/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security;

import com.sun.org.apache.xml.internal.security.algorithms.JCEMapper;
import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithm;
import com.sun.org.apache.xml.internal.security.c14n.Canonicalizer;
import com.sun.org.apache.xml.internal.security.keys.KeyInfo;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolver;
import com.sun.org.apache.xml.internal.security.transforms.Transform;
import com.sun.org.apache.xml.internal.security.utils.ElementProxy;
import com.sun.org.apache.xml.internal.security.utils.I18n;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Init {
    static Logger log = Logger.getLogger(Init.class.getName());
    private static boolean _alreadyInitialized = false;
    public static final String CONF_NS = "http://www.xmlsecurity.org/NS/#configuration";

    public static final boolean isInitialized() {
        return _alreadyInitialized;
    }

    public static synchronized void init() {
        if (_alreadyInitialized) {
            return;
        }
        long XX_configure_i18n_end = 0L;
        long XX_configure_reg_c14n_start = 0L;
        long XX_configure_reg_c14n_end = 0L;
        long XX_configure_reg_jcemapper_end = 0L;
        long XX_configure_reg_keyInfo_start = 0L;
        long XX_configure_reg_keyResolver_end = 0L;
        long XX_configure_reg_prefixes_start = 0L;
        long XX_configure_reg_resourceresolver_start = 0L;
        long XX_configure_reg_sigalgos_end = 0L;
        long XX_configure_reg_transforms_end = 0L;
        long XX_configure_reg_keyInfo_end = 0L;
        long XX_configure_reg_keyResolver_start = 0L;
        _alreadyInitialized = true;
        try {
            long XX_init_start = System.currentTimeMillis();
            long XX_prng_start = System.currentTimeMillis();
            long XX_prng_end = System.currentTimeMillis();
            long XX_parsing_start = System.currentTimeMillis();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputStream is = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return this.getClass().getResourceAsStream("resource/config.xml");
                }
            });
            Document doc = db.parse(is);
            long XX_parsing_end = System.currentTimeMillis();
            long XX_configure_i18n_start = 0L;
            XX_configure_reg_keyInfo_start = System.currentTimeMillis();
            try {
                KeyInfo.init();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            XX_configure_reg_keyInfo_end = System.currentTimeMillis();
            long XX_configure_reg_transforms_start = 0L;
            long XX_configure_reg_jcemapper_start = 0L;
            long XX_configure_reg_sigalgos_start = 0L;
            long XX_configure_reg_resourceresolver_end = 0L;
            long XX_configure_reg_prefixes_end = 0L;
            for (Node config = doc.getFirstChild(); config != null && !"Configuration".equals(config.getLocalName()); config = config.getNextSibling()) {
            }
            for (Node el = config.getFirstChild(); el != null; el = el.getNextSibling()) {
                String Description;
                String JAVACLASS;
                Element[] resolverElem;
                Object[] exArgs;
                String JAVACLASS2;
                String URI2;
                int i;
                if (!(el instanceof Element)) continue;
                String tag = el.getLocalName();
                if (tag.equals("CanonicalizationMethods")) {
                    XX_configure_reg_c14n_start = System.currentTimeMillis();
                    Canonicalizer.init();
                    Element[] list = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "CanonicalizationMethod");
                    for (i = 0; i < list.length; ++i) {
                        URI2 = list[i].getAttributeNS(null, "URI");
                        JAVACLASS2 = list[i].getAttributeNS(null, "JAVACLASS");
                        try {
                            Class.forName(JAVACLASS2);
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "Canonicalizer.register(" + URI2 + ", " + JAVACLASS2 + ")");
                            }
                            Canonicalizer.register(URI2, JAVACLASS2);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            exArgs = new Object[]{URI2, JAVACLASS2};
                            log.log(Level.SEVERE, I18n.translate("algorithm.classDoesNotExist", exArgs));
                        }
                    }
                    XX_configure_reg_c14n_end = System.currentTimeMillis();
                }
                if (tag.equals("TransformAlgorithms")) {
                    XX_configure_reg_transforms_start = System.currentTimeMillis();
                    Transform.init();
                    Element[] tranElem = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "TransformAlgorithm");
                    for (i = 0; i < tranElem.length; ++i) {
                        URI2 = tranElem[i].getAttributeNS(null, "URI");
                        JAVACLASS2 = tranElem[i].getAttributeNS(null, "JAVACLASS");
                        try {
                            Class.forName(JAVACLASS2);
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "Transform.register(" + URI2 + ", " + JAVACLASS2 + ")");
                            }
                            Transform.register(URI2, JAVACLASS2);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            exArgs = new Object[]{URI2, JAVACLASS2};
                            log.log(Level.SEVERE, I18n.translate("algorithm.classDoesNotExist", exArgs));
                            continue;
                        }
                        catch (NoClassDefFoundError ex) {
                            log.log(Level.WARNING, "Not able to found dependecies for algorithm, I'm keep working.");
                        }
                    }
                    XX_configure_reg_transforms_end = System.currentTimeMillis();
                }
                if ("JCEAlgorithmMappings".equals(tag)) {
                    XX_configure_reg_jcemapper_start = System.currentTimeMillis();
                    JCEMapper.init((Element)el);
                    XX_configure_reg_jcemapper_end = System.currentTimeMillis();
                }
                if (tag.equals("SignatureAlgorithms")) {
                    XX_configure_reg_sigalgos_start = System.currentTimeMillis();
                    SignatureAlgorithm.providerInit();
                    Element[] sigElems = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "SignatureAlgorithm");
                    for (i = 0; i < sigElems.length; ++i) {
                        URI2 = sigElems[i].getAttributeNS(null, "URI");
                        JAVACLASS2 = sigElems[i].getAttributeNS(null, "JAVACLASS");
                        try {
                            Class.forName(JAVACLASS2);
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "SignatureAlgorithm.register(" + URI2 + ", " + JAVACLASS2 + ")");
                            }
                            SignatureAlgorithm.register(URI2, JAVACLASS2);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            exArgs = new Object[]{URI2, JAVACLASS2};
                            log.log(Level.SEVERE, I18n.translate("algorithm.classDoesNotExist", exArgs));
                        }
                    }
                    XX_configure_reg_sigalgos_end = System.currentTimeMillis();
                }
                if (tag.equals("ResourceResolvers")) {
                    XX_configure_reg_resourceresolver_start = System.currentTimeMillis();
                    ResourceResolver.init();
                    resolverElem = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "Resolver");
                    for (i = 0; i < resolverElem.length; ++i) {
                        JAVACLASS = resolverElem[i].getAttributeNS(null, "JAVACLASS");
                        Description = resolverElem[i].getAttributeNS(null, "DESCRIPTION");
                        if (Description != null && Description.length() > 0) {
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "Register Resolver: " + JAVACLASS + ": " + Description);
                            }
                        } else if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "Register Resolver: " + JAVACLASS + ": For unknown purposes");
                        }
                        try {
                            ResourceResolver.register(JAVACLASS);
                        }
                        catch (Throwable e) {
                            log.log(Level.WARNING, "Cannot register:" + JAVACLASS + " perhaps some needed jars are not installed", e);
                        }
                        XX_configure_reg_resourceresolver_end = System.currentTimeMillis();
                    }
                }
                if (tag.equals("KeyResolver")) {
                    XX_configure_reg_keyResolver_start = System.currentTimeMillis();
                    KeyResolver.init();
                    resolverElem = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "Resolver");
                    for (i = 0; i < resolverElem.length; ++i) {
                        JAVACLASS = resolverElem[i].getAttributeNS(null, "JAVACLASS");
                        Description = resolverElem[i].getAttributeNS(null, "DESCRIPTION");
                        if (Description != null && Description.length() > 0) {
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "Register Resolver: " + JAVACLASS + ": " + Description);
                            }
                        } else if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "Register Resolver: " + JAVACLASS + ": For unknown purposes");
                        }
                        KeyResolver.register(JAVACLASS);
                    }
                    XX_configure_reg_keyResolver_end = System.currentTimeMillis();
                }
                if (!tag.equals("PrefixMappings")) continue;
                XX_configure_reg_prefixes_start = System.currentTimeMillis();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Now I try to bind prefixes:");
                }
                Element[] nl = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "PrefixMapping");
                for (i = 0; i < nl.length; ++i) {
                    String namespace = nl[i].getAttributeNS(null, "namespace");
                    String prefix = nl[i].getAttributeNS(null, "prefix");
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Now I try to bind " + prefix + " to " + namespace);
                    }
                    ElementProxy.setDefaultPrefix(namespace, prefix);
                }
                XX_configure_reg_prefixes_end = System.currentTimeMillis();
            }
            long XX_init_end = System.currentTimeMillis();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "XX_init                             " + (int)(XX_init_end - XX_init_start) + " ms");
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "  XX_prng                           " + (int)(XX_prng_end - XX_prng_start) + " ms");
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "  XX_parsing                        " + (int)(XX_parsing_end - XX_parsing_start) + " ms");
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "  XX_configure_i18n                 " + (int)(XX_configure_i18n_end - XX_configure_i18n_start) + " ms");
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "  XX_configure_reg_c14n             " + (int)(XX_configure_reg_c14n_end - XX_configure_reg_c14n_start) + " ms");
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "  XX_configure_reg_jcemapper        " + (int)(XX_configure_reg_jcemapper_end - XX_configure_reg_jcemapper_start) + " ms");
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "  XX_configure_reg_keyInfo          " + (int)(XX_configure_reg_keyInfo_end - XX_configure_reg_keyInfo_start) + " ms");
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "  XX_configure_reg_keyResolver      " + (int)(XX_configure_reg_keyResolver_end - XX_configure_reg_keyResolver_start) + " ms");
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "  XX_configure_reg_prefixes         " + (int)(XX_configure_reg_prefixes_end - XX_configure_reg_prefixes_start) + " ms");
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "  XX_configure_reg_resourceresolver " + (int)(XX_configure_reg_resourceresolver_end - XX_configure_reg_resourceresolver_start) + " ms");
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "  XX_configure_reg_sigalgos         " + (int)(XX_configure_reg_sigalgos_end - XX_configure_reg_sigalgos_start) + " ms");
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "  XX_configure_reg_transforms       " + (int)(XX_configure_reg_transforms_end - XX_configure_reg_transforms_start) + " ms");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Bad: ", e);
            e.printStackTrace();
        }
    }
}

