/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.ModelChannelMixer;
import com.sun.media.sound.SoftAudioBuffer;
import com.sun.media.sound.SoftAudioProcessor;
import com.sun.media.sound.SoftChannel;
import com.sun.media.sound.SoftChorus;
import com.sun.media.sound.SoftControl;
import com.sun.media.sound.SoftLimiter;
import com.sun.media.sound.SoftReverb;
import com.sun.media.sound.SoftSynthesizer;
import com.sun.media.sound.SoftTuning;
import com.sun.media.sound.SoftVoice;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Patch;
import javax.sound.midi.ShortMessage;
import javax.sound.sampled.AudioInputStream;

public class SoftMainMixer {
    public static final int CHANNEL_LEFT = 0;
    public static final int CHANNEL_RIGHT = 1;
    public static final int CHANNEL_MONO = 2;
    public static final int CHANNEL_EFFECT1 = 3;
    public static final int CHANNEL_EFFECT2 = 4;
    public static final int CHANNEL_EFFECT3 = 5;
    public static final int CHANNEL_EFFECT4 = 6;
    public static final int CHANNEL_LEFT_DRY = 10;
    public static final int CHANNEL_RIGHT_DRY = 11;
    public static final int CHANNEL_SCRATCH1 = 12;
    public static final int CHANNEL_SCRATCH2 = 13;
    public static final int CHANNEL_CHANNELMIXER_LEFT = 14;
    public static final int CHANNEL_CHANNELMIXER_RIGHT = 15;
    public static final int CHANNEL_CHANNELMIXER_MONO = 16;
    protected boolean active_sensing_on = false;
    private long msec_last_activity = -1L;
    private boolean pusher_silent = false;
    private int pusher_silent_count = 0;
    private long msec_pos = 0L;
    protected boolean readfully = true;
    private Object control_mutex;
    private SoftSynthesizer synth;
    private int nrofchannels = 2;
    private SoftVoice[] voicestatus = null;
    private SoftAudioBuffer[] buffers;
    private SoftReverb reverb;
    private SoftAudioProcessor chorus;
    private SoftAudioProcessor agc;
    private long msec_buffer_len = 0L;
    protected TreeMap<Long, Object> midimessages = new TreeMap();
    double last_volume_left = 1.0;
    double last_volume_right = 1.0;
    private double[] co_master_balance = new double[1];
    private double[] co_master_volume = new double[1];
    private double[] co_master_coarse_tuning = new double[1];
    private double[] co_master_fine_tuning = new double[1];
    private AudioInputStream ais;
    private Set<ModelChannelMixer> registeredMixers = null;
    private Set<ModelChannelMixer> stoppedMixers = null;
    private ModelChannelMixer[] cur_registeredMixers = null;
    protected SoftControl co_master = new SoftControl(){
        double[] balance;
        double[] volume;
        double[] coarse_tuning;
        double[] fine_tuning;
        {
            this.balance = SoftMainMixer.this.co_master_balance;
            this.volume = SoftMainMixer.this.co_master_volume;
            this.coarse_tuning = SoftMainMixer.this.co_master_coarse_tuning;
            this.fine_tuning = SoftMainMixer.this.co_master_fine_tuning;
        }

        public double[] get(int instance, String name) {
            if (name == null) {
                return null;
            }
            if (name.equals("balance")) {
                return this.balance;
            }
            if (name.equals("volume")) {
                return this.volume;
            }
            if (name.equals("coarse_tuning")) {
                return this.coarse_tuning;
            }
            if (name.equals("fine_tuning")) {
                return this.fine_tuning;
            }
            return null;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSystemExclusiveMessage(byte[] data) {
        Object object = this.synth.control_mutex;
        synchronized (object) {
            int i;
            SoftChannel[] channels;
            int channelmask;
            SoftTuning tuning;
            int subid2;
            int subid1;
            int deviceID;
            this.activity();
            if ((data[1] & 0xFF) == 126 && ((deviceID = data[2] & 0xFF) == 127 || deviceID == this.synth.getDeviceID())) {
                subid1 = data[3] & 0xFF;
                block2 : switch (subid1) {
                    case 8: {
                        subid2 = data[4] & 0xFF;
                        switch (subid2) {
                            case 1: {
                                tuning = this.synth.getTuning(new Patch(0, data[5] & 0xFF));
                                tuning.load(data);
                                break;
                            }
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: {
                                tuning = this.synth.getTuning(new Patch(data[5] & 0xFF, data[6] & 0xFF));
                                tuning.load(data);
                                break;
                            }
                            case 8: 
                            case 9: {
                                tuning = new SoftTuning(data);
                                channelmask = (data[5] & 0xFF) * 16384 + (data[6] & 0xFF) * 128 + (data[7] & 0xFF);
                                channels = this.synth.channels;
                                for (i = 0; i < channels.length; ++i) {
                                    if ((channelmask & 1 << i) == 0) continue;
                                    channels[i].tuning = tuning;
                                }
                                break block2;
                            }
                        }
                        break;
                    }
                    case 9: {
                        subid2 = data[4] & 0xFF;
                        switch (subid2) {
                            case 1: {
                                this.synth.setGeneralMidiMode(1);
                                this.reset();
                                break block2;
                            }
                            case 2: {
                                this.synth.setGeneralMidiMode(0);
                                this.reset();
                                break block2;
                            }
                            case 3: {
                                this.synth.setGeneralMidiMode(2);
                                this.reset();
                                break block2;
                            }
                        }
                        break;
                    }
                    case 10: {
                        subid2 = data[4] & 0xFF;
                        switch (subid2) {
                            case 1: {
                                if (this.synth.getGeneralMidiMode() == 0) {
                                    this.synth.setGeneralMidiMode(1);
                                }
                                this.synth.voice_allocation_mode = 1;
                                this.reset();
                                break block2;
                            }
                            case 2: {
                                this.synth.setGeneralMidiMode(0);
                                this.synth.voice_allocation_mode = 0;
                                this.reset();
                                break block2;
                            }
                            case 3: {
                                this.synth.voice_allocation_mode = 0;
                                break block2;
                            }
                            case 4: {
                                this.synth.voice_allocation_mode = 1;
                                break block2;
                            }
                        }
                        break;
                    }
                }
            }
            if ((data[1] & 0xFF) == 127 && ((deviceID = data[2] & 0xFF) == 127 || deviceID == this.synth.getDeviceID())) {
                subid1 = data[3] & 0xFF;
                block23 : switch (subid1) {
                    case 4: {
                        subid2 = data[4] & 0xFF;
                        switch (subid2) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                int val = (data[5] & 0x7F) + (data[6] & 0x7F) * 128;
                                if (subid2 == 1) {
                                    this.setVolume(val);
                                    break block23;
                                }
                                if (subid2 == 2) {
                                    this.setBalance(val);
                                    break block23;
                                }
                                if (subid2 == 3) {
                                    this.setFineTuning(val);
                                    break block23;
                                }
                                if (subid2 != 4) break;
                                this.setCoarseTuning(val);
                                break block23;
                            }
                            case 5: {
                                int ix = 5;
                                int slotPathLen = data[ix++] & 0xFF;
                                int paramWidth = data[ix++] & 0xFF;
                                int valueWidth = data[ix++] & 0xFF;
                                int[] slotPath = new int[slotPathLen];
                                for (int i2 = 0; i2 < slotPathLen; ++i2) {
                                    int msb = data[ix++] & 0xFF;
                                    int lsb = data[ix++] & 0xFF;
                                    slotPath[i2] = msb * 128 + lsb;
                                }
                                int paramCount = (data.length - 1 - ix) / (paramWidth + valueWidth);
                                long[] params = new long[paramCount];
                                long[] values = new long[paramCount];
                                for (int i3 = 0; i3 < paramCount; ++i3) {
                                    int j;
                                    values[i3] = 0L;
                                    for (j = 0; j < paramWidth; ++j) {
                                        params[i3] = params[i3] * 128L + (long)(data[ix++] & 0xFF);
                                    }
                                    for (j = 0; j < valueWidth; ++j) {
                                        values[i3] = values[i3] * 128L + (long)(data[ix++] & 0xFF);
                                    }
                                }
                                this.globalParameterControlChange(slotPath, params, values);
                                break block23;
                            }
                        }
                        break;
                    }
                    case 8: {
                        subid2 = data[4] & 0xFF;
                        switch (subid2) {
                            case 2: {
                                tuning = this.synth.getTuning(new Patch(0, data[5] & 0xFF));
                                tuning.load(data);
                                SoftVoice[] voices = this.synth.getVoices();
                                for (int i4 = 0; i4 < voices.length; ++i4) {
                                    if (!voices[i4].active || voices[i4].tuning != tuning) continue;
                                    voices[i4].updateTuning(tuning);
                                }
                                break block23;
                            }
                            case 7: {
                                tuning = this.synth.getTuning(new Patch(data[5] & 0xFF, data[6] & 0xFF));
                                tuning.load(data);
                                SoftVoice[] voices = this.synth.getVoices();
                                for (int i5 = 0; i5 < voices.length; ++i5) {
                                    if (!voices[i5].active || voices[i5].tuning != tuning) continue;
                                    voices[i5].updateTuning(tuning);
                                }
                                break block23;
                            }
                            case 8: 
                            case 9: {
                                tuning = new SoftTuning(data);
                                channelmask = (data[5] & 0xFF) * 16384 + (data[6] & 0xFF) * 128 + (data[7] & 0xFF);
                                channels = this.synth.channels;
                                for (i = 0; i < channels.length; ++i) {
                                    if ((channelmask & 1 << i) == 0) continue;
                                    channels[i].tuning = tuning;
                                }
                                SoftVoice[] voices = this.synth.getVoices();
                                for (int i6 = 0; i6 < voices.length; ++i6) {
                                    if (!voices[i6].active || (channelmask & 1 << voices[i6].channel) == 0) continue;
                                    voices[i6].updateTuning(tuning);
                                }
                                break block23;
                            }
                        }
                        break;
                    }
                    case 9: {
                        int j;
                        subid2 = data[4] & 0xFF;
                        switch (subid2) {
                            case 1: {
                                int[] destinations = new int[(data.length - 7) / 2];
                                int[] ranges = new int[(data.length - 7) / 2];
                                int ix = 0;
                                for (j = 6; j < data.length - 1; j += 2) {
                                    destinations[ix] = data[j] & 0xFF;
                                    ranges[ix] = data[j + 1] & 0xFF;
                                    ++ix;
                                }
                                int channel = data[5] & 0xFF;
                                SoftChannel softchannel = this.synth.channels[channel];
                                softchannel.mapChannelPressureToDestination(destinations, ranges);
                                break block23;
                            }
                            case 2: {
                                int[] destinations = new int[(data.length - 7) / 2];
                                int[] ranges = new int[(data.length - 7) / 2];
                                int ix = 0;
                                for (j = 6; j < data.length - 1; j += 2) {
                                    destinations[ix] = data[j] & 0xFF;
                                    ranges[ix] = data[j + 1] & 0xFF;
                                    ++ix;
                                }
                                int channel = data[5] & 0xFF;
                                SoftChannel softchannel = this.synth.channels[channel];
                                softchannel.mapPolyPressureToDestination(destinations, ranges);
                                break block23;
                            }
                            case 3: {
                                int[] destinations = new int[(data.length - 7) / 2];
                                int[] ranges = new int[(data.length - 7) / 2];
                                int ix = 0;
                                for (j = 7; j < data.length - 1; j += 2) {
                                    destinations[ix] = data[j] & 0xFF;
                                    ranges[ix] = data[j + 1] & 0xFF;
                                    ++ix;
                                }
                                int channel = data[5] & 0xFF;
                                SoftChannel softchannel = this.synth.channels[channel];
                                int control = data[6] & 0xFF;
                                softchannel.mapControlToDestination(control, destinations, ranges);
                                break block23;
                            }
                        }
                        break;
                    }
                    case 10: {
                        int j;
                        subid2 = data[4] & 0xFF;
                        switch (subid2) {
                            case 1: {
                                int channel = data[5] & 0xFF;
                                int keynumber = data[6] & 0xFF;
                                SoftChannel softchannel = this.synth.channels[channel];
                                for (j = 7; j < data.length - 1; j += 2) {
                                    int controlnumber = data[j] & 0xFF;
                                    int controlvalue = data[j + 1] & 0xFF;
                                    softchannel.controlChangePerNote(keynumber, controlnumber, controlvalue);
                                }
                                break block23;
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    private void processMessages(long timeStamp) {
        Iterator<Map.Entry<Long, Object>> iter = this.midimessages.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, Object> entry = iter.next();
            if (entry.getKey() > timeStamp + 100L) {
                return;
            }
            this.processMessage(entry.getValue());
            iter.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAudioBuffers() {
        int bufferlen;
        ModelChannelMixer[] act_registeredMixers;
        double volume_right;
        double volume_left;
        for (int i = 0; i < this.buffers.length; ++i) {
            this.buffers[i].clear();
        }
        Object object = this.control_mutex;
        synchronized (object) {
            double volume;
            this.processMessages(this.msec_pos);
            if (this.active_sensing_on && this.msec_pos - this.msec_last_activity > 1000000L) {
                this.active_sensing_on = false;
                for (SoftChannel c : this.synth.channels) {
                    c.allSoundOff();
                }
            }
            for (int i = 0; i < this.voicestatus.length; ++i) {
                if (!this.voicestatus[i].active) continue;
                this.voicestatus[i].processControlLogic();
            }
            this.msec_pos += this.msec_buffer_len;
            volume_left = volume = this.co_master_volume[0];
            volume_right = volume;
            double balance = this.co_master_balance[0];
            if (balance > 0.5) {
                volume_left *= (1.0 - balance) * 2.0;
            } else {
                volume_right *= balance * 2.0;
            }
            this.chorus.processControlLogic();
            this.reverb.processControlLogic();
            this.agc.processControlLogic();
            if (this.cur_registeredMixers == null && this.registeredMixers != null) {
                this.cur_registeredMixers = new ModelChannelMixer[this.registeredMixers.size()];
                this.registeredMixers.toArray(this.cur_registeredMixers);
            }
            if ((act_registeredMixers = this.cur_registeredMixers) != null && act_registeredMixers.length == 0) {
                act_registeredMixers = null;
            }
        }
        if (act_registeredMixers != null) {
            SoftAudioBuffer leftbak = this.buffers[0];
            SoftAudioBuffer rightbak = this.buffers[1];
            SoftAudioBuffer monobak = this.buffers[2];
            this.buffers[0] = this.buffers[14];
            this.buffers[1] = this.buffers[15];
            this.buffers[2] = this.buffers[16];
            int bufferlen2 = this.buffers[0].getSize();
            float[][] cbuffer = new float[this.nrofchannels][];
            cbuffer[0] = this.buffers[0].array();
            if (this.nrofchannels != 1) {
                cbuffer[1] = this.buffers[1].array();
            }
            float[][] obuffer = new float[this.nrofchannels][];
            obuffer[0] = leftbak.array();
            if (this.nrofchannels != 1) {
                obuffer[1] = rightbak.array();
            }
            for (ModelChannelMixer cmixer : act_registeredMixers) {
                int i3;
                for (int i2 = 0; i2 < cbuffer.length; ++i2) {
                    Arrays.fill(cbuffer[i2], 0.0f);
                }
                this.buffers[2].clear();
                boolean hasactivevoices = false;
                for (i3 = 0; i3 < this.voicestatus.length; ++i3) {
                    if (!this.voicestatus[i3].active || this.voicestatus[i3].channelmixer != cmixer) continue;
                    this.voicestatus[i3].processAudioLogic(this.buffers);
                    hasactivevoices = true;
                }
                if (!cmixer.process(cbuffer, 0, bufferlen2)) {
                    Object i3 = this.control_mutex;
                    synchronized (i3) {
                        this.registeredMixers.remove(cmixer);
                        this.cur_registeredMixers = null;
                    }
                }
                if (!this.buffers[2].isSilent()) {
                    float[] mono = this.buffers[2].array();
                    float[] left = this.buffers[0].array();
                    if (this.nrofchannels != 1) {
                        float[] right = this.buffers[1].array();
                        int i4 = 0;
                        while (i4 < bufferlen2) {
                            float v = mono[i4];
                            int n = i4;
                            left[n] = left[n] + v;
                            int n2 = i4++;
                            right[n2] = right[n2] + v;
                        }
                    } else {
                        for (int i5 = 0; i5 < bufferlen2; ++i5) {
                            int n = i5;
                            left[n] = left[n] + mono[i5];
                        }
                    }
                }
                for (i3 = 0; i3 < cbuffer.length; ++i3) {
                    float[] cbuff = cbuffer[i3];
                    float[] obuff = obuffer[i3];
                    for (int j = 0; j < bufferlen2; ++j) {
                        int n = j;
                        obuff[n] = obuff[n] + cbuff[j];
                    }
                }
                if (hasactivevoices) continue;
                Object object2 = this.control_mutex;
                synchronized (object2) {
                    if (this.stoppedMixers != null && this.stoppedMixers.contains(cmixer)) {
                        this.stoppedMixers.remove(cmixer);
                        cmixer.stop();
                    }
                }
            }
            this.buffers[0] = leftbak;
            this.buffers[1] = rightbak;
            this.buffers[2] = monobak;
        }
        for (int i = 0; i < this.voicestatus.length; ++i) {
            if (!this.voicestatus[i].active || this.voicestatus[i].channelmixer != null) continue;
            this.voicestatus[i].processAudioLogic(this.buffers);
        }
        if (!this.buffers[2].isSilent()) {
            float[] mono = this.buffers[2].array();
            float[] left = this.buffers[0].array();
            bufferlen = this.buffers[0].getSize();
            if (this.nrofchannels != 1) {
                float[] right = this.buffers[1].array();
                int i = 0;
                while (i < bufferlen) {
                    float v = mono[i];
                    int n = i;
                    left[n] = left[n] + v;
                    int n3 = i++;
                    right[n3] = right[n3] + v;
                }
            } else {
                for (int i = 0; i < bufferlen; ++i) {
                    int n = i;
                    left[n] = left[n] + mono[i];
                }
            }
        }
        if (this.synth.chorus_on) {
            this.chorus.processAudio();
        }
        if (this.synth.reverb_on) {
            this.reverb.processAudio();
        }
        if (this.nrofchannels == 1) {
            volume_left = (volume_left + volume_right) / 2.0;
        }
        if (this.last_volume_left != volume_left || this.last_volume_right != volume_right) {
            float[] left = this.buffers[0].array();
            float[] right = this.buffers[1].array();
            bufferlen = this.buffers[0].getSize();
            float amp = (float)(this.last_volume_left * this.last_volume_left);
            float amp_delta = (float)((volume_left * volume_left - (double)amp) / (double)bufferlen);
            int i = 0;
            while (i < bufferlen) {
                int n = i++;
                left[n] = left[n] * (amp += amp_delta);
            }
            if (this.nrofchannels != 1) {
                amp = (float)(this.last_volume_right * this.last_volume_right);
                amp_delta = (float)((volume_right * volume_right - (double)amp) / (double)bufferlen);
                i = 0;
                while (i < bufferlen) {
                    amp += amp_delta;
                    int n = i++;
                    right[n] = (float)((double)right[n] * volume_right);
                }
            }
            this.last_volume_left = volume_left;
            this.last_volume_right = volume_right;
        } else if (volume_left != 1.0 || volume_right != 1.0) {
            float[] left = this.buffers[0].array();
            float[] right = this.buffers[1].array();
            bufferlen = this.buffers[0].getSize();
            float amp = (float)(volume_left * volume_left);
            int i = 0;
            while (i < bufferlen) {
                int n = i++;
                left[n] = left[n] * amp;
            }
            if (this.nrofchannels != 1) {
                amp = (float)(volume_right * volume_right);
                i = 0;
                while (i < bufferlen) {
                    int n = i++;
                    right[n] = right[n] * amp;
                }
            }
        }
        if (this.buffers[0].isSilent() && this.buffers[1].isSilent()) {
            ++this.pusher_silent_count;
            if (this.pusher_silent_count > 5) {
                this.pusher_silent_count = 0;
                Object object3 = this.control_mutex;
                synchronized (object3) {
                    this.pusher_silent = true;
                    if (this.synth.weakstream != null) {
                        this.synth.weakstream.setInputStream(null);
                    }
                }
            }
        } else {
            this.pusher_silent_count = 0;
        }
        if (this.synth.agc_on) {
            this.agc.processAudio();
        }
    }

    public void activity() {
        this.msec_last_activity = this.msec_pos;
        if (this.pusher_silent) {
            this.pusher_silent = false;
            if (this.synth.weakstream != null) {
                this.synth.weakstream.setInputStream(this.ais);
            }
        }
    }

    public void stopMixer(ModelChannelMixer mixer) {
        if (this.stoppedMixers == null) {
            this.stoppedMixers = new HashSet<ModelChannelMixer>();
        }
        this.stoppedMixers.add(mixer);
    }

    public void registerMixer(ModelChannelMixer mixer) {
        if (this.registeredMixers == null) {
            this.registeredMixers = new HashSet<ModelChannelMixer>();
        }
        this.registeredMixers.add(mixer);
        this.cur_registeredMixers = null;
    }

    public SoftMainMixer(SoftSynthesizer synth2) {
        this.synth = synth2;
        this.msec_pos = 0L;
        this.co_master_balance[0] = 0.5;
        this.co_master_volume[0] = 1.0;
        this.co_master_coarse_tuning[0] = 0.5;
        this.co_master_fine_tuning[0] = 0.5;
        this.msec_buffer_len = (long)(1000000.0 / (double)synth2.getControlRate());
        this.nrofchannels = synth2.getFormat().getChannels();
        int buffersize = (int)(synth2.getFormat().getSampleRate() / synth2.getControlRate());
        this.control_mutex = synth2.control_mutex;
        this.buffers = new SoftAudioBuffer[17];
        for (int i = 0; i < this.buffers.length; ++i) {
            this.buffers[i] = new SoftAudioBuffer(buffersize, synth2.getFormat());
        }
        this.voicestatus = synth2.getVoices();
        this.reverb = new SoftReverb();
        this.chorus = new SoftChorus();
        this.agc = new SoftLimiter();
        float samplerate = synth2.getFormat().getSampleRate();
        float controlrate = synth2.getControlRate();
        this.reverb.init(samplerate, controlrate);
        this.chorus.init(samplerate, controlrate);
        this.agc.init(samplerate, controlrate);
        this.reverb.setLightMode(synth2.reverb_light);
        this.reverb.setMixMode(true);
        this.chorus.setMixMode(true);
        this.agc.setMixMode(false);
        this.chorus.setInput(0, this.buffers[4]);
        this.chorus.setOutput(0, this.buffers[0]);
        if (this.nrofchannels != 1) {
            this.chorus.setOutput(1, this.buffers[1]);
        }
        this.chorus.setOutput(2, this.buffers[3]);
        this.reverb.setInput(0, this.buffers[3]);
        this.reverb.setOutput(0, this.buffers[0]);
        if (this.nrofchannels != 1) {
            this.reverb.setOutput(1, this.buffers[1]);
        }
        this.agc.setInput(0, this.buffers[0]);
        if (this.nrofchannels != 1) {
            this.agc.setInput(1, this.buffers[1]);
        }
        this.agc.setOutput(0, this.buffers[0]);
        if (this.nrofchannels != 1) {
            this.agc.setOutput(1, this.buffers[1]);
        }
        InputStream in = new InputStream(){
            private SoftAudioBuffer[] buffers;
            private int nrofchannels;
            private int buffersize;
            private byte[] bbuffer;
            private int bbuffer_pos;
            private byte[] single;
            {
                this.buffers = SoftMainMixer.this.buffers;
                this.nrofchannels = SoftMainMixer.this.synth.getFormat().getChannels();
                this.buffersize = this.buffers[0].getSize();
                this.bbuffer = new byte[this.buffersize * (SoftMainMixer.this.synth.getFormat().getSampleSizeInBits() / 8) * this.nrofchannels];
                this.bbuffer_pos = 0;
                this.single = new byte[1];
            }

            public void fillBuffer() {
                SoftMainMixer.this.processAudioBuffers();
                for (int i = 0; i < this.nrofchannels; ++i) {
                    this.buffers[i].get(this.bbuffer, i);
                }
                this.bbuffer_pos = 0;
            }

            public int read(byte[] b, int off, int len) {
                int bbuffer_len = this.bbuffer.length;
                int offlen = off + len;
                int orgoff = off;
                byte[] bbuffer = this.bbuffer;
                while (off < offlen) {
                    if (this.available() == 0) {
                        this.fillBuffer();
                        continue;
                    }
                    int bbuffer_pos = this.bbuffer_pos;
                    while (off < offlen && bbuffer_pos < bbuffer_len) {
                        b[off++] = bbuffer[bbuffer_pos++];
                    }
                    this.bbuffer_pos = bbuffer_pos;
                    if (SoftMainMixer.this.readfully) continue;
                    return off - orgoff;
                }
                return len;
            }

            public int read() throws IOException {
                int ret = this.read(this.single);
                if (ret == -1) {
                    return -1;
                }
                return this.single[0] & 0xFF;
            }

            public int available() {
                return this.bbuffer.length - this.bbuffer_pos;
            }

            public void close() {
                SoftMainMixer.this.synth.close();
            }
        };
        this.ais = new AudioInputStream(in, synth2.getFormat(), -1L);
    }

    public AudioInputStream getInputStream() {
        return this.ais;
    }

    public void reset() {
        SoftChannel[] channels = this.synth.channels;
        for (int i = 0; i < channels.length; ++i) {
            channels[i].allSoundOff();
            channels[i].resetAllControllers(true);
            if (this.synth.getGeneralMidiMode() == 2) {
                if (i == 9) {
                    channels[i].programChange(0, 15360);
                    continue;
                }
                channels[i].programChange(0, 15488);
                continue;
            }
            channels[i].programChange(0, 0);
        }
        this.setVolume(16383);
        this.setBalance(8192);
        this.setCoarseTuning(8192);
        this.setFineTuning(8192);
        this.globalParameterControlChange(new int[]{129}, new long[]{0L}, new long[]{4L});
        this.globalParameterControlChange(new int[]{130}, new long[]{0L}, new long[]{2L});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVolume(int value) {
        Object object = this.control_mutex;
        synchronized (object) {
            this.co_master_volume[0] = (double)value / 16384.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBalance(int value) {
        Object object = this.control_mutex;
        synchronized (object) {
            this.co_master_balance[0] = (double)value / 16384.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFineTuning(int value) {
        Object object = this.control_mutex;
        synchronized (object) {
            this.co_master_fine_tuning[0] = (double)value / 16384.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCoarseTuning(int value) {
        Object object = this.control_mutex;
        synchronized (object) {
            this.co_master_coarse_tuning[0] = (double)value / 16384.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVolume() {
        Object object = this.control_mutex;
        synchronized (object) {
            return (int)(this.co_master_volume[0] * 16384.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBalance() {
        Object object = this.control_mutex;
        synchronized (object) {
            return (int)(this.co_master_balance[0] * 16384.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFineTuning() {
        Object object = this.control_mutex;
        synchronized (object) {
            return (int)(this.co_master_fine_tuning[0] * 16384.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCoarseTuning() {
        Object object = this.control_mutex;
        synchronized (object) {
            return (int)(this.co_master_coarse_tuning[0] * 16384.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void globalParameterControlChange(int[] slothpath, long[] params, long[] paramsvalue) {
        if (slothpath.length == 0) {
            return;
        }
        Object object = this.control_mutex;
        synchronized (object) {
            int i;
            if (slothpath[0] == 129) {
                for (i = 0; i < paramsvalue.length; ++i) {
                    this.reverb.globalParameterControlChange(slothpath, params[i], paramsvalue[i]);
                }
            }
            if (slothpath[0] == 130) {
                for (i = 0; i < paramsvalue.length; ++i) {
                    this.chorus.globalParameterControlChange(slothpath, params[i], paramsvalue[i]);
                }
            }
        }
    }

    public void processMessage(Object object) {
        if (object instanceof byte[]) {
            this.processMessage((byte[])object);
        }
        if (object instanceof MidiMessage) {
            this.processMessage((MidiMessage)object);
        }
    }

    public void processMessage(MidiMessage message) {
        if (message instanceof ShortMessage) {
            ShortMessage sms = (ShortMessage)message;
            this.processMessage(sms.getChannel(), sms.getCommand(), sms.getData1(), sms.getData2());
            return;
        }
        this.processMessage(message.getMessage());
    }

    public void processMessage(byte[] data) {
        int status = 0;
        if (data.length > 0) {
            status = data[0] & 0xFF;
        }
        if (status == 240) {
            this.processSystemExclusiveMessage(data);
            return;
        }
        int cmd = status & 0xF0;
        int ch = status & 0xF;
        int data1 = data.length > 1 ? data[1] & 0xFF : 0;
        int data2 = data.length > 2 ? data[2] & 0xFF : 0;
        this.processMessage(ch, cmd, data1, data2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(int ch, int cmd, int data1, int data2) {
        Object object = this.synth.control_mutex;
        synchronized (object) {
            this.activity();
        }
        if (cmd == 240) {
            int status = cmd | ch;
            switch (status) {
                case 254: {
                    Object object2 = this.synth.control_mutex;
                    synchronized (object2) {
                        this.active_sensing_on = true;
                        break;
                    }
                }
            }
            return;
        }
        SoftChannel[] channels = this.synth.channels;
        if (ch >= channels.length) {
            return;
        }
        SoftChannel softchannel = channels[ch];
        switch (cmd) {
            case 144: {
                softchannel.noteOn(data1, data2);
                break;
            }
            case 128: {
                softchannel.noteOff(data1, data2);
                break;
            }
            case 160: {
                softchannel.setPolyPressure(data1, data2);
                break;
            }
            case 176: {
                softchannel.controlChange(data1, data2);
                break;
            }
            case 192: {
                softchannel.programChange(data1);
                break;
            }
            case 208: {
                softchannel.setChannelPressure(data1);
                break;
            }
            case 224: {
                softchannel.setPitchBend(data1 + data2 * 128);
                break;
            }
        }
    }

    public long getMicrosecondPosition() {
        return this.msec_pos;
    }

    public void close() {
    }
}

