/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import javax.sound.midi.MidiChannel;

public class SoftChannelProxy
implements MidiChannel {
    private MidiChannel channel = null;

    public MidiChannel getChannel() {
        return this.channel;
    }

    public void setChannel(MidiChannel channel) {
        this.channel = channel;
    }

    public void allNotesOff() {
        if (this.channel == null) {
            return;
        }
        this.channel.allNotesOff();
    }

    public void allSoundOff() {
        if (this.channel == null) {
            return;
        }
        this.channel.allSoundOff();
    }

    public void controlChange(int controller, int value) {
        if (this.channel == null) {
            return;
        }
        this.channel.controlChange(controller, value);
    }

    public int getChannelPressure() {
        if (this.channel == null) {
            return 0;
        }
        return this.channel.getChannelPressure();
    }

    public int getController(int controller) {
        if (this.channel == null) {
            return 0;
        }
        return this.channel.getController(controller);
    }

    public boolean getMono() {
        if (this.channel == null) {
            return false;
        }
        return this.channel.getMono();
    }

    public boolean getMute() {
        if (this.channel == null) {
            return false;
        }
        return this.channel.getMute();
    }

    public boolean getOmni() {
        if (this.channel == null) {
            return false;
        }
        return this.channel.getOmni();
    }

    public int getPitchBend() {
        if (this.channel == null) {
            return 8192;
        }
        return this.channel.getPitchBend();
    }

    public int getPolyPressure(int noteNumber) {
        if (this.channel == null) {
            return 0;
        }
        return this.channel.getPolyPressure(noteNumber);
    }

    public int getProgram() {
        if (this.channel == null) {
            return 0;
        }
        return this.channel.getProgram();
    }

    public boolean getSolo() {
        if (this.channel == null) {
            return false;
        }
        return this.channel.getSolo();
    }

    public boolean localControl(boolean on) {
        if (this.channel == null) {
            return false;
        }
        return this.channel.localControl(on);
    }

    public void noteOff(int noteNumber) {
        if (this.channel == null) {
            return;
        }
        this.channel.noteOff(noteNumber);
    }

    public void noteOff(int noteNumber, int velocity) {
        if (this.channel == null) {
            return;
        }
        this.channel.noteOff(noteNumber, velocity);
    }

    public void noteOn(int noteNumber, int velocity) {
        if (this.channel == null) {
            return;
        }
        this.channel.noteOn(noteNumber, velocity);
    }

    public void programChange(int program) {
        if (this.channel == null) {
            return;
        }
        this.channel.programChange(program);
    }

    public void programChange(int bank, int program) {
        if (this.channel == null) {
            return;
        }
        this.channel.programChange(bank, program);
    }

    public void resetAllControllers() {
        if (this.channel == null) {
            return;
        }
        this.channel.resetAllControllers();
    }

    public void setChannelPressure(int pressure) {
        if (this.channel == null) {
            return;
        }
        this.channel.setChannelPressure(pressure);
    }

    public void setMono(boolean on) {
        if (this.channel == null) {
            return;
        }
        this.channel.setMono(on);
    }

    public void setMute(boolean mute) {
        if (this.channel == null) {
            return;
        }
        this.channel.setMute(mute);
    }

    public void setOmni(boolean on) {
        if (this.channel == null) {
            return;
        }
        this.channel.setOmni(on);
    }

    public void setPitchBend(int bend) {
        if (this.channel == null) {
            return;
        }
        this.channel.setPitchBend(bend);
    }

    public void setPolyPressure(int noteNumber, int pressure) {
        if (this.channel == null) {
            return;
        }
        this.channel.setPolyPressure(noteNumber, pressure);
    }

    public void setSolo(boolean soloState) {
        if (this.channel == null) {
            return;
        }
        this.channel.setSolo(soloState);
    }
}

