/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.agent.SnmpGenericMetaServer;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import com.sun.jmx.snmp.agent.SnmpMibTable;
import java.util.Enumeration;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class SnmpGenericObjectServer {
    protected final MBeanServer server;

    public SnmpGenericObjectServer(MBeanServer server) {
        this.server = server;
    }

    public void get(SnmpGenericMetaServer meta, ObjectName name, SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        int size = req.getSize();
        Object data = req.getUserData();
        String[] nameList = new String[size];
        SnmpVarBind[] varList = new SnmpVarBind[size];
        long[] idList = new long[size];
        int i = 0;
        Enumeration e = req.getElements();
        while (e.hasMoreElements()) {
            SnmpVarBind var = (SnmpVarBind)e.nextElement();
            try {
                long id = var.oid.getOidArc(depth);
                nameList[i] = meta.getAttributeName(id);
                varList[i] = var;
                idList[i] = id;
                meta.checkGetAccess(id, data);
                ++i;
            }
            catch (SnmpStatusException x) {
                req.registerGetException(var, x);
            }
        }
        AttributeList result = null;
        int errorCode = 224;
        try {
            result = this.server.getAttributes(name, nameList);
        }
        catch (InstanceNotFoundException f) {
            result = new AttributeList();
        }
        catch (ReflectionException r) {
            result = new AttributeList();
        }
        catch (Exception x) {
            result = new AttributeList();
        }
        Iterator it = result.iterator();
        for (int j = 0; j < i; ++j) {
            if (!it.hasNext()) {
                SnmpStatusException x = new SnmpStatusException(errorCode);
                req.registerGetException(varList[j], x);
                continue;
            }
            Attribute att = (Attribute)it.next();
            while (j < i && !nameList[j].equals(att.getName())) {
                SnmpStatusException x = new SnmpStatusException(errorCode);
                req.registerGetException(varList[j], x);
                ++j;
            }
            if (j == i) break;
            try {
                varList[j].value = meta.buildSnmpValue(idList[j], att.getValue());
                continue;
            }
            catch (SnmpStatusException x) {
                req.registerGetException(varList[j], x);
            }
        }
    }

    public SnmpValue get(SnmpGenericMetaServer meta, ObjectName name, long id, Object data) throws SnmpStatusException {
        String attname = meta.getAttributeName(id);
        Object result = null;
        try {
            result = this.server.getAttribute(name, attname);
        }
        catch (MBeanException m) {
            Exception t = m.getTargetException();
            if (t instanceof SnmpStatusException) {
                throw (SnmpStatusException)t;
            }
            throw new SnmpStatusException(224);
        }
        catch (Exception e) {
            throw new SnmpStatusException(224);
        }
        return meta.buildSnmpValue(id, result);
    }

    public void set(SnmpGenericMetaServer meta, ObjectName name, SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        int size = req.getSize();
        AttributeList attList = new AttributeList(size);
        String[] nameList = new String[size];
        SnmpVarBind[] varList = new SnmpVarBind[size];
        long[] idList = new long[size];
        int i = 0;
        Enumeration e = req.getElements();
        while (e.hasMoreElements()) {
            SnmpVarBind var = (SnmpVarBind)e.nextElement();
            try {
                long id = var.oid.getOidArc(depth);
                String attname = meta.getAttributeName(id);
                Object attvalue = meta.buildAttributeValue(id, var.value);
                Attribute att = new Attribute(attname, attvalue);
                attList.add(att);
                nameList[i] = attname;
                varList[i] = var;
                idList[i] = id;
                ++i;
            }
            catch (SnmpStatusException x) {
                req.registerSetException(var, x);
            }
        }
        AttributeList result = null;
        int errorCode = 6;
        try {
            result = this.server.setAttributes(name, attList);
        }
        catch (InstanceNotFoundException f) {
            result = new AttributeList();
            errorCode = 60;
        }
        catch (ReflectionException r) {
            errorCode = 60;
            result = new AttributeList();
        }
        catch (Exception x) {
            result = new AttributeList();
        }
        Iterator it = result.iterator();
        for (int j = 0; j < i; ++j) {
            if (!it.hasNext()) {
                SnmpStatusException x = new SnmpStatusException(errorCode);
                req.registerSetException(varList[j], x);
                continue;
            }
            Attribute att = (Attribute)it.next();
            while (j < i && !nameList[j].equals(att.getName())) {
                SnmpStatusException x = new SnmpStatusException(6);
                req.registerSetException(varList[j], x);
                ++j;
            }
            if (j == i) break;
            try {
                varList[j].value = meta.buildSnmpValue(idList[j], att.getValue());
                continue;
            }
            catch (SnmpStatusException x) {
                req.registerSetException(varList[j], x);
            }
        }
    }

    public SnmpValue set(SnmpGenericMetaServer meta, ObjectName name, SnmpValue x, long id, Object data) throws SnmpStatusException {
        String attname = meta.getAttributeName(id);
        Object attvalue = meta.buildAttributeValue(id, x);
        Attribute att = new Attribute(attname, attvalue);
        Object result = null;
        try {
            this.server.setAttribute(name, att);
            result = this.server.getAttribute(name, attname);
        }
        catch (InvalidAttributeValueException iv) {
            throw new SnmpStatusException(50);
        }
        catch (InstanceNotFoundException f) {
            throw new SnmpStatusException(60);
        }
        catch (ReflectionException r) {
            throw new SnmpStatusException(60);
        }
        catch (MBeanException m) {
            Exception t = m.getTargetException();
            if (t instanceof SnmpStatusException) {
                throw (SnmpStatusException)t;
            }
            throw new SnmpStatusException(6);
        }
        catch (Exception e) {
            throw new SnmpStatusException(6);
        }
        return meta.buildSnmpValue(id, result);
    }

    public void check(SnmpGenericMetaServer meta, ObjectName name, SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        Object data = req.getUserData();
        Enumeration e = req.getElements();
        while (e.hasMoreElements()) {
            SnmpVarBind var = (SnmpVarBind)e.nextElement();
            try {
                long id = var.oid.getOidArc(depth);
                this.check(meta, name, var.value, id, data);
            }
            catch (SnmpStatusException x) {
                req.registerCheckException(var, x);
            }
        }
    }

    public void check(SnmpGenericMetaServer meta, ObjectName name, SnmpValue x, long id, Object data) throws SnmpStatusException {
        meta.checkSetAccess(x, id, data);
        try {
            String attname = meta.getAttributeName(id);
            Object attvalue = meta.buildAttributeValue(id, x);
            Object[] params = new Object[1];
            String[] signature = new String[1];
            params[0] = attvalue;
            signature[0] = attvalue.getClass().getName();
            this.server.invoke(name, "check" + attname, params, signature);
        }
        catch (SnmpStatusException e) {
            throw e;
        }
        catch (InstanceNotFoundException i) {
            throw new SnmpStatusException(60);
        }
        catch (ReflectionException r) {
        }
        catch (MBeanException m) {
            Exception t = m.getTargetException();
            if (t instanceof SnmpStatusException) {
                throw (SnmpStatusException)t;
            }
            throw new SnmpStatusException(6);
        }
        catch (Exception e) {
            throw new SnmpStatusException(6);
        }
    }

    public void registerTableEntry(SnmpMibTable meta, SnmpOid rowOid, ObjectName objname, Object entry) throws SnmpStatusException {
        if (objname == null) {
            throw new SnmpStatusException(60);
        }
        try {
            if (entry != null && !this.server.isRegistered(objname)) {
                this.server.registerMBean(entry, objname);
            }
        }
        catch (InstanceAlreadyExistsException e) {
            throw new SnmpStatusException(60);
        }
        catch (MBeanRegistrationException e) {
            throw new SnmpStatusException(20);
        }
        catch (NotCompliantMBeanException e) {
            throw new SnmpStatusException(0);
        }
        catch (RuntimeOperationsException e) {
            throw new SnmpStatusException(0);
        }
        catch (Exception e) {
            throw new SnmpStatusException(0);
        }
    }
}

