/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

public class ThreadContext
implements Cloneable {
    private ThreadContext previous;
    private String key;
    private Object value;
    private static ThreadLocal<ThreadContext> localContext = new ThreadLocal();

    private ThreadContext(ThreadContext previous, String key, Object value) {
        this.previous = previous;
        this.key = key;
        this.value = value;
    }

    public static Object get(String key) throws IllegalArgumentException {
        ThreadContext context = ThreadContext.contextContaining(key);
        if (context == null) {
            return null;
        }
        return context.value;
    }

    public static boolean contains(String key) throws IllegalArgumentException {
        return ThreadContext.contextContaining(key) != null;
    }

    private static ThreadContext contextContaining(String key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        ThreadContext context = ThreadContext.getContext();
        while (context != null) {
            if (key.equals(context.key)) {
                return context;
            }
            context = context.previous;
        }
        return null;
    }

    public static ThreadContext push(String key, Object value) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        ThreadContext oldContext = ThreadContext.getContext();
        if (oldContext == null) {
            oldContext = new ThreadContext(null, null, null);
        }
        ThreadContext newContext = new ThreadContext(oldContext, key, value);
        ThreadContext.setContext(newContext);
        return oldContext;
    }

    public static ThreadContext getThreadContext() {
        return ThreadContext.getContext();
    }

    public static void restore(ThreadContext oldContext) throws NullPointerException, IllegalArgumentException {
        if (oldContext == null) {
            throw new NullPointerException();
        }
        ThreadContext context = ThreadContext.getContext();
        while (context != oldContext) {
            if (context == null) {
                throw new IllegalArgumentException("Restored context is not contained in current context");
            }
            context = context.previous;
        }
        if (oldContext.key == null) {
            oldContext = null;
        }
        ThreadContext.setContext(oldContext);
    }

    public void setInitialContext(ThreadContext context) throws IllegalArgumentException {
        if (ThreadContext.getContext() != null) {
            throw new IllegalArgumentException("previous context not empty");
        }
        ThreadContext.setContext(context);
    }

    private static ThreadContext getContext() {
        return localContext.get();
    }

    private static void setContext(ThreadContext context) {
        localContext.set(context);
    }
}

