/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.mbeanserver.WeakIdentityHashMap;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MXBeanLookup {
    private final MBeanServerConnection mbsc;
    private final WeakIdentityHashMap<Object, ObjectName> mxbeanToObjectName = WeakIdentityHashMap.make();
    private final Map<ObjectName, WeakReference<Object>> objectNameToProxy = Util.newMap();
    private static WeakIdentityHashMap<MBeanServerConnection, WeakReference<MXBeanLookup>> mbscToLookup = WeakIdentityHashMap.make();

    private MXBeanLookup(MBeanServerConnection mbsc) {
        this.mbsc = mbsc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MXBeanLookup lookupFor(MBeanServerConnection mbsc) {
        WeakIdentityHashMap<MBeanServerConnection, WeakReference<MXBeanLookup>> weakIdentityHashMap = mbscToLookup;
        synchronized (weakIdentityHashMap) {
            MXBeanLookup lookup;
            WeakReference<MXBeanLookup> weakLookup = mbscToLookup.get(mbsc);
            MXBeanLookup mXBeanLookup = lookup = weakLookup == null ? null : (MXBeanLookup)weakLookup.get();
            if (lookup == null) {
                lookup = new MXBeanLookup(mbsc);
                mbscToLookup.put(mbsc, new WeakReference<MXBeanLookup>(lookup));
            }
            return lookup;
        }
    }

    synchronized <T> T objectNameToMXBean(ObjectName name, Class<T> type) {
        Object proxy;
        WeakReference<Object> wr = this.objectNameToProxy.get(name);
        if (wr != null && type.isInstance(proxy = wr.get())) {
            return type.cast(proxy);
        }
        proxy = JMX.newMXBeanProxy(this.mbsc, name, type);
        this.objectNameToProxy.put(name, new WeakReference(proxy));
        return proxy;
    }

    synchronized ObjectName mxbeanToObjectName(Object mxbean) {
        if (mxbean instanceof Proxy) {
            MBeanServerInvocationHandler mbsih;
            InvocationHandler ih = Proxy.getInvocationHandler(mxbean);
            if (ih instanceof MBeanServerInvocationHandler && (mbsih = (MBeanServerInvocationHandler)ih).getMBeanServerConnection().equals(this.mbsc)) {
                return mbsih.getObjectName();
            }
            return null;
        }
        return this.mxbeanToObjectName.get(mxbean);
    }

    synchronized void addReference(ObjectName name, Object mxbean) {
        this.mxbeanToObjectName.put(mxbean, name);
    }

    synchronized boolean removeReference(ObjectName name, Object mxbean) {
        if (name.equals(this.mxbeanToObjectName.get(mxbean))) {
            this.mxbeanToObjectName.remove(mxbean);
            return true;
        }
        return false;
    }
}

