/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.ModifiableClassLoaderRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.management.ObjectName;
import javax.management.loading.PrivateClassLoader;

final class ClassLoaderRepositorySupport
implements ModifiableClassLoaderRepository {
    private static final LoaderEntry[] EMPTY_LOADER_ARRAY = new LoaderEntry[0];
    private LoaderEntry[] loaders = EMPTY_LOADER_ARRAY;
    private final Map<String, List<ClassLoader>> search = new Hashtable<String, List<ClassLoader>>(10);
    private final Map<ObjectName, ClassLoader> loadersWithNames = new Hashtable<ObjectName, ClassLoader>(10);

    ClassLoaderRepositorySupport() {
    }

    private synchronized boolean add(ObjectName name, ClassLoader cl) {
        ArrayList<LoaderEntry> l = new ArrayList<LoaderEntry>(Arrays.asList(this.loaders));
        l.add(new LoaderEntry(name, cl));
        this.loaders = l.toArray(EMPTY_LOADER_ARRAY);
        return true;
    }

    private synchronized boolean remove(ObjectName name, ClassLoader cl) {
        int size = this.loaders.length;
        for (int i = 0; i < size; ++i) {
            boolean match;
            LoaderEntry entry = this.loaders[i];
            boolean bl = name == null ? cl == entry.loader : (match = name.equals(entry.name));
            if (!match) continue;
            LoaderEntry[] newloaders = new LoaderEntry[size - 1];
            System.arraycopy(this.loaders, 0, newloaders, 0, i);
            System.arraycopy(this.loaders, i + 1, newloaders, i, size - 1 - i);
            this.loaders = newloaders;
            return true;
        }
        return false;
    }

    public final Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(this.loaders, className, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Class loadClassWithout(ClassLoader without, String className) throws ClassNotFoundException {
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, ClassLoaderRepositorySupport.class.getName(), "loadClassWithout", className + " without " + without);
        }
        if (without == null) {
            return this.loadClass(this.loaders, className, null, null);
        }
        this.startValidSearch(without, className);
        try {
            Class clazz = this.loadClass(this.loaders, className, without, null);
            Object var5_4 = null;
            this.stopValidSearch(without, className);
            return clazz;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.stopValidSearch(without, className);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Class loadClassBefore(ClassLoader stop, String className) throws ClassNotFoundException {
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, ClassLoaderRepositorySupport.class.getName(), "loadClassBefore", className + " before " + stop);
        }
        if (stop == null) {
            return this.loadClass(this.loaders, className, null, null);
        }
        this.startValidSearch(stop, className);
        try {
            Class clazz = this.loadClass(this.loaders, className, null, stop);
            Object var5_4 = null;
            this.stopValidSearch(stop, className);
            return clazz;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.stopValidSearch(stop, className);
            throw throwable;
        }
    }

    private Class loadClass(LoaderEntry[] list, String className, ClassLoader without, ClassLoader stop) throws ClassNotFoundException {
        int size = list.length;
        for (int i = 0; i < size; ++i) {
            try {
                ClassLoader cl = list[i].loader;
                if (cl == null) {
                    return Class.forName(className, false, null);
                }
                if (cl == without) continue;
                if (cl == stop) break;
                if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, ClassLoaderRepositorySupport.class.getName(), "loadClass", "Trying loader = " + cl);
                }
                return Class.forName(className, false, cl);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(className);
    }

    private synchronized void startValidSearch(ClassLoader aloader, String className) throws ClassNotFoundException {
        List<ClassLoader> excluded = this.search.get(className);
        if (excluded != null && excluded.contains(aloader)) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, ClassLoaderRepositorySupport.class.getName(), "startValidSearch", "Already requested loader = " + aloader + " class = " + className);
            }
            throw new ClassNotFoundException(className);
        }
        if (excluded == null) {
            excluded = new ArrayList<ClassLoader>(1);
            this.search.put(className, excluded);
        }
        excluded.add(aloader);
        if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, ClassLoaderRepositorySupport.class.getName(), "startValidSearch", "loader = " + aloader + " class = " + className);
        }
    }

    private synchronized void stopValidSearch(ClassLoader aloader, String className) {
        List<ClassLoader> excluded = this.search.get(className);
        if (excluded != null) {
            excluded.remove(aloader);
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, ClassLoaderRepositorySupport.class.getName(), "stopValidSearch", "loader = " + aloader + " class = " + className);
            }
        }
    }

    public final void addClassLoader(ClassLoader loader) {
        this.add(null, loader);
    }

    public final void removeClassLoader(ClassLoader loader) {
        this.remove(null, loader);
    }

    public final synchronized void addClassLoader(ObjectName name, ClassLoader loader) {
        this.loadersWithNames.put(name, loader);
        if (!(loader instanceof PrivateClassLoader)) {
            this.add(name, loader);
        }
    }

    public final synchronized void removeClassLoader(ObjectName name) {
        ClassLoader loader = this.loadersWithNames.remove(name);
        if (!(loader instanceof PrivateClassLoader)) {
            this.remove(name, loader);
        }
    }

    public final ClassLoader getClassLoader(ObjectName name) {
        return this.loadersWithNames.get(name);
    }

    private static class LoaderEntry {
        ObjectName name;
        ClassLoader loader;

        LoaderEntry(ObjectName name, ClassLoader loader) {
            this.name = name;
            this.loader = loader;
        }
    }
}

