/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEG;
import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.plugins.jpeg.JPEGQTable;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class DQTMarkerSegment
extends MarkerSegment {
    List tables = new ArrayList();

    DQTMarkerSegment(float quality, boolean needTwo) {
        super(219);
        this.tables.add(new Qtable(true, quality));
        if (needTwo) {
            this.tables.add(new Qtable(false, quality));
        }
    }

    DQTMarkerSegment(JPEGBuffer buffer) throws IOException {
        super(buffer);
        Qtable newGuy;
        for (int count = this.length; count > 0; count -= newGuy.data.length + 1) {
            newGuy = new Qtable(buffer);
            this.tables.add(newGuy);
        }
        buffer.bufAvail -= this.length;
    }

    DQTMarkerSegment(JPEGQTable[] qtables) {
        super(219);
        for (int i = 0; i < qtables.length; ++i) {
            this.tables.add(new Qtable(qtables[i], i));
        }
    }

    DQTMarkerSegment(Node node) throws IIOInvalidTreeException {
        super(219);
        NodeList children = node.getChildNodes();
        int size = children.getLength();
        if (size < 1 || size > 4) {
            throw new IIOInvalidTreeException("Invalid DQT node", node);
        }
        for (int i = 0; i < size; ++i) {
            this.tables.add(new Qtable(children.item(i)));
        }
    }

    protected Object clone() {
        DQTMarkerSegment newGuy = (DQTMarkerSegment)super.clone();
        newGuy.tables = new ArrayList(this.tables.size());
        for (Qtable table : this.tables) {
            newGuy.tables.add(table.clone());
        }
        return newGuy;
    }

    IIOMetadataNode getNativeNode() {
        IIOMetadataNode node = new IIOMetadataNode("dqt");
        for (int i = 0; i < this.tables.size(); ++i) {
            Qtable table = (Qtable)this.tables.get(i);
            node.appendChild(table.getNativeNode());
        }
        return node;
    }

    void write(ImageOutputStream ios) throws IOException {
    }

    void print() {
        this.printTag("DQT");
        System.out.println("Num tables: " + Integer.toString(this.tables.size()));
        for (int i = 0; i < this.tables.size(); ++i) {
            Qtable table = (Qtable)this.tables.get(i);
            table.print();
        }
        System.out.println();
    }

    Qtable getChromaForLuma(Qtable luma) {
        Qtable newGuy = null;
        boolean allSame = true;
        for (int i = 1; i < luma.QTABLE_SIZE; ++i) {
            if (luma.data[i] == luma.data[i - 1]) continue;
            allSame = false;
            break;
        }
        if (allSame) {
            newGuy = (Qtable)luma.clone();
            newGuy.tableID = 1;
        } else {
            int largestPos = 0;
            for (int i = 1; i < luma.QTABLE_SIZE; ++i) {
                if (luma.data[i] <= luma.data[largestPos]) continue;
                largestPos = i;
            }
            float scaleFactor = (float)luma.data[largestPos] / (float)JPEGQTable.K1Div2Luminance.getTable()[largestPos];
            JPEGQTable jpegTable = JPEGQTable.K2Div2Chrominance.getScaledInstance(scaleFactor, true);
            newGuy = new Qtable(jpegTable, 1);
        }
        return newGuy;
    }

    Qtable getQtableFromNode(Node node) throws IIOInvalidTreeException {
        return new Qtable(node);
    }

    class Qtable
    implements Cloneable {
        int elementPrecision;
        int tableID;
        final int QTABLE_SIZE = 64;
        int[] data;
        private final int[] zigzag = new int[]{0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31, 40, 44, 53, 10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61, 35, 36, 48, 49, 57, 58, 62, 63};

        Qtable(boolean wantLuma, float quality) {
            this.elementPrecision = 0;
            JPEGQTable base = null;
            if (wantLuma) {
                this.tableID = 0;
                base = JPEGQTable.K1Div2Luminance;
            } else {
                this.tableID = 1;
                base = JPEGQTable.K2Div2Chrominance;
            }
            if (quality != 0.75f) {
                quality = JPEG.convertToLinearQuality(quality);
                base = wantLuma ? JPEGQTable.K1Luminance.getScaledInstance(quality, true) : JPEGQTable.K2Div2Chrominance.getScaledInstance(quality, true);
            }
            this.data = base.getTable();
        }

        Qtable(JPEGBuffer buffer) throws IIOException {
            this.elementPrecision = buffer.buf[buffer.bufPtr] >>> 4;
            this.tableID = buffer.buf[buffer.bufPtr++] & 0xF;
            if (this.elementPrecision != 0) {
                throw new IIOException("Unsupported element precision");
            }
            this.data = new int[64];
            for (int i = 0; i < 64; ++i) {
                this.data[i] = buffer.buf[buffer.bufPtr + this.zigzag[i]] & 0xFF;
            }
            buffer.bufPtr += 64;
        }

        Qtable(JPEGQTable table, int id) {
            this.elementPrecision = 0;
            this.tableID = id;
            this.data = table.getTable();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Qtable(Node node) throws IIOInvalidTreeException {
            if (!node.getNodeName().equals("dqtable")) throw new IIOInvalidTreeException("Invalid node, expected dqtable", node);
            NamedNodeMap attrs = node.getAttributes();
            int count = attrs.getLength();
            if (count < 1 || count > 2) {
                throw new IIOInvalidTreeException("dqtable node must have 1 or 2 attributes", node);
            }
            this.elementPrecision = 0;
            this.tableID = MarkerSegment.getAttributeValue(node, attrs, "qtableId", 0, 3, true);
            if (!(node instanceof IIOMetadataNode)) throw new IIOInvalidTreeException("dqtable node must have user object", node);
            IIOMetadataNode ourNode = (IIOMetadataNode)node;
            JPEGQTable table = (JPEGQTable)ourNode.getUserObject();
            if (table == null) {
                throw new IIOInvalidTreeException("dqtable node must have user object", node);
            }
            this.data = table.getTable();
        }

        protected Object clone() {
            Qtable newGuy = null;
            try {
                newGuy = (Qtable)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            if (this.data != null) {
                newGuy.data = (int[])this.data.clone();
            }
            return newGuy;
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode node = new IIOMetadataNode("dqtable");
            node.setAttribute("elementPrecision", Integer.toString(this.elementPrecision));
            node.setAttribute("qtableId", Integer.toString(this.tableID));
            node.setUserObject(new JPEGQTable(this.data));
            return node;
        }

        void print() {
            System.out.println("Table id: " + Integer.toString(this.tableID));
            System.out.println("Element precision: " + Integer.toString(this.elementPrecision));
            new JPEGQTable(this.data).toString();
        }
    }
}

