/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orb;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orb.ParserActionBase;
import com.sun.corba.se.impl.orbutil.ObjectUtility;
import com.sun.corba.se.spi.orb.Operation;
import com.sun.corba.se.spi.orb.StringPair;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public class PrefixParserAction
extends ParserActionBase {
    private Class componentType;
    private ORBUtilSystemException wrapper;

    public PrefixParserAction(String propertyName, Operation operation, String fieldName, Class componentType) {
        super(propertyName, true, operation, fieldName);
        this.componentType = componentType;
        this.wrapper = ORBUtilSystemException.get("orb.lifecycle");
    }

    public Object apply(Properties props) {
        int prefixLength;
        String prefix = this.getPropertyName();
        if (prefix.charAt((prefixLength = prefix.length()) - 1) != '.') {
            prefix = prefix + '.';
            ++prefixLength;
        }
        LinkedList<Object> matches = new LinkedList<Object>();
        for (String key : props.keySet()) {
            if (!key.startsWith(prefix)) continue;
            String suffix = key.substring(prefixLength);
            String value = props.getProperty(key);
            StringPair data = new StringPair(suffix, value);
            Object result = this.getOperation().operate(data);
            matches.add(result);
        }
        int size = matches.size();
        if (size > 0) {
            Object result = null;
            try {
                result = Array.newInstance(this.componentType, size);
            }
            catch (Throwable thr) {
                throw this.wrapper.couldNotCreateArray(thr, (Object)this.getPropertyName(), (Object)this.componentType, (Object)new Integer(size));
            }
            Iterator iter2 = matches.iterator();
            int ctr = 0;
            while (iter2.hasNext()) {
                Object obj = iter2.next();
                try {
                    Array.set(result, ctr, obj);
                }
                catch (Throwable thr) {
                    throw this.wrapper.couldNotSetArray(thr, (Object)this.getPropertyName(), (Object)new Integer(ctr), (Object)this.componentType, (Object)new Integer(size), (Object)ObjectUtility.compactObjectToString(obj));
                }
                ++ctr;
            }
            return result;
        }
        return null;
    }
}

