/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.interceptors;

import com.sun.corba.se.impl.corba.RequestImpl;
import com.sun.corba.se.impl.interceptors.ClientRequestInfoImpl;
import com.sun.corba.se.impl.interceptors.CodecFactoryImpl;
import com.sun.corba.se.impl.interceptors.InterceptorInvoker;
import com.sun.corba.se.impl.interceptors.InterceptorList;
import com.sun.corba.se.impl.interceptors.ORBInitInfoImpl;
import com.sun.corba.se.impl.interceptors.PICurrent;
import com.sun.corba.se.impl.interceptors.ServerRequestInfoImpl;
import com.sun.corba.se.impl.logging.InterceptorsSystemException;
import com.sun.corba.se.impl.logging.OMGSystemException;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.protocol.giopmsgheaders.ReplyMessage;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.ObjectKeyTemplate;
import com.sun.corba.se.spi.oa.ObjectAdapter;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.orbutil.closure.ClosureFactory;
import com.sun.corba.se.spi.protocol.CorbaMessageMediator;
import com.sun.corba.se.spi.protocol.ForwardException;
import com.sun.corba.se.spi.protocol.PIHandler;
import java.util.HashMap;
import java.util.Stack;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NVList;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.IOP.CodecFactory;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ObjectReferenceTemplate;
import org.omg.PortableInterceptor.PolicyFactory;

public class PIHandlerImpl
implements PIHandler {
    boolean printPushPopEnabled = false;
    int pushLevel = 0;
    private ORB orb;
    InterceptorsSystemException wrapper;
    ORBUtilSystemException orbutilWrapper;
    OMGSystemException omgWrapper;
    private int serverRequestIdCounter = 0;
    CodecFactory codecFactory = null;
    String[] arguments = null;
    private InterceptorList interceptorList;
    private boolean hasIORInterceptors;
    private boolean hasClientInterceptors;
    private boolean hasServerInterceptors;
    private InterceptorInvoker interceptorInvoker;
    private PICurrent current;
    private HashMap policyFactoryTable;
    private static final short[] REPLY_MESSAGE_TO_PI_REPLY_STATUS = new short[]{0, 2, 1, 3, 3, 4};
    private ThreadLocal threadLocalClientRequestInfoStack = new ThreadLocal(){

        protected Object initialValue() {
            return new RequestInfoStack();
        }
    };
    private ThreadLocal threadLocalServerRequestInfoStack = new ThreadLocal(){

        protected Object initialValue() {
            return new RequestInfoStack();
        }
    };

    private void printPush() {
        if (!this.printPushPopEnabled) {
            return;
        }
        this.printSpaces(this.pushLevel);
        ++this.pushLevel;
        System.out.println("PUSH");
    }

    private void printPop() {
        if (!this.printPushPopEnabled) {
            return;
        }
        --this.pushLevel;
        this.printSpaces(this.pushLevel);
        System.out.println("POP");
    }

    private void printSpaces(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(" ");
        }
    }

    public PIHandlerImpl(ORB orb, String[] args) {
        this.orb = orb;
        this.wrapper = InterceptorsSystemException.get(orb, "rpc.protocol");
        this.orbutilWrapper = ORBUtilSystemException.get(orb, "rpc.protocol");
        this.omgWrapper = OMGSystemException.get(orb, "rpc.protocol");
        this.arguments = args;
        this.codecFactory = new CodecFactoryImpl(orb);
        this.interceptorList = new InterceptorList(this.wrapper);
        this.current = new PICurrent(orb);
        this.interceptorInvoker = new InterceptorInvoker(orb, this.interceptorList, this.current);
        orb.getLocalResolver().register("PICurrent", ClosureFactory.makeConstant(this.current));
        orb.getLocalResolver().register("CodecFactory", ClosureFactory.makeConstant(this.codecFactory));
    }

    public void initialize() {
        if (this.orb.getORBData().getORBInitializers() != null) {
            ORBInitInfoImpl orbInitInfo = this.createORBInitInfo();
            this.current.setORBInitializing(true);
            this.preInitORBInitializers(orbInitInfo);
            this.postInitORBInitializers(orbInitInfo);
            this.interceptorList.sortInterceptors();
            this.current.setORBInitializing(false);
            orbInitInfo.setStage(2);
            this.hasIORInterceptors = this.interceptorList.hasInterceptorsOfType(2);
            this.hasClientInterceptors = true;
            this.hasServerInterceptors = this.interceptorList.hasInterceptorsOfType(1);
            this.interceptorInvoker.setEnabled(true);
        }
    }

    public void destroyInterceptors() {
        this.interceptorList.destroyAll();
    }

    public void objectAdapterCreated(ObjectAdapter oa) {
        if (!this.hasIORInterceptors) {
            return;
        }
        this.interceptorInvoker.objectAdapterCreated(oa);
    }

    public void adapterManagerStateChanged(int managerId, short newState) {
        if (!this.hasIORInterceptors) {
            return;
        }
        this.interceptorInvoker.adapterManagerStateChanged(managerId, newState);
    }

    public void adapterStateChanged(ObjectReferenceTemplate[] templates, short newState) {
        if (!this.hasIORInterceptors) {
            return;
        }
        this.interceptorInvoker.adapterStateChanged(templates, newState);
    }

    public void disableInterceptorsThisThread() {
        if (!this.hasClientInterceptors) {
            return;
        }
        RequestInfoStack infoStack = (RequestInfoStack)this.threadLocalClientRequestInfoStack.get();
        ++infoStack.disableCount;
    }

    public void enableInterceptorsThisThread() {
        if (!this.hasClientInterceptors) {
            return;
        }
        RequestInfoStack infoStack = (RequestInfoStack)this.threadLocalClientRequestInfoStack.get();
        --infoStack.disableCount;
    }

    public void invokeClientPIStartingPoint() throws RemarshalException {
        if (!this.hasClientInterceptors) {
            return;
        }
        if (!this.isClientPIEnabledForThisThread()) {
            return;
        }
        ClientRequestInfoImpl info = this.peekClientRequestInfoImplStack();
        this.interceptorInvoker.invokeClientInterceptorStartingPoint(info);
        short replyStatus = info.getReplyStatus();
        if (replyStatus == 1 || replyStatus == 3) {
            Exception exception = this.invokeClientPIEndingPoint(this.convertPIReplyStatusToReplyMessage(replyStatus), info.getException());
            if (exception == null) {
                // empty if block
            }
            if (exception instanceof SystemException) {
                throw (SystemException)exception;
            }
            if (exception instanceof RemarshalException) {
                throw (RemarshalException)exception;
            }
            if (exception instanceof UserException || exception instanceof ApplicationException) {
                throw this.wrapper.exceptionInvalid();
            }
        } else if (replyStatus != -1) {
            throw this.wrapper.replyStatusNotInit();
        }
    }

    public Exception invokeClientPIEndingPoint(int replyStatus, Exception exception) {
        if (!this.hasClientInterceptors) {
            return exception;
        }
        if (!this.isClientPIEnabledForThisThread()) {
            return exception;
        }
        short piReplyStatus = REPLY_MESSAGE_TO_PI_REPLY_STATUS[replyStatus];
        ClientRequestInfoImpl info = this.peekClientRequestInfoImplStack();
        info.setReplyStatus(piReplyStatus);
        info.setException(exception);
        this.interceptorInvoker.invokeClientInterceptorEndingPoint(info);
        piReplyStatus = info.getReplyStatus();
        if (piReplyStatus == 3 || piReplyStatus == 4) {
            info.reset();
            info.setRetryRequest(true);
            exception = new RemarshalException();
        } else if (piReplyStatus == 1 || piReplyStatus == 2) {
            exception = info.getException();
        }
        return exception;
    }

    public void initiateClientPIRequest(boolean diiRequest) {
        if (!this.hasClientInterceptors) {
            return;
        }
        if (!this.isClientPIEnabledForThisThread()) {
            return;
        }
        RequestInfoStack infoStack = (RequestInfoStack)this.threadLocalClientRequestInfoStack.get();
        ClientRequestInfoImpl info = null;
        if (!infoStack.empty()) {
            info = (ClientRequestInfoImpl)infoStack.peek();
        }
        if (!diiRequest && info != null && info.isDIIInitiate()) {
            info.setDIIInitiate(false);
        } else {
            if (info == null || !info.getRetryRequest()) {
                info = new ClientRequestInfoImpl(this.orb);
                infoStack.push(info);
                this.printPush();
            }
            info.setRetryRequest(false);
            info.incrementEntryCount();
            if (diiRequest) {
                info.setDIIInitiate(true);
            }
        }
    }

    public void cleanupClientPIRequest() {
        if (!this.hasClientInterceptors) {
            return;
        }
        if (!this.isClientPIEnabledForThisThread()) {
            return;
        }
        ClientRequestInfoImpl info = this.peekClientRequestInfoImplStack();
        short replyStatus = info.getReplyStatus();
        if (replyStatus == -1) {
            this.invokeClientPIEndingPoint(2, this.wrapper.unknownRequestInvoke(CompletionStatus.COMPLETED_MAYBE));
        }
        info.decrementEntryCount();
        if (info.getEntryCount() == 0) {
            RequestInfoStack infoStack = (RequestInfoStack)this.threadLocalClientRequestInfoStack.get();
            infoStack.pop();
            this.printPop();
        }
    }

    public void setClientPIInfo(CorbaMessageMediator messageMediator) {
        if (!this.hasClientInterceptors) {
            return;
        }
        if (!this.isClientPIEnabledForThisThread()) {
            return;
        }
        this.peekClientRequestInfoImplStack().setInfo(messageMediator);
    }

    public void setClientPIInfo(RequestImpl requestImpl) {
        if (!this.hasClientInterceptors) {
            return;
        }
        if (!this.isClientPIEnabledForThisThread()) {
            return;
        }
        this.peekClientRequestInfoImplStack().setDIIRequest(requestImpl);
    }

    public void invokeServerPIStartingPoint() {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
        this.interceptorInvoker.invokeServerInterceptorStartingPoint(info);
        this.serverPIHandleExceptions(info);
    }

    public void invokeServerPIIntermediatePoint() {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
        this.interceptorInvoker.invokeServerInterceptorIntermediatePoint(info);
        info.releaseServant();
        this.serverPIHandleExceptions(info);
    }

    public void invokeServerPIEndingPoint(ReplyMessage replyMessage) {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
        info.setReplyMessage(replyMessage);
        info.setCurrentExecutionPoint(2);
        if (!info.getAlreadyExecuted()) {
            int replyStatus = replyMessage.getReplyStatus();
            short piReplyStatus = REPLY_MESSAGE_TO_PI_REPLY_STATUS[replyStatus];
            if (piReplyStatus == 3 || piReplyStatus == 4) {
                info.setForwardRequest(replyMessage.getIOR());
            }
            Exception prevException = info.getException();
            if (!info.isDynamic() && piReplyStatus == 2) {
                info.setException(this.omgWrapper.unknownUserException(CompletionStatus.COMPLETED_MAYBE));
            }
            info.setReplyStatus(piReplyStatus);
            this.interceptorInvoker.invokeServerInterceptorEndingPoint(info);
            short newPIReplyStatus = info.getReplyStatus();
            Exception newException = info.getException();
            if (newPIReplyStatus == 1 && newException != prevException) {
                throw (SystemException)newException;
            }
            if (newPIReplyStatus == 3) {
                if (piReplyStatus != 3) {
                    IOR ior = info.getForwardRequestIOR();
                    throw new ForwardException(this.orb, ior);
                }
                if (info.isForwardRequestRaisedInEnding()) {
                    replyMessage.setIOR(info.getForwardRequestIOR());
                }
            }
        }
    }

    public void setServerPIInfo(Exception exception) {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
        info.setException(exception);
    }

    public void setServerPIInfo(NVList arguments) {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
        info.setDSIArguments(arguments);
    }

    public void setServerPIExceptionInfo(Any exception) {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
        info.setDSIException(exception);
    }

    public void setServerPIInfo(Any result) {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
        info.setDSIResult(result);
    }

    public void initializeServerPIInfo(CorbaMessageMediator request, ObjectAdapter oa, byte[] objectId, ObjectKeyTemplate oktemp) {
        if (!this.hasServerInterceptors) {
            return;
        }
        RequestInfoStack infoStack = (RequestInfoStack)this.threadLocalServerRequestInfoStack.get();
        ServerRequestInfoImpl info = new ServerRequestInfoImpl(this.orb);
        infoStack.push(info);
        this.printPush();
        request.setExecutePIInResponseConstructor(true);
        info.setInfo(request, oa, objectId, oktemp);
    }

    public void setServerPIInfo(Object servant, String targetMostDerivedInterface) {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
        info.setInfo(servant, targetMostDerivedInterface);
    }

    public void cleanupServerPIRequest() {
        if (!this.hasServerInterceptors) {
            return;
        }
        RequestInfoStack infoStack = (RequestInfoStack)this.threadLocalServerRequestInfoStack.get();
        infoStack.pop();
        this.printPop();
    }

    private void serverPIHandleExceptions(ServerRequestInfoImpl info) {
        int endingPointCall = info.getEndingPointCall();
        if (endingPointCall == 1) {
            throw (SystemException)info.getException();
        }
        if (endingPointCall == 2 && info.getForwardRequestException() != null) {
            IOR ior = info.getForwardRequestIOR();
            throw new ForwardException(this.orb, ior);
        }
    }

    private int convertPIReplyStatusToReplyMessage(short replyStatus) {
        int result = 0;
        for (int i = 0; i < REPLY_MESSAGE_TO_PI_REPLY_STATUS.length; ++i) {
            if (REPLY_MESSAGE_TO_PI_REPLY_STATUS[i] != replyStatus) continue;
            result = i;
            break;
        }
        return result;
    }

    private ClientRequestInfoImpl peekClientRequestInfoImplStack() {
        RequestInfoStack infoStack = (RequestInfoStack)this.threadLocalClientRequestInfoStack.get();
        ClientRequestInfoImpl info = null;
        if (infoStack.empty()) {
            throw this.wrapper.clientInfoStackNull();
        }
        info = (ClientRequestInfoImpl)infoStack.peek();
        return info;
    }

    private ServerRequestInfoImpl peekServerRequestInfoImplStack() {
        RequestInfoStack infoStack = (RequestInfoStack)this.threadLocalServerRequestInfoStack.get();
        ServerRequestInfoImpl info = null;
        if (infoStack.empty()) {
            throw this.wrapper.serverInfoStackNull();
        }
        info = (ServerRequestInfoImpl)infoStack.peek();
        return info;
    }

    private boolean isClientPIEnabledForThisThread() {
        RequestInfoStack infoStack = (RequestInfoStack)this.threadLocalClientRequestInfoStack.get();
        return infoStack.disableCount == 0;
    }

    private void preInitORBInitializers(ORBInitInfoImpl info) {
        info.setStage(0);
        for (int i = 0; i < this.orb.getORBData().getORBInitializers().length; ++i) {
            ORBInitializer init = this.orb.getORBData().getORBInitializers()[i];
            if (init == null) continue;
            try {
                init.pre_init(info);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void postInitORBInitializers(ORBInitInfoImpl info) {
        info.setStage(1);
        for (int i = 0; i < this.orb.getORBData().getORBInitializers().length; ++i) {
            ORBInitializer init = this.orb.getORBData().getORBInitializers()[i];
            if (init == null) continue;
            try {
                init.post_init(info);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private ORBInitInfoImpl createORBInitInfo() {
        ORBInitInfoImpl result = null;
        String orbId = this.orb.getORBData().getORBId();
        result = new ORBInitInfoImpl(this.orb, this.arguments, orbId, this.codecFactory);
        return result;
    }

    public void register_interceptor(Interceptor interceptor, int type) throws DuplicateName {
        if (type >= 3 || type < 0) {
            throw this.wrapper.typeOutOfRange(new Integer(type));
        }
        String interceptorName = interceptor.name();
        if (interceptorName == null) {
            throw this.wrapper.nameNull();
        }
        this.interceptorList.register_interceptor(interceptor, type);
    }

    public Current getPICurrent() {
        return this.current;
    }

    private void nullParam() throws BAD_PARAM {
        throw this.orbutilWrapper.nullParam();
    }

    public Policy create_policy(int type, Any val) throws PolicyError {
        if (val == null) {
            this.nullParam();
        }
        if (this.policyFactoryTable == null) {
            throw new PolicyError("There is no PolicyFactory Registered for type " + type, 0);
        }
        PolicyFactory factory = (PolicyFactory)this.policyFactoryTable.get(new Integer(type));
        if (factory == null) {
            throw new PolicyError(" Could Not Find PolicyFactory for the Type " + type, 0);
        }
        Policy policy = factory.create_policy(type, val);
        return policy;
    }

    public void registerPolicyFactory(int type, PolicyFactory factory) {
        Integer key;
        Object val;
        if (this.policyFactoryTable == null) {
            this.policyFactoryTable = new HashMap();
        }
        if ((val = this.policyFactoryTable.get(key = new Integer(type))) != null) {
            throw this.omgWrapper.policyFactoryRegFailed(new Integer(type));
        }
        this.policyFactoryTable.put(key, factory);
    }

    public synchronized int allocateServerRequestId() {
        return this.serverRequestIdCounter++;
    }

    private final class RequestInfoStack
    extends Stack {
        public int disableCount = 0;

        private RequestInfoStack() {
        }
    }
}

