/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.tools.apichecker;

import com.google.gwt.core.ext.typeinfo.JAbstractMethod;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JParameter;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.tools.apichecker.ApiAbstractMethod;
import com.google.gwt.tools.apichecker.ApiChange;
import com.google.gwt.tools.apichecker.ApiClass;
import com.google.gwt.tools.apichecker.ApiDiffGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ApiMethod
extends ApiAbstractMethod {
    ApiMethod(JAbstractMethod method, ApiClass apiClass) {
        super(method, apiClass);
    }

    @Override
    public boolean isOverridable() {
        JMethod methodType = (JMethod)this.method;
        if (methodType.isStatic() || methodType.isFinal()) {
            return false;
        }
        return this.apiClass.isSubclassableApiClass();
    }

    @Override
    ApiChange checkReturnTypeCompatibility(ApiAbstractMethod newMethod) throws TypeNotPresentException {
        if (!(newMethod.getMethod() instanceof JMethod) || !(this.method instanceof JMethod)) {
            throw new AssertionError((Object)("Different types for method = " + this.method.getClass() + ", and newMethodObject = " + newMethod.getMethod().getClass() + ", signature = " + this.getApiSignature()));
        }
        JType firstType = ((JMethod)this.method).getReturnType();
        JType secondType = ((JMethod)newMethod.getMethod()).getReturnType();
        StringBuffer sb = new StringBuffer();
        if (firstType.getSimpleSourceName().indexOf("void") != -1) {
            return null;
        }
        boolean compatible = ApiDiffGenerator.isFirstTypeAssignableToSecond(secondType, firstType);
        if (compatible) {
            return null;
        }
        sb.append(" from ");
        sb.append(firstType.getQualifiedSourceName());
        sb.append(" to ");
        sb.append(secondType.getQualifiedSourceName());
        return new ApiChange(this, ApiChange.Status.RETURN_TYPE_ERROR, sb.toString());
    }

    @Override
    List<ApiChange> getAllChangesInApi(ApiAbstractMethod newApiMethod) {
        JParameter[] existingParametersList;
        JParameter[] newParametersList;
        if (!(newApiMethod.getMethod() instanceof JMethod)) {
            return Collections.emptyList();
        }
        ArrayList<ApiChange> changeApis = new ArrayList<ApiChange>();
        JMethod existingMethod = (JMethod)this.method;
        JMethod newMethod = (JMethod)newApiMethod.getMethod();
        if (!existingMethod.getReturnType().getJNISignature().equals(newMethod.getReturnType().getJNISignature())) {
            changeApis.add(new ApiChange(this, ApiChange.Status.OVERRIDABLE_METHOD_RETURN_TYPE_CHANGE, " from " + existingMethod.getReturnType() + " to " + newMethod.getReturnType()));
        }
        if ((newParametersList = newMethod.getParameters()).length != (existingParametersList = existingMethod.getParameters()).length) {
            changeApis.add(new ApiChange(this, ApiChange.Status.OVERRIDABLE_METHOD_ARGUMENT_TYPE_CHANGE, "number of parameters changed"));
        } else {
            int length = newParametersList.length;
            for (int i = 0; i < length; ++i) {
                if (existingParametersList[i].getType().getJNISignature().equals(newParametersList[i].getType().getJNISignature())) continue;
                changeApis.add(new ApiChange(this, ApiChange.Status.OVERRIDABLE_METHOD_ARGUMENT_TYPE_CHANGE, " at position " + i + " from " + existingParametersList[i].getType() + " to " + newParametersList[i].getType()));
            }
        }
        HashSet<String> newExceptionsSet = new HashSet<String>();
        HashMap<String, JType> newExceptionsMap = new HashMap<String, JType>();
        for (JClassType newType : newMethod.getThrows()) {
            String jniSignature = newType.getJNISignature();
            newExceptionsMap.put(jniSignature, (JType)newType);
            newExceptionsSet.add(jniSignature);
        }
        HashSet<String> existingExceptionsSet = new HashSet<String>();
        HashMap<String, JType> existingExceptionsMap = new HashMap<String, JType>();
        for (JClassType existingType : existingMethod.getThrows()) {
            String jniSignature = existingType.getJNISignature();
            existingExceptionsMap.put(jniSignature, (JType)existingType);
            existingExceptionsSet.add(jniSignature);
        }
        ApiDiffGenerator.removeIntersection(existingExceptionsSet, newExceptionsSet);
        this.removeUncheckedExceptions(newMethod, newExceptionsSet, newExceptionsMap);
        this.removeUncheckedExceptions(existingMethod, existingExceptionsSet, existingExceptionsMap);
        if (existingExceptionsSet.size() > 0) {
            changeApis.add(new ApiChange(this, ApiChange.Status.OVERRIDABLE_METHOD_EXCEPTION_TYPE_CHANGE, "existing method had more exceptions: " + existingExceptionsSet));
        }
        if (newExceptionsSet.size() > 0) {
            changeApis.add(new ApiChange(this, ApiChange.Status.OVERRIDABLE_METHOD_EXCEPTION_TYPE_CHANGE, "new method has more exceptions: " + newExceptionsSet));
        }
        return changeApis;
    }

    @Override
    List<ApiChange.Status> getModifierChanges(ApiAbstractMethod newMethod) {
        JMethod newjmethod = null;
        JMethod oldjmethod = null;
        if (!(newMethod.getMethod() instanceof JMethod) || !(this.method instanceof JMethod)) {
            throw new AssertionError((Object)("Different types for method = " + this.method.getClass() + " and newMethod = " + newMethod.getMethod().getClass() + ", signature = " + this.getApiSignature()));
        }
        newjmethod = (JMethod)newMethod.getMethod();
        oldjmethod = (JMethod)this.method;
        ArrayList<ApiChange.Status> statuses = new ArrayList<ApiChange.Status>();
        if (!oldjmethod.isFinal() && !this.apiClass.getClassObject().isFinal() && newjmethod.isFinal()) {
            statuses.add(ApiChange.Status.FINAL_ADDED);
        }
        if (!oldjmethod.isAbstract() && newjmethod.isAbstract()) {
            statuses.add(ApiChange.Status.ABSTRACT_ADDED);
        }
        if (oldjmethod.isStatic() && !newjmethod.isStatic()) {
            statuses.add(ApiChange.Status.STATIC_REMOVED);
        }
        return statuses;
    }

    private void removeUncheckedExceptions(JMethod method, Set<String> exceptionsSet, Map<String, JType> exceptionsMap) {
        if (exceptionsSet.size() == 0) {
            return;
        }
        TypeOracle typeOracle = method.getEnclosingType().getOracle();
        JClassType errorType = typeOracle.findType(Error.class.getName());
        JClassType rteType = typeOracle.findType(RuntimeException.class.getName());
        HashSet<String> exceptionsToRemove = new HashSet<String>();
        for (String exceptionString : exceptionsSet) {
            JType exception = exceptionsMap.get(exceptionString);
            assert (exception != null);
            boolean remove = errorType != null && ApiDiffGenerator.isFirstTypeAssignableToSecond(exception, (JType)errorType) || rteType != null && ApiDiffGenerator.isFirstTypeAssignableToSecond(exception, (JType)rteType);
            if (!remove) continue;
            exceptionsToRemove.add(exceptionString);
        }
        exceptionsSet.removeAll(exceptionsToRemove);
    }
}

