/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.tools.apichecker;

import com.google.gwt.core.ext.typeinfo.JAbstractMethod;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JParameter;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.tools.apichecker.ApiChange;
import com.google.gwt.tools.apichecker.ApiClass;
import com.google.gwt.tools.apichecker.ApiCompatibilityChecker;
import com.google.gwt.tools.apichecker.ApiDiffGenerator;
import com.google.gwt.tools.apichecker.ApiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ApiAbstractMethod
implements Comparable<ApiAbstractMethod>,
ApiElement {
    final ApiClass apiClass;
    String apiSignature = null;
    String internalSignature = null;
    final JAbstractMethod method;
    String relativeSignature = null;

    static String computeApiSignature(JAbstractMethod method) {
        String className = method.getEnclosingType().getQualifiedSourceName();
        StringBuffer sb = new StringBuffer();
        sb.append(className);
        sb.append("::");
        sb.append(ApiAbstractMethod.computeInternalSignature(method));
        return sb.toString();
    }

    static String computeInternalSignature(JAbstractMethod method) {
        StringBuffer sb = new StringBuffer();
        sb.append(method.getName());
        sb.append("(");
        JParameter[] params = method.getParameters();
        for (int j = 0; j < params.length; ++j) {
            JParameter param = params[j];
            String typeSig = param.getType().getJNISignature();
            sb.append(typeSig);
        }
        sb.append(")");
        return sb.toString();
    }

    public ApiAbstractMethod(JAbstractMethod method, ApiClass apiClass) {
        this.method = method;
        this.apiClass = apiClass;
    }

    @Override
    public int compareTo(ApiAbstractMethod other) {
        return this.getRelativeSignature().compareTo(other.getRelativeSignature());
    }

    public boolean equals(Object o) {
        if (o instanceof ApiAbstractMethod) {
            ApiAbstractMethod other = (ApiAbstractMethod)o;
            return this.getApiSignature().equals(other.getApiSignature());
        }
        return false;
    }

    public ApiClass getApiClass() {
        return this.apiClass;
    }

    public JAbstractMethod getMethod() {
        return this.method;
    }

    @Override
    public String getRelativeSignature() {
        if (this.relativeSignature == null) {
            this.relativeSignature = this.computeRelativeSignature();
        }
        return this.relativeSignature;
    }

    public int hashCode() {
        return this.getApiSignature().hashCode();
    }

    public boolean isCompatible(ApiAbstractMethod methodInNew) {
        JParameter[] parametersInNew = methodInNew.getMethod().getParameters();
        int length = parametersInNew.length;
        if (length != this.method.getParameters().length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (ApiDiffGenerator.isFirstTypeAssignableToSecond(this.method.getParameters()[i].getType(), parametersInNew[i].getType())) continue;
            return false;
        }
        return true;
    }

    public abstract boolean isOverridable();

    public String toString() {
        return this.method.toString();
    }

    List<ApiChange> checkExceptionsAndReturnType(ApiAbstractMethod newMethod) {
        List<ApiChange> apiChanges = this.checkExceptions(newMethod);
        ApiChange returnApiChange = this.checkReturnTypeCompatibility(newMethod);
        if (returnApiChange == null) {
            return apiChanges;
        }
        apiChanges.add(returnApiChange);
        return apiChanges;
    }

    abstract ApiChange checkReturnTypeCompatibility(ApiAbstractMethod var1);

    abstract List<ApiChange> getAllChangesInApi(ApiAbstractMethod var1);

    String getApiSignature() {
        if (this.apiSignature == null) {
            this.apiSignature = ApiAbstractMethod.computeApiSignature(this.method);
        }
        return this.apiSignature;
    }

    String getCoarseSignature() {
        JParameter[] parameters;
        StringBuffer returnStr = new StringBuffer();
        for (JParameter parameter : parameters = this.method.getParameters()) {
            JType type = parameter.getType();
            if (type.isPrimitive() != null) {
                returnStr.append(type.getJNISignature());
            } else {
                returnStr.append("c");
            }
            returnStr.append(";");
        }
        return returnStr.toString();
    }

    String getInternalSignature() {
        if (this.internalSignature == null) {
            this.internalSignature = ApiAbstractMethod.computeInternalSignature(this.method);
        }
        return this.internalSignature;
    }

    abstract List<ApiChange.Status> getModifierChanges(ApiAbstractMethod var1);

    private List<ApiChange> checkExceptions(ApiAbstractMethod newMethod) {
        JClassType rteType;
        ArrayList<JClassType> legalTypes = new ArrayList<JClassType>();
        TypeOracle newTypeOracle = newMethod.getMethod().getEnclosingType().getOracle();
        JClassType errorType = newTypeOracle.findType(Error.class.getName());
        if (errorType != null) {
            legalTypes.add(errorType);
        }
        if ((rteType = newTypeOracle.findType(RuntimeException.class.getName())) != null) {
            legalTypes.add(rteType);
        }
        legalTypes.addAll(Arrays.asList(this.getMethod().getThrows()));
        ArrayList<ApiChange> ret = new ArrayList<ApiChange>();
        for (JClassType newException : newMethod.getMethod().getThrows()) {
            boolean isSubclass = false;
            for (JType jType : legalTypes) {
                if (!ApiDiffGenerator.isFirstTypeAssignableToSecond((JType)newException, jType)) continue;
                isSubclass = true;
                break;
            }
            if (isSubclass) continue;
            ret.add(new ApiChange(this, ApiChange.Status.EXCEPTION_TYPE_ERROR, "unhandled exception in new code " + newException));
        }
        return ret;
    }

    private String computeRelativeSignature() {
        String signature = ApiAbstractMethod.computeInternalSignature(this.method);
        if (ApiCompatibilityChecker.DEBUG) {
            JClassType enclosingType = this.method.getEnclosingType();
            return this.apiClass.getClassObject().getQualifiedSourceName() + "::" + signature + " defined in " + (enclosingType == null ? "null enclosing type " : enclosingType.getQualifiedSourceName());
        }
        return this.apiClass.getClassObject().getQualifiedSourceName() + "::" + signature;
    }
}

