/*
 * Decompiled with CFR 0.152.
 */
package com.sun.inputmethods.internal.thaiim;

import java.awt.im.InputMethodRequests;

public class ThaiRules {
    public static final char BASE = '\u0e00';
    public static final byte NON = 0;
    public static final byte CONS = 1;
    public static final byte LV = 2;
    public static final byte FV1 = 3;
    public static final byte FV2 = 4;
    public static final byte FV3 = 5;
    public static final byte FV4 = 6;
    public static final byte BV1 = 7;
    public static final byte BV2 = 8;
    public static final byte BD = 9;
    public static final byte TONE = 10;
    public static final byte AD1 = 11;
    public static final byte AD2 = 12;
    public static final byte AD3 = 13;
    public static final byte AV1 = 14;
    public static final byte AV2 = 15;
    public static final byte AV3 = 16;
    public static final byte STRICT = 0;
    public static final byte LOOSE = 1;
    public static final byte NOREPLACE = 2;
    public static final byte[] CHARTYPE = new byte[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 5, 1, 5, 1, 1, 1, 1, 1, 1, 1, 1, 0, 3, 15, 3, 6, 14, 16, 15, 16, 7, 8, 9, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 4, 0, 12, 10, 10, 10, 10, 11, 13, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private InputMethodRequests requests;
    private static final int[] INPUTVALIDITY = new int[]{39, 131071, 2, 39, 39, 55, 39, 3111, 1063, 39, 111, 39, 39, 39, 3111, 1063, 9255};
    private static final int[] COMPOSABLE = new int[]{0, 131008, 0, 0, 0, 0, 0, 3072, 1024, 0, 64, 0, 0, 0, 3072, 1024, 9216};
    private static final int[] REPLACABLE = new int[]{0, 0, 0, 0, 0, 0, 129472, 127936, 129984, 131008, 15872, 114496, 131008, 65472, 127936, 129984, 121792};
    private static final int[] SWAPPABLE = new int[]{0, 0, 0, 0, 0, 0, 1024, 0, 0, 0, 115072, 16512, 0, 65536, 0, 0, 0};

    ThaiRules(InputMethodRequests requests) {
        this.requests = requests;
    }

    public static byte getCharType(char c) {
        int ci = c - 3584;
        byte cType = ci < 0 || ci >= CHARTYPE.length ? (byte)0 : CHARTYPE[ci];
        return cType;
    }

    private static boolean isValid(char c1, char c2, int[] validityArray) {
        return (validityArray[ThaiRules.getCharType(c1)] & 1 << ThaiRules.getCharType(c2)) != 0;
    }

    public static boolean isInputValid(char c1, char c2) {
        return ThaiRules.isValid(c1, c2, INPUTVALIDITY);
    }

    public static boolean isComposable(char c1, char c2) {
        return ThaiRules.isValid(c1, c2, COMPOSABLE);
    }

    public static boolean isSwappable(char c1, char c2) {
        return ThaiRules.isValid(c1, c2, SWAPPABLE);
    }

    public static boolean isReplacable(char c1, char c2) {
        return ThaiRules.isValid(c1, c2, REPLACABLE);
    }

    public static boolean isForward(char c) {
        return ThaiRules.getCharType(c) < 6;
    }

    public static boolean isDead(char c) {
        return ThaiRules.getCharType(c) > 5;
    }

    public boolean isInputValid(char current) {
        int offset = this.requests.getInsertPositionOffset();
        if (offset == 0) {
            byte charType = ThaiRules.getCharType(current);
            return charType < 3 || charType == 5;
        }
        char prev = this.requests.getCommittedText(offset - 1, offset, null).first();
        if (ThaiRules.isForward(current)) {
            if (ThaiRules.isInputValid(prev, current)) {
                if (ThaiRules.getCharType(prev) == 10 && ThaiRules.getCharType(current) == 3) {
                    if (offset == 1) {
                        return true;
                    }
                    char pprev = this.requests.getCommittedText(offset - 2, offset - 1, null).first();
                    return ThaiRules.isInputValid(pprev, current);
                }
                return true;
            }
            if (prev == '\u0e32' && current == '\u0e30') {
                return true;
            }
            return prev == '\u0e4d' && current == '\u0e32';
        }
        if (ThaiRules.isInputValid(prev, current)) {
            if (ThaiRules.getCharType(prev) == 10 && ThaiRules.getCharType(current) == 6) {
                return offset != 1;
            }
            return true;
        }
        return false;
    }
}

