/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11SecureRandom
extends SecureRandomSpi {
    private static final long serialVersionUID = -8939510236124553291L;
    private final Token token;
    private volatile SecureRandom mixRandom;
    private byte[] mixBuffer;
    private int buffered;

    P11SecureRandom(Token token) {
        this.token = token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void engineSetSeed(byte[] seed) {
        block9: {
            if (seed == null) {
                throw new NullPointerException("seed must not be null");
            }
            Session session = null;
            try {
                session = this.token.getOpSession();
                this.token.p11.C_SeedRandom(session.id(), seed);
            }
            catch (PKCS11Exception e) {
                SecureRandom random = this.mixRandom;
                if (random != null) {
                    random.setSeed(seed);
                    break block9;
                }
                try {
                    this.mixBuffer = new byte[20];
                    random = SecureRandom.getInstance("SHA1PRNG");
                    random.setSeed(seed);
                    this.mixRandom = random;
                }
                catch (NoSuchAlgorithmException ee) {
                    throw new ProviderException(ee);
                }
            }
            finally {
                this.token.releaseSession(session);
            }
        }
    }

    protected void engineNextBytes(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        Session session = null;
        try {
            session = this.token.getOpSession();
            this.token.p11.C_GenerateRandom(session.id(), bytes);
            this.mix(bytes);
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("nextBytes() failed", e);
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    protected byte[] engineGenerateSeed(int numBytes) {
        byte[] b = new byte[numBytes];
        this.engineNextBytes(b);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mix(byte[] b) {
        SecureRandom random = this.mixRandom;
        if (random == null) {
            return;
        }
        P11SecureRandom p11SecureRandom = this;
        synchronized (p11SecureRandom) {
            int ofs = 0;
            int len = b.length;
            while (len-- > 0) {
                if (this.buffered == 0) {
                    random.nextBytes(this.mixBuffer);
                    this.buffered = this.mixBuffer.length;
                }
                int n = ofs++;
                b[n] = (byte)(b[n] ^ this.mixBuffer[this.mixBuffer.length - this.buffered]);
                --this.buffered;
            }
        }
    }
}

