/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.event.shared.testing;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.SimpleEventBus;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountingEventBus
extends EventBus {
    private final Map<GwtEvent.Type<?>, Integer> counts = new HashMap();
    private final EventBus wrapped;

    public CountingEventBus() {
        this(new SimpleEventBus());
    }

    public CountingEventBus(EventBus wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public <H extends EventHandler> HandlerRegistration addHandler(GwtEvent.Type<H> type, H handler) {
        this.increment(type);
        HandlerRegistration superReg = this.wrapped.addHandler(type, handler);
        return this.makeReg(type, superReg);
    }

    @Override
    public <H extends EventHandler> HandlerRegistration addHandlerToSource(GwtEvent.Type<H> type, Object source, H handler) {
        this.increment(type);
        HandlerRegistration superReg = this.wrapped.addHandlerToSource(type, source, handler);
        return this.makeReg(type, superReg);
    }

    @Override
    public void fireEvent(GwtEvent<?> event) {
        this.wrapped.fireEvent(event);
    }

    @Override
    public void fireEventFromSource(GwtEvent<?> event, Object source) {
        this.wrapped.fireEventFromSource(event, source);
    }

    public int getCount(GwtEvent.Type<?> type) {
        Integer count = this.counts.get(type);
        return count == null ? 0 : count;
    }

    private void decrement(GwtEvent.Type<?> type) {
        Integer count = this.counts.get(type);
        if (count == null) {
            count = 0;
        }
        this.counts.put(type, count - 1);
    }

    private <H> void increment(GwtEvent.Type<H> type) {
        Integer count = this.counts.get(type);
        if (count == null) {
            count = 0;
        }
        this.counts.put(type, count + 1);
    }

    private <H> HandlerRegistration makeReg(final GwtEvent.Type<H> type, final HandlerRegistration superReg) {
        return new HandlerRegistration(){

            public void removeHandler() {
                CountingEventBus.this.decrement(type);
                superReg.removeHandler();
            }
        };
    }
}

