/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.autobean.server.impl;

import com.google.gwt.autobean.shared.Splittable;
import com.google.gwt.autobean.shared.impl.StringQuoter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonSplittable
implements Splittable {
    private final JSONArray array;
    private final JSONObject obj;
    private final String string;

    public static Splittable create(String payload) {
        try {
            switch (payload.charAt(0)) {
                case '{': {
                    return new JsonSplittable(new JSONObject(payload));
                }
                case '[': {
                    return new JsonSplittable(new JSONArray(payload));
                }
                case '\"': {
                    return new JsonSplittable(new JSONArray("[" + payload + "]").getString(0));
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return new JsonSplittable(payload);
                }
            }
            throw new RuntimeException("Could not parse payload: payload[0] = " + payload.charAt(0));
        }
        catch (JSONException e) {
            throw new RuntimeException("Could not parse payload", e);
        }
    }

    private JsonSplittable(JSONArray array) {
        this.array = array;
        this.obj = null;
        this.string = null;
    }

    private JsonSplittable(JSONObject obj) {
        this.array = null;
        this.obj = obj;
        this.string = null;
    }

    private JsonSplittable(String string) {
        this.array = null;
        this.obj = null;
        this.string = string;
    }

    @Override
    public String asString() {
        return this.string;
    }

    @Override
    public Splittable get(int index) {
        try {
            return this.makeSplittable(this.array.get(index));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Splittable get(String key) {
        try {
            return this.makeSplittable(this.obj.get(key));
        }
        catch (JSONException e) {
            throw new RuntimeException(key, e);
        }
    }

    @Override
    public String getPayload() {
        if (this.obj != null) {
            return this.obj.toString();
        }
        if (this.array != null) {
            return this.array.toString();
        }
        if (this.string != null) {
            return StringQuoter.quote(this.string);
        }
        throw new RuntimeException("No data in this JsonSplittable");
    }

    @Override
    public List<String> getPropertyKeys() {
        String[] names = JSONObject.getNames((JSONObject)this.obj);
        if (names == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(names));
    }

    @Override
    public boolean isIndexed() {
        return this.array != null;
    }

    @Override
    public boolean isKeyed() {
        return this.obj != null;
    }

    @Override
    public boolean isNull(int index) {
        return this.array.isNull(index);
    }

    @Override
    public boolean isNull(String key) {
        return !this.obj.has(key) || this.obj.isNull(key);
    }

    @Override
    public boolean isString() {
        return this.string != null;
    }

    @Override
    public int size() {
        return this.array.length();
    }

    public String toString() {
        if (this.obj != null) {
            return this.obj.toString();
        }
        if (this.array != null) {
            return this.array.toString();
        }
        if (this.string != null) {
            return this.string;
        }
        return "<Uninitialized>";
    }

    private JsonSplittable makeSplittable(Object object) {
        if (object instanceof JSONObject) {
            return new JsonSplittable((JSONObject)object);
        }
        if (object instanceof JSONArray) {
            return new JsonSplittable((JSONArray)object);
        }
        return new JsonSplittable(object.toString());
    }
}

