"use strict";
/**
 * @license
 * Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at
 * http://polymer.github.io/LICENSE.txt
 * The complete set of authors may be found at
 * http://polymer.github.io/AUTHORS.txt
 * The complete set of contributors may be found at
 * http://polymer.github.io/CONTRIBUTORS.txt
 * Code distributed by Google as part of the polymer project is also
 * subject to an additional IP rights grant found at
 * http://polymer.github.io/PATENTS.txt
 */
Object.defineProperty(exports, "__esModule", { value: true });
const shady = require("shady-css-parser");
const document_1 = require("../parser/document");
const cssbeautify = require("cssbeautify");
class ShadyVisitor extends shady.NodeVisitor {
    constructor(visitors) {
        super();
        this.visitors = visitors;
    }
    allVisitors(node) {
        for (const visitor of this.visitors) {
            visitor.visit(node, this.path);
        }
    }
    stylesheet(stylesheet) {
        this.allVisitors(stylesheet);
        for (const rule of stylesheet.rules) {
            this.visit(rule);
        }
    }
    atRule(atRule) {
        this.allVisitors(atRule);
        if (atRule.rulelist) {
            this.visit(atRule.rulelist);
        }
    }
    comment(comment) {
        this.allVisitors(comment);
    }
    rulelist(rulelist) {
        this.allVisitors(rulelist);
        for (const rule of rulelist.rules) {
            this.visit(rule);
        }
    }
    ruleset(ruleset) {
        this.allVisitors(ruleset);
        this.visit(ruleset.rulelist);
    }
    declaration(declaration) {
        this.allVisitors(declaration);
        this.visit(declaration.value);
    }
    expression(expression) {
        this.allVisitors(expression);
    }
    discarded(discarded) {
        this.allVisitors(discarded);
    }
}
class ParsedCssDocument extends document_1.ParsedDocument {
    constructor(from) {
        super(from);
        this.type = 'css';
    }
    visit(visitors) {
        const shadyVisitor = new ShadyVisitor(visitors);
        shadyVisitor.visit(this.ast);
    }
    forEachNode(_callback) {
        throw new Error('Not implemented');
    }
    _sourceRangeForNode(_node) {
        throw new Error('Not implemented');
    }
    stringify(options) {
        options = options || {};
        const beautifulResults = cssbeautify(shadyStringifier.stringify(this.ast), { indent: '  ', autosemicolon: true, openbrace: 'end-of-line' });
        const indent = '  '.repeat(options.indent || 0);
        return beautifulResults.split('\n')
            .map((line) => line === '' ? '' : indent + line)
            .join('\n') +
            '\n';
    }
}
exports.ParsedCssDocument = ParsedCssDocument;
const shadyStringifier = new shady.Stringifier();

//# sourceMappingURL=css-document.js.map
