(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(['exports'], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports);
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports);
    global.nodeVisitor = mod.exports;
  }
})(this, function (exports) {
  'use strict';

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  var _createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor) descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);
      if (staticProps) defineProperties(Constructor, staticProps);
      return Constructor;
    };
  }();

  /**
   * @license
   * Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
   * This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
   * The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
   * The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
   * Code distributed by Google as part of the polymer project is also
   * subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
   */

  var path = Symbol('path');

  /**
   * Class that implements a visitor pattern for ASTs produced by the Parser.
   * Extend the NodeVisitor class to implement useful tree traversal operations
   * such as stringification.
   */

  var NodeVisitor = function () {
    /**
     * Create a NodeVisitor instance.
     */

    function NodeVisitor() {
      _classCallCheck(this, NodeVisitor);

      this[path] = [];
    }

    /**
     * A list of nodes that corresponds to the current path through an AST being
     * visited, leading to where the currently visited node will be found.
     * @type {array}
     */


    NodeVisitor.prototype.visit = function visit(node) {
      var result = void 0;
      if (this[node.type]) {
        this[path].push(node);
        result = this[node.type](node);
        this[path].pop();
      }
      return result;
    };

    _createClass(NodeVisitor, [{
      key: 'path',
      get: function () {
        return this[path];
      }
    }]);

    return NodeVisitor;
  }();

  exports.NodeVisitor = NodeVisitor;
});