self.Runtime.cachedResources["issues/issuesPane.css"]="/*\n * Copyright (c) 2020 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.issues-pane {\n  overflow: hidden;\n}\n\n.issues-pane-no-issues {\n  align-items: center;\n  background-color: lightgray;\n  display: flex;\n  flex: 1 1 auto;\n  font-size: 18px;\n  justify-content: center;\n  padding: 30px;\n}\n\n.issues-toolbar-container {\n  display: none;\n  flex: none;\n}\n\n.issues-toolbar-container > .toolbar {\n  background-color: var(--toolbar-bg-color);\n  border-bottom: var(--divider-border);\n}\n\n.issues-toolbar-left {\n  flex: 1 1 auto;\n}\n\n.issues-toolbar-right {\n  padding-right: 6px;\n}\n\n/*# sourceURL=issues/issuesPane.css */";self.Runtime.cachedResources["issues/issuesTree.css"]="/*\n * Copyright (c) 2020 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n/* Remove container padding from TreeOutline.\n * Allows issues to touch the edges of the container. */\n\n:host,\n.issues {\n  padding: 0;\n  overflow: auto;\n}\n\n.issues {\n  --breaking-change-color: #f29900;\n  --issue-gray: #5f6368;\n  --issue-link: #1967d2;\n  --issue-black: #202124;\n  --issue-code: #f0f0f0;\n  --affected-resource-background: #f8f9fa;\n}\n\n:host-context(.-theme-with-dark-background) .issues {\n  --issue-gray: #ffffffde;\n  --issue-link: #8ab4f8;\n  --issue-black: #fff;\n  --issue-code: #0f0f0f;\n  --affected-resource-background: #ffffff12;\n}\n\n/* Override whitespace behavior for tree items to allow wrapping */\n\n.issues li {\n  white-space: normal;\n}\n\n/* Hide toggle for tree items which cannot be collapsed */\n\n.issues .always-parent::before {\n  display: none;\n}\n\n/* Override TreeOutline toggle switching to allow animation */\n\n.issues li.parent::before {\n  transition: transform 200ms;\n  transform-origin: 25% 50%;\n}\n\n.issues li.parent.expanded::before {\n  -webkit-mask-position: 0 0;\n  transform: rotate(90deg);\n}\n\n.issue {\n  padding: 0 8px;\n  overflow: hidden;\n  flex: none;\n  transition: background-color 200ms;\n  background: #f3f3f3;\n  border: 1px solid #e5e5e5;\n  border-width: 0 0 1px;\n}\n\n.issue.expanded {\n  background: #fff;\n  border-width: 0;\n}\n\np {\n  margin-block-start: 2px;\n  margin-block-end: 2px;\n}\n\n/* Override selected tree item styles for issues to avoid changing width. */\n\n.tree-outline-disclosure:not(.tree-outline-disclosure-hide-overflow) .tree-outline.hide-selection-when-blurred .issue.selected:focus[data-keyboard-focus=\"true\"] {\n  width: auto;\n  padding-right: 8px;\n}\n\n.header {\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n  padding: 6px 0;\n  cursor: pointer;\n  width: 100%;\n}\n\n.title {\n  flex: 1;\n  font-size: 14px;\n  color: var(--issue-black);\n  font-weight: normal;\n  user-select: text;\n}\n\n.issue.expanded .title {\n  font-weight: 450;\n}\n\n.body.children {\n  border-bottom: 1px solid #e5e5e5;\n  padding: 6px 0;\n  position: relative;\n  padding-left: 51px;\n  padding-bottom: 26px;\n  padding-right: 8px;\n}\n\n/* Show a colored border on the left side of opened issues. */\n\n.body::before {\n  content: '';\n  display: block;\n  position: absolute;\n  left: 31px;\n  top: 0;\n  bottom: 20px;\n  border-left: 2px solid var(--breaking-change-color);\n  width: 2px;\n}\n\n.message {\n  line-height: 20px;\n  font-size: 14px;\n  color: var(--issue-gray);\n  margin-bottom: 4px;\n  user-select: text;\n}\n\n.message p {\n  margin-bottom: 16px;\n}\n\n.message li {\n  margin-top: 8px;\n}\n\n.message code {\n  color: var(--issue-black);\n  font-size: 12px;\n  user-select: text;\n  cursor: text;\n  background: var(--issue-code);\n}\n\n.separator::before {\n  content: '·';\n  padding-left: 1ex;\n  padding-right: 1ex;\n}\n\n.link {\n  font-size: 14px;\n  color: var(--issue-link);\n}\n\n.link-wrapper {\n  margin-top: 15px;\n  user-select: text;\n}\n\n.affected-resources-label,\n.resolutions-label {\n  margin-top: 5px;\n  font-size: 10px;\n  font-weight: 500;\n  letter-spacing: 0.06em;\n  text-transform: uppercase;\n  color: var(--issue-black);\n  display: inline-block;\n}\n\n.link-list {\n  list-style-type: none;\n  list-style-position: inside;\n  padding-inline-start: 0;\n}\n\n.resolutions-list {\n  list-style-type: none;\n  list-style-position: inside;\n  padding-inline-start: 0;\n}\n\n/* We inherit all the styles from treeoutline, but these are simple text <li>, so we override some styles */\n\n.link-list li::before {\n  content: none;\n  -webkit-mask-image: none;\n}\n\n.resolutions-list li::before {\n  content: \"→\";\n  -webkit-mask-image: none;\n  padding-right: 5px;\n  position: relative;\n  top: -1px;\n}\n\n.link-list li {\n  display: list-item;\n  margin-top: 4px;\n}\n\n.resolutions-list li {\n  display: list-item;\n}\n\nul > li.plain-enum {\n  display: list-item;\n}\n\n/* This is a hack because the tree view's CSS overrides list styling in a non-compositional way. This\n   can be removed once we've moved to proper components. */\nul > li.plain-enum::before {\n  content: \"\";\n  padding: 0;\n  margin: 0;\n  max-width: 0;\n}\n\n.affected-resources-label + .affected-resources {\n  padding: 3px 0 0 0;\n  position: relative;\n  user-select: text;\n}\n\n.affected-resource-label {\n  font-size: 14px;\n  line-height: 20px;\n  color: var(--issue-black);\n  position: relative;\n  cursor: pointer;\n}\n\n.affected-resource-cookie {\n  font-size: 14px;\n  line-height: 20px;\n  border: 0;\n  border-collapse: collapse;\n}\n\n.affected-resource-element {\n  font-size: 14px;\n  line-height: 20px;\n  color: var(--issue-link);\n  border: 0;\n  border-collapse: collapse;\n}\n\n.affected-resource-mixed-content {\n  font-size: 14px;\n  line-height: 20px;\n  border: 0;\n  border-collapse: collapse;\n}\n\n.affected-resource-heavy-ad {\n  font-size: 14px;\n  line-height: 20px;\n  border: 0;\n  border-collapse: collapse;\n}\n\n.affected-resource-request {\n  font-size: 14px;\n  line-height: 20px;\n  border: 0;\n  border-collapse: collapse;\n}\n\n.affected-resource-source {\n  font-size: 14px;\n  line-height: 20px;\n  color: var(--issue-link);\n  border: 0;\n  border-collapse: collapse;\n}\n\n.affected-resource-list {\n  border-spacing: 10px 0;\n  margin-left: -12px;\n}\n\n.affected-resource-header {\n  font-size: 12px;\n  color: rgb(95 99 104 / 50%);\n  padding-left: 2px;\n}\n\n.affected-resource-cookie-info {\n  color: var(--issue-gray);\n  padding: 2px;\n  text-align: right;\n}\n\n.affected-resource-cookie-info-header {\n  text-align: right;\n}\n\n.affected-resource-mixed-content-info {\n  color: var(--issue-gray);\n  padding: 2px;\n}\n\n.affected-resource-heavy-ad-info {\n  color: var(--issue-gray);\n  padding: 2px;\n}\n\n.affected-resource-heavy-ad-info-frame {\n  display: flex;\n  align-items: center;\n  color: var(--issue-gray);\n  padding: 2px;\n}\n\n.affected-resources > .parent {\n  margin-top: 0;\n  padding: 2px 5px 0 5px;\n}\n\n.affected-resources > .parent.expanded {\n  background: var(--affected-resource-background);\n}\n\n.affected-resources > .children.expanded {\n  background: var(--affected-resource-background);\n  padding: 6px 0 9px 5px;\n  margin-bottom: 10px;\n}\n\n.aggregated-issues-count {\n  padding-right: 7px;\n}\n\n.affected-resource-directive-info-header {\n  text-align: left;\n}\n\n.affected-resource-directive {\n  font-size: 14px;\n  line-height: 20px;\n  border: 0;\n  border-collapse: collapse;\n}\n\n.affected-resource-directive-info {\n  color: var(--issue-gray);\n  padding: 2px;\n  text-align: left;\n}\n\n/*# sourceURL=issues/issuesTree.css */";