import{ObjectWrapper,EventTarget,Revealer}from'../common/common.js';import{SDKModel,ResourceTreeModel,IssuesModel,LogModel,ConsoleModel,RuntimeModel,NetworkLog,NetworkRequest,Cookie}from'../sdk/sdk.js';let frameManagerInstance=null;class FrameManager extends ObjectWrapper.ObjectWrapper{constructor(){super();this._eventListeners=new WeakMap();SDKModel.TargetManager.instance().observeModels(ResourceTreeModel.ResourceTreeModel,this);this._frames=new Map();this._framesForTarget=new Map();}
static instance({forceNew}={forceNew:false}){if(!frameManagerInstance||forceNew){frameManagerInstance=new FrameManager();}
return frameManagerInstance;}
modelAdded(resourceTreeModel){const addListener=resourceTreeModel.addEventListener(ResourceTreeModel.Events.FrameAdded,this._frameAdded,this);const detachListener=resourceTreeModel.addEventListener(ResourceTreeModel.Events.FrameDetached,this._frameDetached,this);const navigatedListener=resourceTreeModel.addEventListener(ResourceTreeModel.Events.FrameNavigated,this._frameNavigated,this);this._eventListeners.set(resourceTreeModel,[addListener,detachListener,navigatedListener]);this._framesForTarget.set(resourceTreeModel.target().id(),new Set());}
modelRemoved(resourceTreeModel){const listeners=this._eventListeners.get(resourceTreeModel);if(listeners){EventTarget.EventTarget.removeEventListeners(listeners);}
const frameSet=this._framesForTarget.get(resourceTreeModel.target().id());if(frameSet){for(const frameId of frameSet){this.decreaseOrRemoveFrame(frameId);}}
this._framesForTarget.delete(resourceTreeModel.target().id());}
_frameAdded(event){const frame=(event.data);const frameData=this._frames.get(frame.id);if(frameData){this._frames.set(frame.id,{frame,count:frameData.count+1});}else{this._frames.set(frame.id,{frame,count:1});}
const frameSet=this._framesForTarget.get(frame.resourceTreeModel().target().id());if(frameSet){frameSet.add(frame.id);}
this.dispatchEventToListeners(Events.FrameAddedToTarget,{frame});}
_frameDetached(event){const frame=(event.data);this.decreaseOrRemoveFrame(frame.id);const frameSet=this._framesForTarget.get(frame.resourceTreeModel().target().id());if(frameSet){frameSet.delete(frame.id);}}
_frameNavigated(event){const frame=(event.data);if(frame.isTopFrame()){this.dispatchEventToListeners(Events.TopFrameNavigated,{frame});}}
decreaseOrRemoveFrame(frameId){const frameData=this._frames.get(frameId);if(frameData){if(frameData.count===1){this._frames.delete(frameId);this.dispatchEventToListeners(Events.FrameRemoved,{frameId});}else{frameData.count--;}}}
getFrame(frameId){const frameData=this._frames.get(frameId);if(frameData){return frameData.frame;}
return null;}}
const Events={FrameAddedToTarget:Symbol('FrameAddedToTarget'),FrameRemoved:Symbol('FrameRemoved'),TopFrameNavigated:Symbol('TopFrameNavigated'),};var FrameManager$1=Object.freeze({__proto__:null,FrameManager:FrameManager,Events:Events});let issuesManagerInstance=null;class IssuesManager extends ObjectWrapper.ObjectWrapper{constructor(){super();this._eventListeners=new WeakMap();SDKModel.TargetManager.instance().observeModels(IssuesModel.IssuesModel,this);this._issues=new Map();this._hasSeenTopFrameNavigated=false;FrameManager.instance().addEventListener(Events.TopFrameNavigated,this._onTopFrameNavigated,this);}
static instance({forceNew}={forceNew:false}){if(!issuesManagerInstance||forceNew){issuesManagerInstance=new IssuesManager();}
return issuesManagerInstance;}
reloadForAccurateInformationRequired(){return!this._hasSeenTopFrameNavigated;}
_onTopFrameNavigated(event){const{frame}=(event.data);const keptIssues=new Map();for(const[key,issue]of this._issues.entries()){if(issue.isAssociatedWithRequestId(frame.loaderId)){keptIssues.set(key,issue);}}
this._issues=keptIssues;this._hasSeenTopFrameNavigated=true;this.dispatchEventToListeners(Events$1.FullUpdateRequired);this.dispatchEventToListeners(Events$1.IssuesCountUpdated);}
modelAdded(issuesModel){const listener=issuesModel.addEventListener(IssuesModel.Events.IssueAdded,this._issueAdded,this);this._eventListeners.set(issuesModel,listener);}
modelRemoved(issuesModel){const listener=this._eventListeners.get(issuesModel);if(listener){EventTarget.EventTarget.removeEventListeners([listener]);}}
_issueAdded(event){const{issuesModel,issue}=(event.data);if(!issue.getDescription()){return;}
const primaryKey=issue.primaryKey();if(this._issues.has(primaryKey)){return;}
this._issues.set(primaryKey,issue);this.dispatchEventToListeners(Events$1.IssueAdded,{issuesModel,issue});this.dispatchEventToListeners(Events$1.IssuesCountUpdated);}
issues(){return this._issues.values();}
numberOfIssues(){return this._issues.size;}}
const Events$1={IssuesCountUpdated:Symbol('IssuesCountUpdated'),IssueAdded:Symbol('IssueAdded'),FullUpdateRequired:Symbol('FullUpdateRequired'),};var IssuesManager$1=Object.freeze({__proto__:null,IssuesManager:IssuesManager,Events:Events$1});const modelToEventListeners=new WeakMap();class LogManager{constructor(){SDKModel.TargetManager.instance().observeModels(LogModel.LogModel,this);}
modelAdded(logModel){const eventListeners=[];eventListeners.push(logModel.addEventListener(LogModel.Events.EntryAdded,this._logEntryAdded,this));modelToEventListeners.set(logModel,eventListeners);}
modelRemoved(logModel){const eventListeners=modelToEventListeners.get(logModel);if(eventListeners){EventTarget.EventTarget.removeEventListeners(eventListeners);}}
_logEntryAdded(event){const data=(event.data);const target=data.logModel.target();const consoleMessage=new ConsoleModel.ConsoleMessage(target.model(RuntimeModel.RuntimeModel),data.entry.source,data.entry.level,data.entry.text,undefined,data.entry.url,data.entry.lineNumber,undefined,[data.entry.text,...(data.entry.args||[])],data.entry.stackTrace,data.entry.timestamp,undefined,undefined,data.entry.workerId);if(data.entry.networkRequestId){NetworkLog.NetworkLog.instance().associateConsoleMessageWithRequest(consoleMessage,data.entry.networkRequestId);}
if(consoleMessage.source===ConsoleModel.MessageSource.Worker){const workerId=consoleMessage.workerId||'';if(SDKModel.TargetManager.instance().targetById(workerId)){return;}
setTimeout(()=>{if(!SDKModel.TargetManager.instance().targetById(workerId)){ConsoleModel.ConsoleModel.instance().addMessage(consoleMessage);}},1000);}else{ConsoleModel.ConsoleModel.instance().addMessage(consoleMessage);}}}
var LogManager$1=Object.freeze({__proto__:null,LogManager:LogManager});let IssuesAssociatable;function issuesAssociatedWithNetworkRequest(issues,request){return issues.filter(issue=>{for(const affectedRequest of issue.requests()){if(affectedRequest.requestId===request.requestId()){return true;}}
return false;});}
function issuesAssociatedWithCookie(issues,domain,name,path){return issues.filter(issue=>{for(const cookie of issue.cookies()){if(cookie.domain===domain&&cookie.name===name&&cookie.path===path){return true;}}
return false;});}
function issuesAssociatedWith(issues,obj){if(obj instanceof NetworkRequest.NetworkRequest){return issuesAssociatedWithNetworkRequest(issues,obj);}
if(obj instanceof Cookie.Cookie){return issuesAssociatedWithCookie(issues,obj.domain(),obj.name(),obj.path());}
throw new Error(`issues can not be associated with ${obj}`);}
function hasIssues(obj){const issues=Array.from(IssuesManager.instance().issues());return issuesAssociatedWith(issues,obj).length>0;}
function hasIssueOfCategory(obj,category){const issues=Array.from(IssuesManager.instance().issues());return issuesAssociatedWith(issues,obj).some(issue=>issue.getCategory()===category);}
async function reveal(obj,category){const issues=Array.from(IssuesManager.instance().issues());const candidates=issuesAssociatedWith(issues,obj).filter(issue=>!category||issue.getCategory()===category);if(candidates.length>0){return Revealer.reveal(candidates[0]);}}
var RelatedIssue=Object.freeze({__proto__:null,IssuesAssociatable:IssuesAssociatable,issuesAssociatedWith:issuesAssociatedWith,hasIssues:hasIssues,hasIssueOfCategory:hasIssueOfCategory,reveal:reveal});const logManager=new LogManager();IssuesManager.instance();FrameManager.instance();export{FrameManager$1 as FrameManager,IssuesManager$1 as IssuesManager,LogManager$1 as LogManager,RelatedIssue,logManager};