import{UIString,ObjectWrapper}from'../common/common.js';import{InspectorFrontendHost,InspectorFrontendHostAPI,userMetrics,UserMetrics}from'../host/host.js';import{Panel,Widget,XLink,UIUtils,ListWidget}from'../ui/ui.js';import{TargetDetachedDialog}from'../components/components.js';import'../protocol_client/protocol_client.js';import{Connections,SDKModel}from'../sdk/sdk.js';class NodeConnectionsPanel extends Panel.Panel{constructor(){super('node-connection');this.registerRequiredCSS('node_main/nodeConnectionsPanel.css');this.contentElement.classList.add('node-panel');const container=this.contentElement.createChild('div','node-panel-center');const image=container.createChild('img','node-panel-logo');image.src='https://nodejs.org/static/images/logos/nodejs-new-pantone-black.svg';InspectorFrontendHost.InspectorFrontendHostInstance.events.addEventListener(InspectorFrontendHostAPI.Events.DevicesDiscoveryConfigChanged,this._devicesDiscoveryConfigChanged,this);this._config;this.contentElement.tabIndex=0;this.setDefaultFocusedElement(this.contentElement);InspectorFrontendHost.InspectorFrontendHostInstance.setDevicesUpdatesEnabled(false);InspectorFrontendHost.InspectorFrontendHostInstance.setDevicesUpdatesEnabled(true);this._networkDiscoveryView=new NodeConnectionsView(config=>{this._config.networkDiscoveryConfig=config;InspectorFrontendHost.InspectorFrontendHostInstance.setDevicesDiscoveryConfig(this._config);});this._networkDiscoveryView.show(container);}
_devicesDiscoveryConfigChanged(event){this._config=(event.data);this._networkDiscoveryView.discoveryConfigChanged(this._config.networkDiscoveryConfig);}}
class NodeConnectionsView extends Widget.VBox{constructor(callback){super();this._callback=callback;this.element.classList.add('network-discovery-view');const networkDiscoveryFooter=this.element.createChild('div','network-discovery-footer');const documentationLink=XLink.XLink.create('https://nodejs.org/en/docs/inspector/',ls`Node.js debugging guide`);networkDiscoveryFooter.appendChild(UIUtils.formatLocalized('Specify network endpoint and DevTools will connect to it automatically. Read %s to learn more.',[documentationLink]));this._list=new ListWidget.ListWidget(this);this._list.registerRequiredCSS('node_main/nodeConnectionsPanel.css');this._list.element.classList.add('network-discovery-list');const placeholder=document.createElement('div');placeholder.classList.add('network-discovery-list-empty');placeholder.textContent=UIString.UIString('No connections specified');this._list.setEmptyPlaceholder(placeholder);this._list.show(this.element);this._editor=null;const addButton=UIUtils.createTextButton(UIString.UIString('Add connection'),this._addNetworkTargetButtonClicked.bind(this),'add-network-target-button',true);this.element.appendChild(addButton);this._networkDiscoveryConfig=[];this.element.classList.add('node-frontend');}
_update(){const config=this._networkDiscoveryConfig.map(item=>item.address);this._callback.call(null,config);}
_addNetworkTargetButtonClicked(){this._list.addNewItem(this._networkDiscoveryConfig.length,{address:'',port:''});}
discoveryConfigChanged(networkDiscoveryConfig){this._networkDiscoveryConfig=[];this._list.clear();for(const address of networkDiscoveryConfig){const item={address:address,port:''};this._networkDiscoveryConfig.push(item);this._list.appendItem(item,true);}}
renderItem(rule,editable){const element=document.createElement('div');element.classList.add('network-discovery-list-item');element.createChild('div','network-discovery-value network-discovery-address').textContent=rule.address;return element;}
removeItemRequested(rule,index){this._networkDiscoveryConfig.splice(index,1);this._list.removeItem(index);this._update();}
commitEdit(rule,editor,isNew){rule.address=editor.control('address').value.trim();if(isNew){this._networkDiscoveryConfig.push(rule);}
this._update();}
beginEdit(rule){const editor=this._createEditor();editor.control('address').value=rule.address;return editor;}
_createEditor(){if(this._editor){return this._editor;}
const editor=new ListWidget.Editor();this._editor=editor;const content=editor.contentElement();const fields=content.createChild('div','network-discovery-edit-row');const input=editor.createInput('address','text',ls`Network address (e.g. localhost:9229)`,addressValidator);fields.createChild('div','network-discovery-value network-discovery-address').appendChild(input);return editor;function addressValidator(rule,index,input){const match=input.value.trim().match(/^([a-zA-Z0-9\.\-_]+):(\d+)$/);if(!match){return{valid:false};}
const port=parseInt(match[2],10);return{valid:port<=65535};}}}
var NodeConnectionsPanel$1=Object.freeze({__proto__:null,NodeConnectionsPanel:NodeConnectionsPanel,NodeConnectionsView:NodeConnectionsView});class NodeMainImpl extends ObjectWrapper.ObjectWrapper{run(){userMetrics.actionTaken(UserMetrics.Action.ConnectToNodeJSFromFrontend);Connections.initMainConnection(()=>{const target=SDKModel.TargetManager.instance().createTarget('main',UIString.UIString('Main'),SDKModel.Type.Browser,null);target.setInspectedURL('Node.js');},TargetDetachedDialog.TargetDetachedDialog.webSocketConnectionLost);}}
class NodeChildTargetManager extends SDKModel.SDKModel{constructor(parentTarget){super(parentTarget);this._targetManager=parentTarget.targetManager();this._parentTarget=parentTarget;this._targetAgent=parentTarget.targetAgent();this._childTargets=new Map();this._childConnections=new Map();parentTarget.registerTargetDispatcher(this);this._targetAgent.setDiscoverTargets(true);InspectorFrontendHost.InspectorFrontendHostInstance.events.addEventListener(InspectorFrontendHostAPI.Events.DevicesDiscoveryConfigChanged,this._devicesDiscoveryConfigChanged,this);InspectorFrontendHost.InspectorFrontendHostInstance.setDevicesUpdatesEnabled(false);InspectorFrontendHost.InspectorFrontendHostInstance.setDevicesUpdatesEnabled(true);}
_devicesDiscoveryConfigChanged(event){const config=(event.data);const locations=[];for(const address of config.networkDiscoveryConfig){const parts=address.split(':');const port=parseInt(parts[1],10);if(parts[0]&&port){locations.push({host:parts[0],port:port});}}
this._targetAgent.setRemoteLocations(locations);}
dispose(){InspectorFrontendHost.InspectorFrontendHostInstance.events.removeEventListener(InspectorFrontendHostAPI.Events.DevicesDiscoveryConfigChanged,this._devicesDiscoveryConfigChanged,this);for(const sessionId of this._childTargets.keys()){this.detachedFromTarget(sessionId,undefined);}}
targetCreated(targetInfo){if(targetInfo.type==='node'&&!targetInfo.attached){this._targetAgent.attachToTarget(targetInfo.targetId,false);}}
targetInfoChanged(targetInfo){}
targetDestroyed(targetId){}
attachedToTarget(sessionId,targetInfo,waitingForDebugger){const name=ls`Node.js: ${targetInfo.url}`;const connection=new NodeConnection(this._targetAgent,sessionId);this._childConnections.set(sessionId,connection);const target=this._targetManager.createTarget(targetInfo.targetId,name,SDKModel.Type.Node,this._parentTarget,undefined,undefined,connection);this._childTargets.set(sessionId,target);target.runtimeAgent().runIfWaitingForDebugger();}
detachedFromTarget(sessionId,childTargetId){this._childTargets.get(sessionId).dispose('target terminated');this._childTargets.delete(sessionId);this._childConnections.delete(sessionId);}
receivedMessageFromTarget(sessionId,message,childTargetId){const connection=this._childConnections.get(sessionId);const onMessage=connection?connection._onMessage:null;if(onMessage){onMessage.call(null,message);}}}
class NodeConnection{constructor(targetAgent,sessionId){this._targetAgent=targetAgent;this._sessionId=sessionId;this._onMessage=null;this._onDisconnect=null;}
setOnMessage(onMessage){this._onMessage=onMessage;}
setOnDisconnect(onDisconnect){this._onDisconnect=onDisconnect;}
sendRawMessage(message){this._targetAgent.sendMessageToTarget(message,this._sessionId);}
disconnect(){if(this._onDisconnect){this._onDisconnect.call(null,'force disconnect');}
this._onDisconnect=null;this._onMessage=null;return this._targetAgent.detachFromTarget(this._sessionId);}}
SDKModel.SDKModel.register(NodeChildTargetManager,SDKModel.Capability.Target,true);var NodeMain=Object.freeze({__proto__:null,NodeMainImpl:NodeMainImpl,NodeChildTargetManager:NodeChildTargetManager,NodeConnection:NodeConnection});export{NodeConnectionsPanel$1 as NodeConnectionsPanel,NodeMain};