import{Widget,Fragment,TabbedPane,TreeOutline,Icon,Panel}from'../ui/ui.js';import{DataGrid,SortableDataGrid}from'../data_grid/data_grid.js';import{SDKModel}from'../sdk/sdk.js';import{UIString}from'../common/common.js';let ChevronTab;class ChevronTabbedPanel extends Widget.VBox{constructor(tab_definitions){super();this.registerRequiredCSS('media/chevronTabbedPanel.css');this._chevronButtons=new Map();this._header_panel=this.contentElement.createChild('div','chevron-tabbed-panel-title');this._content_panel=this.contentElement.createChild('div','chevron-tabbed-panel-content');this._header_panel_button_container=this._header_panel.createChild('div','chevron-tabbed-panel-title-buttons');for(const accessor_id in tab_definitions){this.CreateAndAddDropdownButton(accessor_id,tab_definitions[accessor_id]);}}
CreateAndAddDropdownButton(identifier,tab){const button=this._header_panel_button_container.createChild('div','chevron-tabbed-panel-buttons-item');button.appendChild(tab.title);this._chevronButtons.set(identifier,{content:tab.element,button:button});if(this._chevronButtons.size===1){this._DisplayContentSection(tab.element);button.classList.add('selected');}
button.addEventListener('click',event=>{if(event.currentTarget.classList.contains('selected')){return;}
for(const elements of this._chevronButtons.values()){elements.button.classList.remove('selected');}
event.currentTarget.classList.add('selected');this._DisplayContentSection(tab.element);},false);}
RemoveTab(identifier,remove_all=false){const button=this._chevronButtons.get(identifier);this._chevronButtons.delete(identifier);if(!remove_all&&button.classList.contains('selected')){if(this._chevronButtons.size!==0){const new_selected=this._chevronButtons.values().next().value;new_selected.classList.add('selected');}}
this._header_panel_button_container.removeChild(button.button);}
RemoveTabs(identifiers){for(const identifier of identifiers){this.RemoveTab(identifier,true);}}
_DisplayContentSection(content_element){this._content_panel.innerHTML='';content_element.show(this._content_panel);}
GetListOfButtons(){return this._chevronButtons.keys();}
GetContentPanelByName(name){if(!this._chevronButtons.has(name)){return null;}
return this._chevronButtons.get(name).content;}
GetButtonByName(name){return this._chevronButtons.get(name).button;}}
var ChevronTabbedPanel$1=Object.freeze({__proto__:null,ChevronTab:ChevronTab,ChevronTabbedPanel:ChevronTabbedPanel});let PlayerEvent;const ProtocolTriggers={PlayerPropertiesChanged:Symbol('PlayerPropertiesChanged'),PlayerEventsAdded:Symbol('PlayerEventsAdded'),PlayerMessagesLogged:Symbol('PlayerMessagesLogged'),PlayerErrorsRaised:Symbol('PlayerErrorsRaised'),PlayersCreated:Symbol('PlayersCreated')};class MediaModel extends SDKModel.SDKModel{constructor(target){super(target);this._enabled=false;this._agent=target.mediaAgent();target.registerMediaDispatcher(this);}
resumeModel(){if(!this._enabled){return Promise.resolve();}
return this._agent.enable();}
ensureEnabled(){this._agent.enable();this._enabled=true;}
playerPropertiesChanged(playerId,properties){this.dispatchEventToListeners(ProtocolTriggers.PlayerPropertiesChanged,{playerId:playerId,properties:properties});}
playerEventsAdded(playerId,events){this.dispatchEventToListeners(ProtocolTriggers.PlayerEventsAdded,{playerId:playerId,events:events});}
playerMessagesLogged(playerId,messages){this.dispatchEventToListeners(ProtocolTriggers.PlayerMessagesLogged,{playerId:playerId,messages:messages});}
playerErrorsRaised(playerId,errors){this.dispatchEventToListeners(ProtocolTriggers.PlayerErrorsRaised,{playerId:playerId,errors:errors});}
playersCreated(playerIds){this.dispatchEventToListeners(ProtocolTriggers.PlayersCreated,playerIds);}}
SDKModel.SDKModel.register(MediaModel,SDKModel.Capability.DOM,false);var MediaModel$1=Object.freeze({__proto__:null,PlayerEvent:PlayerEvent,ProtocolTriggers:ProtocolTriggers,MediaModel:MediaModel});let EventDisplayColumnConfig;const MediaEventColumnKeys={Timestamp:'displayTimestamp',Event:'event',Value:'value'};class EventNode extends DataGrid.DataGridNode{constructor(event){super(event,false);this._expandableElement=null;}
createCell(columnId){const cell=this.createTD(columnId);const cellData=(this.data[columnId]);if(columnId===MediaEventColumnKeys.Value){const enclosed=cell.createChild('div','event-display-table-contents-json-wrapper');this._expandableElement=new SourceFrame.JSONView(new SourceFrame.ParsedJSON(cellData,'',''),true);this._expandableElement.markAsRoot();this._expandableElement.show(enclosed);}else{cell.classList.add('event-display-table-basic-text-table-entry');cell.createTextChild(cellData);}
return cell;}}
class PlayerEventsView extends Widget.VBox{constructor(){super();this.registerRequiredCSS('media/eventDisplayTable.css');this.contentElement.classList.add('event-display-table-contents-table-container');this._dataGrid=this._createDataGrid([{id:MediaEventColumnKeys.Timestamp,title:ls`Timestamp`,weight:1,sortingFunction:SortableDataGrid.SortableDataGrid.NumericComparator.bind(null,MediaEventColumnKeys.Timestamp)},{id:MediaEventColumnKeys.Event,title:ls`Event Name`,weight:2},{id:MediaEventColumnKeys.Value,title:ls`Value`,weight:7}]);this._firstEventTime=0;this._dataGrid.setStriped(true);this._dataGrid.asWidget().show(this.contentElement);}
_createDataGrid(headers){const gridColumnDescs=[];for(const headerDesc of headers){gridColumnDescs.push(PlayerEventsView._convertToGridDescriptor(headerDesc));}
const datagrid=new DataGrid.DataGridImpl({displayName:ls`Event Display`,columns:gridColumnDescs});datagrid.asWidget().contentElement.classList.add('no-border-top-datagrid');return datagrid;}
onEvent(event){if(this._firstEventTime===0){this._firstEventTime=event.timestamp;}
event=this._subtractFirstEventTime(event);const stringified=(event.value);try{const json=JSON.parse(stringified);event.event=json.event;delete json['event'];event.value=json;const node=new EventNode(event);this._dataGrid.rootNode().appendChild(node);}catch(e){}}
_subtractFirstEventTime(event){event.displayTimestamp=(event.timestamp-this._firstEventTime).toFixed(3);return event;}
static _convertToGridDescriptor(columnConfig){return({id:columnConfig.id,title:columnConfig.title,sortable:columnConfig.sortable,weight:columnConfig.weight||0,sort:DataGrid.Order.Ascending});}}
var EventDisplayTable=Object.freeze({__proto__:null,EventDisplayColumnConfig:EventDisplayColumnConfig,MediaEventColumnKeys:MediaEventColumnKeys,EventNode:EventNode,PlayerEventsView:PlayerEventsView});const PlayerPropertyKeys={kResolution:'kResolution',kTotalBytes:'kTotalBytes',kBitrate:'kBitrate',kMaxDuration:'kMaxDuration',kStartTime:'kStartTime',kIsVideoEncrypted:'kIsVideoEncrypted',kIsStreaming:'kIsStreaming',kFrameUrl:'kFrameUrl',kFrameTitle:'kFrameTitle',kIsSingleOrigin:'kIsSingleOrigin',kIsRangeHeaderSupported:'kIsRangeHeaderSupported',kVideoDecoderName:'kVideoDecoderName',kAudioDecoderName:'kAudioDecoderName',kIsPlatformVideoDecoder:'kIsPlatformVideoDecoder',kIsPlatformAudioDecoder:'kIsPlatformAudioDecoder',kIsVideoDecryptingDemuxerStream:'kIsVideoDecryptingDemuxerStream',kIsAudioDecryptingDemuxerStream:'kIsAudioDecryptingDemuxerStream',kAudioTracks:'kAudioTracks',kVideoTracks:'kVideoTracks',kFramerate:'kFramerate',kVideoPlaybackRoughness:'kVideoPlaybackRoughness',};class PropertyRenderer extends Widget.VBox{constructor(title){super();this.contentElement.classList.add('media-property-renderer');this._title=this.contentElement.createChild('span','media-property-renderer-title');this._contents=this.contentElement.createChild('span','media-property-renderer-contents');this._title.createTextChild(title);this._title=title;this._value=null;this._pseudo_color_protection_element=null;this.contentElement.classList.add('media-property-renderer-hidden');}
updateData(propname,propvalue){if(propvalue===''||propvalue===null){return this._updateData(propname,null);}
try{propvalue=JSON.parse(propvalue);}catch(err){}
return this._updateData(propname,propvalue);}
_updateData(propname,propvalue){if(propvalue===null){this.changeContents(null);}else if(this._value===propvalue){return;}else{this._value=propvalue;this.changeContents(propvalue);}}
changeContents(value){if(value===null){this.contentElement.classList.add('media-property-renderer-hidden');if(this._pseudo_color_protection_element===null){this._pseudo_color_protection_element=document.createElement('div');this._pseudo_color_protection_element.classList.add('media-property-renderer');this._pseudo_color_protection_element.classList.add('media-property-renderer-hidden');this.contentElement.parentNode.insertBefore(this._pseudo_color_protection_element,this.contentElement);}}else{if(this._pseudo_color_protection_element!==null){this._pseudo_color_protection_element.remove();this._pseudo_color_protection_element=null;}
this.contentElement.classList.remove('media-property-renderer-hidden');this._contents.removeChildren();const spanElement=createElement('span');spanElement.textContent=value;this._contents.appendChild(spanElement);}}}
class FormattedPropertyRenderer extends PropertyRenderer{constructor(title,formatfunction){super(UIString.UIString(title));this._formatfunction=formatfunction;}
_updateData(propname,propvalue){if(propvalue===null){this.changeContents(null);}else{this.changeContents(this._formatfunction(propvalue));}}}
class DefaultPropertyRenderer extends PropertyRenderer{constructor(title,default_text){super(UIString.UIString(title));this.changeContents(default_text);}}
class DimensionPropertyRenderer extends PropertyRenderer{constructor(title){super(UIString.UIString(title));this._width=0;this._height=0;}
_updateData(propname,propvalue){let needsUpdate=false;if(propname==='width'&&propvalue!==this._width){this._width=propvalue;needsUpdate=true;}
if(propname==='height'&&propvalue!==this._height){this._height=propvalue;needsUpdate=true;}
if(this._width===0||this._height===0){this.changeContents(null);}else if(needsUpdate){this.changeContents(`${this._width}×${this._height}`);}}}
class AttributesView extends Widget.VBox{constructor(elements){super();this.contentElement.classList.add('media-attributes-view');for(const element of elements){element.show(this.contentElement);}}}
class TrackManager{constructor(propertiesView,type){this._type=type;this._view=propertiesView;this._previousTabs=[];}
updateData(name,value){const tabs=this._view.GetTabs(this._type);tabs.RemoveTabs(this._previousTabs);const newTabs=(JSON.parse(value));let enumerate=1;for(const tabData of newTabs){this.addNewTab(tabs,tabData,enumerate);enumerate++;}}
addNewTab(tabs,data,index){}}
class VideoTrackManager extends TrackManager{constructor(propertiesView){super(propertiesView,'video');}
addNewTab(tabs,tabData,tabNumber){const tabElements=[];for(const[name,data]of Object.entries(tabData)){tabElements.push(new DefaultPropertyRenderer(name,data));}
const newTab=new AttributesView(tabElements);tabs.CreateAndAddDropdownButton('tab_'+tabNumber,{title:Fragment.html`Track #${tabNumber}`,element:newTab});}}
class AudioTrackManager extends TrackManager{constructor(propertiesView){super(propertiesView,'audio');}
addNewTab(tabs,tabData,tabNumber){const tabElements=[];for(const[name,data]of Object.entries(tabData)){tabElements.push(new DefaultPropertyRenderer(name,data));}
const newtab=new AttributesView(tabElements);tabs.CreateAndAddDropdownButton('tab_'+tabNumber,{title:Fragment.html`Track #${tabNumber}`,element:newtab});}}
class PlayerPropertiesView extends Widget.VBox{constructor(){super();this.contentElement.classList.add('media-properties-frame');this.registerRequiredCSS('media/playerPropertiesView.css');this.populateAttributesAndElements();this._videoProperties=new AttributesView(this._mediaElements);this._videoDecoderProperties=new AttributesView(this._videoDecoderElements);this._audioDecoderProperties=new AttributesView(this._audioDecoderElements);const video=new ChevronTabbedPanel({tab:{title:Fragment.html`Media`,element:this._videoProperties}});video.contentElement.classList.add('media-properties-view');video.show(this.contentElement);this._videoDecoderTab=new ChevronTabbedPanel({tab:{title:Fragment.html`Video Decoder`,element:this._videoDecoderProperties}});this._videoDecoderTab.contentElement.classList.add('media-properties-view');this._videoDecoderTab.show(this.contentElement);this._audioDecoderTab=new ChevronTabbedPanel({tab:{title:Fragment.html`Audio Decoder`,element:this._audioDecoderProperties}});this._audioDecoderTab.contentElement.classList.add('media-properties-view');this._audioDecoderTab.show(this.contentElement);}
GetTabs(type){if(type==='audio'){return this._audioDecoderTab;}
if(type==='video'){return this._videoDecoderTab;}
throw new Error('Unreachable');}
onProperty(property){const renderer=this._attributeMap.get(property.name);if(!renderer){throw new Error(`PlayerProperty ${property.name} not supported.`);}
renderer.updateData(property.name,property.value);}
formatKbps(bitsPerSecond){if(bitsPerSecond===''){return'0 kbps';}
const kbps=Math.floor(bitsPerSecond/1000);return`${kbps} kbps`;}
formatTime(seconds){if(seconds===''){return'0:00';}
const date=new Date(null);date.setSeconds(seconds);return date.toISOString().substr(11,8);}
formatFileSize(bytes){if(bytes===''){return'0 bytes';}
const power=Math.floor(Math.log(bytes)/Math.log(1024));const suffix=['bytes','kB','MB','GB','TB'][power];const bytesDecimal=(bytes/Math.pow(1000,power)).toFixed(2);return`${bytesDecimal} ${suffix}`;}
populateAttributesAndElements(){this._mediaElements=[];this._videoDecoderElements=[];this._audioDecoderElements=[];this._attributeMap=new Map();const resolution=new PropertyRenderer(ls`Resolution`);this._mediaElements.push(resolution);this._attributeMap.set(PlayerPropertyKeys.kResolution,resolution);const fileSize=new FormattedPropertyRenderer(ls`File Size`,this.formatFileSize);this._mediaElements.push(fileSize);this._attributeMap.set(PlayerPropertyKeys.kTotalBytes,fileSize);const bitrate=new FormattedPropertyRenderer(ls`Bitrate`,this.formatKbps);this._mediaElements.push(bitrate);this._attributeMap.set(PlayerPropertyKeys.kBitrate,bitrate);const duration=new FormattedPropertyRenderer(ls`Duration`,this.formatTime);this._mediaElements.push(duration);this._attributeMap.set(PlayerPropertyKeys.kMaxDuration,duration);const startTime=new PropertyRenderer(ls`Start Time`);this._mediaElements.push(startTime);this._attributeMap.set(PlayerPropertyKeys.kStartTime,startTime);const streaming=new PropertyRenderer(ls`Streaming`);this._mediaElements.push(streaming);this._attributeMap.set(PlayerPropertyKeys.kIsStreaming,streaming);const frameUrl=new PropertyRenderer(ls`Playback Frame URL`);this._mediaElements.push(frameUrl);this._attributeMap.set(PlayerPropertyKeys.kFrameUrl,frameUrl);const frameTitle=new PropertyRenderer(ls`Playback Frame Title`);this._mediaElements.push(frameTitle);this._attributeMap.set(PlayerPropertyKeys.kFrameTitle,frameTitle);const singleOrigin=new PropertyRenderer(ls`Is Single Origin Playback`);this._mediaElements.push(singleOrigin);this._attributeMap.set(PlayerPropertyKeys.kIsSingleOrigin,singleOrigin);const rangeHeaders=new PropertyRenderer(ls`Range Header Support`);this._mediaElements.push(rangeHeaders);this._attributeMap.set(PlayerPropertyKeys.kIsRangeHeaderSupported,rangeHeaders);const frameRate=new PropertyRenderer(ls`Frame Rate`);this._mediaElements.push(frameRate);this._attributeMap.set(PlayerPropertyKeys.kFramerate,frameRate);const roughness=new PropertyRenderer(ls`Video Playback Roughness`);this._mediaElements.push(roughness);this._attributeMap.set(PlayerPropertyKeys.kVideoPlaybackRoughness,roughness);const decoderName=new DefaultPropertyRenderer(ls`Decoder Name`,ls`No Decoder`);this._videoDecoderElements.push(decoderName);this._attributeMap.set(PlayerPropertyKeys.kVideoDecoderName,decoderName);const videoPlatformDecoder=new PropertyRenderer(ls`Hardware Decoder`);this._videoDecoderElements.push(videoPlatformDecoder);this._attributeMap.set(PlayerPropertyKeys.kIsPlatformVideoDecoder,videoPlatformDecoder);const videoDDS=new PropertyRenderer(ls`Decrypting Demuxer`);this._videoDecoderElements.push(videoDDS);this._attributeMap.set(PlayerPropertyKeys.kIsVideoDecryptingDemuxerStream,videoDDS);const videoTrackManager=new VideoTrackManager(this);this._attributeMap.set(PlayerPropertyKeys.kVideoTracks,videoTrackManager);const audioDecoder=new DefaultPropertyRenderer(ls`Decoder Name`,ls`No Decoder`);this._audioDecoderElements.push(audioDecoder);this._attributeMap.set(PlayerPropertyKeys.kAudioDecoderName,audioDecoder);const audioPlatformDecoder=new PropertyRenderer(ls`Hardware Decoder`);this._audioDecoderElements.push(audioPlatformDecoder);this._attributeMap.set(PlayerPropertyKeys.kIsPlatformAudioDecoder,audioPlatformDecoder);const audioDDS=new PropertyRenderer(ls`Decrypting Demuxer`);this._audioDecoderElements.push(audioDDS);this._attributeMap.set(PlayerPropertyKeys.kIsAudioDecryptingDemuxerStream,audioDDS);const audioTrackManager=new AudioTrackManager(this);this._attributeMap.set(PlayerPropertyKeys.kAudioTracks,audioTrackManager);}}
var PlayerPropertiesView$1=Object.freeze({__proto__:null,PlayerPropertyKeys:PlayerPropertyKeys,PropertyRenderer:PropertyRenderer,FormattedPropertyRenderer:FormattedPropertyRenderer,DefaultPropertyRenderer:DefaultPropertyRenderer,DimensionPropertyRenderer:DimensionPropertyRenderer,AttributesView:AttributesView,TrackManager:TrackManager,VideoTrackManager:VideoTrackManager,AudioTrackManager:AudioTrackManager,PlayerPropertiesView:PlayerPropertiesView});const PlayerDetailViewTabs={Events:'events',Properties:'properties',};class PlayerDetailView extends TabbedPane.TabbedPane{constructor(){super();this._eventView=new PlayerEventsView();this._propertyView=new PlayerPropertiesView();this.appendTab(PlayerDetailViewTabs.Properties,UIString.UIString('Properties'),this._propertyView,UIString.UIString('Player properties'));this.appendTab(PlayerDetailViewTabs.Events,UIString.UIString('Events'),this._eventView,UIString.UIString('Player events'));}
onProperty(property){this._propertyView.onProperty(property);}
onError(error){}
onMessage(message){}
onEvent(event){this._eventView.onEvent(event);}}
var PlayerDetailView$1=Object.freeze({__proto__:null,PlayerDetailViewTabs:PlayerDetailViewTabs,PlayerDetailView:PlayerDetailView});let PlayerStatus;let PlayerStatusMapElement;class PlayerEntryTreeElement extends TreeOutline.TreeElement{constructor(playerStatus,displayContainer){super(playerStatus.playerTitle,false);this.titleFromUrl=true;this._playerStatus=playerStatus;this._displayContainer=displayContainer;this.setLeadingIcons([Icon.Icon.create('smallicon-videoplayer-playing','media-player')]);this.listItemElement.classList.add('player-entry-tree-element');}
onselect(selectedByUser){this._displayContainer.renderMainPanel(this._playerStatus.playerID);return true;}}
class PlayerListView extends Widget.VBox{constructor(mainContainer){super(true);this._playerStatuses=new Map();this._mainContainer=mainContainer;this._sidebarTree=new TreeOutline.TreeOutlineInShadow();this.contentElement.appendChild(this._sidebarTree.element);this._sidebarTree.registerRequiredCSS('media/playerListView.css');this._audioDevices=this._addListSection(Common.UIString('Audio I/O'));this._videoDevices=this._addListSection(Common.UIString('Video Capture Devices'));this._playerList=this._addListSection(Common.UIString('Players'));this._playerList.listItemElement.classList.add('player-entry-header');}
_addListSection(title){const treeElement=new TreeOutline.TreeElement(title,true);treeElement.listItemElement.classList.add('storage-group-list-item');treeElement.setCollapsible(false);treeElement.selectable=false;this._sidebarTree.appendChild(treeElement);return treeElement;}
addMediaElementItem(playerID){const playerStatus={playerTitle:playerID,playerID:playerID,exists:true,playing:false,titleEdited:false};const playerElement=new PlayerEntryTreeElement(playerStatus,this._mainContainer);this._playerStatuses.set(playerID,playerElement);this._playerList.appendChild(playerElement);}
setMediaElementPlayerTitle(playerID,newTitle,isTitleExtractedFromUrl){if(this._playerStatuses.has(playerID)){const sidebarEntry=this._playerStatuses.get(playerID);if(!isTitleExtractedFromUrl||sidebarEntry.titleFromUrl){sidebarEntry.title=newTitle;sidebarEntry.titleFromUrl=isTitleExtractedFromUrl;}}}
setMediaElementPlayerIcon(playerID,iconName){if(this._playerStatuses.has(playerID)){const sidebarEntry=this._playerStatuses.get(playerID);sidebarEntry.setLeadingIcons([Icon.Icon.create('smallicon-videoplayer-'+iconName,'media-player')]);}}
onProperty(playerID,property){if(property.name===PlayerPropertyKeys.kFrameTitle&&property.value){this.setMediaElementPlayerTitle(playerID,(property.value),false);}
if(property.name===PlayerPropertyKeys.kFrameUrl){const url_path_component=property.value.substring(property.value.lastIndexOf('/')+1);this.setMediaElementPlayerTitle(playerID,url_path_component,true);}}
onError(playerID,error){}
onMessage(playerID,message){}
onEvent(playerID,event){if(event.value==='PLAY'){this.setMediaElementPlayerIcon(playerID,'playing');}else if(event.value==='PAUSE'){this.setMediaElementPlayerIcon(playerID,'paused');}else if(event.value==='WEBMEDIAPLAYER_DESTROYED'){this.setMediaElementPlayerIcon(playerID,'destroyed');}}}
var PlayerListView$1=Object.freeze({__proto__:null,PlayerStatus:PlayerStatus,PlayerStatusMapElement:PlayerStatusMapElement,PlayerEntryTreeElement:PlayerEntryTreeElement,PlayerListView:PlayerListView});class TriggerHandler{onProperty(property){}
onError(error){}
onMessage(message){}
onEvent(event){}}
class TriggerDispatcher{onProperty(playerID,property){}
onError(playerID,error){}
onMessage(playerID,message){}
onEvent(playerID,event){}}
class MainView extends Panel.PanelWithSidebar{constructor(){super('Media');this.registerRequiredCSS('media/mediaView.css');this._detailPanels=new Map();this._deletedPlayers=new Set();this._sidebar=new PlayerListView(this);this._sidebar.show(this.panelSidebarElement());SDKModel.TargetManager.instance().observeModels(MediaModel,this);}
renderMainPanel(playerID){if(!this._detailPanels.has(playerID)){return;}
this.splitWidget().mainWidget().detachChildWidgets();this._detailPanels.get(playerID).show(this.mainElement());}
wasShown(){super.wasShown();for(const model of SDKModel.TargetManager.instance().models(MediaModel)){this._addEventListeners(model);}}
willHide(){for(const model of SDKModel.TargetManager.instance().models(MediaModel)){this._removeEventListeners(model);}}
modelAdded(mediaModel){if(this.isShowing()){this._addEventListeners(mediaModel);}}
modelRemoved(mediaModel){this._removeEventListeners(mediaModel);}
_addEventListeners(mediaModel){mediaModel.ensureEnabled();mediaModel.addEventListener(ProtocolTriggers.PlayerPropertiesChanged,this._propertiesChanged,this);mediaModel.addEventListener(ProtocolTriggers.PlayerEventsAdded,this._eventsAdded,this);mediaModel.addEventListener(ProtocolTriggers.PlayerMessagesLogged,this._messagesLogged,this);mediaModel.addEventListener(ProtocolTriggers.PlayerErrorsRaised,this._errorsRaised,this);mediaModel.addEventListener(ProtocolTriggers.PlayersCreated,this._playersCreated,this);}
_removeEventListeners(mediaModel){mediaModel.removeEventListener(ProtocolTriggers.PlayerPropertiesChanged,this._propertiesChanged,this);mediaModel.removeEventListener(ProtocolTriggers.PlayerEventsAdded,this._eventsAdded,this);mediaModel.removeEventListener(ProtocolTriggers.PlayerMessagesLogged,this._messagesLogged,this);mediaModel.removeEventListener(ProtocolTriggers.PlayerErrorsRaised,this._errorsRaised,this);mediaModel.removeEventListener(ProtocolTriggers.PlayersCreated,this._playersCreated,this);}
_onPlayerCreated(playerID){this._sidebar.addMediaElementItem(playerID);this._detailPanels.set(playerID,new PlayerDetailView());}
_propertiesChanged(event){for(const property of event.data.properties){this.onProperty(event.data.playerId,property);}}
_eventsAdded(event){for(const ev of event.data.events){this.onEvent(event.data.playerId,ev);}}
_messagesLogged(event){for(const message of event.data.messages){this.onMessage(event.data.playerId,message);}}
_errorsRaised(event){for(const error of event.data.errors){this.onError(event.data.playerId,error);}}
_shouldPropagate(playerID){return!this._deletedPlayers.has(playerID)&&this._detailPanels.has(playerID);}
onProperty(playerID,property){if(!this._shouldPropagate(playerID)){return;}
this._sidebar.onProperty(playerID,property);this._detailPanels.get(playerID).onProperty(property);}
onError(playerID,error){if(!this._shouldPropagate(playerID)){return;}
this._sidebar.onError(playerID,error);this._detailPanels.get(playerID).onError(error);}
onMessage(playerID,message){if(!this._shouldPropagate(playerID)){return;}
this._sidebar.onMessage(playerID,message);this._detailPanels.get(playerID).onMessage(message);}
onEvent(playerID,event){if(!this._shouldPropagate(playerID)){return;}
this._sidebar.onEvent(playerID,event);this._detailPanels.get(playerID).onEvent(event);}
_playersCreated(event){const playerlist=(event.data);for(const playerID of playerlist){this._onPlayerCreated(playerID);}}}
var MainView$1=Object.freeze({__proto__:null,TriggerHandler:TriggerHandler,TriggerDispatcher:TriggerDispatcher,MainView:MainView});export{ChevronTabbedPanel$1 as ChevronTabbedPanel,MainView$1 as MainView,MediaModel$1 as MediaModel,PlayerDetailView$1 as PlayerDetailView,EventDisplayTable as PlayerEventsView,PlayerListView$1 as PlayerListView,PlayerPropertiesView$1 as PlayerPropertiesView};