import{UIString,ParsedURL,Settings,ObjectWrapper,Revealer,Throttler,Console as Console$1}from'../common/common.js';import{SDKModel,RuntimeModel,ResourceTreeModel,DebuggerModel,OverlayModel,ConsoleModel,NetworkLog,RemoteObject,DOMModel,NetworkManager}from'../sdk/sdk.js';import{ListModel,SoftDropDown,Toolbar,Utils,ARIAUtils,UIUtils,Icon,TreeOutline,ContextMenu,ThrottledWidget,Fragment,TextEditor,KeyboardShortcut,Widget,SearchableView,SplitWidget,ViewManager,Infobar,ProgressIndicator,FilterSuggestionBuilder,SyntaxHighlighter,Panel,GlassPane}from'../ui/ui.js';import{TextRange,TextUtils}from'../text_utils/text_utils.js';import{Linkifier,JSPresentationUtils}from'../components/components.js';import{SortableDataGrid}from'../data_grid/data_grid.js';import{RemoteObjectPreviewFormatter,CustomPreviewComponent,ObjectPropertiesSection,JavaScriptAutocomplete,JavaScriptREPL}from'../object_ui/object_ui.js';import{StringUtilities,NumberUtilities}from'../platform/platform.js';import{userMetrics,UserMetrics,InspectorFrontendHost,Platform}from'../host/host.js';import{FileUtils}from'../bindings/bindings.js';import{IssuesManager}from'../browser_sdk/browser_sdk.js';class ConsoleContextSelector{constructor(){this._items=new ListModel.ListModel();this._dropDown=new SoftDropDown.SoftDropDown(this._items,this);this._dropDown.setRowHeight(36);this._toolbarItem=new Toolbar.ToolbarItem(this._dropDown.element);this._toolbarItem.setEnabled(false);this._toolbarItem.setTitle(ls`JavaScript context: Not selected`);this._items.addEventListener(ListModel.Events.ItemsReplaced,()=>this._toolbarItem.setEnabled(!!this._items.length));this._toolbarItem.element.classList.add('toolbar-has-dropdown');SDKModel.TargetManager.instance().addModelListener(RuntimeModel.RuntimeModel,RuntimeModel.Events.ExecutionContextCreated,this._onExecutionContextCreated,this);SDKModel.TargetManager.instance().addModelListener(RuntimeModel.RuntimeModel,RuntimeModel.Events.ExecutionContextChanged,this._onExecutionContextChanged,this);SDKModel.TargetManager.instance().addModelListener(RuntimeModel.RuntimeModel,RuntimeModel.Events.ExecutionContextDestroyed,this._onExecutionContextDestroyed,this);SDKModel.TargetManager.instance().addModelListener(ResourceTreeModel.ResourceTreeModel,ResourceTreeModel.Events.FrameNavigated,this._frameNavigated,this);self.UI.context.addFlavorChangeListener(RuntimeModel.ExecutionContext,this._executionContextChangedExternally,this);self.UI.context.addFlavorChangeListener(DebuggerModel.CallFrame,this._callFrameSelectedInUI,this);SDKModel.TargetManager.instance().observeModels(RuntimeModel.RuntimeModel,this);SDKModel.TargetManager.instance().addModelListener(DebuggerModel.DebuggerModel,DebuggerModel.Events.CallFrameSelected,this._callFrameSelectedInModel,this);}
toolbarItem(){return this._toolbarItem;}
highlightedItemChanged(from,to,fromElement,toElement){OverlayModel.OverlayModel.hideDOMNodeHighlight();if(to&&to.frameId){const overlayModel=to.target().model(OverlayModel.OverlayModel);if(overlayModel){overlayModel.highlightFrame(to.frameId);}}
if(fromElement){fromElement.classList.remove('highlighted');}
if(toElement){toElement.classList.add('highlighted');}}
titleFor(executionContext){const target=executionContext.target();let label=executionContext.label()?target.decorateLabel(executionContext.label()):'';if(executionContext.frameId){const resourceTreeModel=target.model(ResourceTreeModel.ResourceTreeModel);const frame=resourceTreeModel&&resourceTreeModel.frameForId(executionContext.frameId);if(frame){label=label||frame.displayName();}}
label=label||executionContext.origin;return label;}
_depthFor(executionContext){let target=executionContext.target();let depth=0;if(!executionContext.isDefault){depth++;}
if(executionContext.frameId){const resourceTreeModel=target.model(ResourceTreeModel.ResourceTreeModel);let frame=resourceTreeModel&&resourceTreeModel.frameForId(executionContext.frameId);while(frame){frame=frame.parentFrame||frame.crossTargetParentFrame();if(frame){depth++;target=frame.resourceTreeModel().target();}}}
let targetDepth=0;while(target.parentTarget()&&target.type()!==SDKModel.Type.ServiceWorker){targetDepth++;target=target.parentTarget();}
depth+=targetDepth;return depth;}
_executionContextCreated(executionContext){this._items.insertWithComparator(executionContext,executionContext.runtimeModel.executionContextComparator());if(executionContext===self.UI.context.flavor(RuntimeModel.ExecutionContext)){this._dropDown.selectItem(executionContext);}}
_onExecutionContextCreated(event){const executionContext=(event.data);this._executionContextCreated(executionContext);}
_onExecutionContextChanged(event){const executionContext=(event.data);if(this._items.indexOf(executionContext)===-1){return;}
this._executionContextDestroyed(executionContext);this._executionContextCreated(executionContext);}
_executionContextDestroyed(executionContext){const index=this._items.indexOf(executionContext);if(index===-1){return;}
this._items.remove(index);}
_onExecutionContextDestroyed(event){const executionContext=(event.data);this._executionContextDestroyed(executionContext);}
_executionContextChangedExternally(event){const executionContext=(event.data);this._dropDown.selectItem(executionContext);}
_isTopContext(executionContext){if(!executionContext||!executionContext.isDefault){return false;}
const resourceTreeModel=executionContext.target().model(ResourceTreeModel.ResourceTreeModel);const frame=executionContext.frameId&&resourceTreeModel&&resourceTreeModel.frameForId(executionContext.frameId);if(!frame){return false;}
return frame.isTopFrame();}
_hasTopContext(){return this._items.some(executionContext=>this._isTopContext(executionContext));}
modelAdded(runtimeModel){runtimeModel.executionContexts().forEach(this._executionContextCreated,this);}
modelRemoved(runtimeModel){for(let i=this._items.length-1;i>=0;i--){if(this._items.at(i).runtimeModel===runtimeModel){this._executionContextDestroyed(this._items.at(i));}}}
createElementForItem(item){const element=document.createElement('div');const shadowRoot=Utils.createShadowRootWithCoreStyles(element,'console/consoleContextSelector.css');const title=shadowRoot.createChild('div','title');title.createTextChild(this.titleFor(item).trimEndWithMaxLength(100));const subTitle=shadowRoot.createChild('div','subtitle');subTitle.createTextChild(this._subtitleFor(item));element.style.paddingLeft=(8+this._depthFor(item)*15)+'px';return element;}
_subtitleFor(executionContext){const target=executionContext.target();let frame;if(executionContext.frameId){const resourceTreeModel=target.model(ResourceTreeModel.ResourceTreeModel);frame=resourceTreeModel&&resourceTreeModel.frameForId(executionContext.frameId);}
if(executionContext.origin.startsWith('chrome-extension://')){return UIString.UIString('Extension');}
if(!frame||!frame.parentFrame||frame.parentFrame.securityOrigin!==executionContext.origin){const url=ParsedURL.ParsedURL.fromString(executionContext.origin);if(url){return url.domain();}}
if(frame){const callFrame=frame.findCreationCallFrame(callFrame=>!!callFrame.url);if(callFrame){return new ParsedURL.ParsedURL(callFrame.url).domain();}
return UIString.UIString('IFrame');}
return'';}
isItemSelectable(item){const callFrame=item.debuggerModel.selectedCallFrame();const callFrameContext=callFrame&&callFrame.script.executionContext();return!callFrameContext||item===callFrameContext;}
itemSelected(item){this._toolbarItem.element.classList.toggle('warning',!this._isTopContext(item)&&this._hasTopContext());const title=item?ls`JavaScript context: ${this.titleFor(item)}`:ls`JavaScript context: Not selected`;this._toolbarItem.setTitle(title);self.UI.context.setFlavor(RuntimeModel.ExecutionContext,item);}
_callFrameSelectedInUI(){const callFrame=self.UI.context.flavor(DebuggerModel.CallFrame);const callFrameContext=callFrame&&callFrame.script.executionContext();if(callFrameContext){self.UI.context.setFlavor(RuntimeModel.ExecutionContext,callFrameContext);}}
_callFrameSelectedInModel(event){const debuggerModel=(event.data);for(const executionContext of this._items){if(executionContext.debuggerModel===debuggerModel){this._dropDown.refreshItem(executionContext);}}}
_frameNavigated(event){const frame=(event.data);const runtimeModel=frame.resourceTreeModel().target().model(RuntimeModel.RuntimeModel);if(!runtimeModel){return;}
for(const executionContext of runtimeModel.executionContexts()){if(frame.id===executionContext.frameId){this._dropDown.refreshItem(executionContext);}}}}
var ConsoleContextSelector$1=Object.freeze({__proto__:null,ConsoleContextSelector:ConsoleContextSelector});class ConsoleViewport{constructor(provider){this.element=createElement('div');this.element.style.overflow='auto';this._topGapElement=this.element.createChild('div');this._topGapElement.style.height='0px';this._topGapElement.style.color='transparent';this._contentElement=this.element.createChild('div');this._bottomGapElement=this.element.createChild('div');this._bottomGapElement.style.height='0px';this._bottomGapElement.style.color='transparent';this._topGapElement.textContent='\uFEFF';this._bottomGapElement.textContent='\uFEFF';ARIAUtils.markAsHidden(this._topGapElement);ARIAUtils.markAsHidden(this._bottomGapElement);this._provider=provider;this.element.addEventListener('scroll',this._onScroll.bind(this),false);this.element.addEventListener('copy',this._onCopy.bind(this),false);this.element.addEventListener('dragstart',this._onDragStart.bind(this),false);this._contentElement.addEventListener('focusin',this._onFocusIn.bind(this),false);this._contentElement.addEventListener('focusout',this._onFocusOut.bind(this),false);this._contentElement.addEventListener('keydown',this._onKeyDown.bind(this),false);this._virtualSelectedIndex=-1;this._contentElement.tabIndex=-1;this._firstActiveIndex=-1;this._lastActiveIndex=-1;this._renderedItems=[];this._anchorSelection=null;this._headSelection=null;this._itemCount=0;this._cumulativeHeights=new Int32Array(0);this._muteCopyHandler=false;this._observer=new MutationObserver(this.refresh.bind(this));this._observerConfig={childList:true,subtree:true};}
stickToBottom(){return this._stickToBottom;}
setStickToBottom(value){this._stickToBottom=value;if(this._stickToBottom){this._observer.observe(this._contentElement,this._observerConfig);}else{this._observer.disconnect();}}
hasVirtualSelection(){return this._virtualSelectedIndex!==-1;}
copyWithStyles(){this._muteCopyHandler=true;this.element.ownerDocument.execCommand('copy');this._muteCopyHandler=false;}
_onCopy(event){if(this._muteCopyHandler){return;}
const text=this._selectedText();if(!text){return;}
event.preventDefault();event.clipboardData.setData('text/plain',text);}
_onFocusIn(event){const renderedIndex=this._renderedItems.findIndex(item=>item.element().isSelfOrAncestor(event.target));if(renderedIndex!==-1){this._virtualSelectedIndex=this._firstActiveIndex+renderedIndex;}
let focusLastChild=false;if(this._virtualSelectedIndex===-1&&this._isOutsideViewport((event.relatedTarget))&&event.target===this._contentElement&&this._itemCount){focusLastChild=true;this._virtualSelectedIndex=this._itemCount-1;this.refresh();this.scrollItemIntoView(this._virtualSelectedIndex);}
this._updateFocusedItem(focusLastChild);}
_onFocusOut(event){if(this._isOutsideViewport((event.relatedTarget))){this._virtualSelectedIndex=-1;}
this._updateFocusedItem();}
_isOutsideViewport(element){return!!element&&!element.isSelfOrDescendant(this._contentElement);}
_onDragStart(event){const text=this._selectedText();if(!text){return false;}
event.dataTransfer.clearData();event.dataTransfer.setData('text/plain',text);event.dataTransfer.effectAllowed='copy';return true;}
_onKeyDown(event){if(UIUtils.isEditing()||!this._itemCount||event.shiftKey){return;}
let isArrowUp=false;switch(event.key){case'ArrowUp':if(this._virtualSelectedIndex>0){isArrowUp=true;this._virtualSelectedIndex--;}else{return;}
break;case'ArrowDown':if(this._virtualSelectedIndex<this._itemCount-1){this._virtualSelectedIndex++;}else{return;}
break;case'Home':this._virtualSelectedIndex=0;break;case'End':this._virtualSelectedIndex=this._itemCount-1;break;default:return;}
event.consume(true);this.scrollItemIntoView(this._virtualSelectedIndex);this._updateFocusedItem(isArrowUp);}
_updateFocusedItem(focusLastChild){const selectedElement=this.renderedElementAt(this._virtualSelectedIndex);const changed=this._lastSelectedElement!==selectedElement;const containerHasFocus=this._contentElement===this.element.ownerDocument.deepActiveElement();if(this._lastSelectedElement&&changed){this._lastSelectedElement.classList.remove('console-selected');}
if(selectedElement&&(focusLastChild||changed||containerHasFocus)&&this.element.hasFocus()){selectedElement.classList.add('console-selected');if(focusLastChild){this.setStickToBottom(false);this._renderedItems[this._virtualSelectedIndex-this._firstActiveIndex].focusLastChildOrSelf();}else if(!selectedElement.hasFocus()){focusWithoutScroll(selectedElement);}}
if(this._itemCount&&!this._contentElement.hasFocus()){this._contentElement.tabIndex=0;}else{this._contentElement.tabIndex=-1;}
this._lastSelectedElement=selectedElement;function focusWithoutScroll(element){element.focus({preventScroll:true});}}
contentElement(){return this._contentElement;}
invalidate(){delete this._cachedProviderElements;this._itemCount=this._provider.itemCount();if(this._virtualSelectedIndex>this._itemCount-1){this._virtualSelectedIndex=this._itemCount-1;}
this._rebuildCumulativeHeights();this.refresh();}
_providerElement(index){if(!this._cachedProviderElements){this._cachedProviderElements=new Array(this._itemCount);}
let element=this._cachedProviderElements[index];if(!element){element=this._provider.itemElement(index);this._cachedProviderElements[index]=element;}
return element;}
_rebuildCumulativeHeights(){const firstActiveIndex=this._firstActiveIndex;const lastActiveIndex=this._lastActiveIndex;let height=0;this._cumulativeHeights=new Int32Array(this._itemCount);for(let i=0;i<this._itemCount;++i){if(firstActiveIndex<=i&&i-firstActiveIndex<this._renderedItems.length&&i<=lastActiveIndex){height+=this._renderedItems[i-firstActiveIndex].element().offsetHeight;}else{height+=this._provider.fastHeight(i);}
this._cumulativeHeights[i]=height;}}
_rebuildCumulativeHeightsIfNeeded(){let totalCachedHeight=0;let totalMeasuredHeight=0;for(let i=0;i<this._renderedItems.length;++i){const cachedItemHeight=this._cachedItemHeight(this._firstActiveIndex+i);const measuredHeight=this._renderedItems[i].element().offsetHeight;if(Math.abs(cachedItemHeight-measuredHeight)>1){this._rebuildCumulativeHeights();return;}
totalMeasuredHeight+=measuredHeight;totalCachedHeight+=cachedItemHeight;if(Math.abs(totalCachedHeight-totalMeasuredHeight)>1){this._rebuildCumulativeHeights();return;}}}
_cachedItemHeight(index){return index===0?this._cumulativeHeights[0]:this._cumulativeHeights[index]-this._cumulativeHeights[index-1];}
_isSelectionBackwards(selection){if(!selection||!selection.rangeCount){return false;}
const range=document.createRange();range.setStart(selection.anchorNode,selection.anchorOffset);range.setEnd(selection.focusNode,selection.focusOffset);return range.collapsed;}
_createSelectionModel(itemIndex,node,offset){return{item:itemIndex,node:node,offset:offset};}
_updateSelectionModel(selection){const range=selection&&selection.rangeCount?selection.getRangeAt(0):null;if(!range||selection.isCollapsed||!this.element.hasSelection()){this._headSelection=null;this._anchorSelection=null;return false;}
let firstSelected=Number.MAX_VALUE;let lastSelected=-1;let hasVisibleSelection=false;for(let i=0;i<this._renderedItems.length;++i){if(range.intersectsNode(this._renderedItems[i].element())){const index=i+this._firstActiveIndex;firstSelected=Math.min(firstSelected,index);lastSelected=Math.max(lastSelected,index);hasVisibleSelection=true;}}
if(hasVisibleSelection){firstSelected=this._createSelectionModel(firstSelected,(range.startContainer),range.startOffset);lastSelected=this._createSelectionModel(lastSelected,(range.endContainer),range.endOffset);}
const topOverlap=range.intersectsNode(this._topGapElement)&&this._topGapElement._active;const bottomOverlap=range.intersectsNode(this._bottomGapElement)&&this._bottomGapElement._active;if(!topOverlap&&!bottomOverlap&&!hasVisibleSelection){this._headSelection=null;this._anchorSelection=null;return false;}
if(!this._anchorSelection||!this._headSelection){this._anchorSelection=this._createSelectionModel(0,this.element,0);this._headSelection=this._createSelectionModel(this._itemCount-1,this.element,this.element.children.length);this._selectionIsBackward=false;}
const isBackward=this._isSelectionBackwards(selection);const startSelection=this._selectionIsBackward?this._headSelection:this._anchorSelection;const endSelection=this._selectionIsBackward?this._anchorSelection:this._headSelection;if(topOverlap&&bottomOverlap&&hasVisibleSelection){firstSelected=firstSelected.item<startSelection.item?firstSelected:startSelection;lastSelected=lastSelected.item>endSelection.item?lastSelected:endSelection;}else if(!hasVisibleSelection){firstSelected=startSelection;lastSelected=endSelection;}else if(topOverlap){firstSelected=isBackward?this._headSelection:this._anchorSelection;}else if(bottomOverlap){lastSelected=isBackward?this._anchorSelection:this._headSelection;}
if(isBackward){this._anchorSelection=lastSelected;this._headSelection=firstSelected;}else{this._anchorSelection=firstSelected;this._headSelection=lastSelected;}
this._selectionIsBackward=isBackward;return true;}
_restoreSelection(selection){let anchorElement=null;let anchorOffset;if(this._firstActiveIndex<=this._anchorSelection.item&&this._anchorSelection.item<=this._lastActiveIndex){anchorElement=this._anchorSelection.node;anchorOffset=this._anchorSelection.offset;}else{if(this._anchorSelection.item<this._firstActiveIndex){anchorElement=this._topGapElement;}else if(this._anchorSelection.item>this._lastActiveIndex){anchorElement=this._bottomGapElement;}
anchorOffset=this._selectionIsBackward?1:0;}
let headElement=null;let headOffset;if(this._firstActiveIndex<=this._headSelection.item&&this._headSelection.item<=this._lastActiveIndex){headElement=this._headSelection.node;headOffset=this._headSelection.offset;}else{if(this._headSelection.item<this._firstActiveIndex){headElement=this._topGapElement;}else if(this._headSelection.item>this._lastActiveIndex){headElement=this._bottomGapElement;}
headOffset=this._selectionIsBackward?0:1;}
selection.setBaseAndExtent(anchorElement,anchorOffset,headElement,headOffset);}
refresh(){this._observer.disconnect();this._innerRefresh();if(this._stickToBottom){this._observer.observe(this._contentElement,this._observerConfig);}}
_innerRefresh(){if(!this._visibleHeight()){return;}
if(!this._itemCount){for(let i=0;i<this._renderedItems.length;++i){this._renderedItems[i].willHide();}
this._renderedItems=[];this._contentElement.removeChildren();this._topGapElement.style.height='0px';this._bottomGapElement.style.height='0px';this._firstActiveIndex=-1;this._lastActiveIndex=-1;this._updateFocusedItem();return;}
const selection=this.element.getComponentSelection();const shouldRestoreSelection=this._updateSelectionModel(selection);const visibleFrom=this.element.scrollTop;const visibleHeight=this._visibleHeight();const activeHeight=visibleHeight*2;this._rebuildCumulativeHeightsIfNeeded();if(this._stickToBottom){this._firstActiveIndex=Math.max(this._itemCount-Math.ceil(activeHeight/this._provider.minimumRowHeight()),0);this._lastActiveIndex=this._itemCount-1;}else{this._firstActiveIndex=Math.max(this._cumulativeHeights.lowerBound(visibleFrom+1-(activeHeight-visibleHeight)/2),0);this._lastActiveIndex=this._firstActiveIndex+Math.ceil(activeHeight/this._provider.minimumRowHeight())-1;this._lastActiveIndex=Math.min(this._lastActiveIndex,this._itemCount-1);}
const topGapHeight=this._cumulativeHeights[this._firstActiveIndex-1]||0;const bottomGapHeight=this._cumulativeHeights[this._cumulativeHeights.length-1]-this._cumulativeHeights[this._lastActiveIndex];function prepare(){this._topGapElement.style.height=topGapHeight+'px';this._bottomGapElement.style.height=bottomGapHeight+'px';this._topGapElement._active=!!topGapHeight;this._bottomGapElement._active=!!bottomGapHeight;this._contentElement.style.setProperty('height','10000000px');}
this._partialViewportUpdate(prepare.bind(this));this._contentElement.style.removeProperty('height');if(shouldRestoreSelection){this._restoreSelection(selection);}
if(this._stickToBottom){this.element.scrollTop=10000000;}}
_partialViewportUpdate(prepare){const itemsToRender=new Set();for(let i=this._firstActiveIndex;i<=this._lastActiveIndex;++i){itemsToRender.add(this._providerElement(i));}
const willBeHidden=this._renderedItems.filter(item=>!itemsToRender.has(item));for(let i=0;i<willBeHidden.length;++i){willBeHidden[i].willHide();}
prepare();let hadFocus=false;for(let i=0;i<willBeHidden.length;++i){hadFocus=hadFocus||willBeHidden[i].element().hasFocus();willBeHidden[i].element().remove();}
const wasShown=[];let anchor=this._contentElement.firstChild;for(const viewportElement of itemsToRender){const element=viewportElement.element();if(element!==anchor){const shouldCallWasShown=!element.parentElement;if(shouldCallWasShown){wasShown.push(viewportElement);}
this._contentElement.insertBefore(element,anchor);}else{anchor=anchor.nextSibling;}}
for(let i=0;i<wasShown.length;++i){wasShown[i].wasShown();}
this._renderedItems=Array.from(itemsToRender);if(hadFocus){this._contentElement.focus();}
this._updateFocusedItem();}
_selectedText(){this._updateSelectionModel(this.element.getComponentSelection());if(!this._headSelection||!this._anchorSelection){return null;}
let startSelection=null;let endSelection=null;if(this._selectionIsBackward){startSelection=this._headSelection;endSelection=this._anchorSelection;}else{startSelection=this._anchorSelection;endSelection=this._headSelection;}
const textLines=[];for(let i=startSelection.item;i<=endSelection.item;++i){const element=this._providerElement(i).element();const lineContent=element.childTextNodes().map(Linkifier.Linkifier.untruncatedNodeText).join('');textLines.push(lineContent);}
const endSelectionElement=this._providerElement(endSelection.item).element();if(endSelection.node&&endSelection.node.isSelfOrDescendant(endSelectionElement)){const itemTextOffset=this._textOffsetInNode(endSelectionElement,endSelection.node,endSelection.offset);textLines[textLines.length-1]=textLines.peekLast().substring(0,itemTextOffset);}
const startSelectionElement=this._providerElement(startSelection.item).element();if(startSelection.node&&startSelection.node.isSelfOrDescendant(startSelectionElement)){const itemTextOffset=this._textOffsetInNode(startSelectionElement,startSelection.node,startSelection.offset);textLines[0]=textLines[0].substring(itemTextOffset);}
return textLines.join('\n');}
_textOffsetInNode(itemElement,selectionNode,offset){if(selectionNode.nodeType!==Node.TEXT_NODE){if(offset<selectionNode.childNodes.length){selectionNode=(selectionNode.childNodes.item(offset));offset=0;}else{offset=selectionNode.textContent.length;}}
let chars=0;let node=itemElement;while((node=node.traverseNextNode(itemElement))&&node!==selectionNode){if(node.nodeType!==Node.TEXT_NODE||node.parentElement.nodeName==='STYLE'||node.parentElement.nodeName==='SCRIPT'){continue;}
chars+=Linkifier.Linkifier.untruncatedNodeText(node).length;}
const untruncatedContainerLength=Linkifier.Linkifier.untruncatedNodeText(selectionNode).length;if(offset>0&&untruncatedContainerLength!==selectionNode.textContent.length){offset=untruncatedContainerLength;}
return chars+offset;}
_onScroll(event){this.refresh();}
firstVisibleIndex(){if(!this._cumulativeHeights.length){return-1;}
this._rebuildCumulativeHeightsIfNeeded();return this._cumulativeHeights.lowerBound(this.element.scrollTop+1);}
lastVisibleIndex(){if(!this._cumulativeHeights.length){return-1;}
this._rebuildCumulativeHeightsIfNeeded();const scrollBottom=this.element.scrollTop+this.element.clientHeight;const right=this._itemCount-1;return this._cumulativeHeights.lowerBound(scrollBottom,undefined,undefined,right);}
renderedElementAt(index){if(index===-1||index<this._firstActiveIndex||index>this._lastActiveIndex){return null;}
return this._renderedItems[index-this._firstActiveIndex].element();}
scrollItemIntoView(index,makeLast){const firstVisibleIndex=this.firstVisibleIndex();const lastVisibleIndex=this.lastVisibleIndex();if(index>firstVisibleIndex&&index<lastVisibleIndex){return;}
if(index===lastVisibleIndex&&this._cumulativeHeights[index]<=this.element.scrollTop+this._visibleHeight()){return;}
if(makeLast){this.forceScrollItemToBeLast(index);}else if(index<=firstVisibleIndex){this.forceScrollItemToBeFirst(index);}else if(index>=lastVisibleIndex){this.forceScrollItemToBeLast(index);}}
forceScrollItemToBeFirst(index){console.assert(index>=0&&index<this._itemCount,'Cannot scroll item at invalid index');this.setStickToBottom(false);this._rebuildCumulativeHeightsIfNeeded();this.element.scrollTop=index>0?this._cumulativeHeights[index-1]:0;if(this.element.isScrolledToBottom()){this.setStickToBottom(true);}
this.refresh();this.renderedElementAt(index).scrollIntoView(true);}
forceScrollItemToBeLast(index){console.assert(index>=0&&index<this._itemCount,'Cannot scroll item at invalid index');this.setStickToBottom(false);this._rebuildCumulativeHeightsIfNeeded();this.element.scrollTop=this._cumulativeHeights[index]-this._visibleHeight();if(this.element.isScrolledToBottom()){this.setStickToBottom(true);}
this.refresh();this.renderedElementAt(index).scrollIntoView(false);}
_visibleHeight(){return this.element.offsetHeight;}}
class ConsoleViewportProvider{fastHeight(index){return 0;}
itemCount(){return 0;}
minimumRowHeight(){return 0;}
itemElement(index){return null;}}
class ConsoleViewportElement{willHide(){}
wasShown(){}
element(){}}
var ConsoleViewport$1=Object.freeze({__proto__:null,ConsoleViewport:ConsoleViewport,ConsoleViewportProvider:ConsoleViewportProvider,ConsoleViewportElement:ConsoleViewportElement});class ConsoleViewMessage{constructor(consoleMessage,linkifier,nestingLevel,onResize){this._message=consoleMessage;this._linkifier=linkifier;this._repeatCount=1;this._closeGroupDecorationCount=0;this._nestingLevel=nestingLevel;this._selectableChildren=[];this._messageResized=onResize;this._dataGrid=null;this._previewFormatter=new RemoteObjectPreviewFormatter.RemoteObjectPreviewFormatter();this._searchRegex=null;this._messageLevelIcon=null;this._traceExpanded=false;this._expandTrace=null;this._anchorElement=null;}
element(){return this.toMessageElement();}
wasShown(){if(this._dataGrid){this._dataGrid.updateWidths();}
this._isVisible=true;}
onResize(){if(!this._isVisible){return;}
if(this._dataGrid){this._dataGrid.onResize();}}
willHide(){this._isVisible=false;this._cachedHeight=this.element().offsetHeight;}
fastHeight(){if(this._cachedHeight){return this._cachedHeight;}
const defaultConsoleRowHeight=19;if(this._message.type===ConsoleModel.MessageType.Table){const table=this._message.parameters[0];if(table&&table.preview){return defaultConsoleRowHeight*table.preview.properties.length;}}
return defaultConsoleRowHeight;}
consoleMessage(){return this._message;}
_buildTableMessage(){const formattedMessage=document.createElement('span');formattedMessage.classList.add('source-code');this._anchorElement=this._buildMessageAnchor();if(this._anchorElement){formattedMessage.appendChild(this._anchorElement);}
let table=this._message.parameters&&this._message.parameters.length?this._message.parameters[0]:null;if(table){table=this._parameterToRemoteObject(table);}
if(!table||!table.preview){return this._buildMessage();}
const rawValueColumnSymbol=Symbol('rawValueColumn');const columnNames=[];const preview=table.preview;const rows=[];for(let i=0;i<preview.properties.length;++i){const rowProperty=preview.properties[i];let rowSubProperties;if(rowProperty.valuePreview){rowSubProperties=rowProperty.valuePreview.properties;}else if(rowProperty.value){rowSubProperties=[{name:rawValueColumnSymbol,type:rowProperty.type,value:rowProperty.value}];}else{continue;}
const rowValue={};const maxColumnsToRender=20;for(let j=0;j<rowSubProperties.length;++j){const cellProperty=rowSubProperties[j];let columnRendered=columnNames.indexOf(cellProperty.name)!==-1;if(!columnRendered){if(columnNames.length===maxColumnsToRender){continue;}
columnRendered=true;columnNames.push(cellProperty.name);}
if(columnRendered){const cellElement=this._renderPropertyPreviewOrAccessor(table,[rowProperty,cellProperty]);cellElement.classList.add('console-message-nowrap-below');rowValue[cellProperty.name]=cellElement;}}
rows.push([rowProperty.name,rowValue]);}
const flatValues=[];for(let i=0;i<rows.length;++i){const rowName=rows[i][0];const rowValue=rows[i][1];flatValues.push(rowName);for(let j=0;j<columnNames.length;++j){flatValues.push(rowValue[columnNames[j]]);}}
columnNames.unshift(UIString.UIString('(index)'));const columnDisplayNames=columnNames.map(name=>name===rawValueColumnSymbol?UIString.UIString('Value'):name);if(flatValues.length){this._dataGrid=SortableDataGrid.SortableDataGrid.create(columnDisplayNames,flatValues,ls`Console`);this._dataGrid.setStriped(true);this._dataGrid.setFocusable(false);const formattedResult=document.createElement('span');formattedResult.classList.add('console-message-text');const tableElement=formattedResult.createChild('div','console-message-formatted-table');const dataGridContainer=tableElement.createChild('span');tableElement.appendChild(this._formatParameter(table,true,false));dataGridContainer.appendChild(this._dataGrid.element);formattedMessage.appendChild(formattedResult);this._dataGrid.renderInline();}
return formattedMessage;}
_buildMessage(){let messageElement;let messageText=this._message.messageText;if(this._message.source===ConsoleModel.MessageSource.ConsoleAPI){switch(this._message.type){case ConsoleModel.MessageType.Trace:messageElement=this._format(this._message.parameters||['console.trace']);break;case ConsoleModel.MessageType.Clear:messageElement=document.createElement('span');messageElement.classList.add('console-info');if(Settings.Settings.instance().moduleSetting('preserveConsoleLog').get()){messageElement.textContent=UIString.UIString('console.clear() was prevented due to \'Preserve log\'');}else{messageElement.textContent=UIString.UIString('Console was cleared');}
messageElement.title=ls`Clear all messages with ${self.UI.shortcutRegistry.shortcutTitleForAction('console.clear')}`;break;case ConsoleModel.MessageType.Dir:{const obj=this._message.parameters?this._message.parameters[0]:undefined;const args=['%O',obj];messageElement=this._format(args);break;}
case ConsoleModel.MessageType.Profile:case ConsoleModel.MessageType.ProfileEnd:messageElement=this._format([messageText]);break;case ConsoleModel.MessageType.Assert:this._messagePrefix=ls`Assertion failed: `;default:{if(this._message.parameters&&this._message.parameters.length===1&&this._message.parameters[0].type==='string'){messageElement=this._tryFormatAsError((this._message.parameters[0].value));}
const args=this._message.parameters||[messageText];messageElement=messageElement||this._format(args);}}}else{if(this._message.source===ConsoleModel.MessageSource.Network){messageElement=this._formatAsNetworkRequest()||this._format([messageText]);}else{const messageInParameters=this._message.parameters&&messageText===(this._message.parameters[0]);if(this._message.source===ConsoleModel.MessageSource.Violation){messageText=UIString.UIString('[Violation] %s',messageText);}else if(this._message.source===ConsoleModel.MessageSource.Intervention){messageText=UIString.UIString('[Intervention] %s',messageText);}else if(this._message.source===ConsoleModel.MessageSource.Deprecation){messageText=UIString.UIString('[Deprecation] %s',messageText);}
const args=this._message.parameters||[messageText];if(messageInParameters){args[0]=messageText;}
messageElement=this._format(args);}}
messageElement.classList.add('console-message-text');const formattedMessage=document.createElement('span');formattedMessage.classList.add('source-code');this._anchorElement=this._buildMessageAnchor();if(this._anchorElement){formattedMessage.appendChild(this._anchorElement);}
formattedMessage.appendChild(messageElement);return formattedMessage;}
_formatAsNetworkRequest(){const request=NetworkLog.NetworkLog.requestForConsoleMessage(this._message);if(!request){return null;}
const messageElement=createElement('span');if(this._message.level===ConsoleModel.MessageLevel.Error){messageElement.createTextChild(request.requestMethod+' ');const linkElement=Linkifier.Linkifier.linkifyRevealable(request,request.url(),request.url());linkElement.tabIndex=-1;this._selectableChildren.push({element:linkElement,forceSelect:()=>linkElement.focus()});messageElement.appendChild(linkElement);if(request.failed){messageElement.createTextChildren(' ',request.localizedFailDescription||'');}
if(request.statusCode!==0){messageElement.createTextChildren(' ',String(request.statusCode));}
if(request.statusText){messageElement.createTextChildren(' (',request.statusText,')');}}else{const messageText=this._message.messageText;const fragment=this._linkifyWithCustomLinkifier(messageText,(text,url,lineNumber,columnNumber)=>{let linkElement;if(url===request.url()){linkElement=Linkifier.Linkifier.linkifyRevealable((request),url,request.url());}else{linkElement=Linkifier.Linkifier.linkifyURL(url,{text,lineNumber,columnNumber});}
linkElement.tabIndex=-1;this._selectableChildren.push({element:linkElement,forceSelect:()=>linkElement.focus()});return linkElement;});messageElement.appendChild(fragment);}
return messageElement;}
_buildMessageAnchor(){let anchorElement=null;if(this._message.scriptId){anchorElement=this._linkifyScriptId(this._message.scriptId,this._message.url||'',this._message.line,this._message.column);}else if(this._message.stackTrace&&this._message.stackTrace.callFrames.length){anchorElement=this._linkifyStackTraceTopFrame(this._message.stackTrace);}else if(this._message.url&&this._message.url!=='undefined'){anchorElement=this._linkifyLocation(this._message.url,this._message.line,this._message.column);}
if(anchorElement){anchorElement.tabIndex=-1;this._selectableChildren.push({element:anchorElement,forceSelect:()=>anchorElement.focus(),});const anchorWrapperElement=document.createElement('span');anchorWrapperElement.classList.add('console-message-anchor');anchorWrapperElement.appendChild(anchorElement);anchorWrapperElement.createTextChild(' ');return anchorWrapperElement;}
return null;}
_buildMessageWithStackTrace(){const toggleElement=document.createElement('div');toggleElement.classList.add('console-message-stack-trace-toggle');const contentElement=toggleElement.createChild('div','console-message-stack-trace-wrapper');const messageElement=this._buildMessage();const icon=Icon.Icon.create('smallicon-triangle-right','console-message-expand-icon');const clickableElement=contentElement.createChild('div');clickableElement.appendChild(icon);clickableElement.tabIndex=-1;clickableElement.appendChild(messageElement);const stackTraceElement=contentElement.createChild('div');const stackTracePreview=JSPresentationUtils.buildStackTracePreviewContents(this._message.runtimeModel().target(),this._linkifier,{stackTrace:this._message.stackTrace});stackTraceElement.appendChild(stackTracePreview.element);for(const linkElement of stackTracePreview.links){this._selectableChildren.push({element:linkElement,forceSelect:()=>linkElement.focus()});}
stackTraceElement.classList.add('hidden');ARIAUtils.markAsTreeitem(this.element());ARIAUtils.setExpanded(this.element(),false);this._expandTrace=expand=>{icon.setIconType(expand?'smallicon-triangle-down':'smallicon-triangle-right');stackTraceElement.classList.toggle('hidden',!expand);ARIAUtils.setExpanded(this.element(),expand);this._traceExpanded=expand;};function toggleStackTrace(event){if(UIUtils.isEditing()||contentElement.hasSelection()){return;}
this._expandTrace(stackTraceElement.classList.contains('hidden'));event.consume();}
clickableElement.addEventListener('click',toggleStackTrace.bind(this),false);if(this._message.type===ConsoleModel.MessageType.Trace){this._expandTrace(true);}
toggleElement._expandStackTraceForTest=this._expandTrace.bind(this,true);return toggleElement;}
_linkifyLocation(url,lineNumber,columnNumber){if(!this._message.runtimeModel()){return null;}
return this._linkifier.linkifyScriptLocation(this._message.runtimeModel().target(),null,url,lineNumber,{columnNumber});}
_linkifyStackTraceTopFrame(stackTrace){if(!this._message.runtimeModel()){return null;}
return this._linkifier.linkifyStackTraceTopFrame(this._message.runtimeModel().target(),stackTrace);}
_linkifyScriptId(scriptId,url,lineNumber,columnNumber){if(!this._message.runtimeModel()){return null;}
return this._linkifier.linkifyScriptLocation(this._message.runtimeModel().target(),scriptId,url,lineNumber,{columnNumber});}
_parameterToRemoteObject(parameter){if(parameter instanceof RemoteObject.RemoteObject){return parameter;}
const runtimeModel=this._message.runtimeModel();if(!runtimeModel){return RemoteObject.RemoteObject.fromLocalObject(parameter);}
if(typeof parameter==='object'){return runtimeModel.createRemoteObject(parameter);}
return runtimeModel.createRemoteObjectFromPrimitiveValue(parameter);}
_format(rawParameters){const formattedResult=createElement('span');if(this._messagePrefix){formattedResult.createChild('span').textContent=this._messagePrefix;}
if(!rawParameters.length){return formattedResult;}
let parameters=[];for(let i=0;i<rawParameters.length;++i){parameters[i]=this._parameterToRemoteObject(rawParameters[i]);}
const shouldFormatMessage=RemoteObject.RemoteObject.type(((parameters))[0])==='string'&&(this._message.type!==ConsoleModel.MessageType.Result||this._message.level===ConsoleModel.MessageLevel.Error);if(shouldFormatMessage){const result=this._formatWithSubstitutionString((parameters[0].description),parameters.slice(1),formattedResult);parameters=result.unusedSubstitutions;if(parameters.length){formattedResult.createTextChild(' ');}}
for(let i=0;i<parameters.length;++i){if(shouldFormatMessage&&parameters[i].type==='string'){formattedResult.appendChild(this._linkifyStringAsFragment(parameters[i].description));}else{formattedResult.appendChild(this._formatParameter(parameters[i],false,true));}
if(i<parameters.length-1){formattedResult.createTextChild(' ');}}
return formattedResult;}
_formatParameter(output,forceObjectFormat,includePreview){if(output.customPreview()){return(new CustomPreviewComponent.CustomPreviewComponent(output)).element;}
const type=forceObjectFormat?'object':(output.subtype||output.type);let element;switch(type){case'error':element=this._formatParameterAsError(output);break;case'function':element=this._formatParameterAsFunction(output,includePreview);break;case'array':case'arraybuffer':case'blob':case'dataview':case'generator':case'iterator':case'map':case'object':case'promise':case'proxy':case'set':case'typedarray':case'weakmap':case'weakset':element=this._formatParameterAsObject(output,includePreview);break;case'node':element=output.isNode()?this._formatParameterAsNode(output):this._formatParameterAsObject(output,false);break;case'string':element=this._formatParameterAsString(output);break;case'boolean':case'date':case'null':case'number':case'regexp':case'symbol':case'undefined':case'bigint':element=this._formatParameterAsValue(output);break;default:element=this._formatParameterAsValue(output);console.error('Tried to format remote object of unknown type.');}
element.classList.add('object-value-'+type);element.classList.add('source-code');return element;}
_formatParameterAsValue(obj){const result=createElement('span');const description=obj.description||'';if(description.length>Console.ConsoleViewMessage._MaxTokenizableStringLength){const propertyValue=new ObjectPropertiesSection.ExpandableTextPropertyValue(createElement('span'),description,Console.ConsoleViewMessage._LongStringVisibleLength);result.appendChild(propertyValue.element);}else{result.createTextChild(description);}
if(obj.objectId){result.addEventListener('contextmenu',this._contextMenuEventFired.bind(this,obj),false);}
return result;}
_formatParameterAsObject(obj,includePreview){const titleElement=document.createElement('span');titleElement.classList.add('console-object');if(includePreview&&obj.preview){titleElement.classList.add('console-object-preview');this._previewFormatter.appendObjectPreview(titleElement,obj.preview,false);}else if(obj.type==='function'){const functionElement=titleElement.createChild('span');ObjectPropertiesSection.ObjectPropertiesSection.formatObjectAsFunction(obj,functionElement,false);titleElement.classList.add('object-value-function');}else{titleElement.createTextChild(obj.description||'');}
if(!obj.hasChildren||obj.customPreview()){return titleElement;}
const note=titleElement.createChild('span','object-state-note info-note');if(this._message.type===ConsoleModel.MessageType.QueryObjectResult){note.title=ls`This value will not be collected until console is cleared.`;}else{note.title=ls`Value below was evaluated just now.`;}
const section=new ObjectPropertiesSection.ObjectPropertiesSection(obj,titleElement,this._linkifier);section.element.classList.add('console-view-object-properties-section');section.enableContextMenu();section.setShowSelectionOnKeyboardFocus(true,true);this._selectableChildren.push(section);section.addEventListener(TreeOutline.Events.ElementAttached,this._messageResized);section.addEventListener(TreeOutline.Events.ElementExpanded,this._messageResized);section.addEventListener(TreeOutline.Events.ElementCollapsed,this._messageResized);return section.element;}
_formatParameterAsFunction(func,includePreview){const result=createElement('span');RemoteObject.RemoteFunction.objectAsFunction(func).targetFunction().then(formatTargetFunction.bind(this));return result;function formatTargetFunction(targetFunction){const functionElement=createElement('span');const promise=ObjectPropertiesSection.ObjectPropertiesSection.formatObjectAsFunction(targetFunction,functionElement,true,includePreview);result.appendChild(functionElement);if(targetFunction!==func){const note=result.createChild('span','object-info-state-note');note.title=UIString.UIString('Function was resolved from bound function.');}
result.addEventListener('contextmenu',this._contextMenuEventFired.bind(this,targetFunction),false);promise.then(()=>this._formattedParameterAsFunctionForTest());}}
_formattedParameterAsFunctionForTest(){}
_contextMenuEventFired(obj,event){const contextMenu=new ContextMenu.ContextMenu(event);contextMenu.appendApplicableItems(obj);contextMenu.show();}
_renderPropertyPreviewOrAccessor(object,propertyPath){const property=propertyPath.peekLast();if(property.type==='accessor'){return this._formatAsAccessorProperty(object,propertyPath.map(property=>property.name),false);}
return this._previewFormatter.renderPropertyPreview(property.type,(property.subtype),property.value);}
_formatParameterAsNode(remoteObject){const result=createElement('span');const domModel=remoteObject.runtimeModel().target().model(DOMModel.DOMModel);if(!domModel){return result;}
domModel.pushObjectAsNodeToFrontend(remoteObject).then(async node=>{if(!node){result.appendChild(this._formatParameterAsObject(remoteObject,false));return;}
const renderResult=await UIUtils.Renderer.render((node));if(renderResult){if(renderResult.tree){this._selectableChildren.push(renderResult.tree);renderResult.tree.addEventListener(TreeOutline.Events.ElementAttached,this._messageResized);renderResult.tree.addEventListener(TreeOutline.Events.ElementExpanded,this._messageResized);renderResult.tree.addEventListener(TreeOutline.Events.ElementCollapsed,this._messageResized);}
result.appendChild(renderResult.node);}else{result.appendChild(this._formatParameterAsObject(remoteObject,false));}
this._formattedParameterAsNodeForTest();});return result;}
_formattedParameterAsNodeForTest(){}
_formatParameterAsString(output){const span=createElement('span');span.appendChild(this._linkifyStringAsFragment(output.description||''));const result=createElement('span');result.createChild('span','object-value-string-quote').textContent='"';result.appendChild(span);result.createChild('span','object-value-string-quote').textContent='"';return result;}
_formatParameterAsError(output){const result=createElement('span');const errorSpan=this._tryFormatAsError(output.description||'');result.appendChild(errorSpan?errorSpan:this._linkifyStringAsFragment(output.description||''));return result;}
_formatAsArrayEntry(output){return this._previewFormatter.renderPropertyPreview(output.type,output.subtype,output.description);}
_formatAsAccessorProperty(object,propertyPath,isArrayEntry){const rootElement=ObjectPropertiesSection.ObjectPropertyTreeElement.createRemoteObjectAccessorPropertySpan(object,propertyPath,onInvokeGetterClick.bind(this));function onInvokeGetterClick(result){const wasThrown=result.wasThrown;const object=result.object;if(!object){return;}
rootElement.removeChildren();if(wasThrown){const element=rootElement.createChild('span');element.textContent=UIString.UIString('<exception>');element.title=(object.description);}else if(isArrayEntry){rootElement.appendChild(this._formatAsArrayEntry(object));}else{const maxLength=100;const type=object.type;const subtype=object.subtype;let description='';if(type!=='function'&&object.description){if(type==='string'||subtype==='regexp'){description=object.description.trimMiddle(maxLength);}else{description=object.description.trimEndWithMaxLength(maxLength);}}
rootElement.appendChild(this._previewFormatter.renderPropertyPreview(type,subtype,description));}}
return rootElement;}
_formatWithSubstitutionString(format,parameters,formattedResult){const formatters={};function parameterFormatter(force,includePreview,obj){return this._formatParameter(obj,force,includePreview);}
function stringFormatter(obj){return obj.description;}
function floatFormatter(obj){if(typeof obj.value!=='number'){return'NaN';}
return obj.value;}
function integerFormatter(obj){if(obj.type==='bigint'){return obj.description;}
if(typeof obj.value!=='number'){return'NaN';}
return Math.floor(obj.value);}
function bypassFormatter(obj){return(obj instanceof Node)?obj:'';}
let currentStyle=null;function styleFormatter(obj){currentStyle={};const buffer=createElement('span');buffer.setAttribute('style',obj.description);for(let i=0;i<buffer.style.length;i++){const property=buffer.style[i];if(isWhitelistedProperty(property)){currentStyle[property]=buffer.style[property];}}}
function isWhitelistedProperty(property){const prefixes=['background','border','color','font','line','margin','padding','text','-webkit-background','-webkit-border','-webkit-font','-webkit-margin','-webkit-padding','-webkit-text'];for(let i=0;i<prefixes.length;i++){if(property.startsWith(prefixes[i])){return true;}}
return false;}
formatters.o=parameterFormatter.bind(this,false,true);formatters.s=stringFormatter;formatters.f=floatFormatter;formatters.i=integerFormatter;formatters.d=integerFormatter;formatters.c=styleFormatter;formatters.O=parameterFormatter.bind(this,true,false);formatters._=bypassFormatter;function append(a,b){if(b instanceof Node){a.appendChild(b);return a;}
if(typeof b==='undefined'){return a;}
if(!currentStyle){a.appendChild(this._linkifyStringAsFragment(String(b)));return a;}
const lines=String(b).split('\n');for(let i=0;i<lines.length;i++){const line=lines[i];const lineFragment=this._linkifyStringAsFragment(line);const wrapper=createElement('span');wrapper.style.setProperty('contain','paint');wrapper.style.setProperty('display','inline-block');wrapper.style.setProperty('max-width','100%');wrapper.appendChild(lineFragment);applyCurrentStyle(wrapper);for(const child of wrapper.children){if(child.classList.contains('devtools-link')){this._applyForcedVisibleStyle(child);}}
a.appendChild(wrapper);if(i<lines.length-1){a.appendChild(createElement('br'));}}
return a;}
function applyCurrentStyle(element){for(const key in currentStyle){element.style[key]=currentStyle[key];}}
return StringUtilities.format(format,parameters,formatters,formattedResult,append.bind(this));}
_applyForcedVisibleStyle(element){element.style.setProperty('-webkit-text-stroke','0','important');element.style.setProperty('text-decoration','underline','important');const themedColor=self.UI.themeSupport.patchColorText('rgb(33%, 33%, 33%)',UIUtils.ThemeSupport.ColorUsage.Foreground);element.style.setProperty('color',themedColor,'important');let backgroundColor='hsl(0, 0%, 100%)';if(this._message.level===ConsoleModel.MessageLevel.Error){backgroundColor='hsl(0, 100%, 97%)';}else if(this._message.level===ConsoleModel.MessageLevel.Warning||this._shouldRenderAsWarning()){backgroundColor='hsl(50, 100%, 95%)';}
const themedBackgroundColor=self.UI.themeSupport.patchColorText(backgroundColor,UIUtils.ThemeSupport.ColorUsage.Background);element.style.setProperty('background-color',themedBackgroundColor,'important');}
matchesFilterRegex(regexObject){regexObject.lastIndex=0;const contentElement=this.contentElement();const anchorText=this._anchorElement?this._anchorElement.deepTextContent():'';return(anchorText&&regexObject.test(anchorText.trim()))||regexObject.test(contentElement.deepTextContent().slice(anchorText.length));}
matchesFilterText(filter){const text=this.contentElement().deepTextContent();return text.toLowerCase().includes(filter.toLowerCase());}
updateTimestamp(){if(!this._contentElement){return;}
if(Settings.Settings.instance().moduleSetting('consoleTimestampsEnabled').get()){if(!this._timestampElement){this._timestampElement=document.createElement('span');this._timestampElement.classList.add('console-timestamp');}
this._timestampElement.textContent=UIUtils.formatTimestamp(this._message.timestamp,false)+' ';this._timestampElement.title=UIUtils.formatTimestamp(this._message.timestamp,true);this._contentElement.insertBefore(this._timestampElement,this._contentElement.firstChild);}else if(this._timestampElement){this._timestampElement.remove();delete this._timestampElement;}}
nestingLevel(){return this._nestingLevel;}
setInSimilarGroup(inSimilarGroup,isLast){this._inSimilarGroup=inSimilarGroup;this._lastInSimilarGroup=inSimilarGroup&&!!isLast;if(this._similarGroupMarker&&!inSimilarGroup){this._similarGroupMarker.remove();this._similarGroupMarker=null;}else if(this._element&&!this._similarGroupMarker&&inSimilarGroup){this._similarGroupMarker=document.createElement('div');this._similarGroupMarker.classList.add('nesting-level-marker');this._element.insertBefore(this._similarGroupMarker,this._element.firstChild);this._similarGroupMarker.classList.toggle('group-closed',this._lastInSimilarGroup);}}
isLastInSimilarGroup(){return this._inSimilarGroup&&this._lastInSimilarGroup;}
resetCloseGroupDecorationCount(){if(!this._closeGroupDecorationCount){return;}
this._closeGroupDecorationCount=0;this._updateCloseGroupDecorations();}
incrementCloseGroupDecorationCount(){++this._closeGroupDecorationCount;this._updateCloseGroupDecorations();}
_updateCloseGroupDecorations(){if(!this._nestingLevelMarkers){return;}
for(let i=0,n=this._nestingLevelMarkers.length;i<n;++i){const marker=this._nestingLevelMarkers[i];marker.classList.toggle('group-closed',n-i<=this._closeGroupDecorationCount);}}
_focusedChildIndex(){if(!this._selectableChildren.length){return-1;}
return this._selectableChildren.findIndex(child=>child.element.hasFocus());}
_onKeyDown(event){if(UIUtils.isEditing()||!this._element.hasFocus()||this._element.hasSelection()){return;}
if(this.maybeHandleOnKeyDown(event)){event.consume(true);}}
maybeHandleOnKeyDown(event){const focusedChildIndex=this._focusedChildIndex();const isWrapperFocused=focusedChildIndex===-1;if(this._expandTrace&&isWrapperFocused){if((event.key==='ArrowLeft'&&this._traceExpanded)||(event.key==='ArrowRight'&&!this._traceExpanded)){this._expandTrace(!this._traceExpanded);return true;}}
if(!this._selectableChildren.length){return false;}
if(event.key==='ArrowLeft'){this._element.focus();return true;}
if(event.key==='ArrowRight'){if(isWrapperFocused&&this._selectNearestVisibleChild(0)){return true;}}
if(event.key==='ArrowUp'){const firstVisibleChild=this._nearestVisibleChild(0);if(this._selectableChildren[focusedChildIndex]===firstVisibleChild&&firstVisibleChild){this._element.focus();return true;}
if(this._selectNearestVisibleChild(focusedChildIndex-1,true)){return true;}}
if(event.key==='ArrowDown'){if(isWrapperFocused&&this._selectNearestVisibleChild(0)){return true;}
if(!isWrapperFocused&&this._selectNearestVisibleChild(focusedChildIndex+1)){return true;}}
return false;}
_selectNearestVisibleChild(fromIndex,backwards){const nearestChild=this._nearestVisibleChild(fromIndex,backwards);if(nearestChild){nearestChild.forceSelect();return true;}
return false;}
_nearestVisibleChild(fromIndex,backwards){const childCount=this._selectableChildren.length;if(fromIndex<0||fromIndex>=childCount){return null;}
const direction=backwards?-1:1;let index=fromIndex;while(!this._selectableChildren[index].element.offsetParent){index+=direction;if(index<0||index>=childCount){return null;}}
return this._selectableChildren[index];}
focusLastChildOrSelf(){if(this._element&&!this._selectNearestVisibleChild(this._selectableChildren.length-1,true)){this._element.focus();}}
contentElement(){if(this._contentElement){return this._contentElement;}
const contentElement=document.createElement('div');contentElement.classList.add('console-message');if(this._messageLevelIcon){contentElement.appendChild(this._messageLevelIcon);}
this._contentElement=contentElement;let formattedMessage;const shouldIncludeTrace=!!this._message.stackTrace&&(this._message.source===ConsoleModel.MessageSource.Network||this._message.source===ConsoleModel.MessageSource.Violation||this._message.level===ConsoleModel.MessageLevel.Error||this._message.level===ConsoleModel.MessageLevel.Warning||this._message.type===ConsoleModel.MessageType.Trace);if(this._message.runtimeModel()&&shouldIncludeTrace){formattedMessage=this._buildMessageWithStackTrace();}else if(this._message.type===ConsoleModel.MessageType.Table){formattedMessage=this._buildTableMessage();}else{formattedMessage=this._buildMessage();}
contentElement.appendChild(formattedMessage);this.updateTimestamp();return this._contentElement;}
toMessageElement(){if(this._element){return this._element;}
this._element=createElement('div');this._element.tabIndex=-1;this._element.addEventListener('keydown',this._onKeyDown.bind(this));this.updateMessageElement();return this._element;}
updateMessageElement(){if(!this._element){return;}
this._element.className='console-message-wrapper';this._element.removeChildren();if(this._message.isGroupStartMessage()){this._element.classList.add('console-group-title');}
if(this._message.source===ConsoleModel.MessageSource.ConsoleAPI){this._element.classList.add('console-from-api');}
if(this._inSimilarGroup){this._similarGroupMarker=this._element.createChild('div','nesting-level-marker');this._similarGroupMarker.classList.toggle('group-closed',this._lastInSimilarGroup);}
this._nestingLevelMarkers=[];for(let i=0;i<this._nestingLevel;++i){this._nestingLevelMarkers.push(this._element.createChild('div','nesting-level-marker'));}
this._updateCloseGroupDecorations();this._element.message=this;switch(this._message.level){case ConsoleModel.MessageLevel.Verbose:this._element.classList.add('console-verbose-level');break;case ConsoleModel.MessageLevel.Info:this._element.classList.add('console-info-level');if(this._message.type===ConsoleModel.MessageType.System){this._element.classList.add('console-system-type');}
break;case ConsoleModel.MessageLevel.Warning:this._element.classList.add('console-warning-level');break;case ConsoleModel.MessageLevel.Error:this._element.classList.add('console-error-level');break;}
this._updateMessageLevelIcon();if(this._shouldRenderAsWarning()){this._element.classList.add('console-warning-level');}
this._element.appendChild(this.contentElement());if(this._repeatCount>1){this._showRepeatCountElement();}}
_shouldRenderAsWarning(){return(this._message.level===ConsoleModel.MessageLevel.Verbose||this._message.level===ConsoleModel.MessageLevel.Info)&&(this._message.source===ConsoleModel.MessageSource.Violation||this._message.source===ConsoleModel.MessageSource.Deprecation||this._message.source===ConsoleModel.MessageSource.Intervention||this._message.source===ConsoleModel.MessageSource.Recommendation);}
_updateMessageLevelIcon(){let iconType='';let accessibleName='';if(this._message.level===ConsoleModel.MessageLevel.Warning){iconType='smallicon-warning';accessibleName=ls`Warning`;}else if(this._message.level===ConsoleModel.MessageLevel.Error){iconType='smallicon-error';accessibleName=ls`Error`;}
if(!iconType&&!this._messageLevelIcon){return;}
if(iconType&&!this._messageLevelIcon){this._messageLevelIcon=Icon.Icon.create('','message-level-icon');if(this._contentElement){this._contentElement.insertBefore(this._messageLevelIcon,this._contentElement.firstChild);}}
this._messageLevelIcon.setIconType(iconType);ARIAUtils.setAccessibleName(this._messageLevelIcon,accessibleName);}
repeatCount(){return this._repeatCount||1;}
resetIncrementRepeatCount(){this._repeatCount=1;if(!this._repeatCountElement){return;}
this._repeatCountElement.remove();if(this._contentElement){this._contentElement.classList.remove('repeated-message');}
delete this._repeatCountElement;}
incrementRepeatCount(){this._repeatCount++;this._showRepeatCountElement();}
setRepeatCount(repeatCount){this._repeatCount=repeatCount;this._showRepeatCountElement();}
_showRepeatCountElement(){if(!this._element){return;}
if(!this._repeatCountElement){this._repeatCountElement=document.createElement('span',{is:'dt-small-bubble'});this._repeatCountElement.classList.add('console-message-repeat-count');switch(this._message.level){case ConsoleModel.MessageLevel.Warning:this._repeatCountElement.type='warning';break;case ConsoleModel.MessageLevel.Error:this._repeatCountElement.type='error';break;case ConsoleModel.MessageLevel.Verbose:this._repeatCountElement.type='verbose';break;default:this._repeatCountElement.type='info';}
if(this._shouldRenderAsWarning()){this._repeatCountElement.type='warning';}
this._element.insertBefore(this._repeatCountElement,this._contentElement);this._contentElement.classList.add('repeated-message');}
this._repeatCountElement.textContent=this._repeatCount;let accessibleName=ls`Repeat ${this._repeatCount}`;if(this._message.level===ConsoleModel.MessageLevel.Warning){accessibleName=ls`Warning ${accessibleName}`;}else if(this._message.level===ConsoleModel.MessageLevel.Error){accessibleName=ls`Error ${accessibleName}`;}
ARIAUtils.setAccessibleName(this._repeatCountElement,accessibleName);}
get text(){return this._message.messageText;}
toExportString(){const lines=[];const nodes=this.contentElement().childTextNodes();const messageContent=nodes.map(Linkifier.Linkifier.untruncatedNodeText).join('');for(let i=0;i<this.repeatCount();++i){lines.push(messageContent);}
return lines.join('\n');}
setSearchRegex(regex){if(this._searchHiglightNodeChanges&&this._searchHiglightNodeChanges.length){UIUtils.revertDomChanges(this._searchHiglightNodeChanges);}
this._searchRegex=regex;this._searchHighlightNodes=[];this._searchHiglightNodeChanges=[];if(!this._searchRegex){return;}
const text=this.contentElement().deepTextContent();let match;this._searchRegex.lastIndex=0;const sourceRanges=[];while((match=this._searchRegex.exec(text))&&match[0]){sourceRanges.push(new TextRange.SourceRange(match.index,match[0].length));}
if(sourceRanges.length){this._searchHighlightNodes=UIUtils.highlightSearchResults(this.contentElement(),sourceRanges,this._searchHiglightNodeChanges);}}
searchRegex(){return this._searchRegex;}
searchCount(){return this._searchHighlightNodes.length;}
searchHighlightNode(index){return this._searchHighlightNodes[index];}
_tryFormatAsError(string){function startsWith(prefix){return string.startsWith(prefix);}
const errorPrefixes=['EvalError','ReferenceError','SyntaxError','TypeError','RangeError','Error','URIError'];if(!this._message.runtimeModel()||!errorPrefixes.some(startsWith)){return null;}
const debuggerModel=this._message.runtimeModel().debuggerModel();const baseURL=this._message.runtimeModel().target().inspectedURL();const lines=string.split('\n');const links=[];let position=0;for(let i=0;i<lines.length;++i){position+=i>0?lines[i-1].length+1:0;const isCallFrameLine=/^\s*at\s/.test(lines[i]);if(!isCallFrameLine&&links.length){return null;}
if(!isCallFrameLine){continue;}
let openBracketIndex=-1;let closeBracketIndex=-1;const inBracketsWithLineAndColumn=/\([^\)\(]+:\d+:\d+\)/g;const inBrackets=/\([^\)\(]+\)/g;let lastMatch=null;let currentMatch;while((currentMatch=inBracketsWithLineAndColumn.exec(lines[i]))){lastMatch=currentMatch;}
if(!lastMatch){while((currentMatch=inBrackets.exec(lines[i]))){lastMatch=currentMatch;}}
if(lastMatch){openBracketIndex=lastMatch.index;closeBracketIndex=lastMatch.index+lastMatch[0].length-1;}
const hasOpenBracket=openBracketIndex!==-1;const left=hasOpenBracket?openBracketIndex+1:lines[i].indexOf('at')+3;const right=hasOpenBracket?closeBracketIndex:lines[i].length;const linkCandidate=lines[i].substring(left,right);const splitResult=ParsedURL.ParsedURL.splitLineAndColumn(linkCandidate);if(!splitResult){return null;}
if(splitResult.url==='<anonymous>'){continue;}
let url=parseOrScriptMatch(splitResult.url);if(!url&&ParsedURL.ParsedURL.isRelativeURL(splitResult.url)){url=parseOrScriptMatch(ParsedURL.ParsedURL.completeURL(baseURL,splitResult.url));}
if(!url){return null;}
links.push({url:url,positionLeft:position+left,positionRight:position+right,lineNumber:splitResult.lineNumber,columnNumber:splitResult.columnNumber});}
if(!links.length){return null;}
const formattedResult=createElement('span');let start=0;for(let i=0;i<links.length;++i){formattedResult.appendChild(this._linkifyStringAsFragment(string.substring(start,links[i].positionLeft)));const scriptLocationLink=this._linkifier.linkifyScriptLocation(debuggerModel.target(),null,links[i].url,links[i].lineNumber,{columnNumber:links[i].columnNumber});scriptLocationLink.tabIndex=-1;this._selectableChildren.push({element:scriptLocationLink,forceSelect:()=>scriptLocationLink.focus()});formattedResult.appendChild(scriptLocationLink);start=links[i].positionRight;}
if(start!==string.length){formattedResult.appendChild(this._linkifyStringAsFragment(string.substring(start)));}
return formattedResult;function parseOrScriptMatch(url){if(!url){return null;}
const parsedURL=ParsedURL.ParsedURL.fromString(url);if(parsedURL){return parsedURL.url;}
if(debuggerModel.scriptsForSourceURL(url).length){return url;}
return null;}}
_linkifyWithCustomLinkifier(string,linkifier){if(string.length>Console.ConsoleViewMessage._MaxTokenizableStringLength){const propertyValue=new ObjectPropertiesSection.ExpandableTextPropertyValue(createElement('span'),string,Console.ConsoleViewMessage._LongStringVisibleLength);const fragment=createDocumentFragment();fragment.appendChild(propertyValue.element);return fragment;}
const container=createDocumentFragment();const tokens=ConsoleViewMessage._tokenizeMessageText(string);for(const token of tokens){if(!token.text){continue;}
switch(token.type){case'url':{const realURL=(token.text.startsWith('www.')?'http://'+token.text:token.text);const splitResult=ParsedURL.ParsedURL.splitLineAndColumn(realURL);const sourceURL=ParsedURL.ParsedURL.removeWasmFunctionInfoFromURL(splitResult.url);let linkNode;if(splitResult){linkNode=linkifier(token.text,sourceURL,splitResult.lineNumber,splitResult.columnNumber);}else{linkNode=linkifier(token.text,token.value);}
container.appendChild(linkNode);break;}
default:container.appendChild(createTextNode(token.text));break;}}
return container;}
_linkifyStringAsFragment(string){return this._linkifyWithCustomLinkifier(string,(text,url,lineNumber,columnNumber)=>{const linkElement=Linkifier.Linkifier.linkifyURL(url,{text,lineNumber,columnNumber});linkElement.tabIndex=-1;this._selectableChildren.push({element:linkElement,forceSelect:()=>linkElement.focus()});return linkElement;});}
static _tokenizeMessageText(string){if(!ConsoleViewMessage._tokenizerRegexes){const controlCodes='\\u0000-\\u0020\\u007f-\\u009f';const linkStringRegex=new RegExp('(?:[a-zA-Z][a-zA-Z0-9+.-]{2,}:\\/\\/|data:|www\\.)[^\\s'+controlCodes+'"]{2,}[^\\s'+controlCodes+'"\')}\\],:;.!?]','u');const pathLineRegex=/(?:\/[\w\.-]*)+\:[\d]+/;const timeRegex=/took [\d]+ms/;const eventRegex=/'\w+' event/;const milestoneRegex=/\sM[6-7]\d/;const autofillRegex=/\(suggested: \"[\w-]+\"\)/;const handlers=new Map();handlers.set(linkStringRegex,'url');handlers.set(pathLineRegex,'url');handlers.set(timeRegex,'time');handlers.set(eventRegex,'event');handlers.set(milestoneRegex,'milestone');handlers.set(autofillRegex,'autofill');ConsoleViewMessage._tokenizerRegexes=Array.from(handlers.keys());ConsoleViewMessage._tokenizerTypes=Array.from(handlers.values());}
if(string.length>Console.ConsoleViewMessage._MaxTokenizableStringLength){return[{text:string,type:undefined}];}
const results=TextUtils.Utils.splitStringByRegexes(string,ConsoleViewMessage._tokenizerRegexes);return results.map(result=>({text:result.value,type:ConsoleViewMessage._tokenizerTypes[result.regexIndex]}));}
groupKey(){if(!this._groupKey){this._groupKey=this._message.groupCategoryKey()+':'+this.groupTitle();}
return this._groupKey;}
groupTitle(){const tokens=ConsoleViewMessage._tokenizeMessageText(this._message.messageText);const result=tokens.reduce((acc,token)=>{let text=token.text;if(token.type==='url'){text=UIString.UIString('<URL>');}else if(token.type==='time'){text=UIString.UIString('took <N>ms');}else if(token.type==='event'){text=UIString.UIString('<some> event');}else if(token.type==='milestone'){text=UIString.UIString(' M<XX>');}else if(token.type==='autofill'){text=UIString.UIString('<attribute>');}
return acc+text;},'');return result.replace(/[%]o/g,'');}}
class ConsoleGroupViewMessage extends ConsoleViewMessage{constructor(consoleMessage,linkifier,nestingLevel,onToggle,onResize){console.assert(consoleMessage.isGroupStartMessage());super(consoleMessage,linkifier,nestingLevel,onResize);this._collapsed=consoleMessage.type===ConsoleModel.MessageType.StartGroupCollapsed;this._expandGroupIcon=null;this._onToggle=onToggle;}
_setCollapsed(collapsed){this._collapsed=collapsed;if(this._expandGroupIcon){this._expandGroupIcon.setIconType(this._collapsed?'smallicon-triangle-right':'smallicon-triangle-down');}
this._onToggle.call(null);}
collapsed(){return this._collapsed;}
maybeHandleOnKeyDown(event){const focusedChildIndex=this._focusedChildIndex();if(focusedChildIndex===-1){if((event.key==='ArrowLeft'&&!this._collapsed)||(event.key==='ArrowRight'&&this._collapsed)){this._setCollapsed(!this._collapsed);return true;}}
return super.maybeHandleOnKeyDown(event);}
toMessageElement(){if(!this._element){super.toMessageElement();const iconType=this._collapsed?'smallicon-triangle-right':'smallicon-triangle-down';this._expandGroupIcon=Icon.Icon.create(iconType,'expand-group-icon');this._contentElement.tabIndex=-1;if(this._repeatCountElement){this._repeatCountElement.insertBefore(this._expandGroupIcon,this._repeatCountElement.firstChild);}else{this._element.insertBefore(this._expandGroupIcon,this._contentElement);}
this._element.addEventListener('click',()=>this._setCollapsed(!this._collapsed));}
return this._element;}
_showRepeatCountElement(){super._showRepeatCountElement();if(this._repeatCountElement&&this._expandGroupIcon){this._repeatCountElement.insertBefore(this._expandGroupIcon,this._repeatCountElement.firstChild);}}}
const MaxLengthForLinks=40;const _MaxTokenizableStringLength=10000;const _LongStringVisibleLength=5000;var ConsoleViewMessage$1=Object.freeze({__proto__:null,ConsoleViewMessage:ConsoleViewMessage,ConsoleGroupViewMessage:ConsoleGroupViewMessage,MaxLengthForLinks:MaxLengthForLinks,_MaxTokenizableStringLength:_MaxTokenizableStringLength,_LongStringVisibleLength:_LongStringVisibleLength});class ConsoleFilter{constructor(name,parsedFilters,executionContext,levelsMask){this.name=name;this.parsedFilters=parsedFilters;this.executionContext=executionContext;this.levelsMask=levelsMask||ConsoleFilter.defaultLevelsFilterValue();}
static allLevelsFilterValue(){const result={};for(const name of Object.values(ConsoleModel.MessageLevel)){result[name]=true;}
return result;}
static defaultLevelsFilterValue(){const result=ConsoleFilter.allLevelsFilterValue();result[ConsoleModel.MessageLevel.Verbose]=false;return result;}
static singleLevelMask(level){const result={};result[level]=true;return result;}
clone(){const parsedFilters=this.parsedFilters.map(TextUtils.FilterParser.cloneFilter);const levelsMask=Object.assign({},this.levelsMask);return new ConsoleFilter(this.name,parsedFilters,this.executionContext,levelsMask);}
shouldBeVisible(viewMessage){const message=viewMessage.consoleMessage();if(this.executionContext&&(this.executionContext.runtimeModel!==message.runtimeModel()||this.executionContext.id!==message.executionContextId)){return false;}
if(message.type===ConsoleModel.MessageType.Command||message.type===ConsoleModel.MessageType.Result||message.isGroupMessage()){return true;}
if(message.level&&!this.levelsMask[(message.level)]){return false;}
for(const filter of this.parsedFilters){if(!filter.key){if(filter.regex&&viewMessage.matchesFilterRegex(filter.regex)===filter.negative){return false;}
if(filter.text&&viewMessage.matchesFilterText(filter.text)===filter.negative){return false;}}else{switch(filter.key){case FilterType.Context:{if(!passesFilter(filter,message.context,false)){return false;}
break;}
case FilterType.Source:{const sourceNameForMessage=message.source?ConsoleModel.MessageSourceDisplayName.get((message.source)):message.source;if(!passesFilter(filter,sourceNameForMessage,true)){return false;}
break;}
case FilterType.Url:{if(!passesFilter(filter,message.url,false)){return false;}
break;}}}}
return true;function passesFilter(filter,value,exactMatch){if(!filter.text){return!!value===filter.negative;}
if(!value){return!filter.text===!filter.negative;}
const filterText=(filter.text).toLowerCase();const lowerCaseValue=value.toLowerCase();if(exactMatch&&(lowerCaseValue===filterText)===filter.negative){return false;}
if(!exactMatch&&lowerCaseValue.includes(filterText)===filter.negative){return false;}
return true;}}}
const FilterType={Context:'context',Source:'source',Url:'url'};var ConsoleFilter$1=Object.freeze({__proto__:null,ConsoleFilter:ConsoleFilter,FilterType:FilterType});const _PinSymbol=Symbol('pinSymbol');class ConsolePinPane extends ThrottledWidget.ThrottledWidget{constructor(liveExpressionButton){super(true,250);this._liveExpressionButton=liveExpressionButton;this.registerRequiredCSS('console/consolePinPane.css');this.registerRequiredCSS('object_ui/objectValue.css');this.contentElement.classList.add('console-pins','monospace');this.contentElement.addEventListener('contextmenu',this._contextMenuEventFired.bind(this),false);this._pins=new Set();this._pinsSetting=Settings.Settings.instance().createLocalSetting('consolePins',[]);for(const expression of this._pinsSetting.get()){this.addPin(expression);}}
willHide(){for(const pin of this._pins){pin.setHovered(false);}}
_savePins(){const toSave=Array.from(this._pins).map(pin=>pin.expression());this._pinsSetting.set(toSave);}
_contextMenuEventFired(event){const contextMenu=new ContextMenu.ContextMenu(event);const target=event.deepElementFromPoint();if(target){const targetPinElement=target.enclosingNodeOrSelfWithClass('console-pin');if(targetPinElement){const targetPin=targetPinElement[_PinSymbol];contextMenu.editSection().appendItem(ls`Edit expression`,targetPin.focus.bind(targetPin));contextMenu.editSection().appendItem(ls`Remove expression`,this._removePin.bind(this,targetPin));targetPin.appendToContextMenu(contextMenu);}}
contextMenu.editSection().appendItem(ls`Remove all expressions`,this._removeAllPins.bind(this));contextMenu.show();}
_removeAllPins(){for(const pin of this._pins){this._removePin(pin);}}
_removePin(pin){pin.element().remove();this._pins.delete(pin);this._savePins();this._liveExpressionButton.element.focus();}
addPin(expression,userGesture){const pin=new ConsolePin(expression,this);this.contentElement.appendChild(pin.element());this._pins.add(pin);this._savePins();if(userGesture){pin.focus();}
this.update();}
doUpdate(){if(!this._pins.size||!this.isShowing()){return Promise.resolve();}
if(this.isShowing()){this.update();}
const updatePromises=Array.from(this._pins,pin=>pin.updatePreview());return Promise.all(updatePromises).then(this._updatedForTest.bind(this));}
_updatedForTest(){}}
class ConsolePin extends ObjectWrapper.ObjectWrapper{constructor(expression,pinPane){super();const deletePinIcon=Icon.Icon.create('smallicon-cross','console-delete-pin');self.onInvokeElement(deletePinIcon,event=>{pinPane._removePin(this);event.consume(true);});deletePinIcon.tabIndex=0;ARIAUtils.setAccessibleName(deletePinIcon,ls`Remove expression`);ARIAUtils.markAsButton(deletePinIcon);const fragment=Fragment.Fragment.build`
    <div class='console-pin'>
      ${deletePinIcon}
      <div class='console-pin-name' $='name'></div>
      <div class='console-pin-preview' $='preview'>${ls`not available`}</div>
    </div>`;this._pinElement=fragment.element();this._pinPreview=fragment.$('preview');const nameElement=fragment.$('name');nameElement.title=expression;this._pinElement[_PinSymbol]=this;this._lastResult=null;this._lastExecutionContext=null;this._editor=null;this._committedExpression=expression;this._hovered=false;this._lastNode=null;this._pinPreview.addEventListener('mouseenter',this.setHovered.bind(this,true),false);this._pinPreview.addEventListener('mouseleave',this.setHovered.bind(this,false),false);this._pinPreview.addEventListener('click',event=>{if(this._lastNode){Revealer.reveal(this._lastNode);event.consume();}},false);this._editorPromise=self.runtime.extension(TextEditor.TextEditorFactory).instance().then(factory=>{this._editor=factory.createEditor({devtoolsAccessibleName:ls`Live expression editor`,lineNumbers:false,lineWrapping:true,mimeType:'javascript',autoHeight:true,placeholder:ls`Expression`});this._editor.configureAutocomplete(JavaScriptAutocomplete.JavaScriptAutocompleteConfig.createConfigForEditor(this._editor));this._editor.widget().show(nameElement);this._editor.widget().element.classList.add('console-pin-editor');this._editor.widget().element.tabIndex=-1;this._editor.setText(expression);this._editor.widget().element.addEventListener('keydown',event=>{if(event.key==='Tab'&&!this._editor.text()){event.consume();return;}
if(event.keyCode===KeyboardShortcut.Keys.Esc.code){this._editor.setText(this._committedExpression);}},true);this._editor.widget().element.addEventListener('focusout',event=>{const text=this._editor.text();const trimmedText=text.trim();if(text.length!==trimmedText.length){this._editor.setText(trimmedText);}
this._committedExpression=trimmedText;pinPane._savePins();this._editor.setSelection(TextRange.TextRange.createFromLocation(Infinity,Infinity));});});}
setHovered(hovered){if(this._hovered===hovered){return;}
this._hovered=hovered;if(!hovered&&this._lastNode){OverlayModel.OverlayModel.hideDOMNodeHighlight();}}
expression(){return this._committedExpression;}
element(){return this._pinElement;}
async focus(){await this._editorPromise;this._editor.widget().focus();this._editor.setSelection(TextRange.TextRange.createFromLocation(Infinity,Infinity));}
appendToContextMenu(contextMenu){if(this._lastResult&&this._lastResult.object){contextMenu.appendApplicableItems(this._lastResult.object);this._lastResult=null;}}
async updatePreview(){if(!this._editor){return;}
const text=this._editor.textWithCurrentSuggestion().trim();const isEditing=this._pinElement.hasFocus();const throwOnSideEffect=isEditing&&text!==this._committedExpression;const timeout=throwOnSideEffect?250:undefined;const executionContext=self.UI.context.flavor(RuntimeModel.ExecutionContext);const{preview,result}=await JavaScriptREPL.JavaScriptREPL.evaluateAndBuildPreview(text,throwOnSideEffect,timeout,!isEditing,'console');if(this._lastResult&&this._lastExecutionContext){this._lastExecutionContext.runtimeModel.releaseEvaluationResult(this._lastResult);}
this._lastResult=result||null;this._lastExecutionContext=executionContext||null;const previewText=preview.deepTextContent();if(!previewText||previewText!==this._pinPreview.deepTextContent()){this._pinPreview.removeChildren();if(result&&RuntimeModel.RuntimeModel.isSideEffectFailure(result)){const sideEffectLabel=this._pinPreview.createChild('span','object-value-calculate-value-button');sideEffectLabel.textContent='(…)';sideEffectLabel.title=ls`Evaluate, allowing side effects`;}else if(previewText){this._pinPreview.appendChild(preview);}else if(!isEditing){this._pinPreview.createTextChild(ls`not available`);}
this._pinPreview.title=previewText;}
let node=null;if(result&&result.object&&result.object.type==='object'&&result.object.subtype==='node'){node=result.object;}
if(this._hovered){if(node){OverlayModel.OverlayModel.highlightObjectAsDOMNode(node);}else if(this._lastNode){OverlayModel.OverlayModel.hideDOMNodeHighlight();}}
this._lastNode=node||null;const isError=result&&result.exceptionDetails&&!RuntimeModel.RuntimeModel.isSideEffectFailure(result);this._pinElement.classList.toggle('error-level',!!isError);}}
var ConsolePinPane$1=Object.freeze({__proto__:null,ConsolePinPane:ConsolePinPane,ConsolePin:ConsolePin});class ConsoleSidebar extends Widget.VBox{constructor(){super(true);this.setMinimumSize(125,0);this._tree=new TreeOutline.TreeOutlineInShadow();this._tree.registerRequiredCSS('console/consoleSidebar.css');this._tree.addEventListener(TreeOutline.Events.ElementSelected,this._selectionChanged.bind(this));this.contentElement.appendChild(this._tree.element);this._selectedTreeElement=null;this._treeElements=[];const selectedFilterSetting=Settings.Settings.instance().createSetting('console.sidebarSelectedFilter',null);const Levels=ConsoleModel.MessageLevel;const consoleAPIParsedFilters=[{key:FilterType.Source,text:ConsoleModel.MessageSource.ConsoleAPI,negative:false}];this._appendGroup(_groupName.All,[],ConsoleFilter.allLevelsFilterValue(),Icon.Icon.create('mediumicon-list'),selectedFilterSetting);this._appendGroup(_groupName.ConsoleAPI,consoleAPIParsedFilters,ConsoleFilter.allLevelsFilterValue(),Icon.Icon.create('mediumicon-account-circle'),selectedFilterSetting);this._appendGroup(_groupName.Error,[],ConsoleFilter.singleLevelMask(Levels.Error),Icon.Icon.create('mediumicon-error-circle'),selectedFilterSetting);this._appendGroup(_groupName.Warning,[],ConsoleFilter.singleLevelMask(Levels.Warning),Icon.Icon.create('mediumicon-warning-triangle'),selectedFilterSetting);this._appendGroup(_groupName.Info,[],ConsoleFilter.singleLevelMask(Levels.Info),Icon.Icon.create('mediumicon-info-circle'),selectedFilterSetting);this._appendGroup(_groupName.Verbose,[],ConsoleFilter.singleLevelMask(Levels.Verbose),Icon.Icon.create('mediumicon-bug'),selectedFilterSetting);const selectedTreeElementName=selectedFilterSetting.get();const defaultTreeElement=this._treeElements.find(x=>x.name()===selectedTreeElementName)||this._treeElements[0];defaultTreeElement.select();}
_appendGroup(name,parsedFilters,levelsMask,icon,selectedFilterSetting){const filter=new ConsoleFilter(name,parsedFilters,null,levelsMask);const treeElement=new FilterTreeElement(filter,icon,selectedFilterSetting);this._tree.appendChild(treeElement);this._treeElements.push(treeElement);}
clear(){for(const treeElement of this._treeElements){treeElement.clear();}}
onMessageAdded(viewMessage){for(const treeElement of this._treeElements){treeElement.onMessageAdded(viewMessage);}}
shouldBeVisible(viewMessage){if(!this._selectedTreeElement){return true;}
return this._selectedTreeElement._filter.shouldBeVisible(viewMessage);}
_selectionChanged(event){this._selectedTreeElement=(event.data);this.dispatchEventToListeners(Events.FilterSelected);}}
const Events={FilterSelected:Symbol('FilterSelected')};class URLGroupTreeElement extends TreeOutline.TreeElement{constructor(filter){super(filter.name);this._filter=filter;this._countElement=this.listItemElement.createChild('span','count');const leadingIcons=[Icon.Icon.create('largeicon-navigator-file')];this.setLeadingIcons(leadingIcons);this._messageCount=0;}
incrementAndUpdateCounter(){this._messageCount++;this._countElement.textContent=this._messageCount;}}
class FilterTreeElement extends TreeOutline.TreeElement{constructor(filter,icon,selectedFilterSetting){super(filter.name);this._filter=filter;this._selectedFilterSetting=selectedFilterSetting;this._urlTreeElements=new Map();this.setLeadingIcons([icon]);this._messageCount=0;this._updateCounter();}
clear(){this._urlTreeElements.clear();this.removeChildren();this._messageCount=0;this._updateCounter();}
name(){return this._filter.name;}
onselect(selectedByUser){this._selectedFilterSetting.set(this._filter.name);return super.onselect(selectedByUser);}
_updateCounter(){if(!this._messageCount){this.title=_groupNoMessageTitleMap.get(this._filter.name);}else if(this._messageCount===1){this.title=_groupSingularTitleMap.get(this._filter.name);}else{this.title=StringUtilities.sprintf(_groupPluralTitleMap.get(this._filter.name),this._messageCount);}
this.setExpandable(!!this.childCount());}
onMessageAdded(viewMessage){const message=viewMessage.consoleMessage();const shouldIncrementCounter=message.type!==ConsoleModel.MessageType.Command&&message.type!==ConsoleModel.MessageType.Result&&!message.isGroupMessage();if(!this._filter.shouldBeVisible(viewMessage)||!shouldIncrementCounter){return;}
const child=this._childElement(message.url);child.incrementAndUpdateCounter();this._messageCount++;this._updateCounter();}
_childElement(url){const urlValue=url||null;let child=this._urlTreeElements.get(urlValue);if(child){return child;}
const filter=this._filter.clone();const parsedURL=urlValue?ParsedURL.ParsedURL.fromString(urlValue):null;if(urlValue){filter.name=parsedURL?parsedURL.displayName:urlValue;}else{filter.name=UIString.UIString('<other>');}
filter.parsedFilters.push({key:FilterType.Url,text:urlValue,negative:false});child=new URLGroupTreeElement(filter);if(urlValue){child.tooltip=urlValue;}
this._urlTreeElements.set(urlValue,child);this.appendChild(child);return child;}}
const _groupName={ConsoleAPI:'user message',All:'message',Error:'error',Warning:'warning',Info:'info',Verbose:'verbose'};const _groupSingularTitleMap=new Map([[_groupName.ConsoleAPI,ls`1 user message`],[_groupName.All,ls`1 message`],[_groupName.Error,ls`1 error`],[_groupName.Warning,ls`1 warning`],[_groupName.Info,ls`1 info`],[_groupName.Verbose,ls`1 verbose`]]);const _groupPluralTitleMap=new Map([[_groupName.ConsoleAPI,ls`%d user messages`],[_groupName.All,ls`%d messages`],[_groupName.Error,ls`%d errors`],[_groupName.Warning,ls`%d warnings`],[_groupName.Info,ls`%d info`],[_groupName.Verbose,ls`%d verbose`]]);const _groupNoMessageTitleMap=new Map([[_groupName.ConsoleAPI,ls`No user messages`],[_groupName.All,ls`No messages`],[_groupName.Error,ls`No errors`],[_groupName.Warning,ls`No warnings`],[_groupName.Info,ls`No info`],[_groupName.Verbose,ls`No verbose`]]);var ConsoleSidebar$1=Object.freeze({__proto__:null,ConsoleSidebar:ConsoleSidebar,Events:Events,URLGroupTreeElement:URLGroupTreeElement,FilterTreeElement:FilterTreeElement});class ConsoleView extends Widget.VBox{constructor(){super();this.setMinimumSize(0,35);this.registerRequiredCSS('console/consoleView.css');this.registerRequiredCSS('object_ui/objectValue.css');this._searchableView=new SearchableView.SearchableView(this);this._searchableView.element.classList.add('console-searchable-view');this._searchableView.setPlaceholder(UIString.UIString('Find string in logs'));this._searchableView.setMinimalSearchQuerySize(0);this._sidebar=new ConsoleSidebar();this._sidebar.addEventListener(Events.FilterSelected,this._onFilterChanged.bind(this));this._isSidebarOpen=false;this._filter=new ConsoleViewFilter(this._onFilterChanged.bind(this));this._consoleToolbarContainer=this.element.createChild('div','console-toolbar-container');this._splitWidget=new SplitWidget.SplitWidget(true,false,'console.sidebar.width',100);this._splitWidget.setMainWidget(this._searchableView);this._splitWidget.setSidebarWidget(this._sidebar);this._splitWidget.show(this.element);this._splitWidget.hideSidebar();this._splitWidget.enableShowModeSaving();this._isSidebarOpen=this._splitWidget.showMode()===SplitWidget.ShowMode.Both;if(this._isSidebarOpen){this._filter._levelMenuButton.setEnabled(false);}
this._splitWidget.addEventListener(SplitWidget.Events.ShowModeChanged,event=>{this._isSidebarOpen=event.data===SplitWidget.ShowMode.Both;this._filter._levelMenuButton.setEnabled(!this._isSidebarOpen);this._onFilterChanged();});this._contentsElement=this._searchableView.element;this.element.classList.add('console-view');this._visibleViewMessages=[];this._hiddenByFilterCount=0;this._shouldBeHiddenCache=new Set();this._groupableMessages=new Map();this._groupableMessageTitle=new Map();this._regexMatchRanges=[];this._consoleContextSelector=new ConsoleContextSelector();this._filterStatusText=new Toolbar.ToolbarText();this._filterStatusText.element.classList.add('dimmed');this._showSettingsPaneSetting=Settings.Settings.instance().createSetting('consoleShowSettingsToolbar',false);this._showSettingsPaneButton=new Toolbar.ToolbarSettingToggle(this._showSettingsPaneSetting,'largeicon-settings-gear',UIString.UIString('Console settings'));this._progressToolbarItem=new Toolbar.ToolbarItem(createElement('div'));this._groupSimilarSetting=Settings.Settings.instance().moduleSetting('consoleGroupSimilar');this._groupSimilarSetting.addChangeListener(()=>this._updateMessageList());const groupSimilarToggle=new Toolbar.ToolbarSettingCheckbox(this._groupSimilarSetting,UIString.UIString('Group similar'));const toolbar=new Toolbar.Toolbar('console-main-toolbar',this._consoleToolbarContainer);const rightToolbar=new Toolbar.Toolbar('',this._consoleToolbarContainer);toolbar.appendToolbarItem(this._splitWidget.createShowHideSidebarButton(ls`console sidebar`));toolbar.appendToolbarItem(Toolbar.Toolbar.createActionButton((self.UI.actionRegistry.action('console.clear'))));toolbar.appendSeparator();toolbar.appendToolbarItem(this._consoleContextSelector.toolbarItem());toolbar.appendSeparator();const liveExpressionButton=Toolbar.Toolbar.createActionButton((self.UI.actionRegistry.action('console.create-pin')));toolbar.appendToolbarItem(liveExpressionButton);toolbar.appendSeparator();toolbar.appendToolbarItem(this._filter._textFilterUI);toolbar.appendToolbarItem(this._filter._levelMenuButton);toolbar.appendToolbarItem(this._progressToolbarItem);rightToolbar.appendSeparator();rightToolbar.appendToolbarItem(this._filterStatusText);rightToolbar.appendToolbarItem(this._showSettingsPaneButton);this._preserveLogCheckbox=new Toolbar.ToolbarSettingCheckbox(Settings.Settings.instance().moduleSetting('preserveConsoleLog'),UIString.UIString('Do not clear log on page reload / navigation'),UIString.UIString('Preserve log'));this._hideNetworkMessagesCheckbox=new Toolbar.ToolbarSettingCheckbox(this._filter._hideNetworkMessagesSetting,this._filter._hideNetworkMessagesSetting.title(),UIString.UIString('Hide network'));const filterByExecutionContextCheckbox=new Toolbar.ToolbarSettingCheckbox(this._filter._filterByExecutionContextSetting,UIString.UIString('Only show messages from the current context (top, iframe, worker, extension)'),UIString.UIString('Selected context only'));const monitoringXHREnabledSetting=Settings.Settings.instance().moduleSetting('monitoringXHREnabled');this._timestampsSetting=Settings.Settings.instance().moduleSetting('consoleTimestampsEnabled');this._consoleHistoryAutocompleteSetting=Settings.Settings.instance().moduleSetting('consoleHistoryAutocomplete');const settingsPane=new Widget.HBox();settingsPane.show(this._contentsElement);settingsPane.element.classList.add('console-settings-pane');ARIAUtils.setAccessibleName(settingsPane.element,ls`Console settings`);ARIAUtils.markAsGroup(settingsPane.element);const settingsToolbarLeft=new Toolbar.Toolbar('',settingsPane.element);settingsToolbarLeft.makeVertical();settingsToolbarLeft.appendToolbarItem(this._hideNetworkMessagesCheckbox);settingsToolbarLeft.appendToolbarItem(this._preserveLogCheckbox);settingsToolbarLeft.appendToolbarItem(filterByExecutionContextCheckbox);settingsToolbarLeft.appendToolbarItem(groupSimilarToggle);const settingsToolbarRight=new Toolbar.Toolbar('',settingsPane.element);settingsToolbarRight.makeVertical();settingsToolbarRight.appendToolbarItem(new Toolbar.ToolbarSettingCheckbox(monitoringXHREnabledSetting));const eagerEvalCheckbox=new Toolbar.ToolbarSettingCheckbox(Settings.Settings.instance().moduleSetting('consoleEagerEval'),ls`Eagerly evaluate text in the prompt`);settingsToolbarRight.appendToolbarItem(eagerEvalCheckbox);settingsToolbarRight.appendToolbarItem(new Toolbar.ToolbarSettingCheckbox(this._consoleHistoryAutocompleteSetting));const userGestureCheckbox=new Toolbar.ToolbarSettingCheckbox(Settings.Settings.instance().moduleSetting('consoleUserActivationEval'));settingsToolbarRight.appendToolbarItem(userGestureCheckbox);if(!this._showSettingsPaneSetting.get()){settingsPane.element.classList.add('hidden');}
this._showSettingsPaneSetting.addChangeListener(()=>settingsPane.element.classList.toggle('hidden',!this._showSettingsPaneSetting.get()));this._pinPane=new ConsolePinPane(liveExpressionButton);this._pinPane.element.classList.add('console-view-pinpane');this._pinPane.show(this._contentsElement);this._pinPane.element.addEventListener('keydown',event=>{if((event.key==='Enter'&&KeyboardShortcut.KeyboardShortcut.eventHasCtrlOrMeta((event)))||event.keyCode===KeyboardShortcut.Keys.Esc.code){this._prompt.focus();event.consume();}});this._viewport=new ConsoleViewport(this);this._viewport.setStickToBottom(true);this._viewport.contentElement().classList.add('console-group','console-group-messages');this._contentsElement.appendChild(this._viewport.element);this._messagesElement=this._viewport.element;this._messagesElement.id='console-messages';this._messagesElement.classList.add('monospace');this._messagesElement.addEventListener('click',this._messagesClicked.bind(this),false);this._messagesElement.addEventListener('paste',this._messagesPasted.bind(this),true);this._messagesElement.addEventListener('clipboard-paste',this._messagesPasted.bind(this),true);ARIAUtils.markAsGroup(this._messagesElement);this._viewportThrottler=new Throttler.Throttler(50);this._pendingBatchResize=false;this._onMessageResizedBound=this._onMessageResized.bind(this);this._topGroup=ConsoleGroup.createTopGroup();this._currentGroup=this._topGroup;this._promptElement=this._messagesElement.createChild('div','source-code');this._promptElement.id='console-prompt';const selectAllFixer=this._messagesElement.createChild('div','console-view-fix-select-all');selectAllFixer.textContent='.';ARIAUtils.markAsHidden(selectAllFixer);this._registerShortcuts();this._messagesElement.addEventListener('contextmenu',this._handleContextMenuEvent.bind(this),false);this._linkifier=new Linkifier.Linkifier(MaxLengthForLinks);this._consoleMessages=[];this._viewMessageSymbol=Symbol('viewMessage');this._consoleHistorySetting=Settings.Settings.instance().createLocalSetting('consoleHistory',[]);this._prompt=new ConsolePrompt();this._prompt.show(this._promptElement);this._prompt.element.addEventListener('keydown',this._promptKeyDown.bind(this),true);this._prompt.addEventListener(Events$1.TextChanged,this._promptTextChanged,this);this._messagesElement.addEventListener('keydown',this._messagesKeyDown.bind(this),false);this._prompt.element.addEventListener('focusin',()=>{if(this._isScrolledToBottom()){this._viewport.setStickToBottom(true);}});this._consoleHistoryAutocompleteSetting.addChangeListener(this._consoleHistoryAutocompleteChanged,this);const historyData=this._consoleHistorySetting.get();this._prompt.history().setHistoryData(historyData);this._consoleHistoryAutocompleteChanged();this._updateFilterStatus();this._timestampsSetting.addChangeListener(this._consoleTimestampsSettingChanged,this);this._registerWithMessageSink();self.UI.context.addFlavorChangeListener(RuntimeModel.ExecutionContext,this._executionContextChanged,this);this._messagesElement.addEventListener('mousedown',event=>this._updateStickToBottomOnPointerDown(event.button===2),false);this._messagesElement.addEventListener('mouseup',this._updateStickToBottomOnPointerUp.bind(this),false);this._messagesElement.addEventListener('mouseleave',this._updateStickToBottomOnPointerUp.bind(this),false);this._messagesElement.addEventListener('wheel',this._updateStickToBottomOnWheel.bind(this),false);this._messagesElement.addEventListener('touchstart',this._updateStickToBottomOnPointerDown.bind(this,false),false);this._messagesElement.addEventListener('touchend',this._updateStickToBottomOnPointerUp.bind(this),false);this._messagesElement.addEventListener('touchcancel',this._updateStickToBottomOnPointerUp.bind(this),false);ConsoleModel.ConsoleModel.instance().addEventListener(ConsoleModel.Events.ConsoleCleared,this._consoleCleared,this);ConsoleModel.ConsoleModel.instance().addEventListener(ConsoleModel.Events.MessageAdded,this._onConsoleMessageAdded,this);ConsoleModel.ConsoleModel.instance().addEventListener(ConsoleModel.Events.MessageUpdated,this._onConsoleMessageUpdated,this);ConsoleModel.ConsoleModel.instance().addEventListener(ConsoleModel.Events.CommandEvaluated,this._commandEvaluated,this);ConsoleModel.ConsoleModel.instance().messages().forEach(this._addConsoleMessage,this);if(Root.Runtime.experiments.isEnabled('issuesPane')){const issuesManager=IssuesManager.IssuesManager.instance();issuesManager.addEventListener(IssuesManager.Events.IssuesCountUpdated,this._onIssuesCountChanged.bind(this));if(issuesManager.numberOfIssues()){this._onIssuesCountChanged();}}}
_onIssuesCountChanged(){if(IssuesManager.IssuesManager.instance().numberOfIssues()===0){if(this._issueBarDiv){this._issueBarDiv.remove();this._issueBarDiv=null;}}else if(!this._issueBarDiv){this._issueBarDiv=document.createElement('div');this._issueBarDiv.classList.add('flex-none');const issueBarAction=({text:ls`Go to Issues`,highlight:false,delegate:()=>{userMetrics.issuesPanelOpenedFrom(UserMetrics.IssueOpener.ConsoleInfoBar);ViewManager.ViewManager.instance().showView('issues-pane');},dismiss:true,});const issueBar=new Infobar.Infobar(Infobar.Type.Warning,ls`Issues detected. The new Issues tab displays information about deprecations, breaking changes and other potential problems.`,[issueBarAction]);this.element.insertBefore(this._issueBarDiv,this._consoleToolbarContainer.nextSibling);this._issueBarDiv.appendChild(issueBar.element);issueBar.setParentView(this);this.doResize();}}
static instance(){if(!ConsoleView._instance){ConsoleView._instance=new ConsoleView();}
return ConsoleView._instance;}
static clearConsole(){ConsoleModel.ConsoleModel.instance().requestClearMessages();}
_onFilterChanged(){this._filter._currentFilter.levelsMask=this._isSidebarOpen?ConsoleFilter.allLevelsFilterValue():this._filter._messageLevelFiltersSetting.get();this._cancelBuildHiddenCache();if(this._immediatelyFilterMessagesForTest){for(const viewMessage of this._consoleMessages){this._computeShouldMessageBeVisible(viewMessage);}
this._updateMessageList();return;}
this._buildHiddenCache(0,this._consoleMessages.slice());}
_setImmediatelyFilterMessagesForTest(){this._immediatelyFilterMessagesForTest=true;}
searchableView(){return this._searchableView;}
_clearHistory(){this._consoleHistorySetting.set([]);this._prompt.history().setHistoryData([]);}
_consoleHistoryAutocompleteChanged(){this._prompt.setAddCompletionsFromHistory(this._consoleHistoryAutocompleteSetting.get());}
itemCount(){return this._visibleViewMessages.length;}
itemElement(index){return this._visibleViewMessages[index];}
fastHeight(index){return this._visibleViewMessages[index].fastHeight();}
minimumRowHeight(){return 16;}
_registerWithMessageSink(){Console$1.Console.instance().messages().forEach(this._addSinkMessage,this);Console$1.Console.instance().addEventListener(Console$1.Events.MessageAdded,messageAdded,this);function messageAdded(event){this._addSinkMessage((event.data));}}
_addSinkMessage(message){let level=ConsoleModel.MessageLevel.Verbose;switch(message.level){case Console$1.MessageLevel.Info:level=ConsoleModel.MessageLevel.Info;break;case Console$1.MessageLevel.Error:level=ConsoleModel.MessageLevel.Error;break;case Console$1.MessageLevel.Warning:level=ConsoleModel.MessageLevel.Warning;break;}
const consoleMessage=new ConsoleModel.ConsoleMessage(null,ConsoleModel.MessageSource.Other,level,message.text,ConsoleModel.MessageType.System,undefined,undefined,undefined,undefined,undefined,message.timestamp);this._addConsoleMessage(consoleMessage);}
_consoleTimestampsSettingChanged(){this._updateMessageList();this._consoleMessages.forEach(viewMessage=>viewMessage.updateTimestamp());this._groupableMessageTitle.forEach(viewMessage=>viewMessage.updateTimestamp());}
_executionContextChanged(){this._prompt.clearAutocomplete();}
willHide(){this._hidePromptSuggestBox();}
wasShown(){this._viewport.refresh();}
focus(){if(this._viewport.hasVirtualSelection()){this._viewport.contentElement().focus();}else{this._focusPrompt();}}
_focusPrompt(){if(!this._prompt.hasFocus()){const oldStickToBottom=this._viewport.stickToBottom();const oldScrollTop=this._viewport.element.scrollTop;this._prompt.focus();this._viewport.setStickToBottom(oldStickToBottom);this._viewport.element.scrollTop=oldScrollTop;}}
restoreScrollPositions(){if(this._viewport.stickToBottom()){this._immediatelyScrollToBottom();}else{super.restoreScrollPositions();}}
onResize(){this._scheduleViewportRefresh();this._hidePromptSuggestBox();if(this._viewport.stickToBottom()){this._immediatelyScrollToBottom();}
for(let i=0;i<this._visibleViewMessages.length;++i){this._visibleViewMessages[i].onResize();}}
_hidePromptSuggestBox(){this._prompt.clearAutocomplete();}
_invalidateViewport(){if(this._muteViewportUpdates){this._maybeDirtyWhileMuted=true;return Promise.resolve();}
if(this._needsFullUpdate){this._updateMessageList();delete this._needsFullUpdate;}else{this._viewport.invalidate();}
return Promise.resolve();}
_scheduleViewportRefresh(){if(this._muteViewportUpdates){this._maybeDirtyWhileMuted=true;this._scheduleViewportRefreshForTest(true);return;}
this._scheduleViewportRefreshForTest(false);this._scheduledRefreshPromiseForTest=this._viewportThrottler.schedule(this._invalidateViewport.bind(this));}
_scheduleViewportRefreshForTest(muted){}
_immediatelyScrollToBottom(){this._viewport.setStickToBottom(true);this._promptElement.scrollIntoView(true);}
_updateFilterStatus(){if(this._hiddenByFilterCount===this._lastShownHiddenByFilterCount){return;}
this._filterStatusText.setText(ls`${this._hiddenByFilterCount} hidden`);this._filterStatusText.setVisible(!!this._hiddenByFilterCount);this._lastShownHiddenByFilterCount=this._hiddenByFilterCount;}
_onConsoleMessageAdded(event){const message=(event.data);this._addConsoleMessage(message);}
_addConsoleMessage(message){const viewMessage=this._createViewMessage(message);message[this._viewMessageSymbol]=viewMessage;if(message.type===ConsoleModel.MessageType.Command||message.type===ConsoleModel.MessageType.Result){const lastMessage=this._consoleMessages.peekLast();viewMessage[_messageSortingTimeSymbol]=lastMessage?lastMessage[_messageSortingTimeSymbol]:0;}else{viewMessage[_messageSortingTimeSymbol]=viewMessage.consoleMessage().timestamp;}
let insertAt;if(!this._consoleMessages.length||timeComparator(viewMessage,this._consoleMessages[this._consoleMessages.length-1])>0){insertAt=this._consoleMessages.length;}else{insertAt=this._consoleMessages.upperBound(viewMessage,timeComparator);}
const insertedInMiddle=insertAt<this._consoleMessages.length;this._consoleMessages.splice(insertAt,0,viewMessage);this._filter.onMessageAdded(message);this._sidebar.onMessageAdded(viewMessage);let shouldGoIntoGroup=false;if(message.isGroupable()){const groupKey=viewMessage.groupKey();shouldGoIntoGroup=this._groupSimilarSetting.get()&&this._groupableMessages.has(groupKey);let list=this._groupableMessages.get(groupKey);if(!list){list=[];this._groupableMessages.set(groupKey,list);}
list.push(viewMessage);}
this._computeShouldMessageBeVisible(viewMessage);if(!shouldGoIntoGroup&&!insertedInMiddle){this._appendMessageToEnd(viewMessage);this._updateFilterStatus();this._searchableView.updateSearchMatchesCount(this._regexMatchRanges.length);}else{this._needsFullUpdate=true;}
this._scheduleViewportRefresh();this._consoleMessageAddedForTest(viewMessage);function timeComparator(viewMessage1,viewMessage2){return viewMessage1[_messageSortingTimeSymbol]-viewMessage2[_messageSortingTimeSymbol];}}
_onConsoleMessageUpdated(event){const message=(event.data);const viewMessage=message[this._viewMessageSymbol];if(viewMessage){viewMessage.updateMessageElement();this._computeShouldMessageBeVisible(viewMessage);this._updateMessageList();}}
_consoleMessageAddedForTest(viewMessage){}
_shouldMessageBeVisible(viewMessage){return!this._shouldBeHiddenCache.has(viewMessage);}
_computeShouldMessageBeVisible(viewMessage){if(this._filter.shouldBeVisible(viewMessage)&&(!this._isSidebarOpen||this._sidebar.shouldBeVisible(viewMessage))){this._shouldBeHiddenCache.delete(viewMessage);}else{this._shouldBeHiddenCache.add(viewMessage);}}
_appendMessageToEnd(viewMessage,preventCollapse){if(!this._shouldMessageBeVisible(viewMessage)){this._hiddenByFilterCount++;return;}
if(!preventCollapse&&this._tryToCollapseMessages(viewMessage,this._visibleViewMessages.peekLast())){return;}
const lastMessage=this._visibleViewMessages.peekLast();if(viewMessage.consoleMessage().type===ConsoleModel.MessageType.EndGroup){if(lastMessage&&!this._currentGroup.messagesHidden()){lastMessage.incrementCloseGroupDecorationCount();}
this._currentGroup=this._currentGroup.parentGroup()||this._currentGroup;return;}
if(!this._currentGroup.messagesHidden()){const originatingMessage=viewMessage.consoleMessage().originatingMessage();if(lastMessage&&originatingMessage&&lastMessage.consoleMessage()===originatingMessage){viewMessage.toMessageElement().classList.add('console-adjacent-user-command-result');}
this._visibleViewMessages.push(viewMessage);this._searchMessage(this._visibleViewMessages.length-1);}
if(viewMessage.consoleMessage().isGroupStartMessage()){this._currentGroup=new ConsoleGroup(this._currentGroup,viewMessage);}
this._messageAppendedForTests();}
_messageAppendedForTests(){}
_createViewMessage(message){const nestingLevel=this._currentGroup.nestingLevel();switch(message.type){case ConsoleModel.MessageType.Command:return new ConsoleCommand(message,this._linkifier,nestingLevel,this._onMessageResizedBound);case ConsoleModel.MessageType.Result:return new ConsoleCommandResult(message,this._linkifier,nestingLevel,this._onMessageResizedBound);case ConsoleModel.MessageType.StartGroupCollapsed:case ConsoleModel.MessageType.StartGroup:return new ConsoleGroupViewMessage(message,this._linkifier,nestingLevel,this._updateMessageList.bind(this),this._onMessageResizedBound);default:return new ConsoleViewMessage(message,this._linkifier,nestingLevel,this._onMessageResizedBound);}}
async _onMessageResized(event){const treeElement=(event.data);if(this._pendingBatchResize||!treeElement.treeOutline){return;}
this._pendingBatchResize=true;await Promise.resolve();const treeOutlineElement=treeElement.treeOutline.element;this._viewport.setStickToBottom(this._isScrolledToBottom());if(treeOutlineElement.offsetHeight<=this._messagesElement.offsetHeight){treeOutlineElement.scrollIntoViewIfNeeded();}
this._pendingBatchResize=false;}
_consoleCleared(){const hadFocus=this._viewport.element.hasFocus();this._cancelBuildHiddenCache();this._currentMatchRangeIndex=-1;this._consoleMessages=[];this._groupableMessages.clear();this._groupableMessageTitle.clear();this._sidebar.clear();this._updateMessageList();this._hidePromptSuggestBox();this._viewport.setStickToBottom(true);this._linkifier.reset();this._filter.clear();if(hadFocus){this._prompt.focus();}}
_handleContextMenuEvent(event){const contextMenu=new ContextMenu.ContextMenu(event);if(event.target.isSelfOrDescendant(this._promptElement)){contextMenu.show();return;}
const sourceElement=event.target.enclosingNodeOrSelfWithClass('console-message-wrapper');const consoleMessage=sourceElement?sourceElement.message.consoleMessage():null;if(consoleMessage&&consoleMessage.url){const menuTitle=ls`Hide messages from ${new ParsedURL.ParsedURL(consoleMessage.url).displayName}`;contextMenu.headerSection().appendItem(menuTitle,this._filter.addMessageURLFilter.bind(this._filter,consoleMessage.url));}
contextMenu.defaultSection().appendAction('console.clear');contextMenu.defaultSection().appendAction('console.clear.history');contextMenu.saveSection().appendItem(UIString.UIString('Save as...'),this._saveConsole.bind(this));if(this.element.hasSelection()){contextMenu.clipboardSection().appendItem(UIString.UIString('Copy visible styled selection'),this._viewport.copyWithStyles.bind(this._viewport));}
if(consoleMessage){const request=NetworkLog.NetworkLog.requestForConsoleMessage(consoleMessage);if(request&&NetworkManager.NetworkManager.canReplayRequest(request)){contextMenu.debugSection().appendItem(ls`Replay XHR`,NetworkManager.NetworkManager.replayRequest.bind(null,request));}}
contextMenu.show();}
async _saveConsole(){const url=SDKModel.TargetManager.instance().mainTarget().inspectedURL();const parsedURL=ParsedURL.ParsedURL.fromString(url);const filename=StringUtilities.sprintf('%s-%d.log',parsedURL?parsedURL.host:'console',Date.now());const stream=new FileUtils.FileOutputStream();const progressIndicator=new ProgressIndicator.ProgressIndicator();progressIndicator.setTitle(UIString.UIString('Writing file…'));progressIndicator.setTotalWork(this.itemCount());const chunkSize=350;if(!await stream.open(filename)){return;}
this._progressToolbarItem.element.appendChild(progressIndicator.element);let messageIndex=0;while(messageIndex<this.itemCount()&&!progressIndicator.isCanceled()){const messageContents=[];let i;for(i=0;i<chunkSize&&i+messageIndex<this.itemCount();++i){const message=(this.itemElement(messageIndex+i));messageContents.push(message.toExportString());}
messageIndex+=i;await stream.write(messageContents.join('\n')+'\n');progressIndicator.setWorked(messageIndex);}
stream.close();progressIndicator.done();}
_tryToCollapseMessages(viewMessage,lastMessage){const timestampsShown=this._timestampsSetting.get();if(!timestampsShown&&lastMessage&&!viewMessage.consoleMessage().isGroupMessage()&&viewMessage.consoleMessage().type!==ConsoleModel.MessageType.Command&&viewMessage.consoleMessage().type!==ConsoleModel.MessageType.Result&&viewMessage.consoleMessage().isEqual(lastMessage.consoleMessage())){lastMessage.incrementRepeatCount();if(viewMessage.isLastInSimilarGroup()){lastMessage.setInSimilarGroup(true,true);}
return true;}
return false;}
_buildHiddenCache(startIndex,viewMessages){const startTime=Date.now();let i;for(i=startIndex;i<viewMessages.length;++i){this._computeShouldMessageBeVisible(viewMessages[i]);if(i%10===0&&Date.now()-startTime>12){break;}}
if(i===viewMessages.length){this._updateMessageList();return;}
this._buildHiddenCacheTimeout=this.element.window().requestAnimationFrame(this._buildHiddenCache.bind(this,i,viewMessages));}
_cancelBuildHiddenCache(){this._shouldBeHiddenCache.clear();if(this._buildHiddenCacheTimeout){this.element.window().cancelAnimationFrame(this._buildHiddenCacheTimeout);delete this._buildHiddenCacheTimeout;}}
_updateMessageList(){this._topGroup=ConsoleGroup.createTopGroup();this._currentGroup=this._topGroup;this._regexMatchRanges=[];this._hiddenByFilterCount=0;for(let i=0;i<this._visibleViewMessages.length;++i){this._visibleViewMessages[i].resetCloseGroupDecorationCount();this._visibleViewMessages[i].resetIncrementRepeatCount();}
this._visibleViewMessages=[];if(this._groupSimilarSetting.get()){this._addGroupableMessagesToEnd();}else{for(let i=0;i<this._consoleMessages.length;++i){this._consoleMessages[i].setInSimilarGroup(false);this._appendMessageToEnd(this._consoleMessages[i]);}}
this._updateFilterStatus();this._searchableView.updateSearchMatchesCount(this._regexMatchRanges.length);this._viewport.invalidate();}
_addGroupableMessagesToEnd(){const alreadyAdded=new Set();const processedGroupKeys=new Set();for(let i=0;i<this._consoleMessages.length;++i){const viewMessage=this._consoleMessages[i];const message=viewMessage.consoleMessage();if(alreadyAdded.has(message)){continue;}
if(!message.isGroupable()){this._appendMessageToEnd(viewMessage);alreadyAdded.add(message);continue;}
const key=viewMessage.groupKey();const viewMessagesInGroup=this._groupableMessages.get(key);if(!viewMessagesInGroup||viewMessagesInGroup.length<5){viewMessage.setInSimilarGroup(false);this._appendMessageToEnd(viewMessage);alreadyAdded.add(message);continue;}
if(processedGroupKeys.has(key)){continue;}
if(!viewMessagesInGroup.find(x=>this._shouldMessageBeVisible(x))){alreadyAdded.addAll(viewMessagesInGroup);processedGroupKeys.add(key);continue;}
let startGroupViewMessage=this._groupableMessageTitle.get(key);if(!startGroupViewMessage){const startGroupMessage=new ConsoleModel.ConsoleMessage(null,message.source,message.level,viewMessage.groupTitle(),ConsoleModel.MessageType.StartGroupCollapsed);startGroupViewMessage=this._createViewMessage(startGroupMessage);this._groupableMessageTitle.set(key,startGroupViewMessage);}
startGroupViewMessage.setRepeatCount(viewMessagesInGroup.length);this._appendMessageToEnd(startGroupViewMessage);for(const viewMessageInGroup of viewMessagesInGroup){viewMessageInGroup.setInSimilarGroup(true,viewMessagesInGroup.peekLast()===viewMessageInGroup);this._appendMessageToEnd(viewMessageInGroup,true);alreadyAdded.add(viewMessageInGroup.consoleMessage());}
const endGroupMessage=new ConsoleModel.ConsoleMessage(null,message.source,message.level,message.messageText,ConsoleModel.MessageType.EndGroup);this._appendMessageToEnd(this._createViewMessage(endGroupMessage));}}
_messagesClicked(event){const target=(event.target);if(!this._messagesElement.hasSelection()){const clickedOutsideMessageList=target===this._messagesElement||this._prompt.belowEditorElement().isSelfOrAncestor(target);if(clickedOutsideMessageList){this._prompt.moveCaretToEndOfPrompt();this._focusPrompt();}}}
_messagesKeyDown(event){const hasActionModifier=event.ctrlKey||event.altKey||event.metaKey;if(hasActionModifier||event.key.length!==1||UIUtils.isEditing()||this._messagesElement.hasSelection()){return;}
this._prompt.moveCaretToEndOfPrompt();this._focusPrompt();}
_messagesPasted(event){if(UIUtils.isEditing()){return;}
this._prompt.focus();}
_registerShortcuts(){this._shortcuts={};this._shortcuts[KeyboardShortcut.KeyboardShortcut.makeKey('u',KeyboardShortcut.Modifiers.Ctrl)]=this._clearPromptBackwards.bind(this);}
_clearPromptBackwards(){this._prompt.setText('');}
_promptKeyDown(event){const keyboardEvent=(event);if(keyboardEvent.key==='PageUp'){this._updateStickToBottomOnWheel();return;}
const shortcut=KeyboardShortcut.KeyboardShortcut.makeKeyFromEvent(keyboardEvent);const handler=this._shortcuts[shortcut];if(handler){handler();keyboardEvent.preventDefault();}}
_printResult(result,originatingConsoleMessage,exceptionDetails){if(!result){return;}
const level=!!exceptionDetails?ConsoleModel.MessageLevel.Error:ConsoleModel.MessageLevel.Info;let message;if(!exceptionDetails){message=new ConsoleModel.ConsoleMessage(result.runtimeModel(),ConsoleModel.MessageSource.JS,level,'',ConsoleModel.MessageType.Result,undefined,undefined,undefined,[result]);}else{message=ConsoleModel.ConsoleMessage.fromException(result.runtimeModel(),exceptionDetails,ConsoleModel.MessageType.Result,undefined,undefined);}
message.setOriginatingMessage(originatingConsoleMessage);ConsoleModel.ConsoleModel.instance().addMessage(message);}
_commandEvaluated(event){const data=(event.data);this._prompt.history().pushHistoryItem(data.commandMessage.messageText);this._consoleHistorySetting.set(this._prompt.history().historyData().slice(-persistedHistorySize));this._printResult(data.result,data.commandMessage,data.exceptionDetails);}
elementsToRestoreScrollPositionsFor(){return[this._messagesElement];}
searchCanceled(){this._cleanupAfterSearch();for(let i=0;i<this._visibleViewMessages.length;++i){const message=this._visibleViewMessages[i];message.setSearchRegex(null);}
this._currentMatchRangeIndex=-1;this._regexMatchRanges=[];delete this._searchRegex;this._viewport.refresh();}
performSearch(searchConfig,shouldJump,jumpBackwards){this.searchCanceled();this._searchableView.updateSearchMatchesCount(0);this._searchRegex=searchConfig.toSearchRegex(true);this._regexMatchRanges=[];this._currentMatchRangeIndex=-1;if(shouldJump){this._searchShouldJumpBackwards=!!jumpBackwards;}
this._searchProgressIndicator=new ProgressIndicator.ProgressIndicator();this._searchProgressIndicator.setTitle(UIString.UIString('Searching…'));this._searchProgressIndicator.setTotalWork(this._visibleViewMessages.length);this._progressToolbarItem.element.appendChild(this._searchProgressIndicator.element);this._innerSearch(0);}
_cleanupAfterSearch(){delete this._searchShouldJumpBackwards;if(this._innerSearchTimeoutId){clearTimeout(this._innerSearchTimeoutId);delete this._innerSearchTimeoutId;}
if(this._searchProgressIndicator){this._searchProgressIndicator.done();delete this._searchProgressIndicator;}}
_searchFinishedForTests(){}
_innerSearch(index){delete this._innerSearchTimeoutId;if(this._searchProgressIndicator.isCanceled()){this._cleanupAfterSearch();return;}
const startTime=Date.now();for(;index<this._visibleViewMessages.length&&Date.now()-startTime<100;++index){this._searchMessage(index);}
this._searchableView.updateSearchMatchesCount(this._regexMatchRanges.length);if(typeof this._searchShouldJumpBackwards!=='undefined'&&this._regexMatchRanges.length){this._jumpToMatch(this._searchShouldJumpBackwards?-1:0);delete this._searchShouldJumpBackwards;}
if(index===this._visibleViewMessages.length){this._cleanupAfterSearch();setTimeout(this._searchFinishedForTests.bind(this),0);return;}
this._innerSearchTimeoutId=setTimeout(this._innerSearch.bind(this,index),100);this._searchProgressIndicator.setWorked(index);}
_searchMessage(index){const message=this._visibleViewMessages[index];message.setSearchRegex(this._searchRegex);for(let i=0;i<message.searchCount();++i){this._regexMatchRanges.push({messageIndex:index,matchIndex:i});}}
jumpToNextSearchResult(){this._jumpToMatch(this._currentMatchRangeIndex+1);}
jumpToPreviousSearchResult(){this._jumpToMatch(this._currentMatchRangeIndex-1);}
supportsCaseSensitiveSearch(){return true;}
supportsRegexSearch(){return true;}
_jumpToMatch(index){if(!this._regexMatchRanges.length){return;}
let matchRange;if(this._currentMatchRangeIndex>=0){matchRange=this._regexMatchRanges[this._currentMatchRangeIndex];const message=this._visibleViewMessages[matchRange.messageIndex];message.searchHighlightNode(matchRange.matchIndex).classList.remove(UIUtils.highlightedCurrentSearchResultClassName);}
index=NumberUtilities.mod(index,this._regexMatchRanges.length);this._currentMatchRangeIndex=index;this._searchableView.updateCurrentMatchIndex(index);matchRange=this._regexMatchRanges[index];const message=this._visibleViewMessages[matchRange.messageIndex];const highlightNode=message.searchHighlightNode(matchRange.matchIndex);highlightNode.classList.add(UIUtils.highlightedCurrentSearchResultClassName);this._viewport.scrollItemIntoView(matchRange.messageIndex);highlightNode.scrollIntoViewIfNeeded();}
_updateStickToBottomOnPointerDown(isRightClick){this._muteViewportUpdates=!isRightClick;this._viewport.setStickToBottom(false);if(this._waitForScrollTimeout){clearTimeout(this._waitForScrollTimeout);delete this._waitForScrollTimeout;}}
_updateStickToBottomOnPointerUp(){if(!this._muteViewportUpdates){return;}
this._waitForScrollTimeout=setTimeout(updateViewportState.bind(this),200);function updateViewportState(){this._muteViewportUpdates=false;if(this.isShowing()){this._viewport.setStickToBottom(this._isScrolledToBottom());}
if(this._maybeDirtyWhileMuted){this._scheduleViewportRefresh();delete this._maybeDirtyWhileMuted;}
delete this._waitForScrollTimeout;this._updateViewportStickinessForTest();}}
_updateViewportStickinessForTest(){}
_updateStickToBottomOnWheel(){this._updateStickToBottomOnPointerDown();this._updateStickToBottomOnPointerUp();}
_promptTextChanged(){const oldStickToBottom=this._viewport.stickToBottom();const willStickToBottom=this._isScrolledToBottom();this._viewport.setStickToBottom(willStickToBottom);if(willStickToBottom&&!oldStickToBottom){this._scheduleViewportRefresh();}
this._promptTextChangedForTest();}
_promptTextChangedForTest(){}
_isScrolledToBottom(){const distanceToPromptEditorBottom=this._messagesElement.scrollHeight-this._messagesElement.scrollTop-
this._messagesElement.clientHeight-this._prompt.belowEditorElement().offsetHeight;return distanceToPromptEditorBottom<=2;}}
const persistedHistorySize=300;class ConsoleViewFilter{constructor(filterChangedCallback){this._filterChanged=filterChangedCallback;this._messageLevelFiltersSetting=ConsoleViewFilter.levelFilterSetting();this._hideNetworkMessagesSetting=Settings.Settings.instance().moduleSetting('hideNetworkMessages');this._filterByExecutionContextSetting=Settings.Settings.instance().moduleSetting('selectedContextFilterEnabled');this._messageLevelFiltersSetting.addChangeListener(this._onFilterChanged.bind(this));this._hideNetworkMessagesSetting.addChangeListener(this._onFilterChanged.bind(this));this._filterByExecutionContextSetting.addChangeListener(this._onFilterChanged.bind(this));self.UI.context.addFlavorChangeListener(RuntimeModel.ExecutionContext,this._onFilterChanged,this);const filterKeys=Object.values(FilterType);this._suggestionBuilder=new FilterSuggestionBuilder.FilterSuggestionBuilder(filterKeys);this._textFilterUI=new Toolbar.ToolbarInput(UIString.UIString('Filter'),'',0.2,1,UIString.UIString('e.g. /event\\d/ -cdn url:a.com'),this._suggestionBuilder.completions.bind(this._suggestionBuilder));this._textFilterSetting=Settings.Settings.instance().createSetting('console.textFilter','');if(this._textFilterSetting.get()){this._textFilterUI.setValue(this._textFilterSetting.get());}
this._textFilterUI.addEventListener(Toolbar.ToolbarInput.Event.TextChanged,()=>{this._textFilterSetting.set(this._textFilterUI.value());this._onFilterChanged();});this._filterParser=new TextUtils.FilterParser(filterKeys);this._currentFilter=new ConsoleFilter('',[],null,this._messageLevelFiltersSetting.get());this._updateCurrentFilter();this._levelLabels={};this._levelLabels[ConsoleModel.MessageLevel.Verbose]=UIString.UIString('Verbose');this._levelLabels[ConsoleModel.MessageLevel.Info]=UIString.UIString('Info');this._levelLabels[ConsoleModel.MessageLevel.Warning]=UIString.UIString('Warnings');this._levelLabels[ConsoleModel.MessageLevel.Error]=UIString.UIString('Errors');this._levelMenuButton=new Toolbar.ToolbarButton(ls`Log levels`);this._levelMenuButton.turnIntoSelect();this._levelMenuButton.addEventListener(Toolbar.ToolbarButton.Events.Click,this._showLevelContextMenu.bind(this));ARIAUtils.markAsMenuButton(this._levelMenuButton.element);this._updateLevelMenuButtonText();this._messageLevelFiltersSetting.addChangeListener(this._updateLevelMenuButtonText.bind(this));}
onMessageAdded(message){if(message.type===ConsoleModel.MessageType.Command||message.type===ConsoleModel.MessageType.Result||message.isGroupMessage()){return;}
if(message.context){this._suggestionBuilder.addItem(FilterType.Context,message.context);}
if(message.source){this._suggestionBuilder.addItem(FilterType.Source,message.source);}
if(message.url){this._suggestionBuilder.addItem(FilterType.Url,message.url);}}
static levelFilterSetting(){return Settings.Settings.instance().createSetting('messageLevelFilters',ConsoleFilter.defaultLevelsFilterValue());}
_updateCurrentFilter(){const parsedFilters=this._filterParser.parse(this._textFilterUI.value());if(this._hideNetworkMessagesSetting.get()){parsedFilters.push({key:FilterType.Source,text:ConsoleModel.MessageSource.Network,negative:true});}
this._currentFilter.executionContext=this._filterByExecutionContextSetting.get()?self.UI.context.flavor(RuntimeModel.ExecutionContext):null;this._currentFilter.parsedFilters=parsedFilters;this._currentFilter.levelsMask=this._messageLevelFiltersSetting.get();}
_onFilterChanged(){this._updateCurrentFilter();this._filterChanged();}
_updateLevelMenuButtonText(){let isAll=true;let isDefault=true;const allValue=ConsoleFilter.allLevelsFilterValue();const defaultValue=ConsoleFilter.defaultLevelsFilterValue();let text=null;const levels=this._messageLevelFiltersSetting.get();for(const name of Object.values(ConsoleModel.MessageLevel)){isAll=isAll&&levels[name]===allValue[name];isDefault=isDefault&&levels[name]===defaultValue[name];if(levels[name]){text=text?UIString.UIString('Custom levels'):UIString.UIString('%s only',this._levelLabels[name]);}}
if(isAll){text=UIString.UIString('All levels');}else if(isDefault){text=UIString.UIString('Default levels');}else{text=text||UIString.UIString('Hide all');}
this._levelMenuButton.element.classList.toggle('warning',!isAll&&!isDefault);this._levelMenuButton.setText(text);this._levelMenuButton.setTitle(ls`Log level: ${text}`);}
_showLevelContextMenu(event){const mouseEvent=(event.data);const setting=this._messageLevelFiltersSetting;const levels=setting.get();const contextMenu=new ContextMenu.ContextMenu(mouseEvent,true,this._levelMenuButton.element.totalOffsetLeft(),this._levelMenuButton.element.totalOffsetTop()+this._levelMenuButton.element.offsetHeight);contextMenu.headerSection().appendItem(UIString.UIString('Default'),()=>setting.set(ConsoleFilter.defaultLevelsFilterValue()));for(const level in this._levelLabels){contextMenu.defaultSection().appendCheckboxItem(this._levelLabels[level],toggleShowLevel.bind(null,level),levels[level]);}
contextMenu.show();function toggleShowLevel(level){levels[level]=!levels[level];setting.set(levels);}}
addMessageURLFilter(url){if(!url){return;}
const suffix=this._textFilterUI.value()?` ${this._textFilterUI.value()}`:'';this._textFilterUI.setValue(`-url:${url}${suffix}`);this._textFilterSetting.set(this._textFilterUI.value());this._onFilterChanged();}
shouldBeVisible(viewMessage){return this._currentFilter.shouldBeVisible(viewMessage);}
clear(){this._suggestionBuilder.clear();}
reset(){this._messageLevelFiltersSetting.set(ConsoleFilter.defaultLevelsFilterValue());this._filterByExecutionContextSetting.set(false);this._hideNetworkMessagesSetting.set(false);this._textFilterUI.setValue('');this._onFilterChanged();}}
class ConsoleCommand extends ConsoleViewMessage{contentElement(){if(!this._contentElement){this._contentElement=document.createElement('div');this._contentElement.classList.add('console-user-command');const icon=Icon.Icon.create('smallicon-user-command','command-result-icon');this._contentElement.appendChild(icon);this._contentElement.message=this;this._formattedCommand=document.createElement('span');this._formattedCommand.classList.add('source-code');this._formattedCommand.textContent=StringUtilities.replaceControlCharacters(this.text);this._contentElement.appendChild(this._formattedCommand);if(this._formattedCommand.textContent.length<MaxLengthToIgnoreHighlighter){const javascriptSyntaxHighlighter=new SyntaxHighlighter.SyntaxHighlighter('text/javascript',true);javascriptSyntaxHighlighter.syntaxHighlightNode(this._formattedCommand).then(this._updateSearch.bind(this));}else{this._updateSearch();}
this.updateTimestamp();}
return this._contentElement;}
_updateSearch(){this.setSearchRegex(this.searchRegex());}}
class ConsoleCommandResult extends ConsoleViewMessage{contentElement(){const element=super.contentElement();if(!element.classList.contains('console-user-command-result')){element.classList.add('console-user-command-result');if(this.consoleMessage().level===ConsoleModel.MessageLevel.Info){const icon=Icon.Icon.create('smallicon-command-result','command-result-icon');element.insertBefore(icon,element.firstChild);}}
return element;}}
class ConsoleGroup{constructor(parentGroup,groupMessage){this._parentGroup=parentGroup;this._nestingLevel=parentGroup?parentGroup.nestingLevel()+1:0;this._messagesHidden=groupMessage&&groupMessage.collapsed()||this._parentGroup&&this._parentGroup.messagesHidden();}
static createTopGroup(){return new ConsoleGroup(null,null);}
messagesHidden(){return this._messagesHidden;}
nestingLevel(){return this._nestingLevel;}
parentGroup(){return this._parentGroup;}}
class ActionDelegate{handleAction(context,actionId){switch(actionId){case'console.show':InspectorFrontendHost.InspectorFrontendHostInstance.bringToFront();Console$1.Console.instance().show();ConsoleView.instance()._focusPrompt();return true;case'console.clear':ConsoleView.clearConsole();return true;case'console.clear.history':ConsoleView.instance()._clearHistory();return true;case'console.create-pin':ConsoleView.instance()._pinPane.addPin('',true);return true;}
return false;}}
const _messageSortingTimeSymbol=Symbol('messageSortingTime');const MaxLengthToIgnoreHighlighter=10000;let RegexMatchRange;var ConsoleView$1=Object.freeze({__proto__:null,ConsoleView:ConsoleView,ConsoleViewFilter:ConsoleViewFilter,ConsoleCommand:ConsoleCommand,ConsoleGroup:ConsoleGroup,ActionDelegate:ActionDelegate,RegexMatchRange:RegexMatchRange});class ConsolePanel extends Panel.Panel{constructor(){super('console');this._view=ConsoleView.instance();}
static instance(){return(self.runtime.sharedInstance(ConsolePanel));}
static _updateContextFlavor(){const consoleView=ConsolePanel.instance()._view;self.UI.context.setFlavor(ConsoleView,consoleView.isShowing()?consoleView:null);}
wasShown(){super.wasShown();const wrapper=WrapperView._instance;if(wrapper&&wrapper.isShowing()){self.UI.inspectorView.setDrawerMinimized(true);}
this._view.show(this.element);ConsolePanel._updateContextFlavor();}
willHide(){super.willHide();self.UI.inspectorView.setDrawerMinimized(false);if(WrapperView._instance){WrapperView._instance._showViewInWrapper();}
ConsolePanel._updateContextFlavor();}
searchableView(){return ConsoleView.instance().searchableView();}}
class WrapperView extends Widget.VBox{constructor(){super();this.element.classList.add('console-view-wrapper');WrapperView._instance=this;this._view=ConsoleView.instance();}
wasShown(){if(!ConsolePanel.instance().isShowing()){this._showViewInWrapper();}else{self.UI.inspectorView.setDrawerMinimized(true);}
ConsolePanel._updateContextFlavor();}
willHide(){self.UI.inspectorView.setDrawerMinimized(false);ConsolePanel._updateContextFlavor();}
_showViewInWrapper(){this._view.show(this.element);}}
class ConsoleRevealer{reveal(object){const consoleView=ConsoleView.instance();if(consoleView.isShowing()){consoleView.focus();return Promise.resolve();}
ViewManager.ViewManager.instance().showView('console-view');return Promise.resolve();}}
var ConsolePanel$1=Object.freeze({__proto__:null,ConsolePanel:ConsolePanel,WrapperView:WrapperView,ConsoleRevealer:ConsoleRevealer});class ConsolePrompt extends Widget.Widget{constructor(){super();this.registerRequiredCSS('console/consolePrompt.css');this._addCompletionsFromHistory=true;this._history=new ConsoleHistoryManager();this._initialText='';this._editor=null;this._eagerPreviewElement=document.createElement('div');this._eagerPreviewElement.classList.add('console-eager-preview');this._textChangeThrottler=new Throttler.Throttler(150);this._formatter=new RemoteObjectPreviewFormatter.RemoteObjectPreviewFormatter();this._requestPreviewBound=this._requestPreview.bind(this);this._innerPreviewElement=this._eagerPreviewElement.createChild('div','console-eager-inner-preview');this._eagerPreviewElement.appendChild(Icon.Icon.create('smallicon-command-result','preview-result-icon'));const editorContainerElement=this.element.createChild('div','console-prompt-editor-container');this.element.appendChild(this._eagerPreviewElement);this._promptIcon=Icon.Icon.create('smallicon-text-prompt','console-prompt-icon');this.element.appendChild(this._promptIcon);this._iconThrottler=new Throttler.Throttler(0);this._eagerEvalSetting=Settings.Settings.instance().moduleSetting('consoleEagerEval');this._eagerEvalSetting.addChangeListener(this._eagerSettingChanged.bind(this));this._eagerPreviewElement.classList.toggle('hidden',!this._eagerEvalSetting.get());this.element.tabIndex=0;this._previewRequestForTest=null;this._defaultAutocompleteConfig=null;this._highlightingNode=false;self.runtime.extension(TextEditor.TextEditorFactory).instance().then(gotFactory.bind(this));function gotFactory(factory){this._editor=factory.createEditor({devtoolsAccessibleName:ls`Console prompt`,lineNumbers:false,lineWrapping:true,mimeType:'javascript',autoHeight:true});this._defaultAutocompleteConfig=JavaScriptAutocomplete.JavaScriptAutocompleteConfig.createConfigForEditor(this._editor);this._editor.configureAutocomplete(Object.assign({},this._defaultAutocompleteConfig,{suggestionsCallback:this._wordsWithQuery.bind(this),anchorBehavior:GlassPane.AnchorBehavior.PreferTop}));this._editor.widget().element.addEventListener('keydown',this._editorKeyDown.bind(this),true);this._editor.widget().show(editorContainerElement);this._editor.addEventListener(TextEditor.Events.CursorChanged,this._updatePromptIcon,this);this._editor.addEventListener(TextEditor.Events.TextChanged,this._onTextChanged,this);this._editor.addEventListener(TextEditor.Events.SuggestionChanged,this._onTextChanged,this);this.setText(this._initialText);delete this._initialText;if(this.hasFocus()){this.focus();}
this.element.removeAttribute('tabindex');this._editor.widget().element.tabIndex=-1;this._editorSetForTest();userMetrics.panelLoaded('console','DevTools.Launch.Console');}}
_eagerSettingChanged(){const enabled=this._eagerEvalSetting.get();this._eagerPreviewElement.classList.toggle('hidden',!enabled);if(enabled){this._requestPreview();}}
belowEditorElement(){return this._eagerPreviewElement;}
_onTextChanged(){if(this._eagerEvalSetting.get()){const asSoonAsPossible=!this._editor.textWithCurrentSuggestion();this._previewRequestForTest=this._textChangeThrottler.schedule(this._requestPreviewBound,asSoonAsPossible);}
this._updatePromptIcon();this.dispatchEventToListeners(Events$1.TextChanged);}
async _requestPreview(){const text=this._editor.textWithCurrentSuggestion().trim();const executionContext=self.UI.context.flavor(RuntimeModel.ExecutionContext);const{preview,result}=await JavaScriptREPL.JavaScriptREPL.evaluateAndBuildPreview(text,true,500);this._innerPreviewElement.removeChildren();if(preview.deepTextContent()!==this._editor.textWithCurrentSuggestion().trim()){this._innerPreviewElement.appendChild(preview);}
if(result&&result.object&&result.object.subtype==='node'){this._highlightingNode=true;OverlayModel.OverlayModel.highlightObjectAsDOMNode(result.object);}else if(this._highlightingNode){this._highlightingNode=false;OverlayModel.OverlayModel.hideDOMNodeHighlight();}
if(result){executionContext.runtimeModel.releaseEvaluationResult(result);}}
willHide(){if(this._highlightingNode){this._highlightingNode=false;OverlayModel.OverlayModel.hideDOMNodeHighlight();}}
history(){return this._history;}
clearAutocomplete(){if(this._editor){this._editor.clearAutocomplete();}}
_isCaretAtEndOfPrompt(){return!!this._editor&&this._editor.selection().collapseToEnd().equal(this._editor.fullRange().collapseToEnd());}
moveCaretToEndOfPrompt(){if(this._editor){this._editor.setSelection(TextRange.TextRange.createFromLocation(Infinity,Infinity));}}
setText(text){if(this._editor){this._editor.setText(text);}else{this._initialText=text;}
this.dispatchEventToListeners(Events$1.TextChanged);}
text(){return this._editor?this._editor.text():this._initialText;}
setAddCompletionsFromHistory(value){this._addCompletionsFromHistory=value;}
_editorKeyDown(event){const keyboardEvent=(event);let newText;let isPrevious;const selection=this._editor.selection();const cursorY=this._editor.visualCoordinates(selection.endLine,selection.endColumn).y;switch(keyboardEvent.keyCode){case KeyboardShortcut.Keys.Up.code:{const startY=this._editor.visualCoordinates(0,0).y;if(keyboardEvent.shiftKey||!selection.isEmpty()||cursorY!==startY){break;}
newText=this._history.previous(this.text());isPrevious=true;break;}
case KeyboardShortcut.Keys.Down.code:{const fullRange=this._editor.fullRange();const endY=this._editor.visualCoordinates(fullRange.endLine,fullRange.endColumn).y;if(keyboardEvent.shiftKey||!selection.isEmpty()||cursorY!==endY){break;}
newText=this._history.next();break;}
case KeyboardShortcut.Keys.P.code:{if(Platform.isMac()&&keyboardEvent.ctrlKey&&!keyboardEvent.metaKey&&!keyboardEvent.altKey&&!keyboardEvent.shiftKey){newText=this._history.previous(this.text());isPrevious=true;}
break;}
case KeyboardShortcut.Keys.N.code:{if(Platform.isMac()&&keyboardEvent.ctrlKey&&!keyboardEvent.metaKey&&!keyboardEvent.altKey&&!keyboardEvent.shiftKey){newText=this._history.next();}
break;}
case KeyboardShortcut.Keys.Enter.code:{this._enterKeyPressed(keyboardEvent);break;}
case KeyboardShortcut.Keys.Tab.code:{if(!this.text()){keyboardEvent.consume();}
break;}}
if(newText===undefined){return;}
keyboardEvent.consume(true);this.setText(newText);if(isPrevious){this._editor.setSelection(TextRange.TextRange.createFromLocation(0,Infinity));}else{this.moveCaretToEndOfPrompt();}}
async _enterWillEvaluate(){if(!this._isCaretAtEndOfPrompt()){return true;}
return await JavaScriptAutocomplete.JavaScriptAutocomplete.isExpressionComplete(this.text());}
_updatePromptIcon(){this._iconThrottler.schedule(async()=>{const canComplete=await this._enterWillEvaluate();this._promptIcon.classList.toggle('console-prompt-incomplete',!canComplete);});}
async _enterKeyPressed(event){if(event.altKey||event.ctrlKey||event.shiftKey){return;}
event.consume(true);this.element.scrollIntoView();this.clearAutocomplete();const str=this.text();if(!str.length){return;}
if(await this._enterWillEvaluate()){await this._appendCommand(str,true);}else{this._editor.newlineAndIndent();}
this._enterProcessedForTest();}
async _appendCommand(text,useCommandLineAPI){this.setText('');const currentExecutionContext=self.UI.context.flavor(RuntimeModel.ExecutionContext);if(currentExecutionContext){const executionContext=currentExecutionContext;const message=ConsoleModel.ConsoleModel.instance().addCommandMessage(executionContext,text);const expression=JavaScriptREPL.JavaScriptREPL.preprocessExpression(text);ConsoleModel.ConsoleModel.instance().evaluateCommandInConsole(executionContext,message,expression,useCommandLineAPI);if(ConsolePanel.instance().isShowing()){userMetrics.actionTaken(UserMetrics.Action.CommandEvaluatedInConsolePanel);}}}
_enterProcessedForTest(){}
_historyCompletions(prefix,force){const text=this.text();if(!this._addCompletionsFromHistory||!this._isCaretAtEndOfPrompt()||(!text&&!force)){return[];}
const result=[];const set=new Set();const data=this._history.historyData();for(let i=data.length-1;i>=0&&result.length<50;--i){const item=data[i];if(!item.startsWith(text)){continue;}
if(set.has(item)){continue;}
set.add(item);result.push({text:item.substring(text.length-prefix.length),iconType:'smallicon-text-prompt',isSecondary:true});}
return result;}
focus(){if(this._editor){this._editor.widget().focus();}else{this.element.focus();}}
async _wordsWithQuery(queryRange,substituteRange,force){const query=this._editor.text(queryRange);const words=await this._defaultAutocompleteConfig.suggestionsCallback(queryRange,substituteRange,force);const historyWords=this._historyCompletions(query,force);return words.concat(historyWords);}
_editorSetForTest(){}}
class ConsoleHistoryManager{constructor(){this._data=[];this._historyOffset=1;}
historyData(){return this._data;}
setHistoryData(data){this._data=data.slice();this._historyOffset=1;}
pushHistoryItem(text){if(this._uncommittedIsTop){this._data.pop();delete this._uncommittedIsTop;}
this._historyOffset=1;if(text===this._currentHistoryItem()){return;}
this._data.push(text);}
_pushCurrentText(currentText){if(this._uncommittedIsTop){this._data.pop();}
this._uncommittedIsTop=true;this._data.push(currentText);}
previous(currentText){if(this._historyOffset>this._data.length){return undefined;}
if(this._historyOffset===1){this._pushCurrentText(currentText);}
++this._historyOffset;return this._currentHistoryItem();}
next(){if(this._historyOffset===1){return undefined;}
--this._historyOffset;return this._currentHistoryItem();}
_currentHistoryItem(){return this._data[this._data.length-this._historyOffset];}}
const Events$1={TextChanged:Symbol('TextChanged')};var ConsolePrompt$1=Object.freeze({__proto__:null,ConsolePrompt:ConsolePrompt,ConsoleHistoryManager:ConsoleHistoryManager,Events:Events$1});export{ConsoleContextSelector$1 as ConsoleContextSelector,ConsoleFilter$1 as ConsoleFilter,ConsolePanel$1 as ConsolePanel,ConsolePinPane$1 as ConsolePinPane,ConsolePrompt$1 as ConsolePrompt,ConsoleSidebar$1 as ConsoleSidebar,ConsoleView$1 as ConsoleView,ConsoleViewMessage$1 as ConsoleViewMessage,ConsoleViewport$1 as ConsoleViewport};