import{ObjectWrapper,EventTarget,Revealer}from'../common/common.js';import{SDKModel,IssuesModel,ResourceTreeModel,LogModel,ConsoleModel,RuntimeModel,NetworkRequest,Cookie}from'../sdk/sdk.js';let issuesManagerInstance=null;class IssuesManager extends ObjectWrapper.ObjectWrapper{constructor(){super();this._eventListeners=new WeakMap();SDKModel.TargetManager.instance().observeModels(IssuesModel.IssuesModel,this);this._issues=new Map();this._hasSeenMainFrameNavigated=false;}
static instance({forceNew}={forceNew:false}){if(!issuesManagerInstance||forceNew){issuesManagerInstance=new IssuesManager();}
return issuesManagerInstance;}
reloadForAccurateInformationRequired(){return!this._hasSeenMainFrameNavigated;}
_onMainFrameNavigated(event){const mainFrame=(event.data);const keptIssues=new Map();for(const[key,issue]of this._issues.entries()){if(issue.isAssociatedWithRequestId(mainFrame.loaderId)){keptIssues.set(key,issue);}}
this._issues=keptIssues;this._hasSeenMainFrameNavigated=true;this.dispatchEventToListeners(Events.FullUpdateRequired);this.dispatchEventToListeners(Events.IssuesCountUpdated);}
modelAdded(issuesModel){if(issuesModel.target().id()==='main'){const resourceTreeModel=(issuesModel.target().model(ResourceTreeModel.ResourceTreeModel));if(resourceTreeModel){resourceTreeModel.addEventListener(ResourceTreeModel.Events.MainFrameNavigated,this._onMainFrameNavigated,this);}}
const listener=issuesModel.addEventListener(IssuesModel.Events.IssueAdded,this._issueAdded,this);this._eventListeners.set(issuesModel,listener);}
modelRemoved(issuesModel){const listener=this._eventListeners.get(issuesModel);if(listener){EventTarget.EventTarget.removeEventListeners([listener]);}}
_issueAdded(event){const{issuesModel,issue}=(event.data);if(!issue.getDescription()){return;}
const primaryKey=issue.primaryKey();if(this._issues.has(primaryKey)){return;}
this._issues.set(primaryKey,issue);this.dispatchEventToListeners(Events.IssueAdded,{issuesModel,issue});this.dispatchEventToListeners(Events.IssuesCountUpdated);}
issues(){return this._issues.values();}
numberOfIssues(){return this._issues.size;}}
const Events={IssuesCountUpdated:Symbol('IssuesCountUpdated'),IssueAdded:Symbol('IssueAdded'),FullUpdateRequired:Symbol('FullUpdateRequired'),};var IssuesManager$1=Object.freeze({__proto__:null,IssuesManager:IssuesManager,Events:Events});class LogManager{constructor(){SDKModel.TargetManager.instance().observeModels(LogModel.LogModel,this);}
modelAdded(logModel){const eventListeners=[];eventListeners.push(logModel.addEventListener(LogModel.Events.EntryAdded,this._logEntryAdded,this));logModel[_eventSymbol]=eventListeners;}
modelRemoved(logModel){EventTarget.EventTarget.removeEventListeners(logModel[_eventSymbol]);}
_logEntryAdded(event){const data=(event.data);const target=data.logModel.target();const consoleMessage=new ConsoleModel.ConsoleMessage(target.model(RuntimeModel.RuntimeModel),data.entry.source,data.entry.level,data.entry.text,undefined,data.entry.url,data.entry.lineNumber,undefined,[data.entry.text,...(data.entry.args||[])],data.entry.stackTrace,data.entry.timestamp,undefined,undefined,data.entry.workerId);if(data.entry.networkRequestId){self.SDK.networkLog.associateConsoleMessageWithRequest(consoleMessage,data.entry.networkRequestId);}
if(consoleMessage.source===ConsoleModel.MessageSource.Worker){const workerId=consoleMessage.workerId||'';if(SDKModel.TargetManager.instance().targetById(workerId)){return;}
setTimeout(()=>{if(!SDKModel.TargetManager.instance().targetById(workerId)){ConsoleModel.ConsoleModel.instance().addMessage(consoleMessage);}},1000);}else{ConsoleModel.ConsoleModel.instance().addMessage(consoleMessage);}}}
const _eventSymbol=Symbol('_events');var LogManager$1=Object.freeze({__proto__:null,LogManager:LogManager});let IssuesAssociatable;function issuesAssociatedWithNetworkRequest(issues,request){return issues.filter(issue=>{for(const affectedRequest of issue.requests()){if(affectedRequest.requestId===request.requestId()){return true;}}
return false;});}
function issuesAssociatedWithCookie(issues,domain,name,path){return issues.filter(issue=>{for(const cookie of issue.cookies()){if(cookie.domain===domain&&cookie.name===name&&cookie.path===path){return true;}}
return false;});}
function issuesAssociatedWith(issues,obj){if(obj instanceof NetworkRequest.NetworkRequest){return issuesAssociatedWithNetworkRequest(issues,obj);}
if(obj instanceof Cookie.Cookie){return issuesAssociatedWithCookie(issues,obj.domain(),obj.name(),obj.path());}
throw new Error(`issues can not be associated with ${obj}`);}
function hasIssues(obj){const issues=Array.from(IssuesManager.instance().issues());return issuesAssociatedWith(issues,obj).length>0;}
function hasIssueOfCategory(obj,category){const issues=Array.from(IssuesManager.instance().issues());return issuesAssociatedWith(issues,obj).some(issue=>issue.getCategory()===category);}
async function reveal(obj,category){const issues=Array.from(IssuesManager.instance().issues());const candidates=issuesAssociatedWith(issues,obj).filter(issue=>!category||issue.getCategory()===category);if(candidates.length>0){return Revealer.reveal(candidates[0]);}}
var RelatedIssue=Object.freeze({__proto__:null,IssuesAssociatable:IssuesAssociatable,issuesAssociatedWith:issuesAssociatedWith,hasIssues:hasIssues,hasIssueOfCategory:hasIssueOfCategory,reveal:reveal});const logManager=new LogManager();IssuesManager.instance();export{IssuesManager$1 as IssuesManager,LogManager$1 as LogManager,RelatedIssue,logManager};