import'../common/common.js';import{Issue,SDKModel,IssuesModel,ResourceTreeModel}from'../sdk/sdk.js';import{TreeOutline,UIUtils,Icon,XLink,Widget,Toolbar,Infobar,ViewManager}from'../ui/ui.js';import{NetworkPanel,NetworkItemView}from'../network/network.js';class AffectedResourcesView extends TreeOutline.TreeElement{constructor(parent,resourceName){super();this.toggleOnClick=true;this._parent=parent;this._resourceName=resourceName;this._affectedResourcesCountElement=this.createAffectedResourcesCounter();this._affectedResources=this.createAffectedResources();this._affectedResourcesCount=0;}
createAffectedResourcesCounter(){const counterLabel=createElementWithClass('div','affected-resource-label');this.listItemElement.appendChild(counterLabel);return counterLabel;}
createAffectedResources(){const body=new TreeOutline.TreeElement();const affectedResources=createElementWithClass('table','affected-resource-list');const header=createElementWithClass('tr');const name=createElementWithClass('td','affected-resource-header');name.textContent='Name';header.appendChild(name);const info=createElementWithClass('td','affected-resource-header affected-resource-header-info');info.textContent='\u2009Context';header.appendChild(info);affectedResources.appendChild(header);body.listItemElement.appendChild(affectedResources);this.appendChild(body);return affectedResources;}
getResourceName(count){if(count===1){return this._resourceName.singular;}
return this._resourceName.plural;}
updateAffectedResourceCount(count){this._affectedResourcesCount=count;this._affectedResourcesCountElement.textContent=`${count} ${this.getResourceName(count)}`;this.hidden=this._affectedResourcesCount===0;this._parent.updateAffectedResourceVisibility();}
isEmpty(){return this._affectedResourcesCount===0;}
clear(){this._affectedResources.textContent='';}}
class AffectedCookiesView extends AffectedResourcesView{constructor(parent,issue){super(parent,{singular:ls`cookie`,plural:ls`cookies`});this._issue=issue;}
_appendAffectedCookies(cookies){let count=0;for(const cookie of cookies){count++;this.appendAffectedCookie((cookie));}
this.updateAffectedResourceCount(count);}
appendAffectedCookie(cookie){const element=createElementWithClass('tr','affected-resource-cookie');const name=createElementWithClass('td','');name.appendChild(UIUtils.createTextButton(cookie.name,()=>{NetworkPanel.NetworkPanel.revealAndFilter([{filterType:'cookie-domain',filterValue:cookie.domain,},{filterType:'cookie-name',filterValue:cookie.name,},{filterType:'cookie-path',filterValue:cookie.path,}]);},'link-style devtools-link'));const info=createElementWithClass('td','affected-resource-cookie-info');info.textContent=(cookie.domain[0]!=='.'?'\u2008':'')+cookie.domain+cookie.path;element.appendChild(name);element.appendChild(info);this._affectedResources.appendChild(element);}
update(){this.clear();this._appendAffectedCookies(this._issue.cookies());}}
class AffectedRequestsView extends AffectedResourcesView{constructor(parent,issue){super(parent,{singular:ls`request`,plural:ls`requests`});this._issue=issue;}
_appendAffectedRequests(affectedRequests){let count=0;for(const affectedRequest of affectedRequests){for(const request of self.SDK.networkLog.requestsForId(affectedRequest.requestId)){count++;this._appendNetworkRequest(request);}}
this.updateAffectedResourceCount(count);}
_appendNetworkRequest(request){const nameText=request.name().trimMiddle(100);const nameElement=createElementWithClass('td','');const tab=issueTypeToNetworkHeaderMap.get(this._issue.getCategory())||NetworkItemView.Tabs.Headers;nameElement.appendChild(UIUtils.createTextButton(nameText,()=>{NetworkPanel.NetworkPanel.selectAndShowRequest(request,tab);},'link-style devtools-link'));const element=createElementWithClass('tr','affected-resource-request');element.appendChild(nameElement);this._affectedResources.appendChild(element);}
update(){this.clear();this._appendAffectedRequests(this._issue.requests());}}
const issueTypeToNetworkHeaderMap=new Map([[Issue.IssueCategory.SameSiteCookie,NetworkItemView.Tabs.Cookies],[Issue.IssueCategory.CrossOriginEmbedderPolicy,NetworkItemView.Tabs.Headers]]);class IssueView extends TreeOutline.TreeElement{constructor(parent,issue,description){super();this._parent=parent;this._issue=issue;this._description=description;this.toggleOnClick=true;this.listItemElement.classList.add('issue');this.childrenListElement.classList.add('body');this._affectedResources=this._createAffectedResources();this._affectedCookiesView=new AffectedCookiesView(this,this._issue);this._affectedRequestsView=new AffectedRequestsView(this,this._issue);}
onattach(){this._appendHeader();this._createBody();this.appendChild(this._affectedResources);this.appendAffectedResource(this._affectedCookiesView);this._affectedCookiesView.update();this.appendAffectedResource(this._affectedRequestsView);this._affectedRequestsView.update();this._createReadMoreLink();this.updateAffectedResourceVisibility();}
appendAffectedResource(resource){this._affectedResources.appendChild(resource);}
_appendHeader(){const header=createElementWithClass('div','header');const icon=Icon.Icon.create('largeicon-breaking-change','icon');header.appendChild(icon);const title=createElementWithClass('div','title');title.textContent=this._description.title;header.appendChild(title);this.listItemElement.appendChild(header);}
updateAffectedResourceVisibility(){const noCookies=!this._affectedCookiesView||this._affectedCookiesView.isEmpty();const noRequests=!this._affectedRequestsView||this._affectedRequestsView.isEmpty();const noResources=noCookies&&noRequests;this._affectedResources.hidden=noResources;}
_createAffectedResources(){const wrapper=new TreeOutline.TreeElement();wrapper.setCollapsible(false);wrapper.setExpandable(true);wrapper.expand();wrapper.selectable=false;wrapper.listItemElement.classList.add('affected-resources-label');wrapper.listItemElement.textContent=ls`Affected Resources`;wrapper.childrenListElement.classList.add('affected-resources');return wrapper;}
_createBody(){const kindAndCode=new TreeOutline.TreeElement();kindAndCode.setCollapsible(false);kindAndCode.selectable=false;kindAndCode.listItemElement.classList.add('kind-code-line');const code=createElementWithClass('span','issue-code');code.textContent=this._issue.code();kindAndCode.listItemElement.appendChild(code);this.appendChild(kindAndCode);const messageElement=new TreeOutline.TreeElement();messageElement.setCollapsible(false);messageElement.selectable=false;const message=this._description.message();messageElement.listItemElement.appendChild(message);this.appendChild(messageElement);}
_createReadMoreLink(){const link=XLink.XLink.create(this._description.link,ls`Learn more: ${this._description.linkTitle}`,'link');const linkIcon=Icon.Icon.create('largeicon-link','link-icon');link.prepend(linkIcon);const linkWrapper=new TreeOutline.TreeElement();linkWrapper.setCollapsible(false);linkWrapper.listItemElement.classList.add('link-wrapper');linkWrapper.listItemElement.appendChild(link);this.appendChild(linkWrapper);}
update(){this._affectedCookiesView.update();this._affectedRequestsView.update();this.updateAffectedResourceVisibility();}
toggle(expand){if(expand||(expand===undefined&&!this.expanded)){this.expand();}else{this.collapse();}}}
class IssuesPaneImpl extends Widget.VBox{constructor(){super(true);this.registerRequiredCSS('issues/issuesPane.css');this.contentElement.classList.add('issues-pane');this._issueViews=new Map();const{toolbarContainer,updateToolbarIssuesCount}=this._createToolbars();this._issuesToolbarContainer=toolbarContainer;this._updateToolbarIssuesCount=updateToolbarIssuesCount;this._issuesTree=new TreeOutline.TreeOutlineInShadow();this._issuesTree.registerRequiredCSS('issues/issuesTree.css');this._issuesTree.setShowSelectionOnKeyboardFocus(true);this._issuesTree.contentElement.classList.add('issues');this.contentElement.appendChild(this._issuesTree.element);const mainTarget=SDKModel.TargetManager.instance().mainTarget();this._model=null;if(mainTarget){this._model=mainTarget.model(IssuesModel.IssuesModel);if(this._model){this._model.addEventListener(IssuesModel.Events.AggregatedIssueUpdated,this._issueUpdated,this);this._model.addEventListener(IssuesModel.Events.FullUpdateRequired,this._fullUpdate,this);this._model.ensureEnabled();}}
if(this._model){for(const issue of this._model.aggregatedIssues()){this._updateIssueView(issue);}}
this._updateCounts();this._reloadInfobar=null;this._infoBarDiv=null;this._showReloadInfobarIfNeeded();}
_createToolbars(){const toolbarContainer=this.contentElement.createChild('div','issues-toolbar-container');new Toolbar.Toolbar('issues-toolbar-left',toolbarContainer);const rightToolbar=new Toolbar.Toolbar('issues-toolbar-right',toolbarContainer);rightToolbar.appendSeparator();const toolbarWarnings=createElementWithClass('div','toolbar-warnings');const breakingChangeIcon=Icon.Icon.create('largeicon-breaking-change');toolbarWarnings.appendChild(breakingChangeIcon);const toolbarIssuesCount=toolbarWarnings.createChild('span','warnings-count-label');const toolbarIssuesItem=new Toolbar.ToolbarItem(toolbarWarnings);rightToolbar.appendToolbarItem(toolbarIssuesItem);const updateToolbarIssuesCount=count=>{toolbarIssuesCount.textContent=`${count}`;};return{toolbarContainer,updateToolbarIssuesCount};}
_issueUpdated(event){const issue=(event.data);this._updateIssueView(issue);}
_updateIssueView(issue){const description=issue.getDescription();if(!description){console.warn('Could not find description for issue code:',issue.code());return;}
if(!this._issueViews.has(issue.code())){const view=new IssueView(this,issue,description);this._issueViews.set(issue.code(),view);this._issuesTree.appendChild(view);}
this._issueViews.get(issue.code()).update();this._updateCounts();}
_fullUpdate(){this._hideReloadInfoBar();for(const view of this._issueViews.values()){this._issuesTree.removeChild(view);}
this._issueViews.clear();for(const issue of this._model.aggregatedIssues()){this._updateIssueView(issue);}
this._updateCounts();}
_updateCounts(){this._updateToolbarIssuesCount(this._model.numberOfAggregatedIssues());}
revealByCode(code){const issueView=this._issueViews.get(code);if(issueView){issueView.reveal();}}
_showReloadInfobarIfNeeded(){if(!this._model||!this._model.reloadForAccurateInformationRequired()){return;}
function reload(){const mainTarget=SDKModel.TargetManager.instance().mainTarget();if(mainTarget){const resourceModel=mainTarget.model(ResourceTreeModel.ResourceTreeModel);if(resourceModel){resourceModel.reloadPage();}}}
const infobar=new Infobar.Infobar(Infobar.Type.Warning,ls`Some issues might be missing or incomplete, reload the inspected page to get full information`,[{text:ls`Reload page`,highlight:false,delegate:reload,dismiss:true}]);this._reloadInfobar=infobar;this._attachReloadInfoBar(infobar);}
_attachReloadInfoBar(infobar){if(!this._infoBarDiv){this._infoBarDiv=createElementWithClass('div','flex-none');this.contentElement.insertBefore(this._infoBarDiv,this._issuesToolbarContainer.nextSibling);}
this._infoBarDiv.appendChild(infobar.element);infobar.setParentView(this);this.doResize();}
_hideReloadInfoBar(){if(this._reloadInfobar){this._reloadInfobar.dispose();this._reloadInfobar=null;}}}
var IssuesPane=Object.freeze({__proto__:null,IssuesPaneImpl:IssuesPaneImpl});class IssueRevealer{async reveal(issue){if(!(issue instanceof Issue.Issue)){throw new Error('Internal error: not a issue');}
await ViewManager.ViewManager.instance().showView('issues-pane');const view=ViewManager.ViewManager.instance().view('issues-pane');if(view){const issuesPane=(await view.widget());issuesPane.revealByCode(issue.code());}}}
var IssueRevealer$1=Object.freeze({__proto__:null,IssueRevealer:IssueRevealer});export{IssueRevealer$1 as IssueRevealer,IssuesPane};