import{UIString,Settings}from'../common/common.js';import{Reload}from'../components/components.js';import{userMetrics,UserMetrics,InspectorFrontendHost}from'../host/host.js';import{Widget,Utils,ARIAUtils,ViewManager,Toolbar,View,TabbedPane,Dialog,GlassPane,SettingsUI,UIUtils,ListWidget}from'../ui/ui.js';class SettingsScreen extends Widget.VBox{constructor(){super(true);this.registerRequiredCSS('settings/settingsScreen.css');this.contentElement.classList.add('settings-window-main');this.contentElement.classList.add('vbox');const settingsLabelElement=createElement('div');const settingsTitleElement=Utils.createShadowRootWithCoreStyles(settingsLabelElement,'settings/settingsScreen.css').createChild('div','settings-window-title');ARIAUtils.markAsHeading(settingsTitleElement,1);settingsTitleElement.textContent=ls`Settings`;this._tabbedLocation=ViewManager.ViewManager.instance().createTabbedLocation(()=>SettingsScreen._revealSettingsScreen(),'settings-view');const tabbedPane=this._tabbedLocation.tabbedPane();tabbedPane.leftToolbar().appendToolbarItem(new Toolbar.ToolbarItem(settingsLabelElement));tabbedPane.setShrinkableTabs(false);tabbedPane.makeVerticalTabLayout();if(!Root.Runtime.experiments.isEnabled('customKeyboardShortcuts')){const shortcutsView=new View.SimpleView(ls`Shortcuts`);self.UI.shortcutsScreen.createShortcutsTabView().show(shortcutsView.element);this._tabbedLocation.appendView(shortcutsView);}
tabbedPane.show(this.contentElement);tabbedPane.selectTab('preferences');tabbedPane.addEventListener(TabbedPane.Events.TabInvoked,this._tabInvoked,this);this._reportTabOnReveal=false;}
static _revealSettingsScreen(){const settingsScreen=self.runtime.sharedInstance(SettingsScreen);if(settingsScreen.isShowing()){return settingsScreen;}
settingsScreen._reportTabOnReveal=true;const dialog=new Dialog.Dialog();dialog.contentElement.tabIndex=-1;dialog.addCloseButton();dialog.setOutsideClickCallback(()=>{});dialog.setPointerEventsBehavior(GlassPane.PointerEventsBehavior.PierceGlassPane);dialog.setOutsideTabIndexBehavior(Dialog.OutsideTabIndexBehavior.PreserveMainViewTabIndex);settingsScreen.show(dialog.contentElement);dialog.show();return settingsScreen;}
static async _showSettingsScreen(options={}){const{name,focusTabHeader}=options;const settingsScreen=SettingsScreen._revealSettingsScreen();settingsScreen._selectTab(name||'preferences');const tabbedPane=settingsScreen._tabbedLocation.tabbedPane();await tabbedPane.waitForTabElementUpdate();if(focusTabHeader){tabbedPane.focusSelectedTabHeader();}else{tabbedPane.focus();}}
resolveLocation(locationName){return this._tabbedLocation;}
_selectTab(name){this._tabbedLocation.tabbedPane().selectTab(name,true);}
_tabInvoked(event){const eventData=(event.data);if(!eventData.isUserGesture){return;}
const prevTabId=eventData.prevTabId;const tabId=eventData.tabId;if(!this._reportTabOnReveal&&prevTabId&&prevTabId===tabId){return;}
this._reportTabOnReveal=false;this._reportSettingsPanelShown(tabId);}
_reportSettingsPanelShown(tabId){if(tabId===ls`Shortcuts`){userMetrics.settingsPanelShown('shortcuts');return;}
userMetrics.settingsPanelShown(tabId);}}
class SettingsTab extends Widget.VBox{constructor(name,id){super();this.element.classList.add('settings-tab-container');if(id){this.element.id=id;}
const header=this.element.createChild('header');header.createChild('h1').createTextChild(name);this.containerElement=this.element.createChild('div','settings-container-wrapper').createChild('div','settings-tab settings-content settings-container');}
_appendSection(name){const block=this.containerElement.createChild('div','settings-block');if(name){ARIAUtils.markAsGroup(block);const title=block.createChild('div','settings-section-title');title.textContent=name;ARIAUtils.markAsHeading(title,2);ARIAUtils.setAccessibleName(block,name);}
return block;}}
class GenericSettingsTab extends SettingsTab{constructor(){super(UIString.UIString('Preferences'),'preferences-tab-content');const explicitSectionOrder=['','Appearance','Sources','Elements','Network','Performance','Console','Extensions'];this._nameToSection=new Map();for(const sectionName of explicitSectionOrder){this._sectionElement(sectionName);}
self.runtime.extensions('setting').forEach(this._addSetting.bind(this));self.runtime.extensions(SettingsUI.SettingUI).forEach(this._addSettingUI.bind(this));this._appendSection().appendChild(UIUtils.createTextButton(UIString.UIString('Restore defaults and reload'),restoreAndReload));function restoreAndReload(){Settings.Settings.instance().clearAll();Reload.reload();}}
static isSettingVisible(extension){const descriptor=extension.descriptor();if(!('title'in descriptor)){return false;}
if(!('category'in descriptor)){return false;}
return true;}
_addSetting(extension){if(!GenericSettingsTab.isSettingVisible(extension)){return;}
const sectionElement=this._sectionElement(extension.descriptor()['category']);const setting=Settings.Settings.instance().moduleSetting(extension.descriptor()['settingName']);const settingControl=SettingsUI.createControlForSetting(setting);if(settingControl){sectionElement.appendChild(settingControl);}}
_addSettingUI(extension){const descriptor=extension.descriptor();const sectionName=descriptor['category']||'';extension.instance().then(appendCustomSetting.bind(this));function appendCustomSetting(object){const settingUI=(object);const element=settingUI.settingElement();if(element){this._sectionElement(sectionName).appendChild(element);}}}
_sectionElement(sectionName){let sectionElement=this._nameToSection.get(sectionName);if(!sectionElement){const uiSectionName=sectionName&&UIString.UIString(sectionName);sectionElement=this._appendSection(uiSectionName);this._nameToSection.set(sectionName,sectionElement);}
return sectionElement;}}
class ExperimentsSettingsTab extends SettingsTab{constructor(){super(UIString.UIString('Experiments'),'experiments-tab-content');const experiments=Root.Runtime.experiments.allConfigurableExperiments().sort();const unstableExperiments=experiments.filter(e=>e.unstable);const stableExperiments=experiments.filter(e=>!e.unstable);if(stableExperiments.length){const experimentsSection=this._appendSection();const warningMessage=UIString.UIString('These experiments could be dangerous and may require restart.');experimentsSection.appendChild(this._createExperimentsWarningSubsection(warningMessage));for(const experiment of stableExperiments){experimentsSection.appendChild(this._createExperimentCheckbox(experiment));}}
if(unstableExperiments.length){const experimentsSection=this._appendSection();const warningMessage=UIString.UIString('These experiments are particularly unstable. Enable at your own risk.');experimentsSection.appendChild(this._createExperimentsWarningSubsection(warningMessage));for(const experiment of unstableExperiments){experimentsSection.appendChild(this._createExperimentCheckbox(experiment));}}}
_createExperimentsWarningSubsection(warningMessage){const subsection=createElement('div');const warning=subsection.createChild('span','settings-experiments-warning-subsection-warning');warning.textContent=UIString.UIString('WARNING:');subsection.createTextChild(' ');const message=subsection.createChild('span','settings-experiments-warning-subsection-message');message.textContent=warningMessage;return subsection;}
_createExperimentCheckbox(experiment){const label=UIUtils.CheckboxLabel.create(UIString.UIString(experiment.title),experiment.isEnabled());const input=label.checkboxElement;input.name=experiment.name;function listener(){experiment.setEnabled(input.checked);}
input.addEventListener('click',listener,false);const p=createElement('p');p.className=experiment.unstable&&!experiment.isEnabled()?'settings-experiment-unstable':'';p.appendChild(label);return p;}}
class ActionDelegate{handleAction(context,actionId){let screen;switch(actionId){case'settings.show':SettingsScreen._showSettingsScreen({focusTabHeader:true});return true;case'settings.documentation':InspectorFrontendHost.InspectorFrontendHostInstance.openInNewTab(UIUtils.addReferrerToURL('https://developers.google.com/web/tools/chrome-devtools/'));return true;case'settings.shortcuts':userMetrics.actionTaken(UserMetrics.Action.SettingsOpenedFromMenu);screen={name:ls`Shortcuts`,focusTabHeader:true};if(Root.Runtime.experiments.isEnabled('customKeyboardShortcuts')){screen={name:'keybinds',focusTabHeader:true};}
SettingsScreen._showSettingsScreen(screen);return true;}
return false;}}
class Revealer{reveal(object){console.assert(object instanceof Settings.Setting);const setting=(object);let success=false;self.runtime.extensions('setting').forEach(revealModuleSetting);self.runtime.extensions(SettingsUI.SettingUI).forEach(revealSettingUI);self.runtime.extensions('view').forEach(revealSettingsView);return success?Promise.resolve():Promise.reject();function revealModuleSetting(extension){if(!GenericSettingsTab.isSettingVisible(extension)){return;}
if(extension.descriptor()['settingName']===setting.name){InspectorFrontendHost.InspectorFrontendHostInstance.bringToFront();SettingsScreen._showSettingsScreen();success=true;}}
function revealSettingUI(extension){const settings=extension.descriptor()['settings'];if(settings&&settings.indexOf(setting.name)!==-1){InspectorFrontendHost.InspectorFrontendHostInstance.bringToFront();SettingsScreen._showSettingsScreen();success=true;}}
function revealSettingsView(extension){const location=extension.descriptor()['location'];if(location!=='settings-view'){return;}
const settings=extension.descriptor()['settings'];if(settings&&settings.indexOf(setting.name)!==-1){InspectorFrontendHost.InspectorFrontendHostInstance.bringToFront();SettingsScreen._showSettingsScreen({name:extension.descriptor()['id']});success=true;}}}}
var SettingsScreen$1=Object.freeze({__proto__:null,SettingsScreen:SettingsScreen,GenericSettingsTab:GenericSettingsTab,ExperimentsSettingsTab:ExperimentsSettingsTab,ActionDelegate:ActionDelegate,Revealer:Revealer});class FrameworkBlackboxSettingsTab extends Widget.VBox{constructor(){super(true);this.registerRequiredCSS('settings/frameworkBlackboxSettingsTab.css');const header=this.contentElement.createChild('div','header');header.textContent=ls`Framework Blackboxing`;ARIAUtils.markAsHeading(header,1);this.contentElement.createChild('div','intro').textContent=ls`Debugger will skip through the scripts and will not stop on exceptions thrown by them.`;const blackboxContentScripts=this.contentElement.createChild('div','blackbox-content-scripts');blackboxContentScripts.appendChild(SettingsUI.createSettingCheckbox(ls`Blackbox content scripts`,Settings.Settings.instance().moduleSetting('skipContentScripts'),true));blackboxContentScripts.title=ls`Blackbox content scripts (extension scripts in the page)`;this._blackboxLabel=UIString.UIString('Blackbox');this._disabledLabel=UIString.UIString('Disabled');this._list=new ListWidget.ListWidget(this);this._list.element.classList.add('blackbox-list');this._list.registerRequiredCSS('settings/frameworkBlackboxSettingsTab.css');const placeholder=createElementWithClass('div','blackbox-list-empty');placeholder.textContent=UIString.UIString('No blackboxed patterns');this._list.setEmptyPlaceholder(placeholder);this._list.show(this.contentElement);const addPatternButton=UIUtils.createTextButton(UIString.UIString('Add pattern...'),this._addButtonClicked.bind(this),'add-button');this.contentElement.appendChild(addPatternButton);this._setting=Settings.Settings.instance().moduleSetting('skipStackFramesPattern');this._setting.addChangeListener(this._settingUpdated,this);this.setDefaultFocusedElement(addPatternButton);}
wasShown(){super.wasShown();this._settingUpdated();}
_settingUpdated(){this._list.clear();const patterns=this._setting.getAsArray();for(let i=0;i<patterns.length;++i){this._list.appendItem(patterns[i],true);}}
_addButtonClicked(){this._list.addNewItem(this._setting.getAsArray().length,{pattern:'',disabled:false});}
renderItem(item,editable){const element=createElementWithClass('div','blackbox-list-item');const pattern=element.createChild('div','blackbox-pattern');pattern.textContent=item.pattern;pattern.title=ls`Blackbox scripts whose names match '${item.pattern}'`;element.createChild('div','blackbox-separator');element.createChild('div','blackbox-behavior').textContent=item.disabled?this._disabledLabel:this._blackboxLabel;if(item.disabled){element.classList.add('blackbox-disabled');}
return element;}
removeItemRequested(item,index){const patterns=this._setting.getAsArray();patterns.splice(index,1);this._setting.setAsArray(patterns);}
commitEdit(item,editor,isNew){item.pattern=editor.control('pattern').value.trim();item.disabled=editor.control('behavior').value===this._disabledLabel;const list=this._setting.getAsArray();if(isNew){list.push(item);}
this._setting.setAsArray(list);}
beginEdit(item){const editor=this._createEditor();editor.control('pattern').value=item.pattern;editor.control('behavior').value=item.disabled?this._disabledLabel:this._blackboxLabel;return editor;}
_createEditor(){if(this._editor){return this._editor;}
const editor=new ListWidget.Editor();this._editor=editor;const content=editor.contentElement();const titles=content.createChild('div','blackbox-edit-row');titles.createChild('div','blackbox-pattern').textContent=UIString.UIString('Pattern');titles.createChild('div','blackbox-separator blackbox-separator-invisible');titles.createChild('div','blackbox-behavior').textContent=UIString.UIString('Behavior');const fields=content.createChild('div','blackbox-edit-row');const pattern=editor.createInput('pattern','text','/framework\\.js$',patternValidator.bind(this));ARIAUtils.setAccessibleName(pattern,ls`Pattern`);fields.createChild('div','blackbox-pattern').appendChild(pattern);fields.createChild('div','blackbox-separator blackbox-separator-invisible');const behavior=editor.createSelect('behavior',[this._blackboxLabel,this._disabledLabel],behaviorValidator);ARIAUtils.setAccessibleName(behavior,ls`Behavior`);fields.createChild('div','blackbox-behavior').appendChild(behavior);return editor;function patternValidator(item,index,input){const pattern=input.value.trim();const patterns=this._setting.getAsArray();if(!pattern.length){return{valid:false,errorMessage:ls`Pattern cannot be empty`};}
for(let i=0;i<patterns.length;++i){if(i!==index&&patterns[i].pattern===pattern){return{valid:false,errorMessage:ls`Pattern already exists`};}}
let regex;try{regex=new RegExp(pattern);}catch(e){}
if(!regex){return{valid:false,errorMessage:ls`Pattern must be a valid regular expression`};}
return{valid:true};}
function behaviorValidator(item,index,input){return{valid:true};}}}
var FrameworkBlackboxSettingsTab$1=Object.freeze({__proto__:null,FrameworkBlackboxSettingsTab:FrameworkBlackboxSettingsTab});class KeybindsSettingsTab extends Widget.VBox{constructor(){super(true);this.registerRequiredCSS('settings/keybindsSettingsTab.css');this._actions=self.UI.actionRegistry.actions().sort((actionA,actionB)=>{if(actionA.category()<actionB.category()){return-1;}
if(actionA.category()>actionB.category()){return 1;}
if(actionA.id()<actionB.id()){return-1;}
if(actionA.id()>actionB.id()){return 1;}
return 0;});const header=this.contentElement.createChild('header');header.createChild('h1').textContent=ls`Custom keyboard shortcuts`;const listHeader=this.contentElement.createChild('div','keybinds-list-item keybinds-header');listHeader.createChild('div','keybinds-list-text').textContent=ls`Action`;listHeader.createChild('div','keybinds-list-text').textContent=ls`Keyboard input`;this._list=new ListWidget.ListWidget(this);this._list.registerRequiredCSS('settings/keybindsSettingsTab.css');this._list.show(this.contentElement);this.update();}
renderItem(item){const itemElement=createElementWithClass('div','keybinds-list-item');if(typeof item==='string'){itemElement.classList.add('keybinds-category-header');itemElement.textContent=item;}else{itemElement.createChild('div','keybinds-list-text').textContent=item.title();const keysElement=itemElement.createChild('div','keybinds-list-text');self.UI.shortcutRegistry.shortcutsForAction(item.id()).forEach(shortcut=>keysElement.createChild('span','keybinds-key').textContent=shortcut.descriptor.name);}
return itemElement;}
removeItemRequested(item,index){}
beginEdit(item){return new ListWidget.Editor();}
commitEdit(item,editor,isNew){}
update(){this._list.clear();let currentCategory;this._actions.forEach(action=>{if(currentCategory!==action.category()){this._list.appendItem(action.category(),false);}
this._list.appendItem(action,false);currentCategory=action.category();});}}
let KeybindsItem;var KeybindsSettingsTab$1=Object.freeze({__proto__:null,KeybindsSettingsTab:KeybindsSettingsTab,KeybindsItem:KeybindsItem});export{FrameworkBlackboxSettingsTab$1 as FrameworkBlackboxSettingsTab,KeybindsSettingsTab$1 as KeybindsSettingsTab,SettingsScreen$1 as SettingsScreen};