import{ParsedURL}from'../common/common.js';import{Platform}from'../host/host.js';let InspectorBackendAPI;function registerCommands(inspectorBackend){inspectorBackend.registerEnum('Accessibility.AXValueType',{Boolean:'boolean',Tristate:'tristate',BooleanOrUndefined:'booleanOrUndefined',Idref:'idref',IdrefList:'idrefList',Integer:'integer',Node:'node',NodeList:'nodeList',Number:'number',String:'string',ComputedString:'computedString',Token:'token',TokenList:'tokenList',DomRelation:'domRelation',Role:'role',InternalRole:'internalRole',ValueUndefined:'valueUndefined'});inspectorBackend.registerEnum('Accessibility.AXValueSourceType',{Attribute:'attribute',Implicit:'implicit',Style:'style',Contents:'contents',Placeholder:'placeholder',RelatedElement:'relatedElement'});inspectorBackend.registerEnum('Accessibility.AXValueNativeSourceType',{Figcaption:'figcaption',Label:'label',Labelfor:'labelfor',Labelwrapped:'labelwrapped',Legend:'legend',Tablecaption:'tablecaption',Title:'title',Other:'other'});inspectorBackend.registerEnum('Accessibility.AXPropertyName',{Busy:'busy',Disabled:'disabled',Editable:'editable',Focusable:'focusable',Focused:'focused',Hidden:'hidden',HiddenRoot:'hiddenRoot',Invalid:'invalid',Keyshortcuts:'keyshortcuts',Settable:'settable',Roledescription:'roledescription',Live:'live',Atomic:'atomic',Relevant:'relevant',Root:'root',Autocomplete:'autocomplete',HasPopup:'hasPopup',Level:'level',Multiselectable:'multiselectable',Orientation:'orientation',Multiline:'multiline',Readonly:'readonly',Required:'required',Valuemin:'valuemin',Valuemax:'valuemax',Valuetext:'valuetext',Checked:'checked',Expanded:'expanded',Modal:'modal',Pressed:'pressed',Selected:'selected',Activedescendant:'activedescendant',Controls:'controls',Describedby:'describedby',Details:'details',Errormessage:'errormessage',Flowto:'flowto',Labelledby:'labelledby',Owns:'owns'});inspectorBackend.registerCommand('Accessibility.disable',[],[],false);inspectorBackend.registerCommand('Accessibility.enable',[],[],false);inspectorBackend.registerCommand('Accessibility.getPartialAXTree',[{'name':'nodeId','type':'number','optional':true},{'name':'backendNodeId','type':'number','optional':true},{'name':'objectId','type':'string','optional':true},{'name':'fetchRelatives','type':'boolean','optional':true}],['nodes'],false);inspectorBackend.registerCommand('Accessibility.getFullAXTree',[],['nodes'],false);inspectorBackend.registerEnum('Animation.AnimationType',{CSSTransition:'CSSTransition',CSSAnimation:'CSSAnimation',WebAnimation:'WebAnimation'});inspectorBackend.registerEvent('Animation.animationCanceled',['id']);inspectorBackend.registerEvent('Animation.animationCreated',['id']);inspectorBackend.registerEvent('Animation.animationStarted',['animation']);inspectorBackend.registerCommand('Animation.disable',[],[],false);inspectorBackend.registerCommand('Animation.enable',[],[],false);inspectorBackend.registerCommand('Animation.getCurrentTime',[{'name':'id','type':'string','optional':false}],['currentTime'],false);inspectorBackend.registerCommand('Animation.getPlaybackRate',[],['playbackRate'],false);inspectorBackend.registerCommand('Animation.releaseAnimations',[{'name':'animations','type':'object','optional':false}],[],false);inspectorBackend.registerCommand('Animation.resolveAnimation',[{'name':'animationId','type':'string','optional':false}],['remoteObject'],false);inspectorBackend.registerCommand('Animation.seekAnimations',[{'name':'animations','type':'object','optional':false},{'name':'currentTime','type':'number','optional':false}],[],false);inspectorBackend.registerCommand('Animation.setPaused',[{'name':'animations','type':'object','optional':false},{'name':'paused','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Animation.setPlaybackRate',[{'name':'playbackRate','type':'number','optional':false}],[],false);inspectorBackend.registerCommand('Animation.setTiming',[{'name':'animationId','type':'string','optional':false},{'name':'duration','type':'number','optional':false},{'name':'delay','type':'number','optional':false}],[],false);inspectorBackend.registerEvent('ApplicationCache.applicationCacheStatusUpdated',['frameId','manifestURL','status']);inspectorBackend.registerEvent('ApplicationCache.networkStateUpdated',['isNowOnline']);inspectorBackend.registerCommand('ApplicationCache.enable',[],[],false);inspectorBackend.registerCommand('ApplicationCache.getApplicationCacheForFrame',[{'name':'frameId','type':'string','optional':false}],['applicationCache'],false);inspectorBackend.registerCommand('ApplicationCache.getFramesWithManifests',[],['frameIds'],false);inspectorBackend.registerCommand('ApplicationCache.getManifestForFrame',[{'name':'frameId','type':'string','optional':false}],['manifestURL'],false);inspectorBackend.registerEvent('Audits.issueAdded',['issue']);inspectorBackend.registerCommand('Audits.getEncodedResponse',[{'name':'requestId','type':'string','optional':false},{'name':'encoding','type':'string','optional':false},{'name':'quality','type':'number','optional':true},{'name':'sizeOnly','type':'boolean','optional':true}],['body','originalSize','encodedSize'],false);inspectorBackend.registerCommand('Audits.disable',[],[],false);inspectorBackend.registerCommand('Audits.enable',[],[],false);inspectorBackend.registerEnum('BackgroundService.ServiceName',{BackgroundFetch:'backgroundFetch',BackgroundSync:'backgroundSync',PushMessaging:'pushMessaging',Notifications:'notifications',PaymentHandler:'paymentHandler',PeriodicBackgroundSync:'periodicBackgroundSync'});inspectorBackend.registerEvent('BackgroundService.recordingStateChanged',['isRecording','service']);inspectorBackend.registerEvent('BackgroundService.backgroundServiceEventReceived',['backgroundServiceEvent']);inspectorBackend.registerCommand('BackgroundService.startObserving',[{'name':'service','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('BackgroundService.stopObserving',[{'name':'service','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('BackgroundService.setRecording',[{'name':'shouldRecord','type':'boolean','optional':false},{'name':'service','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('BackgroundService.clearEvents',[{'name':'service','type':'string','optional':false}],[],false);inspectorBackend.registerEnum('Browser.WindowState',{Normal:'normal',Minimized:'minimized',Maximized:'maximized',Fullscreen:'fullscreen'});inspectorBackend.registerEnum('Browser.PermissionType',{AccessibilityEvents:'accessibilityEvents',AudioCapture:'audioCapture',BackgroundSync:'backgroundSync',BackgroundFetch:'backgroundFetch',ClipboardReadWrite:'clipboardReadWrite',ClipboardSanitizedWrite:'clipboardSanitizedWrite',DurableStorage:'durableStorage',Flash:'flash',Geolocation:'geolocation',Midi:'midi',MidiSysex:'midiSysex',Nfc:'nfc',Notifications:'notifications',PaymentHandler:'paymentHandler',PeriodicBackgroundSync:'periodicBackgroundSync',ProtectedMediaIdentifier:'protectedMediaIdentifier',Sensors:'sensors',VideoCapture:'videoCapture',IdleDetection:'idleDetection',WakeLockScreen:'wakeLockScreen',WakeLockSystem:'wakeLockSystem'});inspectorBackend.registerEnum('Browser.PermissionSetting',{Granted:'granted',Denied:'denied',Prompt:'prompt'});inspectorBackend.registerCommand('Browser.setPermission',[{'name':'origin','type':'string','optional':false},{'name':'permission','type':'object','optional':false},{'name':'setting','type':'string','optional':false},{'name':'browserContextId','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Browser.grantPermissions',[{'name':'origin','type':'string','optional':false},{'name':'permissions','type':'object','optional':false},{'name':'browserContextId','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Browser.resetPermissions',[{'name':'browserContextId','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Browser.close',[],[],false);inspectorBackend.registerCommand('Browser.crash',[],[],false);inspectorBackend.registerCommand('Browser.crashGpuProcess',[],[],false);inspectorBackend.registerCommand('Browser.getVersion',[],['protocolVersion','product','revision','userAgent','jsVersion'],false);inspectorBackend.registerCommand('Browser.getBrowserCommandLine',[],['arguments'],false);inspectorBackend.registerCommand('Browser.getHistograms',[{'name':'query','type':'string','optional':true},{'name':'delta','type':'boolean','optional':true}],['histograms'],false);inspectorBackend.registerCommand('Browser.getHistogram',[{'name':'name','type':'string','optional':false},{'name':'delta','type':'boolean','optional':true}],['histogram'],false);inspectorBackend.registerCommand('Browser.getWindowBounds',[{'name':'windowId','type':'number','optional':false}],['bounds'],false);inspectorBackend.registerCommand('Browser.getWindowForTarget',[{'name':'targetId','type':'string','optional':true}],['windowId','bounds'],false);inspectorBackend.registerCommand('Browser.setWindowBounds',[{'name':'windowId','type':'number','optional':false},{'name':'bounds','type':'object','optional':false}],[],false);inspectorBackend.registerCommand('Browser.setDockTile',[{'name':'badgeLabel','type':'string','optional':true},{'name':'image','type':'string','optional':true}],[],false);inspectorBackend.registerEnum('CSS.StyleSheetOrigin',{Injected:'injected',UserAgent:'user-agent',Inspector:'inspector',Regular:'regular'});inspectorBackend.registerEnum('CSS.CSSMediaSource',{MediaRule:'mediaRule',ImportRule:'importRule',LinkedSheet:'linkedSheet',InlineSheet:'inlineSheet'});inspectorBackend.registerEvent('CSS.fontsUpdated',['font']);inspectorBackend.registerEvent('CSS.mediaQueryResultChanged',[]);inspectorBackend.registerEvent('CSS.styleSheetAdded',['header']);inspectorBackend.registerEvent('CSS.styleSheetChanged',['styleSheetId']);inspectorBackend.registerEvent('CSS.styleSheetRemoved',['styleSheetId']);inspectorBackend.registerCommand('CSS.addRule',[{'name':'styleSheetId','type':'string','optional':false},{'name':'ruleText','type':'string','optional':false},{'name':'location','type':'object','optional':false}],['rule'],false);inspectorBackend.registerCommand('CSS.collectClassNames',[{'name':'styleSheetId','type':'string','optional':false}],['classNames'],false);inspectorBackend.registerCommand('CSS.createStyleSheet',[{'name':'frameId','type':'string','optional':false}],['styleSheetId'],false);inspectorBackend.registerCommand('CSS.disable',[],[],false);inspectorBackend.registerCommand('CSS.enable',[],[],false);inspectorBackend.registerCommand('CSS.forcePseudoState',[{'name':'nodeId','type':'number','optional':false},{'name':'forcedPseudoClasses','type':'object','optional':false}],[],false);inspectorBackend.registerCommand('CSS.getBackgroundColors',[{'name':'nodeId','type':'number','optional':false}],['backgroundColors','computedFontSize','computedFontWeight'],false);inspectorBackend.registerCommand('CSS.getComputedStyleForNode',[{'name':'nodeId','type':'number','optional':false}],['computedStyle'],false);inspectorBackend.registerCommand('CSS.getInlineStylesForNode',[{'name':'nodeId','type':'number','optional':false}],['inlineStyle','attributesStyle'],false);inspectorBackend.registerCommand('CSS.getMatchedStylesForNode',[{'name':'nodeId','type':'number','optional':false}],['inlineStyle','attributesStyle','matchedCSSRules','pseudoElements','inherited','cssKeyframesRules'],false);inspectorBackend.registerCommand('CSS.getMediaQueries',[],['medias'],false);inspectorBackend.registerCommand('CSS.getPlatformFontsForNode',[{'name':'nodeId','type':'number','optional':false}],['fonts'],false);inspectorBackend.registerCommand('CSS.getStyleSheetText',[{'name':'styleSheetId','type':'string','optional':false}],['text'],false);inspectorBackend.registerCommand('CSS.setEffectivePropertyValueForNode',[{'name':'nodeId','type':'number','optional':false},{'name':'propertyName','type':'string','optional':false},{'name':'value','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('CSS.setKeyframeKey',[{'name':'styleSheetId','type':'string','optional':false},{'name':'range','type':'object','optional':false},{'name':'keyText','type':'string','optional':false}],['keyText'],false);inspectorBackend.registerCommand('CSS.setMediaText',[{'name':'styleSheetId','type':'string','optional':false},{'name':'range','type':'object','optional':false},{'name':'text','type':'string','optional':false}],['media'],false);inspectorBackend.registerCommand('CSS.setRuleSelector',[{'name':'styleSheetId','type':'string','optional':false},{'name':'range','type':'object','optional':false},{'name':'selector','type':'string','optional':false}],['selectorList'],false);inspectorBackend.registerCommand('CSS.setStyleSheetText',[{'name':'styleSheetId','type':'string','optional':false},{'name':'text','type':'string','optional':false}],['sourceMapURL'],false);inspectorBackend.registerCommand('CSS.setStyleTexts',[{'name':'edits','type':'object','optional':false}],['styles'],false);inspectorBackend.registerCommand('CSS.startRuleUsageTracking',[],[],false);inspectorBackend.registerCommand('CSS.stopRuleUsageTracking',[],['ruleUsage'],false);inspectorBackend.registerCommand('CSS.takeCoverageDelta',[],['coverage','timestamp'],false);inspectorBackend.registerEnum('CacheStorage.CachedResponseType',{Basic:'basic',Cors:'cors',Default:'default',Error:'error',OpaqueResponse:'opaqueResponse',OpaqueRedirect:'opaqueRedirect'});inspectorBackend.registerCommand('CacheStorage.deleteCache',[{'name':'cacheId','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('CacheStorage.deleteEntry',[{'name':'cacheId','type':'string','optional':false},{'name':'request','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('CacheStorage.requestCacheNames',[{'name':'securityOrigin','type':'string','optional':false}],['caches'],false);inspectorBackend.registerCommand('CacheStorage.requestCachedResponse',[{'name':'cacheId','type':'string','optional':false},{'name':'requestURL','type':'string','optional':false},{'name':'requestHeaders','type':'object','optional':false}],['response'],false);inspectorBackend.registerCommand('CacheStorage.requestEntries',[{'name':'cacheId','type':'string','optional':false},{'name':'skipCount','type':'number','optional':true},{'name':'pageSize','type':'number','optional':true},{'name':'pathFilter','type':'string','optional':true}],['cacheDataEntries','returnCount'],false);inspectorBackend.registerEvent('Cast.sinksUpdated',['sinks']);inspectorBackend.registerEvent('Cast.issueUpdated',['issueMessage']);inspectorBackend.registerCommand('Cast.enable',[{'name':'presentationUrl','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Cast.disable',[],[],false);inspectorBackend.registerCommand('Cast.setSinkToUse',[{'name':'sinkName','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Cast.startTabMirroring',[{'name':'sinkName','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Cast.stopCasting',[{'name':'sinkName','type':'string','optional':false}],[],false);inspectorBackend.registerEnum('DOM.PseudoType',{FirstLine:'first-line',FirstLetter:'first-letter',Before:'before',After:'after',Marker:'marker',Backdrop:'backdrop',Selection:'selection',FirstLineInherited:'first-line-inherited',Scrollbar:'scrollbar',ScrollbarThumb:'scrollbar-thumb',ScrollbarButton:'scrollbar-button',ScrollbarTrack:'scrollbar-track',ScrollbarTrackPiece:'scrollbar-track-piece',ScrollbarCorner:'scrollbar-corner',Resizer:'resizer',InputListButton:'input-list-button'});inspectorBackend.registerEnum('DOM.ShadowRootType',{UserAgent:'user-agent',Open:'open',Closed:'closed'});inspectorBackend.registerEvent('DOM.attributeModified',['nodeId','name','value']);inspectorBackend.registerEvent('DOM.attributeRemoved',['nodeId','name']);inspectorBackend.registerEvent('DOM.characterDataModified',['nodeId','characterData']);inspectorBackend.registerEvent('DOM.childNodeCountUpdated',['nodeId','childNodeCount']);inspectorBackend.registerEvent('DOM.childNodeInserted',['parentNodeId','previousNodeId','node']);inspectorBackend.registerEvent('DOM.childNodeRemoved',['parentNodeId','nodeId']);inspectorBackend.registerEvent('DOM.distributedNodesUpdated',['insertionPointId','distributedNodes']);inspectorBackend.registerEvent('DOM.documentUpdated',[]);inspectorBackend.registerEvent('DOM.inlineStyleInvalidated',['nodeIds']);inspectorBackend.registerEvent('DOM.pseudoElementAdded',['parentId','pseudoElement']);inspectorBackend.registerEvent('DOM.pseudoElementRemoved',['parentId','pseudoElementId']);inspectorBackend.registerEvent('DOM.setChildNodes',['parentId','nodes']);inspectorBackend.registerEvent('DOM.shadowRootPopped',['hostId','rootId']);inspectorBackend.registerEvent('DOM.shadowRootPushed',['hostId','root']);inspectorBackend.registerCommand('DOM.collectClassNamesFromSubtree',[{'name':'nodeId','type':'number','optional':false}],['classNames'],false);inspectorBackend.registerCommand('DOM.copyTo',[{'name':'nodeId','type':'number','optional':false},{'name':'targetNodeId','type':'number','optional':false},{'name':'insertBeforeNodeId','type':'number','optional':true}],['nodeId'],false);inspectorBackend.registerCommand('DOM.describeNode',[{'name':'nodeId','type':'number','optional':true},{'name':'backendNodeId','type':'number','optional':true},{'name':'objectId','type':'string','optional':true},{'name':'depth','type':'number','optional':true},{'name':'pierce','type':'boolean','optional':true}],['node'],false);inspectorBackend.registerCommand('DOM.scrollIntoViewIfNeeded',[{'name':'nodeId','type':'number','optional':true},{'name':'backendNodeId','type':'number','optional':true},{'name':'objectId','type':'string','optional':true},{'name':'rect','type':'object','optional':true}],[],false);inspectorBackend.registerCommand('DOM.disable',[],[],false);inspectorBackend.registerCommand('DOM.discardSearchResults',[{'name':'searchId','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('DOM.enable',[],[],false);inspectorBackend.registerCommand('DOM.focus',[{'name':'nodeId','type':'number','optional':true},{'name':'backendNodeId','type':'number','optional':true},{'name':'objectId','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('DOM.getAttributes',[{'name':'nodeId','type':'number','optional':false}],['attributes'],false);inspectorBackend.registerCommand('DOM.getBoxModel',[{'name':'nodeId','type':'number','optional':true},{'name':'backendNodeId','type':'number','optional':true},{'name':'objectId','type':'string','optional':true}],['model'],false);inspectorBackend.registerCommand('DOM.getContentQuads',[{'name':'nodeId','type':'number','optional':true},{'name':'backendNodeId','type':'number','optional':true},{'name':'objectId','type':'string','optional':true}],['quads'],false);inspectorBackend.registerCommand('DOM.getDocument',[{'name':'depth','type':'number','optional':true},{'name':'pierce','type':'boolean','optional':true}],['root'],false);inspectorBackend.registerCommand('DOM.getFlattenedDocument',[{'name':'depth','type':'number','optional':true},{'name':'pierce','type':'boolean','optional':true}],['nodes'],false);inspectorBackend.registerCommand('DOM.getNodeForLocation',[{'name':'x','type':'number','optional':false},{'name':'y','type':'number','optional':false},{'name':'includeUserAgentShadowDOM','type':'boolean','optional':true},{'name':'ignorePointerEventsNone','type':'boolean','optional':true}],['backendNodeId','frameId','nodeId'],false);inspectorBackend.registerCommand('DOM.getOuterHTML',[{'name':'nodeId','type':'number','optional':true},{'name':'backendNodeId','type':'number','optional':true},{'name':'objectId','type':'string','optional':true}],['outerHTML'],false);inspectorBackend.registerCommand('DOM.getRelayoutBoundary',[{'name':'nodeId','type':'number','optional':false}],['nodeId'],false);inspectorBackend.registerCommand('DOM.getSearchResults',[{'name':'searchId','type':'string','optional':false},{'name':'fromIndex','type':'number','optional':false},{'name':'toIndex','type':'number','optional':false}],['nodeIds'],false);inspectorBackend.registerCommand('DOM.hideHighlight',[],[],false);inspectorBackend.registerCommand('DOM.highlightNode',[],[],false);inspectorBackend.registerCommand('DOM.highlightRect',[],[],false);inspectorBackend.registerCommand('DOM.markUndoableState',[],[],false);inspectorBackend.registerCommand('DOM.moveTo',[{'name':'nodeId','type':'number','optional':false},{'name':'targetNodeId','type':'number','optional':false},{'name':'insertBeforeNodeId','type':'number','optional':true}],['nodeId'],false);inspectorBackend.registerCommand('DOM.performSearch',[{'name':'query','type':'string','optional':false},{'name':'includeUserAgentShadowDOM','type':'boolean','optional':true}],['searchId','resultCount'],false);inspectorBackend.registerCommand('DOM.pushNodeByPathToFrontend',[{'name':'path','type':'string','optional':false}],['nodeId'],false);inspectorBackend.registerCommand('DOM.pushNodesByBackendIdsToFrontend',[{'name':'backendNodeIds','type':'object','optional':false}],['nodeIds'],false);inspectorBackend.registerCommand('DOM.querySelector',[{'name':'nodeId','type':'number','optional':false},{'name':'selector','type':'string','optional':false}],['nodeId'],false);inspectorBackend.registerCommand('DOM.querySelectorAll',[{'name':'nodeId','type':'number','optional':false},{'name':'selector','type':'string','optional':false}],['nodeIds'],false);inspectorBackend.registerCommand('DOM.redo',[],[],false);inspectorBackend.registerCommand('DOM.removeAttribute',[{'name':'nodeId','type':'number','optional':false},{'name':'name','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('DOM.removeNode',[{'name':'nodeId','type':'number','optional':false}],[],false);inspectorBackend.registerCommand('DOM.requestChildNodes',[{'name':'nodeId','type':'number','optional':false},{'name':'depth','type':'number','optional':true},{'name':'pierce','type':'boolean','optional':true}],[],false);inspectorBackend.registerCommand('DOM.requestNode',[{'name':'objectId','type':'string','optional':false}],['nodeId'],false);inspectorBackend.registerCommand('DOM.resolveNode',[{'name':'nodeId','type':'number','optional':true},{'name':'backendNodeId','type':'number','optional':true},{'name':'objectGroup','type':'string','optional':true},{'name':'executionContextId','type':'number','optional':true}],['object'],false);inspectorBackend.registerCommand('DOM.setAttributeValue',[{'name':'nodeId','type':'number','optional':false},{'name':'name','type':'string','optional':false},{'name':'value','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('DOM.setAttributesAsText',[{'name':'nodeId','type':'number','optional':false},{'name':'text','type':'string','optional':false},{'name':'name','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('DOM.setFileInputFiles',[{'name':'files','type':'object','optional':false},{'name':'nodeId','type':'number','optional':true},{'name':'backendNodeId','type':'number','optional':true},{'name':'objectId','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('DOM.setNodeStackTracesEnabled',[{'name':'enable','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('DOM.getNodeStackTraces',[{'name':'nodeId','type':'number','optional':false}],['creation'],false);inspectorBackend.registerCommand('DOM.getFileInfo',[{'name':'objectId','type':'string','optional':false}],['path'],false);inspectorBackend.registerCommand('DOM.setInspectedNode',[{'name':'nodeId','type':'number','optional':false}],[],false);inspectorBackend.registerCommand('DOM.setNodeName',[{'name':'nodeId','type':'number','optional':false},{'name':'name','type':'string','optional':false}],['nodeId'],false);inspectorBackend.registerCommand('DOM.setNodeValue',[{'name':'nodeId','type':'number','optional':false},{'name':'value','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('DOM.setOuterHTML',[{'name':'nodeId','type':'number','optional':false},{'name':'outerHTML','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('DOM.undo',[],[],false);inspectorBackend.registerCommand('DOM.getFrameOwner',[{'name':'frameId','type':'string','optional':false}],['backendNodeId','nodeId'],false);inspectorBackend.registerEnum('DOMDebugger.DOMBreakpointType',{SubtreeModified:'subtree-modified',AttributeModified:'attribute-modified',NodeRemoved:'node-removed'});inspectorBackend.registerCommand('DOMDebugger.getEventListeners',[{'name':'objectId','type':'string','optional':false},{'name':'depth','type':'number','optional':true},{'name':'pierce','type':'boolean','optional':true}],['listeners'],false);inspectorBackend.registerCommand('DOMDebugger.removeDOMBreakpoint',[{'name':'nodeId','type':'number','optional':false},{'name':'type','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('DOMDebugger.removeEventListenerBreakpoint',[{'name':'eventName','type':'string','optional':false},{'name':'targetName','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('DOMDebugger.removeInstrumentationBreakpoint',[{'name':'eventName','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('DOMDebugger.removeXHRBreakpoint',[{'name':'url','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('DOMDebugger.setDOMBreakpoint',[{'name':'nodeId','type':'number','optional':false},{'name':'type','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('DOMDebugger.setEventListenerBreakpoint',[{'name':'eventName','type':'string','optional':false},{'name':'targetName','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('DOMDebugger.setInstrumentationBreakpoint',[{'name':'eventName','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('DOMDebugger.setXHRBreakpoint',[{'name':'url','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('DOMSnapshot.disable',[],[],false);inspectorBackend.registerCommand('DOMSnapshot.enable',[],[],false);inspectorBackend.registerCommand('DOMSnapshot.getSnapshot',[{'name':'computedStyleWhitelist','type':'object','optional':false},{'name':'includeEventListeners','type':'boolean','optional':true},{'name':'includePaintOrder','type':'boolean','optional':true},{'name':'includeUserAgentShadowTree','type':'boolean','optional':true}],['domNodes','layoutTreeNodes','computedStyles'],false);inspectorBackend.registerCommand('DOMSnapshot.captureSnapshot',[{'name':'computedStyles','type':'object','optional':false},{'name':'includePaintOrder','type':'boolean','optional':true},{'name':'includeDOMRects','type':'boolean','optional':true}],['documents','strings'],false);inspectorBackend.registerEvent('DOMStorage.domStorageItemAdded',['storageId','key','newValue']);inspectorBackend.registerEvent('DOMStorage.domStorageItemRemoved',['storageId','key']);inspectorBackend.registerEvent('DOMStorage.domStorageItemUpdated',['storageId','key','oldValue','newValue']);inspectorBackend.registerEvent('DOMStorage.domStorageItemsCleared',['storageId']);inspectorBackend.registerCommand('DOMStorage.clear',[{'name':'storageId','type':'object','optional':false}],[],false);inspectorBackend.registerCommand('DOMStorage.disable',[],[],false);inspectorBackend.registerCommand('DOMStorage.enable',[],[],false);inspectorBackend.registerCommand('DOMStorage.getDOMStorageItems',[{'name':'storageId','type':'object','optional':false}],['entries'],false);inspectorBackend.registerCommand('DOMStorage.removeDOMStorageItem',[{'name':'storageId','type':'object','optional':false},{'name':'key','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('DOMStorage.setDOMStorageItem',[{'name':'storageId','type':'object','optional':false},{'name':'key','type':'string','optional':false},{'name':'value','type':'string','optional':false}],[],false);inspectorBackend.registerEvent('Database.addDatabase',['database']);inspectorBackend.registerCommand('Database.disable',[],[],false);inspectorBackend.registerCommand('Database.enable',[],[],false);inspectorBackend.registerCommand('Database.executeSQL',[{'name':'databaseId','type':'string','optional':false},{'name':'query','type':'string','optional':false}],['columnNames','values','sqlError'],false);inspectorBackend.registerCommand('Database.getDatabaseTableNames',[{'name':'databaseId','type':'string','optional':false}],['tableNames'],false);inspectorBackend.registerCommand('DeviceOrientation.clearDeviceOrientationOverride',[],[],false);inspectorBackend.registerCommand('DeviceOrientation.setDeviceOrientationOverride',[{'name':'alpha','type':'number','optional':false},{'name':'beta','type':'number','optional':false},{'name':'gamma','type':'number','optional':false}],[],false);inspectorBackend.registerEnum('Emulation.ScreenOrientationType',{PortraitPrimary:'portraitPrimary',PortraitSecondary:'portraitSecondary',LandscapePrimary:'landscapePrimary',LandscapeSecondary:'landscapeSecondary'});inspectorBackend.registerEnum('Emulation.VirtualTimePolicy',{Advance:'advance',Pause:'pause',PauseIfNetworkFetchesPending:'pauseIfNetworkFetchesPending'});inspectorBackend.registerEvent('Emulation.virtualTimeBudgetExpired',[]);inspectorBackend.registerCommand('Emulation.canEmulate',[],['result'],false);inspectorBackend.registerCommand('Emulation.clearDeviceMetricsOverride',[],[],false);inspectorBackend.registerCommand('Emulation.clearGeolocationOverride',[],[],false);inspectorBackend.registerCommand('Emulation.resetPageScaleFactor',[],[],false);inspectorBackend.registerCommand('Emulation.setFocusEmulationEnabled',[{'name':'enabled','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Emulation.setCPUThrottlingRate',[{'name':'rate','type':'number','optional':false}],[],false);inspectorBackend.registerCommand('Emulation.setDefaultBackgroundColorOverride',[{'name':'color','type':'object','optional':true}],[],false);inspectorBackend.registerCommand('Emulation.setDeviceMetricsOverride',[{'name':'width','type':'number','optional':false},{'name':'height','type':'number','optional':false},{'name':'deviceScaleFactor','type':'number','optional':false},{'name':'mobile','type':'boolean','optional':false},{'name':'scale','type':'number','optional':true},{'name':'screenWidth','type':'number','optional':true},{'name':'screenHeight','type':'number','optional':true},{'name':'positionX','type':'number','optional':true},{'name':'positionY','type':'number','optional':true},{'name':'dontSetVisibleSize','type':'boolean','optional':true},{'name':'screenOrientation','type':'object','optional':true},{'name':'viewport','type':'object','optional':true}],[],false);inspectorBackend.registerCommand('Emulation.setScrollbarsHidden',[{'name':'hidden','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Emulation.setDocumentCookieDisabled',[{'name':'disabled','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Emulation.setEmitTouchEventsForMouse',[{'name':'enabled','type':'boolean','optional':false},{'name':'configuration','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Emulation.setEmulatedMedia',[{'name':'media','type':'string','optional':true},{'name':'features','type':'object','optional':true}],[],false);inspectorBackend.registerCommand('Emulation.setEmulatedVisionDeficiency',[{'name':'type','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Emulation.setGeolocationOverride',[{'name':'latitude','type':'number','optional':true},{'name':'longitude','type':'number','optional':true},{'name':'accuracy','type':'number','optional':true}],[],false);inspectorBackend.registerCommand('Emulation.setNavigatorOverrides',[{'name':'platform','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Emulation.setPageScaleFactor',[{'name':'pageScaleFactor','type':'number','optional':false}],[],false);inspectorBackend.registerCommand('Emulation.setScriptExecutionDisabled',[{'name':'value','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Emulation.setTouchEmulationEnabled',[{'name':'enabled','type':'boolean','optional':false},{'name':'maxTouchPoints','type':'number','optional':true}],[],false);inspectorBackend.registerCommand('Emulation.setVirtualTimePolicy',[{'name':'policy','type':'string','optional':false},{'name':'budget','type':'number','optional':true},{'name':'maxVirtualTimeTaskStarvationCount','type':'number','optional':true},{'name':'waitForNavigation','type':'boolean','optional':true},{'name':'initialVirtualTime','type':'number','optional':true}],['virtualTimeTicksBase'],false);inspectorBackend.registerCommand('Emulation.setLocaleOverride',[{'name':'locale','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Emulation.setTimezoneOverride',[{'name':'timezoneId','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Emulation.setVisibleSize',[{'name':'width','type':'number','optional':false},{'name':'height','type':'number','optional':false}],[],false);inspectorBackend.registerCommand('Emulation.setUserAgentOverride',[{'name':'userAgent','type':'string','optional':false},{'name':'acceptLanguage','type':'string','optional':true},{'name':'platform','type':'string','optional':true}],[],false);inspectorBackend.registerEnum('HeadlessExperimental.ScreenshotParamsFormat',{Jpeg:'jpeg',Png:'png'});inspectorBackend.registerEvent('HeadlessExperimental.needsBeginFramesChanged',['needsBeginFrames']);inspectorBackend.registerCommand('HeadlessExperimental.beginFrame',[{'name':'frameTimeTicks','type':'number','optional':true},{'name':'interval','type':'number','optional':true},{'name':'noDisplayUpdates','type':'boolean','optional':true},{'name':'screenshot','type':'object','optional':true}],['hasDamage','screenshotData'],false);inspectorBackend.registerCommand('HeadlessExperimental.disable',[],[],false);inspectorBackend.registerCommand('HeadlessExperimental.enable',[],[],false);inspectorBackend.registerCommand('IO.close',[{'name':'handle','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('IO.read',[{'name':'handle','type':'string','optional':false},{'name':'offset','type':'number','optional':true},{'name':'size','type':'number','optional':true}],['base64Encoded','data','eof'],false);inspectorBackend.registerCommand('IO.resolveBlob',[{'name':'objectId','type':'string','optional':false}],['uuid'],false);inspectorBackend.registerEnum('IndexedDB.KeyType',{Number:'number',String:'string',Date:'date',Array:'array'});inspectorBackend.registerEnum('IndexedDB.KeyPathType',{Null:'null',String:'string',Array:'array'});inspectorBackend.registerCommand('IndexedDB.clearObjectStore',[{'name':'securityOrigin','type':'string','optional':false},{'name':'databaseName','type':'string','optional':false},{'name':'objectStoreName','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('IndexedDB.deleteDatabase',[{'name':'securityOrigin','type':'string','optional':false},{'name':'databaseName','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('IndexedDB.deleteObjectStoreEntries',[{'name':'securityOrigin','type':'string','optional':false},{'name':'databaseName','type':'string','optional':false},{'name':'objectStoreName','type':'string','optional':false},{'name':'keyRange','type':'object','optional':false}],[],false);inspectorBackend.registerCommand('IndexedDB.disable',[],[],false);inspectorBackend.registerCommand('IndexedDB.enable',[],[],false);inspectorBackend.registerCommand('IndexedDB.requestData',[{'name':'securityOrigin','type':'string','optional':false},{'name':'databaseName','type':'string','optional':false},{'name':'objectStoreName','type':'string','optional':false},{'name':'indexName','type':'string','optional':false},{'name':'skipCount','type':'number','optional':false},{'name':'pageSize','type':'number','optional':false},{'name':'keyRange','type':'object','optional':true}],['objectStoreDataEntries','hasMore'],false);inspectorBackend.registerCommand('IndexedDB.getMetadata',[{'name':'securityOrigin','type':'string','optional':false},{'name':'databaseName','type':'string','optional':false},{'name':'objectStoreName','type':'string','optional':false}],['entriesCount','keyGeneratorValue'],false);inspectorBackend.registerCommand('IndexedDB.requestDatabase',[{'name':'securityOrigin','type':'string','optional':false},{'name':'databaseName','type':'string','optional':false}],['databaseWithObjectStores'],false);inspectorBackend.registerCommand('IndexedDB.requestDatabaseNames',[{'name':'securityOrigin','type':'string','optional':false}],['databaseNames'],false);inspectorBackend.registerEnum('Input.GestureSourceType',{Default:'default',Touch:'touch',Mouse:'mouse'});inspectorBackend.registerEnum('Input.MouseButton',{None:'none',Left:'left',Middle:'middle',Right:'right',Back:'back',Forward:'forward'});inspectorBackend.registerCommand('Input.dispatchKeyEvent',[{'name':'type','type':'string','optional':false},{'name':'modifiers','type':'number','optional':true},{'name':'timestamp','type':'number','optional':true},{'name':'text','type':'string','optional':true},{'name':'unmodifiedText','type':'string','optional':true},{'name':'keyIdentifier','type':'string','optional':true},{'name':'code','type':'string','optional':true},{'name':'key','type':'string','optional':true},{'name':'windowsVirtualKeyCode','type':'number','optional':true},{'name':'nativeVirtualKeyCode','type':'number','optional':true},{'name':'autoRepeat','type':'boolean','optional':true},{'name':'isKeypad','type':'boolean','optional':true},{'name':'isSystemKey','type':'boolean','optional':true},{'name':'location','type':'number','optional':true}],[],false);inspectorBackend.registerCommand('Input.insertText',[{'name':'text','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Input.dispatchMouseEvent',[{'name':'type','type':'string','optional':false},{'name':'x','type':'number','optional':false},{'name':'y','type':'number','optional':false},{'name':'modifiers','type':'number','optional':true},{'name':'timestamp','type':'number','optional':true},{'name':'button','type':'string','optional':true},{'name':'buttons','type':'number','optional':true},{'name':'clickCount','type':'number','optional':true},{'name':'deltaX','type':'number','optional':true},{'name':'deltaY','type':'number','optional':true},{'name':'pointerType','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Input.dispatchTouchEvent',[{'name':'type','type':'string','optional':false},{'name':'touchPoints','type':'object','optional':false},{'name':'modifiers','type':'number','optional':true},{'name':'timestamp','type':'number','optional':true}],[],false);inspectorBackend.registerCommand('Input.emulateTouchFromMouseEvent',[{'name':'type','type':'string','optional':false},{'name':'x','type':'number','optional':false},{'name':'y','type':'number','optional':false},{'name':'button','type':'string','optional':false},{'name':'timestamp','type':'number','optional':true},{'name':'deltaX','type':'number','optional':true},{'name':'deltaY','type':'number','optional':true},{'name':'modifiers','type':'number','optional':true},{'name':'clickCount','type':'number','optional':true}],[],false);inspectorBackend.registerCommand('Input.setIgnoreInputEvents',[{'name':'ignore','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Input.synthesizePinchGesture',[{'name':'x','type':'number','optional':false},{'name':'y','type':'number','optional':false},{'name':'scaleFactor','type':'number','optional':false},{'name':'relativeSpeed','type':'number','optional':true},{'name':'gestureSourceType','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Input.synthesizeScrollGesture',[{'name':'x','type':'number','optional':false},{'name':'y','type':'number','optional':false},{'name':'xDistance','type':'number','optional':true},{'name':'yDistance','type':'number','optional':true},{'name':'xOverscroll','type':'number','optional':true},{'name':'yOverscroll','type':'number','optional':true},{'name':'preventFling','type':'boolean','optional':true},{'name':'speed','type':'number','optional':true},{'name':'gestureSourceType','type':'string','optional':true},{'name':'repeatCount','type':'number','optional':true},{'name':'repeatDelayMs','type':'number','optional':true},{'name':'interactionMarkerName','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Input.synthesizeTapGesture',[{'name':'x','type':'number','optional':false},{'name':'y','type':'number','optional':false},{'name':'duration','type':'number','optional':true},{'name':'tapCount','type':'number','optional':true},{'name':'gestureSourceType','type':'string','optional':true}],[],false);inspectorBackend.registerEvent('Inspector.detached',['reason']);inspectorBackend.registerEvent('Inspector.targetCrashed',[]);inspectorBackend.registerEvent('Inspector.targetReloadedAfterCrash',[]);inspectorBackend.registerCommand('Inspector.disable',[],[],false);inspectorBackend.registerCommand('Inspector.enable',[],[],false);inspectorBackend.registerEnum('LayerTree.ScrollRectType',{RepaintsOnScroll:'RepaintsOnScroll',TouchEventHandler:'TouchEventHandler',WheelEventHandler:'WheelEventHandler'});inspectorBackend.registerEvent('LayerTree.layerPainted',['layerId','clip']);inspectorBackend.registerEvent('LayerTree.layerTreeDidChange',['layers']);inspectorBackend.registerCommand('LayerTree.compositingReasons',[{'name':'layerId','type':'string','optional':false}],['compositingReasons','compositingReasonIds'],false);inspectorBackend.registerCommand('LayerTree.disable',[],[],false);inspectorBackend.registerCommand('LayerTree.enable',[],[],false);inspectorBackend.registerCommand('LayerTree.loadSnapshot',[{'name':'tiles','type':'object','optional':false}],['snapshotId'],false);inspectorBackend.registerCommand('LayerTree.makeSnapshot',[{'name':'layerId','type':'string','optional':false}],['snapshotId'],false);inspectorBackend.registerCommand('LayerTree.profileSnapshot',[{'name':'snapshotId','type':'string','optional':false},{'name':'minRepeatCount','type':'number','optional':true},{'name':'minDuration','type':'number','optional':true},{'name':'clipRect','type':'object','optional':true}],['timings'],false);inspectorBackend.registerCommand('LayerTree.releaseSnapshot',[{'name':'snapshotId','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('LayerTree.replaySnapshot',[{'name':'snapshotId','type':'string','optional':false},{'name':'fromStep','type':'number','optional':true},{'name':'toStep','type':'number','optional':true},{'name':'scale','type':'number','optional':true}],['dataURL'],false);inspectorBackend.registerCommand('LayerTree.snapshotCommandLog',[{'name':'snapshotId','type':'string','optional':false}],['commandLog'],false);inspectorBackend.registerEnum('Log.LogEntrySource',{XML:'xml',Javascript:'javascript',Network:'network',Storage:'storage',Appcache:'appcache',Rendering:'rendering',Security:'security',Deprecation:'deprecation',Worker:'worker',Violation:'violation',Intervention:'intervention',Recommendation:'recommendation',Other:'other'});inspectorBackend.registerEnum('Log.LogEntryLevel',{Verbose:'verbose',Info:'info',Warning:'warning',Error:'error'});inspectorBackend.registerEnum('Log.ViolationSettingName',{LongTask:'longTask',LongLayout:'longLayout',BlockedEvent:'blockedEvent',BlockedParser:'blockedParser',DiscouragedAPIUse:'discouragedAPIUse',Handler:'handler',RecurringHandler:'recurringHandler'});inspectorBackend.registerEvent('Log.entryAdded',['entry']);inspectorBackend.registerCommand('Log.clear',[],[],false);inspectorBackend.registerCommand('Log.disable',[],[],false);inspectorBackend.registerCommand('Log.enable',[],[],false);inspectorBackend.registerCommand('Log.startViolationsReport',[{'name':'config','type':'object','optional':false}],[],false);inspectorBackend.registerCommand('Log.stopViolationsReport',[],[],false);inspectorBackend.registerEnum('Memory.PressureLevel',{Moderate:'moderate',Critical:'critical'});inspectorBackend.registerCommand('Memory.getDOMCounters',[],['documents','nodes','jsEventListeners'],false);inspectorBackend.registerCommand('Memory.prepareForLeakDetection',[],[],false);inspectorBackend.registerCommand('Memory.forciblyPurgeJavaScriptMemory',[],[],false);inspectorBackend.registerCommand('Memory.setPressureNotificationsSuppressed',[{'name':'suppressed','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Memory.simulatePressureNotification',[{'name':'level','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Memory.startSampling',[{'name':'samplingInterval','type':'number','optional':true},{'name':'suppressRandomness','type':'boolean','optional':true}],[],false);inspectorBackend.registerCommand('Memory.stopSampling',[],[],false);inspectorBackend.registerCommand('Memory.getAllTimeSamplingProfile',[],['profile'],false);inspectorBackend.registerCommand('Memory.getBrowserSamplingProfile',[],['profile'],false);inspectorBackend.registerCommand('Memory.getSamplingProfile',[],['profile'],false);inspectorBackend.registerEnum('Network.ResourceType',{Document:'Document',Stylesheet:'Stylesheet',Image:'Image',Media:'Media',Font:'Font',Script:'Script',TextTrack:'TextTrack',XHR:'XHR',Fetch:'Fetch',EventSource:'EventSource',WebSocket:'WebSocket',Manifest:'Manifest',SignedExchange:'SignedExchange',Ping:'Ping',CSPViolationReport:'CSPViolationReport',Other:'Other'});inspectorBackend.registerEnum('Network.ErrorReason',{Failed:'Failed',Aborted:'Aborted',TimedOut:'TimedOut',AccessDenied:'AccessDenied',ConnectionClosed:'ConnectionClosed',ConnectionReset:'ConnectionReset',ConnectionRefused:'ConnectionRefused',ConnectionAborted:'ConnectionAborted',ConnectionFailed:'ConnectionFailed',NameNotResolved:'NameNotResolved',InternetDisconnected:'InternetDisconnected',AddressUnreachable:'AddressUnreachable',BlockedByClient:'BlockedByClient',BlockedByResponse:'BlockedByResponse'});inspectorBackend.registerEnum('Network.ConnectionType',{None:'none',Cellular2g:'cellular2g',Cellular3g:'cellular3g',Cellular4g:'cellular4g',Bluetooth:'bluetooth',Ethernet:'ethernet',Wifi:'wifi',Wimax:'wimax',Other:'other'});inspectorBackend.registerEnum('Network.CookieSameSite',{Strict:'Strict',Lax:'Lax',None:'None'});inspectorBackend.registerEnum('Network.CookiePriority',{Low:'Low',Medium:'Medium',High:'High'});inspectorBackend.registerEnum('Network.ResourcePriority',{VeryLow:'VeryLow',Low:'Low',Medium:'Medium',High:'High',VeryHigh:'VeryHigh'});inspectorBackend.registerEnum('Network.RequestReferrerPolicy',{UnsafeUrl:'unsafe-url',NoReferrerWhenDowngrade:'no-referrer-when-downgrade',NoReferrer:'no-referrer',Origin:'origin',OriginWhenCrossOrigin:'origin-when-cross-origin',SameOrigin:'same-origin',StrictOrigin:'strict-origin',StrictOriginWhenCrossOrigin:'strict-origin-when-cross-origin'});inspectorBackend.registerEnum('Network.CertificateTransparencyCompliance',{Unknown:'unknown',NotCompliant:'not-compliant',Compliant:'compliant'});inspectorBackend.registerEnum('Network.BlockedReason',{Other:'other',Csp:'csp',MixedContent:'mixed-content',Origin:'origin',Inspector:'inspector',SubresourceFilter:'subresource-filter',ContentType:'content-type',CollapsedByClient:'collapsed-by-client',CoepFrameResourceNeedsCoepHeader:'coep-frame-resource-needs-coep-header',CoopSandboxedIframeCannotNavigateToCoopPage:'coop-sandboxed-iframe-cannot-navigate-to-coop-page',CorpNotSameOrigin:'corp-not-same-origin',CorpNotSameOriginAfterDefaultedToSameOriginByCoep:'corp-not-same-origin-after-defaulted-to-same-origin-by-coep',CorpNotSameSite:'corp-not-same-site'});inspectorBackend.registerEnum('Network.InitiatorType',{Parser:'parser',Script:'script',Preload:'preload',SignedExchange:'SignedExchange',Other:'other'});inspectorBackend.registerEnum('Network.SetCookieBlockedReason',{SecureOnly:'SecureOnly',SameSiteStrict:'SameSiteStrict',SameSiteLax:'SameSiteLax',SameSiteUnspecifiedTreatedAsLax:'SameSiteUnspecifiedTreatedAsLax',SameSiteNoneInsecure:'SameSiteNoneInsecure',UserPreferences:'UserPreferences',SyntaxError:'SyntaxError',SchemeNotSupported:'SchemeNotSupported',OverwriteSecure:'OverwriteSecure',InvalidDomain:'InvalidDomain',InvalidPrefix:'InvalidPrefix',UnknownError:'UnknownError'});inspectorBackend.registerEnum('Network.CookieBlockedReason',{SecureOnly:'SecureOnly',NotOnPath:'NotOnPath',DomainMismatch:'DomainMismatch',SameSiteStrict:'SameSiteStrict',SameSiteLax:'SameSiteLax',SameSiteUnspecifiedTreatedAsLax:'SameSiteUnspecifiedTreatedAsLax',SameSiteNoneInsecure:'SameSiteNoneInsecure',UserPreferences:'UserPreferences',UnknownError:'UnknownError'});inspectorBackend.registerEnum('Network.AuthChallengeSource',{Server:'Server',Proxy:'Proxy'});inspectorBackend.registerEnum('Network.AuthChallengeResponseResponse',{Default:'Default',CancelAuth:'CancelAuth',ProvideCredentials:'ProvideCredentials'});inspectorBackend.registerEnum('Network.InterceptionStage',{Request:'Request',HeadersReceived:'HeadersReceived'});inspectorBackend.registerEnum('Network.SignedExchangeErrorField',{SignatureSig:'signatureSig',SignatureIntegrity:'signatureIntegrity',SignatureCertUrl:'signatureCertUrl',SignatureCertSha256:'signatureCertSha256',SignatureValidityUrl:'signatureValidityUrl',SignatureTimestamps:'signatureTimestamps'});inspectorBackend.registerEvent('Network.dataReceived',['requestId','timestamp','dataLength','encodedDataLength']);inspectorBackend.registerEvent('Network.eventSourceMessageReceived',['requestId','timestamp','eventName','eventId','data']);inspectorBackend.registerEvent('Network.loadingFailed',['requestId','timestamp','type','errorText','canceled','blockedReason']);inspectorBackend.registerEvent('Network.loadingFinished',['requestId','timestamp','encodedDataLength','shouldReportCorbBlocking']);inspectorBackend.registerEvent('Network.requestIntercepted',['interceptionId','request','frameId','resourceType','isNavigationRequest','isDownload','redirectUrl','authChallenge','responseErrorReason','responseStatusCode','responseHeaders','requestId']);inspectorBackend.registerEvent('Network.requestServedFromCache',['requestId']);inspectorBackend.registerEvent('Network.requestWillBeSent',['requestId','loaderId','documentURL','request','timestamp','wallTime','initiator','redirectResponse','type','frameId','hasUserGesture']);inspectorBackend.registerEvent('Network.resourceChangedPriority',['requestId','newPriority','timestamp']);inspectorBackend.registerEvent('Network.signedExchangeReceived',['requestId','info']);inspectorBackend.registerEvent('Network.responseReceived',['requestId','loaderId','timestamp','type','response','frameId']);inspectorBackend.registerEvent('Network.webSocketClosed',['requestId','timestamp']);inspectorBackend.registerEvent('Network.webSocketCreated',['requestId','url','initiator']);inspectorBackend.registerEvent('Network.webSocketFrameError',['requestId','timestamp','errorMessage']);inspectorBackend.registerEvent('Network.webSocketFrameReceived',['requestId','timestamp','response']);inspectorBackend.registerEvent('Network.webSocketFrameSent',['requestId','timestamp','response']);inspectorBackend.registerEvent('Network.webSocketHandshakeResponseReceived',['requestId','timestamp','response']);inspectorBackend.registerEvent('Network.webSocketWillSendHandshakeRequest',['requestId','timestamp','wallTime','request']);inspectorBackend.registerEvent('Network.requestWillBeSentExtraInfo',['requestId','blockedCookies','headers']);inspectorBackend.registerEvent('Network.responseReceivedExtraInfo',['requestId','blockedCookies','headers','headersText']);inspectorBackend.registerCommand('Network.canClearBrowserCache',[],['result'],false);inspectorBackend.registerCommand('Network.canClearBrowserCookies',[],['result'],false);inspectorBackend.registerCommand('Network.canEmulateNetworkConditions',[],['result'],false);inspectorBackend.registerCommand('Network.clearBrowserCache',[],[],false);inspectorBackend.registerCommand('Network.clearBrowserCookies',[],[],false);inspectorBackend.registerCommand('Network.continueInterceptedRequest',[{'name':'interceptionId','type':'string','optional':false},{'name':'errorReason','type':'string','optional':true},{'name':'rawResponse','type':'string','optional':true},{'name':'url','type':'string','optional':true},{'name':'method','type':'string','optional':true},{'name':'postData','type':'string','optional':true},{'name':'headers','type':'object','optional':true},{'name':'authChallengeResponse','type':'object','optional':true}],[],false);inspectorBackend.registerCommand('Network.deleteCookies',[{'name':'name','type':'string','optional':false},{'name':'url','type':'string','optional':true},{'name':'domain','type':'string','optional':true},{'name':'path','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Network.disable',[],[],false);inspectorBackend.registerCommand('Network.emulateNetworkConditions',[{'name':'offline','type':'boolean','optional':false},{'name':'latency','type':'number','optional':false},{'name':'downloadThroughput','type':'number','optional':false},{'name':'uploadThroughput','type':'number','optional':false},{'name':'connectionType','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Network.enable',[{'name':'maxTotalBufferSize','type':'number','optional':true},{'name':'maxResourceBufferSize','type':'number','optional':true},{'name':'maxPostDataSize','type':'number','optional':true}],[],false);inspectorBackend.registerCommand('Network.getAllCookies',[],['cookies'],false);inspectorBackend.registerCommand('Network.getCertificate',[{'name':'origin','type':'string','optional':false}],['tableNames'],false);inspectorBackend.registerCommand('Network.getCookies',[{'name':'urls','type':'object','optional':true}],['cookies'],false);inspectorBackend.registerCommand('Network.getResponseBody',[{'name':'requestId','type':'string','optional':false}],['body','base64Encoded'],false);inspectorBackend.registerCommand('Network.getRequestPostData',[{'name':'requestId','type':'string','optional':false}],['postData'],false);inspectorBackend.registerCommand('Network.getResponseBodyForInterception',[{'name':'interceptionId','type':'string','optional':false}],['body','base64Encoded'],false);inspectorBackend.registerCommand('Network.takeResponseBodyForInterceptionAsStream',[{'name':'interceptionId','type':'string','optional':false}],['stream'],false);inspectorBackend.registerCommand('Network.replayXHR',[{'name':'requestId','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Network.searchInResponseBody',[{'name':'requestId','type':'string','optional':false},{'name':'query','type':'string','optional':false},{'name':'caseSensitive','type':'boolean','optional':true},{'name':'isRegex','type':'boolean','optional':true}],['result'],false);inspectorBackend.registerCommand('Network.setBlockedURLs',[{'name':'urls','type':'object','optional':false}],[],false);inspectorBackend.registerCommand('Network.setBypassServiceWorker',[{'name':'bypass','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Network.setCacheDisabled',[{'name':'cacheDisabled','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Network.setCookie',[{'name':'name','type':'string','optional':false},{'name':'value','type':'string','optional':false},{'name':'url','type':'string','optional':true},{'name':'domain','type':'string','optional':true},{'name':'path','type':'string','optional':true},{'name':'secure','type':'boolean','optional':true},{'name':'httpOnly','type':'boolean','optional':true},{'name':'sameSite','type':'string','optional':true},{'name':'expires','type':'number','optional':true},{'name':'priority','type':'string','optional':true}],['success'],false);inspectorBackend.registerCommand('Network.setCookies',[{'name':'cookies','type':'object','optional':false}],[],false);inspectorBackend.registerCommand('Network.setDataSizeLimitsForTest',[{'name':'maxTotalSize','type':'number','optional':false},{'name':'maxResourceSize','type':'number','optional':false}],[],false);inspectorBackend.registerCommand('Network.setExtraHTTPHeaders',[{'name':'headers','type':'object','optional':false}],[],false);inspectorBackend.registerCommand('Network.setRequestInterception',[{'name':'patterns','type':'object','optional':false}],[],false);inspectorBackend.registerCommand('Network.setUserAgentOverride',[{'name':'userAgent','type':'string','optional':false},{'name':'acceptLanguage','type':'string','optional':true},{'name':'platform','type':'string','optional':true}],[],false);inspectorBackend.registerEnum('Overlay.InspectMode',{SearchForNode:'searchForNode',SearchForUAShadowDOM:'searchForUAShadowDOM',CaptureAreaScreenshot:'captureAreaScreenshot',ShowDistances:'showDistances',None:'none'});inspectorBackend.registerEvent('Overlay.inspectNodeRequested',['backendNodeId']);inspectorBackend.registerEvent('Overlay.nodeHighlightRequested',['nodeId']);inspectorBackend.registerEvent('Overlay.screenshotRequested',['viewport']);inspectorBackend.registerEvent('Overlay.inspectModeCanceled',[]);inspectorBackend.registerCommand('Overlay.disable',[],[],false);inspectorBackend.registerCommand('Overlay.enable',[],[],false);inspectorBackend.registerCommand('Overlay.getHighlightObjectForTest',[{'name':'nodeId','type':'number','optional':false},{'name':'includeDistance','type':'boolean','optional':true},{'name':'includeStyle','type':'boolean','optional':true}],['highlight'],false);inspectorBackend.registerCommand('Overlay.hideHighlight',[],[],false);inspectorBackend.registerCommand('Overlay.highlightFrame',[{'name':'frameId','type':'string','optional':false},{'name':'contentColor','type':'object','optional':true},{'name':'contentOutlineColor','type':'object','optional':true}],[],false);inspectorBackend.registerCommand('Overlay.highlightNode',[{'name':'highlightConfig','type':'object','optional':false},{'name':'nodeId','type':'number','optional':true},{'name':'backendNodeId','type':'number','optional':true},{'name':'objectId','type':'string','optional':true},{'name':'selector','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Overlay.highlightQuad',[{'name':'quad','type':'object','optional':false},{'name':'color','type':'object','optional':true},{'name':'outlineColor','type':'object','optional':true}],[],false);inspectorBackend.registerCommand('Overlay.highlightRect',[{'name':'x','type':'number','optional':false},{'name':'y','type':'number','optional':false},{'name':'width','type':'number','optional':false},{'name':'height','type':'number','optional':false},{'name':'color','type':'object','optional':true},{'name':'outlineColor','type':'object','optional':true}],[],false);inspectorBackend.registerCommand('Overlay.setInspectMode',[{'name':'mode','type':'string','optional':false},{'name':'highlightConfig','type':'object','optional':true}],[],false);inspectorBackend.registerCommand('Overlay.setShowAdHighlights',[{'name':'show','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Overlay.setPausedInDebuggerMessage',[{'name':'message','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Overlay.setShowDebugBorders',[{'name':'show','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Overlay.setShowFPSCounter',[{'name':'show','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Overlay.setShowPaintRects',[{'name':'result','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Overlay.setShowLayoutShiftRegions',[{'name':'result','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Overlay.setShowScrollBottleneckRects',[{'name':'show','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Overlay.setShowHitTestBorders',[{'name':'show','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Overlay.setShowViewportSizeOnResize',[{'name':'show','type':'boolean','optional':false}],[],false);inspectorBackend.registerEnum('Page.TransitionType',{Link:'link',Typed:'typed',Address_bar:'address_bar',Auto_bookmark:'auto_bookmark',Auto_subframe:'auto_subframe',Manual_subframe:'manual_subframe',Generated:'generated',Auto_toplevel:'auto_toplevel',Form_submit:'form_submit',Reload:'reload',Keyword:'keyword',Keyword_generated:'keyword_generated',Other:'other'});inspectorBackend.registerEnum('Page.DialogType',{Alert:'alert',Confirm:'confirm',Prompt:'prompt',Beforeunload:'beforeunload'});inspectorBackend.registerEnum('Page.ClientNavigationReason',{FormSubmissionGet:'formSubmissionGet',FormSubmissionPost:'formSubmissionPost',HttpHeaderRefresh:'httpHeaderRefresh',ScriptInitiated:'scriptInitiated',MetaTagRefresh:'metaTagRefresh',PageBlockInterstitial:'pageBlockInterstitial',Reload:'reload',AnchorClick:'anchorClick'});inspectorBackend.registerEnum('Page.ReferrerPolicy',{NoReferrer:'noReferrer',NoReferrerWhenDowngrade:'noReferrerWhenDowngrade',Origin:'origin',OriginWhenCrossOrigin:'originWhenCrossOrigin',SameOrigin:'sameOrigin',StrictOrigin:'strictOrigin',StrictOriginWhenCrossOrigin:'strictOriginWhenCrossOrigin',UnsafeUrl:'unsafeUrl'});inspectorBackend.registerEvent('Page.domContentEventFired',['timestamp']);inspectorBackend.registerEvent('Page.fileChooserOpened',['frameId','backendNodeId','mode']);inspectorBackend.registerEvent('Page.frameAttached',['frameId','parentFrameId','stack']);inspectorBackend.registerEvent('Page.frameClearedScheduledNavigation',['frameId']);inspectorBackend.registerEvent('Page.frameDetached',['frameId']);inspectorBackend.registerEvent('Page.frameNavigated',['frame']);inspectorBackend.registerEvent('Page.frameResized',[]);inspectorBackend.registerEvent('Page.frameRequestedNavigation',['frameId','reason','url']);inspectorBackend.registerEvent('Page.frameScheduledNavigation',['frameId','delay','reason','url']);inspectorBackend.registerEvent('Page.frameStartedLoading',['frameId']);inspectorBackend.registerEvent('Page.frameStoppedLoading',['frameId']);inspectorBackend.registerEvent('Page.downloadWillBegin',['frameId','url']);inspectorBackend.registerEvent('Page.interstitialHidden',[]);inspectorBackend.registerEvent('Page.interstitialShown',[]);inspectorBackend.registerEvent('Page.javascriptDialogClosed',['result','userInput']);inspectorBackend.registerEvent('Page.javascriptDialogOpening',['url','message','type','hasBrowserHandler','defaultPrompt']);inspectorBackend.registerEvent('Page.lifecycleEvent',['frameId','loaderId','name','timestamp']);inspectorBackend.registerEvent('Page.loadEventFired',['timestamp']);inspectorBackend.registerEvent('Page.navigatedWithinDocument',['frameId','url']);inspectorBackend.registerEvent('Page.screencastFrame',['data','metadata','sessionId']);inspectorBackend.registerEvent('Page.screencastVisibilityChanged',['visible']);inspectorBackend.registerEvent('Page.windowOpen',['url','windowName','windowFeatures','userGesture']);inspectorBackend.registerEvent('Page.compilationCacheProduced',['url','data']);inspectorBackend.registerCommand('Page.addScriptToEvaluateOnLoad',[{'name':'scriptSource','type':'string','optional':false}],['identifier'],false);inspectorBackend.registerCommand('Page.addScriptToEvaluateOnNewDocument',[{'name':'source','type':'string','optional':false},{'name':'worldName','type':'string','optional':true}],['identifier'],false);inspectorBackend.registerCommand('Page.bringToFront',[],[],false);inspectorBackend.registerCommand('Page.captureScreenshot',[{'name':'format','type':'string','optional':true},{'name':'quality','type':'number','optional':true},{'name':'clip','type':'object','optional':true},{'name':'fromSurface','type':'boolean','optional':true}],['data'],false);inspectorBackend.registerCommand('Page.captureSnapshot',[{'name':'format','type':'string','optional':true}],['data'],false);inspectorBackend.registerCommand('Page.clearDeviceMetricsOverride',[],[],false);inspectorBackend.registerCommand('Page.clearDeviceOrientationOverride',[],[],false);inspectorBackend.registerCommand('Page.clearGeolocationOverride',[],[],false);inspectorBackend.registerCommand('Page.createIsolatedWorld',[{'name':'frameId','type':'string','optional':false},{'name':'worldName','type':'string','optional':true},{'name':'grantUniveralAccess','type':'boolean','optional':true}],['executionContextId'],false);inspectorBackend.registerCommand('Page.deleteCookie',[{'name':'cookieName','type':'string','optional':false},{'name':'url','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Page.disable',[],[],false);inspectorBackend.registerCommand('Page.enable',[],[],false);inspectorBackend.registerCommand('Page.getAppManifest',[],['url','errors','data','parsed'],false);inspectorBackend.registerCommand('Page.getInstallabilityErrors',[],['installabilityErrors'],false);inspectorBackend.registerCommand('Page.getManifestIcons',[],['primaryIcon'],false);inspectorBackend.registerCommand('Page.getCookies',[],['cookies'],false);inspectorBackend.registerCommand('Page.getFrameTree',[],['frameTree'],false);inspectorBackend.registerCommand('Page.getLayoutMetrics',[],['layoutViewport','visualViewport','contentSize'],false);inspectorBackend.registerCommand('Page.getNavigationHistory',[],['currentIndex','entries'],false);inspectorBackend.registerCommand('Page.resetNavigationHistory',[],[],false);inspectorBackend.registerCommand('Page.getResourceContent',[{'name':'frameId','type':'string','optional':false},{'name':'url','type':'string','optional':false}],['content','base64Encoded'],false);inspectorBackend.registerCommand('Page.getResourceTree',[],['frameTree'],false);inspectorBackend.registerCommand('Page.handleJavaScriptDialog',[{'name':'accept','type':'boolean','optional':false},{'name':'promptText','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Page.navigate',[{'name':'url','type':'string','optional':false},{'name':'referrer','type':'string','optional':true},{'name':'transitionType','type':'string','optional':true},{'name':'frameId','type':'string','optional':true},{'name':'referrerPolicy','type':'string','optional':true}],['frameId','loaderId','errorText'],false);inspectorBackend.registerCommand('Page.navigateToHistoryEntry',[{'name':'entryId','type':'number','optional':false}],[],false);inspectorBackend.registerCommand('Page.printToPDF',[{'name':'landscape','type':'boolean','optional':true},{'name':'displayHeaderFooter','type':'boolean','optional':true},{'name':'printBackground','type':'boolean','optional':true},{'name':'scale','type':'number','optional':true},{'name':'paperWidth','type':'number','optional':true},{'name':'paperHeight','type':'number','optional':true},{'name':'marginTop','type':'number','optional':true},{'name':'marginBottom','type':'number','optional':true},{'name':'marginLeft','type':'number','optional':true},{'name':'marginRight','type':'number','optional':true},{'name':'pageRanges','type':'string','optional':true},{'name':'ignoreInvalidPageRanges','type':'boolean','optional':true},{'name':'headerTemplate','type':'string','optional':true},{'name':'footerTemplate','type':'string','optional':true},{'name':'preferCSSPageSize','type':'boolean','optional':true},{'name':'transferMode','type':'string','optional':true}],['data','stream'],false);inspectorBackend.registerCommand('Page.reload',[{'name':'ignoreCache','type':'boolean','optional':true},{'name':'scriptToEvaluateOnLoad','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Page.removeScriptToEvaluateOnLoad',[{'name':'identifier','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Page.removeScriptToEvaluateOnNewDocument',[{'name':'identifier','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Page.screencastFrameAck',[{'name':'sessionId','type':'number','optional':false}],[],false);inspectorBackend.registerCommand('Page.searchInResource',[{'name':'frameId','type':'string','optional':false},{'name':'url','type':'string','optional':false},{'name':'query','type':'string','optional':false},{'name':'caseSensitive','type':'boolean','optional':true},{'name':'isRegex','type':'boolean','optional':true}],['result'],false);inspectorBackend.registerCommand('Page.setAdBlockingEnabled',[{'name':'enabled','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Page.setBypassCSP',[{'name':'enabled','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Page.setDeviceMetricsOverride',[{'name':'width','type':'number','optional':false},{'name':'height','type':'number','optional':false},{'name':'deviceScaleFactor','type':'number','optional':false},{'name':'mobile','type':'boolean','optional':false},{'name':'scale','type':'number','optional':true},{'name':'screenWidth','type':'number','optional':true},{'name':'screenHeight','type':'number','optional':true},{'name':'positionX','type':'number','optional':true},{'name':'positionY','type':'number','optional':true},{'name':'dontSetVisibleSize','type':'boolean','optional':true},{'name':'screenOrientation','type':'object','optional':true},{'name':'viewport','type':'object','optional':true}],[],false);inspectorBackend.registerCommand('Page.setDeviceOrientationOverride',[{'name':'alpha','type':'number','optional':false},{'name':'beta','type':'number','optional':false},{'name':'gamma','type':'number','optional':false}],[],false);inspectorBackend.registerCommand('Page.setFontFamilies',[{'name':'fontFamilies','type':'object','optional':false}],[],false);inspectorBackend.registerCommand('Page.setFontSizes',[{'name':'fontSizes','type':'object','optional':false}],[],false);inspectorBackend.registerCommand('Page.setDocumentContent',[{'name':'frameId','type':'string','optional':false},{'name':'html','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Page.setDownloadBehavior',[{'name':'behavior','type':'string','optional':false},{'name':'downloadPath','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Page.setGeolocationOverride',[{'name':'latitude','type':'number','optional':true},{'name':'longitude','type':'number','optional':true},{'name':'accuracy','type':'number','optional':true}],[],false);inspectorBackend.registerCommand('Page.setLifecycleEventsEnabled',[{'name':'enabled','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Page.setTouchEmulationEnabled',[{'name':'enabled','type':'boolean','optional':false},{'name':'configuration','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Page.startScreencast',[{'name':'format','type':'string','optional':true},{'name':'quality','type':'number','optional':true},{'name':'maxWidth','type':'number','optional':true},{'name':'maxHeight','type':'number','optional':true},{'name':'everyNthFrame','type':'number','optional':true}],[],false);inspectorBackend.registerCommand('Page.stopLoading',[],[],false);inspectorBackend.registerCommand('Page.crash',[],[],false);inspectorBackend.registerCommand('Page.close',[],[],false);inspectorBackend.registerCommand('Page.setWebLifecycleState',[{'name':'state','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Page.stopScreencast',[],[],false);inspectorBackend.registerCommand('Page.setProduceCompilationCache',[{'name':'enabled','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Page.addCompilationCache',[{'name':'url','type':'string','optional':false},{'name':'data','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Page.clearCompilationCache',[],[],false);inspectorBackend.registerCommand('Page.generateTestReport',[{'name':'message','type':'string','optional':false},{'name':'group','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Page.waitForDebugger',[],[],false);inspectorBackend.registerCommand('Page.setInterceptFileChooserDialog',[{'name':'enabled','type':'boolean','optional':false}],[],false);inspectorBackend.registerEvent('Performance.metrics',['metrics','title']);inspectorBackend.registerCommand('Performance.disable',[],[],false);inspectorBackend.registerCommand('Performance.enable',[{'name':'timeDomain','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Performance.setTimeDomain',[{'name':'timeDomain','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Performance.getMetrics',[],['metrics'],false);inspectorBackend.registerEnum('Security.MixedContentType',{Blockable:'blockable',OptionallyBlockable:'optionally-blockable',None:'none'});inspectorBackend.registerEnum('Security.SecurityState',{Unknown:'unknown',Neutral:'neutral',Insecure:'insecure',Secure:'secure',Info:'info',InsecureBroken:'insecure-broken'});inspectorBackend.registerEnum('Security.SafetyTipStatus',{BadReputation:'badReputation',Lookalike:'lookalike'});inspectorBackend.registerEnum('Security.CertificateErrorAction',{Continue:'continue',Cancel:'cancel'});inspectorBackend.registerEvent('Security.certificateError',['eventId','errorType','requestURL']);inspectorBackend.registerEvent('Security.visibleSecurityStateChanged',['visibleSecurityState']);inspectorBackend.registerEvent('Security.securityStateChanged',['securityState','schemeIsCryptographic','explanations','insecureContentStatus','summary']);inspectorBackend.registerCommand('Security.disable',[],[],false);inspectorBackend.registerCommand('Security.enable',[],[],false);inspectorBackend.registerCommand('Security.setIgnoreCertificateErrors',[{'name':'ignore','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Security.handleCertificateError',[{'name':'eventId','type':'number','optional':false},{'name':'action','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Security.setOverrideCertificateErrors',[{'name':'override','type':'boolean','optional':false}],[],false);inspectorBackend.registerEnum('ServiceWorker.ServiceWorkerVersionRunningStatus',{Stopped:'stopped',Starting:'starting',Running:'running',Stopping:'stopping'});inspectorBackend.registerEnum('ServiceWorker.ServiceWorkerVersionStatus',{New:'new',Installing:'installing',Installed:'installed',Activating:'activating',Activated:'activated',Redundant:'redundant'});inspectorBackend.registerEvent('ServiceWorker.workerErrorReported',['errorMessage']);inspectorBackend.registerEvent('ServiceWorker.workerRegistrationUpdated',['registrations']);inspectorBackend.registerEvent('ServiceWorker.workerVersionUpdated',['versions']);inspectorBackend.registerCommand('ServiceWorker.deliverPushMessage',[{'name':'origin','type':'string','optional':false},{'name':'registrationId','type':'string','optional':false},{'name':'data','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('ServiceWorker.disable',[],[],false);inspectorBackend.registerCommand('ServiceWorker.dispatchSyncEvent',[{'name':'origin','type':'string','optional':false},{'name':'registrationId','type':'string','optional':false},{'name':'tag','type':'string','optional':false},{'name':'lastChance','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('ServiceWorker.dispatchPeriodicSyncEvent',[{'name':'origin','type':'string','optional':false},{'name':'registrationId','type':'string','optional':false},{'name':'tag','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('ServiceWorker.enable',[],[],false);inspectorBackend.registerCommand('ServiceWorker.inspectWorker',[{'name':'versionId','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('ServiceWorker.setForceUpdateOnPageLoad',[{'name':'forceUpdateOnPageLoad','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('ServiceWorker.skipWaiting',[{'name':'scopeURL','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('ServiceWorker.startWorker',[{'name':'scopeURL','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('ServiceWorker.stopAllWorkers',[],[],false);inspectorBackend.registerCommand('ServiceWorker.stopWorker',[{'name':'versionId','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('ServiceWorker.unregister',[{'name':'scopeURL','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('ServiceWorker.updateRegistration',[{'name':'scopeURL','type':'string','optional':false}],[],false);inspectorBackend.registerEnum('Storage.StorageType',{Appcache:'appcache',Cookies:'cookies',File_systems:'file_systems',Indexeddb:'indexeddb',Local_storage:'local_storage',Shader_cache:'shader_cache',Websql:'websql',Service_workers:'service_workers',Cache_storage:'cache_storage',All:'all',Other:'other'});inspectorBackend.registerEvent('Storage.cacheStorageContentUpdated',['origin','cacheName']);inspectorBackend.registerEvent('Storage.cacheStorageListUpdated',['origin']);inspectorBackend.registerEvent('Storage.indexedDBContentUpdated',['origin','databaseName','objectStoreName']);inspectorBackend.registerEvent('Storage.indexedDBListUpdated',['origin']);inspectorBackend.registerCommand('Storage.clearDataForOrigin',[{'name':'origin','type':'string','optional':false},{'name':'storageTypes','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Storage.getCookies',[{'name':'browserContextId','type':'string','optional':true}],['cookies'],false);inspectorBackend.registerCommand('Storage.setCookies',[{'name':'cookies','type':'object','optional':false},{'name':'browserContextId','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Storage.clearCookies',[{'name':'browserContextId','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Storage.getUsageAndQuota',[{'name':'origin','type':'string','optional':false}],['usage','quota','usageBreakdown'],false);inspectorBackend.registerCommand('Storage.trackCacheStorageForOrigin',[{'name':'origin','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Storage.trackIndexedDBForOrigin',[{'name':'origin','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Storage.untrackCacheStorageForOrigin',[{'name':'origin','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Storage.untrackIndexedDBForOrigin',[{'name':'origin','type':'string','optional':false}],[],false);inspectorBackend.registerEnum('SystemInfo.SubsamplingFormat',{Yuv420:'yuv420',Yuv422:'yuv422',Yuv444:'yuv444'});inspectorBackend.registerEnum('SystemInfo.ImageType',{Jpeg:'jpeg',Webp:'webp',Unknown:'unknown'});inspectorBackend.registerCommand('SystemInfo.getInfo',[],['gpu','modelName','modelVersion','commandLine'],false);inspectorBackend.registerCommand('SystemInfo.getProcessInfo',[],['processInfo'],false);inspectorBackend.registerEvent('Target.attachedToTarget',['sessionId','targetInfo','waitingForDebugger']);inspectorBackend.registerEvent('Target.detachedFromTarget',['sessionId','targetId']);inspectorBackend.registerEvent('Target.receivedMessageFromTarget',['sessionId','message','targetId']);inspectorBackend.registerEvent('Target.targetCreated',['targetInfo']);inspectorBackend.registerEvent('Target.targetDestroyed',['targetId']);inspectorBackend.registerEvent('Target.targetCrashed',['targetId','status','errorCode']);inspectorBackend.registerEvent('Target.targetInfoChanged',['targetInfo']);inspectorBackend.registerCommand('Target.activateTarget',[{'name':'targetId','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Target.attachToTarget',[{'name':'targetId','type':'string','optional':false},{'name':'flatten','type':'boolean','optional':true}],['sessionId'],false);inspectorBackend.registerCommand('Target.attachToBrowserTarget',[],['sessionId'],false);inspectorBackend.registerCommand('Target.closeTarget',[{'name':'targetId','type':'string','optional':false}],['success'],false);inspectorBackend.registerCommand('Target.exposeDevToolsProtocol',[{'name':'targetId','type':'string','optional':false},{'name':'bindingName','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Target.createBrowserContext',[{'name':'disposeOnDetach','type':'boolean','optional':true}],['browserContextId'],false);inspectorBackend.registerCommand('Target.getBrowserContexts',[],['browserContextIds'],false);inspectorBackend.registerCommand('Target.createTarget',[{'name':'url','type':'string','optional':false},{'name':'width','type':'number','optional':true},{'name':'height','type':'number','optional':true},{'name':'browserContextId','type':'string','optional':true},{'name':'enableBeginFrameControl','type':'boolean','optional':true},{'name':'newWindow','type':'boolean','optional':true},{'name':'background','type':'boolean','optional':true}],['targetId'],false);inspectorBackend.registerCommand('Target.detachFromTarget',[{'name':'sessionId','type':'string','optional':true},{'name':'targetId','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Target.disposeBrowserContext',[{'name':'browserContextId','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Target.getTargetInfo',[{'name':'targetId','type':'string','optional':true}],['targetInfo'],false);inspectorBackend.registerCommand('Target.getTargets',[],['targetInfos'],false);inspectorBackend.registerCommand('Target.sendMessageToTarget',[{'name':'message','type':'string','optional':false},{'name':'sessionId','type':'string','optional':true},{'name':'targetId','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Target.setAutoAttach',[{'name':'autoAttach','type':'boolean','optional':false},{'name':'waitForDebuggerOnStart','type':'boolean','optional':false},{'name':'flatten','type':'boolean','optional':true}],[],false);inspectorBackend.registerCommand('Target.setDiscoverTargets',[{'name':'discover','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Target.setRemoteLocations',[{'name':'locations','type':'object','optional':false}],[],false);inspectorBackend.registerEvent('Tethering.accepted',['port','connectionId']);inspectorBackend.registerCommand('Tethering.bind',[{'name':'port','type':'number','optional':false}],[],false);inspectorBackend.registerCommand('Tethering.unbind',[{'name':'port','type':'number','optional':false}],[],false);inspectorBackend.registerEnum('Tracing.TraceConfigRecordMode',{RecordUntilFull:'recordUntilFull',RecordContinuously:'recordContinuously',RecordAsMuchAsPossible:'recordAsMuchAsPossible',EchoToConsole:'echoToConsole'});inspectorBackend.registerEnum('Tracing.StreamFormat',{Json:'json',Proto:'proto'});inspectorBackend.registerEnum('Tracing.StreamCompression',{None:'none',Gzip:'gzip'});inspectorBackend.registerEvent('Tracing.bufferUsage',['percentFull','eventCount','value']);inspectorBackend.registerEvent('Tracing.dataCollected',['value']);inspectorBackend.registerEvent('Tracing.tracingComplete',['dataLossOccurred','stream','traceFormat','streamCompression']);inspectorBackend.registerCommand('Tracing.end',[],[],false);inspectorBackend.registerCommand('Tracing.getCategories',[],['categories'],false);inspectorBackend.registerCommand('Tracing.recordClockSyncMarker',[{'name':'syncId','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Tracing.requestMemoryDump',[{'name':'deterministic','type':'boolean','optional':true}],['dumpGuid','success'],false);inspectorBackend.registerCommand('Tracing.start',[{'name':'categories','type':'string','optional':true},{'name':'options','type':'string','optional':true},{'name':'bufferUsageReportingInterval','type':'number','optional':true},{'name':'transferMode','type':'string','optional':true},{'name':'streamFormat','type':'string','optional':true},{'name':'streamCompression','type':'string','optional':true},{'name':'traceConfig','type':'object','optional':true}],[],false);inspectorBackend.registerEnum('Fetch.RequestStage',{Request:'Request',Response:'Response'});inspectorBackend.registerEnum('Fetch.AuthChallengeSource',{Server:'Server',Proxy:'Proxy'});inspectorBackend.registerEnum('Fetch.AuthChallengeResponseResponse',{Default:'Default',CancelAuth:'CancelAuth',ProvideCredentials:'ProvideCredentials'});inspectorBackend.registerEvent('Fetch.requestPaused',['requestId','request','frameId','resourceType','responseErrorReason','responseStatusCode','responseHeaders','networkId']);inspectorBackend.registerEvent('Fetch.authRequired',['requestId','request','frameId','resourceType','authChallenge']);inspectorBackend.registerCommand('Fetch.disable',[],[],false);inspectorBackend.registerCommand('Fetch.enable',[{'name':'patterns','type':'object','optional':true},{'name':'handleAuthRequests','type':'boolean','optional':true}],[],false);inspectorBackend.registerCommand('Fetch.failRequest',[{'name':'requestId','type':'string','optional':false},{'name':'errorReason','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Fetch.fulfillRequest',[{'name':'requestId','type':'string','optional':false},{'name':'responseCode','type':'number','optional':false},{'name':'responseHeaders','type':'object','optional':true},{'name':'binaryResponseHeaders','type':'string','optional':true},{'name':'body','type':'string','optional':true},{'name':'responsePhrase','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Fetch.continueRequest',[{'name':'requestId','type':'string','optional':false},{'name':'url','type':'string','optional':true},{'name':'method','type':'string','optional':true},{'name':'postData','type':'string','optional':true},{'name':'headers','type':'object','optional':true}],[],false);inspectorBackend.registerCommand('Fetch.continueWithAuth',[{'name':'requestId','type':'string','optional':false},{'name':'authChallengeResponse','type':'object','optional':false}],[],false);inspectorBackend.registerCommand('Fetch.getResponseBody',[{'name':'requestId','type':'string','optional':false}],['body','base64Encoded'],false);inspectorBackend.registerCommand('Fetch.takeResponseBodyAsStream',[{'name':'requestId','type':'string','optional':false}],['stream'],false);inspectorBackend.registerEnum('WebAudio.ContextType',{Realtime:'realtime',Offline:'offline'});inspectorBackend.registerEnum('WebAudio.ContextState',{Suspended:'suspended',Running:'running',Closed:'closed'});inspectorBackend.registerEnum('WebAudio.ChannelCountMode',{ClampedMax:'clamped-max',Explicit:'explicit',Max:'max'});inspectorBackend.registerEnum('WebAudio.ChannelInterpretation',{Discrete:'discrete',Speakers:'speakers'});inspectorBackend.registerEnum('WebAudio.AutomationRate',{ARate:'a-rate',KRate:'k-rate'});inspectorBackend.registerEvent('WebAudio.contextCreated',['context']);inspectorBackend.registerEvent('WebAudio.contextWillBeDestroyed',['contextId']);inspectorBackend.registerEvent('WebAudio.contextChanged',['context']);inspectorBackend.registerEvent('WebAudio.audioListenerCreated',['listener']);inspectorBackend.registerEvent('WebAudio.audioListenerWillBeDestroyed',['contextId','listenerId']);inspectorBackend.registerEvent('WebAudio.audioNodeCreated',['node']);inspectorBackend.registerEvent('WebAudio.audioNodeWillBeDestroyed',['contextId','nodeId']);inspectorBackend.registerEvent('WebAudio.audioParamCreated',['param']);inspectorBackend.registerEvent('WebAudio.audioParamWillBeDestroyed',['contextId','nodeId','paramId']);inspectorBackend.registerEvent('WebAudio.nodesConnected',['contextId','sourceId','destinationId','sourceOutputIndex','destinationInputIndex']);inspectorBackend.registerEvent('WebAudio.nodesDisconnected',['contextId','sourceId','destinationId','sourceOutputIndex','destinationInputIndex']);inspectorBackend.registerEvent('WebAudio.nodeParamConnected',['contextId','sourceId','destinationId','sourceOutputIndex']);inspectorBackend.registerEvent('WebAudio.nodeParamDisconnected',['contextId','sourceId','destinationId','sourceOutputIndex']);inspectorBackend.registerCommand('WebAudio.enable',[],[],false);inspectorBackend.registerCommand('WebAudio.disable',[],[],false);inspectorBackend.registerCommand('WebAudio.getRealtimeData',[{'name':'contextId','type':'string','optional':false}],['realtimeData'],false);inspectorBackend.registerEnum('WebAuthn.AuthenticatorProtocol',{U2f:'u2f',Ctap2:'ctap2'});inspectorBackend.registerEnum('WebAuthn.AuthenticatorTransport',{Usb:'usb',Nfc:'nfc',Ble:'ble',Cable:'cable',Internal:'internal'});inspectorBackend.registerCommand('WebAuthn.enable',[],[],false);inspectorBackend.registerCommand('WebAuthn.disable',[],[],false);inspectorBackend.registerCommand('WebAuthn.addVirtualAuthenticator',[{'name':'options','type':'object','optional':false}],['authenticatorId'],false);inspectorBackend.registerCommand('WebAuthn.removeVirtualAuthenticator',[{'name':'authenticatorId','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('WebAuthn.addCredential',[{'name':'authenticatorId','type':'string','optional':false},{'name':'credential','type':'object','optional':false}],[],false);inspectorBackend.registerCommand('WebAuthn.getCredential',[{'name':'authenticatorId','type':'string','optional':false},{'name':'credentialId','type':'string','optional':false}],['credential'],false);inspectorBackend.registerCommand('WebAuthn.getCredentials',[{'name':'authenticatorId','type':'string','optional':false}],['credentials'],false);inspectorBackend.registerCommand('WebAuthn.removeCredential',[{'name':'authenticatorId','type':'string','optional':false},{'name':'credentialId','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('WebAuthn.clearCredentials',[{'name':'authenticatorId','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('WebAuthn.setUserVerified',[{'name':'authenticatorId','type':'string','optional':false},{'name':'isUserVerified','type':'boolean','optional':false}],[],false);inspectorBackend.registerEnum('Media.PlayerEventType',{ErrorEvent:'errorEvent',TriggeredEvent:'triggeredEvent',MessageEvent:'messageEvent'});inspectorBackend.registerEvent('Media.playerPropertiesChanged',['playerId','properties']);inspectorBackend.registerEvent('Media.playerEventsAdded',['playerId','events']);inspectorBackend.registerEvent('Media.playersCreated',['players']);inspectorBackend.registerCommand('Media.enable',[],[],false);inspectorBackend.registerCommand('Media.disable',[],[],false);inspectorBackend.registerEnum('Debugger.ScopeType',{Global:'global',Local:'local',With:'with',Closure:'closure',Catch:'catch',Block:'block',Script:'script',Eval:'eval',Module:'module',WasmExpressionStack:'wasm-expression-stack'});inspectorBackend.registerEnum('Debugger.BreakLocationType',{DebuggerStatement:'debuggerStatement',Call:'call',Return:'return'});inspectorBackend.registerEnum('Debugger.ScriptLanguage',{JavaScript:'JavaScript',WebAssembly:'WebAssembly'});inspectorBackend.registerEvent('Debugger.breakpointResolved',['breakpointId','location']);inspectorBackend.registerEvent('Debugger.paused',['callFrames','reason','data','hitBreakpoints','asyncStackTrace','asyncStackTraceId','asyncCallStackTraceId']);inspectorBackend.registerEvent('Debugger.resumed',[]);inspectorBackend.registerEvent('Debugger.scriptFailedToParse',['scriptId','url','startLine','startColumn','endLine','endColumn','executionContextId','hash','executionContextAuxData','sourceMapURL','hasSourceURL','isModule','length','stackTrace','codeOffset','scriptLanguage']);inspectorBackend.registerEvent('Debugger.scriptParsed',['scriptId','url','startLine','startColumn','endLine','endColumn','executionContextId','hash','executionContextAuxData','isLiveEdit','sourceMapURL','hasSourceURL','isModule','length','stackTrace','codeOffset','scriptLanguage']);inspectorBackend.registerCommand('Debugger.continueToLocation',[{'name':'location','type':'object','optional':false},{'name':'targetCallFrames','type':'string','optional':true}],[],false);inspectorBackend.registerCommand('Debugger.disable',[],[],false);inspectorBackend.registerCommand('Debugger.enable',[{'name':'maxScriptsCacheSize','type':'number','optional':true}],['debuggerId'],false);inspectorBackend.registerCommand('Debugger.evaluateOnCallFrame',[{'name':'callFrameId','type':'string','optional':false},{'name':'expression','type':'string','optional':false},{'name':'objectGroup','type':'string','optional':true},{'name':'includeCommandLineAPI','type':'boolean','optional':true},{'name':'silent','type':'boolean','optional':true},{'name':'returnByValue','type':'boolean','optional':true},{'name':'generatePreview','type':'boolean','optional':true},{'name':'throwOnSideEffect','type':'boolean','optional':true},{'name':'timeout','type':'number','optional':true}],['result','exceptionDetails'],false);inspectorBackend.registerCommand('Debugger.getPossibleBreakpoints',[{'name':'start','type':'object','optional':false},{'name':'end','type':'object','optional':true},{'name':'restrictToFunction','type':'boolean','optional':true}],['locations'],false);inspectorBackend.registerCommand('Debugger.getScriptSource',[{'name':'scriptId','type':'string','optional':false}],['scriptSource','bytecode'],false);inspectorBackend.registerCommand('Debugger.getWasmBytecode',[{'name':'scriptId','type':'string','optional':false}],['bytecode'],false);inspectorBackend.registerCommand('Debugger.getStackTrace',[{'name':'stackTraceId','type':'object','optional':false}],['stackTrace'],false);inspectorBackend.registerCommand('Debugger.pause',[],[],false);inspectorBackend.registerCommand('Debugger.pauseOnAsyncCall',[{'name':'parentStackTraceId','type':'object','optional':false}],[],false);inspectorBackend.registerCommand('Debugger.removeBreakpoint',[{'name':'breakpointId','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Debugger.restartFrame',[{'name':'callFrameId','type':'string','optional':false}],['callFrames','asyncStackTrace','asyncStackTraceId'],false);inspectorBackend.registerCommand('Debugger.resume',[{'name':'terminateOnResume','type':'boolean','optional':true}],[],false);inspectorBackend.registerCommand('Debugger.searchInContent',[{'name':'scriptId','type':'string','optional':false},{'name':'query','type':'string','optional':false},{'name':'caseSensitive','type':'boolean','optional':true},{'name':'isRegex','type':'boolean','optional':true}],['result'],false);inspectorBackend.registerCommand('Debugger.setAsyncCallStackDepth',[{'name':'maxDepth','type':'number','optional':false}],[],false);inspectorBackend.registerCommand('Debugger.setBlackboxPatterns',[{'name':'patterns','type':'object','optional':false}],[],false);inspectorBackend.registerCommand('Debugger.setBlackboxedRanges',[{'name':'scriptId','type':'string','optional':false},{'name':'positions','type':'object','optional':false}],[],false);inspectorBackend.registerCommand('Debugger.setBreakpoint',[{'name':'location','type':'object','optional':false},{'name':'condition','type':'string','optional':true}],['breakpointId','actualLocation'],false);inspectorBackend.registerCommand('Debugger.setInstrumentationBreakpoint',[{'name':'instrumentation','type':'string','optional':false}],['breakpointId'],false);inspectorBackend.registerCommand('Debugger.setBreakpointByUrl',[{'name':'lineNumber','type':'number','optional':false},{'name':'url','type':'string','optional':true},{'name':'urlRegex','type':'string','optional':true},{'name':'scriptHash','type':'string','optional':true},{'name':'columnNumber','type':'number','optional':true},{'name':'condition','type':'string','optional':true}],['breakpointId','locations'],false);inspectorBackend.registerCommand('Debugger.setBreakpointOnFunctionCall',[{'name':'objectId','type':'string','optional':false},{'name':'condition','type':'string','optional':true}],['breakpointId'],false);inspectorBackend.registerCommand('Debugger.setBreakpointsActive',[{'name':'active','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Debugger.setPauseOnExceptions',[{'name':'state','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Debugger.setReturnValue',[{'name':'newValue','type':'object','optional':false}],[],false);inspectorBackend.registerCommand('Debugger.setScriptSource',[{'name':'scriptId','type':'string','optional':false},{'name':'scriptSource','type':'string','optional':false},{'name':'dryRun','type':'boolean','optional':true}],['callFrames','stackChanged','asyncStackTrace','asyncStackTraceId','exceptionDetails'],false);inspectorBackend.registerCommand('Debugger.setSkipAllPauses',[{'name':'skip','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Debugger.setVariableValue',[{'name':'scopeNumber','type':'number','optional':false},{'name':'variableName','type':'string','optional':false},{'name':'newValue','type':'object','optional':false},{'name':'callFrameId','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Debugger.stepInto',[{'name':'breakOnAsyncCall','type':'boolean','optional':true}],[],false);inspectorBackend.registerCommand('Debugger.stepOut',[],[],false);inspectorBackend.registerCommand('Debugger.stepOver',[],[],false);inspectorBackend.registerEvent('HeapProfiler.addHeapSnapshotChunk',['chunk']);inspectorBackend.registerEvent('HeapProfiler.heapStatsUpdate',['statsUpdate']);inspectorBackend.registerEvent('HeapProfiler.lastSeenObjectId',['lastSeenObjectId','timestamp']);inspectorBackend.registerEvent('HeapProfiler.reportHeapSnapshotProgress',['done','total','finished']);inspectorBackend.registerEvent('HeapProfiler.resetProfiles',[]);inspectorBackend.registerCommand('HeapProfiler.addInspectedHeapObject',[{'name':'heapObjectId','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('HeapProfiler.collectGarbage',[],[],false);inspectorBackend.registerCommand('HeapProfiler.disable',[],[],false);inspectorBackend.registerCommand('HeapProfiler.enable',[],[],false);inspectorBackend.registerCommand('HeapProfiler.getHeapObjectId',[{'name':'objectId','type':'string','optional':false}],['heapSnapshotObjectId'],false);inspectorBackend.registerCommand('HeapProfiler.getObjectByHeapObjectId',[{'name':'objectId','type':'string','optional':false},{'name':'objectGroup','type':'string','optional':true}],['result'],false);inspectorBackend.registerCommand('HeapProfiler.getSamplingProfile',[],['profile'],false);inspectorBackend.registerCommand('HeapProfiler.startSampling',[{'name':'samplingInterval','type':'number','optional':true}],[],false);inspectorBackend.registerCommand('HeapProfiler.startTrackingHeapObjects',[{'name':'trackAllocations','type':'boolean','optional':true}],[],false);inspectorBackend.registerCommand('HeapProfiler.stopSampling',[],['profile'],false);inspectorBackend.registerCommand('HeapProfiler.stopTrackingHeapObjects',[{'name':'reportProgress','type':'boolean','optional':true},{'name':'treatGlobalObjectsAsRoots','type':'boolean','optional':true}],[],false);inspectorBackend.registerCommand('HeapProfiler.takeHeapSnapshot',[{'name':'reportProgress','type':'boolean','optional':true},{'name':'treatGlobalObjectsAsRoots','type':'boolean','optional':true}],[],false);inspectorBackend.registerEvent('Profiler.consoleProfileFinished',['id','location','profile','title']);inspectorBackend.registerEvent('Profiler.consoleProfileStarted',['id','location','title']);inspectorBackend.registerEvent('Profiler.preciseCoverageDeltaUpdate',['timestamp','occassion','result']);inspectorBackend.registerCommand('Profiler.disable',[],[],false);inspectorBackend.registerCommand('Profiler.enable',[],[],false);inspectorBackend.registerCommand('Profiler.getBestEffortCoverage',[],['result'],false);inspectorBackend.registerCommand('Profiler.setSamplingInterval',[{'name':'interval','type':'number','optional':false}],[],false);inspectorBackend.registerCommand('Profiler.start',[],[],false);inspectorBackend.registerCommand('Profiler.startPreciseCoverage',[{'name':'callCount','type':'boolean','optional':true},{'name':'detailed','type':'boolean','optional':true},{'name':'allowTriggeredUpdates','type':'boolean','optional':true}],['timestamp'],false);inspectorBackend.registerCommand('Profiler.startTypeProfile',[],[],false);inspectorBackend.registerCommand('Profiler.stop',[],['profile'],false);inspectorBackend.registerCommand('Profiler.stopPreciseCoverage',[],[],false);inspectorBackend.registerCommand('Profiler.stopTypeProfile',[],[],false);inspectorBackend.registerCommand('Profiler.takePreciseCoverage',[],['result','timestamp'],false);inspectorBackend.registerCommand('Profiler.takeTypeProfile',[],['result'],false);inspectorBackend.registerCommand('Profiler.enableRuntimeCallStats',[],[],false);inspectorBackend.registerCommand('Profiler.disableRuntimeCallStats',[],[],false);inspectorBackend.registerCommand('Profiler.getRuntimeCallStats',[],['result'],false);inspectorBackend.registerEnum('Runtime.RemoteObjectType',{Object:'object',Function:'function',Undefined:'undefined',String:'string',Number:'number',Boolean:'boolean',Symbol:'symbol',Bigint:'bigint',Wasm:'wasm'});inspectorBackend.registerEnum('Runtime.RemoteObjectSubtype',{Array:'array',Null:'null',Node:'node',Regexp:'regexp',Date:'date',Map:'map',Set:'set',Weakmap:'weakmap',Weakset:'weakset',Iterator:'iterator',Generator:'generator',Error:'error',Proxy:'proxy',Promise:'promise',Typedarray:'typedarray',Arraybuffer:'arraybuffer',Dataview:'dataview',I32:'i32',I64:'i64',F32:'f32',F64:'f64',V128:'v128'});inspectorBackend.registerEnum('Runtime.ObjectPreviewType',{Object:'object',Function:'function',Undefined:'undefined',String:'string',Number:'number',Boolean:'boolean',Symbol:'symbol',Bigint:'bigint'});inspectorBackend.registerEnum('Runtime.ObjectPreviewSubtype',{Array:'array',Null:'null',Node:'node',Regexp:'regexp',Date:'date',Map:'map',Set:'set',Weakmap:'weakmap',Weakset:'weakset',Iterator:'iterator',Generator:'generator',Error:'error'});inspectorBackend.registerEnum('Runtime.PropertyPreviewType',{Object:'object',Function:'function',Undefined:'undefined',String:'string',Number:'number',Boolean:'boolean',Symbol:'symbol',Accessor:'accessor',Bigint:'bigint'});inspectorBackend.registerEnum('Runtime.PropertyPreviewSubtype',{Array:'array',Null:'null',Node:'node',Regexp:'regexp',Date:'date',Map:'map',Set:'set',Weakmap:'weakmap',Weakset:'weakset',Iterator:'iterator',Generator:'generator',Error:'error'});inspectorBackend.registerEvent('Runtime.bindingCalled',['name','payload','executionContextId']);inspectorBackend.registerEvent('Runtime.consoleAPICalled',['type','args','executionContextId','timestamp','stackTrace','context']);inspectorBackend.registerEvent('Runtime.exceptionRevoked',['reason','exceptionId']);inspectorBackend.registerEvent('Runtime.exceptionThrown',['timestamp','exceptionDetails']);inspectorBackend.registerEvent('Runtime.executionContextCreated',['context']);inspectorBackend.registerEvent('Runtime.executionContextDestroyed',['executionContextId']);inspectorBackend.registerEvent('Runtime.executionContextsCleared',[]);inspectorBackend.registerEvent('Runtime.inspectRequested',['object','hints']);inspectorBackend.registerCommand('Runtime.awaitPromise',[{'name':'promiseObjectId','type':'string','optional':false},{'name':'returnByValue','type':'boolean','optional':true},{'name':'generatePreview','type':'boolean','optional':true}],['result','exceptionDetails'],false);inspectorBackend.registerCommand('Runtime.callFunctionOn',[{'name':'functionDeclaration','type':'string','optional':false},{'name':'objectId','type':'string','optional':true},{'name':'arguments','type':'object','optional':true},{'name':'silent','type':'boolean','optional':true},{'name':'returnByValue','type':'boolean','optional':true},{'name':'generatePreview','type':'boolean','optional':true},{'name':'userGesture','type':'boolean','optional':true},{'name':'awaitPromise','type':'boolean','optional':true},{'name':'executionContextId','type':'number','optional':true},{'name':'objectGroup','type':'string','optional':true}],['result','exceptionDetails'],false);inspectorBackend.registerCommand('Runtime.compileScript',[{'name':'expression','type':'string','optional':false},{'name':'sourceURL','type':'string','optional':false},{'name':'persistScript','type':'boolean','optional':false},{'name':'executionContextId','type':'number','optional':true}],['scriptId','exceptionDetails'],false);inspectorBackend.registerCommand('Runtime.disable',[],[],false);inspectorBackend.registerCommand('Runtime.discardConsoleEntries',[],[],false);inspectorBackend.registerCommand('Runtime.enable',[],[],false);inspectorBackend.registerCommand('Runtime.evaluate',[{'name':'expression','type':'string','optional':false},{'name':'objectGroup','type':'string','optional':true},{'name':'includeCommandLineAPI','type':'boolean','optional':true},{'name':'silent','type':'boolean','optional':true},{'name':'contextId','type':'number','optional':true},{'name':'returnByValue','type':'boolean','optional':true},{'name':'generatePreview','type':'boolean','optional':true},{'name':'userGesture','type':'boolean','optional':true},{'name':'awaitPromise','type':'boolean','optional':true},{'name':'throwOnSideEffect','type':'boolean','optional':true},{'name':'timeout','type':'number','optional':true},{'name':'disableBreaks','type':'boolean','optional':true},{'name':'replMode','type':'boolean','optional':true}],['result','exceptionDetails'],false);inspectorBackend.registerCommand('Runtime.getIsolateId',[],['id'],false);inspectorBackend.registerCommand('Runtime.getHeapUsage',[],['usedSize','totalSize'],false);inspectorBackend.registerCommand('Runtime.getProperties',[{'name':'objectId','type':'string','optional':false},{'name':'ownProperties','type':'boolean','optional':true},{'name':'accessorPropertiesOnly','type':'boolean','optional':true},{'name':'generatePreview','type':'boolean','optional':true}],['result','internalProperties','privateProperties','exceptionDetails'],false);inspectorBackend.registerCommand('Runtime.globalLexicalScopeNames',[{'name':'executionContextId','type':'number','optional':true}],['names'],false);inspectorBackend.registerCommand('Runtime.queryObjects',[{'name':'prototypeObjectId','type':'string','optional':false},{'name':'objectGroup','type':'string','optional':true}],['objects'],false);inspectorBackend.registerCommand('Runtime.releaseObject',[{'name':'objectId','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Runtime.releaseObjectGroup',[{'name':'objectGroup','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Runtime.runIfWaitingForDebugger',[],[],false);inspectorBackend.registerCommand('Runtime.runScript',[{'name':'scriptId','type':'string','optional':false},{'name':'executionContextId','type':'number','optional':true},{'name':'objectGroup','type':'string','optional':true},{'name':'silent','type':'boolean','optional':true},{'name':'includeCommandLineAPI','type':'boolean','optional':true},{'name':'returnByValue','type':'boolean','optional':true},{'name':'generatePreview','type':'boolean','optional':true},{'name':'awaitPromise','type':'boolean','optional':true}],['result','exceptionDetails'],false);inspectorBackend.registerCommand('Runtime.setAsyncCallStackDepth',[{'name':'maxDepth','type':'number','optional':false}],[],false);inspectorBackend.registerCommand('Runtime.setCustomObjectFormatterEnabled',[{'name':'enabled','type':'boolean','optional':false}],[],false);inspectorBackend.registerCommand('Runtime.setMaxCallStackSizeToCapture',[{'name':'size','type':'number','optional':false}],[],false);inspectorBackend.registerCommand('Runtime.terminateExecution',[],[],false);inspectorBackend.registerCommand('Runtime.addBinding',[{'name':'name','type':'string','optional':false},{'name':'executionContextId','type':'number','optional':true}],[],false);inspectorBackend.registerCommand('Runtime.removeBinding',[{'name':'name','type':'string','optional':false}],[],false);inspectorBackend.registerCommand('Schema.getDomains',[],['domains'],false);}
class NodeURL{static patch(object){process(object,'');function process(object,path){if(object.url&&NodeURL._isPlatformPath(object.url,Platform.isWin())){object.url=ParsedURL.ParsedURL.platformPathToURL(object.url);}
for(const entry of Object.entries(object)){const key=entry[0];const value=entry[1];const entryPath=path+'.'+key;if(entryPath!=='.result.result.value'&&value!==null&&typeof value==='object'){process((value),entryPath);}}}}
static _isPlatformPath(fileSystemPath,isWindows){if(isWindows){const re=/^([a-z]:[\/\\]|\\\\)/i;return re.test(fileSystemPath);}
return fileSystemPath.length?fileSystemPath[0]==='/':false;}}
var NodeURL$1=Object.freeze({__proto__:null,NodeURL:NodeURL});const ProtocolError=Symbol('Protocol.Error');const DevToolsStubErrorCode=-32015;const _GenericError=-32000;const _ConnectionClosedErrorCode=-32001;class InspectorBackend{constructor(){this._agentPrototypes=new Map();this._dispatcherPrototypes=new Map();this._initialized=false;}
static reportProtocolError(error,messageObject){console.error(error+': '+JSON.stringify(messageObject));}
isInitialized(){return this._initialized;}
_addAgentGetterMethodToProtocolTargetPrototype(domain){let upperCaseLength=0;while(upperCaseLength<domain.length&&domain[upperCaseLength].toLowerCase()!==domain[upperCaseLength]){++upperCaseLength;}
const methodName=domain.substr(0,upperCaseLength).toLowerCase()+domain.slice(upperCaseLength)+'Agent';function agentGetter(){return this._agents[domain];}
TargetBase.prototype[methodName]=agentGetter;function registerDispatcher(dispatcher){this.registerDispatcher(domain,dispatcher);}
TargetBase.prototype['register'+domain+'Dispatcher']=registerDispatcher;}
_agentPrototype(domain){if(!this._agentPrototypes.has(domain)){this._agentPrototypes.set(domain,new _AgentPrototype(domain));this._addAgentGetterMethodToProtocolTargetPrototype(domain);}
return(this._agentPrototypes.get(domain));}
_dispatcherPrototype(domain){if(!this._dispatcherPrototypes.has(domain)){this._dispatcherPrototypes.set(domain,new _DispatcherPrototype());}
return(this._dispatcherPrototypes.get(domain));}
registerCommand(method,signature,replyArgs,hasErrorData){const domainAndMethod=method.split('.');this._agentPrototype(domainAndMethod[0]).registerCommand(domainAndMethod[1],signature,replyArgs,hasErrorData);this._initialized=true;}
registerEnum(type,values){const domainAndName=type.split('.');const domain=domainAndName[0];if(!Protocol[domain]){Protocol[domain]={};}
Protocol[domain][domainAndName[1]]=values;this._initialized=true;}
registerEvent(eventName,params){const domain=eventName.split('.')[0];this._dispatcherPrototype(domain).registerEvent(eventName,params);this._initialized=true;}
wrapClientCallback(clientCallback,errorPrefix,constructor,defaultValue){function callbackWrapper(error,value){if(error){console.error(errorPrefix+error);clientCallback(defaultValue);return;}
if(constructor){clientCallback(new constructor(value));}else{clientCallback(value);}}
return callbackWrapper;}}
let _factory;class Connection{constructor(){this._onMessage;}
setOnMessage(onMessage){}
setOnDisconnect(onDisconnect){}
sendRawMessage(message){}
disconnect(){throw new Error('not implemented');}
static setFactory(factory){_factory=factory;}
static getFactory(){return _factory;}}
let SendRawMessageCallback;const test={dumpProtocol:null,deprecatedRunAfterPendingDispatches:null,sendRawMessage:null,suppressRequestErrors:false,onMessageSent:null,onMessageReceived:null,};class SessionRouter{constructor(connection){this._connection=connection;this._lastMessageId=1;this._pendingResponsesCount=0;this._domainToLogger=new Map();this._sessions=new Map();this._pendingScripts=[];test.deprecatedRunAfterPendingDispatches=this._deprecatedRunAfterPendingDispatches.bind(this);test.sendRawMessage=this._sendRawMessageForTesting.bind(this);this._connection.setOnMessage(this._onMessage.bind(this));this._connection.setOnDisconnect(reason=>{const session=this._sessions.get('');if(session){session.target.dispose(reason);}});}
registerSession(target,sessionId,proxyConnection){if(proxyConnection){for(const session of this._sessions.values()){if(session.proxyConnection){console.error('Multiple simultaneous proxy connections are currently unsupported');break;}}}
this._sessions.set(sessionId,{target,callbacks:new Map(),proxyConnection});}
unregisterSession(sessionId){const session=this._sessions.get(sessionId);if(!session){return;}
for(const callback of session.callbacks.values()){SessionRouter.dispatchConnectionError(callback);}
this._sessions.delete(sessionId);}
_getTargetBySessionId(sessionId){const session=this._sessions.get(sessionId?sessionId:'');if(!session){return null;}
return session.target;}
_nextMessageId(){return this._lastMessageId++;}
connection(){return this._connection;}
sendMessage(sessionId,domain,method,params,callback){const messageObject={};const messageId=this._nextMessageId();messageObject.id=messageId;messageObject.method=method;if(params){messageObject.params=params;}
if(sessionId){messageObject.sessionId=sessionId;}
if(test.dumpProtocol){test.dumpProtocol('frontend: '+JSON.stringify(messageObject));}
if(test.onMessageSent){const paramsObject=JSON.parse(JSON.stringify(params||{}));test.onMessageSent({domain,method,params:(paramsObject),id:messageId},this._getTargetBySessionId(sessionId));}
++this._pendingResponsesCount;const session=this._sessions.get(sessionId);if(!session){return;}
session.callbacks.set(messageId,callback);this._connection.sendRawMessage(JSON.stringify(messageObject));}
_sendRawMessageForTesting(method,params,callback){const domain=method.split('.')[0];this.sendMessage('',domain,method,params,callback||(()=>{}));}
_onMessage(message){if(test.dumpProtocol){test.dumpProtocol('backend: '+((typeof message==='string')?message:JSON.stringify(message)));}
if(test.onMessageReceived){const messageObjectCopy=JSON.parse((typeof message==='string')?message:JSON.stringify(message));test.onMessageReceived((messageObjectCopy),this._getTargetBySessionId(messageObjectCopy.sessionId));}
const messageObject=((typeof message==='string')?JSON.parse(message):message);let suppressUnknownMessageErrors=false;for(const session of this._sessions.values()){if(!session.proxyConnection){continue;}
if(!session.proxyConnection._onMessage){InspectorBackend.reportProtocolError('Protocol Error: the session has a proxyConnection with no _onMessage',messageObject);continue;}
session.proxyConnection._onMessage(messageObject);suppressUnknownMessageErrors=true;}
const sessionId=messageObject.sessionId||'';const session=this._sessions.get(sessionId);if(!session){if(!suppressUnknownMessageErrors){InspectorBackend.reportProtocolError('Protocol Error: the message with wrong session id',messageObject);}
return;}
if(session.proxyConnection){return;}
if(session.target._needsNodeJSPatching){NodeURL.patch(messageObject);}
if('id'in messageObject){const callback=session.callbacks.get(messageObject.id);session.callbacks.delete(messageObject.id);if(!callback){if(!suppressUnknownMessageErrors){InspectorBackend.reportProtocolError('Protocol Error: the message with wrong id',messageObject);}
return;}
callback(messageObject.error,messageObject.result);--this._pendingResponsesCount;if(this._pendingScripts.length&&!this._pendingResponsesCount){this._deprecatedRunAfterPendingDispatches();}}else{if(!('method'in messageObject)){InspectorBackend.reportProtocolError('Protocol Error: the message without method',messageObject);return;}
const method=messageObject.method.split('.');const domainName=method[0];if(!(domainName in session.target._dispatchers)){InspectorBackend.reportProtocolError(`Protocol Error: the message ${messageObject.method} is for non-existing domain '${domainName}'`,messageObject);return;}
session.target._dispatchers[domainName].dispatch(method[1],(messageObject));}}
_deprecatedRunAfterPendingDispatches(script){if(script){this._pendingScripts.push(script);}
setTimeout(()=>{if(!this._pendingResponsesCount){this._executeAfterPendingDispatches();}else{this._deprecatedRunAfterPendingDispatches();}},0);}
_executeAfterPendingDispatches(){if(!this._pendingResponsesCount){const scripts=this._pendingScripts;this._pendingScripts=[];for(let id=0;id<scripts.length;++id){scripts[id]();}}}
static dispatchConnectionError(callback){const error={message:'Connection is closed, can\'t dispatch pending call',code:_ConnectionClosedErrorCode,data:null};setTimeout(()=>callback(error,null),0);}}
class TargetBase{constructor(needsNodeJSPatching,parentTarget,sessionId,connection){this._needsNodeJSPatching=needsNodeJSPatching;this._sessionId=sessionId;if((!parentTarget&&connection)||(!parentTarget&&sessionId)||(connection&&sessionId)){throw new Error('Either connection or sessionId (but not both) must be supplied for a child target');}
let router;if(sessionId&&parentTarget&&parentTarget._router){router=parentTarget._router;}else if(connection){router=new SessionRouter(connection);}else{router=new SessionRouter(_factory());}
this._router=router;router.registerSession(this,this._sessionId);this._agents={};for(const[domain,agentPrototype]of inspectorBackend._agentPrototypes){this._agents[domain]=Object.create((agentPrototype));this._agents[domain]._target=this;}
this._dispatchers={};for(const[domain,dispatcherPrototype]of inspectorBackend._dispatcherPrototypes){this._dispatchers[domain]=Object.create((dispatcherPrototype));this._dispatchers[domain]._dispatchers=[];}}
registerDispatcher(domain,dispatcher){if(!this._dispatchers[domain]){return;}
this._dispatchers[domain].addDomainDispatcher(dispatcher);}
dispose(reason){if(!this._router){return;}
this._router.unregisterSession(this._sessionId);this._router=null;}
isDisposed(){return!this._router;}
markAsNodeJSForTest(){this._needsNodeJSPatching=true;}
router(){return this._router;}}
class _AgentPrototype{constructor(domain){this._replyArgs={};this._hasErrorData={};this._domain=domain;this._target;}
registerCommand(methodName,signature,replyArgs,hasErrorData){const domainAndMethod=this._domain+'.'+methodName;function sendMessagePromise(vararg){const params=Array.prototype.slice.call(arguments);return _AgentPrototype.prototype._sendMessageToBackendPromise.call(this,domainAndMethod,signature,params);}
this[methodName]=sendMessagePromise;function invoke(request){return this._invoke(domainAndMethod,request);}
this['invoke_'+methodName]=invoke;this._replyArgs[domainAndMethod]=replyArgs;if(hasErrorData){this._hasErrorData[domainAndMethod]=true;}}
_prepareParameters(method,signature,args,errorCallback){const params={};let hasParams=false;for(const param of signature){const paramName=param['name'];const typeName=param['type'];const optionalFlag=param['optional'];if(!args.length&&!optionalFlag){errorCallback(`Protocol Error: Invalid number of arguments for method '${method}' call. `+`It must have the following arguments ${JSON.stringify(signature)}'.`);return null;}
const value=args.shift();if(optionalFlag&&typeof value==='undefined'){continue;}
if(typeof value!==typeName){errorCallback(`Protocol Error: Invalid type of argument '${paramName}' for method '${method}' call. `+`It must be '${typeName}' but it is '${typeof value}'.`);return null;}
params[paramName]=value;hasParams=true;}
if(args.length){errorCallback(`Protocol Error: Extra ${args.length} arguments in a call to method '${method}'.`);return null;}
return hasParams?params:null;}
_sendMessageToBackendPromise(method,signature,args){let errorMessage;function onError(message){console.error(message);errorMessage=message;}
const params=this._prepareParameters(method,signature,args,onError);if(errorMessage){return Promise.resolve(null);}
return new Promise((resolve,reject)=>{const callback=(error,result)=>{if(error){if(!test.suppressRequestErrors&&error.code!==DevToolsStubErrorCode&&error.code!==_GenericError&&error.code!==_ConnectionClosedErrorCode){console.error('Request '+method+' failed. '+JSON.stringify(error));reject(error);}else{resolve(null);}
return;}
const args=this._replyArgs[method];resolve(result&&args.length?result[args[0]]:undefined);};if(!this._target._router){SessionRouter.dispatchConnectionError(callback);}else{this._target._router.sendMessage(this._target._sessionId,this._domain,method,params,callback);}});}
_invoke(method,request){return new Promise(fulfill=>{const callback=(error,result)=>{if(error&&!test.suppressRequestErrors&&error.code!==DevToolsStubErrorCode&&error.code!==_GenericError&&error.code!==_ConnectionClosedErrorCode){console.error('Request '+method+' failed. '+JSON.stringify(error));}
if(!result){result={};}
if(error){result[ProtocolError]=error.message;}
fulfill(result);};if(!this._target._router){SessionRouter.dispatchConnectionError(callback);}else{this._target._router.sendMessage(this._target._sessionId,this._domain,method,request,callback);}});}}
class _DispatcherPrototype{constructor(){this._eventArgs={};this._dispatchers;}
registerEvent(eventName,params){this._eventArgs[eventName]=params;}
addDomainDispatcher(dispatcher){this._dispatchers.push(dispatcher);}
dispatch(functionName,messageObject){if(!this._dispatchers.length){return;}
if(!this._eventArgs[messageObject.method]){InspectorBackend.reportProtocolError(`Protocol Error: Attempted to dispatch an unspecified method '${messageObject.method}'`,messageObject);return;}
const params=[];if(messageObject.params){const paramNames=this._eventArgs[messageObject.method];for(let i=0;i<paramNames.length;++i){params.push(messageObject.params[paramNames[i]]);}}
for(let index=0;index<this._dispatchers.length;++index){const dispatcher=this._dispatchers[index];if(functionName in dispatcher){dispatcher[functionName].apply(dispatcher,params);}}}}
let _Callback;const inspectorBackend=new InspectorBackend();var InspectorBackend$1=Object.freeze({__proto__:null,ProtocolError:ProtocolError,DevToolsStubErrorCode:DevToolsStubErrorCode,InspectorBackend:InspectorBackend,Connection:Connection,test:test,SessionRouter:SessionRouter,TargetBase:TargetBase,_Callback:_Callback,inspectorBackend:inspectorBackend});self.Protocol=self.Protocol||{};registerCommands(inspectorBackend);const Protocol$1=self.Protocol;export{InspectorBackend$1 as InspectorBackend,NodeURL$1 as NodeURL,Protocol$1 as Protocol};