self.Runtime.cachedResources["issues/issuesPane.css"]="/*\n * Copyright (c) 2020 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.issue {\n    padding: 0 8px;\n    overflow: hidden;\n    flex: none;\n    transition: background-color 200ms;\n    background: #FFFFFF;\n    border: 1px solid #E5E5E5;\n    border-width: 0 0 1px;\n    --breaking-change-color: #F29900;\n    --issue-gray: #5F6368;\n    --issue-link: #1967D2;\n    --issue-black: #202124;\n}\n\n.header {\n    display: flex;\n    flex-direction: row;\n    align-items: center;\n    padding: 12px 0;\n    cursor: pointer;\n}\n\n.icon {\n    margin-right: 4px;\n}\n\n.title {\n    flex: 1;\n    font-size: 14px;\n    color: var(--issue-black);\n    font-weight: 450;\n}\n\n.issue.collapsed .title {\n    font-weight: normal;\n}\n\n.header::after {\n    transition: transform 200ms;\n    user-select: none;\n    -webkit-mask-image: url(Images/treeoutlineTriangles.svg);\n    -webkit-mask-size: 32px 24px;\n    content: '\\00a0\\00a0';\n    text-shadow: none;\n    margin-right: -2px;\n    height: 12px;\n    width: 13px;\n    background: var(--issue-gray);\n    transform: rotate(90deg);\n    transform-origin: 25% 50%;\n}\n\n.body-wrapper {\n    max-height: 400px;\n    transition: max-height 200ms;\n}\n\n.body {\n    padding: 6px 0;\n    margin-left: 9.5px;\n    border-left: 2px solid var(--breaking-change-color);\n    padding-left: 21px;\n    margin-bottom: 20px;\n}\n\n.message {\n    line-height: 20px;\n    font-size: 14px;\n    color: var(--issue-gray);\n    margin-bottom: 4px;\n}\n\n.message .example {\n    margin-top: 2px;\n    margin-bottom: 2px;\n}\n\n.message .example code {\n    color: var(--issue-black);\n    font-size: 90%;\n    user-select: text;\n    cursor: text;\n}\n\n.message .example .comment::before {\n   content: ' — ';\n}\n\n.kind-code-line {\n    font-size: 12px;\n    color: var(--issue-gray);\n    margin-bottom: 4px;\n    user-select: none;\n}\n\n.separator::before {\n    content: '\\B7';\n    padding-left: 1ex;\n    padding-right: 1ex;\n}\n\n.issue-code {\n    color: rgba(95, 99, 104, 0.5);\n    user-select: text;\n    cursor: text;\n}\n\n.issue-kind {\n    color: var(--breaking-change-color);\n}\n\n.link {\n    font-size: 14px;\n    color: var(--issue-link);\n}\n\n.link-wrapper {\n    margin-top: 8px;\n}\n\n.issue.collapsed {\n    background:  #f3f3f3\n}\n\n.issue.collapsed .header::after {\n    transform: rotate(-90deg);\n}\n\n.issue.collapsed .body-wrapper {\n    max-height: 0;\n}\n\n.issues-toolbar-container {\n    display: flex;\n    flex: none;\n}\n\n.issues-toolbar-container > .toolbar {\n    background-color: var(--toolbar-bg-color);\n    border-bottom: var(--divider-border);\n}\n\n.issues-toolbar-left {\n    flex: 1 1 auto;\n}\n\n.issues-toolbar-right {\n    padding-right: 6px;\n}\n\n.affected-resources-label {\n    font-size: 10px;\n    font-weight: 500;\n    line-height: 2em;\n    letter-spacing: 0.06em;\n    text-transform: uppercase;\n}\n\n.affected-resource {\n    background: #F8F9FA;\n    padding: 12px 3px 12px 20px;\n    position: relative;\n}\n\n.affected-resource-label-wrapper {\n    position: relative;\n    margin-left: -12px;\n    cursor: pointer;\n}\n\n.affected-resource-label-wrapper::before {\n    transition: transform 200ms;\n    user-select: none;\n    -webkit-mask-image: url(Images/treeoutlineTriangles.svg);\n    -webkit-mask-size: 32px 24px;\n    -webkit-mask-position: -1px 1px;\n    content: '\\00a0\\00a0';\n    text-shadow: none;\n    background: var(--issue-gray);\n    transform-origin: center;\n    position: absolute;\n    top: 3px;\n}\n\n.affected-resource-label {\n    font-size: 14px;\n    line-height: 20px;\n    color: var(--issue-black);\n    position: relative;\n    margin-left: 12px;\n}\n\n.affected-resource.expanded .affected-resource-label-wrapper::before {\n    transform: rotate(90deg);\n}\n\n.affected-resource-cookie {\n    font-size: 14px;\n    line-height: 20px;\n    color: var(--issue-link);\n    border: 0;\n    border-collapse: collapse;\n}\n\n.affected-resource-request {\n    font-size: 14px;\n    line-height: 20px;\n    color: var(--issue-link);\n    border: 0;\n    border-collapse: collapse;\n}\n\n.affected-resource-list-wrapper {\n    max-height: 0;\n    overflow: hidden;\n    transition: max-height ease-in-out 200ms;\n}\n\n@media (prefers-reduced-motion: reduce) {\n    .affected-resource-list-wrapper {\n        transition: none;\n    }\n}\n\n.affected-resource.expanded .affected-resource-list-wrapper {\n    max-height: 100vh;\n}\n\n.affected-resource-list {\n    border-spacing: 0;\n}\n\n.affected-resource-header {\n    font-size: 12px;\n    color: rgba(95, 99, 104, 0.5);\n}\n\n.affected-resource-header-info {\n    padding-left: 16px;\n}\n\n.affected-resource-cookie-info {\n    color: #9AA0A6;\n    padding-left: 16px;\n    opacity: 1;\n    transition: opacity 200ms;\n}\n\n.affected-resource-cookie:hover .affected-resource-cookie-info {\n    opacity: 1;\n}\n\n/*# sourceURL=issues/issuesPane.css */";