import*as Common from'../common/common.js';import*as ARIAUtils from'./ARIAUtils.js';import{CheckboxLabel}from'./UIUtils.js';export const createSettingCheckbox=function(name,setting,omitParagraphElement,tooltip){const label=CheckboxLabel.create(name);if(tooltip){label.title=tooltip;}
const input=label.checkboxElement;input.name=name;bindCheckbox(input,setting);if(omitParagraphElement){return label;}
const p=createElement('p');p.appendChild(label);return p;};const createSettingSelect=function(name,options,setting,subtitle){const settingSelectElement=createElement('p');const label=settingSelectElement.createChild('label');const select=settingSelectElement.createChild('select','chrome-select');label.textContent=name;if(subtitle){settingSelectElement.classList.add('chrome-select-label');label.createChild('p').textContent=subtitle;}
ARIAUtils.bindLabelToControl(label,select);for(let i=0;i<options.length;++i){const option=options[i];const optionName=option.raw?option.text:Common.UIString.UIString(option.text);select.add(new Option(optionName,option.value));}
setting.addChangeListener(settingChanged);settingChanged();select.addEventListener('change',selectChanged,false);return settingSelectElement;function settingChanged(){const newValue=setting.get();for(let i=0;i<options.length;i++){if(options[i].value===newValue){select.selectedIndex=i;}}}
function selectChanged(){setting.set(options[select.selectedIndex].value);}};export const bindCheckbox=function(input,setting){function settingChanged(){if(input.checked!==setting.get()){input.checked=setting.get();}}
setting.addChangeListener(settingChanged);settingChanged();function inputChanged(){if(setting.get()!==input.checked){setting.set(input.checked);}}
input.addEventListener('change',inputChanged,false);};export const createCustomSetting=function(name,element){const p=createElement('p');const fieldsetElement=p.createChild('fieldset');const label=fieldsetElement.createChild('label');label.textContent=name;ARIAUtils.bindLabelToControl(label,element);fieldsetElement.appendChild(element);return p;};export const createControlForSetting=function(setting,subtitle){if(!setting.extension()){return null;}
const descriptor=setting.extension().descriptor();const uiTitle=Common.UIString.UIString(setting.title()||'');switch(descriptor['settingType']){case'boolean':return createSettingCheckbox(uiTitle,setting);case'enum':if(Array.isArray(descriptor['options'])){return createSettingSelect(uiTitle,descriptor['options'],setting,subtitle);}
console.error('Enum setting defined without options');return null;default:console.error('Invalid setting type: '+descriptor['settingType']);return null;}};export class SettingUI{settingElement(){}}