Root.Runtime.cachedResources["security/lockIcon.css"]="/* Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.lock-icon,\n.security-property {\n    height: 16px;\n    width: 16px;\n\n    -webkit-mask-image: url(Images/securityIcons.svg);\n    -webkit-mask-size: 80px 32px;\n\n    background-color: #888;\n}\n\n.lock-icon-secure {\n    -webkit-mask-position: 0px 0px;\n    background-color: #0B8043;\n}\n\n.lock-icon-unknown,\n.lock-icon-neutral {\n    -webkit-mask-position: -16px 0px;\n    background-color: #000000; /* Black for clarity on lower DPI screens */\n}\n\n@media (-webkit-min-device-pixel-ratio: 1.1) {\n    .lock-icon-unknown,\n    .lock-icon-neutral {\n        background-color: #5A5A5A; /* Gray for hiDPI screens */\n    }\n}\n\n.lock-icon-insecure {\n    -webkit-mask-position: -32px 0px;\n    background-color: #5A5A5A;\n}\n\n.lock-icon-insecure-broken {\n    -webkit-mask-position: -32px 0px;\n    background-color: #C63626;\n}\n\n.security-property-secure {\n    -webkit-mask-position: 0px -16px;\n    background-color: #0B8043;\n}\n\n.security-property-neutral {\n    -webkit-mask-position: -16px -16px;\n    background-color: #C63626;\n}\n\n.security-property-insecure {\n    -webkit-mask-position: -32px -16px;\n    background-color: #C63626;\n}\n\n.security-property-insecure-broken {\n    -webkit-mask-position: -32px -16px;\n    background-color: #C63626;\n}\n\n.security-property-info {\n    -webkit-mask-position: -48px -16px;\n    background-color: rgba(0, 0, 0, 0.5);\n}\n\n.security-property-unknown {\n    -webkit-mask-position: -64px -16px;\n    background-color: rgba(0, 0, 0, 0.5);\n}\n\n.url-scheme-secure {\n    color: #0b8043;\n}\n\n.url-scheme-neutral,\n.url-scheme-insecure,\n.url-scheme-insecure-broken {\n    color: #cb3626;\n}\n\n.url-scheme-separator {\n    color: #8a8a8a;\n}\n\n@media (forced-colors: active) {\n    .lock-icon,\n    .security-property,\n    .url-scheme-neutral,\n    .url-scheme-insecure,\n    .url-scheme-insecure-broken {\n        forced-color-adjust: none;\n    }\n    .lock-icon-unknown,\n    .lock-icon-neutral {\n        background-color: Highlight;\n    }\n    .tree-outline:not(.hide-selection-when-blurred) li.selected .security-property-info,\n    .tree-outline:not(.hide-selection-when-blurred) li.selected .security-property-unknown {\n        background-color: HighlightText;\n    }\n    .security-property-info,\n    .security-property-unknown {\n        background-color: CanvasText;\n    }\n}\n\n/*# sourceURL=security/lockIcon.css */";Root.Runtime.cachedResources["security/mainView.css"]="/* Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.devtools-link {\n  display: inline-block;\n}\n\n.security-main-view {\n    user-select: text;\n    overflow-x: hidden;\n    overflow-y: auto;\n    background-color: var(--toolbar-bg-color);\n}\n\n.security-main-view > div {\n    flex-shrink: 0;\n}\n\n.security-summary-section-title {\n    font-size: 15px;\n    margin: 12px 16px;\n}\n\n.lock-spectrum {\n    margin: 8px 16px;\n    display: flex;\n    align-items: flex-start;\n}\n\n.security-summary .lock-icon {\n    flex: none;\n    width: 16px;\n    height: 16px;\n    margin: 0 0;\n}\n\n/* Separate the middle icon from the other two. */\n.security-summary .lock-icon-neutral {\n    margin: 0 16px;\n}\n\n.security-summary:not(.security-summary-secure) .lock-icon-secure,\n.security-summary:not(.security-summary-neutral) .lock-icon-neutral,\n.security-summary:not(.security-summary-insecure) .lock-icon-insecure,\n.security-summary:not(.security-summary-insecure-broken) .lock-icon-insecure-broken {\n    background-color: rgba(90, 90, 90, 0.25);\n}\n\n.triangle-pointer-container {\n    margin: 8px 24px 0;\n    padding: 0 0;\n}\n\n.triangle-pointer-wrapper {\n    /* Defaults for dynamic properties. */\n    transform: translateX(0);\n    transition: transform 0.3s;\n}\n\n.triangle-pointer {\n    width: 12px;\n    height: 12px;\n    margin-bottom: -6px;\n    margin-left: -6px;\n    transform: rotate(-45deg);\n    border-style: solid;\n    border-width: 1px 1px 0 0;\n\n    background: #fff;\n    border-color: rgb(217, 217, 217);\n}\n\n.security-summary-secure .triangle-pointer-wrapper {\n    transform: translateX(0px);\n}\n\n.security-summary-neutral .triangle-pointer-wrapper {\n    transform: translateX(32px);\n}\n\n.security-summary-insecure .triangle-pointer-wrapper {\n    transform: translateX(64px);\n}\n\n.security-summary-insecure-broken .triangle-pointer-wrapper {\n    transform: translateX(64px);\n}\n\n.security-summary-text {\n    padding: 16px 24px;\n    border-style: solid;\n    border-width: 1px 0;\n    font-size: 15px;\n\n    background: #fff;\n    border-color: rgb(217, 217, 217);\n}\n\n.security-summary-secure .triangle-pointer,\n.security-summary-secure .security-summary-text,\n.security-explanation-title-secure {\n    color: #0b8043;\n}\n\n.security-summary-insecure-broken .triangle-pointer,\n.security-summary-insecure-broken .security-summary-text,\n.security-explanation-title-neutral,\n.security-explanation-title-insecure,\n.security-explanation-title-insecure-broken {\n    color: #cb3626;\n}\n\n.security-explanation-list {\n    padding-bottom: 16px;\n}\n\n.security-explanation-list:empty {\n    border-bottom: none;\n    padding: 0px;\n}\n\n.security-explanations-main {\n    margin-top: -5px;\n    background-color: #fff;\n    border-bottom: 1px solid rgb(230, 230, 230);\n}\n\n.security-explanations-extra {\n    background-color: transparent;\n}\n\n.security-explanation {\n    padding: 11px;\n    display: flex;\n    white-space: nowrap;\n    border: none;\n    color: rgb(90, 90, 90);\n}\n\n.security-explanation-text {\n    flex: auto;\n    white-space: normal;\n    max-width: 400px;\n}\n\n.security-explanation .security-property {\n    flex: none;\n    width: 16px;\n    height: 16px;\n    margin-right: 16px;\n}\n\n.security-explanation-title {\n    color: rgb(48, 57, 66);\n    margin-top: 1px;\n    margin-bottom: 8px;\n}\n\n.security-mixed-content {\n    margin-top: 8px;\n}\n\n.security-explanation-recommendations {\n    padding-inline-start: 16px;\n}\n\n.security-explanation-recommendations > li {\n    margin-bottom: 4px;\n}\n\n@media (forced-colors: active) {\n    .security-summary:not(.security-summary-secure) .lock-icon-secure,\n    .security-summary:not(.security-summary-neutral) .lock-icon-neutral,\n    .security-summary:not(.security-summary-insecure) .lock-icon-insecure,\n    .security-summary:not(.security-summary-insecure-broken) .lock-icon-insecure-broken {\n        background-color: CanvasText;\n    }\n    .security-summary-neutral .lock-icon-neutral {\n        background-color: Highlight;\n    }\n}\n\n/*# sourceURL=security/mainView.css */";Root.Runtime.cachedResources["security/originView.css"]="/* Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.title-section {\n    padding: 16px 0 24px 0;\n    border-bottom: 1px solid rgb(230, 230, 230);\n}\n\n.title-section-header {\n    padding-left: 16px;\n    padding-bottom: 10px;\n    font-size: 14px;\n}\n\n.security-origin-view {\n    overflow-x: hidden;\n    overflow-y: scroll;\n    display: block;\n    user-select: text;\n}\n\n.security-origin-view .origin-view-section {\n    border-bottom: 1px solid rgb(230, 230, 230);\n    padding: 12px 6px 12px  24px;\n    font-size:12px;\n}\n\n.origin-view-notes {\n    margin-top: 2px;\n    color: #8c8c8c;\n}\n\n.origin-view-section-notes {\n    margin-top: 6px;\n    color: #8c8c8c;\n}\n\n.security-origin-view .origin-display {\n    font-size: 12px;\n    padding-left: 32px;\n    display: flex;\n    align-items: center;\n}\n\n.title-section > .view-network-button {\n    padding: 6px 0 0 16px\n}\n\n.security-origin-view .origin-display .security-property {\n    display: inline-block;\n    vertical-align: middle;\n    position: absolute;\n    left: 13px;\n}\n\n.security-origin-view .origin-view-section-title {\n    margin-top: 4px;\n    margin-bottom: 4px;\n    font-weight: bold;\n}\n\n.security-origin-view .details-table-row {\n    display: flex;\n    white-space: nowrap;\n    overflow: hidden;\n    line-height: 22px;\n}\n\n.security-origin-view .details-table-row > div {\n    align-items: flex-start;\n}\n\n.security-origin-view .details-table-row > div:first-child {\n    color: rgb(140, 140, 140);\n    width: 110px;\n    margin-right: 1em;\n    flex: none;\n    display: flex;\n    justify-content: flex-end;\n}\n.security-origin-view .details-table-row > div:nth-child(2) {\n    flex: auto;\n    white-space: normal;\n}\n\n.security-origin-view .sct-details .details-table .details-table-row:last-child div:last-child {\n    border-bottom: 1px solid rgb(230, 230, 230);\n    padding-bottom: 10px;\n}\n\n.security-origin-view .sct-details .details-table:last-child .details-table-row:last-child div:last-child {\n    border-bottom: none;\n    padding-bottom: 0;\n}\n\n.security-origin-view .details-toggle {\n  margin-left: 126px;\n}\n\n.security-origin-view .sct-toggle {\n    margin-left: 145px;\n    padding-top: 5px;\n}\n\n.security-origin-view .details-table .empty-san {\n    color: rgb(140, 140, 140);\n}\n\n.security-origin-view .details-table .san-entry {\n    display: block;\n}\n\n.security-origin-view .truncated-san .truncated-entry {\n    display: none;\n}\n\n.origin-button {\n    margin-top: 4px;\n    margin-left: 0;\n}\n\n.origin-view-section:last-child  {\n    border-bottom:none;\n}\n\n.devtools-link {\n    display: inline-flex;\n}\n\n/*# sourceURL=security/originView.css */";Root.Runtime.cachedResources["security/sidebar.css"]="/* Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.tree-outline {\n    padding: 0;\n}\n\n.tree-outline li {\n    display: flex;\n    flex-direction: row;\n    align-items: center;\n    padding: 2px 5px;\n    overflow: hidden;\n    margin: 2px 0;\n    border-top: 1px solid transparent;\n    white-space: nowrap;\n}\n\n.tree-outline li.selected:focus .lock-icon,\n.tree-outline .security-sidebar-tree-item.selected:focus .icon\n{\n    background-color: var(--selection-fg-color);\n}\n\n.tree-outline .security-main-view-sidebar-tree-item {\n    border-bottom: 1px solid rgb(230, 230, 230);\n    padding: 16px 0;\n}\n\n.tree-outline li.security-sidebar-origins {\n    padding: 1px 8px 1px 13px;\n    margin-top: 1em;\n    margin-bottom: 0.5em;\n    color: rgb(90, 90, 90);\n    border-top: none;\n    line-height: 16px;\n    text-shadow: rgba(255, 255, 255, 0.75) 0 1px 0;\n}\n\n.tree-outline ol {\n    padding-left: 0;\n}\n\n.tree-outline li::before {\n    content: none;\n}\n\n.tree-outline .security-main-view-sidebar-tree-item,\n.tree-outline .security-sidebar-origins,\n.tree-outline li.security-sidebar-origins + .children > li {\n    padding-left: 16px;\n}\n\n.tree-outline .lock-icon,\n.tree-outline .security-property {\n    margin-right: 4px;\n    flex: none;\n}\n\n.security-sidebar-tree-item {\n    padding: 2px 0;\n}\n\n.security-sidebar-tree-item .title {\n    overflow: hidden;\n    margin-right: 5px;\n}\n\n.security-main-view-reload-message .tree-element-title {\n    color: rgba(0, 0, 0, 0.5);\n    padding-left: 8px;\n}\n\n@media (forced-colors: active) {\n    .tree-outline .lock-icon,\n    .tree-outline .security-property {\n        forced-color-adjust: none;\n    }\n    .tree-outline li.selected:focus .lock-icon,\n    .tree-outline .security-sidebar-tree-item.selected:focus .icon {\n        background-color: HighlightText;\n    }\n}\n\n/*# sourceURL=security/sidebar.css */";