import*as Common from'../common/common.js';import*as SDK from'../sdk/sdk.js';import*as UI from'../ui/ui.js';import{StorageItemsView}from'./StorageItemsView.js';export class CookieItemsView extends StorageItemsView{constructor(model,cookieDomain){super(Common.UIString.UIString('Cookies'),'cookiesPanel');this.registerRequiredCSS('resources/cookieItemsView.css');this.element.classList.add('storage-view');this._model=model;this._cookieDomain=cookieDomain;this._totalSize=0;this._cookiesTable=this._cookiesTable=new CookieTable.CookiesTable(false,this._saveCookie.bind(this),this.refreshItems.bind(this),this._handleCookieSelected.bind(this),this._deleteCookie.bind(this));this._cookiesTable.setMinimumSize(0,50);this._splitWidget=new UI.SplitWidget.SplitWidget(false,true,'cookieItemsSplitViewState');this._splitWidget.show(this.element);this._previewPanel=new UI.Widget.VBox();const resizer=this._previewPanel.element.createChild('div','preview-panel-resizer');this._splitWidget.setMainWidget(this._cookiesTable);this._splitWidget.setSidebarWidget(this._previewPanel);this._splitWidget.installResizer(resizer);this._onlyIssuesFilterUI=new UI.Toolbar.ToolbarCheckbox(ls`Only blocked`,ls`Only show blocked Cookies`,()=>{this._updateWithCookies(this._allCookies);});this.appendToolbarItem(this._onlyIssuesFilterUI);this._refreshThrottler=new Common.Throttler.Throttler(300);this._eventDescriptors=[];this._preview=null;this._previewValue=null;this._allCookies=[];this.setCookiesDomain(model,cookieDomain);}
setCookiesDomain(model,domain){this._model=model;this._cookieDomain=domain;this.refreshItems();Common.EventTarget.EventTarget.removeEventListeners(this._eventDescriptors);const networkManager=model.target().model(SDK.NetworkManager.NetworkManager);this._eventDescriptors=[networkManager.addEventListener(SDK.NetworkManager.Events.ResponseReceived,this._onResponseReceived,this),networkManager.addEventListener(SDK.NetworkManager.Events.LoadingFinished,this._onLoadingFinished,this),];this._showPreview(null,null);}
_showPreview(preview,value){if(this._preview&&this._previewValue===value){return;}
if(this._preview){this._preview.detach();}
if(!preview){preview=new UI.EmptyWidget.EmptyWidget(ls`Select a cookie to preview its value`);}
this._previewValue=value;this._preview=preview;preview.show(this._previewPanel.contentElement);}
_handleCookieSelected(){const cookie=this._cookiesTable.selectedCookie();this.setCanDeleteSelected(!!cookie);if(!cookie){this._showPreview(null,null);return;}
const value=createElementWithClass('div','cookie-value');value.textContent=cookie.value();value.addEventListener('dblclick',handleDblClickOnCookieValue);const preview=new UI.Widget.VBox();preview.contentElement.appendChild(value);this._showPreview(preview,cookie);function handleDblClickOnCookieValue(){const range=document.createRange();range.selectNode(value);window.getSelection().removeAllRanges();window.getSelection().addRange(range);}}
_saveCookie(newCookie,oldCookie){if(!this._model){return Promise.resolve(false);}
if(oldCookie&&newCookie.key()!==oldCookie.key()){this._model.deleteCookie(oldCookie);}
return this._model.saveCookie(newCookie);}
_deleteCookie(cookie,callback){this._model.deleteCookie(cookie,callback);}
_updateWithCookies(allCookies){this._allCookies=allCookies;this._totalSize=allCookies.reduce((size,cookie)=>size+cookie.size(),0);const parsedURL=Common.ParsedURL.ParsedURL.fromString(this._cookieDomain);const host=parsedURL?parsedURL.host:'';this._cookiesTable.setCookieDomain(host);const shownCookies=this.filter(allCookies,cookie=>`${cookie.name()} ${cookie.value()} ${cookie.domain()}`);this._cookiesTable.setCookies(shownCookies,this._model.getCookieToBlockedReasonsMap());this.setCanFilter(true);this.setCanDeleteAll(true);this.setCanDeleteSelected(!!this._cookiesTable.selectedCookie());}
filter(items,keyFunction){return super.filter(items,keyFunction).filter(cookie=>!this._onlyIssuesFilterUI.checked()||SDK.IssuesModel.IssuesModel.hasIssues(cookie));}
deleteAllItems(){this._model.clear(this._cookieDomain,()=>this.refreshItems());}
deleteSelectedItem(){const selectedCookie=this._cookiesTable.selectedCookie();if(selectedCookie){this._model.deleteCookie(selectedCookie,()=>this.refreshItems());}}
refreshItems(){this._model.getCookiesForDomain(this._cookieDomain).then(this._updateWithCookies.bind(this));}
refreshItemsThrottled(){this._refreshThrottler.schedule(()=>Promise.resolve(this.refreshItems()));}
_onResponseReceived(){this.refreshItemsThrottled();}
_onLoadingFinished(){this.refreshItemsThrottled();}}