import*as Common from'../common/common.js';import*as Host from'../host/host.js';import*as UI from'../ui/ui.js';export class NodeConnectionsPanel extends UI.Panel.Panel{constructor(){super('node-connection');this.registerRequiredCSS('node_main/nodeConnectionsPanel.css');this.contentElement.classList.add('node-panel');const container=this.contentElement.createChild('div','node-panel-center');const image=container.createChild('img','node-panel-logo');image.src='https://nodejs.org/static/images/logos/nodejs-new-pantone-black.svg';Host.InspectorFrontendHost.InspectorFrontendHostInstance.events.addEventListener(Host.InspectorFrontendHostAPI.Events.DevicesDiscoveryConfigChanged,this._devicesDiscoveryConfigChanged,this);this._config;this.contentElement.tabIndex=0;this.setDefaultFocusedElement(this.contentElement);Host.InspectorFrontendHost.InspectorFrontendHostInstance.setDevicesUpdatesEnabled(false);Host.InspectorFrontendHost.InspectorFrontendHostInstance.setDevicesUpdatesEnabled(true);this._networkDiscoveryView=new NodeConnectionsView(config=>{this._config.networkDiscoveryConfig=config;Host.InspectorFrontendHost.InspectorFrontendHostInstance.setDevicesDiscoveryConfig(this._config);});this._networkDiscoveryView.show(container);}
_devicesDiscoveryConfigChanged(event){this._config=(event.data);this._networkDiscoveryView.discoveryConfigChanged(this._config.networkDiscoveryConfig);}}
export class NodeConnectionsView extends UI.Widget.VBox{constructor(callback){super();this._callback=callback;this.element.classList.add('network-discovery-view');const networkDiscoveryFooter=this.element.createChild('div','network-discovery-footer');const documentationLink=UI.XLink.XLink.create('https://nodejs.org/en/docs/inspector/',ls`Node.js debugging guide`);networkDiscoveryFooter.appendChild(UI.UIUtils.formatLocalized('Specify network endpoint and DevTools will connect to it automatically. Read %s to learn more.',[documentationLink]));this._list=new UI.ListWidget.ListWidget(this);this._list.registerRequiredCSS('node_main/nodeConnectionsPanel.css');this._list.element.classList.add('network-discovery-list');const placeholder=createElementWithClass('div','network-discovery-list-empty');placeholder.textContent=Common.UIString.UIString('No connections specified');this._list.setEmptyPlaceholder(placeholder);this._list.show(this.element);this._editor=null;const addButton=UI.UIUtils.createTextButton(Common.UIString.UIString('Add connection'),this._addNetworkTargetButtonClicked.bind(this),'add-network-target-button',true);this.element.appendChild(addButton);this._networkDiscoveryConfig=[];this.element.classList.add('node-frontend');}
_update(){const config=this._networkDiscoveryConfig.map(item=>item.address);this._callback.call(null,config);}
_addNetworkTargetButtonClicked(){this._list.addNewItem(this._networkDiscoveryConfig.length,{address:'',port:''});}
discoveryConfigChanged(networkDiscoveryConfig){this._networkDiscoveryConfig=[];this._list.clear();for(const address of networkDiscoveryConfig){const item={address:address,port:''};this._networkDiscoveryConfig.push(item);this._list.appendItem(item,true);}}
renderItem(rule,editable){const element=createElementWithClass('div','network-discovery-list-item');element.createChild('div','network-discovery-value network-discovery-address').textContent=rule.address;return element;}
removeItemRequested(rule,index){this._networkDiscoveryConfig.splice(index,1);this._list.removeItem(index);this._update();}
commitEdit(rule,editor,isNew){rule.address=editor.control('address').value.trim();if(isNew){this._networkDiscoveryConfig.push(rule);}
this._update();}
beginEdit(rule){const editor=this._createEditor();editor.control('address').value=rule.address;return editor;}
_createEditor(){if(this._editor){return this._editor;}
const editor=new UI.ListWidget.Editor();this._editor=editor;const content=editor.contentElement();const fields=content.createChild('div','network-discovery-edit-row');const input=editor.createInput('address','text',ls`Network address (e.g. localhost:9229)`,addressValidator);fields.createChild('div','network-discovery-value network-discovery-address').appendChild(input);return editor;function addressValidator(rule,index,input){const match=input.value.trim().match(/^([a-zA-Z0-9\.\-_]+):(\d+)$/);if(!match){return{valid:false};}
const port=parseInt(match[2],10);return{valid:port<=65535};}}}