import*as UI from'../ui/ui.js';import*as MediaModel from'./MediaModel.js';export let PlayerStatus;export let PlayerStatusMapElement;export class PlayerEntryTreeElement extends UI.TreeOutline.TreeElement{constructor(playerStatus,displayContainer){super(playerStatus.playerTitle,false);this.titleFromUrl=true;this._playerStatus=playerStatus;this._displayContainer=displayContainer;this.setLeadingIcons([UI.Icon.Icon.create('smallicon-videoplayer-playing','media-player')]);}
onselect(selectedByUser){this._displayContainer.renderMainPanel(this._playerStatus.playerID);return true;}}
export class PlayerListView extends UI.Widget.VBox{constructor(mainContainer){super(true);this._playerStatuses=new Map();this._mainContainer=mainContainer;this._sidebarTree=new UI.TreeOutline.TreeOutlineInShadow();this.contentElement.appendChild(this._sidebarTree.element);this._sidebarTree.registerRequiredCSS('media/playerListView.css');this._audioDevices=this._addListSection(Common.UIString('Audio I/O'));this._videoDevices=this._addListSection(Common.UIString('Video Capture Devices'));this._playerList=this._addListSection(Common.UIString('Players'));}
_addListSection(title){const treeElement=new UI.TreeOutline.TreeElement(title,true);treeElement.listItemElement.classList.add('storage-group-list-item');treeElement.setCollapsible(false);treeElement.selectable=false;this._sidebarTree.appendChild(treeElement);return treeElement;}
addMediaElementItem(playerID){const playerStatus={playerTitle:playerID,playerID:playerID,exists:true,playing:false,titleEdited:false};const playerElement=new PlayerEntryTreeElement(playerStatus,this._mainContainer);this._playerStatuses.set(playerID,playerElement);this._playerList.appendChild(playerElement);}
setMediaElementPlayerTitle(playerID,newTitle,isTitleExtractedFromUrl){if(this._playerStatuses.has(playerID)){const sidebarEntry=this._playerStatuses.get(playerID);if(!isTitleExtractedFromUrl||sidebarEntry.titleFromUrl){sidebarEntry.title=newTitle;sidebarEntry.titleFromUrl=isTitleExtractedFromUrl;}}}
setMediaElementPlayerIcon(playerID,iconName){if(this._playerStatuses.has(playerID)){const sidebarEntry=this._playerStatuses.get(playerID);sidebarEntry.setLeadingIcons([UI.Icon.Icon.create('smallicon-videoplayer-'+iconName,'media-player')]);}}
renderChanges(playerID,changes,changeType){if(changeType===MediaModel.MediaChangeTypeKeys.Property){for(const change of changes){if(change.name==='frame_title'&&change.value){this.setMediaElementPlayerTitle(playerID,(change.value),false);}
if(change.name==='frame_url'){const url_path_component=change.value.substring(change.value.lastIndexOf('/')+1);this.setMediaElementPlayerTitle(playerID,url_path_component,true);}}}
if(changeType===MediaModel.MediaChangeTypeKeys.Event){let change_to=null;for(const change of changes){if(change.name==='Event'){if(change.value==='PLAY'){change_to='playing';}else if(change.value==='PAUSE'){change_to='paused';}else if(change.value==='WEBMEDIAPLAYER_DESTROYED'){change_to='destroyed';}}}
if(change_to){this.setMediaElementPlayerIcon(playerID,change_to);}}}}