import*as DataGrid from'../data_grid/data_grid.js';import*as UI from'../ui/ui.js';import*as MediaModel from'./MediaModel.js';export let EventDisplayColumnConfig;export const MediaEventColumnKeys={Timestamp:'displayTimestamp',Event:'event',Value:'value'};export class EventNode extends DataGrid.DataGrid.DataGridNode{constructor(event){super(event,false);this._expandableElement=null;}
createCell(columnId){const cell=this.createTD(columnId);const cellData=(this.data[columnId]);if(columnId===MediaEventColumnKeys.Value){const enclosed=cell.createChild('div','event-display-table-contents-json-wrapper');this._expandableElement=new SourceFrame.JSONView(new SourceFrame.ParsedJSON(cellData,'',''),true);this._expandableElement.markAsRoot();this._expandableElement.show(enclosed);}else{cell.classList.add('event-display-table-basic-text-table-entry');cell.createTextChild(cellData);}
return cell;}}
export class PlayerEventsView extends UI.Widget.VBox{constructor(){super();this.registerRequiredCSS('media/eventDisplayTable.css');this.contentElement.classList.add('event-display-table-contents-table-container');this._dataGrid=this._createDataGrid([{id:MediaEventColumnKeys.Timestamp,title:ls`Timestamp`,weight:1,sortingFunction:DataGrid.SortableDataGrid.SortableDataGrid.NumericComparator.bind(null,MediaEventColumnKeys.Timestamp)},{id:MediaEventColumnKeys.Event,title:ls`Event Name`,weight:2},{id:MediaEventColumnKeys.Value,title:ls`Value`,weight:7}]);this._firstEventTime=0;this._dataGrid.setStriped(true);this._dataGrid.asWidget().show(this.contentElement);}
_createDataGrid(headers){const gridColumnDescs=[];for(const headerDesc of headers){gridColumnDescs.push(PlayerEventsView._convertToGridDescriptor(headerDesc));}
const datagrid=new DataGrid.DataGrid.DataGridImpl({displayName:ls`Event Display`,columns:gridColumnDescs});datagrid.asWidget().contentElement.classList.add('no-border-top-datagrid');return datagrid;}
renderChanges(playerID,changes,change_type){if(this._firstEventTime===0&&changes.length>0){this._firstEventTime=changes[0].timestamp;}
for(const event of changes){this.addEvent(this._subtractFirstEventTime(event));}}
addEvent(event){if(event.type==='triggeredEvent'){const stringified=(event.value);const json=JSON.parse(stringified);event.event=json.event;delete json['event'];event.value=json;const node=new EventNode(event);this._dataGrid.rootNode().appendChild(node);}
if(event.type==='systemEvent'){event.event=event.name;const node=new EventNode(event);this._dataGrid.rootNode().appendChild(node);}}
_subtractFirstEventTime(event){event.displayTimestamp=(event.timestamp-this._firstEventTime).toFixed(3);return event;}
static _convertToGridDescriptor(columnConfig){return({id:columnConfig.id,title:columnConfig.title,sortable:columnConfig.sortable,weight:columnConfig.weight||0,sort:DataGrid.DataGrid.Order.Ascending});}}