import*as Common from'../common/common.js';import*as SDK from'../sdk/sdk.js';export class LighthouseController extends Common.ObjectWrapper.ObjectWrapper{constructor(protocolService){super();protocolService.registerStatusCallback(message=>this.dispatchEventToListeners(Events.AuditProgressChanged,{message}));for(const preset of Presets){preset.setting.addChangeListener(this.recomputePageAuditability.bind(this));}
SDK.SDKModel.TargetManager.instance().observeModels(SDK.ServiceWorkerManager.ServiceWorkerManager,this);SDK.SDKModel.TargetManager.instance().addEventListener(SDK.SDKModel.Events.InspectedURLChanged,this.recomputePageAuditability,this);}
modelAdded(serviceWorkerManager){if(this._manager){return;}
this._manager=serviceWorkerManager;this._serviceWorkerListeners=[this._manager.addEventListener(SDK.ServiceWorkerManager.Events.RegistrationUpdated,this.recomputePageAuditability,this),this._manager.addEventListener(SDK.ServiceWorkerManager.Events.RegistrationDeleted,this.recomputePageAuditability,this),];this.recomputePageAuditability();}
modelRemoved(serviceWorkerManager){if(this._manager!==serviceWorkerManager){return;}
Common.EventTarget.EventTarget.removeEventListeners(this._serviceWorkerListeners);this._manager=null;this.recomputePageAuditability();}
_hasActiveServiceWorker(){if(!this._manager){return false;}
const mainTarget=this._manager.target();if(!mainTarget){return false;}
const inspectedURL=Common.ParsedURL.ParsedURL.fromString(mainTarget.inspectedURL());const inspectedOrigin=inspectedURL&&inspectedURL.securityOrigin();for(const registration of this._manager.registrations().values()){if(registration.securityOrigin!==inspectedOrigin){continue;}
for(const version of registration.versions.values()){if(version.controlledClients.length>1){return true;}}}
return false;}
_hasAtLeastOneCategory(){return Presets.some(preset=>preset.setting.get());}
_unauditablePageMessage(){if(!this._manager){return null;}
const mainTarget=this._manager.target();const inspectedURL=mainTarget&&mainTarget.inspectedURL();if(inspectedURL&&!/^(http|chrome-extension)/.test(inspectedURL)){return Common.UIString.UIString('Can only audit HTTP/HTTPS pages and Chrome extensions. Navigate to a different page to start an audit.');}
return null;}
async _evaluateInspectedURL(){const mainTarget=this._manager.target();const runtimeModel=mainTarget.model(SDK.RuntimeModel.RuntimeModel);const executionContext=runtimeModel&&runtimeModel.defaultExecutionContext();let inspectedURL=mainTarget.inspectedURL();if(!executionContext){return inspectedURL;}
try{const result=await executionContext.evaluate({expression:'window.location.href',objectGroup:'lighthouse',includeCommandLineAPI:false,silent:false,returnByValue:true,generatePreview:false},false,false);if(!result.exceptionDetails&&result.object){inspectedURL=result.object.value;result.object.release();}}catch(err){console.error(err);}
return inspectedURL;}
getFlags(){const flags={internalDisableDeviceScreenEmulation:true};for(const runtimeSetting of RuntimeSettings){runtimeSetting.setFlags(flags,runtimeSetting.setting.get());}
return flags;}
getCategoryIDs(){const categoryIDs=[];for(const preset of Presets){if(preset.setting.get()){categoryIDs.push(preset.configID);}}
return categoryIDs;}
async getInspectedURL(options){if(options&&options.force||!this._inspectedURL){this._inspectedURL=await this._evaluateInspectedURL();}
return this._inspectedURL;}
recomputePageAuditability(){const hasActiveServiceWorker=this._hasActiveServiceWorker();const hasAtLeastOneCategory=this._hasAtLeastOneCategory();const unauditablePageMessage=this._unauditablePageMessage();let helpText='';if(hasActiveServiceWorker){helpText=Common.UIString.UIString('Multiple tabs are being controlled by the same service worker. Close your other tabs on the same origin to audit this page.');}else if(!hasAtLeastOneCategory){helpText=Common.UIString.UIString('At least one category must be selected.');}else if(unauditablePageMessage){helpText=unauditablePageMessage;}
this.dispatchEventToListeners(Events.PageAuditabilityChanged,{helpText});}}
export const Presets=[{setting:self.Common.settings.createSetting('lighthouse.cat_perf',true),configID:'performance',title:ls`Performance`,description:ls`How long does this app take to show content and become usable`},{setting:self.Common.settings.createSetting('lighthouse.cat_pwa',true),configID:'pwa',title:ls`Progressive Web App`,description:ls`Does this page meet the standard of a Progressive Web App`},{setting:self.Common.settings.createSetting('lighthouse.cat_best_practices',true),configID:'best-practices',title:ls`Best practices`,description:ls`Does this page follow best practices for modern web development`},{setting:self.Common.settings.createSetting('lighthouse.cat_a11y',true),configID:'accessibility',title:ls`Accessibility`,description:ls`Is this page usable by people with disabilities or impairments`},{setting:self.Common.settings.createSetting('lighthouse.cat_seo',true),configID:'seo',title:ls`SEO`,description:ls`Is this page optimized for search engine results ranking`},{setting:self.Common.settings.createSetting('lighthouse.cat_pubads',false),plugin:true,configID:'lighthouse-plugin-publisher-ads',title:ls`Publisher Ads`,description:ls`Is this page optimized for ad speed and quality`},];export const RuntimeSettings=[{setting:self.Common.settings.createSetting('lighthouse.device_type','mobile'),description:ls`Apply mobile emulation during auditing`,setFlags:(flags,value)=>{flags.emulatedFormFactor=value;},options:[{label:ls`Mobile`,value:'mobile'},{label:ls`Desktop`,value:'desktop'},],},{setting:self.Common.settings.createSetting('lighthouse.throttling',true),title:ls`Simulated throttling`,learnMore:'https://github.com/GoogleChrome/lighthouse/blob/master/docs/throttling.md#devtools-lighthouse-panel-throttling',setFlags:(flags,value)=>{flags.throttlingMethod=value?'simulate':'devtools';},},{setting:self.Common.settings.createSetting('lighthouse.clear_storage',true),title:ls`Clear storage`,description:ls`Reset storage (localStorage, IndexedDB, etc) before auditing. (Good for performance & PWA testing)`,setFlags:(flags,value)=>{flags.disableStorageReset=!value;},},];export const Events={PageAuditabilityChanged:Symbol('PageAuditabilityChanged'),AuditProgressChanged:Symbol('AuditProgressChanged'),RequestLighthouseStart:Symbol('RequestLighthouseStart'),RequestLighthouseCancel:Symbol('RequestLighthouseCancel'),};