Root.Runtime.cachedResources["issues/issuesPane.css"]="/*\n * Copyright (c) 2020 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.issue {\n    padding: 0 8px;\n    overflow: hidden;\n    flex: none;\n    transition: background-color 200ms;\n    background: #FFFFFF;\n    border: 1px solid #E5E5E5;\n    border-width: 0 0 1px;\n}\n\n.header {\n    display: flex;\n    flex-direction: row;\n    align-items: center;\n    padding: 12px 0;\n    cursor: pointer;\n}\n\n.icon {\n    margin-right: 4px;\n}\n\n.title {\n    flex: 1;\n    font-size: 14px;\n    color: #202124;\n}\n\n.priority {\n    font-size: 12px;\n    color: #C5221F;\n    margin-right: 10px;\n}\n\n.header::after {\n    transition: transform 200ms;\n    user-select: none;\n    -webkit-mask-image: url(Images/treeoutlineTriangles.svg);\n    -webkit-mask-size: 32px 24px;\n    content: \"\\00a0\\00a0\";\n    text-shadow: none;\n    margin-right: -2px;\n    height: 12px;\n    width: 13px;\n    background: #5F6368;\n    transform: rotate(90deg);\n    transform-origin: 25% 50%;\n}\n\n.body-wrapper {\n    max-height: 400px;\n    transition: max-height 200ms;\n}\n\n.body {\n    padding: 6px 0;\n    margin-left: 9.5px;\n    border-left: 2px solid #F29900;\n    padding-left: 21px;\n    margin-bottom: 20px;\n}\n\n.message {\n    max-width: 600px;\n    line-height: 20px;\n    font-size: 14px;\n    color: #5F6368;\n    margin-bottom: 4px;\n}\n\n.code {\n    font-size: 12px;\n    color:rgba(95, 99, 104, 0.5);\n    margin-bottom: 16px;\n    user-select: text;\n}\n\n.link {\n    font-size: 14px;\n    color: #1967D2;\n}\n\n.link-icon {\n\n}\n\n.issue.collapsed {\n    background:  #f3f3f3\n}\n\n.issue.collapsed .header::after {\n    transform: rotate(-90deg);\n}\n\n.issue.collapsed .body-wrapper {\n    max-height: 0;\n}\n\n.issues-toolbar-container {\n    display: flex;\n    flex: none;\n}\n\n.issues-toolbar-container > .toolbar {\n    background-color: var(--toolbar-bg-color);\n    border-bottom: var(--divider-border);\n}\n\n.issues-toolbar-left {\n    flex: 1 1 auto;\n}\n\n.issues-toolbar-right {\n    padding-right: 6px;\n}\n\n/*# sourceURL=issues/issuesPane.css */";