import*as Common from'../common/common.js';import*as Platform from'../platform/platform.js';import{FormatResult,formatterWorkerPool}from'./FormatterWorkerPool.js';export class FormatterInterface{}
FormatterInterface.format=function(contentType,mimeType,content,callback){if(contentType.isDocumentOrScriptOrStyleSheet()){new ScriptFormatter(mimeType,content,callback);}else{new ScriptIdentityFormatter(mimeType,content,callback);}};FormatterInterface.locationToPosition=function(lineEndings,lineNumber,columnNumber){const position=lineNumber?lineEndings[lineNumber-1]+1:0;return position+columnNumber;};FormatterInterface.positionToLocation=function(lineEndings,position){const lineNumber=lineEndings.upperBound(position-1);let columnNumber;if(!lineNumber){columnNumber=position;}else{columnNumber=position-lineEndings[lineNumber-1]-1;}
return[lineNumber,columnNumber];};export class ScriptFormatter{constructor(mimeType,content,callback){content=content.replace(/\r\n?|[\n\u2028\u2029]/g,'\n').replace(/^\uFEFF/,'');this._callback=callback;this._originalContent=content;formatterWorkerPool().format(mimeType,content,self.Common.settings.moduleSetting('textEditorIndent').get()).then(this._didFormatContent.bind(this));}
_didFormatContent(formatResult){const originalContentLineEndings=Platform.StringUtilities.findLineEndingIndexes(this._originalContent);const formattedContentLineEndings=Platform.StringUtilities.findLineEndingIndexes(formatResult.content);const sourceMapping=new FormatterSourceMappingImpl(originalContentLineEndings,formattedContentLineEndings,formatResult.mapping);this._callback(formatResult.content,sourceMapping);}}
class ScriptIdentityFormatter{constructor(mimeType,content,callback){callback(content,new IdentityFormatterSourceMapping());}}
export class FormatterSourceMapping{originalToFormatted(lineNumber,columnNumber){}
formattedToOriginal(lineNumber,columnNumber){}}
class IdentityFormatterSourceMapping{originalToFormatted(lineNumber,columnNumber){return[lineNumber,columnNumber||0];}
formattedToOriginal(lineNumber,columnNumber){return[lineNumber,columnNumber||0];}}
class FormatterSourceMappingImpl{constructor(originalLineEndings,formattedLineEndings,mapping){this._originalLineEndings=originalLineEndings;this._formattedLineEndings=formattedLineEndings;this._mapping=mapping;}
originalToFormatted(lineNumber,columnNumber){const originalPosition=FormatterInterface.locationToPosition(this._originalLineEndings,lineNumber,columnNumber||0);const formattedPosition=this._convertPosition(this._mapping.original,this._mapping.formatted,originalPosition||0);return FormatterInterface.positionToLocation(this._formattedLineEndings,formattedPosition);}
formattedToOriginal(lineNumber,columnNumber){const formattedPosition=FormatterInterface.locationToPosition(this._formattedLineEndings,lineNumber,columnNumber||0);const originalPosition=this._convertPosition(this._mapping.formatted,this._mapping.original,formattedPosition);return FormatterInterface.positionToLocation(this._originalLineEndings,originalPosition||0);}
_convertPosition(positions1,positions2,position){const index=positions1.upperBound(position)-1;let convertedPosition=positions2[index]+position-positions1[index];if(index<positions2.length-1&&convertedPosition>positions2[index+1]){convertedPosition=positions2[index+1];}
return convertedPosition;}}