require=function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a;}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){var n=e[i][1][r];return o(n||r);},p,p.exports,r,e,n,t);}return n[i].exports;}for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o;}return r;}()({"../audits/accessibility/accesskeys":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class Accesskeys extends AxeAudit{static get meta(){return{name:'accesskeys',description:'`[accesskey]` values are unique',failureDescription:'`[accesskey]` values are not unique',helpText:'Access keys let users quickly focus a part of the page. For proper '+'navigation, each access key must be unique. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/accesskeys?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=Accesskeys;},{"./axe-audit":1}],"../audits/accessibility/aria-allowed-attr":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ARIAAllowedAttr extends AxeAudit{static get meta(){return{name:'aria-allowed-attr',description:'`[aria-*]` attributes match their roles',failureDescription:'`[aria-*]` attributes do not match their roles',helpText:'Each ARIA `role` supports a specific subset of `aria-*` attributes. '+'Mismatching these invalidates the `aria-*` attributes. [Learn '+'more](https://dequeuniversity.com/rules/axe/2.2/aria-allowed-attr?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=ARIAAllowedAttr;},{"./axe-audit":1}],"../audits/accessibility/aria-required-attr":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ARIARequiredAttr extends AxeAudit{static get meta(){return{name:'aria-required-attr',description:'`[role]`s have all required `[aria-*]` attributes',failureDescription:'`[role]`s do not have all required `[aria-*]` attributes',helpText:'Some ARIA roles have required attributes that describe the state '+'of the element to screen readers. [Learn more](https://dequeuniversity.com/rules/axe/2.2/aria-required-attr?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=ARIARequiredAttr;},{"./axe-audit":1}],"../audits/accessibility/aria-required-children":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class AriaRequiredChildren extends AxeAudit{static get meta(){return{name:'aria-required-children',description:'Elements with `[role]` that require specific children `[role]`s, are present',failureDescription:'Elements with `[role]` that require specific children `[role]`s, '+'are missing.',helpText:'Some ARIA parent roles must contain specific child roles to perform '+'their intended accessibility functions. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/aria-required-children?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=AriaRequiredChildren;},{"./axe-audit":1}],"../audits/accessibility/aria-required-parent":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class AriaRequiredParent extends AxeAudit{static get meta(){return{name:'aria-required-parent',description:'`[role]`s are contained by their required parent element',failureDescription:'`[role]`s are not contained by their required parent element',helpText:'Some ARIA child roles must be contained by specific parent roles to '+'properly perform their intended accessibility functions. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/aria-required-parent?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=AriaRequiredParent;},{"./axe-audit":1}],"../audits/accessibility/aria-roles":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class AriaRoles extends AxeAudit{static get meta(){return{name:'aria-roles',description:'`[role]` values are valid',failureDescription:'`[role]` values are not valid',helpText:'ARIA roles must have valid values in order to perform their '+'intended accessibility functions. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/aria-roles?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=AriaRoles;},{"./axe-audit":1}],"../audits/accessibility/aria-valid-attr-value":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ARIAValidAttr extends AxeAudit{static get meta(){return{name:'aria-valid-attr-value',description:'`[aria-*]` attributes have valid values',failureDescription:'`[aria-*]` attributes do not have valid values',helpText:'Assistive technologies, like screen readers, can\'t interpret ARIA '+'attributes with invalid values. [Learn '+'more](https://dequeuniversity.com/rules/axe/2.2/aria-valid-attr-value?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=ARIAValidAttr;},{"./axe-audit":1}],"../audits/accessibility/aria-valid-attr":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ARIAValidAttr extends AxeAudit{static get meta(){return{name:'aria-valid-attr',description:'`[aria-*]` attributes are valid and not misspelled',failureDescription:'`[aria-*]` attributes are not valid or misspelled',helpText:'Assistive technologies, like screen readers, can\'t interpret ARIA '+'attributes with invalid names. [Learn '+'more](https://dequeuniversity.com/rules/axe/2.2/aria-valid-attr?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=ARIAValidAttr;},{"./axe-audit":1}],"../audits/accessibility/audio-caption":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class AudioCaption extends AxeAudit{static get meta(){return{name:'audio-caption',description:'`<audio>` elements contain a `<track>` element with `[kind="captions"]`',failureDescription:'`<audio>` elements are missing a `<track>` element with '+'`[kind="captions"]`.',helpText:'Captions make audio elements usable for deaf or hearing-impaired users, '+'providing critical information such as who is talking, what they\'re saying, '+'and other non-speech information. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/audio-caption?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=AudioCaption;},{"./axe-audit":1}],"../audits/accessibility/button-name":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ButtonName extends AxeAudit{static get meta(){return{name:'button-name',description:'Buttons have an accessible name',failureDescription:'Buttons do not have an accessible name',helpText:'When a button doesn\'t have an accessible name, screen readers announce it as '+'"button", making it unusable for users who rely on screen readers. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/button-name?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=ButtonName;},{"./axe-audit":1}],"../audits/accessibility/bypass":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class Bypass extends AxeAudit{static get meta(){return{name:'bypass',description:'The page contains a heading, skip link, or landmark region',failureDescription:'The page does not contain a heading, skip link, or landmark region',helpText:'Adding ways to bypass repetitive content lets keyboard users navigate the page '+'more efficiently. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/bypass?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=Bypass;},{"./axe-audit":1}],"../audits/accessibility/color-contrast":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ColorContrast extends AxeAudit{static get meta(){return{name:'color-contrast',description:'Background and foreground colors have a sufficient contrast ratio',failureDescription:'Background and foreground colors do not have a '+'sufficient contrast ratio.',helpText:'Low-contrast text is difficult or impossible for many users to read. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/color-contrast?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=ColorContrast;},{"./axe-audit":1}],"../audits/accessibility/definition-list":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class DefinitionList extends AxeAudit{static get meta(){return{name:'definition-list',description:'`<dl>`\'s contain only properly-ordered `<dt>` and `<dd>` groups, `<script>` '+'or `<template>` elements.',failureDescription:'`<dl>`\'s do not contain only properly-ordered `<dt>` and `<dd>` '+'groups, `<script>` or `<template>` elements.',helpText:'When definition lists are not properly marked up, screen readers may produce '+'confusing or inaccurate output. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/definition-list?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=DefinitionList;},{"./axe-audit":1}],"../audits/accessibility/dlitem":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class DLItem extends AxeAudit{static get meta(){return{name:'dlitem',description:'Definition list items are wrapped in `<dl>` elements',failureDescription:'Definition list items are not wrapped in `<dl>` elements',helpText:'Definition list items (`<dt>` and `<dd>`) must be wrapped in a '+'parent `<dl>` element to ensure that screen readers can properly announce them. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/dlitem?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=DLItem;},{"./axe-audit":1}],"../audits/accessibility/document-title":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class DocumentTitle extends AxeAudit{static get meta(){return{name:'document-title',description:'Document has a `<title>` element',failureDescription:'Document doesn\'t have a `<title>` element',helpText:'The title gives screen reader users an overview of the page, and search '+'engine users rely on it heavily to determine if a page is relevant to their search. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/title).',requiredArtifacts:['Accessibility']};}}
module.exports=DocumentTitle;},{"./axe-audit":1}],"../audits/accessibility/duplicate-id":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class DuplicateId extends AxeAudit{static get meta(){return{name:'duplicate-id',description:'`[id]` attributes on the page are unique',failureDescription:'`[id]` attributes on the page are not unique',helpText:'The value of an id attribute must be unique to prevent '+'other instances from being overlooked by assistive technologies. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/duplicate-id?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=DuplicateId;},{"./axe-audit":1}],"../audits/accessibility/frame-title":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class FrameTitle extends AxeAudit{static get meta(){return{name:'frame-title',description:'`<frame>` or `<iframe>` elements have a title',failureDescription:'`<frame>` or `<iframe>` elements do not have a title',helpText:'Screen reader users rely on frame titles to describe the contents of frames. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/frame-title?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=FrameTitle;},{"./axe-audit":1}],"../audits/accessibility/html-has-lang":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class HTMLHasLang extends AxeAudit{static get meta(){return{name:'html-has-lang',description:'`<html>` element has a `[lang]` attribute',failureDescription:'`<html>` element does not have a `[lang]` attribute',helpText:'If a page doesn\'t specify a lang attribute, a screen reader assumes '+'that the page is in the default language that the user chose when setting up the '+'screen reader. If the page isn\'t actually in the default language, then the screen '+'reader might not announce the page\'s text correctly. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/html-lang?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=HTMLHasLang;},{"./axe-audit":1}],"../audits/accessibility/html-lang-valid":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class HTMLLangValid extends AxeAudit{static get meta(){return{name:'html-lang-valid',description:'`<html>` element has a valid value for its `[lang]` attribute',failureDescription:'`<html>` element does not have a valid value for '+'its `[lang]` attribute.',helpText:'Specifying a valid [BCP 47 language](https://www.w3.org/International/questions/qa-choosing-language-tags#question) '+'helps screen readers announce text properly. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/valid-lang?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=HTMLLangValid;},{"./axe-audit":1}],"../audits/accessibility/image-alt":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ImageAlt extends AxeAudit{static get meta(){return{name:'image-alt',description:'Image elements have `[alt]` attributes',failureDescription:'Image elements do not have `[alt]` attributes',helpText:'Informative elements should aim for short, descriptive alternate text. '+'Decorative elements can be ignored with an empty alt attribute. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/image-alt?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=ImageAlt;},{"./axe-audit":1}],"../audits/accessibility/input-image-alt":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class InputImageAlt extends AxeAudit{static get meta(){return{name:'input-image-alt',description:'`<input type="image">` elements have `[alt]` text',failureDescription:'`<input type="image">` elements do not have `[alt]` text',helpText:'When an image is being used as an `<input>` button, providing alternative text '+'can help screen reader users understand the purpose of the button. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/input-image-alt?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=InputImageAlt;},{"./axe-audit":1}],"../audits/accessibility/label":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class Label extends AxeAudit{static get meta(){return{name:'label',description:'Form elements have associated labels',failureDescription:'Form elements do not have associated labels',helpText:'Labels ensure that form controls are announced properly by assistive '+'technologies, like screen readers. [Learn '+'more](https://dequeuniversity.com/rules/axe/2.2/label?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=Label;},{"./axe-audit":1}],"../audits/accessibility/layout-table":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class LayoutTable extends AxeAudit{static get meta(){return{name:'layout-table',description:'Presentational `<table>` elements avoid using `<th>`, `<caption>` or the '+'`[summary]` attribute.',failureDescription:'Presentational `<table>` elements do not avoid using `<th>`, '+'`<caption>` or the `[summary]` attribute.',helpText:'A table being used for layout purposes should not include data elements, '+'such as the th or caption elements or the summary attribute, because this can '+'create a confusing experience for screen reader users. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/layout-table?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=LayoutTable;},{"./axe-audit":1}],"../audits/accessibility/link-name":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class LinkName extends AxeAudit{static get meta(){return{name:'link-name',description:'Links have a discernible name',failureDescription:'Links do not have a discernible name',helpText:'Link text (and alternate text for images, when used as links) that is '+'discernible, unique, and focusable improves the navigation experience for '+'screen reader users. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/link-name?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=LinkName;},{"./axe-audit":1}],"../audits/accessibility/listitem":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ListItem extends AxeAudit{static get meta(){return{name:'listitem',description:'List items (`<li>`) are contained within `<ul>` or `<ol>` parent elements',failureDescription:'List items (`<li>`) are not contained within `<ul>` '+'or `<ol>` parent elements.',helpText:'Screen readers require list items (`<li>`) to be contained within a '+'parent `<ul>` or `<ol>` to be announced properly. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/listitem?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=ListItem;},{"./axe-audit":1}],"../audits/accessibility/list":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class List extends AxeAudit{static get meta(){return{name:'list',description:'Lists contain only `<li>` elements and script supporting elements '+'(`<script>` and `<template>`).',failureDescription:'Lists do not contain only `<li>` elements and script '+'supporting elements (`<script>` and `<template>`).',helpText:'Screen readers have a specific way of announcing lists. Ensuring proper list '+'structure aids screen reader output. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/list?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=List;},{"./axe-audit":1}],"../audits/accessibility/manual/custom-controls-labels":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class CustomControlsLabels extends ManualAudit{static get meta(){return Object.assign({name:'custom-controls-labels',helpText:'Custom interactive controls have associated labels, provided by aria-label or aria-labelledby. [Learn more](https://developers.google.com/web/fundamentals/accessibility/how-to-review#try_it_with_a_screen_reader).',description:'Custom controls have associated labels'},super.partialMeta);}}
module.exports=CustomControlsLabels;},{"../../manual/manual-audit":4}],"../audits/accessibility/manual/custom-controls-roles":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class CustomControlsRoles extends ManualAudit{static get meta(){return Object.assign({name:'custom-controls-roles',helpText:'Custom interactive controls have appropriate ARIA roles. [Learn more](https://developers.google.com/web/fundamentals/accessibility/how-to-review#try_it_with_a_screen_reader).',description:'Custom controls have ARIA roles'},super.partialMeta);}}
module.exports=CustomControlsRoles;},{"../../manual/manual-audit":4}],"../audits/accessibility/manual/focus-traps":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class FocusTraps extends ManualAudit{static get meta(){return Object.assign({name:'focus-traps',helpText:'A user can tab into and out of any control or region without accidentally trapping their focus. [Learn more](https://developers.google.com/web/fundamentals/accessibility/how-to-review#start_with_the_keyboard).',description:'User focus is not accidentally trapped in a region'},super.partialMeta);}}
module.exports=FocusTraps;},{"../../manual/manual-audit":4}],"../audits/accessibility/manual/focusable-controls":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class FocusableControls extends ManualAudit{static get meta(){return Object.assign({name:'focusable-controls',helpText:'Custom interactive controls are keyboard focusable and display a focus indicator. [Learn more](https://developers.google.com/web/fundamentals/accessibility/how-to-review#start_with_the_keyboard).',description:'Interactive controls are keyboard focusable'},super.partialMeta);}}
module.exports=FocusableControls;},{"../../manual/manual-audit":4}],"../audits/accessibility/manual/heading-levels":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class HeadingLevels extends ManualAudit{static get meta(){return Object.assign({name:'heading-levels',helpText:'Headings are used to create an outline for the page and heading levels are not skipped. [Learn more](https://developers.google.com/web/fundamentals/accessibility/how-to-review#take_advantage_of_headings_and_landmarks).',description:'Headings don\'t skip levels'},super.partialMeta);}}
module.exports=HeadingLevels;},{"../../manual/manual-audit":4}],"../audits/accessibility/manual/logical-tab-order":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class LogicalTabOrder extends ManualAudit{static get meta(){return Object.assign({name:'logical-tab-order',helpText:'Tabbing through the page follows the visual layout. Users cannot focus elements that are offscreen. [Learn more](https://developers.google.com/web/fundamentals/accessibility/how-to-review#start_with_the_keyboard).',description:'The page has a logical tab order'},super.partialMeta);}}
module.exports=LogicalTabOrder;},{"../../manual/manual-audit":4}],"../audits/accessibility/manual/managed-focus":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class ManagedFocus extends ManualAudit{static get meta(){return Object.assign({name:'managed-focus',helpText:'If new content, such as a dialog, is added to the page, the user\'s focus is directed to it. [Learn more](https://developers.google.com/web/fundamentals/accessibility/how-to-review#start_with_the_keyboard).',description:'The user\'s focus is directed to new content added to the page'},super.partialMeta);}}
module.exports=ManagedFocus;},{"../../manual/manual-audit":4}],"../audits/accessibility/manual/offscreen-content-hidden":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class OffscreenContentHidden extends ManualAudit{static get meta(){return Object.assign({name:'offscreen-content-hidden',helpText:'Offscreen content is hidden with display: none or aria-hidden=true. [Learn more](https://developers.google.com/web/fundamentals/accessibility/how-to-review#try_it_with_a_screen_reader).',description:'Offscreen content is hidden from assistive technology'},super.partialMeta);}}
module.exports=OffscreenContentHidden;},{"../../manual/manual-audit":4}],"../audits/accessibility/manual/use-landmarks":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class UseLandmarks extends ManualAudit{static get meta(){return Object.assign({name:'use-landmarks',helpText:'Landmark elements (<main>, <nav>, etc.) are used to improve the keyboard navigation of the page for assistive technology. [Learn more](https://developers.google.com/web/fundamentals/accessibility/how-to-review#take_advantage_of_headings_and_landmarks).',description:'HTML5 landmark elements are used to improve navigation'},super.partialMeta);}}
module.exports=UseLandmarks;},{"../../manual/manual-audit":4}],"../audits/accessibility/manual/visual-order-follows-dom":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class VisualOrderFollowsDOM extends ManualAudit{static get meta(){return Object.assign({name:'visual-order-follows-dom',helpText:'DOM order matches the visual order, improving navigation for assistive technology. [Learn more](https://developers.google.com/web/fundamentals/accessibility/how-to-review#try_it_with_a_screen_reader).',description:'Visual order on the page follows DOM order'},super.partialMeta);}}
module.exports=VisualOrderFollowsDOM;},{"../../manual/manual-audit":4}],"../audits/accessibility/meta-refresh":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class MetaRefresh extends AxeAudit{static get meta(){return{name:'meta-refresh',description:'The document does not use `<meta http-equiv="refresh">`',failureDescription:'The document uses `<meta http-equiv="refresh">`',helpText:'Users do not expect a page to refresh automatically, and doing so will move '+'focus back to the top of the page. This may create a frustrating or '+'confusing experience. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/meta-refresh?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=MetaRefresh;},{"./axe-audit":1}],"../audits/accessibility/meta-viewport":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class MetaViewport extends AxeAudit{static get meta(){return{name:'meta-viewport',description:'`[user-scalable="no"]` is not used in the `<meta name="viewport">` '+'element and the `[maximum-scale]` attribute is not less than 5.',failureDescription:'`[user-scalable="no"]` is used in the `<meta name="viewport">` '+'element or the `[maximum-scale]` attribute is less than 5.',helpText:'Disabling zooming is problematic for users with low vision who rely on screen '+'magnification to properly see the contents of a web page. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/meta-viewport?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=MetaViewport;},{"./axe-audit":1}],"../audits/accessibility/object-alt":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ObjectAlt extends AxeAudit{static get meta(){return{name:'object-alt',description:'`<object>` elements have `[alt]` text',failureDescription:'`<object>` elements do not have `[alt]` text',helpText:'Screen readers cannot translate non-text content. Adding alt text to `<object>` '+'elements helps screen readers convey meaning to users. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/object-alt?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=ObjectAlt;},{"./axe-audit":1}],"../audits/accessibility/tabindex":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class TabIndex extends AxeAudit{static get meta(){return{name:'tabindex',description:'No element has a `[tabindex]` value greater than 0',failureDescription:'Some elements have a `[tabindex]` value greater than 0',helpText:'A value greater than 0 implies an explicit navigation ordering. '+'Although technically valid, this often creates frustrating experiences '+'for users who rely on assistive technologies. [Learn more](https://dequeuniversity.com/rules/axe/2.2/tabindex?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=TabIndex;},{"./axe-audit":1}],"../audits/accessibility/td-headers-attr":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class TDHeadersAttr extends AxeAudit{static get meta(){return{name:'td-headers-attr',description:'Cells in a `<table>` element that use the `[headers]` attribute only refer '+'to other cells of that same table.',failureDescription:'Cells in a `<table>` element that use the `[headers]` '+'attribute refers to other cells of that same table.',helpText:'Screen readers have features to make navigating tables easier. Ensuring `<td>` '+'cells using the `[headers]` attribute only refer to other cells in the same table may '+'improve the experience for screen reader users. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/td-headers-attr?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=TDHeadersAttr;},{"./axe-audit":1}],"../audits/accessibility/th-has-data-cells":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class THHasDataCells extends AxeAudit{static get meta(){return{name:'th-has-data-cells',description:'`<th>` elements and elements with `[role="columnheader"/"rowheader"]` have '+'data cells they describe.',failureDescription:'`<th>` elements and elements with '+'`[role="columnheader"/"rowheader"]` do not have data cells they describe.',helpText:'Screen readers have features to make navigating tables easier. Ensuring table '+'headers always refer to some set of cells may improve the experience for screen '+'reader users. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/th-has-data-cells?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=THHasDataCells;},{"./axe-audit":1}],"../audits/accessibility/valid-lang":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ValidLang extends AxeAudit{static get meta(){return{name:'valid-lang',description:'`[lang]` attributes have a valid value',failureDescription:'`[lang]` attributes do not have a valid value',helpText:'Specifying a valid [BCP 47 language](https://www.w3.org/International/questions/qa-choosing-language-tags#question) '+'on elements helps ensure that text is pronounced correctly by a screen reader. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/valid-lang?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=ValidLang;},{"./axe-audit":1}],"../audits/accessibility/video-caption":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class VideoCaption extends AxeAudit{static get meta(){return{name:'video-caption',description:'`<video>` elements contain a `<track>` element with `[kind="captions"]`',failureDescription:'`<video>` elements do not contain a `<track>` element '+'with `[kind="captions"]`.',helpText:'When a video provides a caption it is easier for deaf and hearing impaired '+'users to access its information. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/video-caption?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=VideoCaption;},{"./axe-audit":1}],"../audits/accessibility/video-description":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class VideoDescription extends AxeAudit{static get meta(){return{name:'video-description',description:'`<video>` elements contain a `<track>` element with `[kind="description"]`',failureDescription:'`<video>` elements do not contain a `<track>` element with '+'`[kind="description"]`.',helpText:'Audio descriptions provide relevant information for videos that dialogue '+'cannot, such as facial expressions and scenes. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/video-description?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=VideoDescription;},{"./axe-audit":1}],"../audits/bootup-time":[function(require,module,exports){'use strict';const Audit=require('./audit');const WebInspector=require('../lib/web-inspector');const Util=require('../report/html/renderer/util');const{groupIdToName,taskToGroup}=require('../lib/task-groups');class BootupTime extends Audit{static get meta(){return{name:'bootup-time',description:'JavaScript boot-up time',failureDescription:'JavaScript boot-up time is too high',scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,helpText:'Consider reducing the time spent parsing, compiling, and executing JS. '+'You may find delivering smaller JS payloads helps with this. [Learn '+'more](https://developers.google.com/web/tools/lighthouse/audits/bootup).',requiredArtifacts:['traces']};}
static get defaultOptions(){return{scorePODR:600,scoreMedian:3500,thresholdInMs:50};}
static getExecutionTimingsByURL(timelineModel){const bottomUpByURL=timelineModel.bottomUpGroupBy('URL');const result=new Map();bottomUpByURL.children.forEach((perUrlNode,url)=>{if(!url||url==='about:blank'){return;}
const taskGroups={};perUrlNode.children.forEach(perTaskPerUrlNode=>{const task=WebInspector.TimelineUIUtils.eventStyle(perTaskPerUrlNode.event);const groupName=taskToGroup[task.title]||groupIdToName.other;const groupTotal=taskGroups[groupName]||0;taskGroups[groupName]=groupTotal+(perTaskPerUrlNode.selfTime||0);});result.set(url,taskGroups);});return result;}
static async audit(artifacts,context){const settings=context.settings||{};const trace=artifacts.traces[BootupTime.DEFAULT_PASS];const devtoolsTimelineModel=await artifacts.requestDevtoolsTimelineModel(trace);const executionTimings=BootupTime.getExecutionTimingsByURL(devtoolsTimelineModel);let totalBootupTime=0;const extendedInfo={};const headings=[{key:'url',itemType:'url',text:'URL'},{key:'scripting',granularity:1,itemType:'ms',text:groupIdToName.scripting},{key:'scriptParseCompile',granularity:1,itemType:'ms',text:groupIdToName.scriptParseCompile}];const multiplier=settings.throttlingMethod==='simulate'?settings.throttling.cpuSlowdownMultiplier:1;const results=Array.from(executionTimings).map(([url,groups])=>{for(const[name,value]of Object.entries(groups)){groups[name]=value*multiplier;totalBootupTime+=value*multiplier;}
extendedInfo[url]=groups;const scriptingTotal=groups[groupIdToName.scripting]||0;const parseCompileTotal=groups[groupIdToName.scriptParseCompile]||0;return{url:url,sum:scriptingTotal+parseCompileTotal,scripting:scriptingTotal,scriptParseCompile:parseCompileTotal};}).filter(result=>result.sum>=context.options.thresholdInMs).sort((a,b)=>b.sum-a.sum);const summary={wastedMs:totalBootupTime};const details=BootupTime.makeTableDetails(headings,results,summary);const score=Audit.computeLogNormalScore(totalBootupTime,context.options.scorePODR,context.options.scoreMedian);return{score,rawValue:totalBootupTime,displayValue:[Util.MS_DISPLAY_VALUE,totalBootupTime],details,extendedInfo:{value:extendedInfo}};}}
module.exports=BootupTime;},{"../lib/task-groups":42,"../lib/web-inspector":47,"../report/html/renderer/util":48,"./audit":2}],"../audits/byte-efficiency/efficient-animated-content":[function(require,module,exports){'use strict';const WebInspector=require('../../lib/web-inspector');const ByteEfficiencyAudit=require('./byte-efficiency-audit');const GIF_BYTE_THRESHOLD=100*1024;class EfficientAnimatedContent extends ByteEfficiencyAudit{static get meta(){return{name:'efficient-animated-content',scoreDisplayMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,description:'Use video formats for animated content',helpText:'Large GIFs are inefficient for delivering animated content. Consider using '+'MPEG4/WebM videos for animations and PNG/WebP for static images instead of GIF to save '+'network bytes. [Learn more](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/replace-animated-gifs-with-video/)',requiredArtifacts:['devtoolsLogs']};}
static getPercentSavings(bytes){return Math.round(29.1*Math.log10(bytes)-100.7)/100;}
static audit_(artifacts,networkRecords){const unoptimizedContent=networkRecords.filter(record=>record._mimeType==='image/gif'&&record._resourceType===WebInspector.resourceTypes.Image&&(record._resourceSize||0)>GIF_BYTE_THRESHOLD);const results=unoptimizedContent.map(record=>{const resourceSize=record._resourceSize||0;return{url:record.url,totalBytes:resourceSize,wastedBytes:Math.round(resourceSize*EfficientAnimatedContent.getPercentSavings(resourceSize))};});const headings=[{key:'url',itemType:'url',text:'URL'},{key:'totalBytes',itemType:'bytes',displayUnit:'kb',granularity:1,text:'Transfer Size'},{key:'wastedBytes',itemType:'bytes',displayUnit:'kb',granularity:1,text:'Byte Savings'}];return{results,headings};}}
module.exports=EfficientAnimatedContent;},{"../../lib/web-inspector":47,"./byte-efficiency-audit":3}],"../audits/byte-efficiency/offscreen-images":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const Sentry=require('../../lib/sentry');const URL=require('../../lib/url-shim');const ALLOWABLE_OFFSCREEN_X=100;const ALLOWABLE_OFFSCREEN_Y=200;const IGNORE_THRESHOLD_IN_BYTES=2048;const IGNORE_THRESHOLD_IN_PERCENT=75;class OffscreenImages extends ByteEfficiencyAudit{static get meta(){return{name:'offscreen-images',description:'Defer offscreen images',scoreDisplayMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,helpText:'Consider lazy-loading offscreen and hidden images after all critical resources have '+'finished loading to lower time to interactive. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/offscreen-images).',requiredArtifacts:['ImageUsage','ViewportDimensions','traces','devtoolsLogs']};}
static computeVisiblePixels(imageRect,viewportDimensions){const innerWidth=viewportDimensions.innerWidth;const innerHeight=viewportDimensions.innerHeight;const top=Math.max(imageRect.top,-1*ALLOWABLE_OFFSCREEN_Y);const right=Math.min(imageRect.right,innerWidth+ALLOWABLE_OFFSCREEN_X);const bottom=Math.min(imageRect.bottom,innerHeight+ALLOWABLE_OFFSCREEN_Y);const left=Math.max(imageRect.left,-1*ALLOWABLE_OFFSCREEN_X);return Math.max(right-left,0)*Math.max(bottom-top,0);}
static computeWaste(image,viewportDimensions){if(!image.networkRecord){return null;}
const url=URL.elideDataURI(image.src);const totalPixels=image.clientWidth*image.clientHeight;const visiblePixels=this.computeVisiblePixels(image.clientRect,viewportDimensions);const wastedRatio=totalPixels===0?1:1-visiblePixels/totalPixels;const totalBytes=image.networkRecord.resourceSize;const wastedBytes=Math.round(totalBytes*wastedRatio);if(!Number.isFinite(wastedRatio)){return new Error(`Invalid image sizing information ${url}`);}
return{url,requestStartTime:image.networkRecord.startTime,totalBytes,wastedBytes,wastedPercent:100*wastedRatio};}
static computeWasteWithTTIGraph(results,graph,simulator){return ByteEfficiencyAudit.computeWasteWithTTIGraph(results,graph,simulator,{includeLoad:false});}
static audit_(artifacts,networkRecords,context){const images=artifacts.ImageUsage;const viewportDimensions=artifacts.ViewportDimensions;const trace=artifacts.traces[ByteEfficiencyAudit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[ByteEfficiencyAudit.DEFAULT_PASS];const warnings=[];const resultsMap=images.reduce((results,image)=>{const processed=OffscreenImages.computeWaste(image,viewportDimensions);if(processed===null){return results;}
if(processed instanceof Error){warnings.push(processed.message);Sentry.captureException(processed,{tags:{audit:this.meta.name},level:'warning'});return results;}
const existing=results.get(processed.url);if(!existing||existing.wastedBytes>processed.wastedBytes){results.set(processed.url,processed);}
return results;},new Map());const settings=context.settings;return artifacts.requestFirstCPUIdle({trace,devtoolsLog,settings}).then(firstInteractive=>{const ttiTimestamp=firstInteractive.timestamp?firstInteractive.timestamp/1e6:Infinity;const results=Array.from(resultsMap.values()).filter(item=>{const isWasteful=item.wastedBytes>IGNORE_THRESHOLD_IN_BYTES&&item.wastedPercent>IGNORE_THRESHOLD_IN_PERCENT;const loadedEarly=item.requestStartTime<ttiTimestamp;return isWasteful&&loadedEarly;});const headings=[{key:'url',itemType:'thumbnail',text:''},{key:'url',itemType:'url',text:'URL'},{key:'totalBytes',itemType:'bytes',displayUnit:'kb',granularity:1,text:'Original'},{key:'wastedBytes',itemType:'bytes',displayUnit:'kb',granularity:1,text:'Potential Savings'}];return{warnings,results,headings};});}}
module.exports=OffscreenImages;},{"../../lib/sentry":39,"../../lib/url-shim":"url","./byte-efficiency-audit":3}],"../audits/byte-efficiency/render-blocking-resources":[function(require,module,exports){'use strict';const Audit=require('../audit');const Node=require('../../lib/dependency-graph/node');const ByteEfficiencyAudit=require('./byte-efficiency-audit');const UnusedCSS=require('./unused-css-rules');const WebInspector=require('../../lib/web-inspector');const Simulator=require('../../lib/dependency-graph/simulator/simulator');const NetworkNode=require('../../lib/dependency-graph/network-node.js');const MINIMUM_WASTED_MS=50;function getNodesAndTimingByUrl(nodeTimings){const urlMap={};const nodes=Array.from(nodeTimings.keys());nodes.forEach(node=>{if(node.type!=='network')return;const networkNode=node;const nodeTiming=nodeTimings.get(node);if(!nodeTiming)return;urlMap[networkNode.record.url]={node,nodeTiming};});return urlMap;}
class RenderBlockingResources extends Audit{static get meta(){return{name:'render-blocking-resources',description:'Eliminate render-blocking resources',scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,helpText:'Resources are blocking the first paint of your page. Consider '+'delivering critical JS/CSS inline and deferring all non-critical '+'JS/styles. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/blocking-resources).',requiredArtifacts:['URL','TagsBlockingFirstPaint','traces']};}
static async computeResults(artifacts,context){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const simulatorData={devtoolsLog,settings:context.settings};const traceOfTab=await artifacts.requestTraceOfTab(trace);const simulator=await artifacts.requestLoadSimulator(simulatorData);const wastedCssBytes=await RenderBlockingResources.computeWastedCSSBytes(artifacts,context);const metricSettings={throttlingMethod:'simulate'};const metricComputationData={trace,devtoolsLog,simulator,settings:metricSettings};const fcpSimulation=await artifacts.requestFirstContentfulPaint(metricComputationData);const fcpTsInMs=traceOfTab.timestamps.firstContentfulPaint/1000;const nodesByUrl=getNodesAndTimingByUrl(fcpSimulation.optimisticEstimate.nodeTimings);const results=[];const deferredNodeIds=new Set();for(const resource of artifacts.TagsBlockingFirstPaint){if(resource.endTime*1000>fcpTsInMs)continue;if(!nodesByUrl[resource.tag.url])continue;const{node,nodeTiming}=nodesByUrl[resource.tag.url];node.traverse(node=>deferredNodeIds.add(node.id));const wastedMs=Math.round(nodeTiming.endTime-nodeTiming.startTime);if(wastedMs<MINIMUM_WASTED_MS)continue;results.push({url:resource.tag.url,totalBytes:resource.transferSize,wastedMs});}
if(!results.length){return{results,wastedMs:0};}
const wastedMs=RenderBlockingResources.estimateSavingsWithGraphs(simulator,fcpSimulation.optimisticGraph,deferredNodeIds,wastedCssBytes);return{results,wastedMs};}
static estimateSavingsWithGraphs(simulator,fcpGraph,deferredIds,wastedCssBytesByUrl){const originalEstimate=simulator.simulate(fcpGraph).timeInMs;let totalChildNetworkBytes=0;const minimalFCPGraph=fcpGraph.cloneWithRelationships(node=>{const canDeferRequest=deferredIds.has(node.id);if(node.type!==Node.TYPES.NETWORK)return!canDeferRequest;const networkNode=node;const isStylesheet=networkNode.record._resourceType===WebInspector.resourceTypes.Stylesheet;if(canDeferRequest&&isStylesheet){const wastedBytes=wastedCssBytesByUrl.get(networkNode.record.url)||0;totalChildNetworkBytes+=(networkNode.record._transferSize||0)-wastedBytes;}
return!canDeferRequest;});const originalTransferSize=minimalFCPGraph.record._transferSize;const safeTransferSize=originalTransferSize||0;minimalFCPGraph.record._transferSize=safeTransferSize+totalChildNetworkBytes;const estimateAfterInline=simulator.simulate(minimalFCPGraph).timeInMs;minimalFCPGraph.record._transferSize=originalTransferSize;return Math.round(Math.max(originalEstimate-estimateAfterInline,0));}
static async computeWastedCSSBytes(artifacts,context){const wastedBytesByUrl=new Map();try{const results=await UnusedCSS.audit(artifacts,context);for(const item of results.details.items){wastedBytesByUrl.set(item.url,item.wastedBytes);}}catch(_){}
return wastedBytesByUrl;}
static async audit(artifacts,context){const{results,wastedMs}=await RenderBlockingResources.computeResults(artifacts,context);let displayValue='';if(results.length>1){displayValue=`${results.length} resources delayed first paint by ${wastedMs}ms`;}else if(results.length===1){displayValue=`${results.length} resource delayed first paint by ${wastedMs}ms`;}
const headings=[{key:'url',itemType:'url',text:'URL'},{key:'totalBytes',itemType:'bytes',displayUnit:'kb',granularity:0.01,text:'Size (KB)'},{key:'wastedMs',itemType:'ms',text:'Download Time (ms)',granularity:1}];const summary={wastedMs};const details=Audit.makeTableDetails(headings,results,summary);return{displayValue,score:ByteEfficiencyAudit.scoreForWastedMs(wastedMs),rawValue:wastedMs,details};}}
module.exports=RenderBlockingResources;},{"../../lib/dependency-graph/network-node.js":24,"../../lib/dependency-graph/node":25,"../../lib/dependency-graph/simulator/simulator":28,"../../lib/web-inspector":47,"../audit":2,"./byte-efficiency-audit":3,"./unused-css-rules":"../audits/byte-efficiency/unused-css-rules"}],"../audits/byte-efficiency/total-byte-weight":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');class TotalByteWeight extends ByteEfficiencyAudit{static get meta(){return{name:'total-byte-weight',description:'Avoids enormous network payloads',failureDescription:'Has enormous network payloads',scoreDisplayMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,helpText:'Large network payloads cost users real money and are highly correlated with '+'long load times. [Learn '+'more](https://developers.google.com/web/tools/lighthouse/audits/network-payloads).',requiredArtifacts:['devtoolsLogs']};}
static get defaultOptions(){return{scorePODR:2500*1024,scoreMedian:4000*1024};}
static async audit(artifacts,context){const devtoolsLogs=artifacts.devtoolsLogs[ByteEfficiencyAudit.DEFAULT_PASS];const[networkRecords,networkThroughput]=await Promise.all([artifacts.requestNetworkRecords(devtoolsLogs),artifacts.requestNetworkThroughput(devtoolsLogs)]);let totalBytes=0;let results=[];networkRecords.forEach(record=>{if(record.parsedURL.scheme==='data'||!record.finished)return;const result={url:record.url,totalBytes:record.transferSize,totalMs:ByteEfficiencyAudit.bytesToMs(record.transferSize,networkThroughput)};totalBytes+=result.totalBytes;results.push(result);});const totalCompletedRequests=results.length;results=results.sort((itemA,itemB)=>itemB.totalBytes-itemA.totalBytes).slice(0,10);const score=ByteEfficiencyAudit.computeLogNormalScore(totalBytes,context.options.scorePODR,context.options.scoreMedian);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'totalBytes',itemType:'bytes',displayUnit:'kb',granularity:1,text:'Total Size'},{key:'totalMs',itemType:'ms',text:'Transfer Time'}];const tableDetails=ByteEfficiencyAudit.makeTableDetails(headings,results);return{score,rawValue:totalBytes,displayValue:['Total size was %d\xa0KB',totalBytes/1024],extendedInfo:{value:{results,totalCompletedRequests}},details:tableDetails};}}
module.exports=TotalByteWeight;},{"./byte-efficiency-audit":3}],"../audits/byte-efficiency/unminified-css":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const UnusedCSSRules=require('./unused-css-rules');const IGNORE_THRESHOLD_IN_PERCENT=5;const IGNORE_THRESHOLD_IN_BYTES=2048;class UnminifiedCSS extends ByteEfficiencyAudit{static get meta(){return{name:'unminified-css',description:'Minify CSS',scoreDisplayMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,helpText:'Minifying CSS files can reduce network payload sizes. '+'[Learn more](https://developers.google.com/speed/docs/insights/MinifyResources).',requiredArtifacts:['CSSUsage','devtoolsLogs']};}
static computeTokenLength(content){let totalTokenLength=0;let isInComment=false;let isInLicenseComment=false;let isInString=false;let stringOpenChar=null;for(let i=0;i<content.length;i++){const twoChars=content.substr(i,2);const char=twoChars.charAt(0);const isWhitespace=char===' '||char==='\n'||char==='\t';const isAStringOpenChar=char===`'`||char==='"';if(isInComment){if(isInLicenseComment)totalTokenLength++;if(twoChars==='*/'){if(isInLicenseComment)totalTokenLength++;isInComment=false;i++;}}else if(isInString){totalTokenLength++;if(char==='\\'){totalTokenLength++;i++;}else if(char===stringOpenChar){isInString=false;}}else{if(twoChars==='/*'){isInComment=true;isInLicenseComment=content.charAt(i+2)==='!';if(isInLicenseComment)totalTokenLength+=2;i++;}else if(isAStringOpenChar){isInString=true;stringOpenChar=char;totalTokenLength++;}else if(!isWhitespace){totalTokenLength++;}}}
if(isInComment||isInString){return content.length;}
return totalTokenLength;}
static computeWaste(stylesheet,networkRecord,pageUrl){const content=stylesheet.content;const totalTokenLength=UnminifiedCSS.computeTokenLength(content);let url=stylesheet.header.sourceURL;if(!url||url===pageUrl){const contentPreview=UnusedCSSRules.determineContentPreview(stylesheet.content);url={type:'code',value:contentPreview};}
const totalBytes=ByteEfficiencyAudit.estimateTransferSize(networkRecord,content.length,'stylesheet');const wastedRatio=1-totalTokenLength/content.length;const wastedBytes=Math.round(totalBytes*wastedRatio);return{url,totalBytes,wastedBytes,wastedPercent:100*wastedRatio};}
static audit_(artifacts,networkRecords){const pageUrl=artifacts.URL.finalUrl;const results=[];for(const stylesheet of artifacts.CSSUsage.stylesheets){const networkRecord=networkRecords.find(record=>record.url===stylesheet.header.sourceURL);if(!stylesheet.content)continue;const result=UnminifiedCSS.computeWaste(stylesheet,networkRecord,pageUrl);if(result.wastedPercent<IGNORE_THRESHOLD_IN_PERCENT||result.wastedBytes<IGNORE_THRESHOLD_IN_BYTES||!Number.isFinite(result.wastedBytes))continue;results.push(result);}
return{results,headings:[{key:'url',itemType:'url',text:'URL'},{key:'totalBytes',itemType:'bytes',displayUnit:'kb',granularity:1,text:'Original'},{key:'wastedBytes',itemType:'bytes',displayUnit:'kb',granularity:1,text:'Potential Savings'}]};}}
module.exports=UnminifiedCSS;},{"./byte-efficiency-audit":3,"./unused-css-rules":"../audits/byte-efficiency/unused-css-rules"}],"../audits/byte-efficiency/unminified-javascript":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const esprima=require('esprima');const IGNORE_THRESHOLD_IN_PERCENT=10;const IGNORE_THRESHOLD_IN_BYTES=2048;class UnminifiedJavaScript extends ByteEfficiencyAudit{static get meta(){return{name:'unminified-javascript',description:'Minify JavaScript',scoreDisplayMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,helpText:'Minifying JavaScript files can reduce payload sizes and script parse time. '+'[Learn more](https://developers.google.com/speed/docs/insights/MinifyResources).',requiredArtifacts:['Scripts','devtoolsLogs']};}
static computeWaste(scriptContent,networkRecord){const contentLength=scriptContent.length;let totalTokenLength=0;const tokens=esprima.tokenize(scriptContent,{tolerant:true});if(!tokens.length&&tokens.errors&&tokens.errors.length){throw tokens.errors[0];}
for(const token of tokens){totalTokenLength+=token.value.length;}
const totalBytes=ByteEfficiencyAudit.estimateTransferSize(networkRecord,contentLength,'script');const wastedRatio=1-totalTokenLength/contentLength;const wastedBytes=Math.round(totalBytes*wastedRatio);return{url:networkRecord.url,totalBytes,wastedBytes,wastedPercent:100*wastedRatio};}
static audit_(artifacts,networkRecords){const results=[];const warnings=[];for(const requestId of Object.keys(artifacts.Scripts)){const scriptContent=artifacts.Scripts[requestId];const networkRecord=networkRecords.find(record=>record.requestId===requestId);if(!networkRecord||!scriptContent)continue;try{const result=UnminifiedJavaScript.computeWaste(scriptContent,networkRecord);if(result.wastedPercent<IGNORE_THRESHOLD_IN_PERCENT||result.wastedBytes<IGNORE_THRESHOLD_IN_BYTES||!Number.isFinite(result.wastedBytes))continue;results.push(result);}catch(err){warnings.push(`Unable to process ${networkRecord._url}: ${err.message}`);}}
return{results,warnings,headings:[{key:'url',itemType:'url',text:'URL'},{key:'totalBytes',itemType:'bytes',displayUnit:'kb',granularity:1,text:'Original'},{key:'wastedBytes',itemType:'bytes',displayUnit:'kb',granularity:1,text:'Potential Savings'}]};}}
module.exports=UnminifiedJavaScript;},{"./byte-efficiency-audit":3,"esprima":136}],"../audits/byte-efficiency/unused-css-rules":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const IGNORE_THRESHOLD_IN_BYTES=2048;const PREVIEW_LENGTH=100;class UnusedCSSRules extends ByteEfficiencyAudit{static get meta(){return{name:'unused-css-rules',description:'Defer unused CSS',scoreDisplayMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,helpText:'Remove unused rules from stylesheets to reduce unnecessary '+'bytes consumed by network activity. '+'[Learn more](https://developers.google.com/speed/docs/insights/OptimizeCSSDelivery).',requiredArtifacts:['CSSUsage','URL','devtoolsLogs']};}
static indexStylesheetsById(styles,networkRecords){const indexedNetworkRecords=networkRecords.reduce((indexed,record)=>{indexed[record.url]=record;return indexed;},{});return styles.reduce((indexed,stylesheet)=>{indexed[stylesheet.header.styleSheetId]=Object.assign({usedRules:[],networkRecord:indexedNetworkRecords[stylesheet.header.sourceURL]},stylesheet);return indexed;},{});}
static indexUsedRules(rules,indexedStylesheets){rules.forEach(rule=>{const stylesheetInfo=indexedStylesheets[rule.styleSheetId];if(!stylesheetInfo){return;}
if(rule.used){stylesheetInfo.usedRules.push(rule);}});}
static computeUsage(stylesheetInfo){let usedUncompressedBytes=0;const totalUncompressedBytes=stylesheetInfo.content.length;for(const usedRule of stylesheetInfo.usedRules){usedUncompressedBytes+=usedRule.endOffset-usedRule.startOffset;}
const totalTransferredBytes=ByteEfficiencyAudit.estimateTransferSize(stylesheetInfo.networkRecord,totalUncompressedBytes,'stylesheet');const percentUnused=(totalUncompressedBytes-usedUncompressedBytes)/totalUncompressedBytes;const wastedBytes=Math.round(percentUnused*totalTransferredBytes);return{wastedBytes,wastedPercent:percentUnused*100,totalBytes:totalTransferredBytes};}
static determineContentPreview(content){let preview=(content||'').slice(0,PREVIEW_LENGTH*5).replace(/( {2,}|\t)+/g,'  ').replace(/\n\s+}/g,'\n}').trim();if(preview.length>PREVIEW_LENGTH){const firstRuleStart=preview.indexOf('{');const firstRuleEnd=preview.indexOf('}');if(firstRuleStart===-1||firstRuleEnd===-1||firstRuleStart>firstRuleEnd||firstRuleStart>PREVIEW_LENGTH){preview=preview.slice(0,PREVIEW_LENGTH)+'...';}else if(firstRuleEnd<PREVIEW_LENGTH){preview=preview.slice(0,firstRuleEnd+1)+' ...';}else{const lastSemicolonIndex=preview.slice(0,PREVIEW_LENGTH).lastIndexOf(';');preview=lastSemicolonIndex<firstRuleStart?preview.slice(0,PREVIEW_LENGTH)+'... } ...':preview.slice(0,lastSemicolonIndex+1)+' ... } ...';}}
return preview;}
static mapSheetToResult(stylesheetInfo,pageUrl){let url=stylesheetInfo.header.sourceURL;if(!url||url===pageUrl){const contentPreview=UnusedCSSRules.determineContentPreview(stylesheetInfo.content);url={type:'code',value:contentPreview};}
const usage=UnusedCSSRules.computeUsage(stylesheetInfo);return Object.assign({url},usage);}
static audit_(artifacts){const styles=artifacts.CSSUsage.stylesheets;const usage=artifacts.CSSUsage.rules;const pageUrl=artifacts.URL.finalUrl;const devtoolsLogs=artifacts.devtoolsLogs[ByteEfficiencyAudit.DEFAULT_PASS];return artifacts.requestNetworkRecords(devtoolsLogs).then(networkRecords=>{const indexedSheets=UnusedCSSRules.indexStylesheetsById(styles,networkRecords);UnusedCSSRules.indexUsedRules(usage,indexedSheets);const results=Object.keys(indexedSheets).map(sheetId=>UnusedCSSRules.mapSheetToResult(indexedSheets[sheetId],pageUrl)).filter(sheet=>sheet&&sheet.wastedBytes>IGNORE_THRESHOLD_IN_BYTES);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'totalBytes',itemType:'bytes',displayUnit:'kb',granularity:1,text:'Original'},{key:'wastedBytes',itemType:'bytes',displayUnit:'kb',granularity:1,text:'Potential Savings'}];return{results,headings};});}}
module.exports=UnusedCSSRules;},{"./byte-efficiency-audit":3}],"../audits/byte-efficiency/unused-javascript":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const IGNORE_THRESHOLD_IN_BYTES=2048;class UnusedJavaScript extends ByteEfficiencyAudit{static get meta(){return{name:'unused-javascript',description:'Unused JavaScript',scoreDisplayMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,helpText:'Remove unused JavaScript to reduce bytes consumed by network activity.',requiredArtifacts:['JsUsage','devtoolsLogs']};}
static computeWaste(script){let maximumEndOffset=0;for(const func of script.functions){for(const range of func.ranges){maximumEndOffset=Math.max(maximumEndOffset,range.endOffset);}}
const unusedByIndex=new Uint8Array(maximumEndOffset);for(const func of script.functions){for(const range of func.ranges){if(range.count===0){for(let i=range.startOffset;i<range.endOffset;i++){unusedByIndex[i]=1;}}}}
let unused=0;for(const x of unusedByIndex){unused+=x;}
return{unusedLength:unused,contentLength:maximumEndOffset};}
static mergeWaste(wasteData,networkRecord){let unusedLength=0;let contentLength=0;for(const usage of wasteData){unusedLength+=usage.unusedLength;contentLength+=usage.contentLength;}
const totalBytes=ByteEfficiencyAudit.estimateTransferSize(networkRecord,contentLength,'script');const wastedRatio=unusedLength/contentLength||0;const wastedBytes=Math.round(totalBytes*wastedRatio);return{url:networkRecord.url,totalBytes,wastedBytes,wastedPercent:100*wastedRatio};}
static audit_(artifacts,networkRecords){const scriptsByUrl=new Map();for(const script of artifacts.JsUsage){const scripts=scriptsByUrl.get(script.url)||[];scripts.push(script);scriptsByUrl.set(script.url,scripts);}
const results=[];for(const[url,scripts]of scriptsByUrl.entries()){const networkRecord=networkRecords.find(record=>record.url===url);if(!networkRecord)continue;const wasteData=scripts.map(UnusedJavaScript.computeWaste);const result=UnusedJavaScript.mergeWaste(wasteData,networkRecord);if(result.wastedBytes<=IGNORE_THRESHOLD_IN_BYTES)continue;results.push(result);}
return{results,headings:[{key:'url',itemType:'url',text:'URL'},{key:'totalBytes',itemType:'bytes',displayUnit:'kb',granularity:1,text:'Original'},{key:'wastedBytes',itemType:'bytes',displayUnit:'kb',granularity:1,text:'Potential Savings'}]};}}
module.exports=UnusedJavaScript;},{"./byte-efficiency-audit":3}],"../audits/byte-efficiency/uses-long-cache-ttl":[function(require,module,exports){'use strict';const assert=require('assert');const parseCacheControl=require('parse-cache-control');const Audit=require('../audit');const WebInspector=require('../../lib/web-inspector');const URL=require('../../lib/url-shim');const IGNORE_THRESHOLD_IN_PERCENT=0.925;class CacheHeaders extends Audit{static get meta(){return{name:'uses-long-cache-ttl',description:'Uses efficient cache policy on static assets',failureDescription:'Uses inefficient cache policy on static assets',helpText:'A long cache lifetime can speed up repeat visits to your page. '+'[Learn more](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/http-caching#cache-control).',scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['devtoolsLogs']};}
static get defaultOptions(){return{scorePODR:4*1024,scoreMedian:128*1024};}
static linearInterpolation(x0,y0,x1,y1,x){const slope=(y1-y0)/(x1-x0);return y0+(x-x0)*slope;}
static getCacheHitProbability(maxAgeInSeconds){const RESOURCE_AGE_IN_HOURS_DECILES=[0,0.2,1,3,8,12,24,48,72,168,8760,Infinity];assert.ok(RESOURCE_AGE_IN_HOURS_DECILES.length===12,'deciles 0-10 and 1 for overflow');const maxAgeInHours=maxAgeInSeconds/3600;const upperDecileIndex=RESOURCE_AGE_IN_HOURS_DECILES.findIndex(decile=>decile>=maxAgeInHours);if(upperDecileIndex===RESOURCE_AGE_IN_HOURS_DECILES.length-1)return 1;if(upperDecileIndex===0)return 0;const upperDecileValue=RESOURCE_AGE_IN_HOURS_DECILES[upperDecileIndex];const lowerDecileValue=RESOURCE_AGE_IN_HOURS_DECILES[upperDecileIndex-1];const upperDecile=upperDecileIndex/10;const lowerDecile=(upperDecileIndex-1)/10;return CacheHeaders.linearInterpolation(lowerDecileValue,lowerDecile,upperDecileValue,upperDecile,maxAgeInHours);}
static computeCacheLifetimeInSeconds(headers,cacheControl){if(cacheControl){if(cacheControl['no-cache']||cacheControl['no-store'])return 0;const maxAge=cacheControl['max-age'];if(maxAge!==undefined&&Number.isFinite(maxAge))return Math.max(maxAge,0);}else if((headers.get('pragma')||'').includes('no-cache')){return 0;}
const expiresHeaders=headers.get('expires');if(expiresHeaders){const expires=new Date(expiresHeaders).getTime();if(!expires)return 0;return Math.max(0,Math.ceil((expires-Date.now())/1000));}
return null;}
static isCacheableAsset(record){const CACHEABLE_STATUS_CODES=new Set([200,203,206]);const STATIC_RESOURCE_TYPES=new Set([WebInspector.resourceTypes.Font,WebInspector.resourceTypes.Image,WebInspector.resourceTypes.Media,WebInspector.resourceTypes.Script,WebInspector.resourceTypes.Stylesheet]);const resourceUrl=record._url;return(CACHEABLE_STATUS_CODES.has(record.statusCode)&&STATIC_RESOURCE_TYPES.has(record._resourceType)&&!resourceUrl.includes('data:'));}
static audit(artifacts,context){const devtoolsLogs=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];return artifacts.requestNetworkRecords(devtoolsLogs).then(records=>{const results=[];let queryStringCount=0;let totalWastedBytes=0;for(const record of records){if(!CacheHeaders.isCacheableAsset(record))continue;const headers=new Map();for(const header of record._responseHeaders||[]){headers.set(header.name.toLowerCase(),header.value);}
const cacheControl=parseCacheControl(headers.get('cache-control'));let cacheLifetimeInSeconds=CacheHeaders.computeCacheLifetimeInSeconds(headers,cacheControl);if(cacheLifetimeInSeconds===0)continue;cacheLifetimeInSeconds=cacheLifetimeInSeconds||0;const cacheHitProbability=CacheHeaders.getCacheHitProbability(cacheLifetimeInSeconds);if(cacheHitProbability>IGNORE_THRESHOLD_IN_PERCENT)continue;const url=URL.elideDataURI(record._url);const totalBytes=record._transferSize||0;const wastedBytes=(1-cacheHitProbability)*totalBytes;totalWastedBytes+=wastedBytes;if(url.includes('?'))queryStringCount++;results.push({url,cacheControl,cacheLifetimeMs:cacheLifetimeInSeconds*1000,cacheHitProbability,totalBytes,wastedBytes});}
results.sort((a,b)=>a.cacheLifetimeMs-b.cacheLifetimeMs||b.totalBytes-a.totalBytes);const score=Audit.computeLogNormalScore(totalWastedBytes,context.options.scorePODR,context.options.scoreMedian);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'cacheLifetimeMs',itemType:'ms',text:'Cache TTL',displayUnit:'duration'},{key:'totalBytes',itemType:'bytes',text:'Size (KB)',displayUnit:'kb',granularity:1}];const summary={wastedBytes:totalWastedBytes};const details=Audit.makeTableDetails(headings,results,summary);return{score,rawValue:totalWastedBytes,displayValue:`${results.length} asset${results.length!==1?'s':''} found`,extendedInfo:{value:{results,queryStringCount}},details};});}}
module.exports=CacheHeaders;},{"../../lib/url-shim":"url","../../lib/web-inspector":47,"../audit":2,"assert":53,"parse-cache-control":147}],"../audits/byte-efficiency/uses-optimized-images":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const URL=require('../../lib/url-shim');const IGNORE_THRESHOLD_IN_BYTES=4096;class UsesOptimizedImages extends ByteEfficiencyAudit{static get meta(){return{name:'uses-optimized-images',description:'Efficiently encode images',scoreDisplayMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,helpText:'Optimized images load faster and consume less cellular data. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/optimize-images).',requiredArtifacts:['OptimizedImages','devtoolsLogs']};}
static computeSavings(image){const bytes=image.originalSize-image.jpegSize;const percent=100*bytes/image.originalSize;return{bytes,percent};}
static audit_(artifacts){const images=artifacts.OptimizedImages;const results=[];const warnings=[];for(const image of images){if(image.failed){warnings.push(`Unable to decode ${URL.getURLDisplayName(image.url)}`);continue;}else if(/(jpeg|bmp)/.test(image.mimeType)===false||image.originalSize<image.jpegSize+IGNORE_THRESHOLD_IN_BYTES){continue;}
const url=URL.elideDataURI(image.url);const jpegSavings=UsesOptimizedImages.computeSavings(image);results.push({url,fromProtocol:image.fromProtocol,isCrossOrigin:!image.isSameOrigin,totalBytes:image.originalSize,wastedBytes:jpegSavings.bytes});}
const headings=[{key:'url',itemType:'thumbnail',text:''},{key:'url',itemType:'url',text:'URL'},{key:'totalBytes',itemType:'bytes',displayUnit:'kb',granularity:1,text:'Original'},{key:'wastedBytes',itemType:'bytes',displayUnit:'kb',granularity:1,text:'Potential Savings'}];return{warnings,results,headings};}}
module.exports=UsesOptimizedImages;},{"../../lib/url-shim":"url","./byte-efficiency-audit":3}],"../audits/byte-efficiency/uses-responsive-images":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const Sentry=require('../../lib/sentry');const URL=require('../../lib/url-shim');const IGNORE_THRESHOLD_IN_BYTES=2048;class UsesResponsiveImages extends ByteEfficiencyAudit{static get meta(){return{name:'uses-responsive-images',description:'Properly size images',scoreDisplayMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,helpText:'Serve images that are appropriately-sized to save cellular data '+'and improve load time. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/oversized-images).',requiredArtifacts:['ImageUsage','ViewportDimensions','devtoolsLogs']};}
static computeWaste(image,DPR){if(!image.networkRecord){return null;}
const url=URL.elideDataURI(image.src);const actualPixels=image.naturalWidth*image.naturalHeight;const usedPixels=image.clientWidth*image.clientHeight*Math.pow(DPR,2);const wastedRatio=1-usedPixels/actualPixels;const totalBytes=image.networkRecord.resourceSize;const wastedBytes=Math.round(totalBytes*wastedRatio);if(!usedPixels){return null;}
if(!Number.isFinite(wastedRatio)){return new Error(`Invalid image sizing information ${url}`);}
return{url,totalBytes,wastedBytes,wastedPercent:100*wastedRatio};}
static audit_(artifacts){const images=artifacts.ImageUsage;const DPR=artifacts.ViewportDimensions.devicePixelRatio;const warnings=[];const resultsMap=new Map();images.forEach(image=>{if(!image.networkRecord||image.networkRecord.mimeType==='image/svg+xml'){return;}
const processed=UsesResponsiveImages.computeWaste(image,DPR);if(!processed)return;if(processed instanceof Error){warnings.push(processed.message);Sentry.captureException(processed,{tags:{audit:this.meta.name},level:'warning'});return;}
const existing=resultsMap.get(processed.url);if(!existing||existing.wastedBytes>processed.wastedBytes){resultsMap.set(processed.url,processed);}});const results=Array.from(resultsMap.values()).filter(item=>item.wastedBytes>IGNORE_THRESHOLD_IN_BYTES);const headings=[{key:'url',itemType:'thumbnail',text:''},{key:'url',itemType:'url',text:'URL'},{key:'totalBytes',itemType:'bytes',displayUnit:'kb',granularity:1,text:'Original'},{key:'wastedBytes',itemType:'bytes',displayUnit:'kb',granularity:1,text:'Potential Savings'}];return{warnings,results,headings};}}
module.exports=UsesResponsiveImages;},{"../../lib/sentry":39,"../../lib/url-shim":"url","./byte-efficiency-audit":3}],"../audits/byte-efficiency/uses-text-compression":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const URL=require('../../lib/url-shim');const IGNORE_THRESHOLD_IN_BYTES=1400;const IGNORE_THRESHOLD_IN_PERCENT=0.1;class ResponsesAreCompressed extends ByteEfficiencyAudit{static get meta(){return{name:'uses-text-compression',scoreDisplayMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,description:'Enable text compression',helpText:'Text-based responses should be served with compression (gzip, deflate or brotli)'+' to minimize total network bytes.'+' [Learn more](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/optimize-encoding-and-transfer).',requiredArtifacts:['ResponseCompression','devtoolsLogs']};}
static audit_(artifacts){const uncompressedResponses=artifacts.ResponseCompression;const results=[];uncompressedResponses.forEach(record=>{const originalSize=record.resourceSize;const gzipSize=record.gzipSize;const gzipSavings=originalSize-gzipSize;if(1-gzipSize/originalSize<IGNORE_THRESHOLD_IN_PERCENT||gzipSavings<IGNORE_THRESHOLD_IN_BYTES||record.transferSize<gzipSize)
{return;}
const url=URL.elideDataURI(record.url);const isDuplicate=results.find(res=>res.url===url&&res.totalBytes===record.resourceSize);if(isDuplicate){return;}
results.push({url,totalBytes:originalSize,wastedBytes:gzipSavings});});const headings=[{key:'url',itemType:'url',text:'Uncompressed resource URL'},{key:'totalBytes',itemType:'bytes',displayUnit:'kb',granularity:1,text:'Original'},{key:'wastedBytes',itemType:'bytes',displayUnit:'kb',granularity:1,text:'GZIP Savings'}];return{results,headings};}}
module.exports=ResponsesAreCompressed;},{"../../lib/url-shim":"url","./byte-efficiency-audit":3}],"../audits/byte-efficiency/uses-webp-images":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const URL=require('../../lib/url-shim');const IGNORE_THRESHOLD_IN_BYTES=8192;class UsesWebPImages extends ByteEfficiencyAudit{static get meta(){return{name:'uses-webp-images',description:'Serve images in next-gen formats',scoreDisplayMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,helpText:'Image formats like JPEG 2000, JPEG XR, and WebP often provide better '+'compression than PNG or JPEG, which means faster downloads and less data consumption. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/webp).',requiredArtifacts:['OptimizedImages','devtoolsLogs']};}
static computeSavings(image){const bytes=image.originalSize-image.webpSize;const percent=100*bytes/image.originalSize;return{bytes,percent};}
static audit_(artifacts){const images=artifacts.OptimizedImages;const results=[];const warnings=[];for(const image of images){if(image.failed){warnings.push(`Unable to decode ${URL.getURLDisplayName(image.url)}`);continue;}else if(image.originalSize<image.webpSize+IGNORE_THRESHOLD_IN_BYTES){continue;}
const url=URL.elideDataURI(image.url);const webpSavings=UsesWebPImages.computeSavings(image);results.push({url,fromProtocol:image.fromProtocol,isCrossOrigin:!image.isSameOrigin,totalBytes:image.originalSize,wastedBytes:webpSavings.bytes});}
const headings=[{key:'url',itemType:'thumbnail',text:''},{key:'url',itemType:'url',text:'URL'},{key:'totalBytes',itemType:'bytes',displayUnit:'kb',granularity:1,text:'Original'},{key:'wastedBytes',itemType:'bytes',displayUnit:'kb',granularity:1,text:'Potential Savings'}];return{warnings,results,headings};}}
module.exports=UsesWebPImages;},{"../../lib/url-shim":"url","./byte-efficiency-audit":3}],"../audits/content-width":[function(require,module,exports){'use strict';const Audit=require('./audit');class ContentWidth extends Audit{static get meta(){return{name:'content-width',description:'Content is sized correctly for the viewport',failureDescription:'Content is not sized correctly for the viewport',helpText:'If the width of your app\'s content doesn\'t match the width '+'of the viewport, your app might not be optimized for mobile screens. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/content-sized-correctly-for-viewport).',requiredArtifacts:['ViewportDimensions']};}
static audit(artifacts){const viewportWidth=artifacts.ViewportDimensions.innerWidth;const windowWidth=artifacts.ViewportDimensions.outerWidth;const widthsMatch=viewportWidth===windowWidth;return{rawValue:widthsMatch,explanation:this.createExplanation(widthsMatch,artifacts.ViewportDimensions)};}
static createExplanation(match,artifact){if(match){return'';}
return'The viewport size is '+artifact.innerWidth+'px, '+'whereas the window size is '+artifact.outerWidth+'px.';}}
module.exports=ContentWidth;},{"./audit":2}],"../audits/critical-request-chains":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/html/renderer/util');class CriticalRequestChains extends Audit{static get meta(){return{name:'critical-request-chains',description:'Critical Request Chains',scoreDisplayMode:Audit.SCORING_MODES.INFORMATIVE,helpText:'The Critical Request Chains below show you what resources are '+'issued with a high priority. Consider reducing '+'the length of chains, reducing the download size of resources, or '+'deferring the download of unnecessary resources to improve page load. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/critical-request-chains).',requiredArtifacts:['devtoolsLogs','URL']};}
static _traverse(tree,cb){function walk(node,depth,startTime,transferSize=0){const children=Object.keys(node);if(children.length===0){return;}
children.forEach(id=>{const child=node[id];if(!startTime){startTime=child.request.startTime;}
cb({depth,id,node:child,chainDuration:(child.request.endTime-startTime)*1000,chainTransferSize:transferSize+child.request.transferSize});walk(child.children,depth+1,startTime);},'');}
walk(tree,0);}
static _getLongestChain(tree){const longest={duration:0,length:0,transferSize:0};CriticalRequestChains._traverse(tree,opts=>{const duration=opts.chainDuration;if(duration>longest.duration){longest.duration=duration;longest.transferSize=opts.chainTransferSize;longest.length=opts.depth;}});longest.length++;return longest;}
static flattenRequests(tree){const flattendChains={};const chainMap=new Map();function flatten(opts){const request=opts.node.request;const simpleRequest={url:request.url,startTime:request.startTime,endTime:request.endTime,_responseReceivedTime:request._responseReceivedTime,transferSize:request.transferSize};let chain=chainMap.get(opts.id);if(chain){chain.request=simpleRequest;}else{chain={request:simpleRequest,children:{}};flattendChains[opts.id]=chain;}
for(const chainId of Object.keys(opts.node.children)){const childChain={request:{},children:{}};chainMap.set(chainId,childChain);chain.children[chainId]=childChain;}
chainMap.set(opts.id,chain);}
CriticalRequestChains._traverse(tree,flatten);return flattendChains;}
static audit(artifacts){const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const URL=artifacts.URL;return artifacts.requestCriticalRequestChains({devtoolsLog,URL}).then(chains=>{let chainCount=0;function walk(node,depth){const children=Object.keys(node);if(children.length===0){chainCount++;}
children.forEach(id=>{const child=node[id];walk(child.children,depth+1);},'');}
const flattenedChains=CriticalRequestChains.flattenRequests(chains);const initialNavKey=Object.keys(flattenedChains)[0];const initialNavChildren=initialNavKey&&flattenedChains[initialNavKey].children;if(initialNavChildren&&Object.keys(initialNavChildren).length>0){walk(initialNavChildren,0);}
const longestChain=CriticalRequestChains._getLongestChain(flattenedChains);return{rawValue:chainCount===0,notApplicable:chainCount===0,displayValue:chainCount?`${Util.formatNumber(chainCount)} chains found`:'',extendedInfo:{value:{chains:flattenedChains,longestChain}},details:{type:'criticalrequestchain',header:{type:'text',text:'View critical network waterfall:'},chains:flattenedChains,longestChain}};});}}
module.exports=CriticalRequestChains;},{"../report/html/renderer/util":48,"./audit":2}],"../audits/deprecations":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/html/renderer/util');class Deprecations extends Audit{static get meta(){return{name:'deprecations',description:'Avoids deprecated APIs',failureDescription:'Uses deprecated API\'s',helpText:'Deprecated APIs will eventually be removed from the browser. '+'[Learn more](https://www.chromestatus.com/features#deprecated).',requiredArtifacts:['ChromeConsoleMessages']};}
static audit(artifacts){const entries=artifacts.ChromeConsoleMessages;const deprecations=entries.filter(log=>log.entry.source==='deprecation').map(log=>{return{value:log.entry.text,url:log.entry.url||'',source:log.entry.source,lineNumber:log.entry.lineNumber};});const headings=[{key:'value',itemType:'code',text:'Deprecation / Warning'},{key:'url',itemType:'url',text:'URL'},{key:'lineNumber',itemType:'text',text:'Line'}];const details=Audit.makeTableDetails(headings,deprecations);let displayValue='';if(deprecations.length>1){displayValue=`${Util.formatNumber(deprecations.length)} warnings found`;}else if(deprecations.length===1){displayValue=`${deprecations.length} warning found`;}
return{rawValue:deprecations.length===0,displayValue,extendedInfo:{value:deprecations},details};}}
module.exports=Deprecations;},{"../report/html/renderer/util":48,"./audit":2}],"../audits/dobetterweb/appcache-manifest":[function(require,module,exports){'use strict';const Audit=require('../audit');class AppCacheManifestAttr extends Audit{static get meta(){return{name:'appcache-manifest',description:'Avoids Application Cache',failureDescription:'Uses Application Cache',helpText:'Application Cache is deprecated. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/appcache).',requiredArtifacts:['AppCacheManifest']};}
static audit(artifacts){const usingAppcache=artifacts.AppCacheManifest!==null;const displayValue=usingAppcache?`Found "${artifacts.AppCacheManifest}"`:'';return{rawValue:!usingAppcache,displayValue};}}
module.exports=AppCacheManifestAttr;},{"../audit":2}],"../audits/dobetterweb/dom-size":[function(require,module,exports){'use strict';const Audit=require('../audit');const Util=require('../../report/html/renderer/util.js');const MAX_DOM_NODES=1500;const MAX_DOM_TREE_WIDTH=60;const MAX_DOM_TREE_DEPTH=32;class DOMSize extends Audit{static get MAX_DOM_NODES(){return MAX_DOM_NODES;}
static get meta(){return{name:'dom-size',description:'Avoids an excessive DOM size',failureDescription:'Uses an excessive DOM size',helpText:'Browser engineers recommend pages contain fewer than '+`~${Util.formatNumber(DOMSize.MAX_DOM_NODES)} DOM nodes. The sweet spot is a tree `+`depth < ${MAX_DOM_TREE_DEPTH} elements and fewer than ${MAX_DOM_TREE_WIDTH} `+'children/parent element. A large DOM can increase memory usage, cause longer '+'[style calculations](https://developers.google.com/web/fundamentals/performance/rendering/reduce-the-scope-and-complexity-of-style-calculations), '+'and produce costly [layout reflows](https://developers.google.com/speed/articles/reflow). [Learn more](https://developers.google.com/web/tools/lighthouse/audits/dom-size).',scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['DOMStats']};}
static get defaultOptions(){return{scorePODR:700,scoreMedian:1400};}
static audit(artifacts,context){const stats=artifacts.DOMStats;const score=Audit.computeLogNormalScore(stats.totalDOMNodes,context.options.scorePODR,context.options.scoreMedian);const headings=[{key:'totalNodes',itemType:'text',text:'Total DOM Nodes'},{key:'depth',itemType:'text',text:'Maximum DOM Depth'},{key:'width',itemType:'text',text:'Maximum Children'}];const items=[{totalNodes:Util.formatNumber(stats.totalDOMNodes),depth:Util.formatNumber(stats.depth.max),width:Util.formatNumber(stats.width.max)},{totalNodes:'',depth:{type:'code',value:stats.depth.snippet},width:{type:'code',value:stats.width.snippet}}];return{score,rawValue:stats.totalDOMNodes,displayValue:['%d nodes',stats.totalDOMNodes],extendedInfo:{value:items},details:Audit.makeTableDetails(headings,items)};}}
module.exports=DOMSize;},{"../../report/html/renderer/util.js":48,"../audit":2}],"../audits/dobetterweb/external-anchors-use-rel-noopener":[function(require,module,exports){'use strict';const URL=require('../../lib/url-shim');const Audit=require('../audit');class ExternalAnchorsUseRelNoopenerAudit extends Audit{static get meta(){return{name:'external-anchors-use-rel-noopener',description:'Links to cross-origin destinations are safe',failureDescription:'Links to cross-origin destinations are unsafe',helpText:'Add `rel="noopener"` or `rel="noreferrer"` to any external links to improve '+'performance and prevent security vulnerabilities. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/noopener).',requiredArtifacts:['URL','AnchorsWithNoRelNoopener']};}
static audit(artifacts){const warnings=[];const pageHost=new URL(artifacts.URL.finalUrl).host;const failingAnchors=artifacts.AnchorsWithNoRelNoopener.filter(anchor=>{try{return new URL(anchor.href).host!==pageHost;}catch(err){warnings.push('Unable to determine the destination for anchor tag. '+'If not used as a hyperlink, consider removing target=_blank.');return true;}}).filter(anchor=>{return!anchor.href||anchor.href.toLowerCase().startsWith('http');}).map(anchor=>{return{href:anchor.href||'Unknown',target:anchor.target||'',rel:anchor.rel||'',url:'<a'+(anchor.href?` href="${anchor.href}"`:'')+(anchor.target?` target="${anchor.target}"`:'')+(anchor.rel?` rel="${anchor.rel}"`:'')+'>'};});const headings=[{key:'href',itemType:'url',text:'URL'},{key:'target',itemType:'text',text:'Target'},{key:'rel',itemType:'text',text:'Rel'}];const details=Audit.makeTableDetails(headings,failingAnchors);return{rawValue:failingAnchors.length===0,extendedInfo:{value:failingAnchors},details,warnings};}}
module.exports=ExternalAnchorsUseRelNoopenerAudit;},{"../../lib/url-shim":"url","../audit":2}],"../audits/dobetterweb/geolocation-on-start":[function(require,module,exports){'use strict';const ViolationAudit=require('../violation-audit');class GeolocationOnStart extends ViolationAudit{static get meta(){return{name:'geolocation-on-start',description:'Avoids requesting the geolocation permission on page load',failureDescription:'Requests the geolocation permission on page load',helpText:'Users are mistrustful of or confused by sites that request their '+'location without context. Consider tying the request to user gestures instead. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/geolocation-on-load).',requiredArtifacts:['ChromeConsoleMessages']};}
static audit(artifacts){const results=ViolationAudit.getViolationResults(artifacts,/geolocation/);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'label',itemType:'text',text:'Location'}];const details=ViolationAudit.makeTableDetails(headings,results);return{rawValue:results.length===0,extendedInfo:{value:results},details};}}
module.exports=GeolocationOnStart;},{"../violation-audit":6}],"../audits/dobetterweb/no-document-write":[function(require,module,exports){'use strict';const ViolationAudit=require('../violation-audit');class NoDocWriteAudit extends ViolationAudit{static get meta(){return{name:'no-document-write',description:'Avoids `document.write()`',failureDescription:'Uses `document.write()`',helpText:'For users on slow connections, external scripts dynamically injected via '+'`document.write()` can delay page load by tens of seconds. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/document-write).',requiredArtifacts:['ChromeConsoleMessages']};}
static audit(artifacts){const results=ViolationAudit.getViolationResults(artifacts,/document\.write/);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'label',itemType:'text',text:'Location'}];const details=ViolationAudit.makeTableDetails(headings,results);return{rawValue:results.length===0,extendedInfo:{value:results},details};}}
module.exports=NoDocWriteAudit;},{"../violation-audit":6}],"../audits/dobetterweb/no-mutation-events":[function(require,module,exports){'use strict';const URL=require('../../lib/url-shim');const Audit=require('../audit');const EventHelpers=require('../../lib/event-helpers');class NoMutationEventsAudit extends Audit{static get MUTATION_EVENTS(){return['DOMAttrModified','DOMAttributeNameChanged','DOMCharacterDataModified','DOMElementNameChanged','DOMNodeInserted','DOMNodeInsertedIntoDocument','DOMNodeRemoved','DOMNodeRemovedFromDocument','DOMSubtreeModified'];}
static get meta(){return{name:'no-mutation-events',description:'Avoids Mutation Events in its own scripts',failureDescription:'Uses Mutation Events in its own scripts',helpText:'Mutation Events are deprecated and harm performance. Consider using Mutation '+'Observers instead. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/mutation-events).',requiredArtifacts:['URL','EventListeners']};}
static audit(artifacts){const warnings=[];const listeners=artifacts.EventListeners;const results=listeners.filter(loc=>{const isMutationEvent=this.MUTATION_EVENTS.includes(loc.type);let sameHost=URL.hostsMatch(artifacts.URL.finalUrl,loc.url);if(!URL.isValid(loc.url)&&isMutationEvent){sameHost=true;warnings.push(URL.INVALID_URL_DEBUG_STRING);}
return sameHost&&isMutationEvent;}).map(EventHelpers.addFormattedCodeSnippet);const groupedResults=EventHelpers.groupCodeSnippetsByLocation(results);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'type',itemType:'code',text:'Event'},{key:'line',itemType:'text',text:'Line'},{key:'col',itemType:'text',text:'Col'},{key:'pre',itemType:'code',text:'Snippet'}];const details=NoMutationEventsAudit.makeTableDetails(headings,groupedResults);return{rawValue:groupedResults.length===0,extendedInfo:{value:{results:groupedResults}},details,warnings};}}
module.exports=NoMutationEventsAudit;},{"../../lib/event-helpers":34,"../../lib/url-shim":"url","../audit":2}],"../audits/dobetterweb/no-vulnerable-libraries":[function(require,module,exports){'use strict';const Audit=require('../audit');const Sentry=require('../../lib/sentry');const semver=require('semver');const snykDatabase=require('../../../third-party/snyk/snapshot.json');const SEMVER_REGEX=/^(\d+\.\d+\.\d+)[^-0-9]+/;class NoVulnerableLibrariesAudit extends Audit{static get meta(){return{name:'no-vulnerable-libraries',description:'Avoids front-end JavaScript libraries'+' with known security vulnerabilities',failureDescription:'Includes front-end JavaScript libraries'+' with known security vulnerabilities',helpText:'Some third-party scripts may contain known security vulnerabilities '+' that are easily identified and exploited by attackers.',requiredArtifacts:['JSLibraries']};}
static get snykDB(){return snykDatabase;}
static get severityMap(){return{high:3,medium:2,low:1};}
static normalizeVersion(version){if(!version)return version;if(semver.valid(version))return version;if(/^\d+\.\d+$/.test(version))return`${version}.0`;const versionMatch=version.match(SEMVER_REGEX);if(versionMatch)return versionMatch[1];return version;}
static getVulnerabilities(normalizedVersion,lib){const snykDB=NoVulnerableLibrariesAudit.snykDB;if(!lib.npmPkgName||!snykDB.npm[lib.npmPkgName]){return[];}
try{semver.satisfies(normalizedVersion,'*');}catch(err){err.pkgName=lib.npmPkgName;Sentry.captureException(err,{level:'warning'});return[];}
const snykInfo=snykDB.npm[lib.npmPkgName];const vulns=snykInfo.filter(vuln=>semver.satisfies(normalizedVersion,vuln.semver.vulnerable[0])).map(vuln=>{return{severity:vuln.severity,numericSeverity:this.severityMap[vuln.severity],library:`${lib.name}@${normalizedVersion}`,url:'https://snyk.io/vuln/'+vuln.id};});return vulns;}
static highestSeverity(vulnerabilities){const sortedVulns=vulnerabilities.sort((a,b)=>b.numericSeverity-a.numericSeverity);return sortedVulns[0].severity;}
static audit(artifacts){const foundLibraries=artifacts.JSLibraries;if(!foundLibraries.length){return{rawValue:true};}
let totalVulns=0;const vulnerabilityResults=[];const libraryVulns=foundLibraries.map(lib=>{const version=this.normalizeVersion(lib.version)||'';const vulns=this.getVulnerabilities(version,lib);const vulnCount=vulns.length;totalVulns+=vulnCount;let highestSeverity;if(vulns.length>0){highestSeverity=this.highestSeverity(vulns).replace(/^\w/,l=>l.toUpperCase());vulnerabilityResults.push({highestSeverity,vulnCount,detectedLib:{text:lib.name+'@'+version,url:`https://snyk.io/vuln/npm:${lib.npmPkgName}?lh@${version}`,type:'link'}});}
return{name:lib.name,npmPkgName:lib.npmPkgName,version,vulns,highestSeverity};});let displayValue='';if(totalVulns>1){displayValue=`${totalVulns} vulnerabilities detected`;}else if(totalVulns===1){displayValue=`${totalVulns} vulnerability detected`;}
const headings=[{key:'detectedLib',itemType:'link',text:'Library Version'},{key:'vulnCount',itemType:'text',text:'Vulnerability Count'},{key:'highestSeverity',itemType:'text',text:'Highest Severity'}];const details=Audit.makeTableDetails(headings,vulnerabilityResults,{});return{rawValue:totalVulns===0,displayValue,extendedInfo:{jsLibs:libraryVulns,vulnerabilities:vulnerabilityResults},details};}}
module.exports=NoVulnerableLibrariesAudit;},{"../../../third-party/snyk/snapshot.json":155,"../../lib/sentry":39,"../audit":2,"semver":150}],"../audits/dobetterweb/no-websql":[function(require,module,exports){'use strict';const Audit=require('../audit');class NoWebSQLAudit extends Audit{static get meta(){return{name:'no-websql',description:'Avoids WebSQL DB',failureDescription:'Uses WebSQL DB',helpText:'Web SQL is deprecated. Consider using IndexedDB instead. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/web-sql).',requiredArtifacts:['WebSQL']};}
static audit(artifacts){const db=artifacts.WebSQL;const displayValue=db?`Found "${db.name}" (v${db.version})`:'';return{rawValue:!db,displayValue};}}
module.exports=NoWebSQLAudit;},{"../audit":2}],"../audits/dobetterweb/notification-on-start":[function(require,module,exports){'use strict';const ViolationAudit=require('../violation-audit');class NotificationOnStart extends ViolationAudit{static get meta(){return{name:'notification-on-start',description:'Avoids requesting the notification permission on page load',failureDescription:'Requests the notification permission on page load',helpText:'Users are mistrustful of or confused by sites that request to send '+'notifications without context. Consider tying the request to user gestures '+'instead. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/notifications-on-load).',requiredArtifacts:['ChromeConsoleMessages']};}
static audit(artifacts){const results=ViolationAudit.getViolationResults(artifacts,/notification permission/);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'label',itemType:'text',text:'Location'}];const details=ViolationAudit.makeTableDetails(headings,results);return{rawValue:results.length===0,extendedInfo:{value:results},details};}}
module.exports=NotificationOnStart;},{"../violation-audit":6}],"../audits/dobetterweb/password-inputs-can-be-pasted-into":[function(require,module,exports){'use strict';const Audit=require('../audit');class PasswordInputsCanBePastedIntoAudit extends Audit{static get meta(){return{name:'password-inputs-can-be-pasted-into',description:'Allows users to paste into password fields',failureDescription:'Prevents users to paste into password fields',helpText:'Preventing password pasting undermines good security policy. '+'[Learn more](https://www.ncsc.gov.uk/blog-post/let-them-paste-passwords).',requiredArtifacts:['PasswordInputsWithPreventedPaste']};}
static audit(artifacts){const passwordInputsWithPreventedPaste=artifacts.PasswordInputsWithPreventedPaste;const items=[];passwordInputsWithPreventedPaste.forEach(input=>{items.push({node:{type:'node',snippet:input.snippet}});});const headings=[{key:'node',itemType:'node',text:'Failing Elements'}];return{rawValue:passwordInputsWithPreventedPaste.length===0,extendedInfo:{value:passwordInputsWithPreventedPaste},details:Audit.makeTableDetails(headings,items)};}}
module.exports=PasswordInputsCanBePastedIntoAudit;},{"../audit":2}],"../audits/dobetterweb/uses-http2":[function(require,module,exports){'use strict';const URL=require('../../lib/url-shim');const Audit=require('../audit');const Util=require('../../report/html/renderer/util.js');class UsesHTTP2Audit extends Audit{static get meta(){return{name:'uses-http2',description:'Uses HTTP/2 for its own resources',failureDescription:'Does not use HTTP/2 for all of its resources',helpText:'HTTP/2 offers many benefits over HTTP/1.1, including binary headers, '+'multiplexing, and server push. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/http2).',requiredArtifacts:['URL','devtoolsLogs']};}
static audit(artifacts){const devtoolsLogs=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];return artifacts.requestNetworkRecords(devtoolsLogs).then(networkRecords=>{const finalHost=new URL(artifacts.URL.finalUrl).host;const seenURLs=new Set();const resources=networkRecords.filter(record=>{const isOldHttp=/HTTP\/[01][.\d]?/i.test(record.protocol);if(!isOldHttp)return false;const requestHost=new URL(record._url).host;return requestHost===finalHost;}).map(record=>{return{protocol:record.protocol,url:record._url};}).filter(record=>{if(seenURLs.has(record.url))return false;seenURLs.add(record.url);return true;});let displayValue='';if(resources.length>1){displayValue=`${Util.formatNumber(resources.length)} requests not served via HTTP/2`;}else if(resources.length===1){displayValue=`${resources.length} request not served via HTTP/2`;}
const headings=[{key:'url',itemType:'url',text:'URL'},{key:'protocol',itemType:'text',text:'Protocol'}];const details=Audit.makeTableDetails(headings,resources);return{rawValue:resources.length===0,displayValue:displayValue,extendedInfo:{value:{results:resources}},details};});}}
module.exports=UsesHTTP2Audit;},{"../../lib/url-shim":"url","../../report/html/renderer/util.js":48,"../audit":2}],"../audits/dobetterweb/uses-passive-event-listeners":[function(require,module,exports){'use strict';const ViolationAudit=require('../violation-audit');class PassiveEventsAudit extends ViolationAudit{static get meta(){return{name:'uses-passive-event-listeners',description:'Uses passive listeners to improve scrolling performance',failureDescription:'Does not use passive listeners to improve scrolling performance',helpText:'Consider marking your touch and wheel event listeners as `passive` '+'to improve your page\'s scroll performance. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/passive-event-listeners).',requiredArtifacts:['ChromeConsoleMessages']};}
static audit(artifacts){const results=ViolationAudit.getViolationResults(artifacts,/passive event listener/);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'label',itemType:'text',text:'Location'}];const details=ViolationAudit.makeTableDetails(headings,results);return{rawValue:results.length===0,extendedInfo:{value:results},details};}}
module.exports=PassiveEventsAudit;},{"../violation-audit":6}],"../audits/errors-in-console":[function(require,module,exports){'use strict';const Audit=require('./audit');class ErrorLogs extends Audit{static get meta(){return{name:'errors-in-console',description:'No browser errors logged to the console',helpText:'Errors logged to the console indicate unresolved problems. '+'They can come from network request failures and other browser concerns.',failureDescription:'Browser errors were logged to the console',requiredArtifacts:['ChromeConsoleMessages','RuntimeExceptions']};}
static audit(artifacts){const consoleEntries=artifacts.ChromeConsoleMessages;const runtimeExceptions=artifacts.RuntimeExceptions;const consoleRows=consoleEntries.filter(log=>log.entry&&log.entry.level==='error').map(item=>{return{source:item.entry.source,description:item.entry.text,url:item.entry.url};});const runtimeExRows=runtimeExceptions.filter(entry=>entry.exceptionDetails!==undefined).map(entry=>{const description=entry.exceptionDetails.exception?entry.exceptionDetails.exception.description:entry.exceptionDetails.text;return{source:'Runtime.exception',description,url:entry.exceptionDetails.url};});const tableRows=consoleRows.concat(runtimeExRows);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'description',itemType:'code',text:'Description'}];const details=Audit.makeTableDetails(headings,tableRows);const numErrors=tableRows.length;return{score:Number(numErrors===0),rawValue:numErrors,details};}}
module.exports=ErrorLogs;},{"./audit":2}],"../audits/estimated-input-latency":[function(require,module,exports){'use strict';const Audit=require('./audit');class EstimatedInputLatency extends Audit{static get meta(){return{name:'estimated-input-latency',description:'Estimated Input Latency',helpText:'The score above is an estimate of how long your app takes to respond to user '+'input, in milliseconds, during the busiest 5s window of page load. If your '+'latency is higher than 50 ms, users may perceive your app as laggy. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/estimated-input-latency).',scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces']};}
static get defaultOptions(){return{scorePODR:50,scoreMedian:100};}
static async audit(artifacts,context){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const metricComputationData={trace,devtoolsLog,settings:context.settings};const metricResult=await artifacts.requestEstimatedInputLatency(metricComputationData);return{score:Audit.computeLogNormalScore(metricResult.timing,context.options.scorePODR,context.options.scoreMedian),rawValue:metricResult.timing,displayValue:['%d\xa0ms',metricResult.timing]};}}
module.exports=EstimatedInputLatency;},{"./audit":2}],"../audits/first-contentful-paint":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/html/renderer/util.js');class FirstContentfulPaint extends Audit{static get meta(){return{name:'first-contentful-paint',description:'First Contentful Paint',helpText:'First contentful paint marks the time at which the first text/image is painted. '+`[Learn more](https://developers.google.com/web/fundamentals/performance/user-centric-performance-metrics#first_paint_and_first_contentful_paint).`,scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces','devtoolsLogs']};}
static get defaultOptions(){return{scorePODR:2900,scoreMedian:4000};}
static async audit(artifacts,context){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const metricComputationData={trace,devtoolsLog,settings:context.settings};const metricResult=await artifacts.requestFirstContentfulPaint(metricComputationData);return{score:Audit.computeLogNormalScore(metricResult.timing,context.options.scorePODR,context.options.scoreMedian),rawValue:metricResult.timing,displayValue:[Util.MS_DISPLAY_VALUE,metricResult.timing]};}}
module.exports=FirstContentfulPaint;},{"../report/html/renderer/util.js":48,"./audit":2}],"../audits/first-cpu-idle":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/html/renderer/util.js');class FirstCPUIdle extends Audit{static get meta(){return{name:'first-cpu-idle',description:'First CPU Idle',helpText:'First CPU Idle marks the first time at which the page\'s main thread is '+'quiet enough to handle input. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/first-interactive).',scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces']};}
static get defaultOptions(){return{scorePODR:2900,scoreMedian:6500};}
static async audit(artifacts,context){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const metricComputationData={trace,devtoolsLog,settings:context.settings};const metricResult=await artifacts.requestFirstCPUIdle(metricComputationData);return{score:Audit.computeLogNormalScore(metricResult.timing,context.options.scorePODR,context.options.scoreMedian),rawValue:metricResult.timing,displayValue:[Util.MS_DISPLAY_VALUE,metricResult.timing]};}}
module.exports=FirstCPUIdle;},{"../report/html/renderer/util.js":48,"./audit":2}],"../audits/first-meaningful-paint":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/html/renderer/util');class FirstMeaningfulPaint extends Audit{static get meta(){return{name:'first-meaningful-paint',description:'First Meaningful Paint',helpText:'First Meaningful Paint measures when the primary content of a page is visible. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/first-meaningful-paint).',scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces']};}
static get defaultOptions(){return{scorePODR:2000,scoreMedian:4000};}
static async audit(artifacts,context){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const metricComputationData={trace,devtoolsLog,settings:context.settings};const metricResult=await artifacts.requestFirstMeaningfulPaint(metricComputationData);return{score:Audit.computeLogNormalScore(metricResult.timing,context.options.scorePODR,context.options.scoreMedian),rawValue:metricResult.timing,displayValue:[Util.MS_DISPLAY_VALUE,metricResult.timing]};}}
module.exports=FirstMeaningfulPaint;},{"../report/html/renderer/util":48,"./audit":2}],"../audits/font-display":[function(require,module,exports){'use strict';const Audit=require('./audit');const WebInspector=require('../lib/web-inspector');const allowedFontFaceDisplays=['block','fallback','optional','swap'];class FontDisplay extends Audit{static get meta(){return{name:'font-display',description:'All text remains visible during webfont loads',failureDescription:'Text is invisible while webfonts are loading',helpText:'Leverage the font-display CSS feature to ensure text is user-visible while '+'webfonts are loading. '+'[Learn more](https://developers.google.com/web/updates/2016/02/font-display).',requiredArtifacts:['devtoolsLogs','Fonts']};}
static audit(artifacts){const devtoolsLogs=artifacts.devtoolsLogs[this.DEFAULT_PASS];const fontFaces=artifacts.Fonts;const fontsWithoutProperDisplay=fontFaces.filter(fontFace=>!fontFace.display||!allowedFontFaceDisplays.includes(fontFace.display));return artifacts.requestNetworkRecords(devtoolsLogs).then(networkRecords=>{const results=networkRecords.filter(record=>{const isFont=record._resourceType===WebInspector.resourceTypes.Font;return isFont;}).filter(fontRecord=>{return!!fontsWithoutProperDisplay.find(fontFace=>{return!!fontFace.src&&!!fontFace.src.find(src=>fontRecord.url===src);});}).map(record=>{const wastedTime=Math.min((record.endTime-record.startTime)*1000,3000);return{url:record.url,wastedTime};});const headings=[{key:'url',itemType:'url',text:'Font URL'},{key:'wastedTime',itemType:'ms',granularity:1,text:'Font download time'}];const details=Audit.makeTableDetails(headings,results);return{score:Number(results.length===0),rawValue:results.length===0,details};});}}
module.exports=FontDisplay;},{"../lib/web-inspector":47,"./audit":2}],"../audits/image-aspect-ratio":[function(require,module,exports){'use strict';const Audit=require('./audit');const URL=require('../lib/url-shim');const THRESHOLD=0.05;class ImageAspectRatio extends Audit{static get meta(){return{name:'image-aspect-ratio',description:'Displays images with correct aspect ratio',failureDescription:'Displays images with incorrect aspect ratio',helpText:'Image display dimensions should match natural aspect ratio.',requiredArtifacts:['ImageUsage']};}
static computeAspectRatios(image){const url=URL.elideDataURI(image.src);const actualAspectRatio=image.naturalWidth/image.naturalHeight;const displayedAspectRatio=image.width/image.height;const doRatiosMatch=Math.abs(actualAspectRatio-displayedAspectRatio)<THRESHOLD;if(!Number.isFinite(actualAspectRatio)||!Number.isFinite(displayedAspectRatio)){return new Error(`Invalid image sizing information ${url}`);}
return{url,displayedAspectRatio:`${image.width} x ${image.height}
        (${displayedAspectRatio.toFixed(2)})`,actualAspectRatio:`${image.naturalWidth} x ${image.naturalHeight}
        (${actualAspectRatio.toFixed(2)})`,doRatiosMatch};}
static audit(artifacts){const images=artifacts.ImageUsage;const warnings=[];const results=[];images.filter(image=>{return image.networkRecord&&image.networkRecord.mimeType!=='image/svg+xml'&&image.width&&image.height&&!image.usesObjectFit;}).forEach(image=>{const wellDefinedImage=image;const processed=ImageAspectRatio.computeAspectRatios(wellDefinedImage);if(processed instanceof Error){warnings.push(processed.message);return;}
if(!processed.doRatiosMatch)results.push(processed);});const headings=[{key:'url',itemType:'thumbnail',text:''},{key:'url',itemType:'url',text:'URL'},{key:'displayedAspectRatio',itemType:'text',text:'Aspect Ratio (Displayed)'},{key:'actualAspectRatio',itemType:'text',text:'Aspect Ratio (Actual)'}];return{rawValue:results.length===0,warnings,details:Audit.makeTableDetails(headings,results)};}}
module.exports=ImageAspectRatio;},{"../lib/url-shim":"url","./audit":2}],"../audits/interactive":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/html/renderer/util');class InteractiveMetric extends Audit{static get meta(){return{name:'interactive',description:'Time to Interactive',helpText:'Interactive marks the time at which the page is fully interactive. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/consistently-interactive).',scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces','devtoolsLogs']};}
static get defaultOptions(){return{scorePODR:2900,scoreMedian:7300};}
static async audit(artifacts,context){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const metricComputationData={trace,devtoolsLog,settings:context.settings};const metricResult=await artifacts.requestInteractive(metricComputationData);const timeInMs=metricResult.timing;const extendedInfo={timeInMs,timestamp:metricResult.timestamp,optimistic:metricResult.optimisticEstimate&&metricResult.optimisticEstimate.timeInMs,pessimistic:metricResult.pessimisticEstimate&&metricResult.pessimisticEstimate.timeInMs};return{score:Audit.computeLogNormalScore(timeInMs,context.options.scorePODR,context.options.scoreMedian),rawValue:timeInMs,displayValue:[Util.MS_DISPLAY_VALUE,timeInMs],extendedInfo:{value:extendedInfo}};}}
module.exports=InteractiveMetric;},{"../report/html/renderer/util":48,"./audit":2}],"../audits/is-on-https":[function(require,module,exports){'use strict';const Audit=require('./audit');const URL=require('../lib/url-shim');const Util=require('../report/html/renderer/util');const SECURE_SCHEMES=['data','https','wss','blob','chrome','chrome-extension','about'];const SECURE_DOMAINS=['localhost','127.0.0.1'];class HTTPS extends Audit{static get meta(){return{name:'is-on-https',description:'Uses HTTPS',failureDescription:'Does not use HTTPS',helpText:'All sites should be protected with HTTPS, even ones that don\'t handle '+'sensitive data. HTTPS prevents intruders from tampering with or passively listening '+'in on the communications between your app and your users, and is a prerequisite for '+'HTTP/2 and many new web platform APIs. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/https).',requiredArtifacts:['devtoolsLogs']};}
static isSecureRecord(record){return SECURE_SCHEMES.includes(record.parsedURL.scheme)||SECURE_SCHEMES.includes(record.protocol)||SECURE_DOMAINS.includes(record.parsedURL.host);}
static audit(artifacts){const devtoolsLogs=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];return artifacts.requestNetworkRecords(devtoolsLogs).then(networkRecords=>{const insecureURLs=networkRecords.filter(record=>!HTTPS.isSecureRecord(record)).map(record=>URL.elideDataURI(record.url));let displayValue='';if(insecureURLs.length>1){displayValue=`${Util.formatNumber(insecureURLs.length)} insecure requests found`;}else if(insecureURLs.length===1){displayValue=`${insecureURLs.length} insecure request found`;}
const items=Array.from(new Set(insecureURLs)).map(url=>({url}));const headings=[{key:'url',itemType:'url',text:'Insecure URL'}];return{rawValue:items.length===0,displayValue,extendedInfo:{value:items},details:Audit.makeTableDetails(headings,items)};});}}
module.exports=HTTPS;},{"../lib/url-shim":"url","../report/html/renderer/util":48,"./audit":2}],"../audits/load-fast-enough-for-pwa":[function(require,module,exports){'use strict';const isDeepEqual=require('lodash.isequal');const Audit=require('./audit');const mobile3GThrottling=require('../config/constants').throttling.mobile3G;const MAXIMUM_TTI=10*1000;class LoadFastEnough4Pwa extends Audit{static get meta(){return{name:'load-fast-enough-for-pwa',description:'Page load is fast enough on 3G',failureDescription:'Page load is not fast enough on 3G',helpText:'A fast page load over a 3G network ensures a good mobile user experience. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/fast-3g).',requiredArtifacts:['traces','devtoolsLogs']};}
static async audit(artifacts,context){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const settingOverrides={throttlingMethod:'simulate',throttling:mobile3GThrottling};const settings=context.settings.throttlingMethod!=='provided'&&isDeepEqual(context.settings.throttling,mobile3GThrottling)?context.settings:Object.assign({},context.settings,settingOverrides);const metricComputationData={trace,devtoolsLog,settings};const tti=await artifacts.requestInteractive(metricComputationData);const score=Number(tti.timing<MAXIMUM_TTI);let displayValue;let explanation;if(!score){displayValue=[`Interactive at %d\xa0s`,tti.timing/1000];explanation='Your page loads too slowly and is not interactive within 10 seconds. '+'Look at the opportunities and diagnostics in the "Performance" section to learn how to '+'improve.';}
return{score,displayValue,explanation,rawValue:tti.timing};}}
module.exports=LoadFastEnough4Pwa;},{"../config/constants":8,"./audit":2,"lodash.isequal":144}],"../audits/mainthread-work-breakdown":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/html/renderer/util');const{taskToGroup}=require('../lib/task-groups');class MainThreadWorkBreakdown extends Audit{static get meta(){return{name:'mainthread-work-breakdown',description:'Minimizes main thread work',failureDescription:'Has significant main thread work',scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,helpText:'Consider reducing the time spent parsing, compiling and executing JS. '+'You may find delivering smaller JS payloads helps with this.',requiredArtifacts:['traces']};}
static get defaultOptions(){return{scorePODR:1500,scoreMedian:4000};}
static getExecutionTimingsByCategory(timelineModel){const bottomUpByName=timelineModel.bottomUpGroupBy('EventName');const result=new Map();bottomUpByName.children.forEach((event,eventName)=>result.set(eventName,event.selfTime));return result;}
static async audit(artifacts,context){const settings=context.settings||{};const trace=artifacts.traces[MainThreadWorkBreakdown.DEFAULT_PASS];const devtoolsTimelineModel=await artifacts.requestDevtoolsTimelineModel(trace);const executionTimings=MainThreadWorkBreakdown.getExecutionTimingsByCategory(devtoolsTimelineModel);let totalExecutionTime=0;const multiplier=settings.throttlingMethod==='simulate'?settings.throttling.cpuSlowdownMultiplier:1;const extendedInfo={};const categoryTotals={};const results=Array.from(executionTimings).map(([eventName,duration])=>{duration*=multiplier;totalExecutionTime+=duration;extendedInfo[eventName]=duration;const groupName=taskToGroup[eventName];const categoryTotal=categoryTotals[groupName]||0;categoryTotals[groupName]=categoryTotal+duration;return{category:eventName,group:groupName,duration:duration};});const headings=[{key:'group',itemType:'text',text:'Category'},{key:'category',itemType:'text',text:'Work'},{key:'duration',itemType:'ms',granularity:1,text:'Time spent'}];results.stableSort((a,b)=>categoryTotals[b.group]-categoryTotals[a.group]);const tableDetails=MainThreadWorkBreakdown.makeTableDetails(headings,results);const score=Audit.computeLogNormalScore(totalExecutionTime,context.options.scorePODR,context.options.scoreMedian);return{score,rawValue:totalExecutionTime,displayValue:[Util.MS_DISPLAY_VALUE,totalExecutionTime],details:tableDetails,extendedInfo:{value:extendedInfo}};}}
module.exports=MainThreadWorkBreakdown;},{"../lib/task-groups":42,"../report/html/renderer/util":48,"./audit":2}],"../audits/manifest-short-name-length":[function(require,module,exports){'use strict';const Audit=require('./audit');class ManifestShortNameLength extends Audit{static get meta(){return{name:'manifest-short-name-length',description:'Manifest\'s `short_name` won\'t be truncated when displayed on homescreen',failureDescription:'Manifest\'s `short_name` will be truncated when displayed '+'on homescreen',helpText:'Make your app\'s `short_name` fewer than 12 characters to '+'ensure that it\'s not truncated on homescreens. [Learn '+'more](https://developers.google.com/web/tools/lighthouse/audits/manifest-short_name-is-not-truncated).',requiredArtifacts:['Manifest']};}
static audit(artifacts){return artifacts.requestManifestValues(artifacts.Manifest).then(manifestValues=>{if(manifestValues.isParseFailure){return{rawValue:false};}
const hasShortName=manifestValues.allChecks.find(i=>i.id==='hasShortName');if(!hasShortName||!hasShortName.passing){return{rawValue:false,explanation:'No short_name found in manifest.'};}
const isShortEnough=manifestValues.allChecks.find(i=>i.id==='shortNameLength');return{rawValue:!!isShortEnough&&isShortEnough.passing};});}}
module.exports=ManifestShortNameLength;},{"./audit":2}],"../audits/manual/pwa-cross-browser":[function(require,module,exports){'use strict';const ManualAudit=require('./manual-audit');class PWACrossBrowser extends ManualAudit{static get meta(){return Object.assign({name:'pwa-cross-browser',helpText:'To reach the most number of users, sites should work across '+'every major browser. [Learn more](https://developers.google.com/web/progressive-web-apps/checklist#site-works-cross-browser).',description:'Site works cross-browser'},super.partialMeta);}}
module.exports=PWACrossBrowser;},{"./manual-audit":4}],"../audits/manual/pwa-each-page-has-url":[function(require,module,exports){'use strict';const ManualAudit=require('./manual-audit');class PWAEachPageHasURL extends ManualAudit{static get meta(){return Object.assign({name:'pwa-each-page-has-url',helpText:'Ensure individual pages are deep linkable via the URLs and that URLs are '+'unique for the purpose of shareability on social media. [Learn more](https://developers.google.com/web/progressive-web-apps/checklist#each-page-has-a-url).',description:'Each page has a URL'},super.partialMeta);}}
module.exports=PWAEachPageHasURL;},{"./manual-audit":4}],"../audits/manual/pwa-page-transitions":[function(require,module,exports){'use strict';const ManualAudit=require('./manual-audit');class PWAPageTransitions extends ManualAudit{static get meta(){return Object.assign({name:'pwa-page-transitions',helpText:'Transitions should feel snappy as you tap around, even on a slow network, a key '+'to perceived performance. [Learn more](https://developers.google.com/web/progressive-web-apps/checklist#page-transitions-dont-feel-like-they-block-on-the-network).',description:'Page transitions don\'t feel like they block on the network'},super.partialMeta);}}
module.exports=PWAPageTransitions;},{"./manual-audit":4}],"../audits/metrics":[function(require,module,exports){'use strict';const Audit=require('./audit');class Metrics extends Audit{static get meta(){return{name:'metrics',scoreDisplayMode:Audit.SCORING_MODES.INFORMATIVE,description:'Metrics',helpText:'Collects all available metrics.',requiredArtifacts:['traces','devtoolsLogs']};}
static async audit(artifacts,context){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const metricComputationData={trace,devtoolsLog,settings:context.settings};const traceOfTab=await artifacts.requestTraceOfTab(trace);const speedline=await artifacts.requestSpeedline(trace);const firstContentfulPaint=await artifacts.requestFirstContentfulPaint(metricComputationData);const firstMeaningfulPaint=await artifacts.requestFirstMeaningfulPaint(metricComputationData);const firstCPUIdle=await artifacts.requestFirstCPUIdle(metricComputationData);const interactive=await artifacts.requestInteractive(metricComputationData);const speedIndex=await artifacts.requestSpeedIndex(metricComputationData);const estimatedInputLatency=await artifacts.requestEstimatedInputLatency(metricComputationData);const metrics={firstContentfulPaint:firstContentfulPaint.timing,firstContentfulPaintTs:firstContentfulPaint.timestamp,firstMeaningfulPaint:firstMeaningfulPaint.timing,firstMeaningfulPaintTs:firstMeaningfulPaint.timestamp,firstCPUIdle:firstCPUIdle.timing,firstCPUIdleTs:firstCPUIdle.timestamp,interactive:interactive.timing,interactiveTs:interactive.timestamp,speedIndex:speedIndex.timing,speedIndexTs:speedIndex.timestamp,estimatedInputLatency:estimatedInputLatency.timing,estimatedInputLatencyTs:estimatedInputLatency.timestamp,observedNavigationStart:traceOfTab.timings.navigationStart,observedNavigationStartTs:traceOfTab.timestamps.navigationStart,observedFirstPaint:traceOfTab.timings.firstPaint,observedFirstPaintTs:traceOfTab.timestamps.firstPaint,observedFirstContentfulPaint:traceOfTab.timings.firstContentfulPaint,observedFirstContentfulPaintTs:traceOfTab.timestamps.firstContentfulPaint,observedFirstMeaningfulPaint:traceOfTab.timings.firstMeaningfulPaint,observedFirstMeaningfulPaintTs:traceOfTab.timestamps.firstMeaningfulPaint,observedTraceEnd:traceOfTab.timings.traceEnd,observedTraceEndTs:traceOfTab.timestamps.traceEnd,observedLoad:traceOfTab.timings.load,observedLoadTs:traceOfTab.timestamps.load,observedDomContentLoaded:traceOfTab.timings.domContentLoaded,observedDomContentLoadedTs:traceOfTab.timestamps.domContentLoaded,observedFirstVisualChange:speedline.first,observedFirstVisualChangeTs:(speedline.first+speedline.beginning)*1000,observedLastVisualChange:speedline.complete,observedLastVisualChangeTs:(speedline.complete+speedline.beginning)*1000,observedSpeedIndex:speedline.speedIndex,observedSpeedIndexTs:(speedline.speedIndex+speedline.beginning)*1000};for(const[name,value]of Object.entries(metrics)){const key=name;if(typeof value!=='undefined'){metrics[key]=Math.round(value);}}
const details={items:[metrics]};return{score:1,rawValue:interactive.timing,details};}}
module.exports=Metrics;},{"./audit":2}],"../audits/mixed-content":[function(require,module,exports){'use strict';const Audit=require('./audit');const URL=require('../lib/url-shim');const Util=require('../report/html/renderer/util');class MixedContent extends Audit{static get meta(){return{name:'mixed-content',description:'All resources loaded are secure',failureDescription:'Some insecure resources can be upgraded to HTTPS',helpText:`Mixed content warnings can prevent you from upgrading to HTTPS.
      This audit shows which insecure resources this page uses that can be
      upgraded to HTTPS. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/mixed-content)`,requiredArtifacts:['devtoolsLogs','MixedContent']};}
static isSecureRecord(record){return record.securityState()==='secure'||record.protocol==='data';}
static upgradeURL(url){const parsedURL=new URL(url);parsedURL.protocol='https:';return parsedURL.href;}
static simplifyURL(url){const parsedURL=new URL(url);parsedURL.hash='';parsedURL.search='';return parsedURL.href;}
static displayURL(url){const displayOptions={numPathParts:4,preserveQuery:false,preserveHost:true};return URL.getURLDisplayName(url,displayOptions);}
static audit(artifacts){const defaultLogs=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const upgradeLogs=artifacts.devtoolsLogs['mixedContentPass'];const baseHostname=new URL(artifacts.MixedContent.url).host;const computedArtifacts=[artifacts.requestNetworkRecords(defaultLogs),artifacts.requestNetworkRecords(upgradeLogs)];return Promise.all(computedArtifacts).then(([defaultRecords,upgradedRecords])=>{const insecureRecords=defaultRecords.filter(record=>!MixedContent.isSecureRecord(record));const secureRecords=defaultRecords.filter(record=>MixedContent.isSecureRecord(record));const upgradePassHosts=new Set();const upgradePassSecureHosts=new Set();upgradedRecords.forEach(record=>{upgradePassHosts.add(new URL(record.url).hostname);if(MixedContent.isSecureRecord(record)&&record.finished&&!record.failed){upgradePassSecureHosts.add(new URL(record.url).hostname);}});const seen=new Set();const upgradeableResources=[];for(const record of insecureRecords){const simpleUrl=this.simplifyURL(record.url);if(seen.has(simpleUrl))continue;seen.add(simpleUrl);const resource={host:new URL(record.url).hostname,fullUrl:record.url,referrerDocUrl:this.displayURL(record._documentURL)};if(!upgradePassSecureHosts.has(resource.host))continue;if(!resource.referrerDocUrl.includes(baseHostname))continue;upgradeableResources.push(resource);}
const displayValue=`${Util.formatNumber(upgradeableResources.length)}
          ${upgradeableResources.length===1?'request':'requests'}`;const headings=[{key:'fullUrl',itemType:'url',text:'URL'}];const details=Audit.makeTableDetails(headings,upgradeableResources);const totalRecords=defaultRecords.length;const score=(secureRecords.length+0.5*upgradeableResources.length)/totalRecords;return{rawValue:upgradeableResources.length===0,score,displayValue:displayValue,details};});}}
module.exports=MixedContent;},{"../lib/url-shim":"url","../report/html/renderer/util":48,"./audit":2}],"../audits/network-requests":[function(require,module,exports){'use strict';const Audit=require('./audit');const URL=require('../lib/url-shim');class NetworkRequests extends Audit{static get meta(){return{name:'network-requests',scoreDisplayMode:Audit.SCORING_MODES.INFORMATIVE,description:'Network Requests',helpText:'Lists the network requests that were made during page load.',requiredArtifacts:['devtoolsLogs']};}
static audit(artifacts){const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];return artifacts.requestNetworkRecords(devtoolsLog).then(records=>{const earliestStartTime=records.reduce((min,record)=>Math.min(min,record.startTime),Infinity);const results=records.map(record=>{return{url:URL.elideDataURI(record.url),startTime:(record.startTime-earliestStartTime)*1000,endTime:(record.endTime-earliestStartTime)*1000,transferSize:record.transferSize,statusCode:record.statusCode,mimeType:record._mimeType,resourceType:record._resourceType&&record._resourceType._name};});const headings=[{key:'url',itemType:'url',text:'URL'},{key:'startTime',itemType:'ms',granularity:1,text:'Start Time'},{key:'endTime',itemType:'ms',granularity:1,text:'End Time'},{key:'transferSize',itemType:'bytes',displayUnit:'kb',granularity:1,text:'Transfer Size'},{key:'statusCode',itemType:'text',text:'Status Code'},{key:'mimeType',itemType:'text',text:'MIME Type'},{key:'resourceType',itemType:'text',text:'Resource Type'}];const tableDetails=Audit.makeTableDetails(headings,results);return{score:1,rawValue:results.length,extendedInfo:{value:results},details:tableDetails};});}}
module.exports=NetworkRequests;},{"../lib/url-shim":"url","./audit":2}],"../audits/predictive-perf":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/html/renderer/util');const SCORING_POINT_OF_DIMINISHING_RETURNS=1700;const SCORING_MEDIAN=10000;class PredictivePerf extends Audit{static get meta(){return{name:'predictive-perf',description:'Predicted Performance (beta)',helpText:'Predicted performance evaluates how your site will perform under '+'a 3G connection on a mobile device.',scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces','devtoolsLogs']};}
static async audit(artifacts){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const settings={};const fcp=await artifacts.requestLanternFirstContentfulPaint({trace,devtoolsLog,settings});const fmp=await artifacts.requestLanternFirstMeaningfulPaint({trace,devtoolsLog,settings});const tti=await artifacts.requestLanternInteractive({trace,devtoolsLog,settings});const ttfcpui=await artifacts.requestLanternFirstCPUIdle({trace,devtoolsLog,settings});const si=await artifacts.requestLanternSpeedIndex({trace,devtoolsLog,settings});const eil=await artifacts.requestLanternEstimatedInputLatency({trace,devtoolsLog,settings});const values={roughEstimateOfFCP:fcp.timing,optimisticFCP:fcp.optimisticEstimate.timeInMs,pessimisticFCP:fcp.pessimisticEstimate.timeInMs,roughEstimateOfFMP:fmp.timing,optimisticFMP:fmp.optimisticEstimate.timeInMs,pessimisticFMP:fmp.pessimisticEstimate.timeInMs,roughEstimateOfTTI:tti.timing,optimisticTTI:tti.optimisticEstimate.timeInMs,pessimisticTTI:tti.pessimisticEstimate.timeInMs,roughEstimateOfTTFCPUI:ttfcpui.timing,optimisticTTFCPUI:ttfcpui.optimisticEstimate.timeInMs,pessimisticTTFCPUI:ttfcpui.pessimisticEstimate.timeInMs,roughEstimateOfSI:si.timing,optimisticSI:si.optimisticEstimate.timeInMs,pessimisticSI:si.pessimisticEstimate.timeInMs,roughEstimateOfEIL:eil.timing,optimisticEIL:eil.optimisticEstimate.timeInMs,pessimisticEIL:eil.pessimisticEstimate.timeInMs};const score=Audit.computeLogNormalScore(values.roughEstimateOfTTI,SCORING_POINT_OF_DIMINISHING_RETURNS,SCORING_MEDIAN);return{score,rawValue:values.roughEstimateOfTTI,displayValue:Util.formatMilliseconds(values.roughEstimateOfTTI),details:{items:[values]}};}}
module.exports=PredictivePerf;},{"../report/html/renderer/util":48,"./audit":2}],"../audits/redirects-http":[function(require,module,exports){'use strict';const Audit=require('./audit');class RedirectsHTTP extends Audit{static get meta(){return{name:'redirects-http',description:'Redirects HTTP traffic to HTTPS',failureDescription:'Does not redirect HTTP traffic to HTTPS',helpText:'If you\'ve already set up HTTPS, make sure that you redirect all HTTP traffic '+'to HTTPS. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/http-redirects-to-https).',requiredArtifacts:['HTTPRedirect']};}
static audit(artifacts){return{rawValue:artifacts.HTTPRedirect.value};}}
module.exports=RedirectsHTTP;},{"./audit":2}],"../audits/redirects":[function(require,module,exports){'use strict';const Audit=require('./audit');const UnusedBytes=require('./byte-efficiency/byte-efficiency-audit');class Redirects extends Audit{static get meta(){return{name:'redirects',description:'Avoid multiple page redirects',scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,helpText:'Redirects introduce additional delays before the page can be loaded. [Learn more](https://developers.google.com/speed/docs/insights/AvoidRedirects).',requiredArtifacts:['URL','devtoolsLogs','traces']};}
static async audit(artifacts,context){const settings=context.settings;const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const traceOfTab=await artifacts.requestTraceOfTab(trace);const networkRecords=await artifacts.requestNetworkRecords(devtoolsLog);const mainResource=await artifacts.requestMainResource({URL:artifacts.URL,devtoolsLog});const metricComputationData={trace,devtoolsLog,traceOfTab,networkRecords,settings};const metricResult=await artifacts.requestLanternInteractive(metricComputationData);const nodeTimingsByUrl=new Map();for(const[node,timing]of metricResult.pessimisticEstimate.nodeTimings.entries()){if(node.type==='network'){const networkNode=node;nodeTimingsByUrl.set(networkNode.record.url,timing);}}
const redirectRequests=Array.from(mainResource.redirects||[]);redirectRequests.push(mainResource);let totalWastedMs=0;const pageRedirects=[];if(redirectRequests.length>1){pageRedirects.push({url:`(Initial: ${redirectRequests[0].url})`,wastedMs:0});}
for(let i=1;i<redirectRequests.length;i++){const initialRequest=redirectRequests[i-1];const redirectedRequest=redirectRequests[i];const initialTiming=nodeTimingsByUrl.get(initialRequest.url);const redirectedTiming=nodeTimingsByUrl.get(redirectedRequest.url);if(!initialTiming||!redirectedTiming){throw new Error('Could not find redirects in graph');}
const wastedMs=redirectedTiming.startTime-initialTiming.startTime;totalWastedMs+=wastedMs;pageRedirects.push({url:redirectedRequest.url,wastedMs});}
const headings=[{key:'url',itemType:'text',text:'Redirected URL'},{key:'wastedMs',itemType:'ms',text:'Time for Redirect'}];const summary={wastedMs:totalWastedMs};const details=Audit.makeTableDetails(headings,pageRedirects,summary);return{score:redirectRequests.length<=2?1:UnusedBytes.scoreForWastedMs(totalWastedMs),rawValue:totalWastedMs,displayValue:['%d\xa0ms',totalWastedMs],extendedInfo:{value:{wastedMs:totalWastedMs}},details};}}
module.exports=Redirects;},{"./audit":2,"./byte-efficiency/byte-efficiency-audit":3}],"../audits/screenshot-thumbnails":[function(require,module,exports){'use strict';const Audit=require('./audit');const LHError=require('../lib/errors');const jpeg=require('jpeg-js');const NUMBER_OF_THUMBNAILS=10;const THUMBNAIL_WIDTH=120;class ScreenshotThumbnails extends Audit{static get meta(){return{name:'screenshot-thumbnails',scoreDisplayMode:Audit.SCORING_MODES.INFORMATIVE,description:'Screenshot Thumbnails',helpText:'This is what the load of your site looked like.',requiredArtifacts:['traces','devtoolsLogs']};}
static scaleImageToThumbnail(imageData){const scaledWidth=THUMBNAIL_WIDTH;const scaleFactor=imageData.width/scaledWidth;const scaledHeight=Math.floor(imageData.height/scaleFactor);const outPixels=new Uint8Array(scaledWidth*scaledHeight*4);for(let i=0;i<scaledWidth;i++){for(let j=0;j<scaledHeight;j++){const origX=Math.floor(i*scaleFactor);const origY=Math.floor(j*scaleFactor);const origPos=(origY*imageData.width+origX)*4;const outPos=(j*scaledWidth+i)*4;outPixels[outPos]=imageData.data[origPos];outPixels[outPos+1]=imageData.data[origPos+1];outPixels[outPos+2]=imageData.data[origPos+2];outPixels[outPos+3]=imageData.data[origPos+3];}}
return{width:scaledWidth,height:scaledHeight,data:outPixels};}
static async audit(artifacts,context){const trace=artifacts.traces[Audit.DEFAULT_PASS];const cachedThumbnails=new Map();const speedline=await artifacts.requestSpeedline(trace);let minimumTimelineDuration=context.options.minimumTimelineDuration||3000;if(context.settings.throttlingMethod!=='simulate'){const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const metricComputationData={trace,devtoolsLog,settings:context.settings};const tti=artifacts.requestInteractive(metricComputationData);try{minimumTimelineDuration=Math.max((await tti).timing,minimumTimelineDuration);}catch(_){}}
const thumbnails=[];const analyzedFrames=speedline.frames.filter(frame=>!frame.isProgressInterpolated());const maxFrameTime=speedline.complete||Math.max(...speedline.frames.map(frame=>frame.getTimeStamp()-speedline.beginning));const timelineEnd=Math.max(maxFrameTime,minimumTimelineDuration);if(!analyzedFrames.length||!Number.isFinite(timelineEnd)){throw new LHError(LHError.errors.INVALID_SPEEDLINE);}
for(let i=1;i<=NUMBER_OF_THUMBNAILS;i++){const targetTimestamp=speedline.beginning+timelineEnd*i/NUMBER_OF_THUMBNAILS;let frameForTimestamp=null;if(i===NUMBER_OF_THUMBNAILS){frameForTimestamp=analyzedFrames[analyzedFrames.length-1];}else{analyzedFrames.forEach(frame=>{if(frame.getTimeStamp()<=targetTimestamp){frameForTimestamp=frame;}});}
const imageData=frameForTimestamp.getParsedImage();const thumbnailImageData=ScreenshotThumbnails.scaleImageToThumbnail(imageData);const base64Data=cachedThumbnails.get(frameForTimestamp)||jpeg.encode(thumbnailImageData,90).data.toString('base64');cachedThumbnails.set(frameForTimestamp,base64Data);thumbnails.push({timing:Math.round(targetTimestamp-speedline.beginning),timestamp:targetTimestamp*1000,data:base64Data});}
return{score:1,rawValue:thumbnails.length>0,details:{type:'filmstrip',scale:timelineEnd,items:thumbnails}};}}
module.exports=ScreenshotThumbnails;},{"../lib/errors":33,"./audit":2,"jpeg-js":140}],"../audits/seo/canonical":[function(require,module,exports){'use strict';const Audit=require('../audit');const LinkHeader=require('http-link-header');const URL=require('../../lib/url-shim');const LINK_HEADER='link';function getCanonicalLinksFromHeader(headerValue){const linkHeader=LinkHeader.parse(headerValue);return linkHeader.get('rel','canonical').map(c=>c.uri);}
function getHreflangsFromHeader(headerValue){const linkHeader=LinkHeader.parse(headerValue);return linkHeader.get('rel','alternate').map(h=>h.uri);}
function isValidRelativeOrAbsoluteURL(url){try{new URL(url,'https://example.com/');return true;}catch(e){return false;}}
function getPrimaryDomain(url){return url.hostname.split('.').slice(-2).join('.');}
class Canonical extends Audit{static get meta(){return{name:'canonical',description:'Document has a valid `rel=canonical`',failureDescription:'Document does not have a valid `rel=canonical`',helpText:'Canonical links suggest which URL to show in search results. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/canonical).',requiredArtifacts:['Canonical','Hreflang','URL']};}
static audit(artifacts){const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];return artifacts.requestMainResource({devtoolsLog,URL:artifacts.URL}).then(mainResource=>{const baseURL=new URL(mainResource.url);let canonicals=[];let hreflangs=[];mainResource._responseHeaders&&mainResource._responseHeaders.filter(h=>h.name.toLowerCase()===LINK_HEADER).forEach(h=>{canonicals=canonicals.concat(getCanonicalLinksFromHeader(h.value));hreflangs=hreflangs.concat(getHreflangsFromHeader(h.value));});for(const canonical of artifacts.Canonical){if(canonical!==null){canonicals.push(canonical);}}
canonicals=Array.from(new Set(canonicals));artifacts.Hreflang.forEach(({href})=>hreflangs.push(href));hreflangs=hreflangs.filter(href=>isValidRelativeOrAbsoluteURL(href)).map(href=>new URL(href,baseURL).href);if(canonicals.length===0){return{rawValue:true,notApplicable:true};}
if(canonicals.length>1){return{rawValue:false,explanation:`Multiple conflicting URLs (${canonicals.join(', ')})`};}
const canonical=canonicals[0];if(!isValidRelativeOrAbsoluteURL(canonical)){return{rawValue:false,explanation:`Invalid URL (${canonical})`};}
if(!URL.isValid(canonical)){return{rawValue:false,explanation:`Relative URL (${canonical})`};}
const canonicalURL=new URL(canonical);if(hreflangs.includes(baseURL.href)&&hreflangs.includes(canonicalURL.href)&&baseURL.href!==canonicalURL.href){return{rawValue:false,explanation:`Points to another hreflang location (${baseURL.href})`};}
if(getPrimaryDomain(canonicalURL)!==getPrimaryDomain(baseURL)){return{rawValue:false,explanation:`Points to a different domain (${canonicalURL})`};}
if(canonicalURL.origin===baseURL.origin&&canonicalURL.pathname==='/'&&baseURL.pathname!=='/'){return{rawValue:false,explanation:'Points to a root of the same origin'};}
return{rawValue:true};});}}
module.exports=Canonical;},{"../../lib/url-shim":"url","../audit":2,"http-link-header":137}],"../audits/seo/font-size":[function(require,module,exports){'use strict';const URL=require('../../lib/url-shim');const Audit=require('../audit');const ViewportAudit=require('../viewport');const WebInspector=require('../../lib/web-inspector');const CSSStyleDeclaration=WebInspector.CSSStyleDeclaration;const MINIMAL_PERCENTAGE_OF_LEGIBLE_TEXT=60;function getUniqueFailingRules(fontSizeArtifact){const failingRules=new Map();fontSizeArtifact.forEach(({cssRule,fontSize,textLength,node})=>{const artifactId=getFontArtifactId(cssRule,node);const failingRule=failingRules.get(artifactId);if(!failingRule){failingRules.set(artifactId,{node,cssRule,fontSize,textLength});}else{failingRule.textLength+=textLength;}});return[...failingRules.values()];}
function getAttributeMap(attributes=[]){const map=new Map();for(let i=0;i<attributes.length;i+=2){const name=attributes[i].toLowerCase();const value=attributes[i+1].trim();if(value){map.set(name,value);}}
return map;}
function getSelector(node){const attributeMap=getAttributeMap(node.attributes);if(attributeMap.has('id')){return'#'+attributeMap.get('id');}else{const attrClass=attributeMap.get('class');if(attrClass){return'.'+attrClass.split(/\s+/).join('.');}}
return node.localName.toLowerCase();}
function nodeToTableNode(node){const attributes=node.attributes||[];const attributesString=attributes.map((value,idx)=>idx%2===0?` ${value}`:`="${value}"`).join('');return{type:'node',selector:node.parentNode?getSelector(node.parentNode):'',snippet:`<${node.localName}${attributesString}>`};}
function findStyleRuleSource(baseURL,styleDeclaration,node){if(!styleDeclaration||styleDeclaration.type===CSSStyleDeclaration.Type.Attributes||styleDeclaration.type===CSSStyleDeclaration.Type.Inline)
{return{selector:nodeToTableNode(node),source:baseURL};}
if(styleDeclaration.parentRule&&styleDeclaration.parentRule.origin==='user-agent'){return{selector:styleDeclaration.parentRule.selectors.map(item=>item.text).join(', '),source:'User Agent Stylesheet'};}
if(styleDeclaration.type===CSSStyleDeclaration.Type.Regular&&styleDeclaration.parentRule){const rule=styleDeclaration.parentRule;const stylesheet=styleDeclaration.stylesheet;if(stylesheet){let source;const selector=rule.selectors.map(item=>item.text).join(', ');if(stylesheet.sourceURL){const url=new URL(stylesheet.sourceURL,baseURL);const range=styleDeclaration.range;source=`${url.href}`;if(range){const absoluteStartLine=range.startLine+stylesheet.startLine+1;const absoluteStartColumn=range.startColumn+stylesheet.startColumn+1;source+=`:${absoluteStartLine}:${absoluteStartColumn}`;}}else{source='dynamic';}
return{selector,source};}}
return{selector:'',source:'Unknown'};}
function getFontArtifactId(styleDeclaration,node){if(styleDeclaration&&styleDeclaration.type===CSSStyleDeclaration.Type.Regular){const startLine=styleDeclaration.range?styleDeclaration.range.startLine:0;const startColumn=styleDeclaration.range?styleDeclaration.range.startColumn:0;return`${styleDeclaration.styleSheetId}@${startLine}:${startColumn}`;}else{return`node_${node.nodeId}`;}}
class FontSize extends Audit{static get meta(){return{name:'font-size',description:'Document uses legible font sizes',failureDescription:'Document doesn\'t use legible font sizes',helpText:'Font sizes less than 12px are too small to be legible and require mobile '+'visitors to “pinch to zoom” in order to read. Strive to have >60% of page text ≥12px. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/font-sizes).',requiredArtifacts:['FontSize','URL','Viewport']};}
static audit(artifacts){const hasViewportSet=ViewportAudit.audit(artifacts).rawValue;if(!hasViewportSet){return{rawValue:false,explanation:'Text is illegible because of a missing viewport config'};}
const{analyzedFailingNodesData,analyzedFailingTextLength,failingTextLength,visitedTextLength,totalTextLength}=artifacts.FontSize;if(totalTextLength===0){return{rawValue:true};}
const failingRules=getUniqueFailingRules(analyzedFailingNodesData);const percentageOfPassingText=(visitedTextLength-failingTextLength)/visitedTextLength*100;const pageUrl=artifacts.URL.finalUrl;const headings=[{key:'source',itemType:'url',text:'Source'},{key:'selector',itemType:'code',text:'Selector'},{key:'coverage',itemType:'text',text:'% of Page Text'},{key:'fontSize',itemType:'text',text:'Font Size'}];const tableData=failingRules.sort((a,b)=>b.textLength-a.textLength).map(({cssRule,textLength,fontSize,node})=>{const percentageOfAffectedText=textLength/visitedTextLength*100;const origin=findStyleRuleSource(pageUrl,cssRule,node);return{source:origin.source,selector:origin.selector,coverage:`${percentageOfAffectedText.toFixed(2)}%`,fontSize:`${fontSize}px`};});if(analyzedFailingTextLength<failingTextLength){const percentageOfUnanalyzedFailingText=(failingTextLength-analyzedFailingTextLength)/visitedTextLength*100;tableData.push({source:'Add\'l illegible text',selector:'',coverage:`${percentageOfUnanalyzedFailingText.toFixed(2)}%`,fontSize:'< 12px'});}
if(percentageOfPassingText>0){tableData.push({source:'Legible text',selector:'',coverage:`${percentageOfPassingText.toFixed(2)}%`,fontSize:'≥ 12px'});}
const displayValue=['%.1d% legible text',percentageOfPassingText];const details=Audit.makeTableDetails(headings,tableData);const passed=percentageOfPassingText>=MINIMAL_PERCENTAGE_OF_LEGIBLE_TEXT;let explanation;if(!passed){const percentageOfFailingText=parseFloat((100-percentageOfPassingText).toFixed(2));let disclaimer='';if(visitedTextLength<totalTextLength){const percentageOfVisitedText=visitedTextLength/totalTextLength*100;disclaimer=` (based on ${percentageOfVisitedText.toFixed()}% sample)`;}
explanation=`${percentageOfFailingText}% of text is too small${disclaimer}.`;}
return{rawValue:passed,details,displayValue,explanation};}}
module.exports=FontSize;},{"../../lib/url-shim":"url","../../lib/web-inspector":47,"../audit":2,"../viewport":"../audits/viewport"}],"../audits/seo/hreflang":[function(require,module,exports){(function(global){'use strict';const Audit=require('../audit');const LinkHeader=require('http-link-header');const VALID_LANGS=importValidLangs();const LINK_HEADER='link';const NO_LANGUAGE='x-default';function importValidLangs(){const axeCache=global.axe;global.axe={utils:{}};require('axe-core/lib/commons/utils/valid-langs.js');const validLangs=global.axe.utils.validLangs();global.axe=axeCache;return validLangs;}
function isValidHreflang(hreflang){if(hreflang.toLowerCase()===NO_LANGUAGE){return true;}
const[lang]=hreflang.split('-');return VALID_LANGS.includes(lang.toLowerCase());}
function headerHasValidHreflangs(headerValue){const linkHeader=LinkHeader.parse(headerValue);return linkHeader.get('rel','alternate').every(link=>!!link.hreflang&&isValidHreflang(link.hreflang));}
class Hreflang extends Audit{static get meta(){return{name:'hreflang',description:'Document has a valid `hreflang`',failureDescription:'Document doesn\'t have a valid `hreflang`',helpText:'hreflang links tell search engines what version of a page they should '+'list in search results for a given language or region. [Learn more]'+'(https://developers.google.com/web/tools/lighthouse/audits/hreflang).',requiredArtifacts:['Hreflang','URL']};}
static audit(artifacts){const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const URL=artifacts.URL;return artifacts.requestMainResource({devtoolsLog,URL}).then(mainResource=>{const invalidHreflangs=[];if(artifacts.Hreflang){artifacts.Hreflang.forEach(({href,hreflang})=>{if(!isValidHreflang(hreflang)){invalidHreflangs.push({source:{type:'node',snippet:`<link name="alternate" hreflang="${hreflang}" href="${href}" />`}});}});}
mainResource._responseHeaders&&mainResource._responseHeaders.filter(h=>h.name.toLowerCase()===LINK_HEADER&&!headerHasValidHreflangs(h.value)).forEach(h=>invalidHreflangs.push({source:`${h.name}: ${h.value}`}));const headings=[{key:'source',itemType:'code',text:'Source'}];const details=Audit.makeTableDetails(headings,invalidHreflangs);return{rawValue:invalidHreflangs.length===0,details};});}}
module.exports=Hreflang;}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"../audit":2,"axe-core/lib/commons/utils/valid-langs.js":98,"http-link-header":137}],"../audits/seo/http-status-code":[function(require,module,exports){'use strict';const Audit=require('../audit');const HTTP_UNSUCCESSFUL_CODE_LOW=400;const HTTP_UNSUCCESSFUL_CODE_HIGH=599;class HTTPStatusCode extends Audit{static get meta(){return{name:'http-status-code',description:'Page has successful HTTP status code',failureDescription:'Page has unsuccessful HTTP status code',helpText:'Pages with unsuccessful HTTP status codes may not be indexed properly. '+'[Learn more]'+'(https://developers.google.com/web/tools/lighthouse/audits/successful-http-code).',requiredArtifacts:['devtoolsLogs','URL']};}
static audit(artifacts){const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const URL=artifacts.URL;return artifacts.requestMainResource({devtoolsLog,URL}).then(mainResource=>{const statusCode=mainResource.statusCode;if(statusCode>=HTTP_UNSUCCESSFUL_CODE_LOW&&statusCode<=HTTP_UNSUCCESSFUL_CODE_HIGH){return{rawValue:false,displayValue:`${statusCode}`};}
return{rawValue:true};});}}
module.exports=HTTPStatusCode;},{"../audit":2}],"../audits/seo/is-crawlable":[function(require,module,exports){'use strict';const Audit=require('../audit');const robotsParser=require('robots-parser');const URL=require('../../lib/url-shim');const BLOCKLIST=new Set(['noindex','none']);const ROBOTS_HEADER='x-robots-tag';const UNAVAILABLE_AFTER='unavailable_after';function isUnavailable(directive){const parts=directive.split(':');if(parts.length<=1||parts[0]!==UNAVAILABLE_AFTER){return false;}
const date=Date.parse(parts.slice(1).join(':'));return!isNaN(date)&&date<Date.now();}
function hasBlockingDirective(directives){return directives.split(',').map(d=>d.toLowerCase().trim()).some(d=>BLOCKLIST.has(d)||isUnavailable(d));}
function hasUserAgent(directives){const parts=directives.match(/^([^,:]+):/);return!!parts&&parts[1].toLowerCase()!==UNAVAILABLE_AFTER;}
class IsCrawlable extends Audit{static get meta(){return{name:'is-crawlable',description:'Page isn’t blocked from indexing',failureDescription:'Page is blocked from indexing',helpText:'Search engines are unable to include your pages in search results '+'if they don\'t have permission to crawl them. [Learn '+'more](https://developers.google.com/web/tools/lighthouse/audits/indexing).',requiredArtifacts:['MetaRobots','RobotsTxt','URL']};}
static audit(artifacts){const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];return artifacts.requestMainResource({devtoolsLog,URL:artifacts.URL}).then(mainResource=>{const blockingDirectives=[];if(artifacts.MetaRobots){const isBlocking=hasBlockingDirective(artifacts.MetaRobots);if(isBlocking){blockingDirectives.push({source:{type:'node',snippet:`<meta name="robots" content="${artifacts.MetaRobots}" />`}});}}
mainResource._responseHeaders&&mainResource._responseHeaders.filter(h=>h.name.toLowerCase()===ROBOTS_HEADER&&!hasUserAgent(h.value)&&hasBlockingDirective(h.value)).forEach(h=>blockingDirectives.push({source:`${h.name}: ${h.value}`}));if(artifacts.RobotsTxt.content){const robotsFileUrl=new URL('/robots.txt',mainResource.url);const robotsTxt=robotsParser(robotsFileUrl.href,artifacts.RobotsTxt.content);if(!robotsTxt.isAllowed(mainResource.url)){blockingDirectives.push({source:{type:'url',value:robotsFileUrl.href}});}}
const headings=[{key:'source',itemType:'code',text:'Blocking Directive Source'}];const details=Audit.makeTableDetails(headings,blockingDirectives);return{rawValue:blockingDirectives.length===0,details};});}}
module.exports=IsCrawlable;},{"../../lib/url-shim":"url","../audit":2,"robots-parser":149}],"../audits/seo/link-text":[function(require,module,exports){'use strict';const Audit=require('../audit');const URL=require('../../lib/url-shim');const BLOCKLIST=new Set(['click here','click this','go','here','this','start','right here','more','learn more']);class LinkText extends Audit{static get meta(){return{name:'link-text',description:'Links have descriptive text',failureDescription:'Links do not have descriptive text',helpText:'Descriptive link text helps search engines understand your content. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/descriptive-link-text).',requiredArtifacts:['URL','CrawlableLinks']};}
static audit(artifacts){const failingLinks=artifacts.CrawlableLinks.filter(link=>{if(link.href.toLowerCase().startsWith('javascript:')||URL.equalWithExcludedFragments(link.href,artifacts.URL.finalUrl))
{return false;}
return BLOCKLIST.has(link.text.trim().toLowerCase());});const headings=[{key:'href',itemType:'url',text:'Link destination'},{key:'text',itemType:'text',text:'Link Text'}];const details=Audit.makeTableDetails(headings,failingLinks,{});let displayValue;if(failingLinks.length){displayValue=failingLinks.length>1?`${failingLinks.length} links found`:'1 link found';}
return{rawValue:failingLinks.length===0,details,displayValue};}}
module.exports=LinkText;},{"../../lib/url-shim":"url","../audit":2}],"../audits/seo/manual/mobile-friendly":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class MobileFriendly extends ManualAudit{static get meta(){return Object.assign({name:'mobile-friendly',helpText:'Take the [Mobile-Friendly Test](https://search.google.com/test/mobile-friendly) to check for audits not covered by Lighthouse, like sizing tap targets appropriately. [Learn more](https://developers.google.com/search/mobile-sites/).',description:'Page is mobile friendly'},super.partialMeta);}}
module.exports=MobileFriendly;},{"../../manual/manual-audit":4}],"../audits/seo/manual/structured-data":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class StructuredData extends ManualAudit{static get meta(){return Object.assign({name:'structured-data',helpText:'Run the [Structured Data Testing Tool](https://search.google.com/structured-data/testing-tool/) and the [Structured Data Linter](http://linter.structured-data.org/) to validate structured data. [Learn more](https://developers.google.com/search/docs/guides/mark-up-content).',description:'Structured data is valid'},super.partialMeta);}}
module.exports=StructuredData;},{"../../manual/manual-audit":4}],"../audits/seo/meta-description":[function(require,module,exports){'use strict';const Audit=require('../audit');class Description extends Audit{static get meta(){return{name:'meta-description',description:'Document has a meta description',failureDescription:'Document does not have a meta description',helpText:'Meta descriptions may be included in search results to concisely summarize '+'page content. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/description).',requiredArtifacts:['MetaDescription']};}
static audit(artifacts){if(artifacts.MetaDescription===null){return{rawValue:false};}
if(artifacts.MetaDescription.trim().length===0){return{rawValue:false,explanation:'Description text is empty.'};}
return{rawValue:true};}}
module.exports=Description;},{"../audit":2}],"../audits/seo/plugins":[function(require,module,exports){'use strict';const Audit=require('../audit');const URL=require('../../lib/url-shim');const JAVA_APPLET_TYPE='application/x-java-applet';const JAVA_BEAN_TYPE='application/x-java-bean';const TYPE_BLOCKLIST=new Set(['application/x-shockwave-flash',JAVA_APPLET_TYPE,JAVA_BEAN_TYPE,'application/x-silverlight','application/x-silverlight-2']);const FILE_EXTENSION_BLOCKLIST=new Set(['swf','flv','class','xap']);const SOURCE_PARAMS=new Set(['code','movie','source','src']);function isPluginType(type){type=type.trim().toLowerCase();return TYPE_BLOCKLIST.has(type)||type.startsWith(JAVA_APPLET_TYPE)||type.startsWith(JAVA_BEAN_TYPE);}
function isPluginURL(url){try{const filePath=new URL(url,'http://example.com').pathname;const parts=filePath.split('.');if(parts.length<2){return false;}
const part=parts.pop();return FILE_EXTENSION_BLOCKLIST.has(part.trim().toLowerCase());}catch(e){return false;}}
class Plugins extends Audit{static get meta(){return{name:'plugins',description:'Document avoids plugins',failureDescription:'Document uses plugins',helpText:'Search engines can\'t index plugin content, and '+'many devices restrict plugins or don\'t support them. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/plugins).',requiredArtifacts:['EmbeddedContent']};}
static audit(artifacts){const plugins=artifacts.EmbeddedContent.filter(item=>{if(item.tagName==='APPLET'){return true;}
if((item.tagName==='EMBED'||item.tagName==='OBJECT')&&item.type&&isPluginType(item.type))
{return true;}
const embedSrc=item.src||item.code;if(item.tagName==='EMBED'&&embedSrc&&isPluginURL(embedSrc)){return true;}
if(item.tagName==='OBJECT'&&item.data&&isPluginURL(item.data)){return true;}
const failingParams=item.params.filter(param=>SOURCE_PARAMS.has(param.name.trim().toLowerCase())&&isPluginURL(param.value));return failingParams.length>0;}).map(plugin=>{const tagName=plugin.tagName.toLowerCase();const attributeKeys=['src','data','code','type'];const attributes=attributeKeys.reduce((result,attr)=>{if(plugin[attr]!==null){result+=` ${attr}="${plugin[attr]}"`;}
return result;},'');const params=plugin.params.filter(param=>SOURCE_PARAMS.has(param.name.trim().toLowerCase())).map(param=>`<param ${param.name}="${param.value}" />`).join('');return{source:{type:'node',snippet:`<${tagName}${attributes}>${params}</${tagName}>`}};});const headings=[{key:'source',itemType:'code',text:'Element source'}];const details=Audit.makeTableDetails(headings,plugins);return{rawValue:plugins.length===0,details};}}
module.exports=Plugins;},{"../../lib/url-shim":"url","../audit":2}],"../audits/seo/robots-txt":[function(require,module,exports){'use strict';const Audit=require('../audit');const URL=require('../../lib/url-shim');const HTTP_CLIENT_ERROR_CODE_LOW=400;const HTTP_SERVER_ERROR_CODE_LOW=500;const DIRECTIVE_SITEMAP='sitemap';const DIRECTIVE_USER_AGENT='user-agent';const DIRECTIVE_ALLOW='allow';const DIRECTIVE_DISALLOW='disallow';const DIRECTIVES_GROUP_MEMBERS=new Set([DIRECTIVE_ALLOW,DIRECTIVE_DISALLOW]);const DIRECTIVE_SAFELIST=new Set([DIRECTIVE_USER_AGENT,DIRECTIVE_DISALLOW,DIRECTIVE_ALLOW,DIRECTIVE_SITEMAP,'crawl-delay','clean-param','host','request-rate','visit-time','noindex']);const SITEMAP_VALID_PROTOCOLS=new Set(['https:','http:','ftp:']);function verifyDirective(directiveName,directiveValue){if(!DIRECTIVE_SAFELIST.has(directiveName)){throw new Error('Unknown directive');}
if(directiveName===DIRECTIVE_SITEMAP){let sitemapUrl;try{sitemapUrl=new URL(directiveValue);}catch(e){throw new Error('Invalid sitemap URL');}
if(!SITEMAP_VALID_PROTOCOLS.has(sitemapUrl.protocol)){throw new Error('Invalid sitemap URL protocol');}}
if(directiveName===DIRECTIVE_USER_AGENT&&!directiveValue){throw new Error('No user-agent specified');}
if(directiveName===DIRECTIVE_ALLOW||directiveName===DIRECTIVE_DISALLOW){if(directiveValue!==''&&directiveValue[0]!=='/'&&directiveValue[0]!=='*'){throw new Error('Pattern should either be empty, start with "/" or "*"');}
const dollarIndex=directiveValue.indexOf('$');if(dollarIndex!==-1&&dollarIndex!==directiveValue.length-1){throw new Error('"$" should only be used at the end of the pattern');}}}
function parseLine(line){const hashIndex=line.indexOf('#');if(hashIndex!==-1){line=line.substr(0,hashIndex);}
line=line.trim();if(line.length===0){return null;}
const colonIndex=line.indexOf(':');if(colonIndex===-1){throw new Error('Syntax not understood');}
const directiveName=line.slice(0,colonIndex).trim().toLowerCase();const directiveValue=line.slice(colonIndex+1).trim();verifyDirective(directiveName,directiveValue);return{directive:directiveName,value:directiveValue};}
function validateRobots(content){const errors=[];let inGroup=false;content.split(/\r\n|\r|\n/).forEach((line,index)=>{let parsedLine;try{parsedLine=parseLine(line);}catch(e){errors.push({index:(index+1).toString(),line:line,message:e.message.toString()});}
if(!parsedLine){return;}
if(parsedLine.directive===DIRECTIVE_USER_AGENT){inGroup=true;}else if(!inGroup&&DIRECTIVES_GROUP_MEMBERS.has(parsedLine.directive)){errors.push({index:(index+1).toString(),line:line,message:'No user-agent specified'});}});return errors;}
class RobotsTxt extends Audit{static get meta(){return{name:'robots-txt',description:'robots.txt is valid',failureDescription:'robots.txt is not valid',helpText:'If your robots.txt file is malformed, crawlers may not be able to understand '+'how you want your website to be crawled or indexed.',requiredArtifacts:['RobotsTxt']};}
static audit(artifacts){const{status,content}=artifacts.RobotsTxt;if(!status){return{rawValue:false,explanation:'Lighthouse was unable to download your robots.txt file'};}
if(status>=HTTP_SERVER_ERROR_CODE_LOW){return{rawValue:false,displayValue:`request for robots.txt returned HTTP${status}`};}else if(status>=HTTP_CLIENT_ERROR_CODE_LOW||content===''){return{rawValue:true,notApplicable:true};}
if(content===null){throw new Error(`Status ${status} was valid, but content was null`);}
const validationErrors=validateRobots(content);const headings=[{key:'index',itemType:'text',text:'Line #'},{key:'line',itemType:'code',text:'Content'},{key:'message',itemType:'code',text:'Error'}];const details=Audit.makeTableDetails(headings,validationErrors,{});let displayValue;if(validationErrors.length){displayValue=validationErrors.length>1?`${validationErrors.length} errors found`:'1 error found';}
return{rawValue:validationErrors.length===0,details,displayValue};}}
module.exports=RobotsTxt;},{"../../lib/url-shim":"url","../audit":2}],"../audits/service-worker":[function(require,module,exports){'use strict';const URL=require('../lib/url-shim');const Audit=require('./audit');class ServiceWorker extends Audit{static get meta(){return{name:'service-worker',description:'Registers a service worker',failureDescription:'Does not register a service worker',helpText:'The service worker is the technology that enables your app to use many '+'Progressive Web App features, such as offline, add to homescreen, and push '+'notifications. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/registered-service-worker).',requiredArtifacts:['URL','ServiceWorker']};}
static audit(artifacts){const versions=artifacts.ServiceWorker.versions;const url=artifacts.URL.finalUrl;const origin=new URL(url).origin;const matchingSW=versions.filter(v=>v.status==='activated').find(v=>new URL(v.scriptURL).origin===origin);return{rawValue:!!matchingSW};}}
module.exports=ServiceWorker;},{"../lib/url-shim":"url","./audit":2}],"../audits/speed-index":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/html/renderer/util');class SpeedIndex extends Audit{static get meta(){return{name:'speed-index',description:'Speed Index',helpText:'Speed Index shows how quickly the contents of a page are visibly populated. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/speed-index).',scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces','devtoolsLogs']};}
static get defaultOptions(){return{scorePODR:2900,scoreMedian:5800};}
static async audit(artifacts,context){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const metricComputationData={trace,devtoolsLog,settings:context.settings};const metricResult=await artifacts.requestSpeedIndex(metricComputationData);return{score:Audit.computeLogNormalScore(metricResult.timing,context.options.scorePODR,context.options.scoreMedian),rawValue:metricResult.timing,displayValue:[Util.MS_DISPLAY_VALUE,metricResult.timing]};}}
module.exports=SpeedIndex;},{"../report/html/renderer/util":48,"./audit":2}],"../audits/splash-screen":[function(require,module,exports){'use strict';const MultiCheckAudit=require('./multi-check-audit');class SplashScreen extends MultiCheckAudit{static get meta(){return{name:'splash-screen',description:'Configured for a custom splash screen',failureDescription:'Is not configured for a custom splash screen',helpText:'A themed splash screen ensures a high-quality experience when '+'users launch your app from their homescreens. [Learn '+'more](https://developers.google.com/web/tools/lighthouse/audits/custom-splash-screen).',requiredArtifacts:['Manifest']};}
static assessManifest(manifestValues,failures){if(manifestValues.isParseFailure&&manifestValues.parseFailureReason){failures.push(manifestValues.parseFailureReason);return;}
const splashScreenCheckIds=['hasName','hasBackgroundColor','hasThemeColor','hasIconsAtLeast512px'];manifestValues.allChecks.filter(item=>splashScreenCheckIds.includes(item.id)).forEach(item=>{if(!item.passing){failures.push(item.failureText);}});}
static audit_(artifacts){const failures=[];return artifacts.requestManifestValues(artifacts.Manifest).then(manifestValues=>{SplashScreen.assessManifest(manifestValues,failures);return{failures,manifestValues};});}}
module.exports=SplashScreen;},{"./multi-check-audit":5}],"../audits/themed-omnibox":[function(require,module,exports){'use strict';const MultiCheckAudit=require('./multi-check-audit');const validColor=require('../lib/web-inspector').Color.parse;class ThemedOmnibox extends MultiCheckAudit{static get meta(){return{name:'themed-omnibox',description:'Address bar matches brand colors',failureDescription:'Address bar does not match brand colors',helpText:'The browser address bar can be themed to match your site. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/address-bar).',requiredArtifacts:['Manifest','ThemeColor']};}
static assessMetaThemecolor(themeColorMeta,failures){if(themeColorMeta===null){failures.push('No `<meta name="theme-color">` tag found');}else if(!validColor(themeColorMeta)){failures.push('The theme-color meta tag did not contain a valid CSS color');}}
static assessManifest(manifestValues,failures){if(manifestValues.isParseFailure&&manifestValues.parseFailureReason){failures.push(manifestValues.parseFailureReason);return;}
const themeColorCheck=manifestValues.allChecks.find(i=>i.id==='hasThemeColor');if(themeColorCheck&&!themeColorCheck.passing){failures.push(themeColorCheck.failureText);}}
static audit_(artifacts){const failures=[];return artifacts.requestManifestValues(artifacts.Manifest).then(manifestValues=>{ThemedOmnibox.assessManifest(manifestValues,failures);ThemedOmnibox.assessMetaThemecolor(artifacts.ThemeColor,failures);return{failures,manifestValues,themeColor:artifacts.ThemeColor};});}}
module.exports=ThemedOmnibox;},{"../lib/web-inspector":47,"./multi-check-audit":5}],"../audits/time-to-first-byte":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/html/renderer/util');const TTFB_THRESHOLD=600;class TTFBMetric extends Audit{static get meta(){return{name:'time-to-first-byte',description:'Keep server response times low (TTFB)',helpText:'Time To First Byte identifies the time at which your server sends a response.'+' [Learn more](https://developers.google.com/web/tools/chrome-devtools/network-performance/issues).',requiredArtifacts:['devtoolsLogs','URL']};}
static caclulateTTFB(record){const timing=record._timing;return timing.receiveHeadersEnd-timing.sendEnd;}
static audit(artifacts){const devtoolsLogs=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];return artifacts.requestNetworkRecords(devtoolsLogs).then(networkRecords=>{let displayValue='';const finalUrl=artifacts.URL.finalUrl;const finalUrlRequest=networkRecords.find(record=>record._url===finalUrl);if(!finalUrlRequest){throw new Error(`finalUrl '${finalUrl} not found in network records.`);}
const ttfb=TTFBMetric.caclulateTTFB(finalUrlRequest);const passed=ttfb<TTFB_THRESHOLD;if(!passed){displayValue=`Root document took ${Util.formatMilliseconds(ttfb,1)} `;}
return{rawValue:ttfb,score:Number(passed),displayValue,details:{summary:{wastedMs:ttfb-TTFB_THRESHOLD}},extendedInfo:{value:{wastedMs:ttfb-TTFB_THRESHOLD}}};});}}
module.exports=TTFBMetric;},{"../report/html/renderer/util":48,"./audit":2}],"../audits/user-timings":[function(require,module,exports){'use strict';const Audit=require('./audit');class UserTimings extends Audit{static get meta(){return{name:'user-timings',scoreDisplayMode:Audit.SCORING_MODES.INFORMATIVE,description:'User Timing marks and measures',helpText:'Consider instrumenting your app with the User Timing API to create custom, '+'real-world measurements of key user experiences. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/user-timing).',requiredArtifacts:['traces']};}
static filterTrace(tabTrace){const userTimings=[];const measuresStartTimes={};tabTrace.processEvents.filter(evt=>{if(!evt.cat.includes('blink.user_timing')){return false;}
return evt.name!=='requestStart'&&evt.name!=='navigationStart'&&evt.name!=='paintNonDefaultBackgroundColor'&&evt.args.frame===undefined;}).forEach(ut=>{if(ut.ph==='R'||ut.ph.toUpperCase()==='I'){userTimings.push({name:ut.name,isMark:true,args:ut.args,startTime:ut.ts});}else if(ut.ph.toLowerCase()==='b'){measuresStartTimes[ut.name]=ut.ts;}else if(ut.ph.toLowerCase()==='e'){userTimings.push({name:ut.name,isMark:false,args:ut.args,startTime:measuresStartTimes[ut.name],endTime:ut.ts,duration:ut.ts-measuresStartTimes[ut.name]});}});userTimings.forEach(ut=>{ut.startTime=(ut.startTime-tabTrace.navigationStartEvt.ts)/1000;if(!ut.isMark){ut.endTime=(ut.endTime-tabTrace.navigationStartEvt.ts)/1000;ut.duration=ut.duration/1000;}});return userTimings;}
static get blacklistedPrefixes(){return['goog_'];}
static excludeBlacklisted(evt){return UserTimings.blacklistedPrefixes.every(prefix=>!evt.name.startsWith(prefix));}
static audit(artifacts){const trace=artifacts.traces[Audit.DEFAULT_PASS];return artifacts.requestTraceOfTab(trace).then(tabTrace=>{const userTimings=this.filterTrace(tabTrace).filter(UserTimings.excludeBlacklisted);const tableRows=userTimings.map(item=>{const time=item.isMark?item.startTime:item.duration;return{name:item.name,timingType:item.isMark?'Mark':'Measure',time};}).sort((itemA,itemB)=>{if(itemA.timingType===itemB.timingType){return itemA.time-itemB.time;}else if(itemA.timingType==='Measure'){return-1;}else{return 1;}});const headings=[{key:'name',itemType:'text',text:'Name'},{key:'timingType',itemType:'text',text:'Type'},{key:'time',itemType:'ms',granularity:0.01,text:'Time'}];const details=Audit.makeTableDetails(headings,tableRows);return{rawValue:userTimings.length===0,notApplicable:userTimings.length===0,displayValue:userTimings.length?`${userTimings.length}`:'',extendedInfo:{value:userTimings},details};});}}
module.exports=UserTimings;},{"./audit":2}],"../audits/uses-rel-preconnect":[function(require,module,exports){'use strict';const Audit=require('./audit');const UnusedBytes=require('./byte-efficiency/byte-efficiency-audit');const PRECONNECT_SOCKET_MAX_IDLE=15;const IGNORE_THRESHOLD_IN_MS=50;class UsesRelPreconnectAudit extends Audit{static get meta(){return{name:'uses-rel-preconnect',description:'Avoid multiple, costly round trips to any origin',helpText:'Consider adding preconnect or dns-prefetch resource hints to establish early '+`connections to important third-party origins. [Learn more](https://developers.google.com/web/fundamentals/performance/resource-prioritization#preconnect).`,requiredArtifacts:['devtoolsLogs','URL'],scoreDisplayMode:Audit.SCORING_MODES.NUMERIC};}
static hasValidTiming(record){return record._timing&&record._timing.connectEnd>0&&record._timing.connectStart>0;}
static hasAlreadyConnectedToOrigin(record){return(record._timing.dnsEnd-record._timing.dnsStart===0&&record._timing.connectEnd-record._timing.connectStart===0);}
static socketStartTimeIsBelowThreshold(record,mainResource){return Math.max(0,record.startTime-mainResource.endTime)<PRECONNECT_SOCKET_MAX_IDLE;}
static async audit(artifacts,context){const devtoolsLog=artifacts.devtoolsLogs[UsesRelPreconnectAudit.DEFAULT_PASS];const URL=artifacts.URL;const settings=context.settings;let maxWasted=0;const[networkRecords,mainResource,loadSimulator]=await Promise.all([artifacts.requestNetworkRecords(devtoolsLog),artifacts.requestMainResource({devtoolsLog,URL}),artifacts.requestLoadSimulator({devtoolsLog,settings})]);const{rtt,additionalRttByOrigin}=loadSimulator.getOptions();const origins=new Map();networkRecords.forEach(record=>{if(!UsesRelPreconnectAudit.hasValidTiming(record)||record.initiatorRequest()===mainResource||!record.parsedURL||!record.parsedURL.securityOrigin()||mainResource.parsedURL.securityOrigin()===record.parsedURL.securityOrigin()||UsesRelPreconnectAudit.hasAlreadyConnectedToOrigin(record)||!UsesRelPreconnectAudit.socketStartTimeIsBelowThreshold(record,mainResource))
{return;}
const securityOrigin=record.parsedURL.securityOrigin();const records=origins.get(securityOrigin)||[];records.push(record);origins.set(securityOrigin,records);});let results=[];origins.forEach(records=>{const firstRecordOfOrigin=records.reduce((firstRecord,record)=>{return record.startTime<firstRecord.startTime?record:firstRecord;});const securityOrigin=firstRecordOfOrigin.parsedURL.securityOrigin();const additionalRtt=additionalRttByOrigin.get(securityOrigin)||0;let connectionTime=rtt+additionalRtt;if(firstRecordOfOrigin.parsedURL.scheme==='https')connectionTime=connectionTime*2;const timeBetweenMainResourceAndDnsStart=firstRecordOfOrigin.startTime*1000-
mainResource.endTime*1000+
firstRecordOfOrigin._timing.dnsStart;const wastedMs=Math.min(connectionTime,timeBetweenMainResourceAndDnsStart);if(wastedMs<IGNORE_THRESHOLD_IN_MS)return;maxWasted=Math.max(wastedMs,maxWasted);results.push({url:securityOrigin,wastedMs:wastedMs});});results=results.sort((a,b)=>b.wastedMs-a.wastedMs);const headings=[{key:'url',itemType:'url',text:'Origin'},{key:'wastedMs',itemType:'ms',text:'Potential Savings'}];const summary={wastedMs:maxWasted};const details=Audit.makeTableDetails(headings,results,summary);return{score:UnusedBytes.scoreForWastedMs(maxWasted),rawValue:maxWasted,displayValue:['Potential savings of %10d\xa0ms',maxWasted],extendedInfo:{value:results},details};}}
module.exports=UsesRelPreconnectAudit;},{"./audit":2,"./byte-efficiency/byte-efficiency-audit":3}],"../audits/uses-rel-preload":[function(require,module,exports){'use strict';const Audit=require('./audit');const UnusedBytes=require('./byte-efficiency/byte-efficiency-audit');const THRESHOLD_IN_MS=100;class UsesRelPreloadAudit extends Audit{static get meta(){return{name:'uses-rel-preload',description:'Preload key requests',helpText:'Consider using <link rel=preload> to prioritize fetching late-discovered '+'resources sooner. [Learn more](https://developers.google.com/web/updates/2016/03/link-rel-preload).',requiredArtifacts:['devtoolsLogs','traces','URL'],scoreDisplayMode:Audit.SCORING_MODES.NUMERIC};}
static _flattenRequests(chains,maxLevel,minLevel=0){const requests=[];const flatten=(chains,level)=>{Object.keys(chains).forEach(chain=>{if(chains[chain]){const currentChain=chains[chain];if(level>=minLevel){requests.push(currentChain.request);}
if(level<maxLevel){flatten(currentChain.children,level+1);}}});};flatten(chains,0);return requests;}
static computeWasteWithGraph(urls,graph,simulator){if(!urls.size){return{wastedMs:0,results:[]};}
const simulationBeforeChanges=simulator.simulate(graph,{flexibleOrdering:true});const modifiedGraph=graph.cloneWithRelationships();const nodesToPreload=[];let mainDocumentNode=null;modifiedGraph.traverse(node=>{if(node.type!=='network')return;const networkNode=node;if(node.isMainDocument()){mainDocumentNode=networkNode;}else if(networkNode.record&&urls.has(networkNode.record.url)){nodesToPreload.push(networkNode);}});if(!mainDocumentNode){throw new Error('Could not find main document node');}
for(const node of nodesToPreload){node.removeAllDependencies();node.addDependency(mainDocumentNode);}
const simulationAfterChanges=simulator.simulate(modifiedGraph,{flexibleOrdering:true});const originalNodesByRecord=Array.from(simulationBeforeChanges.nodeTimings.keys()).reduce((map,node)=>map.set(node.record,node),new Map());const results=[];for(const node of nodesToPreload){const originalNode=originalNodesByRecord.get(node.record);const timingAfter=simulationAfterChanges.nodeTimings.get(node);const timingBefore=simulationBeforeChanges.nodeTimings.get(originalNode);const wastedMs=Math.round(timingBefore.endTime-timingAfter.endTime);if(wastedMs<THRESHOLD_IN_MS)continue;results.push({url:node.record.url,wastedMs});}
if(!results.length){return{wastedMs:0,results};}
return{wastedMs:Math.max(...results.map(item=>item.wastedMs)),results};}
static async audit(artifacts,context){const trace=artifacts.traces[UsesRelPreloadAudit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[UsesRelPreloadAudit.DEFAULT_PASS];const URL=artifacts.URL;const simulatorOptions={trace,devtoolsLog,settings:context.settings};const[critChains,mainResource,graph,simulator]=await Promise.all([artifacts.requestCriticalRequestChains({devtoolsLog,URL}),artifacts.requestMainResource({devtoolsLog,URL}),artifacts.requestPageDependencyGraph({trace,devtoolsLog}),artifacts.requestLoadSimulator(simulatorOptions)]);const mainResourceIndex=mainResource.redirects?mainResource.redirects.length:0;const criticalRequests=UsesRelPreloadAudit._flattenRequests(critChains,3+mainResourceIndex,2+mainResourceIndex);const urls=new Set();for(const networkRecord of criticalRequests){if(!networkRecord._isLinkPreload&&networkRecord.protocol!=='data'){urls.add(networkRecord._url);}}
const{results,wastedMs}=UsesRelPreloadAudit.computeWasteWithGraph(urls,graph,simulator);results.sort((a,b)=>b.wastedMs-a.wastedMs);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'wastedMs',itemType:'ms',text:'Potential Savings',granularity:10}];const summary={wastedMs};const details=Audit.makeTableDetails(headings,results,summary);return{score:UnusedBytes.scoreForWastedMs(wastedMs),rawValue:wastedMs,displayValue:['Potential savings of %10d\xa0ms',wastedMs],extendedInfo:{value:results},details};}}
module.exports=UsesRelPreloadAudit;},{"./audit":2,"./byte-efficiency/byte-efficiency-audit":3}],"../audits/viewport":[function(require,module,exports){'use strict';const Audit=require('./audit');const Parser=require('metaviewport-parser');class Viewport extends Audit{static get meta(){return{name:'viewport',description:'Has a `<meta name="viewport">` tag with `width` or `initial-scale`',failureDescription:'Does not have a `<meta name="viewport">` tag with `width` '+'or `initial-scale`',helpText:'Add a viewport meta tag to optimize your app for mobile screens. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/has-viewport-meta-tag).',requiredArtifacts:['Viewport']};}
static audit(artifacts){if(artifacts.Viewport===null){return{explanation:'No viewport meta tag found',rawValue:false};}
const warnings=[];const parsedProps=Parser.parseMetaViewPortContent(artifacts.Viewport);if(Object.keys(parsedProps.unknownProperties).length){warnings.push(`Invalid properties found: ${JSON.stringify(parsedProps.unknownProperties)}`);}
if(Object.keys(parsedProps.invalidValues).length){warnings.push(`Invalid values found: ${JSON.stringify(parsedProps.invalidValues)}`);}
const viewportProps=parsedProps.validProperties;const hasMobileViewport=viewportProps.width||viewportProps['initial-scale'];return{rawValue:!!hasMobileViewport,warnings};}}
module.exports=Viewport;},{"./audit":2,"metaviewport-parser":145}],"../audits/webapp-install-banner":[function(require,module,exports){'use strict';const MultiCheckAudit=require('./multi-check-audit');const SWAudit=require('./service-worker');class WebappInstallBanner extends MultiCheckAudit{static get meta(){return{name:'webapp-install-banner',description:'User can be prompted to Install the Web App',failureDescription:'User will not be prompted to Install the Web App',helpText:'Browsers can proactively prompt users to add your app to their homescreen, '+'which can lead to higher engagement. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/install-prompt).',requiredArtifacts:['URL','ServiceWorker','Manifest','StartUrl']};}
static assessManifest(manifestValues){if(manifestValues.isParseFailure&&manifestValues.parseFailureReason){return[manifestValues.parseFailureReason];}
const failures=[];const bannerCheckIds=['hasName','hasShortName','hasStartUrl','hasPWADisplayValue','hasIconsAtLeast192px'];manifestValues.allChecks.filter(item=>bannerCheckIds.includes(item.id)).forEach(item=>{if(!item.passing){failures.push(item.failureText);}});return failures;}
static assessServiceWorker(artifacts){const failures=[];const hasServiceWorker=SWAudit.audit(artifacts).rawValue;if(!hasServiceWorker){failures.push('Site does not register a service worker');}
return failures;}
static assessOfflineStartUrl(artifacts){const failures=[];const warnings=[];const hasOfflineStartUrl=artifacts.StartUrl.statusCode===200;if(!hasOfflineStartUrl){failures.push('Service worker does not successfully serve the manifest\'s start_url');if(artifacts.StartUrl.debugString){failures.push(artifacts.StartUrl.debugString);}}
if(artifacts.StartUrl.debugString){warnings.push(artifacts.StartUrl.debugString);}
return{failures,warnings};}
static audit_(artifacts){let offlineFailures=[];let offlineWarnings=[];return artifacts.requestManifestValues(artifacts.Manifest).then(manifestValues=>{const manifestFailures=WebappInstallBanner.assessManifest(manifestValues);const swFailures=WebappInstallBanner.assessServiceWorker(artifacts);if(!swFailures.length){const{failures,warnings}=WebappInstallBanner.assessOfflineStartUrl(artifacts);offlineFailures=failures;offlineWarnings=warnings;}
return{warnings:offlineWarnings,failures:[...manifestFailures,...swFailures,...offlineFailures],manifestValues};});}}
module.exports=WebappInstallBanner;},{"./multi-check-audit":5,"./service-worker":"../audits/service-worker"}],"../audits/without-javascript":[function(require,module,exports){'use strict';const Audit=require('./audit');class WithoutJavaScript extends Audit{static get meta(){return{name:'without-javascript',description:'Contains some content when JavaScript is not available',failureDescription:'Does not provide fallback content when JavaScript is not available',helpText:'Your app should display some content when JavaScript is disabled, even if it\'s '+'just a warning to the user that JavaScript is required to use the app. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/no-js).',requiredArtifacts:['HTMLWithoutJavaScript']};}
static audit(artifacts){const artifact=artifacts.HTMLWithoutJavaScript;if(artifact.value.trim()===''){return{rawValue:false,explanation:'The page body should render some content if its scripts are not available.'};}
return{rawValue:true};}}
module.exports=WithoutJavaScript;},{"./audit":2}],"../audits/works-offline":[function(require,module,exports){'use strict';const URL=require('../lib/url-shim');const Audit=require('./audit');class WorksOffline extends Audit{static get meta(){return{name:'works-offline',description:'Responds with a 200 when offline',failureDescription:'Does not respond with a 200 when offline',helpText:'If you\'re building a Progressive Web App, consider using a service worker so '+'that your app can work offline. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/http-200-when-offline).',requiredArtifacts:['Offline','URL']};}
static audit(artifacts){const warnings=[];const passed=artifacts.Offline===200;if(!passed&&!URL.equalWithExcludedFragments(artifacts.URL.requestedUrl,artifacts.URL.finalUrl)){warnings.push('You may be not loading offline because your test URL '+`(${artifacts.URL.requestedUrl}) was redirected to "${artifacts.URL.finalUrl}". `+'Try testing the second URL directly.');}
return{rawValue:passed,warnings};}}
module.exports=WorksOffline;},{"../lib/url-shim":"url","./audit":2}],"../gather/gatherers/accessibility":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');const axeLibSource="/*! aXe v3.0.0-beta.2\n * Copyright (c) 2018 Deque Systems, Inc.\n *\n * Your use of this Source Code Form is subject to the terms of the Mozilla Public\n * License, v. 2.0. If a copy of the MPL was not distributed with this\n * file, You can obtain one at http://mozilla.org/MPL/2.0/.\n *\n * This entire copyright notice must appear in every copy of this file you\n * distribute or in any file that contains substantial portions of this source\n * code.\n */\n!function a(window){function b(a){this.name=\"SupportError\",this.cause=a.cause,this.message=\"`\"+a.cause+\"` - feature unsupported in your environment.\",a.ruleId&&(this.ruleId=a.ruleId,this.message+=\" Skipping \"+this.ruleId+\" rule.\"),this.stack=(new Error).stack}function c(a){\"use strict\";var b;return a?(b=axe.utils.clone(a),b.commons=a.commons):b={},b.reporter=b.reporter||null,b.rules=b.rules||[],b.checks=b.checks||[],b.data=Object.assign({checks:{},rules:{}},b.data),b}function d(a,b,c){\"use strict\";var d,e;for(d=0,e=a.length;d<e;d++)b[c](a[d])}function e(a){this.brand=\"axe\",this.application=\"axeAPI\",this.tagExclude=[\"experimental\"],this.defaultConfig=a,this._init()}function f(a,b,c){var d=a.brand,e=a.application;return axe.constants.helpUrlBase+d+\"/\"+(c||axe.version.substring(0,axe.version.lastIndexOf(\".\")))+\"/\"+b+\"?application=\"+e}function g(a){\"use strict\";this.id=a.id,this.data=null,this.relatedNodes=[],this.result=null}function h(a){\"use strict\";return\"string\"==typeof a?new Function(\"return \"+a+\";\")():a}function i(a){a&&(this.id=a.id,this.configure(a))}function j(a,b){\"use strict\";if(!axe.utils.isHidden(b)){axe.utils.findBy(a,\"node\",b)||a.push({node:b,include:[],exclude:[]})}}function k(a,b,c){\"use strict\";a.frames=a.frames||[];var d,e,f=document.querySelectorAll(c.shift());a:for(var g=0,h=f.length;g<h;g++){e=f[g];for(var i=0,j=a.frames.length;i<j;i++)if(a.frames[i].node===e){a.frames[i][b].push(c);break a}d={node:e,include:[],exclude:[]},c&&d[b].push(c),a.frames.push(d)}}function l(a){\"use strict\";if(a&&\"object\"===(void 0===a?\"undefined\":za(a))||a instanceof NodeList){if(a instanceof Node)return{include:[a],exclude:[]};if(a.hasOwnProperty(\"include\")||a.hasOwnProperty(\"exclude\"))return{include:a.include&&+a.include.length?a.include:[document],exclude:a.exclude||[]};if(a.length===+a.length)return{include:a,exclude:[]}}return\"string\"==typeof a?{include:[a],exclude:[]}:{include:[document],exclude:[]}}function m(a,b){\"use strict\";for(var c,d,e=[],f=0,g=a[b].length;f<g;f++){if(\"string\"==typeof(c=a[b][f])){d=Array.from(document.querySelectorAll(c)),e=e.concat(d.map(function(a){return axe.utils.getFlattenedTree(a)[0]}));break}!c||!c.length||c instanceof Node?c instanceof Node&&e.push(axe.utils.getFlattenedTree(c)[0]):c.length>1?k(a,b,c):(d=Array.from(document.querySelectorAll(c[0])),e=e.concat(d.map(function(a){return axe.utils.getFlattenedTree(a)[0]})))}return e.filter(function(a){return a})}function n(a){\"use strict\";if(0===a.include.length){if(0===a.frames.length){var b=axe.utils.respondable.isInFrame()?\"frame\":\"page\";return new Error(\"No elements found for include in \"+b+\" Context\")}a.frames.forEach(function(a,b){if(0===a.include.length)return new Error(\"No elements found for include in Context of frame \"+b)})}}function o(a){\"use strict\";var b=this;this.frames=[],this.initiator=!a||\"boolean\"!=typeof a.initiator||a.initiator,this.page=!1,a=l(a),this.exclude=a.exclude,this.include=a.include,this.include=m(this,\"include\"),this.exclude=m(this,\"exclude\"),axe.utils.select(\"frame, iframe\",this).forEach(function(a){wa(a,b)&&j(b.frames,a.actualNode)}),1===this.include.length&&this.include[0].actualNode===document.documentElement&&(this.page=!0);var c=n(this);if(c instanceof Error)throw c;Array.isArray(this.include)||(this.include=Array.from(this.include)),this.include.sort(axe.utils.nodeSorter)}function p(a){\"use strict\";this.id=a.id,this.result=axe.constants.NA,this.pageLevel=a.pageLevel,this.impact=null,this.nodes=[]}function q(a,b){\"use strict\";this._audit=b,this.id=a.id,this.selector=a.selector||\"*\",this.excludeHidden=\"boolean\"!=typeof a.excludeHidden||a.excludeHidden,this.enabled=\"boolean\"!=typeof a.enabled||a.enabled,this.pageLevel=\"boolean\"==typeof a.pageLevel&&a.pageLevel,this.any=a.any||[],this.all=a.all||[],this.none=a.none||[],this.tags=a.tags||[],a.matches&&(this.matches=h(a.matches))}function r(a){\"use strict\";return axe.utils.getAllChecks(a).map(function(b){var c=a._audit.checks[b.id||b];return c&&\"function\"==typeof c.after?c:null}).filter(Boolean)}function s(a,b){\"use strict\";var c=[];return a.forEach(function(a){axe.utils.getAllChecks(a).forEach(function(a){a.id===b&&c.push(a)})}),c}function t(a){\"use strict\";return a.filter(function(a){return!0!==a.filtered})}function u(a){\"use strict\";var b=[\"any\",\"all\",\"none\"],c=a.nodes.filter(function(a){var c=0;return b.forEach(function(b){a[b]=t(a[b]),c+=a[b].length}),c>0});return a.pageLevel&&c.length&&(c=[c.reduce(function(a,c){if(a)return b.forEach(function(b){a[b].push.apply(a[b],c[b])}),a})]),c}function v(a,b){\"use strict\";if(a=a||function(){},b=b||axe.log,!axe._audit)throw new Error(\"No audit configured\");var c=axe.utils.queue(),d=[];Object.keys(axe.plugins).forEach(function(a){c.defer(function(b){var c=function(a){d.push(a),b()};try{axe.plugins[a].cleanup(b,c)}catch(a){c(a)}})});var e=axe.utils.getFlattenedTree(document.body);axe.utils.querySelectorAll(e,\"iframe, frame\").forEach(function(a){c.defer(function(b,c){return axe.utils.sendCommandToFrame(a.actualNode,{command:\"cleanup-plugin\"},b,c)})}),c.then(function(c){0===d.length?a(c):b(d)}).catch(b)}function w(a){\"use strict\";var b;if(!(b=axe._audit))throw new Error(\"No audit configured\");a.reporter&&(\"function\"==typeof a.reporter||Ca[a.reporter])&&(b.reporter=a.reporter),a.checks&&a.checks.forEach(function(a){b.addCheck(a)});var c=[];a.rules&&a.rules.forEach(function(a){c.push(a.id),b.addRule(a)}),a.disableOtherRules&&b.rules.forEach(function(a){!1===c.includes(a.id)&&(a.enabled=!1)}),void 0!==a.branding?b.setBranding(a.branding):b._constructHelpUrls(),a.tagExclude&&(b.tagExclude=a.tagExclude)}function x(a,b,c){\"use strict\";var d=c,e=function(a){a instanceof Error==!1&&(a=new Error(a)),c(a)},f=a&&a.context||{};f.hasOwnProperty(\"include\")&&!f.include.length&&(f.include=[document]);var g=a&&a.options||{};switch(a.command){case\"rules\":return A(f,g,d,e);case\"cleanup-plugin\":return v(d,e);default:if(axe._audit&&axe._audit.commands&&axe._audit.commands[a.command])return axe._audit.commands[a.command](a,c)}}function y(a){\"use strict\";this._run=a.run,this._collect=a.collect,this._registry={},a.commands.forEach(function(a){axe._audit.registerCommand(a)})}function z(){\"use strict\";var a=axe._audit;if(!a)throw new Error(\"No audit configured\");a.resetRulesAndChecks()}function A(a,b,c,d){\"use strict\";try{a=new o(a)}catch(a){return d(a)}var e=axe.utils.queue(),f=axe._audit;b.performanceTimer&&axe.utils.performanceTimer.auditStart(),a.frames.length&&!1!==b.iframes&&e.defer(function(c,d){axe.utils.collectResultsFromFrames(a,b,\"rules\",null,c,d)});var g=void 0;e.defer(function(c,d){b.restoreScroll&&(g=axe.utils.getScrollState()),f.run(a,b,c,d)}),e.then(function(e){try{g&&axe.utils.setScrollState(g),b.performanceTimer&&axe.utils.performanceTimer.auditEnd();var h=axe.utils.mergeResults(e.map(function(a){return{results:a}}));a.initiator&&(h=f.after(h,b),h.forEach(axe.utils.publishMetaData),h=h.map(axe.utils.finalizeRuleResult));try{c(h)}catch(a){axe.log(a)}}catch(a){d(a)}}).catch(d)}function B(a){\"use strict\";switch(!0){case\"string\"==typeof a:case Array.isArray(a):case Node&&a instanceof Node:case NodeList&&a instanceof NodeList:return!0;case\"object\"!==(void 0===a?\"undefined\":za(a)):return!1;case void 0!==a.include:case void 0!==a.exclude:case\"number\"==typeof a.length:return!0;default:return!1}}function C(a,b,c){\"use strict\";var d=new TypeError(\"axe.run arguments are invalid\");if(!B(a)){if(void 0!==c)throw d;c=b,b=a,a=document}if(\"object\"!==(void 0===b?\"undefined\":za(b))){if(void 0!==c)throw d;c=b,b={}}if(\"function\"!=typeof c&&void 0!==c)throw d;return{context:a,options:b,callback:c||Da}}function D(a,b){\"use strict\";[\"any\",\"all\",\"none\"].forEach(function(c){Array.isArray(a[c])&&a[c].filter(function(a){return Array.isArray(a.relatedNodes)}).forEach(function(a){a.relatedNodes=a.relatedNodes.map(function(a){var c={html:a.source};return b.elementRef&&!a.fromFrame&&(c.element=a.element),(!1!==b.selectors||a.fromFrame)&&(c.target=a.selector),b.xpath&&(c.xpath=a.xpath),c})})})}function E(a,b){return Ja.reduce(function(c,d){return c[d]=(a[d]||[]).map(function(a){return b(a,d)}),c},{})}function F(a,b,c){var d=Object.assign({},b);d.nodes=(d[c]||[]).concat(),axe.constants.resultGroups.forEach(function(a){delete d[a]}),a[c].push(d)}function G(a,b,c){\"use strict\";var d=window.getComputedStyle(a,null),e=!1;return!!d&&(b.forEach(function(a){d.getPropertyValue(a.property)===a.value&&(e=!0)}),!!e||!(a.nodeName.toUpperCase()===c.toUpperCase()||!a.parentNode)&&G(a.parentNode,b,c))}function H(a,b){\"use strict\";var c;return axe._tree&&(c=axe.utils.getSelector(b)),new Error(a+\": \"+(c||b))}function I(a,b,c,d,e,f){\"use strict\";var g=axe.utils.queue();a.frames.forEach(function(e){var f={options:b,command:c,parameter:d,context:{initiator:!1,page:a.page,include:e.include||[],exclude:e.exclude||[]}};g.defer(function(a,b){var c=e.node;axe.utils.sendCommandToFrame(c,f,function(b){if(b)return a({results:b,frameElement:c,frame:axe.utils.getSelector(c)});a(null)},b)})}),g.then(function(a){e(axe.utils.mergeResults(a,b))}).catch(f)}function J(a,b){if(b=b||300,a.length>b){var c=a.indexOf(\">\");a=a.substring(0,c+1)}return a}function K(a){var b=a.outerHTML;return b||\"function\"!=typeof XMLSerializer||(b=(new XMLSerializer).serializeToString(a)),J(b||\"\")}function L(a,b,c){this._fromFrame=!!c,this.spec=c||{},b&&b.absolutePaths&&(this._options={toRoot:!0}),this.source=void 0!==this.spec.source?this.spec.source:K(a),this._element=a}function M(a,b){return{shadowId:b,children:[],actualNode:a}}function N(a){var b=[];for(a=a.firstChild;a;)b.push(a),a=a.nextSibling;return b}function O(){var a=arguments.length>0&&void 0!==arguments[0]?arguments[0]:\"\";return 0!==a.length&&(a.match(/[0-9]/g)||\"\").length>=a.length/2}function P(a,b){return[a.substring(0,b),a.substring(b)]}function Q(a){var b=a,c=\"\",d=\"\",e=\"\",f=\"\",g=\"\",h=\"\";if(a.includes(\"#\")){var i=P(a,a.indexOf(\"#\")),j=Ka(i,2);a=j[0],h=j[1]}if(a.includes(\"?\")){var k=P(a,a.indexOf(\"?\")),l=Ka(k,2);a=l[0],g=l[1]}if(a.includes(\"://\")){var m=a.split(\"://\"),n=Ka(m,2);c=n[0],a=n[1];var o=P(a,a.indexOf(\"/\")),p=Ka(o,2);d=p[0],a=p[1]}else if(\"//\"===a.substr(0,2)){a=a.substr(2);var q=P(a,a.indexOf(\"/\")),r=Ka(q,2);d=r[0],a=r[1]}if(\"www.\"===d.substr(0,4)&&(d=d.substr(4)),d&&d.includes(\":\")){var s=P(d,d.indexOf(\":\")),t=Ka(s,2);d=t[0],e=t[1]}return f=a,{original:b,protocol:c,domain:d,port:e,path:f,query:g,hash:h}}function R(a,b){var c=b.name,d=void 0;if(-1!==c.indexOf(\"href\")||-1!==c.indexOf(\"src\")){var e=encodeURI(axe.utils.getFriendlyUriEnd(a.getAttribute(c)));if(!e)return;d=La(b.name)+'$=\"'+e+'\"'}else d=La(c)+'=\"'+La(b.value)+'\"';return d}function S(a,b){return a.count<b.count?-1:a.count===b.count?0:1}function T(a){return!Na.includes(a.name)&&-1===a.name.indexOf(\":\")&&(!a.value||a.value.length<Oa)}function U(a,b){var c=[],d=b.classes,e=b.tags;return a.classList&&Array.from(a.classList).forEach(function(b){var f=La(b);d[f]<e[a.nodeName]&&c.push({name:f,count:d[f],species:\"class\"})}),c.sort(S)}function V(a,b){var c=a.parentNode&&Array.from(a.parentNode.children||\"\")||[];if(c.find(function(c){return c!==a&&axe.utils.matchesSelector(c,b)}))return\":nth-child(\"+(1+c.indexOf(a))+\")\";return\"\"}function W(a){if(a.getAttribute(\"id\")){var b=a.getRootNode&&a.getRootNode()||document,c=\"#\"+La(a.getAttribute(\"id\")||\"\");return c.match(/player_uid_/)||1!==b.querySelectorAll(c).length?void 0:c}}function X(a){return void 0===Ma&&(Ma=axe.utils.isXHTML(document)),La(Ma?a.localName:a.nodeName.toLowerCase())}function Y(a,b){var c=[],d=b.attributes,e=b.tags;return a.attributes&&Array.from(a.attributes).filter(T).forEach(function(b){var f=R(a,b);f&&d[f]<e[a.nodeName]&&c.push({name:f,count:d[f],species:\"attribute\"})}),c.sort(S)}function Z(a,b){var c=\"\",d=void 0,e=U(a,b),f=Y(a,b);return e.length&&1===e[0].count?d=[e[0]]:f.length&&1===f[0].count?(d=[f[0]],c=X(a)):(d=e.concat(f),d.sort(S),d=d.slice(0,3),d.some(function(a){return\"class\"===a.species})?d.sort(function(a,b){return a.species!==b.species&&\"class\"===a.species?-1:a.species===b.species?0:1}):c=X(a)),c+=d.reduce(function(a,b){switch(b.species){case\"class\":return a+\".\"+b.name;case\"attribute\":return a+\"[\"+b.name+\"]\"}return a},\"\")}function $(a,b,c){axe._selectorData||(axe._selectorData=axe.utils.getSelectorData(axe._tree));var d=b.toRoot,e=void 0!==d&&d,f=void 0,g=void 0;do{var h=W(a);h||(h=Z(a,axe._selectorData),h+=V(a,h)),f=f?h+\" > \"+f:h,g=g?g.filter(function(a){return axe.utils.matchesSelector(a,f)}):Array.from(c.querySelectorAll(f)),a=a.parentElement}while((g.length>1||e)&&a&&11!==a.nodeType);return 1===g.length?f:-1!==f.indexOf(\" > \")?\":root\"+f.substring(f.indexOf(\" > \")):\":root\"}function _(a,b){var c,d;if(!a)return[];if(!b&&9===a.nodeType)return b=[{str:\"html\"}];if(b=b||[],a.parentNode&&a.parentNode!==a&&(b=_(a.parentNode,b)),a.previousSibling){d=1,c=a.previousSibling;do{1===c.nodeType&&c.nodeName===a.nodeName&&d++,c=c.previousSibling}while(c);1===d&&(d=null)}else if(a.nextSibling){c=a.nextSibling;do{1===c.nodeType&&c.nodeName===a.nodeName?(d=1,c=null):(d=null,c=c.previousSibling)}while(c)}if(1===a.nodeType){var e={};e.str=a.nodeName.toLowerCase();var f=a.getAttribute&&axe.utils.escapeSelector(a.getAttribute(\"id\"));f&&1===a.ownerDocument.querySelectorAll(\"#\"+f).length&&(e.id=a.getAttribute(\"id\")),d>1&&(e.count=d),b.push(e)}return b}function aa(a){return a.reduce(function(a,b){return b.id?\"/\"+b.str+\"[@id='\"+b.id+\"']\":a+\"/\"+b.str+(b.count>0?\"[\"+b.count+\"]\":\"\")},\"\")}function ba(a){\"use strict\";if(Pa&&Pa.parentNode)return void 0===Pa.styleSheet?Pa.appendChild(document.createTextNode(a)):Pa.styleSheet.cssText+=a,Pa;if(a){var b=document.head||document.getElementsByTagName(\"head\")[0];return Pa=document.createElement(\"style\"),Pa.type=\"text/css\",void 0===Pa.styleSheet?Pa.appendChild(document.createTextNode(a)):Pa.styleSheet.cssText=a,b.appendChild(Pa),Pa}}function ca(a,b,c,d){\"use strict\";var e=axe.utils.getXpath(c),f={element:c,selector:d,xpath:e};a.forEach(function(a){a.node=axe.utils.DqElement.fromFrame(a.node,b,f);var c=axe.utils.getAllChecks(a);c.length&&c.forEach(function(a){a.relatedNodes=a.relatedNodes.map(function(a){return axe.utils.DqElement.fromFrame(a,b,f)})})})}function da(a,b){\"use strict\";for(var c,d,e=b[0].node,f=0,g=a.length;f<g;f++)if(d=a[f].node,(c=axe.utils.nodeSorter({actualNode:d.element},{actualNode:e.element}))>0||0===c&&e.selector.length<d.selector.length)return void a.splice.apply(a,[f,0].concat(b));a.push.apply(a,b)}function ea(a){\"use strict\";return a&&a.results?Array.isArray(a.results)?a.results.length?a.results:null:[a.results]:null}function fa(a,b){function c(a){return a.incomplete&&a.incomplete.default?a.incomplete.default:Aa.incompleteFallbackMessage()}if(!a||!a.missingData)return c(b);try{var d=b.incomplete[a.missingData[0].reason];if(!d)throw new Error;return d}catch(d){return\"string\"==typeof a.missingData?b.incomplete[a.missingData]:c(b)}}function ga(a,b){\"use strict\";return function(c){var d=a[c.id]||{},e=d.messages||{},f=Object.assign({},d);delete f.messages,void 0===c.result?\"object\"===za(e.incomplete)?f.message=function(){return fa(c.data,e)}:f.message=e.incomplete:f.message=c.result===b?e.pass:e.fail,axe.utils.extendMetaData(c,f)}}function ha(a,b){return 1===a.nodeType&&(\"*\"===b.tag||a.nodeName.toLowerCase()===b.tag)}function ia(a,b){return!b.classes||b.classes.reduce(function(b,c){return b&&a.className&&a.className.match(c.regexp)},!0)}function ja(a,b){return!b.attributes||b.attributes.reduce(function(b,c){var d=a.getAttribute(c.key);return b&&null!==d&&(!c.value||c.test(d))},!0)}function ka(a,b){return!b.id||a.id===b.id}function la(a,b){return!(b.pseudos&&!b.pseudos.reduce(function(b,c){if(\"not\"===c.name)return b&&!Sa([a],c.expressions,!1).length;throw new Error(\"the pseudo selector \"+c.name+\" has not yet been implemented\")},!0))}function ma(a){/*! Credit Mootools Copyright Mootools, MIT License */\nif(a)return a.map(function(a){var b,c,d=a.name.replace(Ua,\"\"),e=(a.value||\"\").replace(Ua,\"\");switch(a.operator){case\"^=\":c=new RegExp(\"^\"+Ta(e));break;case\"$=\":c=new RegExp(Ta(e)+\"$\");break;case\"~=\":c=new RegExp(\"(^|\\\\s)\"+Ta(e)+\"(\\\\s|$)\");break;case\"|=\":c=new RegExp(\"^\"+Ta(e)+\"(-|$)\");break;case\"=\":b=function(a){return e===a};break;case\"*=\":b=function(a){return a&&a.includes(e)};break;case\"!=\":b=function(a){return e!==a};break;default:b=function(a){return!!a}}return\"\"===e&&/^[*$^]=$/.test(a.operator)&&(b=function(){return!1}),b||(b=function(a){return a&&c.test(a)}),{key:d,value:e,test:b}})}function na(a){if(a)return a.map(function(a){return a=a.replace(Ua,\"\"),{value:a,regexp:new RegExp(\"(^|\\\\s)\"+Ta(a)+\"(\\\\s|$)\")}})}function oa(a){if(a)return a.map(function(a){var b;return\"not\"===a.name&&(b=axe.utils.cssParser.parse(a.value),b=b.selectors?b.selectors:[b],b=Ra(b)),{name:a.name,expressions:b,value:a.value}})}function pa(a,b,c,d){var e={nodes:a.slice(),anyLevel:b,thisLevel:c,parentShadowId:d};return e.nodes.reverse(),e}function qa(a,b){return ha(a.actualNode,b[0])&&ia(a.actualNode,b[0])&&ja(a.actualNode,b[0])&&ka(a.actualNode,b[0])&&la(a,b[0])}function ra(a,b){\"use strict\";var c,d,e=axe._audit&&axe._audit.tagExclude?axe._audit.tagExclude:[];return b.hasOwnProperty(\"include\")||b.hasOwnProperty(\"exclude\")?(c=b.include||[],c=Array.isArray(c)?c:[c],d=b.exclude||[],d=Array.isArray(d)?d:[d],d=d.concat(e.filter(function(a){return-1===c.indexOf(a)}))):(c=Array.isArray(b)?b:[b],d=e.filter(function(a){return-1===c.indexOf(a)})),!!(c.some(function(b){return-1!==a.tags.indexOf(b)})||0===c.length&&!1!==a.enabled)&&d.every(function(b){return-1===a.tags.indexOf(b)})}function sa(a){var b=window.getComputedStyle(a),c=\"visible\"===b.getPropertyValue(\"overflow-y\"),d=\"visible\"===b.getPropertyValue(\"overflow-x\");if(!c&&a.scrollHeight>a.clientHeight||!d&&a.scrollWidth>a.clientWidth)return{elm:a,top:a.scrollTop,left:a.scrollLeft}}function ta(a,b,c){if(a===window)return a.scroll(b,c);a.scrollTop=b,a.scrollLeft=c}function ua(a){return Array.from(a.children).reduce(function(a,b){var c=sa(b);return c&&a.push(c),a.concat(ua(b))},[])}function va(a){\"use strict\";return a.sort(function(a,b){return axe.utils.contains(a,b)?1:-1})[0]}function wa(a,b){\"use strict\";var c=b.include&&va(b.include.filter(function(b){return axe.utils.contains(b,a)})),d=b.exclude&&va(b.exclude.filter(function(b){return axe.utils.contains(b,a)}));return!!(!d&&c||d&&axe.utils.contains(d,c))}function xa(a,b){\"use strict\";var c;if(0===a.length)return b;a.length<b.length&&(c=a,a=b,b=c);for(var d=0,e=b.length;d<e;d++)a.includes(b[d])||a.push(b[d]);return a}function ya(a){return a.reduce(function(a,b){return a.length&&a[a.length-1].actualNode.contains(b.actualNode)||a.push(b),a},[])}var document=window.document,za=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a},axe=axe||{};axe.version=\"3.0.0-beta.2\",\"function\"==typeof define&&define.amd&&define([],function(){\"use strict\";return axe}),\"object\"===(\"undefined\"==typeof module?\"undefined\":za(module))&&module.exports&&\"function\"==typeof a.toString&&(axe.source=\"(\"+a.toString()+')(typeof window === \"object\" ? window : this);',module.exports=axe),\"function\"==typeof window.getComputedStyle&&(window.axe=axe);var commons;b.prototype=Object.create(Error.prototype),b.prototype.constructor=b;var utils=axe.utils={},Aa={},za=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};e.prototype._init=function(){var a=c(this.defaultConfig);axe.commons=commons=a.commons,this.reporter=a.reporter,this.commands={},this.rules=[],this.checks={},d(a.rules,this,\"addRule\"),d(a.checks,this,\"addCheck\"),this.data={},this.data.checks=a.data&&a.data.checks||{},this.data.rules=a.data&&a.data.rules||{},this.data.failureSummaries=a.data&&a.data.failureSummaries||{},this.data.incompleteFallbackMessage=a.data&&a.data.incompleteFallbackMessage||\"\",this._constructHelpUrls()},e.prototype.registerCommand=function(a){\"use strict\";this.commands[a.id]=a.callback},e.prototype.addRule=function(a){\"use strict\";a.metadata&&(this.data.rules[a.id]=a.metadata);var b=this.getRule(a.id);b?b.configure(a):this.rules.push(new q(a,this))},e.prototype.addCheck=function(a){\"use strict\";var b=a.metadata;\"object\"===(void 0===b?\"undefined\":za(b))&&(this.data.checks[a.id]=b,\"object\"===za(b.messages)&&Object.keys(b.messages).filter(function(a){return b.messages.hasOwnProperty(a)&&\"string\"==typeof b.messages[a]}).forEach(function(a){0===b.messages[a].indexOf(\"function\")&&(b.messages[a]=new Function(\"return \"+b.messages[a]+\";\")())})),this.checks[a.id]?this.checks[a.id].configure(a):this.checks[a.id]=new i(a)},e.prototype.run=function(a,b,c,d){\"use strict\";this.validateOptions(b),axe._tree=axe.utils.getFlattenedTree(document.documentElement),axe._selectCache=[];var e=axe.utils.queue();this.rules.forEach(function(c){if(axe.utils.ruleShouldRun(c,a,b)){if(b.performanceTimer){var d=\"mark_rule_end_\"+c.id,f=\"mark_rule_start_\"+c.id;axe.utils.performanceTimer.mark(f)}e.defer(function(e,g){c.run(a,b,function(a){b.performanceTimer&&(axe.utils.performanceTimer.mark(d),axe.utils.performanceTimer.measure(\"rule_\"+c.id,f,d)),e(a)},function(a){if(b.debug)g(a);else{var d=Object.assign(new p(c),{result:axe.constants.CANTTELL,description:\"An error occured while running this rule\",message:a.message,stack:a.stack,error:a});e(d)}})})}}),e.then(function(a){axe._selectCache=void 0,c(a.filter(function(a){return!!a}))}).catch(d)},e.prototype.after=function(a,b){\"use strict\";var c=this.rules;return a.map(function(a){return axe.utils.findBy(c,\"id\",a.id).after(a,b)})},e.prototype.getRule=function(a){return this.rules.find(function(b){return b.id===a})},e.prototype.validateOptions=function(a){\"use strict\";var b=this;if(\"object\"===za(a.runOnly)){var c=a.runOnly;if(\"rule\"===c.type&&Array.isArray(c.value))c.value.forEach(function(a){if(!b.getRule(a))throw new Error(\"unknown rule `\"+a+\"` in options.runOnly\")});else if(Array.isArray(c.value)&&c.value.length>0){var d=[].concat(c.value);if(b.rules.forEach(function(a){var b,c,e;if(d)for(c=0,e=a.tags.length;c<e;c++)-1!==(b=d.indexOf(a.tags[c]))&&d.splice(b,1)}),0!==d.length)throw new Error(\"could not find tags `\"+d.join(\"`, `\")+\"`\")}}return\"object\"===za(a.rules)&&Object.keys(a.rules).forEach(function(a){if(!b.getRule(a))throw new Error(\"unknown rule `\"+a+\"` in options.rules\")}),a},e.prototype.setBranding=function(a){\"use strict\";var b={brand:this.brand,application:this.application};a&&a.hasOwnProperty(\"brand\")&&a.brand&&\"string\"==typeof a.brand&&(this.brand=a.brand),a&&a.hasOwnProperty(\"application\")&&a.application&&\"string\"==typeof a.application&&(this.application=a.application),this._constructHelpUrls(b)},e.prototype._constructHelpUrls=function(){var a=this,b=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null,c=(axe.version.match(/^[1-9][0-9]*\\.[0-9]+/)||[\"x.y\"])[0];this.rules.forEach(function(d){a.data.rules[d.id]||(a.data.rules[d.id]={});var e=a.data.rules[d.id];(\"string\"!=typeof e.helpUrl||b&&e.helpUrl===f(b,d.id,c))&&(e.helpUrl=f(a,d.id,c))})},e.prototype.resetRulesAndChecks=function(){\"use strict\";this._init()},i.prototype.enabled=!0,i.prototype.run=function(a,b,c,d){\"use strict\";b=b||{};var e=b.hasOwnProperty(\"enabled\")?b.enabled:this.enabled,f=b.options||this.options;if(e){var h,i=new g(this),j=axe.utils.checkHelper(i,b,c,d);try{h=this.evaluate.call(j,a.actualNode,f,a)}catch(a){return void d(a)}j.isAsync||(i.result=h,setTimeout(function(){c(i)},0))}else c(null)},i.prototype.configure=function(a){var b=this;[\"options\",\"enabled\"].filter(function(b){return a.hasOwnProperty(b)}).forEach(function(c){return b[c]=a[c]}),[\"evaluate\",\"after\"].filter(function(b){return a.hasOwnProperty(b)}).forEach(function(c){return b[c]=h(a[c])})};var za=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};q.prototype.matches=function(){\"use strict\";return!0},q.prototype.gather=function(a){\"use strict\";var b=axe.utils.select(this.selector,a);return this.excludeHidden?b.filter(function(a){return!axe.utils.isHidden(a.actualNode)}):b},q.prototype.runChecks=function(a,b,c,d,e){\"use strict\";var f=this,g=axe.utils.queue();this[a].forEach(function(a){var d=f._audit.checks[a.id||a],e=axe.utils.getCheckOption(d,f.id,c);g.defer(function(a,c){d.run(b,e,a,c)})}),g.then(function(b){b=b.filter(function(a){return a}),d({type:a,results:b})}).catch(e)},q.prototype.run=function(a,c,d,e){var f=this,g=axe.utils.queue(),h=new p(this),i=\"mark_runchecks_start_\"+this.id,j=\"mark_runchecks_end_\"+this.id,k=void 0;try{k=this.gather(a).filter(function(a){return f.matches(a.actualNode,a)})}catch(a){return void e(new b({cause:a,ruleId:this.id}))}c.performanceTimer&&(axe.log(\"gather (\",k.length,\"):\",axe.utils.performanceTimer.timeElapsed()+\"ms\"),axe.utils.performanceTimer.mark(i)),k.forEach(function(a){g.defer(function(b,d){var e=axe.utils.queue();e.defer(function(b,d){f.runChecks(\"any\",a,c,b,d)}),e.defer(function(b,d){f.runChecks(\"all\",a,c,b,d)}),e.defer(function(b,d){f.runChecks(\"none\",a,c,b,d)}),e.then(function(d){if(d.length){var e=!1,f={};d.forEach(function(a){var b=a.results.filter(function(a){return a});f[a.type]=b,b.length&&(e=!0)}),e&&(f.node=new axe.utils.DqElement(a.actualNode,c),h.nodes.push(f))}b()}).catch(function(a){return d(a)})})}),c.performanceTimer&&(axe.utils.performanceTimer.mark(j),axe.utils.performanceTimer.measure(\"runchecks_\"+this.id,i,j)),g.then(function(){return d(h)}).catch(function(a){return e(a)})},q.prototype.after=function(a,b){\"use strict\";var c=r(this),d=this.id;return c.forEach(function(c){var e=s(a.nodes,c.id),f=axe.utils.getCheckOption(c,d,b),g=c.after(e,f);e.forEach(function(a){-1===g.indexOf(a)&&(a.filtered=!0)})}),a.nodes=u(a),a},q.prototype.configure=function(a){\"use strict\";a.hasOwnProperty(\"selector\")&&(this.selector=a.selector),a.hasOwnProperty(\"excludeHidden\")&&(this.excludeHidden=\"boolean\"!=typeof a.excludeHidden||a.excludeHidden),a.hasOwnProperty(\"enabled\")&&(this.enabled=\"boolean\"!=typeof a.enabled||a.enabled),a.hasOwnProperty(\"pageLevel\")&&(this.pageLevel=\"boolean\"==typeof a.pageLevel&&a.pageLevel),a.hasOwnProperty(\"any\")&&(this.any=a.any),a.hasOwnProperty(\"all\")&&(this.all=a.all),a.hasOwnProperty(\"none\")&&(this.none=a.none),a.hasOwnProperty(\"tags\")&&(this.tags=a.tags),a.hasOwnProperty(\"matches\")&&(\"string\"==typeof a.matches?this.matches=new Function(\"return \"+a.matches+\";\")():this.matches=a.matches)},function(axe){var a=[{name:\"NA\",value:\"inapplicable\",priority:0,group:\"inapplicable\"},{name:\"PASS\",value:\"passed\",priority:1,group:\"passes\"},{name:\"CANTTELL\",value:\"cantTell\",priority:2,group:\"incomplete\"},{name:\"FAIL\",value:\"failed\",priority:3,group:\"violations\"}],b={helpUrlBase:\"https://dequeuniversity.com/rules/\",results:[],resultGroups:[],resultGroupMap:{},impact:Object.freeze([\"minor\",\"moderate\",\"serious\",\"critical\"])};a.forEach(function(a){var c=a.name,d=a.value,e=a.priority,f=a.group;b[c]=d,b[c+\"_PRIO\"]=e,b[c+\"_GROUP\"]=f,b.results[e]=d,b.resultGroups[e]=f,b.resultGroupMap[d]=f}),Object.freeze(b.results),Object.freeze(b.resultGroups),Object.freeze(b.resultGroupMap),Object.freeze(b),Object.defineProperty(axe,\"constants\",{value:b,enumerable:!0,configurable:!1,writable:!1})}(axe);var za=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};axe.log=function(){\"use strict\";\"object\"===(\"undefined\"==typeof console?\"undefined\":za(console))&&console.log&&Function.prototype.apply.call(console.log,console,arguments)},axe.cleanup=v,axe.configure=w,axe.getRules=function(a){\"use strict\";a=a||[];var b=a.length?axe._audit.rules.filter(function(b){return!!a.filter(function(a){return-1!==b.tags.indexOf(a)}).length}):axe._audit.rules,c=axe._audit.data.rules||{};return b.map(function(a){var b=c[a.id]||{};return{ruleId:a.id,description:b.description,help:b.help,helpUrl:b.helpUrl,tags:a.tags}})},axe._load=function(a){\"use strict\";axe.utils.respondable.subscribe(\"axe.ping\",function(a,b,c){c({axe:!0})}),axe.utils.respondable.subscribe(\"axe.start\",x),axe._audit=new e(a)};var axe=axe||{};axe.plugins={},y.prototype.run=function(){\"use strict\";return this._run.apply(this,arguments)},y.prototype.collect=function(){\"use strict\";return this._collect.apply(this,arguments)},y.prototype.cleanup=function(a){\"use strict\";var b=axe.utils.queue(),c=this;Object.keys(this._registry).forEach(function(a){b.defer(function(b){c._registry[a].cleanup(b)})}),b.then(function(){a()})},y.prototype.add=function(a){\"use strict\";this._registry[a.id]=a},axe.registerPlugin=function(a){\"use strict\";axe.plugins[a.id]=new y(a)};var Ba,Ca={};axe.getReporter=function(a){\"use strict\";return\"string\"==typeof a&&Ca[a]?Ca[a]:\"function\"==typeof a?a:Ba},axe.addReporter=function(a,b,c){\"use strict\";Ca[a]=b,c&&(Ba=b)},axe.reset=z,axe._runRules=A;var za=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a},Da=function(){};axe.run=function(a,b,c){\"use strict\";if(!axe._audit)throw new Error(\"No audit configured\");var d=C(a,b,c);a=d.context,b=d.options,c=d.callback,b.reporter=b.reporter||axe._audit.reporter||\"v1\",b.performanceTimer&&axe.utils.performanceTimer.start();var e=void 0,f=Da,g=Da;return window.Promise&&c===Da&&(e=new Promise(function(a,b){f=b,g=a})),axe._runRules(a,b,function(a){var d=function(a){try{c(null,a)}catch(a){axe.log(a)}g(a)};b.performanceTimer&&axe.utils.performanceTimer.end();try{var e=axe.getReporter(b.reporter),h=e(a,b,d);axe._selectorData=void 0,axe._tree=void 0,void 0!==h&&d(h)}catch(a){c(a),f(a)}},function(a){c(a),f(a)}),e},Aa.failureSummary=function(a){\"use strict\";var b={};return b.none=a.none.concat(a.all),b.any=a.any,Object.keys(b).map(function(a){if(b[a].length){var c=axe._audit.data.failureSummaries[a];return c&&\"function\"==typeof c.failureMessage?c.failureMessage(b[a].map(function(a){return a.message||\"\"})):void 0}}).filter(function(a){return void 0!==a}).join(\"\\n\\n\")},Aa.incompleteFallbackMessage=function(){\"use strict\";return axe._audit.data.incompleteFallbackMessage()};var za=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a},Ea=axe.constants.resultGroups;Aa.processAggregate=function(a,b){var c=axe.utils.aggregateResult(a);return c.timestamp=(new Date).toISOString(),c.url=window.location.href,Ea.forEach(function(a){b.resultTypes&&!b.resultTypes.includes(a)&&(c[a]||[]).forEach(function(a){Array.isArray(a.nodes)&&a.nodes.length>0&&(a.nodes=[a.nodes[0]])}),c[a]=(c[a]||[]).map(function(a){return a=Object.assign({},a),Array.isArray(a.nodes)&&a.nodes.length>0&&(a.nodes=a.nodes.map(function(a){return\"object\"===za(a.node)&&(a.html=a.node.source,b.elementRef&&!a.node.fromFrame&&(a.element=a.node.element),(!1!==b.selectors||a.node.fromFrame)&&(a.target=a.node.selector),b.xpath&&(a.xpath=a.node.xpath)),delete a.result,delete a.node,D(a,b),a})),Ea.forEach(function(b){return delete a[b]}),delete a.pageLevel,delete a.result,a})}),c},axe.addReporter(\"na\",function(a,b,c){\"use strict\";\"function\"==typeof b&&(c=b,b={});var d=Aa.processAggregate(a,b);c({violations:d.violations,passes:d.passes,incomplete:d.incomplete,inapplicable:d.inapplicable,timestamp:d.timestamp,url:d.url})}),axe.addReporter(\"no-passes\",function(a,b,c){\"use strict\";\"function\"==typeof b&&(c=b,b={}),b.resultTypes=[\"violations\"];var d=Aa.processAggregate(a,b);c({violations:d.violations,timestamp:d.timestamp,url:d.url})}),axe.addReporter(\"raw\",function(a,b,c){\"use strict\";\"function\"==typeof b&&(c=b,b={}),c(a)}),axe.addReporter(\"v1\",function(a,b,c){\"use strict\";\"function\"==typeof b&&(c=b,b={});var d=Aa.processAggregate(a,b);d.violations.forEach(function(a){return a.nodes.forEach(function(a){a.failureSummary=Aa.failureSummary(a)})}),c({violations:d.violations,passes:d.passes,incomplete:d.incomplete,inapplicable:d.inapplicable,timestamp:d.timestamp,url:d.url})}),axe.addReporter(\"v2\",function(a,b,c){\"use strict\";\"function\"==typeof b&&(c=b,b={});var d=Aa.processAggregate(a,b);c({violations:d.violations,passes:d.passes,incomplete:d.incomplete,inapplicable:d.inapplicable,timestamp:d.timestamp,url:d.url})},!0),axe.utils.aggregate=function(a,b,c){b=b.slice(),c&&b.push(c);var d=b.map(function(b){return a.indexOf(b)}).sort();return a[d.pop()]};var Fa=axe.constants,Ga=Fa.CANTTELL_PRIO,Ha=Fa.FAIL_PRIO,Ia=[];Ia[axe.constants.PASS_PRIO]=!0,Ia[axe.constants.CANTTELL_PRIO]=null,Ia[axe.constants.FAIL_PRIO]=!1;var Ja=[\"any\",\"all\",\"none\"];axe.utils.aggregateChecks=function(a){var b=Object.assign({},a);E(b,function(a,b){var c=Ia.indexOf(a.result);a.priority=-1!==c?c:axe.constants.CANTTELL_PRIO,\"none\"===b&&(a.priority=4-a.priority)});var c={all:b.all.reduce(function(a,b){return Math.max(a,b.priority)},0),none:b.none.reduce(function(a,b){return Math.max(a,b.priority)},0),any:b.any.reduce(function(a,b){return Math.min(a,b.priority)},4)%4};b.priority=Math.max(c.all,c.none,c.any);var d=[];return Ja.forEach(function(a){b[a]=b[a].filter(function(d){return d.priority===b.priority&&d.priority===c[a]}),b[a].forEach(function(a){return d.push(a.impact)})}),[Ga,Ha].includes(b.priority)?b.impact=axe.utils.aggregate(axe.constants.impact,d):b.impact=null,E(b,function(a){delete a.result,delete a.priority}),b.result=axe.constants.results[b.priority],delete b.priority,b},function(){axe.utils.aggregateNodeResults=function(a){var b={};if((a=a.map(function(a){if(a.any&&a.all&&a.none)return axe.utils.aggregateChecks(a);if(Array.isArray(a.node))return axe.utils.finalizeRuleResult(a);throw new TypeError(\"Invalid Result type\")}))&&a.length){var c=a.map(function(a){return a.result});b.result=axe.utils.aggregate(axe.constants.results,c,b.result)}else b.result=\"inapplicable\";axe.constants.resultGroups.forEach(function(a){return b[a]=[]}),a.forEach(function(a){var c=axe.constants.resultGroupMap[a.result];b[c].push(a)});var d=axe.constants.FAIL_GROUP;if(0===b[d].length&&(d=axe.constants.CANTTELL_GROUP),b[d].length>0){var e=b[d].map(function(a){return a.impact});b.impact=axe.utils.aggregate(axe.constants.impact,e)||null}else b.impact=null;return b}}(),axe.utils.aggregateResult=function(a){var b={};return axe.constants.resultGroups.forEach(function(a){return b[a]=[]}),a.forEach(function(a){a.error?F(b,a,axe.constants.CANTTELL_GROUP):a.result===axe.constants.NA?F(b,a,axe.constants.NA_GROUP):axe.constants.resultGroups.forEach(function(c){Array.isArray(a[c])&&a[c].length>0&&F(b,a,c)})}),b},axe.utils.areStylesSet=G,axe.utils.checkHelper=function(a,b,c,d){\"use strict\";return{isAsync:!1,async:function(){return this.isAsync=!0,function(b){b instanceof Error==!1?(a.result=b,c(a)):d(b)}},data:function(b){a.data=b},relatedNodes:function(c){c=c instanceof Node?[c]:axe.utils.toArray(c),a.relatedNodes=c.map(function(a){return new axe.utils.DqElement(a,b)})}}};var za=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};axe.utils.clone=function(a){\"use strict\";var b,c,d=a;if(null!==a&&\"object\"===(void 0===a?\"undefined\":za(a)))if(Array.isArray(a))for(d=[],b=0,c=a.length;b<c;b++)d[b]=axe.utils.clone(a[b]);else{d={};for(b in a)d[b]=axe.utils.clone(a[b])}return d},axe.utils.sendCommandToFrame=function(a,b,c,d){\"use strict\";var e=a.contentWindow;if(!e)return axe.log(\"Frame does not have a content window\",a),void c(null);var f=setTimeout(function(){f=setTimeout(function(){var e=H(\"No response from frame\",a);b.debug?d(e):(axe.log(e),c(null))},0)},500);axe.utils.respondable(e,\"axe.ping\",null,void 0,function(){clearTimeout(f);var g=b.options&&b.options.frameWaitTime||6e4;f=setTimeout(function(){d(H(\"Axe in frame timed out\",a))},g),axe.utils.respondable(e,\"axe.start\",b,void 0,function(a){clearTimeout(f),a instanceof Error==!1?c(a):d(a)})})},axe.utils.collectResultsFromFrames=I,axe.utils.contains=function(a,b){\"use strict\";function c(a,b){return a.shadowId===b.shadowId||!!a.children.find(function(a){return c(a,b)})}return a.shadowId||b.shadowId?c(a,b):\"function\"==typeof a.actualNode.contains?a.actualNode.contains(b.actualNode):!!(16&a.actualNode.compareDocumentPosition(b.actualNode))},function(axe){/*!\n  * The copyright below covers the code within this function block only\n  *\n  * Copyright (c) 2013 Dulin Marat\n  * \n  * Permission is hereby granted, free of charge, to any person obtaining a copy\n  * of this software and associated documentation files (the \"Software\"), to deal\n  * in the Software without restriction, including without limitation the rights\n  * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell\n  * copies of the Software, and to permit persons to whom the Software is\n  * furnished to do so, subject to the following conditions:\n  * \n  * The above copyright notice and this permission notice shall be included in\n  * all copies or substantial portions of the Software.\n  * \n  * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n  * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n  * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n  * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n  * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\n  * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN\n  * THE SOFTWARE.\n  */\nfunction a(){this.pseudos={},this.attrEqualityMods={},this.ruleNestingOperators={},this.substitutesEnabled=!1}function b(a){return a>=\"a\"&&a<=\"z\"||a>=\"A\"&&a<=\"Z\"||\"-\"===a||\"_\"===a}function c(a){return a>=\"a\"&&a<=\"z\"||a>=\"A\"&&a<=\"Z\"||a>=\"0\"&&a<=\"9\"||\"-\"===a||\"_\"===a}function d(a){return a>=\"a\"&&a<=\"f\"||a>=\"A\"&&a<=\"F\"||a>=\"0\"&&a<=\"9\"}function e(a,e,g,j,k,l){var m,n,o,p,q;return p=a.length,m=null,o=function(b,c){var f,g,h;for(h=\"\",e++,m=a.charAt(e);e<p;){if(m===b)return e++,h;if(\"\\\\\"===m)if(e++,(m=a.charAt(e))===b)h+=b;else if(f=c[m])h+=f;else{if(d(m)){for(g=m,e++,m=a.charAt(e);d(m);)g+=m,e++,m=a.charAt(e);\" \"===m&&(e++,m=a.charAt(e)),h+=String.fromCharCode(parseInt(g,16));continue}h+=m}else h+=m;e++,m=a.charAt(e)}return h},n=function(){var b=\"\";for(m=a.charAt(e);e<p;){if(c(m))b+=m;else{if(\"\\\\\"!==m)return b;if(++e>=p)throw Error(\"Expected symbol but end of file reached.\");if(m=a.charAt(e),f[m])b+=m;else{if(d(m)){var g=m;for(e++,m=a.charAt(e);d(m);)g+=m,e++,m=a.charAt(e);\" \"===m&&(e++,m=a.charAt(e)),b+=String.fromCharCode(parseInt(g,16));continue}b+=m}}e++,m=a.charAt(e)}return b},q=function(){m=a.charAt(e);for(var b=!1;\" \"===m||\"\\t\"===m||\"\\n\"===m||\"\\r\"===m||\"\\f\"===m;)b=!0,e++,m=a.charAt(e);return b},this.parse=function(){var b=this.parseSelector();if(e<p)throw Error('Rule expected but \"'+a.charAt(e)+'\" found.');return b},this.parseSelector=function(){var b,c=b=this.parseSingleSelector();for(m=a.charAt(e);\",\"===m;){if(e++,q(),\"selectors\"!==b.type&&(b={type:\"selectors\",selectors:[c]}),!(c=this.parseSingleSelector()))throw Error('Rule expected after \",\".');b.selectors.push(c)}return b},this.parseSingleSelector=function(){q();var b={type:\"ruleSet\"},c=this.parseRule();if(!c)return null;for(var d=b;c&&(c.type=\"rule\",d.rule=c,d=c,q(),m=a.charAt(e),!(e>=p||\",\"===m||\")\"===m));)if(k[m]){var f=m;if(e++,q(),!(c=this.parseRule()))throw Error('Rule expected after \"'+f+'\".');c.nestingOperator=f}else(c=this.parseRule())&&(c.nestingOperator=null);return b},this.parseRule=function(){for(var c=null;e<p;)if(\"*\"===(m=a.charAt(e)))e++,(c=c||{}).tagName=\"*\";else if(b(m)||\"\\\\\"===m)(c=c||{}).tagName=n();else if(\".\"===m)e++,c=c||{},(c.classNames=c.classNames||[]).push(n());else if(\"#\"===m)e++,(c=c||{}).id=n();else if(\"[\"===m){e++,q();var d={name:n()};if(q(),\"]\"===m)e++;else{var f=\"\";if(j[m]&&(f=m,e++,m=a.charAt(e)),e>=p)throw Error('Expected \"=\" but end of file reached.');if(\"=\"!==m)throw Error('Expected \"=\" but \"'+m+'\" found.');d.operator=f+\"=\",e++,q();var k=\"\";if(d.valueType=\"string\",'\"'===m)k=o('\"',i);else if(\"'\"===m)k=o(\"'\",h);else if(l&&\"$\"===m)e++,k=n(),d.valueType=\"substitute\";else{for(;e<p&&\"]\"!==m;)k+=m,e++,m=a.charAt(e);k=k.trim()}if(q(),e>=p)throw Error('Expected \"]\" but end of file reached.');if(\"]\"!==m)throw Error('Expected \"]\" but \"'+m+'\" found.');e++,d.value=k}c=c||{},(c.attrs=c.attrs||[]).push(d)}else{if(\":\"!==m)break;e++;var r=n(),s={name:r};if(\"(\"===m){e++;var t=\"\";if(q(),\"selector\"===g[r])s.valueType=\"selector\",t=this.parseSelector();else{if(s.valueType=g[r]||\"string\",'\"'===m)t=o('\"',i);else if(\"'\"===m)t=o(\"'\",h);else if(l&&\"$\"===m)e++,t=n(),s.valueType=\"substitute\";else{for(;e<p&&\")\"!==m;)t+=m,e++,m=a.charAt(e);t=t.trim()}q()}if(e>=p)throw Error('Expected \")\" but end of file reached.');if(\")\"!==m)throw Error('Expected \")\" but \"'+m+'\" found.');e++,s.value=t}c=c||{},(c.pseudos=c.pseudos||[]).push(s)}return c},this}a.prototype.registerSelectorPseudos=function(a){for(var b=0,c=arguments.length;b<c;b++)a=arguments[b],this.pseudos[a]=\"selector\";return this},a.prototype.unregisterSelectorPseudos=function(a){for(var b=0,c=arguments.length;b<c;b++)a=arguments[b],delete this.pseudos[a];return this},a.prototype.registerNumericPseudos=function(a){for(var b=0,c=arguments.length;b<c;b++)a=arguments[b],this.pseudos[a]=\"numeric\";return this},a.prototype.unregisterNumericPseudos=function(a){for(var b=0,c=arguments.length;b<c;b++)a=arguments[b],delete this.pseudos[a];return this},a.prototype.registerNestingOperators=function(a){for(var b=0,c=arguments.length;b<c;b++)a=arguments[b],this.ruleNestingOperators[a]=!0;return this},a.prototype.unregisterNestingOperators=function(a){for(var b=0,c=arguments.length;b<c;b++)a=arguments[b],delete this.ruleNestingOperators[a];return this},a.prototype.registerAttrEqualityMods=function(a){for(var b=0,c=arguments.length;b<c;b++)a=arguments[b],this.attrEqualityMods[a]=!0;return this},a.prototype.unregisterAttrEqualityMods=function(a){for(var b=0,c=arguments.length;b<c;b++)a=arguments[b],delete this.attrEqualityMods[a];return this},a.prototype.enableSubstitutes=function(){return this.substitutesEnabled=!0,this},a.prototype.disableSubstitutes=function(){return this.substitutesEnabled=!1,this};var f={\"!\":!0,'\"':!0,\"#\":!0,$:!0,\"%\":!0,\"&\":!0,\"'\":!0,\"(\":!0,\")\":!0,\"*\":!0,\"+\":!0,\",\":!0,\".\":!0,\"/\":!0,\";\":!0,\"<\":!0,\"=\":!0,\">\":!0,\"?\":!0,\"@\":!0,\"[\":!0,\"\\\\\":!0,\"]\":!0,\"^\":!0,\"`\":!0,\"{\":!0,\"|\":!0,\"}\":!0,\"~\":!0},g={\"\\n\":\"\\\\n\",\"\\r\":\"\\\\r\",\"\\t\":\"\\\\t\",\"\\f\":\"\\\\f\",\"\\v\":\"\\\\v\"},h={n:\"\\n\",r:\"\\r\",t:\"\\t\",f:\"\\f\",\"\\\\\":\"\\\\\",\"'\":\"'\"},i={n:\"\\n\",r:\"\\r\",t:\"\\t\",f:\"\\f\",\"\\\\\":\"\\\\\",'\"':'\"'};a.prototype.parse=function(a){return new e(a,0,this.pseudos,this.attrEqualityMods,this.ruleNestingOperators,this.substitutesEnabled).parse()},a.prototype.escapeIdentifier=function(a){for(var b=\"\",c=0,d=a.length;c<d;){var e=a.charAt(c);if(f[e])b+=\"\\\\\"+e;else if(\"_\"===e||\"-\"===e||e>=\"A\"&&e<=\"Z\"||e>=\"a\"&&e<=\"z\"||0!==c&&e>=\"0\"&&e<=\"9\")b+=e;else{var g=e.charCodeAt(0);if(55296==(63488&g)){var h=a.charCodeAt(c++);if(55296!=(64512&g)||56320!=(64512&h))throw Error(\"UCS-2(decode): illegal sequence\");g=((1023&g)<<10)+(1023&h)+65536}b+=\"\\\\\"+g.toString(16)+\" \"}c++}return b},a.prototype.escapeStr=function(a){for(var b,c,d=\"\",e=0,f=a.length;e<f;)b=a.charAt(e),'\"'===b?b='\\\\\"':\"\\\\\"===b?b=\"\\\\\\\\\":(c=g[b])&&(b=c),d+=b,e++;return'\"'+d+'\"'},a.prototype.render=function(a){return this._renderEntity(a).trim()},a.prototype._renderEntity=function(a){var b,c,d;switch(d=\"\",a.type){case\"ruleSet\":for(b=a.rule,c=[];b;)b.nestingOperator&&c.push(b.nestingOperator),c.push(this._renderEntity(b)),b=b.rule;d=c.join(\" \");break;case\"selectors\":d=a.selectors.map(this._renderEntity,this).join(\", \");break;case\"rule\":a.tagName&&(d=\"*\"===a.tagName?\"*\":this.escapeIdentifier(a.tagName)),a.id&&(d+=\"#\"+this.escapeIdentifier(a.id)),a.classNames&&(d+=a.classNames.map(function(a){return\".\"+this.escapeIdentifier(a)},this).join(\"\")),a.attrs&&(d+=a.attrs.map(function(a){return a.operator?\"substitute\"===a.valueType?\"[\"+this.escapeIdentifier(a.name)+a.operator+\"$\"+a.value+\"]\":\"[\"+this.escapeIdentifier(a.name)+a.operator+this.escapeStr(a.value)+\"]\":\"[\"+this.escapeIdentifier(a.name)+\"]\"},this).join(\"\")),a.pseudos&&(d+=a.pseudos.map(function(a){return a.valueType?\"selector\"===a.valueType?\":\"+this.escapeIdentifier(a.name)+\"(\"+this._renderEntity(a.value)+\")\":\"substitute\"===a.valueType?\":\"+this.escapeIdentifier(a.name)+\"($\"+a.value+\")\":\"numeric\"===a.valueType?\":\"+this.escapeIdentifier(a.name)+\"(\"+a.value+\")\":\":\"+this.escapeIdentifier(a.name)+\"(\"+this.escapeIdentifier(a.value)+\")\":\":\"+this.escapeIdentifier(a.name)},this).join(\"\"));break;default:throw Error('Unknown entity type: \"'+a.type(NaN))}return d};var j=new a;j.registerNestingOperators(\">\"),axe.utils.cssParser=j}(axe),L.prototype={get selector(){return this.spec.selector||[axe.utils.getSelector(this.element,this._options)]},get xpath(){return this.spec.xpath||[axe.utils.getXpath(this.element)]},get element(){return this._element},get fromFrame(){return this._fromFrame},toJSON:function(){\"use strict\";return{selector:this.selector,source:this.source,xpath:this.xpath}}},L.fromFrame=function(a,b,c){return a.selector.unshift(c.selector),a.xpath.unshift(c.xpath),new axe.utils.DqElement(c.element,b,a)},axe.utils.DqElement=L,axe.utils.matchesSelector=function(){\"use strict\";function a(a){var b,c,d=a.Element.prototype,e=[\"matches\",\"matchesSelector\",\"mozMatchesSelector\",\"webkitMatchesSelector\",\"msMatchesSelector\"],f=e.length;for(b=0;b<f;b++)if(c=e[b],d[c])return c}var b;return function(c,d){return b&&c[b]||(b=a(c.ownerDocument.defaultView)),c[b](d)}}(),axe.utils.escapeSelector=function(a){\"use strict\";for(var b,c=String(a),d=c.length,e=-1,f=\"\",g=c.charCodeAt(0);++e<d;){if(0==(b=c.charCodeAt(e)))throw new Error(\"INVALID_CHARACTER_ERR\");b>=1&&b<=31||b>=127&&b<=159||0==e&&b>=48&&b<=57||1==e&&b>=48&&b<=57&&45==g?f+=\"\\\\\"+b.toString(16)+\" \":f+=(1!=e||45!=b||45!=g)&&(b>=128||45==b||95==b||b>=48&&b<=57||b>=65&&b<=90||b>=97&&b<=122)?c.charAt(e):\"\\\\\"+c.charAt(e)}return f},axe.utils.extendMetaData=function(a,b){Object.assign(a,b),Object.keys(b).filter(function(a){return\"function\"==typeof b[a]}).forEach(function(c){a[c]=null;try{a[c]=b[c](a)}catch(a){}})},axe.utils.finalizeRuleResult=function(a){return Object.assign(a,axe.utils.aggregateNodeResults(a.nodes)),delete a.nodes,a};var za=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};axe.utils.findBy=function(a,b,c){if(Array.isArray(a))return a.find(function(a){return\"object\"===(void 0===a?\"undefined\":za(a))&&a[b]===c})};var axe=axe||{utils:{}};axe.utils.getFlattenedTree=function(a,b){function c(a,c){var d=axe.utils.getFlattenedTree(c,b);return d&&(a=a.concat(d)),a}var d,e,f;if(a.documentElement&&(a=a.documentElement),f=a.nodeName.toLowerCase(),axe.utils.isShadowRoot(a))return d=M(a,b),b=\"a\"+Math.random().toString().substring(2),e=Array.from(a.shadowRoot.childNodes),d.children=e.reduce(c,[]),[d];if(\"content\"===f)return e=Array.from(a.getDistributedNodes()),e.reduce(c,[]);if(\"slot\"===f){e=Array.from(a.assignedNodes()),e.length||(e=N(a));window.getComputedStyle(a);return e.reduce(c,[])}return 1===a.nodeType?(d=M(a,b),e=Array.from(a.childNodes),d.children=e.reduce(c,[]),[d]):3===a.nodeType?[M(a)]:void 0},axe.utils.getNodeFromTree=function(a,b){var c;return a.actualNode===b?a:(a.children.forEach(function(a){var d;a.actualNode===b?c=a:(d=axe.utils.getNodeFromTree(a,b))&&(c=d)}),c)},axe.utils.getAllChecks=function(a){\"use strict\";return[].concat(a.any||[]).concat(a.all||[]).concat(a.none||[])},axe.utils.getCheckOption=function(a,b,c){var d=((c.rules&&c.rules[b]||{}).checks||{})[a.id],e=(c.checks||{})[a.id],f=a.enabled,g=a.options;return e&&(e.hasOwnProperty(\"enabled\")&&(f=e.enabled),e.hasOwnProperty(\"options\")&&(g=e.options)),d&&(d.hasOwnProperty(\"enabled\")&&(f=d.enabled),d.hasOwnProperty(\"options\")&&(g=d.options)),{enabled:f,options:g,absolutePaths:c.absolutePaths}};var Ka=function(){function a(a,b){var c=[],d=!0,e=!1,f=void 0;try{for(var g,h=a[Symbol.iterator]();!(d=(g=h.next()).done)&&(c.push(g.value),!b||c.length!==b);d=!0);}catch(a){e=!0,f=a}finally{try{!d&&h.return&&h.return()}finally{if(e)throw f}}return c}return function(b,c){if(Array.isArray(b))return b;if(Symbol.iterator in Object(b))return a(b,c);throw new TypeError(\"Invalid attempt to destructure non-iterable instance\")}}();axe.utils.getFriendlyUriEnd=function(){var a=arguments.length>0&&void 0!==arguments[0]?arguments[0]:\"\",b=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!(a.length<=1||\"data:\"===a.substr(0,5)||\"javascript:\"===a.substr(0,11)||a.includes(\"?\"))){var c=b.currentDomain,d=b.maxLength,e=void 0===d?25:d,f=Q(a),g=f.path,h=f.domain,i=f.hash,j=g.substr(g.substr(0,g.length-2).lastIndexOf(\"/\")+1);if(i)return j&&(j+i).length<=e?j+i:j.length<2&&i.length>2&&i.length<=e?i:void 0;if(h&&h.length<e&&g.length<=1)return h+g;if(g===\"/\"+j&&h&&c&&h!==c&&(h+g).length<=e)return h+g;var k=j.lastIndexOf(\".\");return(-1===k||k>1)&&(-1!==k||j.length>2)&&j.length<=e&&!j.match(/index(\\.[a-zA-Z]{2-4})?/)&&!O(j)?j:void 0}};var La=axe.utils.escapeSelector,Ma=void 0,Na=[\"class\",\"style\",\"id\",\"selected\",\"checked\",\"disabled\",\"tabindex\",\"aria-checked\",\"aria-selected\",\"aria-invalid\",\"aria-activedescendant\",\"aria-busy\",\"aria-disabled\",\"aria-expanded\",\"aria-grabbed\",\"aria-pressed\",\"aria-valuenow\"],Oa=31;axe.utils.getSelectorData=function(a){var b={classes:{},tags:{},attributes:{}};a=Array.isArray(a)?a:[a];for(var c=a.slice(),d=[];c.length;)!function(){var a=c.pop(),e=a.actualNode;if(e.querySelectorAll){var f=e.nodeName;b.tags[f]?b.tags[f]++:b.tags[f]=1,e.classList&&Array.from(e.classList).forEach(function(a){var c=La(a);b.classes[c]?b.classes[c]++:b.classes[c]=1}),e.attributes&&Array.from(e.attributes).filter(T).forEach(function(a){var c=R(e,a);c&&(b.attributes[c]?b.attributes[c]++:b.attributes[c]=1)})}for(a.children.length&&(d.push(c),c=a.children.slice());!c.length&&d.length;)c=d.pop()}();return b},axe.utils.getSelector=function(a){var b=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!a)return\"\";var c=a.getRootNode&&a.getRootNode()||document;if(11===c.nodeType){for(var d=[];11===c.nodeType;)d.push({elm:a,doc:c}),a=c.host,c=a.getRootNode();return d.push({elm:a,doc:c}),d.reverse().map(function(a){return $(a.elm,b,a.doc)})}return $(a,b,c)},axe.utils.getXpath=function(a){return aa(_(a))};var Pa;axe.utils.injectStyle=ba,axe.utils.isHidden=function(a,b){\"use strict\";var c;if(9===a.nodeType)return!1;11===a.nodeType&&(a=a.host);var d=window.getComputedStyle(a,null);return!d||!a.parentNode||\"none\"===d.getPropertyValue(\"display\")||!b&&\"hidden\"===d.getPropertyValue(\"visibility\")||\"true\"===a.getAttribute(\"aria-hidden\")||(c=a.assignedSlot?a.assignedSlot:a.parentNode,axe.utils.isHidden(c,!0))};var Qa=[\"article\",\"aside\",\"blockquote\",\"body\",\"div\",\"footer\",\"h1\",\"h2\",\"h3\",\"h4\",\"h5\",\"h6\",\"header\",\"main\",\"nav\",\"p\",\"section\",\"span\"];axe.utils.isShadowRoot=function(a){var b=a.nodeName.toLowerCase();return!(!a.shadowRoot||!/^[a-z][a-z0-9_.-]*-[a-z0-9_.-]*$/.test(b)&&!Qa.includes(b))},axe.utils.isXHTML=function(a){\"use strict\";return!!a.createElement&&\"A\"===a.createElement(\"A\").localName},axe.utils.mergeResults=function(a,b){\"use strict\";var c=[];return a.forEach(function(a){var d=ea(a);d&&d.length&&d.forEach(function(d){d.nodes&&a.frame&&ca(d.nodes,b,a.frameElement,a.frame);var e=axe.utils.findBy(c,\"id\",d.id);e?d.nodes.length&&da(e.nodes,d.nodes):c.push(d)})}),c},axe.utils.nodeSorter=function(a,b){\"use strict\";return a.actualNode===b.actualNode?0:4&a.actualNode.compareDocumentPosition(b.actualNode)?-1:1},utils.performanceTimer=function(){\"use strict\";function a(){if(window.performance&&window.performance)return window.performance.now()}var b=null,c=a();return{start:function(){this.mark(\"mark_axe_start\")},end:function(){this.mark(\"mark_axe_end\"),this.measure(\"axe\",\"mark_axe_start\",\"mark_axe_end\"),this.logMeasures(\"axe\")},auditStart:function(){this.mark(\"mark_audit_start\")},auditEnd:function(){this.mark(\"mark_audit_end\"),this.measure(\"audit_start_to_end\",\"mark_audit_start\",\"mark_audit_end\"),this.logMeasures()},mark:function(a){window.performance&&void 0!==window.performance.mark&&window.performance.mark(a)},measure:function(a,b,c){window.performance&&void 0!==window.performance.measure&&window.performance.measure(a,b,c)},logMeasures:function(a){function b(a){axe.log(\"Measure \"+a.name+\" took \"+a.duration+\"ms\")}if(window.performance&&void 0!==window.performance.getEntriesByType)for(var c=window.performance.getEntriesByType(\"measure\"),d=0;d<c.length;++d){var e=c[d];if(e.name===a)return void b(e);b(e)}},timeElapsed:function(){return a()-c},reset:function(){b||(b=a()),c=a()}}}(),\"function\"!=typeof Object.assign&&function(){Object.assign=function(a){\"use strict\";if(void 0===a||null===a)throw new TypeError(\"Cannot convert undefined or null to object\");for(var b=Object(a),c=1;c<arguments.length;c++){var d=arguments[c];if(void 0!==d&&null!==d)for(var e in d)d.hasOwnProperty(e)&&(b[e]=d[e])}return b}}(),Array.prototype.find||Object.defineProperty(Array.prototype,\"find\",{value:function(a){if(null===this)throw new TypeError(\"Array.prototype.find called on null or undefined\");if(\"function\"!=typeof a)throw new TypeError(\"predicate must be a function\");for(var b,c=Object(this),d=c.length>>>0,e=arguments[1],f=0;f<d;f++)if(b=c[f],a.call(e,b,f,c))return b}}),axe.utils.pollyfillElementsFromPoint=function(){if(document.elementsFromPoint)return document.elementsFromPoint;if(document.msElementsFromPoint)return document.msElementsFromPoint;var a=function(){var a=document.createElement(\"x\");return a.style.cssText=\"pointer-events:auto\",\"auto\"===a.style.pointerEvents}(),b=a?\"pointer-events\":\"visibility\",c=a?\"none\":\"hidden\",d=document.createElement(\"style\");return d.innerHTML=a?\"* { pointer-events: all }\":\"* { visibility: visible }\",function(a,e){var f,g,h,i=[],j=[];for(document.head.appendChild(d);(f=document.elementFromPoint(a,e))&&-1===i.indexOf(f);)i.push(f),j.push({value:f.style.getPropertyValue(b),priority:f.style.getPropertyPriority(b)}),f.style.setProperty(b,c,\"important\");for(i.indexOf(document.documentElement)<i.length-1&&(i.splice(i.indexOf(document.documentElement),1),i.push(document.documentElement)),g=j.length;h=j[--g];)i[g].style.setProperty(b,h.value?h.value:\"\",h.priority);return document.head.removeChild(d),i}},\"function\"==typeof window.addEventListener&&(document.elementsFromPoint=axe.utils.pollyfillElementsFromPoint()),Array.prototype.includes||Object.defineProperty(Array.prototype,\"includes\",{value:function(a){\"use strict\";var b=Object(this),c=parseInt(b.length,10)||0;if(0===c)return!1;var d,e=parseInt(arguments[1],10)||0;e>=0?d=e:(d=c+e)<0&&(d=0);for(var f;d<c;){if(f=b[d],a===f||a!==a&&f!==f)return!0;d++}return!1}}),Array.prototype.some||Object.defineProperty(Array.prototype,\"some\",{value:function(a){\"use strict\";if(null==this)throw new TypeError(\"Array.prototype.some called on null or undefined\");if(\"function\"!=typeof a)throw new TypeError;for(var b=Object(this),c=b.length>>>0,d=arguments.length>=2?arguments[1]:void 0,e=0;e<c;e++)if(e in b&&a.call(d,b[e],e,b))return!0;return!1}}),Array.from||Object.defineProperty(Array,\"from\",{value:function(){var a=Object.prototype.toString,b=function(b){return\"function\"==typeof b||\"[object Function]\"===a.call(b)},c=function(a){var b=Number(a);return isNaN(b)?0:0!==b&&isFinite(b)?(b>0?1:-1)*Math.floor(Math.abs(b)):b},d=Math.pow(2,53)-1,e=function(a){var b=c(a);return Math.min(Math.max(b,0),d)};return function(a){var c=this,d=Object(a);if(null==a)throw new TypeError(\"Array.from requires an array-like object - not null or undefined\");var f,g=arguments.length>1?arguments[1]:void 0;if(void 0!==g){if(!b(g))throw new TypeError(\"Array.from: when provided, the second argument must be a function\");arguments.length>2&&(f=arguments[2])}for(var h,i=e(d.length),j=b(c)?Object(new c(i)):new Array(i),k=0;k<i;)h=d[k],j[k]=g?void 0===f?g(h,k):g.call(f,h,k):h,k+=1;return j.length=i,j}}()}),String.prototype.includes||(String.prototype.includes=function(a,b){return\"number\"!=typeof b&&(b=0),!(b+a.length>this.length)&&-1!==this.indexOf(a,b)});var za=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};axe.utils.publishMetaData=function(a){\"use strict\";var b=axe._audit.data.checks||{},c=axe._audit.data.rules||{},d=axe.utils.findBy(axe._audit.rules,\"id\",a.id)||{};a.tags=axe.utils.clone(d.tags||[]);var e=ga(b,!0),f=ga(b,!1);a.nodes.forEach(function(a){a.any.forEach(e),a.all.forEach(e),a.none.forEach(f)}),axe.utils.extendMetaData(a,axe.utils.clone(c[a.id]||{}))};var Ra=function(){},Sa=function(){},Ta=function(){/*! Credit: XRegExp 0.6.1 (c) 2007-2008 Steven Levithan <http://stevenlevithan.com/regex/xregexp/> MIT License */\nvar a=/(?=[\\-\\[\\]{}()*+?.\\\\\\^$|,#\\s])/g;return function(b){return b.replace(a,\"\\\\\")}}(),Ua=/\\\\/g;Ra=function(a){return a.map(function(a){for(var b=[],c=a.rule;c;)b.push({tag:c.tagName?c.tagName.toLowerCase():\"*\",combinator:c.nestingOperator?c.nestingOperator:\" \",id:c.id,attributes:ma(c.attrs),classes:na(c.classNames),pseudos:oa(c.pseudos)}),c=c.rule;return b})},Sa=function(a,b,c,d){for(var e=[],f=Array.isArray(a)?a:[a],g=pa(f,b,[],a[0].shadowId),h=[];g.nodes.length;){for(var i=g.nodes.pop(),j=[],k=[],l=g.anyLevel.slice().concat(g.thisLevel),m=!1,n=0;n<l.length;n++){var o=l[n];if(qa(i,o)&&(!o[0].id||i.shadowId===g.parentShadowId))if(1===o.length)m||d&&!d(i)||(h.push(i),m=!0);else{var p=o.slice(1);if(!1===[\" \",\">\"].includes(p[0].combinator))throw new Error(\"axe.utils.querySelectorAll does not support the combinator: \"+o[1].combinator);\">\"===p[0].combinator?j.push(p):k.push(p)}!g.anyLevel.includes(o)||o[0].id&&i.shadowId!==g.parentShadowId||k.push(o)}for(i.children&&i.children.length&&c&&(e.push(g),g=pa(i.children,k,j,i.shadowId));!g.nodes.length&&e.length;)g=e.pop()}return h},axe.utils.querySelectorAll=function(a,b){return axe.utils.querySelectorAllFilter(a,b)},axe.utils.querySelectorAllFilter=function(a,b,c){a=Array.isArray(a)?a:[a];var d=axe.utils.cssParser.parse(b);return d=d.selectors?d.selectors:[d],d=Ra(d),Sa(a,d,!0,c)};var za=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};!function(){\"use strict\";function a(){}function b(a){if(\"function\"!=typeof a)throw new TypeError(\"Queue methods require functions as arguments\")}function c(){function c(b){return function(c){g[b]=c,(i-=1)||j===a||(k=!0,j(g))}}function d(b){return j=a,m(b),g}function e(){for(var a=g.length;h<a;h++){var b=g[h];try{b.call(null,c(h),d)}catch(a){d(a)}}}var f,g=[],h=0,i=0,j=a,k=!1,l=function(a){f=a,setTimeout(function(){void 0!==f&&null!==f&&axe.log(\"Uncaught error (of queue)\",f)},1)},m=l,n={defer:function(a){if(\"object\"===(void 0===a?\"undefined\":za(a))&&a.then&&a.catch){var c=a;a=function(a,b){c.then(a).catch(b)}}if(b(a),void 0===f){if(k)throw new Error(\"Queue already completed\");return g.push(a),++i,e(),n}},then:function(c){if(b(c),j!==a)throw new Error(\"queue `then` already set\");return f||(j=c,i||(k=!0,j(g))),n},catch:function(a){if(b(a),m!==l)throw new Error(\"queue `catch` already set\");return f?(a(f),f=null):m=a,n},abort:d};return n}axe.utils.queue=c}();var za=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};!function(a){\"use strict\";function b(){var a=\"axe\",b=\"\";return void 0!==axe&&axe._audit&&!axe._audit.application&&(a=axe._audit.application),void 0!==axe&&(b=axe.version),a+\".\"+b}function c(a){if(\"object\"===(void 0===a?\"undefined\":za(a))&&\"string\"==typeof a.uuid&&!0===a._respondable){var c=b();return a._source===c||\"axe.x.y.z\"===a._source||\"axe.x.y.z\"===c}return!1}function d(a,c,d,e,f,g){var h;d instanceof Error&&(h={name:d.name,message:d.message,stack:d.stack},d=void 0);var i={uuid:e,topic:c,message:d,error:h,_respondable:!0,_source:b(),_keepalive:f};\"function\"==typeof g&&(j[e]=g),a.postMessage(JSON.stringify(i),\"*\")}function e(a,b,c,e,f){d(a,b,c,Va.v1(),e,f)}function f(a,b,c){return function(e,f,g){d(a,b,e,c,f,g)}}function g(a,b,c){var d=b.topic,e=k[d];if(e){var g=f(a,null,b.uuid);e(b.message,c,g)}}function h(a){var b=a.message||\"Unknown error occurred\",c=l.includes(a.name)?a.name:\"Error\",d=window[c]||Error;return a.stack&&(b+=\"\\n\"+a.stack.replace(a.message,\"\")),new d(b)}function i(a){var b;if(\"string\"==typeof a){try{b=JSON.parse(a)}catch(a){}if(c(b))return\"object\"===za(b.error)?b.error=h(b.error):b.error=void 0,b}}var j={},k={},l=Object.freeze([\"EvalError\",\"RangeError\",\"ReferenceError\",\"SyntaxError\",\"TypeError\",\"URIError\"]);e.subscribe=function(a,b){k[a]=b},e.isInFrame=function(a){return a=a||window,!!a.frameElement},\"function\"==typeof window.addEventListener&&window.addEventListener(\"message\",function(a){var b=i(a.data);if(b){var c=b.uuid,e=b._keepalive,h=j[c];if(h){h(b.error||b.message,e,f(a.source,b.topic,c)),e||delete j[c]}if(!b.error)try{g(a.source,b,e)}catch(e){d(a.source,b.topic,e,c,!1)}}},!1),a.respondable=e}(utils),axe.utils.ruleShouldRun=function(a,b,c){\"use strict\";var d=c.runOnly||{},e=(c.rules||{})[a.id];return!(a.pageLevel&&!b.page)&&(\"rule\"===d.type?-1!==d.values.indexOf(a.id):e&&\"boolean\"==typeof e.enabled?e.enabled:\"tag\"===d.type&&d.values?ra(a,d.values):ra(a,[]))},axe.utils.getScrollState=function(){var a=arguments.length>0&&void 0!==arguments[0]?arguments[0]:window,b=a.document.documentElement;return[void 0!==a.pageXOffset?{elm:a,top:a.pageYOffset,left:a.pageXOffset}:{elm:b,top:b.scrollTop,left:b.scrollLeft}].concat(ua(document.body))},axe.utils.setScrollState=function(a){a.forEach(function(a){return ta(a.elm,a.top,a.left)})},axe.utils.select=function(a,b){\"use strict\";var c,d=[];if(axe._selectCache)for(var e=0,f=axe._selectCache.length;e<f;e++){var g=axe._selectCache[e];if(g.selector===a)return g.result}for(var h=function(a){return function(b){return wa(b,a)}}(b),i=ya(b.include),j=0;j<i.length;j++)c=i[j],c.actualNode.nodeType===c.actualNode.ELEMENT_NODE&&axe.utils.matchesSelector(c.actualNode,a)&&h(c)&&(d=xa(d,[c])),d=xa(d,axe.utils.querySelectorAllFilter(c,a,h));return axe._selectCache&&axe._selectCache.push({selector:a,result:d}),d},axe.utils.toArray=function(a){\"use strict\";return Array.prototype.slice.call(a)},axe.utils.uniqueArray=function(a,b){return a.concat(b).filter(function(a,b,c){return c.indexOf(a)===b})};var Va;!function(a){function b(a,b,c){var d=b&&c||0,e=0;for(b=b||[],a.toLowerCase().replace(/[0-9a-f]{2}/g,function(a){e<16&&(b[d+e++]=l[a])});e<16;)b[d+e++]=0;return b}function c(a,b){var c=b||0,d=k;return d[a[c++]]+d[a[c++]]+d[a[c++]]+d[a[c++]]+\"-\"+d[a[c++]]+d[a[c++]]+\"-\"+d[a[c++]]+d[a[c++]]+\"-\"+d[a[c++]]+d[a[c++]]+\"-\"+d[a[c++]]+d[a[c++]]+d[a[c++]]+d[a[c++]]+d[a[c++]]+d[a[c++]]}function d(a,b,d){var e=b&&d||0,f=b||[];a=a||{};var g=null!=a.clockseq?a.clockseq:p,h=null!=a.msecs?a.msecs:(new Date).getTime(),i=null!=a.nsecs?a.nsecs:r+1,j=h-q+(i-r)/1e4;if(j<0&&null==a.clockseq&&(g=g+1&16383),(j<0||h>q)&&null==a.nsecs&&(i=0),i>=1e4)throw new Error(\"uuid.v1(): Can't create more than 10M uuids/sec\");q=h,r=i,p=g,h+=122192928e5;var k=(1e4*(268435455&h)+i)%4294967296;f[e++]=k>>>24&255,f[e++]=k>>>16&255,f[e++]=k>>>8&255,f[e++]=255&k;var l=h/4294967296*1e4&268435455;f[e++]=l>>>8&255,f[e++]=255&l,f[e++]=l>>>24&15|16,f[e++]=l>>>16&255,f[e++]=g>>>8|128,f[e++]=255&g;for(var m=a.node||o,n=0;n<6;n++)f[e+n]=m[n];return b||c(f)}function e(a,b,d){var e=b&&d||0;\"string\"==typeof a&&(b=\"binary\"==a?new j(16):null,a=null),a=a||{};var g=a.random||(a.rng||f)();if(g[6]=15&g[6]|64,g[8]=63&g[8]|128,b)for(var h=0;h<16;h++)b[e+h]=g[h];return b||c(g)}var f,g=a.crypto||a.msCrypto;if(!f&&g&&g.getRandomValues){var h=new Uint8Array(16);f=function(){return g.getRandomValues(h),h}}if(!f){var i=new Array(16);f=function(){for(var a,b=0;b<16;b++)0==(3&b)&&(a=4294967296*Math.random()),i[b]=a>>>((3&b)<<3)&255;return i}}for(var j=\"function\"==typeof a.Buffer?a.Buffer:Array,k=[],l={},m=0;m<256;m++)k[m]=(m+256).toString(16).substr(1),l[k[m]]=m;var n=f(),o=[1|n[0],n[1],n[2],n[3],n[4],n[5]],p=16383&(n[6]<<8|n[7]),q=0,r=0;Va=e,Va.v1=d,Va.v4=e,Va.parse=b,Va.unparse=c,Va.BufferClass=j}(window),axe._load({data:{rules:{accesskeys:{description:\"Ensures every accesskey attribute value is unique\",help:\"accesskey attribute value must be unique\"},\"area-alt\":{description:\"Ensures <area> elements of image maps have alternate text\",help:\"Active <area> elements must have alternate text\"},\"aria-allowed-attr\":{description:\"Ensures ARIA attributes are allowed for an element's role\",help:\"Elements must only use allowed ARIA attributes\"},\"aria-hidden-body\":{description:\"Ensures aria-hidden='true' is not present on the document body.\",help:\"aria-hidden='true' must not be present on the document body\"},\"aria-required-attr\":{description:\"Ensures elements with ARIA roles have all required ARIA attributes\",help:\"Required ARIA attributes must be provided\"},\"aria-required-children\":{description:\"Ensures elements with an ARIA role that require child roles contain them\",help:\"Certain ARIA roles must contain particular children\"},\"aria-required-parent\":{description:\"Ensures elements with an ARIA role that require parent roles are contained by them\",help:\"Certain ARIA roles must be contained by particular parents\"},\"aria-roles\":{description:\"Ensures all elements with a role attribute use a valid value\",help:\"ARIA roles used must conform to valid values\"},\"aria-valid-attr-value\":{description:\"Ensures all ARIA attributes have valid values\",help:\"ARIA attributes must conform to valid values\"},\"aria-valid-attr\":{description:\"Ensures attributes that begin with aria- are valid ARIA attributes\",help:\"ARIA attributes must conform to valid names\"},\"audio-caption\":{description:\"Ensures <audio> elements have captions\",help:\"<audio> elements must have a captions track\"},blink:{description:\"Ensures <blink> elements are not used\",help:\"<blink> elements are deprecated and must not be used\"},\"button-name\":{description:\"Ensures buttons have discernible text\",help:\"Buttons must have discernible text\"},bypass:{description:\"Ensures each page has at least one mechanism for a user to bypass navigation and jump straight to the content\",help:\"Page must have means to bypass repeated blocks\"},checkboxgroup:{description:'Ensures related <input type=\"checkbox\"> elements have a group and that that group designation is consistent',help:\"Checkbox inputs with the same name attribute value must be part of a group\"},\"color-contrast\":{description:\"Ensures the contrast between foreground and background colors meets WCAG 2 AA contrast ratio thresholds\",help:\"Elements must have sufficient color contrast\"},\"definition-list\":{description:\"Ensures <dl> elements are structured correctly\",help:\"<dl> elements must only directly contain properly-ordered <dt> and <dd> groups, <script> or <template> elements\"},dlitem:{description:\"Ensures <dt> and <dd> elements are contained by a <dl>\",help:\"<dt> and <dd> elements must be contained by a <dl>\"},\"document-title\":{description:\"Ensures each HTML document contains a non-empty <title> element\",help:\"Documents must have <title> element to aid in navigation\"},\"duplicate-id\":{description:\"Ensures every id attribute value is unique\",help:\"id attribute value must be unique\"},\"empty-heading\":{description:\"Ensures headings have discernible text\",help:\"Headings must not be empty\"},\"focus-order-semantics\":{description:\"Ensures elements in the focus order have an appropriate role\",help:\"Elements in the focus order need a role appropriate for interactive content\"},\"frame-title-unique\":{description:\"Ensures <iframe> and <frame> elements contain a unique title attribute\",help:\"Frames must have a unique title attribute\"},\"frame-title\":{description:\"Ensures <iframe> and <frame> elements contain a non-empty title attribute\",help:\"Frames must have title attribute\"},\"heading-order\":{description:\"Ensures the order of headings is semantically correct\",help:\"Heading levels should only increase by one\"},\"hidden-content\":{description:\"Informs users about hidden content.\",help:\"Hidden content on the page cannot be analyzed\"},\"html-has-lang\":{description:\"Ensures every HTML document has a lang attribute\",help:\"<html> element must have a lang attribute\"},\"html-lang-valid\":{description:\"Ensures the lang attribute of the <html> element has a valid value\",help:\"<html> element must have a valid value for the lang attribute\"},\"image-alt\":{description:\"Ensures <img> elements have alternate text or a role of none or presentation\",help:\"Images must have alternate text\"},\"image-redundant-alt\":{description:\"Ensure button and link text is not repeated as image alternative\",help:\"Text of buttons and links should not be repeated in the image alternative\"},\"input-image-alt\":{description:'Ensures <input type=\"image\"> elements have alternate text',help:\"Image buttons must have alternate text\"},\"label-title-only\":{description:\"Ensures that every form element is not solely labeled using the title or aria-describedby attributes\",help:\"Form elements should have a visible label\"},label:{description:\"Ensures every form element has a label\",help:\"Form elements must have labels\"},\"landmark-main-is-top-level\":{description:\"The main landmark should not be contained in another landmark\",help:\"Main landmark is not at top level\"},\"landmark-one-main\":{description:\"Ensures a navigation point to the primary content of the page. If the page contains iframes, each iframe should contain either no main landmarks or just one.\",help:\"Page must contain one main landmark.\"},\"layout-table\":{description:\"Ensures presentational <table> elements do not use <th>, <caption> elements or the summary attribute\",help:\"Layout tables must not use data table elements\"},\"link-in-text-block\":{description:\"Links can be distinguished without relying on color\",help:\"Links must be distinguished from surrounding text in a way that does not rely on color\"},\"link-name\":{description:\"Ensures links have discernible text\",help:\"Links must have discernible text\"},list:{description:\"Ensures that lists are structured correctly\",help:\"<ul> and <ol> must only directly contain <li>, <script> or <template> elements\"},listitem:{description:\"Ensures <li> elements are used semantically\",help:\"<li> elements must be contained in a <ul> or <ol>\"},marquee:{description:\"Ensures <marquee> elements are not used\",help:\"<marquee> elements are deprecated and must not be used\"},\"meta-refresh\":{description:'Ensures <meta http-equiv=\"refresh\"> is not used',help:\"Timed refresh must not exist\"},\"meta-viewport-large\":{description:'Ensures <meta name=\"viewport\"> can scale a significant amount',help:\"Users should be able to zoom and scale the text up to 500%\"},\"meta-viewport\":{description:'Ensures <meta name=\"viewport\"> does not disable text scaling and zooming',help:\"Zooming and scaling must not be disabled\"},\"object-alt\":{description:\"Ensures <object> elements have alternate text\",help:\"<object> elements must have alternate text\"},\"p-as-heading\":{description:\"Ensure p elements are not used to style headings\",help:\"Bold, italic text and font-size are not used to style p elements as a heading\"},radiogroup:{description:'Ensures related <input type=\"radio\"> elements have a group and that the group designation is consistent',help:\"Radio inputs with the same name attribute value must be part of a group\"},region:{description:\"Ensures all content is contained within a landmark region\",help:\"Content should be contained in a landmark region\"},\"scope-attr-valid\":{description:\"Ensures the scope attribute is used correctly on tables\",help:\"scope attribute should be used correctly\"},\"server-side-image-map\":{description:\"Ensures that server-side image maps are not used\",help:\"Server-side image maps must not be used\"},\"skip-link\":{description:\"Ensure all skip links have a focusable target\",help:\"The skip-link target should exist and be focusable\"},tabindex:{description:\"Ensures tabindex attribute values are not greater than 0\",help:\"Elements should not have tabindex greater than zero\"},\"table-duplicate-name\":{description:\"Ensure that tables do not have the same summary and caption\",help:\"The <caption> element should not contain the same text as the summary attribute\"},\"table-fake-caption\":{description:\"Ensure that tables with a caption use the <caption> element.\",help:\"Data or header cells should not be used to give caption to a data table.\"},\"td-has-header\":{description:\"Ensure that each non-empty data cell in a large table has one or more table headers\",help:\"All non-empty td element in table larger than 3 by 3 must have an associated table header\"},\"td-headers-attr\":{description:\"Ensure that each cell in a table using the headers refers to another cell in that table\",help:\"All cells in a table element that use the headers attribute must only refer to other cells of that same table\"},\"th-has-data-cells\":{description:\"Ensure that each table header in a data table refers to data cells\",help:\"All th elements and elements with role=columnheader/rowheader must have data cells they describe\"},\"valid-lang\":{description:\"Ensures lang attributes have valid values\",help:\"lang attribute must have a valid value\"},\"video-caption\":{description:\"Ensures <video> elements have captions\",help:\"<video> elements must have captions\"},\"video-description\":{description:\"Ensures <video> elements have audio descriptions\",help:\"<video> elements must have an audio description track\"}},checks:{accesskeys:{impact:\"serious\",messages:{pass:function(a){return\"Accesskey attribute value is unique\"},fail:function(a){return\"Document has multiple elements with the same accesskey\"}}},\"non-empty-alt\":{impact:\"critical\",messages:{pass:function(a){return\"Element has a non-empty alt attribute\"},fail:function(a){return\"Element has no alt attribute or the alt attribute is empty\"}}},\"non-empty-title\":{impact:\"serious\",messages:{pass:function(a){return\"Element has a title attribute\"},fail:function(a){return\"Element has no title attribute or the title attribute is empty\"}}},\"aria-label\":{impact:\"serious\",messages:{pass:function(a){return\"aria-label attribute exists and is not empty\"},fail:function(a){return\"aria-label attribute does not exist or is empty\"}}},\"aria-labelledby\":{impact:\"serious\",messages:{pass:function(a){return\"aria-labelledby attribute exists and references elements that are visible to screen readers\"},fail:function(a){return\"aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty or not visible\"}}},\"aria-allowed-attr\":{impact:\"critical\",messages:{pass:function(a){return\"ARIA attributes are used correctly for the defined role\"},fail:function(a){var b=\"ARIA attribute\"+(a.data&&a.data.length>1?\"s are\":\" is\")+\" not allowed:\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},\"aria-hidden-body\":{impact:\"critical\",messages:{pass:function(a){return\"No aria-hidden attribute is present on document body\"},fail:function(a){return\"aria-hidden=true should not be present on the document body\"}}},\"aria-required-attr\":{impact:\"critical\",messages:{pass:function(a){return\"All required ARIA attributes are present\"},fail:function(a){var b=\"Required ARIA attribute\"+(a.data&&a.data.length>1?\"s\":\"\")+\" not present:\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},\"aria-required-children\":{impact:\"critical\",messages:{pass:function(a){return\"Required ARIA children are present\"},fail:function(a){var b=\"Required ARIA \"+(a.data&&a.data.length>1?\"children\":\"child\")+\" role not present:\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},\"aria-required-parent\":{impact:\"critical\",messages:{pass:function(a){return\"Required ARIA parent role present\"},fail:function(a){var b=\"Required ARIA parent\"+(a.data&&a.data.length>1?\"s\":\"\")+\" role not present:\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},invalidrole:{impact:\"critical\",messages:{pass:function(a){return\"ARIA role is valid\"},fail:function(a){return\"Role must be one of the valid ARIA roles\"}}},abstractrole:{impact:\"serious\",messages:{pass:function(a){return\"Abstract roles are not used\"},fail:function(a){return\"Abstract roles cannot be directly used\"}}},\"aria-valid-attr-value\":{impact:\"critical\",messages:{pass:function(a){return\"ARIA attribute values are valid\"},fail:function(a){var b=\"Invalid ARIA attribute value\"+(a.data&&a.data.length>1?\"s\":\"\")+\":\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},\"aria-errormessage\":{impact:\"critical\",messages:{pass:function(a){return\"Uses a supported aria-errormessage technique\"},fail:function(a){var b=\"aria-errormessage value\"+(a.data&&a.data.length>1?\"s\":\"\")+\" \",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" `\"+d;return b+=\"` must use a technique to announce the message (e.g., aria-live, aria-describedby, role=alert, etc.)\"}}},\"aria-valid-attr\":{impact:\"critical\",messages:{pass:function(a){return\"ARIA attribute name\"+(a.data&&a.data.length>1?\"s\":\"\")+\" are valid\"},fail:function(a){var b=\"Invalid ARIA attribute name\"+(a.data&&a.data.length>1?\"s\":\"\")+\":\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},caption:{impact:\"critical\",messages:{pass:function(a){return\"The multimedia element has a captions track\"},fail:function(a){return\"The multimedia element does not have a captions track\"},incomplete:function(a){return\"A captions track for this element could not be found\"}}},\"is-on-screen\":{impact:\"serious\",messages:{pass:function(a){return\"Element is not visible\"},fail:function(a){return\"Element is visible\"}}},\"non-empty-if-present\":{impact:\"critical\",messages:{pass:function(a){var b=\"Element \";return a.data?b+=\"has a non-empty value attribute\":b+=\"does not have a value attribute\",b},fail:function(a){return\"Element has a value attribute and the value attribute is empty\"}}},\"non-empty-value\":{impact:\"critical\",messages:{pass:function(a){return\"Element has a non-empty value attribute\"},fail:function(a){return\"Element has no value attribute or the value attribute is empty\"}}},\"button-has-visible-text\":{impact:\"critical\",messages:{pass:function(a){return\"Element has inner text that is visible to screen readers\"},fail:function(a){return\"Element does not have inner text that is visible to screen readers\"}}},\"role-presentation\":{impact:\"minor\",messages:{pass:function(a){return'Element\\'s default semantics were overriden with role=\"presentation\"'},fail:function(a){return'Element\\'s default semantics were not overridden with role=\"presentation\"'}}},\"role-none\":{impact:\"minor\",messages:{pass:function(a){return'Element\\'s default semantics were overriden with role=\"none\"'},fail:function(a){return'Element\\'s default semantics were not overridden with role=\"none\"'}}},\"focusable-no-name\":{impact:\"serious\",messages:{pass:function(a){return\"Element is not in tab order or has accessible text\"},fail:function(a){return\"Element is in tab order and does not have accessible text\"}}},\"internal-link-present\":{impact:\"serious\",messages:{pass:function(a){return\"Valid skip link found\"},fail:function(a){return\"No valid skip link found\"}}},\"header-present\":{impact:\"serious\",messages:{pass:function(a){return\"Page has a header\"},fail:function(a){return\"Page does not have a header\"}}},landmark:{impact:\"serious\",messages:{pass:function(a){return\"Page has a landmark region\"},fail:function(a){return\"Page does not have a landmark region\"}}},\"group-labelledby\":{impact:\"critical\",messages:{pass:function(a){return'All elements with the name \"'+a.data.name+'\" reference the same element with aria-labelledby'},fail:function(a){return'All elements with the name \"'+a.data.name+'\" do not reference the same element with aria-labelledby'}}},fieldset:{impact:\"critical\",messages:{pass:function(a){return\"Element is contained in a fieldset\"},fail:function(a){var b=\"\",c=a.data&&a.data.failureCode;return b+=\"no-legend\"===c?\"Fieldset does not have a legend as its first child\":\"empty-legend\"===c?\"Legend does not have text that is visible to screen readers\":\"mixed-inputs\"===c?\"Fieldset contains unrelated inputs\":\"no-group-label\"===c?\"ARIA group does not have aria-label or aria-labelledby\":\"group-mixed-inputs\"===c?\"ARIA group contains unrelated inputs\":\"Element does not have a containing fieldset or ARIA group\"}}},\"color-contrast\":{impact:\"serious\",messages:{pass:function(a){return\"Element has sufficient color contrast of \"+a.data.contrastRatio},fail:function(a){return\"Element has insufficient color contrast of \"+a.data.contrastRatio+\" (foreground color: \"+a.data.fgColor+\", background color: \"+a.data.bgColor+\", font size: \"+a.data.fontSize+\", font weight: \"+a.data.fontWeight+\"). Expected contrast ratio of \"+a.data.expectedContrastRatio},incomplete:{bgImage:\"Element's background color could not be determined due to a background image\",bgGradient:\"Element's background color could not be determined due to a background gradient\",imgNode:\"Element's background color could not be determined because element contains an image node\",bgOverlap:\"Element's background color could not be determined because it is overlapped by another element\",fgAlpha:\"Element's foreground color could not be determined because of alpha transparency\",elmPartiallyObscured:\"Element's background color could not be determined because it's partially obscured by another element\",elmPartiallyObscuring:\"Element's background color could not be determined because it partially overlaps other elements\",outsideViewport:\"Element's background color could not be determined because it's outside the viewport\",equalRatio:\"Element has a 1:1 contrast ratio with the background\",default:\"Unable to determine contrast ratio\"}}},\"structured-dlitems\":{impact:\"serious\",messages:{pass:function(a){return\"When not empty, element has both <dt> and <dd> elements\"},fail:function(a){return\"When not empty, element does not have at least one <dt> element followed by at least one <dd> element\"}}},\"only-dlitems\":{impact:\"serious\",messages:{pass:function(a){return\"List element only has direct children that are allowed inside <dt> or <dd> elements\"},fail:function(a){return\"List element has direct children that are not allowed inside <dt> or <dd> elements\"}}},dlitem:{impact:\"serious\",messages:{pass:function(a){return\"Description list item has a <dl> parent element\"},fail:function(a){return\"Description list item does not have a <dl> parent element\"}}},\"doc-has-title\":{impact:\"serious\",messages:{pass:function(a){return\"Document has a non-empty <title> element\"},fail:function(a){return\"Document does not have a non-empty <title> element\"}}},\"duplicate-id\":{impact:\"moderate\",messages:{pass:function(a){return\"Document has no elements that share the same id attribute\"},fail:function(a){return\"Document has multiple elements with the same id attribute: \"+a.data}}},\"has-visible-text\":{impact:\"minor\",messages:{pass:function(a){return\"Element has text that is visible to screen readers\"},fail:function(a){return\"Element does not have text that is visible to screen readers\"}}},\"has-widget-role\":{impact:\"minor\",messages:{pass:function(a){return\"Element has a widget role.\"},fail:function(a){return\"Element does not have a widget role.\"}}},\"valid-scrollable-semantics\":{impact:\"minor\",messages:{pass:function(a){return\"Element has valid semantics for an element in the focus order.\"},fail:function(a){return\"Element has invalid semantics for an element in the focus order.\"}}},\"unique-frame-title\":{impact:\"serious\",messages:{pass:function(a){return\"Element's title attribute is unique\"},fail:function(a){return\"Element's title attribute is not unique\"}}},\"heading-order\":{impact:\"moderate\",messages:{pass:function(a){return\"Heading order valid\"},fail:function(a){return\"Heading order invalid\"}}},\"hidden-content\":{impact:\"minor\",messages:{pass:function(a){return\"All content on the page has been analyzed.\"},fail:function(a){return\"There were problems analyzing the content on this page.\"},incomplete:function(a){return\"There is hidden content on the page that was not analyzed. You will need to trigger the display of this content in order to analyze it.\"}}},\"has-lang\":{impact:\"serious\",messages:{pass:function(a){return\"The <html> element has a lang attribute\"},fail:function(a){return\"The <html> element does not have a lang attribute\"}}},\"valid-lang\":{impact:\"serious\",messages:{pass:function(a){return\"Value of lang attribute is included in the list of valid languages\"},fail:function(a){return\"Value of lang attribute not included in the list of valid languages\"}}},\"has-alt\":{impact:\"critical\",messages:{pass:function(a){return\"Element has an alt attribute\"},fail:function(a){return\"Element does not have an alt attribute\"}}},\"duplicate-img-label\":{impact:\"minor\",messages:{pass:function(a){return\"Element does not duplicate existing text in <img> alt text\"},fail:function(a){return\"Element contains <img> element with alt text that duplicates existing text\"}}},\"title-only\":{impact:\"serious\",messages:{pass:function(a){return\"Form element does not solely use title attribute for its label\"},fail:function(a){return\"Only title used to generate label for form element\"}}},\"implicit-label\":{impact:\"critical\",messages:{pass:function(a){return\"Form element has an implicit (wrapped) <label>\"},fail:function(a){return\"Form element does not have an implicit (wrapped) <label>\"}}},\"explicit-label\":{impact:\"critical\",messages:{pass:function(a){return\"Form element has an explicit <label>\"},fail:function(a){return\"Form element does not have an explicit <label>\"}}},\"help-same-as-label\":{impact:\"minor\",messages:{pass:function(a){return\"Help text (title or aria-describedby) does not duplicate label text\"},fail:function(a){return\"Help text (title or aria-describedby) text is the same as the label text\"}}},\"multiple-label\":{impact:\"serious\",messages:{pass:function(a){return\"Form element does not have multiple <label> elements\"},fail:function(a){return\"Form element has multiple <label> elements\"}}},\"main-is-top-level\":{impact:\"moderate\",messages:{pass:function(a){return\"The main landmark is at the top level.\"},fail:function(a){return\"The main landmark is contained in another landmark.\"}}},\"has-at-least-one-main\":{impact:\"moderate\",messages:{pass:function(a){return\"Document has at least one main landmark\"},fail:function(a){return\"Document has no main landmarks\"}}},\"has-no-more-than-one-main\":{impact:\"moderate\",messages:{pass:function(a){return\"Document has no more than one main landmark\"},fail:function(a){return\"Document has more than one main landmark\"}}},\"has-th\":{impact:\"serious\",messages:{pass:function(a){return\"Layout table does not use <th> elements\"},fail:function(a){return\"Layout table uses <th> elements\"}}},\"has-caption\":{impact:\"serious\",messages:{pass:function(a){return\"Layout table does not use <caption> element\"},fail:function(a){return\"Layout table uses <caption> element\"}}},\"has-summary\":{impact:\"serious\",messages:{pass:function(a){return\"Layout table does not use summary attribute\"},fail:function(a){return\"Layout table uses summary attribute\"}}},\"link-in-text-block\":{impact:\"serious\",messages:{pass:function(a){return\"Links can be distinguished from surrounding text in some way other than by color\"},fail:function(a){return\"Links need to be distinguished from surrounding text in some way other than by color\"},incomplete:{bgContrast:\"Element's contrast ratio could not be determined. Check for a distinct hover/focus style\",bgImage:\"Element's contrast ratio could not be determined due to a background image\",bgGradient:\"Element's contrast ratio could not be determined due to a background gradient\",imgNode:\"Element's contrast ratio could not be determined because element contains an image node\",bgOverlap:\"Element's contrast ratio could not be determined because of element overlap\",default:\"Unable to determine contrast ratio\"}}},\"only-listitems\":{impact:\"serious\",messages:{pass:function(a){return\"List element only has direct children that are allowed inside <li> elements\"},fail:function(a){return\"List element has direct children that are not allowed inside <li> elements\"}}},listitem:{impact:\"serious\",messages:{pass:function(a){return'List item has a <ul>, <ol> or role=\"list\" parent element'},fail:function(a){return'List item does not have a <ul>, <ol> or role=\"list\" parent element'}}},\"meta-refresh\":{impact:\"critical\",messages:{pass:function(a){return\"<meta> tag does not immediately refresh the page\"},fail:function(a){return\"<meta> tag forces timed refresh of page\"}}},\"meta-viewport-large\":{impact:\"minor\",messages:{pass:function(a){\nreturn\"<meta> tag does not prevent significant zooming on mobile devices\"},fail:function(a){return\"<meta> tag limits zooming on mobile devices\"}}},\"meta-viewport\":{impact:\"critical\",messages:{pass:function(a){return\"<meta> tag does not disable zooming on mobile devices\"},fail:function(a){return\"<meta> tag disables zooming on mobile devices\"}}},\"p-as-heading\":{impact:\"serious\",messages:{pass:function(a){return\"<p> elements are not styled as headings\"},fail:function(a){return\"Heading elements should be used instead of styled p elements\"}}},region:{impact:\"moderate\",messages:{pass:function(a){return\"Content contained by ARIA landmark\"},fail:function(a){return\"Content not contained by an ARIA landmark\"}}},\"html5-scope\":{impact:\"moderate\",messages:{pass:function(a){return\"Scope attribute is only used on table header elements (<th>)\"},fail:function(a){return\"In HTML 5, scope attributes may only be used on table header elements (<th>)\"}}},\"scope-value\":{impact:\"critical\",messages:{pass:function(a){return\"Scope attribute is used correctly\"},fail:function(a){return\"The value of the scope attribute may only be 'row' or 'col'\"}}},exists:{impact:\"minor\",messages:{pass:function(a){return\"Element does not exist\"},fail:function(a){return\"Element exists\"}}},\"skip-link\":{impact:\"moderate\",messages:{pass:function(a){return\"Skip link target exists\"},incomplete:function(a){return\"Skip link target should become visible on activation\"},fail:function(a){return\"No skip link target\"}}},tabindex:{impact:\"serious\",messages:{pass:function(a){return\"Element does not have a tabindex greater than 0\"},fail:function(a){return\"Element has a tabindex greater than 0\"}}},\"same-caption-summary\":{impact:\"minor\",messages:{pass:function(a){return\"Content of summary attribute and <caption> are not duplicated\"},fail:function(a){return\"Content of summary attribute and <caption> element are identical\"}}},\"caption-faked\":{impact:\"serious\",messages:{pass:function(a){return\"The first row of a table is not used as a caption\"},fail:function(a){return\"The first row of the table should be a caption instead of a table cell\"}}},\"td-has-header\":{impact:\"critical\",messages:{pass:function(a){return\"All non-empty data cells have table headers\"},fail:function(a){return\"Some non-empty data cells do not have table headers\"}}},\"td-headers-attr\":{impact:\"serious\",messages:{pass:function(a){return\"The headers attribute is exclusively used to refer to other cells in the table\"},fail:function(a){return\"The headers attribute is not exclusively used to refer to other cells in the table\"}}},\"th-has-data-cells\":{impact:\"serious\",messages:{pass:function(a){return\"All table header cells refer to data cells\"},fail:function(a){return\"Not all table header cells refer to data cells\"},incomplete:function(a){return\"Table data cells are missing or empty\"}}},description:{impact:\"critical\",messages:{pass:function(a){return\"The multimedia element has an audio description track\"},fail:function(a){return\"The multimedia element does not have an audio description track\"},incomplete:function(a){return\"An audio description track for this element could not be found\"}}}},failureSummaries:{any:{failureMessage:function(a){var b=\"Fix any of the following:\",c=a;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\"\\n  \"+d.split(\"\\n\").join(\"\\n  \");return b}},none:{failureMessage:function(a){var b=\"Fix all of the following:\",c=a;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\"\\n  \"+d.split(\"\\n\").join(\"\\n  \");return b}}},incompleteFallbackMessage:function(a){return\"aXe couldn't tell the reason. Time to break out the element inspector!\"}},rules:[{id:\"accesskeys\",selector:\"[accesskey]\",excludeHidden:!1,tags:[\"wcag2a\",\"wcag211\",\"cat.keyboard\"],all:[],any:[],none:[\"accesskeys\"]},{id:\"area-alt\",selector:\"map area[href]\",excludeHidden:!1,tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag111\",\"section508\",\"section508.22.a\"],all:[],any:[\"non-empty-alt\",\"non-empty-title\",\"aria-label\",\"aria-labelledby\"],none:[]},{id:\"aria-allowed-attr\",matches:function(a,b){var c=a.getAttribute(\"role\");c||(c=axe.commons.aria.implicitRole(a));var d=axe.commons.aria.allowedAttr(c);if(c&&d){var e=/^aria-/;if(a.hasAttributes())for(var f=a.attributes,g=0,h=f.length;g<h;g++)if(e.test(f[g].name))return!0}return!1},tags:[\"cat.aria\",\"wcag2a\",\"wcag411\",\"wcag412\"],all:[],any:[\"aria-allowed-attr\"],none:[]},{id:\"aria-hidden-body\",selector:\"body\",excludeHidden:!1,tags:[\"cat.aria\",\"wcag2a\",\"wcag412\"],all:[],any:[\"aria-hidden-body\"],none:[]},{id:\"aria-required-attr\",selector:\"[role]\",tags:[\"cat.aria\",\"wcag2a\",\"wcag411\",\"wcag412\"],all:[],any:[\"aria-required-attr\"],none:[]},{id:\"aria-required-children\",selector:\"[role]\",tags:[\"cat.aria\",\"wcag2a\",\"wcag131\"],all:[],any:[\"aria-required-children\"],none:[]},{id:\"aria-required-parent\",selector:\"[role]\",tags:[\"cat.aria\",\"wcag2a\",\"wcag131\"],all:[],any:[\"aria-required-parent\"],none:[]},{id:\"aria-roles\",selector:\"[role]\",tags:[\"cat.aria\",\"wcag2a\",\"wcag131\",\"wcag411\",\"wcag412\"],all:[],any:[],none:[\"invalidrole\",\"abstractrole\"]},{id:\"aria-valid-attr-value\",matches:function(a,b){var c=/^aria-/;if(a.hasAttributes())for(var d=a.attributes,e=0,f=d.length;e<f;e++)if(c.test(d[e].name))return!0;return!1},tags:[\"cat.aria\",\"wcag2a\",\"wcag131\",\"wcag411\",\"wcag412\"],all:[{options:[],id:\"aria-valid-attr-value\"},\"aria-errormessage\"],any:[],none:[]},{id:\"aria-valid-attr\",matches:function(a,b){var c=/^aria-/;if(a.hasAttributes())for(var d=a.attributes,e=0,f=d.length;e<f;e++)if(c.test(d[e].name))return!0;return!1},tags:[\"cat.aria\",\"wcag2a\",\"wcag411\"],all:[],any:[{options:[],id:\"aria-valid-attr\"}],none:[]},{id:\"audio-caption\",selector:\"audio\",excludeHidden:!1,tags:[\"cat.time-and-media\",\"wcag2a\",\"wcag121\",\"section508\",\"section508.22.a\"],all:[],any:[],none:[\"caption\"]},{id:\"blink\",selector:\"blink\",excludeHidden:!1,tags:[\"cat.time-and-media\",\"wcag2a\",\"wcag222\",\"section508\",\"section508.22.j\"],all:[],any:[],none:[\"is-on-screen\"]},{id:\"button-name\",selector:'button, [role=\"button\"], input[type=\"button\"], input[type=\"submit\"], input[type=\"reset\"]',tags:[\"cat.name-role-value\",\"wcag2a\",\"wcag412\",\"section508\",\"section508.22.a\"],all:[],any:[\"non-empty-if-present\",\"non-empty-value\",\"button-has-visible-text\",\"aria-label\",\"aria-labelledby\",\"role-presentation\",\"role-none\"],none:[\"focusable-no-name\"]},{id:\"bypass\",selector:\"html\",pageLevel:!0,matches:function(a,b){return!!a.querySelector(\"a[href]\")},tags:[\"cat.keyboard\",\"wcag2a\",\"wcag241\",\"section508\",\"section508.22.o\"],all:[],any:[\"internal-link-present\",\"header-present\",\"landmark\"],none:[]},{id:\"checkboxgroup\",selector:\"input[type=checkbox][name]\",tags:[\"cat.forms\",\"best-practice\"],all:[],any:[\"group-labelledby\",\"fieldset\"],none:[]},{id:\"color-contrast\",matches:function(a,b){var c=a.nodeName.toUpperCase(),d=a.type;if(\"true\"===a.getAttribute(\"aria-disabled\")||axe.commons.dom.findUpVirtual(b,'[aria-disabled=\"true\"]'))return!1;if(\"INPUT\"===c)return-1===[\"hidden\",\"range\",\"color\",\"checkbox\",\"radio\",\"image\"].indexOf(d)&&!a.disabled;if(\"SELECT\"===c)return!!a.options.length&&!a.disabled;if(\"TEXTAREA\"===c)return!a.disabled;if(\"OPTION\"===c)return!1;if(\"BUTTON\"===c&&a.disabled||axe.commons.dom.findUpVirtual(b,\"button[disabled]\"))return!1;if(\"FIELDSET\"===c&&a.disabled||axe.commons.dom.findUpVirtual(b,\"fieldset[disabled]\"))return!1;var e=axe.commons.dom.findUpVirtual(b,\"label\");if(\"LABEL\"===c||e){var f=a,g=b;e&&(f=e,g=axe.utils.getNodeFromTree(axe._tree[0],e));var h=axe.commons.dom.getRootNode(f),i=f.htmlFor&&h.getElementById(f.htmlFor);if(i&&i.disabled)return!1;var i=axe.utils.querySelectorAll(g,'input:not([type=\"hidden\"]):not([type=\"image\"]):not([type=\"button\"]):not([type=\"submit\"]):not([type=\"reset\"]), select, textarea');if(i.length&&i[0].actualNode.disabled)return!1}if(a.getAttribute(\"id\")){var j=axe.commons.utils.escapeSelector(a.getAttribute(\"id\")),k=axe.commons.dom.getRootNode(a),i=k.querySelector(\"[aria-labelledby~=\"+j+\"]\");if(i&&i.disabled)return!1}if(\"\"===axe.commons.text.visibleVirtual(b,!1,!0))return!1;var l,m,n=document.createRange(),o=b.children,p=o.length;for(m=0;m<p;m++)l=o[m],3===l.actualNode.nodeType&&\"\"!==axe.commons.text.sanitize(l.actualNode.nodeValue)&&n.selectNodeContents(l.actualNode);var q=n.getClientRects();for(p=q.length,m=0;m<p;m++)if(axe.commons.dom.visuallyOverlaps(q[m],a))return!0;return!1},excludeHidden:!1,options:{noScroll:!1},tags:[\"cat.color\",\"wcag2aa\",\"wcag143\"],all:[],any:[\"color-contrast\"],none:[]},{id:\"definition-list\",selector:\"dl\",matches:function(a,b){return!a.getAttribute(\"role\")},tags:[\"cat.structure\",\"wcag2a\",\"wcag131\"],all:[],any:[],none:[\"structured-dlitems\",\"only-dlitems\"]},{id:\"dlitem\",selector:\"dd, dt\",matches:function(a,b){return!a.getAttribute(\"role\")},tags:[\"cat.structure\",\"wcag2a\",\"wcag131\"],all:[],any:[\"dlitem\"],none:[]},{id:\"document-title\",selector:\"html\",matches:function(a,b){return a.ownerDocument.defaultView.self===a.ownerDocument.defaultView.top},tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag242\"],all:[],any:[\"doc-has-title\"],none:[]},{id:\"duplicate-id\",selector:\"[id]\",excludeHidden:!1,tags:[\"cat.parsing\",\"wcag2a\",\"wcag411\"],all:[],any:[\"duplicate-id\"],none:[]},{id:\"empty-heading\",selector:'h1, h2, h3, h4, h5, h6, [role=\"heading\"]',matches:function(a,b){var c=void 0;return a.hasAttribute(\"role\")&&(c=a.getAttribute(\"role\").split(/\\s+/i).filter(axe.commons.aria.isValidRole)),c&&c.length>0?c.includes(\"heading\"):\"heading\"===axe.commons.aria.implicitRole(a)},tags:[\"cat.name-role-value\",\"best-practice\"],all:[],any:[\"has-visible-text\"],none:[]},{id:\"focus-order-semantics\",selector:\"div, h1, h2, h3, h4, h5, h6, [role=heading], p, span\",matches:function(a,b){return axe.commons.dom.insertedIntoFocusOrder(a)},tags:[\"cat.keyboard\",\"best-practice\",\"experimental\"],all:[],any:[{options:[],id:\"has-widget-role\"},{options:[],id:\"valid-scrollable-semantics\"}],none:[]},{id:\"frame-title-unique\",selector:\"frame[title], iframe[title]\",matches:function(a,b){var c=a.getAttribute(\"title\");return!!(c?axe.commons.text.sanitize(c).trim():\"\")},tags:[\"cat.text-alternatives\",\"best-practice\"],all:[],any:[],none:[\"unique-frame-title\"]},{id:\"frame-title\",selector:\"frame, iframe\",tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag241\",\"section508\",\"section508.22.i\"],all:[],any:[\"aria-label\",\"aria-labelledby\",\"non-empty-title\",\"role-presentation\",\"role-none\"],none:[]},{id:\"heading-order\",selector:\"h1, h2, h3, h4, h5, h6, [role=heading]\",matches:function(a,b){var c=void 0;return a.hasAttribute(\"role\")&&(c=a.getAttribute(\"role\").split(/\\s+/i).filter(axe.commons.aria.isValidRole)),c&&c.length>0?c.includes(\"heading\"):\"heading\"===axe.commons.aria.implicitRole(a)},tags:[\"cat.semantics\",\"best-practice\"],all:[],any:[\"heading-order\"],none:[]},{id:\"hidden-content\",selector:\"*\",excludeHidden:!1,tags:[\"experimental\",\"review-item\"],all:[],any:[\"hidden-content\"],none:[]},{id:\"html-has-lang\",selector:\"html\",tags:[\"cat.language\",\"wcag2a\",\"wcag311\"],all:[],any:[\"has-lang\"],none:[]},{id:\"html-lang-valid\",selector:\"html[lang]\",tags:[\"cat.language\",\"wcag2a\",\"wcag311\"],all:[],any:[],none:[\"valid-lang\"]},{id:\"image-alt\",selector:\"img, [role='img']:not(svg)\",tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag111\",\"section508\",\"section508.22.a\"],all:[],any:[\"has-alt\",\"aria-label\",\"aria-labelledby\",\"non-empty-title\",\"role-presentation\",\"role-none\"],none:[]},{id:\"image-redundant-alt\",selector:'button, [role=\"button\"], a[href], p, li, td, th',tags:[\"cat.text-alternatives\",\"best-practice\"],all:[],any:[],none:[\"duplicate-img-label\"]},{id:\"input-image-alt\",selector:'input[type=\"image\"]',tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag111\",\"section508\",\"section508.22.a\"],all:[],any:[\"non-empty-alt\",\"aria-label\",\"aria-labelledby\",\"non-empty-title\"],none:[]},{id:\"label-title-only\",selector:\"input, select, textarea\",matches:function(a,b){return\"input\"!==a.nodeName.toLowerCase()||!1===a.hasAttribute(\"type\")||!1===[\"hidden\",\"image\",\"button\",\"submit\",\"reset\"].includes(a.getAttribute(\"type\").toLowerCase())},tags:[\"cat.forms\",\"best-practice\"],all:[],any:[],none:[\"title-only\"]},{id:\"label\",selector:\"input, select, textarea\",matches:function(a,b){return\"input\"!==a.nodeName.toLowerCase()||!1===a.hasAttribute(\"type\")||!1===[\"hidden\",\"image\",\"button\",\"submit\",\"reset\"].includes(a.getAttribute(\"type\").toLowerCase())},tags:[\"cat.forms\",\"wcag2a\",\"wcag332\",\"wcag131\",\"section508\",\"section508.22.n\"],all:[],any:[\"aria-label\",\"aria-labelledby\",\"implicit-label\",\"explicit-label\",\"non-empty-title\"],none:[\"help-same-as-label\",\"multiple-label\"]},{id:\"landmark-main-is-top-level\",selector:\"main, [role=main]\",tags:[\"best-practice\"],all:[],any:[\"main-is-top-level\"],none:[]},{id:\"landmark-one-main\",selector:\"html\",tags:[\"best-practice\"],all:[\"has-at-least-one-main\",\"has-no-more-than-one-main\"],any:[],none:[]},{id:\"layout-table\",selector:\"table\",matches:function(a,b){return!axe.commons.table.isDataTable(a)},tags:[\"cat.semantics\",\"wcag2a\",\"wcag131\"],all:[],any:[],none:[\"has-th\",\"has-caption\",\"has-summary\"]},{id:\"link-in-text-block\",selector:\"a[href], [role=link]\",matches:function(a,b){var c=axe.commons.text.sanitize(a.textContent),d=a.getAttribute(\"role\");return(!d||\"link\"===d)&&(!!c&&(!!axe.commons.dom.isVisible(a,!1)&&axe.commons.dom.isInTextBlock(a)))},excludeHidden:!1,tags:[\"cat.color\",\"experimental\",\"wcag2a\",\"wcag141\"],all:[\"link-in-text-block\"],any:[],none:[]},{id:\"link-name\",selector:\"a[href], [role=link][href]\",matches:function(a,b){return\"button\"!==a.getAttribute(\"role\")},tags:[\"cat.name-role-value\",\"wcag2a\",\"wcag111\",\"wcag412\",\"wcag244\",\"section508\",\"section508.22.a\"],all:[],any:[\"has-visible-text\",\"aria-label\",\"aria-labelledby\",\"role-presentation\",\"role-none\"],none:[\"focusable-no-name\"]},{id:\"list\",selector:\"ul, ol\",matches:function(a,b){return!a.getAttribute(\"role\")},tags:[\"cat.structure\",\"wcag2a\",\"wcag131\"],all:[],any:[],none:[\"only-listitems\"]},{id:\"listitem\",selector:\"li\",matches:function(a,b){return!a.getAttribute(\"role\")},tags:[\"cat.structure\",\"wcag2a\",\"wcag131\"],all:[],any:[\"listitem\"],none:[]},{id:\"marquee\",selector:\"marquee\",excludeHidden:!1,tags:[\"cat.parsing\",\"wcag2a\",\"wcag222\"],all:[],any:[],none:[\"is-on-screen\"]},{id:\"meta-refresh\",selector:'meta[http-equiv=\"refresh\"]',excludeHidden:!1,tags:[\"cat.time\",\"wcag2a\",\"wcag2aaa\",\"wcag221\",\"wcag224\",\"wcag325\"],all:[],any:[\"meta-refresh\"],none:[]},{id:\"meta-viewport-large\",selector:'meta[name=\"viewport\"]',excludeHidden:!1,tags:[\"cat.sensory-and-visual-cues\",\"best-practice\"],all:[],any:[{options:{scaleMinimum:5,lowerBound:2},id:\"meta-viewport-large\"}],none:[]},{id:\"meta-viewport\",selector:'meta[name=\"viewport\"]',excludeHidden:!1,tags:[\"cat.sensory-and-visual-cues\",\"wcag2aa\",\"wcag144\"],all:[],any:[{options:{scaleMinimum:2},id:\"meta-viewport\"}],none:[]},{id:\"object-alt\",selector:\"object\",tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag111\",\"section508\",\"section508.22.a\"],all:[],any:[\"has-visible-text\",\"aria-label\",\"aria-labelledby\",\"non-empty-title\"],none:[]},{id:\"p-as-heading\",selector:\"p\",matches:function(a,b){var c=Array.from(a.parentNode.childNodes),d=a.textContent.trim(),e=/[.!?:;](?![.!?:;])/g;return!(0===d.length||(d.match(e)||[]).length>=2)&&0!==c.slice(c.indexOf(a)+1).filter(function(a){return\"P\"===a.nodeName.toUpperCase()&&\"\"!==a.textContent.trim()}).length},tags:[\"cat.semantics\",\"wcag2a\",\"wcag131\",\"experimental\"],all:[{options:{margins:[{weight:150,italic:!0},{weight:150,size:1.15},{italic:!0,size:1.15},{size:1.4}]},id:\"p-as-heading\"}],any:[],none:[]},{id:\"radiogroup\",selector:\"input[type=radio][name]\",tags:[\"cat.forms\",\"best-practice\"],all:[],any:[\"group-labelledby\",\"fieldset\"],none:[]},{id:\"region\",selector:\"html\",pageLevel:!0,tags:[\"cat.keyboard\",\"best-practice\"],all:[],any:[\"region\"],none:[]},{id:\"scope-attr-valid\",selector:\"td[scope], th[scope]\",tags:[\"cat.tables\",\"best-practice\"],all:[\"html5-scope\",\"scope-value\"],any:[],none:[]},{id:\"server-side-image-map\",selector:\"img[ismap]\",tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag211\",\"section508\",\"section508.22.f\"],all:[],any:[],none:[\"exists\"]},{id:\"skip-link\",selector:\"a[href]\",matches:function(a,b){var c=a.getAttribute(\"href\");return\"#\"===c[0]&&c.length>1},tags:[\"cat.keyboard\",\"best-practice\"],all:[],any:[\"skip-link\"],none:[]},{id:\"tabindex\",selector:\"[tabindex]\",tags:[\"cat.keyboard\",\"best-practice\"],all:[],any:[\"tabindex\"],none:[]},{id:\"table-duplicate-name\",selector:\"table\",tags:[\"cat.tables\",\"best-practice\"],all:[],any:[],none:[\"same-caption-summary\"]},{id:\"table-fake-caption\",selector:\"table\",matches:function(a,b){return axe.commons.table.isDataTable(a)},tags:[\"cat.tables\",\"experimental\",\"wcag2a\",\"wcag131\",\"section508\",\"section508.22.g\"],all:[\"caption-faked\"],any:[],none:[]},{id:\"td-has-header\",selector:\"table\",matches:function(a,b){if(axe.commons.table.isDataTable(a)){var c=axe.commons.table.toArray(a);return c.length>=3&&c[0].length>=3&&c[1].length>=3&&c[2].length>=3}return!1},tags:[\"cat.tables\",\"experimental\",\"wcag2a\",\"wcag131\",\"section508\",\"section508.22.g\"],all:[\"td-has-header\"],any:[],none:[]},{id:\"td-headers-attr\",selector:\"table\",tags:[\"cat.tables\",\"wcag2a\",\"wcag131\",\"section508\",\"section508.22.g\"],all:[\"td-headers-attr\"],any:[],none:[]},{id:\"th-has-data-cells\",selector:\"table\",matches:function(a,b){return axe.commons.table.isDataTable(a)},tags:[\"cat.tables\",\"wcag2a\",\"wcag131\",\"section508\",\"section508.22.g\"],all:[\"th-has-data-cells\"],any:[],none:[]},{id:\"valid-lang\",selector:\"[lang], [xml\\\\:lang]\",matches:function(a,b){return\"html\"!==a.nodeName.toLowerCase()},tags:[\"cat.language\",\"wcag2aa\",\"wcag312\"],all:[],any:[],none:[\"valid-lang\"]},{id:\"video-caption\",selector:\"video\",excludeHidden:!1,tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag122\",\"wcag123\",\"section508\",\"section508.22.a\"],all:[],any:[],none:[\"caption\"]},{id:\"video-description\",selector:\"video\",excludeHidden:!1,tags:[\"cat.text-alternatives\",\"wcag2aa\",\"wcag125\",\"section508\",\"section508.22.b\"],all:[],any:[],none:[\"description\"]}],checks:[{id:\"abstractrole\",evaluate:function(a,b,c){return\"abstract\"===axe.commons.aria.getRoleType(a.getAttribute(\"role\"))}},{id:\"aria-allowed-attr\",evaluate:function(a,b,c){b=b||{};var d,e,f,g=[],h=a.getAttribute(\"role\"),i=a.attributes;if(h||(h=axe.commons.aria.implicitRole(a)),f=axe.commons.aria.allowedAttr(h),Array.isArray(b[h])&&(f=axe.utils.uniqueArray(b[h].concat(f))),h&&f)for(var j=0,k=i.length;j<k;j++)d=i[j],e=d.name,axe.commons.aria.validateAttr(e)&&!f.includes(e)&&g.push(e+'=\"'+d.nodeValue+'\"');return!g.length||(this.data(g),!1)}},{id:\"aria-hidden-body\",evaluate:function(a,b,c){return\"true\"!==a.getAttribute(\"aria-hidden\")}},{id:\"aria-errormessage\",evaluate:function(a,b,c){b=Array.isArray(b)?b:[];var d=a.getAttribute(\"aria-errormessage\"),e=a.hasAttribute(\"aria-errormessage\"),f=axe.commons.dom.getRootNode(a);return!(-1===b.indexOf(d)&&e&&!function(){var b=d&&f.getElementById(d);if(b)return\"alert\"===b.getAttribute(\"role\")||\"assertive\"===b.getAttribute(\"aria-live\")||axe.utils.tokenList(a.getAttribute(\"aria-describedby\")||\"\").indexOf(d)>-1}())||(this.data(d),!1)}},{id:\"has-widget-role\",evaluate:function(a,b,c){var d=a.getAttribute(\"role\");if(null===d)return!1;var e=axe.commons.aria.getRoleType(d);return\"widget\"===e||\"composite\"===e},options:[]},{id:\"invalidrole\",evaluate:function(a,b,c){return!axe.commons.aria.isValidRole(a.getAttribute(\"role\"))}},{id:\"aria-required-attr\",evaluate:function(a,b,c){b=b||{};var d=[];if(a.hasAttributes()){var e,f=a.getAttribute(\"role\"),g=axe.commons.aria.requiredAttr(f);if(Array.isArray(b[f])&&(g=axe.utils.uniqueArray(b[f],g)),f&&g)for(var h=0,i=g.length;h<i;h++)e=g[h],a.getAttribute(e)||d.push(e)}return!d.length||(this.data(d),!1)}},{id:\"aria-required-children\",evaluate:function(a,b,c){function d(a,b,c,d){if(null===a)return!1;var e=g(c),f=['[role=\"'+c+'\"]'];return e&&(f=f.concat(e)),f=f.join(\",\"),d?h(a,f)||!!axe.utils.querySelectorAll(b,f)[0]:!!axe.utils.querySelectorAll(b,f)[0]}function e(a,b){var c,e;for(c=0,e=a.length;c<e;c++)if(null!==a[c]){var f=axe.utils.getNodeFromTree(axe._tree[0],a[c]);if(d(a[c],f,b,!0))return!0}return!1}var f=axe.commons.aria.requiredOwned,g=axe.commons.aria.implicitNodes,h=axe.commons.utils.matchesSelector,i=axe.commons.dom.idrefs,j=a.getAttribute(\"role\"),k=f(j);if(!k)return!0;var l=!1,m=k.one;if(!m){var l=!0;m=k.all}var n=function(a,b,f,g){var h,j=b.length,k=[],l=i(a,\"aria-owns\");for(h=0;h<j;h++){var m=b[h];if(d(a,c,m)||e(l,m)){if(!f)return null}else f&&k.push(m)}if(\"combobox\"===g){var n=k.indexOf(\"textbox\"),o=[\"text\",\"search\",\"email\",\"url\",\"tel\"];n>=0&&\"INPUT\"===a.tagName&&o.includes(a.type)&&k.splice(n,1);var p=k.indexOf(\"listbox\"),q=a.getAttribute(\"aria-expanded\");p>=0&&(!q||\"false\"===q)&&k.splice(p,1)}return k.length?k:!f&&b.length?b:null}(a,m,l,j);return!n||(this.data(n),!1)}},{id:\"aria-required-parent\",evaluate:function(a,b,c){function d(a){return(axe.commons.aria.implicitNodes(a)||[]).concat('[role=\"'+a+'\"]').join(\",\")}function e(a,b,c){var e,f,g=a.actualNode.getAttribute(\"role\"),h=[];if(b||(b=axe.commons.aria.requiredContext(g)),!b)return null;for(e=0,f=b.length;e<f;e++){if(c&&axe.utils.matchesSelector(a.actualNode,d(b[e])))return null;if(axe.commons.dom.findUpVirtual(a,d(b[e])))return null;h.push(b[e])}return h}var f=e(c);if(!f)return!0;var g=function(a){for(var b=[],c=null;a;){if(a.getAttribute(\"id\")){var d=axe.commons.utils.escapeSelector(a.getAttribute(\"id\"));c=axe.commons.dom.getRootNode(a).querySelector(\"[aria-owns~=\"+d+\"]\"),c&&b.push(c)}a=a.parentElement}return b.length?b:null}(a);if(g)for(var h=0,i=g.length;h<i;h++)if(!(f=e(axe.utils.getNodeFromTree(axe._tree[0],g[h]),f,!0)))return!0;return this.data(f),!1}},{id:\"aria-valid-attr-value\",evaluate:function(a,b,c){b=Array.isArray(b)?b:[];for(var d,e,f=[],g=/^aria-/,h=a.attributes,i=[\"aria-errormessage\"],j=0,k=h.length;j<k;j++)d=h[j],e=d.name,i.includes(e)||-1===b.indexOf(e)&&g.test(e)&&!axe.commons.aria.validateAttrValue(a,e)&&f.push(e+'=\"'+d.nodeValue+'\"');return!f.length||(this.data(f),!1)},options:[]},{id:\"aria-valid-attr\",evaluate:function(a,b,c){b=Array.isArray(b)?b:[];for(var d,e=[],f=/^aria-/,g=a.attributes,h=0,i=g.length;h<i;h++)d=g[h].name,-1===b.indexOf(d)&&f.test(d)&&!axe.commons.aria.validateAttr(d)&&e.push(d);return!e.length||(this.data(e),!1)},options:[]},{id:\"valid-scrollable-semantics\",evaluate:function(a,b,c){function d(a){var b=a.tagName.toUpperCase();return f[b]||!1}function e(a){var b=a.getAttribute(\"role\");return!!b&&(g[b.toLowerCase()]||!1)}var f={ARTICLE:!0,ASIDE:!0,NAV:!0,SECTION:!0},g={banner:!1,complementary:!0,contentinfo:!0,form:!0,main:!0,navigation:!0,region:!0,search:!1};return function(a){return e(a)||d(a)}(a)},options:[]},{id:\"color-contrast\",evaluate:function(a,b,c){if(!axe.commons.dom.isVisible(a,!1))return!0;var d,e=!!(b||{}).noScroll,f=[],g=axe.commons.color.getBackgroundColor(a,f,e),h=axe.commons.color.getForegroundColor(a,e),i=window.getComputedStyle(a),j=parseFloat(i.getPropertyValue(\"font-size\")),k=i.getPropertyValue(\"font-weight\"),l=-1!==[\"bold\",\"bolder\",\"600\",\"700\",\"800\",\"900\"].indexOf(k),m=axe.commons.color.hasValidContrastRatio(g,h,j,l),n=Math.floor(100*m.contrastRatio)/100;null===g&&(d=axe.commons.color.incompleteData.get(\"bgColor\"));var o=!1;1===n&&(o=!0,d=axe.commons.color.incompleteData.set(\"bgColor\",\"equalRatio\"));var p={fgColor:h?h.toHexString():void 0,bgColor:g?g.toHexString():void 0,contrastRatio:m?n:void 0,fontSize:(72*j/96).toFixed(1)+\"pt\",fontWeight:l?\"bold\":\"normal\",missingData:d,expectedContrastRatio:m.expectedContrastRatio+\":1\"};return this.data(p),null===h||null===g||o?(d=null,axe.commons.color.incompleteData.clear(),void this.relatedNodes(f)):(m.isValid||this.relatedNodes(f),m.isValid)}},{id:\"link-in-text-block\",evaluate:function(a,b,c){function d(a,b){var c=a.getRelativeLuminance(),d=b.getRelativeLuminance();return(Math.max(c,d)+.05)/(Math.min(c,d)+.05)}function e(a){var b=window.getComputedStyle(a).getPropertyValue(\"display\");return-1!==i.indexOf(b)||\"table-\"===b.substr(0,6)}var f=axe.commons,g=f.color,h=f.dom,i=[\"block\",\"list-item\",\"table\",\"flex\",\"grid\",\"inline-block\"];if(e(a))return!1;for(var j=h.getComposedParent(a);1===j.nodeType&&!e(j);)j=h.getComposedParent(j);if(this.relatedNodes([j]),g.elementIsDistinct(a,j))return!0;var k,l;if(k=g.getForegroundColor(a),l=g.getForegroundColor(j),k&&l){var m=d(k,l);if(1===m)return!0;if(m>=3)return axe.commons.color.incompleteData.set(\"fgColor\",\"bgContrast\"),this.data({missingData:axe.commons.color.incompleteData.get(\"fgColor\")}),void axe.commons.color.incompleteData.clear();if(k=g.getBackgroundColor(a),l=g.getBackgroundColor(j),!k||!l||d(k,l)>=3){var n=void 0;return n=k&&l?\"bgContrast\":axe.commons.color.incompleteData.get(\"bgColor\"),axe.commons.color.incompleteData.set(\"fgColor\",n),this.data({missingData:axe.commons.color.incompleteData.get(\"fgColor\")}),void axe.commons.color.incompleteData.clear()}return!1}}},{id:\"fieldset\",evaluate:function(a,b,c){function d(a,b){return axe.commons.utils.toArray(a.querySelectorAll('select,textarea,button,input:not([name=\"'+b+'\"]):not([type=\"hidden\"])'))}function e(a,b){var c=a.firstElementChild;if(!c||\"LEGEND\"!==c.nodeName.toUpperCase())return i.relatedNodes([a]),h=\"no-legend\",!1;if(!axe.commons.text.accessibleText(c))return i.relatedNodes([c]),h=\"empty-legend\",!1;var e=d(a,b);return!e.length||(i.relatedNodes(e),h=\"mixed-inputs\",!1)}function f(a,b){var c=axe.commons.dom.idrefs(a,\"aria-labelledby\").some(function(a){return a&&axe.commons.text.accessibleText(a)}),e=a.getAttribute(\"aria-label\");if(!(c||e&&axe.commons.text.sanitize(e)))return i.relatedNodes(a),h=\"no-group-label\",!1;var f=d(a,b);return!f.length||(i.relatedNodes(f),h=\"group-mixed-inputs\",!1)}function g(a,b){return axe.commons.utils.toArray(a).filter(function(a){return a!==b})}var h,i=this,j={name:a.getAttribute(\"name\"),type:a.getAttribute(\"type\")},k=function(a){var b=axe.commons.utils.escapeSelector(a.actualNode.name),c=axe.commons.dom.getRootNode(a.actualNode),d=c.querySelectorAll('input[type=\"'+axe.commons.utils.escapeSelector(a.actualNode.type)+'\"][name=\"'+b+'\"]');if(d.length<2)return!0;var j=axe.commons.dom.findUpVirtual(a,\"fieldset\"),k=axe.commons.dom.findUpVirtual(a,'[role=\"group\"]'+(\"radio\"===a.actualNode.type?',[role=\"radiogroup\"]':\"\"));return k||j?j?e(j,b):f(k,b):(h=\"no-group\",i.relatedNodes(g(d,a.actualNode)),!1)}(c);return k||(j.failureCode=h),this.data(j),k},after:function(a,b){var c={};return a.filter(function(a){if(a.result)return!0;var b=a.data;if(b){if(c[b.type]=c[b.type]||{},!c[b.type][b.name])return c[b.type][b.name]=[b],!0;var d=c[b.type][b.name].some(function(a){return a.failureCode===b.failureCode});return d||c[b.type][b.name].push(b),!d}return!1})}},{id:\"group-labelledby\",evaluate:function(a,b,c){this.data({name:a.getAttribute(\"name\"),type:a.getAttribute(\"type\")});var d=axe.commons.dom.getRootNode(a),e=d.querySelectorAll('input[type=\"'+axe.commons.utils.escapeSelector(a.type)+'\"][name=\"'+axe.commons.utils.escapeSelector(a.name)+'\"]');return e.length<=1||0!==[].map.call(e,function(a){var b=a.getAttribute(\"aria-labelledby\");return b?b.split(/\\s+/):[]}).reduce(function(a,b){return a.filter(function(a){return b.includes(a)})}).filter(function(a){var b=d.getElementById(a);return b&&axe.commons.text.accessibleText(b,!0)}).length},after:function(a,b){var c={};return a.filter(function(a){var b=a.data;return!(!b||(c[b.type]=c[b.type]||{},c[b.type][b.name]))&&(c[b.type][b.name]=!0,!0)})}},{id:\"accesskeys\",evaluate:function(a,b,c){return axe.commons.dom.isVisible(a,!1)&&(this.data(a.getAttribute(\"accesskey\")),this.relatedNodes([a])),!0},after:function(a,b){var c={};return a.filter(function(a){if(!a.data)return!1;var b=a.data.toUpperCase();return c[b]?(c[b].relatedNodes.push(a.relatedNodes[0]),!1):(c[b]=a,a.relatedNodes=[],!0)}).map(function(a){return a.result=!!a.relatedNodes.length,a})}},{id:\"focusable-no-name\",evaluate:function(a,b,c){var d=a.getAttribute(\"tabindex\");return!!(axe.commons.dom.isFocusable(a)&&d>-1)&&!axe.commons.text.accessibleTextVirtual(c)}},{id:\"has-at-least-one-main\",evaluate:function(a,b,c){var d=axe.utils.querySelectorAll(c,\"main,[role=main]\");return this.data(!!d[0]),!!d[0]},after:function(a,b){for(var c=!1,d=0;d<a.length&&!c;d++)c=a[d].data;for(var d=0;d<a.length;d++)a[d].result=c;return a}},{id:\"has-no-more-than-one-main\",evaluate:function(a,b,c){return axe.utils.querySelectorAll(c,\"main,[role=main]\").length<=1}},{id:\"main-is-top-level\",evaluate:function(a,b,c){for(var d=axe.commons.aria.getRolesByType(\"landmark\"),e=axe.commons.dom.getComposedParent(a);e;){var f=e.getAttribute(\"role\");if(f||\"form\"===e.tagName.toLowerCase()||(f=axe.commons.aria.implicitRole(e)),f&&d.includes(f))return!1;e=axe.commons.dom.getComposedParent(e)}return!0}},{id:\"tabindex\",evaluate:function(a,b,c){return a.tabIndex<=0}},{id:\"duplicate-img-label\",evaluate:function(a,b,c){var d=axe.commons.text.visibleVirtual(c,!0).toLowerCase();return\"\"!==d&&axe.utils.querySelectorAll(c,\"img\").filter(function(a){var b=a.actualNode;return axe.commons.dom.isVisible(b)&&![\"none\",\"presentation\"].includes(b.getAttribute(\"role\"))}).some(function(a){return d===axe.commons.text.accessibleTextVirtual(a).toLowerCase()})}},{id:\"explicit-label\",evaluate:function(a,b,c){if(a.getAttribute(\"id\")){var d=axe.commons.dom.getRootNode(a),e=axe.commons.utils.escapeSelector(a.getAttribute(\"id\")),f=d.querySelector('label[for=\"'+e+'\"]');if(f)return!!axe.commons.text.accessibleText(f)}return!1}},{id:\"help-same-as-label\",evaluate:function(a,b,c){var d=axe.commons.text.labelVirtual(c),e=a.getAttribute(\"title\");if(!d)return!1;if(!e&&(e=\"\",a.getAttribute(\"aria-describedby\"))){e=axe.commons.dom.idrefs(a,\"aria-describedby\").map(function(a){return a?axe.commons.text.accessibleText(a):\"\"}).join(\"\")}return axe.commons.text.sanitize(e)===axe.commons.text.sanitize(d)},enabled:!1},{id:\"implicit-label\",evaluate:function(a,b,c){var d=axe.commons.dom.findUpVirtual(c,\"label\");return!!d&&!!axe.commons.text.accessibleTextVirtual(d)}},{id:\"multiple-label\",evaluate:function(a,b,c){var d=axe.commons.utils.escapeSelector(a.getAttribute(\"id\")),e=Array.from(document.querySelectorAll('label[for=\"'+d+'\"]')),f=a.parentNode;for(e.length&&(e=e.filter(function(a,b){if(0===b&&!axe.commons.dom.isVisible(a,!0)||axe.commons.dom.isVisible(a,!0))return a}));f;)\"LABEL\"===f.tagName&&-1===e.indexOf(f)&&e.push(f),f=f.parentNode;return this.relatedNodes(e),e.length>1}},{id:\"title-only\",evaluate:function(a,b,c){return!(axe.commons.text.labelVirtual(c)||!a.getAttribute(\"title\")&&!a.getAttribute(\"aria-describedby\"))}},{id:\"has-lang\",evaluate:function(a,b,c){return!!(a.getAttribute(\"lang\")||a.getAttribute(\"xml:lang\")||\"\").trim()}},{id:\"valid-lang\",evaluate:function(a,b,c){function d(a){return a.trim().split(\"-\")[0].toLowerCase()}var e,f;return e=(b||axe.commons.utils.validLangs()).map(d),f=[\"lang\",\"xml:lang\"].reduce(function(b,c){var f=a.getAttribute(c);if(\"string\"!=typeof f)return b;var g=d(f);return\"\"!==g&&-1===e.indexOf(g)&&b.push(c+'=\"'+a.getAttribute(c)+'\"'),b},[]),!!f.length&&(this.data(f),!0)}},{id:\"dlitem\",evaluate:function(a,b,c){return\"DL\"===axe.commons.dom.getComposedParent(a).nodeName.toUpperCase()}},{id:\"has-listitem\",evaluate:function(a,b,c){return c.children.every(function(a){return\"LI\"!==a.actualNode.nodeName.toUpperCase()})}},{id:\"listitem\",evaluate:function(a,b,c){var d=axe.commons.dom.getComposedParent(a);return[\"UL\",\"OL\"].includes(d.nodeName.toUpperCase())||\"list\"===(d.getAttribute(\"role\")||\"\").toLowerCase()}},{id:\"only-dlitems\",evaluate:function(a,b,c){var d=[],e=[\"STYLE\",\"META\",\"LINK\",\"MAP\",\"AREA\",\"SCRIPT\",\"DATALIST\",\"TEMPLATE\"],f=!1;return c.children.forEach(function(a){var b=a.actualNode,c=b.nodeName.toUpperCase();1===b.nodeType&&\"DT\"!==c&&\"DD\"!==c&&-1===e.indexOf(c)?d.push(b):3===b.nodeType&&\"\"!==b.nodeValue.trim()&&(f=!0)}),d.length&&this.relatedNodes(d),!!d.length||f}},{id:\"only-listitems\",evaluate:function(a,b,c){var d=[],e=[\"STYLE\",\"META\",\"LINK\",\"MAP\",\"AREA\",\"SCRIPT\",\"DATALIST\",\"TEMPLATE\"],f=!1;return c.children.forEach(function(a){var b=a.actualNode,c=b.nodeName.toUpperCase();1===b.nodeType&&\"LI\"!==c&&-1===e.indexOf(c)?d.push(b):3===b.nodeType&&\"\"!==b.nodeValue.trim()&&(f=!0)}),d.length&&this.relatedNodes(d),!!d.length||f}},{id:\"structured-dlitems\",\nevaluate:function(a,b,c){var d=c.children;if(!d||!d.length)return!1;for(var e,f=!1,g=!1,h=0;h<d.length;h++){if(e=d[h].actualNode.nodeName.toUpperCase(),\"DT\"===e&&(f=!0),f&&\"DD\"===e)return!1;\"DD\"===e&&(g=!0)}return f||g}},{id:\"caption\",evaluate:function(a,b,c){var d=axe.utils.querySelectorAll(c,\"track\");if(d.length)return!d.some(function(a){return\"captions\"===(a.actualNode.getAttribute(\"kind\")||\"\").toLowerCase()})}},{id:\"description\",evaluate:function(a,b,c){var d=axe.utils.querySelectorAll(c,\"track\");if(d.length){return!d.some(function(a){return\"descriptions\"===(a.actualNode.getAttribute(\"kind\")||\"\").toLowerCase()})}}},{id:\"meta-viewport-large\",evaluate:function(a,b,c){b=b||{};for(var d,e=a.getAttribute(\"content\")||\"\",f=e.split(/[;,]/),g={},h=b.scaleMinimum||2,i=b.lowerBound||!1,j=0,k=f.length;j<k;j++){d=f[j].split(\"=\");var l=d.shift().toLowerCase();l&&d.length&&(g[l.trim()]=d.shift().trim().toLowerCase())}return!!(i&&g[\"maximum-scale\"]&&parseFloat(g[\"maximum-scale\"])<i)||!(!i&&\"no\"===g[\"user-scalable\"])&&!(g[\"maximum-scale\"]&&parseFloat(g[\"maximum-scale\"])<h)},options:{scaleMinimum:5,lowerBound:2}},{id:\"meta-viewport\",evaluate:function(a,b,c){b=b||{};for(var d,e=a.getAttribute(\"content\")||\"\",f=e.split(/[;,]/),g={},h=b.scaleMinimum||2,i=b.lowerBound||!1,j=0,k=f.length;j<k;j++){d=f[j].split(\"=\");var l=d.shift().toLowerCase();l&&d.length&&(g[l.trim()]=d.shift().trim().toLowerCase())}return!!(i&&g[\"maximum-scale\"]&&parseFloat(g[\"maximum-scale\"])<i)||!(!i&&\"no\"===g[\"user-scalable\"])&&!(g[\"maximum-scale\"]&&parseFloat(g[\"maximum-scale\"])<h)},options:{scaleMinimum:2}},{id:\"header-present\",evaluate:function(a,b,c){return!!axe.utils.querySelectorAll(c,'h1, h2, h3, h4, h5, h6, [role=\"heading\"]')[0]}},{id:\"heading-order\",evaluate:function(a,b,c){var d=a.getAttribute(\"aria-level\");if(null!==d)return this.data(parseInt(d,10)),!0;var e=a.tagName.match(/H(\\d)/);return!e||(this.data(parseInt(e[1],10)),!0)},after:function(a,b){if(a.length<2)return a;for(var c=a[0].data,d=1;d<a.length;d++)a[d].result&&a[d].data>c+1&&(a[d].result=!1),c=a[d].data;return a}},{id:\"internal-link-present\",evaluate:function(a,b,c){return axe.utils.querySelectorAll(c,\"a[href]\").some(function(a){return\"#\"===a.actualNode.getAttribute(\"href\")[0]})}},{id:\"landmark\",evaluate:function(a,b,c){return axe.utils.querySelectorAll(c,'main, [role=\"main\"]').length>0}},{id:\"meta-refresh\",evaluate:function(a,b,c){var d=a.getAttribute(\"content\")||\"\",e=d.split(/[;,]/);return\"\"===d||\"0\"===e[0]}},{id:\"p-as-heading\",evaluate:function(a,b,c){function d(a){for(var b=a,c=a.textContent.trim(),d=c;d===c&&void 0!==b;){var e=-1;if(a=b,0===a.children.length)return a;do{e++,d=a.children[e].textContent.trim()}while(\"\"===d&&e+1<a.children.length);b=a.children[e]}return a}function e(a){switch(a){case\"lighter\":return 100;case\"normal\":return 400;case\"bold\":return 700;case\"bolder\":return 900}return a=parseInt(a),isNaN(a)?400:a}function f(a){var b=window.getComputedStyle(d(a));return{fontWeight:e(b.getPropertyValue(\"font-weight\")),fontSize:parseInt(b.getPropertyValue(\"font-size\")),isItalic:\"italic\"===b.getPropertyValue(\"font-style\")}}function g(a,b,c){return c.reduce(function(c,d){return c||(!d.size||a.fontSize/d.size>b.fontSize)&&(!d.weight||a.fontWeight-d.weight>b.fontWeight)&&(!d.italic||a.isItalic&&!b.isItalic)},!1)}var h=Array.from(a.parentNode.children),i=h.indexOf(a);b=b||{};var j=b.margins||[],k=h.slice(i+1).find(function(a){return\"P\"===a.nodeName.toUpperCase()}),l=h.slice(0,i).reverse().find(function(a){return\"P\"===a.nodeName.toUpperCase()}),m=f(a),n=k?f(k):null,o=l?f(l):null;if(!n||!g(m,n,j))return!0;var p=axe.commons.dom.findUpVirtual(c,\"blockquote\");return!!(p&&\"BLOCKQUOTE\"===p.nodeName.toUpperCase()||o&&!g(m,o,j))&&void 0},options:{margins:[{weight:150,italic:!0},{weight:150,size:1.15},{italic:!0,size:1.15},{size:1.4}]}},{id:\"region\",evaluate:function(a,b,c){function d(a){return j&&j===a}function e(a){return a.hasAttribute(\"role\")?k.includes(a.getAttribute(\"role\").toLowerCase()):l.some(function(b){return axe.utils.matchesSelector(a,b)})}function f(a){var b=a.actualNode;return e(b)||d(b)||!h.isVisible(b,!0)?[]:h.hasContent(b,!0)?[b]:a.children.filter(function(a){return 1===a.actualNode.nodeType}).map(f).reduce(function(a,b){return a.concat(b)},[])}var g=axe.commons,h=g.dom,i=g.aria,j=function(a){var b=axe.utils.querySelectorAll(a,\"a[href]\")[0];if(b&&axe.commons.dom.getElementByReference(b.actualNode,\"href\"))return b.actualNode}(c),k=i.getRolesByType(\"landmark\"),l=k.reduce(function(a,b){return a.concat(i.implicitNodes(b))},[]).filter(function(a){return null!==a}),m=f(c);return this.relatedNodes(m),0===m.length},after:function(a,b){return[a[0]]}},{id:\"skip-link\",evaluate:function(a,b,c){var d=axe.commons.dom.getElementByReference(a,\"href\");return!!d&&(axe.commons.dom.isVisible(d,!0)||void 0)}},{id:\"unique-frame-title\",evaluate:function(a,b,c){var d=axe.commons.text.sanitize(a.title).trim().toLowerCase();return this.data(d),!0},after:function(a,b){var c={};return a.forEach(function(a){c[a.data]=void 0!==c[a.data]?++c[a.data]:0}),a.forEach(function(a){a.result=!!c[a.data]}),a}},{id:\"aria-label\",evaluate:function(a,b,c){var d=a.getAttribute(\"aria-label\");return!!(d?axe.commons.text.sanitize(d).trim():\"\")}},{id:\"aria-labelledby\",evaluate:function(a,b,c){return(0,axe.commons.dom.idrefs)(a,\"aria-labelledby\").some(function(a){return a&&axe.commons.text.accessibleText(a,!0)})}},{id:\"button-has-visible-text\",evaluate:function(a,b,c){var d=a.nodeName.toUpperCase(),e=a.getAttribute(\"role\"),f=void 0;return(\"BUTTON\"===d||\"button\"===e&&\"INPUT\"!==d)&&(f=axe.commons.text.accessibleTextVirtual(c),this.data(f),!!f)}},{id:\"doc-has-title\",evaluate:function(a,b,c){var d=document.title;return!!(d?axe.commons.text.sanitize(d).trim():\"\")}},{id:\"duplicate-id\",evaluate:function(a,b,c){var d=a.getAttribute(\"id\").trim();if(!d)return!0;var e=axe.commons.dom.getRootNode(a),f=Array.from(e.querySelectorAll('[id=\"'+axe.commons.utils.escapeSelector(d)+'\"]')).filter(function(b){return b!==a});return f.length&&this.relatedNodes(f),this.data(d),0===f.length},after:function(a,b){var c=[];return a.filter(function(a){return-1===c.indexOf(a.data)&&(c.push(a.data),!0)})}},{id:\"exists\",evaluate:function(a,b,c){return!0}},{id:\"has-alt\",evaluate:function(a,b,c){var d=a.nodeName.toLowerCase();return a.hasAttribute(\"alt\")&&(\"img\"===d||\"input\"===d||\"area\"===d)}},{id:\"has-visible-text\",evaluate:function(a,b,c){return axe.commons.text.accessibleTextVirtual(c).length>0}},{id:\"is-on-screen\",evaluate:function(a,b,c){return axe.commons.dom.isVisible(a,!1)&&!axe.commons.dom.isOffscreen(a)}},{id:\"non-empty-alt\",evaluate:function(a,b,c){var d=a.getAttribute(\"alt\");return!!(d?axe.commons.text.sanitize(d).trim():\"\")}},{id:\"non-empty-if-present\",evaluate:function(a,b,c){var d=a.nodeName.toUpperCase(),e=(a.getAttribute(\"type\")||\"\").toLowerCase(),f=a.getAttribute(\"value\");return this.data(f),!(\"INPUT\"!==d||![\"submit\",\"reset\"].includes(e))&&null===f}},{id:\"non-empty-title\",evaluate:function(a,b,c){var d=a.getAttribute(\"title\");return!!(d?axe.commons.text.sanitize(d).trim():\"\")}},{id:\"non-empty-value\",evaluate:function(a,b,c){var d=a.getAttribute(\"value\");return!!(d?axe.commons.text.sanitize(d).trim():\"\")}},{id:\"role-none\",evaluate:function(a,b,c){return\"none\"===a.getAttribute(\"role\")}},{id:\"role-presentation\",evaluate:function(a,b,c){return\"presentation\"===a.getAttribute(\"role\")}},{id:\"caption-faked\",evaluate:function(a,b,c){var d=axe.commons.table.toGrid(a),e=d[0];return d.length<=1||e.length<=1||a.rows.length<=1||e.reduce(function(a,b,c){return a||b!==e[c+1]&&void 0!==e[c+1]},!1)}},{id:\"has-caption\",evaluate:function(a,b,c){return!!a.caption}},{id:\"has-summary\",evaluate:function(a,b,c){return!!a.summary}},{id:\"has-th\",evaluate:function(a,b,c){for(var d,e,f=[],g=0,h=a.rows.length;g<h;g++){d=a.rows[g];for(var i=0,j=d.cells.length;i<j;i++)e=d.cells[i],\"TH\"!==e.nodeName.toUpperCase()&&-1===[\"rowheader\",\"columnheader\"].indexOf(e.getAttribute(\"role\"))||f.push(e)}return!!f.length&&(this.relatedNodes(f),!0)}},{id:\"html5-scope\",evaluate:function(a,b,c){return!axe.commons.dom.isHTML5(document)||\"TH\"===a.nodeName.toUpperCase()}},{id:\"same-caption-summary\",evaluate:function(a,b,c){return!(!a.summary||!a.caption)&&a.summary===axe.commons.text.accessibleText(a.caption)}},{id:\"scope-value\",evaluate:function(a,b,c){b=b||{};var d=a.getAttribute(\"scope\").toLowerCase();return-1!==([\"row\",\"col\",\"rowgroup\",\"colgroup\"]||b.values).indexOf(d)}},{id:\"td-has-header\",evaluate:function(a,b,c){var d=axe.commons.table,e=[];return d.getAllCells(a).forEach(function(a){if(axe.commons.dom.hasContent(a)&&d.isDataCell(a)&&!axe.commons.aria.label(a)){var b=d.getHeaders(a);(b=b.reduce(function(a,b){return a||null!==b&&!!axe.commons.dom.hasContent(b)},!1))||e.push(a)}}),!e.length||(this.relatedNodes(e),!1)}},{id:\"td-headers-attr\",evaluate:function(a,b,c){for(var d=[],e=0,f=a.rows.length;e<f;e++)for(var g=a.rows[e],h=0,i=g.cells.length;h<i;h++)d.push(g.cells[h]);var j=d.reduce(function(a,b){return b.getAttribute(\"id\")&&a.push(b.getAttribute(\"id\")),a},[]),k=d.reduce(function(a,b){var c,d,e=(b.getAttribute(\"headers\")||\"\").split(/\\s/).reduce(function(a,b){return b=b.trim(),b&&a.push(b),a},[]);return 0!==e.length&&(b.getAttribute(\"id\")&&(c=-1!==e.indexOf(b.getAttribute(\"id\").trim())),d=e.reduce(function(a,b){return a||-1===j.indexOf(b)},!1),(c||d)&&a.push(b)),a},[]);return!(k.length>0)||(this.relatedNodes(k),!1)}},{id:\"th-has-data-cells\",evaluate:function(a,b,c){var d=axe.commons.table,e=d.getAllCells(a),f=this,g=[];e.forEach(function(a){var b=a.getAttribute(\"headers\");b&&(g=g.concat(b.split(/\\s+/)));var c=a.getAttribute(\"aria-labelledby\");c&&(g=g.concat(c.split(/\\s+/)))});var h=e.filter(function(a){return\"\"!==axe.commons.text.sanitize(a.textContent)&&(\"TH\"===a.nodeName.toUpperCase()||-1!==[\"rowheader\",\"columnheader\"].indexOf(a.getAttribute(\"role\")))}),i=d.toGrid(a);return!!h.reduce(function(a,b){if(b.getAttribute(\"id\")&&g.includes(b.getAttribute(\"id\")))return!!a||a;var c=!1,e=d.getCellPosition(b,i);return d.isColumnHeader(b)&&(c=d.traverse(\"down\",e,i).reduce(function(a,b){return a||axe.commons.dom.hasContent(b)&&!d.isColumnHeader(b)},!1)),!c&&d.isRowHeader(b)&&(c=d.traverse(\"right\",e,i).reduce(function(a,b){return a||axe.commons.dom.hasContent(b)&&!d.isRowHeader(b)},!1)),c||f.relatedNodes(b),a&&c},!0)||void 0}},{id:\"hidden-content\",evaluate:function(a,b,c){if(![\"SCRIPT\",\"HEAD\",\"TITLE\",\"NOSCRIPT\",\"STYLE\",\"TEMPLATE\"].includes(a.tagName.toUpperCase())&&axe.commons.dom.hasContentVirtual(c)){var d=window.getComputedStyle(a);if(\"none\"===d.getPropertyValue(\"display\"))return;if(\"hidden\"===d.getPropertyValue(\"visibility\")){var e=axe.commons.dom.getComposedParent(a),f=e&&window.getComputedStyle(e);if(!f||\"hidden\"!==f.getPropertyValue(\"visibility\"))return}}return!0}}],commons:function(){function a(a){return a.getPropertyValue(\"font-family\").split(/[,;]/g).map(function(a){return a.trim().toLowerCase()})}function b(b,c){var d=window.getComputedStyle(b);if(\"none\"!==d.getPropertyValue(\"background-image\"))return!0;if([\"border-bottom\",\"border-top\",\"outline\"].reduce(function(a,b){var c=new C.Color;return c.parseRgbString(d.getPropertyValue(b+\"-color\")),a||\"none\"!==d.getPropertyValue(b+\"-style\")&&parseFloat(d.getPropertyValue(b+\"-width\"))>0&&0!==c.alpha},!1))return!0;var e=window.getComputedStyle(c);if(a(d)[0]!==a(e)[0])return!0;var f=[\"text-decoration-line\",\"text-decoration-style\",\"font-weight\",\"font-style\",\"font-size\"].reduce(function(a,b){return a||d.getPropertyValue(b)!==e.getPropertyValue(b)},!1),g=d.getPropertyValue(\"text-decoration\");return g.split(\" \").length<3&&(f=f||g!==e.getPropertyValue(\"text-decoration\")),f}function c(a,b){var c=a.nodeName.toUpperCase();if(G.includes(c))return axe.commons.color.incompleteData.set(\"bgColor\",\"imgNode\"),!0;b=b||window.getComputedStyle(a);var d=b.getPropertyValue(\"background-image\"),e=\"none\"!==d;if(e){var f=/gradient/.test(d);axe.commons.color.incompleteData.set(\"bgColor\",f?\"bgGradient\":\"bgImage\")}return e}function d(a,b){b=b||window.getComputedStyle(a);var c=new C.Color;if(c.parseRgbString(b.getPropertyValue(\"background-color\")),0!==c.alpha){var d=b.getPropertyValue(\"opacity\");c.alpha=c.alpha*d}return c}function e(a,b){var c=a.getClientRects()[0],d=D.shadowElementsFromPoint(c.left,c.top);if(d)for(var e=0;e<d.length;e++)if(d[e]!==a&&d[e]===b)return!0;return!1}function f(a,b,c){var f=0;if(a>0)for(var g=a-1;g>=0;g--){var h=b[g],i=window.getComputedStyle(h),j=d(h,i);j.alpha&&e(c,h)?f+=j.alpha:b.splice(g,1)}return f}function g(a,b,c){var d=a!==b&&!D.visuallyContains(a,b)&&0!==c.alpha;return d&&axe.commons.color.incompleteData.set(\"bgColor\",\"elmPartiallyObscured\"),d}function h(a,b){var c={TD:[\"TR\",\"TBODY\"],TH:[\"TR\",\"THEAD\"],INPUT:[\"LABEL\"]},d=a.map(function(a){return a.tagName}),e=a;for(var f in c)if(d.includes(f))for(var g in c[f])if(f.hasOwnProperty(g)){var h=axe.commons.dom.findUp(b,c[f][g]);if(h&&-1===a.indexOf(h)){var i=axe.commons.dom.visuallyOverlaps(b.getBoundingClientRect(),h);i&&e.splice(d.indexOf(f)+1,0,h)}b.tagName===c[f][g]&&-1===d.indexOf(b.tagName)&&e.splice(d.indexOf(f)+1,0,b)}return e}function i(a){var b=a.indexOf(document.body),e=a;return b>1&&!c(document.documentElement)&&0===d(document.documentElement).alpha&&(e.splice(b,1),e.splice(a.indexOf(document.documentElement),1),e.push(document.body)),e}function j(a){if(!H.includes(a.actualNode.nodeName.toUpperCase()))return a.children.some(function(a){var b=a.actualNode;return 3===b.nodeType&&b.nodeValue.trim()})}function k(a){return a.disabled||!D.isVisible(a,!0)&&\"AREA\"!==a.nodeName.toUpperCase()}function l(a,b){!1!==b(a.actualNode)&&a.children.forEach(function(a){return l(a,b)})}function m(a){var b=window.getComputedStyle(a).getPropertyValue(\"display\");return I.includes(b)||\"table-\"===b.substr(0,6)}function n(a){for(var b=D.getComposedParent(a);b&&!m(b);)b=D.getComposedParent(b);return axe.utils.getNodeFromTree(axe._tree[0],b)}function o(a,b){for(a=D.getComposedParent(a);a&&\"html\"!==a.nodeName.toLowerCase();){if(a.scrollTop&&(b+=a.scrollTop)>=0)return!1;a=D.getComposedParent(a)}return!0}function p(a){\"use strict\";var b=a.match(/rect\\s*\\(([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px\\s*\\)/);return!(!b||5!==b.length)&&(b[3]-b[1]<=0&&b[2]-b[4]<=0)}function q(a){var b=void 0;return b=a.actualNode.id?D.findElmsInContext({elm:\"label\",attr:\"for\",value:a.actualNode.id,context:a.actualNode})[0]:D.findUpVirtual(a,\"label\"),axe.utils.getNodeFromTree(axe._tree[0],b)}function r(a){return[\"button\",\"reset\",\"submit\"].includes(a.actualNode.type.toLowerCase())}function s(a){var b=a.actualNode,c=b.nodeName.toUpperCase();return\"TEXTAREA\"===c||\"SELECT\"===c||\"INPUT\"===c&&\"hidden\"!==b.type.toLowerCase()}function t(a){return[\"BUTTON\",\"SUMMARY\",\"A\"].includes(a.actualNode.nodeName.toUpperCase())}function u(a){return[\"TABLE\",\"FIGURE\"].includes(a.actualNode.nodeName.toUpperCase())}function v(a){var b=a.actualNode,c=b.nodeName.toUpperCase();if(\"INPUT\"===c)return!b.hasAttribute(\"type\")||L.includes(b.type.toLowerCase())?b.value:\"\";if(\"SELECT\"===c){var d=b.options;if(d&&d.length){for(var e=\"\",f=0;f<d.length;f++)d[f].selected&&(e+=\" \"+d[f].text);return F.sanitize(e)}return\"\"}return\"TEXTAREA\"===c&&b.value?b.value:\"\"}function w(a,b){var c=a.actualNode,d=c.querySelector(b.toLowerCase());return d?F.accessibleText(d):\"\"}function x(a){if(!a)return!1;var b=a.actualNode;switch(b.nodeName.toUpperCase()){case\"SELECT\":case\"TEXTAREA\":return!0;case\"INPUT\":return!b.hasAttribute(\"type\")||L.includes(b.getAttribute(\"type\").toLowerCase());default:return!1}}function y(a){var b=a.actualNode,c=b.nodeName.toUpperCase();return[\"IMG\",\"APPLET\",\"AREA\"].includes(c)||\"INPUT\"===c&&\"image\"===b.type.toLowerCase()}function z(a){return!!F.sanitize(a)}var commons={},A=commons.aria={},B=A.lookupTable={};B.attributes={\"aria-activedescendant\":{type:\"idref\"},\"aria-atomic\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-autocomplete\":{type:\"nmtoken\",values:[\"inline\",\"list\",\"both\",\"none\"]},\"aria-busy\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-checked\":{type:\"nmtoken\",values:[\"true\",\"false\",\"mixed\",\"undefined\"]},\"aria-colcount\":{type:\"int\"},\"aria-colindex\":{type:\"int\"},\"aria-colspan\":{type:\"int\"},\"aria-controls\":{type:\"idrefs\"},\"aria-current\":{type:\"nmtoken\",values:[\"page\",\"step\",\"location\",\"date\",\"time\",\"true\",\"false\"]},\"aria-describedby\":{type:\"idrefs\"},\"aria-disabled\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-dropeffect\":{type:\"nmtokens\",values:[\"copy\",\"move\",\"reference\",\"execute\",\"popup\",\"none\"]},\"aria-errormessage\":{type:\"idref\"},\"aria-expanded\":{type:\"nmtoken\",values:[\"true\",\"false\",\"undefined\"]},\"aria-flowto\":{type:\"idrefs\"},\"aria-grabbed\":{type:\"nmtoken\",values:[\"true\",\"false\",\"undefined\"]},\"aria-haspopup\":{type:\"nmtoken\",values:[\"true\",\"false\",\"menu\",\"listbox\",\"tree\",\"grid\",\"dialog\"]},\"aria-hidden\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-invalid\":{type:\"nmtoken\",values:[\"true\",\"false\",\"spelling\",\"grammar\"]},\"aria-keyshortcuts\":{type:\"string\"},\"aria-label\":{type:\"string\"},\"aria-labelledby\":{type:\"idrefs\"},\"aria-level\":{type:\"int\"},\"aria-live\":{type:\"nmtoken\",values:[\"off\",\"polite\",\"assertive\"]},\"aria-modal\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-multiline\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-multiselectable\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-orientation\":{type:\"nmtoken\",values:[\"horizontal\",\"vertical\"]},\"aria-owns\":{type:\"idrefs\"},\"aria-placeholder\":{type:\"string\"},\"aria-posinset\":{type:\"int\"},\"aria-pressed\":{type:\"nmtoken\",values:[\"true\",\"false\",\"mixed\",\"undefined\"]},\"aria-readonly\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-relevant\":{type:\"nmtokens\",values:[\"additions\",\"removals\",\"text\",\"all\"]},\"aria-required\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-rowcount\":{type:\"int\"},\"aria-rowindex\":{type:\"int\"},\"aria-rowspan\":{type:\"int\"},\"aria-selected\":{type:\"nmtoken\",values:[\"true\",\"false\",\"undefined\"]},\"aria-setsize\":{type:\"int\"},\"aria-sort\":{type:\"nmtoken\",values:[\"ascending\",\"descending\",\"other\",\"none\"]},\"aria-valuemax\":{type:\"decimal\"},\"aria-valuemin\":{type:\"decimal\"},\"aria-valuenow\":{type:\"decimal\"},\"aria-valuetext\":{type:\"string\"}},B.globalAttributes=[\"aria-atomic\",\"aria-busy\",\"aria-controls\",\"aria-current\",\"aria-describedby\",\"aria-disabled\",\"aria-dropeffect\",\"aria-flowto\",\"aria-grabbed\",\"aria-haspopup\",\"aria-hidden\",\"aria-invalid\",\"aria-keyshortcuts\",\"aria-label\",\"aria-labelledby\",\"aria-live\",\"aria-owns\",\"aria-relevant\"],B.role={alert:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},alertdialog:{type:\"widget\",attributes:{allowed:[\"aria-expanded\",\"aria-modal\"]},owned:null,nameFrom:[\"author\"],context:null},application:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},article:{type:\"structure\",attributes:{allowed:[\"aria-expanded\",\"aria-posinset\",\"aria-setsize\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"article\"]},banner:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"header\"]},button:{type:\"widget\",attributes:{allowed:[\"aria-expanded\",\"aria-pressed\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null,implicit:[\"button\",'input[type=\"button\"]','input[type=\"image\"]','input[type=\"reset\"]','input[type=\"submit\"]',\"summary\"]},cell:{type:\"structure\",attributes:{allowed:[\"aria-colindex\",\"aria-colspan\",\"aria-rowindex\",\"aria-rowspan\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"row\"],implicit:[\"td\",\"th\"]},checkbox:{type:\"widget\",attributes:{allowed:[\"aria-checked\",\"aria-required\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null,implicit:['input[type=\"checkbox\"]']},columnheader:{type:\"structure\",attributes:{allowed:[\"aria-colindex\",\"aria-colspan\",\"aria-expanded\",\"aria-rowindex\",\"aria-rowspan\",\"aria-required\",\"aria-readonly\",\"aria-selected\",\"aria-sort\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"row\"],implicit:[\"th\"]},combobox:{type:\"composite\",attributes:{allowed:[\"aria-expanded\",\"aria-autocomplete\",\"aria-required\",\"aria-activedescendant\",\"aria-orientation\"]},owned:{all:[\"listbox\",\"textbox\"]},nameFrom:[\"author\"],context:null},command:{nameFrom:[\"author\"],type:\"abstract\"},complementary:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"aside\"]},composite:{nameFrom:[\"author\"],type:\"abstract\"},contentinfo:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"footer\"]},definition:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"dd\",\"dfn\"]},dialog:{type:\"widget\",attributes:{allowed:[\"aria-expanded\",\"aria-modal\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"dialog\"]},directory:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null},document:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"body\"]},feed:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:{one:[\"article\"]},nameFrom:[\"author\"],context:null},form:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"form\"]},grid:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\",\"aria-colcount\",\"aria-level\",\"aria-multiselectable\",\"aria-readonly\",\"aria-rowcount\"]},owned:{one:[\"rowgroup\",\"row\"]},nameFrom:[\"author\"],context:null,implicit:[\"table\"]},gridcell:{type:\"widget\",attributes:{allowed:[\"aria-colindex\",\"aria-colspan\",\"aria-expanded\",\"aria-rowindex\",\"aria-rowspan\",\"aria-selected\",\"aria-readonly\",\"aria-required\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"row\"],implicit:[\"td\",\"th\"]},group:{type:\"structure\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"details\",\"optgroup\"]},heading:{type:\"structure\",attributes:{allowed:[\"aria-level\",\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null,implicit:[\"h1\",\"h2\",\"h3\",\"h4\",\"h5\",\"h6\"]},img:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"img\"]},input:{nameFrom:[\"author\"],type:\"abstract\"},landmark:{nameFrom:[\"author\"],type:\"abstract\"},link:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null,implicit:[\"a[href]\"]},list:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:{all:[\"listitem\"]},nameFrom:[\"author\"],context:null,implicit:[\"ol\",\"ul\",\"dl\"]},listbox:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-multiselectable\",\"aria-required\",\"aria-expanded\",\"aria-orientation\"]},owned:{all:[\"option\"]},nameFrom:[\"author\"],context:null,implicit:[\"select\"]},listitem:{type:\"structure\",attributes:{allowed:[\"aria-level\",\"aria-posinset\",\"aria-setsize\",\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"list\"],implicit:[\"li\",\"dt\"]},log:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},main:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"main\"]},marquee:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},math:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"math\"]},menu:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\",\"aria-orientation\"]},owned:{one:[\"menuitem\",\"menuitemradio\",\"menuitemcheckbox\"]},nameFrom:[\"author\"],context:null,implicit:['menu[type=\"context\"]']},menubar:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\",\"aria-orientation\"]},owned:null,nameFrom:[\"author\"],context:null},menuitem:{type:\"widget\",attributes:{allowed:[\"aria-posinset\",\"aria-setsize\",\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"menu\",\"menubar\"],implicit:['menuitem[type=\"command\"]']},menuitemcheckbox:{type:\"widget\",attributes:{allowed:[\"aria-checked\",\"aria-posinset\",\"aria-setsize\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"menu\",\"menubar\"],implicit:['menuitem[type=\"checkbox\"]']},menuitemradio:{type:\"widget\",attributes:{allowed:[\"aria-checked\",\"aria-selected\",\"aria-posinset\",\"aria-setsize\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"menu\",\"menubar\"],implicit:['menuitem[type=\"radio\"]']},navigation:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"nav\"]},none:{type:\"structure\",attributes:null,owned:null,nameFrom:[\"author\"],context:null},note:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},option:{type:\"widget\",attributes:{allowed:[\"aria-selected\",\"aria-posinset\",\"aria-setsize\",\"aria-checked\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"listbox\"],implicit:[\"option\"]},presentation:{type:\"structure\",attributes:null,owned:null,nameFrom:[\"author\"],context:null},progressbar:{type:\"widget\",attributes:{allowed:[\"aria-valuetext\",\"aria-valuenow\",\"aria-valuemax\",\"aria-valuemin\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"progress\"]},radio:{type:\"widget\",attributes:{allowed:[\"aria-checked\",\"aria-selected\",\"aria-posinset\",\"aria-setsize\",\"aria-required\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null,implicit:['input[type=\"radio\"]']},radiogroup:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-required\",\"aria-expanded\"]},owned:{all:[\"radio\"]},nameFrom:[\"author\"],context:null},range:{nameFrom:[\"author\"],type:\"abstract\"},region:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"section[aria-label]\",\"section[aria-labelledby]\",\"section[title]\"]},roletype:{type:\"abstract\"},row:{type:\"structure\",attributes:{allowed:[\"aria-activedescendant\",\"aria-colindex\",\"aria-expanded\",\"aria-level\",\"aria-selected\",\"aria-rowindex\"]},owned:{one:[\"cell\",\"columnheader\",\"rowheader\",\"gridcell\"]},nameFrom:[\"author\",\"contents\"],context:[\"rowgroup\",\"grid\",\"treegrid\",\"table\"],implicit:[\"tr\"]},rowgroup:{type:\"structure\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\"]},owned:{all:[\"row\"]},nameFrom:[\"author\",\"contents\"],context:[\"grid\",\"table\"],implicit:[\"tbody\",\"thead\",\"tfoot\"]},rowheader:{type:\"structure\",attributes:{allowed:[\"aria-colindex\",\"aria-colspan\",\"aria-expanded\",\"aria-rowindex\",\"aria-rowspan\",\"aria-required\",\"aria-readonly\",\"aria-selected\",\"aria-sort\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"row\"],implicit:[\"th\"]},scrollbar:{type:\"widget\",attributes:{required:[\"aria-controls\",\"aria-valuenow\",\"aria-valuemax\",\"aria-valuemin\"],allowed:[\"aria-valuetext\",\"aria-orientation\"]},owned:null,nameFrom:[\"author\"],context:null},search:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},searchbox:{type:\"widget\",attributes:{allowed:[\"aria-activedescendant\",\"aria-autocomplete\",\"aria-multiline\",\"aria-readonly\",\"aria-required\",\"aria-placeholder\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:['input[type=\"search\"]']},section:{nameFrom:[\"author\",\"contents\"],type:\"abstract\"},sectionhead:{nameFrom:[\"author\",\"contents\"],type:\"abstract\"},select:{nameFrom:[\"author\"],type:\"abstract\"},separator:{type:\"structure\",attributes:{allowed:[\"aria-expanded\",\"aria-orientation\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"hr\"]},slider:{type:\"widget\",attributes:{allowed:[\"aria-valuetext\",\"aria-orientation\"],required:[\"aria-valuenow\",\"aria-valuemax\",\"aria-valuemin\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:['input[type=\"range\"]']},spinbutton:{type:\"widget\",attributes:{allowed:[\"aria-valuetext\",\"aria-required\"],required:[\"aria-valuenow\",\"aria-valuemax\",\"aria-valuemin\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:['input[type=\"number\"]']},status:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"output\"]},structure:{type:\"abstract\"},switch:{type:\"widget\",attributes:{required:[\"aria-checked\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null},tab:{type:\"widget\",attributes:{allowed:[\"aria-selected\",\"aria-expanded\",\"aria-setsize\",\"aria-posinset\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"tablist\"]},table:{type:\"structure\",attributes:{allowed:[\"aria-colcount\",\"aria-rowcount\"]},owned:{one:[\"rowgroup\",\"row\"]},nameFrom:[\"author\"],context:null,implicit:[\"table\"]},tablist:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\",\"aria-level\",\"aria-multiselectable\",\"aria-orientation\"]},owned:{all:[\"tab\"]},nameFrom:[\"author\"],context:null},tabpanel:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},term:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null,implicit:[\"dt\"]},text:{type:\"structure\",owned:null,nameFrom:[\"author\",\"contents\"],context:null},textbox:{type:\"widget\",attributes:{allowed:[\"aria-activedescendant\",\"aria-autocomplete\",\"aria-multiline\",\"aria-readonly\",\"aria-required\",\"aria-placeholder\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:['input[type=\"text\"]','input[type=\"email\"]','input[type=\"password\"]','input[type=\"tel\"]','input[type=\"url\"]',\"input:not([type])\",\"textarea\"]},timer:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},toolbar:{type:\"structure\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:['menu[type=\"toolbar\"]']},tooltip:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null},tree:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-multiselectable\",\"aria-required\",\"aria-expanded\",\"aria-orientation\"]},owned:{all:[\"treeitem\"]},nameFrom:[\"author\"],context:null},treegrid:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-colcount\",\"aria-expanded\",\"aria-level\",\"aria-multiselectable\",\"aria-readonly\",\"aria-required\",\"aria-rowcount\",\"aria-orientation\"]},owned:{one:[\"rowgroup\",\"row\"]},nameFrom:[\"author\"],context:null},treeitem:{type:\"widget\",attributes:{allowed:[\"aria-checked\",\"aria-selected\",\"aria-expanded\",\"aria-level\",\"aria-posinset\",\"aria-setsize\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"group\",\"tree\"]},widget:{type:\"abstract\"},window:{nameFrom:[\"author\"],type:\"abstract\"}};var C={};commons.color=C;var D=commons.dom={},E=commons.table={},F=commons.text={EdgeFormDefaults:{}};commons.utils=axe.utils;A.requiredAttr=function(a){\"use strict\";var b=A.lookupTable.role[a];return b&&b.attributes&&b.attributes.required||[]},A.allowedAttr=function(a){\"use strict\";var b=A.lookupTable.role[a],c=b&&b.attributes&&b.attributes.allowed||[],d=b&&b.attributes&&b.attributes.required||[];return c.concat(A.lookupTable.globalAttributes).concat(d)},A.validateAttr=function(a){\"use strict\";return!!A.lookupTable.attributes[a]},A.validateAttrValue=function(a,b){\"use strict\";var c,d,e=a.getAttribute(b),f=A.lookupTable.attributes[b],g=D.getRootNode(a);if(!f)return!0;switch(f.type){case\"boolean\":case\"nmtoken\":return\"string\"==typeof e&&-1!==f.values.indexOf(e.toLowerCase());case\"nmtokens\":return d=axe.utils.tokenList(e),d.reduce(function(a,b){return a&&-1!==f.values.indexOf(b)},0!==d.length);case\"idref\":return!(!e||!g.getElementById(e));case\"idrefs\":return d=axe.utils.tokenList(e),d.reduce(function(a,b){return!(!a||!g.getElementById(b))},0!==d.length);case\"string\":return!0;case\"decimal\":return!(!(c=e.match(/^[-+]?([0-9]*)\\.?([0-9]*)$/))||!c[1]&&!c[2]);case\"int\":return/^[-+]?[0-9]+$/.test(e)}},A.labelVirtual=function(a){var b=a.actualNode,c=void 0,d=void 0;return b.getAttribute(\"aria-labelledby\")&&(c=D.idrefs(b,\"aria-labelledby\"),d=c.map(function(a){\nvar b=axe.utils.getNodeFromTree(axe._tree[0],a);return b?F.visibleVirtual(b,!0):\"\"}).join(\" \").trim())?d:(d=b.getAttribute(\"aria-label\"),d&&(d=F.sanitize(d).trim())?d:null)},A.label=function(a){return a=axe.utils.getNodeFromTree(axe._tree[0],a),A.labelVirtual(a)},A.isValidRole=function(a){\"use strict\";return!!A.lookupTable.role[a]},A.getRolesWithNameFromContents=function(){return Object.keys(A.lookupTable.role).filter(function(a){return A.lookupTable.role[a].nameFrom&&-1!==A.lookupTable.role[a].nameFrom.indexOf(\"contents\")})},A.getRolesByType=function(a){return Object.keys(A.lookupTable.role).filter(function(b){return A.lookupTable.role[b].type===a})},A.getRoleType=function(a){var b=A.lookupTable.role[a];return b&&b.type||null},A.requiredOwned=function(a){\"use strict\";var b=null,c=A.lookupTable.role[a];return c&&(b=axe.utils.clone(c.owned)),b},A.requiredContext=function(a){\"use strict\";var b=null,c=A.lookupTable.role[a];return c&&(b=axe.utils.clone(c.context)),b},A.implicitNodes=function(a){\"use strict\";var b=null,c=A.lookupTable.role[a];return c&&c.implicit&&(b=axe.utils.clone(c.implicit)),b},A.implicitRole=function(a){\"use strict\";var b=function(b,c){var d=function(b){return axe.utils.matchesSelector(a,b)};return c.implicit&&c.implicit.some(d)&&b.push(c.name),b},c=Object.keys(A.lookupTable.role).map(function(a){var b=A.lookupTable.role[a];return{name:a,implicit:b&&b.implicit}}),d=c.reduce(b,[]);if(!d.length)return null;for(var e=a.attributes,f=[],g=0,h=e.length;g<h;g++){var i=e[g];i.name.match(/^aria-/)&&f.push(i.name)}return function(a,b){var c=function(a){return A.allowedAttr(a).reduce(function(a,c){return a+(b.indexOf(c)>-1?1:0)},0)};return a.map(function(a){return{score:c(a),name:a}}).sort(function(a,b){return b.score-a.score}).map(function(a){return a.name})}(d,f).shift()},C.Color=function(a,b,c,d){this.red=a,this.green=b,this.blue=c,this.alpha=d,this.toHexString=function(){var a=Math.round(this.red).toString(16),b=Math.round(this.green).toString(16),c=Math.round(this.blue).toString(16);return\"#\"+(this.red>15.5?a:\"0\"+a)+(this.green>15.5?b:\"0\"+b)+(this.blue>15.5?c:\"0\"+c)};var e=/^rgb\\((\\d+), (\\d+), (\\d+)\\)$/,f=/^rgba\\((\\d+), (\\d+), (\\d+), (\\d*(\\.\\d+)?)\\)/;this.parseRgbString=function(a){if(\"transparent\"===a)return this.red=0,this.green=0,this.blue=0,void(this.alpha=0);var b=a.match(e);return b?(this.red=parseInt(b[1],10),this.green=parseInt(b[2],10),this.blue=parseInt(b[3],10),void(this.alpha=1)):(b=a.match(f),b?(this.red=parseInt(b[1],10),this.green=parseInt(b[2],10),this.blue=parseInt(b[3],10),void(this.alpha=parseFloat(b[4]))):void 0)},this.getRelativeLuminance=function(){var a=this.red/255,b=this.green/255,c=this.blue/255;return.2126*(a<=.03928?a/12.92:Math.pow((a+.055)/1.055,2.4))+.7152*(b<=.03928?b/12.92:Math.pow((b+.055)/1.055,2.4))+.0722*(c<=.03928?c/12.92:Math.pow((c+.055)/1.055,2.4))}},C.flattenColors=function(a,b){var c=a.alpha,d=(1-c)*b.red+c*a.red,e=(1-c)*b.green+c*a.green,f=(1-c)*b.blue+c*a.blue,g=a.alpha+b.alpha*(1-a.alpha);return new C.Color(d,e,f,g)},C.getContrast=function(a,b){if(!b||!a)return null;b.alpha<1&&(b=C.flattenColors(b,a));var c=a.getRelativeLuminance(),d=b.getRelativeLuminance();return(Math.max(d,c)+.05)/(Math.min(d,c)+.05)},C.hasValidContrastRatio=function(a,b,c,d){var e=C.getContrast(a,b),f=d&&Math.ceil(72*c)/96<14||!d&&Math.ceil(72*c)/96<18,g=f?4.5:3;return{isValid:e>g,contrastRatio:e,expectedContrastRatio:g}},C.elementIsDistinct=b;var G=[\"IMG\",\"CANVAS\",\"OBJECT\",\"IFRAME\",\"VIDEO\",\"SVG\"];C.getCoords=function(a){var b=void 0,c=void 0;if(!(a.left>window.innerWidth||a.top>window.innerHeight))return b=Math.min(Math.ceil(a.left+a.width/2),window.innerWidth-1),c=Math.min(Math.ceil(a.top+a.height/2),window.innerHeight-1),{x:b,y:c}},C.getRectStack=function(a){var b=C.getCoords(a.getBoundingClientRect());if(b){var c=D.shadowElementsFromPoint(b.x,b.y),d=Array.from(a.getClientRects());if(d&&d.length>1){var e=d.filter(function(a){return a.width&&a.width>0}).map(function(a){var b=C.getCoords(a);if(b)return D.shadowElementsFromPoint(b.x,b.y)});return e.splice(0,0,c),e}return[c]}return null},C.filteredRectStack=function(a){var b=C.getRectStack(a);if(b&&1===b.length)return b[0];if(b&&b.length>1){var c=b.shift(),d=void 0;return b.forEach(function(e,f){if(0!==f){var g=b[f-1],h=b[f];d=g.every(function(a,b){return a===h[b]})||c.includes(a)}}),d?b[0]:(axe.commons.color.incompleteData.set(\"bgColor\",\"elmPartiallyObscuring\"),null)}return axe.commons.color.incompleteData.set(\"bgColor\",\"outsideViewport\"),null},C.getBackgroundStack=function(a){var b=C.filteredRectStack(a);if(null===b)return null;b=h(b,a),b=D.reduceToElementsBelowFloating(b,a),b=i(b);var c=b.indexOf(a);return f(c,b,a)>=.99?(axe.commons.color.incompleteData.set(\"bgColor\",\"bgOverlap\"),null):-1!==c?b:null},C.getBackgroundColor=function(a){var b=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];if(!0!==(arguments.length>2&&void 0!==arguments[2]&&arguments[2])){var e=a.clientHeight-2>=2*window.innerHeight;a.scrollIntoView(e)}var f=[],h=C.getBackgroundStack(a);if((h||[]).some(function(e){var h=window.getComputedStyle(e),i=d(e,h);return g(a,e,i)||c(e,h)?(f=null,b.push(e),!0):0!==i.alpha&&(b.push(e),f.push(i),1===i.alpha)}),null!==f&&null!==h){f.push(new C.Color(255,255,255,1));return f.reduce(C.flattenColors)}return null},D.isOpaque=function(a){var b=window.getComputedStyle(a);return c(a,b)||1===d(a,b).alpha},C.getForegroundColor=function(a,b){var c=window.getComputedStyle(a),d=new C.Color;d.parseRgbString(c.getPropertyValue(\"color\"));var e=c.getPropertyValue(\"opacity\");if(d.alpha=d.alpha*e,1===d.alpha)return d;var f=C.getBackgroundColor(a,[],b);if(null===f){var g=axe.commons.color.incompleteData.get(\"bgColor\");return axe.commons.color.incompleteData.set(\"fgColor\",g),null}return C.flattenColors(d,f)},C.incompleteData=function(){var a={};return{set:function(b,c){if(\"string\"!=typeof b)throw new Error(\"Incomplete data: key must be a string\");return c&&(a[b]=c),a[b]},get:function(b){return a[b]},clear:function(){a={}}}}(),D.reduceToElementsBelowFloating=function(a,b){var c,d,e,f=[\"fixed\",\"sticky\"],g=[],h=!1;for(c=0;c<a.length;++c)d=a[c],d===b&&(h=!0),e=window.getComputedStyle(d),h||-1===f.indexOf(e.position)?g.push(d):g=[];return g},D.findElmsInContext=function(a){var b=a.context,c=a.value,d=a.attr,e=a.elm,f=void 0===e?\"\":e,g=void 0,h=axe.utils.escapeSelector(c);return g=9===b.nodeType||11===b.nodeType?b:D.getRootNode(b),Array.from(g.querySelectorAll(f+\"[\"+d+\"=\"+h+\"]\"))},D.findUp=function(a,b){return D.findUpVirtual(axe.utils.getNodeFromTree(axe._tree[0],a),b)},D.findUpVirtual=function(a,b){var c=void 0;if(c=a.actualNode,!a.shadowId&&\"function\"==typeof a.actualNode.closest){var d=a.actualNode.closest(b);return d||null}do{(c=c.assignedSlot?c.assignedSlot:c.parentNode)&&11===c.nodeType&&(c=c.host)}while(c&&!axe.utils.matchesSelector(c,b)&&c!==document.documentElement);return axe.utils.matchesSelector(c,b)?c:null},D.getComposedParent=function a(b){if(b.assignedSlot)return a(b.assignedSlot);if(b.parentNode){var c=b.parentNode;if(1===c.nodeType)return c;if(c.host)return c.host}return null},D.getElementByReference=function(a,b){var c=a.getAttribute(b);if(c&&\"#\"===c.charAt(0)){c=c.substring(1);var d=document.getElementById(c);if(d)return d;if(d=document.getElementsByName(c),d.length)return d[0]}return null},D.getElementCoordinates=function(a){\"use strict\";var b=D.getScrollOffset(document),c=b.left,d=b.top,e=a.getBoundingClientRect();return{top:e.top+d,right:e.right+c,bottom:e.bottom+d,left:e.left+c,width:e.right-e.left,height:e.bottom-e.top}},D.getRootNode=function(a){var b=a.getRootNode&&a.getRootNode()||document;return b===a&&(b=document),b},D.getScrollOffset=function(a){\"use strict\";if(!a.nodeType&&a.document&&(a=a.document),9===a.nodeType){var b=a.documentElement,c=a.body;return{left:b&&b.scrollLeft||c&&c.scrollLeft||0,top:b&&b.scrollTop||c&&c.scrollTop||0}}return{left:a.scrollLeft,top:a.scrollTop}},D.getViewportSize=function(a){\"use strict\";var b,c=a.document,d=c.documentElement;return a.innerWidth?{width:a.innerWidth,height:a.innerHeight}:d?{width:d.clientWidth,height:d.clientHeight}:(b=c.body,{width:b.clientWidth,height:b.clientHeight})};var H=[\"HEAD\",\"TITLE\",\"TEMPLATE\",\"SCRIPT\",\"STYLE\",\"IFRAME\",\"OBJECT\",\"VIDEO\",\"AUDIO\",\"NOSCRIPT\"];D.hasContentVirtual=function(a,b){return j(a)||D.isVisualContent(a.actualNode)||!!A.labelVirtual(a)||!b&&a.children.some(function(a){return 1===a.actualNode.nodeType&&D.hasContentVirtual(a)})},D.hasContent=function(a,b){return a=axe.utils.getNodeFromTree(axe._tree[0],a),D.hasContentVirtual(a,b)},D.idrefs=function(a,b){\"use strict\";var c,d,e=D.getRootNode(a),f=[],g=a.getAttribute(b);if(g)for(g=axe.utils.tokenList(g),c=0,d=g.length;c<d;c++)f.push(e.getElementById(g[c]));return f},D.isFocusable=function(a){\"use strict\";if(k(a))return!1;if(D.isNativelyFocusable(a))return!0;var b=a.getAttribute(\"tabindex\");return!(!b||isNaN(parseInt(b,10)))},D.isNativelyFocusable=function(a){\"use strict\";if(!a||k(a))return!1;switch(a.nodeName.toUpperCase()){case\"A\":case\"AREA\":if(a.href)return!0;break;case\"INPUT\":return\"hidden\"!==a.type;case\"TEXTAREA\":case\"SELECT\":case\"DETAILS\":case\"BUTTON\":return!0}return!1},D.insertedIntoFocusOrder=function(a){return a.tabIndex>-1&&D.isFocusable(a)&&!D.isNativelyFocusable(a)},D.isHTML5=function(a){var b=a.doctype;return null!==b&&(\"html\"===b.name&&!b.publicId&&!b.systemId)};var I=[\"block\",\"list-item\",\"table\",\"flex\",\"grid\",\"inline-block\"];D.isInTextBlock=function(a){if(m(a))return!1;var b=n(a),c=\"\",d=\"\",e=0;return l(b,function(b){if(2===e)return!1;if(3===b.nodeType&&(c+=b.nodeValue),1===b.nodeType){var f=(b.nodeName||\"\").toUpperCase();if([\"BR\",\"HR\"].includes(f))0===e?(c=\"\",d=\"\"):e=2;else{if(\"none\"===b.style.display||\"hidden\"===b.style.overflow||![\"\",null,\"none\"].includes(b.style.float)||![\"\",null,\"relative\"].includes(b.style.position))return!1;if(\"A\"===f&&b.href||\"link\"===(b.getAttribute(\"role\")||\"\").toLowerCase())return b===a&&(e=1),d+=b.textContent,!1}}}),c=axe.commons.text.sanitize(c),d=axe.commons.text.sanitize(d),c.length>d.length},D.isNode=function(a){\"use strict\";return a instanceof Node},D.isOffscreen=function(a){var b=void 0,c=document.documentElement,d=window.getComputedStyle(a),e=window.getComputedStyle(document.body||c).getPropertyValue(\"direction\"),f=D.getElementCoordinates(a);if(f.bottom<0&&(o(a,f.bottom)||\"absolute\"===d.position))return!0;if(0===f.left&&0===f.right)return!1;if(\"ltr\"===e){if(f.right<=0)return!0}else if(b=Math.max(c.scrollWidth,D.getViewportSize(window).width),f.left>=b)return!0;return!1},D.isVisible=function(a,b,c){\"use strict\";var d,e,f;return 9===a.nodeType||(11===a.nodeType&&(a=a.host),null!==(d=window.getComputedStyle(a,null))&&(e=a.nodeName.toUpperCase(),!(\"none\"===d.getPropertyValue(\"display\")||\"STYLE\"===e.toUpperCase()||\"SCRIPT\"===e.toUpperCase()||!b&&p(d.getPropertyValue(\"clip\"))||!c&&(\"hidden\"===d.getPropertyValue(\"visibility\")||!b&&D.isOffscreen(a))||b&&\"true\"===a.getAttribute(\"aria-hidden\"))&&(!!(f=a.assignedSlot?a.assignedSlot:a.parentNode)&&D.isVisible(f,b,!0))))};var J=[\"checkbox\",\"img\",\"radio\",\"range\",\"slider\",\"spinbutton\",\"textbox\"];D.isVisualContent=function(a){var b=a.getAttribute(\"role\");if(b)return-1!==J.indexOf(b);switch(a.tagName.toUpperCase()){case\"IMG\":case\"IFRAME\":case\"OBJECT\":case\"VIDEO\":case\"AUDIO\":case\"CANVAS\":case\"SVG\":case\"MATH\":case\"BUTTON\":case\"SELECT\":case\"TEXTAREA\":case\"KEYGEN\":case\"PROGRESS\":case\"METER\":return!0;case\"INPUT\":return\"hidden\"!==a.type;default:return!1}},D.shadowElementsFromPoint=function(a,b){return(arguments.length>2&&void 0!==arguments[2]?arguments[2]:document).elementsFromPoint(a,b).reduce(function(c,d){if(axe.utils.isShadowRoot(d)){var e=D.shadowElementsFromPoint(a,b,d.shadowRoot);c=c.concat(e),c.length&&axe.commons.dom.visuallyContains(c[0],d)&&c.push(d)}else c.push(d);return c},[])},D.visuallyContains=function(a,b){var c=a.getBoundingClientRect(),d={top:c.top+.01,bottom:c.bottom-.01,left:c.left+.01,right:c.right-.01},e=b.getBoundingClientRect(),f=e.top,g=e.left,h={top:f-b.scrollTop,bottom:f-b.scrollTop+b.scrollHeight,left:g-b.scrollLeft,right:g-b.scrollLeft+b.scrollWidth},i=window.getComputedStyle(b);return\"inline\"===i.getPropertyValue(\"display\")||!(d.left<h.left&&d.left<e.left||d.top<h.top&&d.top<e.top||d.right>h.right&&d.right>e.right||d.bottom>h.bottom&&d.bottom>e.bottom)&&(!(d.right>e.right||d.bottom>e.bottom)||(\"scroll\"===i.overflow||\"auto\"===i.overflow||\"hidden\"===i.overflow||b instanceof HTMLBodyElement||b instanceof HTMLHtmlElement))},D.visuallyOverlaps=function(a,b){var c=b.getBoundingClientRect(),d=c.top,e=c.left,f={top:d-b.scrollTop,bottom:d-b.scrollTop+b.scrollHeight,left:e-b.scrollLeft,right:e-b.scrollLeft+b.scrollWidth};if(a.left>f.right&&a.left>c.right||a.top>f.bottom&&a.top>c.bottom||a.right<f.left&&a.right<c.left||a.bottom<f.top&&a.bottom<c.top)return!1;var g=window.getComputedStyle(b);return!(a.left>c.right||a.top>c.bottom)||(\"scroll\"===g.overflow||\"auto\"===g.overflow||b instanceof HTMLBodyElement||b instanceof HTMLHtmlElement)},E.getAllCells=function(a){var b,c,d,e,f=[];for(b=0,d=a.rows.length;b<d;b++)for(c=0,e=a.rows[b].cells.length;c<e;c++)f.push(a.rows[b].cells[c]);return f},E.getCellPosition=function(a,b){var c,d;for(b||(b=E.toGrid(D.findUp(a,\"table\"))),c=0;c<b.length;c++)if(b[c]&&-1!==(d=b[c].indexOf(a)))return{x:d,y:c}},E.getHeaders=function(a){if(a.hasAttribute(\"headers\"))return commons.dom.idrefs(a,\"headers\");var b=commons.table.toGrid(commons.dom.findUp(a,\"table\")),c=commons.table.getCellPosition(a,b);return[].concat(E.traverse(\"left\",c,b).filter(function(a){return E.isRowHeader(a)}),E.traverse(\"up\",c,b).filter(function(a){return E.isColumnHeader(a)})).reverse()},E.getScope=function(a){var b=a.getAttribute(\"scope\"),c=a.getAttribute(\"role\");if(a instanceof Element==!1||-1===[\"TD\",\"TH\"].indexOf(a.nodeName.toUpperCase()))throw new TypeError(\"Expected TD or TH element\");if(\"columnheader\"===c)return\"col\";if(\"rowheader\"===c)return\"row\";if(\"col\"===b||\"row\"===b)return b;if(\"TH\"!==a.nodeName.toUpperCase())return!1;var d=E.toGrid(D.findUp(a,\"table\")),e=E.getCellPosition(a);return d[e.y].reduce(function(a,b){return a&&\"TH\"===b.nodeName.toUpperCase()},!0)?\"col\":d.map(function(a){return a[e.x]}).reduce(function(a,b){return a&&\"TH\"===b.nodeName.toUpperCase()},!0)?\"row\":\"auto\"},E.isColumnHeader=function(a){return-1!==[\"col\",\"auto\"].indexOf(E.getScope(a))},E.isDataCell=function(a){return!(!a.children.length&&!a.textContent.trim())&&\"TD\"===a.nodeName.toUpperCase()},E.isDataTable=function(a){var b=(a.getAttribute(\"role\")||\"\").toLowerCase();if((\"presentation\"===b||\"none\"===b)&&!D.isFocusable(a))return!1;if(\"true\"===a.getAttribute(\"contenteditable\")||D.findUp(a,'[contenteditable=\"true\"]'))return!0;if(\"grid\"===b||\"treegrid\"===b||\"table\"===b)return!0;if(\"landmark\"===commons.aria.getRoleType(b))return!0;if(\"0\"===a.getAttribute(\"datatable\"))return!1;if(a.getAttribute(\"summary\"))return!0;if(a.tHead||a.tFoot||a.caption)return!0;for(var c=0,d=a.children.length;c<d;c++)if(\"COLGROUP\"===a.children[c].nodeName.toUpperCase())return!0;for(var e,f,g=0,h=a.rows.length,i=!1,j=0;j<h;j++){e=a.rows[j];for(var k=0,l=e.cells.length;k<l;k++){if(f=e.cells[k],\"TH\"===f.nodeName.toUpperCase())return!0;if(i||f.offsetWidth===f.clientWidth&&f.offsetHeight===f.clientHeight||(i=!0),f.getAttribute(\"scope\")||f.getAttribute(\"headers\")||f.getAttribute(\"abbr\"))return!0;if([\"columnheader\",\"rowheader\"].includes((f.getAttribute(\"role\")||\"\").toLowerCase()))return!0;if(1===f.children.length&&\"ABBR\"===f.children[0].nodeName.toUpperCase())return!0;g++}}if(a.getElementsByTagName(\"table\").length)return!1;if(h<2)return!1;var m=a.rows[Math.ceil(h/2)];if(1===m.cells.length&&1===m.cells[0].colSpan)return!1;if(m.cells.length>=5)return!0;if(i)return!0;var n,o;for(j=0;j<h;j++){if(e=a.rows[j],n&&n!==window.getComputedStyle(e).getPropertyValue(\"background-color\"))return!0;if(n=window.getComputedStyle(e).getPropertyValue(\"background-color\"),o&&o!==window.getComputedStyle(e).getPropertyValue(\"background-image\"))return!0;o=window.getComputedStyle(e).getPropertyValue(\"background-image\")}return h>=20||!(D.getElementCoordinates(a).width>.95*D.getViewportSize(window).width)&&(!(g<10)&&!a.querySelector(\"object, embed, iframe, applet\"))},E.isHeader=function(a){if(E.isColumnHeader(a)||E.isRowHeader(a))return!0;if(a.getAttribute(\"id\")){var b=axe.utils.escapeSelector(a.getAttribute(\"id\"));return!!document.querySelector('[headers~=\"'+b+'\"]')}return!1},E.isRowHeader=function(a){return[\"row\",\"auto\"].includes(E.getScope(a))},E.toGrid=function(a){for(var b=[],c=a.rows,d=0,e=c.length;d<e;d++){var f=c[d].cells;b[d]=b[d]||[];for(var g=0,h=0,i=f.length;h<i;h++)for(var j=0;j<f[h].colSpan;j++){for(var k=0;k<f[h].rowSpan;k++){for(b[d+k]=b[d+k]||[];b[d+k][g];)g++;b[d+k][g]=f[h]}g++}}return b},E.toArray=E.toGrid,function(a){var b=function a(b,c,d,e){var f,g=d[c.y]?d[c.y][c.x]:void 0;return g?\"function\"==typeof e&&!0===(f=e(g,c,d))?[g]:(f=a(b,{x:c.x+b.x,y:c.y+b.y},d,e),f.unshift(g),f):[]};a.traverse=function(a,c,d,e){if(Array.isArray(c)&&(e=d,d=c,c={x:0,y:0}),\"string\"==typeof a)switch(a){case\"left\":a={x:-1,y:0};break;case\"up\":a={x:0,y:-1};break;case\"right\":a={x:1,y:0};break;case\"down\":a={x:0,y:1}}return b(a,{x:c.x+a.x,y:c.y+a.y},d,e)}}(E);var K={submit:\"Submit\",reset:\"Reset\"},L=[\"text\",\"search\",\"tel\",\"url\",\"email\",\"date\",\"time\",\"number\",\"range\",\"color\"],M=[\"A\",\"EM\",\"STRONG\",\"SMALL\",\"MARK\",\"ABBR\",\"DFN\",\"I\",\"B\",\"S\",\"U\",\"CODE\",\"VAR\",\"SAMP\",\"KBD\",\"SUP\",\"SUB\",\"Q\",\"CITE\",\"SPAN\",\"BDO\",\"BDI\",\"BR\",\"WBR\",\"INS\",\"DEL\",\"IMG\",\"EMBED\",\"OBJECT\",\"IFRAME\",\"MAP\",\"AREA\",\"SCRIPT\",\"NOSCRIPT\",\"RUBY\",\"VIDEO\",\"AUDIO\",\"INPUT\",\"TEXTAREA\",\"SELECT\",\"BUTTON\",\"LABEL\",\"OUTPUT\",\"DATALIST\",\"KEYGEN\",\"PROGRESS\",\"COMMAND\",\"CANVAS\",\"TIME\",\"METER\"];F.accessibleText=function(a,b){var c=axe.utils.getNodeFromTree(axe._tree[0],a);return axe.commons.text.accessibleTextVirtual(c,b)},F.accessibleTextVirtual=function(a,b){function c(a,b,c){return a.children.reduce(function(a,d){var e=d.actualNode;return 3===e.nodeType?a+=e.nodeValue:1===e.nodeType&&(M.includes(e.nodeName.toUpperCase())||(a+=\" \"),a+=g(d,b,c)),a},\"\")}function d(a){return axe.commons.table.isDataTable(a.actualNode)||1!==axe.commons.table.getAllCells(a.actualNode).length?\"\":c(a,!1,!1).trim()}function e(a,b,e){var f=\"\",h=a.actualNode,i=h.nodeName.toUpperCase();if(t(a)&&(f=c(a,!1,!1)||\"\",z(f)))return f;if(\"FIGURE\"===i&&(f=w(a,\"figcaption\"),z(f)))return f;if(\"TABLE\"===i){if(f=w(a,\"caption\"),z(f))return f;if(f=h.getAttribute(\"title\")||h.getAttribute(\"summary\")||d(a)||\"\",z(f))return f}if(y(a))return h.getAttribute(\"alt\")||\"\";if(s(a)&&!e){if(r(a))return h.value||h.title||K[h.type]||\"\";var j=q(a);if(j)return g(j,b,!0)}return\"\"}function f(a,b,c){var d=\"\",e=a.actualNode;return!b&&e.hasAttribute(\"aria-labelledby\")&&(d=F.sanitize(D.idrefs(e,\"aria-labelledby\").map(function(a){if(null!==a){e===a&&h.pop();var b=axe.utils.getNodeFromTree(axe._tree[0],a);return g(b,!0,e!==a)}return\"\"}).join(\" \"))),d||c&&x(a)||!e.hasAttribute(\"aria-label\")?d:F.sanitize(e.getAttribute(\"aria-label\"))}var g=void 0,h=[];return a instanceof Node&&(a=axe.utils.getNodeFromTree(axe._tree[0],a)),g=function(a,b,d){var g=void 0;if(!a||h.includes(a))return\"\";if(null!==a&&a.actualNode instanceof Node!=!0)throw new Error(\"Invalid argument. Virtual Node must be provided\");if(!b&&!D.isVisible(a.actualNode,!0))return\"\";h.push(a);var i=a.actualNode.getAttribute(\"role\");return g=f(a,b,d),z(g)?g:(g=e(a,b,d),z(g)?g:d&&(g=v(a),z(g))?g:u(a)||i&&-1===A.getRolesWithNameFromContents().indexOf(i)||(g=c(a,b,d),!z(g))?a.actualNode.hasAttribute(\"title\")?a.actualNode.getAttribute(\"title\"):\"\":g)},F.sanitize(g(a,b))},F.labelVirtual=function(a){var b,c,d;if(c=A.labelVirtual(a))return c;if(a.actualNode.id){var e=axe.commons.utils.escapeSelector(a.actualNode.getAttribute(\"id\"));if(d=axe.commons.dom.getRootNode(a.actualNode),b=d.querySelector('label[for=\"'+e+'\"]'),c=b&&F.visible(b,!0))return c}return b=D.findUpVirtual(a,\"label\"),(c=b&&F.visible(b,!0))||null},F.label=function(a){return a=axe.utils.getNodeFromTree(axe._tree[0],a),F.labelVirtual(a)},F.sanitize=function(a){\"use strict\";return a.replace(/\\r\\n/g,\"\\n\").replace(/\\u00A0/g,\" \").replace(/[\\s]{2,}/g,\" \").trim()},F.visibleVirtual=function(a,b,c){var d=a.children.map(function(d){if(3===d.actualNode.nodeType){var e=d.actualNode.nodeValue;if(e&&D.isVisible(a.actualNode,b))return e}else if(!c)return F.visibleVirtual(d,b)}).join(\"\");return F.sanitize(d)},F.visible=function(a,b,c){return a=axe.utils.getNodeFromTree(axe._tree[0],a),F.visibleVirtual(a,b,c)},axe.utils.tokenList=function(a){\"use strict\";return a.trim().replace(/\\s{2,}/g,\" \").split(\" \")}\n;var N=[\"aa\",\"ab\",\"ae\",\"af\",\"ak\",\"am\",\"an\",\"ar\",\"as\",\"av\",\"ay\",\"az\",\"ba\",\"be\",\"bg\",\"bh\",\"bi\",\"bm\",\"bn\",\"bo\",\"br\",\"bs\",\"ca\",\"ce\",\"ch\",\"co\",\"cr\",\"cs\",\"cu\",\"cv\",\"cy\",\"da\",\"de\",\"dv\",\"dz\",\"ee\",\"el\",\"en\",\"eo\",\"es\",\"et\",\"eu\",\"fa\",\"ff\",\"fi\",\"fj\",\"fo\",\"fr\",\"fy\",\"ga\",\"gd\",\"gl\",\"gn\",\"gu\",\"gv\",\"ha\",\"he\",\"hi\",\"ho\",\"hr\",\"ht\",\"hu\",\"hy\",\"hz\",\"ia\",\"id\",\"ie\",\"ig\",\"ii\",\"ik\",\"in\",\"io\",\"is\",\"it\",\"iu\",\"iw\",\"ja\",\"ji\",\"jv\",\"jw\",\"ka\",\"kg\",\"ki\",\"kj\",\"kk\",\"kl\",\"km\",\"kn\",\"ko\",\"kr\",\"ks\",\"ku\",\"kv\",\"kw\",\"ky\",\"la\",\"lb\",\"lg\",\"li\",\"ln\",\"lo\",\"lt\",\"lu\",\"lv\",\"mg\",\"mh\",\"mi\",\"mk\",\"ml\",\"mn\",\"mo\",\"mr\",\"ms\",\"mt\",\"my\",\"na\",\"nb\",\"nd\",\"ne\",\"ng\",\"nl\",\"nn\",\"no\",\"nr\",\"nv\",\"ny\",\"oc\",\"oj\",\"om\",\"or\",\"os\",\"pa\",\"pi\",\"pl\",\"ps\",\"pt\",\"qu\",\"rm\",\"rn\",\"ro\",\"ru\",\"rw\",\"sa\",\"sc\",\"sd\",\"se\",\"sg\",\"sh\",\"si\",\"sk\",\"sl\",\"sm\",\"sn\",\"so\",\"sq\",\"sr\",\"ss\",\"st\",\"su\",\"sv\",\"sw\",\"ta\",\"te\",\"tg\",\"th\",\"ti\",\"tk\",\"tl\",\"tn\",\"to\",\"tr\",\"ts\",\"tt\",\"tw\",\"ty\",\"ug\",\"uk\",\"ur\",\"uz\",\"ve\",\"vi\",\"vo\",\"wa\",\"wo\",\"xh\",\"yi\",\"yo\",\"za\",\"zh\",\"zu\",\"aaa\",\"aab\",\"aac\",\"aad\",\"aae\",\"aaf\",\"aag\",\"aah\",\"aai\",\"aak\",\"aal\",\"aam\",\"aan\",\"aao\",\"aap\",\"aaq\",\"aas\",\"aat\",\"aau\",\"aav\",\"aaw\",\"aax\",\"aaz\",\"aba\",\"abb\",\"abc\",\"abd\",\"abe\",\"abf\",\"abg\",\"abh\",\"abi\",\"abj\",\"abl\",\"abm\",\"abn\",\"abo\",\"abp\",\"abq\",\"abr\",\"abs\",\"abt\",\"abu\",\"abv\",\"abw\",\"abx\",\"aby\",\"abz\",\"aca\",\"acb\",\"acd\",\"ace\",\"acf\",\"ach\",\"aci\",\"ack\",\"acl\",\"acm\",\"acn\",\"acp\",\"acq\",\"acr\",\"acs\",\"act\",\"acu\",\"acv\",\"acw\",\"acx\",\"acy\",\"acz\",\"ada\",\"adb\",\"add\",\"ade\",\"adf\",\"adg\",\"adh\",\"adi\",\"adj\",\"adl\",\"adn\",\"ado\",\"adp\",\"adq\",\"adr\",\"ads\",\"adt\",\"adu\",\"adw\",\"adx\",\"ady\",\"adz\",\"aea\",\"aeb\",\"aec\",\"aed\",\"aee\",\"aek\",\"ael\",\"aem\",\"aen\",\"aeq\",\"aer\",\"aes\",\"aeu\",\"aew\",\"aey\",\"aez\",\"afa\",\"afb\",\"afd\",\"afe\",\"afg\",\"afh\",\"afi\",\"afk\",\"afn\",\"afo\",\"afp\",\"afs\",\"aft\",\"afu\",\"afz\",\"aga\",\"agb\",\"agc\",\"agd\",\"age\",\"agf\",\"agg\",\"agh\",\"agi\",\"agj\",\"agk\",\"agl\",\"agm\",\"agn\",\"ago\",\"agp\",\"agq\",\"agr\",\"ags\",\"agt\",\"agu\",\"agv\",\"agw\",\"agx\",\"agy\",\"agz\",\"aha\",\"ahb\",\"ahg\",\"ahh\",\"ahi\",\"ahk\",\"ahl\",\"ahm\",\"ahn\",\"aho\",\"ahp\",\"ahr\",\"ahs\",\"aht\",\"aia\",\"aib\",\"aic\",\"aid\",\"aie\",\"aif\",\"aig\",\"aih\",\"aii\",\"aij\",\"aik\",\"ail\",\"aim\",\"ain\",\"aio\",\"aip\",\"aiq\",\"air\",\"ais\",\"ait\",\"aiw\",\"aix\",\"aiy\",\"aja\",\"ajg\",\"aji\",\"ajn\",\"ajp\",\"ajt\",\"aju\",\"ajw\",\"ajz\",\"akb\",\"akc\",\"akd\",\"ake\",\"akf\",\"akg\",\"akh\",\"aki\",\"akj\",\"akk\",\"akl\",\"akm\",\"ako\",\"akp\",\"akq\",\"akr\",\"aks\",\"akt\",\"aku\",\"akv\",\"akw\",\"akx\",\"aky\",\"akz\",\"ala\",\"alc\",\"ald\",\"ale\",\"alf\",\"alg\",\"alh\",\"ali\",\"alj\",\"alk\",\"all\",\"alm\",\"aln\",\"alo\",\"alp\",\"alq\",\"alr\",\"als\",\"alt\",\"alu\",\"alv\",\"alw\",\"alx\",\"aly\",\"alz\",\"ama\",\"amb\",\"amc\",\"ame\",\"amf\",\"amg\",\"ami\",\"amj\",\"amk\",\"aml\",\"amm\",\"amn\",\"amo\",\"amp\",\"amq\",\"amr\",\"ams\",\"amt\",\"amu\",\"amv\",\"amw\",\"amx\",\"amy\",\"amz\",\"ana\",\"anb\",\"anc\",\"and\",\"ane\",\"anf\",\"ang\",\"anh\",\"ani\",\"anj\",\"ank\",\"anl\",\"anm\",\"ann\",\"ano\",\"anp\",\"anq\",\"anr\",\"ans\",\"ant\",\"anu\",\"anv\",\"anw\",\"anx\",\"any\",\"anz\",\"aoa\",\"aob\",\"aoc\",\"aod\",\"aoe\",\"aof\",\"aog\",\"aoh\",\"aoi\",\"aoj\",\"aok\",\"aol\",\"aom\",\"aon\",\"aor\",\"aos\",\"aot\",\"aou\",\"aox\",\"aoz\",\"apa\",\"apb\",\"apc\",\"apd\",\"ape\",\"apf\",\"apg\",\"aph\",\"api\",\"apj\",\"apk\",\"apl\",\"apm\",\"apn\",\"apo\",\"app\",\"apq\",\"apr\",\"aps\",\"apt\",\"apu\",\"apv\",\"apw\",\"apx\",\"apy\",\"apz\",\"aqa\",\"aqc\",\"aqd\",\"aqg\",\"aql\",\"aqm\",\"aqn\",\"aqp\",\"aqr\",\"aqt\",\"aqz\",\"arb\",\"arc\",\"ard\",\"are\",\"arh\",\"ari\",\"arj\",\"ark\",\"arl\",\"arn\",\"aro\",\"arp\",\"arq\",\"arr\",\"ars\",\"art\",\"aru\",\"arv\",\"arw\",\"arx\",\"ary\",\"arz\",\"asa\",\"asb\",\"asc\",\"asd\",\"ase\",\"asf\",\"asg\",\"ash\",\"asi\",\"asj\",\"ask\",\"asl\",\"asn\",\"aso\",\"asp\",\"asq\",\"asr\",\"ass\",\"ast\",\"asu\",\"asv\",\"asw\",\"asx\",\"asy\",\"asz\",\"ata\",\"atb\",\"atc\",\"atd\",\"ate\",\"atg\",\"ath\",\"ati\",\"atj\",\"atk\",\"atl\",\"atm\",\"atn\",\"ato\",\"atp\",\"atq\",\"atr\",\"ats\",\"att\",\"atu\",\"atv\",\"atw\",\"atx\",\"aty\",\"atz\",\"aua\",\"aub\",\"auc\",\"aud\",\"aue\",\"auf\",\"aug\",\"auh\",\"aui\",\"auj\",\"auk\",\"aul\",\"aum\",\"aun\",\"auo\",\"aup\",\"auq\",\"aur\",\"aus\",\"aut\",\"auu\",\"auw\",\"aux\",\"auy\",\"auz\",\"avb\",\"avd\",\"avi\",\"avk\",\"avl\",\"avm\",\"avn\",\"avo\",\"avs\",\"avt\",\"avu\",\"avv\",\"awa\",\"awb\",\"awc\",\"awd\",\"awe\",\"awg\",\"awh\",\"awi\",\"awk\",\"awm\",\"awn\",\"awo\",\"awr\",\"aws\",\"awt\",\"awu\",\"awv\",\"aww\",\"awx\",\"awy\",\"axb\",\"axe\",\"axg\",\"axk\",\"axl\",\"axm\",\"axx\",\"aya\",\"ayb\",\"ayc\",\"ayd\",\"aye\",\"ayg\",\"ayh\",\"ayi\",\"ayk\",\"ayl\",\"ayn\",\"ayo\",\"ayp\",\"ayq\",\"ayr\",\"ays\",\"ayt\",\"ayu\",\"ayx\",\"ayy\",\"ayz\",\"aza\",\"azb\",\"azc\",\"azd\",\"azg\",\"azj\",\"azm\",\"azn\",\"azo\",\"azt\",\"azz\",\"baa\",\"bab\",\"bac\",\"bad\",\"bae\",\"baf\",\"bag\",\"bah\",\"bai\",\"baj\",\"bal\",\"ban\",\"bao\",\"bap\",\"bar\",\"bas\",\"bat\",\"bau\",\"bav\",\"baw\",\"bax\",\"bay\",\"baz\",\"bba\",\"bbb\",\"bbc\",\"bbd\",\"bbe\",\"bbf\",\"bbg\",\"bbh\",\"bbi\",\"bbj\",\"bbk\",\"bbl\",\"bbm\",\"bbn\",\"bbo\",\"bbp\",\"bbq\",\"bbr\",\"bbs\",\"bbt\",\"bbu\",\"bbv\",\"bbw\",\"bbx\",\"bby\",\"bbz\",\"bca\",\"bcb\",\"bcc\",\"bcd\",\"bce\",\"bcf\",\"bcg\",\"bch\",\"bci\",\"bcj\",\"bck\",\"bcl\",\"bcm\",\"bcn\",\"bco\",\"bcp\",\"bcq\",\"bcr\",\"bcs\",\"bct\",\"bcu\",\"bcv\",\"bcw\",\"bcy\",\"bcz\",\"bda\",\"bdb\",\"bdc\",\"bdd\",\"bde\",\"bdf\",\"bdg\",\"bdh\",\"bdi\",\"bdj\",\"bdk\",\"bdl\",\"bdm\",\"bdn\",\"bdo\",\"bdp\",\"bdq\",\"bdr\",\"bds\",\"bdt\",\"bdu\",\"bdv\",\"bdw\",\"bdx\",\"bdy\",\"bdz\",\"bea\",\"beb\",\"bec\",\"bed\",\"bee\",\"bef\",\"beg\",\"beh\",\"bei\",\"bej\",\"bek\",\"bem\",\"beo\",\"bep\",\"beq\",\"ber\",\"bes\",\"bet\",\"beu\",\"bev\",\"bew\",\"bex\",\"bey\",\"bez\",\"bfa\",\"bfb\",\"bfc\",\"bfd\",\"bfe\",\"bff\",\"bfg\",\"bfh\",\"bfi\",\"bfj\",\"bfk\",\"bfl\",\"bfm\",\"bfn\",\"bfo\",\"bfp\",\"bfq\",\"bfr\",\"bfs\",\"bft\",\"bfu\",\"bfw\",\"bfx\",\"bfy\",\"bfz\",\"bga\",\"bgb\",\"bgc\",\"bgd\",\"bge\",\"bgf\",\"bgg\",\"bgi\",\"bgj\",\"bgk\",\"bgl\",\"bgm\",\"bgn\",\"bgo\",\"bgp\",\"bgq\",\"bgr\",\"bgs\",\"bgt\",\"bgu\",\"bgv\",\"bgw\",\"bgx\",\"bgy\",\"bgz\",\"bha\",\"bhb\",\"bhc\",\"bhd\",\"bhe\",\"bhf\",\"bhg\",\"bhh\",\"bhi\",\"bhj\",\"bhk\",\"bhl\",\"bhm\",\"bhn\",\"bho\",\"bhp\",\"bhq\",\"bhr\",\"bhs\",\"bht\",\"bhu\",\"bhv\",\"bhw\",\"bhx\",\"bhy\",\"bhz\",\"bia\",\"bib\",\"bic\",\"bid\",\"bie\",\"bif\",\"big\",\"bij\",\"bik\",\"bil\",\"bim\",\"bin\",\"bio\",\"bip\",\"biq\",\"bir\",\"bit\",\"biu\",\"biv\",\"biw\",\"bix\",\"biy\",\"biz\",\"bja\",\"bjb\",\"bjc\",\"bjd\",\"bje\",\"bjf\",\"bjg\",\"bjh\",\"bji\",\"bjj\",\"bjk\",\"bjl\",\"bjm\",\"bjn\",\"bjo\",\"bjp\",\"bjq\",\"bjr\",\"bjs\",\"bjt\",\"bju\",\"bjv\",\"bjw\",\"bjx\",\"bjy\",\"bjz\",\"bka\",\"bkb\",\"bkc\",\"bkd\",\"bkf\",\"bkg\",\"bkh\",\"bki\",\"bkj\",\"bkk\",\"bkl\",\"bkm\",\"bkn\",\"bko\",\"bkp\",\"bkq\",\"bkr\",\"bks\",\"bkt\",\"bku\",\"bkv\",\"bkw\",\"bkx\",\"bky\",\"bkz\",\"bla\",\"blb\",\"blc\",\"bld\",\"ble\",\"blf\",\"blg\",\"blh\",\"bli\",\"blj\",\"blk\",\"bll\",\"blm\",\"bln\",\"blo\",\"blp\",\"blq\",\"blr\",\"bls\",\"blt\",\"blv\",\"blw\",\"blx\",\"bly\",\"blz\",\"bma\",\"bmb\",\"bmc\",\"bmd\",\"bme\",\"bmf\",\"bmg\",\"bmh\",\"bmi\",\"bmj\",\"bmk\",\"bml\",\"bmm\",\"bmn\",\"bmo\",\"bmp\",\"bmq\",\"bmr\",\"bms\",\"bmt\",\"bmu\",\"bmv\",\"bmw\",\"bmx\",\"bmy\",\"bmz\",\"bna\",\"bnb\",\"bnc\",\"bnd\",\"bne\",\"bnf\",\"bng\",\"bni\",\"bnj\",\"bnk\",\"bnl\",\"bnm\",\"bnn\",\"bno\",\"bnp\",\"bnq\",\"bnr\",\"bns\",\"bnt\",\"bnu\",\"bnv\",\"bnw\",\"bnx\",\"bny\",\"bnz\",\"boa\",\"bob\",\"boe\",\"bof\",\"bog\",\"boh\",\"boi\",\"boj\",\"bok\",\"bol\",\"bom\",\"bon\",\"boo\",\"bop\",\"boq\",\"bor\",\"bot\",\"bou\",\"bov\",\"bow\",\"box\",\"boy\",\"boz\",\"bpa\",\"bpb\",\"bpd\",\"bpg\",\"bph\",\"bpi\",\"bpj\",\"bpk\",\"bpl\",\"bpm\",\"bpn\",\"bpo\",\"bpp\",\"bpq\",\"bpr\",\"bps\",\"bpt\",\"bpu\",\"bpv\",\"bpw\",\"bpx\",\"bpy\",\"bpz\",\"bqa\",\"bqb\",\"bqc\",\"bqd\",\"bqf\",\"bqg\",\"bqh\",\"bqi\",\"bqj\",\"bqk\",\"bql\",\"bqm\",\"bqn\",\"bqo\",\"bqp\",\"bqq\",\"bqr\",\"bqs\",\"bqt\",\"bqu\",\"bqv\",\"bqw\",\"bqx\",\"bqy\",\"bqz\",\"bra\",\"brb\",\"brc\",\"brd\",\"brf\",\"brg\",\"brh\",\"bri\",\"brj\",\"brk\",\"brl\",\"brm\",\"brn\",\"bro\",\"brp\",\"brq\",\"brr\",\"brs\",\"brt\",\"bru\",\"brv\",\"brw\",\"brx\",\"bry\",\"brz\",\"bsa\",\"bsb\",\"bsc\",\"bse\",\"bsf\",\"bsg\",\"bsh\",\"bsi\",\"bsj\",\"bsk\",\"bsl\",\"bsm\",\"bsn\",\"bso\",\"bsp\",\"bsq\",\"bsr\",\"bss\",\"bst\",\"bsu\",\"bsv\",\"bsw\",\"bsx\",\"bsy\",\"bta\",\"btb\",\"btc\",\"btd\",\"bte\",\"btf\",\"btg\",\"bth\",\"bti\",\"btj\",\"btk\",\"btl\",\"btm\",\"btn\",\"bto\",\"btp\",\"btq\",\"btr\",\"bts\",\"btt\",\"btu\",\"btv\",\"btw\",\"btx\",\"bty\",\"btz\",\"bua\",\"bub\",\"buc\",\"bud\",\"bue\",\"buf\",\"bug\",\"buh\",\"bui\",\"buj\",\"buk\",\"bum\",\"bun\",\"buo\",\"bup\",\"buq\",\"bus\",\"but\",\"buu\",\"buv\",\"buw\",\"bux\",\"buy\",\"buz\",\"bva\",\"bvb\",\"bvc\",\"bvd\",\"bve\",\"bvf\",\"bvg\",\"bvh\",\"bvi\",\"bvj\",\"bvk\",\"bvl\",\"bvm\",\"bvn\",\"bvo\",\"bvp\",\"bvq\",\"bvr\",\"bvt\",\"bvu\",\"bvv\",\"bvw\",\"bvx\",\"bvy\",\"bvz\",\"bwa\",\"bwb\",\"bwc\",\"bwd\",\"bwe\",\"bwf\",\"bwg\",\"bwh\",\"bwi\",\"bwj\",\"bwk\",\"bwl\",\"bwm\",\"bwn\",\"bwo\",\"bwp\",\"bwq\",\"bwr\",\"bws\",\"bwt\",\"bwu\",\"bww\",\"bwx\",\"bwy\",\"bwz\",\"bxa\",\"bxb\",\"bxc\",\"bxd\",\"bxe\",\"bxf\",\"bxg\",\"bxh\",\"bxi\",\"bxj\",\"bxk\",\"bxl\",\"bxm\",\"bxn\",\"bxo\",\"bxp\",\"bxq\",\"bxr\",\"bxs\",\"bxu\",\"bxv\",\"bxw\",\"bxx\",\"bxz\",\"bya\",\"byb\",\"byc\",\"byd\",\"bye\",\"byf\",\"byg\",\"byh\",\"byi\",\"byj\",\"byk\",\"byl\",\"bym\",\"byn\",\"byo\",\"byp\",\"byq\",\"byr\",\"bys\",\"byt\",\"byv\",\"byw\",\"byx\",\"byy\",\"byz\",\"bza\",\"bzb\",\"bzc\",\"bzd\",\"bze\",\"bzf\",\"bzg\",\"bzh\",\"bzi\",\"bzj\",\"bzk\",\"bzl\",\"bzm\",\"bzn\",\"bzo\",\"bzp\",\"bzq\",\"bzr\",\"bzs\",\"bzt\",\"bzu\",\"bzv\",\"bzw\",\"bzx\",\"bzy\",\"bzz\",\"caa\",\"cab\",\"cac\",\"cad\",\"cae\",\"caf\",\"cag\",\"cah\",\"cai\",\"caj\",\"cak\",\"cal\",\"cam\",\"can\",\"cao\",\"cap\",\"caq\",\"car\",\"cas\",\"cau\",\"cav\",\"caw\",\"cax\",\"cay\",\"caz\",\"cba\",\"cbb\",\"cbc\",\"cbd\",\"cbe\",\"cbg\",\"cbh\",\"cbi\",\"cbj\",\"cbk\",\"cbl\",\"cbn\",\"cbo\",\"cbq\",\"cbr\",\"cbs\",\"cbt\",\"cbu\",\"cbv\",\"cbw\",\"cby\",\"cca\",\"ccc\",\"ccd\",\"cce\",\"ccg\",\"cch\",\"ccj\",\"ccl\",\"ccm\",\"ccn\",\"cco\",\"ccp\",\"ccq\",\"ccr\",\"ccs\",\"cda\",\"cdc\",\"cdd\",\"cde\",\"cdf\",\"cdg\",\"cdh\",\"cdi\",\"cdj\",\"cdm\",\"cdn\",\"cdo\",\"cdr\",\"cds\",\"cdy\",\"cdz\",\"cea\",\"ceb\",\"ceg\",\"cek\",\"cel\",\"cen\",\"cet\",\"cfa\",\"cfd\",\"cfg\",\"cfm\",\"cga\",\"cgc\",\"cgg\",\"cgk\",\"chb\",\"chc\",\"chd\",\"chf\",\"chg\",\"chh\",\"chj\",\"chk\",\"chl\",\"chm\",\"chn\",\"cho\",\"chp\",\"chq\",\"chr\",\"cht\",\"chw\",\"chx\",\"chy\",\"chz\",\"cia\",\"cib\",\"cic\",\"cid\",\"cie\",\"cih\",\"cik\",\"cim\",\"cin\",\"cip\",\"cir\",\"ciw\",\"ciy\",\"cja\",\"cje\",\"cjh\",\"cji\",\"cjk\",\"cjm\",\"cjn\",\"cjo\",\"cjp\",\"cjr\",\"cjs\",\"cjv\",\"cjy\",\"cka\",\"ckb\",\"ckh\",\"ckl\",\"ckn\",\"cko\",\"ckq\",\"ckr\",\"cks\",\"ckt\",\"cku\",\"ckv\",\"ckx\",\"cky\",\"ckz\",\"cla\",\"clc\",\"cld\",\"cle\",\"clh\",\"cli\",\"clj\",\"clk\",\"cll\",\"clm\",\"clo\",\"clt\",\"clu\",\"clw\",\"cly\",\"cma\",\"cmc\",\"cme\",\"cmg\",\"cmi\",\"cmk\",\"cml\",\"cmm\",\"cmn\",\"cmo\",\"cmr\",\"cms\",\"cmt\",\"cna\",\"cnb\",\"cnc\",\"cng\",\"cnh\",\"cni\",\"cnk\",\"cnl\",\"cno\",\"cns\",\"cnt\",\"cnu\",\"cnw\",\"cnx\",\"coa\",\"cob\",\"coc\",\"cod\",\"coe\",\"cof\",\"cog\",\"coh\",\"coj\",\"cok\",\"col\",\"com\",\"con\",\"coo\",\"cop\",\"coq\",\"cot\",\"cou\",\"cov\",\"cow\",\"cox\",\"coy\",\"coz\",\"cpa\",\"cpb\",\"cpc\",\"cpe\",\"cpf\",\"cpg\",\"cpi\",\"cpn\",\"cpo\",\"cpp\",\"cps\",\"cpu\",\"cpx\",\"cpy\",\"cqd\",\"cqu\",\"cra\",\"crb\",\"crc\",\"crd\",\"crf\",\"crg\",\"crh\",\"cri\",\"crj\",\"crk\",\"crl\",\"crm\",\"crn\",\"cro\",\"crp\",\"crq\",\"crr\",\"crs\",\"crt\",\"crv\",\"crw\",\"crx\",\"cry\",\"crz\",\"csa\",\"csb\",\"csc\",\"csd\",\"cse\",\"csf\",\"csg\",\"csh\",\"csi\",\"csj\",\"csk\",\"csl\",\"csm\",\"csn\",\"cso\",\"csq\",\"csr\",\"css\",\"cst\",\"csu\",\"csv\",\"csw\",\"csy\",\"csz\",\"cta\",\"ctc\",\"ctd\",\"cte\",\"ctg\",\"cth\",\"ctl\",\"ctm\",\"ctn\",\"cto\",\"ctp\",\"cts\",\"ctt\",\"ctu\",\"ctz\",\"cua\",\"cub\",\"cuc\",\"cug\",\"cuh\",\"cui\",\"cuj\",\"cuk\",\"cul\",\"cum\",\"cuo\",\"cup\",\"cuq\",\"cur\",\"cus\",\"cut\",\"cuu\",\"cuv\",\"cuw\",\"cux\",\"cvg\",\"cvn\",\"cwa\",\"cwb\",\"cwd\",\"cwe\",\"cwg\",\"cwt\",\"cya\",\"cyb\",\"cyo\",\"czh\",\"czk\",\"czn\",\"czo\",\"czt\",\"daa\",\"dac\",\"dad\",\"dae\",\"daf\",\"dag\",\"dah\",\"dai\",\"daj\",\"dak\",\"dal\",\"dam\",\"dao\",\"dap\",\"daq\",\"dar\",\"das\",\"dau\",\"dav\",\"daw\",\"dax\",\"day\",\"daz\",\"dba\",\"dbb\",\"dbd\",\"dbe\",\"dbf\",\"dbg\",\"dbi\",\"dbj\",\"dbl\",\"dbm\",\"dbn\",\"dbo\",\"dbp\",\"dbq\",\"dbr\",\"dbt\",\"dbu\",\"dbv\",\"dbw\",\"dby\",\"dcc\",\"dcr\",\"dda\",\"ddd\",\"dde\",\"ddg\",\"ddi\",\"ddj\",\"ddn\",\"ddo\",\"ddr\",\"dds\",\"ddw\",\"dec\",\"ded\",\"dee\",\"def\",\"deg\",\"deh\",\"dei\",\"dek\",\"del\",\"dem\",\"den\",\"dep\",\"deq\",\"der\",\"des\",\"dev\",\"dez\",\"dga\",\"dgb\",\"dgc\",\"dgd\",\"dge\",\"dgg\",\"dgh\",\"dgi\",\"dgk\",\"dgl\",\"dgn\",\"dgo\",\"dgr\",\"dgs\",\"dgt\",\"dgu\",\"dgw\",\"dgx\",\"dgz\",\"dha\",\"dhd\",\"dhg\",\"dhi\",\"dhl\",\"dhm\",\"dhn\",\"dho\",\"dhr\",\"dhs\",\"dhu\",\"dhv\",\"dhw\",\"dhx\",\"dia\",\"dib\",\"dic\",\"did\",\"dif\",\"dig\",\"dih\",\"dii\",\"dij\",\"dik\",\"dil\",\"dim\",\"din\",\"dio\",\"dip\",\"diq\",\"dir\",\"dis\",\"dit\",\"diu\",\"diw\",\"dix\",\"diy\",\"diz\",\"dja\",\"djb\",\"djc\",\"djd\",\"dje\",\"djf\",\"dji\",\"djj\",\"djk\",\"djl\",\"djm\",\"djn\",\"djo\",\"djr\",\"dju\",\"djw\",\"dka\",\"dkk\",\"dkl\",\"dkr\",\"dks\",\"dkx\",\"dlg\",\"dlk\",\"dlm\",\"dln\",\"dma\",\"dmb\",\"dmc\",\"dmd\",\"dme\",\"dmg\",\"dmk\",\"dml\",\"dmm\",\"dmn\",\"dmo\",\"dmr\",\"dms\",\"dmu\",\"dmv\",\"dmw\",\"dmx\",\"dmy\",\"dna\",\"dnd\",\"dne\",\"dng\",\"dni\",\"dnj\",\"dnk\",\"dnn\",\"dnr\",\"dnt\",\"dnu\",\"dnv\",\"dnw\",\"dny\",\"doa\",\"dob\",\"doc\",\"doe\",\"dof\",\"doh\",\"doi\",\"dok\",\"dol\",\"don\",\"doo\",\"dop\",\"doq\",\"dor\",\"dos\",\"dot\",\"dov\",\"dow\",\"dox\",\"doy\",\"doz\",\"dpp\",\"dra\",\"drb\",\"drc\",\"drd\",\"dre\",\"drg\",\"drh\",\"dri\",\"drl\",\"drn\",\"dro\",\"drq\",\"drr\",\"drs\",\"drt\",\"dru\",\"drw\",\"dry\",\"dsb\",\"dse\",\"dsh\",\"dsi\",\"dsl\",\"dsn\",\"dso\",\"dsq\",\"dta\",\"dtb\",\"dtd\",\"dth\",\"dti\",\"dtk\",\"dtm\",\"dtn\",\"dto\",\"dtp\",\"dtr\",\"dts\",\"dtt\",\"dtu\",\"dty\",\"dua\",\"dub\",\"duc\",\"dud\",\"due\",\"duf\",\"dug\",\"duh\",\"dui\",\"duj\",\"duk\",\"dul\",\"dum\",\"dun\",\"duo\",\"dup\",\"duq\",\"dur\",\"dus\",\"duu\",\"duv\",\"duw\",\"dux\",\"duy\",\"duz\",\"dva\",\"dwa\",\"dwl\",\"dwr\",\"dws\",\"dwu\",\"dww\",\"dwy\",\"dya\",\"dyb\",\"dyd\",\"dyg\",\"dyi\",\"dym\",\"dyn\",\"dyo\",\"dyu\",\"dyy\",\"dza\",\"dzd\",\"dze\",\"dzg\",\"dzl\",\"dzn\",\"eaa\",\"ebg\",\"ebk\",\"ebo\",\"ebr\",\"ebu\",\"ecr\",\"ecs\",\"ecy\",\"eee\",\"efa\",\"efe\",\"efi\",\"ega\",\"egl\",\"ego\",\"egx\",\"egy\",\"ehu\",\"eip\",\"eit\",\"eiv\",\"eja\",\"eka\",\"ekc\",\"eke\",\"ekg\",\"eki\",\"ekk\",\"ekl\",\"ekm\",\"eko\",\"ekp\",\"ekr\",\"eky\",\"ele\",\"elh\",\"eli\",\"elk\",\"elm\",\"elo\",\"elp\",\"elu\",\"elx\",\"ema\",\"emb\",\"eme\",\"emg\",\"emi\",\"emk\",\"emm\",\"emn\",\"emo\",\"emp\",\"ems\",\"emu\",\"emw\",\"emx\",\"emy\",\"ena\",\"enb\",\"enc\",\"end\",\"enf\",\"enh\",\"enl\",\"enm\",\"enn\",\"eno\",\"enq\",\"enr\",\"enu\",\"env\",\"enw\",\"enx\",\"eot\",\"epi\",\"era\",\"erg\",\"erh\",\"eri\",\"erk\",\"ero\",\"err\",\"ers\",\"ert\",\"erw\",\"ese\",\"esg\",\"esh\",\"esi\",\"esk\",\"esl\",\"esm\",\"esn\",\"eso\",\"esq\",\"ess\",\"esu\",\"esx\",\"esy\",\"etb\",\"etc\",\"eth\",\"etn\",\"eto\",\"etr\",\"ets\",\"ett\",\"etu\",\"etx\",\"etz\",\"euq\",\"eve\",\"evh\",\"evn\",\"ewo\",\"ext\",\"eya\",\"eyo\",\"eza\",\"eze\",\"faa\",\"fab\",\"fad\",\"faf\",\"fag\",\"fah\",\"fai\",\"faj\",\"fak\",\"fal\",\"fam\",\"fan\",\"fap\",\"far\",\"fat\",\"fau\",\"fax\",\"fay\",\"faz\",\"fbl\",\"fcs\",\"fer\",\"ffi\",\"ffm\",\"fgr\",\"fia\",\"fie\",\"fil\",\"fip\",\"fir\",\"fit\",\"fiu\",\"fiw\",\"fkk\",\"fkv\",\"fla\",\"flh\",\"fli\",\"fll\",\"fln\",\"flr\",\"fly\",\"fmp\",\"fmu\",\"fnb\",\"fng\",\"fni\",\"fod\",\"foi\",\"fom\",\"fon\",\"for\",\"fos\",\"fox\",\"fpe\",\"fqs\",\"frc\",\"frd\",\"frk\",\"frm\",\"fro\",\"frp\",\"frq\",\"frr\",\"frs\",\"frt\",\"fse\",\"fsl\",\"fss\",\"fub\",\"fuc\",\"fud\",\"fue\",\"fuf\",\"fuh\",\"fui\",\"fuj\",\"fum\",\"fun\",\"fuq\",\"fur\",\"fut\",\"fuu\",\"fuv\",\"fuy\",\"fvr\",\"fwa\",\"fwe\",\"gaa\",\"gab\",\"gac\",\"gad\",\"gae\",\"gaf\",\"gag\",\"gah\",\"gai\",\"gaj\",\"gak\",\"gal\",\"gam\",\"gan\",\"gao\",\"gap\",\"gaq\",\"gar\",\"gas\",\"gat\",\"gau\",\"gav\",\"gaw\",\"gax\",\"gay\",\"gaz\",\"gba\",\"gbb\",\"gbc\",\"gbd\",\"gbe\",\"gbf\",\"gbg\",\"gbh\",\"gbi\",\"gbj\",\"gbk\",\"gbl\",\"gbm\",\"gbn\",\"gbo\",\"gbp\",\"gbq\",\"gbr\",\"gbs\",\"gbu\",\"gbv\",\"gbw\",\"gbx\",\"gby\",\"gbz\",\"gcc\",\"gcd\",\"gce\",\"gcf\",\"gcl\",\"gcn\",\"gcr\",\"gct\",\"gda\",\"gdb\",\"gdc\",\"gdd\",\"gde\",\"gdf\",\"gdg\",\"gdh\",\"gdi\",\"gdj\",\"gdk\",\"gdl\",\"gdm\",\"gdn\",\"gdo\",\"gdq\",\"gdr\",\"gds\",\"gdt\",\"gdu\",\"gdx\",\"gea\",\"geb\",\"gec\",\"ged\",\"geg\",\"geh\",\"gei\",\"gej\",\"gek\",\"gel\",\"gem\",\"geq\",\"ges\",\"gev\",\"gew\",\"gex\",\"gey\",\"gez\",\"gfk\",\"gft\",\"gfx\",\"gga\",\"ggb\",\"ggd\",\"gge\",\"ggg\",\"ggk\",\"ggl\",\"ggn\",\"ggo\",\"ggr\",\"ggt\",\"ggu\",\"ggw\",\"gha\",\"ghc\",\"ghe\",\"ghh\",\"ghk\",\"ghl\",\"ghn\",\"gho\",\"ghr\",\"ghs\",\"ght\",\"gia\",\"gib\",\"gic\",\"gid\",\"gie\",\"gig\",\"gih\",\"gil\",\"gim\",\"gin\",\"gio\",\"gip\",\"giq\",\"gir\",\"gis\",\"git\",\"giu\",\"giw\",\"gix\",\"giy\",\"giz\",\"gji\",\"gjk\",\"gjm\",\"gjn\",\"gjr\",\"gju\",\"gka\",\"gke\",\"gkn\",\"gko\",\"gkp\",\"gku\",\"glc\",\"gld\",\"glh\",\"gli\",\"glj\",\"glk\",\"gll\",\"glo\",\"glr\",\"glu\",\"glw\",\"gly\",\"gma\",\"gmb\",\"gmd\",\"gme\",\"gmg\",\"gmh\",\"gml\",\"gmm\",\"gmn\",\"gmq\",\"gmu\",\"gmv\",\"gmw\",\"gmx\",\"gmy\",\"gmz\",\"gna\",\"gnb\",\"gnc\",\"gnd\",\"gne\",\"gng\",\"gnh\",\"gni\",\"gnk\",\"gnl\",\"gnm\",\"gnn\",\"gno\",\"gnq\",\"gnr\",\"gnt\",\"gnu\",\"gnw\",\"gnz\",\"goa\",\"gob\",\"goc\",\"god\",\"goe\",\"gof\",\"gog\",\"goh\",\"goi\",\"goj\",\"gok\",\"gol\",\"gom\",\"gon\",\"goo\",\"gop\",\"goq\",\"gor\",\"gos\",\"got\",\"gou\",\"gow\",\"gox\",\"goy\",\"goz\",\"gpa\",\"gpe\",\"gpn\",\"gqa\",\"gqi\",\"gqn\",\"gqr\",\"gqu\",\"gra\",\"grb\",\"grc\",\"grd\",\"grg\",\"grh\",\"gri\",\"grj\",\"grk\",\"grm\",\"gro\",\"grq\",\"grr\",\"grs\",\"grt\",\"gru\",\"grv\",\"grw\",\"grx\",\"gry\",\"grz\",\"gse\",\"gsg\",\"gsl\",\"gsm\",\"gsn\",\"gso\",\"gsp\",\"gss\",\"gsw\",\"gta\",\"gti\",\"gtu\",\"gua\",\"gub\",\"guc\",\"gud\",\"gue\",\"guf\",\"gug\",\"guh\",\"gui\",\"guk\",\"gul\",\"gum\",\"gun\",\"guo\",\"gup\",\"guq\",\"gur\",\"gus\",\"gut\",\"guu\",\"guv\",\"guw\",\"gux\",\"guz\",\"gva\",\"gvc\",\"gve\",\"gvf\",\"gvj\",\"gvl\",\"gvm\",\"gvn\",\"gvo\",\"gvp\",\"gvr\",\"gvs\",\"gvy\",\"gwa\",\"gwb\",\"gwc\",\"gwd\",\"gwe\",\"gwf\",\"gwg\",\"gwi\",\"gwj\",\"gwm\",\"gwn\",\"gwr\",\"gwt\",\"gwu\",\"gww\",\"gwx\",\"gxx\",\"gya\",\"gyb\",\"gyd\",\"gye\",\"gyf\",\"gyg\",\"gyi\",\"gyl\",\"gym\",\"gyn\",\"gyr\",\"gyy\",\"gza\",\"gzi\",\"gzn\",\"haa\",\"hab\",\"hac\",\"had\",\"hae\",\"haf\",\"hag\",\"hah\",\"hai\",\"haj\",\"hak\",\"hal\",\"ham\",\"han\",\"hao\",\"hap\",\"haq\",\"har\",\"has\",\"hav\",\"haw\",\"hax\",\"hay\",\"haz\",\"hba\",\"hbb\",\"hbn\",\"hbo\",\"hbu\",\"hca\",\"hch\",\"hdn\",\"hds\",\"hdy\",\"hea\",\"hed\",\"heg\",\"heh\",\"hei\",\"hem\",\"hgm\",\"hgw\",\"hhi\",\"hhr\",\"hhy\",\"hia\",\"hib\",\"hid\",\"hif\",\"hig\",\"hih\",\"hii\",\"hij\",\"hik\",\"hil\",\"him\",\"hio\",\"hir\",\"hit\",\"hiw\",\"hix\",\"hji\",\"hka\",\"hke\",\"hkk\",\"hks\",\"hla\",\"hlb\",\"hld\",\"hle\",\"hlt\",\"hlu\",\"hma\",\"hmb\",\"hmc\",\"hmd\",\"hme\",\"hmf\",\"hmg\",\"hmh\",\"hmi\",\"hmj\",\"hmk\",\"hml\",\"hmm\",\"hmn\",\"hmp\",\"hmq\",\"hmr\",\"hms\",\"hmt\",\"hmu\",\"hmv\",\"hmw\",\"hmx\",\"hmy\",\"hmz\",\"hna\",\"hnd\",\"hne\",\"hnh\",\"hni\",\"hnj\",\"hnn\",\"hno\",\"hns\",\"hnu\",\"hoa\",\"hob\",\"hoc\",\"hod\",\"hoe\",\"hoh\",\"hoi\",\"hoj\",\"hok\",\"hol\",\"hom\",\"hoo\",\"hop\",\"hor\",\"hos\",\"hot\",\"hov\",\"how\",\"hoy\",\"hoz\",\"hpo\",\"hps\",\"hra\",\"hrc\",\"hre\",\"hrk\",\"hrm\",\"hro\",\"hrp\",\"hrr\",\"hrt\",\"hru\",\"hrw\",\"hrx\",\"hrz\",\"hsb\",\"hsh\",\"hsl\",\"hsn\",\"hss\",\"hti\",\"hto\",\"hts\",\"htu\",\"htx\",\"hub\",\"huc\",\"hud\",\"hue\",\"huf\",\"hug\",\"huh\",\"hui\",\"huj\",\"huk\",\"hul\",\"hum\",\"huo\",\"hup\",\"huq\",\"hur\",\"hus\",\"hut\",\"huu\",\"huv\",\"huw\",\"hux\",\"huy\",\"huz\",\"hvc\",\"hve\",\"hvk\",\"hvn\",\"hvv\",\"hwa\",\"hwc\",\"hwo\",\"hya\",\"hyx\",\"iai\",\"ian\",\"iap\",\"iar\",\"iba\",\"ibb\",\"ibd\",\"ibe\",\"ibg\",\"ibh\",\"ibi\",\"ibl\",\"ibm\",\"ibn\",\"ibr\",\"ibu\",\"iby\",\"ica\",\"ich\",\"icl\",\"icr\",\"ida\",\"idb\",\"idc\",\"idd\",\"ide\",\"idi\",\"idr\",\"ids\",\"idt\",\"idu\",\"ifa\",\"ifb\",\"ife\",\"iff\",\"ifk\",\"ifm\",\"ifu\",\"ify\",\"igb\",\"ige\",\"igg\",\"igl\",\"igm\",\"ign\",\"igo\",\"igs\",\"igw\",\"ihb\",\"ihi\",\"ihp\",\"ihw\",\"iin\",\"iir\",\"ijc\",\"ije\",\"ijj\",\"ijn\",\"ijo\",\"ijs\",\"ike\",\"iki\",\"ikk\",\"ikl\",\"iko\",\"ikp\",\"ikr\",\"iks\",\"ikt\",\"ikv\",\"ikw\",\"ikx\",\"ikz\",\"ila\",\"ilb\",\"ilg\",\"ili\",\"ilk\",\"ill\",\"ilm\",\"ilo\",\"ilp\",\"ils\",\"ilu\",\"ilv\",\"ilw\",\"ima\",\"ime\",\"imi\",\"iml\",\"imn\",\"imo\",\"imr\",\"ims\",\"imy\",\"inb\",\"inc\",\"ine\",\"ing\",\"inh\",\"inj\",\"inl\",\"inm\",\"inn\",\"ino\",\"inp\",\"ins\",\"int\",\"inz\",\"ior\",\"iou\",\"iow\",\"ipi\",\"ipo\",\"iqu\",\"iqw\",\"ira\",\"ire\",\"irh\",\"iri\",\"irk\",\"irn\",\"iro\",\"irr\",\"iru\",\"irx\",\"iry\",\"isa\",\"isc\",\"isd\",\"ise\",\"isg\",\"ish\",\"isi\",\"isk\",\"ism\",\"isn\",\"iso\",\"isr\",\"ist\",\"isu\",\"itb\",\"itc\",\"itd\",\"ite\",\"iti\",\"itk\",\"itl\",\"itm\",\"ito\",\"itr\",\"its\",\"itt\",\"itv\",\"itw\",\"itx\",\"ity\",\"itz\",\"ium\",\"ivb\",\"ivv\",\"iwk\",\"iwm\",\"iwo\",\"iws\",\"ixc\",\"ixl\",\"iya\",\"iyo\",\"iyx\",\"izh\",\"izi\",\"izr\",\"izz\",\"jaa\",\"jab\",\"jac\",\"jad\",\"jae\",\"jaf\",\"jah\",\"jaj\",\"jak\",\"jal\",\"jam\",\"jan\",\"jao\",\"jaq\",\"jar\",\"jas\",\"jat\",\"jau\",\"jax\",\"jay\",\"jaz\",\"jbe\",\"jbi\",\"jbj\",\"jbk\",\"jbn\",\"jbo\",\"jbr\",\"jbt\",\"jbu\",\"jbw\",\"jcs\",\"jct\",\"jda\",\"jdg\",\"jdt\",\"jeb\",\"jee\",\"jeg\",\"jeh\",\"jei\",\"jek\",\"jel\",\"jen\",\"jer\",\"jet\",\"jeu\",\"jgb\",\"jge\",\"jgk\",\"jgo\",\"jhi\",\"jhs\",\"jia\",\"jib\",\"jic\",\"jid\",\"jie\",\"jig\",\"jih\",\"jii\",\"jil\",\"jim\",\"jio\",\"jiq\",\"jit\",\"jiu\",\"jiv\",\"jiy\",\"jje\",\"jjr\",\"jka\",\"jkm\",\"jko\",\"jkp\",\"jkr\",\"jku\",\"jle\",\"jls\",\"jma\",\"jmb\",\"jmc\",\"jmd\",\"jmi\",\"jml\",\"jmn\",\"jmr\",\"jms\",\"jmw\",\"jmx\",\"jna\",\"jnd\",\"jng\",\"jni\",\"jnj\",\"jnl\",\"jns\",\"job\",\"jod\",\"jog\",\"jor\",\"jos\",\"jow\",\"jpa\",\"jpr\",\"jpx\",\"jqr\",\"jra\",\"jrb\",\"jrr\",\"jrt\",\"jru\",\"jsl\",\"jua\",\"jub\",\"juc\",\"jud\",\"juh\",\"jui\",\"juk\",\"jul\",\"jum\",\"jun\",\"juo\",\"jup\",\"jur\",\"jus\",\"jut\",\"juu\",\"juw\",\"juy\",\"jvd\",\"jvn\",\"jwi\",\"jya\",\"jye\",\"jyy\",\"kaa\",\"kab\",\"kac\",\"kad\",\"kae\",\"kaf\",\"kag\",\"kah\",\"kai\",\"kaj\",\"kak\",\"kam\",\"kao\",\"kap\",\"kaq\",\"kar\",\"kav\",\"kaw\",\"kax\",\"kay\",\"kba\",\"kbb\",\"kbc\",\"kbd\",\"kbe\",\"kbf\",\"kbg\",\"kbh\",\"kbi\",\"kbj\",\"kbk\",\"kbl\",\"kbm\",\"kbn\",\"kbo\",\"kbp\",\"kbq\",\"kbr\",\"kbs\",\"kbt\",\"kbu\",\"kbv\",\"kbw\",\"kbx\",\"kby\",\"kbz\",\"kca\",\"kcb\",\"kcc\",\"kcd\",\"kce\",\"kcf\",\"kcg\",\"kch\",\"kci\",\"kcj\",\"kck\",\"kcl\",\"kcm\",\"kcn\",\"kco\",\"kcp\",\"kcq\",\"kcr\",\"kcs\",\"kct\",\"kcu\",\"kcv\",\"kcw\",\"kcx\",\"kcy\",\"kcz\",\"kda\",\"kdc\",\"kdd\",\"kde\",\"kdf\",\"kdg\",\"kdh\",\"kdi\",\"kdj\",\"kdk\",\"kdl\",\"kdm\",\"kdn\",\"kdo\",\"kdp\",\"kdq\",\"kdr\",\"kdt\",\"kdu\",\"kdv\",\"kdw\",\"kdx\",\"kdy\",\"kdz\",\"kea\",\"keb\",\"kec\",\"ked\",\"kee\",\"kef\",\"keg\",\"keh\",\"kei\",\"kej\",\"kek\",\"kel\",\"kem\",\"ken\",\"keo\",\"kep\",\"keq\",\"ker\",\"kes\",\"ket\",\"keu\",\"kev\",\"kew\",\"kex\",\"key\",\"kez\",\"kfa\",\"kfb\",\"kfc\",\"kfd\",\"kfe\",\"kff\",\"kfg\",\"kfh\",\"kfi\",\"kfj\",\"kfk\",\"kfl\",\"kfm\",\"kfn\",\"kfo\",\"kfp\",\"kfq\",\"kfr\",\"kfs\",\"kft\",\"kfu\",\"kfv\",\"kfw\",\"kfx\",\"kfy\",\"kfz\",\"kga\",\"kgb\",\"kgc\",\"kgd\",\"kge\",\"kgf\",\"kgg\",\"kgh\",\"kgi\",\"kgj\",\"kgk\",\"kgl\",\"kgm\",\"kgn\",\"kgo\",\"kgp\",\"kgq\",\"kgr\",\"kgs\",\"kgt\",\"kgu\",\"kgv\",\"kgw\",\"kgx\",\"kgy\",\"kha\",\"khb\",\"khc\",\"khd\",\"khe\",\"khf\",\"khg\",\"khh\",\"khi\",\"khj\",\"khk\",\"khl\",\"khn\",\"kho\",\"khp\",\"khq\",\"khr\",\"khs\",\"kht\",\"khu\",\"khv\",\"khw\",\"khx\",\"khy\",\"khz\",\"kia\",\"kib\",\"kic\",\"kid\",\"kie\",\"kif\",\"kig\",\"kih\",\"kii\",\"kij\",\"kil\",\"kim\",\"kio\",\"kip\",\"kiq\",\"kis\",\"kit\",\"kiu\",\"kiv\",\"kiw\",\"kix\",\"kiy\",\"kiz\",\"kja\",\"kjb\",\"kjc\",\"kjd\",\"kje\",\"kjf\",\"kjg\",\"kjh\",\"kji\",\"kjj\",\"kjk\",\"kjl\",\"kjm\",\"kjn\",\"kjo\",\"kjp\",\"kjq\",\"kjr\",\"kjs\",\"kjt\",\"kju\",\"kjv\",\"kjx\",\"kjy\",\"kjz\",\"kka\",\"kkb\",\"kkc\",\"kkd\",\"kke\",\"kkf\",\"kkg\",\"kkh\",\"kki\",\"kkj\",\"kkk\",\"kkl\",\"kkm\",\"kkn\",\"kko\",\"kkp\",\"kkq\",\"kkr\",\"kks\",\"kkt\",\"kku\",\"kkv\",\"kkw\",\"kkx\",\"kky\",\"kkz\",\"kla\",\"klb\",\"klc\",\"kld\",\"kle\",\"klf\",\"klg\",\"klh\",\"kli\",\"klj\",\"klk\",\"kll\",\"klm\",\"kln\",\"klo\",\"klp\",\"klq\",\"klr\",\"kls\",\"klt\",\"klu\",\"klv\",\"klw\",\"klx\",\"kly\",\"klz\",\"kma\",\"kmb\",\"kmc\",\"kmd\",\"kme\",\"kmf\",\"kmg\",\"kmh\",\"kmi\",\"kmj\",\"kmk\",\"kml\",\"kmm\",\"kmn\",\"kmo\",\"kmp\",\"kmq\",\"kmr\",\"kms\",\"kmt\",\"kmu\",\"kmv\",\"kmw\",\"kmx\",\"kmy\",\"kmz\",\"kna\",\"knb\",\"knc\",\"knd\",\"kne\",\"knf\",\"kng\",\"kni\",\"knj\",\"knk\",\"knl\",\"knm\",\"knn\",\"kno\",\"knp\",\"knq\",\"knr\",\"kns\",\"knt\",\"knu\",\"knv\",\"knw\",\"knx\",\"kny\",\"knz\",\"koa\",\"koc\",\"kod\",\"koe\",\"kof\",\"kog\",\"koh\",\"koi\",\"koj\",\"kok\",\"kol\",\"koo\",\"kop\",\"koq\",\"kos\",\"kot\",\"kou\",\"kov\",\"kow\",\"kox\",\"koy\",\"koz\",\"kpa\",\"kpb\",\"kpc\",\"kpd\",\"kpe\",\"kpf\",\"kpg\",\"kph\",\"kpi\",\"kpj\",\"kpk\",\"kpl\",\"kpm\",\"kpn\",\"kpo\",\"kpp\",\"kpq\",\"kpr\",\"kps\",\"kpt\",\"kpu\",\"kpv\",\"kpw\",\"kpx\",\"kpy\",\"kpz\",\"kqa\",\"kqb\",\"kqc\",\"kqd\",\"kqe\",\"kqf\",\"kqg\",\"kqh\",\"kqi\",\"kqj\",\"kqk\",\"kql\",\"kqm\",\"kqn\",\"kqo\",\"kqp\",\"kqq\",\"kqr\",\"kqs\",\"kqt\",\"kqu\",\"kqv\",\"kqw\",\"kqx\",\"kqy\",\"kqz\",\"kra\",\"krb\",\"krc\",\"krd\",\"kre\",\"krf\",\"krh\",\"kri\",\"krj\",\"krk\",\"krl\",\"krm\",\"krn\",\"kro\",\"krp\",\"krr\",\"krs\",\"krt\",\"kru\",\"krv\",\"krw\",\"krx\",\"kry\",\"krz\",\"ksa\",\"ksb\",\"ksc\",\"ksd\",\"kse\",\"ksf\",\"ksg\",\"ksh\",\"ksi\",\"ksj\",\"ksk\",\"ksl\",\"ksm\",\"ksn\",\"kso\",\"ksp\",\"ksq\",\"ksr\",\"kss\",\"kst\",\"ksu\",\"ksv\",\"ksw\",\"ksx\",\"ksy\",\"ksz\",\"kta\",\"ktb\",\"ktc\",\"ktd\",\"kte\",\"ktf\",\"ktg\",\"kth\",\"kti\",\"ktj\",\"ktk\",\"ktl\",\"ktm\",\"ktn\",\"kto\",\"ktp\",\"ktq\",\"ktr\",\"kts\",\"ktt\",\"ktu\",\"ktv\",\"ktw\",\"ktx\",\"kty\",\"ktz\",\"kub\",\"kuc\",\"kud\",\"kue\",\"kuf\",\"kug\",\"kuh\",\"kui\",\"kuj\",\"kuk\",\"kul\",\"kum\",\"kun\",\"kuo\",\"kup\",\"kuq\",\"kus\",\"kut\",\"kuu\",\"kuv\",\"kuw\",\"kux\",\"kuy\",\"kuz\",\"kva\",\"kvb\",\"kvc\",\"kvd\",\"kve\",\"kvf\",\"kvg\",\"kvh\",\"kvi\",\"kvj\",\"kvk\",\"kvl\",\"kvm\",\"kvn\",\"kvo\",\"kvp\",\"kvq\",\"kvr\",\"kvs\",\"kvt\",\"kvu\",\"kvv\",\"kvw\",\"kvx\",\"kvy\",\"kvz\",\"kwa\",\"kwb\",\"kwc\",\"kwd\",\"kwe\",\"kwf\",\"kwg\",\"kwh\",\"kwi\",\"kwj\",\"kwk\",\"kwl\",\"kwm\",\"kwn\",\"kwo\",\"kwp\",\"kwq\",\"kwr\",\"kws\",\"kwt\",\"kwu\",\"kwv\",\"kww\",\"kwx\",\"kwy\",\"kwz\",\"kxa\",\"kxb\",\"kxc\",\"kxd\",\"kxe\",\"kxf\",\"kxh\",\"kxi\",\"kxj\",\"kxk\",\"kxl\",\"kxm\",\"kxn\",\"kxo\",\"kxp\",\"kxq\",\"kxr\",\"kxs\",\"kxt\",\"kxu\",\"kxv\",\"kxw\",\"kxx\",\"kxy\",\"kxz\",\"kya\",\"kyb\",\"kyc\",\"kyd\",\"kye\",\"kyf\",\"kyg\",\"kyh\",\"kyi\",\"kyj\",\"kyk\",\"kyl\",\"kym\",\"kyn\",\"kyo\",\"kyp\",\"kyq\",\"kyr\",\"kys\",\"kyt\",\"kyu\",\"kyv\",\"kyw\",\"kyx\",\"kyy\",\"kyz\",\"kza\",\"kzb\",\"kzc\",\"kzd\",\"kze\",\"kzf\",\"kzg\",\"kzh\",\"kzi\",\"kzj\",\"kzk\",\"kzl\",\"kzm\",\"kzn\",\"kzo\",\"kzp\",\"kzq\",\"kzr\",\"kzs\",\"kzt\",\"kzu\",\"kzv\",\"kzw\",\"kzx\",\"kzy\",\"kzz\",\"laa\",\"lab\",\"lac\",\"lad\",\"lae\",\"laf\",\"lag\",\"lah\",\"lai\",\"laj\",\"lak\",\"lal\",\"lam\",\"lan\",\"lap\",\"laq\",\"lar\",\"las\",\"lau\",\"law\",\"lax\",\"lay\",\"laz\",\"lba\",\"lbb\",\"lbc\",\"lbe\",\"lbf\",\"lbg\",\"lbi\",\"lbj\",\"lbk\",\"lbl\",\"lbm\",\"lbn\",\"lbo\",\"lbq\",\"lbr\",\"lbs\",\"lbt\",\"lbu\",\"lbv\",\"lbw\",\"lbx\",\"lby\",\"lbz\",\"lcc\",\"lcd\",\"lce\",\"lcf\",\"lch\",\"lcl\",\"lcm\",\"lcp\",\"lcq\",\"lcs\",\"lda\",\"ldb\",\"ldd\",\"ldg\",\"ldh\",\"ldi\",\"ldj\",\"ldk\",\"ldl\",\"ldm\",\"ldn\",\"ldo\",\"ldp\",\"ldq\",\"lea\",\"leb\",\"lec\",\"led\",\"lee\",\"lef\",\"leg\",\"leh\",\"lei\",\"lej\",\"lek\",\"lel\",\"lem\",\"len\",\"leo\",\"lep\",\"leq\",\"ler\",\"les\",\"let\",\"leu\",\"lev\",\"lew\",\"lex\",\"ley\",\"lez\",\"lfa\",\"lfn\",\"lga\",\"lgb\",\"lgg\",\"lgh\",\"lgi\",\"lgk\",\"lgl\",\"lgm\",\"lgn\",\"lgq\",\"lgr\",\"lgt\",\"lgu\",\"lgz\",\"lha\",\"lhh\",\"lhi\",\"lhl\",\"lhm\",\"lhn\",\"lhp\",\"lhs\",\"lht\",\"lhu\",\"lia\",\"lib\",\"lic\",\"lid\",\"lie\",\"lif\",\"lig\",\"lih\",\"lii\",\"lij\",\"lik\",\"lil\",\"lio\",\"lip\",\"liq\",\"lir\",\"lis\",\"liu\",\"liv\",\"liw\",\"lix\",\"liy\",\"liz\",\"lja\",\"lje\",\"lji\",\"ljl\",\"ljp\",\"ljw\",\"ljx\",\"lka\",\"lkb\",\"lkc\",\"lkd\",\"lke\",\"lkh\",\"lki\",\"lkj\",\"lkl\",\"lkm\",\"lkn\",\"lko\",\"lkr\",\"lks\",\"lkt\",\"lku\",\"lky\",\"lla\",\"llb\",\"llc\",\"lld\",\"lle\",\"llf\",\"llg\",\"llh\",\"lli\",\"llj\",\"llk\",\"lll\",\"llm\",\"lln\",\"llo\",\"llp\",\"llq\",\"lls\",\"llu\",\"llx\",\"lma\",\"lmb\",\"lmc\",\"lmd\",\"lme\",\"lmf\",\"lmg\",\"lmh\",\"lmi\",\"lmj\",\"lmk\",\"lml\",\"lmm\",\"lmn\",\"lmo\",\"lmp\",\"lmq\",\"lmr\",\"lmu\",\"lmv\",\"lmw\",\"lmx\",\"lmy\",\"lmz\",\"lna\",\"lnb\",\"lnd\",\"lng\",\"lnh\",\"lni\",\"lnj\",\"lnl\",\"lnm\",\"lnn\",\"lno\",\"lns\",\"lnu\",\"lnw\",\"lnz\",\"loa\",\"lob\",\"loc\",\"loe\",\"lof\",\"log\",\"loh\",\"loi\",\"loj\",\"lok\",\"lol\",\"lom\",\"lon\",\"loo\",\"lop\",\"loq\",\"lor\",\"los\",\"lot\",\"lou\",\"lov\",\"low\",\"lox\",\"loy\",\"loz\",\"lpa\",\"lpe\",\"lpn\",\"lpo\",\"lpx\",\"lra\",\"lrc\",\"lre\",\"lrg\",\"lri\",\"lrk\",\"lrl\",\"lrm\",\"lrn\",\"lro\",\"lrr\",\"lrt\",\"lrv\",\"lrz\",\"lsa\",\"lsd\",\"lse\",\"lsg\",\"lsh\",\"lsi\",\"lsl\",\"lsm\",\"lso\",\"lsp\",\"lsr\",\"lss\",\"lst\",\"lsy\",\"ltc\",\"ltg\",\"lth\",\"lti\",\"ltn\",\"lto\",\"lts\",\"ltu\",\"lua\",\"luc\",\"lud\",\"lue\",\"luf\",\"lui\",\"luj\",\"luk\",\"lul\",\"lum\",\"lun\",\"luo\",\"lup\",\"luq\",\"lur\",\"lus\",\"lut\",\"luu\",\"luv\",\"luw\",\"luy\",\"luz\",\"lva\",\"lvk\",\"lvs\",\"lvu\",\"lwa\",\"lwe\",\"lwg\",\"lwh\",\"lwl\",\"lwm\",\"lwo\",\"lwt\",\"lwu\",\"lww\",\"lya\",\"lyg\",\"lyn\",\"lzh\",\"lzl\",\"lzn\",\"lzz\",\"maa\",\"mab\",\"mad\",\"mae\",\"maf\",\"mag\",\"mai\",\"maj\",\"mak\",\"mam\",\"man\",\"map\",\"maq\",\"mas\",\"mat\",\"mau\",\"mav\",\"maw\",\"max\",\"maz\",\"mba\",\"mbb\",\"mbc\",\"mbd\",\"mbe\",\"mbf\",\"mbh\",\"mbi\",\"mbj\",\"mbk\",\"mbl\",\"mbm\",\"mbn\",\"mbo\",\"mbp\",\"mbq\",\"mbr\",\"mbs\",\"mbt\",\"mbu\",\"mbv\",\"mbw\",\"mbx\",\"mby\",\"mbz\",\"mca\",\"mcb\",\"mcc\",\"mcd\",\"mce\",\"mcf\",\"mcg\",\"mch\",\"mci\",\"mcj\",\"mck\",\"mcl\",\"mcm\",\"mcn\",\"mco\",\"mcp\",\"mcq\",\"mcr\",\"mcs\",\"mct\",\"mcu\",\"mcv\",\"mcw\",\"mcx\",\"mcy\",\"mcz\",\"mda\",\"mdb\",\"mdc\",\"mdd\",\"mde\",\"mdf\",\"mdg\",\"mdh\",\"mdi\",\"mdj\",\"mdk\",\"mdl\",\"mdm\",\"mdn\",\"mdp\",\"mdq\",\"mdr\",\"mds\",\"mdt\",\"mdu\",\"mdv\",\"mdw\",\"mdx\",\"mdy\",\"mdz\",\"mea\",\"meb\",\"mec\",\"med\",\"mee\",\"mef\",\"meg\",\"meh\",\"mei\",\"mej\",\"mek\",\"mel\",\"mem\",\"men\",\"meo\",\"mep\",\"meq\",\"mer\",\"mes\",\"met\",\"meu\",\"mev\",\"mew\",\"mey\",\"mez\",\"mfa\",\"mfb\",\"mfc\",\"mfd\",\"mfe\",\"mff\",\"mfg\",\"mfh\",\"mfi\",\"mfj\",\"mfk\",\"mfl\",\"mfm\",\"mfn\",\"mfo\",\"mfp\",\"mfq\",\"mfr\",\"mfs\",\"mft\",\"mfu\",\"mfv\",\"mfw\",\"mfx\",\"mfy\",\"mfz\",\"mga\",\"mgb\",\"mgc\",\"mgd\",\"mge\",\"mgf\",\"mgg\",\"mgh\",\"mgi\",\"mgj\",\"mgk\",\"mgl\",\"mgm\",\"mgn\",\"mgo\",\"mgp\",\"mgq\",\"mgr\",\"mgs\",\"mgt\",\"mgu\",\"mgv\",\"mgw\",\"mgx\",\"mgy\",\"mgz\",\"mha\",\"mhb\",\"mhc\",\"mhd\",\"mhe\",\"mhf\",\"mhg\",\"mhh\",\"mhi\",\"mhj\",\"mhk\",\"mhl\",\"mhm\",\"mhn\",\"mho\",\"mhp\",\"mhq\",\"mhr\",\"mhs\",\"mht\",\"mhu\",\"mhw\",\"mhx\",\"mhy\",\"mhz\",\"mia\",\"mib\",\"mic\",\"mid\",\"mie\",\"mif\",\"mig\",\"mih\",\"mii\",\"mij\",\"mik\",\"mil\",\"mim\",\"min\",\"mio\",\"mip\",\"miq\",\"mir\",\"mis\",\"mit\",\"miu\",\"miw\",\"mix\",\"miy\",\"miz\",\"mja\",\"mjb\",\"mjc\",\"mjd\",\"mje\",\"mjg\",\"mjh\",\"mji\",\"mjj\",\"mjk\",\"mjl\",\"mjm\",\"mjn\",\"mjo\",\"mjp\",\"mjq\",\"mjr\",\"mjs\",\"mjt\",\"mju\",\"mjv\",\"mjw\",\"mjx\",\"mjy\",\"mjz\",\"mka\",\"mkb\",\"mkc\",\"mke\",\"mkf\",\"mkg\",\"mkh\",\"mki\",\"mkj\",\"mkk\",\"mkl\",\"mkm\",\"mkn\",\"mko\",\"mkp\",\"mkq\",\"mkr\",\"mks\",\"mkt\",\"mku\",\"mkv\",\"mkw\",\"mkx\",\"mky\",\"mkz\",\"mla\",\"mlb\",\"mlc\",\"mld\",\"mle\",\"mlf\",\"mlh\",\"mli\",\"mlj\",\"mlk\",\"mll\",\"mlm\",\"mln\",\"mlo\",\"mlp\",\"mlq\",\"mlr\",\"mls\",\"mlu\",\"mlv\",\"mlw\",\"mlx\",\"mlz\",\"mma\",\"mmb\",\"mmc\",\"mmd\",\"mme\",\"mmf\",\"mmg\",\"mmh\",\"mmi\",\"mmj\",\"mmk\",\"mml\",\"mmm\",\"mmn\",\"mmo\",\"mmp\",\"mmq\",\"mmr\",\"mmt\",\"mmu\",\"mmv\",\"mmw\",\"mmx\",\"mmy\",\"mmz\",\"mna\",\"mnb\",\"mnc\",\"mnd\",\"mne\",\"mnf\",\"mng\",\"mnh\",\"mni\",\"mnj\",\"mnk\",\"mnl\",\"mnm\",\"mnn\",\"mno\",\"mnp\",\"mnq\",\"mnr\",\"mns\",\"mnt\",\"mnu\",\"mnv\",\"mnw\",\"mnx\",\"mny\",\"mnz\",\"moa\",\"moc\",\"mod\",\"moe\",\"mof\",\"mog\",\"moh\",\"moi\",\"moj\",\"mok\",\"mom\",\"moo\",\"mop\",\"moq\",\"mor\",\"mos\",\"mot\",\"mou\",\"mov\",\"mow\",\"mox\",\"moy\",\"moz\",\"mpa\",\"mpb\",\"mpc\",\"mpd\",\"mpe\",\"mpg\",\"mph\",\"mpi\",\"mpj\",\"mpk\",\"mpl\",\"mpm\",\"mpn\",\"mpo\",\"mpp\",\"mpq\",\"mpr\",\"mps\",\"mpt\",\"mpu\",\"mpv\",\"mpw\",\"mpx\",\"mpy\",\"mpz\",\"mqa\",\"mqb\",\"mqc\",\"mqe\",\"mqf\",\"mqg\",\"mqh\",\"mqi\",\"mqj\",\"mqk\",\"mql\",\"mqm\",\"mqn\",\"mqo\",\"mqp\",\"mqq\",\"mqr\",\"mqs\",\"mqt\",\"mqu\",\"mqv\",\"mqw\",\"mqx\",\"mqy\",\"mqz\",\"mra\",\"mrb\",\"mrc\",\"mrd\",\"mre\",\"mrf\",\"mrg\",\"mrh\",\"mrj\",\"mrk\",\"mrl\",\"mrm\",\"mrn\",\"mro\",\"mrp\",\"mrq\",\"mrr\",\"mrs\",\"mrt\",\"mru\",\"mrv\",\"mrw\",\"mrx\",\"mry\",\"mrz\",\"msb\",\"msc\",\"msd\",\"mse\",\"msf\",\"msg\",\"msh\",\"msi\",\"msj\",\"msk\",\"msl\",\"msm\",\"msn\",\"mso\",\"msp\",\"msq\",\"msr\",\"mss\",\"mst\",\"msu\",\"msv\",\"msw\",\"msx\",\"msy\",\"msz\",\"mta\",\"mtb\",\"mtc\",\"mtd\",\"mte\",\"mtf\",\"mtg\",\"mth\",\"mti\",\"mtj\",\"mtk\",\"mtl\",\"mtm\",\"mtn\",\"mto\",\"mtp\",\"mtq\",\"mtr\",\"mts\",\"mtt\",\"mtu\",\"mtv\",\"mtw\",\"mtx\",\"mty\",\"mua\",\"mub\",\"muc\",\"mud\",\"mue\",\"mug\",\"muh\",\"mui\",\"muj\",\"muk\",\"mul\",\"mum\",\"mun\",\"muo\",\"mup\",\"muq\",\"mur\",\"mus\",\"mut\",\"muu\",\"muv\",\"mux\",\"muy\",\"muz\",\"mva\",\"mvb\",\"mvd\",\"mve\",\"mvf\",\"mvg\",\"mvh\",\"mvi\",\"mvk\",\"mvl\",\"mvm\",\"mvn\",\"mvo\",\"mvp\",\"mvq\",\"mvr\",\"mvs\",\"mvt\",\"mvu\",\"mvv\",\"mvw\",\"mvx\",\"mvy\",\"mvz\",\"mwa\",\"mwb\",\"mwc\",\"mwd\",\"mwe\",\"mwf\",\"mwg\",\"mwh\",\"mwi\",\"mwj\",\"mwk\",\"mwl\",\"mwm\",\"mwn\",\"mwo\",\"mwp\",\"mwq\",\"mwr\",\"mws\",\"mwt\",\"mwu\",\"mwv\",\"mww\",\"mwx\",\"mwy\",\"mwz\",\"mxa\",\"mxb\",\"mxc\",\"mxd\",\"mxe\",\"mxf\",\"mxg\",\"mxh\",\"mxi\",\"mxj\",\"mxk\",\"mxl\",\"mxm\",\"mxn\",\"mxo\",\"mxp\",\"mxq\",\"mxr\",\"mxs\",\"mxt\",\"mxu\",\"mxv\",\"mxw\",\"mxx\",\"mxy\",\"mxz\",\"myb\",\"myc\",\"myd\",\"mye\",\"myf\",\"myg\",\"myh\",\"myi\",\"myj\",\"myk\",\"myl\",\"mym\",\"myn\",\"myo\",\"myp\",\"myq\",\"myr\",\"mys\",\"myt\",\"myu\",\"myv\",\"myw\",\"myx\",\"myy\",\"myz\",\"mza\",\"mzb\",\"mzc\",\"mzd\",\"mze\",\"mzg\",\"mzh\",\"mzi\",\"mzj\",\"mzk\",\"mzl\",\"mzm\",\"mzn\",\"mzo\",\"mzp\",\"mzq\",\"mzr\",\"mzs\",\"mzt\",\"mzu\",\"mzv\",\"mzw\",\"mzx\",\"mzy\",\"mzz\",\"naa\",\"nab\",\"nac\",\"nad\",\"nae\",\"naf\",\"nag\",\"nah\",\"nai\",\"naj\",\"nak\",\"nal\",\"nam\",\"nan\",\"nao\",\"nap\",\"naq\",\"nar\",\"nas\",\"nat\",\"naw\",\"nax\",\"nay\",\"naz\",\"nba\",\"nbb\",\"nbc\",\"nbd\",\"nbe\",\"nbf\",\"nbg\",\"nbh\",\"nbi\",\"nbj\",\"nbk\",\"nbm\",\"nbn\",\"nbo\",\"nbp\",\"nbq\",\"nbr\",\"nbs\",\"nbt\",\"nbu\",\"nbv\",\"nbw\",\"nbx\",\"nby\",\"nca\",\"ncb\",\"ncc\",\"ncd\",\"nce\",\"ncf\",\"ncg\",\"nch\",\"nci\",\"ncj\",\"nck\",\"ncl\",\"ncm\",\"ncn\",\"nco\",\"ncp\",\"ncq\",\"ncr\",\"ncs\",\"nct\",\"ncu\",\"ncx\",\"ncz\",\"nda\",\"ndb\",\"ndc\",\"ndd\",\"ndf\",\"ndg\",\"ndh\",\"ndi\",\"ndj\",\"ndk\",\"ndl\",\"ndm\",\"ndn\",\"ndp\",\"ndq\",\"ndr\",\"nds\",\"ndt\",\"ndu\",\"ndv\",\"ndw\",\"ndx\",\"ndy\",\"ndz\",\"nea\",\"neb\",\"nec\",\"ned\",\"nee\",\"nef\",\"neg\",\"neh\",\"nei\",\"nej\",\"nek\",\"nem\",\"nen\",\"neo\",\"neq\",\"ner\",\"nes\",\"net\",\"neu\",\"nev\",\"new\",\"nex\",\"ney\",\"nez\",\"nfa\",\"nfd\",\"nfl\",\"nfr\",\"nfu\",\"nga\",\"ngb\",\"ngc\",\"ngd\",\"nge\",\"ngf\",\"ngg\",\"ngh\",\"ngi\",\"ngj\",\"ngk\",\"ngl\",\"ngm\",\"ngn\",\"ngo\",\"ngp\",\"ngq\",\"ngr\",\"ngs\",\"ngt\",\"ngu\",\"ngv\",\"ngw\",\"ngx\",\"ngy\",\"ngz\",\"nha\",\"nhb\",\"nhc\",\"nhd\",\"nhe\",\"nhf\",\"nhg\",\"nhh\",\"nhi\",\"nhk\",\"nhm\",\"nhn\",\"nho\",\"nhp\",\"nhq\",\"nhr\",\"nht\",\"nhu\",\"nhv\",\"nhw\",\"nhx\",\"nhy\",\"nhz\",\"nia\",\"nib\",\"nic\",\"nid\",\"nie\",\"nif\",\"nig\",\"nih\",\"nii\",\"nij\",\"nik\",\"nil\",\"nim\",\"nin\",\"nio\",\"niq\",\"nir\",\"nis\",\"nit\",\"niu\",\"niv\",\"niw\",\"nix\",\"niy\",\"niz\",\"nja\",\"njb\",\"njd\",\"njh\",\"nji\",\"njj\",\"njl\",\"njm\",\"njn\",\"njo\",\"njr\",\"njs\",\"njt\",\"nju\",\"njx\",\"njy\",\"njz\",\"nka\",\"nkb\",\"nkc\",\"nkd\",\"nke\",\"nkf\",\"nkg\",\"nkh\",\"nki\",\"nkj\",\"nkk\",\"nkm\",\"nkn\",\"nko\",\"nkp\",\"nkq\",\"nkr\",\"nks\",\"nkt\",\"nku\",\"nkv\",\"nkw\",\"nkx\",\"nkz\",\"nla\",\"nlc\",\"nle\",\"nlg\",\"nli\",\"nlj\",\"nlk\",\"nll\",\"nln\",\"nlo\",\"nlq\",\"nlr\",\"nlu\",\"nlv\",\"nlw\",\"nlx\",\"nly\",\"nlz\",\"nma\",\"nmb\",\"nmc\",\"nmd\",\"nme\",\"nmf\",\"nmg\",\"nmh\",\"nmi\",\"nmj\",\"nmk\",\"nml\",\"nmm\",\"nmn\",\"nmo\",\"nmp\",\"nmq\",\"nmr\",\"nms\",\"nmt\",\"nmu\",\"nmv\",\"nmw\",\"nmx\",\"nmy\",\"nmz\",\"nna\",\"nnb\",\"nnc\",\"nnd\",\"nne\",\"nnf\",\"nng\",\"nnh\",\"nni\",\"nnj\",\"nnk\",\"nnl\",\"nnm\",\"nnn\",\"nnp\",\"nnq\",\"nnr\",\"nns\",\"nnt\",\"nnu\",\"nnv\",\"nnw\",\"nnx\",\"nny\",\"nnz\",\"noa\",\"noc\",\"nod\",\"noe\",\"nof\",\"nog\",\"noh\",\"noi\",\"noj\",\"nok\",\"nol\",\"nom\",\"non\",\"noo\",\"nop\",\"noq\",\"nos\",\"not\",\"nou\",\"nov\",\"now\",\"noy\",\"noz\",\"npa\",\"npb\",\"npg\",\"nph\",\"npi\",\"npl\",\"npn\",\"npo\",\"nps\",\"npu\",\"npx\",\"npy\",\"nqg\",\"nqk\",\"nql\",\"nqm\",\"nqn\",\"nqo\",\"nqq\",\"nqy\",\"nra\",\"nrb\",\"nrc\",\"nre\",\"nrf\",\"nrg\",\"nri\",\"nrk\",\"nrl\",\"nrm\",\"nrn\",\"nrp\",\"nrr\",\"nrt\",\"nru\",\"nrx\",\"nrz\",\"nsa\",\"nsc\",\"nsd\",\"nse\",\"nsf\",\"nsg\",\"nsh\",\"nsi\",\"nsk\",\"nsl\",\"nsm\",\"nsn\",\"nso\",\"nsp\",\"nsq\",\"nsr\",\"nss\",\"nst\",\"nsu\",\"nsv\",\"nsw\",\"nsx\",\"nsy\",\"nsz\",\"ntd\",\"nte\",\"ntg\",\"nti\",\"ntj\",\"ntk\",\"ntm\",\"nto\",\"ntp\",\"ntr\",\"nts\",\"ntu\",\"ntw\",\"ntx\",\"nty\",\"ntz\",\"nua\",\"nub\",\"nuc\",\"nud\",\"nue\",\"nuf\",\"nug\",\"nuh\",\"nui\",\"nuj\",\"nuk\",\"nul\",\"num\",\"nun\",\"nuo\",\"nup\",\"nuq\",\"nur\",\"nus\",\"nut\",\"nuu\",\"nuv\",\"nuw\",\"nux\",\"nuy\",\"nuz\",\"nvh\",\"nvm\",\"nvo\",\"nwa\",\"nwb\",\"nwc\",\"nwe\",\"nwg\",\"nwi\",\"nwm\",\"nwo\",\"nwr\",\"nwx\",\"nwy\",\"nxa\",\"nxd\",\"nxe\",\"nxg\",\"nxi\",\"nxk\",\"nxl\",\"nxm\",\"nxn\",\"nxo\",\"nxq\",\"nxr\",\"nxu\",\"nxx\",\"nyb\",\"nyc\",\"nyd\",\"nye\",\"nyf\",\"nyg\",\"nyh\",\"nyi\",\"nyj\",\"nyk\",\"nyl\",\"nym\",\"nyn\",\"nyo\",\"nyp\",\"nyq\",\"nyr\",\"nys\",\"nyt\",\"nyu\",\"nyv\",\"nyw\",\"nyx\",\"nyy\",\"nza\",\"nzb\",\"nzi\",\"nzk\",\"nzm\",\"nzs\",\"nzu\",\"nzy\",\"nzz\",\"oaa\",\"oac\",\"oar\",\"oav\",\"obi\",\"obk\",\"obl\",\"obm\",\"obo\",\"obr\",\"obt\",\"obu\",\"oca\",\"och\",\"oco\",\"ocu\",\"oda\",\"odk\",\"odt\",\"odu\",\"ofo\",\"ofs\",\"ofu\",\"ogb\",\"ogc\",\"oge\",\"ogg\",\"ogo\",\"ogu\",\"oht\",\"ohu\",\"oia\",\"oin\",\"ojb\",\"ojc\",\"ojg\",\"ojp\",\"ojs\",\"ojv\",\"ojw\",\"oka\",\"okb\",\"okd\",\"oke\",\"okg\",\"okh\",\"oki\",\"okj\",\"okk\",\"okl\",\"okm\",\"okn\",\"oko\",\"okr\",\"oks\",\"oku\",\"okv\",\"okx\",\"ola\",\"old\",\"ole\",\"olk\",\"olm\",\"olo\",\"olr\",\"olt\",\"olu\",\"oma\",\"omb\",\"omc\",\"ome\",\"omg\",\"omi\",\"omk\",\"oml\",\"omn\",\"omo\",\"omp\",\"omq\",\"omr\",\"omt\",\"omu\",\"omv\",\"omw\",\"omx\",\"ona\",\"onb\",\"one\",\"ong\",\"oni\",\"onj\",\"onk\",\"onn\",\"ono\",\"onp\",\"onr\",\"ons\",\"ont\",\"onu\",\"onw\",\"onx\",\"ood\",\"oog\",\"oon\",\"oor\",\"oos\",\"opa\",\"opk\",\"opm\",\"opo\",\"opt\",\"opy\",\"ora\",\"orc\",\"ore\",\"org\",\"orh\",\"orn\",\"oro\",\"orr\",\"ors\",\"ort\",\"oru\",\"orv\",\"orw\",\"orx\",\"ory\",\"orz\",\"osa\",\"osc\",\"osi\",\"oso\",\"osp\",\"ost\",\"osu\",\"osx\",\"ota\",\"otb\",\"otd\",\"ote\",\"oti\",\"otk\",\"otl\",\"otm\",\"otn\",\"oto\",\"otq\",\"otr\",\"ots\",\"ott\",\"otu\",\"otw\",\"otx\",\"oty\",\"otz\",\"oua\",\"oub\",\"oue\",\"oui\",\"oum\",\"oun\",\"ovd\",\"owi\",\"owl\",\"oyb\",\"oyd\",\"oym\",\"oyy\",\"ozm\",\"paa\",\"pab\",\"pac\",\"pad\",\"pae\",\"paf\",\"pag\",\"pah\",\"pai\",\"pak\",\"pal\",\"pam\",\"pao\",\"pap\",\"paq\",\"par\",\"pas\",\"pat\",\"pau\",\"pav\",\"paw\",\"pax\",\"pay\",\"paz\",\"pbb\",\"pbc\",\"pbe\",\"pbf\",\"pbg\",\"pbh\",\"pbi\",\"pbl\",\"pbn\",\"pbo\",\"pbp\",\"pbr\",\"pbs\",\"pbt\",\"pbu\",\"pbv\",\"pby\",\"pbz\",\"pca\",\"pcb\",\"pcc\",\"pcd\",\"pce\",\"pcf\",\"pcg\",\"pch\",\"pci\",\"pcj\",\"pck\",\"pcl\",\"pcm\",\"pcn\",\"pcp\",\"pcr\",\"pcw\",\"pda\",\"pdc\",\"pdi\",\"pdn\",\"pdo\",\"pdt\",\"pdu\",\"pea\",\"peb\",\"ped\",\"pee\",\"pef\",\"peg\",\"peh\",\"pei\",\"pej\",\"pek\",\"pel\",\"pem\",\"peo\",\"pep\",\"peq\",\"pes\",\"pev\",\"pex\",\"pey\",\"pez\",\"pfa\",\"pfe\",\"pfl\",\"pga\",\"pgd\",\"pgg\",\"pgi\",\"pgk\",\"pgl\",\"pgn\",\"pgs\",\"pgu\",\"pgy\",\"pgz\",\"pha\",\"phd\",\"phg\",\"phh\",\"phi\",\"phk\",\"phl\",\"phm\",\"phn\",\"pho\",\"phq\",\"phr\",\"pht\",\"phu\",\"phv\",\"phw\",\"pia\",\"pib\",\"pic\",\"pid\",\"pie\",\"pif\",\"pig\",\"pih\",\"pii\",\"pij\",\"pil\",\"pim\",\"pin\",\"pio\",\"pip\",\"pir\",\"pis\",\"pit\",\"piu\",\"piv\",\"piw\",\"pix\",\"piy\",\"piz\",\"pjt\",\"pka\",\"pkb\",\"pkc\",\"pkg\",\"pkh\",\"pkn\",\"pko\",\"pkp\",\"pkr\",\"pks\",\"pkt\",\"pku\",\"pla\",\"plb\",\"plc\",\"pld\",\"ple\",\"plf\",\"plg\",\"plh\",\"plj\",\"plk\",\"pll\",\"pln\",\"plo\",\"plp\",\"plq\",\"plr\",\"pls\",\"plt\",\"plu\",\"plv\",\"plw\",\"ply\",\"plz\",\"pma\",\"pmb\",\"pmc\",\"pmd\",\"pme\",\"pmf\",\"pmh\",\"pmi\",\"pmj\",\"pmk\",\"pml\",\"pmm\",\"pmn\",\"pmo\",\"pmq\",\"pmr\",\"pms\",\"pmt\",\"pmu\",\"pmw\",\"pmx\",\"pmy\",\"pmz\",\"pna\",\"pnb\",\"pnc\",\"pne\",\"png\",\"pnh\",\"pni\",\"pnj\",\"pnk\",\"pnl\",\"pnm\",\"pnn\",\"pno\",\"pnp\",\"pnq\",\"pnr\",\"pns\",\"pnt\",\"pnu\",\"pnv\",\"pnw\",\"pnx\",\"pny\",\"pnz\",\"poc\",\"pod\",\"poe\",\"pof\",\"pog\",\"poh\",\"poi\",\"pok\",\"pom\",\"pon\",\"poo\",\"pop\",\"poq\",\"pos\",\"pot\",\"pov\",\"pow\",\"pox\",\"poy\",\"poz\",\"ppa\",\"ppe\",\"ppi\",\"ppk\",\"ppl\",\"ppm\",\"ppn\",\"ppo\",\"ppp\",\"ppq\",\"ppr\",\"pps\",\"ppt\",\"ppu\",\"pqa\",\"pqe\",\"pqm\",\"pqw\",\"pra\",\"prb\",\"prc\",\"prd\",\"pre\",\"prf\",\"prg\",\"prh\",\"pri\",\"prk\",\"prl\",\"prm\",\"prn\",\"pro\",\"prp\",\"prq\",\"prr\",\"prs\",\"prt\",\"pru\",\"prw\",\"prx\",\"pry\",\"prz\",\"psa\",\"psc\",\"psd\",\"pse\",\"psg\",\"psh\",\"psi\",\"psl\",\"psm\",\"psn\",\"pso\",\"psp\",\"psq\",\"psr\",\"pss\",\"pst\",\"psu\",\"psw\",\"psy\",\"pta\",\"pth\",\"pti\",\"ptn\",\"pto\",\"ptp\",\"ptq\",\"ptr\",\"ptt\",\"ptu\",\"ptv\",\"ptw\",\"pty\",\"pua\",\"pub\",\"puc\",\"pud\",\"pue\",\"puf\",\"pug\",\"pui\",\"puj\",\"puk\",\"pum\",\"puo\",\"pup\",\"puq\",\"pur\",\"put\",\"puu\",\"puw\",\"pux\",\"puy\",\"puz\",\"pwa\",\"pwb\",\"pwg\",\"pwi\",\"pwm\",\"pwn\",\"pwo\",\"pwr\",\"pww\",\"pxm\",\"pye\",\"pym\",\"pyn\",\"pys\",\"pyu\",\"pyx\",\"pyy\",\"pzn\",\"qaa..qtz\",\"qua\",\"qub\",\"quc\",\"qud\",\"quf\",\"qug\",\"quh\",\"qui\",\"quk\",\"qul\",\"qum\",\"qun\",\"qup\",\"quq\",\"qur\",\"qus\",\"quv\",\"quw\",\"qux\",\"quy\",\"quz\",\"qva\",\"qvc\",\"qve\",\"qvh\",\"qvi\",\"qvj\",\"qvl\",\"qvm\",\"qvn\",\"qvo\",\"qvp\",\"qvs\",\"qvw\",\"qvy\",\"qvz\",\"qwa\",\"qwc\",\"qwe\",\"qwh\",\"qwm\",\"qws\",\"qwt\",\"qxa\",\"qxc\",\"qxh\",\"qxl\",\"qxn\",\"qxo\",\"qxp\",\"qxq\",\"qxr\",\"qxs\",\"qxt\",\"qxu\",\"qxw\",\"qya\",\"qyp\",\"raa\",\"rab\",\"rac\",\"rad\",\"raf\",\"rag\",\"rah\",\"rai\",\"raj\",\"rak\",\"ral\",\"ram\",\"ran\",\"rao\",\"rap\",\"raq\",\"rar\",\"ras\",\"rat\",\"rau\",\"rav\",\"raw\",\"rax\",\"ray\",\"raz\",\"rbb\",\"rbk\",\"rbl\",\"rbp\",\"rcf\",\"rdb\",\"rea\",\"reb\",\"ree\",\"reg\",\"rei\",\"rej\",\"rel\",\"rem\",\"ren\",\"rer\",\"res\",\"ret\",\"rey\",\"rga\",\"rge\",\"rgk\",\"rgn\",\"rgr\",\"rgs\",\"rgu\",\"rhg\",\"rhp\",\"ria\",\"rie\",\"rif\",\"ril\",\"rim\",\"rin\",\"rir\",\"rit\",\"riu\",\"rjg\",\"rji\",\"rjs\",\"rka\",\"rkb\",\"rkh\",\"rki\",\"rkm\",\"rkt\",\"rkw\",\"rma\",\"rmb\",\"rmc\",\"rmd\",\"rme\",\"rmf\",\"rmg\",\"rmh\",\"rmi\",\"rmk\",\"rml\",\"rmm\",\"rmn\",\"rmo\",\"rmp\",\"rmq\",\"rmr\",\"rms\",\"rmt\",\"rmu\",\"rmv\",\"rmw\",\"rmx\",\"rmy\",\"rmz\",\"rna\",\"rnd\",\"rng\",\"rnl\",\"rnn\",\"rnp\",\"rnr\",\"rnw\",\"roa\",\"rob\",\"roc\",\"rod\",\"roe\",\"rof\",\"rog\",\"rol\",\"rom\",\"roo\",\"rop\",\"ror\",\"rou\",\"row\",\"rpn\",\"rpt\",\"rri\",\"rro\",\"rrt\",\"rsb\",\"rsi\",\"rsl\",\"rsm\",\"rtc\",\"rth\",\"rtm\",\"rts\",\"rtw\",\"rub\",\"ruc\",\"rue\",\"ruf\",\"rug\",\"ruh\",\"rui\",\"ruk\",\"ruo\",\"rup\",\"ruq\",\"rut\",\"ruu\",\"ruy\",\"ruz\",\"rwa\",\"rwk\",\"rwm\",\"rwo\",\"rwr\",\"rxd\",\"rxw\",\"ryn\",\"rys\",\"ryu\",\"rzh\",\"saa\",\"sab\",\"sac\",\"sad\",\"sae\",\"saf\",\"sah\",\"sai\",\"saj\",\"sak\",\"sal\",\"sam\",\"sao\",\"sap\",\"saq\",\"sar\",\"sas\",\"sat\",\"sau\",\"sav\",\"saw\",\"sax\",\"say\",\"saz\",\"sba\",\"sbb\",\"sbc\",\"sbd\",\"sbe\",\"sbf\",\"sbg\",\"sbh\",\"sbi\",\"sbj\",\"sbk\",\"sbl\",\"sbm\",\"sbn\",\"sbo\",\"sbp\",\"sbq\",\"sbr\",\"sbs\",\"sbt\",\"sbu\",\"sbv\",\"sbw\",\"sbx\",\"sby\",\"sbz\",\"sca\",\"scb\",\"sce\",\"scf\",\"scg\",\"sch\",\"sci\",\"sck\",\"scl\",\"scn\",\"sco\",\"scp\",\"scq\",\"scs\",\"sct\",\"scu\",\"scv\",\"scw\",\"scx\",\"sda\",\"sdb\",\"sdc\",\"sde\",\"sdf\",\"sdg\",\"sdh\",\"sdj\",\"sdk\",\"sdl\",\"sdm\",\"sdn\",\"sdo\",\"sdp\",\"sdr\",\"sds\",\"sdt\",\"sdu\",\"sdv\",\"sdx\",\"sdz\",\"sea\",\"seb\",\"sec\",\"sed\",\"see\",\"sef\",\"seg\",\"seh\",\"sei\",\"sej\",\"sek\",\"sel\",\"sem\",\"sen\",\"seo\",\"sep\",\"seq\",\"ser\",\"ses\",\"set\",\"seu\",\"sev\",\"sew\",\"sey\",\"sez\",\"sfb\",\"sfe\",\"sfm\",\"sfs\",\"sfw\",\"sga\",\"sgb\",\"sgc\",\"sgd\",\"sge\",\"sgg\",\"sgh\",\"sgi\",\"sgj\",\"sgk\",\"sgl\",\"sgm\",\"sgn\",\"sgo\",\"sgp\",\"sgr\",\"sgs\",\"sgt\",\"sgu\",\"sgw\",\"sgx\",\"sgy\",\"sgz\",\"sha\",\"shb\",\"shc\",\"shd\",\"she\",\"shg\",\"shh\",\"shi\",\"shj\",\"shk\",\"shl\",\"shm\",\"shn\",\"sho\",\"shp\",\"shq\",\"shr\",\"shs\",\"sht\",\"shu\",\"shv\",\"shw\",\"shx\",\"shy\",\"shz\",\"sia\",\"sib\",\"sid\",\"sie\",\"sif\",\"sig\",\"sih\",\"sii\",\"sij\",\"sik\",\"sil\",\"sim\",\"sio\",\"sip\",\"siq\",\"sir\",\"sis\",\"sit\",\"siu\",\"siv\",\"siw\",\"six\",\"siy\",\"siz\",\"sja\",\"sjb\",\"sjd\",\"sje\",\"sjg\",\"sjk\",\"sjl\",\"sjm\",\"sjn\",\"sjo\",\"sjp\",\"sjr\",\"sjs\",\"sjt\",\"sju\",\"sjw\",\"ska\",\"skb\",\"skc\",\"skd\",\"ske\",\"skf\",\"skg\",\"skh\",\"ski\",\"skj\",\"skk\",\"skm\",\"skn\",\"sko\",\"skp\",\"skq\",\"skr\",\"sks\",\"skt\",\"sku\",\"skv\",\"skw\",\"skx\",\"sky\",\"skz\",\"sla\",\"slc\",\"sld\",\"sle\",\"slf\",\"slg\",\"slh\",\"sli\",\"slj\",\"sll\",\"slm\",\"sln\",\"slp\",\"slq\",\"slr\",\"sls\",\"slt\",\"slu\",\"slw\",\"slx\",\"sly\",\"slz\",\"sma\",\"smb\",\"smc\",\"smd\",\"smf\",\"smg\",\"smh\",\"smi\",\"smj\",\"smk\",\"sml\",\"smm\",\"smn\",\"smp\",\"smq\",\"smr\",\"sms\",\"smt\",\"smu\",\"smv\",\"smw\",\"smx\",\"smy\",\"smz\",\"snb\",\"snc\",\"sne\",\"snf\",\"sng\",\"snh\",\"sni\",\"snj\",\"snk\",\"snl\",\"snm\",\"snn\",\"sno\",\"snp\",\"snq\",\"snr\",\"sns\",\"snu\",\"snv\",\"snw\",\"snx\",\"sny\",\"snz\",\"soa\",\"sob\",\"soc\",\"sod\",\"soe\",\"sog\",\"soh\",\"soi\",\"soj\",\"sok\",\"sol\",\"son\",\"soo\",\"sop\",\"soq\",\"sor\",\"sos\",\"sou\",\"sov\",\"sow\",\"sox\",\"soy\",\"soz\",\"spb\",\"spc\",\"spd\",\"spe\",\"spg\",\"spi\",\"spk\",\"spl\",\"spm\",\"spn\",\"spo\",\"spp\",\"spq\",\"spr\",\"sps\",\"spt\",\"spu\",\"spv\",\"spx\",\"spy\",\"sqa\",\"sqh\",\"sqj\",\"sqk\",\"sqm\",\"sqn\",\"sqo\",\"sqq\",\"sqr\",\"sqs\",\"sqt\",\"squ\",\"sra\",\"srb\",\"src\",\"sre\",\"srf\",\"srg\",\"srh\",\"sri\",\"srk\",\"srl\",\"srm\",\"srn\",\"sro\",\"srq\",\"srr\",\"srs\",\"srt\",\"sru\",\"srv\",\"srw\",\"srx\",\"sry\",\"srz\",\"ssa\",\"ssb\",\"ssc\",\"ssd\",\"sse\",\"ssf\",\"ssg\",\"ssh\",\"ssi\",\"ssj\",\"ssk\",\"ssl\",\"ssm\",\"ssn\",\"sso\",\"ssp\",\"ssq\",\"ssr\",\"sss\",\"sst\",\"ssu\",\"ssv\",\"ssx\",\"ssy\",\"ssz\",\"sta\",\"stb\",\"std\",\"ste\",\"stf\",\"stg\",\"sth\",\"sti\",\"stj\",\"stk\",\"stl\",\"stm\",\"stn\",\"sto\",\"stp\",\"stq\",\"str\",\"sts\",\"stt\",\"stu\",\"stv\",\"stw\",\"sty\",\"sua\",\"sub\",\"suc\",\"sue\",\"sug\",\"sui\",\"suj\",\"suk\",\"sul\",\"sum\",\"suq\",\"sur\",\"sus\",\"sut\",\"suv\",\"suw\",\"sux\",\"suy\",\"suz\",\"sva\",\"svb\",\"svc\",\"sve\",\"svk\",\"svm\",\"svr\",\"svs\",\"svx\",\"swb\",\"swc\",\"swf\",\"swg\",\"swh\",\"swi\",\"swj\",\"swk\",\"swl\",\"swm\",\"swn\",\"swo\",\"swp\",\"swq\",\"swr\",\"sws\",\"swt\",\"swu\",\"swv\",\"sww\",\"swx\",\"swy\",\"sxb\",\"sxc\",\"sxe\",\"sxg\",\"sxk\",\"sxl\",\"sxm\",\"sxn\",\"sxo\",\"sxr\",\"sxs\",\"sxu\",\"sxw\",\"sya\",\"syb\",\"syc\",\"syd\",\"syi\",\"syk\",\"syl\",\"sym\",\"syn\",\"syo\",\"syr\",\"sys\",\"syw\",\"syx\",\"syy\",\"sza\",\"szb\",\"szc\",\"szd\",\"sze\",\"szg\",\"szl\",\"szn\",\"szp\",\"szs\",\"szv\",\"szw\",\"taa\",\"tab\",\"tac\",\"tad\",\"tae\",\"taf\",\"tag\",\"tai\",\"taj\",\"tak\",\"tal\",\"tan\",\"tao\",\"tap\",\"taq\",\"tar\",\"tas\",\"tau\",\"tav\",\"taw\",\"tax\",\"tay\",\"taz\",\"tba\",\"tbb\",\"tbc\",\"tbd\",\"tbe\",\"tbf\",\"tbg\",\"tbh\",\"tbi\",\"tbj\",\"tbk\",\"tbl\",\"tbm\",\"tbn\",\"tbo\",\"tbp\",\"tbq\",\"tbr\",\"tbs\",\"tbt\",\"tbu\",\"tbv\",\"tbw\",\"tbx\",\"tby\",\"tbz\",\"tca\",\"tcb\",\"tcc\",\"tcd\",\"tce\",\"tcf\",\"tcg\",\"tch\",\"tci\",\"tck\",\"tcl\",\"tcm\",\"tcn\",\"tco\",\"tcp\",\"tcq\",\"tcs\",\"tct\",\"tcu\",\"tcw\",\"tcx\",\"tcy\",\"tcz\",\"tda\",\"tdb\",\"tdc\",\"tdd\",\"tde\",\"tdf\",\"tdg\",\"tdh\",\"tdi\",\"tdj\",\"tdk\",\"tdl\",\"tdm\",\"tdn\",\"tdo\",\"tdq\",\"tdr\",\"tds\",\"tdt\",\"tdu\",\"tdv\",\"tdx\",\"tdy\",\"tea\",\"teb\",\"tec\",\"ted\",\"tee\",\"tef\",\"teg\",\"teh\",\"tei\",\"tek\",\"tem\",\"ten\",\"teo\",\"tep\",\"teq\",\"ter\",\"tes\",\"tet\",\"teu\",\"tev\",\"tew\",\"tex\",\"tey\",\"tfi\",\"tfn\",\"tfo\",\"tfr\",\"tft\",\"tga\",\"tgb\",\"tgc\",\"tgd\",\"tge\",\"tgf\",\"tgg\",\"tgh\",\"tgi\",\"tgj\",\"tgn\",\"tgo\",\"tgp\",\"tgq\",\"tgr\",\"tgs\",\"tgt\",\"tgu\",\"tgv\",\"tgw\",\"tgx\",\"tgy\",\"tgz\",\"thc\",\"thd\",\"the\",\"thf\",\"thh\",\"thi\",\"thk\",\"thl\",\"thm\",\"thn\",\"thp\",\"thq\",\"thr\",\"ths\",\"tht\",\"thu\",\"thv\",\"thw\",\"thx\",\"thy\",\"thz\",\"tia\",\"tic\",\"tid\",\"tie\",\"tif\",\"tig\",\"tih\",\"tii\",\"tij\",\"tik\",\"til\",\"tim\",\"tin\",\"tio\",\"tip\",\"tiq\",\"tis\",\"tit\",\"tiu\",\"tiv\",\"tiw\",\"tix\",\"tiy\",\"tiz\",\"tja\",\"tjg\",\"tji\",\"tjl\",\"tjm\",\"tjn\",\"tjo\",\"tjs\",\"tju\",\"tjw\",\"tka\",\"tkb\",\"tkd\",\"tke\",\"tkf\",\"tkg\",\"tkk\",\"tkl\",\"tkm\",\"tkn\",\"tkp\",\"tkq\",\"tkr\",\"tks\",\"tkt\",\"tku\",\"tkv\",\"tkw\",\"tkx\",\"tkz\",\"tla\",\"tlb\",\"tlc\",\"tld\",\"tlf\",\"tlg\",\"tlh\",\"tli\",\"tlj\",\"tlk\",\"tll\",\"tlm\",\"tln\",\"tlo\",\"tlp\",\"tlq\",\"tlr\",\"tls\",\"tlt\",\"tlu\",\"tlv\",\"tlw\",\"tlx\",\"tly\",\"tma\",\"tmb\",\"tmc\",\"tmd\",\"tme\",\"tmf\",\"tmg\",\"tmh\",\"tmi\",\"tmj\",\"tmk\",\"tml\",\"tmm\",\"tmn\",\"tmo\",\"tmp\",\"tmq\",\"tmr\",\"tms\",\"tmt\",\"tmu\",\"tmv\",\"tmw\",\"tmy\",\"tmz\",\"tna\",\"tnb\",\"tnc\",\"tnd\",\"tne\",\"tnf\",\"tng\",\"tnh\",\"tni\",\"tnk\",\"tnl\",\"tnm\",\"tnn\",\"tno\",\"tnp\",\"tnq\",\"tnr\",\"tns\",\"tnt\",\"tnu\",\"tnv\",\"tnw\",\"tnx\",\"tny\",\"tnz\",\"tob\",\"toc\",\"tod\",\"toe\",\"tof\",\"tog\",\"toh\",\"toi\",\"toj\",\"tol\",\"tom\",\"too\",\"top\",\"toq\",\"tor\",\"tos\",\"tou\",\"tov\",\"tow\",\"tox\",\"toy\",\"toz\",\"tpa\",\"tpc\",\"tpe\",\"tpf\",\"tpg\",\"tpi\",\"tpj\",\"tpk\",\"tpl\",\"tpm\",\"tpn\",\"tpo\",\"tpp\",\"tpq\",\"tpr\",\"tpt\",\"tpu\",\"tpv\",\"tpw\",\"tpx\",\"tpy\",\"tpz\",\"tqb\",\"tql\",\"tqm\",\"tqn\",\"tqo\",\"tqp\",\"tqq\",\"tqr\",\"tqt\",\"tqu\",\"tqw\",\"tra\",\"trb\",\"trc\",\"trd\",\"tre\",\"trf\",\"trg\",\"trh\",\"tri\",\"trj\",\"trk\",\"trl\",\"trm\",\"trn\",\"tro\",\"trp\",\"trq\",\"trr\",\"trs\",\"trt\",\"tru\",\"trv\",\"trw\",\"trx\",\"try\",\"trz\",\"tsa\",\"tsb\",\"tsc\",\"tsd\",\"tse\",\"tsf\",\"tsg\",\"tsh\",\"tsi\",\"tsj\",\"tsk\",\"tsl\",\"tsm\",\"tsp\",\"tsq\",\"tsr\",\"tss\",\"tst\",\"tsu\",\"tsv\",\"tsw\",\"tsx\",\"tsy\",\"tsz\",\"tta\",\"ttb\",\"ttc\",\"ttd\",\"tte\",\"ttf\",\"ttg\",\"tth\",\"tti\",\"ttj\",\"ttk\",\"ttl\",\"ttm\",\"ttn\",\"tto\",\"ttp\",\"ttq\",\"ttr\",\"tts\",\"ttt\",\"ttu\",\"ttv\",\"ttw\",\"tty\",\"ttz\",\"tua\",\"tub\",\"tuc\",\"tud\",\"tue\",\"tuf\",\"tug\",\"tuh\",\"tui\",\"tuj\",\"tul\",\"tum\",\"tun\",\"tuo\",\"tup\",\"tuq\",\"tus\",\"tut\",\"tuu\",\"tuv\",\"tuw\",\"tux\",\"tuy\",\"tuz\",\"tva\",\"tvd\",\"tve\",\"tvk\",\"tvl\",\"tvm\",\"tvn\",\"tvo\",\"tvs\",\"tvt\",\"tvu\",\"tvw\",\"tvy\",\"twa\",\"twb\",\"twc\",\"twd\",\"twe\",\"twf\",\"twg\",\"twh\",\"twl\",\"twm\",\"twn\",\"two\",\"twp\",\"twq\",\"twr\",\"twt\",\"twu\",\"tww\",\"twx\",\"twy\",\"txa\",\"txb\",\"txc\",\"txe\",\"txg\",\"txh\",\"txi\",\"txj\",\"txm\",\"txn\",\"txo\",\"txq\",\"txr\",\"txs\",\"txt\",\"txu\",\"txx\",\"txy\",\"tya\",\"tye\",\"tyh\",\"tyi\",\"tyj\",\"tyl\",\"tyn\",\"typ\",\"tyr\",\"tys\",\"tyt\",\"tyu\",\"tyv\",\"tyx\",\"tyz\",\"tza\",\"tzh\",\"tzj\",\"tzl\",\"tzm\",\"tzn\",\"tzo\",\"tzx\",\"uam\",\"uan\",\"uar\",\"uba\",\"ubi\",\"ubl\",\"ubr\",\"ubu\",\"uby\",\"uda\",\"ude\",\"udg\",\"udi\",\"udj\",\"udl\",\"udm\",\"udu\",\"ues\",\"ufi\",\"uga\",\"ugb\",\"uge\",\"ugn\",\"ugo\",\"ugy\",\"uha\",\"uhn\",\"uis\",\"uiv\",\"uji\",\"uka\",\"ukg\",\"ukh\",\"ukk\",\"ukl\",\"ukp\",\"ukq\",\"uks\",\"uku\",\"ukw\",\"uky\",\"ula\",\"ulb\",\"ulc\",\"ule\",\"ulf\",\"uli\",\"ulk\",\"ull\",\"ulm\",\"uln\",\"ulu\",\"ulw\",\"uma\",\"umb\",\"umc\",\"umd\",\"umg\",\"umi\",\"umm\",\"umn\",\"umo\",\"ump\",\"umr\",\"ums\",\"umu\",\"una\",\"und\",\"une\",\"ung\",\"unk\",\"unm\",\"unn\",\"unp\",\"unr\",\"unu\",\"unx\",\"unz\",\"uok\",\"upi\",\"upv\",\"ura\",\"urb\",\"urc\",\"ure\",\"urf\",\"urg\",\"urh\",\"uri\",\"urj\",\"urk\",\"url\",\"urm\",\"urn\",\"uro\",\"urp\",\"urr\",\"urt\",\"uru\",\"urv\",\"urw\",\"urx\",\"ury\",\"urz\",\"usa\",\"ush\",\"usi\",\"usk\",\"usp\",\"usu\",\"uta\",\"ute\",\"utp\",\"utr\",\"utu\",\"uum\",\"uun\",\"uur\",\"uuu\",\"uve\",\"uvh\",\"uvl\",\"uwa\",\"uya\",\"uzn\",\"uzs\",\"vaa\",\"vae\",\"vaf\",\"vag\",\"vah\",\"vai\",\"vaj\",\"val\",\"vam\",\"van\",\"vao\",\"vap\",\"var\",\"vas\",\"vau\",\"vav\",\"vay\",\"vbb\",\"vbk\",\"vec\",\"ved\",\"vel\",\"vem\",\"veo\",\"vep\",\"ver\",\"vgr\",\"vgt\",\"vic\",\"vid\",\"vif\",\"vig\",\"vil\",\"vin\",\"vis\",\"vit\",\"viv\",\"vka\",\"vki\",\"vkj\",\"vkk\",\"vkl\",\"vkm\",\"vko\",\"vkp\",\"vkt\",\"vku\",\"vlp\",\"vls\",\"vma\",\"vmb\",\"vmc\",\"vmd\",\"vme\",\"vmf\",\"vmg\",\"vmh\",\"vmi\",\"vmj\",\"vmk\",\"vml\",\"vmm\",\"vmp\",\"vmq\",\"vmr\",\"vms\",\"vmu\",\"vmv\",\"vmw\",\"vmx\",\"vmy\",\"vmz\",\"vnk\",\"vnm\",\"vnp\",\"vor\",\"vot\",\"vra\",\"vro\",\"vrs\",\"vrt\",\"vsi\",\"vsl\",\"vsv\",\"vto\",\"vum\",\"vun\",\"vut\",\"vwa\",\"waa\",\"wab\",\"wac\",\"wad\",\"wae\",\"waf\",\"wag\",\"wah\",\"wai\",\"waj\",\"wak\",\"wal\",\"wam\",\"wan\",\"wao\",\"wap\",\"waq\",\"war\",\"was\",\"wat\",\"wau\",\"wav\",\"waw\",\"wax\",\"way\",\"waz\",\"wba\",\"wbb\",\"wbe\",\"wbf\",\"wbh\",\"wbi\",\"wbj\",\"wbk\",\"wbl\",\"wbm\",\"wbp\",\"wbq\",\"wbr\",\"wbs\",\"wbt\",\"wbv\",\"wbw\",\"wca\",\"wci\",\"wdd\",\"wdg\",\"wdj\",\"wdk\",\"wdu\",\"wdy\",\"wea\",\"wec\",\"wed\",\"weg\",\"weh\",\"wei\",\"wem\",\"wen\",\"weo\",\"wep\",\"wer\",\"wes\",\"wet\",\"weu\",\"wew\",\"wfg\",\"wga\",\"wgb\",\"wgg\",\"wgi\",\"wgo\",\"wgu\",\"wgw\",\"wgy\",\"wha\",\"whg\",\"whk\",\"whu\",\"wib\",\"wic\",\"wie\",\"wif\",\"wig\",\"wih\",\"wii\",\"wij\",\"wik\",\"wil\",\"wim\",\"win\",\"wir\",\"wit\",\"wiu\",\"wiv\",\"wiw\",\"wiy\",\"wja\",\"wji\",\"wka\",\"wkb\",\"wkd\",\"wkl\",\"wku\",\"wkw\",\"wky\",\"wla\",\"wlc\",\"wle\",\"wlg\",\"wli\",\"wlk\",\"wll\",\"wlm\",\"wlo\",\"wlr\",\"wls\",\"wlu\",\"wlv\",\"wlw\",\"wlx\",\"wly\",\"wma\",\"wmb\",\"wmc\",\"wmd\",\"wme\",\"wmh\",\"wmi\",\"wmm\",\"wmn\",\"wmo\",\"wms\",\"wmt\",\"wmw\",\"wmx\",\"wnb\",\"wnc\",\"wnd\",\"wne\",\"wng\",\"wni\",\"wnk\",\"wnm\",\"wnn\",\"wno\",\"wnp\",\"wnu\",\"wnw\",\"wny\",\"woa\",\"wob\",\"woc\",\"wod\",\"woe\",\"wof\",\"wog\",\"woi\",\"wok\",\"wom\",\"won\",\"woo\",\"wor\",\"wos\",\"wow\",\"woy\",\"wpc\",\"wra\",\"wrb\",\"wrd\",\"wrg\",\"wrh\",\"wri\",\"wrk\",\"wrl\",\"wrm\",\"wrn\",\"wro\",\"wrp\",\"wrr\",\"wrs\",\"wru\",\"wrv\",\"wrw\",\"wrx\",\"wry\",\"wrz\",\"wsa\",\"wsg\",\"wsi\",\"wsk\",\"wsr\",\"wss\",\"wsu\",\"wsv\",\"wtf\",\"wth\",\"wti\",\"wtk\",\"wtm\",\"wtw\",\"wua\",\"wub\",\"wud\",\"wuh\",\"wul\",\"wum\",\"wun\",\"wur\",\"wut\",\"wuu\",\"wuv\",\"wux\",\"wuy\",\"wwa\",\"wwb\",\"wwo\",\"wwr\",\"www\",\"wxa\",\"wxw\",\"wya\",\"wyb\",\"wyi\",\"wym\",\"wyr\",\"wyy\",\"xaa\",\"xab\",\"xac\",\"xad\",\"xae\",\"xag\",\"xai\",\"xaj\",\"xak\",\"xal\",\"xam\",\"xan\",\"xao\",\"xap\",\"xaq\",\"xar\",\"xas\",\"xat\",\"xau\",\"xav\",\"xaw\",\"xay\",\"xba\",\"xbb\",\"xbc\",\"xbd\",\"xbe\",\"xbg\",\"xbi\",\"xbj\",\"xbm\",\"xbn\",\"xbo\",\"xbp\",\"xbr\",\"xbw\",\"xbx\",\"xby\",\"xcb\",\"xcc\",\"xce\",\"xcg\",\"xch\",\"xcl\",\"xcm\",\"xcn\",\"xco\",\"xcr\",\"xct\",\"xcu\",\"xcv\",\"xcw\",\"xcy\",\"xda\",\"xdc\",\"xdk\",\"xdm\",\"xdo\",\"xdy\",\"xeb\",\"xed\",\"xeg\",\"xel\",\"xem\",\"xep\",\"xer\",\"xes\",\"xet\",\"xeu\",\"xfa\",\"xga\",\"xgb\",\"xgd\",\"xgf\",\"xgg\",\"xgi\",\"xgl\",\"xgm\",\"xgn\",\"xgr\",\"xgu\",\"xgw\",\"xha\",\"xhc\",\"xhd\",\"xhe\",\"xhr\",\"xht\",\"xhu\",\"xhv\",\"xia\",\"xib\",\"xii\",\"xil\",\"xin\",\"xip\",\"xir\",\"xis\",\"xiv\",\"xiy\",\"xjb\",\"xjt\",\"xka\",\"xkb\",\"xkc\",\"xkd\",\"xke\",\"xkf\",\"xkg\",\"xkh\",\"xki\",\"xkj\",\"xkk\",\"xkl\",\"xkn\",\"xko\",\"xkp\",\"xkq\",\"xkr\",\"xks\",\"xkt\",\"xku\",\"xkv\",\"xkw\",\"xkx\",\"xky\",\"xkz\",\"xla\",\"xlb\",\"xlc\",\"xld\",\"xle\",\"xlg\",\"xli\",\"xln\",\"xlo\",\"xlp\",\"xls\",\"xlu\",\"xly\",\"xma\",\"xmb\",\"xmc\",\"xmd\",\"xme\",\"xmf\",\"xmg\",\"xmh\",\"xmj\",\"xmk\",\"xml\",\"xmm\",\"xmn\",\"xmo\",\"xmp\",\"xmq\",\"xmr\",\"xms\",\"xmt\",\"xmu\",\"xmv\",\"xmw\",\"xmx\",\"xmy\",\"xmz\",\"xna\",\"xnb\",\"xnd\",\"xng\",\"xnh\",\"xni\",\"xnk\",\"xnn\",\"xno\",\"xnr\",\"xns\",\"xnt\",\"xnu\",\"xny\",\"xnz\",\"xoc\",\"xod\",\"xog\",\"xoi\",\"xok\",\"xom\",\"xon\",\"xoo\",\"xop\",\"xor\",\"xow\",\"xpa\",\"xpc\",\"xpe\",\"xpg\",\"xpi\",\"xpj\",\"xpk\",\"xpm\",\"xpn\",\"xpo\",\"xpp\",\"xpq\",\"xpr\",\"xps\",\"xpt\",\"xpu\",\"xpy\",\"xqa\",\"xqt\",\"xra\",\"xrb\",\"xrd\",\"xre\",\"xrg\",\"xri\",\"xrm\",\"xrn\",\"xrq\",\"xrr\",\"xrt\",\"xru\",\"xrw\",\"xsa\",\"xsb\",\"xsc\",\"xsd\",\"xse\",\"xsh\",\"xsi\",\"xsj\",\"xsl\",\"xsm\",\"xsn\",\"xso\",\"xsp\",\"xsq\",\"xsr\",\"xss\",\"xsu\",\"xsv\",\"xsy\",\"xta\",\"xtb\",\"xtc\",\"xtd\",\"xte\",\"xtg\",\"xth\",\"xti\",\"xtj\",\"xtl\",\"xtm\",\"xtn\",\"xto\",\"xtp\",\"xtq\",\"xtr\",\"xts\",\"xtt\",\"xtu\",\"xtv\",\"xtw\",\"xty\",\"xtz\",\"xua\",\"xub\",\"xud\",\"xug\",\"xuj\",\"xul\",\"xum\",\"xun\",\"xuo\",\"xup\",\"xur\",\"xut\",\"xuu\",\"xve\",\"xvi\",\"xvn\",\"xvo\",\"xvs\",\"xwa\",\"xwc\",\"xwd\",\"xwe\",\"xwg\",\"xwj\",\"xwk\",\"xwl\",\"xwo\",\"xwr\",\"xwt\",\"xww\",\"xxb\",\"xxk\",\"xxm\",\"xxr\",\"xxt\",\"xya\",\"xyb\",\"xyj\",\"xyk\",\"xyl\",\"xyt\",\"xyy\",\"xzh\",\"xzm\",\"xzp\",\"yaa\",\"yab\",\"yac\",\"yad\",\"yae\",\"yaf\",\"yag\",\"yah\",\"yai\",\"yaj\",\"yak\",\"yal\",\"yam\",\"yan\",\"yao\",\"yap\",\"yaq\",\"yar\",\"yas\",\"yat\",\"yau\",\"yav\",\"yaw\",\"yax\",\"yay\",\"yaz\",\"yba\",\"ybb\",\"ybd\",\"ybe\",\"ybh\",\"ybi\",\"ybj\",\"ybk\",\"ybl\",\"ybm\",\"ybn\",\"ybo\",\"ybx\",\"yby\",\"ych\",\"ycl\",\"ycn\",\"ycp\",\"yda\",\"ydd\",\"yde\",\"ydg\",\"ydk\",\"yds\",\"yea\",\"yec\",\"yee\",\"yei\",\"yej\",\"yel\",\"yen\",\"yer\",\"yes\",\"yet\",\"yeu\",\"yev\",\"yey\",\"yga\",\"ygi\",\"ygl\",\"ygm\",\"ygp\",\"ygr\",\"ygs\",\"ygu\",\"ygw\",\"yha\",\"yhd\",\"yhl\",\"yhs\",\"yia\",\"yif\",\"yig\",\"yih\",\"yii\",\"yij\",\"yik\",\"yil\",\"yim\",\"yin\",\"yip\",\"yiq\",\"yir\",\"yis\",\"yit\",\"yiu\",\"yiv\",\"yix\",\"yiy\",\"yiz\",\"yka\",\"ykg\",\"yki\",\"ykk\",\"ykl\",\"ykm\",\"ykn\",\"yko\",\"ykr\",\"ykt\",\"yku\",\"yky\",\"yla\",\"ylb\",\"yle\",\"ylg\",\"yli\",\"yll\",\"ylm\",\"yln\",\"ylo\",\"ylr\",\"ylu\",\"yly\",\"yma\",\"ymb\",\"ymc\",\"ymd\",\"yme\",\"ymg\",\"ymh\",\"ymi\",\"ymk\",\"yml\",\"ymm\",\"ymn\",\"ymo\",\"ymp\",\"ymq\",\"ymr\",\"yms\",\"ymt\",\"ymx\",\"ymz\",\"yna\",\"ynd\",\"yne\",\"yng\",\"ynh\",\"ynk\",\"ynl\",\"ynn\",\"yno\",\"ynq\",\"yns\",\"ynu\",\"yob\",\"yog\",\"yoi\",\"yok\",\"yol\",\"yom\",\"yon\",\"yos\",\"yot\",\"yox\",\"yoy\",\"ypa\",\"ypb\",\"ypg\",\"yph\",\"ypk\",\"ypm\",\"ypn\",\"ypo\",\"ypp\",\"ypz\",\"yra\",\"yrb\",\"yre\",\"yri\",\"yrk\",\"yrl\",\"yrm\",\"yrn\",\"yro\",\"yrs\",\"yrw\",\"yry\",\"ysc\",\"ysd\",\"ysg\",\"ysl\",\"ysn\",\"yso\",\"ysp\",\"ysr\",\"yss\",\"ysy\",\"yta\",\"ytl\",\"ytp\",\"ytw\",\"yty\",\"yua\",\"yub\",\"yuc\",\"yud\",\"yue\",\"yuf\",\"yug\",\"yui\",\"yuj\",\"yuk\",\"yul\",\"yum\",\"yun\",\"yup\",\"yuq\",\"yur\",\"yut\",\"yuu\",\"yuw\",\"yux\",\"yuy\",\"yuz\",\"yva\",\"yvt\",\"ywa\",\"ywg\",\"ywl\",\"ywn\",\"ywq\",\"ywr\",\"ywt\",\"ywu\",\"yww\",\"yxa\",\"yxg\",\"yxl\",\"yxm\",\"yxu\",\"yxy\",\"yyr\",\"yyu\",\"yyz\",\"yzg\",\"yzk\",\"zaa\",\"zab\",\"zac\",\"zad\",\"zae\",\"zaf\",\"zag\",\"zah\",\"zai\",\"zaj\",\"zak\",\"zal\",\"zam\",\"zao\",\"zap\",\"zaq\",\"zar\",\"zas\",\"zat\",\"zau\",\"zav\",\"zaw\",\"zax\",\"zay\",\"zaz\",\"zbc\",\"zbe\",\"zbl\",\"zbt\",\"zbw\",\"zca\",\"zch\",\"zdj\",\"zea\",\"zeg\",\"zeh\",\"zen\",\"zga\",\"zgb\",\"zgh\",\"zgm\",\"zgn\",\"zgr\",\"zhb\",\"zhd\",\"zhi\",\"zhn\",\"zhw\",\"zhx\",\"zia\",\"zib\",\"zik\",\"zil\",\"zim\",\"zin\",\"zir\",\"ziw\",\"ziz\",\"zka\",\"zkb\",\"zkd\",\"zkg\",\"zkh\",\"zkk\",\"zkn\",\"zko\",\"zkp\",\"zkr\",\"zkt\",\"zku\",\"zkv\",\"zkz\",\"zle\",\"zlj\",\"zlm\",\"zln\",\"zlq\",\"zls\",\"zlw\",\"zma\",\"zmb\",\"zmc\",\"zmd\",\"zme\",\"zmf\",\"zmg\",\"zmh\",\"zmi\",\"zmj\",\"zmk\",\"zml\",\"zmm\",\"zmn\",\"zmo\",\"zmp\",\"zmq\",\"zmr\",\"zms\",\"zmt\",\"zmu\",\"zmv\",\"zmw\",\"zmx\",\"zmy\",\"zmz\",\"zna\",\"znd\",\"zne\",\"zng\",\"znk\",\"zns\",\"zoc\",\"zoh\",\"zom\",\"zoo\",\"zoq\",\"zor\",\"zos\",\"zpa\",\"zpb\",\"zpc\",\"zpd\",\"zpe\",\"zpf\",\"zpg\",\"zph\",\"zpi\",\"zpj\",\"zpk\",\"zpl\",\"zpm\",\"zpn\",\"zpo\",\"zpp\",\"zpq\",\"zpr\",\"zps\",\"zpt\",\"zpu\",\"zpv\",\"zpw\",\"zpx\",\"zpy\",\"zpz\",\"zqe\",\"zra\",\"zrg\",\"zrn\",\"zro\",\"zrp\",\"zrs\",\"zsa\",\"zsk\",\"zsl\",\"zsm\",\"zsr\",\"zsu\",\"zte\",\"ztg\",\"ztl\",\"ztm\",\"ztn\",\"ztp\",\"ztq\",\"zts\",\"ztt\",\"ztu\",\"ztx\",\"zty\",\"zua\",\"zuh\",\"zum\",\"zun\",\"zuy\",\"zwa\",\"zxx\",\"zyb\",\"zyg\",\"zyj\",\"zyn\",\"zyp\",\"zza\",\"zzj\"]\n;return axe.utils.validLangs=function(){\"use strict\";return N},commons}()})}(\"object\"==typeof window?window:this);";function runA11yChecks(){return window.axe.run(document,{elementRef:true,runOnly:{type:'tag',values:['wcag2a','wcag2aa']},resultTypes:['violations','inapplicable'],rules:{'tabindex':{enabled:true},'table-fake-caption':{enabled:true},'td-has-header':{enabled:true},'area-alt':{enabled:false},'blink':{enabled:false},'server-side-image-map':{enabled:false}}}).then(axeResult=>{axeResult.violations.forEach(v=>v.nodes.forEach(node=>{node.path=getNodePath(node.element);node.snippet=getOuterHTMLSnippet(node.element);node.element=node.any=node.all=node.none=undefined;}));axeResult={violations:axeResult.violations,notApplicable:axeResult.inapplicable};return axeResult;});function getNodePath(node){function getNodeIndex(node){let index=0;let prevNode;while(prevNode=node.previousSibling){node=prevNode;if(node.nodeType===Node.TEXT_NODE&&node.textContent&&node.textContent.trim().length===0)continue;index++;}
return index;}
const path=[];while(node&&node.parentNode){const index=getNodeIndex(node);path.push([index,node.nodeName]);node=node.parentNode;}
path.reverse();return path.join(',');}
function getOuterHTMLSnippet(el){const reOpeningTag=/^.*?>/;const match=el.outerHTML.match(reOpeningTag);return match&&match[0]||'';}}
class Accessibility extends Gatherer{afterPass(passContext){const driver=passContext.driver;const expression=`(function () {
      ${axeLibSource};
      return (${runA11yChecks.toString()}());
    })()`;return driver.evaluateAsync(expression,{useIsolation:true}).then(returnedValue=>{if(!returnedValue){throw new Error('No axe-core results returned');}
if(!Array.isArray(returnedValue.violations)){throw new Error('Unable to parse axe results'+returnedValue);}
return returnedValue;});}}
module.exports=Accessibility;},{"./gatherer":19}],"../gather/gatherers/cache-contents":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');function getCacheContents(){return caches.keys().then(cacheNames=>Promise.all(cacheNames.map(cacheName=>caches.open(cacheName)))).then(caches=>{const requests=[];return Promise.all(caches.map(cache=>{return cache.keys().then(reqs=>{requests.push(...reqs.map(r=>r.url));});})).then(_=>{return requests;});});}
class CacheContents extends Gatherer{async afterPass(passContext){const driver=passContext.driver;const cacheUrls=await driver.evaluateAsync(`(${getCacheContents.toString()}())`);if(!cacheUrls||!Array.isArray(cacheUrls)){throw new Error('Unable to retrieve cache contents');}
return cacheUrls;}}
module.exports=CacheContents;},{"./gatherer":19}],"../gather/gatherers/chrome-console-messages":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class ChromeConsoleMessages extends Gatherer{constructor(){super();this._logEntries=[];this._onConsoleEntryAdded=this.onConsoleEntry.bind(this);}
onConsoleEntry(entry){this._logEntries.push(entry);}
async beforePass(passContext){const driver=passContext.driver;driver.on('Log.entryAdded',this._onConsoleEntryAdded);await driver.sendCommand('Log.enable');await driver.sendCommand('Log.startViolationsReport',{config:[{name:'discouragedAPIUse',threshold:-1}]});}
async afterPass(passContext){await passContext.driver.sendCommand('Log.stopViolationsReport');await passContext.driver.off('Log.entryAdded',this._onConsoleEntryAdded);await passContext.driver.sendCommand('Log.disable');return this._logEntries;}}
module.exports=ChromeConsoleMessages;},{"./gatherer":19}],"../gather/gatherers/css-usage":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class CSSUsage extends Gatherer{async afterPass(passContext){const driver=passContext.driver;const stylesheets=[];const onStylesheetAdded=sheet=>stylesheets.push(sheet);driver.on('CSS.styleSheetAdded',onStylesheetAdded);await driver.sendCommand('DOM.enable');await driver.sendCommand('CSS.enable');await driver.sendCommand('CSS.startRuleUsageTracking');await driver.evaluateAsync('getComputedStyle(document.body)');driver.off('CSS.styleSheetAdded',onStylesheetAdded);const promises=stylesheets.map(sheet=>{const styleSheetId=sheet.header.styleSheetId;return driver.sendCommand('CSS.getStyleSheetText',{styleSheetId}).then(content=>{return{header:sheet.header,content:content.text};});});const styleSheetInfo=await Promise.all(promises);const ruleUsageResponse=await driver.sendCommand('CSS.stopRuleUsageTracking');await driver.sendCommand('CSS.disable');await driver.sendCommand('DOM.disable');const dedupedStylesheets=new Map(styleSheetInfo.map(sheet=>{return[sheet.content,sheet];}));return{rules:ruleUsageResponse.ruleUsage,stylesheets:Array.from(dedupedStylesheets.values())};}}
module.exports=CSSUsage;},{"./gatherer":19}],"../gather/gatherers/dobetterweb/all-event-listeners":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');const Driver=require('../../driver.js');const Element=require('../../../lib/element.js');class EventListeners extends Gatherer{async listenForScriptParsedEvents(driver){const parsedScripts=new Map();const scriptListener=script=>{parsedScripts.set(script.scriptId,script);};driver.on('Debugger.scriptParsed',scriptListener);await driver.sendCommand('Debugger.enable');await driver.sendCommand('Debugger.disable');driver.off('Debugger.scriptParsed',scriptListener);return parsedScripts;}
_listEventListeners(driver,nodeIdOrObject){let promise;if(typeof nodeIdOrObject==='string'){promise=driver.sendCommand('Runtime.evaluate',{expression:nodeIdOrObject,objectGroup:'event-listeners-gatherer'}).then(result=>result.result);}else{promise=driver.sendCommand('DOM.resolveNode',{nodeId:nodeIdOrObject,objectGroup:'event-listeners-gatherer'}).then(result=>result.object);}
return promise.then(obj=>{const objectId=obj.objectId;const description=obj.description;if(!objectId||!description){return{listeners:[],tagName:''};}
return driver.sendCommand('DOMDebugger.getEventListeners',{objectId}).then(results=>{return{listeners:results.listeners,tagName:description};});});}
getEventListeners(driver,parsedScripts,nodeId){const matchedListeners=[];return this._listEventListeners(driver,nodeId).then(results=>{results.listeners.forEach(listener=>{const script=parsedScripts.get(listener.scriptId);if(script){matchedListeners.push({url:script.url,type:listener.type,handler:listener.handler,objectName:results.tagName,line:listener.lineNumber+1,col:listener.columnNumber+1});}});return matchedListeners;});}
collectListeners(driver,parsedScripts,nodeIds){return Promise.all(nodeIds.map(node=>this.getEventListeners(driver,parsedScripts,node))).then(nestedListeners=>nestedListeners.reduce((prev,curr)=>prev.concat(curr)));}
async afterPass(passContext){const driver=passContext.driver;await passContext.driver.sendCommand('DOM.enable');const parsedScripts=await this.listenForScriptParsedEvents(driver);const elements=await passContext.driver.getElementsInDocument();const elementIds=[...elements.map(el=>el.getNodeId()),'document','window'];const listeners=await this.collectListeners(driver,parsedScripts,elementIds);await passContext.driver.sendCommand('DOM.disable');return listeners;}}
module.exports=EventListeners;},{"../../../lib/element.js":31,"../../driver.js":17,"../gatherer":19}],"../gather/gatherers/dobetterweb/anchors-with-no-rel-noopener":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');const DOMHelpers=require('../../../lib/dom-helpers.js');class AnchorsWithNoRelNoopener extends Gatherer{afterPass(passContext){const expression=`(function() {
      ${DOMHelpers.getElementsInDocumentFnString}; // define function on page
      const selector = 'a[target="_blank"]:not([rel~="noopener"]):not([rel~="noreferrer"])';
      const elements = getElementsInDocument(selector);
      return elements.map(node => ({
        href: node.href,
        rel: node.getAttribute('rel'),
        target: node.getAttribute('target')
      }));
    })()`;return passContext.driver.evaluateAsync(expression);}}
module.exports=AnchorsWithNoRelNoopener;},{"../../../lib/dom-helpers.js":30,"../gatherer":19}],"../gather/gatherers/dobetterweb/appcache":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');class AppCacheManifest extends Gatherer{afterPass(passContext){const driver=passContext.driver;return driver.querySelector('html').then(node=>node&&node.getAttribute('manifest'));}}
module.exports=AppCacheManifest;},{"../gatherer":19}],"../gather/gatherers/dobetterweb/domstats":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');function getOuterHTMLSnippet(element){const reOpeningTag=/^.*?>/;const match=element.outerHTML.match(reOpeningTag);return match&&match[0];}
function createSelectorsLabel(element){let name=element.localName||'';const idAttr=element.getAttribute&&element.getAttribute('id');if(idAttr){name+=`#${idAttr}`;}
if(element.classList){const className=element.classList.toString();if(className){name+=`.${className.trim().replace(/\s+/g,'.')}`;}}else if(ShadowRoot.prototype.isPrototypeOf(element)){name+='#shadow-root';}
return name;}
function elementPathInDOM(element){const visited=new Set();const path=[createSelectorsLabel(element)];let node=element;while(node){visited.add(node);if(ShadowRoot.prototype.isPrototypeOf(node)){const isShadowHost=node.host&&node.localName!=='a';node=isShadowHost?node.host:node.parentElement;}else{const isShadowHost=node.parentNode&&node.parentNode.host&&node.parentNode.localName!=='a';node=isShadowHost?node.parentNode.host:node.parentElement;}
if(visited.has(node)){node=null;}
if(node){path.unshift(createSelectorsLabel(node));}}
return path;}
function getDOMStats(element,deep=true){let deepestNode=null;let maxDepth=0;let maxWidth=0;let parentWithMostChildren=null;const _calcDOMWidthAndHeight=function(element,depth=1){if(depth>maxDepth){deepestNode=element;maxDepth=depth;}
if(element.children.length>maxWidth){parentWithMostChildren=element;maxWidth=element.children.length;}
let child=element.firstElementChild;while(child){_calcDOMWidthAndHeight(child,depth+1);if(deep&&child.shadowRoot){_calcDOMWidthAndHeight(child.shadowRoot,depth+1);}
child=child.nextElementSibling;}
return{maxDepth,maxWidth};};const result=_calcDOMWidthAndHeight(element);return{depth:{max:result.maxDepth,pathToElement:elementPathInDOM(deepestNode),snippet:getOuterHTMLSnippet(deepestNode)},width:{max:result.maxWidth,pathToElement:elementPathInDOM(parentWithMostChildren),snippet:getOuterHTMLSnippet(parentWithMostChildren)}};}
class DOMStats extends Gatherer{afterPass(passContext){const expression=`(function() {
      ${getOuterHTMLSnippet.toString()};
      ${createSelectorsLabel.toString()};
      ${elementPathInDOM.toString()};
      return (${getDOMStats.toString()}(document.documentElement));
    })()`;return passContext.driver.sendCommand('DOM.enable').then(()=>passContext.driver.evaluateAsync(expression,{useIsolation:true})).then(results=>passContext.driver.getElementsInDocument().then(allNodes=>{results.totalDOMNodes=allNodes.length;return passContext.driver.sendCommand('DOM.disable').then(()=>results);}));}}
module.exports=DOMStats;},{"../gatherer":19}],"../gather/gatherers/dobetterweb/js-libraries":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');const libDetectorSource="var UNKNOWN_VERSION = null;\nvar d41d8cd98f00b204e9800998ecf8427e_LibraryDetectorTests = {\n\n    'GWT': {\n        icon: 'gwt',\n        url: 'http://www.gwtproject.org/',\n        test: function(win) {\n            // pretty complicated, many possible tell tales\n            var doc = win.document,\n                hasHistFrame = doc.getElementById('__gwt_historyFrame'),\n                hasGwtUid = doc.gwt_uid,\n                hasBodyListener = doc.body.__listener,\n                hasBodyEventBits = doc.body.__eventBits,\n                hasModules = win.__gwt_activeModules,\n                hasJsonP = win.__gwt_jsonp__,\n                hasRootWinApp = win.__gwt_scriptsLoaded || win.__gwt_stylesLoaded || win.__gwt_activeModules;\n\n            // use the many possible indicators\n            if(hasHistFrame || hasGwtUid || hasBodyListener || hasBodyEventBits || hasModules || hasJsonP || hasRootWinApp) {\n\n                // carefully look at frames, but only if certain is GWT frame\n                var frames = doc.getElementsByTagName('iframe'),\n                    gwtVersion = UNKNOWN_VERSION;\n                for(var n=0; n<frames.length; n++) {\n                    // catch security access errors\n                    try {\n                        var hasNegativeTabIndex = frames[n].tabIndex < 0; // on for GWT\n                        if(hasNegativeTabIndex && frames[n].contentWindow && frames[n].contentWindow.$gwt_version) {\n                            gwtVersion = frames[n].contentWindow.$gwt_version;\n                            break;\n                        }\n                    }\n                    catch(e) {}\n                }\n\n                if(gwtVersion=='0.0.999') {\n                  gwtVersion = 'Google Internal';\n                }\n\n                return { version: gwtVersion };\n            }\n            return false;\n        }\n    },\n\n    'Ink': {\n        icon: 'ink',\n        url: 'http://ink.sapo.pt/',\n        test: function(win) {\n            if (win.Ink && win.Ink.createModule) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Vaadin': {\n        icon: 'vaadin',\n        url: 'http://vaadin.com/home',\n        test: function(win) {\n            if (win.vaadin && win.vaadin.registerWidgetset) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Bootstrap': {\n        icon: 'bootstrap',\n        url: 'http://getbootstrap.com/',\n        npm: 'bootstrap',\n        // look for a function Boostrap has added to jQuery - regex for BS 2 & 3\n        test: function(win) {\n            var jQueryAvailable = win.$ && win.$.fn,\n                RE_PREFIX_V2 = '\\\\$this\\\\.data\\\\((?:\\'|\")',\n                RE_PREFIX_V3 = '\\\\$this\\\\.data\\\\((?:\\'|\")(?:bs\\\\.){1}',\n                bootstrapComponents = [\n                    'affix', 'alert', 'button', 'carousel', 'collapse', 'dropdown',\n                    'modal', 'popover', 'scrollspy', 'tab', 'tooltip'\n                ];\n\n            if(jQueryAvailable) {\n                var bootstrapVersion;\n\n                bootstrapComponents.some(function(component) {\n                    if(win.$.fn[component]) {\n                        // Bootstrap >= 3.2.0 detection\n                        if(win.$.fn[component].Constructor && win.$.fn[component].Constructor.VERSION) {\n                            bootstrapVersion = win.$.fn[component].Constructor.VERSION;\n                            return true;\n                        // Bootstrap >= 2.0.0 and <= 3.1.0 detection\n                        } else if(new RegExp(RE_PREFIX_V3 + component).test(win.$.fn[component].toString())) {\n                            bootstrapVersion = '>= 3.0.0 & <= 3.1.1';\n                            return true;\n                        // Bootstrap < 3.1.0 detection\n                        } else if(new RegExp(RE_PREFIX_V2 + component).test(win.$.fn[component].toString())) {\n                            bootstrapVersion = '>= 2.0.0 & <= 2.3.2';\n                            return true;\n                        }\n                    }\n\n                    return false;\n                });\n\n                if (bootstrapVersion) {\n                    return { version: bootstrapVersion };\n                }\n            }\n\n            return false;\n        }\n    },\n\n    'Zurb': {\n        icon: 'zurb',\n        url: 'http://foundation.zurb.com/',\n        npm: 'foundation-sites',\n        test: function(win) {\n            if(win.Foundation && win.Foundation.Toggler) {\n                return { version: win.Foundation.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Polymer': {\n        icon: 'polymer',\n        url: 'http://www.polymer-project.org/',\n        npm: '@polymer/polymer',\n        test: function(win) {\n            if(win.Polymer && win.Polymer.dom) {\n                return { version: win.Polymer.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Highcharts': {\n        icon: 'highcharts',\n        url: 'http://www.highcharts.com',\n        npm: 'highcharts',\n        test: function(win) {\n            if(win.Highcharts && win.Highcharts.Point) {\n                return { version: win.Highcharts.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'InfoVis': {\n        icon: 'jit',\n        url: 'http://philogb.github.com/jit/',\n        test: function test(win) {\n            if(win.$jit && win.$jit.PieChart) {\n                return { version: win.$jit.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'FlotCharts': {\n        icon: 'icon_48',\n        url: 'http://www.flotcharts.org/',\n        npm: 'flot',\n        test: function(win) {\n            if(win.$ && win.$.plot) {\n                return { version: win.$.plot.version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Blackbird': {\n        icon: 'blackbird',\n        url: 'http://www.gscottolson.com/blackbirdjs/',\n        test: function(win) {\n            if(win.log && win.log.warn) {\n                return { version: UNKNOWN_VERSION}; // no version info\n            }\n            return false;\n        }\n    },\n\n    'CreateJS': {\n        icon: 'createjs',\n        url: 'http://createjs.com/#!/CreateJS',\n        npm: 'createjs',\n        test: function(win) {\n            if(win.createjs && win.createjs.promote) {\n                return { version: UNKNOWN_VERSION}; // no version info available\n            }\n            return false;\n        }\n    },\n\n    'Google Maps': {\n        icon: 'gmaps',\n        url: 'https://developers.google.com/maps/',\n        test: function(win) {\n            if (win.google && win.google.maps) {\n                return { version: win.google.maps.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'jQuery': {\n        icon: 'jquery',\n        url: 'http://jquery.com',\n        npm: 'jquery',\n        test: function(win) {\n            var jq = win.jQuery || win.$;\n            if (jq && jq.fn) {\n                return { version: jq.fn.jquery.replace(/[^\\d+\\.+]/g, '') || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'jQuery UI': {\n        icon: 'jquery_ui',\n        url: 'http://jqueryui.com',\n        npm: 'jquery-ui',\n        test: function(win) {\n            var jq = win.jQuery || win.$ || win.$jq || win.$j;\n            if(jq && jq.fn && jq.fn.jquery && jq.ui) {\n                var plugins = 'accordion,datepicker,dialog,draggable,droppable,progressbar,resizable,selectable,slider,menu,grid,tabs'.split(','), concat = [];\n                for (var i=0; i < plugins.length; i++) { if(jq.ui[plugins[i]]) concat.push(plugins[i].substr(0,1).toUpperCase() + plugins[i].substr(1)); }\n                return { version: jq.ui.version || UNKNOWN_VERSION, details: concat.length ? 'Plugins used: '+concat.join(',') : '' };\n            }\n            return false;\n        }\n    },\n\n    'Dojo': {\n        icon: 'dojo',\n        url: 'http://dojotoolkit.org',\n        npm: 'dojo',\n        test: function(win) {\n            if(win.dojo && win.dojo.delegate) {\n                var version = win.dojo.version ? win.dojo.version.toString() : UNKNOWN_VERSION;\n                return { version: version, details: 'Details: '+(win.dijit ? 'Uses Dijit' : 'none') };\n            }\n            return false;\n        }\n    },\n\n    'Prototype': {\n        icon: 'prototype',\n        url: 'http://prototypejs.org',\n        test: function(win) {\n            if(win.Prototype && win.Prototype.BrowserFeatures) {\n                return { version: win.Prototype.Version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Scriptaculous': {\n        icon: 'scriptaculous',\n        url: 'http://script.aculo.us',\n        test: function(win) {\n            if(win.Scriptaculous && win.Scriptaculous.load) {\n                return { version: win.Scriptaculous.Version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'MooTools': {\n        icon: 'mootools',\n        url: 'http://mootools.net',\n        test: function(win) {\n            if(win.MooTools && win.MooTools.build) {\n                return { version: win.MooTools.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Spry': {\n        icon: 'spry',\n        url: 'http://labs.adobe.com/technologies/spry',\n        test: function(win) {\n            if (win.Spry && win.Spry.Data) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'YUI 2': {\n        icon: 'yui',\n        url: 'http://developer.yahoo.com/yui/2/',\n        test: function(win) {\n            if (win.YAHOO && win.YAHOO.util) {\n                return { version: win.YAHOO.VERSION || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'YUI 3': {\n        icon: 'yui3',\n        url: 'http://yuilibrary.com/',\n        npm: 'yui',\n        test: function(win) {\n            if (win.YUI && win.YUI.Env) {\n                return { version: win.YUI.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Qooxdoo': {\n        icon: 'qooxdoo',\n        url: 'http://qooxdoo.org',\n        npm: 'qooxdoo',\n        test: function(win) {\n            if(win.qx && win.qx.Bootstrap) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Ext JS': {\n        icon: 'extjs',\n        url: 'http://www.sencha.com/products/extjs',\n        test: function(win) {\n            if (win.Ext && win.Ext.versions) {\n                return { version: win.Ext.versions.core.version };\n            }\n            else if(win.Ext) {\n                return { version: win.Ext.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'base2': {\n        icon: 'base2',\n        url: 'http://code.google.com/p/base2',\n        test: function(win) {\n            if(win.base2 && win.base2.dom) {\n                return { version: win.base2.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Closure Library': {\n        icon: 'closure',\n        url: 'https://developers.google.com/closure/library',\n        npm: 'google-closure-library',\n        test: function(win) {\n            if(win.goog && win.goog.provide) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Rapha&euml;l': {\n        icon: 'raphael',\n        url: 'http://dmitrybaranovskiy.github.io/raphael',\n        test: function(win) {\n            if (win.Raphael && win.Raphael.circle) {\n                return { version: win.Raphael.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'React': {\n        icon: 'react',\n        url: 'https://facebook.github.io/react/',\n        npm: 'react',\n        test: function(win) {\n            var reactRoot = document.getElementById('react-root');\n            var altHasReact = document.querySelector('*[data-reactroot]');\n            if (reactRoot && reactRoot.innerText.length > 0 || altHasReact || win.React && win.React.Component) {\n                return { version: win.React && win.React.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Modernizr': {\n        icon: 'modernizr',\n        url: 'http://www.modernizr.com',\n        npm: 'modernizr',\n        test: function(win) {\n            if (win.Modernizr && win.Modernizr.addTest) {\n                return { version: win.Modernizr._version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Processing.js': {\n        icon: 'processingjs',\n        url: 'http://processingjs.org',\n        npm: 'processing-js',\n        test: function(win) {\n            if(win.Processing && win.Processing.box) {\n                return { version: Processing.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Backbone': {\n        icon: 'backbone',\n        url: 'http://backbonejs.org/',\n        npm: 'backbone',\n        test: function(win) {\n            if (win.Backbone && win.Backbone.Model.extend) {\n                return {version: win.Backbone.VERSION || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Leaflet': {\n        icon: 'leaflet',\n        url: 'http://leafletjs.com',\n        npm: 'leaflet',\n        test: function(win) {\n            // Leaflet 3.1 uses L.Marker and L.VERSION; later versions use L.marker and L.version\n            if (win.L && win.L.GeoJSON && (win.L.marker || win.L.Marker)) {\n                return { version: win.L.version || win.L.VERSION || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Mapbox': {\n        icon: 'mapbox',\n        url: 'http://mapbox.com',\n        npm: 'mapbox-gl',\n        test: function(win) {\n            if (win.L && win.L.mapbox && win.L.mapbox.geocoder) {\n                return { version: win.L.mapbox.VERSION || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Lo-Dash': {\n        icon: 'lodash',\n        url: 'http://lodash.com/',\n        npm: 'lodash',\n        test: function(win) {\n            var _ = typeof (_ = win._) == 'function' && _,\n                chain = typeof (chain = _ && _.chain) == 'function' && chain,\n                wrapper = (chain || _ || function() { return {}; })(1);\n\n            if (_ && wrapper.__wrapped__) {\n                return { version: _.VERSION || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Underscore': {\n        icon: 'underscore',\n        url: 'http://underscorejs.org/',\n        npm: 'underscore',\n        test: function(win) {\n            if (win._ && typeof win._.tap === 'function' &&\n                !d41d8cd98f00b204e9800998ecf8427e_LibraryDetectorTests['Lo-Dash'].test(win)) {\n                return {version: win._.VERSION || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Sammy': {\n        icon: 'sammy',\n        url: 'http://sammyjs.org',\n        test: function(win) {\n            if (win.Sammy && win.Sammy.Application.curry) {\n                return {version: win.Sammy.VERSION || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Rico': {\n        icon: 'rico',\n        url: 'http://openrico.sourceforge.net/examples/index.html',\n        test:  function(win) {\n            if (win.Rico && window.Rico.checkIfComplete) {\n                return {version: win.Rico.Version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'MochiKit': {\n        icon: 'mochikit',\n        url: 'https://mochi.github.io/mochikit/',\n        test: function(win) {\n            if (win.MochiKit && win.MochiKit.Base.module) {\n                return {version: MochiKit.VERSION || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'gRapha&euml;l': {\n        icon: 'graphael',\n        url: 'http://g.raphaeljs.com',\n        test: function(win) {\n            if (win.Raphael && win.Raphael.fn.g) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Glow': {\n        icon: 'glow',\n        url: 'http://www.bbc.co.uk/glow',\n        test: function(win) {\n            if (win.gloader && win.gloader.getRequests) {\n                return {version: UNKNOWN_VERSION};\n            }\n            else if (win.glow && win.glow.dom) {\n                return {version: win.glow.VERSION || UNKNOWN_VERSION};\n            }\n            else if (win.Glow) {\n                return {version: win.Glow.version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Socket.IO': {\n        icon: 'socketio', // currently has no icon\n        url: 'http://socket.io',\n        npm: 'socket.io',\n        test: function(win) {\n            // version 0.6.2 uses only io.Socket; more recent versions also have io.sockets\n            if (win.io && (win.io.sockets || win.io.Socket)) {\n                return {version: win.io.version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Mustache': {\n        icon: 'mustache',\n        url: 'http://mustache.github.com',\n        npm: 'mustache',\n        test: function(win) {\n            if (win.Mustache && win.Mustache.to_html) {\n                return {version: win.Mustache.version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Fabric.js': {\n        icon: 'icon_48', // currently has no icon\n        url: 'http://fabricjs.com/',\n        npm: 'fabric',\n        test: function(win) {\n            if (win.fabric && win.fabric.util) {\n                return {version: win.fabric.version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'FuseJS': {\n        icon: 'fusejs',\n        url: 'http://fusejs.io/',\n        npm: 'fuse.js',\n        test: function(win) {\n            if (win.Fuse) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Tween.js': {\n        icon: 'icon_48', // currently has no icon\n        url: 'https://github.com/sole/tween.js',\n        npm: 'tween.js',\n        test: function(win) {\n            if (win.TWEEN && win.TWEEN.Easing) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'SproutCore': {\n       icon: 'sproutcore',\n       url: 'http://www.sproutcore.com',\n       test: function(win) {\n           if (win.SC && win.SC.Application) {\n               return {version: UNKNOWN_VERSION};\n           }\n           return false;\n       }\n    },\n\n    'Zepto.js': {\n       icon: 'zepto',\n       url: 'http://zeptojs.com',\n       npm: 'zepto',\n       test: function(win) {\n           if (win.Zepto && win.Zepto.fn) {\n               return {version: UNKNOWN_VERSION};\n           }\n           return false;\n       }\n    },\n\n    'three.js': {\n       icon: 'icon_48', // currently has no icon\n       url: 'http://threejs.org/',\n       npm: 'three',\n       test: function(win) {\n           if (win.THREE && win.THREE.REVISION) {\n               return {version: 'r' + win.THREE.REVISION};\n           }\n           else if (win.THREE) {\n               return {version: UNKNOWN_VERSION};\n           }\n           return false;\n       }\n    },\n\n    'PhiloGL': {\n       icon: 'philogl',\n       url: 'http://www.senchalabs.org/philogl/',\n       npm: 'philogl',\n       test: function(win) {\n           if (win.PhiloGL && win.PhiloGL.Camera) {\n               return {version: win.PhiloGL.version || UNKNOWN_VERSION};\n           }\n           return false;\n       }\n    },\n\n    'CamanJS': {\n        icon: 'camanjs',\n        url: 'http://camanjs.com/',\n        npm: 'caman',\n        test: function(win) {\n            if (win.Caman && win.Caman.version) {\n                return {version: win.Caman.version.release};\n            }\n            else if (win.Caman) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'yepnope': {\n        icon: 'yepnope',\n        url: 'http://yepnopejs.com/',\n        test: function(win) {\n            if (win.yepnope && win.yepnope.injectJs) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'LABjs': {\n        icon: 'icon_48',\n        url: 'http://labjs.com/',\n        test: function(win) {\n            if (win.$LAB && win.$LAB.setOptions) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Head JS': {\n        icon: 'headjs',\n        url: 'http://headjs.com/',\n        npm: 'headjs',\n        test: function(win) {\n            if (win.head && win.head.js) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'ControlJS': {\n        icon: 'icon_48',\n        url: 'http://stevesouders.com/controljs/',\n        test: function(win) {\n            if (win.CJS && win.CJS.start) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'RequireJS': {\n        icon: 'requirejs',\n        url: 'http://requirejs.org/',\n        npm: 'requirejs',\n        test: function(win) {\n            var req = win.require || win.requirejs;\n            if (req && (req.load || (req.s && req.s.contexts && req.s.contexts._ && (req.s.contexts._.loaded || req.s.contexts._.load)))) {\n                return { version: req.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'RightJS': {\n        icon: 'rightjs',\n        url: 'http://rightjs.org/',\n        test: function(win) {\n            if (win.RightJS && win.RightJS.isNode) {\n                return { version: win.RightJS.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'jQuery Tools': {\n       icon: 'jquerytools',\n       url: 'http://jquerytools.github.io/',\n       test: function(win) {\n            var jq = win.jQuery || win.$;\n            if(jq && jq.tools) {\n               return { version: jq.tools.version || UNKNOWN_VERSION };\n           }\n           return false;\n       }\n    },\n\n    'Pusher': {\n       icon: 'pusher',\n       url: 'http://pusher.com/docs/pusher_js/',\n       npm: 'pusher-js',\n       test: function(win) {\n            if(win.Pusher && win.Pusher.Channel) {\n               return { version: win.Pusher.VERSION || UNKNOWN_VERSION };\n           }\n           return false;\n       }\n    },\n\n    'Paper.js': {\n       icon: 'paperjs',\n       url: 'http://paperjs.org/',\n       npm: 'paper',\n       test: function(win) {\n            if(win.paper && win.paper.Point) {\n               return { version: win.paper.version || UNKNOWN_VERSION };\n           }\n           return false;\n       }\n    },\n\n    'Swiffy': {\n       icon: 'icon_48',\n       url: 'http://www.google.com/doubleclick/studio/swiffy/',\n       test: function(win) {\n            if(win.swiffy && win.swiffy.Stage) {\n               return { version: UNKNOWN_VERSION };\n           }\n           return false;\n       }\n    },\n\n    'Move': {\n       icon: 'move',\n       url: 'https://github.com/rsms/move',\n       npm: 'move',\n       test: function(win) {\n            if(win.move && win.move.compile) {\n               return { version: win.move.version() || UNKNOWN_VERSION };\n           }\n           return false;\n       }\n    },\n\n    'AmplifyJS': {\n       icon: 'amplifyjs',\n       url: 'http://amplifyjs.com/',\n       npm: 'amplifyjs',\n       test: function(win) {\n            if(win.amplify && win.amplify.publish) {\n               return { version: UNKNOWN_VERSION };\n           }\n           return false;\n       }\n    },\n\n    'Popcorn.js': {\n       icon: 'popcornjs',\n       url: 'http://popcornjs.org/',\n       test: function(win) {\n            if (win.Popcorn && win.Popcorn.Events) {\n               return { version: win.Popcorn.version || UNKNOWN_VERSION };\n           }\n           return false;\n       }\n    },\n\n    'D3': {\n        icon: 'd3',\n        url: 'http://d3js.org',\n        npm: 'd3',\n        test: function(win) {\n            if (win.d3 && win.d3.select) {\n                return { version: win.d3.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Handlebars': {\n        icon: 'handlebars',\n        url: 'http://handlebarsjs.com/',\n        npm: 'handlebars',\n        test: function(win) {\n            if(win.Handlebars && win.Handlebars.compile) {\n                return { version: win.Handlebars.VERSION || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Knockout': {\n        icon: 'knockout',\n        url: 'http://knockoutjs.com/',\n        npm: 'knockout',\n        test: function(win) {\n            if (win.ko && win.ko.applyBindings) {\n                return { version: win.ko.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Spine': {\n        icon: 'icon_48',\n        url: 'http://spinejs.com/',\n        test: function(win) {\n            if (win.Spine && win.Spine.Controller) {\n                return {version: win.Spine.version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'jQuery Mobile': {\n        icon: 'jquery_mobile',\n        url: 'http://jquerymobile.com/',\n        npm: 'jquery-mobile',\n        test: function(win) {\n            var jq = win.jQuery || win.$ || win.$jq || win.$j;\n            if(jq && jq.fn && jq.fn.jquery && jq.mobile) {\n                return { version: jq.mobile.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'WebFont Loader': {\n        icon: 'icon_48',\n        url: 'https://github.com/typekit/webfontloader',\n        npm: 'webfontloader',\n        test: function(win) {\n            if(win.WebFont && win.WebFont.load) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Angular': {\n        icon: 'angular',\n        url: 'https://angular.io/',\n        npm: '@angular/core',\n        test: function(win) {\n            var ng = win.document.querySelector('[ng-version]');\n            if (ng) {\n                return { version: ng.getAttribute('ng-version') || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'AngularJS': {\n        icon: 'angularjs',\n        url: 'http://angularjs.org',\n        npm: 'angular',\n        test: function(win) {\n            var ng = win.angular;\n            if(ng && ng.version && ng.version.full) {\n                return { version: ng.version.full };\n            }\n            else if (ng) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Ember.js': {\n        icon: 'emberjs',\n        url: 'http://emberjs.com/',\n        npm: 'ember-source',\n        test: function(win) {\n            var ember = win.Ember || win.Em;\n            if (ember && ember.propertyDidChange) {\n                return { version: ember.VERSION || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Hammer.js': {\n        icon: 'hammerjs',\n        url: 'http://eightmedia.github.io/hammer.js/',\n        npm: 'hammerjs',\n        test: function(win) {\n            if(win.Hammer && win.Hammer.Pinch) {\n                // Hammer.VERSION available in 1.0.10+\n                return { version: win.Hammer.VERSION || \"&lt; 1.0.10\" };\n            }\n            return false;\n        }\n    },\n\n    'Visibility.js': {\n        icon: 'icon_48',\n        url: 'https://github.com/ai/visibilityjs',\n        npm: 'visibilityjs',\n        test: function(win) {\n            if(win.Visibility && win.Visibility.every) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Velocity.js': {\n        icon: 'icon_48',\n        url: 'http://velocityjs.org/',\n        npm: 'velocity-animate',\n        test: function(win) {\n            var jq = win.jQuery || win.$,\n                velocity = jq ? jq.Velocity : win.Velocity;\n\n            if(velocity && velocity.RegisterEffect && velocity.version) {\n                return {\n                    version:\n                        velocity.version.major + \".\" +\n                        velocity.version.minor + \".\" +\n                        velocity.version.patch\n                };\n            }\n            else if (velocity && velocity.RegisterEffect) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'IfVisible.js': {\n        icon: 'icon_48',\n        url: 'http://serkanyersen.github.io/ifvisible.js/',\n        npm: 'ifvisible.js',\n        test: function(win) {\n            var iv = win.ifvisible;\n            if(iv && iv.__ceGUID === \"ifvisible.object.event.identifier\") {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Pixi.js': {\n        icon: 'pixi',\n        url: 'https://github.com/GoodBoyDigital/pixi.js',\n        npm: 'pixi.js',\n        test: function(win) {\n            var px = win.PIXI;\n            if(px && px.WebGLRenderer && px.VERSION) {\n                // version 4.4.3 returns simply \"4.4.3\"; version 1.5.2 returns \"v1.5.2\"\n                return { version: px.VERSION.replace('v', '') || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'DC.js': {\n        icon: 'icon_48',\n        url: 'http://dc-js.github.io/dc.js/',\n        npm: 'dc',\n        test: function(win) {\n            var dc = win.dc;\n            if(dc && dc.registerChart) {\n                return { version: dc.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'GreenSock JS': {\n        icon: 'greensock',\n        url: 'https://github.com/greensock/GreenSock-JS',\n        npm: 'gsap',\n        test: function(win) {\n            if (win.TweenMax && win.TweenMax.pauseAll) {\n                return { version: win.TweenMax.version || UNKNOWN_VERSION }\n            }\n            return false;\n        }\n    },\n    'FastClick': {\n        icon: 'fastclick',\n        url: 'https://github.com/ftlabs/fastclick',\n        npm: 'fastclick',\n        test: function(win) {\n            if(win.FastClick && win.FastClick.notNeeded) {\n                return { version: UNKNOWN_VERSION }\n            }\n            return false;\n        }\n    },\n    'Isotope': {\n        icon: 'isotope',\n        url: 'http://isotope.metafizzy.co/',\n        npm: 'isotope-layout',\n        test: function(win) {\n            if(win.Isotope || (win.$ != null && win.$.Isotope)) {\n                return { version: UNKNOWN_VERSION }\n            }\n            return false;\n        }\n    },\n    'Marionette': {\n        icon: 'marionette',\n        url: 'http://marionettejs.com/',\n        npm: 'backbone.marionette',\n        test: function(win) {\n            if(win.Marionette && win.Marionette.Application) {\n                return { version: win.Marionette.VERSION || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Can': {\n        icon: 'icon_48',\n        url: 'http://canjs.com/',\n        npm: 'can',\n        test: function (win) {\n            if (win.can && win.can.Construct) {\n                return { version: win.can.VERSION || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Vue': {\n        icon: 'vue',\n        url: 'http://vuejs.org/',\n        npm: 'vue',\n        test: function(win) {\n            if (win.Vue && win.Vue.nextTick) {\n                return { version: win.Vue.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Two': {\n        icon: 'two',\n        url: 'https://jonobr1.github.io/two.js',\n        npm: 'two.js',\n        test: function(win) {\n            if (win.Two && win.Two.Utils) {\n                return { version: win.Two.Version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Brewser': {\n        icon: 'brewser',\n        url: 'http://handcraftedldn.github.io/brewser/',\n        npm: 'brewser',\n        test: function(win) {\n            if(win.BREWSER && win.BREWSER.ua) {\n                return { version: BREWSER.VERSION || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Material Design Lite': {\n    \ticon: 'mdl',\n    \turl: 'http://www.getmdl.io/',\n        npm: 'material-design-lite',\n    \ttest: function(win) {\n    \t\tif(win.componentHandler && win.componentHandler.upgradeElement) {\n    \t\t\treturn { version: UNKNOWN_VERSION};\n    \t\t}\n    \t\treturn false;\n    \t}\n    },\n    'Kendo UI': {\n        icon: 'kendoui',\n        url: 'https://github.com/telerik/kendo-ui-core',\n        npm: 'kendo-ui-core',\n        test: function(win) {\n            if (win.kendo && win.kendo.View && win.kendo.View.extend) {\n                return {version: win.kendo.version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n    'Matter.js': {\n        icon: 'matter-js',\n        url: 'http://brm.io/matter-js/',\n        npm: 'matter-js',\n        test: function(win) {\n            if (win.Matter && win.Matter.Engine) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n    'Riot': {\n        icon: 'riot',\n        url: 'http://riotjs.com/',\n        npm: 'riot',\n        test: function(win) {\n            if (win.riot && win.riot.mixin) {\n                return { version: win.riot.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Sea.js': {\n        icon: 'icon_48',\n        url: 'http://seajs.org/',\n        npm: 'seajs',\n        test: function(win) {\n            if(win.seajs && win.seajs.use) {\n                return { version: win.seajs.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Moment.js': {\n        icon: 'momentjs',\n        url: 'http://momentjs.com/',\n        npm: 'moment',\n        test: function(win) {\n            if(win.moment && (win.moment.isMoment || win.moment.lang)) {\n                // version 1.0.0 has neither \"isMoment\" nor \"version\"\n                return { version: win.moment.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Moment Timezone': {\n        icon: 'momentjs',\n        url: 'http://momentjs.com/timezone/',\n        npm: 'moment-timezone',\n        test: function(win) {\n            if (win.moment && win.moment.tz) {\n                return { version: win.moment.tz.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'ScrollMagic': {\n        icon: 'scrollmagic',\n        url: 'http://scrollmagic.io/',\n        npm: 'scrollmagic',\n        test: function(win) {\n            if (win.ScrollMagic && win.ScrollMagic.Controller) {\n                return {version: ScrollMagic.version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n    'SWFObject': {\n        icon: 'icon_48', // currently has no icon\n        url: 'https://github.com/swfobject/swfobject',\n        test: function(win) {\n            if (win.swfobject && win.swfobject.embedSWF) {\n                // 2.x - exact version only for 2.3\n                return { version: win.swfobject.version || UNKNOWN_VERSION };\n            } else if(win.deconcept && win.deconcept.SWFObject) {\n                // 1.x\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'FlexSlider': {\n        icon: 'icon_48', // currently has no icon\n        url: 'https://woocommerce.com/flexslider/',\n        npm: 'flexslider',\n        test: function(win) {\n            var jq = win.jQuery || win.$ || win.$jq || win.$j;\n            if (jq && jq.fn && jq.fn.jquery && jq.flexslider){\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'SPF': {\n        icon: 'icon_48', // currently has no icon\n        url: 'https://youtube.github.io/spfjs/',\n        npm: 'spf',\n        test: function(win) {\n            if (win.spf && win.spf.init) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Numeral.js': {\n        icon: 'icon_48', // currently has no icon\n        url: 'http://numeraljs.com/',\n        npm: 'numeraljs',\n        test: function(win) {\n            if (win.numeral && win.isNumeral) {\n                return { version: win.numeral.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'boomerang.js': {\n        icon: 'icon_48', // currently has no icon\n        url: 'https://soasta.github.io/boomerang/doc/',\n        npm: 'boomerangjs',\n        test: function(win) {\n            if (win.BOOMR && win.BOOMR.utils && win.BOOMR.init) {\n                return { version: win.BOOMR.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Framer': {\n        icon: 'framer',\n        url: 'https://framer.com/',\n        npm: 'framerjs',\n        test: function(win) {\n            if (win.Framer && win.Framer.Layer) {\n                return { version: win.Framer.Version.build || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    }\n};\n";function detectLibraries(){const libraries=[];Object.entries(d41d8cd98f00b204e9800998ecf8427e_LibraryDetectorTests).forEach(([name,lib])=>{try{const result=lib.test(window);if(result){libraries.push({name:name,version:result.version,npmPkgName:lib.npm});}}catch(e){}});return libraries;}
class JSLibraries extends Gatherer{afterPass(passContext){const expression=`(function () {
      ${libDetectorSource};
      return (${detectLibraries.toString()}());
    })()`;return passContext.driver.evaluateAsync(expression);}}
module.exports=JSLibraries;},{"../gatherer":19}],"../gather/gatherers/dobetterweb/optimized-images":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');const URL=require('../../../lib/url-shim');const Sentry=require('../../../lib/sentry');const Driver=require('../../driver.js');const JPEG_QUALITY=0.92;const WEBP_QUALITY=0.85;const MINIMUM_IMAGE_SIZE=4096;function getOptimizedNumBytes(url){return new Promise(function(resolve,reject){const img=new Image();const canvas=document.createElement('canvas');const context=canvas.getContext('2d');if(!context){return reject(new Error('unable to create canvas context'));}
function getTypeStats(type,quality){const dataURI=canvas.toDataURL(type,quality);const base64=dataURI.slice(dataURI.indexOf(',')+1);return{base64:base64.length,binary:atob(base64).length};}
img.addEventListener('error',reject);img.addEventListener('load',()=>{try{canvas.height=img.height;canvas.width=img.width;context.drawImage(img,0,0);const jpeg=getTypeStats('image/jpeg',0.92);const webp=getTypeStats('image/webp',0.85);resolve({jpeg,webp});}catch(err){reject(err);}},false);img.src=url;});}
class OptimizedImages extends Gatherer{static filterImageRequests(pageUrl,networkRecords){const seenUrls=new Set();return networkRecords.reduce((prev,record)=>{if(seenUrls.has(record._url)||!record.finished){return prev;}
seenUrls.add(record._url);const isOptimizableImage=record._resourceType&&record._resourceType._name==='image'&&/image\/(png|bmp|jpeg)/.test(record._mimeType);const isSameOrigin=URL.originsMatch(pageUrl,record._url);const isBase64DataUri=/^data:.{2,40}base64\s*,/.test(record._url);const actualResourceSize=Math.min(record._resourceSize||0,record._transferSize||0);if(isOptimizableImage&&actualResourceSize>MINIMUM_IMAGE_SIZE){prev.push({isSameOrigin,isBase64DataUri,requestId:record._requestId,url:record._url,mimeType:record._mimeType,resourceSize:actualResourceSize});}
return prev;},[]);}
_getEncodedResponse(driver,requestId,encoding){const quality=encoding==='jpeg'?JPEG_QUALITY:WEBP_QUALITY;const params={requestId,encoding,quality,sizeOnly:true};return driver.sendCommand('Audits.getEncodedResponse',params);}
calculateImageStats(driver,networkRecord){return Promise.resolve(networkRecord.requestId).then(requestId=>{if(this._getEncodedResponseUnsupported)return;return this._getEncodedResponse(driver,requestId,'jpeg').then(jpegData=>{return this._getEncodedResponse(driver,requestId,'webp').then(webpData=>{return{fromProtocol:true,originalSize:networkRecord.resourceSize,jpegSize:jpegData.encodedSize,webpSize:webpData.encodedSize};});}).catch(err=>{if(/wasn't found/.test(err.message)){this._getEncodedResponseUnsupported=true;}else{throw err;}});}).then(result=>{if(result)return result;if(!networkRecord.isSameOrigin&&!networkRecord.isBase64DataUri)return null;const script=`(${getOptimizedNumBytes.toString()})(${JSON.stringify(networkRecord.url)})`;return driver.evaluateAsync(script).then(stats=>{if(!stats)return null;const isBase64DataUri=networkRecord.isBase64DataUri;const base64Length=networkRecord.url.length-networkRecord.url.indexOf(',')-1;return{fromProtocol:false,originalSize:isBase64DataUri?base64Length:networkRecord.resourceSize,jpegSize:isBase64DataUri?stats.jpeg.base64:stats.jpeg.binary,webpSize:isBase64DataUri?stats.webp.base64:stats.webp.binary};});});}
async computeOptimizedImages(driver,imageRecords){const results=[];for(const record of imageRecords){try{const stats=await this.calculateImageStats(driver,record);if(stats===null){continue;}
const image=Object.assign({failed:false},stats,record);results.push(image);}catch(err){Sentry.captureException(err,{tags:{gatherer:'OptimizedImages'},extra:{imageUrl:URL.elideDataURI(record.url)},level:'warning'});const imageError=Object.assign({failed:true,errMsg:err.message},record);results.push(imageError);}}
return results;}
afterPass(passContext,loadData){const networkRecords=loadData.networkRecords;const imageRecords=OptimizedImages.filterImageRequests(passContext.url,networkRecords);return Promise.resolve().then(_=>this.computeOptimizedImages(passContext.driver,imageRecords)).then(results=>{const successfulResults=results.filter(result=>!result.failed);if(results.length&&!successfulResults.length){throw new Error('All image optimizations failed');}
return results;});}}
module.exports=OptimizedImages;},{"../../../lib/sentry":39,"../../../lib/url-shim":"url","../../driver.js":17,"../gatherer":19}],"../gather/gatherers/dobetterweb/password-inputs-with-prevented-paste":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');function findPasswordInputsWithPreventedPaste(){function getOuterHTMLSnippet(element){const reOpeningTag=/^.*?>/;const match=element.outerHTML.match(reOpeningTag);return match&&match[0];}
return Array.from(document.querySelectorAll('input[type="password"]')).filter(passwordInput=>!passwordInput.dispatchEvent(new ClipboardEvent('paste',{cancelable:true}))).map(passwordInput=>({snippet:getOuterHTMLSnippet(passwordInput)}));}
class PasswordInputsWithPreventedPaste extends Gatherer{afterPass(passContext){return passContext.driver.evaluateAsync(`(${findPasswordInputsWithPreventedPaste.toString()}())`);}}
module.exports=PasswordInputsWithPreventedPaste;},{"../gatherer":19}],"../gather/gatherers/dobetterweb/response-compression":[function(require,module,exports){(function(Buffer){'use strict';const Gatherer=require('../gatherer');const gzip=require('zlib').gzip;const compressionHeaders=['content-encoding','x-original-content-encoding'];const compressionTypes=['gzip','br','deflate'];const binaryMimeTypes=['image','audio','video'];const CHROME_EXTENSION_PROTOCOL='chrome-extension:';class ResponseCompression extends Gatherer{static filterUnoptimizedResponses(networkRecords){const unoptimizedResponses=[];networkRecords.forEach(record=>{const mimeType=record._mimeType;const resourceType=record._resourceType;const resourceSize=record._resourceSize;const isBinaryResource=mimeType&&binaryMimeTypes.some(type=>mimeType.startsWith(type));const isTextBasedResource=!isBinaryResource&&resourceType&&resourceType.isTextType();const isChromeExtensionResource=record.url.startsWith(CHROME_EXTENSION_PROTOCOL);if(!isTextBasedResource||!resourceSize||!record.finished||isChromeExtensionResource||!record.transferSize||record.statusCode===304){return;}
const isContentEncoded=(record._responseHeaders||[]).find(header=>compressionHeaders.includes(header.name.toLowerCase())&&compressionTypes.includes(header.value));if(!isContentEncoded){unoptimizedResponses.push({requestId:record.requestId,url:record.url,mimeType:mimeType,transferSize:record.transferSize,resourceSize:resourceSize,gzipSize:0});}});return unoptimizedResponses;}
afterPass(passContext,loadData){const networkRecords=loadData.networkRecords;const textRecords=ResponseCompression.filterUnoptimizedResponses(networkRecords);const driver=passContext.driver;return Promise.all(textRecords.map(record=>{return driver.getRequestContent(record.requestId).then(content=>{if(!content){return record;}
return new Promise((resolve,reject)=>{return gzip(content,(err,res)=>{if(err){return reject(err);}
record.gzipSize=Buffer.byteLength(res,'utf8');resolve(record);});});});}));}}
module.exports=ResponseCompression;}).call(this,require("buffer").Buffer);},{"../gatherer":19,"buffer":60,"zlib":57}],"../gather/gatherers/dobetterweb/tags-blocking-first-paint":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');const Driver=require('../../driver.js');function installMediaListener(){window.___linkMediaChanges=[];Object.defineProperty(HTMLLinkElement.prototype,'media',{set:function(val){window.___linkMediaChanges.push({href:this.href,media:val,msSinceHTMLEnd:Date.now()-window.performance.timing.responseEnd,matches:window.matchMedia(val).matches});return this.setAttribute('media',val);}});}
function collectTagsThatBlockFirstPaint(){return new Promise((resolve,reject)=>{try{const tagList=[...document.querySelectorAll('link, head script[src]')].filter(tag=>{if(tag.tagName==='SCRIPT'){const scriptTag=tag;return(!scriptTag.hasAttribute('async')&&!scriptTag.hasAttribute('defer')&&!/^data:/.test(scriptTag.src)&&scriptTag.getAttribute('type')!=='module');}else if(tag.tagName==='LINK'){const linkTag=tag;const blockingStylesheet=linkTag.rel==='stylesheet'&&window.matchMedia(linkTag.media).matches&&!linkTag.disabled;const blockingImport=linkTag.rel==='import'&&!linkTag.hasAttribute('async');return blockingStylesheet||blockingImport;}
return false;}).map(tag=>{return{tagName:tag.tagName,url:tag.tagName==='LINK'?tag.href:tag.src,src:tag.src,href:tag.href,rel:tag.rel,media:tag.media,disabled:tag.disabled,mediaChanges:window.___linkMediaChanges.filter(item=>item.href===tag.href)};});resolve(tagList);}catch(e){const friendly='Unable to gather Scripts/Stylesheets/HTML Imports on the page';reject(new Error(`${friendly}: ${e.message}`));}});}
class TagsBlockingFirstPaint extends Gatherer{static _filteredAndIndexedByUrl(networkRecords){const result={};return networkRecords.reduce((prev,record)=>{if(!record.finished){return prev;}
const isParserGenerated=record._initiator.type==='parser';const isParserScriptOrStyle=/(css|script)/.test(record._mimeType)&&isParserGenerated;const isFailedRequest=record._failed;const isHtml=record._mimeType&&record._mimeType.includes('html');if(isHtml||isParserScriptOrStyle||isFailedRequest&&isParserGenerated){prev[record._url]={isLinkPreload:record.isLinkPreload,transferSize:record._transferSize,startTime:record._startTime,endTime:record._endTime};}
return prev;},result);}
static findBlockingTags(driver,networkRecords){const scriptSrc=`(${collectTagsThatBlockFirstPaint.toString()}())`;const firstRequestEndTime=networkRecords.reduce((min,record)=>Math.min(min,record._endTime),Infinity);return driver.evaluateAsync(scriptSrc).then(tags=>{const requests=TagsBlockingFirstPaint._filteredAndIndexedByUrl(networkRecords);return tags.reduce((prev,tag)=>{const request=requests[tag.url];if(request&&!request.isLinkPreload){const timesResourceBecameNonBlocking=(tag.mediaChanges||[]).filter(change=>!change.matches).map(change=>change.msSinceHTMLEnd);const earliestNonBlockingTime=Math.min(...timesResourceBecameNonBlocking);const lastTimeResourceWasBlocking=Math.max(request.startTime,firstRequestEndTime+earliestNonBlockingTime/1000);prev.push({tag,transferSize:request.transferSize||0,startTime:request.startTime,endTime:Math.min(request.endTime,lastTimeResourceWasBlocking)});requests[tag.url]=null;}
return prev;},[]);});}
beforePass(passContext){return passContext.driver.evaluteScriptOnNewDocument(`(${installMediaListener.toString()})()`);}
afterPass(passContext,loadData){return TagsBlockingFirstPaint.findBlockingTags(passContext.driver,loadData.networkRecords);}}
module.exports=TagsBlockingFirstPaint;},{"../../driver.js":17,"../gatherer":19}],"../gather/gatherers/dobetterweb/websql":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');const Driver=require('../../driver.js');const MAX_WAIT_TIMEOUT=500;class WebSQL extends Gatherer{listenForDatabaseEvents(driver){let timeout;return new Promise((resolve,reject)=>{driver.once('Database.addDatabase',db=>{clearTimeout(timeout);driver.sendCommand('Database.disable').then(_=>resolve(db),reject);});driver.sendCommand('Database.enable').catch(reject);timeout=setTimeout(function(){resolve(null);},MAX_WAIT_TIMEOUT);});}
afterPass(passContext){return this.listenForDatabaseEvents(passContext.driver).then(result=>{return result&&result.database;});}}
module.exports=WebSQL;},{"../../driver.js":17,"../gatherer":19}],"../gather/gatherers/fonts":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');const Sentry=require('../../lib/sentry');const fontFaceDescriptors=['display','family','featureSettings','stretch','style','unicodeRange','variant','weight'];function getAllLoadedFonts(descriptors){const getFont=fontFace=>{const fontRule={src:[]};descriptors.forEach(descriptor=>{fontRule[descriptor]=fontFace[descriptor];});return fontRule;};return document.fonts.ready.then(()=>{return Array.from(document.fonts).filter(fontFace=>fontFace.status==='loaded').map(getFont);});}
function getFontFaceFromStylesheets(){function getSheetsFontFaces(stylesheet){const fontUrlRegex='url\\((?:")([^"]+)(?:"|\')\\)';const fontFaceRules=[];if(stylesheet.cssRules){for(const rule of Array.from(stylesheet.cssRules)){if(rule instanceof CSSFontFaceRule){const fontsObject={display:rule.style.fontDisplay||'auto',family:rule.style.fontFamily?rule.style.fontFamily.replace(/"|'/g,''):'',stretch:rule.style.fontStretch||'normal',style:rule.style.fontStyle||'normal',weight:rule.style.fontWeight||'normal',variant:rule.style.fontVariant||'normal',unicodeRange:rule.style.unicodeRange||'U+0-10FFFF',featureSettings:rule.style.featureSettings||'normal',src:[]};const src=rule.style.src;if(src){const matches=src.match(new RegExp(fontUrlRegex,'g'));if(matches){matches.forEach(match=>{const res=new RegExp(fontUrlRegex).exec(match);if(res){fontsObject.src.push(new URL(res[1],location.href).href);}});}}
fontFaceRules.push(fontsObject);}}}
return fontFaceRules;}
function loadStylesheetWithCORS(oldNode){const newNode=oldNode.cloneNode(true);return new Promise(resolve=>{newNode.addEventListener('load',function onload(){newNode.removeEventListener('load',onload);resolve(getFontFaceFromStylesheets());});newNode.crossOrigin='anonymous';oldNode.parentNode&&oldNode.parentNode.insertBefore(newNode,oldNode);oldNode.remove();});}
const data=[];const corsDataPromises=[];for(const stylesheet of Array.from(document.styleSheets)){try{const cssStylesheet=stylesheet;if(cssStylesheet.cssRules===null&&cssStylesheet.href&&cssStylesheet.ownerNode&&!cssStylesheet.ownerNode.crossOrigin){const ownerLinkEl=cssStylesheet.ownerNode;corsDataPromises.push(loadStylesheetWithCORS(ownerLinkEl));}else{data.push(...getSheetsFontFaces(cssStylesheet));}}catch(err){data.push({err:{message:err.message,stack:err.stack}});}}
return Promise.all(corsDataPromises).then(corsFontFaces=>data.concat(...corsFontFaces));}
class Fonts extends Gatherer{_findSameFontFamily(fontFace,fontFacesList){return fontFacesList.find(fontItem=>{return!fontFaceDescriptors.find(descriptor=>{return fontFace[descriptor]!==fontItem[descriptor];});});}
afterPass(passContext){const driver=passContext.driver;const args=JSON.stringify(fontFaceDescriptors);const fontData=Promise.all([driver.evaluateAsync(`(${getAllLoadedFonts.toString()})(${args})`),driver.evaluateAsync(`(${getFontFaceFromStylesheets.toString()})()`)]);return fontData.then(([loadedFonts,fontsAndErrors])=>{const fontFaces=fontsAndErrors.filter(fontOrError=>{const dataError=fontOrError;if(dataError.err){const err=new Error(dataError.err.message);err.stack=dataError.err.stack;Sentry.captureException(err,{tags:{gatherer:'Fonts'},level:'warning'});return false;}
return true;});return loadedFonts.map(loadedFont=>{const fontFaceItem=this._findSameFontFamily(loadedFont,fontFaces);loadedFont.src=fontFaceItem&&fontFaceItem.src||[];return loadedFont;});});}}
module.exports=Fonts;},{"../../lib/sentry":39,"./gatherer":19}],"../gather/gatherers/html-without-javascript":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');function getBodyText(){const body=document.querySelector('body');return Promise.resolve(body?body.innerText:'');}
class HTMLWithoutJavaScript extends Gatherer{beforePass(passContext){passContext.disableJavaScript=true;}
async afterPass(passContext){passContext.disableJavaScript=false;const bodyText=await passContext.driver.evaluateAsync(`(${getBodyText.toString()}())`);if(typeof bodyText!=='string'){throw new Error('document body innerText returned by protocol was not a string');}
return{value:bodyText};}}
module.exports=HTMLWithoutJavaScript;},{"./gatherer":19}],"../gather/gatherers/http-redirect":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class HTTPRedirect extends Gatherer{constructor(){super();this._preRedirectURL='';}
beforePass(passContext){this._preRedirectURL=passContext.url;passContext.url=this._preRedirectURL.replace(/^https/,'http');}
async afterPass(passContext){passContext.url=this._preRedirectURL;const expression=`new URL(window.location).protocol === 'https:'`;const isHttps=await passContext.driver.evaluateAsync(expression,{useIsolation:true});return{value:isHttps};}}
module.exports=HTTPRedirect;},{"./gatherer":19}],"../gather/gatherers/image-usage":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');const DOMHelpers=require('../../lib/dom-helpers.js');const Driver=require('../driver.js');function collectImageElementInfo(){function getClientRect(element){const clientRect=element.getBoundingClientRect();return{top:clientRect.top,bottom:clientRect.bottom,left:clientRect.left,right:clientRect.right};}
const allElements=getElementsInDocument();const allImageElements=allElements.filter(element=>{return element.localName==='img';});const htmlImages=allImageElements.map(element=>{const computedStyle=window.getComputedStyle(element);return{src:element.currentSrc,width:element.width,height:element.height,clientWidth:element.clientWidth,clientHeight:element.clientHeight,clientRect:getClientRect(element),naturalWidth:element.naturalWidth,naturalHeight:element.naturalHeight,isCss:false,isPicture:!!element.parentElement&&element.parentElement.tagName==='PICTURE',usesObjectFit:computedStyle.getPropertyValue('object-fit')==='cover'||computedStyle.getPropertyValue('object-fit')==='contain'};});const CSS_URL_REGEX=/^url\("([^"]+)"\)$/;const CSS_SIZE_REGEX=/(auto|contain|cover)/;const cssImages=allElements.reduce((images,element)=>{const style=window.getComputedStyle(element);if(!style.backgroundImage||!CSS_URL_REGEX.test(style.backgroundImage)||!style.backgroundSize||!CSS_SIZE_REGEX.test(style.backgroundSize)){return images;}
const imageMatch=style.backgroundImage.match(CSS_URL_REGEX);const url=imageMatch[1];const differentImages=images.filter(image=>image.src!==url);if(images.length-differentImages.length>2){return differentImages;}
images.push({src:url,clientWidth:element.clientWidth,clientHeight:element.clientHeight,clientRect:getClientRect(element),naturalWidth:Number.MAX_VALUE,naturalHeight:Number.MAX_VALUE,isCss:true,isPicture:false,usesObjectFit:false});return images;},[]);return htmlImages.concat(cssImages);}
function determineNaturalSize(url){return new Promise((resolve,reject)=>{const img=new Image();img.addEventListener('error',_=>reject(new Error('determineNaturalSize failed img load')));img.addEventListener('load',()=>{resolve({naturalWidth:img.naturalWidth,naturalHeight:img.naturalHeight});});img.src=url;});}
class ImageUsage extends Gatherer{async fetchElementWithSizeInformation(driver,element){const url=JSON.stringify(element.src);try{const size=await driver.evaluateAsync(`(${determineNaturalSize.toString()})(${url})`);return Object.assign(element,size);}catch(_){return Object.assign(element,{naturalWidth:0,naturalHeight:0});}}
async afterPass(passContext,loadData){const driver=passContext.driver;const indexedNetworkRecords=loadData.networkRecords.reduce((map,record)=>{if(/^image/.test(record._mimeType)&&record.finished){map[record._url]={url:record.url,resourceSize:Math.min(record._resourceSize||0,record.transferSize),startTime:record.startTime,endTime:record.endTime,responseReceivedTime:record._responseReceivedTime,mimeType:record._mimeType};}
return map;},{});const expression=`(function() {
      ${DOMHelpers.getElementsInDocumentFnString}; // define function on page
      return (${collectImageElementInfo.toString()})();
    })()`;const elements=await driver.evaluateAsync(expression);const imageUsage=[];for(let element of elements){element.networkRecord=indexedNetworkRecords[element.src];if((element.isPicture||element.isCss)&&element.networkRecord){element=await this.fetchElementWithSizeInformation(driver,element);}
imageUsage.push(element);}
return imageUsage;}}
module.exports=ImageUsage;},{"../../lib/dom-helpers.js":30,"../driver.js":17,"./gatherer":19}],"../gather/gatherers/js-usage":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class JsUsage extends Gatherer{async beforePass(passContext){await passContext.driver.sendCommand('Profiler.enable');await passContext.driver.sendCommand('Profiler.startPreciseCoverage');}
async afterPass(passContext){const driver=passContext.driver;const coverageResponse=await driver.sendCommand('Profiler.takePreciseCoverage');await driver.sendCommand('Profiler.stopPreciseCoverage');await driver.sendCommand('Profiler.disable');return coverageResponse.result;}}
module.exports=JsUsage;},{"./gatherer":19}],"../gather/gatherers/manifest":[function(require,module,exports){(function(Buffer){'use strict';const Gatherer=require('./gatherer');const manifestParser=require('../../lib/manifest-parser');const BOM_LENGTH=3;const BOM_FIRSTCHAR=65279;class Manifest extends Gatherer{async afterPass(passContext){const manifestPromise=passContext.driver.getAppManifest();const timeoutPromise=new Promise(resolve=>setTimeout(resolve,3000));const response=await Promise.race([manifestPromise,timeoutPromise]);if(!response){return null;}
const isBomEncoded=response.data.charCodeAt(0)===BOM_FIRSTCHAR;if(isBomEncoded){response.data=Buffer.from(response.data).slice(BOM_LENGTH).toString();}
return manifestParser(response.data,response.url,passContext.url);}}
module.exports=Manifest;}).call(this,require("buffer").Buffer);},{"../../lib/manifest-parser":36,"./gatherer":19,"buffer":60}],"../gather/gatherers/mixed-content":[function(require,module,exports){(function(Buffer){'use strict';const Gatherer=require('./gatherer');const URL=require('../../lib/url-shim');const Driver=require('../driver.js');class MixedContent extends Gatherer{constructor(){super();this.ids=new Set();this.url=undefined;this._onRequestIntercepted=undefined;}
upgradeURL(url){const parsedURL=new URL(url);parsedURL.protocol='https:';return parsedURL.href;}
downgradeURL(url){const parsedURL=new URL(url);parsedURL.protocol='http:';return parsedURL.href;}
_getRequestInterceptor(pageUrl,driver){const onRequestIntercepted=event=>{if(new URL(event.request.url).protocol==='http:'&&!URL.equalWithExcludedFragments(event.request.url,pageUrl)&&!this.ids.has(event.interceptionId)){this.ids.add(event.interceptionId);event.request.url=this.upgradeURL(event.request.url);driver.sendCommand('Network.continueInterceptedRequest',{interceptionId:event.interceptionId,rawResponse:Buffer.from(`HTTP/1.1 302 Found\r\nLocation: ${event.request.url}\r\n\r\n`,'utf8').toString('base64')});}else{driver.sendCommand('Network.continueInterceptedRequest',{interceptionId:event.interceptionId});}};return onRequestIntercepted;}
async beforePass(passContext){const driver=passContext.driver;passContext.url=this.downgradeURL(passContext.url);this.url=passContext.url;this._onRequestIntercepted=this._getRequestInterceptor(this.url,driver);await driver.sendCommand('Network.enable');driver.on('Network.requestIntercepted',this._onRequestIntercepted);await driver.sendCommand('Network.setCacheDisabled',{cacheDisabled:true});await driver.sendCommand('Network.setRequestInterception',{patterns:[{urlPattern:'*'}]});}
async afterPass(passContext){const driver=passContext.driver;await driver.sendCommand('Network.setRequestInterception',{patterns:[]});if(this._onRequestIntercepted){driver.off('Network.requestIntercepted',this._onRequestIntercepted);}
await driver.sendCommand('Network.setCacheDisabled',{cacheDisabled:false});return{url:passContext.url};}}
module.exports=MixedContent;}).call(this,require("buffer").Buffer);},{"../../lib/url-shim":"url","../driver.js":17,"./gatherer":19,"buffer":60}],"../gather/gatherers/offline":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');const URL=require('../../lib/url-shim');class Offline extends Gatherer{beforePass(passContext){return passContext.driver.goOffline();}
afterPass(passContext,loadData){const navigationRecord=loadData.networkRecords.filter(record=>{return URL.equalWithExcludedFragments(record._url,passContext.url)&&record._fetchedViaServiceWorker;}).pop();return passContext.driver.goOnline(passContext).then(_=>navigationRecord?navigationRecord.statusCode:-1);}}
module.exports=Offline;},{"../../lib/url-shim":"url","./gatherer":19}],"../gather/gatherers/runtime-exceptions":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class RuntimeExceptions extends Gatherer{constructor(){super();this._exceptions=[];this._onRuntimeExceptionThrown=this.onRuntimeExceptionThrown.bind(this);}
onRuntimeExceptionThrown(entry){this._exceptions.push(entry);}
beforePass(passContext){const driver=passContext.driver;driver.on('Runtime.exceptionThrown',this._onRuntimeExceptionThrown);}
async afterPass(passContext){await passContext.driver.off('Runtime.exceptionThrown',this._onRuntimeExceptionThrown);return this._exceptions;}}
module.exports=RuntimeExceptions;},{"./gatherer":19}],"../gather/gatherers/scripts":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');const WebInspector=require('../../lib/web-inspector');class Scripts extends Gatherer{async afterPass(passContext,loadData){const driver=passContext.driver;const scriptContentMap={};const scriptRecords=loadData.networkRecords.filter(record=>record._resourceType===WebInspector.resourceTypes.Script);for(const record of scriptRecords){try{const content=await driver.getRequestContent(record.requestId);if(content){scriptContentMap[record.requestId]=content;}}catch(e){}}
return scriptContentMap;}}
module.exports=Scripts;},{"../../lib/web-inspector":47,"./gatherer":19}],"../gather/gatherers/seo/canonical":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');class Canonical extends Gatherer{afterPass(passContext){const driver=passContext.driver;return driver.querySelectorAll('head link[rel="canonical" i]').then(nodes=>Promise.all(nodes.map(node=>node.getAttribute('href'))));}}
module.exports=Canonical;},{"../gatherer":19}],"../gather/gatherers/seo/crawlable-links":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');const DOMHelpers=require('../../../lib/dom-helpers.js');class CrawlableLinks extends Gatherer{afterPass(passContext){const expression=`(function() {
      ${DOMHelpers.getElementsInDocumentFnString}; // define function on page
      const selector = 'a[href]:not([rel~="nofollow"])';
      const elements = getElementsInDocument(selector);
      return elements
        .map(node => ({
          href: node.href,
          text: node.innerText
        }));
    })()`;return passContext.driver.evaluateAsync(expression);}}
module.exports=CrawlableLinks;},{"../../../lib/dom-helpers.js":30,"../gatherer":19}],"../gather/gatherers/seo/embedded-content":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');const DOMHelpers=require('../../../lib/dom-helpers.js');class EmbeddedContent extends Gatherer{afterPass(passContext){const expression=`(function() {
      ${DOMHelpers.getElementsInDocumentFnString}; // define function on page
      const selector = 'object, embed, applet';
      const elements = getElementsInDocument(selector);
      return elements
        .map(node => ({
          tagName: node.tagName,
          type: node.getAttribute('type'),
          src: node.getAttribute('src'),
          data: node.getAttribute('data'),
          code: node.getAttribute('code'),
          params: Array.from(node.children)
            .filter(el => el.tagName === 'PARAM')
            .map(el => ({
              name: el.getAttribute('name') || '',
              value: el.getAttribute('value') || '',
            })),
        }));
    })()`;return passContext.driver.evaluateAsync(expression);}}
module.exports=EmbeddedContent;},{"../../../lib/dom-helpers.js":30,"../gatherer":19}],"../gather/gatherers/seo/font-size":[function(require,module,exports){(function(global){'use strict';const CSSMatchedStyles=require('../../../lib/web-inspector').CSSMatchedStyles;const Gatherer=require('../gatherer');const FONT_SIZE_PROPERTY_NAME='font-size';const TEXT_NODE_BLOCK_LIST=new Set(['SCRIPT','STYLE','NOSCRIPT']);const MINIMAL_LEGIBLE_FONT_SIZE_PX=12;const MAX_NODES_VISITED=500;const MAX_NODES_ANALYZED=50;const Driver=require('../../driver.js');function nodeInBody(node){if(!node){return false;}
if(node.nodeName==='BODY'){return true;}
return nodeInBody(node.parentNode);}
function getAllNodesFromBody(driver){return driver.getNodesInDocument().then(nodes=>{const nodeMap=new Map();nodes.forEach(node=>nodeMap.set(node.nodeId,node));nodes.forEach(node=>node.parentNode=nodeMap.get(node.parentId));return nodes.filter(nodeInBody);});}
function getEffectiveRule(property,node,{inlineStyle,attributesStyle,matchedCSSRules,inherited})
{const cssModel={styleSheetHeaderForId:id=>({id})};const nodeType=node.nodeType;node.nodeType=()=>nodeType;const matchedStyles=new CSSMatchedStyles(cssModel,node,inlineStyle,attributesStyle,matchedCSSRules,null,inherited,null);const nodeStyles=matchedStyles.nodeStyles();const matchingRule=nodeStyles.find(style=>style.allProperties.some(item=>item.name===property&&matchedStyles.propertyState(item)!==CSSMatchedStyles.PropertyState.Overloaded));return matchingRule;}
function getNodeTextLength(node){return!node.nodeValue?0:node.nodeValue.trim().length;}
function getFontSizeSourceRule(driver,node){return driver.sendCommand('CSS.getMatchedStylesForNode',{nodeId:node.nodeId}).then(matchedRules=>getEffectiveRule(FONT_SIZE_PROPERTY_NAME,node,matchedRules));}
function getFontSizeInformation(driver,node){return driver.sendCommand('CSS.getComputedStyleForNode',{nodeId:node.parentId}).then(result=>{const{computedStyle}=result;const fontSizeProperty=computedStyle.find(({name})=>name===FONT_SIZE_PROPERTY_NAME);return{fontSize:parseInt(fontSizeProperty.value,10),textLength:getNodeTextLength(node),node:node.parentNode};}).catch(err=>{require('../../../lib/sentry.js').captureException(err);return null;});}
function isNonEmptyTextNode(node){return node.nodeType===global.Node.TEXT_NODE&&!TEXT_NODE_BLOCK_LIST.has(node.parentNode.nodeName)&&getNodeTextLength(node)>0;}
class FontSize extends Gatherer{afterPass(passContext){const stylesheets=new Map();const onStylesheetAdd=sheet=>stylesheets.set(sheet.header.styleSheetId,sheet.header);passContext.driver.on('CSS.styleSheetAdded',onStylesheetAdd);const enableDOM=passContext.driver.sendCommand('DOM.enable');const enableCSS=passContext.driver.sendCommand('CSS.enable');let failingTextLength=0;let visitedTextLength=0;let totalTextLength=0;return Promise.all([enableDOM,enableCSS]).then(()=>getAllNodesFromBody(passContext.driver)).then(nodes=>{const textNodes=nodes.filter(isNonEmptyTextNode);totalTextLength=textNodes.reduce((sum,node)=>sum+=getNodeTextLength(node),0);const nodesToVisit=textNodes.sort((a,b)=>getNodeTextLength(b)-getNodeTextLength(a)).slice(0,MAX_NODES_VISITED);return nodesToVisit;}).then(textNodes=>Promise.all(textNodes.map(node=>getFontSizeInformation(passContext.driver,node)))).then(fontSizeInfo=>{const visitedNodes=fontSizeInfo.filter(Boolean);visitedTextLength=visitedNodes.reduce((sum,{textLength})=>sum+=textLength,0);const failingNodes=visitedNodes.filter(({fontSize})=>fontSize<MINIMAL_LEGIBLE_FONT_SIZE_PX);failingTextLength=failingNodes.reduce((sum,{textLength})=>sum+=textLength,0);return Promise.all(failingNodes.sort((a,b)=>b.textLength-a.textLength).slice(0,MAX_NODES_ANALYZED).map(info=>getFontSizeSourceRule(passContext.driver,info.node).then(sourceRule=>{if(sourceRule){info.cssRule={type:sourceRule.type,range:sourceRule.range,styleSheetId:sourceRule.styleSheetId};if(sourceRule.parentRule){info.cssRule.parentRule={origin:sourceRule.parentRule.origin,selectors:sourceRule.parentRule.selectors};}}
return info;})));}).then(analyzedFailingNodesData=>{passContext.driver.off('CSS.styleSheetAdded',onStylesheetAdd);const analyzedFailingTextLength=analyzedFailingNodesData.reduce((sum,{textLength})=>sum+=textLength,0);analyzedFailingNodesData.filter(data=>data.cssRule&&data.cssRule.styleSheetId).forEach(data=>data.cssRule.stylesheet=stylesheets.get(data.cssRule.styleSheetId));return Promise.all([passContext.driver.sendCommand('DOM.disable'),passContext.driver.sendCommand('CSS.disable')]).then(_=>({analyzedFailingNodesData,analyzedFailingTextLength,failingTextLength,visitedTextLength,totalTextLength}));});}}
module.exports=FontSize;}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"../../../lib/sentry.js":39,"../../../lib/web-inspector":47,"../../driver.js":17,"../gatherer":19}],"../gather/gatherers/seo/hreflang":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');class Hreflang extends Gatherer{afterPass(passContext){const driver=passContext.driver;return driver.querySelectorAll('head link[rel="alternate" i][hreflang]').then(nodes=>Promise.all(nodes.map(node=>Promise.all([node.getAttribute('href'),node.getAttribute('hreflang')])))).then(attributeValues=>attributeValues&&attributeValues.map(values=>{const[href,hreflang]=values;return{href:href||'',hreflang:hreflang||''};}));}}
module.exports=Hreflang;},{"../gatherer":19}],"../gather/gatherers/seo/meta-description":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');class MetaDescription extends Gatherer{afterPass(passContext){const driver=passContext.driver;return driver.querySelector('head meta[name="description" i]').then(node=>node&&node.getAttribute('content'));}}
module.exports=MetaDescription;},{"../gatherer":19}],"../gather/gatherers/seo/meta-robots":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');class MetaRobots extends Gatherer{afterPass(passContext){const driver=passContext.driver;return driver.querySelector('head meta[name="robots" i]').then(node=>node&&node.getAttribute('content'));}}
module.exports=MetaRobots;},{"../gatherer":19}],"../gather/gatherers/seo/robots-txt":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');async function getRobotsTxtContent(){try{const response=await fetch(new URL('/robots.txt',location.href).href);if(!response.ok){return{status:response.status,content:null};}
const content=await response.text();return{status:response.status,content};}catch(_){return{status:null,content:null};}}
class RobotsTxt extends Gatherer{afterPass(passContext){return passContext.driver.evaluateAsync(`(${getRobotsTxtContent.toString()}())`);}}
module.exports=RobotsTxt;},{"../gatherer":19}],"../gather/gatherers/service-worker":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class ServiceWorker extends Gatherer{async beforePass(passContext){const{versions}=await passContext.driver.getServiceWorkerVersions();return{versions};}}
module.exports=ServiceWorker;},{"./gatherer":19}],"../gather/gatherers/start-url":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');const manifestParser=require('../../lib/manifest-parser');const Driver=require('../driver.js');class StartUrl extends Gatherer{afterPass(passContext){const driver=passContext.driver;return driver.goOnline(passContext).then(()=>driver.getAppManifest()).then(response=>driver.goOffline().then(()=>response)).then(response=>response&&manifestParser(response.data,response.url,passContext.url)).then(manifest=>{const startUrlInfo=this._readManifestStartUrl(manifest);if(startUrlInfo.isReadFailure){return{statusCode:-1,debugString:startUrlInfo.reason};}
return this._attemptManifestFetch(passContext.driver,startUrlInfo.startUrl);}).catch(()=>{return{statusCode:-1,debugString:'Unable to fetch start URL via service worker'};});}
_readManifestStartUrl(manifest){if(!manifest||!manifest.value){const detailedMsg=manifest&&manifest.debugString;if(detailedMsg){return{isReadFailure:true,reason:`Error fetching web app manifest: ${detailedMsg}`};}else{return{isReadFailure:true,reason:`No usable web app manifest found on page`};}}
if(manifest.value.start_url.debugString){return{isReadFailure:true,reason:manifest.value.start_url.debugString};}
return{isReadFailure:false,startUrl:manifest.value.start_url.value};}
_attemptManifestFetch(driver,startUrl){const timeoutPromise=new Promise(resolve=>setTimeout(()=>resolve({statusCode:-1,debugString:'Timed out waiting for fetched start_url'}),3000));const fetchPromise=new Promise(resolve=>{driver.on('Network.responseReceived',onResponseReceived);function onResponseReceived(responseEvent){const{response}=responseEvent;if(response.url!==startUrl)return;driver.off('Network.responseReceived',onResponseReceived);if(!response.fromServiceWorker){return resolve({statusCode:-1,debugString:'Unable to fetch start URL via service worker'});}
return resolve({statusCode:response.status});}});return driver.evaluateAsync(`window.location = '${startUrl}'`).then(()=>Promise.race([fetchPromise,timeoutPromise]));}}
module.exports=StartUrl;},{"../../lib/manifest-parser":36,"../driver.js":17,"./gatherer":19}],"../gather/gatherers/theme-color":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class ThemeColor extends Gatherer{async afterPass(passContext){const driver=passContext.driver;const metaEl=await driver.querySelector('head meta[name="theme-color" i]');return metaEl&&metaEl.getAttribute('content');}}
module.exports=ThemeColor;},{"./gatherer":19}],"../gather/gatherers/viewport-dimensions":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');function getViewportDimensions(){return Promise.resolve({innerWidth:window.innerWidth,innerHeight:window.innerHeight,outerWidth:window.outerWidth,outerHeight:window.outerHeight,devicePixelRatio:window.devicePixelRatio});}
class ViewportDimensions extends Gatherer{async afterPass(passContext){const driver=passContext.driver;const dimensions=await driver.evaluateAsync(`(${getViewportDimensions.toString()}())`,{useIsolation:true});const allNumeric=Object.values(dimensions).every(Number.isFinite);if(!allNumeric){const results=JSON.stringify(dimensions);throw new Error(`ViewportDimensions results were not numeric: ${results}`);}
return dimensions;}}
module.exports=ViewportDimensions;},{"./gatherer":19}],"../gather/gatherers/viewport":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class Viewport extends Gatherer{async afterPass(passContext){const driver=passContext.driver;const metaEl=await driver.querySelector('head meta[name="viewport" i]');return metaEl&&metaEl.getAttribute('content');}}
module.exports=Viewport;},{"./gatherer":19}],"./gather/computed/critical-request-chains":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const WebInspector=require('../../lib/web-inspector');const assert=require('assert');class CriticalRequestChains extends ComputedArtifact{get name(){return'CriticalRequestChains';}
static isCritical(request,mainResource){assert.ok(mainResource,'mainResource not provided');if(request._isLinkPreload){return false;}
const resourceTypeCategory=request._resourceType&&request._resourceType._category;const isIframe=request._resourceType===WebInspector.resourceTypes.Document&&request._frameId!==mainResource._frameId;const nonCriticalResourceTypes=[WebInspector.resourceTypes.Image._category,WebInspector.resourceTypes.XHR._category];if(nonCriticalResourceTypes.includes(resourceTypeCategory)||isIframe||request._mimeType&&request._mimeType.startsWith('image/')){return false;}
return['VeryHigh','High','Medium'].includes(request.priority());}
static extractChain(networkRecords,mainResource){networkRecords=networkRecords.filter(req=>req.finished);const requestIdToRequests=new Map();for(const request of networkRecords){requestIdToRequests.set(request.requestId,request);}
const criticalRequests=networkRecords.filter(request=>CriticalRequestChains.isCritical(request,mainResource));const criticalRequestChains={};for(const request of criticalRequests){const ancestors=[];let ancestorRequest=request.initiatorRequest();let node=criticalRequestChains;while(ancestorRequest){const ancestorIsCritical=CriticalRequestChains.isCritical(ancestorRequest,mainResource);if(!ancestorIsCritical||ancestors.includes(ancestorRequest.requestId)){ancestors.length=0;node=undefined;break;}
ancestors.push(ancestorRequest.requestId);ancestorRequest=ancestorRequest.initiatorRequest();}
let ancestor=ancestors.pop();while(ancestor&&node){const parentRequest=requestIdToRequests.get(ancestor);if(!parentRequest){throw new Error(`request with id ${ancestor} not found.`);}
const parentRequestId=parentRequest.requestId;if(!node[parentRequestId]){node[parentRequestId]={request:parentRequest,children:{}};}
ancestor=ancestors.pop();node=node[parentRequestId].children;}
if(!node){continue;}
if(node[request.requestId]){continue;}
node[request.requestId]={request,children:{}};}
return criticalRequestChains;}
async compute_(data,artifacts){const[networkRecords,mainResource]=await Promise.all([artifacts.requestNetworkRecords(data.devtoolsLog),artifacts.requestMainResource(data)]);return CriticalRequestChains.extractChain(networkRecords,mainResource);}}
module.exports=CriticalRequestChains;},{"../../lib/web-inspector":47,"./computed-artifact":11,"assert":53}],"./gather/computed/dtm-model":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const DTM=require('../../lib/traces/devtools-timeline-model');class DevtoolsTimelineModel extends ComputedArtifact{get name(){return'DevtoolsTimelineModel';}
async compute_(trace){return new DTM(trace);}}
module.exports=DevtoolsTimelineModel;},{"../../lib/traces/devtools-timeline-model":43,"./computed-artifact":11}],"./gather/computed/load-simulator":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const constants=require('../../config/constants');const Simulator=require('../../lib/dependency-graph/simulator/simulator');class LoadSimulatorArtifact extends ComputedArtifact{get name(){return'LoadSimulator';}
async compute_(data,artifacts){const{throttlingMethod,throttling}=data.settings;const networkAnalysis=await artifacts.requestNetworkAnalysis(data.devtoolsLog);const options={additionalRttByOrigin:networkAnalysis.additionalRttByOrigin,serverResponseTimeByOrigin:networkAnalysis.serverResponseTimeByOrigin};switch(throttlingMethod){case'provided':options.rtt=networkAnalysis.rtt;options.throughput=networkAnalysis.throughput;options.cpuSlowdownMultiplier=1;options.layoutTaskMultiplier=1;break;case'devtools':if(throttling){options.rtt=throttling.requestLatencyMs/constants.throttling.DEVTOOLS_RTT_ADJUSTMENT_FACTOR;options.throughput=throttling.downloadThroughputKbps*1024/constants.throttling.DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR;}
options.cpuSlowdownMultiplier=1;options.layoutTaskMultiplier=1;break;case'simulate':if(throttling){options.rtt=throttling.rttMs;options.throughput=throttling.throughputKbps*1024;options.cpuSlowdownMultiplier=throttling.cpuSlowdownMultiplier;}
break;default:break;}
return new Simulator(options);}}
module.exports=LoadSimulatorArtifact;},{"../../config/constants":8,"../../lib/dependency-graph/simulator/simulator":28,"./computed-artifact":11}],"./gather/computed/main-resource":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');class MainResource extends ComputedArtifact{get name(){return'MainResource';}
compute_(data,artifacts){const{URL,devtoolsLog}=data;return artifacts.requestNetworkRecords(devtoolsLog).then(requests=>{const mainResource=requests.find(request=>request.url===URL.finalUrl);if(!mainResource){throw new Error('Unable to identify the main resource');}
return mainResource;});}}
module.exports=MainResource;},{"./computed-artifact":11}],"./gather/computed/manifest-values":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const icons=require('../../lib/icons');const PWA_DISPLAY_VALUES=['minimal-ui','fullscreen','standalone'];const SUGGESTED_SHORTNAME_LENGTH=12;class ManifestValues extends ComputedArtifact{get name(){return'ManifestValues';}
static get validityIds(){return['hasManifest','hasParseableManifest'];}
static get manifestChecks(){return[{id:'hasStartUrl',failureText:'Manifest does not contain a `start_url`',validate:manifestValue=>!!manifestValue.start_url.value},{id:'hasIconsAtLeast192px',failureText:'Manifest does not have icons at least 192px',validate:manifestValue=>icons.doExist(manifestValue)&&icons.sizeAtLeast(192,manifestValue).length>0},{id:'hasIconsAtLeast512px',failureText:'Manifest does not have icons at least 512px',validate:manifestValue=>icons.doExist(manifestValue)&&icons.sizeAtLeast(512,manifestValue).length>0},{id:'hasPWADisplayValue',failureText:'Manifest\'s `display` value is not one of: '+PWA_DISPLAY_VALUES.join(' | '),validate:manifestValue=>PWA_DISPLAY_VALUES.includes(manifestValue.display.value)},{id:'hasBackgroundColor',failureText:'Manifest does not have `background_color`',validate:manifestValue=>!!manifestValue.background_color.value},{id:'hasThemeColor',failureText:'Manifest does not have `theme_color`',validate:manifestValue=>!!manifestValue.theme_color.value},{id:'hasShortName',failureText:'Manifest does not have `short_name`',validate:manifestValue=>!!manifestValue.short_name.value},{id:'shortNameLength',failureText:'Manifest `short_name` will be truncated when displayed on the homescreen',validate:manifestValue=>!!manifestValue.short_name.value&&manifestValue.short_name.value.length<=SUGGESTED_SHORTNAME_LENGTH},{id:'hasName',failureText:'Manifest does not have `name`',validate:manifestValue=>!!manifestValue.name.value}];}
async compute_(manifest){let parseFailureReason;if(manifest===null){return{isParseFailure:true,parseFailureReason:'No manifest was fetched',allChecks:[]};}
const manifestValue=manifest.value;if(manifestValue===undefined){return{isParseFailure:true,parseFailureReason:'Manifest failed to parse as valid JSON',allChecks:[]};}
const remainingChecks=ManifestValues.manifestChecks.map(item=>{return{id:item.id,failureText:item.failureText,passing:item.validate(manifestValue)};});return{isParseFailure:false,parseFailureReason,allChecks:remainingChecks};}}
module.exports=ManifestValues;},{"../../lib/icons":35,"./computed-artifact":11}],"./gather/computed/metrics/estimated-input-latency":[function(require,module,exports){'use strict';const MetricArtifact=require('./metric');const LHError=require('../../../lib/errors');const TracingProcessor=require('../../../lib/traces/tracing-processor');const ROLLING_WINDOW_SIZE=5000;class EstimatedInputLatency extends MetricArtifact{get name(){return'EstimatedInputLatency';}
static calculateRollingWindowEIL(events){const candidateStartEvts=events.filter(evt=>evt.duration>=10);let worst90thPercentileLatency=16;for(const startEvt of candidateStartEvts){const latencyPercentiles=TracingProcessor.getRiskToResponsiveness(events,startEvt.start,startEvt.start+ROLLING_WINDOW_SIZE,[0.9]);worst90thPercentileLatency=Math.max(latencyPercentiles[0].time,worst90thPercentileLatency);}
return worst90thPercentileLatency;}
computeObservedMetric(data){const{firstMeaningfulPaint}=data.traceOfTab.timings;if(!firstMeaningfulPaint){throw new LHError(LHError.errors.NO_FMP);}
const events=TracingProcessor.getMainThreadTopLevelEvents(data.traceOfTab,firstMeaningfulPaint).filter(evt=>evt.duration>=1);return Promise.resolve({timing:EstimatedInputLatency.calculateRollingWindowEIL(events)});}}
module.exports=EstimatedInputLatency;},{"../../../lib/errors":33,"../../../lib/traces/tracing-processor":46,"./metric":13}],"./gather/computed/metrics/first-contentful-paint":[function(require,module,exports){'use strict';const MetricArtifact=require('./metric');const LHError=require('../../../lib/errors');class FirstContentfulPaint extends MetricArtifact{get name(){return'FirstContentfulPaint';}
computeObservedMetric(data){const{traceOfTab}=data;if(!traceOfTab.timestamps.firstContentfulPaint){throw new LHError(LHError.errors.NO_FCP);}
return Promise.resolve({timing:traceOfTab.timings.firstContentfulPaint,timestamp:traceOfTab.timestamps.firstContentfulPaint});}}
module.exports=FirstContentfulPaint;},{"../../../lib/errors":33,"./metric":13}],"./gather/computed/metrics/first-cpu-idle":[function(require,module,exports){'use strict';const MetricArtifact=require('./metric');const TracingProcessor=require('../../../lib/traces/tracing-processor');const LHError=require('../../../lib/errors');const LONG_TASK_THRESHOLD=50;const MAX_TASK_CLUSTER_DURATION=250;const MIN_TASK_CLUSTER_PADDING=1000;const MIN_TASK_CLUSTER_FMP_DISTANCE=5000;const MAX_QUIET_WINDOW_SIZE=5000;const EXPONENTIATION_COEFFICIENT=-Math.log(3-1)/15;class FirstCPUIdle extends MetricArtifact{get name(){return'FirstCPUIdle';}
static getRequiredWindowSizeInMs(t){const tInSeconds=t/1000;const exponentiationComponent=Math.exp(EXPONENTIATION_COEFFICIENT*tInSeconds);return(4*exponentiationComponent+1)*1000;}
static getTaskClustersInWindow(tasks,startIndex,windowEnd){const clusters=[];let previousTaskEndTime=-Infinity;let currentCluster=[];const clusteringWindowEnd=windowEnd+MIN_TASK_CLUSTER_PADDING;const isInClusteringWindow=task=>task.start<clusteringWindowEnd;for(let i=startIndex;i<tasks.length;i++){if(!isInClusteringWindow(tasks[i])){break;}
const task=tasks[i];if(task.start-previousTaskEndTime>MIN_TASK_CLUSTER_PADDING){currentCluster=[];clusters.push(currentCluster);}
currentCluster.push(task);previousTaskEndTime=task.end;}
return clusters.map(tasks=>{const start=tasks[0].start;const end=tasks[tasks.length-1].end;const duration=end-start;return{start,end,duration};}).filter(cluster=>cluster.start<windowEnd);}
static findQuietWindow(FMP,traceEnd,longTasks){if(longTasks.length===0||longTasks[0].start>FMP+FirstCPUIdle.getRequiredWindowSizeInMs(0)){return FMP;}
const isTooCloseToFMP=cluster=>cluster.start<FMP+MIN_TASK_CLUSTER_FMP_DISTANCE;const isTooLong=cluster=>cluster.duration>MAX_TASK_CLUSTER_DURATION;const isBadCluster=cluster=>isTooCloseToFMP(cluster)||isTooLong(cluster);for(let i=0;i<longTasks.length;i++){const windowStart=longTasks[i].end;const windowSize=FirstCPUIdle.getRequiredWindowSizeInMs(windowStart-FMP);const windowEnd=windowStart+windowSize;if(windowEnd>traceEnd){throw new LHError(LHError.errors.NO_FCPUI_IDLE_PERIOD);}
if(i+1<longTasks.length&&longTasks[i+1].start-windowStart<=MIN_TASK_CLUSTER_PADDING){continue;}
const taskClusters=FirstCPUIdle.getTaskClustersInWindow(longTasks,i+1,windowEnd);const hasBadTaskClusters=taskClusters.some(isBadCluster);if(!hasBadTaskClusters){return windowStart;}}
throw new LHError(LHError.errors.NO_FCPUI_IDLE_PERIOD);}
computeObservedMetric(data){const{traceOfTab}=data;const navStart=traceOfTab.timestamps.navigationStart;const FMP=traceOfTab.timings.firstMeaningfulPaint;const DCL=traceOfTab.timings.domContentLoaded;const traceEnd=traceOfTab.timings.traceEnd;if(traceEnd-FMP<MAX_QUIET_WINDOW_SIZE){throw new LHError(LHError.errors.FMP_TOO_LATE_FOR_FCPUI);}
if(!FMP||!DCL){throw new LHError(FMP?LHError.errors.NO_DCL:LHError.errors.NO_FMP);}
const longTasksAfterFMP=TracingProcessor.getMainThreadTopLevelEvents(traceOfTab,FMP).filter(evt=>evt.duration>=LONG_TASK_THRESHOLD);const firstInteractive=FirstCPUIdle.findQuietWindow(FMP,traceEnd,longTasksAfterFMP);const valueInMs=Math.max(firstInteractive,DCL);return Promise.resolve({timing:valueInMs,timestamp:valueInMs*1000+navStart});}}
module.exports=FirstCPUIdle;},{"../../../lib/errors":33,"../../../lib/traces/tracing-processor":46,"./metric":13}],"./gather/computed/metrics/first-meaningful-paint":[function(require,module,exports){'use strict';const MetricArtifact=require('./metric');const LHError=require('../../../lib/errors');class FirstMeaningfulPaint extends MetricArtifact{get name(){return'FirstMeaningfulPaint';}
computeObservedMetric(data){const{traceOfTab}=data;if(!traceOfTab.timestamps.firstMeaningfulPaint){throw new LHError(LHError.errors.NO_FMP);}
return Promise.resolve({timing:traceOfTab.timings.firstMeaningfulPaint,timestamp:traceOfTab.timestamps.firstMeaningfulPaint});}}
module.exports=FirstMeaningfulPaint;},{"../../../lib/errors":33,"./metric":13}],"./gather/computed/metrics/interactive":[function(require,module,exports){'use strict';const MetricArtifact=require('./metric');const NetworkRecorder=require('../../../lib/network-recorder');const TracingProcessor=require('../../../lib/traces/tracing-processor');const LHError=require('../../../lib/errors');const REQUIRED_QUIET_WINDOW=5000;const ALLOWED_CONCURRENT_REQUESTS=2;class Interactive extends MetricArtifact{get name(){return'Interactive';}
static _findNetworkQuietPeriods(networkRecords,traceOfTab){const traceEndTsInMs=traceOfTab.timestamps.traceEnd/1000;const filteredNetworkRecords=networkRecords.filter(record=>{return record.finished&&record.requestMethod==='GET'&&!record.failed&&record.statusCode<400;});return NetworkRecorder.findNetworkQuietPeriods(filteredNetworkRecords,ALLOWED_CONCURRENT_REQUESTS,traceEndTsInMs);}
static _findCPUQuietPeriods(longTasks,traceOfTab){const navStartTsInMs=traceOfTab.timestamps.navigationStart/1000;const traceEndTsInMs=traceOfTab.timestamps.traceEnd/1000;if(longTasks.length===0){return[{start:0,end:traceEndTsInMs}];}
const quietPeriods=[];longTasks.forEach((task,index)=>{if(index===0){quietPeriods.push({start:0,end:task.start+navStartTsInMs});}
if(index===longTasks.length-1){quietPeriods.push({start:task.end+navStartTsInMs,end:traceEndTsInMs});}else{quietPeriods.push({start:task.end+navStartTsInMs,end:longTasks[index+1].start+navStartTsInMs});}});return quietPeriods;}
static findOverlappingQuietPeriods(longTasks,networkRecords,traceOfTab){const FcpTsInMs=traceOfTab.timestamps.firstContentfulPaint/1000;const isLongEnoughQuietPeriod=period=>period.end>FcpTsInMs+REQUIRED_QUIET_WINDOW&&period.end-period.start>=REQUIRED_QUIET_WINDOW;const networkQuietPeriods=this._findNetworkQuietPeriods(networkRecords,traceOfTab).filter(isLongEnoughQuietPeriod);const cpuQuietPeriods=this._findCPUQuietPeriods(longTasks,traceOfTab).filter(isLongEnoughQuietPeriod);const cpuQueue=cpuQuietPeriods.slice();const networkQueue=networkQuietPeriods.slice();let cpuCandidate=cpuQueue.shift();let networkCandidate=networkQueue.shift();while(cpuCandidate&&networkCandidate){if(cpuCandidate.start>=networkCandidate.start){if(networkCandidate.end>=cpuCandidate.start+REQUIRED_QUIET_WINDOW){return{cpuQuietPeriod:cpuCandidate,networkQuietPeriod:networkCandidate,cpuQuietPeriods,networkQuietPeriods};}else{networkCandidate=networkQueue.shift();}}else{if(cpuCandidate.end>=networkCandidate.start+REQUIRED_QUIET_WINDOW){return{cpuQuietPeriod:cpuCandidate,networkQuietPeriod:networkCandidate,cpuQuietPeriods,networkQuietPeriods};}else{cpuCandidate=cpuQueue.shift();}}}
throw new LHError(cpuCandidate?LHError.errors.NO_TTI_NETWORK_IDLE_PERIOD:LHError.errors.NO_TTI_CPU_IDLE_PERIOD);}
computeObservedMetric(data){const{traceOfTab,networkRecords}=data;if(!traceOfTab.timestamps.firstContentfulPaint){throw new LHError(LHError.errors.NO_FCP);}
if(!traceOfTab.timestamps.domContentLoaded){throw new LHError(LHError.errors.NO_DCL);}
const longTasks=TracingProcessor.getMainThreadTopLevelEvents(traceOfTab).filter(event=>event.duration>=50);const quietPeriodInfo=Interactive.findOverlappingQuietPeriods(longTasks,networkRecords,traceOfTab);const cpuQuietPeriod=quietPeriodInfo.cpuQuietPeriod;const timestamp=Math.max(cpuQuietPeriod.start,traceOfTab.timestamps.firstContentfulPaint/1000,traceOfTab.timestamps.domContentLoaded/1000)*1000;const timing=(timestamp-traceOfTab.timestamps.navigationStart)/1000;return Promise.resolve({timing,timestamp});}}
module.exports=Interactive;},{"../../../lib/errors":33,"../../../lib/network-recorder":37,"../../../lib/traces/tracing-processor":46,"./metric":13}],"./gather/computed/metrics/lantern-estimated-input-latency":[function(require,module,exports){'use strict';const LanternMetricArtifact=require('./lantern-metric');const Node=require('../../../lib/dependency-graph/node');const EstimatedInputLatency=require('./estimated-input-latency');class LanternEstimatedInputLatency extends LanternMetricArtifact{get name(){return'LanternEstimatedInputLatency';}
get COEFFICIENTS(){return{intercept:0,optimistic:0.4,pessimistic:0.4};}
getOptimisticGraph(dependencyGraph){return dependencyGraph;}
getPessimisticGraph(dependencyGraph){return dependencyGraph;}
getEstimateFromSimulation(simulation,extras){const fmpTimeInMs=extras.optimistic?extras.fmpResult.pessimisticEstimate.timeInMs:extras.fmpResult.optimisticEstimate.timeInMs;const events=LanternEstimatedInputLatency.getEventsAfterFMP(simulation.nodeTimings,fmpTimeInMs);return{timeInMs:EstimatedInputLatency.calculateRollingWindowEIL(events),nodeTimings:simulation.nodeTimings};}
async compute_(data,artifacts){const fmpResult=await artifacts.requestLanternFirstMeaningfulPaint(data);return this.computeMetricWithGraphs(data,artifacts,{fmpResult});}
static getEventsAfterFMP(nodeTimings,fmpTimeInMs){const events=[];for(const[node,timing]of nodeTimings.entries()){if(node.type!==Node.TYPES.CPU)continue;if(!timing.endTime||!timing.startTime)continue;if(timing.endTime<fmpTimeInMs)continue;events.push({start:timing.startTime,end:timing.endTime,duration:timing.endTime-timing.startTime});}
return events;}}
module.exports=LanternEstimatedInputLatency;},{"../../../lib/dependency-graph/node":25,"./estimated-input-latency":"./gather/computed/metrics/estimated-input-latency","./lantern-metric":12}],"./gather/computed/metrics/lantern-first-contentful-paint":[function(require,module,exports){'use strict';const MetricArtifact=require('./lantern-metric');const Node=require('../../../lib/dependency-graph/node');const CPUNode=require('../../../lib/dependency-graph/cpu-node');const NetworkNode=require('../../../lib/dependency-graph/network-node');class FirstContentfulPaint extends MetricArtifact{get name(){return'LanternFirstContentfulPaint';}
get COEFFICIENTS(){return{intercept:600,optimistic:0.6,pessimistic:0.5};}
getOptimisticGraph(dependencyGraph,traceOfTab){const fcp=traceOfTab.timestamps.firstContentfulPaint;const blockingScriptUrls=MetricArtifact.getScriptUrls(dependencyGraph,node=>{return(node.endTime<=fcp&&node.hasRenderBlockingPriority()&&node.initiatorType!=='script');});return dependencyGraph.cloneWithRelationships(node=>{if(node.endTime>fcp&&!node.isMainDocument())return false;if(node.type===Node.TYPES.CPU){return node.isEvaluateScriptFor(blockingScriptUrls);}
const asNetworkNode=node;return asNetworkNode.hasRenderBlockingPriority()&&asNetworkNode.initiatorType!=='script';});}
getPessimisticGraph(dependencyGraph,traceOfTab){const fcp=traceOfTab.timestamps.firstContentfulPaint;const blockingScriptUrls=MetricArtifact.getScriptUrls(dependencyGraph,node=>{return node.endTime<=fcp&&node.hasRenderBlockingPriority();});return dependencyGraph.cloneWithRelationships(node=>{if(node.endTime>fcp&&!node.isMainDocument())return false;if(node.type===Node.TYPES.CPU){return node.isEvaluateScriptFor(blockingScriptUrls);}
return node.hasRenderBlockingPriority();});}}
module.exports=FirstContentfulPaint;},{"../../../lib/dependency-graph/cpu-node":23,"../../../lib/dependency-graph/network-node":24,"../../../lib/dependency-graph/node":25,"./lantern-metric":12}],"./gather/computed/metrics/lantern-first-cpu-idle":[function(require,module,exports){'use strict';const Node=require('../../../lib/dependency-graph/node');const CPUNode=require('../../../lib/dependency-graph/cpu-node');const NetworkNode=require('../../../lib/dependency-graph/network-node');const FirstCPUIdle=require('./first-cpu-idle');const LanternInteractive=require('./lantern-interactive');class LanternFirstCPUIdle extends LanternInteractive{get name(){return'LanternFirstCPUIdle';}
getEstimateFromSimulation(simulation,extras){const fmpTimeInMs=extras.optimistic?extras.fmpResult.optimisticEstimate.timeInMs:extras.fmpResult.pessimisticEstimate.timeInMs;return{timeInMs:LanternFirstCPUIdle.getFirstCPUIdleWindowStart(simulation.nodeTimings,fmpTimeInMs),nodeTimings:simulation.nodeTimings};}
static getFirstCPUIdleWindowStart(nodeTimings,fmpTimeInMs,longTaskLength=50){const longTasks=[];for(const[node,timing]of nodeTimings.entries()){if(node.type!==Node.TYPES.CPU)continue;if(!timing.endTime||!timing.startTime)continue;if(timing.endTime-timing.startTime<longTaskLength)continue;longTasks.push({start:timing.startTime,end:timing.endTime});}
return FirstCPUIdle.findQuietWindow(fmpTimeInMs,Infinity,longTasks);}}
module.exports=LanternFirstCPUIdle;},{"../../../lib/dependency-graph/cpu-node":23,"../../../lib/dependency-graph/network-node":24,"../../../lib/dependency-graph/node":25,"./first-cpu-idle":"./gather/computed/metrics/first-cpu-idle","./lantern-interactive":"./gather/computed/metrics/lantern-interactive"}],"./gather/computed/metrics/lantern-first-meaningful-paint":[function(require,module,exports){'use strict';const MetricArtifact=require('./lantern-metric');const Node=require('../../../lib/dependency-graph/node');const CPUNode=require('../../../lib/dependency-graph/cpu-node');const NetworkNode=require('../../../lib/dependency-graph/network-node');class FirstMeaningfulPaint extends MetricArtifact{get name(){return'LanternFirstMeaningfulPaint';}
get COEFFICIENTS(){return{intercept:900,optimistic:0.45,pessimistic:0.6};}
getOptimisticGraph(dependencyGraph,traceOfTab){const fmp=traceOfTab.timestamps.firstMeaningfulPaint;const blockingScriptUrls=MetricArtifact.getScriptUrls(dependencyGraph,node=>{return(node.endTime<=fmp&&node.hasRenderBlockingPriority()&&node.initiatorType!=='script');});return dependencyGraph.cloneWithRelationships(node=>{if(node.endTime>fmp&&!node.isMainDocument())return false;if(node.type===Node.TYPES.CPU){return node.isEvaluateScriptFor(blockingScriptUrls);}
const asNetworkNode=node;return asNetworkNode.hasRenderBlockingPriority()&&asNetworkNode.initiatorType!=='script';});}
getPessimisticGraph(dependencyGraph,traceOfTab){const fmp=traceOfTab.timestamps.firstMeaningfulPaint;const requiredScriptUrls=MetricArtifact.getScriptUrls(dependencyGraph,node=>{return node.endTime<=fmp&&node.hasRenderBlockingPriority();});return dependencyGraph.cloneWithRelationships(node=>{if(node.endTime>fmp&&!node.isMainDocument())return false;if(node.type===Node.TYPES.CPU){const asCpuNode=node;return asCpuNode.didPerformLayout()||asCpuNode.isEvaluateScriptFor(requiredScriptUrls);}
return node.hasRenderBlockingPriority();});}
async compute_(data,artifacts){const fcpResult=await artifacts.requestLanternFirstContentfulPaint(data);const metricResult=await this.computeMetricWithGraphs(data,artifacts);metricResult.timing=Math.max(metricResult.timing,fcpResult.timing);return metricResult;}}
module.exports=FirstMeaningfulPaint;},{"../../../lib/dependency-graph/cpu-node":23,"../../../lib/dependency-graph/network-node":24,"../../../lib/dependency-graph/node":25,"./lantern-metric":12}],"./gather/computed/metrics/lantern-interactive":[function(require,module,exports){'use strict';const MetricArtifact=require('./lantern-metric');const Node=require('../../../lib/dependency-graph/node');const CPUNode=require('../../../lib/dependency-graph/cpu-node');const NetworkNode=require('../../../lib/dependency-graph/network-node');const WebInspector=require('../../../lib/web-inspector');const CRITICAL_LONG_TASK_THRESHOLD=20;class Interactive extends MetricArtifact{get name(){return'LanternInteractive';}
get COEFFICIENTS(){return{intercept:1600,optimistic:0.6,pessimistic:0.45};}
getOptimisticGraph(dependencyGraph){const minimumCpuTaskDuration=CRITICAL_LONG_TASK_THRESHOLD*1000;return dependencyGraph.cloneWithRelationships(node=>{if(node.type===Node.TYPES.CPU){return node.event.dur>minimumCpuTaskDuration;}
const asNetworkNode=node;const isImage=asNetworkNode.record._resourceType===WebInspector.resourceTypes.Image;const isScript=asNetworkNode.record._resourceType===WebInspector.resourceTypes.Script;return(!isImage&&(isScript||asNetworkNode.record.priority()==='High'||asNetworkNode.record.priority()==='VeryHigh'));});}
getPessimisticGraph(dependencyGraph){return dependencyGraph;}
getEstimateFromSimulation(simulationResult,extras){const lastTaskAt=Interactive.getLastLongTaskEndTime(simulationResult.nodeTimings);const minimumTime=extras.optimistic?extras.fmpResult.optimisticEstimate.timeInMs:extras.fmpResult.pessimisticEstimate.timeInMs;return{timeInMs:Math.max(minimumTime,lastTaskAt),nodeTimings:simulationResult.nodeTimings};}
async compute_(data,artifacts){const fmpResult=await artifacts.requestLanternFirstMeaningfulPaint(data);const metricResult=await this.computeMetricWithGraphs(data,artifacts,{fmpResult});metricResult.timing=Math.max(metricResult.timing,fmpResult.timing);return metricResult;}
static getLastLongTaskEndTime(nodeTimings,duration=50){return Array.from(nodeTimings.entries()).filter(([node,timing])=>{if(node.type!==Node.TYPES.CPU)return false;if(!timing.endTime||!timing.startTime)return false;return timing.endTime-timing.startTime>duration;}).map(([_,timing])=>timing.endTime).reduce((max,x)=>Math.max(max||0,x||0),0);}}
module.exports=Interactive;},{"../../../lib/dependency-graph/cpu-node":23,"../../../lib/dependency-graph/network-node":24,"../../../lib/dependency-graph/node":25,"../../../lib/web-inspector":47,"./lantern-metric":12}],"./gather/computed/metrics/lantern-speed-index":[function(require,module,exports){'use strict';const MetricArtifact=require('./lantern-metric');const Node=require('../../../lib/dependency-graph/node');const CPUNode=require('../../../lib/dependency-graph/cpu-node');class SpeedIndex extends MetricArtifact{get name(){return'LanternSpeedIndex';}
get COEFFICIENTS(){return{intercept:-250,optimistic:1.4,pessimistic:0.65};}
getOptimisticGraph(dependencyGraph){return dependencyGraph;}
getPessimisticGraph(dependencyGraph){return dependencyGraph;}
getEstimateFromSimulation(simulationResult,extras){const fcpTimeInMs=extras.fcpResult.pessimisticEstimate.timeInMs;const estimate=extras.optimistic?extras.speedline.speedIndex:SpeedIndex.computeLayoutBasedSpeedIndex(simulationResult.nodeTimings,fcpTimeInMs);return{timeInMs:estimate,nodeTimings:simulationResult.nodeTimings};}
async compute_(data,artifacts){const speedline=await artifacts.requestSpeedline(data.trace);const fcpResult=await artifacts.requestLanternFirstContentfulPaint(data);const metricResult=await this.computeMetricWithGraphs(data,artifacts,{speedline,fcpResult});metricResult.timing=Math.max(metricResult.timing,fcpResult.timing);return metricResult;}
static computeLayoutBasedSpeedIndex(nodeTimings,fcpTimeInMs){const layoutWeights=[];for(const[node,timing]of nodeTimings.entries()){if(node.type!==Node.TYPES.CPU)continue;if(!timing.startTime||!timing.endTime)continue;const cpuNode=node;if(cpuNode.childEvents.some(x=>x.name==='Layout')){const timingWeight=Math.max(Math.log2(timing.endTime-timing.startTime),0);layoutWeights.push({time:timing.endTime,weight:timingWeight});}}
if(!layoutWeights.length){return fcpTimeInMs;}
const totalWeightedTime=layoutWeights.map(evt=>evt.weight*Math.max(evt.time,fcpTimeInMs)).reduce((a,b)=>a+b,0);const totalWeight=layoutWeights.map(evt=>evt.weight).reduce((a,b)=>a+b,0);return totalWeightedTime/totalWeight;}}
module.exports=SpeedIndex;},{"../../../lib/dependency-graph/cpu-node":23,"../../../lib/dependency-graph/node":25,"./lantern-metric":12}],"./gather/computed/metrics/speed-index":[function(require,module,exports){'use strict';const MetricArtifact=require('./metric');class SpeedIndex extends MetricArtifact{get name(){return'SpeedIndex';}
async computeObservedMetric(data,artifacts){const speedline=await artifacts.requestSpeedline(data.trace);const timing=Math.round(speedline.speedIndex);const timestamp=(timing+speedline.beginning)*1000;return Promise.resolve({timing,timestamp});}}
module.exports=SpeedIndex;},{"./metric":13}],"./gather/computed/network-analysis":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const NetworkAnalyzer=require('../../lib/dependency-graph/simulator/network-analyzer');class NetworkAnalysis extends ComputedArtifact{get name(){return'NetworkAnalysis';}
static computeRTTAndServerResponseTime(records){const rttByOrigin=new Map();for(const[origin,summary]of NetworkAnalyzer.estimateRTTByOrigin(records).entries()){rttByOrigin.set(origin,summary.min);}
const minimumRtt=Math.min(...Array.from(rttByOrigin.values()));const responseTimeSummaries=NetworkAnalyzer.estimateServerResponseTimeByOrigin(records,{rttByOrigin});const additionalRttByOrigin=new Map();const serverResponseTimeByOrigin=new Map();for(const[origin,summary]of responseTimeSummaries.entries()){const rttForOrigin=rttByOrigin.get(origin);additionalRttByOrigin.set(origin,rttForOrigin-minimumRtt);serverResponseTimeByOrigin.set(origin,summary.median);}
return{rtt:minimumRtt,additionalRttByOrigin,serverResponseTimeByOrigin,throughput:0};}
async compute_(devtoolsLog,computedArtifacts){const records=await computedArtifacts.requestNetworkRecords(devtoolsLog);const throughput=await computedArtifacts.requestNetworkThroughput(devtoolsLog);const rttAndServerResponseTime=NetworkAnalysis.computeRTTAndServerResponseTime(records);rttAndServerResponseTime.throughput=throughput*8;return rttAndServerResponseTime;}}
module.exports=NetworkAnalysis;},{"../../lib/dependency-graph/simulator/network-analyzer":27,"./computed-artifact":11}],"./gather/computed/network-records":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const NetworkRecorder=require('../../lib/network-recorder');class NetworkRecords extends ComputedArtifact{get name(){return'NetworkRecords';}
async compute_(devtoolsLog){return NetworkRecorder.recordsFromLogs(devtoolsLog);}}
module.exports=NetworkRecords;},{"../../lib/network-recorder":37,"./computed-artifact":11}],"./gather/computed/network-throughput":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');class NetworkThroughput extends ComputedArtifact{get name(){return'NetworkThroughput';}
static getThroughput(networkRecords){let totalBytes=0;const timeBoundaries=networkRecords.reduce((boundaries,record)=>{const scheme=record.parsedURL&&record.parsedURL.scheme;if(scheme==='data'||record.failed||!record.finished||record.statusCode>300||!record.transferSize){return boundaries;}
totalBytes+=record.transferSize;boundaries.push({time:record._responseReceivedTime,isStart:true});boundaries.push({time:record.endTime,isStart:false});return boundaries;},[]).sort((a,b)=>a.time-b.time);if(!timeBoundaries.length){return Infinity;}
let inflight=0;let currentStart=0;let totalDuration=0;timeBoundaries.forEach(boundary=>{if(boundary.isStart){if(inflight===0){currentStart=boundary.time;}
inflight++;}else{inflight--;if(inflight===0){totalDuration+=boundary.time-currentStart;}}});return totalBytes/totalDuration;}
compute_(devtoolsLog,computedArtifacts){return computedArtifacts.requestNetworkRecords(devtoolsLog).then(NetworkThroughput.getThroughput);}}
module.exports=NetworkThroughput;},{"./computed-artifact":11}],"./gather/computed/page-dependency-graph":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const NetworkNode=require('../../lib/dependency-graph/network-node');const CPUNode=require('../../lib/dependency-graph/cpu-node');const NetworkAnalyzer=require('../../lib/dependency-graph/simulator/network-analyzer');const TracingProcessor=require('../../lib/traces/tracing-processor');const WebInspector=require('../../lib/web-inspector');const Node=require('../../lib/dependency-graph/node.js');const MINIMUM_TASK_DURATION_OF_INTEREST=10;const IGNORED_MIME_TYPES_REGEX=/^video/;class PageDependencyGraphArtifact extends ComputedArtifact{get name(){return'PageDependencyGraph';}
static getNetworkInitiators(record){if(!record._initiator)return[];if(record._initiator.url)return[record._initiator.url];if(record._initiator.type==='script'&&record._initiator.stack){const frames=record._initiator.stack.callFrames;return Array.from(new Set(frames.map(frame=>frame.url))).filter(Boolean);}
return[];}
static getNetworkNodeOutput(networkRecords){const nodes=[];const idToNodeMap=new Map();const urlToNodeMap=new Map();networkRecords.forEach(record=>{if(IGNORED_MIME_TYPES_REGEX.test(record._mimeType))return;while(idToNodeMap.has(record.requestId)){record._requestId+=':duplicate';}
const node=new NetworkNode(record);nodes.push(node);const list=urlToNodeMap.get(record.url)||[];list.push(node);idToNodeMap.set(record.requestId,node);urlToNodeMap.set(record.url,list);});return{nodes,idToNodeMap,urlToNodeMap};}
static getCPUNodes(traceOfTab){const nodes=[];let i=0;const minimumEvtDur=MINIMUM_TASK_DURATION_OF_INTEREST*1000;while(i<traceOfTab.mainThreadEvents.length){const evt=traceOfTab.mainThreadEvents[i];if(!TracingProcessor.isScheduleableTask(evt)||!evt.dur||evt.dur<minimumEvtDur)
{i++;continue;}
const children=[];i++;for(const endTime=evt.ts+evt.dur;i<traceOfTab.mainThreadEvents.length&&traceOfTab.mainThreadEvents[i].ts<endTime;i++)
{children.push(traceOfTab.mainThreadEvents[i]);}
nodes.push(new CPUNode(evt,children));}
return nodes;}
static linkNetworkNodes(rootNode,networkNodeOutput){networkNodeOutput.nodes.forEach(node=>{const initiators=PageDependencyGraphArtifact.getNetworkInitiators(node.record);if(initiators.length){initiators.forEach(initiator=>{const parentCandidates=networkNodeOutput.urlToNodeMap.get(initiator)||[rootNode];const parent=parentCandidates.length===1?parentCandidates[0]:rootNode;node.addDependency(parent);});}else if(node!==rootNode){rootNode.addDependent(node);}
const redirects=Array.from(node.record.redirects||[]);redirects.push(node.record);for(let i=1;i<redirects.length;i++){const redirectNode=networkNodeOutput.idToNodeMap.get(redirects[i-1].requestId);const actualNode=networkNodeOutput.idToNodeMap.get(redirects[i].requestId);if(actualNode&&redirectNode){actualNode.addDependency(redirectNode);}}});}
static linkCPUNodes(rootNode,networkNodeOutput,cpuNodes){function addDependentNetworkRequest(cpuNode,reqId){const networkNode=networkNodeOutput.idToNodeMap.get(reqId);if(!networkNode||networkNode.record._resourceType!==WebInspector.resourceTypes.XHR||networkNode.startTime<=cpuNode.startTime)return;cpuNode.addDependent(networkNode);}
function addDependencyOnUrl(cpuNode,url){if(!url)return;const minimumAllowableTimeSinceNetworkNodeEnd=-100*1000;const candidates=networkNodeOutput.urlToNodeMap.get(url)||[];let minCandidate=null;let minDistance=Infinity;for(const candidate of candidates){if(cpuNode.startTime<=candidate.startTime)return;const distance=cpuNode.startTime-candidate.endTime;if(distance>=minimumAllowableTimeSinceNetworkNodeEnd&&distance<minDistance){minCandidate=candidate;minDistance=distance;}}
if(!minCandidate)return;cpuNode.addDependency(minCandidate);}
const timers=new Map();for(const node of cpuNodes){for(const evt of node.childEvents){if(!evt.args.data)continue;const argsUrl=evt.args.data.url;const stackTraceUrls=(evt.args.data.stackTrace||[]).map(l=>l.url).filter(Boolean);switch(evt.name){case'TimerInstall':timers.set(evt.args.data.timerId,node);stackTraceUrls.forEach(url=>addDependencyOnUrl(node,url));break;case'TimerFire':{const installer=timers.get(evt.args.data.timerId);if(!installer)break;installer.addDependent(node);break;}
case'InvalidateLayout':case'ScheduleStyleRecalculation':stackTraceUrls.forEach(url=>addDependencyOnUrl(node,url));break;case'EvaluateScript':addDependencyOnUrl(node,argsUrl);stackTraceUrls.forEach(url=>addDependencyOnUrl(node,url));break;case'XHRReadyStateChange':if(evt.args.data.readyState!==4)break;addDependencyOnUrl(node,argsUrl);stackTraceUrls.forEach(url=>addDependencyOnUrl(node,url));break;case'FunctionCall':case'v8.compile':addDependencyOnUrl(node,argsUrl);break;case'ParseAuthorStyleSheet':addDependencyOnUrl(node,evt.args.data.styleSheetUrl);break;case'ResourceSendRequest':addDependentNetworkRequest(node,evt.args.data.requestId);stackTraceUrls.forEach(url=>addDependencyOnUrl(node,url));break;}}
if(node.getNumberOfDependencies()===0){node.addDependency(rootNode);}}}
static createGraph(traceOfTab,networkRecords){const networkNodeOutput=PageDependencyGraphArtifact.getNetworkNodeOutput(networkRecords);const cpuNodes=PageDependencyGraphArtifact.getCPUNodes(traceOfTab);const rootRequest=networkRecords.reduce((min,r)=>min.startTime<r.startTime?min:r);const rootNode=networkNodeOutput.idToNodeMap.get(rootRequest.requestId);const mainDocumentRequest=NetworkAnalyzer.findMainDocument(networkRecords);const mainDocumentNode=networkNodeOutput.idToNodeMap.get(mainDocumentRequest.requestId);if(!rootNode||!mainDocumentNode){throw new Error(`${rootNode?'mainDocument':'root'}Node not found.`);}
PageDependencyGraphArtifact.linkNetworkNodes(rootNode,networkNodeOutput);PageDependencyGraphArtifact.linkCPUNodes(rootNode,networkNodeOutput,cpuNodes);mainDocumentNode.setIsMainDocument(true);if(NetworkNode.hasCycle(rootNode)){throw new Error('Invalid dependency graph created, cycle detected');}
return rootNode;}
static printGraph(rootNode,widthInCharacters=100){function padRight(str,target,padChar=' '){return str+padChar.repeat(Math.max(target-str.length,0));}
const nodes=[];rootNode.traverse(node=>nodes.push(node));nodes.sort((a,b)=>a.startTime-b.startTime);const min=nodes[0].startTime;const max=nodes.reduce((max,node)=>Math.max(max,node.endTime),0);const totalTime=max-min;const timePerCharacter=totalTime/widthInCharacters;nodes.forEach(node=>{const offset=Math.round((node.startTime-min)/timePerCharacter);const length=Math.ceil((node.endTime-node.startTime)/timePerCharacter);const bar=padRight('',offset)+padRight('',length,'=');const displayName=node.record?node.record._url:node.type;console.log(padRight(bar,widthInCharacters),`| ${displayName.slice(0,30)}`);});}
async compute_(data,artifacts){const trace=data.trace;const devtoolsLog=data.devtoolsLog;const[traceOfTab,networkRecords]=await Promise.all([artifacts.requestTraceOfTab(trace),artifacts.requestNetworkRecords(devtoolsLog)]);return PageDependencyGraphArtifact.createGraph(traceOfTab,networkRecords);}}
module.exports=PageDependencyGraphArtifact;},{"../../lib/dependency-graph/cpu-node":23,"../../lib/dependency-graph/network-node":24,"../../lib/dependency-graph/node.js":25,"../../lib/dependency-graph/simulator/network-analyzer":27,"../../lib/traces/tracing-processor":46,"../../lib/web-inspector":47,"./computed-artifact":11}],"./gather/computed/pushed-requests":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');class PushedRequests extends ComputedArtifact{get name(){return'PushedRequests';}
compute_(devtoolsLog,artifacts){return artifacts.requestNetworkRecords(devtoolsLog).then(records=>{const pushedRecords=records.filter(r=>r._timing&&!!r._timing.pushStart);return pushedRecords;});}}
module.exports=PushedRequests;},{"./computed-artifact":11}],"./gather/computed/screenshots":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');class ScreenshotFilmstrip extends ComputedArtifact{get name(){return'Screenshots';}
fetchScreenshot(frame){return frame.imageDataPromise().then(data=>'data:image/jpg;base64,'+data);}
compute_(trace,computedArtifacts){return computedArtifacts.requestDevtoolsTimelineModel(trace).then(model=>{const filmStripFrames=model.filmStripModel().frames();const frameFetches=filmStripFrames.map(frame=>this.fetchScreenshot(frame));return Promise.all(frameFetches).then(images=>{const result=filmStripFrames.map((frame,i)=>({timestamp:frame.timestamp,datauri:images[i]}));return result;});});}}
module.exports=ScreenshotFilmstrip;},{"./computed-artifact":11}],"./gather/computed/speedline":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const speedline=require('speedline');const LHError=require('../../lib/errors');class Speedline extends ComputedArtifact{get name(){return'Speedline';}
compute_(trace,computedArtifacts){return computedArtifacts.requestTraceOfTab(trace).then(traceOfTab=>{const traceEvents=trace.traceEvents.slice();const navStart=traceOfTab.timestamps.navigationStart;return speedline(traceEvents,{timeOrigin:navStart,fastMode:true,include:'speedIndex'});}).catch(err=>{if(/No screenshots found in trace/.test(err.message)){throw new LHError(LHError.errors.NO_SCREENSHOTS);}
throw err;}).then(speedline=>{if(speedline.frames.length===0){throw new LHError(LHError.errors.NO_SPEEDLINE_FRAMES);}
if(speedline.speedIndex===0){throw new LHError(LHError.errors.SPEEDINDEX_OF_ZERO);}
return speedline;});}}
module.exports=Speedline;},{"../../lib/errors":33,"./computed-artifact":11,"speedline":152}],"./gather/computed/trace-of-tab":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const log=require('lighthouse-logger');const LHError=require('../../lib/errors');const Sentry=require('../../lib/sentry');const WebInspector=require('../../lib/web-inspector');class TraceOfTab extends ComputedArtifact{get name(){return'TraceOfTab';}
async compute_(trace){const keyEvents=trace.traceEvents.filter(e=>{return e.cat.includes('blink.user_timing')||e.cat.includes('loading')||e.cat.includes('devtools.timeline')||e.name==='TracingStartedInPage';}).stableSort((event0,event1)=>event0.ts-event1.ts);const startedInPageEvt=keyEvents.find(e=>e.name==='TracingStartedInPage');if(!startedInPageEvt)throw new LHError(LHError.errors.NO_TRACING_STARTED);const frameId=startedInPageEvt.args.data.page;const frameEvents=keyEvents.filter(e=>e.args.frame===frameId);const navigationStart=frameEvents.filter(e=>e.name==='navigationStart').pop();if(!navigationStart)throw new LHError(LHError.errors.NO_NAVSTART);const firstPaint=frameEvents.find(e=>e.name==='firstPaint'&&e.ts>navigationStart.ts);const firstContentfulPaint=frameEvents.find(e=>e.name==='firstContentfulPaint'&&e.ts>navigationStart.ts);let firstMeaningfulPaint=frameEvents.find(e=>e.name==='firstMeaningfulPaint'&&e.ts>navigationStart.ts);let fmpFellBack=false;if(!firstMeaningfulPaint){Sentry.captureMessage('No firstMeaningfulPaint found, using fallback',{level:'warning'});const fmpCand='firstMeaningfulPaintCandidate';fmpFellBack=true;log.verbose('trace-of-tab',`No firstMeaningfulPaint found, falling back to last ${fmpCand}`);const lastCandidate=frameEvents.filter(e=>e.name===fmpCand).pop();if(!lastCandidate){log.verbose('trace-of-tab','No `firstMeaningfulPaintCandidate` events found in trace');}
firstMeaningfulPaint=lastCandidate;}
const load=frameEvents.find(e=>e.name==='loadEventEnd'&&e.ts>navigationStart.ts);const domContentLoaded=frameEvents.find(e=>e.name==='domContentLoadedEventEnd'&&e.ts>navigationStart.ts);const processEvents=trace.traceEvents.filter(e=>e.pid===startedInPageEvt.pid).stableSort((event0,event1)=>event0.ts-event1.ts);const mainThreadEvents=processEvents.filter(e=>e.tid===startedInPageEvt.tid);const traceEnd=trace.traceEvents.reduce((max,evt)=>{return max.ts>evt.ts?max:evt;});const metrics={navigationStart,firstPaint,firstContentfulPaint,firstMeaningfulPaint,traceEnd:{ts:traceEnd.ts+(traceEnd.dur||0)},load,domContentLoaded};const timings={};const timestamps={};Object.keys(metrics).forEach(metric=>{timestamps[metric]=metrics[metric]&&metrics[metric].ts;timings[metric]=(timestamps[metric]-navigationStart.ts)/1000;});return{timings:timings,timestamps:timestamps,processEvents,mainThreadEvents,startedInPageEvt,navigationStartEvt:navigationStart,firstPaintEvt:firstPaint,firstContentfulPaintEvt:firstContentfulPaint,firstMeaningfulPaintEvt:firstMeaningfulPaint,loadEvt:load,domContentLoadedEvt:domContentLoaded,fmpFellBack};}}
module.exports=TraceOfTab;},{"../../lib/errors":33,"../../lib/sentry":39,"../../lib/web-inspector":47,"./computed-artifact":11,"lighthouse-logger":143}],1:[function(require,module,exports){'use strict';const Audit=require('../audit');class AxeAudit extends Audit{static audit(artifacts){const notApplicables=artifacts.Accessibility.notApplicable||[];const isNotApplicable=notApplicables.find(result=>result.id===this.meta.name);if(isNotApplicable){return{rawValue:true,notApplicable:true};}
const violations=artifacts.Accessibility.violations||[];const rule=violations.find(result=>result.id===this.meta.name);let items=[];if(rule&&rule.nodes){items=rule.nodes.map(node=>({node:{type:'node',selector:Array.isArray(node.target)?node.target.join(' '):'',path:node.path,snippet:node.snippet}}));}
const headings=[{key:'node',itemType:'node',text:'Failing Elements'}];return{rawValue:typeof rule==='undefined',extendedInfo:{value:rule},details:Audit.makeTableDetails(headings,items)};}}
module.exports=AxeAudit;},{"../audit":2}],2:[function(require,module,exports){'use strict';const statistics=require('../lib/statistics');const Util=require('../report/html/renderer/util');const DEFAULT_PASS='defaultPass';const clampTo2Decimals=val=>Math.round(val*100)/100;class Audit{static get DEFAULT_PASS(){return DEFAULT_PASS;}
static get SCORING_MODES(){return{NUMERIC:'numeric',BINARY:'binary',MANUAL:'manual',INFORMATIVE:'informative',NOT_APPLICABLE:'not-applicable',ERROR:'error'};}
static get meta(){throw new Error('Audit meta information must be overridden.');}
static get defaultOptions(){return{};}
static audit(artifacts,context){throw new Error('audit() method must be overriden');}
static computeLogNormalScore(measuredValue,diminishingReturnsValue,medianValue){const distribution=statistics.getLogNormalDistribution(medianValue,diminishingReturnsValue);let score=distribution.computeComplementaryPercentile(measuredValue);score=Math.min(1,score);score=Math.max(0,score);return clampTo2Decimals(score);}
static generateErrorAuditResult(audit,errorMessage){return Audit.generateAuditResult(audit,{rawValue:null,errorMessage});}
static makeTableDetails(headings,results,summary){if(results.length===0){return{type:'table',headings:[],items:[],summary};}
return{type:'table',headings:headings,items:results,summary};}
static _normalizeAuditScore(audit,result){let score=result.score===undefined?Number(result.rawValue):result.score;if(!Number.isFinite(score))throw new Error(`Invalid score: ${score}`);if(score>1)throw new Error(`Audit score for ${audit.meta.name} is > 1`);if(score<0)throw new Error(`Audit score for ${audit.meta.name} is < 0`);score=clampTo2Decimals(score);const scoreDisplayMode=audit.meta.scoreDisplayMode||Audit.SCORING_MODES.BINARY;return{score,scoreDisplayMode};}
static generateAuditResult(audit,result){if(typeof result.rawValue==='undefined'){throw new Error('generateAuditResult requires a rawValue');}
let{score,scoreDisplayMode}=Audit._normalizeAuditScore(audit,result);if(result.notApplicable){scoreDisplayMode=Audit.SCORING_MODES.NOT_APPLICABLE;result.rawValue=true;}
if(result.errorMessage){scoreDisplayMode=Audit.SCORING_MODES.ERROR;}
let auditDescription=audit.meta.description;if(audit.meta.failureDescription){if(Number(score)<Util.PASS_THRESHOLD){auditDescription=audit.meta.failureDescription;}}
if(scoreDisplayMode!==Audit.SCORING_MODES.BINARY&&scoreDisplayMode!==Audit.SCORING_MODES.NUMERIC){score=null;}
return{id:audit.meta.name,title:auditDescription,description:audit.meta.helpText,score,scoreDisplayMode,rawValue:result.rawValue,displayValue:result.displayValue,explanation:result.explanation,errorMessage:result.errorMessage,warnings:result.warnings,details:result.details};}}
module.exports=Audit;},{"../lib/statistics":40,"../report/html/renderer/util":48}],3:[function(require,module,exports){'use strict';const Audit=require('../audit');const Interactive=require('../../gather/computed/metrics/lantern-interactive');const Simulator=require('../../lib/dependency-graph/simulator/simulator');const Node=require('../../lib/dependency-graph/node.js');const NetworkNode=require('../../lib/dependency-graph/network-node.js');const KB_IN_BYTES=1024;const WASTED_MS_FOR_AVERAGE=300;const WASTED_MS_FOR_POOR=750;class UnusedBytes extends Audit{static scoreForWastedMs(wastedMs){if(wastedMs===0)return 1;else
if(wastedMs<WASTED_MS_FOR_AVERAGE)return 0.9;else
if(wastedMs<WASTED_MS_FOR_POOR)return 0.65;else
return 0;}
static bytesToMs(bytes,networkThroughput){const milliseconds=bytes/networkThroughput*1000;return milliseconds;}
static estimateTransferSize(networkRecord,totalBytes,resourceType,compressionRatio=0.5){if(!networkRecord){return Math.round(totalBytes*compressionRatio);}else if(networkRecord._resourceType&&networkRecord._resourceType._name===resourceType){return networkRecord._transferSize||0;}else{const transferSize=networkRecord._transferSize||0;const resourceSize=networkRecord._resourceSize;const compressionRatio=resourceSize!==undefined?transferSize/resourceSize:1;return Math.round(totalBytes*compressionRatio);}}
static audit(artifacts,context){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const settings=context&&context.settings||{};const simulatorOptions={devtoolsLog,settings};return artifacts.requestNetworkRecords(devtoolsLog).then(networkRecords=>Promise.all([this.audit_(artifacts,networkRecords,context),artifacts.requestPageDependencyGraph({trace,devtoolsLog}),artifacts.requestLoadSimulator(simulatorOptions)])).then(([result,graph,simulator])=>this.createAuditProduct(result,graph,simulator));}
static computeWasteWithTTIGraph(results,graph,simulator,options){options=Object.assign({includeLoad:true},options);const simulationBeforeChanges=simulator.simulate(graph);const resultsByUrl=new Map();for(const result of results){resultsByUrl.set(result.url,result);}
const originalTransferSizes=new Map();graph.traverse(node=>{if(node.type!=='network')return;const networkNode=node;const result=resultsByUrl.get(networkNode.record.url);if(!result)return;const original=networkNode.record.transferSize;originalTransferSizes.set(networkNode.record.requestId,original);const wastedBytes=result.wastedBytes;networkNode.record._transferSize=Math.max(original-wastedBytes,0);});const simulationAfterChanges=simulator.simulate(graph);graph.traverse(node=>{if(node.type!=='network')return;const networkNode=node;const originalTransferSize=originalTransferSizes.get(networkNode.record.requestId);if(originalTransferSize===undefined)return;networkNode.record._transferSize=originalTransferSize;});const savingsOnOverallLoad=simulationBeforeChanges.timeInMs-simulationAfterChanges.timeInMs;const savingsOnTTI=Interactive.getLastLongTaskEndTime(simulationBeforeChanges.nodeTimings)-
Interactive.getLastLongTaskEndTime(simulationAfterChanges.nodeTimings);let savings=savingsOnTTI;if(options.includeLoad)savings=Math.max(savings,savingsOnOverallLoad);return Math.round(Math.max(savings,0)/10)*10;}
static createAuditProduct(result,graph,simulator){const results=result.results.sort((itemA,itemB)=>itemB.wastedBytes-itemA.wastedBytes);const wastedBytes=results.reduce((sum,item)=>sum+item.wastedBytes,0);const wastedKb=Math.round(wastedBytes/KB_IN_BYTES);const wastedMs=this.computeWasteWithTTIGraph(results,graph,simulator);let displayValue=result.displayValue||'';if(typeof result.displayValue==='undefined'&&wastedKb){displayValue=['Potential savings of %d\xa0KB',wastedKb];}
const summary={wastedMs,wastedBytes};const details=Audit.makeTableDetails(result.headings,results,summary);return{explanation:result.explanation,warnings:result.warnings,displayValue,rawValue:wastedMs,score:UnusedBytes.scoreForWastedMs(wastedMs),extendedInfo:{value:{wastedMs,wastedKb,results}},details};}
static audit_(artifacts,networkRecords,context){throw new Error('audit_ unimplemented');}}
module.exports=UnusedBytes;},{"../../gather/computed/metrics/lantern-interactive":"./gather/computed/metrics/lantern-interactive","../../lib/dependency-graph/network-node.js":24,"../../lib/dependency-graph/node.js":25,"../../lib/dependency-graph/simulator/simulator":28,"../audit":2}],4:[function(require,module,exports){'use strict';const Audit=require('../audit');class ManualAudit extends Audit{static get partialMeta(){return{scoreDisplayMode:Audit.SCORING_MODES.MANUAL,requiredArtifacts:[]};}
static audit(){return{rawValue:false};}}
module.exports=ManualAudit;},{"../audit":2}],5:[function(require,module,exports){'use strict';const Audit=require('./audit');class MultiCheckAudit extends Audit{static audit(artifacts){return Promise.resolve(this.audit_(artifacts)).then(result=>this.createAuditProduct(result));}
static createAuditProduct(result){const extendedInfo={value:result};if(result.failures.length>0){return{rawValue:false,explanation:`Failures: ${result.failures.join(',\n')}.`,extendedInfo};}
return{rawValue:true,extendedInfo,warnings:result.warnings};}
static audit_(artifacts){throw new Error('audit_ unimplemented');}}
module.exports=MultiCheckAudit;},{"./audit":2}],6:[function(require,module,exports){'use strict';const Audit=require('./audit');class ViolationAudit extends Audit{static getViolationResults(artifacts,pattern){const seen=new Set();return artifacts.ChromeConsoleMessages.map(message=>message.entry).filter(entry=>entry.url&&entry.source==='violation'&&pattern.test(entry.text)).map(entry=>({label:`line: ${entry.lineNumber}`,url:entry.url})).filter(entry=>{const key=`${entry.url}!${entry.label}`;if(seen.has(key))return false;seen.add(key);return true;});}}
module.exports=ViolationAudit;},{"./audit":2}],7:[function(require,module,exports){(function(__dirname){'use strict';const defaultConfigPath='./default-config.js';const defaultConfig=require('./default-config.js');const fullConfig=require('./full-config.js');const constants=require('./constants');const isDeepEqual=require('lodash.isequal');const log=require('lighthouse-logger');const path=require('path');const Audit=require('../audits/audit');const Runner=require('../runner');function validatePasses(passes,audits){if(!Array.isArray(passes)){return;}
const requiredGatherers=Config.getGatherersNeededByAudits(audits);passes.forEach(pass=>{pass.gatherers.forEach(gathererDefn=>{const gatherer=gathererDefn.instance||gathererDefn.implementation;const isGatherRequiredByAudits=requiredGatherers.has(gatherer.name);if(isGatherRequiredByAudits===false){const msg=`${gatherer.name} gatherer requested, however no audit requires it.`;log.warn('config',msg);}});});const usedNames=new Set();passes.forEach(pass=>{const passName=pass.passName;if(usedNames.has(passName)){throw new Error(`Passes must have unique names (repeated passName: ${passName}.`);}
usedNames.add(passName);});}
function validateCategories(categories,audits,groups){if(!categories){return;}
Object.keys(categories).forEach(categoryId=>{categories[categoryId].auditRefs.forEach((auditRef,index)=>{if(!auditRef.id){throw new Error(`missing an audit id at ${categoryId}[${index}]`);}
const audit=audits.find(a=>a.implementation.meta.name===auditRef.id);if(!audit){throw new Error(`could not find ${auditRef.id} audit for category ${categoryId}`);}
const auditImpl=audit.implementation;const isManual=auditImpl.meta.scoreDisplayMode==='manual';if(categoryId==='accessibility'&&!auditRef.group&&!isManual){throw new Error(`${auditRef.id} accessibility audit does not have a group`);}
if(auditRef.weight>0&&isManual){throw new Error(`${auditRef.id} is manual but has a positive weight`);}
if(auditRef.group&&!groups[auditRef.group]){throw new Error(`${auditRef.id} references unknown group ${auditRef.group}`);}});});}
function assertValidAudit(auditDefinition,auditPath){const auditName=auditPath||auditDefinition&&auditDefinition.meta&&auditDefinition.meta.name;if(typeof auditDefinition.audit!=='function'||auditDefinition.audit===Audit.audit){throw new Error(`${auditName} has no audit() method.`);}
if(typeof auditDefinition.meta.name!=='string'){throw new Error(`${auditName} has no meta.name property, or the property is not a string.`);}
if(typeof auditDefinition.meta.description!=='string'){throw new Error(`${auditName} has no meta.description property, or the property is not a string.`);}
if(typeof auditDefinition.meta.failureDescription!=='string'&&auditDefinition.meta.scoreDisplayMode===Audit.SCORING_MODES.BINARY){throw new Error(`${auditName} has no failureDescription and should.`);}
if(typeof auditDefinition.meta.helpText!=='string'){throw new Error(`${auditName} has no meta.helpText property, or the property is not a string.`);}else if(auditDefinition.meta.helpText===''){throw new Error(`${auditName} has an empty meta.helpText string. Please add a description for the UI.`);}
if(!Array.isArray(auditDefinition.meta.requiredArtifacts)){throw new Error(`${auditName} has no meta.requiredArtifacts property, or the property is not an array.`);}}
function assertValidGatherer(gathererInstance,gathererName){gathererName=gathererName||gathererInstance.name||'gatherer';if(typeof gathererInstance.beforePass!=='function'){throw new Error(`${gathererName} has no beforePass() method.`);}
if(typeof gathererInstance.pass!=='function'){throw new Error(`${gathererName} has no pass() method.`);}
if(typeof gathererInstance.afterPass!=='function'){throw new Error(`${gathererName} has no afterPass() method.`);}}
function cleanFlagsForSettings(flags={}){const settings={};for(const key of Object.keys(flags)){if(typeof constants.defaultSettings[key]!=='undefined'){settings[key]=flags[key];}}
return settings;}
function merge(base,extension,overwriteArrays=false){if(typeof base==='undefined'||base===null){return extension;}else if(typeof extension==='undefined'){return base;}else if(Array.isArray(extension)){if(overwriteArrays)return extension;if(!Array.isArray(base))throw new TypeError(`Expected array but got ${typeof base}`);const merged=base.slice();extension.forEach(item=>{if(!merged.some(candidate=>isDeepEqual(candidate,item)))merged.push(item);});return merged;}else if(typeof extension==='object'){if(typeof base!=='object')throw new TypeError(`Expected object but got ${typeof base}`);Object.keys(extension).forEach(key=>{const localOverwriteArrays=overwriteArrays||key==='settings'&&typeof base[key]==='object';base[key]=merge(base[key],extension[key],localOverwriteArrays);});return base;}
return extension;}
function cloneArrayWithPluginSafety(array){return array.map(item=>{return typeof item==='object'?Object.assign({},item):item;});}
function deepClone(json){const cloned=JSON.parse(JSON.stringify(json));if(Array.isArray(json.passes)){cloned.passes.forEach((pass,i)=>{pass.gatherers=cloneArrayWithPluginSafety(json.passes[i].gatherers||[]);});}
if(Array.isArray(json.audits)){cloned.audits=cloneArrayWithPluginSafety(json.audits);}
return cloned;}
class Config{constructor(configJSON,flags){let configPath=flags&&flags.configPath;if(!configJSON){configJSON=defaultConfig;configPath=path.resolve(__dirname,defaultConfigPath);}
if(configPath&&!path.isAbsolute(configPath)){throw new Error('configPath must be an absolute path.');}
configJSON=deepClone(configJSON);if(configJSON.extends==='lighthouse:full'){const explodedFullConfig=Config.extendConfigJSON(deepClone(defaultConfig),deepClone(fullConfig));configJSON=Config.extendConfigJSON(explodedFullConfig,configJSON);}else if(configJSON.extends){configJSON=Config.extendConfigJSON(deepClone(defaultConfig),configJSON);}
configJSON=Config.augmentWithDefaults(configJSON);configJSON.audits=Config.expandAuditShorthandAndMergeOptions(configJSON.audits);configJSON.passes=Config.expandGathererShorthandAndMergeOptions(configJSON.passes);configJSON.settings=merge(configJSON.settings||{},cleanFlagsForSettings(flags),true);if(Array.isArray(configJSON.settings.onlyCategories)||Array.isArray(configJSON.settings.onlyAudits)||Array.isArray(configJSON.settings.skipAudits)){const categoryIds=configJSON.settings.onlyCategories;const auditIds=configJSON.settings.onlyAudits;const skipAuditIds=configJSON.settings.skipAudits;configJSON=Config.generateNewFilteredConfig(configJSON,categoryIds,auditIds,skipAuditIds);}
Config.adjustDefaultPassForThrottling(configJSON);this._configDir=configPath?path.dirname(configPath):undefined;this._passes=Config.requireGatherers(configJSON.passes,this._configDir);this._audits=Config.requireAudits(configJSON.audits,this._configDir);this._categories=configJSON.categories;this._groups=configJSON.groups;this._settings=configJSON.settings||{};validatePasses(configJSON.passes,this._audits);validateCategories(configJSON.categories,this._audits,this._groups);}
static extendConfigJSON(baseJSON,extendJSON){if(extendJSON.passes){extendJSON.passes.forEach(pass=>{const passName=pass.passName||constants.defaultPassConfig.passName;const basePass=baseJSON.passes.find(candidate=>candidate.passName===passName);if(!basePass){baseJSON.passes.push(pass);}else{merge(basePass,pass);}});delete extendJSON.passes;}
return merge(baseJSON,extendJSON);}
static augmentWithDefaults(config){const{defaultSettings,defaultPassConfig}=constants;config.settings=merge(deepClone(defaultSettings),config.settings,true);if(config.passes){config.passes=config.passes.map(pass=>merge(deepClone(defaultPassConfig),pass));}
return config;}
static expandAuditShorthandAndMergeOptions(audits){if(!audits){return audits;}
const newAudits=audits.map(audit=>{if(typeof audit==='string'){return{path:audit,options:{}};}else if(audit&&typeof audit.audit==='function'){return{implementation:audit,options:{}};}else{return audit;}});return Config._mergeOptionsOfItems(newAudits);}
static expandGathererShorthandAndMergeOptions(passes){if(!passes){return passes;}
passes.forEach(pass=>{pass.gatherers=pass.gatherers.map(gatherer=>{if(typeof gatherer==='string'){return{path:gatherer,options:{}};}else if(typeof gatherer==='function'){return{implementation:gatherer,options:{}};}else if(gatherer&&typeof gatherer.beforePass==='function'){return{instance:gatherer,options:{}};}else{return gatherer;}});pass.gatherers=Config._mergeOptionsOfItems(pass.gatherers);});return passes;}
static _mergeOptionsOfItems(items){const mergedItems=[];for(const item of items){const existingItem=item.path&&mergedItems.find(candidate=>candidate.path===item.path);if(!existingItem){mergedItems.push(item);continue;}
existingItem.options=Object.assign({},existingItem.options,item.options);}
return mergedItems;}
static adjustDefaultPassForThrottling(config){if(config.settings.throttlingMethod!=='devtools'&&config.settings.throttlingMethod!=='provided'){return;}
const defaultPass=config.passes.find(pass=>pass.passName==='defaultPass');if(!defaultPass)return;const overrides=constants.nonSimulatedPassConfigOverrides;defaultPass.pauseAfterLoadMs=Math.max(overrides.pauseAfterLoadMs,defaultPass.pauseAfterLoadMs);defaultPass.cpuQuietThresholdMs=Math.max(overrides.cpuQuietThresholdMs,defaultPass.cpuQuietThresholdMs);defaultPass.networkQuietThresholdMs=Math.max(overrides.networkQuietThresholdMs,defaultPass.networkQuietThresholdMs);}
static generateNewFilteredConfig(oldConfig,categoryIds,auditIds,skipAuditIds){const config=deepClone(oldConfig);config.audits=Config.expandAuditShorthandAndMergeOptions(config.audits);config.passes=Config.expandGathererShorthandAndMergeOptions(config.passes);config.passes=Config.requireGatherers(config.passes);const{categories,audits:requestedAuditNames}=Config.filterCategoriesAndAudits(config.categories,categoryIds,auditIds,skipAuditIds);config.categories=categories;const auditPathToNameMap=Config.getMapOfAuditPathToName(config);const getAuditName=auditDefn=>auditDefn.implementation?auditDefn.implementation.meta.name:auditPathToNameMap.get(auditDefn.path);config.audits=config.audits.filter(auditDefn=>requestedAuditNames.has(getAuditName(auditDefn)));const auditObjectsSelected=Config.requireAudits(config.audits);const requiredGatherers=Config.getGatherersNeededByAudits(auditObjectsSelected);config.passes=Config.generatePassesNeededByGatherers(config.passes,requiredGatherers);return config;}
static filterCategoriesAndAudits(oldCategories,categoryIds,auditIds,skipAuditIds){if(auditIds&&skipAuditIds){throw new Error('Cannot set both skipAudits and onlyAudits');}
const categories={};const filterByIncludedCategory=!!categoryIds;const filterByIncludedAudit=!!auditIds;categoryIds=categoryIds||[];auditIds=auditIds||[];skipAuditIds=skipAuditIds||[];categoryIds.forEach(categoryId=>{if(!oldCategories[categoryId]){log.warn('config',`unrecognized category in 'onlyCategories': ${categoryId}`);}});const auditsToValidate=new Set(auditIds.concat(skipAuditIds));for(const auditId of auditsToValidate){const foundCategory=Object.keys(oldCategories).find(categoryId=>{const auditRefs=oldCategories[categoryId].auditRefs;return auditRefs.find(candidate=>candidate.id===auditId);});if(!foundCategory){const parentKeyName=skipAuditIds.includes(auditId)?'skipAudits':'onlyAudits';log.warn('config',`unrecognized audit in '${parentKeyName}': ${auditId}`);}
if(auditIds.includes(auditId)&&categoryIds.includes(foundCategory)){log.warn('config',`${auditId} in 'onlyAudits' is already included by `+`${foundCategory} in 'onlyCategories'`);}}
const includedAudits=new Set(auditIds);skipAuditIds.forEach(id=>includedAudits.delete(id));Object.keys(oldCategories).forEach(categoryId=>{const category=deepClone(oldCategories[categoryId]);if(filterByIncludedCategory&&filterByIncludedAudit){if(!categoryIds.includes(categoryId)){category.auditRefs=category.auditRefs.filter(audit=>auditIds.includes(audit.id));}}else if(filterByIncludedCategory){if(!categoryIds.includes(categoryId)){return;}}else if(filterByIncludedAudit){category.auditRefs=category.auditRefs.filter(audit=>auditIds.includes(audit.id));}
category.auditRefs=category.auditRefs.filter(audit=>!skipAuditIds.includes(audit.id));if(category.auditRefs.length){categories[categoryId]=category;category.auditRefs.forEach(audit=>includedAudits.add(audit.id));}});return{categories,audits:includedAudits};}
static getCategories(config){return Object.keys(config.categories).map(id=>{const title=config.categories[id].title;return{id,title};});}
static getMapOfAuditPathToName(config){const auditObjectsAll=Config.requireAudits(config.audits);const auditPathToName=new Map(auditObjectsAll.map((auditDefn,index)=>{const AuditClass=auditDefn.implementation;const auditPath=config.audits[index];const auditName=AuditClass.meta.name;return[auditPath,auditName];}));return auditPathToName;}
static getGatherersNeededByAudits(audits){if(!audits){return new Set();}
return audits.reduce((list,auditDefn)=>{auditDefn.implementation.meta.requiredArtifacts.forEach(artifact=>list.add(artifact));return list;},new Set());}
static generatePassesNeededByGatherers(passes,requiredGatherers){const auditsNeedTrace=requiredGatherers.has('traces');const filteredPasses=passes.map(pass=>{pass.gatherers=pass.gatherers.filter(gathererDefn=>{const gatherer=gathererDefn.instance||gathererDefn.implementation;return requiredGatherers.has(gatherer.name);});if(pass.recordTrace&&!auditsNeedTrace){const passName=pass.passName||'unknown pass';log.warn('config',`Trace not requested by an audit, dropping trace in ${passName}`);pass.recordTrace=false;}
return pass;}).filter(pass=>{if(pass.recordTrace)return true;if(pass.passName==='defaultPass')return true;return pass.gatherers.length>0;});return filteredPasses;}
static requireAudits(audits,configPath){if(!audits){return null;}
const coreList=Runner.getAuditList();return audits.map(auditDefn=>{if(!auditDefn.implementation){const path=auditDefn.path;const coreAudit=coreList.find(a=>a===`${path}.js`);let requirePath=`../audits/${path}`;if(!coreAudit){requirePath=Runner.resolvePlugin(path,configPath,'audit');}
auditDefn.implementation=require(requirePath);}
assertValidAudit(auditDefn.implementation,auditDefn.path);return auditDefn;});}
static requireGatherers(passes,configPath){if(!passes){return null;}
const coreList=Runner.getGathererList();passes.forEach(pass=>{pass.gatherers.forEach(gathererDefn=>{if(!gathererDefn.instance){let GathererClass=gathererDefn.implementation;if(!GathererClass){const name=gathererDefn.path;const coreGatherer=coreList.find(a=>a===`${name}.js`);let requirePath=`../gather/gatherers/${name}`;if(!coreGatherer){requirePath=Runner.resolvePlugin(name,configPath,'gatherer');}
GathererClass=require(requirePath);}
gathererDefn.implementation=GathererClass;gathererDefn.instance=new GathererClass();}
assertValidGatherer(gathererDefn.instance,gathererDefn.path);});});return passes;}
get configDir(){return this._configDir;}
get passes(){return this._passes;}
get audits(){return this._audits;}
get categories(){return this._categories;}
get groups(){return this._groups;}
get settings(){return this._settings;}}
module.exports=Config;}).call(this,"/../lighthouse-core/config");},{"../audits/audit":2,"../runner":50,"./constants":8,"./default-config.js":9,"./full-config.js":10,"lighthouse-logger":143,"lodash.isequal":144,"path":75}],8:[function(require,module,exports){'use strict';const DEVTOOLS_RTT_ADJUSTMENT_FACTOR=3.75;const DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR=0.9;const throttling={DEVTOOLS_RTT_ADJUSTMENT_FACTOR,DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR,mobile3G:{rttMs:150,throughputKbps:1.6*1024,requestLatencyMs:150*DEVTOOLS_RTT_ADJUSTMENT_FACTOR,downloadThroughputKbps:1.6*1024*DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR,uploadThroughputKbps:750*DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR,cpuSlowdownMultiplier:4}};const defaultSettings={output:'json',maxWaitForLoad:45*1000,throttlingMethod:'simulate',throttling:throttling.mobile3G,auditMode:false,gatherMode:false,disableStorageReset:false,disableDeviceEmulation:false,blockedUrlPatterns:null,additionalTraceCategories:null,extraHeaders:null,onlyAudits:null,onlyCategories:null,skipAudits:null};const defaultPassConfig={passName:'defaultPass',recordTrace:false,useThrottling:false,pauseAfterLoadMs:0,networkQuietThresholdMs:0,cpuQuietThresholdMs:0,blockedUrlPatterns:[],blankPage:'about:blank',blankDuration:300,gatherers:[]};const nonSimulatedPassConfigOverrides={pauseAfterLoadMs:5250,networkQuietThresholdMs:5250,cpuQuietThresholdMs:5250};module.exports={throttling,defaultSettings,defaultPassConfig,nonSimulatedPassConfigOverrides};},{}],9:[function(require,module,exports){'use strict';const constants=require('./constants');module.exports={settings:constants.defaultSettings,passes:[{passName:'defaultPass',recordTrace:true,useThrottling:true,pauseAfterLoadMs:1000,networkQuietThresholdMs:1000,cpuQuietThresholdMs:1000,gatherers:['scripts','css-usage','viewport','viewport-dimensions','theme-color','manifest','runtime-exceptions','chrome-console-messages','image-usage','accessibility','dobetterweb/all-event-listeners','dobetterweb/anchors-with-no-rel-noopener','dobetterweb/appcache','dobetterweb/domstats','dobetterweb/js-libraries','dobetterweb/optimized-images','dobetterweb/password-inputs-with-prevented-paste','dobetterweb/response-compression','dobetterweb/tags-blocking-first-paint','dobetterweb/websql','seo/meta-description','seo/font-size','seo/crawlable-links','seo/meta-robots','seo/hreflang','seo/embedded-content','seo/canonical','seo/robots-txt','fonts']},{passName:'offlinePass',gatherers:['service-worker','offline','start-url']},{passName:'redirectPass',blockedUrlPatterns:['*.css','*.jpg','*.jpeg','*.png','*.gif','*.svg','*.ttf','*.woff','*.woff2'],gatherers:['http-redirect','html-without-javascript']}],audits:['is-on-https','redirects-http','service-worker','works-offline','viewport','without-javascript','first-contentful-paint','first-meaningful-paint','load-fast-enough-for-pwa','speed-index','screenshot-thumbnails','estimated-input-latency','errors-in-console','time-to-first-byte','first-cpu-idle','interactive','user-timings','critical-request-chains','redirects','webapp-install-banner','splash-screen','themed-omnibox','manifest-short-name-length','content-width','image-aspect-ratio','deprecations','mainthread-work-breakdown','bootup-time','uses-rel-preload','uses-rel-preconnect','font-display','network-requests','metrics','manual/pwa-cross-browser','manual/pwa-page-transitions','manual/pwa-each-page-has-url','accessibility/accesskeys','accessibility/aria-allowed-attr','accessibility/aria-required-attr','accessibility/aria-required-children','accessibility/aria-required-parent','accessibility/aria-roles','accessibility/aria-valid-attr-value','accessibility/aria-valid-attr','accessibility/audio-caption','accessibility/button-name','accessibility/bypass','accessibility/color-contrast','accessibility/definition-list','accessibility/dlitem','accessibility/document-title','accessibility/duplicate-id','accessibility/frame-title','accessibility/html-has-lang','accessibility/html-lang-valid','accessibility/image-alt','accessibility/input-image-alt','accessibility/label','accessibility/layout-table','accessibility/link-name','accessibility/list','accessibility/listitem','accessibility/meta-refresh','accessibility/meta-viewport','accessibility/object-alt','accessibility/tabindex','accessibility/td-headers-attr','accessibility/th-has-data-cells','accessibility/valid-lang','accessibility/video-caption','accessibility/video-description','accessibility/manual/custom-controls-labels','accessibility/manual/custom-controls-roles','accessibility/manual/focus-traps','accessibility/manual/focusable-controls','accessibility/manual/heading-levels','accessibility/manual/logical-tab-order','accessibility/manual/managed-focus','accessibility/manual/offscreen-content-hidden','accessibility/manual/use-landmarks','accessibility/manual/visual-order-follows-dom','byte-efficiency/uses-long-cache-ttl','byte-efficiency/total-byte-weight','byte-efficiency/offscreen-images','byte-efficiency/render-blocking-resources','byte-efficiency/unminified-css','byte-efficiency/unminified-javascript','byte-efficiency/unused-css-rules','byte-efficiency/uses-webp-images','byte-efficiency/uses-optimized-images','byte-efficiency/uses-text-compression','byte-efficiency/uses-responsive-images','byte-efficiency/efficient-animated-content','dobetterweb/appcache-manifest','dobetterweb/dom-size','dobetterweb/external-anchors-use-rel-noopener','dobetterweb/geolocation-on-start','dobetterweb/no-document-write','dobetterweb/no-mutation-events','dobetterweb/no-vulnerable-libraries','dobetterweb/no-websql','dobetterweb/notification-on-start','dobetterweb/password-inputs-can-be-pasted-into','dobetterweb/uses-http2','dobetterweb/uses-passive-event-listeners','seo/meta-description','seo/http-status-code','seo/font-size','seo/link-text','seo/is-crawlable','seo/robots-txt','seo/hreflang','seo/plugins','seo/canonical','seo/manual/mobile-friendly','seo/manual/structured-data'],groups:{'metrics':{title:'Metrics'},'load-opportunities':{title:'Opportunities',description:'These are opportunities to speed up your application by optimizing the following resources.'},'diagnostics':{title:'Diagnostics',description:'More information about the performance of your application.'},'a11y-color-contrast':{title:'Color Contrast Is Satisfactory',description:'These are opportunities to improve the legibility of your content.'},'a11y-describe-contents':{title:'Elements Describe Contents Well',description:'These are opportunities to make your content easier to understand for a user of assistive technology, like a screen reader.'},'a11y-well-structured':{title:'Elements Are Well Structured',description:'These are opportunities to make sure your HTML is appropriately structured.'},'a11y-aria':{title:'ARIA Attributes Follow Best Practices',description:'These are opportunities to improve the usage of ARIA in your application which may enhance the experience for users of assistive technology, like a screen reader.'},'a11y-correct-attributes':{title:'Elements Use Attributes Correctly',description:'These are opportunities to improve the configuration of your HTML elements.'},'a11y-element-names':{title:'Elements Have Discernible Names',description:'These are opportunities to improve the semantics of the controls in your application. This may enhance the experience for users of assistive technology, like a screen reader.'},'a11y-language':{title:'Page Specifies Valid Language',description:'These are opportunities to improve the interpretation of your content by users in different locales.'},'a11y-meta':{title:'Meta Tags Used Properly',description:'These are opportunities to improve the user experience of your site.'},'seo-mobile':{title:'Mobile Friendly',description:'Make sure your pages are mobile friendly so users don’t have to pinch or zoom '+'in order to read the content pages. [Learn more](https://developers.google.com/search/mobile-sites/).'},'seo-content':{title:'Content Best Practices',description:'Format your HTML in a way that enables crawlers to better understand your app’s content.'},'seo-crawl':{title:'Crawling and Indexing',description:'To appear in search results, crawlers need access to your app.'}},categories:{'performance':{title:'Performance',auditRefs:[{id:'first-contentful-paint',weight:3,group:'metrics'},{id:'first-meaningful-paint',weight:1,group:'metrics'},{id:'speed-index',weight:4,group:'metrics'},{id:'interactive',weight:5,group:'metrics'},{id:'first-cpu-idle',weight:2,group:'metrics'},{id:'estimated-input-latency',weight:0,group:'metrics'},{id:'render-blocking-resources',weight:0,group:'load-opportunities'},{id:'uses-responsive-images',weight:0,group:'load-opportunities'},{id:'offscreen-images',weight:0,group:'load-opportunities'},{id:'unminified-css',weight:0,group:'load-opportunities'},{id:'unminified-javascript',weight:0,group:'load-opportunities'},{id:'unused-css-rules',weight:0,group:'load-opportunities'},{id:'uses-optimized-images',weight:0,group:'load-opportunities'},{id:'uses-webp-images',weight:0,group:'load-opportunities'},{id:'uses-text-compression',weight:0,group:'load-opportunities'},{id:'uses-rel-preconnect',weight:0,group:'load-opportunities'},{id:'time-to-first-byte',weight:0,group:'load-opportunities'},{id:'redirects',weight:0,group:'load-opportunities'},{id:'uses-rel-preload',weight:0,group:'load-opportunities'},{id:'efficient-animated-content',weight:0,group:'load-opportunities'},{id:'total-byte-weight',weight:0,group:'diagnostics'},{id:'uses-long-cache-ttl',weight:0,group:'diagnostics'},{id:'dom-size',weight:0,group:'diagnostics'},{id:'critical-request-chains',weight:0,group:'diagnostics'},{id:'network-requests',weight:0},{id:'metrics',weight:0},{id:'user-timings',weight:0,group:'diagnostics'},{id:'bootup-time',weight:0,group:'diagnostics'},{id:'screenshot-thumbnails',weight:0},{id:'mainthread-work-breakdown',weight:0,group:'diagnostics'},{id:'font-display',weight:0,group:'diagnostics'}]},'pwa':{title:'Progressive Web App',description:'These checks validate the aspects of a Progressive Web App, as specified by the baseline [PWA Checklist](https://developers.google.com/web/progressive-web-apps/checklist).',manualDescription:'These checks are required by the baseline '+'[PWA Checklist](https://developers.google.com/web/progressive-web-apps/checklist) but are '+'not automatically checked by Lighthouse. They do not affect your score but it\'s important that you verify them manually.',auditRefs:[{id:'service-worker',weight:1},{id:'works-offline',weight:1},{id:'without-javascript',weight:1},{id:'is-on-https',weight:1},{id:'redirects-http',weight:1},{id:'load-fast-enough-for-pwa',weight:1},{id:'webapp-install-banner',weight:1},{id:'splash-screen',weight:1},{id:'themed-omnibox',weight:1},{id:'viewport',weight:1},{id:'content-width',weight:1},{id:'pwa-cross-browser',weight:0},{id:'pwa-page-transitions',weight:0},{id:'pwa-each-page-has-url',weight:0}]},'accessibility':{title:'Accessibility',description:'These checks highlight opportunities to [improve the accessibility of your web app](https://developers.google.com/web/fundamentals/accessibility). Only a subset of accessibility issues can be automatically detected so manual testing is also encouraged.',manualDescription:'These items address areas which an automated testing tool cannot cover. Learn more in our guide on [conducting an accessibility review](https://developers.google.com/web/fundamentals/accessibility/how-to-review).',auditRefs:[{id:'accesskeys',weight:1,group:'a11y-correct-attributes'},{id:'aria-allowed-attr',weight:3,group:'a11y-aria'},{id:'aria-required-attr',weight:2,group:'a11y-aria'},{id:'aria-required-children',weight:5,group:'a11y-aria'},{id:'aria-required-parent',weight:2,group:'a11y-aria'},{id:'aria-roles',weight:3,group:'a11y-aria'},{id:'aria-valid-attr-value',weight:2,group:'a11y-aria'},{id:'aria-valid-attr',weight:5,group:'a11y-aria'},{id:'audio-caption',weight:4,group:'a11y-correct-attributes'},{id:'button-name',weight:10,group:'a11y-element-names'},{id:'bypass',weight:10,group:'a11y-describe-contents'},{id:'color-contrast',weight:6,group:'a11y-color-contrast'},{id:'definition-list',weight:1,group:'a11y-well-structured'},{id:'dlitem',weight:1,group:'a11y-well-structured'},{id:'document-title',weight:2,group:'a11y-describe-contents'},{id:'duplicate-id',weight:5,group:'a11y-well-structured'},{id:'frame-title',weight:5,group:'a11y-describe-contents'},{id:'html-has-lang',weight:4,group:'a11y-language'},{id:'html-lang-valid',weight:1,group:'a11y-language'},{id:'image-alt',weight:8,group:'a11y-correct-attributes'},{id:'input-image-alt',weight:1,group:'a11y-correct-attributes'},{id:'label',weight:10,group:'a11y-describe-contents'},{id:'layout-table',weight:1,group:'a11y-describe-contents'},{id:'link-name',weight:9,group:'a11y-element-names'},{id:'list',weight:5,group:'a11y-well-structured'},{id:'listitem',weight:4,group:'a11y-well-structured'},{id:'meta-refresh',weight:1,group:'a11y-meta'},{id:'meta-viewport',weight:3,group:'a11y-meta'},{id:'object-alt',weight:4,group:'a11y-describe-contents'},{id:'tabindex',weight:4,group:'a11y-correct-attributes'},{id:'td-headers-attr',weight:1,group:'a11y-correct-attributes'},{id:'th-has-data-cells',weight:1,group:'a11y-correct-attributes'},{id:'valid-lang',weight:1,group:'a11y-language'},{id:'video-caption',weight:4,group:'a11y-describe-contents'},{id:'video-description',weight:3,group:'a11y-describe-contents'},{id:'logical-tab-order',weight:0},{id:'focusable-controls',weight:0},{id:'managed-focus',weight:0},{id:'focus-traps',weight:0},{id:'custom-controls-labels',weight:0},{id:'custom-controls-roles',weight:0},{id:'visual-order-follows-dom',weight:0},{id:'offscreen-content-hidden',weight:0},{id:'heading-levels',weight:0},{id:'use-landmarks',weight:0}]},'best-practices':{title:'Best Practices',auditRefs:[{id:'appcache-manifest',weight:1},{id:'no-websql',weight:1},{id:'is-on-https',weight:1},{id:'uses-http2',weight:1},{id:'uses-passive-event-listeners',weight:1},{id:'no-mutation-events',weight:1},{id:'no-document-write',weight:1},{id:'external-anchors-use-rel-noopener',weight:1},{id:'geolocation-on-start',weight:1},{id:'no-vulnerable-libraries',weight:1},{id:'notification-on-start',weight:1},{id:'deprecations',weight:1},{id:'manifest-short-name-length',weight:1},{id:'password-inputs-can-be-pasted-into',weight:1},{id:'errors-in-console',weight:1},{id:'image-aspect-ratio',weight:1}]},'seo':{title:'SEO',description:'These checks ensure that your page is optimized for search engine results ranking. '+'There are additional factors Lighthouse does not check that may affect your search ranking. '+'[Learn more](https://support.google.com/webmasters/answer/35769).',manualDescription:'Run these additional validators on your site to check additional SEO best practices.',auditRefs:[{id:'viewport',weight:1,group:'seo-mobile'},{id:'document-title',weight:1,group:'seo-content'},{id:'meta-description',weight:1,group:'seo-content'},{id:'http-status-code',weight:1,group:'seo-crawl'},{id:'link-text',weight:1,group:'seo-content'},{id:'is-crawlable',weight:1,group:'seo-crawl'},{id:'robots-txt',weight:1,group:'seo-crawl'},{id:'hreflang',weight:1,group:'seo-content'},{id:'canonical',weight:1,group:'seo-content'},{id:'font-size',weight:1,group:'seo-mobile'},{id:'plugins',weight:1,group:'seo-content'},{id:'mobile-friendly',weight:0},{id:'structured-data',weight:0}]}}};},{"./constants":8}],10:[function(require,module,exports){'use strict';module.exports={extends:'lighthouse:default',settings:{},passes:[{passName:'extraPass',gatherers:['js-usage']}],audits:['byte-efficiency/unused-javascript'],categories:{'performance':{auditRefs:[{id:'unused-javascript',weight:0,group:'load-opportunities'}]}}};},{}],11:[function(require,module,exports){'use strict';const ArbitraryEqualityMap=require('../../lib/arbitrary-equality-map');class ComputedArtifact{constructor(allComputedArtifacts){const cache=new ArbitraryEqualityMap();cache.setEqualityFn(ArbitraryEqualityMap.deepEquals);this._cache=cache;this._allComputedArtifacts=allComputedArtifacts;}
get name(){throw new Error('name getter not implemented for computed artifact '+this.constructor.name);}
async compute_(artifact,allComputedArtifacts){throw new Error('compute_() not implemented for computed artifact '+this.name);}
async request(requiredArtifacts){const computed=this._cache.get(requiredArtifacts);if(computed){return computed;}
const artifactPromise=this.compute_(requiredArtifacts,this._allComputedArtifacts);this._cache.set(requiredArtifacts,artifactPromise);return artifactPromise;}}
module.exports=ComputedArtifact;},{"../../lib/arbitrary-equality-map":20}],12:[function(require,module,exports){'use strict';const ComputedArtifact=require('../computed-artifact');const Node=require('../../../lib/dependency-graph/node');const NetworkNode=require('../../../lib/dependency-graph/network-node');const Simulator=require('../../../lib/dependency-graph/simulator/simulator');const WebInspector=require('../../../lib/web-inspector');class LanternMetricArtifact extends ComputedArtifact{static getScriptUrls(dependencyGraph,condition){const scriptUrls=new Set();dependencyGraph.traverse(node=>{if(node.type===Node.TYPES.CPU)return;const asNetworkNode=node;if(asNetworkNode.record._resourceType!==WebInspector.resourceTypes.Script)return;if(condition&&!condition(asNetworkNode))return;scriptUrls.add(asNetworkNode.record.url);});return scriptUrls;}
get COEFFICIENTS(){throw new Error('COEFFICIENTS unimplemented!');}
getOptimisticGraph(dependencyGraph,traceOfTab){throw new Error('Optimistic graph unimplemented!');}
getPessimisticGraph(dependencyGraph,traceOfTab){throw new Error('Pessmistic graph unimplemented!');}
getEstimateFromSimulation(simulationResult,extras){return simulationResult;}
async computeMetricWithGraphs(data,artifacts,extras){const{trace,devtoolsLog,settings}=data;const graph=await artifacts.requestPageDependencyGraph({trace,devtoolsLog});const traceOfTab=await artifacts.requestTraceOfTab(trace);const simulator=data.simulator||(await artifacts.requestLoadSimulator({devtoolsLog,settings}));const optimisticGraph=this.getOptimisticGraph(graph,traceOfTab);const pessimisticGraph=this.getPessimisticGraph(graph,traceOfTab);const optimisticSimulation=simulator.simulate(optimisticGraph);const optimisticFlexSimulation=simulator.simulate(optimisticGraph,{flexibleOrdering:true});const pessimisticSimulation=simulator.simulate(pessimisticGraph);const optimisticEstimate=this.getEstimateFromSimulation(optimisticSimulation.timeInMs<optimisticFlexSimulation.timeInMs?optimisticSimulation:optimisticFlexSimulation,Object.assign({},extras,{optimistic:true}));const pessimisticEstimate=this.getEstimateFromSimulation(pessimisticSimulation,Object.assign({},extras,{optimistic:false}));const interceptMultiplier=this.COEFFICIENTS.intercept>0?Math.min(1,optimisticEstimate.timeInMs/1000):1;const timing=this.COEFFICIENTS.intercept*interceptMultiplier+
this.COEFFICIENTS.optimistic*optimisticEstimate.timeInMs+
this.COEFFICIENTS.pessimistic*pessimisticEstimate.timeInMs;return{timing,optimisticEstimate,pessimisticEstimate,optimisticGraph,pessimisticGraph};}
compute_(data,computedArtifacts){return this.computeMetricWithGraphs(data,computedArtifacts);}}
module.exports=LanternMetricArtifact;},{"../../../lib/dependency-graph/network-node":24,"../../../lib/dependency-graph/node":25,"../../../lib/dependency-graph/simulator/simulator":28,"../../../lib/web-inspector":47,"../computed-artifact":11}],13:[function(require,module,exports){'use strict';const ComputedArtifact=require('../computed-artifact');class ComputedMetric extends ComputedArtifact{get name(){throw new Error('Unimplemented');}
computeSimulatedMetric(data,artifacts){return artifacts[`requestLantern${this.name}`](data);}
computeObservedMetric(data,artifacts){throw new Error('Unimplemented');}
async compute_(data,computedArtifacts){const{trace,devtoolsLog,settings}=data;if(!trace||!devtoolsLog||!settings){throw new Error('Did not provide necessary metric computation data');}
const augmentedData=Object.assign({networkRecords:await computedArtifacts.requestNetworkRecords(devtoolsLog),traceOfTab:await computedArtifacts.requestTraceOfTab(trace)},data);switch(settings.throttlingMethod){case'simulate':return this.computeSimulatedMetric(augmentedData,computedArtifacts);case'provided':case'devtools':return this.computeObservedMetric(augmentedData,computedArtifacts);default:throw new TypeError(`Unrecognized throttling method: ${settings.throttlingMethod}`);}}}
module.exports=ComputedMetric;},{"../computed-artifact":11}],14:[function(require,module,exports){'use strict';const EventEmitter=require('events').EventEmitter;const log=require('lighthouse-logger');const LHError=require('../../lib/errors');class Connection{constructor(){this._lastCommandId=0;this._callbacks=new Map();this._eventEmitter=new EventEmitter();}
connect(){return Promise.reject(new Error('Not implemented'));}
disconnect(){return Promise.reject(new Error('Not implemented'));}
wsEndpoint(){return Promise.reject(new Error('Not implemented'));}
sendRawMessage(message){throw new Error('Not implemented');}
handleRawMessage(message){const object=JSON.parse(message);if(!('id'in object)){const eventMessage=object;log.formatProtocol('<= event',{method:eventMessage.method,params:eventMessage.params},'verbose');this.emitProtocolEvent(eventMessage);return;}
const callback=this._callbacks.get(object.id);if(callback){this._callbacks.delete(object.id);return callback.resolve(Promise.resolve().then(_=>{if(object.error){const logLevel=callback.options.silent?'verbose':'error';log.formatProtocol('method <= browser ERR',{method:callback.method},logLevel);throw LHError.fromProtocolMessage(callback.method,object.error);}
log.formatProtocol('method <= browser OK',{method:callback.method,params:object.result},'verbose');return object.result;}));}else{const error=object.error&&object.error.message;log.formatProtocol(`disowned method <= browser ${error?'ERR':'OK'}`,{method:'UNKNOWN',params:error||object.result},'verbose');}}
emitProtocolEvent(eventMessage){if(!this._eventEmitter){throw new Error('Attempted to emit event after connection disposed.');}
this._eventEmitter.emit('protocolevent',eventMessage);}
dispose(){if(this._eventEmitter){this._eventEmitter.removeAllListeners();this._eventEmitter=null;}}}
Connection.prototype.on=function on(eventName,cb){if(eventName!=='protocolevent'){throw new Error('Only supports "protocolevent" events');}
if(!this._eventEmitter){throw new Error('Attempted to add event listener after connection disposed.');}
this._eventEmitter.on(eventName,cb);};function _sendCommand(method,params={},cmdOpts={}){log.formatProtocol('method => browser',{method,params},'verbose');const id=++this._lastCommandId;const message=JSON.stringify({id,method,params});this.sendRawMessage(message);return new Promise(resolve=>{this._callbacks.set(id,{resolve,method,options:cmdOpts});});}
Connection.prototype.sendCommand=_sendCommand;module.exports=Connection;},{"../../lib/errors":33,"events":62,"lighthouse-logger":143}],15:[function(require,module,exports){'use strict';const Connection=require('./connection.js');class Port{on(eventName,cb){}
send(message){}
close(){}}
class RawConnection extends Connection{constructor(port){super();this._port=port;this._port.on('message',this.handleRawMessage.bind(this));this._port.on('close',this.dispose.bind(this));}
connect(){return Promise.resolve();}
disconnect(){this._port.close();return Promise.resolve();}
sendRawMessage(message){this._port.send(message);}}
module.exports=RawConnection;},{"./connection.js":14}],16:[function(require,module,exports){'use strict';class DevtoolsLog{constructor(regexFilter){this._filter=regexFilter;this._messages=[];this._isRecording=false;}
get messages(){return this._messages;}
reset(){this._messages=[];}
beginRecording(){this._isRecording=true;}
endRecording(){this._isRecording=false;}
record(message){if(this._isRecording&&(!this._filter||this._filter.test(message.method))){this._messages.push(message);}}}
module.exports=DevtoolsLog;},{}],17:[function(require,module,exports){'use strict';const NetworkRecorder=require('../lib/network-recorder');const emulation=require('../lib/emulation');const Element=require('../lib/element');const LHError=require('../lib/errors');const EventEmitter=require('events').EventEmitter;const URL=require('../lib/url-shim');const TraceParser=require('../lib/traces/trace-parser');const constants=require('../config/constants');const log=require('lighthouse-logger');const DevtoolsLog=require('./devtools-log');const pageFunctions=require('../lib/page-functions.js');const Connection=require('./connections/connection.js');const DEFAULT_PAUSE_AFTER_LOAD=0;const DEFAULT_NETWORK_QUIET_THRESHOLD=5000;const DEFAULT_CPU_QUIET_THRESHOLD=0;class Driver{constructor(connection){this._traceCategories=Driver.traceCategories;this._eventEmitter=new EventEmitter();this._connection=connection;this._devtoolsLog=new DevtoolsLog(/^(Page|Network)\./);this.online=true;this._domainEnabledCounts=new Map();this._isolatedExecutionContextId=undefined;this._networkStatusMonitor=null;this._monitoredUrl=null;connection.on('protocolevent',event=>{this._devtoolsLog.record(event);if(this._networkStatusMonitor){this._networkStatusMonitor.dispatch(event);}
this._eventEmitter.emit(event.method,event.params);});}
static get traceCategories(){return['-*','toplevel','v8.execute','blink.console','blink.user_timing','benchmark','loading','latencyInfo','devtools.timeline','disabled-by-default-devtools.timeline','disabled-by-default-devtools.timeline.frame','disabled-by-default-devtools.timeline.stack','disabled-by-default-devtools.screenshot'];}
getUserAgent(){return this.evaluateAsync('navigator.userAgent');}
connect(){return this._connection.connect();}
disconnect(){return this._connection.disconnect();}
wsEndpoint(){return this._connection.wsEndpoint();}
_shouldToggleDomain(domain,enable){const enabledCount=this._domainEnabledCounts.get(domain)||0;const newCount=enabledCount+(enable?1:-1);this._domainEnabledCounts.set(domain,Math.max(0,newCount));if(enable&&newCount===1||!enable&&newCount===0){log.verbose('Driver',`${domain}.${enable?'enable':'disable'}`);return true;}else{if(newCount<0){log.error('Driver',`Attempted to disable domain '${domain}' when already disabled.`);}
return false;}}
isDomainEnabled(domain){return!!this._domainEnabledCounts.get(domain);}
evaluteScriptOnNewDocument(scriptSource){return this.sendCommand('Page.addScriptToEvaluateOnLoad',{scriptSource});}
evaluateAsync(expression,options={}){const contextIdPromise=options.useIsolation?this._getOrCreateIsolatedContextId():Promise.resolve(undefined);return contextIdPromise.then(contextId=>this._evaluateInContext(expression,contextId));}
_evaluateInContext(expression,contextId){return new Promise((resolve,reject)=>{const asyncTimeout=setTimeout(_=>reject(new Error('The asynchronous expression exceeded the allotted time of 60s')),60000);const evaluationParams={expression:`(function wrapInNativePromise() {
          const __nativePromise = window.__nativePromise || Promise;
          return new __nativePromise(function (resolve) {
            return __nativePromise.resolve()
              .then(_ => ${expression})
              .catch(${pageFunctions.wrapRuntimeEvalErrorInBrowser.toString()})
              .then(resolve);
          });
        }())`,includeCommandLineAPI:true,awaitPromise:true,returnByValue:true,contextId};this.sendCommand('Runtime.evaluate',evaluationParams).then(result=>{clearTimeout(asyncTimeout);const value=result.result.value;if(result.exceptionDetails){reject(new Error('an unexpected driver error occurred'));}if(value&&value.__failedInBrowser){reject(Object.assign(new Error(),value));}else{resolve(value);}}).catch(err=>{clearTimeout(asyncTimeout);reject(err);});});}
getAppManifest(){return this.sendCommand('Page.getAppManifest').then(response=>{if(!response.data){return null;}
return response;});}
getServiceWorkerVersions(){return new Promise((resolve,reject)=>{const versionUpdatedListener=data=>{const activateCandidates=data.versions.filter(sw=>{return sw.status!=='redundant';});const hasActiveServiceWorker=activateCandidates.find(sw=>{return sw.status==='activated';});if(!activateCandidates.length||hasActiveServiceWorker){this.off('ServiceWorker.workerVersionUpdated',versionUpdatedListener);this.sendCommand('ServiceWorker.disable').then(_=>resolve(data),reject);}};this.on('ServiceWorker.workerVersionUpdated',versionUpdatedListener);this.sendCommand('ServiceWorker.enable').catch(reject);});}
getServiceWorkerRegistrations(){return new Promise((resolve,reject)=>{this.once('ServiceWorker.workerRegistrationUpdated',data=>{this.sendCommand('ServiceWorker.disable').then(_=>resolve(data),reject);});this.sendCommand('ServiceWorker.enable').catch(reject);});}
assertNoSameOriginServiceWorkerClients(pageUrl){let registrations;let versions;return this.getServiceWorkerRegistrations().then(data=>{registrations=data.registrations;}).then(_=>this.getServiceWorkerVersions()).then(data=>{versions=data.versions;}).then(_=>{const origin=new URL(pageUrl).origin;registrations.filter(reg=>{const swOrigin=new URL(reg.scopeURL).origin;return origin===swOrigin;}).forEach(reg=>{versions.forEach(ver=>{if(ver.registrationId!==reg.registrationId){return;}
if(ver.controlledClients&&ver.controlledClients.length>0){throw new Error('You probably have multiple tabs open to the same origin.');}});});});}
_waitForNetworkIdle(networkQuietThresholdMs){let idleTimeout;let cancel=()=>{throw new Error('_waitForNetworkIdle.cancel() called before it was defined');};if(!this._networkStatusMonitor){throw new Error('Driver._waitForNetworkIdle called with no networkStatusMonitor');}
const networkStatusMonitor=this._networkStatusMonitor;const promise=new Promise((resolve,reject)=>{const onIdle=()=>{networkStatusMonitor.once('network-2-busy',onBusy);idleTimeout=setTimeout(_=>{cancel();resolve();},networkQuietThresholdMs);};const onBusy=()=>{networkStatusMonitor.once('network-2-idle',onIdle);idleTimeout&&clearTimeout(idleTimeout);};const domContentLoadedListener=()=>{if(networkStatusMonitor.is2Idle()){onIdle();}else{onBusy();}};this.once('Page.domContentEventFired',domContentLoadedListener);cancel=()=>{idleTimeout&&clearTimeout(idleTimeout);this.off('Page.domContentEventFired',domContentLoadedListener);networkStatusMonitor.removeListener('network-2-busy',onBusy);networkStatusMonitor.removeListener('network-2-idle',onIdle);};});return{promise,cancel};}
_waitForCPUIdle(waitForCPUQuiet){if(!waitForCPUQuiet){return{promise:Promise.resolve(),cancel:()=>undefined};}
let lastTimeout;let cancelled=false;const checkForQuietExpression=`(${pageFunctions.checkTimeSinceLastLongTask.toString()})()`;function checkForQuiet(driver,resolve){if(cancelled)return;return driver.evaluateAsync(checkForQuietExpression).then(timeSinceLongTask=>{if(cancelled)return;if(typeof timeSinceLongTask==='number'){if(timeSinceLongTask>=waitForCPUQuiet){log.verbose('Driver',`CPU has been idle for ${timeSinceLongTask} ms`);resolve();}else{log.verbose('Driver',`CPU has been idle for ${timeSinceLongTask} ms`);const timeToWait=waitForCPUQuiet-timeSinceLongTask;lastTimeout=setTimeout(()=>checkForQuiet(driver,resolve),timeToWait);}}});}
let cancel=()=>{throw new Error('_waitForCPUIdle.cancel() called before it was defined');};const promise=new Promise((resolve,reject)=>{checkForQuiet(this,resolve);cancel=()=>{cancelled=true;if(lastTimeout)clearTimeout(lastTimeout);reject(new Error('Wait for CPU idle cancelled'));};});return{promise,cancel};}
_waitForLoadEvent(pauseAfterLoadMs){let cancel=()=>{throw new Error('_waitForLoadEvent.cancel() called before it was defined');};const promise=new Promise((resolve,reject)=>{let loadTimeout;const loadListener=function(){loadTimeout=setTimeout(resolve,pauseAfterLoadMs);};this.once('Page.loadEventFired',loadListener);cancel=()=>{this.off('Page.loadEventFired',loadListener);loadTimeout&&clearTimeout(loadTimeout);};});return{promise,cancel};}
async _waitForFullyLoaded(pauseAfterLoadMs,networkQuietThresholdMs,cpuQuietThresholdMs,maxWaitForLoadedMs){let maxTimeoutHandle;const waitForLoadEvent=this._waitForLoadEvent(pauseAfterLoadMs);const waitForNetworkIdle=this._waitForNetworkIdle(networkQuietThresholdMs);let waitForCPUIdle=null;const loadPromise=Promise.all([waitForLoadEvent.promise,waitForNetworkIdle.promise]).then(()=>{waitForCPUIdle=this._waitForCPUIdle(cpuQuietThresholdMs);return waitForCPUIdle.promise;}).then(()=>{return function(){log.verbose('Driver','loadEventFired and network considered idle');maxTimeoutHandle&&clearTimeout(maxTimeoutHandle);};});const maxTimeoutPromise=new Promise((resolve,reject)=>{maxTimeoutHandle=setTimeout(resolve,maxWaitForLoadedMs);}).then(_=>{return function(){log.warn('Driver','Timed out waiting for page load. Moving on...');waitForLoadEvent.cancel();waitForNetworkIdle.cancel();waitForCPUIdle&&waitForCPUIdle.cancel();};});const cleanupFn=await Promise.race([loadPromise,maxTimeoutPromise]);cleanupFn();}
_beginNetworkStatusMonitoring(startingUrl){this._networkStatusMonitor=new NetworkRecorder([]);this._monitoredUrl=startingUrl;const requestLoadedListener=redirectRequest=>{if(!redirectRequest.redirectSource){return;}
const earlierRequest=redirectRequest.redirectSource;if(earlierRequest.url===this._monitoredUrl){this._monitoredUrl=redirectRequest.url;}};this._networkStatusMonitor.on('requestloaded',requestLoadedListener);return this.sendCommand('Network.enable');}
_endNetworkStatusMonitoring(){this._networkStatusMonitor=null;const finalUrl=this._monitoredUrl;this._monitoredUrl=null;if(!finalUrl){throw new Error('Network Status Monitoring ended with an undefined finalUrl');}
return finalUrl;}
async _getOrCreateIsolatedContextId(){if(typeof this._isolatedExecutionContextId==='number'){return this._isolatedExecutionContextId;}
const resourceTreeResponse=await this.sendCommand('Page.getResourceTree');const mainFrameId=resourceTreeResponse.frameTree.frame.id;const isolatedWorldResponse=await this.sendCommand('Page.createIsolatedWorld',{frameId:mainFrameId,worldName:'lighthouse_isolated_context'});this._isolatedExecutionContextId=isolatedWorldResponse.executionContextId;return isolatedWorldResponse.executionContextId;}
_clearIsolatedContextId(){this._isolatedExecutionContextId=undefined;}
async gotoURL(url,options={}){const waitForLoad=options.waitForLoad||false;const passContext=options.passContext||{};const disableJS=passContext.disableJavaScript||false;await this._beginNetworkStatusMonitoring(url);await this._clearIsolatedContextId();this.sendCommand('Page.enable');this.sendCommand('Emulation.setScriptExecutionDisabled',{value:disableJS});this.sendCommand('Page.navigate',{url});if(waitForLoad){const passConfig=passContext.passConfig||{};let{pauseAfterLoadMs,networkQuietThresholdMs,cpuQuietThresholdMs}=passConfig;let maxWaitMs=passContext.settings&&passContext.settings.maxWaitForLoad;if(typeof pauseAfterLoadMs!=='number')pauseAfterLoadMs=DEFAULT_PAUSE_AFTER_LOAD;if(typeof networkQuietThresholdMs!=='number')networkQuietThresholdMs=DEFAULT_NETWORK_QUIET_THRESHOLD;if(typeof cpuQuietThresholdMs!=='number')cpuQuietThresholdMs=DEFAULT_CPU_QUIET_THRESHOLD;if(typeof maxWaitMs!=='number')maxWaitMs=constants.defaultSettings.maxWaitForLoad;await this._waitForFullyLoaded(pauseAfterLoadMs,networkQuietThresholdMs,cpuQuietThresholdMs,maxWaitMs);}
return this._endNetworkStatusMonitoring();}
async getObjectProperty(objectId,propName){const propertiesResponse=await this.sendCommand('Runtime.getProperties',{objectId,accessorPropertiesOnly:true,generatePreview:false,ownProperties:false});const propertyForName=propertiesResponse.result.find(property=>property.name===propName);if(propertyForName&&propertyForName.value){return propertyForName.value.value;}else{return null;}}
getRequestContent(requestId,timeout=1000){return new Promise((resolve,reject)=>{const err=new LHError(LHError.errors.REQUEST_CONTENT_TIMEOUT);const asyncTimeout=setTimeout(_=>reject(err),timeout);this.sendCommand('Network.getResponseBody',{requestId}).then(result=>{clearTimeout(asyncTimeout);resolve(result.body);}).catch(e=>{clearTimeout(asyncTimeout);reject(e);});});}
queryPermissionState(name){const expressionToEval=`
      navigator.permissions.query({name: '${name}'}).then(result => {
        return result.state;
      })
    `;return this.evaluateAsync(expressionToEval);}
async querySelector(selector){const documentResponse=await this.sendCommand('DOM.getDocument');const rootNodeId=documentResponse.root.nodeId;const targetNode=await this.sendCommand('DOM.querySelector',{nodeId:rootNodeId,selector});if(targetNode.nodeId===0){return null;}
return new Element(targetNode,this);}
async querySelectorAll(selector){const documentResponse=await this.sendCommand('DOM.getDocument');const rootNodeId=documentResponse.root.nodeId;const targetNodeList=await this.sendCommand('DOM.querySelectorAll',{nodeId:rootNodeId,selector});const elementList=[];targetNodeList.nodeIds.forEach(nodeId=>{if(nodeId!==0){elementList.push(new Element({nodeId},this));}});return elementList;}
getElementsInDocument(pierce=true){return this.getNodesInDocument(pierce).then(nodes=>nodes.filter(node=>node.nodeType===1).map(node=>new Element({nodeId:node.nodeId},this)));}
async getNodesInDocument(pierce=true){const flattenedDocument=await this.sendCommand('DOM.getFlattenedDocument',{depth:-1,pierce});return flattenedDocument.nodes?flattenedDocument.nodes:[];}
beginTrace(settings){const additionalCategories=settings&&settings.additionalTraceCategories&&settings.additionalTraceCategories.split(',')||[];const traceCategories=this._traceCategories.concat(additionalCategories);const uniqueCategories=Array.from(new Set(traceCategories));if(this.isDomainEnabled('Debugger')){throw new Error('Debugger domain enabled when starting trace');}
if(this.isDomainEnabled('CSS')){throw new Error('CSS domain enabled when starting trace');}
if(this.isDomainEnabled('DOM')){throw new Error('DOM domain enabled when starting trace');}
return this.sendCommand('Page.enable').then(_=>this.endTraceIfStarted()).then(_=>this.sendCommand('Tracing.start',{categories:uniqueCategories.join(','),transferMode:'ReturnAsStream',options:'sampling-frequency=10000'}));}
endTraceIfStarted(){return new Promise(resolve=>{const traceCallback=()=>resolve();this.once('Tracing.tracingComplete',traceCallback);return this.sendCommand('Tracing.end',undefined,{silent:true}).catch(()=>{this.off('Tracing.tracingComplete',traceCallback);traceCallback();});});}
endTrace(){return new Promise((resolve,reject)=>{this.once('Tracing.tracingComplete',completeEvent=>{this._readTraceFromStream(completeEvent).then(traceContents=>resolve(traceContents),reject);});return this.sendCommand('Tracing.end').catch(reject);});}
_readTraceFromStream(traceCompleteEvent){return new Promise((resolve,reject)=>{let isEOF=false;const parser=new TraceParser();if(!traceCompleteEvent.stream){return reject('No streamHandle returned by traceCompleteEvent');}
const readArguments={handle:traceCompleteEvent.stream};const onChunkRead=response=>{if(isEOF){return;}
parser.parseChunk(response.data);if(response.eof){isEOF=true;return resolve(parser.getTrace());}
return this.sendCommand('IO.read',readArguments).then(onChunkRead);};this.sendCommand('IO.read',readArguments).then(onChunkRead).catch(reject);});}
beginDevtoolsLog(){this._devtoolsLog.reset();this._devtoolsLog.beginRecording();}
endDevtoolsLog(){this._devtoolsLog.endRecording();return this._devtoolsLog.messages;}
enableRuntimeEvents(){return this.sendCommand('Runtime.enable');}
async beginEmulation(settings){if(!settings.disableDeviceEmulation){await emulation.enableNexus5X(this);}
await this.setThrottling(settings,{useThrottling:true});}
async setThrottling(settings,passConfig){if(settings.throttlingMethod!=='devtools'){return emulation.clearAllNetworkEmulation(this);}
const cpuPromise=passConfig.useThrottling?emulation.enableCPUThrottling(this,settings.throttling):emulation.disableCPUThrottling(this);const networkPromise=passConfig.useThrottling?emulation.enableNetworkThrottling(this,settings.throttling):emulation.clearAllNetworkEmulation(this);await Promise.all([cpuPromise,networkPromise]);}
async goOffline(){await this.sendCommand('Network.enable');await emulation.goOffline(this);this.online=false;}
async goOnline(options){await this.setThrottling(options.settings,options.passConfig);this.online=true;}
cleanBrowserCaches(){return this.sendCommand('Network.clearBrowserCache').then(_=>this.sendCommand('Network.setCacheDisabled',{cacheDisabled:true})).then(_=>this.sendCommand('Network.setCacheDisabled',{cacheDisabled:false}));}
async setExtraHTTPHeaders(headers){if(!headers){return;}
return this.sendCommand('Network.setExtraHTTPHeaders',{headers});}
clearDataForOrigin(url){const origin=new URL(url).origin;const typesToClear=['appcache','file_systems','indexeddb','local_storage','shader_cache','websql','service_workers','cache_storage'].join(',');return this.sendCommand('Storage.clearDataForOrigin',{origin:origin,storageTypes:typesToClear});}
async cacheNatives(){await this.evaluteScriptOnNewDocument(`window.__nativePromise = Promise;
        window.__nativeError = Error;`);}
async registerPerformanceObserver(){const scriptStr=`(${pageFunctions.registerPerformanceObserverInPage.toString()})()`;await this.evaluteScriptOnNewDocument(scriptStr);}
captureFunctionCallSites(funcName){const globalVarToPopulate=`window['__${funcName}StackTraces']`;const collectUsage=()=>{return this.evaluateAsync(`Array.from(${globalVarToPopulate}).map(item => JSON.parse(item))`).then(result=>{if(!Array.isArray(result)){throw new Error('Driver failure: Expected evaluateAsync results to be an array '+`but got "${JSON.stringify(result)}" instead.`);}
return result.filter(item=>!item.isExtension);});};const funcBody=pageFunctions.captureJSCallUsage.toString();this.evaluteScriptOnNewDocument(`
        ${globalVarToPopulate} = new Set();
        (${funcName} = ${funcBody}(${funcName}, ${globalVarToPopulate}))`);return collectUsage;}
blockUrlPatterns(urls){return this.sendCommand('Network.setBlockedURLs',{urls}).catch(err=>{if(!/wasn't found/.test(err.message)){throw err;}});}
async dismissJavaScriptDialogs(){await this.sendCommand('Page.enable');this.on('Page.javascriptDialogOpening',data=>{log.warn('Driver',`${data.type} dialog opened by the page automatically suppressed.`);this.sendCommand('Page.handleJavaScriptDialog',{accept:true,promptText:'Lighthouse prompt response'});});}}
Driver.prototype.on=function on(eventName,cb){if(this._eventEmitter===null){throw new Error('connect() must be called before attempting to listen to events.');}
log.formatProtocol('listen for event =>',{method:eventName},'verbose');this._eventEmitter.on(eventName,cb);};Driver.prototype.once=function once(eventName,cb){if(this._eventEmitter===null){throw new Error('connect() must be called before attempting to listen to events.');}
log.formatProtocol('listen once for event =>',{method:eventName},'verbose');this._eventEmitter.once(eventName,cb);};Driver.prototype.off=function off(eventName,cb){if(this._eventEmitter===null){throw new Error('connect() must be called before attempting to remove an event listener.');}
this._eventEmitter.removeListener(eventName,cb);};function _sendCommand(method,params={},cmdOpts={}){const domainCommand=/^(\w+)\.(enable|disable)$/.exec(method);if(domainCommand){const enable=domainCommand[2]==='enable';if(!this._shouldToggleDomain(domainCommand[1],enable)){return Promise.resolve();}}
return this._connection.sendCommand(method,params,cmdOpts);}
Driver.prototype.sendCommand=_sendCommand;module.exports=Driver;},{"../config/constants":8,"../lib/element":31,"../lib/emulation":32,"../lib/errors":33,"../lib/network-recorder":37,"../lib/page-functions.js":38,"../lib/traces/trace-parser":45,"../lib/url-shim":"url","./connections/connection.js":14,"./devtools-log":16,"events":62,"lighthouse-logger":143}],18:[function(require,module,exports){'use strict';const log=require('lighthouse-logger');const LHError=require('../lib/errors');const URL=require('../lib/url-shim');const NetworkRecorder=require('../lib/network-recorder.js');const constants=require('../config/constants');const Driver=require('../gather/driver.js');class GatherRunner{static loadBlank(driver,url=constants.defaultPassConfig.blankPage,duration=constants.defaultPassConfig.blankDuration)
{return driver.gotoURL(url).then(_=>new Promise(resolve=>setTimeout(resolve,duration)));}
static loadPage(driver,passContext){return driver.gotoURL(passContext.url,{waitForLoad:true,passContext}).then(finalUrl=>{passContext.url=finalUrl;});}
static setupDriver(driver,gathererResults,options){log.log('status','Initializing…');const resetStorage=!options.settings.disableStorageReset;return driver.assertNoSameOriginServiceWorkerClients(options.requestedUrl).then(_=>driver.getUserAgent()).then(userAgent=>{gathererResults.UserAgent=[userAgent];GatherRunner.warnOnHeadless(userAgent,gathererResults);}).then(_=>driver.beginEmulation(options.settings)).then(_=>driver.enableRuntimeEvents()).then(_=>driver.cacheNatives()).then(_=>driver.registerPerformanceObserver()).then(_=>driver.dismissJavaScriptDialogs()).then(_=>{if(resetStorage)return driver.clearDataForOrigin(options.requestedUrl);});}
static disposeDriver(driver){log.log('status','Disconnecting from browser...');return driver.disconnect().catch(err=>{if(!/close\/.*status: 500$/.test(err.message)){log.error('GatherRunner disconnect',err.message);}});}
static recoverOrThrow(promise){return promise.catch(err=>{if(err.fatal){throw err;}});}
static getPageLoadError(url,networkRecords){const mainRecord=networkRecords.find(record=>{return URL.equalWithExcludedFragments(record.url,url);});let errorCode;let errorReason;if(!mainRecord){errorCode=LHError.errors.NO_DOCUMENT_REQUEST;}else if(mainRecord.failed){errorCode=LHError.errors.FAILED_DOCUMENT_REQUEST;errorReason=mainRecord.localizedFailDescription;}
if(errorCode){const error=new LHError(errorCode,{reason:errorReason});log.error('GatherRunner',error.message,url);return error;}}
static warnOnHeadless(userAgent,gathererResults){const chromeVersion=userAgent.split(/HeadlessChrome\/(.*) /)[1];const minVersion='63.0.3239.0';if(chromeVersion&&chromeVersion<minVersion){gathererResults.LighthouseRunWarnings.push('Your site\'s mobile performance may be '+'worse than the numbers presented in this report. Lighthouse could not test on a '+'mobile connection because Headless Chrome does not support network throttling '+'prior to version '+minVersion+'. The version used was '+chromeVersion);}}
static beforePass(passContext,gathererResults){const blockedUrls=(passContext.passConfig.blockedUrlPatterns||[]).concat(passContext.settings.blockedUrlPatterns||[]);const blankPage=passContext.passConfig.blankPage;const blankDuration=passContext.passConfig.blankDuration;const pass=GatherRunner.loadBlank(passContext.driver,blankPage,blankDuration).then(()=>passContext.driver.blockUrlPatterns(blockedUrls)).then(()=>passContext.driver.setExtraHTTPHeaders(passContext.settings.extraHeaders));return passContext.passConfig.gatherers.reduce((chain,gathererDefn)=>{return chain.then(_=>{const gatherer=gathererDefn.instance;passContext.options=gathererDefn.options||{};const artifactPromise=Promise.resolve().then(_=>gatherer.beforePass(passContext));gathererResults[gatherer.name]=[artifactPromise];return GatherRunner.recoverOrThrow(artifactPromise);});},pass);}
static pass(passContext,gathererResults){const driver=passContext.driver;const config=passContext.passConfig;const settings=passContext.settings;const gatherers=config.gatherers;const recordTrace=config.recordTrace;const isPerfRun=!settings.disableStorageReset&&recordTrace&&config.useThrottling;const gatherernames=gatherers.map(g=>g.instance.name).join(', ');const status='Loading page & waiting for onload';log.log('status',status,gatherernames);const pass=Promise.resolve().then(_=>{if(isPerfRun)driver.cleanBrowserCaches();}).then(_=>driver.beginDevtoolsLog()).then(_=>{if(recordTrace)driver.beginTrace(settings);}).then(_=>GatherRunner.loadPage(driver,passContext)).then(_=>log.log('statusEnd',status));return gatherers.reduce((chain,gathererDefn)=>{return chain.then(_=>{const gatherer=gathererDefn.instance;passContext.options=gathererDefn.options||{};const artifactPromise=Promise.resolve().then(_=>gatherer.pass(passContext));gathererResults[gatherer.name].push(artifactPromise);return GatherRunner.recoverOrThrow(artifactPromise);});},pass);}
static async afterPass(passContext,gathererResults){const driver=passContext.driver;const config=passContext.passConfig;const gatherers=config.gatherers;let trace;if(config.recordTrace){log.log('status','Retrieving trace');trace=await driver.endTrace();log.verbose('statusEnd','Retrieving trace');}
const status='Retrieving devtoolsLog and network records';log.log('status',status);const devtoolsLog=driver.endDevtoolsLog();const networkRecords=NetworkRecorder.recordsFromLogs(devtoolsLog);log.verbose('statusEnd',status);let pageLoadError=GatherRunner.getPageLoadError(passContext.url,networkRecords);if(!driver.online)pageLoadError=undefined;if(pageLoadError){gathererResults.LighthouseRunWarnings.push('Lighthouse was unable to reliably load the '+'page you requested. Make sure you are testing the correct URL and that the server is '+'properly responding to all requests.');}
const passData={networkRecords,devtoolsLog,trace};await driver.setThrottling(passContext.settings,{useThrottling:false});for(const gathererDefn of gatherers){const gatherer=gathererDefn.instance;const status=`Retrieving: ${gatherer.name}`;log.log('status',status);passContext.options=gathererDefn.options||{};const artifactPromise=pageLoadError?Promise.reject(pageLoadError):Promise.resolve().then(_=>gatherer.afterPass(passContext,passData));gathererResults[gatherer.name].push(artifactPromise);await GatherRunner.recoverOrThrow(artifactPromise);log.verbose('statusEnd',status);}
return passData;}
static async collectArtifacts(gathererResults,tracingData,settings){const artifacts={traces:tracingData.traces,devtoolsLogs:tracingData.devtoolsLogs,settings,LighthouseRunWarnings:Array.from(new Set(gathererResults.LighthouseRunWarnings))};const pageLoadFailures=[];for(const[gathererName,phaseResultsPromises]of Object.entries(gathererResults)){if(artifacts[gathererName]!==undefined)continue;try{const phaseResults=await Promise.all(phaseResultsPromises);const definedResults=phaseResults.filter(element=>element!==undefined);const artifact=definedResults[definedResults.length-1];artifacts[gathererName]=artifact;}catch(err){artifacts[gathererName]=err;if(LHError.isPageLoadError(err))pageLoadFailures.push(err);}
if(artifacts[gathererName]===undefined){throw new Error(`${gathererName} failed to provide an artifact.`);}
if(pageLoadFailures.length>Object.keys(artifacts).length*0.5){throw pageLoadFailures[0];}}
return artifacts;}
static run(passes,options){const driver=options.driver;const tracingData={traces:{},devtoolsLogs:{}};const gathererResults={LighthouseRunWarnings:[],fetchTime:[new Date().toJSON()],URL:[{requestedUrl:options.requestedUrl,finalUrl:''}]};return driver.connect().then(_=>GatherRunner.loadBlank(driver)).then(_=>GatherRunner.setupDriver(driver,gathererResults,options)).then(_=>{return passes.reduce((chain,passConfig,passIndex)=>{const passContext={driver:options.driver,url:options.requestedUrl,settings:options.settings,passConfig};return chain.then(_=>driver.setThrottling(options.settings,passConfig)).then(_=>GatherRunner.beforePass(passContext,gathererResults)).then(_=>GatherRunner.pass(passContext,gathererResults)).then(_=>GatherRunner.afterPass(passContext,gathererResults)).then(passData=>{tracingData.devtoolsLogs[passConfig.passName]=passData.devtoolsLog;if(passData.trace){tracingData.traces[passConfig.passName]=passData.trace;}
if(passIndex===0){gathererResults.URL[0].finalUrl=passContext.url;}});},Promise.resolve());}).then(_=>GatherRunner.disposeDriver(driver)).then(_=>GatherRunner.collectArtifacts(gathererResults,tracingData,options.settings)).catch(err=>{GatherRunner.disposeDriver(driver);throw err;});}}
module.exports=GatherRunner;},{"../config/constants":8,"../gather/driver.js":17,"../lib/errors":33,"../lib/network-recorder.js":37,"../lib/url-shim":"url","lighthouse-logger":143}],19:[function(require,module,exports){'use strict';class Gatherer{get name(){return this.constructor.name;}
beforePass(passContext){}
pass(passContext){}
afterPass(passContext,loadData){}}
module.exports=Gatherer;},{}],20:[function(require,module,exports){'use strict';const isEqual=require('lodash.isequal');module.exports=class ArbitraryEqualityMap{constructor(){this._equalsFn=(a,b)=>a===b;this._entries=[];}
setEqualityFn(equalsFn){this._equalsFn=equalsFn;}
has(key){return this._findIndexOf(key)!==-1;}
get(key){const entry=this._entries[this._findIndexOf(key)];return entry&&entry.value;}
set(key,value){let index=this._findIndexOf(key);if(index===-1)index=this._entries.length;this._entries[index]={key,value};}
_findIndexOf(key){for(let i=0;i<this._entries.length;i++){if(this._equalsFn(key,this._entries[i].key))return i;}
return-1;}
static deepEquals(objA,objB){return isEqual(objA,objB);}};},{"lodash.isequal":144}],21:[function(require,module,exports){'use strict';const path=require('path');const log=require('lighthouse-logger');const stream=require('stream');const Metrics=require('./traces/pwmetrics-events');const TraceParser=require('./traces/trace-parser');const rimraf=require('rimraf');const mkdirp=require('mkdirp');const artifactsFilename='artifacts.json';const traceSuffix='.trace.json';const devtoolsLogSuffix='.devtoolslog.json';function screenshotDump(screenshots){return`
  <!doctype html>
  <meta charset="utf-8">
  <title>screenshots</title>
  <style>
html {
    overflow-x: scroll;
    overflow-y: hidden;
    height: 100%;
    background-image: linear-gradient(to left, #4ca1af , #c4e0e5);
    background-attachment: fixed;
    padding: 10px;
}
body {
    white-space: nowrap;
    background-image: linear-gradient(to left, #4ca1af , #c4e0e5);
    width: 100%;
    margin: 0;
}
img {
    margin: 4px;
}
</style>
  <body>
    <script>
      var shots = ${JSON.stringify(screenshots)};

  shots.forEach(s => {
    var i = document.createElement('img');
    i.src = s.datauri;
    i.title = s.timestamp;
    document.body.appendChild(i);
  });
  </script>
  `;}
async function loadArtifacts(basePath){log.log('Reading artifacts from disk:',basePath);if(!fs.existsSync(basePath)){throw new Error('No saved artifacts found at '+basePath);}
const artifacts=JSON.parse(fs.readFileSync(path.join(basePath,artifactsFilename),'utf8'));const filenames=fs.readdirSync(basePath);artifacts.devtoolsLogs={};filenames.filter(f=>f.endsWith(devtoolsLogSuffix)).map(filename=>{const passName=filename.replace(devtoolsLogSuffix,'');const devtoolsLog=JSON.parse(fs.readFileSync(path.join(basePath,filename),'utf8'));artifacts.devtoolsLogs[passName]=devtoolsLog;});artifacts.traces={};const promises=filenames.filter(f=>f.endsWith(traceSuffix)).map(filename=>{return new Promise(resolve=>{const passName=filename.replace(traceSuffix,'');const readStream=fs.createReadStream(path.join(basePath,filename),{encoding:'utf-8',highWaterMark:4*1024*1024});const parser=new TraceParser();readStream.on('data',chunk=>parser.parseChunk(chunk));readStream.on('end',_=>{artifacts.traces[passName]=parser.getTrace();resolve();});});});await Promise.all(promises);return artifacts;}
async function saveArtifacts(artifacts,basePath){mkdirp.sync(basePath);rimraf.sync(`${basePath}/*${traceSuffix}`);rimraf.sync(`${basePath}/${artifactsFilename}`);const{traces,devtoolsLogs,...restArtifacts}=artifacts;for(const[passName,trace]of Object.entries(traces)){await saveTrace(trace,`${basePath}/${passName}${traceSuffix}`);}
for(const[passName,devtoolsLog]of Object.entries(devtoolsLogs)){const log=JSON.stringify(devtoolsLog);fs.writeFileSync(`${basePath}/${passName}${devtoolsLogSuffix}`,log,'utf8');}
const restArtifactsString=JSON.stringify(restArtifacts,null,2);fs.writeFileSync(`${basePath}/${artifactsFilename}`,restArtifactsString,'utf8');log.log('Artifacts saved to disk in folder:',basePath);}
async function prepareAssets(artifacts,audits){const passNames=Object.keys(artifacts.traces);const assets=[];for(const passName of passNames){const trace=artifacts.traces[passName];const devtoolsLog=artifacts.devtoolsLogs[passName];const Runner=require('../runner.js');const computedArtifacts=Runner.instantiateComputedArtifacts();const screenshots=await computedArtifacts.requestScreenshots(trace);const traceData=Object.assign({},trace);const screenshotsHTML=screenshotDump(screenshots);if(audits){const evts=new Metrics(traceData.traceEvents,audits).generateFakeEvents();traceData.traceEvents=traceData.traceEvents.concat(evts);}
assets.push({passName,traceData,devtoolsLog,screenshotsHTML,screenshots});}
return assets;}
function*traceJsonGenerator(traceData){const keys=Object.keys(traceData);yield'{\n';yield'"traceEvents": [\n';if(traceData.traceEvents.length>0){const eventsIterator=traceData.traceEvents[Symbol.iterator]();const firstEvent=eventsIterator.next().value;yield`  ${JSON.stringify(firstEvent)}`;for(const event of eventsIterator){yield`,\n  ${JSON.stringify(event)}`;}}
yield'\n]';if(keys.length>1){for(const key of keys){if(key==='traceEvents')continue;yield`,\n"${key}": ${JSON.stringify(traceData[key],null,2)}`;}}
yield'}\n';}
function saveTrace(traceData,traceFilename){return new Promise((resolve,reject)=>{const traceIter=traceJsonGenerator(traceData);const traceStream=new stream.Readable({read(){const next=traceIter.next();this.push(next.done?null:next.value);}});const writeStream=fs.createWriteStream(traceFilename);writeStream.on('finish',resolve);writeStream.on('error',reject);traceStream.pipe(writeStream);});}
async function saveAssets(artifacts,audits,pathWithBasename){const allAssets=await prepareAssets(artifacts,audits);const saveAll=allAssets.map(async(passAssets,index)=>{const devtoolsLogFilename=`${pathWithBasename}-${index}${devtoolsLogSuffix}`;fs.writeFileSync(devtoolsLogFilename,JSON.stringify(passAssets.devtoolsLog,null,2));log.log('saveAssets','devtools log saved to disk: '+devtoolsLogFilename);const screenshotsHTMLFilename=`${pathWithBasename}-${index}.screenshots.html`;fs.writeFileSync(screenshotsHTMLFilename,passAssets.screenshotsHTML);log.log('saveAssets','screenshots saved to disk: '+screenshotsHTMLFilename);const screenshotsJSONFilename=`${pathWithBasename}-${index}.screenshots.json`;fs.writeFileSync(screenshotsJSONFilename,JSON.stringify(passAssets.screenshots,null,2));log.log('saveAssets','screenshots saved to disk: '+screenshotsJSONFilename);const streamTraceFilename=`${pathWithBasename}-${index}${traceSuffix}`;log.log('saveAssets','streaming trace file to disk: '+streamTraceFilename);await saveTrace(passAssets.traceData,streamTraceFilename);log.log('saveAssets','trace file streamed to disk: '+streamTraceFilename);});await Promise.all(saveAll);}
async function logAssets(artifacts,audits){const allAssets=await prepareAssets(artifacts,audits);allAssets.map(passAssets=>{log.log(`devtoolslog-${passAssets.passName}.json`,JSON.stringify(passAssets.devtoolsLog));const traceIter=traceJsonGenerator(passAssets.traceData);let traceJson='';for(const trace of traceIter){traceJson+=trace;}
log.log(`trace-${passAssets.passName}.json`,traceJson);});}
module.exports={saveArtifacts,loadArtifacts,saveAssets,prepareAssets,saveTrace,logAssets};},{"../runner.js":50,"./traces/pwmetrics-events":44,"./traces/trace-parser":45,"lighthouse-logger":143,"mkdirp":58,"path":75,"rimraf":58,"stream":92}],22:[function(require,module,exports){'use strict';const log=require('lighthouse-logger');let _logs=[];class ConsoleQuieter{static mute(opts){_logs=_logs||[];console.log=function(...args){_logs.push({type:'log',args,prefix:opts.prefix});};console.warn=function(...args){_logs.push({type:'warn',args,prefix:opts.prefix});};console.error=function(...args){_logs.push({type:'error',args,prefix:opts.prefix});};}
static unmuteAndFlush(){console.log=ConsoleQuieter._consolelog;console.warn=ConsoleQuieter._consolewarn;console.error=ConsoleQuieter._consoleerror;_logs.forEach(entry=>{log.verbose(`${entry.prefix}-${entry.type}`,...entry.args);});_logs=[];}}
ConsoleQuieter._consolelog=console.log.bind(console);ConsoleQuieter._consolewarn=console.warn.bind(console);ConsoleQuieter._consoleerror=console.error.bind(console);module.exports=ConsoleQuieter;},{"lighthouse-logger":143}],23:[function(require,module,exports){'use strict';const Node=require('./node');class CPUNode extends Node{constructor(parentEvent,childEvents=[]){const nodeId=`${parentEvent.tid}.${parentEvent.ts}`;super(nodeId);this._event=parentEvent;this._childEvents=childEvents;}
get type(){return Node.TYPES.CPU;}
get startTime(){return this._event.ts;}
get endTime(){return this._event.ts+this._event.dur;}
get event(){return this._event;}
get childEvents(){return this._childEvents;}
didPerformLayout(){return this._childEvents.some(evt=>evt.name==='Layout');}
isEvaluateScriptFor(urls){return this._childEvents.some(evt=>{return evt.name==='EvaluateScript'&&!!evt.args.data&&!!evt.args.data.url&&urls.has(evt.args.data.url);});}
cloneWithoutRelationships(){return new CPUNode(this._event,this._childEvents);}}
module.exports=CPUNode;},{"./node":25}],24:[function(require,module,exports){'use strict';const Node=require('./node');const WebInspector=require('../web-inspector');class NetworkNode extends Node{constructor(networkRecord){super(networkRecord.requestId);this._record=networkRecord;}
get type(){return Node.TYPES.NETWORK;}
get startTime(){return this._record.startTime*1000*1000;}
get endTime(){return this._record.endTime*1000*1000;}
get record(){return this._record;}
get initiatorType(){return this._record._initiator&&this._record._initiator.type;}
get fromDiskCache(){return!!this._record._fromDiskCache;}
hasRenderBlockingPriority(){const priority=this._record.priority();const isScript=this._record._resourceType===WebInspector.resourceTypes.Script;const isDocument=this._record._resourceType===WebInspector.resourceTypes.Document;const isBlockingScript=priority==='High'&&isScript;const isBlockingHtmlImport=priority==='High'&&isDocument;return priority==='VeryHigh'||isBlockingScript||isBlockingHtmlImport;}
cloneWithoutRelationships(){const node=new NetworkNode(this._record);node.setIsMainDocument(this._isMainDocument);return node;}}
module.exports=NetworkNode;},{"../web-inspector":47,"./node":25}],25:[function(require,module,exports){'use strict';class Node{constructor(id){this._id=id;this._isMainDocument=false;this._dependents=[];this._dependencies=[];}
get id(){return this._id;}
get type(){throw new Error('Unimplemented');}
get startTime(){throw new Error('Unimplemented');}
get endTime(){throw new Error('Unimplemented');}
setIsMainDocument(value){this._isMainDocument=value;}
isMainDocument(){return this._isMainDocument;}
getDependents(){return this._dependents.slice();}
getDependencies(){return this._dependencies.slice();}
getNumberOfDependencies(){return this._dependencies.length;}
getRootNode(){let rootNode=this;while(rootNode._dependencies.length){rootNode=rootNode._dependencies[0];}
return rootNode;}
addDependent(node){node.addDependency(this);}
addDependency(node){if(this._dependencies.includes(node)){return;}
node._dependents.push(this);this._dependencies.push(node);}
removeDependent(node){node.removeDependency(this);}
removeDependency(node){if(!this._dependencies.includes(node)){return;}
node._dependents.splice(node._dependents.indexOf(this),1);this._dependencies.splice(this._dependencies.indexOf(node),1);}
removeAllDependencies(){for(const node of this._dependencies.slice()){this.removeDependency(node);}}
cloneWithoutRelationships(){const node=new Node(this.id);node.setIsMainDocument(this._isMainDocument);return node;}
cloneWithRelationships(predicate){const rootNode=this.getRootNode();let shouldIncludeNode=()=>true;if(predicate){const idsToInclude=new Set();rootNode.traverse(node=>{if(predicate(node)){node.traverse(node=>idsToInclude.add(node.id),node=>node._dependencies.filter(parent=>!idsToInclude.has(parent)));}});shouldIncludeNode=node=>idsToInclude.has(node.id);}
const idToNodeMap=new Map();rootNode.traverse(originalNode=>{if(!shouldIncludeNode(originalNode))return;const clonedNode=originalNode.cloneWithoutRelationships();idToNodeMap.set(clonedNode.id,clonedNode);});rootNode.traverse(originalNode=>{if(!shouldIncludeNode(originalNode))return;const clonedNode=idToNodeMap.get(originalNode.id);for(const dependency of originalNode._dependencies){const clonedDependency=idToNodeMap.get(dependency.id);clonedNode.addDependency(clonedDependency);}});if(!idToNodeMap.has(this.id))throw new Error(`Cloned graph missing node ${this.id}`);return idToNodeMap.get(this.id);}
_traversePaths(iterator,getNext){const stack=[[this]];while(stack.length){const path=stack.shift();const node=path[0];iterator(node,path);const nodesToAdd=getNext(node);for(const nextNode of nodesToAdd){stack.push([nextNode].concat(path));}}}
traverse(iterator,getNext){if(!getNext){getNext=node=>node.getDependents();}
const visited=new Set();const originalGetNext=getNext;getNext=node=>{visited.add(node.id);const allNodesToVisit=originalGetNext(node);const nodesToVisit=allNodesToVisit.filter(nextNode=>!visited.has(nextNode.id));nodesToVisit.forEach(nextNode=>visited.add(nextNode.id));return nodesToVisit;};this._traversePaths(iterator,getNext);}
static hasCycle(node,direction='both'){if(direction==='both'){return Node.hasCycle(node,'dependents')||Node.hasCycle(node,'dependencies');}
const visited=new Set();const currentPath=[];const toVisit=[node];const depthAdded=new Map([[node,0]]);while(toVisit.length){const currentNode=toVisit.pop();if(currentPath.includes(currentNode))return true;if(visited.has(currentNode))continue;while(currentPath.length>depthAdded.get(currentNode))currentPath.pop();visited.add(currentNode);currentPath.push(currentNode);const nodesToExplore=direction==='dependents'?currentNode._dependents:currentNode._dependencies;for(const nextNode of nodesToExplore){if(toVisit.includes(nextNode))continue;toVisit.push(nextNode);depthAdded.set(nextNode,currentPath.length);}}
return false;}}
Node.TYPES={NETWORK:'network',CPU:'cpu'};module.exports=Node;},{}],26:[function(require,module,exports){'use strict';const NetworkAnalyzer=require('./network-analyzer');const TcpConnection=require('./tcp-connection');const DEFAULT_SERVER_RESPONSE_TIME=30;const TLS_SCHEMES=['https','wss'];const CONNECTIONS_PER_ORIGIN=6;module.exports=class ConnectionPool{constructor(records,options){this._options=Object.assign({rtt:undefined,throughput:undefined,additionalRttByOrigin:new Map(),serverResponseTimeByOrigin:new Map()},options);if(!this._options.rtt||!this._options.throughput){throw new Error('Cannot create pool with no rtt or throughput');}
this._records=records;this._connectionsByOrigin=new Map();this._connectionsByRecord=new Map();this._connectionsInUse=new Set();this._connectionReusedByRequestId=NetworkAnalyzer.estimateIfConnectionWasReused(records,{forceCoarseEstimates:true});this._initializeConnections();}
connectionsInUse(){return Array.from(this._connectionsInUse);}
_initializeConnections(){const connectionReused=this._connectionReusedByRequestId;const additionalRttByOrigin=this._options.additionalRttByOrigin;const serverResponseTimeByOrigin=this._options.serverResponseTimeByOrigin;const recordsByOrigin=NetworkAnalyzer.groupByOrigin(this._records);for(const[origin,records]of recordsByOrigin.entries()){const connections=[];const additionalRtt=additionalRttByOrigin.get(origin)||0;const responseTime=serverResponseTimeByOrigin.get(origin)||DEFAULT_SERVER_RESPONSE_TIME;for(const record of records){if(connectionReused.get(record.requestId))continue;const isTLS=TLS_SCHEMES.includes(record.parsedURL.scheme);const isH2=record.protocol==='h2';const connection=new TcpConnection(this._options.rtt+additionalRtt,this._options.throughput,responseTime,isTLS,isH2);connections.push(connection);}
if(!connections.length){throw new Error(`Could not find a connection for origin: ${origin}`);}
while(connections.length<CONNECTIONS_PER_ORIGIN)connections.push(connections[0].clone());this._connectionsByOrigin.set(origin,connections);}}
acquire(record,options={}){if(this._connectionsByRecord.has(record)){return this._connectionsByRecord.get(record);}
const origin=String(record.parsedURL.securityOrigin());const connections=this._connectionsByOrigin.get(origin)||[];const availableConnections=connections.filter(connection=>!this._connectionsInUse.has(connection)).sort((a,b)=>b.congestionWindow-a.congestionWindow);const observedConnectionWasReused=!!this._connectionReusedByRequestId.get(record.requestId);let connectionToUse=availableConnections[0];if(!options.ignoreConnectionReused){connectionToUse=availableConnections.find(connection=>connection.isWarm()===observedConnectionWasReused);}
if(!connectionToUse)return null;this._connectionsInUse.add(connectionToUse);this._connectionsByRecord.set(record,connectionToUse);return connectionToUse;}
release(record){const connection=this._connectionsByRecord.get(record);this._connectionsByRecord.delete(record);this._connectionsInUse.delete(connection);}};},{"./network-analyzer":27,"./tcp-connection":29}],27:[function(require,module,exports){'use strict';const INITIAL_CWD=14*1024;const WebInspector=require('../../web-inspector');class NetworkAnalyzer{static get SUMMARY(){return'__SUMMARY__';}
static groupByOrigin(records){const grouped=new Map();records.forEach(item=>{const key=item.parsedURL.securityOrigin();const group=grouped.get(key)||[];group.push(item);grouped.set(key,group);});return grouped;}
static getSummary(values){values.sort((a,b)=>a-b);return{min:values[0],max:values[values.length-1],avg:values.reduce((a,b)=>a+b,0)/values.length,median:values[Math.floor((values.length-1)/2)]};}
static summarize(values){const summaryByKey=new Map();const allEstimates=[];for(const[key,estimates]of values){summaryByKey.set(key,NetworkAnalyzer.getSummary(estimates));allEstimates.push(...estimates);}
summaryByKey.set(NetworkAnalyzer.SUMMARY,NetworkAnalyzer.getSummary(allEstimates));return summaryByKey;}
static _estimateValueByOrigin(records,iteratee){const connectionWasReused=NetworkAnalyzer.estimateIfConnectionWasReused(records);const groupedByOrigin=NetworkAnalyzer.groupByOrigin(records);const estimates=new Map();for(const[origin,originRecords]of groupedByOrigin.entries()){let originEstimates=[];for(const record of originRecords){const timing=record._timing;if(!timing)continue;const value=iteratee({record,timing,connectionReused:connectionWasReused.get(record.requestId)});if(typeof value!=='undefined'){originEstimates=originEstimates.concat(value);}}
if(!originEstimates.length)continue;estimates.set(origin,originEstimates);}
return estimates;}
static _estimateRTTByOriginViaTCPTiming(records){return NetworkAnalyzer._estimateValueByOrigin(records,({timing,connectionReused})=>{if(connectionReused)return;if(timing.sslStart>0&&timing.sslEnd>0){return[timing.connectEnd-timing.sslStart,timing.sslStart-timing.connectStart];}else if(timing.connectStart>0&&timing.connectEnd>0){return timing.connectEnd-timing.connectStart;}});}
static _estimateRTTByOriginViaDownloadTiming(records){return NetworkAnalyzer._estimateValueByOrigin(records,({record,timing,connectionReused})=>{if(connectionReused)return;if(record.transferSize<=INITIAL_CWD)return;if(!Number.isFinite(timing.receiveHeadersEnd)||timing.receiveHeadersEnd<0)return;const totalTime=(record.endTime-record.startTime)*1000;const downloadTimeAfterFirstByte=totalTime-timing.receiveHeadersEnd;const numberOfRoundTrips=Math.log2(record.transferSize/INITIAL_CWD);if(numberOfRoundTrips>5)return;return downloadTimeAfterFirstByte/numberOfRoundTrips;});}
static _estimateRTTByOriginViaSendStartTiming(records){return NetworkAnalyzer._estimateValueByOrigin(records,({record,timing,connectionReused})=>{if(connectionReused)return;if(!Number.isFinite(timing.sendStart)||timing.sendStart<0)return;let roundTrips=1;if(record.parsedURL.scheme==='https')roundTrips+=1;return timing.sendStart/roundTrips;});}
static _estimateResponseTimeByOrigin(records,rttByOrigin){return NetworkAnalyzer._estimateValueByOrigin(records,({record,timing})=>{if(!Number.isFinite(timing.receiveHeadersEnd)||timing.receiveHeadersEnd<0)return;if(!Number.isFinite(timing.sendEnd)||timing.sendEnd<0)return;const ttfb=timing.receiveHeadersEnd-timing.sendEnd;const origin=record.parsedURL.securityOrigin();const rtt=rttByOrigin.get(origin)||rttByOrigin.get(NetworkAnalyzer.SUMMARY)||0;return Math.max(ttfb-rtt,0);});}
static canTrustConnectionInformation(records){const connectionIdWasStarted=new Map();for(const record of records){const started=connectionIdWasStarted.get(record.connectionId)||!record.connectionReused;connectionIdWasStarted.set(record.connectionId,started);}
if(connectionIdWasStarted.size<=1)return false;return Array.from(connectionIdWasStarted.values()).every(started=>started);}
static estimateIfConnectionWasReused(records,options){options=Object.assign({forceCoarseEstimates:false},options);if(!options.forceCoarseEstimates&&NetworkAnalyzer.canTrustConnectionInformation(records)){return new Map(records.map(record=>[record.requestId,!!record.connectionReused]));}
const connectionWasReused=new Map();const groupedByOrigin=NetworkAnalyzer.groupByOrigin(records);for(const[_,originRecords]of groupedByOrigin.entries()){const earliestReusePossible=originRecords.map(record=>record.endTime).reduce((a,b)=>Math.min(a,b),Infinity);for(const record of originRecords){connectionWasReused.set(record.requestId,record.startTime>=earliestReusePossible||record.protocol==='h2');}
const firstRecord=originRecords.reduce((a,b)=>a.startTime>b.startTime?b:a);connectionWasReused.set(firstRecord.requestId,false);}
return connectionWasReused;}
static estimateRTTByOrigin(records,options){options=Object.assign({forceCoarseEstimates:false,coarseEstimateMultiplier:0.5},options);let estimatesByOrigin=NetworkAnalyzer._estimateRTTByOriginViaTCPTiming(records);if(!estimatesByOrigin.size||options.forceCoarseEstimates){estimatesByOrigin=new Map();const estimatesViaDownload=NetworkAnalyzer._estimateRTTByOriginViaDownloadTiming(records);const estimatesViaSendStart=NetworkAnalyzer._estimateRTTByOriginViaSendStartTiming(records);for(const[origin,estimates]of estimatesViaDownload.entries()){estimatesByOrigin.set(origin,estimates);}
for(const[origin,estimates]of estimatesViaSendStart.entries()){const existing=estimatesByOrigin.get(origin)||[];estimatesByOrigin.set(origin,existing.concat(estimates));}
for(const estimates of estimatesByOrigin.values()){estimates.forEach((x,i)=>estimates[i]=x*options.coarseEstimateMultiplier);}}
if(!estimatesByOrigin.size)throw new Error('No timing information available');return NetworkAnalyzer.summarize(estimatesByOrigin);}
static estimateServerResponseTimeByOrigin(records,options){options=Object.assign({rttByOrigin:null},options);let rttByOrigin=options.rttByOrigin;if(!rttByOrigin){rttByOrigin=NetworkAnalyzer.estimateRTTByOrigin(records,options);for(const[origin,summary]of rttByOrigin.entries()){rttByOrigin.set(origin,summary.min);}}
const estimatesByOrigin=NetworkAnalyzer._estimateResponseTimeByOrigin(records,rttByOrigin);return NetworkAnalyzer.summarize(estimatesByOrigin);}
static findMainDocument(records){const documentRequests=records.filter(record=>record._resourceType===WebInspector.resourceTypes.Document);return documentRequests.sort((a,b)=>a.startTime-b.startTime)[0];}}
module.exports=NetworkAnalyzer;},{"../../web-inspector":47}],28:[function(require,module,exports){'use strict';const Node=require('../node');const NetworkNode=require('../network-node');const CpuNode=require('../cpu-node');const TcpConnection=require('./tcp-connection');const ConnectionPool=require('./connection-pool');const mobile3G=require('../../../config/constants').throttling.mobile3G;const DEFAULT_MAXIMUM_CONCURRENT_REQUESTS=10;const DEFAULT_LAYOUT_TASK_MULTIPLIER=0.5;const DEFAULT_MAXIMUM_CPU_TASK_DURATION=10000;const NodeState={NotReadyToStart:0,ReadyToStart:1,InProgress:2,Complete:3};class Simulator{constructor(options){this._options=Object.assign({rtt:mobile3G.rttMs,throughput:mobile3G.throughputKbps*1024,maximumConcurrentRequests:DEFAULT_MAXIMUM_CONCURRENT_REQUESTS,cpuSlowdownMultiplier:mobile3G.cpuSlowdownMultiplier,layoutTaskMultiplier:DEFAULT_LAYOUT_TASK_MULTIPLIER,additionalRttByOrigin:new Map(),serverResponseTimeByOrigin:new Map()},options);this._rtt=this._options.rtt;this._throughput=this._options.throughput;this._maximumConcurrentRequests=Math.max(Math.min(TcpConnection.maximumSaturatedConnections(this._rtt,this._throughput),this._options.maximumConcurrentRequests),1);this._cpuSlowdownMultiplier=this._options.cpuSlowdownMultiplier;this._layoutTaskMultiplier=this._cpuSlowdownMultiplier*this._options.layoutTaskMultiplier;this._flexibleOrdering=false;this._nodeTimings=new Map();this._numberInProgressByType=new Map();this._nodes={};this._connectionPool=null;}
_initializeConnectionPool(graph){const records=[];graph.getRootNode().traverse(node=>{if(node.type===Node.TYPES.NETWORK){records.push(node.record);}});this._connectionPool=new ConnectionPool(records,this._options);}
_initializeAuxiliaryData(){this._nodeTimings=new Map();this._numberInProgressByType=new Map();this._nodes={};for(const key of Object.keys(NodeState)){this._nodes[NodeState[key]]=new Set();}}
_numberInProgress(type){return this._numberInProgressByType.get(type)||0;}
_setTimingData(node,values){const timingData=this._nodeTimings.get(node)||{};Object.assign(timingData,values);this._nodeTimings.set(node,timingData);}
_markNodeAsReadyToStart(node,queuedTime){this._nodes[NodeState.ReadyToStart].add(node);this._nodes[NodeState.NotReadyToStart].delete(node);this._setTimingData(node,{queuedTime});}
_markNodeAsInProgress(node,startTime){this._nodes[NodeState.InProgress].add(node);this._nodes[NodeState.ReadyToStart].delete(node);this._numberInProgressByType.set(node.type,this._numberInProgress(node.type)+1);this._setTimingData(node,{startTime});}
_markNodeAsComplete(node,endTime){this._nodes[NodeState.Complete].add(node);this._nodes[NodeState.InProgress].delete(node);this._numberInProgressByType.set(node.type,this._numberInProgress(node.type)-1);this._setTimingData(node,{endTime});for(const dependent of node.getDependents()){const dependencies=dependent.getDependencies();if(dependencies.some(dep=>!this._nodes[NodeState.Complete].has(dep)))continue;this._markNodeAsReadyToStart(dependent,endTime);}}
_acquireConnection(record){return this._connectionPool.acquire(record,{ignoreConnectionReused:this._flexibleOrdering});}
_startNodeIfPossible(node,totalElapsedTime){if(node.type===Node.TYPES.CPU){if(this._numberInProgress(node.type)===0){this._markNodeAsInProgress(node,totalElapsedTime);this._setTimingData(node,{timeElapsed:0});}
return;}
if(node.type!==Node.TYPES.NETWORK)throw new Error('Unsupported');const networkNode=node;if(!networkNode.fromDiskCache){const numberOfActiveRequests=this._numberInProgress(node.type);if(numberOfActiveRequests>=this._maximumConcurrentRequests)return;const connection=this._acquireConnection(networkNode.record);if(!connection)return;}
this._markNodeAsInProgress(node,totalElapsedTime);this._setTimingData(node,{timeElapsed:0,timeElapsedOvershoot:0,bytesDownloaded:0});}
_updateNetworkCapacity(){for(const connection of this._connectionPool.connectionsInUse()){connection.setThroughput(this._throughput/this._nodes[NodeState.InProgress].size);}}
_estimateTimeRemaining(node){if(node.type===Node.TYPES.CPU){return this._estimateCPUTimeRemaining(node);}else if(node.type===Node.TYPES.NETWORK){return this._estimateNetworkTimeRemaining(node);}else{throw new Error('Unsupported');}}
_estimateCPUTimeRemaining(cpuNode){const timingData=this._nodeTimings.get(cpuNode);const multiplier=cpuNode.didPerformLayout()?this._layoutTaskMultiplier:this._cpuSlowdownMultiplier;const totalDuration=Math.min(Math.round(cpuNode.event.dur/1000*multiplier),DEFAULT_MAXIMUM_CPU_TASK_DURATION);const estimatedTimeElapsed=totalDuration-timingData.timeElapsed;this._setTimingData(cpuNode,{estimatedTimeElapsed});return estimatedTimeElapsed;}
_estimateNetworkTimeRemaining(networkNode){const timingData=this._nodeTimings.get(networkNode);let timeElapsed=0;if(networkNode.fromDiskCache){const sizeInMb=(networkNode.record._resourceSize||0)/1024/1024;timeElapsed=8+20*sizeInMb-timingData.timeElapsed;}else{const connection=this._acquireConnection(networkNode.record);const calculation=connection.simulateDownloadUntil(networkNode.record.transferSize-timingData.bytesDownloaded,{timeAlreadyElapsed:timingData.timeElapsed,maximumTimeToElapse:Infinity});timeElapsed=calculation.timeElapsed;}
const estimatedTimeElapsed=timeElapsed+timingData.timeElapsedOvershoot;this._setTimingData(networkNode,{estimatedTimeElapsed});return estimatedTimeElapsed;}
_findNextNodeCompletionTime(){let minimumTime=Infinity;for(const node of this._nodes[NodeState.InProgress]){minimumTime=Math.min(minimumTime,this._estimateTimeRemaining(node));}
return minimumTime;}
_updateProgressMadeInTimePeriod(node,timePeriodLength,totalElapsedTime){const timingData=this._nodeTimings.get(node);const isFinished=timingData.estimatedTimeElapsed===timePeriodLength;const networkNode=node;if(node.type===Node.TYPES.CPU||networkNode.fromDiskCache){return isFinished?this._markNodeAsComplete(node,totalElapsedTime):timingData.timeElapsed+=timePeriodLength;}
if(node.type!==Node.TYPES.NETWORK)throw new Error('Unsupported');const record=networkNode.record;const connection=this._acquireConnection(record);const calculation=connection.simulateDownloadUntil(record.transferSize-timingData.bytesDownloaded,{timeAlreadyElapsed:timingData.timeElapsed,maximumTimeToElapse:timePeriodLength-timingData.timeElapsedOvershoot});connection.setCongestionWindow(calculation.congestionWindow);connection.setH2OverflowBytesDownloaded(calculation.extraBytesDownloaded);if(isFinished){connection.setWarmed(true);this._connectionPool.release(record);this._markNodeAsComplete(node,totalElapsedTime);}else{timingData.timeElapsed+=calculation.timeElapsed;timingData.timeElapsedOvershoot+=calculation.timeElapsed-timePeriodLength;timingData.bytesDownloaded+=calculation.bytesDownloaded;}}
getOptions(){return this._options;}
simulate(graph,options){if(Node.hasCycle(graph)){throw new Error('Cannot simulate graph with cycle');}
options=Object.assign({flexibleOrdering:false},options);this._flexibleOrdering=!!options.flexibleOrdering;this._initializeConnectionPool(graph);this._initializeAuxiliaryData();const nodesNotReadyToStart=this._nodes[NodeState.NotReadyToStart];const nodesReadyToStart=this._nodes[NodeState.ReadyToStart];const nodesInProgress=this._nodes[NodeState.InProgress];const rootNode=graph.getRootNode();rootNode.traverse(node=>nodesNotReadyToStart.add(node));let totalElapsedTime=0;let iteration=0;this._markNodeAsReadyToStart(rootNode,totalElapsedTime);while(nodesReadyToStart.size||nodesInProgress.size){for(const node of nodesReadyToStart){this._startNodeIfPossible(node,totalElapsedTime);}
if(!nodesInProgress.size){if(this._flexibleOrdering)throw new Error('Failed to start a node');this._flexibleOrdering=true;continue;}
this._updateNetworkCapacity();const minimumTime=this._findNextNodeCompletionTime();totalElapsedTime+=minimumTime;if(!Number.isFinite(minimumTime)||iteration>100000){throw new Error('Graph creation failed, depth exceeded');}
iteration++;for(const node of nodesInProgress){this._updateProgressMadeInTimePeriod(node,minimumTime,totalElapsedTime);}}
return{timeInMs:totalElapsedTime,nodeTimings:this._nodeTimings};}}
module.exports=Simulator;},{"../../../config/constants":8,"../cpu-node":23,"../network-node":24,"../node":25,"./connection-pool":26,"./tcp-connection":29}],29:[function(require,module,exports){'use strict';const INITIAL_CONGESTION_WINDOW=10;const TCP_SEGMENT_SIZE=1460;class TcpConnection{constructor(rtt,throughput,serverLatency=0,ssl=true,h2=false){this._warmed=false;this._ssl=ssl;this._h2=h2;this._rtt=rtt;this._throughput=throughput;this._serverLatency=serverLatency;this._congestionWindow=INITIAL_CONGESTION_WINDOW;this._h2OverflowBytesDownloaded=0;}
static maximumSaturatedConnections(rtt,availableThroughput){const roundTripsPerSecond=1000/rtt;const bytesPerRoundTrip=TCP_SEGMENT_SIZE;const bytesPerSecond=roundTripsPerSecond*bytesPerRoundTrip;const minimumThroughputRequiredPerRequest=bytesPerSecond*8;return Math.floor(availableThroughput/minimumThroughputRequiredPerRequest);}
_computeMaximumCongestionWindowInSegments(){const bytesPerSecond=this._throughput/8;const secondsPerRoundTrip=this._rtt/1000;const bytesPerRoundTrip=bytesPerSecond*secondsPerRoundTrip;return Math.floor(bytesPerRoundTrip/TCP_SEGMENT_SIZE);}
setThroughput(throughput){this._throughput=throughput;}
setCongestionWindow(congestion){this._congestionWindow=congestion;}
setWarmed(warmed){this._warmed=warmed;}
isWarm(){return this._warmed;}
isH2(){return this._h2;}
get congestionWindow(){return this._congestionWindow;}
setH2OverflowBytesDownloaded(bytes){if(!this._h2)return;this._h2OverflowBytesDownloaded=bytes;}
clone(){return Object.assign(new TcpConnection(this._rtt,this._throughput),this);}
simulateDownloadUntil(bytesToDownload,options){const{timeAlreadyElapsed=0,maximumTimeToElapse=Infinity}=options||{};if(this._warmed&&this._h2){bytesToDownload-=this._h2OverflowBytesDownloaded;}
const twoWayLatency=this._rtt;const oneWayLatency=twoWayLatency/2;const maximumCongestionWindow=this._computeMaximumCongestionWindowInSegments();let handshakeAndRequest=oneWayLatency;if(!this._warmed){handshakeAndRequest=oneWayLatency+
oneWayLatency+
oneWayLatency+(this._ssl?twoWayLatency:0);}
let roundTrips=Math.ceil(handshakeAndRequest/twoWayLatency);let timeToFirstByte=handshakeAndRequest+this._serverLatency+oneWayLatency;if(this._warmed&&this._h2)timeToFirstByte=0;const timeElapsedForTTFB=Math.max(timeToFirstByte-timeAlreadyElapsed,0);const maximumDownloadTimeToElapse=maximumTimeToElapse-timeElapsedForTTFB;let congestionWindow=Math.min(this._congestionWindow,maximumCongestionWindow);let totalBytesDownloaded=0;if(timeElapsedForTTFB>0){totalBytesDownloaded=congestionWindow*TCP_SEGMENT_SIZE;}else{roundTrips=0;}
let downloadTimeElapsed=0;let bytesRemaining=bytesToDownload-totalBytesDownloaded;while(bytesRemaining>0&&downloadTimeElapsed<=maximumDownloadTimeToElapse){roundTrips++;downloadTimeElapsed+=twoWayLatency;congestionWindow=Math.max(Math.min(maximumCongestionWindow,congestionWindow*2),1);const bytesDownloadedInWindow=congestionWindow*TCP_SEGMENT_SIZE;totalBytesDownloaded+=bytesDownloadedInWindow;bytesRemaining-=bytesDownloadedInWindow;}
const timeElapsed=timeElapsedForTTFB+downloadTimeElapsed;const extraBytesDownloaded=this._h2?Math.max(totalBytesDownloaded-bytesToDownload,0):0;const bytesDownloaded=Math.max(Math.min(totalBytesDownloaded,bytesToDownload),0);return{roundTrips,timeElapsed,bytesDownloaded,extraBytesDownloaded,congestionWindow};}}
module.exports=TcpConnection;},{}],30:[function(require,module,exports){'use strict';function getElementsInDocument(selector){const results=[];const _findAllElements=nodes=>{for(let i=0,el;el=nodes[i];++i){if(!selector||el.matches(selector)){results.push(el);}
if(el.shadowRoot){_findAllElements(el.shadowRoot.querySelectorAll('*'));}}};_findAllElements(document.querySelectorAll('*'));return results;}
module.exports={getElementsInDocumentFnString:getElementsInDocument.toString()};},{}],31:[function(require,module,exports){'use strict';const Driver=require('../gather/driver.js');class Element{constructor(element,driver){if(!element||!driver){throw Error('Driver and element required to create Element');}
this.driver=driver;this.element=element;}
getAttribute(name){return this.driver.sendCommand('DOM.getAttributes',{nodeId:this.element.nodeId}).then(resp=>{const attrIndex=resp.attributes.indexOf(name);if(attrIndex===-1){return null;}
return resp.attributes[attrIndex+1];});}
getNodeId(){return this.element.nodeId;}
getProperty(propName){return this.driver.sendCommand('DOM.resolveNode',{nodeId:this.element.nodeId}).then(resp=>{if(!resp.object.objectId){return null;}
return this.driver.getObjectProperty(resp.object.objectId,propName);});}}
module.exports=Element;},{"../gather/driver.js":17}],32:[function(require,module,exports){'use strict';const Driver=require('../gather/driver');const mobile3G=require('../config/constants').throttling.mobile3G;const NEXUS5X_EMULATION_METRICS={mobile:true,screenWidth:412,screenHeight:732,width:412,height:732,positionX:0,positionY:0,scale:1,deviceScaleFactor:2.625,screenOrientation:{angle:0,type:'portraitPrimary'}};const NEXUS5X_USERAGENT={userAgent:'Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5 Build/MRA58N) AppleWebKit/537.36'+'(KHTML, like Gecko) Chrome/66.0.3359.30 Mobile Safari/537.36'};const OFFLINE_METRICS={offline:true,latency:0,downloadThroughput:0,uploadThroughput:0};const NO_THROTTLING_METRICS={latency:0,downloadThroughput:0,uploadThroughput:0,offline:false};const NO_CPU_THROTTLE_METRICS={rate:1};const CPU_THROTTLE_METRICS={rate:4};function enableNexus5X(driver){return Promise.all([driver.sendCommand('Emulation.setDeviceMetricsOverride',NEXUS5X_EMULATION_METRICS),driver.sendCommand('Network.enable'),driver.sendCommand('Network.setUserAgentOverride',NEXUS5X_USERAGENT),driver.sendCommand('Emulation.setEmitTouchEventsForMouse',{enabled:true,configuration:'mobile'})]);}
function enableNetworkThrottling(driver,throttlingSettings=mobile3G){const conditions={offline:false,latency:throttlingSettings.requestLatencyMs||0,downloadThroughput:throttlingSettings.downloadThroughputKbps||0,uploadThroughput:throttlingSettings.uploadThroughputKbps||0};conditions.downloadThroughput=Math.floor(conditions.downloadThroughput*1024/8);conditions.uploadThroughput=Math.floor(conditions.uploadThroughput*1024/8);return driver.sendCommand('Network.emulateNetworkConditions',conditions);}
function clearAllNetworkEmulation(driver){return driver.sendCommand('Network.emulateNetworkConditions',NO_THROTTLING_METRICS);}
function goOffline(driver){return driver.sendCommand('Network.emulateNetworkConditions',OFFLINE_METRICS);}
function enableCPUThrottling(driver,throttlingSettings){const rate=throttlingSettings&&throttlingSettings.cpuSlowdownMultiplier!==undefined?throttlingSettings.cpuSlowdownMultiplier:CPU_THROTTLE_METRICS.rate;return driver.sendCommand('Emulation.setCPUThrottlingRate',{rate});}
function disableCPUThrottling(driver){return driver.sendCommand('Emulation.setCPUThrottlingRate',NO_CPU_THROTTLE_METRICS);}
module.exports={enableNexus5X,enableNetworkThrottling,clearAllNetworkEmulation,enableCPUThrottling,disableCPUThrottling,goOffline};},{"../config/constants":8,"../gather/driver":17}],33:[function(require,module,exports){'use strict';const strings=require('./strings');class LighthouseError extends Error{constructor(errorDefinition,properties){super(errorDefinition.code);this.name='LHError';this.code=errorDefinition.code;this.friendlyMessage=errorDefinition.message;if(properties)Object.assign(this,properties);Error.captureStackTrace(this,LighthouseError);}
static isPageLoadError(err){return err.code===ERRORS.NO_DOCUMENT_REQUEST.code||err.code===ERRORS.FAILED_DOCUMENT_REQUEST.code;}
static fromProtocolMessage(method,protocolError){const protocolErrors=Object.keys(ERRORS).filter(k=>ERRORS[k].pattern).map(k=>ERRORS[k]);const matchedErrorDefinition=protocolErrors.find(e=>e.pattern.test(protocolError.message));if(matchedErrorDefinition){return new LighthouseError(matchedErrorDefinition,{protocolMethod:method,protocolError:protocolError.message});}
let errMsg=`(${method}): ${protocolError.message}`;if(protocolError.data)errMsg+=` (${protocolError.data})`;const error=new Error(`Protocol error ${errMsg}`);return Object.assign(error,{protocolMethod:method,protocolError:protocolError.message});}}
const ERRORS={NO_SPEEDLINE_FRAMES:{message:strings.didntCollectScreenshots},SPEEDINDEX_OF_ZERO:{message:strings.didntCollectScreenshots},NO_SCREENSHOTS:{message:strings.didntCollectScreenshots},INVALID_SPEEDLINE:{message:strings.didntCollectScreenshots},NO_TRACING_STARTED:{message:strings.badTraceRecording},NO_NAVSTART:{message:strings.badTraceRecording},NO_FCP:{message:strings.badTraceRecording},NO_FMP:{message:strings.badTraceRecording},NO_DCL:{message:strings.badTraceRecording},FMP_TOO_LATE_FOR_FCPUI:{message:strings.pageLoadTookTooLong},NO_FCPUI_IDLE_PERIOD:{message:strings.pageLoadTookTooLong},NO_TTI_CPU_IDLE_PERIOD:{message:strings.pageLoadTookTooLong},NO_TTI_NETWORK_IDLE_PERIOD:{message:strings.pageLoadTookTooLong},NO_DOCUMENT_REQUEST:{message:strings.pageLoadFailed},FAILED_DOCUMENT_REQUEST:{message:strings.pageLoadFailed},TRACING_ALREADY_STARTED:{message:strings.internalChromeError,pattern:/Tracing.*started/},PARSING_PROBLEM:{message:strings.internalChromeError,pattern:/Parsing problem/},READ_FAILED:{message:strings.internalChromeError,pattern:/Read failed/},REQUEST_CONTENT_TIMEOUT:{message:strings.requestContentTimeout}};Object.keys(ERRORS).forEach(code=>ERRORS[code].code=code);LighthouseError.errors=ERRORS;module.exports=LighthouseError;},{"./strings":41}],34:[function(require,module,exports){'use strict';function addFormattedCodeSnippet(listener){const handler=listener.handler?listener.handler.description:'...';const objectName=listener.objectName.toLowerCase().replace('#document','document');return Object.assign({pre:`${objectName}.addEventListener('${listener.type}', ${handler})`},listener);}
function groupCodeSnippetsByLocation(listeners){const locToListenerMap=new Map();listeners.forEach(loc=>{const accPre=loc.pre.trim()+'\n\n';const simplifiedLoc={line:loc.line,col:loc.col,url:loc.url,type:loc.type,pre:''};const key=JSON.stringify(simplifiedLoc);const accListener=locToListenerMap.get(key)||simplifiedLoc;accListener.pre+=accPre;locToListenerMap.set(key,accListener);});return[...locToListenerMap.values()];}
module.exports={addFormattedCodeSnippet,groupCodeSnippetsByLocation};},{}],35:[function(require,module,exports){'use strict';function doExist(manifest){if(!manifest||!manifest.icons){return false;}
if(manifest.icons.value.length===0){return false;}
return true;}
function sizeAtLeast(sizeRequirement,manifest){const iconValues=manifest.icons.value;const flattenedSizes=[];iconValues.forEach(icon=>{if(icon.value.sizes.value){flattenedSizes.push(...icon.value.sizes.value);}});return flattenedSizes.filter(size=>/\d+x\d+/.test(size)).filter(size=>{const sizeStrs=size.split(/x/i);const sizeNums=[parseFloat(sizeStrs[0]),parseFloat(sizeStrs[1])];const areIconsBigEnough=sizeNums[0]>=sizeRequirement&&sizeNums[1]>=sizeRequirement;const areIconsSquare=sizeNums[0]===sizeNums[1];return areIconsBigEnough&&areIconsSquare;});}
module.exports={doExist,sizeAtLeast};},{}],36:[function(require,module,exports){'use strict';const URL=require('./url-shim');const validateColor=require('./web-inspector').Color.parse;const ALLOWED_DISPLAY_VALUES=['fullscreen','standalone','minimal-ui','browser'];const DEFAULT_DISPLAY_MODE='browser';const ALLOWED_ORIENTATION_VALUES=['any','natural','landscape','portrait','portrait-primary','portrait-secondary','landscape-primary','landscape-secondary'];function parseString(raw,trim){let value;let debugString;if(typeof raw==='string'){value=trim?raw.trim():raw;}else{if(raw!==undefined){debugString='ERROR: expected a string.';}
value=undefined;}
return{raw,value,debugString};}
function parseColor(raw){const color=parseString(raw);if(color.value===undefined){return color;}
const validatedColor=validateColor(color.raw);if(!validatedColor){color.value=undefined;color.debugString='ERROR: color parsing failed.';}
return color;}
function parseName(jsonInput){return parseString(jsonInput.name,true);}
function parseShortName(jsonInput){return parseString(jsonInput.short_name,true);}
function checkSameOrigin(url1,url2){const parsed1=new URL(url1);const parsed2=new URL(url2);return parsed1.origin===parsed2.origin;}
function parseStartUrl(jsonInput,manifestUrl,documentUrl){const raw=jsonInput.start_url;if(raw===''){return{raw,value:documentUrl,debugString:'ERROR: start_url string empty'};}
const parsedAsString=parseString(raw);if(!parsedAsString.value){parsedAsString.value=documentUrl;return parsedAsString;}
let startUrl;try{startUrl=new URL(raw,manifestUrl).href;}catch(e){return{raw,value:documentUrl,debugString:'ERROR: invalid start_url relative to ${manifestUrl}'};}
if(!checkSameOrigin(startUrl,documentUrl)){return{raw,value:documentUrl,debugString:'ERROR: start_url must be same-origin as document'};}
return{raw,value:startUrl};}
function parseDisplay(jsonInput){const parsedString=parseString(jsonInput.display,true);const stringValue=parsedString.value;if(!stringValue){return{raw:jsonInput,value:DEFAULT_DISPLAY_MODE,debugString:parsedString.debugString};}
const displayValue=stringValue.toLowerCase();if(!ALLOWED_DISPLAY_VALUES.includes(displayValue)){return{raw:jsonInput,value:DEFAULT_DISPLAY_MODE,debugString:'ERROR: \'display\' has invalid value '+displayValue+`. will fall back to ${DEFAULT_DISPLAY_MODE}.`};}
return{raw:jsonInput,value:displayValue,debugString:undefined};}
function parseOrientation(jsonInput){const orientation=parseString(jsonInput.orientation,true);if(orientation.value&&!ALLOWED_ORIENTATION_VALUES.includes(orientation.value.toLowerCase())){orientation.value=undefined;orientation.debugString='ERROR: \'orientation\' has an invalid value, will be ignored.';}
return orientation;}
function parseIcon(raw,manifestUrl){const src=parseString(raw.src,true);if(src.value===''){src.value=undefined;}
if(src.value){src.value=new URL(src.value,manifestUrl).href;}
const type=parseString(raw.type,true);const density={raw:raw.density,value:1,debugString:undefined};if(density.raw!==undefined){density.value=parseFloat(density.raw);if(isNaN(density.value)||!isFinite(density.value)||density.value<=0){density.value=1;density.debugString='ERROR: icon density cannot be NaN, +∞, or less than or equal to +0.';}}
let sizes;const parsedSizes=parseString(raw.sizes);if(parsedSizes.value!==undefined){const set=new Set();parsedSizes.value.trim().split(/\s+/).forEach(size=>set.add(size.toLowerCase()));sizes={raw:raw.sizes,value:set.size>0?Array.from(set):undefined,debugString:undefined};}else{sizes={...parsedSizes,value:undefined};}
return{raw,value:{src,type,density,sizes},debugString:undefined};}
function parseIcons(jsonInput,manifestUrl){const raw=jsonInput.icons;if(raw===undefined){return{raw,value:[],debugString:undefined};}
if(!Array.isArray(raw)){return{raw,value:[],debugString:'ERROR: \'icons\' expected to be an array but is not.'};}
const value=raw.filter(icon=>icon.src!==undefined).map(icon=>parseIcon(icon,manifestUrl)).filter(parsedIcon=>parsedIcon.value.src.value!==undefined);return{raw,value,debugString:undefined};}
function parseApplication(raw){const platform=parseString(raw.platform,true);const id=parseString(raw.id,true);const appUrl=parseString(raw.url,true);if(appUrl.value){try{appUrl.value=new URL(appUrl.value).href;}catch(e){appUrl.value=undefined;appUrl.debugString='ERROR: invalid application URL ${raw.url}';}}
return{raw,value:{platform,id,url:appUrl},debugString:undefined};}
function parseRelatedApplications(jsonInput){const raw=jsonInput.related_applications;if(raw===undefined){return{raw,value:undefined,debugString:undefined};}
if(!Array.isArray(raw)){return{raw,value:undefined,debugString:'ERROR: \'related_applications\' expected to be an array but is not.'};}
const value=raw.filter(application=>!!application.platform).map(parseApplication).filter(parsedApp=>!!parsedApp.value.id.value||!!parsedApp.value.url.value);return{raw,value,debugString:undefined};}
function parsePreferRelatedApplications(jsonInput){const raw=jsonInput.prefer_related_applications;let value;let debugString;if(typeof raw==='boolean'){value=raw;}else{if(raw!==undefined){debugString='ERROR: \'prefer_related_applications\' expected to be a boolean.';}
value=undefined;}
return{raw,value,debugString};}
function parseThemeColor(jsonInput){return parseColor(jsonInput.theme_color);}
function parseBackgroundColor(jsonInput){return parseColor(jsonInput.background_color);}
function parse(string,manifestUrl,documentUrl){if(manifestUrl===undefined||documentUrl===undefined){throw new Error('Manifest and document URLs required for manifest parsing.');}
let jsonInput;try{jsonInput=JSON.parse(string);}catch(e){return{raw:string,value:undefined,debugString:'ERROR: file isn\'t valid JSON: '+e};}
const manifest={name:parseName(jsonInput),short_name:parseShortName(jsonInput),start_url:parseStartUrl(jsonInput,manifestUrl,documentUrl),display:parseDisplay(jsonInput),orientation:parseOrientation(jsonInput),icons:parseIcons(jsonInput,manifestUrl),related_applications:parseRelatedApplications(jsonInput),prefer_related_applications:parsePreferRelatedApplications(jsonInput),theme_color:parseThemeColor(jsonInput),background_color:parseBackgroundColor(jsonInput)};return{raw:string,value:manifest,debugString:undefined};}
module.exports=parse;},{"./url-shim":"url","./web-inspector":47}],37:[function(require,module,exports){'use strict';const NetworkManager=require('./web-inspector').NetworkManager;const EventEmitter=require('events').EventEmitter;const log=require('lighthouse-logger');const IGNORED_NETWORK_SCHEMES=['data','ws'];class NetworkRecorder extends EventEmitter{constructor(recordArray){super();this._records=recordArray;this.networkManager=NetworkManager.createWithFakeTarget();this.networkManager.addEventListener(this.EventTypes.RequestStarted,this.onRequestStarted.bind(this));this.networkManager.addEventListener(this.EventTypes.RequestFinished,this.onRequestFinished.bind(this));}
on(event,listener){return super.on(event,listener);}
once(event,listener){return super.once(event,listener);}
get EventTypes(){return NetworkManager.Events;}
isIdle(){return!!this._getActiveIdlePeriod(0);}
is2Idle(){return!!this._getActiveIdlePeriod(2);}
_getActiveIdlePeriod(allowedRequests){const quietPeriods=NetworkRecorder.findNetworkQuietPeriods(this._records,allowedRequests);return quietPeriods.find(period=>!Number.isFinite(period.end));}
_emitNetworkStatus(){const zeroQuiet=this._getActiveIdlePeriod(0);const twoQuiet=this._getActiveIdlePeriod(2);if(twoQuiet&&zeroQuiet){log.verbose('NetworkRecorder','network fully-quiet');this.emit('network-2-idle');this.emit('networkidle');}else if(twoQuiet&&!zeroQuiet){log.verbose('NetworkRecorder','network semi-quiet');this.emit('network-2-idle');this.emit('networkbusy');}else{log.verbose('NetworkRecorder','network busy');this.emit('network-2-busy');this.emit('networkbusy');}}
static _isQUICAndFinished(record){const isQUIC=record._responseHeaders&&record._responseHeaders.some(header=>header.name.toLowerCase()==='alt-svc'&&/quic/.test(header.value));const receivedHeaders=record._timing&&record._timing.receiveHeadersEnd>0;return!!(isQUIC&&receivedHeaders&&record.endTime);}
static findNetworkQuietPeriods(networkRecords,allowedConcurrentRequests,endTime=Infinity){let timeBoundaries=[];networkRecords.forEach(record=>{const scheme=record.parsedURL&&record.parsedURL.scheme;if(IGNORED_NETWORK_SCHEMES.includes(scheme)){return;}
timeBoundaries.push({time:record.startTime*1000,isStart:true});if(record.finished||NetworkRecorder._isQUICAndFinished(record)){timeBoundaries.push({time:record.endTime*1000,isStart:false});}});timeBoundaries=timeBoundaries.filter(boundary=>boundary.time<=endTime).sort((a,b)=>a.time-b.time);let numInflightRequests=0;let quietPeriodStart=0;const quietPeriods=[];timeBoundaries.forEach(boundary=>{if(boundary.isStart){if(numInflightRequests===allowedConcurrentRequests){quietPeriods.push({start:quietPeriodStart,end:boundary.time});}
numInflightRequests++;}else{numInflightRequests--;if(numInflightRequests===allowedConcurrentRequests){quietPeriodStart=boundary.time;}}});if(numInflightRequests<=allowedConcurrentRequests){quietPeriods.push({start:quietPeriodStart,end:endTime});}
return quietPeriods.filter(period=>period.start!==period.end);}
onRequestStarted(request){this._records.push(request.data);this._emitNetworkStatus();}
onRequestFinished(request){this.emit('requestloaded',request.data);this._emitNetworkStatus();}
onRequestWillBeSent(data){this.networkManager._dispatcher.requestWillBeSent(data.requestId,data.frameId,data.loaderId,data.documentURL,data.request,data.timestamp,data.wallTime,data.initiator,data.redirectResponse,data.type);}
onRequestServedFromCache(data){this.networkManager._dispatcher.requestServedFromCache(data.requestId);}
onResponseReceived(data){this.networkManager._dispatcher.responseReceived(data.requestId,data.frameId,data.loaderId,data.timestamp,data.type,data.response);}
onDataReceived(data){this.networkManager._dispatcher.dataReceived(data.requestId,data.timestamp,data.dataLength,data.encodedDataLength);}
onLoadingFinished(data){this.networkManager._dispatcher.loadingFinished(data.requestId,data.timestamp,data.encodedDataLength);}
onLoadingFailed(data){this.networkManager._dispatcher.loadingFailed(data.requestId,data.timestamp,data.type,data.errorText,data.canceled,data.blockedReason);}
onResourceChangedPriority(data){this.networkManager._dispatcher.resourceChangedPriority(data.requestId,data.newPriority,data.timestamp);}
dispatch(event){if(!event.method.startsWith('Network.')){return;}
switch(event.method){case'Network.requestWillBeSent':return this.onRequestWillBeSent(event.params);case'Network.requestServedFromCache':return this.onRequestServedFromCache(event.params);case'Network.responseReceived':return this.onResponseReceived(event.params);case'Network.dataReceived':return this.onDataReceived(event.params);case'Network.loadingFinished':return this.onLoadingFinished(event.params);case'Network.loadingFailed':return this.onLoadingFailed(event.params);case'Network.resourceChangedPriority':return this.onResourceChangedPriority(event.params);default:return;}}
static recordsFromLogs(devtoolsLog){const records=[];const nr=new NetworkRecorder(records);devtoolsLog.forEach(message=>{nr.dispatch(message);});return records;}}
module.exports=NetworkRecorder;},{"./web-inspector":47,"events":62,"lighthouse-logger":143}],38:[function(require,module,exports){'use strict';function captureJSCallUsage(funcRef,set){const __nativeError=window.__nativeError||Error;const originalFunc=funcRef;const originalPrepareStackTrace=__nativeError.prepareStackTrace;return function(...args){__nativeError.prepareStackTrace=function(error,structStackTrace){const callFrame=structStackTrace[1];let url=callFrame.getFileName()||callFrame.getEvalOrigin();const line=callFrame.getLineNumber();const col=callFrame.getColumnNumber();const isEval=callFrame.isEval();let isExtension=false;const stackTrace=structStackTrace.slice(1).map(callsite=>callsite.toString());if(isEval){url=stackTrace[1];}
if(stackTrace[0].startsWith('<anonymous>')){url=stackTrace[0];isExtension=true;}
return{url,args,line,col,isEval,isExtension};};const e=new __nativeError(`__called ${funcRef.name}__`);set.add(JSON.stringify(e.stack));__nativeError.prepareStackTrace=originalPrepareStackTrace;return originalFunc.apply(this,args);};}
function wrapRuntimeEvalErrorInBrowser(err){err=err||new Error();const fallbackMessage=typeof err==='string'?err:'unknown error';return{__failedInBrowser:true,name:err.name||'Error',message:err.message||fallbackMessage,stack:err.stack||new Error().stack};}
function registerPerformanceObserverInPage(){window.____lastLongTask=window.performance.now();const observer=new window.PerformanceObserver(entryList=>{const entries=entryList.getEntries();for(const entry of entries){if(entry.entryType==='longtask'){const taskEnd=entry.startTime+entry.duration;window.____lastLongTask=Math.max(window.____lastLongTask,taskEnd);}}});observer.observe({entryTypes:['longtask']});window.____lhPerformanceObserver=observer;}
function checkTimeSinceLastLongTask(){return new Promise(resolve=>{const timeoutRequested=window.performance.now()+50;setTimeout(()=>{const timeoutFired=window.performance.now();const timeSinceLongTask=timeoutFired-timeoutRequested<50?timeoutFired-window.____lastLongTask:0;resolve(timeSinceLongTask);},50);});}
module.exports={captureJSCallUsage,wrapRuntimeEvalErrorInBrowser,registerPerformanceObserverInPage,checkTimeSinceLastLongTask};},{}],39:[function(require,module,exports){'use strict';const log=require('lighthouse-logger');const SENTRY_URL='https://a6bb0da87ee048cc9ae2a345fc09ab2e:63a7029f46f74265981b7e005e0f69f8@sentry.io/174697';const noop=()=>Promise.resolve();const sentryApi={captureMessage:noop,captureException:noop,captureBreadcrumb:noop,mergeContext:noop,getContext:noop};const SAMPLED_ERRORS=[{pattern:/DOCUMENT_REQUEST$/,rate:0.1},{pattern:/(IDLE_PERIOD|FMP_TOO_LATE)/,rate:0.1},{pattern:/^NO_.*/,rate:0.1},{pattern:/Failed to decode/,rate:0.1},{pattern:/All image optimizations failed/,rate:0.1},{pattern:/No.*resource with given/,rate:0.01},{pattern:/No.*node with given id/,rate:0.01}];const sentryDelegate=Object.assign({},sentryApi);sentryDelegate.init=function init(opts){if(!opts.flags.enableErrorReporting){return;}
const environmentData=opts.environmentData||{};const sentryConfig=Object.assign({},environmentData,{captureUnhandledRejections:true});try{const Sentry=require('raven');Sentry.config(SENTRY_URL,sentryConfig).install();Object.keys(sentryApi).forEach(functionName=>{sentryDelegate[functionName]=(...args)=>Sentry[functionName](...args);});sentryDelegate.captureException=(err,opts)=>{opts=opts||{};const empty=Promise.resolve();if(!err)return empty;if(err.expected)return empty;const sampledErrorMatch=SAMPLED_ERRORS.find(sample=>sample.pattern.test(err.message));if(sampledErrorMatch&&sampledErrorMatch.rate<=Math.random())return empty;if(err.protocolMethod){opts.fingerprint=['{{ default }}',err.protocolMethod,err.protocolError];}
return new Promise(resolve=>{Sentry.captureException(err,opts,()=>resolve());});};}catch(e){log.warn('sentry','Could not load raven library, errors will not be reported.');}
const context=Object.assign({url:opts.url,deviceEmulation:!opts.flags.disableDeviceEmulation,throttlingMethod:opts.flags.throttlingMethod},opts.flags.throttling);sentryDelegate.mergeContext({extra:Object.assign({},environmentData.extra,context)});return context;};module.exports=sentryDelegate;},{"lighthouse-logger":143,"raven":58}],40:[function(require,module,exports){'use strict';function erf(x){const sign=Math.sign(x);x=Math.abs(x);const a1=0.254829592;const a2=-0.284496736;const a3=1.421413741;const a4=-1.453152027;const a5=1.061405429;const p=0.3275911;const t=1/(1+p*x);const y=t*(a1+t*(a2+t*(a3+t*(a4+t*a5))));return sign*(1-y*Math.exp(-x*x));}
function getLogNormalDistribution(median,falloff){const location=Math.log(median);const logRatio=Math.log(falloff/median);const shape=Math.sqrt(1-3*logRatio-Math.sqrt((logRatio-3)*(logRatio-3)-8))/2;return{computeComplementaryPercentile(x){const standardizedX=(Math.log(x)-location)/(Math.SQRT2*shape);return(1-erf(standardizedX))/2;}};}
module.exports={getLogNormalDistribution};},{}],41:[function(require,module,exports){'use strict';module.exports={didntCollectScreenshots:`Chrome didn't collect any screenshots during the page load. Please make sure there is content visible on the page, and then try re-running Lighthouse.`,badTraceRecording:`Something went wrong with recording the trace over your page load. Please run Lighthouse again.`,pageLoadTookTooLong:`Your page took too long to load. Please follow the opportunities in the report to reduce your page load time, and then try re-running Lighthouse.`,pageLoadFailed:`Your page failed to load. Verify that the URL is valid and re-run Lighthouse.`,internalChromeError:`An internal Chrome error occurred. Please restart Chrome and try re-running Lighthouse.`,requestContentTimeout:'Fetching resource content has exceeded the allotted time'};},{}],42:[function(require,module,exports){'use strict';const groupIdToName={loading:'Network request loading',parseHTML:'Parsing HTML & CSS',styleLayout:'Style & Layout',compositing:'Compositing',painting:'Paint',gpu:'GPU',scripting:'Script Evaluation',scriptParseCompile:'Script Parsing & Compile',scriptGC:'Garbage collection',other:'Other',images:'Images'};const taskToGroup={'Animation':groupIdToName.painting,'Async Task':groupIdToName.other,'Frame Start':groupIdToName.painting,'Frame Start (main thread)':groupIdToName.painting,'Cancel Animation Frame':groupIdToName.scripting,'Cancel Idle Callback':groupIdToName.scripting,'Compile Script':groupIdToName.scriptParseCompile,'Composite Layers':groupIdToName.compositing,'Console Time':groupIdToName.scripting,'Image Decode':groupIdToName.images,'Draw Frame':groupIdToName.painting,'Embedder Callback':groupIdToName.scripting,'Evaluate Script':groupIdToName.scripting,'Event':groupIdToName.scripting,'Animation Frame Fired':groupIdToName.scripting,'Fire Idle Callback':groupIdToName.scripting,'Function Call':groupIdToName.scripting,'DOM GC':groupIdToName.scriptGC,'GC Event':groupIdToName.scriptGC,'GPU':groupIdToName.gpu,'Hit Test':groupIdToName.compositing,'Invalidate Layout':groupIdToName.styleLayout,'JS Frame':groupIdToName.scripting,'Input Latency':groupIdToName.scripting,'Layout':groupIdToName.styleLayout,'Major GC':groupIdToName.scriptGC,'DOMContentLoaded event':groupIdToName.scripting,'First paint':groupIdToName.painting,'FMP':groupIdToName.painting,'FMP candidate':groupIdToName.painting,'Load event':groupIdToName.scripting,'Minor GC':groupIdToName.scriptGC,'Paint':groupIdToName.painting,'Paint Image':groupIdToName.images,'Paint Setup':groupIdToName.painting,'Parse Stylesheet':groupIdToName.parseHTML,'Parse HTML':groupIdToName.parseHTML,'Parse Script':groupIdToName.scriptParseCompile,'Other':groupIdToName.other,'Rasterize Paint':groupIdToName.painting,'Recalculate Style':groupIdToName.styleLayout,'Request Animation Frame':groupIdToName.scripting,'Request Idle Callback':groupIdToName.scripting,'Request Main Thread Frame':groupIdToName.painting,'Image Resize':groupIdToName.images,'Finish Loading':groupIdToName.loading,'Receive Data':groupIdToName.loading,'Receive Response':groupIdToName.loading,'Send Request':groupIdToName.loading,'Run Microtasks':groupIdToName.scripting,'Schedule Style Recalculation':groupIdToName.styleLayout,'Scroll':groupIdToName.compositing,'Task':groupIdToName.other,'Timer Fired':groupIdToName.scripting,'Install Timer':groupIdToName.scripting,'Remove Timer':groupIdToName.scripting,'Timestamp':groupIdToName.scripting,'Update Layer':groupIdToName.compositing,'Update Layer Tree':groupIdToName.compositing,'User Timing':groupIdToName.scripting,'Create WebSocket':groupIdToName.scripting,'Destroy WebSocket':groupIdToName.scripting,'Receive WebSocket Handshake':groupIdToName.scripting,'Send WebSocket Handshake':groupIdToName.scripting,'XHR Load':groupIdToName.scripting,'XHR Ready State Change':groupIdToName.scripting};module.exports={groupIdToName,taskToGroup};},{}],43:[function(require,module,exports){'use strict';const WebInspector=require('../web-inspector');const ConsoleQuieter=require('../console-quieter');const TimelineModelTreeView=require('devtools-timeline-model/lib/timeline-model-treeview.js')(WebInspector);class TimelineModel{constructor(events){this.init(events);}
init(trace){this._tracingModel=new WebInspector.TracingModel(new WebInspector.TempFileBackingStorage('tracing'));this._timelineModel=new WebInspector.TimelineModel(WebInspector.TimelineUIUtils.visibleEventsFilter());let events;if(Array.isArray(trace)){events=trace;}
if(typeof trace==='string'){events=JSON.parse(trace);}
if(trace.hasOwnProperty('traceEvents')){events=trace.traceEvents;}
this._tracingModel.reset();try{ConsoleQuieter.mute({prefix:'timelineModel'});this._tracingModel.addEvents(events);this._tracingModel.tracingComplete();this._timelineModel.setEvents(this._tracingModel);}finally{ConsoleQuieter.unmuteAndFlush();}
return this;}
_createAggregator(){return WebInspector.AggregatedTimelineTreeView.prototype._createAggregator();}
timelineModel(){return this._timelineModel;}
tracingModel(){return this._tracingModel;}
topDown(){const filters=[];filters.push(WebInspector.TimelineUIUtils.visibleEventsFilter());filters.push(new WebInspector.ExcludeTopLevelFilter());const nonessentialEvents=[WebInspector.TimelineModel.RecordType.EventDispatch,WebInspector.TimelineModel.RecordType.FunctionCall,WebInspector.TimelineModel.RecordType.TimerFire];filters.push(new WebInspector.ExclusiveNameFilter(nonessentialEvents));const topDown=WebInspector.TimelineProfileTree.buildTopDown(this._timelineModel.mainThreadEvents(),filters,0,Infinity,WebInspector.TimelineAggregator.eventId);return topDown;}
bottomUp(){const topDown=this.topDown();const noGrouping=WebInspector.TimelineAggregator.GroupBy.None;const noGroupAggregator=this._createAggregator().groupFunction(noGrouping);return WebInspector.TimelineProfileTree.buildBottomUp(topDown,noGroupAggregator);}
bottomUpGroupBy(grouping){const topDown=this.topDown();const groupSetting=WebInspector.TimelineAggregator.GroupBy[grouping];const groupingAggregator=this._createAggregator().groupFunction(groupSetting);const bottomUpGrouped=WebInspector.TimelineProfileTree.buildBottomUp(topDown,groupingAggregator);new TimelineModelTreeView(bottomUpGrouped).sortingChanged('self','desc');return bottomUpGrouped;}
frameModel(){const mapper=event=>WebInspector.TimelineUIUtils.eventStyle(event).category.name;const frameModel=new WebInspector.TimelineFrameModel(mapper);frameModel.addTraceEvents({},this._timelineModel.inspectedTargetEvents(),this._timelineModel.sessionId()||'');return frameModel;}
filmStripModel(){return new WebInspector.FilmStripModel(this._tracingModel);}
interactionModel(){const irModel=new WebInspector.TimelineIRModel();irModel.populate(this._timelineModel);return irModel;}}
module.exports=TimelineModel;},{"../console-quieter":22,"../web-inspector":47,"devtools-timeline-model/lib/timeline-model-treeview.js":135}],44:[function(require,module,exports){'use strict';const log=require('lighthouse-logger');function findValueInMetricsAuditFn(metricName){return auditResults=>{const metricsAudit=auditResults.metrics;if(!metricsAudit||!metricsAudit.details||!metricsAudit.details.items)return;const values=metricsAudit.details.items[0];return values&&values[metricName];};}
class Metrics{constructor(traceEvents,auditResults){this._traceEvents=traceEvents;this._auditResults=auditResults;}
static get metricsDefinitions(){return[{name:'Navigation Start',id:'navstart',getTs:findValueInMetricsAuditFn('observedNavigationStartTs'),getTiming:findValueInMetricsAuditFn('observedNavigationStart')},{name:'First Contentful Paint',id:'ttfcp',getTs:findValueInMetricsAuditFn('observedFirstContentfulPaintTs'),getTiming:findValueInMetricsAuditFn('observedFirstContentfulPaint')},{name:'First Meaningful Paint',id:'ttfmp',getTs:findValueInMetricsAuditFn('observedFirstMeaningfulPaintTs'),getTiming:findValueInMetricsAuditFn('observedFirstMeaningfulPaint')},{name:'Speed Index',id:'si',getTs:findValueInMetricsAuditFn('observedSpeedIndexTs'),getTiming:findValueInMetricsAuditFn('observedSpeedIndex')},{name:'First Visual Change',id:'fv',getTs:findValueInMetricsAuditFn('observedFirstVisualChangeTs'),getTiming:findValueInMetricsAuditFn('observedFirstVisualChange')},{name:'Visually Complete 100%',id:'vc100',getTs:findValueInMetricsAuditFn('observedLastVisualChangeTs'),getTiming:findValueInMetricsAuditFn('observedLastVisualChange')},{name:'First CPU Idle',id:'ttfi',getTs:findValueInMetricsAuditFn('firstCPUIdleTs'),getTiming:findValueInMetricsAuditFn('firstCPUIdle')},{name:'Interactive',id:'tti',getTs:findValueInMetricsAuditFn('interactiveTs'),getTiming:findValueInMetricsAuditFn('interactive')},{name:'End of Trace',id:'eot',getTs:findValueInMetricsAuditFn('observedTraceEndTs'),getTiming:findValueInMetricsAuditFn('observedTraceEnd')},{name:'On Load',id:'onload',getTs:findValueInMetricsAuditFn('observedLoadTs'),getTiming:findValueInMetricsAuditFn('observedLoad')},{name:'DOM Content Loaded',id:'dcl',getTs:findValueInMetricsAuditFn('observedDomContentLoadedTs'),getTiming:findValueInMetricsAuditFn('observedDomContentLoaded')}];}
gatherMetrics(){const metricDfns=Metrics.metricsDefinitions;const resolvedMetrics=[];metricDfns.forEach(metric=>{try{resolvedMetrics.push({id:metric.id,name:metric.name,ts:metric.getTs(this._auditResults)});}catch(e){log.error('pwmetrics-events',`${metric.name} timestamp not found: ${e.message}`);}});return resolvedMetrics;}
identifyNavigationStartEvt(metrics){const navStartMetric=metrics.find(e=>e.id==='navstart');if(!navStartMetric)return;this._navigationStartEvt=this._traceEvents.find(e=>e.name==='navigationStart'&&e.ts===navStartMetric.ts);}
synthesizeEventPair(metric){const eventBase={pid:this._navigationStartEvt.pid,tid:this._navigationStartEvt.tid,cat:'blink.user_timing',name:metric.name,args:{},id:`0x${(Math.random()*1000000|0).toString(16)}`};const fakeMeasureStartEvent=Object.assign({},eventBase,{ts:this._navigationStartEvt.ts,ph:'b'});const fakeMeasureEndEvent=Object.assign({},eventBase,{ts:metric.ts,ph:'e'});return[fakeMeasureStartEvent,fakeMeasureEndEvent];}
generateFakeEvents(){const fakeEvents=[];const metrics=this.gatherMetrics();if(metrics.length===0){log.error('metrics-events','Metrics collection had errors, not synthetizing trace events');return[];}
this.identifyNavigationStartEvt(metrics);if(!this._navigationStartEvt){log.error('pwmetrics-events','Reference navigationStart not found');return[];}
metrics.forEach(metric=>{if(metric.id==='navstart'){return;}
if(!metric.ts){log.error('pwmetrics-events',`(${metric.name}) missing timestamp. Skipping…`);return;}
log.verbose('pwmetrics-events',`Sythesizing trace events for ${metric.name}`);fakeEvents.push(...this.synthesizeEventPair(metric));});return fakeEvents;}}
module.exports=Metrics;},{"lighthouse-logger":143}],45:[function(require,module,exports){'use strict';const WebInspector=require('../web-inspector');class TraceParser{constructor(){this.traceEvents=[];this.tracingModel={reset:()=>this._reset(),addEvents:evts=>this._addEvents(evts)};const delegateMock={loadingProgress:()=>{},loadingStarted:()=>{},loadingComplete:success=>{if(!success)throw new Error('Parsing problem');}};this.loader=new WebInspector.TimelineLoader(this.tracingModel,delegateMock);}
_reset(){this.traceEvents=[];}
_addEvents(evts){this.traceEvents.push(...evts);}
parseChunk(data){this.loader.write(data);}
getTrace(){return{traceEvents:this.traceEvents};}}
module.exports=TraceParser;},{"../web-inspector":47}],46:[function(require,module,exports){'use strict';const BASE_RESPONSE_LATENCY=16;const SCHEDULABLE_TASK_TITLE='TaskQueueManager::ProcessTaskFromWorkQueue';const SCHEDULABLE_TASK_TITLE_ALT='ThreadControllerImpl::DoWork';class TraceProcessor{static _riskPercentiles(durations,totalTime,percentiles,clippedLength=0){let busyTime=0;for(let i=0;i<durations.length;i++){busyTime+=durations[i];}
busyTime-=clippedLength;let completedTime=totalTime-busyTime;let duration=0;let cdfTime=completedTime;const results=[];let durationIndex=-1;let remainingCount=durations.length+1;if(clippedLength>0){remainingCount--;}
for(const percentile of percentiles){const percentileTime=percentile*totalTime;while(cdfTime<percentileTime&&durationIndex<durations.length-1){completedTime+=duration;remainingCount-=duration<0?-1:1;if(clippedLength>0&&clippedLength<durations[durationIndex+1]){duration=-clippedLength;clippedLength=0;}else{durationIndex++;duration=durations[durationIndex];}
cdfTime=completedTime+Math.abs(duration)*remainingCount;}
results.push({percentile,time:Math.max(0,(percentileTime-completedTime)/remainingCount)+
BASE_RESPONSE_LATENCY});}
return results;}
static getRiskToResponsiveness(events,startTime,endTime,percentiles=[0.5,0.75,0.9,0.99,1])
{const totalTime=endTime-startTime;percentiles.sort((a,b)=>a-b);const ret=TraceProcessor.getMainThreadTopLevelEventDurations(events,startTime,endTime);return TraceProcessor._riskPercentiles(ret.durations,totalTime,percentiles,ret.clippedLength);}
static getMainThreadTopLevelEventDurations(topLevelEvents,startTime=0,endTime=Infinity){const durations=[];let clippedLength=0;for(const event of topLevelEvents){if(event.end<startTime||event.start>endTime){continue;}
let duration=event.duration;let eventStart=event.start;if(eventStart<startTime){eventStart=startTime;duration=event.end-startTime;}
if(event.end>endTime){clippedLength=duration-(endTime-eventStart);}
durations.push(duration);}
durations.sort((a,b)=>a-b);return{durations,clippedLength};}
static getMainThreadTopLevelEvents(tabTrace,startTime=0,endTime=Infinity){const topLevelEvents=[];for(const event of tabTrace.mainThreadEvents){if(!TraceProcessor.isScheduleableTask(event)||!event.dur)continue;const start=(event.ts-tabTrace.navigationStartEvt.ts)/1000;const end=(event.ts+event.dur-tabTrace.navigationStartEvt.ts)/1000;if(start>endTime||end<startTime)continue;topLevelEvents.push({start,end,duration:event.dur/1000});}
if(!topLevelEvents.length){throw new Error('Could not find any top level events');}
return topLevelEvents;}
static isScheduleableTask(evt){return evt.name===SCHEDULABLE_TASK_TITLE||evt.name===SCHEDULABLE_TASK_TITLE_ALT;}}
module.exports=TraceProcessor;},{}],47:[function(require,module,exports){(function(global){'use strict';module.exports=function(){if(global.WebInspector){return global.WebInspector;}
if(global.self!==global){global.self=global;}
if(typeof global.window==='undefined'){global.window=global;}
global.Node={ELEMENT_NODE:1,TEXT_NODE:3};global.CSSAgent={};global.CSSAgent.StyleSheetOrigin={INJECTED:'injected',USER_AGENT:'user-agent',INSPECTOR:'inspector',REGULAR:'regular'};global.CSS={};global.CSS.supports=()=>true;const _setImmediate=global.setImmediate;global.Runtime=global.Runtime||{};global.Runtime.experiments=global.Runtime.experiments||{};global.Runtime.experiments.isEnabled=_=>false;const _queryParam=global.Runtime.queryParam;global.Runtime.queryParam=function(arg){switch(arg){case'remoteFrontend':return false;case'ws':return false;default:{if(_queryParam){return _queryParam.call(global.Runtime,arg);}
throw new Error('Mock queryParam case not implemented.');}}};global.TreeElement={};global.WorkerRuntime={};global.Protocol={Agents(){}};global.WebInspector={};const WebInspector=global.WebInspector;WebInspector._moduleSettings={cacheDisabled:{addChangeListener(){},get(){return false;}},monitoringXHREnabled:{addChangeListener(){},get(){return false;}},showNativeFunctionsInJSProfile:{addChangeListener(){},get(){return true;}}};WebInspector.moduleSetting=function(settingName){return this._moduleSettings[settingName];};global.NetworkAgent={RequestMixedContentType:{Blockable:'blockable',OptionallyBlockable:'optionally-blockable',None:'none'},BlockedReason:{CSP:'csp',MixedContent:'mixed-content',Origin:'origin',Inspector:'inspector',Other:'other'},InitiatorType:{Other:'other',Parser:'parser',Redirect:'redirect',Script:'script'}};global.SecurityAgent={SecurityState:{Unknown:'unknown',Neutral:'neutral',Insecure:'insecure',Warning:'warning',Secure:'secure',Info:'info'}};global.PageAgent={ResourceType:{Document:'document',Stylesheet:'stylesheet',Image:'image',Media:'media',Font:'font',Script:'script',TextTrack:'texttrack',XHR:'xhr',Fetch:'fetch',EventSource:'eventsource',WebSocket:'websocket',Manifest:'manifest',Other:'other'}};require('chrome-devtools-frontend/front_end/common/Object.js');require('chrome-devtools-frontend/front_end/common/ParsedURL.js');require('chrome-devtools-frontend/front_end/common/ResourceType.js');require('chrome-devtools-frontend/front_end/common/UIString.js');require('chrome-devtools-frontend/front_end/platform/utilities.js');require('chrome-devtools-frontend/front_end/sdk/Target.js');require('chrome-devtools-frontend/front_end/sdk/TargetManager.js');require('chrome-devtools-frontend/front_end/sdk/NetworkManager.js');require('chrome-devtools-frontend/front_end/sdk/NetworkRequest.js');WebInspector.targetManager={observeTargets(){},addEventListener(){}};WebInspector.settings={createSetting(){return{get(){return false;},addChangeListener(){}};}};WebInspector.console={error(){}};WebInspector.VBox=function(){};WebInspector.HBox=function(){};WebInspector.ViewportDataGrid=function(){};WebInspector.ViewportDataGridNode=function(){};global.WorkerRuntime.Worker=function(){};require('chrome-devtools-frontend/front_end/common/SegmentedRange.js');require('chrome-devtools-frontend/front_end/bindings/TempFile.js');require('chrome-devtools-frontend/front_end/sdk/TracingModel.js');require('chrome-devtools-frontend/front_end/sdk/ProfileTreeModel.js');require('chrome-devtools-frontend/front_end/timeline/TimelineUIUtils.js');require('chrome-devtools-frontend/front_end/timeline_model/TimelineJSProfile.js');require('chrome-devtools-frontend/front_end/sdk/CPUProfileDataModel.js');require('chrome-devtools-frontend/front_end/timeline_model/LayerTreeModel.js');require('chrome-devtools-frontend/front_end/timeline_model/TimelineModel.js');require('chrome-devtools-frontend/front_end/ui_lazy/SortableDataGrid.js');require('chrome-devtools-frontend/front_end/timeline/TimelineTreeView.js');require('chrome-devtools-frontend/front_end/common/TextUtils.js');require('chrome-devtools-frontend/front_end/timeline/TimelineLoader.js');require('chrome-devtools-frontend/front_end/timeline_model/TimelineProfileTree.js');require('chrome-devtools-frontend/front_end/components_lazy/FilmStripModel.js');require('chrome-devtools-frontend/front_end/timeline_model/TimelineIRModel.js');require('chrome-devtools-frontend/front_end/timeline_model/TimelineFrameModel.js');WebInspector.DeferredTempFile=function(){};WebInspector.DeferredTempFile.prototype={write:function(){},finishWriting:function(){}};WebInspector.ConsoleMessage=function(){};WebInspector.ConsoleMessage.MessageSource={Network:'network'};WebInspector.ConsoleMessage.MessageLevel={Log:'log'};WebInspector.ConsoleMessage.MessageType={Log:'log'};WebInspector.NetworkLog=function(target){this._requests=new Map();target.networkManager.addEventListener(WebInspector.NetworkManager.Events.RequestStarted,this._onRequestStarted,this);};WebInspector.NetworkLog.prototype={requestForURL:function(url){return this._requests.get(url)||null;},_onRequestStarted:function(event){const request=event.data;if(this._requests.has(request.url)){return;}
this._requests.set(request.url,request);}};require('chrome-devtools-frontend/front_end/common/Color.js');const Dispatcher=WebInspector.NetworkDispatcher;const origUpdateRequest=Dispatcher.prototype._updateNetworkRequestWithRequest;Dispatcher.prototype._updateNetworkRequestWithRequest=function(netRecord,request){origUpdateRequest.apply(this,arguments);netRecord.isLinkPreload=Boolean(request.isLinkPreload);netRecord._isLinkPreload=Boolean(request.isLinkPreload);};WebInspector.NetworkManager.createWithFakeTarget=function(){const fakeNetworkAgent={enable(){},getResponseBody(){throw new Error('Use driver.getRequestContent() for network request content');}};const fakeConsoleModel={addMessage(){},target(){}};const fakeTarget={_modelByConstructor:new Map(),get consoleModel(){return fakeConsoleModel;},networkAgent(){return fakeNetworkAgent;},registerNetworkDispatcher(){},model(){}};fakeTarget.networkManager=new WebInspector.NetworkManager(fakeTarget);fakeTarget.networkLog=new WebInspector.NetworkLog(fakeTarget);WebInspector.NetworkLog.fromTarget=()=>{return fakeTarget.networkLog;};return fakeTarget.networkManager;};require('chrome-devtools-frontend/front_end/common/TextRange.js');require('chrome-devtools-frontend/front_end/sdk/CSSMatchedStyles.js');require('chrome-devtools-frontend/front_end/sdk/CSSMedia.js');require('chrome-devtools-frontend/front_end/sdk/CSSMetadata.js');require('chrome-devtools-frontend/front_end/sdk/CSSProperty.js');require('chrome-devtools-frontend/front_end/sdk/CSSRule.js');require('chrome-devtools-frontend/front_end/sdk/CSSStyleDeclaration.js');WebInspector.CSSMetadata._generatedProperties=[{name:'font-size',inherited:true}];global.setImmediate=_setImmediate;return WebInspector;}();}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"chrome-devtools-frontend/front_end/bindings/TempFile.js":99,"chrome-devtools-frontend/front_end/common/Color.js":100,"chrome-devtools-frontend/front_end/common/Object.js":101,"chrome-devtools-frontend/front_end/common/ParsedURL.js":102,"chrome-devtools-frontend/front_end/common/ResourceType.js":103,"chrome-devtools-frontend/front_end/common/SegmentedRange.js":104,"chrome-devtools-frontend/front_end/common/TextRange.js":105,"chrome-devtools-frontend/front_end/common/TextUtils.js":106,"chrome-devtools-frontend/front_end/common/UIString.js":107,"chrome-devtools-frontend/front_end/components_lazy/FilmStripModel.js":108,"chrome-devtools-frontend/front_end/platform/utilities.js":109,"chrome-devtools-frontend/front_end/sdk/CPUProfileDataModel.js":110,"chrome-devtools-frontend/front_end/sdk/CSSMatchedStyles.js":111,"chrome-devtools-frontend/front_end/sdk/CSSMedia.js":112,"chrome-devtools-frontend/front_end/sdk/CSSMetadata.js":113,"chrome-devtools-frontend/front_end/sdk/CSSProperty.js":114,"chrome-devtools-frontend/front_end/sdk/CSSRule.js":115,"chrome-devtools-frontend/front_end/sdk/CSSStyleDeclaration.js":116,"chrome-devtools-frontend/front_end/sdk/NetworkManager.js":117,"chrome-devtools-frontend/front_end/sdk/NetworkRequest.js":118,"chrome-devtools-frontend/front_end/sdk/ProfileTreeModel.js":119,"chrome-devtools-frontend/front_end/sdk/Target.js":120,"chrome-devtools-frontend/front_end/sdk/TargetManager.js":121,"chrome-devtools-frontend/front_end/sdk/TracingModel.js":122,"chrome-devtools-frontend/front_end/timeline/TimelineLoader.js":123,"chrome-devtools-frontend/front_end/timeline/TimelineTreeView.js":124,"chrome-devtools-frontend/front_end/timeline/TimelineUIUtils.js":125,"chrome-devtools-frontend/front_end/timeline_model/LayerTreeModel.js":126,"chrome-devtools-frontend/front_end/timeline_model/TimelineFrameModel.js":127,"chrome-devtools-frontend/front_end/timeline_model/TimelineIRModel.js":128,"chrome-devtools-frontend/front_end/timeline_model/TimelineJSProfile.js":129,"chrome-devtools-frontend/front_end/timeline_model/TimelineModel.js":130,"chrome-devtools-frontend/front_end/timeline_model/TimelineProfileTree.js":131,"chrome-devtools-frontend/front_end/ui_lazy/SortableDataGrid.js":132}],48:[function(require,module,exports){'use strict';const ELLIPSIS='\u2026';const NBSP='\xa0';const PASS_THRESHOLD=0.75;const RATINGS={PASS:{label:'pass',minScore:PASS_THRESHOLD},AVERAGE:{label:'average',minScore:0.45},FAIL:{label:'fail'},ERROR:{label:'error'}};class Util{static get PASS_THRESHOLD(){return PASS_THRESHOLD;}
static get MS_DISPLAY_VALUE(){return`%10d${NBSP}ms`;}
static formatDisplayValue(displayValue){if(typeof displayValue==='string')return displayValue;if(!displayValue)return'';const replacementRegex=/%([0-9]*(\.[0-9]+)?d|s)/;const template=displayValue[0];if(typeof template!=='string'){return'UNKNOWN';}
let output=template;for(const replacement of displayValue.slice(1)){if(!replacementRegex.test(output)){console.warn('Too many replacements given');break;}
output=output.replace(replacementRegex,match=>{const granularity=Number(match.match(/[0-9.]+/))||1;return match==='%s'?replacement.toLocaleString():(Math.round(Number(replacement)/granularity)*granularity).toLocaleString();});}
if(replacementRegex.test(output)){console.warn('Not enough replacements given');}
return output;}
static showAsPassed(audit){switch(audit.scoreDisplayMode){case'manual':case'not-applicable':return true;case'error':case'informative':return false;case'numeric':case'binary':default:return Number(audit.score)===1;}}
static calculateRating(score,scoreDisplayMode){if(scoreDisplayMode==='manual'||scoreDisplayMode==='not-applicable'){return RATINGS.PASS.label;}else if(scoreDisplayMode==='error'){return RATINGS.ERROR.label;}else if(score===null){return RATINGS.FAIL.label;}
let rating=RATINGS.FAIL.label;if(score>=RATINGS.PASS.minScore){rating=RATINGS.PASS.label;}else if(score>=RATINGS.AVERAGE.minScore){rating=RATINGS.AVERAGE.label;}
return rating;}
static formatNumber(number,granularity=0.1){const coarseValue=Math.round(number/granularity)*granularity;return coarseValue.toLocaleString();}
static formatBytesToKB(size,granularity=0.1){const kbs=(Math.round(size/1024/granularity)*granularity).toLocaleString();return`${kbs}${NBSP}KB`;}
static formatMilliseconds(ms,granularity=10){const coarseTime=Math.round(ms/granularity)*granularity;return`${coarseTime.toLocaleString()}${NBSP}ms`;}
static formatSeconds(ms,granularity=0.1){const coarseTime=Math.round(ms/1000/granularity)*granularity;return`${coarseTime.toLocaleString()}${NBSP}s`;}
static formatDateTime(date){const options={month:'short',day:'numeric',year:'numeric',hour:'numeric',minute:'numeric',timeZoneName:'short'};let formatter=new Intl.DateTimeFormat('en-US',options);const tz=formatter.resolvedOptions().timeZone;if(!tz||tz.toLowerCase()==='etc/unknown'){options.timeZone='UTC';formatter=new Intl.DateTimeFormat('en-US',options);}
return formatter.format(new Date(date));}
static formatDuration(timeInMilliseconds){let timeInSeconds=timeInMilliseconds/1000;if(Math.round(timeInSeconds)===0){return'None';}
const parts=[];const unitLabels={d:60*60*24,h:60*60,m:60,s:1};Object.keys(unitLabels).forEach(label=>{const unit=unitLabels[label];const numberOfUnits=Math.floor(timeInSeconds/unit);if(numberOfUnits>0){timeInSeconds-=numberOfUnits*unit;parts.push(`${numberOfUnits}\xa0${label}`);}});return parts.join(' ');}
static getURLDisplayName(parsedUrl,options){options=options||{numPathParts:undefined,preserveQuery:undefined,preserveHost:undefined};const numPathParts=options.numPathParts!==undefined?options.numPathParts:2;const preserveQuery=options.preserveQuery!==undefined?options.preserveQuery:true;const preserveHost=options.preserveHost||false;let name;if(parsedUrl.protocol==='about:'||parsedUrl.protocol==='data:'){name=parsedUrl.href;}else{name=parsedUrl.pathname;const parts=name.split('/').filter(part=>part.length);if(numPathParts&&parts.length>numPathParts){name=ELLIPSIS+parts.slice(-1*numPathParts).join('/');}
if(preserveHost){name=`${parsedUrl.host}/${name.replace(/^\//,'')}`;}
if(preserveQuery){name=`${name}${parsedUrl.search}`;}}
const MAX_LENGTH=64;name=name.replace(/([a-f0-9]{7})[a-f0-9]{13}[a-f0-9]*/g,`$1${ELLIPSIS}`);name=name.replace(/([a-zA-Z0-9-_]{9})(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])[a-zA-Z0-9-_]{10,}/g,`$1${ELLIPSIS}`);name=name.replace(/(\d{3})\d{6,}/g,`$1${ELLIPSIS}`);name=name.replace(/\u2026+/g,ELLIPSIS);if(name.length>MAX_LENGTH&&name.includes('?')){name=name.replace(/\?([^=]*)(=)?.*/,`?$1$2${ELLIPSIS}`);if(name.length>MAX_LENGTH){name=name.replace(/\?.*/,`?${ELLIPSIS}`);}}
if(name.length>MAX_LENGTH){const dotIndex=name.lastIndexOf('.');if(dotIndex>=0){name=name.slice(0,MAX_LENGTH-1-(name.length-dotIndex))+`${ELLIPSIS}${name.slice(dotIndex)}`;}else{name=name.slice(0,MAX_LENGTH-1)+ELLIPSIS;}}
return name;}
static parseURL(url){const parsedUrl=new URL(url);return{file:Util.getURLDisplayName(parsedUrl),hostname:parsedUrl.hostname,origin:parsedUrl.origin};}
static chainDuration(startTime,endTime){return Util.formatNumber((endTime-startTime)*1000);}
static getEnvironmentDisplayValues(settings){const emulationDesc=Util.getEmulationDescriptions(settings);return[{name:'Device',description:emulationDesc.deviceEmulation},{name:'Network throttling',description:emulationDesc.networkThrottling},{name:'CPU throttling',description:emulationDesc.cpuThrottling}];}
static getEmulationDescriptions(settings){let cpuThrottling;let networkThrottling;let summary;const throttling=settings.throttling;switch(settings.throttlingMethod){case'provided':cpuThrottling='Provided by environment';networkThrottling='Provided by environment';summary='No throttling applied';break;case'devtools':{const{cpuSlowdownMultiplier,requestLatencyMs}=throttling;cpuThrottling=`${Util.formatNumber(cpuSlowdownMultiplier)}x slowdown (DevTools)`;networkThrottling=`${Util.formatNumber(requestLatencyMs)}${NBSP}ms HTTP RTT, `+`${Util.formatNumber(throttling.downloadThroughputKbps)}${NBSP}Kbps down, `+`${Util.formatNumber(throttling.uploadThroughputKbps)}${NBSP}Kbps up (DevTools)`;summary='Throttled Fast 3G network';break;}
case'simulate':{const{cpuSlowdownMultiplier,rttMs,throughputKbps}=throttling;cpuThrottling=`${Util.formatNumber(cpuSlowdownMultiplier)}x slowdown (Simulated)`;networkThrottling=`${Util.formatNumber(rttMs)}${NBSP}ms TCP RTT, `+`${Util.formatNumber(throughputKbps)}${NBSP}Kbps throughput (Simulated)`;summary='Simulated Fast 3G network';break;}
default:cpuThrottling='Unknown';networkThrottling='Unknown';summary='Unknown';}
const deviceEmulation=settings.disableDeviceEmulation?'No emulation':'Emulated Nexus 5X';return{deviceEmulation,cpuThrottling,networkThrottling,summary:`${deviceEmulation}, ${summary}`};}}
if(typeof module!=='undefined'&&module.exports){module.exports=Util;}else{self.Util=Util;}},{}],49:[function(require,module,exports){'use strict';const htmlReportAssets=require('./html/html-report-assets');class ReportGenerator{static replaceStrings(source,replacements){if(replacements.length===0){return source;}
const firstReplacement=replacements[0];const nextReplacements=replacements.slice(1);return source.split(firstReplacement.search).map(part=>ReportGenerator.replaceStrings(part,nextReplacements)).join(firstReplacement.replacement);}
static generateReportHtml(lhr){const sanitizedJson=JSON.stringify(lhr).replace(/</g,'\\u003c').replace(/\u2028/g,'\\u2028').replace(/\u2029/g,'\\u2029');const sanitizedJavascript=htmlReportAssets.REPORT_JAVASCRIPT.replace(/<\//g,'\\u003c/');return ReportGenerator.replaceStrings(htmlReportAssets.REPORT_TEMPLATE,[{search:'%%LIGHTHOUSE_JSON%%',replacement:sanitizedJson},{search:'%%LIGHTHOUSE_JAVASCRIPT%%',replacement:sanitizedJavascript},{search:'/*%%LIGHTHOUSE_CSS%%*/',replacement:htmlReportAssets.REPORT_CSS},{search:'%%LIGHTHOUSE_TEMPLATES%%',replacement:htmlReportAssets.REPORT_TEMPLATES}]);}
static generateReportCSV(lhr){const CRLF='\r\n';const separator=',';const escape=value=>`"${value.replace(/"/g,'""')}"`;const header=['category','name','title','type','score'];const table=Object.values(lhr.categories).map(category=>{return category.auditRefs.map(auditRef=>{const audit=lhr.audits[auditRef.id];const numericScore=audit.score===null?-1:audit.score;return[category.title,audit.id,audit.title,audit.scoreDisplayMode,numericScore].map(value=>value.toString()).map(escape);});});const flattedTable=[].concat(...table);return[header,...flattedTable].map(row=>row.join(separator)).join(CRLF);}
static generateReport(lhr,outputModes){const outputAsArray=Array.isArray(outputModes);if(typeof outputModes==='string')outputModes=[outputModes];const output=outputModes.map(outputMode=>{if(outputMode==='html'){return ReportGenerator.generateReportHtml(lhr);}
if(outputMode==='csv'){return ReportGenerator.generateReportCSV(lhr);}
if(outputMode==='json'){return JSON.stringify(lhr,null,2);}
throw new Error('Invalid output mode: '+outputMode);});return outputAsArray?output:output[0];}}
module.exports=ReportGenerator;},{"./html/html-report-assets":58}],50:[function(require,module,exports){(function(process,__dirname){'use strict';const isDeepEqual=require('lodash.isequal');const Driver=require('./gather/driver.js');const GatherRunner=require('./gather/gather-runner');const ReportScoring=require('./scoring');const Audit=require('./audits/audit');const log=require('lighthouse-logger');const assetSaver=require('./lib/asset-saver');const path=require('path');const URL=require('./lib/url-shim');const Sentry=require('./lib/sentry');const generateReport=require('./report/report-generator').generateReport;const Connection=require('./gather/connections/connection.js');class Runner{static async run(connection,opts){try{const startTime=Date.now();const settings=opts.config.settings;const lighthouseRunWarnings=[];const rawRequestedUrl=opts.url;if(typeof rawRequestedUrl!=='string'||rawRequestedUrl.length===0){throw new Error(`You must provide a url to the runner. '${rawRequestedUrl}' provided.`);}
let parsedURL;try{parsedURL=new URL(opts.url);}catch(e){throw new Error('The url provided should have a proper protocol and hostname.');}
const sentryContext=Sentry.getContext();Sentry.captureBreadcrumb({message:'Run started',category:'lifecycle',data:sentryContext&&sentryContext.extra});if(parsedURL.protocol!=='https:'&&parsedURL.hostname!=='localhost'){log.warn('Lighthouse','The URL provided should be on HTTPS');log.warn('Lighthouse','Performance stats will be skewed redirecting from HTTP to HTTPS.');}
const requestedUrl=parsedURL.href;let artifacts;if(settings.auditMode&&!settings.gatherMode){const path=Runner._getArtifactsPath(settings);artifacts=await assetSaver.loadArtifacts(path);}else{artifacts=await Runner._gatherArtifactsFromBrowser(requestedUrl,opts,connection);if(settings.gatherMode){const path=Runner._getArtifactsPath(settings);await assetSaver.saveArtifacts(artifacts,path);}}
if(settings.gatherMode&&!settings.auditMode)return;if(!opts.config.audits){throw new Error('No audits to evaluate.');}
const auditResults=await Runner._runAudits(settings,opts.config.audits,artifacts);log.log('status','Generating results...');if(artifacts.LighthouseRunWarnings){lighthouseRunWarnings.push(...artifacts.LighthouseRunWarnings);}
const lighthouseVersion=require('../package.json').version;const resultsById={};for(const audit of auditResults){resultsById[audit.id]=audit;}
let categories={};if(opts.config.categories){categories=ReportScoring.scoreAllCategories(opts.config.categories,resultsById);}
const lhr={userAgent:artifacts.UserAgent,lighthouseVersion,fetchTime:artifacts.fetchTime,requestedUrl:requestedUrl,finalUrl:artifacts.URL.finalUrl,runWarnings:lighthouseRunWarnings,audits:resultsById,configSettings:settings,categories,categoryGroups:opts.config.groups,timing:{total:Date.now()-startTime}};const report=generateReport(lhr,settings.output);return{lhr,artifacts,report};}catch(err){await Sentry.captureException(err,{level:'fatal'});throw err;}}
static async _gatherArtifactsFromBrowser(requestedUrl,runnerOpts,connection){if(!runnerOpts.config.passes){throw new Error('No browser artifacts are either provided or requested.');}
const driver=runnerOpts.driverMock||new Driver(connection);const gatherOpts={driver,requestedUrl,settings:runnerOpts.config.settings};const artifacts=await GatherRunner.run(runnerOpts.config.passes,gatherOpts);return artifacts;}
static async _runAudits(settings,audits,artifacts){log.log('status','Analyzing and running audits...');artifacts=Object.assign({},Runner.instantiateComputedArtifacts(),artifacts);if(artifacts.settings){const overrides={gatherMode:undefined,auditMode:undefined,output:undefined};const normalizedGatherSettings=Object.assign({},artifacts.settings,overrides);const normalizedAuditSettings=Object.assign({},settings,overrides);if(!isDeepEqual(normalizedGatherSettings,normalizedAuditSettings)){throw new Error('Cannot change settings between gathering and auditing');}}
const auditResults=[];for(const auditDefn of audits){const auditResult=await Runner._runAudit(auditDefn,artifacts,settings);auditResults.push(auditResult);}
return auditResults;}
static async _runAudit(auditDefn,artifacts,settings){const audit=auditDefn.implementation;const status=`Evaluating: ${audit.meta.description}`;log.log('status',status);let auditResult;try{for(const artifactName of audit.meta.requiredArtifacts){const noArtifact=artifacts[artifactName]===undefined;const noTrace=artifactName==='traces'&&!artifacts.traces[Audit.DEFAULT_PASS];if(noArtifact||noTrace){log.warn('Runner',`${artifactName} gatherer, required by audit ${audit.meta.name}, did not run.`);throw new Error(`Required ${artifactName} gatherer did not run.`);}
if(artifacts[artifactName]instanceof Error){const artifactError=artifacts[artifactName];Sentry.captureException(artifactError,{tags:{gatherer:artifactName},level:'error'});log.warn('Runner',`${artifactName} gatherer, required by audit ${audit.meta.name},`+` encountered an error: ${artifactError.message}`);const error=new Error(`Required ${artifactName} gatherer encountered an error: ${artifactError.message}`);error.expected=true;throw error;}}
const auditOptions=Object.assign({},audit.defaultOptions,auditDefn.options);const product=await audit.audit(artifacts,{options:auditOptions,settings:settings});auditResult=Audit.generateAuditResult(audit,product);}catch(err){log.warn(audit.meta.name,`Caught exception: ${err.message}`);if(err.fatal){throw err;}
Sentry.captureException(err,{tags:{audit:audit.meta.name},level:'error'});const errorMessage=err.friendlyMessage?`${err.friendlyMessage} (${err.message})`:`Audit error: ${err.message}`;auditResult=Audit.generateErrorAuditResult(audit,errorMessage);}
log.verbose('statusEnd',status);return auditResult;}
static getAuditList(){const ignoredFiles=['audit.js','violation-audit.js','accessibility/axe-audit.js','multi-check-audit.js','byte-efficiency/byte-efficiency-audit.js','manual/manual-audit.js'];const fileList=[...["accessibility","audit.js","bootup-time.js","byte-efficiency","content-width.js","critical-request-chains.js","deprecations.js","dobetterweb","errors-in-console.js","estimated-input-latency.js","first-contentful-paint.js","first-cpu-idle.js","first-meaningful-paint.js","font-display.js","image-aspect-ratio.js","interactive.js","is-on-https.js","load-fast-enough-for-pwa.js","mainthread-work-breakdown.js","manifest-short-name-length.js","manual","metrics.js","mixed-content.js","multi-check-audit.js","network-requests.js","predictive-perf.js","redirects-http.js","redirects.js","screenshot-thumbnails.js","seo","service-worker.js","speed-index.js","splash-screen.js","themed-omnibox.js","time-to-first-byte.js","user-timings.js","uses-rel-preconnect.js","uses-rel-preload.js","viewport.js","violation-audit.js","webapp-install-banner.js","without-javascript.js","works-offline.js"],...["appcache-manifest.js","dom-size.js","external-anchors-use-rel-noopener.js","geolocation-on-start.js","no-document-write.js","no-mutation-events.js","no-vulnerable-libraries.js","no-websql.js","notification-on-start.js","password-inputs-can-be-pasted-into.js","uses-http2.js","uses-passive-event-listeners.js"].map(f=>`dobetterweb/${f}`),...["canonical.js","font-size.js","hreflang.js","http-status-code.js","is-crawlable.js","link-text.js","manual","meta-description.js","plugins.js","robots-txt.js"].map(f=>`seo/${f}`),...["mobile-friendly.js","structured-data.js"].map(f=>`seo/manual/${f}`),...["accesskeys.js","aria-allowed-attr.js","aria-required-attr.js","aria-required-children.js","aria-required-parent.js","aria-roles.js","aria-valid-attr-value.js","aria-valid-attr.js","audio-caption.js","axe-audit.js","button-name.js","bypass.js","color-contrast.js","definition-list.js","dlitem.js","document-title.js","duplicate-id.js","frame-title.js","html-has-lang.js","html-lang-valid.js","image-alt.js","input-image-alt.js","label.js","layout-table.js","link-name.js","list.js","listitem.js","manual","meta-refresh.js","meta-viewport.js","object-alt.js","tabindex.js","td-headers-attr.js","th-has-data-cells.js","valid-lang.js","video-caption.js","video-description.js"].map(f=>`accessibility/${f}`),...["custom-controls-labels.js","custom-controls-roles.js","focus-traps.js","focusable-controls.js","heading-levels.js","logical-tab-order.js","managed-focus.js","offscreen-content-hidden.js","use-landmarks.js","visual-order-follows-dom.js"].map(f=>`accessibility/manual/${f}`),...["byte-efficiency-audit.js","efficient-animated-content.js","offscreen-images.js","render-blocking-resources.js","total-byte-weight.js","unminified-css.js","unminified-javascript.js","unused-css-rules.js","unused-javascript.js","uses-long-cache-ttl.js","uses-optimized-images.js","uses-responsive-images.js","uses-text-compression.js","uses-webp-images.js"].map(f=>`byte-efficiency/${f}`),...["manual-audit.js","pwa-cross-browser.js","pwa-each-page-has-url.js","pwa-page-transitions.js"].map(f=>`manual/${f}`)];return fileList.filter(f=>{return/\.js$/.test(f)&&!ignoredFiles.includes(f);}).sort();}
static getGathererList(){const fileList=[...["accessibility.js","cache-contents.js","chrome-console-messages.js","css-usage.js","dobetterweb","fonts.js","gatherer.js","html-without-javascript.js","http-redirect.js","image-usage.js","js-usage.js","manifest.js","mixed-content.js","offline.js","runtime-exceptions.js","scripts.js","seo","service-worker.js","start-url.js","theme-color.js","viewport-dimensions.js","viewport.js"],...["canonical.js","crawlable-links.js","embedded-content.js","font-size.js","hreflang.js","meta-description.js","meta-robots.js","robots-txt.js"].map(f=>`seo/${f}`),...["all-event-listeners.js","anchors-with-no-rel-noopener.js","appcache.js","domstats.js","js-libraries.js","optimized-images.js","password-inputs-with-prevented-paste.js","response-compression.js","tags-blocking-first-paint.js","websql.js"].map(f=>`dobetterweb/${f}`)];return fileList.filter(f=>/\.js$/.test(f)&&f!=='gatherer.js').sort();}
static getComputedGathererList(){const filenamesToSkip=['computed-artifact.js','metrics','metrics/lantern-metric.js','metrics/metric.js'];const fileList=[...["computed-artifact.js","critical-request-chains.js","dtm-model.js","load-simulator.js","main-resource.js","manifest-values.js","metrics","network-analysis.js","network-records.js","network-throughput.js","page-dependency-graph.js","pushed-requests.js","screenshots.js","speedline.js","trace-of-tab.js"],...["estimated-input-latency.js","first-contentful-paint.js","first-cpu-idle.js","first-meaningful-paint.js","interactive.js","lantern-estimated-input-latency.js","lantern-first-contentful-paint.js","lantern-first-cpu-idle.js","lantern-first-meaningful-paint.js","lantern-interactive.js","lantern-metric.js","lantern-speed-index.js","metric.js","speed-index.js"].map(f=>`metrics/${f}`)];return fileList.filter(f=>/\.js$/.test(f)&&!filenamesToSkip.includes(f)).sort();}
static instantiateComputedArtifacts(){const computedArtifacts={};Runner.getComputedGathererList().forEach(function(filename){filename=filename.replace(/\.js$/,'');const ArtifactClass=require('./gather/computed/'+filename);const artifact=new ArtifactClass(computedArtifacts);computedArtifacts['request'+artifact.name]=artifact.request.bind(artifact);});return computedArtifacts;}
static resolvePlugin(plugin,configDir,category){try{return require.resolve(plugin);}catch(e){}
const cwdPath=path.resolve(process.cwd(),plugin);try{return require.resolve(cwdPath);}catch(e){}
const errorString='Unable to locate '+(category?`${category}: `:'')+`${plugin} (tried to require() from '${__dirname}' and load from '${cwdPath}'`;if(!configDir){throw new Error(errorString+')');}
const relativePath=path.resolve(configDir,plugin);try{return require.resolve(relativePath);}catch(requireError){}
throw new Error(errorString+` and '${relativePath}')`);}
static _getArtifactsPath(settings){const{auditMode,gatherMode}=settings;if(typeof auditMode==='string')return path.resolve(process.cwd(),auditMode);if(typeof gatherMode==='string')return path.resolve(process.cwd(),gatherMode);return path.join(process.cwd(),'latest-run');}}
module.exports=Runner;}).call(this,require('_process'),"/../lighthouse-core");},{"../package.json":154,"./audits/audit":2,"./gather/connections/connection.js":14,"./gather/driver.js":17,"./gather/gather-runner":18,"./lib/asset-saver":21,"./lib/sentry":39,"./lib/url-shim":"url","./report/report-generator":49,"./scoring":51,"_process":77,"lighthouse-logger":143,"lodash.isequal":144,"path":75}],51:[function(require,module,exports){'use strict';const Audit=require('./audits/audit');const clampTo2Decimals=val=>Math.round(val*100)/100;class ReportScoring{static arithmeticMean(items){items=items.filter(item=>item.weight>0);if(items.some(item=>item.score===null))return null;const results=items.reduce((result,item)=>{const score=item.score;const weight=item.weight;return{weight:result.weight+weight,sum:result.sum+score*weight};},{weight:0,sum:0});return clampTo2Decimals(results.sum/results.weight||0);}
static scoreAllCategories(configCategories,resultsByAuditId){const scoredCategories={};for(const[categoryId,configCategory]of Object.entries(configCategories)){const auditRefs=configCategory.auditRefs.map(configMember=>{const member={...configMember};const result=resultsByAuditId[member.id];if(result.scoreDisplayMode===Audit.SCORING_MODES.NOT_APPLICABLE||result.scoreDisplayMode===Audit.SCORING_MODES.INFORMATIVE||result.scoreDisplayMode===Audit.SCORING_MODES.MANUAL){member.weight=0;}
return member;});const scores=auditRefs.map(auditRef=>({score:resultsByAuditId[auditRef.id].score,weight:auditRef.weight}));const score=ReportScoring.arithmeticMean(scores);scoredCategories[categoryId]={...configCategory,auditRefs,id:categoryId,score};}
return scoredCategories;}}
module.exports=ReportScoring;},{"./audits/audit":2}],52:[function(require,module,exports){'use strict';const RawProtocol=require('../../../lighthouse-core/gather/connections/raw');const Runner=require('../../../lighthouse-core/runner');const Config=require('../../../lighthouse-core/config/config');const defaultConfig=require('../../../lighthouse-core/config/default-config.js');const log=require('lighthouse-logger');window.runLighthouseForConnection=function(connection,url,options,categoryIDs,updateBadgeFn=function(){}){const config=new Config({extends:'lighthouse:default',settings:{onlyCategories:categoryIDs}},options.flags);const runOptions=Object.assign({},options,{url,config});updateBadgeFn(url);return Runner.run(connection,runOptions).then(result=>{updateBadgeFn();return result;}).catch(err=>{updateBadgeFn();throw err;});};window.runLighthouseInWorker=function(port,url,options,categoryIDs){log.setLevel('info');const connection=new RawProtocol(port);return window.runLighthouseForConnection(connection,url,options,categoryIDs);};window.getDefaultCategories=function(){return Config.getCategories(defaultConfig);};window.listenForStatus=function(listenCallback){log.events.addListener('status',listenCallback);};},{"../../../lighthouse-core/config/config":7,"../../../lighthouse-core/config/default-config.js":9,"../../../lighthouse-core/gather/connections/raw":15,"../../../lighthouse-core/runner":50,"lighthouse-logger":143}],53:[function(require,module,exports){(function(global){'use strict';function compare(a,b){if(a===b){return 0;}
var x=a.length;var y=b.length;for(var i=0,len=Math.min(x,y);i<len;++i){if(a[i]!==b[i]){x=a[i];y=b[i];break;}}
if(x<y){return-1;}
if(y<x){return 1;}
return 0;}
function isBuffer(b){if(global.Buffer&&typeof global.Buffer.isBuffer==='function'){return global.Buffer.isBuffer(b);}
return!!(b!=null&&b._isBuffer);}
var util=require('util/');var hasOwn=Object.prototype.hasOwnProperty;var pSlice=Array.prototype.slice;var functionsHaveNames=function(){return function foo(){}.name==='foo';}();function pToString(obj){return Object.prototype.toString.call(obj);}
function isView(arrbuf){if(isBuffer(arrbuf)){return false;}
if(typeof global.ArrayBuffer!=='function'){return false;}
if(typeof ArrayBuffer.isView==='function'){return ArrayBuffer.isView(arrbuf);}
if(!arrbuf){return false;}
if(arrbuf instanceof DataView){return true;}
if(arrbuf.buffer&&arrbuf.buffer instanceof ArrayBuffer){return true;}
return false;}
var assert=module.exports=ok;var regex=/\s*function\s+([^\(\s]*)\s*/;function getName(func){if(!util.isFunction(func)){return;}
if(functionsHaveNames){return func.name;}
var str=func.toString();var match=str.match(regex);return match&&match[1];}
assert.AssertionError=function AssertionError(options){this.name='AssertionError';this.actual=options.actual;this.expected=options.expected;this.operator=options.operator;if(options.message){this.message=options.message;this.generatedMessage=false;}else{this.message=getMessage(this);this.generatedMessage=true;}
var stackStartFunction=options.stackStartFunction||fail;if(Error.captureStackTrace){Error.captureStackTrace(this,stackStartFunction);}else{var err=new Error();if(err.stack){var out=err.stack;var fn_name=getName(stackStartFunction);var idx=out.indexOf('\n'+fn_name);if(idx>=0){var next_line=out.indexOf('\n',idx+1);out=out.substring(next_line+1);}
this.stack=out;}}};util.inherits(assert.AssertionError,Error);function truncate(s,n){if(typeof s==='string'){return s.length<n?s:s.slice(0,n);}else{return s;}}
function inspect(something){if(functionsHaveNames||!util.isFunction(something)){return util.inspect(something);}
var rawname=getName(something);var name=rawname?': '+rawname:'';return'[Function'+name+']';}
function getMessage(self){return truncate(inspect(self.actual),128)+' '+
self.operator+' '+
truncate(inspect(self.expected),128);}
function fail(actual,expected,message,operator,stackStartFunction){throw new assert.AssertionError({message:message,actual:actual,expected:expected,operator:operator,stackStartFunction:stackStartFunction});}
assert.fail=fail;function ok(value,message){if(!value)fail(value,true,message,'==',assert.ok);}
assert.ok=ok;assert.equal=function equal(actual,expected,message){if(actual!=expected)fail(actual,expected,message,'==',assert.equal);};assert.notEqual=function notEqual(actual,expected,message){if(actual==expected){fail(actual,expected,message,'!=',assert.notEqual);}};assert.deepEqual=function deepEqual(actual,expected,message){if(!_deepEqual(actual,expected,false)){fail(actual,expected,message,'deepEqual',assert.deepEqual);}};assert.deepStrictEqual=function deepStrictEqual(actual,expected,message){if(!_deepEqual(actual,expected,true)){fail(actual,expected,message,'deepStrictEqual',assert.deepStrictEqual);}};function _deepEqual(actual,expected,strict,memos){if(actual===expected){return true;}else if(isBuffer(actual)&&isBuffer(expected)){return compare(actual,expected)===0;}else if(util.isDate(actual)&&util.isDate(expected)){return actual.getTime()===expected.getTime();}else if(util.isRegExp(actual)&&util.isRegExp(expected)){return actual.source===expected.source&&actual.global===expected.global&&actual.multiline===expected.multiline&&actual.lastIndex===expected.lastIndex&&actual.ignoreCase===expected.ignoreCase;}else if((actual===null||typeof actual!=='object')&&(expected===null||typeof expected!=='object')){return strict?actual===expected:actual==expected;}else if(isView(actual)&&isView(expected)&&pToString(actual)===pToString(expected)&&!(actual instanceof Float32Array||actual instanceof Float64Array)){return compare(new Uint8Array(actual.buffer),new Uint8Array(expected.buffer))===0;}else if(isBuffer(actual)!==isBuffer(expected)){return false;}else{memos=memos||{actual:[],expected:[]};var actualIndex=memos.actual.indexOf(actual);if(actualIndex!==-1){if(actualIndex===memos.expected.indexOf(expected)){return true;}}
memos.actual.push(actual);memos.expected.push(expected);return objEquiv(actual,expected,strict,memos);}}
function isArguments(object){return Object.prototype.toString.call(object)=='[object Arguments]';}
function objEquiv(a,b,strict,actualVisitedObjects){if(a===null||a===undefined||b===null||b===undefined)
return false;if(util.isPrimitive(a)||util.isPrimitive(b))
return a===b;if(strict&&Object.getPrototypeOf(a)!==Object.getPrototypeOf(b))
return false;var aIsArgs=isArguments(a);var bIsArgs=isArguments(b);if(aIsArgs&&!bIsArgs||!aIsArgs&&bIsArgs)
return false;if(aIsArgs){a=pSlice.call(a);b=pSlice.call(b);return _deepEqual(a,b,strict);}
var ka=objectKeys(a);var kb=objectKeys(b);var key,i;if(ka.length!==kb.length)
return false;ka.sort();kb.sort();for(i=ka.length-1;i>=0;i--){if(ka[i]!==kb[i])
return false;}
for(i=ka.length-1;i>=0;i--){key=ka[i];if(!_deepEqual(a[key],b[key],strict,actualVisitedObjects))
return false;}
return true;}
assert.notDeepEqual=function notDeepEqual(actual,expected,message){if(_deepEqual(actual,expected,false)){fail(actual,expected,message,'notDeepEqual',assert.notDeepEqual);}};assert.notDeepStrictEqual=notDeepStrictEqual;function notDeepStrictEqual(actual,expected,message){if(_deepEqual(actual,expected,true)){fail(actual,expected,message,'notDeepStrictEqual',notDeepStrictEqual);}}
assert.strictEqual=function strictEqual(actual,expected,message){if(actual!==expected){fail(actual,expected,message,'===',assert.strictEqual);}};assert.notStrictEqual=function notStrictEqual(actual,expected,message){if(actual===expected){fail(actual,expected,message,'!==',assert.notStrictEqual);}};function expectedException(actual,expected){if(!actual||!expected){return false;}
if(Object.prototype.toString.call(expected)=='[object RegExp]'){return expected.test(actual);}
try{if(actual instanceof expected){return true;}}catch(e){}
if(Error.isPrototypeOf(expected)){return false;}
return expected.call({},actual)===true;}
function _tryBlock(block){var error;try{block();}catch(e){error=e;}
return error;}
function _throws(shouldThrow,block,expected,message){var actual;if(typeof block!=='function'){throw new TypeError('"block" argument must be a function');}
if(typeof expected==='string'){message=expected;expected=null;}
actual=_tryBlock(block);message=(expected&&expected.name?' ('+expected.name+').':'.')+(message?' '+message:'.');if(shouldThrow&&!actual){fail(actual,expected,'Missing expected exception'+message);}
var userProvidedMessage=typeof message==='string';var isUnwantedException=!shouldThrow&&util.isError(actual);var isUnexpectedException=!shouldThrow&&actual&&!expected;if(isUnwantedException&&userProvidedMessage&&expectedException(actual,expected)||isUnexpectedException){fail(actual,expected,'Got unwanted exception'+message);}
if(shouldThrow&&actual&&expected&&!expectedException(actual,expected)||!shouldThrow&&actual){throw actual;}}
assert.throws=function(block,error,message){_throws(true,block,error,message);};assert.doesNotThrow=function(block,error,message){_throws(false,block,error,message);};assert.ifError=function(err){if(err)throw err;};var objectKeys=Object.keys||function(obj){var keys=[];for(var key in obj){if(hasOwn.call(obj,key))keys.push(key);}
return keys;};}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"util/":97}],54:[function(require,module,exports){'use strict';exports.byteLength=byteLength;exports.toByteArray=toByteArray;exports.fromByteArray=fromByteArray;var lookup=[];var revLookup=[];var Arr=typeof Uint8Array!=='undefined'?Uint8Array:Array;var code='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';for(var i=0,len=code.length;i<len;++i){lookup[i]=code[i];revLookup[code.charCodeAt(i)]=i;}
revLookup['-'.charCodeAt(0)]=62;revLookup['_'.charCodeAt(0)]=63;function getLens(b64){var len=b64.length;if(len%4>0){throw new Error('Invalid string. Length must be a multiple of 4');}
var validLen=b64.indexOf('=');if(validLen===-1)validLen=len;var placeHoldersLen=validLen===len?0:4-validLen%4;return[validLen,placeHoldersLen];}
function byteLength(b64){var lens=getLens(b64);var validLen=lens[0];var placeHoldersLen=lens[1];return(validLen+placeHoldersLen)*3/4-placeHoldersLen;}
function _byteLength(b64,validLen,placeHoldersLen){return(validLen+placeHoldersLen)*3/4-placeHoldersLen;}
function toByteArray(b64){var tmp;var lens=getLens(b64);var validLen=lens[0];var placeHoldersLen=lens[1];var arr=new Arr(_byteLength(b64,validLen,placeHoldersLen));var curByte=0;var len=placeHoldersLen>0?validLen-4:validLen;for(var i=0;i<len;i+=4){tmp=revLookup[b64.charCodeAt(i)]<<18|revLookup[b64.charCodeAt(i+1)]<<12|revLookup[b64.charCodeAt(i+2)]<<6|revLookup[b64.charCodeAt(i+3)];arr[curByte++]=tmp>>16&0xFF;arr[curByte++]=tmp>>8&0xFF;arr[curByte++]=tmp&0xFF;}
if(placeHoldersLen===2){tmp=revLookup[b64.charCodeAt(i)]<<2|revLookup[b64.charCodeAt(i+1)]>>4;arr[curByte++]=tmp&0xFF;}
if(placeHoldersLen===1){tmp=revLookup[b64.charCodeAt(i)]<<10|revLookup[b64.charCodeAt(i+1)]<<4|revLookup[b64.charCodeAt(i+2)]>>2;arr[curByte++]=tmp>>8&0xFF;arr[curByte++]=tmp&0xFF;}
return arr;}
function tripletToBase64(num){return lookup[num>>18&0x3F]+
lookup[num>>12&0x3F]+
lookup[num>>6&0x3F]+
lookup[num&0x3F];}
function encodeChunk(uint8,start,end){var tmp;var output=[];for(var i=start;i<end;i+=3){tmp=(uint8[i]<<16&0xFF0000)+(uint8[i+1]<<8&0xFF00)+(uint8[i+2]&0xFF);output.push(tripletToBase64(tmp));}
return output.join('');}
function fromByteArray(uint8){var tmp;var len=uint8.length;var extraBytes=len%3;var parts=[];var maxChunkLength=16383;for(var i=0,len2=len-extraBytes;i<len2;i+=maxChunkLength){parts.push(encodeChunk(uint8,i,i+maxChunkLength>len2?len2:i+maxChunkLength));}
if(extraBytes===1){tmp=uint8[len-1];parts.push(lookup[tmp>>2]+
lookup[tmp<<4&0x3F]+'==');}else if(extraBytes===2){tmp=(uint8[len-2]<<8)+uint8[len-1];parts.push(lookup[tmp>>10]+
lookup[tmp>>4&0x3F]+
lookup[tmp<<2&0x3F]+'=');}
return parts.join('');}},{}],55:[function(require,module,exports){},{}],56:[function(require,module,exports){(function(process,Buffer){'use strict';var assert=require('assert');var Zstream=require('pako/lib/zlib/zstream');var zlib_deflate=require('pako/lib/zlib/deflate.js');var zlib_inflate=require('pako/lib/zlib/inflate.js');var constants=require('pako/lib/zlib/constants');for(var key in constants){exports[key]=constants[key];}
exports.NONE=0;exports.DEFLATE=1;exports.INFLATE=2;exports.GZIP=3;exports.GUNZIP=4;exports.DEFLATERAW=5;exports.INFLATERAW=6;exports.UNZIP=7;var GZIP_HEADER_ID1=0x1f;var GZIP_HEADER_ID2=0x8b;function Zlib(mode){if(typeof mode!=='number'||mode<exports.DEFLATE||mode>exports.UNZIP){throw new TypeError('Bad argument');}
this.dictionary=null;this.err=0;this.flush=0;this.init_done=false;this.level=0;this.memLevel=0;this.mode=mode;this.strategy=0;this.windowBits=0;this.write_in_progress=false;this.pending_close=false;this.gzip_id_bytes_read=0;}
Zlib.prototype.close=function(){if(this.write_in_progress){this.pending_close=true;return;}
this.pending_close=false;assert(this.init_done,'close before init');assert(this.mode<=exports.UNZIP);if(this.mode===exports.DEFLATE||this.mode===exports.GZIP||this.mode===exports.DEFLATERAW){zlib_deflate.deflateEnd(this.strm);}else if(this.mode===exports.INFLATE||this.mode===exports.GUNZIP||this.mode===exports.INFLATERAW||this.mode===exports.UNZIP){zlib_inflate.inflateEnd(this.strm);}
this.mode=exports.NONE;this.dictionary=null;};Zlib.prototype.write=function(flush,input,in_off,in_len,out,out_off,out_len){return this._write(true,flush,input,in_off,in_len,out,out_off,out_len);};Zlib.prototype.writeSync=function(flush,input,in_off,in_len,out,out_off,out_len){return this._write(false,flush,input,in_off,in_len,out,out_off,out_len);};Zlib.prototype._write=function(async,flush,input,in_off,in_len,out,out_off,out_len){assert.equal(arguments.length,8);assert(this.init_done,'write before init');assert(this.mode!==exports.NONE,'already finalized');assert.equal(false,this.write_in_progress,'write already in progress');assert.equal(false,this.pending_close,'close is pending');this.write_in_progress=true;assert.equal(false,flush===undefined,'must provide flush value');this.write_in_progress=true;if(flush!==exports.Z_NO_FLUSH&&flush!==exports.Z_PARTIAL_FLUSH&&flush!==exports.Z_SYNC_FLUSH&&flush!==exports.Z_FULL_FLUSH&&flush!==exports.Z_FINISH&&flush!==exports.Z_BLOCK){throw new Error('Invalid flush value');}
if(input==null){input=Buffer.alloc(0);in_len=0;in_off=0;}
this.strm.avail_in=in_len;this.strm.input=input;this.strm.next_in=in_off;this.strm.avail_out=out_len;this.strm.output=out;this.strm.next_out=out_off;this.flush=flush;if(!async){this._process();if(this._checkError()){return this._afterSync();}
return;}
var self=this;process.nextTick(function(){self._process();self._after();});return this;};Zlib.prototype._afterSync=function(){var avail_out=this.strm.avail_out;var avail_in=this.strm.avail_in;this.write_in_progress=false;return[avail_in,avail_out];};Zlib.prototype._process=function(){var next_expected_header_byte=null;switch(this.mode){case exports.DEFLATE:case exports.GZIP:case exports.DEFLATERAW:this.err=zlib_deflate.deflate(this.strm,this.flush);break;case exports.UNZIP:if(this.strm.avail_in>0){next_expected_header_byte=this.strm.next_in;}
switch(this.gzip_id_bytes_read){case 0:if(next_expected_header_byte===null){break;}
if(this.strm.input[next_expected_header_byte]===GZIP_HEADER_ID1){this.gzip_id_bytes_read=1;next_expected_header_byte++;if(this.strm.avail_in===1){break;}}else{this.mode=exports.INFLATE;break;}
case 1:if(next_expected_header_byte===null){break;}
if(this.strm.input[next_expected_header_byte]===GZIP_HEADER_ID2){this.gzip_id_bytes_read=2;this.mode=exports.GUNZIP;}else{this.mode=exports.INFLATE;}
break;default:throw new Error('invalid number of gzip magic number bytes read');}
case exports.INFLATE:case exports.GUNZIP:case exports.INFLATERAW:this.err=zlib_inflate.inflate(this.strm,this.flush);if(this.err===exports.Z_NEED_DICT&&this.dictionary){this.err=zlib_inflate.inflateSetDictionary(this.strm,this.dictionary);if(this.err===exports.Z_OK){this.err=zlib_inflate.inflate(this.strm,this.flush);}else if(this.err===exports.Z_DATA_ERROR){this.err=exports.Z_NEED_DICT;}}
while(this.strm.avail_in>0&&this.mode===exports.GUNZIP&&this.err===exports.Z_STREAM_END&&this.strm.next_in[0]!==0x00){this.reset();this.err=zlib_inflate.inflate(this.strm,this.flush);}
break;default:throw new Error('Unknown mode '+this.mode);}};Zlib.prototype._checkError=function(){switch(this.err){case exports.Z_OK:case exports.Z_BUF_ERROR:if(this.strm.avail_out!==0&&this.flush===exports.Z_FINISH){this._error('unexpected end of file');return false;}
break;case exports.Z_STREAM_END:break;case exports.Z_NEED_DICT:if(this.dictionary==null){this._error('Missing dictionary');}else{this._error('Bad dictionary');}
return false;default:this._error('Zlib error');return false;}
return true;};Zlib.prototype._after=function(){if(!this._checkError()){return;}
var avail_out=this.strm.avail_out;var avail_in=this.strm.avail_in;this.write_in_progress=false;this.callback(avail_in,avail_out);if(this.pending_close){this.close();}};Zlib.prototype._error=function(message){if(this.strm.msg){message=this.strm.msg;}
this.onerror(message,this.err);this.write_in_progress=false;if(this.pending_close){this.close();}};Zlib.prototype.init=function(windowBits,level,memLevel,strategy,dictionary){assert(arguments.length===4||arguments.length===5,'init(windowBits, level, memLevel, strategy, [dictionary])');assert(windowBits>=8&&windowBits<=15,'invalid windowBits');assert(level>=-1&&level<=9,'invalid compression level');assert(memLevel>=1&&memLevel<=9,'invalid memlevel');assert(strategy===exports.Z_FILTERED||strategy===exports.Z_HUFFMAN_ONLY||strategy===exports.Z_RLE||strategy===exports.Z_FIXED||strategy===exports.Z_DEFAULT_STRATEGY,'invalid strategy');this._init(level,windowBits,memLevel,strategy,dictionary);this._setDictionary();};Zlib.prototype.params=function(){throw new Error('deflateParams Not supported');};Zlib.prototype.reset=function(){this._reset();this._setDictionary();};Zlib.prototype._init=function(level,windowBits,memLevel,strategy,dictionary){this.level=level;this.windowBits=windowBits;this.memLevel=memLevel;this.strategy=strategy;this.flush=exports.Z_NO_FLUSH;this.err=exports.Z_OK;if(this.mode===exports.GZIP||this.mode===exports.GUNZIP){this.windowBits+=16;}
if(this.mode===exports.UNZIP){this.windowBits+=32;}
if(this.mode===exports.DEFLATERAW||this.mode===exports.INFLATERAW){this.windowBits=-1*this.windowBits;}
this.strm=new Zstream();switch(this.mode){case exports.DEFLATE:case exports.GZIP:case exports.DEFLATERAW:this.err=zlib_deflate.deflateInit2(this.strm,this.level,exports.Z_DEFLATED,this.windowBits,this.memLevel,this.strategy);break;case exports.INFLATE:case exports.GUNZIP:case exports.INFLATERAW:case exports.UNZIP:this.err=zlib_inflate.inflateInit2(this.strm,this.windowBits);break;default:throw new Error('Unknown mode '+this.mode);}
if(this.err!==exports.Z_OK){this._error('Init error');}
this.dictionary=dictionary;this.write_in_progress=false;this.init_done=true;};Zlib.prototype._setDictionary=function(){if(this.dictionary==null){return;}
this.err=exports.Z_OK;switch(this.mode){case exports.DEFLATE:case exports.DEFLATERAW:this.err=zlib_deflate.deflateSetDictionary(this.strm,this.dictionary);break;default:break;}
if(this.err!==exports.Z_OK){this._error('Failed to set dictionary');}};Zlib.prototype._reset=function(){this.err=exports.Z_OK;switch(this.mode){case exports.DEFLATE:case exports.DEFLATERAW:case exports.GZIP:this.err=zlib_deflate.deflateReset(this.strm);break;case exports.INFLATE:case exports.INFLATERAW:case exports.GUNZIP:this.err=zlib_inflate.inflateReset(this.strm);break;default:break;}
if(this.err!==exports.Z_OK){this._error('Failed to reset stream');}};exports.Zlib=Zlib;}).call(this,require('_process'),require("buffer").Buffer);},{"_process":77,"assert":53,"buffer":60,"pako/lib/zlib/constants":69,"pako/lib/zlib/deflate.js":71,"pako/lib/zlib/inflate.js":58,"pako/lib/zlib/zstream":74}],57:[function(require,module,exports){(function(process){'use strict';var Buffer=require('buffer').Buffer;var Transform=require('stream').Transform;var binding=require('./binding');var util=require('util');var assert=require('assert').ok;var kMaxLength=require('buffer').kMaxLength;var kRangeErrorMessage='Cannot create final Buffer. It would be larger '+'than 0x'+kMaxLength.toString(16)+' bytes';binding.Z_MIN_WINDOWBITS=8;binding.Z_MAX_WINDOWBITS=15;binding.Z_DEFAULT_WINDOWBITS=15;binding.Z_MIN_CHUNK=64;binding.Z_MAX_CHUNK=Infinity;binding.Z_DEFAULT_CHUNK=16*1024;binding.Z_MIN_MEMLEVEL=1;binding.Z_MAX_MEMLEVEL=9;binding.Z_DEFAULT_MEMLEVEL=8;binding.Z_MIN_LEVEL=-1;binding.Z_MAX_LEVEL=9;binding.Z_DEFAULT_LEVEL=binding.Z_DEFAULT_COMPRESSION;var bkeys=Object.keys(binding);for(var bk=0;bk<bkeys.length;bk++){var bkey=bkeys[bk];if(bkey.match(/^Z/)){Object.defineProperty(exports,bkey,{enumerable:true,value:binding[bkey],writable:false});}}
var codes={Z_OK:binding.Z_OK,Z_STREAM_END:binding.Z_STREAM_END,Z_NEED_DICT:binding.Z_NEED_DICT,Z_ERRNO:binding.Z_ERRNO,Z_STREAM_ERROR:binding.Z_STREAM_ERROR,Z_DATA_ERROR:binding.Z_DATA_ERROR,Z_MEM_ERROR:binding.Z_MEM_ERROR,Z_BUF_ERROR:binding.Z_BUF_ERROR,Z_VERSION_ERROR:binding.Z_VERSION_ERROR};var ckeys=Object.keys(codes);for(var ck=0;ck<ckeys.length;ck++){var ckey=ckeys[ck];codes[codes[ckey]]=ckey;}
Object.defineProperty(exports,'codes',{enumerable:true,value:Object.freeze(codes),writable:false});exports.Deflate=Deflate;exports.Inflate=Inflate;exports.Gzip=Gzip;exports.Gunzip=Gunzip;exports.DeflateRaw=DeflateRaw;exports.InflateRaw=InflateRaw;exports.Unzip=Unzip;exports.createDeflate=function(o){return new Deflate(o);};exports.createInflate=function(o){return new Inflate(o);};exports.createDeflateRaw=function(o){return new DeflateRaw(o);};exports.createInflateRaw=function(o){return new InflateRaw(o);};exports.createGzip=function(o){return new Gzip(o);};exports.createGunzip=function(o){return new Gunzip(o);};exports.createUnzip=function(o){return new Unzip(o);};exports.deflate=function(buffer,opts,callback){if(typeof opts==='function'){callback=opts;opts={};}
return zlibBuffer(new Deflate(opts),buffer,callback);};exports.deflateSync=function(buffer,opts){return zlibBufferSync(new Deflate(opts),buffer);};exports.gzip=function(buffer,opts,callback){if(typeof opts==='function'){callback=opts;opts={};}
return zlibBuffer(new Gzip(opts),buffer,callback);};exports.gzipSync=function(buffer,opts){return zlibBufferSync(new Gzip(opts),buffer);};exports.deflateRaw=function(buffer,opts,callback){if(typeof opts==='function'){callback=opts;opts={};}
return zlibBuffer(new DeflateRaw(opts),buffer,callback);};exports.deflateRawSync=function(buffer,opts){return zlibBufferSync(new DeflateRaw(opts),buffer);};exports.unzip=function(buffer,opts,callback){if(typeof opts==='function'){callback=opts;opts={};}
return zlibBuffer(new Unzip(opts),buffer,callback);};exports.unzipSync=function(buffer,opts){return zlibBufferSync(new Unzip(opts),buffer);};exports.inflate=function(buffer,opts,callback){if(typeof opts==='function'){callback=opts;opts={};}
return zlibBuffer(new Inflate(opts),buffer,callback);};exports.inflateSync=function(buffer,opts){return zlibBufferSync(new Inflate(opts),buffer);};exports.gunzip=function(buffer,opts,callback){if(typeof opts==='function'){callback=opts;opts={};}
return zlibBuffer(new Gunzip(opts),buffer,callback);};exports.gunzipSync=function(buffer,opts){return zlibBufferSync(new Gunzip(opts),buffer);};exports.inflateRaw=function(buffer,opts,callback){if(typeof opts==='function'){callback=opts;opts={};}
return zlibBuffer(new InflateRaw(opts),buffer,callback);};exports.inflateRawSync=function(buffer,opts){return zlibBufferSync(new InflateRaw(opts),buffer);};function zlibBuffer(engine,buffer,callback){var buffers=[];var nread=0;engine.on('error',onError);engine.on('end',onEnd);engine.end(buffer);flow();function flow(){var chunk;while(null!==(chunk=engine.read())){buffers.push(chunk);nread+=chunk.length;}
engine.once('readable',flow);}
function onError(err){engine.removeListener('end',onEnd);engine.removeListener('readable',flow);callback(err);}
function onEnd(){var buf;var err=null;if(nread>=kMaxLength){err=new RangeError(kRangeErrorMessage);}else{buf=Buffer.concat(buffers,nread);}
buffers=[];engine.close();callback(err,buf);}}
function zlibBufferSync(engine,buffer){if(typeof buffer==='string')buffer=Buffer.from(buffer);if(!Buffer.isBuffer(buffer))throw new TypeError('Not a string or buffer');var flushFlag=engine._finishFlushFlag;return engine._processChunk(buffer,flushFlag);}
function Deflate(opts){if(!(this instanceof Deflate))return new Deflate(opts);Zlib.call(this,opts,binding.DEFLATE);}
function Inflate(opts){if(!(this instanceof Inflate))return new Inflate(opts);Zlib.call(this,opts,binding.INFLATE);}
function Gzip(opts){if(!(this instanceof Gzip))return new Gzip(opts);Zlib.call(this,opts,binding.GZIP);}
function Gunzip(opts){if(!(this instanceof Gunzip))return new Gunzip(opts);Zlib.call(this,opts,binding.GUNZIP);}
function DeflateRaw(opts){if(!(this instanceof DeflateRaw))return new DeflateRaw(opts);Zlib.call(this,opts,binding.DEFLATERAW);}
function InflateRaw(opts){if(!(this instanceof InflateRaw))return new InflateRaw(opts);Zlib.call(this,opts,binding.INFLATERAW);}
function Unzip(opts){if(!(this instanceof Unzip))return new Unzip(opts);Zlib.call(this,opts,binding.UNZIP);}
function isValidFlushFlag(flag){return flag===binding.Z_NO_FLUSH||flag===binding.Z_PARTIAL_FLUSH||flag===binding.Z_SYNC_FLUSH||flag===binding.Z_FULL_FLUSH||flag===binding.Z_FINISH||flag===binding.Z_BLOCK;}
function Zlib(opts,mode){var _this=this;this._opts=opts=opts||{};this._chunkSize=opts.chunkSize||exports.Z_DEFAULT_CHUNK;Transform.call(this,opts);if(opts.flush&&!isValidFlushFlag(opts.flush)){throw new Error('Invalid flush flag: '+opts.flush);}
if(opts.finishFlush&&!isValidFlushFlag(opts.finishFlush)){throw new Error('Invalid flush flag: '+opts.finishFlush);}
this._flushFlag=opts.flush||binding.Z_NO_FLUSH;this._finishFlushFlag=typeof opts.finishFlush!=='undefined'?opts.finishFlush:binding.Z_FINISH;if(opts.chunkSize){if(opts.chunkSize<exports.Z_MIN_CHUNK||opts.chunkSize>exports.Z_MAX_CHUNK){throw new Error('Invalid chunk size: '+opts.chunkSize);}}
if(opts.windowBits){if(opts.windowBits<exports.Z_MIN_WINDOWBITS||opts.windowBits>exports.Z_MAX_WINDOWBITS){throw new Error('Invalid windowBits: '+opts.windowBits);}}
if(opts.level){if(opts.level<exports.Z_MIN_LEVEL||opts.level>exports.Z_MAX_LEVEL){throw new Error('Invalid compression level: '+opts.level);}}
if(opts.memLevel){if(opts.memLevel<exports.Z_MIN_MEMLEVEL||opts.memLevel>exports.Z_MAX_MEMLEVEL){throw new Error('Invalid memLevel: '+opts.memLevel);}}
if(opts.strategy){if(opts.strategy!=exports.Z_FILTERED&&opts.strategy!=exports.Z_HUFFMAN_ONLY&&opts.strategy!=exports.Z_RLE&&opts.strategy!=exports.Z_FIXED&&opts.strategy!=exports.Z_DEFAULT_STRATEGY){throw new Error('Invalid strategy: '+opts.strategy);}}
if(opts.dictionary){if(!Buffer.isBuffer(opts.dictionary)){throw new Error('Invalid dictionary: it should be a Buffer instance');}}
this._handle=new binding.Zlib(mode);var self=this;this._hadError=false;this._handle.onerror=function(message,errno){_close(self);self._hadError=true;var error=new Error(message);error.errno=errno;error.code=exports.codes[errno];self.emit('error',error);};var level=exports.Z_DEFAULT_COMPRESSION;if(typeof opts.level==='number')level=opts.level;var strategy=exports.Z_DEFAULT_STRATEGY;if(typeof opts.strategy==='number')strategy=opts.strategy;this._handle.init(opts.windowBits||exports.Z_DEFAULT_WINDOWBITS,level,opts.memLevel||exports.Z_DEFAULT_MEMLEVEL,strategy,opts.dictionary);this._buffer=Buffer.allocUnsafe(this._chunkSize);this._offset=0;this._level=level;this._strategy=strategy;this.once('end',this.close);Object.defineProperty(this,'_closed',{get:function(){return!_this._handle;},configurable:true,enumerable:true});}
util.inherits(Zlib,Transform);Zlib.prototype.params=function(level,strategy,callback){if(level<exports.Z_MIN_LEVEL||level>exports.Z_MAX_LEVEL){throw new RangeError('Invalid compression level: '+level);}
if(strategy!=exports.Z_FILTERED&&strategy!=exports.Z_HUFFMAN_ONLY&&strategy!=exports.Z_RLE&&strategy!=exports.Z_FIXED&&strategy!=exports.Z_DEFAULT_STRATEGY){throw new TypeError('Invalid strategy: '+strategy);}
if(this._level!==level||this._strategy!==strategy){var self=this;this.flush(binding.Z_SYNC_FLUSH,function(){assert(self._handle,'zlib binding closed');self._handle.params(level,strategy);if(!self._hadError){self._level=level;self._strategy=strategy;if(callback)callback();}});}else{process.nextTick(callback);}};Zlib.prototype.reset=function(){assert(this._handle,'zlib binding closed');return this._handle.reset();};Zlib.prototype._flush=function(callback){this._transform(Buffer.alloc(0),'',callback);};Zlib.prototype.flush=function(kind,callback){var _this2=this;var ws=this._writableState;if(typeof kind==='function'||kind===undefined&&!callback){callback=kind;kind=binding.Z_FULL_FLUSH;}
if(ws.ended){if(callback)process.nextTick(callback);}else if(ws.ending){if(callback)this.once('end',callback);}else if(ws.needDrain){if(callback){this.once('drain',function(){return _this2.flush(kind,callback);});}}else{this._flushFlag=kind;this.write(Buffer.alloc(0),'',callback);}};Zlib.prototype.close=function(callback){_close(this,callback);process.nextTick(emitCloseNT,this);};function _close(engine,callback){if(callback)process.nextTick(callback);if(!engine._handle)return;engine._handle.close();engine._handle=null;}
function emitCloseNT(self){self.emit('close');}
Zlib.prototype._transform=function(chunk,encoding,cb){var flushFlag;var ws=this._writableState;var ending=ws.ending||ws.ended;var last=ending&&(!chunk||ws.length===chunk.length);if(chunk!==null&&!Buffer.isBuffer(chunk))return cb(new Error('invalid input'));if(!this._handle)return cb(new Error('zlib binding closed'));if(last)flushFlag=this._finishFlushFlag;else{flushFlag=this._flushFlag;if(chunk.length>=ws.length){this._flushFlag=this._opts.flush||binding.Z_NO_FLUSH;}}
this._processChunk(chunk,flushFlag,cb);};Zlib.prototype._processChunk=function(chunk,flushFlag,cb){var availInBefore=chunk&&chunk.length;var availOutBefore=this._chunkSize-this._offset;var inOff=0;var self=this;var async=typeof cb==='function';if(!async){var buffers=[];var nread=0;var error;this.on('error',function(er){error=er;});assert(this._handle,'zlib binding closed');do{var res=this._handle.writeSync(flushFlag,chunk,inOff,availInBefore,this._buffer,this._offset,availOutBefore);}while(!this._hadError&&callback(res[0],res[1]));if(this._hadError){throw error;}
if(nread>=kMaxLength){_close(this);throw new RangeError(kRangeErrorMessage);}
var buf=Buffer.concat(buffers,nread);_close(this);return buf;}
assert(this._handle,'zlib binding closed');var req=this._handle.write(flushFlag,chunk,inOff,availInBefore,this._buffer,this._offset,availOutBefore);req.buffer=chunk;req.callback=callback;function callback(availInAfter,availOutAfter){if(this){this.buffer=null;this.callback=null;}
if(self._hadError)return;var have=availOutBefore-availOutAfter;assert(have>=0,'have should not go down');if(have>0){var out=self._buffer.slice(self._offset,self._offset+have);self._offset+=have;if(async){self.push(out);}else{buffers.push(out);nread+=out.length;}}
if(availOutAfter===0||self._offset>=self._chunkSize){availOutBefore=self._chunkSize;self._offset=0;self._buffer=Buffer.allocUnsafe(self._chunkSize);}
if(availOutAfter===0){inOff+=availInBefore-availInAfter;availInBefore=availInAfter;if(!async)return true;var newReq=self._handle.write(flushFlag,chunk,inOff,availInBefore,self._buffer,self._offset,self._chunkSize);newReq.callback=callback;newReq.buffer=chunk;return;}
if(!async)return false;cb();}};util.inherits(Deflate,Zlib);util.inherits(Inflate,Zlib);util.inherits(Gzip,Zlib);util.inherits(Gunzip,Zlib);util.inherits(DeflateRaw,Zlib);util.inherits(InflateRaw,Zlib);util.inherits(Unzip,Zlib);}).call(this,require('_process'));},{"./binding":56,"_process":77,"assert":53,"buffer":60,"stream":92,"util":97}],58:[function(require,module,exports){arguments[4][55][0].apply(exports,arguments);},{"dup":55}],59:[function(require,module,exports){(function(global){'use strict';var buffer=require('buffer');var Buffer=buffer.Buffer;var SlowBuffer=buffer.SlowBuffer;var MAX_LEN=buffer.kMaxLength||2147483647;exports.alloc=function alloc(size,fill,encoding){if(typeof Buffer.alloc==='function'){return Buffer.alloc(size,fill,encoding);}
if(typeof encoding==='number'){throw new TypeError('encoding must not be number');}
if(typeof size!=='number'){throw new TypeError('size must be a number');}
if(size>MAX_LEN){throw new RangeError('size is too large');}
var enc=encoding;var _fill=fill;if(_fill===undefined){enc=undefined;_fill=0;}
var buf=new Buffer(size);if(typeof _fill==='string'){var fillBuf=new Buffer(_fill,enc);var flen=fillBuf.length;var i=-1;while(++i<size){buf[i]=fillBuf[i%flen];}}else{buf.fill(_fill);}
return buf;};exports.allocUnsafe=function allocUnsafe(size){if(typeof Buffer.allocUnsafe==='function'){return Buffer.allocUnsafe(size);}
if(typeof size!=='number'){throw new TypeError('size must be a number');}
if(size>MAX_LEN){throw new RangeError('size is too large');}
return new Buffer(size);};exports.from=function from(value,encodingOrOffset,length){if(typeof Buffer.from==='function'&&(!global.Uint8Array||Uint8Array.from!==Buffer.from)){return Buffer.from(value,encodingOrOffset,length);}
if(typeof value==='number'){throw new TypeError('"value" argument must not be a number');}
if(typeof value==='string'){return new Buffer(value,encodingOrOffset);}
if(typeof ArrayBuffer!=='undefined'&&value instanceof ArrayBuffer){var offset=encodingOrOffset;if(arguments.length===1){return new Buffer(value);}
if(typeof offset==='undefined'){offset=0;}
var len=length;if(typeof len==='undefined'){len=value.byteLength-offset;}
if(offset>=value.byteLength){throw new RangeError('\'offset\' is out of bounds');}
if(len>value.byteLength-offset){throw new RangeError('\'length\' is out of bounds');}
return new Buffer(value.slice(offset,offset+len));}
if(Buffer.isBuffer(value)){var out=new Buffer(value.length);value.copy(out,0,0,value.length);return out;}
if(value){if(Array.isArray(value)||typeof ArrayBuffer!=='undefined'&&value.buffer instanceof ArrayBuffer||'length'in value){return new Buffer(value);}
if(value.type==='Buffer'&&Array.isArray(value.data)){return new Buffer(value.data);}}
throw new TypeError('First argument must be a string, Buffer, '+'ArrayBuffer, Array, or array-like object.');};exports.allocUnsafeSlow=function allocUnsafeSlow(size){if(typeof Buffer.allocUnsafeSlow==='function'){return Buffer.allocUnsafeSlow(size);}
if(typeof size!=='number'){throw new TypeError('size must be a number');}
if(size>=MAX_LEN){throw new RangeError('size is too large');}
return new SlowBuffer(size);};}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"buffer":60}],60:[function(require,module,exports){'use strict';var base64=require('base64-js');var ieee754=require('ieee754');exports.Buffer=Buffer;exports.SlowBuffer=SlowBuffer;exports.INSPECT_MAX_BYTES=50;var K_MAX_LENGTH=0x7fffffff;exports.kMaxLength=K_MAX_LENGTH;Buffer.TYPED_ARRAY_SUPPORT=typedArraySupport();if(!Buffer.TYPED_ARRAY_SUPPORT&&typeof console!=='undefined'&&typeof console.error==='function'){console.error('This browser lacks typed array (Uint8Array) support which is required by '+'`buffer` v5.x. Use `buffer` v4.x if you require old browser support.');}
function typedArraySupport(){try{var arr=new Uint8Array(1);arr.__proto__={__proto__:Uint8Array.prototype,foo:function(){return 42;}};return arr.foo()===42;}catch(e){return false;}}
Object.defineProperty(Buffer.prototype,'parent',{get:function(){if(!(this instanceof Buffer)){return undefined;}
return this.buffer;}});Object.defineProperty(Buffer.prototype,'offset',{get:function(){if(!(this instanceof Buffer)){return undefined;}
return this.byteOffset;}});function createBuffer(length){if(length>K_MAX_LENGTH){throw new RangeError('Invalid typed array length');}
var buf=new Uint8Array(length);buf.__proto__=Buffer.prototype;return buf;}
function Buffer(arg,encodingOrOffset,length){if(typeof arg==='number'){if(typeof encodingOrOffset==='string'){throw new Error('If encoding is specified then the first argument must be a string');}
return allocUnsafe(arg);}
return from(arg,encodingOrOffset,length);}
if(typeof Symbol!=='undefined'&&Symbol.species&&Buffer[Symbol.species]===Buffer){Object.defineProperty(Buffer,Symbol.species,{value:null,configurable:true,enumerable:false,writable:false});}
Buffer.poolSize=8192;function from(value,encodingOrOffset,length){if(typeof value==='number'){throw new TypeError('"value" argument must not be a number');}
if(isArrayBuffer(value)||value&&isArrayBuffer(value.buffer)){return fromArrayBuffer(value,encodingOrOffset,length);}
if(typeof value==='string'){return fromString(value,encodingOrOffset);}
return fromObject(value);}
Buffer.from=function(value,encodingOrOffset,length){return from(value,encodingOrOffset,length);};Buffer.prototype.__proto__=Uint8Array.prototype;Buffer.__proto__=Uint8Array;function assertSize(size){if(typeof size!=='number'){throw new TypeError('"size" argument must be of type number');}else if(size<0){throw new RangeError('"size" argument must not be negative');}}
function alloc(size,fill,encoding){assertSize(size);if(size<=0){return createBuffer(size);}
if(fill!==undefined){return typeof encoding==='string'?createBuffer(size).fill(fill,encoding):createBuffer(size).fill(fill);}
return createBuffer(size);}
Buffer.alloc=function(size,fill,encoding){return alloc(size,fill,encoding);};function allocUnsafe(size){assertSize(size);return createBuffer(size<0?0:checked(size)|0);}
Buffer.allocUnsafe=function(size){return allocUnsafe(size);};Buffer.allocUnsafeSlow=function(size){return allocUnsafe(size);};function fromString(string,encoding){if(typeof encoding!=='string'||encoding===''){encoding='utf8';}
if(!Buffer.isEncoding(encoding)){throw new TypeError('Unknown encoding: '+encoding);}
var length=byteLength(string,encoding)|0;var buf=createBuffer(length);var actual=buf.write(string,encoding);if(actual!==length){buf=buf.slice(0,actual);}
return buf;}
function fromArrayLike(array){var length=array.length<0?0:checked(array.length)|0;var buf=createBuffer(length);for(var i=0;i<length;i+=1){buf[i]=array[i]&255;}
return buf;}
function fromArrayBuffer(array,byteOffset,length){if(byteOffset<0||array.byteLength<byteOffset){throw new RangeError('"offset" is outside of buffer bounds');}
if(array.byteLength<byteOffset+(length||0)){throw new RangeError('"length" is outside of buffer bounds');}
var buf;if(byteOffset===undefined&&length===undefined){buf=new Uint8Array(array);}else if(length===undefined){buf=new Uint8Array(array,byteOffset);}else{buf=new Uint8Array(array,byteOffset,length);}
buf.__proto__=Buffer.prototype;return buf;}
function fromObject(obj){if(Buffer.isBuffer(obj)){var len=checked(obj.length)|0;var buf=createBuffer(len);if(buf.length===0){return buf;}
obj.copy(buf,0,0,len);return buf;}
if(obj){if(ArrayBuffer.isView(obj)||'length'in obj){if(typeof obj.length!=='number'||numberIsNaN(obj.length)){return createBuffer(0);}
return fromArrayLike(obj);}
if(obj.type==='Buffer'&&Array.isArray(obj.data)){return fromArrayLike(obj.data);}}
throw new TypeError('The first argument must be one of type string, Buffer, ArrayBuffer, Array, or Array-like Object.');}
function checked(length){if(length>=K_MAX_LENGTH){throw new RangeError('Attempt to allocate Buffer larger than maximum '+'size: 0x'+K_MAX_LENGTH.toString(16)+' bytes');}
return length|0;}
function SlowBuffer(length){if(+length!=length){length=0;}
return Buffer.alloc(+length);}
Buffer.isBuffer=function isBuffer(b){return b!=null&&b._isBuffer===true;};Buffer.compare=function compare(a,b){if(!Buffer.isBuffer(a)||!Buffer.isBuffer(b)){throw new TypeError('Arguments must be Buffers');}
if(a===b)return 0;var x=a.length;var y=b.length;for(var i=0,len=Math.min(x,y);i<len;++i){if(a[i]!==b[i]){x=a[i];y=b[i];break;}}
if(x<y)return-1;if(y<x)return 1;return 0;};Buffer.isEncoding=function isEncoding(encoding){switch(String(encoding).toLowerCase()){case'hex':case'utf8':case'utf-8':case'ascii':case'latin1':case'binary':case'base64':case'ucs2':case'ucs-2':case'utf16le':case'utf-16le':return true;default:return false;}};Buffer.concat=function concat(list,length){if(!Array.isArray(list)){throw new TypeError('"list" argument must be an Array of Buffers');}
if(list.length===0){return Buffer.alloc(0);}
var i;if(length===undefined){length=0;for(i=0;i<list.length;++i){length+=list[i].length;}}
var buffer=Buffer.allocUnsafe(length);var pos=0;for(i=0;i<list.length;++i){var buf=list[i];if(ArrayBuffer.isView(buf)){buf=Buffer.from(buf);}
if(!Buffer.isBuffer(buf)){throw new TypeError('"list" argument must be an Array of Buffers');}
buf.copy(buffer,pos);pos+=buf.length;}
return buffer;};function byteLength(string,encoding){if(Buffer.isBuffer(string)){return string.length;}
if(ArrayBuffer.isView(string)||isArrayBuffer(string)){return string.byteLength;}
if(typeof string!=='string'){string=''+string;}
var len=string.length;if(len===0)return 0;var loweredCase=false;for(;;){switch(encoding){case'ascii':case'latin1':case'binary':return len;case'utf8':case'utf-8':case undefined:return utf8ToBytes(string).length;case'ucs2':case'ucs-2':case'utf16le':case'utf-16le':return len*2;case'hex':return len>>>1;case'base64':return base64ToBytes(string).length;default:if(loweredCase)return utf8ToBytes(string).length;encoding=(''+encoding).toLowerCase();loweredCase=true;}}}
Buffer.byteLength=byteLength;function slowToString(encoding,start,end){var loweredCase=false;if(start===undefined||start<0){start=0;}
if(start>this.length){return'';}
if(end===undefined||end>this.length){end=this.length;}
if(end<=0){return'';}
end>>>=0;start>>>=0;if(end<=start){return'';}
if(!encoding)encoding='utf8';while(true){switch(encoding){case'hex':return hexSlice(this,start,end);case'utf8':case'utf-8':return utf8Slice(this,start,end);case'ascii':return asciiSlice(this,start,end);case'latin1':case'binary':return latin1Slice(this,start,end);case'base64':return base64Slice(this,start,end);case'ucs2':case'ucs-2':case'utf16le':case'utf-16le':return utf16leSlice(this,start,end);default:if(loweredCase)throw new TypeError('Unknown encoding: '+encoding);encoding=(encoding+'').toLowerCase();loweredCase=true;}}}
Buffer.prototype._isBuffer=true;function swap(b,n,m){var i=b[n];b[n]=b[m];b[m]=i;}
Buffer.prototype.swap16=function swap16(){var len=this.length;if(len%2!==0){throw new RangeError('Buffer size must be a multiple of 16-bits');}
for(var i=0;i<len;i+=2){swap(this,i,i+1);}
return this;};Buffer.prototype.swap32=function swap32(){var len=this.length;if(len%4!==0){throw new RangeError('Buffer size must be a multiple of 32-bits');}
for(var i=0;i<len;i+=4){swap(this,i,i+3);swap(this,i+1,i+2);}
return this;};Buffer.prototype.swap64=function swap64(){var len=this.length;if(len%8!==0){throw new RangeError('Buffer size must be a multiple of 64-bits');}
for(var i=0;i<len;i+=8){swap(this,i,i+7);swap(this,i+1,i+6);swap(this,i+2,i+5);swap(this,i+3,i+4);}
return this;};Buffer.prototype.toString=function toString(){var length=this.length;if(length===0)return'';if(arguments.length===0)return utf8Slice(this,0,length);return slowToString.apply(this,arguments);};Buffer.prototype.toLocaleString=Buffer.prototype.toString;Buffer.prototype.equals=function equals(b){if(!Buffer.isBuffer(b))throw new TypeError('Argument must be a Buffer');if(this===b)return true;return Buffer.compare(this,b)===0;};Buffer.prototype.inspect=function inspect(){var str='';var max=exports.INSPECT_MAX_BYTES;if(this.length>0){str=this.toString('hex',0,max).match(/.{2}/g).join(' ');if(this.length>max)str+=' ... ';}
return'<Buffer '+str+'>';};Buffer.prototype.compare=function compare(target,start,end,thisStart,thisEnd){if(!Buffer.isBuffer(target)){throw new TypeError('Argument must be a Buffer');}
if(start===undefined){start=0;}
if(end===undefined){end=target?target.length:0;}
if(thisStart===undefined){thisStart=0;}
if(thisEnd===undefined){thisEnd=this.length;}
if(start<0||end>target.length||thisStart<0||thisEnd>this.length){throw new RangeError('out of range index');}
if(thisStart>=thisEnd&&start>=end){return 0;}
if(thisStart>=thisEnd){return-1;}
if(start>=end){return 1;}
start>>>=0;end>>>=0;thisStart>>>=0;thisEnd>>>=0;if(this===target)return 0;var x=thisEnd-thisStart;var y=end-start;var len=Math.min(x,y);var thisCopy=this.slice(thisStart,thisEnd);var targetCopy=target.slice(start,end);for(var i=0;i<len;++i){if(thisCopy[i]!==targetCopy[i]){x=thisCopy[i];y=targetCopy[i];break;}}
if(x<y)return-1;if(y<x)return 1;return 0;};function bidirectionalIndexOf(buffer,val,byteOffset,encoding,dir){if(buffer.length===0)return-1;if(typeof byteOffset==='string'){encoding=byteOffset;byteOffset=0;}else if(byteOffset>0x7fffffff){byteOffset=0x7fffffff;}else if(byteOffset<-0x80000000){byteOffset=-0x80000000;}
byteOffset=+byteOffset;if(numberIsNaN(byteOffset)){byteOffset=dir?0:buffer.length-1;}
if(byteOffset<0)byteOffset=buffer.length+byteOffset;if(byteOffset>=buffer.length){if(dir)return-1;else
byteOffset=buffer.length-1;}else if(byteOffset<0){if(dir)byteOffset=0;else
return-1;}
if(typeof val==='string'){val=Buffer.from(val,encoding);}
if(Buffer.isBuffer(val)){if(val.length===0){return-1;}
return arrayIndexOf(buffer,val,byteOffset,encoding,dir);}else if(typeof val==='number'){val=val&0xFF;if(typeof Uint8Array.prototype.indexOf==='function'){if(dir){return Uint8Array.prototype.indexOf.call(buffer,val,byteOffset);}else{return Uint8Array.prototype.lastIndexOf.call(buffer,val,byteOffset);}}
return arrayIndexOf(buffer,[val],byteOffset,encoding,dir);}
throw new TypeError('val must be string, number or Buffer');}
function arrayIndexOf(arr,val,byteOffset,encoding,dir){var indexSize=1;var arrLength=arr.length;var valLength=val.length;if(encoding!==undefined){encoding=String(encoding).toLowerCase();if(encoding==='ucs2'||encoding==='ucs-2'||encoding==='utf16le'||encoding==='utf-16le'){if(arr.length<2||val.length<2){return-1;}
indexSize=2;arrLength/=2;valLength/=2;byteOffset/=2;}}
function read(buf,i){if(indexSize===1){return buf[i];}else{return buf.readUInt16BE(i*indexSize);}}
var i;if(dir){var foundIndex=-1;for(i=byteOffset;i<arrLength;i++){if(read(arr,i)===read(val,foundIndex===-1?0:i-foundIndex)){if(foundIndex===-1)foundIndex=i;if(i-foundIndex+1===valLength)return foundIndex*indexSize;}else{if(foundIndex!==-1)i-=i-foundIndex;foundIndex=-1;}}}else{if(byteOffset+valLength>arrLength)byteOffset=arrLength-valLength;for(i=byteOffset;i>=0;i--){var found=true;for(var j=0;j<valLength;j++){if(read(arr,i+j)!==read(val,j)){found=false;break;}}
if(found)return i;}}
return-1;}
Buffer.prototype.includes=function includes(val,byteOffset,encoding){return this.indexOf(val,byteOffset,encoding)!==-1;};Buffer.prototype.indexOf=function indexOf(val,byteOffset,encoding){return bidirectionalIndexOf(this,val,byteOffset,encoding,true);};Buffer.prototype.lastIndexOf=function lastIndexOf(val,byteOffset,encoding){return bidirectionalIndexOf(this,val,byteOffset,encoding,false);};function hexWrite(buf,string,offset,length){offset=Number(offset)||0;var remaining=buf.length-offset;if(!length){length=remaining;}else{length=Number(length);if(length>remaining){length=remaining;}}
var strLen=string.length;if(length>strLen/2){length=strLen/2;}
for(var i=0;i<length;++i){var parsed=parseInt(string.substr(i*2,2),16);if(numberIsNaN(parsed))return i;buf[offset+i]=parsed;}
return i;}
function utf8Write(buf,string,offset,length){return blitBuffer(utf8ToBytes(string,buf.length-offset),buf,offset,length);}
function asciiWrite(buf,string,offset,length){return blitBuffer(asciiToBytes(string),buf,offset,length);}
function latin1Write(buf,string,offset,length){return asciiWrite(buf,string,offset,length);}
function base64Write(buf,string,offset,length){return blitBuffer(base64ToBytes(string),buf,offset,length);}
function ucs2Write(buf,string,offset,length){return blitBuffer(utf16leToBytes(string,buf.length-offset),buf,offset,length);}
Buffer.prototype.write=function write(string,offset,length,encoding){if(offset===undefined){encoding='utf8';length=this.length;offset=0;}else if(length===undefined&&typeof offset==='string'){encoding=offset;length=this.length;offset=0;}else if(isFinite(offset)){offset=offset>>>0;if(isFinite(length)){length=length>>>0;if(encoding===undefined)encoding='utf8';}else{encoding=length;length=undefined;}}else{throw new Error('Buffer.write(string, encoding, offset[, length]) is no longer supported');}
var remaining=this.length-offset;if(length===undefined||length>remaining)length=remaining;if(string.length>0&&(length<0||offset<0)||offset>this.length){throw new RangeError('Attempt to write outside buffer bounds');}
if(!encoding)encoding='utf8';var loweredCase=false;for(;;){switch(encoding){case'hex':return hexWrite(this,string,offset,length);case'utf8':case'utf-8':return utf8Write(this,string,offset,length);case'ascii':return asciiWrite(this,string,offset,length);case'latin1':case'binary':return latin1Write(this,string,offset,length);case'base64':return base64Write(this,string,offset,length);case'ucs2':case'ucs-2':case'utf16le':case'utf-16le':return ucs2Write(this,string,offset,length);default:if(loweredCase)throw new TypeError('Unknown encoding: '+encoding);encoding=(''+encoding).toLowerCase();loweredCase=true;}}};Buffer.prototype.toJSON=function toJSON(){return{type:'Buffer',data:Array.prototype.slice.call(this._arr||this,0)};};function base64Slice(buf,start,end){if(start===0&&end===buf.length){return base64.fromByteArray(buf);}else{return base64.fromByteArray(buf.slice(start,end));}}
function utf8Slice(buf,start,end){end=Math.min(buf.length,end);var res=[];var i=start;while(i<end){var firstByte=buf[i];var codePoint=null;var bytesPerSequence=firstByte>0xEF?4:firstByte>0xDF?3:firstByte>0xBF?2:1;if(i+bytesPerSequence<=end){var secondByte,thirdByte,fourthByte,tempCodePoint;switch(bytesPerSequence){case 1:if(firstByte<0x80){codePoint=firstByte;}
break;case 2:secondByte=buf[i+1];if((secondByte&0xC0)===0x80){tempCodePoint=(firstByte&0x1F)<<0x6|secondByte&0x3F;if(tempCodePoint>0x7F){codePoint=tempCodePoint;}}
break;case 3:secondByte=buf[i+1];thirdByte=buf[i+2];if((secondByte&0xC0)===0x80&&(thirdByte&0xC0)===0x80){tempCodePoint=(firstByte&0xF)<<0xC|(secondByte&0x3F)<<0x6|thirdByte&0x3F;if(tempCodePoint>0x7FF&&(tempCodePoint<0xD800||tempCodePoint>0xDFFF)){codePoint=tempCodePoint;}}
break;case 4:secondByte=buf[i+1];thirdByte=buf[i+2];fourthByte=buf[i+3];if((secondByte&0xC0)===0x80&&(thirdByte&0xC0)===0x80&&(fourthByte&0xC0)===0x80){tempCodePoint=(firstByte&0xF)<<0x12|(secondByte&0x3F)<<0xC|(thirdByte&0x3F)<<0x6|fourthByte&0x3F;if(tempCodePoint>0xFFFF&&tempCodePoint<0x110000){codePoint=tempCodePoint;}}}}
if(codePoint===null){codePoint=0xFFFD;bytesPerSequence=1;}else if(codePoint>0xFFFF){codePoint-=0x10000;res.push(codePoint>>>10&0x3FF|0xD800);codePoint=0xDC00|codePoint&0x3FF;}
res.push(codePoint);i+=bytesPerSequence;}
return decodeCodePointsArray(res);}
var MAX_ARGUMENTS_LENGTH=0x1000;function decodeCodePointsArray(codePoints){var len=codePoints.length;if(len<=MAX_ARGUMENTS_LENGTH){return String.fromCharCode.apply(String,codePoints);}
var res='';var i=0;while(i<len){res+=String.fromCharCode.apply(String,codePoints.slice(i,i+=MAX_ARGUMENTS_LENGTH));}
return res;}
function asciiSlice(buf,start,end){var ret='';end=Math.min(buf.length,end);for(var i=start;i<end;++i){ret+=String.fromCharCode(buf[i]&0x7F);}
return ret;}
function latin1Slice(buf,start,end){var ret='';end=Math.min(buf.length,end);for(var i=start;i<end;++i){ret+=String.fromCharCode(buf[i]);}
return ret;}
function hexSlice(buf,start,end){var len=buf.length;if(!start||start<0)start=0;if(!end||end<0||end>len)end=len;var out='';for(var i=start;i<end;++i){out+=toHex(buf[i]);}
return out;}
function utf16leSlice(buf,start,end){var bytes=buf.slice(start,end);var res='';for(var i=0;i<bytes.length;i+=2){res+=String.fromCharCode(bytes[i]+bytes[i+1]*256);}
return res;}
Buffer.prototype.slice=function slice(start,end){var len=this.length;start=~~start;end=end===undefined?len:~~end;if(start<0){start+=len;if(start<0)start=0;}else if(start>len){start=len;}
if(end<0){end+=len;if(end<0)end=0;}else if(end>len){end=len;}
if(end<start)end=start;var newBuf=this.subarray(start,end);newBuf.__proto__=Buffer.prototype;return newBuf;};function checkOffset(offset,ext,length){if(offset%1!==0||offset<0)throw new RangeError('offset is not uint');if(offset+ext>length)throw new RangeError('Trying to access beyond buffer length');}
Buffer.prototype.readUIntLE=function readUIntLE(offset,byteLength,noAssert){offset=offset>>>0;byteLength=byteLength>>>0;if(!noAssert)checkOffset(offset,byteLength,this.length);var val=this[offset];var mul=1;var i=0;while(++i<byteLength&&(mul*=0x100)){val+=this[offset+i]*mul;}
return val;};Buffer.prototype.readUIntBE=function readUIntBE(offset,byteLength,noAssert){offset=offset>>>0;byteLength=byteLength>>>0;if(!noAssert){checkOffset(offset,byteLength,this.length);}
var val=this[offset+--byteLength];var mul=1;while(byteLength>0&&(mul*=0x100)){val+=this[offset+--byteLength]*mul;}
return val;};Buffer.prototype.readUInt8=function readUInt8(offset,noAssert){offset=offset>>>0;if(!noAssert)checkOffset(offset,1,this.length);return this[offset];};Buffer.prototype.readUInt16LE=function readUInt16LE(offset,noAssert){offset=offset>>>0;if(!noAssert)checkOffset(offset,2,this.length);return this[offset]|this[offset+1]<<8;};Buffer.prototype.readUInt16BE=function readUInt16BE(offset,noAssert){offset=offset>>>0;if(!noAssert)checkOffset(offset,2,this.length);return this[offset]<<8|this[offset+1];};Buffer.prototype.readUInt32LE=function readUInt32LE(offset,noAssert){offset=offset>>>0;if(!noAssert)checkOffset(offset,4,this.length);return(this[offset]|this[offset+1]<<8|this[offset+2]<<16)+
this[offset+3]*0x1000000;};Buffer.prototype.readUInt32BE=function readUInt32BE(offset,noAssert){offset=offset>>>0;if(!noAssert)checkOffset(offset,4,this.length);return this[offset]*0x1000000+(this[offset+1]<<16|this[offset+2]<<8|this[offset+3]);};Buffer.prototype.readIntLE=function readIntLE(offset,byteLength,noAssert){offset=offset>>>0;byteLength=byteLength>>>0;if(!noAssert)checkOffset(offset,byteLength,this.length);var val=this[offset];var mul=1;var i=0;while(++i<byteLength&&(mul*=0x100)){val+=this[offset+i]*mul;}
mul*=0x80;if(val>=mul)val-=Math.pow(2,8*byteLength);return val;};Buffer.prototype.readIntBE=function readIntBE(offset,byteLength,noAssert){offset=offset>>>0;byteLength=byteLength>>>0;if(!noAssert)checkOffset(offset,byteLength,this.length);var i=byteLength;var mul=1;var val=this[offset+--i];while(i>0&&(mul*=0x100)){val+=this[offset+--i]*mul;}
mul*=0x80;if(val>=mul)val-=Math.pow(2,8*byteLength);return val;};Buffer.prototype.readInt8=function readInt8(offset,noAssert){offset=offset>>>0;if(!noAssert)checkOffset(offset,1,this.length);if(!(this[offset]&0x80))return this[offset];return(0xff-this[offset]+1)*-1;};Buffer.prototype.readInt16LE=function readInt16LE(offset,noAssert){offset=offset>>>0;if(!noAssert)checkOffset(offset,2,this.length);var val=this[offset]|this[offset+1]<<8;return val&0x8000?val|0xFFFF0000:val;};Buffer.prototype.readInt16BE=function readInt16BE(offset,noAssert){offset=offset>>>0;if(!noAssert)checkOffset(offset,2,this.length);var val=this[offset+1]|this[offset]<<8;return val&0x8000?val|0xFFFF0000:val;};Buffer.prototype.readInt32LE=function readInt32LE(offset,noAssert){offset=offset>>>0;if(!noAssert)checkOffset(offset,4,this.length);return this[offset]|this[offset+1]<<8|this[offset+2]<<16|this[offset+3]<<24;};Buffer.prototype.readInt32BE=function readInt32BE(offset,noAssert){offset=offset>>>0;if(!noAssert)checkOffset(offset,4,this.length);return this[offset]<<24|this[offset+1]<<16|this[offset+2]<<8|this[offset+3];};Buffer.prototype.readFloatLE=function readFloatLE(offset,noAssert){offset=offset>>>0;if(!noAssert)checkOffset(offset,4,this.length);return ieee754.read(this,offset,true,23,4);};Buffer.prototype.readFloatBE=function readFloatBE(offset,noAssert){offset=offset>>>0;if(!noAssert)checkOffset(offset,4,this.length);return ieee754.read(this,offset,false,23,4);};Buffer.prototype.readDoubleLE=function readDoubleLE(offset,noAssert){offset=offset>>>0;if(!noAssert)checkOffset(offset,8,this.length);return ieee754.read(this,offset,true,52,8);};Buffer.prototype.readDoubleBE=function readDoubleBE(offset,noAssert){offset=offset>>>0;if(!noAssert)checkOffset(offset,8,this.length);return ieee754.read(this,offset,false,52,8);};function checkInt(buf,value,offset,ext,max,min){if(!Buffer.isBuffer(buf))throw new TypeError('"buffer" argument must be a Buffer instance');if(value>max||value<min)throw new RangeError('"value" argument is out of bounds');if(offset+ext>buf.length)throw new RangeError('Index out of range');}
Buffer.prototype.writeUIntLE=function writeUIntLE(value,offset,byteLength,noAssert){value=+value;offset=offset>>>0;byteLength=byteLength>>>0;if(!noAssert){var maxBytes=Math.pow(2,8*byteLength)-1;checkInt(this,value,offset,byteLength,maxBytes,0);}
var mul=1;var i=0;this[offset]=value&0xFF;while(++i<byteLength&&(mul*=0x100)){this[offset+i]=value/mul&0xFF;}
return offset+byteLength;};Buffer.prototype.writeUIntBE=function writeUIntBE(value,offset,byteLength,noAssert){value=+value;offset=offset>>>0;byteLength=byteLength>>>0;if(!noAssert){var maxBytes=Math.pow(2,8*byteLength)-1;checkInt(this,value,offset,byteLength,maxBytes,0);}
var i=byteLength-1;var mul=1;this[offset+i]=value&0xFF;while(--i>=0&&(mul*=0x100)){this[offset+i]=value/mul&0xFF;}
return offset+byteLength;};Buffer.prototype.writeUInt8=function writeUInt8(value,offset,noAssert){value=+value;offset=offset>>>0;if(!noAssert)checkInt(this,value,offset,1,0xff,0);this[offset]=value&0xff;return offset+1;};Buffer.prototype.writeUInt16LE=function writeUInt16LE(value,offset,noAssert){value=+value;offset=offset>>>0;if(!noAssert)checkInt(this,value,offset,2,0xffff,0);this[offset]=value&0xff;this[offset+1]=value>>>8;return offset+2;};Buffer.prototype.writeUInt16BE=function writeUInt16BE(value,offset,noAssert){value=+value;offset=offset>>>0;if(!noAssert)checkInt(this,value,offset,2,0xffff,0);this[offset]=value>>>8;this[offset+1]=value&0xff;return offset+2;};Buffer.prototype.writeUInt32LE=function writeUInt32LE(value,offset,noAssert){value=+value;offset=offset>>>0;if(!noAssert)checkInt(this,value,offset,4,0xffffffff,0);this[offset+3]=value>>>24;this[offset+2]=value>>>16;this[offset+1]=value>>>8;this[offset]=value&0xff;return offset+4;};Buffer.prototype.writeUInt32BE=function writeUInt32BE(value,offset,noAssert){value=+value;offset=offset>>>0;if(!noAssert)checkInt(this,value,offset,4,0xffffffff,0);this[offset]=value>>>24;this[offset+1]=value>>>16;this[offset+2]=value>>>8;this[offset+3]=value&0xff;return offset+4;};Buffer.prototype.writeIntLE=function writeIntLE(value,offset,byteLength,noAssert){value=+value;offset=offset>>>0;if(!noAssert){var limit=Math.pow(2,8*byteLength-1);checkInt(this,value,offset,byteLength,limit-1,-limit);}
var i=0;var mul=1;var sub=0;this[offset]=value&0xFF;while(++i<byteLength&&(mul*=0x100)){if(value<0&&sub===0&&this[offset+i-1]!==0){sub=1;}
this[offset+i]=(value/mul>>0)-sub&0xFF;}
return offset+byteLength;};Buffer.prototype.writeIntBE=function writeIntBE(value,offset,byteLength,noAssert){value=+value;offset=offset>>>0;if(!noAssert){var limit=Math.pow(2,8*byteLength-1);checkInt(this,value,offset,byteLength,limit-1,-limit);}
var i=byteLength-1;var mul=1;var sub=0;this[offset+i]=value&0xFF;while(--i>=0&&(mul*=0x100)){if(value<0&&sub===0&&this[offset+i+1]!==0){sub=1;}
this[offset+i]=(value/mul>>0)-sub&0xFF;}
return offset+byteLength;};Buffer.prototype.writeInt8=function writeInt8(value,offset,noAssert){value=+value;offset=offset>>>0;if(!noAssert)checkInt(this,value,offset,1,0x7f,-0x80);if(value<0)value=0xff+value+1;this[offset]=value&0xff;return offset+1;};Buffer.prototype.writeInt16LE=function writeInt16LE(value,offset,noAssert){value=+value;offset=offset>>>0;if(!noAssert)checkInt(this,value,offset,2,0x7fff,-0x8000);this[offset]=value&0xff;this[offset+1]=value>>>8;return offset+2;};Buffer.prototype.writeInt16BE=function writeInt16BE(value,offset,noAssert){value=+value;offset=offset>>>0;if(!noAssert)checkInt(this,value,offset,2,0x7fff,-0x8000);this[offset]=value>>>8;this[offset+1]=value&0xff;return offset+2;};Buffer.prototype.writeInt32LE=function writeInt32LE(value,offset,noAssert){value=+value;offset=offset>>>0;if(!noAssert)checkInt(this,value,offset,4,0x7fffffff,-0x80000000);this[offset]=value&0xff;this[offset+1]=value>>>8;this[offset+2]=value>>>16;this[offset+3]=value>>>24;return offset+4;};Buffer.prototype.writeInt32BE=function writeInt32BE(value,offset,noAssert){value=+value;offset=offset>>>0;if(!noAssert)checkInt(this,value,offset,4,0x7fffffff,-0x80000000);if(value<0)value=0xffffffff+value+1;this[offset]=value>>>24;this[offset+1]=value>>>16;this[offset+2]=value>>>8;this[offset+3]=value&0xff;return offset+4;};function checkIEEE754(buf,value,offset,ext,max,min){if(offset+ext>buf.length)throw new RangeError('Index out of range');if(offset<0)throw new RangeError('Index out of range');}
function writeFloat(buf,value,offset,littleEndian,noAssert){value=+value;offset=offset>>>0;if(!noAssert){checkIEEE754(buf,value,offset,4,3.4028234663852886e+38,-3.4028234663852886e+38);}
ieee754.write(buf,value,offset,littleEndian,23,4);return offset+4;}
Buffer.prototype.writeFloatLE=function writeFloatLE(value,offset,noAssert){return writeFloat(this,value,offset,true,noAssert);};Buffer.prototype.writeFloatBE=function writeFloatBE(value,offset,noAssert){return writeFloat(this,value,offset,false,noAssert);};function writeDouble(buf,value,offset,littleEndian,noAssert){value=+value;offset=offset>>>0;if(!noAssert){checkIEEE754(buf,value,offset,8,1.7976931348623157E+308,-1.7976931348623157E+308);}
ieee754.write(buf,value,offset,littleEndian,52,8);return offset+8;}
Buffer.prototype.writeDoubleLE=function writeDoubleLE(value,offset,noAssert){return writeDouble(this,value,offset,true,noAssert);};Buffer.prototype.writeDoubleBE=function writeDoubleBE(value,offset,noAssert){return writeDouble(this,value,offset,false,noAssert);};Buffer.prototype.copy=function copy(target,targetStart,start,end){if(!Buffer.isBuffer(target))throw new TypeError('argument should be a Buffer');if(!start)start=0;if(!end&&end!==0)end=this.length;if(targetStart>=target.length)targetStart=target.length;if(!targetStart)targetStart=0;if(end>0&&end<start)end=start;if(end===start)return 0;if(target.length===0||this.length===0)return 0;if(targetStart<0){throw new RangeError('targetStart out of bounds');}
if(start<0||start>=this.length)throw new RangeError('Index out of range');if(end<0)throw new RangeError('sourceEnd out of bounds');if(end>this.length)end=this.length;if(target.length-targetStart<end-start){end=target.length-targetStart+start;}
var len=end-start;if(this===target&&typeof Uint8Array.prototype.copyWithin==='function'){this.copyWithin(targetStart,start,end);}else if(this===target&&start<targetStart&&targetStart<end){for(var i=len-1;i>=0;--i){target[i+targetStart]=this[i+start];}}else{Uint8Array.prototype.set.call(target,this.subarray(start,end),targetStart);}
return len;};Buffer.prototype.fill=function fill(val,start,end,encoding){if(typeof val==='string'){if(typeof start==='string'){encoding=start;start=0;end=this.length;}else if(typeof end==='string'){encoding=end;end=this.length;}
if(encoding!==undefined&&typeof encoding!=='string'){throw new TypeError('encoding must be a string');}
if(typeof encoding==='string'&&!Buffer.isEncoding(encoding)){throw new TypeError('Unknown encoding: '+encoding);}
if(val.length===1){var code=val.charCodeAt(0);if(encoding==='utf8'&&code<128||encoding==='latin1'){val=code;}}}else if(typeof val==='number'){val=val&255;}
if(start<0||this.length<start||this.length<end){throw new RangeError('Out of range index');}
if(end<=start){return this;}
start=start>>>0;end=end===undefined?this.length:end>>>0;if(!val)val=0;var i;if(typeof val==='number'){for(i=start;i<end;++i){this[i]=val;}}else{var bytes=Buffer.isBuffer(val)?val:new Buffer(val,encoding);var len=bytes.length;if(len===0){throw new TypeError('The value "'+val+'" is invalid for argument "value"');}
for(i=0;i<end-start;++i){this[i+start]=bytes[i%len];}}
return this;};var INVALID_BASE64_RE=/[^+/0-9A-Za-z-_]/g;function base64clean(str){str=str.split('=')[0];str=str.trim().replace(INVALID_BASE64_RE,'');if(str.length<2)return'';while(str.length%4!==0){str=str+'=';}
return str;}
function toHex(n){if(n<16)return'0'+n.toString(16);return n.toString(16);}
function utf8ToBytes(string,units){units=units||Infinity;var codePoint;var length=string.length;var leadSurrogate=null;var bytes=[];for(var i=0;i<length;++i){codePoint=string.charCodeAt(i);if(codePoint>0xD7FF&&codePoint<0xE000){if(!leadSurrogate){if(codePoint>0xDBFF){if((units-=3)>-1)bytes.push(0xEF,0xBF,0xBD);continue;}else if(i+1===length){if((units-=3)>-1)bytes.push(0xEF,0xBF,0xBD);continue;}
leadSurrogate=codePoint;continue;}
if(codePoint<0xDC00){if((units-=3)>-1)bytes.push(0xEF,0xBF,0xBD);leadSurrogate=codePoint;continue;}
codePoint=(leadSurrogate-0xD800<<10|codePoint-0xDC00)+0x10000;}else if(leadSurrogate){if((units-=3)>-1)bytes.push(0xEF,0xBF,0xBD);}
leadSurrogate=null;if(codePoint<0x80){if((units-=1)<0)break;bytes.push(codePoint);}else if(codePoint<0x800){if((units-=2)<0)break;bytes.push(codePoint>>0x6|0xC0,codePoint&0x3F|0x80);}else if(codePoint<0x10000){if((units-=3)<0)break;bytes.push(codePoint>>0xC|0xE0,codePoint>>0x6&0x3F|0x80,codePoint&0x3F|0x80);}else if(codePoint<0x110000){if((units-=4)<0)break;bytes.push(codePoint>>0x12|0xF0,codePoint>>0xC&0x3F|0x80,codePoint>>0x6&0x3F|0x80,codePoint&0x3F|0x80);}else{throw new Error('Invalid code point');}}
return bytes;}
function asciiToBytes(str){var byteArray=[];for(var i=0;i<str.length;++i){byteArray.push(str.charCodeAt(i)&0xFF);}
return byteArray;}
function utf16leToBytes(str,units){var c,hi,lo;var byteArray=[];for(var i=0;i<str.length;++i){if((units-=2)<0)break;c=str.charCodeAt(i);hi=c>>8;lo=c%256;byteArray.push(lo);byteArray.push(hi);}
return byteArray;}
function base64ToBytes(str){return base64.toByteArray(base64clean(str));}
function blitBuffer(src,dst,offset,length){for(var i=0;i<length;++i){if(i+offset>=dst.length||i>=src.length)break;dst[i+offset]=src[i];}
return i;}
function isArrayBuffer(obj){return obj instanceof ArrayBuffer||obj!=null&&obj.constructor!=null&&obj.constructor.name==='ArrayBuffer'&&typeof obj.byteLength==='number';}
function numberIsNaN(obj){return obj!==obj;}},{"base64-js":54,"ieee754":63}],61:[function(require,module,exports){(function(Buffer){function isArray(arg){if(Array.isArray){return Array.isArray(arg);}
return objectToString(arg)==='[object Array]';}
exports.isArray=isArray;function isBoolean(arg){return typeof arg==='boolean';}
exports.isBoolean=isBoolean;function isNull(arg){return arg===null;}
exports.isNull=isNull;function isNullOrUndefined(arg){return arg==null;}
exports.isNullOrUndefined=isNullOrUndefined;function isNumber(arg){return typeof arg==='number';}
exports.isNumber=isNumber;function isString(arg){return typeof arg==='string';}
exports.isString=isString;function isSymbol(arg){return typeof arg==='symbol';}
exports.isSymbol=isSymbol;function isUndefined(arg){return arg===void 0;}
exports.isUndefined=isUndefined;function isRegExp(re){return objectToString(re)==='[object RegExp]';}
exports.isRegExp=isRegExp;function isObject(arg){return typeof arg==='object'&&arg!==null;}
exports.isObject=isObject;function isDate(d){return objectToString(d)==='[object Date]';}
exports.isDate=isDate;function isError(e){return objectToString(e)==='[object Error]'||e instanceof Error;}
exports.isError=isError;function isFunction(arg){return typeof arg==='function';}
exports.isFunction=isFunction;function isPrimitive(arg){return arg===null||typeof arg==='boolean'||typeof arg==='number'||typeof arg==='string'||typeof arg==='symbol'||typeof arg==='undefined';}
exports.isPrimitive=isPrimitive;exports.isBuffer=Buffer.isBuffer;function objectToString(o){return Object.prototype.toString.call(o);}}).call(this,{"isBuffer":require("../../is-buffer/index.js")});},{"../../is-buffer/index.js":65}],62:[function(require,module,exports){var objectCreate=Object.create||objectCreatePolyfill;var objectKeys=Object.keys||objectKeysPolyfill;var bind=Function.prototype.bind||functionBindPolyfill;function EventEmitter(){if(!this._events||!Object.prototype.hasOwnProperty.call(this,'_events')){this._events=objectCreate(null);this._eventsCount=0;}
this._maxListeners=this._maxListeners||undefined;}
module.exports=EventEmitter;EventEmitter.EventEmitter=EventEmitter;EventEmitter.prototype._events=undefined;EventEmitter.prototype._maxListeners=undefined;var defaultMaxListeners=10;var hasDefineProperty;try{var o={};if(Object.defineProperty)Object.defineProperty(o,'x',{value:0});hasDefineProperty=o.x===0;}catch(err){hasDefineProperty=false;}
if(hasDefineProperty){Object.defineProperty(EventEmitter,'defaultMaxListeners',{enumerable:true,get:function(){return defaultMaxListeners;},set:function(arg){if(typeof arg!=='number'||arg<0||arg!==arg)
throw new TypeError('"defaultMaxListeners" must be a positive number');defaultMaxListeners=arg;}});}else{EventEmitter.defaultMaxListeners=defaultMaxListeners;}
EventEmitter.prototype.setMaxListeners=function setMaxListeners(n){if(typeof n!=='number'||n<0||isNaN(n))
throw new TypeError('"n" argument must be a positive number');this._maxListeners=n;return this;};function $getMaxListeners(that){if(that._maxListeners===undefined)
return EventEmitter.defaultMaxListeners;return that._maxListeners;}
EventEmitter.prototype.getMaxListeners=function getMaxListeners(){return $getMaxListeners(this);};function emitNone(handler,isFn,self){if(isFn)
handler.call(self);else
{var len=handler.length;var listeners=arrayClone(handler,len);for(var i=0;i<len;++i)
listeners[i].call(self);}}
function emitOne(handler,isFn,self,arg1){if(isFn)
handler.call(self,arg1);else
{var len=handler.length;var listeners=arrayClone(handler,len);for(var i=0;i<len;++i)
listeners[i].call(self,arg1);}}
function emitTwo(handler,isFn,self,arg1,arg2){if(isFn)
handler.call(self,arg1,arg2);else
{var len=handler.length;var listeners=arrayClone(handler,len);for(var i=0;i<len;++i)
listeners[i].call(self,arg1,arg2);}}
function emitThree(handler,isFn,self,arg1,arg2,arg3){if(isFn)
handler.call(self,arg1,arg2,arg3);else
{var len=handler.length;var listeners=arrayClone(handler,len);for(var i=0;i<len;++i)
listeners[i].call(self,arg1,arg2,arg3);}}
function emitMany(handler,isFn,self,args){if(isFn)
handler.apply(self,args);else
{var len=handler.length;var listeners=arrayClone(handler,len);for(var i=0;i<len;++i)
listeners[i].apply(self,args);}}
EventEmitter.prototype.emit=function emit(type){var er,handler,len,args,i,events;var doError=type==='error';events=this._events;if(events)
doError=doError&&events.error==null;else
if(!doError)
return false;if(doError){if(arguments.length>1)
er=arguments[1];if(er instanceof Error){throw er;}else{var err=new Error('Unhandled "error" event. ('+er+')');err.context=er;throw err;}
return false;}
handler=events[type];if(!handler)
return false;var isFn=typeof handler==='function';len=arguments.length;switch(len){case 1:emitNone(handler,isFn,this);break;case 2:emitOne(handler,isFn,this,arguments[1]);break;case 3:emitTwo(handler,isFn,this,arguments[1],arguments[2]);break;case 4:emitThree(handler,isFn,this,arguments[1],arguments[2],arguments[3]);break;default:args=new Array(len-1);for(i=1;i<len;i++)
args[i-1]=arguments[i];emitMany(handler,isFn,this,args);}
return true;};function _addListener(target,type,listener,prepend){var m;var events;var existing;if(typeof listener!=='function')
throw new TypeError('"listener" argument must be a function');events=target._events;if(!events){events=target._events=objectCreate(null);target._eventsCount=0;}else{if(events.newListener){target.emit('newListener',type,listener.listener?listener.listener:listener);events=target._events;}
existing=events[type];}
if(!existing){existing=events[type]=listener;++target._eventsCount;}else{if(typeof existing==='function'){existing=events[type]=prepend?[listener,existing]:[existing,listener];}else{if(prepend){existing.unshift(listener);}else{existing.push(listener);}}
if(!existing.warned){m=$getMaxListeners(target);if(m&&m>0&&existing.length>m){existing.warned=true;var w=new Error('Possible EventEmitter memory leak detected. '+
existing.length+' "'+String(type)+'" listeners '+'added. Use emitter.setMaxListeners() to '+'increase limit.');w.name='MaxListenersExceededWarning';w.emitter=target;w.type=type;w.count=existing.length;if(typeof console==='object'&&console.warn){console.warn('%s: %s',w.name,w.message);}}}}
return target;}
EventEmitter.prototype.addListener=function addListener(type,listener){return _addListener(this,type,listener,false);};EventEmitter.prototype.on=EventEmitter.prototype.addListener;EventEmitter.prototype.prependListener=function prependListener(type,listener){return _addListener(this,type,listener,true);};function onceWrapper(){if(!this.fired){this.target.removeListener(this.type,this.wrapFn);this.fired=true;switch(arguments.length){case 0:return this.listener.call(this.target);case 1:return this.listener.call(this.target,arguments[0]);case 2:return this.listener.call(this.target,arguments[0],arguments[1]);case 3:return this.listener.call(this.target,arguments[0],arguments[1],arguments[2]);default:var args=new Array(arguments.length);for(var i=0;i<args.length;++i)
args[i]=arguments[i];this.listener.apply(this.target,args);}}}
function _onceWrap(target,type,listener){var state={fired:false,wrapFn:undefined,target:target,type:type,listener:listener};var wrapped=bind.call(onceWrapper,state);wrapped.listener=listener;state.wrapFn=wrapped;return wrapped;}
EventEmitter.prototype.once=function once(type,listener){if(typeof listener!=='function')
throw new TypeError('"listener" argument must be a function');this.on(type,_onceWrap(this,type,listener));return this;};EventEmitter.prototype.prependOnceListener=function prependOnceListener(type,listener){if(typeof listener!=='function')
throw new TypeError('"listener" argument must be a function');this.prependListener(type,_onceWrap(this,type,listener));return this;};EventEmitter.prototype.removeListener=function removeListener(type,listener){var list,events,position,i,originalListener;if(typeof listener!=='function')
throw new TypeError('"listener" argument must be a function');events=this._events;if(!events)
return this;list=events[type];if(!list)
return this;if(list===listener||list.listener===listener){if(--this._eventsCount===0)
this._events=objectCreate(null);else
{delete events[type];if(events.removeListener)
this.emit('removeListener',type,list.listener||listener);}}else if(typeof list!=='function'){position=-1;for(i=list.length-1;i>=0;i--){if(list[i]===listener||list[i].listener===listener){originalListener=list[i].listener;position=i;break;}}
if(position<0)
return this;if(position===0)
list.shift();else
spliceOne(list,position);if(list.length===1)
events[type]=list[0];if(events.removeListener)
this.emit('removeListener',type,originalListener||listener);}
return this;};EventEmitter.prototype.removeAllListeners=function removeAllListeners(type){var listeners,events,i;events=this._events;if(!events)
return this;if(!events.removeListener){if(arguments.length===0){this._events=objectCreate(null);this._eventsCount=0;}else if(events[type]){if(--this._eventsCount===0)
this._events=objectCreate(null);else
delete events[type];}
return this;}
if(arguments.length===0){var keys=objectKeys(events);var key;for(i=0;i<keys.length;++i){key=keys[i];if(key==='removeListener')continue;this.removeAllListeners(key);}
this.removeAllListeners('removeListener');this._events=objectCreate(null);this._eventsCount=0;return this;}
listeners=events[type];if(typeof listeners==='function'){this.removeListener(type,listeners);}else if(listeners){for(i=listeners.length-1;i>=0;i--){this.removeListener(type,listeners[i]);}}
return this;};EventEmitter.prototype.listeners=function listeners(type){var evlistener;var ret;var events=this._events;if(!events)
ret=[];else
{evlistener=events[type];if(!evlistener)
ret=[];else
if(typeof evlistener==='function')
ret=[evlistener.listener||evlistener];else
ret=unwrapListeners(evlistener);}
return ret;};EventEmitter.listenerCount=function(emitter,type){if(typeof emitter.listenerCount==='function'){return emitter.listenerCount(type);}else{return listenerCount.call(emitter,type);}};EventEmitter.prototype.listenerCount=listenerCount;function listenerCount(type){var events=this._events;if(events){var evlistener=events[type];if(typeof evlistener==='function'){return 1;}else if(evlistener){return evlistener.length;}}
return 0;}
EventEmitter.prototype.eventNames=function eventNames(){return this._eventsCount>0?Reflect.ownKeys(this._events):[];};function spliceOne(list,index){for(var i=index,k=i+1,n=list.length;k<n;i+=1,k+=1)
list[i]=list[k];list.pop();}
function arrayClone(arr,n){var copy=new Array(n);for(var i=0;i<n;++i)
copy[i]=arr[i];return copy;}
function unwrapListeners(arr){var ret=new Array(arr.length);for(var i=0;i<ret.length;++i){ret[i]=arr[i].listener||arr[i];}
return ret;}
function objectCreatePolyfill(proto){var F=function(){};F.prototype=proto;return new F();}
function objectKeysPolyfill(obj){var keys=[];for(var k in obj)if(Object.prototype.hasOwnProperty.call(obj,k)){keys.push(k);}
return k;}
function functionBindPolyfill(context){var fn=this;return function(){return fn.apply(context,arguments);};}},{}],63:[function(require,module,exports){exports.read=function(buffer,offset,isLE,mLen,nBytes){var e,m;var eLen=nBytes*8-mLen-1;var eMax=(1<<eLen)-1;var eBias=eMax>>1;var nBits=-7;var i=isLE?nBytes-1:0;var d=isLE?-1:1;var s=buffer[offset+i];i+=d;e=s&(1<<-nBits)-1;s>>=-nBits;nBits+=eLen;for(;nBits>0;e=e*256+buffer[offset+i],i+=d,nBits-=8){}
m=e&(1<<-nBits)-1;e>>=-nBits;nBits+=mLen;for(;nBits>0;m=m*256+buffer[offset+i],i+=d,nBits-=8){}
if(e===0){e=1-eBias;}else if(e===eMax){return m?NaN:(s?-1:1)*Infinity;}else{m=m+Math.pow(2,mLen);e=e-eBias;}
return(s?-1:1)*m*Math.pow(2,e-mLen);};exports.write=function(buffer,value,offset,isLE,mLen,nBytes){var e,m,c;var eLen=nBytes*8-mLen-1;var eMax=(1<<eLen)-1;var eBias=eMax>>1;var rt=mLen===23?Math.pow(2,-24)-Math.pow(2,-77):0;var i=isLE?0:nBytes-1;var d=isLE?1:-1;var s=value<0||value===0&&1/value<0?1:0;value=Math.abs(value);if(isNaN(value)||value===Infinity){m=isNaN(value)?1:0;e=eMax;}else{e=Math.floor(Math.log(value)/Math.LN2);if(value*(c=Math.pow(2,-e))<1){e--;c*=2;}
if(e+eBias>=1){value+=rt/c;}else{value+=rt*Math.pow(2,1-eBias);}
if(value*c>=2){e++;c/=2;}
if(e+eBias>=eMax){m=0;e=eMax;}else if(e+eBias>=1){m=(value*c-1)*Math.pow(2,mLen);e=e+eBias;}else{m=value*Math.pow(2,eBias-1)*Math.pow(2,mLen);e=0;}}
for(;mLen>=8;buffer[offset+i]=m&0xff,i+=d,m/=256,mLen-=8){}
e=e<<mLen|m;eLen+=mLen;for(;eLen>0;buffer[offset+i]=e&0xff,i+=d,e/=256,eLen-=8){}
buffer[offset+i-d]|=s*128;};},{}],64:[function(require,module,exports){if(typeof Object.create==='function'){module.exports=function inherits(ctor,superCtor){ctor.super_=superCtor;ctor.prototype=Object.create(superCtor.prototype,{constructor:{value:ctor,enumerable:false,writable:true,configurable:true}});};}else{module.exports=function inherits(ctor,superCtor){ctor.super_=superCtor;var TempCtor=function(){};TempCtor.prototype=superCtor.prototype;ctor.prototype=new TempCtor();ctor.prototype.constructor=ctor;};}},{}],65:[function(require,module,exports){module.exports=function(obj){return obj!=null&&(isBuffer(obj)||isSlowBuffer(obj)||!!obj._isBuffer);};function isBuffer(obj){return!!obj.constructor&&typeof obj.constructor.isBuffer==='function'&&obj.constructor.isBuffer(obj);}
function isSlowBuffer(obj){return typeof obj.readFloatLE==='function'&&typeof obj.slice==='function'&&isBuffer(obj.slice(0,0));}},{}],66:[function(require,module,exports){var toString={}.toString;module.exports=Array.isArray||function(arr){return toString.call(arr)=='[object Array]';};},{}],67:[function(require,module,exports){'use strict';var TYPED_OK=typeof Uint8Array!=='undefined'&&typeof Uint16Array!=='undefined'&&typeof Int32Array!=='undefined';function _has(obj,key){return Object.prototype.hasOwnProperty.call(obj,key);}
exports.assign=function(obj){var sources=Array.prototype.slice.call(arguments,1);while(sources.length){var source=sources.shift();if(!source){continue;}
if(typeof source!=='object'){throw new TypeError(source+'must be non-object');}
for(var p in source){if(_has(source,p)){obj[p]=source[p];}}}
return obj;};exports.shrinkBuf=function(buf,size){if(buf.length===size){return buf;}
if(buf.subarray){return buf.subarray(0,size);}
buf.length=size;return buf;};var fnTyped={arraySet:function(dest,src,src_offs,len,dest_offs){if(src.subarray&&dest.subarray){dest.set(src.subarray(src_offs,src_offs+len),dest_offs);return;}
for(var i=0;i<len;i++){dest[dest_offs+i]=src[src_offs+i];}},flattenChunks:function(chunks){var i,l,len,pos,chunk,result;len=0;for(i=0,l=chunks.length;i<l;i++){len+=chunks[i].length;}
result=new Uint8Array(len);pos=0;for(i=0,l=chunks.length;i<l;i++){chunk=chunks[i];result.set(chunk,pos);pos+=chunk.length;}
return result;}};var fnUntyped={arraySet:function(dest,src,src_offs,len,dest_offs){for(var i=0;i<len;i++){dest[dest_offs+i]=src[src_offs+i];}},flattenChunks:function(chunks){return[].concat.apply([],chunks);}};exports.setTyped=function(on){if(on){exports.Buf8=Uint8Array;exports.Buf16=Uint16Array;exports.Buf32=Int32Array;exports.assign(exports,fnTyped);}else{exports.Buf8=Array;exports.Buf16=Array;exports.Buf32=Array;exports.assign(exports,fnUntyped);}};exports.setTyped(TYPED_OK);},{}],68:[function(require,module,exports){'use strict';function adler32(adler,buf,len,pos){var s1=adler&0xffff|0,s2=adler>>>16&0xffff|0,n=0;while(len!==0){n=len>2000?2000:len;len-=n;do{s1=s1+buf[pos++]|0;s2=s2+s1|0;}while(--n);s1%=65521;s2%=65521;}
return s1|s2<<16|0;}
module.exports=adler32;},{}],69:[function(require,module,exports){'use strict';module.exports={Z_NO_FLUSH:0,Z_PARTIAL_FLUSH:1,Z_SYNC_FLUSH:2,Z_FULL_FLUSH:3,Z_FINISH:4,Z_BLOCK:5,Z_TREES:6,Z_OK:0,Z_STREAM_END:1,Z_NEED_DICT:2,Z_ERRNO:-1,Z_STREAM_ERROR:-2,Z_DATA_ERROR:-3,Z_BUF_ERROR:-5,Z_NO_COMPRESSION:0,Z_BEST_SPEED:1,Z_BEST_COMPRESSION:9,Z_DEFAULT_COMPRESSION:-1,Z_FILTERED:1,Z_HUFFMAN_ONLY:2,Z_RLE:3,Z_FIXED:4,Z_DEFAULT_STRATEGY:0,Z_BINARY:0,Z_TEXT:1,Z_UNKNOWN:2,Z_DEFLATED:8};},{}],70:[function(require,module,exports){'use strict';function makeTable(){var c,table=[];for(var n=0;n<256;n++){c=n;for(var k=0;k<8;k++){c=c&1?0xEDB88320^c>>>1:c>>>1;}
table[n]=c;}
return table;}
var crcTable=makeTable();function crc32(crc,buf,len,pos){var t=crcTable,end=pos+len;crc^=-1;for(var i=pos;i<end;i++){crc=crc>>>8^t[(crc^buf[i])&0xFF];}
return crc^-1;}
module.exports=crc32;},{}],71:[function(require,module,exports){'use strict';var utils=require('../utils/common');var trees=require('./trees');var adler32=require('./adler32');var crc32=require('./crc32');var msg=require('./messages');var Z_NO_FLUSH=0;var Z_PARTIAL_FLUSH=1;var Z_FULL_FLUSH=3;var Z_FINISH=4;var Z_BLOCK=5;var Z_OK=0;var Z_STREAM_END=1;var Z_STREAM_ERROR=-2;var Z_DATA_ERROR=-3;var Z_BUF_ERROR=-5;var Z_DEFAULT_COMPRESSION=-1;var Z_FILTERED=1;var Z_HUFFMAN_ONLY=2;var Z_RLE=3;var Z_FIXED=4;var Z_DEFAULT_STRATEGY=0;var Z_UNKNOWN=2;var Z_DEFLATED=8;var MAX_MEM_LEVEL=9;var MAX_WBITS=15;var DEF_MEM_LEVEL=8;var LENGTH_CODES=29;var LITERALS=256;var L_CODES=LITERALS+1+LENGTH_CODES;var D_CODES=30;var BL_CODES=19;var HEAP_SIZE=2*L_CODES+1;var MAX_BITS=15;var MIN_MATCH=3;var MAX_MATCH=258;var MIN_LOOKAHEAD=MAX_MATCH+MIN_MATCH+1;var PRESET_DICT=0x20;var INIT_STATE=42;var EXTRA_STATE=69;var NAME_STATE=73;var COMMENT_STATE=91;var HCRC_STATE=103;var BUSY_STATE=113;var FINISH_STATE=666;var BS_NEED_MORE=1;var BS_BLOCK_DONE=2;var BS_FINISH_STARTED=3;var BS_FINISH_DONE=4;var OS_CODE=0x03;function err(strm,errorCode){strm.msg=msg[errorCode];return errorCode;}
function rank(f){return(f<<1)-(f>4?9:0);}
function zero(buf){var len=buf.length;while(--len>=0){buf[len]=0;}}
function flush_pending(strm){var s=strm.state;var len=s.pending;if(len>strm.avail_out){len=strm.avail_out;}
if(len===0){return;}
utils.arraySet(strm.output,s.pending_buf,s.pending_out,len,strm.next_out);strm.next_out+=len;s.pending_out+=len;strm.total_out+=len;strm.avail_out-=len;s.pending-=len;if(s.pending===0){s.pending_out=0;}}
function flush_block_only(s,last){trees._tr_flush_block(s,s.block_start>=0?s.block_start:-1,s.strstart-s.block_start,last);s.block_start=s.strstart;flush_pending(s.strm);}
function put_byte(s,b){s.pending_buf[s.pending++]=b;}
function putShortMSB(s,b){s.pending_buf[s.pending++]=b>>>8&0xff;s.pending_buf[s.pending++]=b&0xff;}
function read_buf(strm,buf,start,size){var len=strm.avail_in;if(len>size){len=size;}
if(len===0){return 0;}
strm.avail_in-=len;utils.arraySet(buf,strm.input,strm.next_in,len,start);if(strm.state.wrap===1){strm.adler=adler32(strm.adler,buf,len,start);}else
if(strm.state.wrap===2){strm.adler=crc32(strm.adler,buf,len,start);}
strm.next_in+=len;strm.total_in+=len;return len;}
function longest_match(s,cur_match){var chain_length=s.max_chain_length;var scan=s.strstart;var match;var len;var best_len=s.prev_length;var nice_match=s.nice_match;var limit=s.strstart>s.w_size-MIN_LOOKAHEAD?s.strstart-(s.w_size-MIN_LOOKAHEAD):0;var _win=s.window;var wmask=s.w_mask;var prev=s.prev;var strend=s.strstart+MAX_MATCH;var scan_end1=_win[scan+best_len-1];var scan_end=_win[scan+best_len];if(s.prev_length>=s.good_match){chain_length>>=2;}
if(nice_match>s.lookahead){nice_match=s.lookahead;}
do{match=cur_match;if(_win[match+best_len]!==scan_end||_win[match+best_len-1]!==scan_end1||_win[match]!==_win[scan]||_win[++match]!==_win[scan+1]){continue;}
scan+=2;match++;do{}while(_win[++scan]===_win[++match]&&_win[++scan]===_win[++match]&&_win[++scan]===_win[++match]&&_win[++scan]===_win[++match]&&_win[++scan]===_win[++match]&&_win[++scan]===_win[++match]&&_win[++scan]===_win[++match]&&_win[++scan]===_win[++match]&&scan<strend);len=MAX_MATCH-(strend-scan);scan=strend-MAX_MATCH;if(len>best_len){s.match_start=cur_match;best_len=len;if(len>=nice_match){break;}
scan_end1=_win[scan+best_len-1];scan_end=_win[scan+best_len];}}while((cur_match=prev[cur_match&wmask])>limit&&--chain_length!==0);if(best_len<=s.lookahead){return best_len;}
return s.lookahead;}
function fill_window(s){var _w_size=s.w_size;var p,n,m,more,str;do{more=s.window_size-s.lookahead-s.strstart;if(s.strstart>=_w_size+(_w_size-MIN_LOOKAHEAD)){utils.arraySet(s.window,s.window,_w_size,_w_size,0);s.match_start-=_w_size;s.strstart-=_w_size;s.block_start-=_w_size;n=s.hash_size;p=n;do{m=s.head[--p];s.head[p]=m>=_w_size?m-_w_size:0;}while(--n);n=_w_size;p=n;do{m=s.prev[--p];s.prev[p]=m>=_w_size?m-_w_size:0;}while(--n);more+=_w_size;}
if(s.strm.avail_in===0){break;}
n=read_buf(s.strm,s.window,s.strstart+s.lookahead,more);s.lookahead+=n;if(s.lookahead+s.insert>=MIN_MATCH){str=s.strstart-s.insert;s.ins_h=s.window[str];s.ins_h=(s.ins_h<<s.hash_shift^s.window[str+1])&s.hash_mask;while(s.insert){s.ins_h=(s.ins_h<<s.hash_shift^s.window[str+MIN_MATCH-1])&s.hash_mask;s.prev[str&s.w_mask]=s.head[s.ins_h];s.head[s.ins_h]=str;str++;s.insert--;if(s.lookahead+s.insert<MIN_MATCH){break;}}}}while(s.lookahead<MIN_LOOKAHEAD&&s.strm.avail_in!==0);}
function deflate_stored(s,flush){var max_block_size=0xffff;if(max_block_size>s.pending_buf_size-5){max_block_size=s.pending_buf_size-5;}
for(;;){if(s.lookahead<=1){fill_window(s);if(s.lookahead===0&&flush===Z_NO_FLUSH){return BS_NEED_MORE;}
if(s.lookahead===0){break;}}
s.strstart+=s.lookahead;s.lookahead=0;var max_start=s.block_start+max_block_size;if(s.strstart===0||s.strstart>=max_start){s.lookahead=s.strstart-max_start;s.strstart=max_start;flush_block_only(s,false);if(s.strm.avail_out===0){return BS_NEED_MORE;}}
if(s.strstart-s.block_start>=s.w_size-MIN_LOOKAHEAD){flush_block_only(s,false);if(s.strm.avail_out===0){return BS_NEED_MORE;}}}
s.insert=0;if(flush===Z_FINISH){flush_block_only(s,true);if(s.strm.avail_out===0){return BS_FINISH_STARTED;}
return BS_FINISH_DONE;}
if(s.strstart>s.block_start){flush_block_only(s,false);if(s.strm.avail_out===0){return BS_NEED_MORE;}}
return BS_NEED_MORE;}
function deflate_fast(s,flush){var hash_head;var bflush;for(;;){if(s.lookahead<MIN_LOOKAHEAD){fill_window(s);if(s.lookahead<MIN_LOOKAHEAD&&flush===Z_NO_FLUSH){return BS_NEED_MORE;}
if(s.lookahead===0){break;}}
hash_head=0;if(s.lookahead>=MIN_MATCH){s.ins_h=(s.ins_h<<s.hash_shift^s.window[s.strstart+MIN_MATCH-1])&s.hash_mask;hash_head=s.prev[s.strstart&s.w_mask]=s.head[s.ins_h];s.head[s.ins_h]=s.strstart;}
if(hash_head!==0&&s.strstart-hash_head<=s.w_size-MIN_LOOKAHEAD){s.match_length=longest_match(s,hash_head);}
if(s.match_length>=MIN_MATCH){bflush=trees._tr_tally(s,s.strstart-s.match_start,s.match_length-MIN_MATCH);s.lookahead-=s.match_length;if(s.match_length<=s.max_lazy_match&&s.lookahead>=MIN_MATCH){s.match_length--;do{s.strstart++;s.ins_h=(s.ins_h<<s.hash_shift^s.window[s.strstart+MIN_MATCH-1])&s.hash_mask;hash_head=s.prev[s.strstart&s.w_mask]=s.head[s.ins_h];s.head[s.ins_h]=s.strstart;}while(--s.match_length!==0);s.strstart++;}else
{s.strstart+=s.match_length;s.match_length=0;s.ins_h=s.window[s.strstart];s.ins_h=(s.ins_h<<s.hash_shift^s.window[s.strstart+1])&s.hash_mask;}}else{bflush=trees._tr_tally(s,0,s.window[s.strstart]);s.lookahead--;s.strstart++;}
if(bflush){flush_block_only(s,false);if(s.strm.avail_out===0){return BS_NEED_MORE;}}}
s.insert=s.strstart<MIN_MATCH-1?s.strstart:MIN_MATCH-1;if(flush===Z_FINISH){flush_block_only(s,true);if(s.strm.avail_out===0){return BS_FINISH_STARTED;}
return BS_FINISH_DONE;}
if(s.last_lit){flush_block_only(s,false);if(s.strm.avail_out===0){return BS_NEED_MORE;}}
return BS_BLOCK_DONE;}
function deflate_slow(s,flush){var hash_head;var bflush;var max_insert;for(;;){if(s.lookahead<MIN_LOOKAHEAD){fill_window(s);if(s.lookahead<MIN_LOOKAHEAD&&flush===Z_NO_FLUSH){return BS_NEED_MORE;}
if(s.lookahead===0){break;}}
hash_head=0;if(s.lookahead>=MIN_MATCH){s.ins_h=(s.ins_h<<s.hash_shift^s.window[s.strstart+MIN_MATCH-1])&s.hash_mask;hash_head=s.prev[s.strstart&s.w_mask]=s.head[s.ins_h];s.head[s.ins_h]=s.strstart;}
s.prev_length=s.match_length;s.prev_match=s.match_start;s.match_length=MIN_MATCH-1;if(hash_head!==0&&s.prev_length<s.max_lazy_match&&s.strstart-hash_head<=s.w_size-MIN_LOOKAHEAD){s.match_length=longest_match(s,hash_head);if(s.match_length<=5&&(s.strategy===Z_FILTERED||s.match_length===MIN_MATCH&&s.strstart-s.match_start>4096)){s.match_length=MIN_MATCH-1;}}
if(s.prev_length>=MIN_MATCH&&s.match_length<=s.prev_length){max_insert=s.strstart+s.lookahead-MIN_MATCH;bflush=trees._tr_tally(s,s.strstart-1-s.prev_match,s.prev_length-MIN_MATCH);s.lookahead-=s.prev_length-1;s.prev_length-=2;do{if(++s.strstart<=max_insert){s.ins_h=(s.ins_h<<s.hash_shift^s.window[s.strstart+MIN_MATCH-1])&s.hash_mask;hash_head=s.prev[s.strstart&s.w_mask]=s.head[s.ins_h];s.head[s.ins_h]=s.strstart;}}while(--s.prev_length!==0);s.match_available=0;s.match_length=MIN_MATCH-1;s.strstart++;if(bflush){flush_block_only(s,false);if(s.strm.avail_out===0){return BS_NEED_MORE;}}}else if(s.match_available){bflush=trees._tr_tally(s,0,s.window[s.strstart-1]);if(bflush){flush_block_only(s,false);}
s.strstart++;s.lookahead--;if(s.strm.avail_out===0){return BS_NEED_MORE;}}else{s.match_available=1;s.strstart++;s.lookahead--;}}
if(s.match_available){bflush=trees._tr_tally(s,0,s.window[s.strstart-1]);s.match_available=0;}
s.insert=s.strstart<MIN_MATCH-1?s.strstart:MIN_MATCH-1;if(flush===Z_FINISH){flush_block_only(s,true);if(s.strm.avail_out===0){return BS_FINISH_STARTED;}
return BS_FINISH_DONE;}
if(s.last_lit){flush_block_only(s,false);if(s.strm.avail_out===0){return BS_NEED_MORE;}}
return BS_BLOCK_DONE;}
function deflate_rle(s,flush){var bflush;var prev;var scan,strend;var _win=s.window;for(;;){if(s.lookahead<=MAX_MATCH){fill_window(s);if(s.lookahead<=MAX_MATCH&&flush===Z_NO_FLUSH){return BS_NEED_MORE;}
if(s.lookahead===0){break;}}
s.match_length=0;if(s.lookahead>=MIN_MATCH&&s.strstart>0){scan=s.strstart-1;prev=_win[scan];if(prev===_win[++scan]&&prev===_win[++scan]&&prev===_win[++scan]){strend=s.strstart+MAX_MATCH;do{}while(prev===_win[++scan]&&prev===_win[++scan]&&prev===_win[++scan]&&prev===_win[++scan]&&prev===_win[++scan]&&prev===_win[++scan]&&prev===_win[++scan]&&prev===_win[++scan]&&scan<strend);s.match_length=MAX_MATCH-(strend-scan);if(s.match_length>s.lookahead){s.match_length=s.lookahead;}}}
if(s.match_length>=MIN_MATCH){bflush=trees._tr_tally(s,1,s.match_length-MIN_MATCH);s.lookahead-=s.match_length;s.strstart+=s.match_length;s.match_length=0;}else{bflush=trees._tr_tally(s,0,s.window[s.strstart]);s.lookahead--;s.strstart++;}
if(bflush){flush_block_only(s,false);if(s.strm.avail_out===0){return BS_NEED_MORE;}}}
s.insert=0;if(flush===Z_FINISH){flush_block_only(s,true);if(s.strm.avail_out===0){return BS_FINISH_STARTED;}
return BS_FINISH_DONE;}
if(s.last_lit){flush_block_only(s,false);if(s.strm.avail_out===0){return BS_NEED_MORE;}}
return BS_BLOCK_DONE;}
function deflate_huff(s,flush){var bflush;for(;;){if(s.lookahead===0){fill_window(s);if(s.lookahead===0){if(flush===Z_NO_FLUSH){return BS_NEED_MORE;}
break;}}
s.match_length=0;bflush=trees._tr_tally(s,0,s.window[s.strstart]);s.lookahead--;s.strstart++;if(bflush){flush_block_only(s,false);if(s.strm.avail_out===0){return BS_NEED_MORE;}}}
s.insert=0;if(flush===Z_FINISH){flush_block_only(s,true);if(s.strm.avail_out===0){return BS_FINISH_STARTED;}
return BS_FINISH_DONE;}
if(s.last_lit){flush_block_only(s,false);if(s.strm.avail_out===0){return BS_NEED_MORE;}}
return BS_BLOCK_DONE;}
function Config(good_length,max_lazy,nice_length,max_chain,func){this.good_length=good_length;this.max_lazy=max_lazy;this.nice_length=nice_length;this.max_chain=max_chain;this.func=func;}
var configuration_table;configuration_table=[new Config(0,0,0,0,deflate_stored),new Config(4,4,8,4,deflate_fast),new Config(4,5,16,8,deflate_fast),new Config(4,6,32,32,deflate_fast),new Config(4,4,16,16,deflate_slow),new Config(8,16,32,32,deflate_slow),new Config(8,16,128,128,deflate_slow),new Config(8,32,128,256,deflate_slow),new Config(32,128,258,1024,deflate_slow),new Config(32,258,258,4096,deflate_slow)];function lm_init(s){s.window_size=2*s.w_size;zero(s.head);s.max_lazy_match=configuration_table[s.level].max_lazy;s.good_match=configuration_table[s.level].good_length;s.nice_match=configuration_table[s.level].nice_length;s.max_chain_length=configuration_table[s.level].max_chain;s.strstart=0;s.block_start=0;s.lookahead=0;s.insert=0;s.match_length=s.prev_length=MIN_MATCH-1;s.match_available=0;s.ins_h=0;}
function DeflateState(){this.strm=null;this.status=0;this.pending_buf=null;this.pending_buf_size=0;this.pending_out=0;this.pending=0;this.wrap=0;this.gzhead=null;this.gzindex=0;this.method=Z_DEFLATED;this.last_flush=-1;this.w_size=0;this.w_bits=0;this.w_mask=0;this.window=null;this.window_size=0;this.prev=null;this.head=null;this.ins_h=0;this.hash_size=0;this.hash_bits=0;this.hash_mask=0;this.hash_shift=0;this.block_start=0;this.match_length=0;this.prev_match=0;this.match_available=0;this.strstart=0;this.match_start=0;this.lookahead=0;this.prev_length=0;this.max_chain_length=0;this.max_lazy_match=0;this.level=0;this.strategy=0;this.good_match=0;this.nice_match=0;this.dyn_ltree=new utils.Buf16(HEAP_SIZE*2);this.dyn_dtree=new utils.Buf16((2*D_CODES+1)*2);this.bl_tree=new utils.Buf16((2*BL_CODES+1)*2);zero(this.dyn_ltree);zero(this.dyn_dtree);zero(this.bl_tree);this.l_desc=null;this.d_desc=null;this.bl_desc=null;this.bl_count=new utils.Buf16(MAX_BITS+1);this.heap=new utils.Buf16(2*L_CODES+1);zero(this.heap);this.heap_len=0;this.heap_max=0;this.depth=new utils.Buf16(2*L_CODES+1);zero(this.depth);this.l_buf=0;this.lit_bufsize=0;this.last_lit=0;this.d_buf=0;this.opt_len=0;this.static_len=0;this.matches=0;this.insert=0;this.bi_buf=0;this.bi_valid=0;}
function deflateResetKeep(strm){var s;if(!strm||!strm.state){return err(strm,Z_STREAM_ERROR);}
strm.total_in=strm.total_out=0;strm.data_type=Z_UNKNOWN;s=strm.state;s.pending=0;s.pending_out=0;if(s.wrap<0){s.wrap=-s.wrap;}
s.status=s.wrap?INIT_STATE:BUSY_STATE;strm.adler=s.wrap===2?0:1;s.last_flush=Z_NO_FLUSH;trees._tr_init(s);return Z_OK;}
function deflateReset(strm){var ret=deflateResetKeep(strm);if(ret===Z_OK){lm_init(strm.state);}
return ret;}
function deflateSetHeader(strm,head){if(!strm||!strm.state){return Z_STREAM_ERROR;}
if(strm.state.wrap!==2){return Z_STREAM_ERROR;}
strm.state.gzhead=head;return Z_OK;}
function deflateInit2(strm,level,method,windowBits,memLevel,strategy){if(!strm){return Z_STREAM_ERROR;}
var wrap=1;if(level===Z_DEFAULT_COMPRESSION){level=6;}
if(windowBits<0){wrap=0;windowBits=-windowBits;}else
if(windowBits>15){wrap=2;windowBits-=16;}
if(memLevel<1||memLevel>MAX_MEM_LEVEL||method!==Z_DEFLATED||windowBits<8||windowBits>15||level<0||level>9||strategy<0||strategy>Z_FIXED){return err(strm,Z_STREAM_ERROR);}
if(windowBits===8){windowBits=9;}
var s=new DeflateState();strm.state=s;s.strm=strm;s.wrap=wrap;s.gzhead=null;s.w_bits=windowBits;s.w_size=1<<s.w_bits;s.w_mask=s.w_size-1;s.hash_bits=memLevel+7;s.hash_size=1<<s.hash_bits;s.hash_mask=s.hash_size-1;s.hash_shift=~~((s.hash_bits+MIN_MATCH-1)/MIN_MATCH);s.window=new utils.Buf8(s.w_size*2);s.head=new utils.Buf16(s.hash_size);s.prev=new utils.Buf16(s.w_size);s.lit_bufsize=1<<memLevel+6;s.pending_buf_size=s.lit_bufsize*4;s.pending_buf=new utils.Buf8(s.pending_buf_size);s.d_buf=1*s.lit_bufsize;s.l_buf=(1+2)*s.lit_bufsize;s.level=level;s.strategy=strategy;s.method=method;return deflateReset(strm);}
function deflateInit(strm,level){return deflateInit2(strm,level,Z_DEFLATED,MAX_WBITS,DEF_MEM_LEVEL,Z_DEFAULT_STRATEGY);}
function deflate(strm,flush){var old_flush,s;var beg,val;if(!strm||!strm.state||flush>Z_BLOCK||flush<0){return strm?err(strm,Z_STREAM_ERROR):Z_STREAM_ERROR;}
s=strm.state;if(!strm.output||!strm.input&&strm.avail_in!==0||s.status===FINISH_STATE&&flush!==Z_FINISH){return err(strm,strm.avail_out===0?Z_BUF_ERROR:Z_STREAM_ERROR);}
s.strm=strm;old_flush=s.last_flush;s.last_flush=flush;if(s.status===INIT_STATE){if(s.wrap===2){strm.adler=0;put_byte(s,31);put_byte(s,139);put_byte(s,8);if(!s.gzhead){put_byte(s,0);put_byte(s,0);put_byte(s,0);put_byte(s,0);put_byte(s,0);put_byte(s,s.level===9?2:s.strategy>=Z_HUFFMAN_ONLY||s.level<2?4:0);put_byte(s,OS_CODE);s.status=BUSY_STATE;}else
{put_byte(s,(s.gzhead.text?1:0)+(s.gzhead.hcrc?2:0)+(!s.gzhead.extra?0:4)+(!s.gzhead.name?0:8)+(!s.gzhead.comment?0:16));put_byte(s,s.gzhead.time&0xff);put_byte(s,s.gzhead.time>>8&0xff);put_byte(s,s.gzhead.time>>16&0xff);put_byte(s,s.gzhead.time>>24&0xff);put_byte(s,s.level===9?2:s.strategy>=Z_HUFFMAN_ONLY||s.level<2?4:0);put_byte(s,s.gzhead.os&0xff);if(s.gzhead.extra&&s.gzhead.extra.length){put_byte(s,s.gzhead.extra.length&0xff);put_byte(s,s.gzhead.extra.length>>8&0xff);}
if(s.gzhead.hcrc){strm.adler=crc32(strm.adler,s.pending_buf,s.pending,0);}
s.gzindex=0;s.status=EXTRA_STATE;}}else
{var header=Z_DEFLATED+(s.w_bits-8<<4)<<8;var level_flags=-1;if(s.strategy>=Z_HUFFMAN_ONLY||s.level<2){level_flags=0;}else if(s.level<6){level_flags=1;}else if(s.level===6){level_flags=2;}else{level_flags=3;}
header|=level_flags<<6;if(s.strstart!==0){header|=PRESET_DICT;}
header+=31-header%31;s.status=BUSY_STATE;putShortMSB(s,header);if(s.strstart!==0){putShortMSB(s,strm.adler>>>16);putShortMSB(s,strm.adler&0xffff);}
strm.adler=1;}}
if(s.status===EXTRA_STATE){if(s.gzhead.extra){beg=s.pending;while(s.gzindex<(s.gzhead.extra.length&0xffff)){if(s.pending===s.pending_buf_size){if(s.gzhead.hcrc&&s.pending>beg){strm.adler=crc32(strm.adler,s.pending_buf,s.pending-beg,beg);}
flush_pending(strm);beg=s.pending;if(s.pending===s.pending_buf_size){break;}}
put_byte(s,s.gzhead.extra[s.gzindex]&0xff);s.gzindex++;}
if(s.gzhead.hcrc&&s.pending>beg){strm.adler=crc32(strm.adler,s.pending_buf,s.pending-beg,beg);}
if(s.gzindex===s.gzhead.extra.length){s.gzindex=0;s.status=NAME_STATE;}}else
{s.status=NAME_STATE;}}
if(s.status===NAME_STATE){if(s.gzhead.name){beg=s.pending;do{if(s.pending===s.pending_buf_size){if(s.gzhead.hcrc&&s.pending>beg){strm.adler=crc32(strm.adler,s.pending_buf,s.pending-beg,beg);}
flush_pending(strm);beg=s.pending;if(s.pending===s.pending_buf_size){val=1;break;}}
if(s.gzindex<s.gzhead.name.length){val=s.gzhead.name.charCodeAt(s.gzindex++)&0xff;}else{val=0;}
put_byte(s,val);}while(val!==0);if(s.gzhead.hcrc&&s.pending>beg){strm.adler=crc32(strm.adler,s.pending_buf,s.pending-beg,beg);}
if(val===0){s.gzindex=0;s.status=COMMENT_STATE;}}else
{s.status=COMMENT_STATE;}}
if(s.status===COMMENT_STATE){if(s.gzhead.comment){beg=s.pending;do{if(s.pending===s.pending_buf_size){if(s.gzhead.hcrc&&s.pending>beg){strm.adler=crc32(strm.adler,s.pending_buf,s.pending-beg,beg);}
flush_pending(strm);beg=s.pending;if(s.pending===s.pending_buf_size){val=1;break;}}
if(s.gzindex<s.gzhead.comment.length){val=s.gzhead.comment.charCodeAt(s.gzindex++)&0xff;}else{val=0;}
put_byte(s,val);}while(val!==0);if(s.gzhead.hcrc&&s.pending>beg){strm.adler=crc32(strm.adler,s.pending_buf,s.pending-beg,beg);}
if(val===0){s.status=HCRC_STATE;}}else
{s.status=HCRC_STATE;}}
if(s.status===HCRC_STATE){if(s.gzhead.hcrc){if(s.pending+2>s.pending_buf_size){flush_pending(strm);}
if(s.pending+2<=s.pending_buf_size){put_byte(s,strm.adler&0xff);put_byte(s,strm.adler>>8&0xff);strm.adler=0;s.status=BUSY_STATE;}}else
{s.status=BUSY_STATE;}}
if(s.pending!==0){flush_pending(strm);if(strm.avail_out===0){s.last_flush=-1;return Z_OK;}}else if(strm.avail_in===0&&rank(flush)<=rank(old_flush)&&flush!==Z_FINISH){return err(strm,Z_BUF_ERROR);}
if(s.status===FINISH_STATE&&strm.avail_in!==0){return err(strm,Z_BUF_ERROR);}
if(strm.avail_in!==0||s.lookahead!==0||flush!==Z_NO_FLUSH&&s.status!==FINISH_STATE){var bstate=s.strategy===Z_HUFFMAN_ONLY?deflate_huff(s,flush):s.strategy===Z_RLE?deflate_rle(s,flush):configuration_table[s.level].func(s,flush);if(bstate===BS_FINISH_STARTED||bstate===BS_FINISH_DONE){s.status=FINISH_STATE;}
if(bstate===BS_NEED_MORE||bstate===BS_FINISH_STARTED){if(strm.avail_out===0){s.last_flush=-1;}
return Z_OK;}
if(bstate===BS_BLOCK_DONE){if(flush===Z_PARTIAL_FLUSH){trees._tr_align(s);}else
if(flush!==Z_BLOCK){trees._tr_stored_block(s,0,0,false);if(flush===Z_FULL_FLUSH){zero(s.head);if(s.lookahead===0){s.strstart=0;s.block_start=0;s.insert=0;}}}
flush_pending(strm);if(strm.avail_out===0){s.last_flush=-1;return Z_OK;}}}
if(flush!==Z_FINISH){return Z_OK;}
if(s.wrap<=0){return Z_STREAM_END;}
if(s.wrap===2){put_byte(s,strm.adler&0xff);put_byte(s,strm.adler>>8&0xff);put_byte(s,strm.adler>>16&0xff);put_byte(s,strm.adler>>24&0xff);put_byte(s,strm.total_in&0xff);put_byte(s,strm.total_in>>8&0xff);put_byte(s,strm.total_in>>16&0xff);put_byte(s,strm.total_in>>24&0xff);}else
{putShortMSB(s,strm.adler>>>16);putShortMSB(s,strm.adler&0xffff);}
flush_pending(strm);if(s.wrap>0){s.wrap=-s.wrap;}
return s.pending!==0?Z_OK:Z_STREAM_END;}
function deflateEnd(strm){var status;if(!strm||!strm.state){return Z_STREAM_ERROR;}
status=strm.state.status;if(status!==INIT_STATE&&status!==EXTRA_STATE&&status!==NAME_STATE&&status!==COMMENT_STATE&&status!==HCRC_STATE&&status!==BUSY_STATE&&status!==FINISH_STATE)
{return err(strm,Z_STREAM_ERROR);}
strm.state=null;return status===BUSY_STATE?err(strm,Z_DATA_ERROR):Z_OK;}
function deflateSetDictionary(strm,dictionary){var dictLength=dictionary.length;var s;var str,n;var wrap;var avail;var next;var input;var tmpDict;if(!strm||!strm.state){return Z_STREAM_ERROR;}
s=strm.state;wrap=s.wrap;if(wrap===2||wrap===1&&s.status!==INIT_STATE||s.lookahead){return Z_STREAM_ERROR;}
if(wrap===1){strm.adler=adler32(strm.adler,dictionary,dictLength,0);}
s.wrap=0;if(dictLength>=s.w_size){if(wrap===0){zero(s.head);s.strstart=0;s.block_start=0;s.insert=0;}
tmpDict=new utils.Buf8(s.w_size);utils.arraySet(tmpDict,dictionary,dictLength-s.w_size,s.w_size,0);dictionary=tmpDict;dictLength=s.w_size;}
avail=strm.avail_in;next=strm.next_in;input=strm.input;strm.avail_in=dictLength;strm.next_in=0;strm.input=dictionary;fill_window(s);while(s.lookahead>=MIN_MATCH){str=s.strstart;n=s.lookahead-(MIN_MATCH-1);do{s.ins_h=(s.ins_h<<s.hash_shift^s.window[str+MIN_MATCH-1])&s.hash_mask;s.prev[str&s.w_mask]=s.head[s.ins_h];s.head[s.ins_h]=str;str++;}while(--n);s.strstart=str;s.lookahead=MIN_MATCH-1;fill_window(s);}
s.strstart+=s.lookahead;s.block_start=s.strstart;s.insert=s.lookahead;s.lookahead=0;s.match_length=s.prev_length=MIN_MATCH-1;s.match_available=0;strm.next_in=next;strm.input=input;strm.avail_in=avail;s.wrap=wrap;return Z_OK;}
exports.deflateInit=deflateInit;exports.deflateInit2=deflateInit2;exports.deflateReset=deflateReset;exports.deflateResetKeep=deflateResetKeep;exports.deflateSetHeader=deflateSetHeader;exports.deflate=deflate;exports.deflateEnd=deflateEnd;exports.deflateSetDictionary=deflateSetDictionary;exports.deflateInfo='pako deflate (from Nodeca project)';},{"../utils/common":67,"./adler32":68,"./crc32":70,"./messages":72,"./trees":73}],72:[function(require,module,exports){'use strict';module.exports={2:'need dictionary',1:'stream end',0:'','-1':'file error','-2':'stream error','-3':'data error','-4':'insufficient memory','-5':'buffer error','-6':'incompatible version'};},{}],73:[function(require,module,exports){'use strict';var utils=require('../utils/common');var Z_FIXED=4;var Z_BINARY=0;var Z_TEXT=1;var Z_UNKNOWN=2;function zero(buf){var len=buf.length;while(--len>=0){buf[len]=0;}}
var STORED_BLOCK=0;var STATIC_TREES=1;var DYN_TREES=2;var MIN_MATCH=3;var MAX_MATCH=258;var LENGTH_CODES=29;var LITERALS=256;var L_CODES=LITERALS+1+LENGTH_CODES;var D_CODES=30;var BL_CODES=19;var HEAP_SIZE=2*L_CODES+1;var MAX_BITS=15;var Buf_size=16;var MAX_BL_BITS=7;var END_BLOCK=256;var REP_3_6=16;var REPZ_3_10=17;var REPZ_11_138=18;var extra_lbits=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0];var extra_dbits=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13];var extra_blbits=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7];var bl_order=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];var DIST_CODE_LEN=512;var static_ltree=new Array((L_CODES+2)*2);zero(static_ltree);var static_dtree=new Array(D_CODES*2);zero(static_dtree);var _dist_code=new Array(DIST_CODE_LEN);zero(_dist_code);var _length_code=new Array(MAX_MATCH-MIN_MATCH+1);zero(_length_code);var base_length=new Array(LENGTH_CODES);zero(base_length);var base_dist=new Array(D_CODES);zero(base_dist);function StaticTreeDesc(static_tree,extra_bits,extra_base,elems,max_length){this.static_tree=static_tree;this.extra_bits=extra_bits;this.extra_base=extra_base;this.elems=elems;this.max_length=max_length;this.has_stree=static_tree&&static_tree.length;}
var static_l_desc;var static_d_desc;var static_bl_desc;function TreeDesc(dyn_tree,stat_desc){this.dyn_tree=dyn_tree;this.max_code=0;this.stat_desc=stat_desc;}
function d_code(dist){return dist<256?_dist_code[dist]:_dist_code[256+(dist>>>7)];}
function put_short(s,w){s.pending_buf[s.pending++]=w&0xff;s.pending_buf[s.pending++]=w>>>8&0xff;}
function send_bits(s,value,length){if(s.bi_valid>Buf_size-length){s.bi_buf|=value<<s.bi_valid&0xffff;put_short(s,s.bi_buf);s.bi_buf=value>>Buf_size-s.bi_valid;s.bi_valid+=length-Buf_size;}else{s.bi_buf|=value<<s.bi_valid&0xffff;s.bi_valid+=length;}}
function send_code(s,c,tree){send_bits(s,tree[c*2],tree[c*2+1]);}
function bi_reverse(code,len){var res=0;do{res|=code&1;code>>>=1;res<<=1;}while(--len>0);return res>>>1;}
function bi_flush(s){if(s.bi_valid===16){put_short(s,s.bi_buf);s.bi_buf=0;s.bi_valid=0;}else if(s.bi_valid>=8){s.pending_buf[s.pending++]=s.bi_buf&0xff;s.bi_buf>>=8;s.bi_valid-=8;}}
function gen_bitlen(s,desc)
{var tree=desc.dyn_tree;var max_code=desc.max_code;var stree=desc.stat_desc.static_tree;var has_stree=desc.stat_desc.has_stree;var extra=desc.stat_desc.extra_bits;var base=desc.stat_desc.extra_base;var max_length=desc.stat_desc.max_length;var h;var n,m;var bits;var xbits;var f;var overflow=0;for(bits=0;bits<=MAX_BITS;bits++){s.bl_count[bits]=0;}
tree[s.heap[s.heap_max]*2+1]=0;for(h=s.heap_max+1;h<HEAP_SIZE;h++){n=s.heap[h];bits=tree[tree[n*2+1]*2+1]+1;if(bits>max_length){bits=max_length;overflow++;}
tree[n*2+1]=bits;if(n>max_code){continue;}
s.bl_count[bits]++;xbits=0;if(n>=base){xbits=extra[n-base];}
f=tree[n*2];s.opt_len+=f*(bits+xbits);if(has_stree){s.static_len+=f*(stree[n*2+1]+xbits);}}
if(overflow===0){return;}
do{bits=max_length-1;while(s.bl_count[bits]===0){bits--;}
s.bl_count[bits]--;s.bl_count[bits+1]+=2;s.bl_count[max_length]--;overflow-=2;}while(overflow>0);for(bits=max_length;bits!==0;bits--){n=s.bl_count[bits];while(n!==0){m=s.heap[--h];if(m>max_code){continue;}
if(tree[m*2+1]!==bits){s.opt_len+=(bits-tree[m*2+1])*tree[m*2];tree[m*2+1]=bits;}
n--;}}}
function gen_codes(tree,max_code,bl_count)
{var next_code=new Array(MAX_BITS+1);var code=0;var bits;var n;for(bits=1;bits<=MAX_BITS;bits++){next_code[bits]=code=code+bl_count[bits-1]<<1;}
for(n=0;n<=max_code;n++){var len=tree[n*2+1];if(len===0){continue;}
tree[n*2]=bi_reverse(next_code[len]++,len);}}
function tr_static_init(){var n;var bits;var length;var code;var dist;var bl_count=new Array(MAX_BITS+1);length=0;for(code=0;code<LENGTH_CODES-1;code++){base_length[code]=length;for(n=0;n<1<<extra_lbits[code];n++){_length_code[length++]=code;}}
_length_code[length-1]=code;dist=0;for(code=0;code<16;code++){base_dist[code]=dist;for(n=0;n<1<<extra_dbits[code];n++){_dist_code[dist++]=code;}}
dist>>=7;for(;code<D_CODES;code++){base_dist[code]=dist<<7;for(n=0;n<1<<extra_dbits[code]-7;n++){_dist_code[256+dist++]=code;}}
for(bits=0;bits<=MAX_BITS;bits++){bl_count[bits]=0;}
n=0;while(n<=143){static_ltree[n*2+1]=8;n++;bl_count[8]++;}
while(n<=255){static_ltree[n*2+1]=9;n++;bl_count[9]++;}
while(n<=279){static_ltree[n*2+1]=7;n++;bl_count[7]++;}
while(n<=287){static_ltree[n*2+1]=8;n++;bl_count[8]++;}
gen_codes(static_ltree,L_CODES+1,bl_count);for(n=0;n<D_CODES;n++){static_dtree[n*2+1]=5;static_dtree[n*2]=bi_reverse(n,5);}
static_l_desc=new StaticTreeDesc(static_ltree,extra_lbits,LITERALS+1,L_CODES,MAX_BITS);static_d_desc=new StaticTreeDesc(static_dtree,extra_dbits,0,D_CODES,MAX_BITS);static_bl_desc=new StaticTreeDesc(new Array(0),extra_blbits,0,BL_CODES,MAX_BL_BITS);}
function init_block(s){var n;for(n=0;n<L_CODES;n++){s.dyn_ltree[n*2]=0;}
for(n=0;n<D_CODES;n++){s.dyn_dtree[n*2]=0;}
for(n=0;n<BL_CODES;n++){s.bl_tree[n*2]=0;}
s.dyn_ltree[END_BLOCK*2]=1;s.opt_len=s.static_len=0;s.last_lit=s.matches=0;}
function bi_windup(s)
{if(s.bi_valid>8){put_short(s,s.bi_buf);}else if(s.bi_valid>0){s.pending_buf[s.pending++]=s.bi_buf;}
s.bi_buf=0;s.bi_valid=0;}
function copy_block(s,buf,len,header)
{bi_windup(s);if(header){put_short(s,len);put_short(s,~len);}
utils.arraySet(s.pending_buf,s.window,buf,len,s.pending);s.pending+=len;}
function smaller(tree,n,m,depth){var _n2=n*2;var _m2=m*2;return tree[_n2]<tree[_m2]||tree[_n2]===tree[_m2]&&depth[n]<=depth[m];}
function pqdownheap(s,tree,k)
{var v=s.heap[k];var j=k<<1;while(j<=s.heap_len){if(j<s.heap_len&&smaller(tree,s.heap[j+1],s.heap[j],s.depth)){j++;}
if(smaller(tree,v,s.heap[j],s.depth)){break;}
s.heap[k]=s.heap[j];k=j;j<<=1;}
s.heap[k]=v;}
function compress_block(s,ltree,dtree)
{var dist;var lc;var lx=0;var code;var extra;if(s.last_lit!==0){do{dist=s.pending_buf[s.d_buf+lx*2]<<8|s.pending_buf[s.d_buf+lx*2+1];lc=s.pending_buf[s.l_buf+lx];lx++;if(dist===0){send_code(s,lc,ltree);}else{code=_length_code[lc];send_code(s,code+LITERALS+1,ltree);extra=extra_lbits[code];if(extra!==0){lc-=base_length[code];send_bits(s,lc,extra);}
dist--;code=d_code(dist);send_code(s,code,dtree);extra=extra_dbits[code];if(extra!==0){dist-=base_dist[code];send_bits(s,dist,extra);}}}while(lx<s.last_lit);}
send_code(s,END_BLOCK,ltree);}
function build_tree(s,desc)
{var tree=desc.dyn_tree;var stree=desc.stat_desc.static_tree;var has_stree=desc.stat_desc.has_stree;var elems=desc.stat_desc.elems;var n,m;var max_code=-1;var node;s.heap_len=0;s.heap_max=HEAP_SIZE;for(n=0;n<elems;n++){if(tree[n*2]!==0){s.heap[++s.heap_len]=max_code=n;s.depth[n]=0;}else{tree[n*2+1]=0;}}
while(s.heap_len<2){node=s.heap[++s.heap_len]=max_code<2?++max_code:0;tree[node*2]=1;s.depth[node]=0;s.opt_len--;if(has_stree){s.static_len-=stree[node*2+1];}}
desc.max_code=max_code;for(n=s.heap_len>>1;n>=1;n--){pqdownheap(s,tree,n);}
node=elems;do{n=s.heap[1];s.heap[1]=s.heap[s.heap_len--];pqdownheap(s,tree,1);m=s.heap[1];s.heap[--s.heap_max]=n;s.heap[--s.heap_max]=m;tree[node*2]=tree[n*2]+tree[m*2];s.depth[node]=(s.depth[n]>=s.depth[m]?s.depth[n]:s.depth[m])+1;tree[n*2+1]=tree[m*2+1]=node;s.heap[1]=node++;pqdownheap(s,tree,1);}while(s.heap_len>=2);s.heap[--s.heap_max]=s.heap[1];gen_bitlen(s,desc);gen_codes(tree,max_code,s.bl_count);}
function scan_tree(s,tree,max_code)
{var n;var prevlen=-1;var curlen;var nextlen=tree[0*2+1];var count=0;var max_count=7;var min_count=4;if(nextlen===0){max_count=138;min_count=3;}
tree[(max_code+1)*2+1]=0xffff;for(n=0;n<=max_code;n++){curlen=nextlen;nextlen=tree[(n+1)*2+1];if(++count<max_count&&curlen===nextlen){continue;}else if(count<min_count){s.bl_tree[curlen*2]+=count;}else if(curlen!==0){if(curlen!==prevlen){s.bl_tree[curlen*2]++;}
s.bl_tree[REP_3_6*2]++;}else if(count<=10){s.bl_tree[REPZ_3_10*2]++;}else{s.bl_tree[REPZ_11_138*2]++;}
count=0;prevlen=curlen;if(nextlen===0){max_count=138;min_count=3;}else if(curlen===nextlen){max_count=6;min_count=3;}else{max_count=7;min_count=4;}}}
function send_tree(s,tree,max_code)
{var n;var prevlen=-1;var curlen;var nextlen=tree[0*2+1];var count=0;var max_count=7;var min_count=4;if(nextlen===0){max_count=138;min_count=3;}
for(n=0;n<=max_code;n++){curlen=nextlen;nextlen=tree[(n+1)*2+1];if(++count<max_count&&curlen===nextlen){continue;}else if(count<min_count){do{send_code(s,curlen,s.bl_tree);}while(--count!==0);}else if(curlen!==0){if(curlen!==prevlen){send_code(s,curlen,s.bl_tree);count--;}
send_code(s,REP_3_6,s.bl_tree);send_bits(s,count-3,2);}else if(count<=10){send_code(s,REPZ_3_10,s.bl_tree);send_bits(s,count-3,3);}else{send_code(s,REPZ_11_138,s.bl_tree);send_bits(s,count-11,7);}
count=0;prevlen=curlen;if(nextlen===0){max_count=138;min_count=3;}else if(curlen===nextlen){max_count=6;min_count=3;}else{max_count=7;min_count=4;}}}
function build_bl_tree(s){var max_blindex;scan_tree(s,s.dyn_ltree,s.l_desc.max_code);scan_tree(s,s.dyn_dtree,s.d_desc.max_code);build_tree(s,s.bl_desc);for(max_blindex=BL_CODES-1;max_blindex>=3;max_blindex--){if(s.bl_tree[bl_order[max_blindex]*2+1]!==0){break;}}
s.opt_len+=3*(max_blindex+1)+5+5+4;return max_blindex;}
function send_all_trees(s,lcodes,dcodes,blcodes)
{var rank;send_bits(s,lcodes-257,5);send_bits(s,dcodes-1,5);send_bits(s,blcodes-4,4);for(rank=0;rank<blcodes;rank++){send_bits(s,s.bl_tree[bl_order[rank]*2+1],3);}
send_tree(s,s.dyn_ltree,lcodes-1);send_tree(s,s.dyn_dtree,dcodes-1);}
function detect_data_type(s){var black_mask=0xf3ffc07f;var n;for(n=0;n<=31;n++,black_mask>>>=1){if(black_mask&1&&s.dyn_ltree[n*2]!==0){return Z_BINARY;}}
if(s.dyn_ltree[9*2]!==0||s.dyn_ltree[10*2]!==0||s.dyn_ltree[13*2]!==0){return Z_TEXT;}
for(n=32;n<LITERALS;n++){if(s.dyn_ltree[n*2]!==0){return Z_TEXT;}}
return Z_BINARY;}
var static_init_done=false;function _tr_init(s)
{if(!static_init_done){tr_static_init();static_init_done=true;}
s.l_desc=new TreeDesc(s.dyn_ltree,static_l_desc);s.d_desc=new TreeDesc(s.dyn_dtree,static_d_desc);s.bl_desc=new TreeDesc(s.bl_tree,static_bl_desc);s.bi_buf=0;s.bi_valid=0;init_block(s);}
function _tr_stored_block(s,buf,stored_len,last)
{send_bits(s,(STORED_BLOCK<<1)+(last?1:0),3);copy_block(s,buf,stored_len,true);}
function _tr_align(s){send_bits(s,STATIC_TREES<<1,3);send_code(s,END_BLOCK,static_ltree);bi_flush(s);}
function _tr_flush_block(s,buf,stored_len,last)
{var opt_lenb,static_lenb;var max_blindex=0;if(s.level>0){if(s.strm.data_type===Z_UNKNOWN){s.strm.data_type=detect_data_type(s);}
build_tree(s,s.l_desc);build_tree(s,s.d_desc);max_blindex=build_bl_tree(s);opt_lenb=s.opt_len+3+7>>>3;static_lenb=s.static_len+3+7>>>3;if(static_lenb<=opt_lenb){opt_lenb=static_lenb;}}else{opt_lenb=static_lenb=stored_len+5;}
if(stored_len+4<=opt_lenb&&buf!==-1){_tr_stored_block(s,buf,stored_len,last);}else if(s.strategy===Z_FIXED||static_lenb===opt_lenb){send_bits(s,(STATIC_TREES<<1)+(last?1:0),3);compress_block(s,static_ltree,static_dtree);}else{send_bits(s,(DYN_TREES<<1)+(last?1:0),3);send_all_trees(s,s.l_desc.max_code+1,s.d_desc.max_code+1,max_blindex+1);compress_block(s,s.dyn_ltree,s.dyn_dtree);}
init_block(s);if(last){bi_windup(s);}}
function _tr_tally(s,dist,lc)
{s.pending_buf[s.d_buf+s.last_lit*2]=dist>>>8&0xff;s.pending_buf[s.d_buf+s.last_lit*2+1]=dist&0xff;s.pending_buf[s.l_buf+s.last_lit]=lc&0xff;s.last_lit++;if(dist===0){s.dyn_ltree[lc*2]++;}else{s.matches++;dist--;s.dyn_ltree[(_length_code[lc]+LITERALS+1)*2]++;s.dyn_dtree[d_code(dist)*2]++;}
return s.last_lit===s.lit_bufsize-1;}
exports._tr_init=_tr_init;exports._tr_stored_block=_tr_stored_block;exports._tr_flush_block=_tr_flush_block;exports._tr_tally=_tr_tally;exports._tr_align=_tr_align;},{"../utils/common":67}],74:[function(require,module,exports){'use strict';function ZStream(){this.input=null;this.next_in=0;this.avail_in=0;this.total_in=0;this.output=null;this.next_out=0;this.avail_out=0;this.total_out=0;this.msg='';this.state=null;this.data_type=2;this.adler=0;}
module.exports=ZStream;},{}],75:[function(require,module,exports){(function(process){function normalizeArray(parts,allowAboveRoot){var up=0;for(var i=parts.length-1;i>=0;i--){var last=parts[i];if(last==='.'){parts.splice(i,1);}else if(last==='..'){parts.splice(i,1);up++;}else if(up){parts.splice(i,1);up--;}}
if(allowAboveRoot){for(;up--;up){parts.unshift('..');}}
return parts;}
var splitPathRe=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;var splitPath=function(filename){return splitPathRe.exec(filename).slice(1);};exports.resolve=function(){var resolvedPath='',resolvedAbsolute=false;for(var i=arguments.length-1;i>=-1&&!resolvedAbsolute;i--){var path=i>=0?arguments[i]:process.cwd();if(typeof path!=='string'){throw new TypeError('Arguments to path.resolve must be strings');}else if(!path){continue;}
resolvedPath=path+'/'+resolvedPath;resolvedAbsolute=path.charAt(0)==='/';}
resolvedPath=normalizeArray(filter(resolvedPath.split('/'),function(p){return!!p;}),!resolvedAbsolute).join('/');return(resolvedAbsolute?'/':'')+resolvedPath||'.';};exports.normalize=function(path){var isAbsolute=exports.isAbsolute(path),trailingSlash=substr(path,-1)==='/';path=normalizeArray(filter(path.split('/'),function(p){return!!p;}),!isAbsolute).join('/');if(!path&&!isAbsolute){path='.';}
if(path&&trailingSlash){path+='/';}
return(isAbsolute?'/':'')+path;};exports.isAbsolute=function(path){return path.charAt(0)==='/';};exports.join=function(){var paths=Array.prototype.slice.call(arguments,0);return exports.normalize(filter(paths,function(p,index){if(typeof p!=='string'){throw new TypeError('Arguments to path.join must be strings');}
return p;}).join('/'));};exports.relative=function(from,to){from=exports.resolve(from).substr(1);to=exports.resolve(to).substr(1);function trim(arr){var start=0;for(;start<arr.length;start++){if(arr[start]!=='')break;}
var end=arr.length-1;for(;end>=0;end--){if(arr[end]!=='')break;}
if(start>end)return[];return arr.slice(start,end-start+1);}
var fromParts=trim(from.split('/'));var toParts=trim(to.split('/'));var length=Math.min(fromParts.length,toParts.length);var samePartsLength=length;for(var i=0;i<length;i++){if(fromParts[i]!==toParts[i]){samePartsLength=i;break;}}
var outputParts=[];for(var i=samePartsLength;i<fromParts.length;i++){outputParts.push('..');}
outputParts=outputParts.concat(toParts.slice(samePartsLength));return outputParts.join('/');};exports.sep='/';exports.delimiter=':';exports.dirname=function(path){var result=splitPath(path),root=result[0],dir=result[1];if(!root&&!dir){return'.';}
if(dir){dir=dir.substr(0,dir.length-1);}
return root+dir;};exports.basename=function(path,ext){var f=splitPath(path)[2];if(ext&&f.substr(-1*ext.length)===ext){f=f.substr(0,f.length-ext.length);}
return f;};exports.extname=function(path){return splitPath(path)[3];};function filter(xs,f){if(xs.filter)return xs.filter(f);var res=[];for(var i=0;i<xs.length;i++){if(f(xs[i],i,xs))res.push(xs[i]);}
return res;}
var substr='ab'.substr(-1)==='b'?function(str,start,len){return str.substr(start,len);}:function(str,start,len){if(start<0)start=str.length+start;return str.substr(start,len);};}).call(this,require('_process'));},{"_process":77}],76:[function(require,module,exports){(function(process){'use strict';if(!process.version||process.version.indexOf('v0.')===0||process.version.indexOf('v1.')===0&&process.version.indexOf('v1.8.')!==0){module.exports=nextTick;}else{module.exports=process.nextTick;}
function nextTick(fn,arg1,arg2,arg3){if(typeof fn!=='function'){throw new TypeError('"callback" argument must be a function');}
var len=arguments.length;var args,i;switch(len){case 0:case 1:return process.nextTick(fn);case 2:return process.nextTick(function afterTickOne(){fn.call(null,arg1);});case 3:return process.nextTick(function afterTickTwo(){fn.call(null,arg1,arg2);});case 4:return process.nextTick(function afterTickThree(){fn.call(null,arg1,arg2,arg3);});default:args=new Array(len-1);i=0;while(i<args.length){args[i++]=arguments[i];}
return process.nextTick(function afterTick(){fn.apply(null,args);});}}}).call(this,require('_process'));},{"_process":77}],77:[function(require,module,exports){var process=module.exports={};var cachedSetTimeout;var cachedClearTimeout;function defaultSetTimout(){throw new Error('setTimeout has not been defined');}
function defaultClearTimeout(){throw new Error('clearTimeout has not been defined');}
(function(){try{if(typeof setTimeout==='function'){cachedSetTimeout=setTimeout;}else{cachedSetTimeout=defaultSetTimout;}}catch(e){cachedSetTimeout=defaultSetTimout;}
try{if(typeof clearTimeout==='function'){cachedClearTimeout=clearTimeout;}else{cachedClearTimeout=defaultClearTimeout;}}catch(e){cachedClearTimeout=defaultClearTimeout;}})();function runTimeout(fun){if(cachedSetTimeout===setTimeout){return setTimeout(fun,0);}
if((cachedSetTimeout===defaultSetTimout||!cachedSetTimeout)&&setTimeout){cachedSetTimeout=setTimeout;return setTimeout(fun,0);}
try{return cachedSetTimeout(fun,0);}catch(e){try{return cachedSetTimeout.call(null,fun,0);}catch(e){return cachedSetTimeout.call(this,fun,0);}}}
function runClearTimeout(marker){if(cachedClearTimeout===clearTimeout){return clearTimeout(marker);}
if((cachedClearTimeout===defaultClearTimeout||!cachedClearTimeout)&&clearTimeout){cachedClearTimeout=clearTimeout;return clearTimeout(marker);}
try{return cachedClearTimeout(marker);}catch(e){try{return cachedClearTimeout.call(null,marker);}catch(e){return cachedClearTimeout.call(this,marker);}}}
var queue=[];var draining=false;var currentQueue;var queueIndex=-1;function cleanUpNextTick(){if(!draining||!currentQueue){return;}
draining=false;if(currentQueue.length){queue=currentQueue.concat(queue);}else{queueIndex=-1;}
if(queue.length){drainQueue();}}
function drainQueue(){if(draining){return;}
var timeout=runTimeout(cleanUpNextTick);draining=true;var len=queue.length;while(len){currentQueue=queue;queue=[];while(++queueIndex<len){if(currentQueue){currentQueue[queueIndex].run();}}
queueIndex=-1;len=queue.length;}
currentQueue=null;draining=false;runClearTimeout(timeout);}
process.nextTick=function(fun){var args=new Array(arguments.length-1);if(arguments.length>1){for(var i=1;i<arguments.length;i++){args[i-1]=arguments[i];}}
queue.push(new Item(fun,args));if(queue.length===1&&!draining){runTimeout(drainQueue);}};function Item(fun,array){this.fun=fun;this.array=array;}
Item.prototype.run=function(){this.fun.apply(null,this.array);};process.title='browser';process.browser=true;process.env={};process.argv=[];process.version='';process.versions={};function noop(){}
process.on=noop;process.addListener=noop;process.once=noop;process.off=noop;process.removeListener=noop;process.removeAllListeners=noop;process.emit=noop;process.prependListener=noop;process.prependOnceListener=noop;process.listeners=function(name){return[];};process.binding=function(name){throw new Error('process.binding is not supported');};process.cwd=function(){return'/';};process.chdir=function(dir){throw new Error('process.chdir is not supported');};process.umask=function(){return 0;};},{}],78:[function(require,module,exports){'use strict';function hasOwnProperty(obj,prop){return Object.prototype.hasOwnProperty.call(obj,prop);}
module.exports=function(qs,sep,eq,options){sep=sep||'&';eq=eq||'=';var obj={};if(typeof qs!=='string'||qs.length===0){return obj;}
var regexp=/\+/g;qs=qs.split(sep);var maxKeys=1000;if(options&&typeof options.maxKeys==='number'){maxKeys=options.maxKeys;}
var len=qs.length;if(maxKeys>0&&len>maxKeys){len=maxKeys;}
for(var i=0;i<len;++i){var x=qs[i].replace(regexp,'%20'),idx=x.indexOf(eq),kstr,vstr,k,v;if(idx>=0){kstr=x.substr(0,idx);vstr=x.substr(idx+1);}else{kstr=x;vstr='';}
k=decodeURIComponent(kstr);v=decodeURIComponent(vstr);if(!hasOwnProperty(obj,k)){obj[k]=v;}else if(isArray(obj[k])){obj[k].push(v);}else{obj[k]=[obj[k],v];}}
return obj;};var isArray=Array.isArray||function(xs){return Object.prototype.toString.call(xs)==='[object Array]';};},{}],79:[function(require,module,exports){'use strict';var stringifyPrimitive=function(v){switch(typeof v){case'string':return v;case'boolean':return v?'true':'false';case'number':return isFinite(v)?v:'';default:return'';}};module.exports=function(obj,sep,eq,name){sep=sep||'&';eq=eq||'=';if(obj===null){obj=undefined;}
if(typeof obj==='object'){return map(objectKeys(obj),function(k){var ks=encodeURIComponent(stringifyPrimitive(k))+eq;if(isArray(obj[k])){return map(obj[k],function(v){return ks+encodeURIComponent(stringifyPrimitive(v));}).join(sep);}else{return ks+encodeURIComponent(stringifyPrimitive(obj[k]));}}).join(sep);}
if(!name)return'';return encodeURIComponent(stringifyPrimitive(name))+eq+
encodeURIComponent(stringifyPrimitive(obj));};var isArray=Array.isArray||function(xs){return Object.prototype.toString.call(xs)==='[object Array]';};function map(xs,f){if(xs.map)return xs.map(f);var res=[];for(var i=0;i<xs.length;i++){res.push(f(xs[i],i));}
return res;}
var objectKeys=Object.keys||function(obj){var res=[];for(var key in obj){if(Object.prototype.hasOwnProperty.call(obj,key))res.push(key);}
return res;};},{}],80:[function(require,module,exports){'use strict';exports.decode=exports.parse=require('./decode');exports.encode=exports.stringify=require('./encode');},{"./decode":78,"./encode":79}],81:[function(require,module,exports){module.exports=require("./lib/_stream_duplex.js");},{"./lib/_stream_duplex.js":82}],82:[function(require,module,exports){'use strict';var objectKeys=Object.keys||function(obj){var keys=[];for(var key in obj){keys.push(key);}return keys;};module.exports=Duplex;var processNextTick=require('process-nextick-args');var util=require('core-util-is');util.inherits=require('inherits');var Readable=require('./_stream_readable');var Writable=require('./_stream_writable');util.inherits(Duplex,Readable);var keys=objectKeys(Writable.prototype);for(var v=0;v<keys.length;v++){var method=keys[v];if(!Duplex.prototype[method])Duplex.prototype[method]=Writable.prototype[method];}
function Duplex(options){if(!(this instanceof Duplex))return new Duplex(options);Readable.call(this,options);Writable.call(this,options);if(options&&options.readable===false)this.readable=false;if(options&&options.writable===false)this.writable=false;this.allowHalfOpen=true;if(options&&options.allowHalfOpen===false)this.allowHalfOpen=false;this.once('end',onend);}
function onend(){if(this.allowHalfOpen||this._writableState.ended)return;processNextTick(onEndNT,this);}
function onEndNT(self){self.end();}
function forEach(xs,f){for(var i=0,l=xs.length;i<l;i++){f(xs[i],i);}}},{"./_stream_readable":84,"./_stream_writable":86,"core-util-is":61,"inherits":64,"process-nextick-args":76}],83:[function(require,module,exports){'use strict';module.exports=PassThrough;var Transform=require('./_stream_transform');var util=require('core-util-is');util.inherits=require('inherits');util.inherits(PassThrough,Transform);function PassThrough(options){if(!(this instanceof PassThrough))return new PassThrough(options);Transform.call(this,options);}
PassThrough.prototype._transform=function(chunk,encoding,cb){cb(null,chunk);};},{"./_stream_transform":85,"core-util-is":61,"inherits":64}],84:[function(require,module,exports){(function(process){'use strict';module.exports=Readable;var processNextTick=require('process-nextick-args');var isArray=require('isarray');var Duplex;Readable.ReadableState=ReadableState;var EE=require('events').EventEmitter;var EElistenerCount=function(emitter,type){return emitter.listeners(type).length;};var Stream;(function(){try{Stream=require('st'+'ream');}catch(_){}finally{if(!Stream)Stream=require('events').EventEmitter;}})();var Buffer=require('buffer').Buffer;var bufferShim=require('buffer-shims');var util=require('core-util-is');util.inherits=require('inherits');var debugUtil=require('util');var debug=void 0;if(debugUtil&&debugUtil.debuglog){debug=debugUtil.debuglog('stream');}else{debug=function(){};}
var BufferList=require('./internal/streams/BufferList');var StringDecoder;util.inherits(Readable,Stream);function prependListener(emitter,event,fn){if(typeof emitter.prependListener==='function'){return emitter.prependListener(event,fn);}else{if(!emitter._events||!emitter._events[event])emitter.on(event,fn);else if(isArray(emitter._events[event]))emitter._events[event].unshift(fn);else emitter._events[event]=[fn,emitter._events[event]];}}
function ReadableState(options,stream){Duplex=Duplex||require('./_stream_duplex');options=options||{};this.objectMode=!!options.objectMode;if(stream instanceof Duplex)this.objectMode=this.objectMode||!!options.readableObjectMode;var hwm=options.highWaterMark;var defaultHwm=this.objectMode?16:16*1024;this.highWaterMark=hwm||hwm===0?hwm:defaultHwm;this.highWaterMark=~~this.highWaterMark;this.buffer=new BufferList();this.length=0;this.pipes=null;this.pipesCount=0;this.flowing=null;this.ended=false;this.endEmitted=false;this.reading=false;this.sync=true;this.needReadable=false;this.emittedReadable=false;this.readableListening=false;this.resumeScheduled=false;this.defaultEncoding=options.defaultEncoding||'utf8';this.ranOut=false;this.awaitDrain=0;this.readingMore=false;this.decoder=null;this.encoding=null;if(options.encoding){if(!StringDecoder)StringDecoder=require('string_decoder/').StringDecoder;this.decoder=new StringDecoder(options.encoding);this.encoding=options.encoding;}}
function Readable(options){Duplex=Duplex||require('./_stream_duplex');if(!(this instanceof Readable))return new Readable(options);this._readableState=new ReadableState(options,this);this.readable=true;if(options&&typeof options.read==='function')this._read=options.read;Stream.call(this);}
Readable.prototype.push=function(chunk,encoding){var state=this._readableState;if(!state.objectMode&&typeof chunk==='string'){encoding=encoding||state.defaultEncoding;if(encoding!==state.encoding){chunk=bufferShim.from(chunk,encoding);encoding='';}}
return readableAddChunk(this,state,chunk,encoding,false);};Readable.prototype.unshift=function(chunk){var state=this._readableState;return readableAddChunk(this,state,chunk,'',true);};Readable.prototype.isPaused=function(){return this._readableState.flowing===false;};function readableAddChunk(stream,state,chunk,encoding,addToFront){var er=chunkInvalid(state,chunk);if(er){stream.emit('error',er);}else if(chunk===null){state.reading=false;onEofChunk(stream,state);}else if(state.objectMode||chunk&&chunk.length>0){if(state.ended&&!addToFront){var e=new Error('stream.push() after EOF');stream.emit('error',e);}else if(state.endEmitted&&addToFront){var _e=new Error('stream.unshift() after end event');stream.emit('error',_e);}else{var skipAdd;if(state.decoder&&!addToFront&&!encoding){chunk=state.decoder.write(chunk);skipAdd=!state.objectMode&&chunk.length===0;}
if(!addToFront)state.reading=false;if(!skipAdd){if(state.flowing&&state.length===0&&!state.sync){stream.emit('data',chunk);stream.read(0);}else{state.length+=state.objectMode?1:chunk.length;if(addToFront)state.buffer.unshift(chunk);else state.buffer.push(chunk);if(state.needReadable)emitReadable(stream);}}
maybeReadMore(stream,state);}}else if(!addToFront){state.reading=false;}
return needMoreData(state);}
function needMoreData(state){return!state.ended&&(state.needReadable||state.length<state.highWaterMark||state.length===0);}
Readable.prototype.setEncoding=function(enc){if(!StringDecoder)StringDecoder=require('string_decoder/').StringDecoder;this._readableState.decoder=new StringDecoder(enc);this._readableState.encoding=enc;return this;};var MAX_HWM=0x800000;function computeNewHighWaterMark(n){if(n>=MAX_HWM){n=MAX_HWM;}else{n--;n|=n>>>1;n|=n>>>2;n|=n>>>4;n|=n>>>8;n|=n>>>16;n++;}
return n;}
function howMuchToRead(n,state){if(n<=0||state.length===0&&state.ended)return 0;if(state.objectMode)return 1;if(n!==n){if(state.flowing&&state.length)return state.buffer.head.data.length;else return state.length;}
if(n>state.highWaterMark)state.highWaterMark=computeNewHighWaterMark(n);if(n<=state.length)return n;if(!state.ended){state.needReadable=true;return 0;}
return state.length;}
Readable.prototype.read=function(n){debug('read',n);n=parseInt(n,10);var state=this._readableState;var nOrig=n;if(n!==0)state.emittedReadable=false;if(n===0&&state.needReadable&&(state.length>=state.highWaterMark||state.ended)){debug('read: emitReadable',state.length,state.ended);if(state.length===0&&state.ended)endReadable(this);else emitReadable(this);return null;}
n=howMuchToRead(n,state);if(n===0&&state.ended){if(state.length===0)endReadable(this);return null;}
var doRead=state.needReadable;debug('need readable',doRead);if(state.length===0||state.length-n<state.highWaterMark){doRead=true;debug('length less than watermark',doRead);}
if(state.ended||state.reading){doRead=false;debug('reading or ended',doRead);}else if(doRead){debug('do read');state.reading=true;state.sync=true;if(state.length===0)state.needReadable=true;this._read(state.highWaterMark);state.sync=false;if(!state.reading)n=howMuchToRead(nOrig,state);}
var ret;if(n>0)ret=fromList(n,state);else ret=null;if(ret===null){state.needReadable=true;n=0;}else{state.length-=n;}
if(state.length===0){if(!state.ended)state.needReadable=true;if(nOrig!==n&&state.ended)endReadable(this);}
if(ret!==null)this.emit('data',ret);return ret;};function chunkInvalid(state,chunk){var er=null;if(!Buffer.isBuffer(chunk)&&typeof chunk!=='string'&&chunk!==null&&chunk!==undefined&&!state.objectMode){er=new TypeError('Invalid non-string/buffer chunk');}
return er;}
function onEofChunk(stream,state){if(state.ended)return;if(state.decoder){var chunk=state.decoder.end();if(chunk&&chunk.length){state.buffer.push(chunk);state.length+=state.objectMode?1:chunk.length;}}
state.ended=true;emitReadable(stream);}
function emitReadable(stream){var state=stream._readableState;state.needReadable=false;if(!state.emittedReadable){debug('emitReadable',state.flowing);state.emittedReadable=true;if(state.sync)processNextTick(emitReadable_,stream);else emitReadable_(stream);}}
function emitReadable_(stream){debug('emit readable');stream.emit('readable');flow(stream);}
function maybeReadMore(stream,state){if(!state.readingMore){state.readingMore=true;processNextTick(maybeReadMore_,stream,state);}}
function maybeReadMore_(stream,state){var len=state.length;while(!state.reading&&!state.flowing&&!state.ended&&state.length<state.highWaterMark){debug('maybeReadMore read 0');stream.read(0);if(len===state.length)
break;else len=state.length;}
state.readingMore=false;}
Readable.prototype._read=function(n){this.emit('error',new Error('_read() is not implemented'));};Readable.prototype.pipe=function(dest,pipeOpts){var src=this;var state=this._readableState;switch(state.pipesCount){case 0:state.pipes=dest;break;case 1:state.pipes=[state.pipes,dest];break;default:state.pipes.push(dest);break;}
state.pipesCount+=1;debug('pipe count=%d opts=%j',state.pipesCount,pipeOpts);var doEnd=(!pipeOpts||pipeOpts.end!==false)&&dest!==process.stdout&&dest!==process.stderr;var endFn=doEnd?onend:cleanup;if(state.endEmitted)processNextTick(endFn);else src.once('end',endFn);dest.on('unpipe',onunpipe);function onunpipe(readable){debug('onunpipe');if(readable===src){cleanup();}}
function onend(){debug('onend');dest.end();}
var ondrain=pipeOnDrain(src);dest.on('drain',ondrain);var cleanedUp=false;function cleanup(){debug('cleanup');dest.removeListener('close',onclose);dest.removeListener('finish',onfinish);dest.removeListener('drain',ondrain);dest.removeListener('error',onerror);dest.removeListener('unpipe',onunpipe);src.removeListener('end',onend);src.removeListener('end',cleanup);src.removeListener('data',ondata);cleanedUp=true;if(state.awaitDrain&&(!dest._writableState||dest._writableState.needDrain))ondrain();}
var increasedAwaitDrain=false;src.on('data',ondata);function ondata(chunk){debug('ondata');increasedAwaitDrain=false;var ret=dest.write(chunk);if(false===ret&&!increasedAwaitDrain){if((state.pipesCount===1&&state.pipes===dest||state.pipesCount>1&&indexOf(state.pipes,dest)!==-1)&&!cleanedUp){debug('false write response, pause',src._readableState.awaitDrain);src._readableState.awaitDrain++;increasedAwaitDrain=true;}
src.pause();}}
function onerror(er){debug('onerror',er);unpipe();dest.removeListener('error',onerror);if(EElistenerCount(dest,'error')===0)dest.emit('error',er);}
prependListener(dest,'error',onerror);function onclose(){dest.removeListener('finish',onfinish);unpipe();}
dest.once('close',onclose);function onfinish(){debug('onfinish');dest.removeListener('close',onclose);unpipe();}
dest.once('finish',onfinish);function unpipe(){debug('unpipe');src.unpipe(dest);}
dest.emit('pipe',src);if(!state.flowing){debug('pipe resume');src.resume();}
return dest;};function pipeOnDrain(src){return function(){var state=src._readableState;debug('pipeOnDrain',state.awaitDrain);if(state.awaitDrain)state.awaitDrain--;if(state.awaitDrain===0&&EElistenerCount(src,'data')){state.flowing=true;flow(src);}};}
Readable.prototype.unpipe=function(dest){var state=this._readableState;if(state.pipesCount===0)return this;if(state.pipesCount===1){if(dest&&dest!==state.pipes)return this;if(!dest)dest=state.pipes;state.pipes=null;state.pipesCount=0;state.flowing=false;if(dest)dest.emit('unpipe',this);return this;}
if(!dest){var dests=state.pipes;var len=state.pipesCount;state.pipes=null;state.pipesCount=0;state.flowing=false;for(var i=0;i<len;i++){dests[i].emit('unpipe',this);}return this;}
var index=indexOf(state.pipes,dest);if(index===-1)return this;state.pipes.splice(index,1);state.pipesCount-=1;if(state.pipesCount===1)state.pipes=state.pipes[0];dest.emit('unpipe',this);return this;};Readable.prototype.on=function(ev,fn){var res=Stream.prototype.on.call(this,ev,fn);if(ev==='data'){if(this._readableState.flowing!==false)this.resume();}else if(ev==='readable'){var state=this._readableState;if(!state.endEmitted&&!state.readableListening){state.readableListening=state.needReadable=true;state.emittedReadable=false;if(!state.reading){processNextTick(nReadingNextTick,this);}else if(state.length){emitReadable(this,state);}}}
return res;};Readable.prototype.addListener=Readable.prototype.on;function nReadingNextTick(self){debug('readable nexttick read 0');self.read(0);}
Readable.prototype.resume=function(){var state=this._readableState;if(!state.flowing){debug('resume');state.flowing=true;resume(this,state);}
return this;};function resume(stream,state){if(!state.resumeScheduled){state.resumeScheduled=true;processNextTick(resume_,stream,state);}}
function resume_(stream,state){if(!state.reading){debug('resume read 0');stream.read(0);}
state.resumeScheduled=false;state.awaitDrain=0;stream.emit('resume');flow(stream);if(state.flowing&&!state.reading)stream.read(0);}
Readable.prototype.pause=function(){debug('call pause flowing=%j',this._readableState.flowing);if(false!==this._readableState.flowing){debug('pause');this._readableState.flowing=false;this.emit('pause');}
return this;};function flow(stream){var state=stream._readableState;debug('flow',state.flowing);while(state.flowing&&stream.read()!==null){}}
Readable.prototype.wrap=function(stream){var state=this._readableState;var paused=false;var self=this;stream.on('end',function(){debug('wrapped end');if(state.decoder&&!state.ended){var chunk=state.decoder.end();if(chunk&&chunk.length)self.push(chunk);}
self.push(null);});stream.on('data',function(chunk){debug('wrapped data');if(state.decoder)chunk=state.decoder.write(chunk);if(state.objectMode&&(chunk===null||chunk===undefined))return;else if(!state.objectMode&&(!chunk||!chunk.length))return;var ret=self.push(chunk);if(!ret){paused=true;stream.pause();}});for(var i in stream){if(this[i]===undefined&&typeof stream[i]==='function'){this[i]=function(method){return function(){return stream[method].apply(stream,arguments);};}(i);}}
var events=['error','close','destroy','pause','resume'];forEach(events,function(ev){stream.on(ev,self.emit.bind(self,ev));});self._read=function(n){debug('wrapped _read',n);if(paused){paused=false;stream.resume();}};return self;};Readable._fromList=fromList;function fromList(n,state){if(state.length===0)return null;var ret;if(state.objectMode)ret=state.buffer.shift();else if(!n||n>=state.length){if(state.decoder)ret=state.buffer.join('');else if(state.buffer.length===1)ret=state.buffer.head.data;else ret=state.buffer.concat(state.length);state.buffer.clear();}else{ret=fromListPartial(n,state.buffer,state.decoder);}
return ret;}
function fromListPartial(n,list,hasStrings){var ret;if(n<list.head.data.length){ret=list.head.data.slice(0,n);list.head.data=list.head.data.slice(n);}else if(n===list.head.data.length){ret=list.shift();}else{ret=hasStrings?copyFromBufferString(n,list):copyFromBuffer(n,list);}
return ret;}
function copyFromBufferString(n,list){var p=list.head;var c=1;var ret=p.data;n-=ret.length;while(p=p.next){var str=p.data;var nb=n>str.length?str.length:n;if(nb===str.length)ret+=str;else ret+=str.slice(0,n);n-=nb;if(n===0){if(nb===str.length){++c;if(p.next)list.head=p.next;else list.head=list.tail=null;}else{list.head=p;p.data=str.slice(nb);}
break;}
++c;}
list.length-=c;return ret;}
function copyFromBuffer(n,list){var ret=bufferShim.allocUnsafe(n);var p=list.head;var c=1;p.data.copy(ret);n-=p.data.length;while(p=p.next){var buf=p.data;var nb=n>buf.length?buf.length:n;buf.copy(ret,ret.length-n,0,nb);n-=nb;if(n===0){if(nb===buf.length){++c;if(p.next)list.head=p.next;else list.head=list.tail=null;}else{list.head=p;p.data=buf.slice(nb);}
break;}
++c;}
list.length-=c;return ret;}
function endReadable(stream){var state=stream._readableState;if(state.length>0)throw new Error('"endReadable()" called on non-empty stream');if(!state.endEmitted){state.ended=true;processNextTick(endReadableNT,state,stream);}}
function endReadableNT(state,stream){if(!state.endEmitted&&state.length===0){state.endEmitted=true;stream.readable=false;stream.emit('end');}}
function forEach(xs,f){for(var i=0,l=xs.length;i<l;i++){f(xs[i],i);}}
function indexOf(xs,x){for(var i=0,l=xs.length;i<l;i++){if(xs[i]===x)return i;}
return-1;}}).call(this,require('_process'));},{"./_stream_duplex":82,"./internal/streams/BufferList":87,"_process":77,"buffer":60,"buffer-shims":59,"core-util-is":61,"events":62,"inherits":64,"isarray":66,"process-nextick-args":76,"string_decoder/":93,"util":55}],85:[function(require,module,exports){'use strict';module.exports=Transform;var Duplex=require('./_stream_duplex');var util=require('core-util-is');util.inherits=require('inherits');util.inherits(Transform,Duplex);function TransformState(stream){this.afterTransform=function(er,data){return afterTransform(stream,er,data);};this.needTransform=false;this.transforming=false;this.writecb=null;this.writechunk=null;this.writeencoding=null;}
function afterTransform(stream,er,data){var ts=stream._transformState;ts.transforming=false;var cb=ts.writecb;if(!cb)return stream.emit('error',new Error('no writecb in Transform class'));ts.writechunk=null;ts.writecb=null;if(data!==null&&data!==undefined)stream.push(data);cb(er);var rs=stream._readableState;rs.reading=false;if(rs.needReadable||rs.length<rs.highWaterMark){stream._read(rs.highWaterMark);}}
function Transform(options){if(!(this instanceof Transform))return new Transform(options);Duplex.call(this,options);this._transformState=new TransformState(this);var stream=this;this._readableState.needReadable=true;this._readableState.sync=false;if(options){if(typeof options.transform==='function')this._transform=options.transform;if(typeof options.flush==='function')this._flush=options.flush;}
this.once('prefinish',function(){if(typeof this._flush==='function')this._flush(function(er,data){done(stream,er,data);});else done(stream);});}
Transform.prototype.push=function(chunk,encoding){this._transformState.needTransform=false;return Duplex.prototype.push.call(this,chunk,encoding);};Transform.prototype._transform=function(chunk,encoding,cb){throw new Error('_transform() is not implemented');};Transform.prototype._write=function(chunk,encoding,cb){var ts=this._transformState;ts.writecb=cb;ts.writechunk=chunk;ts.writeencoding=encoding;if(!ts.transforming){var rs=this._readableState;if(ts.needTransform||rs.needReadable||rs.length<rs.highWaterMark)this._read(rs.highWaterMark);}};Transform.prototype._read=function(n){var ts=this._transformState;if(ts.writechunk!==null&&ts.writecb&&!ts.transforming){ts.transforming=true;this._transform(ts.writechunk,ts.writeencoding,ts.afterTransform);}else{ts.needTransform=true;}};function done(stream,er,data){if(er)return stream.emit('error',er);if(data!==null&&data!==undefined)stream.push(data);var ws=stream._writableState;var ts=stream._transformState;if(ws.length)throw new Error('Calling transform done when ws.length != 0');if(ts.transforming)throw new Error('Calling transform done when still transforming');return stream.push(null);}},{"./_stream_duplex":82,"core-util-is":61,"inherits":64}],86:[function(require,module,exports){(function(process){'use strict';module.exports=Writable;var processNextTick=require('process-nextick-args');var asyncWrite=!process.browser&&['v0.10','v0.9.'].indexOf(process.version.slice(0,5))>-1?setImmediate:processNextTick;var Duplex;Writable.WritableState=WritableState;var util=require('core-util-is');util.inherits=require('inherits');var internalUtil={deprecate:require('util-deprecate')};var Stream;(function(){try{Stream=require('st'+'ream');}catch(_){}finally{if(!Stream)Stream=require('events').EventEmitter;}})();var Buffer=require('buffer').Buffer;var bufferShim=require('buffer-shims');util.inherits(Writable,Stream);function nop(){}
function WriteReq(chunk,encoding,cb){this.chunk=chunk;this.encoding=encoding;this.callback=cb;this.next=null;}
function WritableState(options,stream){Duplex=Duplex||require('./_stream_duplex');options=options||{};this.objectMode=!!options.objectMode;if(stream instanceof Duplex)this.objectMode=this.objectMode||!!options.writableObjectMode;var hwm=options.highWaterMark;var defaultHwm=this.objectMode?16:16*1024;this.highWaterMark=hwm||hwm===0?hwm:defaultHwm;this.highWaterMark=~~this.highWaterMark;this.needDrain=false;this.ending=false;this.ended=false;this.finished=false;var noDecode=options.decodeStrings===false;this.decodeStrings=!noDecode;this.defaultEncoding=options.defaultEncoding||'utf8';this.length=0;this.writing=false;this.corked=0;this.sync=true;this.bufferProcessing=false;this.onwrite=function(er){onwrite(stream,er);};this.writecb=null;this.writelen=0;this.bufferedRequest=null;this.lastBufferedRequest=null;this.pendingcb=0;this.prefinished=false;this.errorEmitted=false;this.bufferedRequestCount=0;this.corkedRequestsFree=new CorkedRequest(this);}
WritableState.prototype.getBuffer=function getBuffer(){var current=this.bufferedRequest;var out=[];while(current){out.push(current);current=current.next;}
return out;};(function(){try{Object.defineProperty(WritableState.prototype,'buffer',{get:internalUtil.deprecate(function(){return this.getBuffer();},'_writableState.buffer is deprecated. Use _writableState.getBuffer '+'instead.')});}catch(_){}})();var realHasInstance;if(typeof Symbol==='function'&&Symbol.hasInstance&&typeof Function.prototype[Symbol.hasInstance]==='function'){realHasInstance=Function.prototype[Symbol.hasInstance];Object.defineProperty(Writable,Symbol.hasInstance,{value:function(object){if(realHasInstance.call(this,object))return true;return object&&object._writableState instanceof WritableState;}});}else{realHasInstance=function(object){return object instanceof this;};}
function Writable(options){Duplex=Duplex||require('./_stream_duplex');if(!realHasInstance.call(Writable,this)&&!(this instanceof Duplex)){return new Writable(options);}
this._writableState=new WritableState(options,this);this.writable=true;if(options){if(typeof options.write==='function')this._write=options.write;if(typeof options.writev==='function')this._writev=options.writev;}
Stream.call(this);}
Writable.prototype.pipe=function(){this.emit('error',new Error('Cannot pipe, not readable'));};function writeAfterEnd(stream,cb){var er=new Error('write after end');stream.emit('error',er);processNextTick(cb,er);}
function validChunk(stream,state,chunk,cb){var valid=true;var er=false;if(chunk===null){er=new TypeError('May not write null values to stream');}else if(!Buffer.isBuffer(chunk)&&typeof chunk!=='string'&&chunk!==undefined&&!state.objectMode){er=new TypeError('Invalid non-string/buffer chunk');}
if(er){stream.emit('error',er);processNextTick(cb,er);valid=false;}
return valid;}
Writable.prototype.write=function(chunk,encoding,cb){var state=this._writableState;var ret=false;if(typeof encoding==='function'){cb=encoding;encoding=null;}
if(Buffer.isBuffer(chunk))encoding='buffer';else if(!encoding)encoding=state.defaultEncoding;if(typeof cb!=='function')cb=nop;if(state.ended)writeAfterEnd(this,cb);else if(validChunk(this,state,chunk,cb)){state.pendingcb++;ret=writeOrBuffer(this,state,chunk,encoding,cb);}
return ret;};Writable.prototype.cork=function(){var state=this._writableState;state.corked++;};Writable.prototype.uncork=function(){var state=this._writableState;if(state.corked){state.corked--;if(!state.writing&&!state.corked&&!state.finished&&!state.bufferProcessing&&state.bufferedRequest)clearBuffer(this,state);}};Writable.prototype.setDefaultEncoding=function setDefaultEncoding(encoding){if(typeof encoding==='string')encoding=encoding.toLowerCase();if(!(['hex','utf8','utf-8','ascii','binary','base64','ucs2','ucs-2','utf16le','utf-16le','raw'].indexOf((encoding+'').toLowerCase())>-1))throw new TypeError('Unknown encoding: '+encoding);this._writableState.defaultEncoding=encoding;return this;};function decodeChunk(state,chunk,encoding){if(!state.objectMode&&state.decodeStrings!==false&&typeof chunk==='string'){chunk=bufferShim.from(chunk,encoding);}
return chunk;}
function writeOrBuffer(stream,state,chunk,encoding,cb){chunk=decodeChunk(state,chunk,encoding);if(Buffer.isBuffer(chunk))encoding='buffer';var len=state.objectMode?1:chunk.length;state.length+=len;var ret=state.length<state.highWaterMark;if(!ret)state.needDrain=true;if(state.writing||state.corked){var last=state.lastBufferedRequest;state.lastBufferedRequest=new WriteReq(chunk,encoding,cb);if(last){last.next=state.lastBufferedRequest;}else{state.bufferedRequest=state.lastBufferedRequest;}
state.bufferedRequestCount+=1;}else{doWrite(stream,state,false,len,chunk,encoding,cb);}
return ret;}
function doWrite(stream,state,writev,len,chunk,encoding,cb){state.writelen=len;state.writecb=cb;state.writing=true;state.sync=true;if(writev)stream._writev(chunk,state.onwrite);else stream._write(chunk,encoding,state.onwrite);state.sync=false;}
function onwriteError(stream,state,sync,er,cb){--state.pendingcb;if(sync)processNextTick(cb,er);else cb(er);stream._writableState.errorEmitted=true;stream.emit('error',er);}
function onwriteStateUpdate(state){state.writing=false;state.writecb=null;state.length-=state.writelen;state.writelen=0;}
function onwrite(stream,er){var state=stream._writableState;var sync=state.sync;var cb=state.writecb;onwriteStateUpdate(state);if(er)onwriteError(stream,state,sync,er,cb);else{var finished=needFinish(state);if(!finished&&!state.corked&&!state.bufferProcessing&&state.bufferedRequest){clearBuffer(stream,state);}
if(sync){asyncWrite(afterWrite,stream,state,finished,cb);}else{afterWrite(stream,state,finished,cb);}}}
function afterWrite(stream,state,finished,cb){if(!finished)onwriteDrain(stream,state);state.pendingcb--;cb();finishMaybe(stream,state);}
function onwriteDrain(stream,state){if(state.length===0&&state.needDrain){state.needDrain=false;stream.emit('drain');}}
function clearBuffer(stream,state){state.bufferProcessing=true;var entry=state.bufferedRequest;if(stream._writev&&entry&&entry.next){var l=state.bufferedRequestCount;var buffer=new Array(l);var holder=state.corkedRequestsFree;holder.entry=entry;var count=0;while(entry){buffer[count]=entry;entry=entry.next;count+=1;}
doWrite(stream,state,true,state.length,buffer,'',holder.finish);state.pendingcb++;state.lastBufferedRequest=null;if(holder.next){state.corkedRequestsFree=holder.next;holder.next=null;}else{state.corkedRequestsFree=new CorkedRequest(state);}}else{while(entry){var chunk=entry.chunk;var encoding=entry.encoding;var cb=entry.callback;var len=state.objectMode?1:chunk.length;doWrite(stream,state,false,len,chunk,encoding,cb);entry=entry.next;if(state.writing){break;}}
if(entry===null)state.lastBufferedRequest=null;}
state.bufferedRequestCount=0;state.bufferedRequest=entry;state.bufferProcessing=false;}
Writable.prototype._write=function(chunk,encoding,cb){cb(new Error('_write() is not implemented'));};Writable.prototype._writev=null;Writable.prototype.end=function(chunk,encoding,cb){var state=this._writableState;if(typeof chunk==='function'){cb=chunk;chunk=null;encoding=null;}else if(typeof encoding==='function'){cb=encoding;encoding=null;}
if(chunk!==null&&chunk!==undefined)this.write(chunk,encoding);if(state.corked){state.corked=1;this.uncork();}
if(!state.ending&&!state.finished)endWritable(this,state,cb);};function needFinish(state){return state.ending&&state.length===0&&state.bufferedRequest===null&&!state.finished&&!state.writing;}
function prefinish(stream,state){if(!state.prefinished){state.prefinished=true;stream.emit('prefinish');}}
function finishMaybe(stream,state){var need=needFinish(state);if(need){if(state.pendingcb===0){prefinish(stream,state);state.finished=true;stream.emit('finish');}else{prefinish(stream,state);}}
return need;}
function endWritable(stream,state,cb){state.ending=true;finishMaybe(stream,state);if(cb){if(state.finished)processNextTick(cb);else stream.once('finish',cb);}
state.ended=true;stream.writable=false;}
function CorkedRequest(state){var _this=this;this.next=null;this.entry=null;this.finish=function(err){var entry=_this.entry;_this.entry=null;while(entry){var cb=entry.callback;state.pendingcb--;cb(err);entry=entry.next;}
if(state.corkedRequestsFree){state.corkedRequestsFree.next=_this;}else{state.corkedRequestsFree=_this;}};}}).call(this,require('_process'));},{"./_stream_duplex":82,"_process":77,"buffer":60,"buffer-shims":59,"core-util-is":61,"events":62,"inherits":64,"process-nextick-args":76,"util-deprecate":94}],87:[function(require,module,exports){'use strict';var Buffer=require('buffer').Buffer;var bufferShim=require('buffer-shims');module.exports=BufferList;function BufferList(){this.head=null;this.tail=null;this.length=0;}
BufferList.prototype.push=function(v){var entry={data:v,next:null};if(this.length>0)this.tail.next=entry;else this.head=entry;this.tail=entry;++this.length;};BufferList.prototype.unshift=function(v){var entry={data:v,next:this.head};if(this.length===0)this.tail=entry;this.head=entry;++this.length;};BufferList.prototype.shift=function(){if(this.length===0)return;var ret=this.head.data;if(this.length===1)this.head=this.tail=null;else this.head=this.head.next;--this.length;return ret;};BufferList.prototype.clear=function(){this.head=this.tail=null;this.length=0;};BufferList.prototype.join=function(s){if(this.length===0)return'';var p=this.head;var ret=''+p.data;while(p=p.next){ret+=s+p.data;}return ret;};BufferList.prototype.concat=function(n){if(this.length===0)return bufferShim.alloc(0);if(this.length===1)return this.head.data;var ret=bufferShim.allocUnsafe(n>>>0);var p=this.head;var i=0;while(p){p.data.copy(ret,i);i+=p.data.length;p=p.next;}
return ret;};},{"buffer":60,"buffer-shims":59}],88:[function(require,module,exports){module.exports=require("./lib/_stream_passthrough.js");},{"./lib/_stream_passthrough.js":83}],89:[function(require,module,exports){(function(process){var Stream=function(){try{return require('st'+'ream');}catch(_){}}();exports=module.exports=require('./lib/_stream_readable.js');exports.Stream=Stream||exports;exports.Readable=exports;exports.Writable=require('./lib/_stream_writable.js');exports.Duplex=require('./lib/_stream_duplex.js');exports.Transform=require('./lib/_stream_transform.js');exports.PassThrough=require('./lib/_stream_passthrough.js');if(!process.browser&&process.env.READABLE_STREAM==='disable'&&Stream){module.exports=Stream;}}).call(this,require('_process'));},{"./lib/_stream_duplex.js":82,"./lib/_stream_passthrough.js":83,"./lib/_stream_readable.js":84,"./lib/_stream_transform.js":85,"./lib/_stream_writable.js":86,"_process":77}],90:[function(require,module,exports){module.exports=require("./lib/_stream_transform.js");},{"./lib/_stream_transform.js":85}],91:[function(require,module,exports){module.exports=require("./lib/_stream_writable.js");},{"./lib/_stream_writable.js":86}],92:[function(require,module,exports){module.exports=Stream;var EE=require('events').EventEmitter;var inherits=require('inherits');inherits(Stream,EE);Stream.Readable=require('readable-stream/readable.js');Stream.Writable=require('readable-stream/writable.js');Stream.Duplex=require('readable-stream/duplex.js');Stream.Transform=require('readable-stream/transform.js');Stream.PassThrough=require('readable-stream/passthrough.js');Stream.Stream=Stream;function Stream(){EE.call(this);}
Stream.prototype.pipe=function(dest,options){var source=this;function ondata(chunk){if(dest.writable){if(false===dest.write(chunk)&&source.pause){source.pause();}}}
source.on('data',ondata);function ondrain(){if(source.readable&&source.resume){source.resume();}}
dest.on('drain',ondrain);if(!dest._isStdio&&(!options||options.end!==false)){source.on('end',onend);source.on('close',onclose);}
var didOnEnd=false;function onend(){if(didOnEnd)return;didOnEnd=true;dest.end();}
function onclose(){if(didOnEnd)return;didOnEnd=true;if(typeof dest.destroy==='function')dest.destroy();}
function onerror(er){cleanup();if(EE.listenerCount(this,'error')===0){throw er;}}
source.on('error',onerror);dest.on('error',onerror);function cleanup(){source.removeListener('data',ondata);dest.removeListener('drain',ondrain);source.removeListener('end',onend);source.removeListener('close',onclose);source.removeListener('error',onerror);dest.removeListener('error',onerror);source.removeListener('end',cleanup);source.removeListener('close',cleanup);dest.removeListener('close',cleanup);}
source.on('end',cleanup);source.on('close',cleanup);dest.on('close',cleanup);dest.emit('pipe',source);return dest;};},{"events":62,"inherits":64,"readable-stream/duplex.js":81,"readable-stream/passthrough.js":88,"readable-stream/readable.js":89,"readable-stream/transform.js":90,"readable-stream/writable.js":91}],93:[function(require,module,exports){var Buffer=require('buffer').Buffer;var isBufferEncoding=Buffer.isEncoding||function(encoding){switch(encoding&&encoding.toLowerCase()){case'hex':case'utf8':case'utf-8':case'ascii':case'binary':case'base64':case'ucs2':case'ucs-2':case'utf16le':case'utf-16le':case'raw':return true;default:return false;}};function assertEncoding(encoding){if(encoding&&!isBufferEncoding(encoding)){throw new Error('Unknown encoding: '+encoding);}}
var StringDecoder=exports.StringDecoder=function(encoding){this.encoding=(encoding||'utf8').toLowerCase().replace(/[-_]/,'');assertEncoding(encoding);switch(this.encoding){case'utf8':this.surrogateSize=3;break;case'ucs2':case'utf16le':this.surrogateSize=2;this.detectIncompleteChar=utf16DetectIncompleteChar;break;case'base64':this.surrogateSize=3;this.detectIncompleteChar=base64DetectIncompleteChar;break;default:this.write=passThroughWrite;return;}
this.charBuffer=new Buffer(6);this.charReceived=0;this.charLength=0;};StringDecoder.prototype.write=function(buffer){var charStr='';while(this.charLength){var available=buffer.length>=this.charLength-this.charReceived?this.charLength-this.charReceived:buffer.length;buffer.copy(this.charBuffer,this.charReceived,0,available);this.charReceived+=available;if(this.charReceived<this.charLength){return'';}
buffer=buffer.slice(available,buffer.length);charStr=this.charBuffer.slice(0,this.charLength).toString(this.encoding);var charCode=charStr.charCodeAt(charStr.length-1);if(charCode>=0xD800&&charCode<=0xDBFF){this.charLength+=this.surrogateSize;charStr='';continue;}
this.charReceived=this.charLength=0;if(buffer.length===0){return charStr;}
break;}
this.detectIncompleteChar(buffer);var end=buffer.length;if(this.charLength){buffer.copy(this.charBuffer,0,buffer.length-this.charReceived,end);end-=this.charReceived;}
charStr+=buffer.toString(this.encoding,0,end);var end=charStr.length-1;var charCode=charStr.charCodeAt(end);if(charCode>=0xD800&&charCode<=0xDBFF){var size=this.surrogateSize;this.charLength+=size;this.charReceived+=size;this.charBuffer.copy(this.charBuffer,size,0,size);buffer.copy(this.charBuffer,0,0,size);return charStr.substring(0,end);}
return charStr;};StringDecoder.prototype.detectIncompleteChar=function(buffer){var i=buffer.length>=3?3:buffer.length;for(;i>0;i--){var c=buffer[buffer.length-i];if(i==1&&c>>5==0x06){this.charLength=2;break;}
if(i<=2&&c>>4==0x0E){this.charLength=3;break;}
if(i<=3&&c>>3==0x1E){this.charLength=4;break;}}
this.charReceived=i;};StringDecoder.prototype.end=function(buffer){var res='';if(buffer&&buffer.length)
res=this.write(buffer);if(this.charReceived){var cr=this.charReceived;var buf=this.charBuffer;var enc=this.encoding;res+=buf.slice(0,cr).toString(enc);}
return res;};function passThroughWrite(buffer){return buffer.toString(this.encoding);}
function utf16DetectIncompleteChar(buffer){this.charReceived=buffer.length%2;this.charLength=this.charReceived?2:0;}
function base64DetectIncompleteChar(buffer){this.charReceived=buffer.length%3;this.charLength=this.charReceived?3:0;}},{"buffer":60}],94:[function(require,module,exports){(function(global){module.exports=deprecate;function deprecate(fn,msg){if(config('noDeprecation')){return fn;}
var warned=false;function deprecated(){if(!warned){if(config('throwDeprecation')){throw new Error(msg);}else if(config('traceDeprecation')){console.trace(msg);}else{console.warn(msg);}
warned=true;}
return fn.apply(this,arguments);}
return deprecated;}
function config(name){try{if(!global.localStorage)return false;}catch(_){return false;}
var val=global.localStorage[name];if(null==val)return false;return String(val).toLowerCase()==='true';}}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{}],95:[function(require,module,exports){arguments[4][64][0].apply(exports,arguments);},{"dup":64}],96:[function(require,module,exports){module.exports=function isBuffer(arg){return arg&&typeof arg==='object'&&typeof arg.copy==='function'&&typeof arg.fill==='function'&&typeof arg.readUInt8==='function';};},{}],97:[function(require,module,exports){(function(process,global){var formatRegExp=/%[sdj%]/g;exports.format=function(f){if(!isString(f)){var objects=[];for(var i=0;i<arguments.length;i++){objects.push(inspect(arguments[i]));}
return objects.join(' ');}
var i=1;var args=arguments;var len=args.length;var str=String(f).replace(formatRegExp,function(x){if(x==='%%')return'%';if(i>=len)return x;switch(x){case'%s':return String(args[i++]);case'%d':return Number(args[i++]);case'%j':try{return JSON.stringify(args[i++]);}catch(_){return'[Circular]';}
default:return x;}});for(var x=args[i];i<len;x=args[++i]){if(isNull(x)||!isObject(x)){str+=' '+x;}else{str+=' '+inspect(x);}}
return str;};exports.deprecate=function(fn,msg){if(isUndefined(global.process)){return function(){return exports.deprecate(fn,msg).apply(this,arguments);};}
if(process.noDeprecation===true){return fn;}
var warned=false;function deprecated(){if(!warned){if(process.throwDeprecation){throw new Error(msg);}else if(process.traceDeprecation){console.trace(msg);}else{console.error(msg);}
warned=true;}
return fn.apply(this,arguments);}
return deprecated;};var debugs={};var debugEnviron;exports.debuglog=function(set){if(isUndefined(debugEnviron))
debugEnviron=process.env.NODE_DEBUG||'';set=set.toUpperCase();if(!debugs[set]){if(new RegExp('\\b'+set+'\\b','i').test(debugEnviron)){var pid=process.pid;debugs[set]=function(){var msg=exports.format.apply(exports,arguments);console.error('%s %d: %s',set,pid,msg);};}else{debugs[set]=function(){};}}
return debugs[set];};function inspect(obj,opts){var ctx={seen:[],stylize:stylizeNoColor};if(arguments.length>=3)ctx.depth=arguments[2];if(arguments.length>=4)ctx.colors=arguments[3];if(isBoolean(opts)){ctx.showHidden=opts;}else if(opts){exports._extend(ctx,opts);}
if(isUndefined(ctx.showHidden))ctx.showHidden=false;if(isUndefined(ctx.depth))ctx.depth=2;if(isUndefined(ctx.colors))ctx.colors=false;if(isUndefined(ctx.customInspect))ctx.customInspect=true;if(ctx.colors)ctx.stylize=stylizeWithColor;return formatValue(ctx,obj,ctx.depth);}
exports.inspect=inspect;inspect.colors={'bold':[1,22],'italic':[3,23],'underline':[4,24],'inverse':[7,27],'white':[37,39],'grey':[90,39],'black':[30,39],'blue':[34,39],'cyan':[36,39],'green':[32,39],'magenta':[35,39],'red':[31,39],'yellow':[33,39]};inspect.styles={'special':'cyan','number':'yellow','boolean':'yellow','undefined':'grey','null':'bold','string':'green','date':'magenta','regexp':'red'};function stylizeWithColor(str,styleType){var style=inspect.styles[styleType];if(style){return'\u001b['+inspect.colors[style][0]+'m'+str+'\u001b['+inspect.colors[style][1]+'m';}else{return str;}}
function stylizeNoColor(str,styleType){return str;}
function arrayToHash(array){var hash={};array.forEach(function(val,idx){hash[val]=true;});return hash;}
function formatValue(ctx,value,recurseTimes){if(ctx.customInspect&&value&&isFunction(value.inspect)&&value.inspect!==exports.inspect&&!(value.constructor&&value.constructor.prototype===value)){var ret=value.inspect(recurseTimes,ctx);if(!isString(ret)){ret=formatValue(ctx,ret,recurseTimes);}
return ret;}
var primitive=formatPrimitive(ctx,value);if(primitive){return primitive;}
var keys=Object.keys(value);var visibleKeys=arrayToHash(keys);if(ctx.showHidden){keys=Object.getOwnPropertyNames(value);}
if(isError(value)&&(keys.indexOf('message')>=0||keys.indexOf('description')>=0)){return formatError(value);}
if(keys.length===0){if(isFunction(value)){var name=value.name?': '+value.name:'';return ctx.stylize('[Function'+name+']','special');}
if(isRegExp(value)){return ctx.stylize(RegExp.prototype.toString.call(value),'regexp');}
if(isDate(value)){return ctx.stylize(Date.prototype.toString.call(value),'date');}
if(isError(value)){return formatError(value);}}
var base='',array=false,braces=['{','}'];if(isArray(value)){array=true;braces=['[',']'];}
if(isFunction(value)){var n=value.name?': '+value.name:'';base=' [Function'+n+']';}
if(isRegExp(value)){base=' '+RegExp.prototype.toString.call(value);}
if(isDate(value)){base=' '+Date.prototype.toUTCString.call(value);}
if(isError(value)){base=' '+formatError(value);}
if(keys.length===0&&(!array||value.length==0)){return braces[0]+base+braces[1];}
if(recurseTimes<0){if(isRegExp(value)){return ctx.stylize(RegExp.prototype.toString.call(value),'regexp');}else{return ctx.stylize('[Object]','special');}}
ctx.seen.push(value);var output;if(array){output=formatArray(ctx,value,recurseTimes,visibleKeys,keys);}else{output=keys.map(function(key){return formatProperty(ctx,value,recurseTimes,visibleKeys,key,array);});}
ctx.seen.pop();return reduceToSingleString(output,base,braces);}
function formatPrimitive(ctx,value){if(isUndefined(value))
return ctx.stylize('undefined','undefined');if(isString(value)){var simple='\''+JSON.stringify(value).replace(/^"|"$/g,'').replace(/'/g,"\\'").replace(/\\"/g,'"')+'\'';return ctx.stylize(simple,'string');}
if(isNumber(value))
return ctx.stylize(''+value,'number');if(isBoolean(value))
return ctx.stylize(''+value,'boolean');if(isNull(value))
return ctx.stylize('null','null');}
function formatError(value){return'['+Error.prototype.toString.call(value)+']';}
function formatArray(ctx,value,recurseTimes,visibleKeys,keys){var output=[];for(var i=0,l=value.length;i<l;++i){if(hasOwnProperty(value,String(i))){output.push(formatProperty(ctx,value,recurseTimes,visibleKeys,String(i),true));}else{output.push('');}}
keys.forEach(function(key){if(!key.match(/^\d+$/)){output.push(formatProperty(ctx,value,recurseTimes,visibleKeys,key,true));}});return output;}
function formatProperty(ctx,value,recurseTimes,visibleKeys,key,array){var name,str,desc;desc=Object.getOwnPropertyDescriptor(value,key)||{value:value[key]};if(desc.get){if(desc.set){str=ctx.stylize('[Getter/Setter]','special');}else{str=ctx.stylize('[Getter]','special');}}else{if(desc.set){str=ctx.stylize('[Setter]','special');}}
if(!hasOwnProperty(visibleKeys,key)){name='['+key+']';}
if(!str){if(ctx.seen.indexOf(desc.value)<0){if(isNull(recurseTimes)){str=formatValue(ctx,desc.value,null);}else{str=formatValue(ctx,desc.value,recurseTimes-1);}
if(str.indexOf('\n')>-1){if(array){str=str.split('\n').map(function(line){return'  '+line;}).join('\n').substr(2);}else{str='\n'+str.split('\n').map(function(line){return'   '+line;}).join('\n');}}}else{str=ctx.stylize('[Circular]','special');}}
if(isUndefined(name)){if(array&&key.match(/^\d+$/)){return str;}
name=JSON.stringify(''+key);if(name.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)){name=name.substr(1,name.length-2);name=ctx.stylize(name,'name');}else{name=name.replace(/'/g,"\\'").replace(/\\"/g,'"').replace(/(^"|"$)/g,"'");name=ctx.stylize(name,'string');}}
return name+': '+str;}
function reduceToSingleString(output,base,braces){var numLinesEst=0;var length=output.reduce(function(prev,cur){numLinesEst++;if(cur.indexOf('\n')>=0)numLinesEst++;return prev+cur.replace(/\u001b\[\d\d?m/g,'').length+1;},0);if(length>60){return braces[0]+(base===''?'':base+'\n ')+' '+
output.join(',\n  ')+' '+
braces[1];}
return braces[0]+base+' '+output.join(', ')+' '+braces[1];}
function isArray(ar){return Array.isArray(ar);}
exports.isArray=isArray;function isBoolean(arg){return typeof arg==='boolean';}
exports.isBoolean=isBoolean;function isNull(arg){return arg===null;}
exports.isNull=isNull;function isNullOrUndefined(arg){return arg==null;}
exports.isNullOrUndefined=isNullOrUndefined;function isNumber(arg){return typeof arg==='number';}
exports.isNumber=isNumber;function isString(arg){return typeof arg==='string';}
exports.isString=isString;function isSymbol(arg){return typeof arg==='symbol';}
exports.isSymbol=isSymbol;function isUndefined(arg){return arg===void 0;}
exports.isUndefined=isUndefined;function isRegExp(re){return isObject(re)&&objectToString(re)==='[object RegExp]';}
exports.isRegExp=isRegExp;function isObject(arg){return typeof arg==='object'&&arg!==null;}
exports.isObject=isObject;function isDate(d){return isObject(d)&&objectToString(d)==='[object Date]';}
exports.isDate=isDate;function isError(e){return isObject(e)&&(objectToString(e)==='[object Error]'||e instanceof Error);}
exports.isError=isError;function isFunction(arg){return typeof arg==='function';}
exports.isFunction=isFunction;function isPrimitive(arg){return arg===null||typeof arg==='boolean'||typeof arg==='number'||typeof arg==='string'||typeof arg==='symbol'||typeof arg==='undefined';}
exports.isPrimitive=isPrimitive;exports.isBuffer=require('./support/isBuffer');function objectToString(o){return Object.prototype.toString.call(o);}
function pad(n){return n<10?'0'+n.toString(10):n.toString(10);}
var months=['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];function timestamp(){var d=new Date();var time=[pad(d.getHours()),pad(d.getMinutes()),pad(d.getSeconds())].join(':');return[d.getDate(),months[d.getMonth()],time].join(' ');}
exports.log=function(){console.log('%s - %s',timestamp(),exports.format.apply(exports,arguments));};exports.inherits=require('inherits');exports._extend=function(origin,add){if(!add||!isObject(add))return origin;var keys=Object.keys(add);var i=keys.length;while(i--){origin[keys[i]]=add[keys[i]];}
return origin;};function hasOwnProperty(obj,prop){return Object.prototype.hasOwnProperty.call(obj,prop);}}).call(this,require('_process'),typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./support/isBuffer":96,"_process":77,"inherits":95}],98:[function(require,module,exports){var langs=["aa","ab","ae","af","ak","am","an","ar","as","av","ay","az","ba","be","bg","bh","bi","bm","bn","bo","br","bs","ca","ce","ch","co","cr","cs","cu","cv","cy","da","de","dv","dz","ee","el","en","eo","es","et","eu","fa","ff","fi","fj","fo","fr","fy","ga","gd","gl","gn","gu","gv","ha","he","hi","ho","hr","ht","hu","hy","hz","ia","id","ie","ig","ii","ik","in","io","is","it","iu","iw","ja","ji","jv","jw","ka","kg","ki","kj","kk","kl","km","kn","ko","kr","ks","ku","kv","kw","ky","la","lb","lg","li","ln","lo","lt","lu","lv","mg","mh","mi","mk","ml","mn","mo","mr","ms","mt","my","na","nb","nd","ne","ng","nl","nn","no","nr","nv","ny","oc","oj","om","or","os","pa","pi","pl","ps","pt","qu","rm","rn","ro","ru","rw","sa","sc","sd","se","sg","sh","si","sk","sl","sm","sn","so","sq","sr","ss","st","su","sv","sw","ta","te","tg","th","ti","tk","tl","tn","to","tr","ts","tt","tw","ty","ug","uk","ur","uz","ve","vi","vo","wa","wo","xh","yi","yo","za","zh","zu","aaa","aab","aac","aad","aae","aaf","aag","aah","aai","aak","aal","aam","aan","aao","aap","aaq","aas","aat","aau","aav","aaw","aax","aaz","aba","abb","abc","abd","abe","abf","abg","abh","abi","abj","abl","abm","abn","abo","abp","abq","abr","abs","abt","abu","abv","abw","abx","aby","abz","aca","acb","acd","ace","acf","ach","aci","ack","acl","acm","acn","acp","acq","acr","acs","act","acu","acv","acw","acx","acy","acz","ada","adb","add","ade","adf","adg","adh","adi","adj","adl","adn","ado","adp","adq","adr","ads","adt","adu","adw","adx","ady","adz","aea","aeb","aec","aed","aee","aek","ael","aem","aen","aeq","aer","aes","aeu","aew","aey","aez","afa","afb","afd","afe","afg","afh","afi","afk","afn","afo","afp","afs","aft","afu","afz","aga","agb","agc","agd","age","agf","agg","agh","agi","agj","agk","agl","agm","agn","ago","agp","agq","agr","ags","agt","agu","agv","agw","agx","agy","agz","aha","ahb","ahg","ahh","ahi","ahk","ahl","ahm","ahn","aho","ahp","ahr","ahs","aht","aia","aib","aic","aid","aie","aif","aig","aih","aii","aij","aik","ail","aim","ain","aio","aip","aiq","air","ais","ait","aiw","aix","aiy","aja","ajg","aji","ajn","ajp","ajt","aju","ajw","ajz","akb","akc","akd","ake","akf","akg","akh","aki","akj","akk","akl","akm","ako","akp","akq","akr","aks","akt","aku","akv","akw","akx","aky","akz","ala","alc","ald","ale","alf","alg","alh","ali","alj","alk","all","alm","aln","alo","alp","alq","alr","als","alt","alu","alv","alw","alx","aly","alz","ama","amb","amc","ame","amf","amg","ami","amj","amk","aml","amm","amn","amo","amp","amq","amr","ams","amt","amu","amv","amw","amx","amy","amz","ana","anb","anc","and","ane","anf","ang","anh","ani","anj","ank","anl","anm","ann","ano","anp","anq","anr","ans","ant","anu","anv","anw","anx","any","anz","aoa","aob","aoc","aod","aoe","aof","aog","aoh","aoi","aoj","aok","aol","aom","aon","aor","aos","aot","aou","aox","aoz","apa","apb","apc","apd","ape","apf","apg","aph","api","apj","apk","apl","apm","apn","apo","app","apq","apr","aps","apt","apu","apv","apw","apx","apy","apz","aqa","aqc","aqd","aqg","aql","aqm","aqn","aqp","aqr","aqt","aqz","arb","arc","ard","are","arh","ari","arj","ark","arl","arn","aro","arp","arq","arr","ars","art","aru","arv","arw","arx","ary","arz","asa","asb","asc","asd","ase","asf","asg","ash","asi","asj","ask","asl","asn","aso","asp","asq","asr","ass","ast","asu","asv","asw","asx","asy","asz","ata","atb","atc","atd","ate","atg","ath","ati","atj","atk","atl","atm","atn","ato","atp","atq","atr","ats","att","atu","atv","atw","atx","aty","atz","aua","aub","auc","aud","aue","auf","aug","auh","aui","auj","auk","aul","aum","aun","auo","aup","auq","aur","aus","aut","auu","auw","aux","auy","auz","avb","avd","avi","avk","avl","avm","avn","avo","avs","avt","avu","avv","awa","awb","awc","awd","awe","awg","awh","awi","awk","awm","awn","awo","awr","aws","awt","awu","awv","aww","awx","awy","axb","axe","axg","axk","axl","axm","axx","aya","ayb","ayc","ayd","aye","ayg","ayh","ayi","ayk","ayl","ayn","ayo","ayp","ayq","ayr","ays","ayt","ayu","ayx","ayy","ayz","aza","azb","azc","azd","azg","azj","azm","azn","azo","azt","azz","baa","bab","bac","bad","bae","baf","bag","bah","bai","baj","bal","ban","bao","bap","bar","bas","bat","bau","bav","baw","bax","bay","baz","bba","bbb","bbc","bbd","bbe","bbf","bbg","bbh","bbi","bbj","bbk","bbl","bbm","bbn","bbo","bbp","bbq","bbr","bbs","bbt","bbu","bbv","bbw","bbx","bby","bbz","bca","bcb","bcc","bcd","bce","bcf","bcg","bch","bci","bcj","bck","bcl","bcm","bcn","bco","bcp","bcq","bcr","bcs","bct","bcu","bcv","bcw","bcy","bcz","bda","bdb","bdc","bdd","bde","bdf","bdg","bdh","bdi","bdj","bdk","bdl","bdm","bdn","bdo","bdp","bdq","bdr","bds","bdt","bdu","bdv","bdw","bdx","bdy","bdz","bea","beb","bec","bed","bee","bef","beg","beh","bei","bej","bek","bem","beo","bep","beq","ber","bes","bet","beu","bev","bew","bex","bey","bez","bfa","bfb","bfc","bfd","bfe","bff","bfg","bfh","bfi","bfj","bfk","bfl","bfm","bfn","bfo","bfp","bfq","bfr","bfs","bft","bfu","bfw","bfx","bfy","bfz","bga","bgb","bgc","bgd","bge","bgf","bgg","bgi","bgj","bgk","bgl","bgm","bgn","bgo","bgp","bgq","bgr","bgs","bgt","bgu","bgv","bgw","bgx","bgy","bgz","bha","bhb","bhc","bhd","bhe","bhf","bhg","bhh","bhi","bhj","bhk","bhl","bhm","bhn","bho","bhp","bhq","bhr","bhs","bht","bhu","bhv","bhw","bhx","bhy","bhz","bia","bib","bic","bid","bie","bif","big","bij","bik","bil","bim","bin","bio","bip","biq","bir","bit","biu","biv","biw","bix","biy","biz","bja","bjb","bjc","bjd","bje","bjf","bjg","bjh","bji","bjj","bjk","bjl","bjm","bjn","bjo","bjp","bjq","bjr","bjs","bjt","bju","bjv","bjw","bjx","bjy","bjz","bka","bkb","bkc","bkd","bkf","bkg","bkh","bki","bkj","bkk","bkl","bkm","bkn","bko","bkp","bkq","bkr","bks","bkt","bku","bkv","bkw","bkx","bky","bkz","bla","blb","blc","bld","ble","blf","blg","blh","bli","blj","blk","bll","blm","bln","blo","blp","blq","blr","bls","blt","blv","blw","blx","bly","blz","bma","bmb","bmc","bmd","bme","bmf","bmg","bmh","bmi","bmj","bmk","bml","bmm","bmn","bmo","bmp","bmq","bmr","bms","bmt","bmu","bmv","bmw","bmx","bmy","bmz","bna","bnb","bnc","bnd","bne","bnf","bng","bni","bnj","bnk","bnl","bnm","bnn","bno","bnp","bnq","bnr","bns","bnt","bnu","bnv","bnw","bnx","bny","bnz","boa","bob","boe","bof","bog","boh","boi","boj","bok","bol","bom","bon","boo","bop","boq","bor","bot","bou","bov","bow","box","boy","boz","bpa","bpb","bpd","bpg","bph","bpi","bpj","bpk","bpl","bpm","bpn","bpo","bpp","bpq","bpr","bps","bpt","bpu","bpv","bpw","bpx","bpy","bpz","bqa","bqb","bqc","bqd","bqf","bqg","bqh","bqi","bqj","bqk","bql","bqm","bqn","bqo","bqp","bqq","bqr","bqs","bqt","bqu","bqv","bqw","bqx","bqy","bqz","bra","brb","brc","brd","brf","brg","brh","bri","brj","brk","brl","brm","brn","bro","brp","brq","brr","brs","brt","bru","brv","brw","brx","bry","brz","bsa","bsb","bsc","bse","bsf","bsg","bsh","bsi","bsj","bsk","bsl","bsm","bsn","bso","bsp","bsq","bsr","bss","bst","bsu","bsv","bsw","bsx","bsy","bta","btb","btc","btd","bte","btf","btg","bth","bti","btj","btk","btl","btm","btn","bto","btp","btq","btr","bts","btt","btu","btv","btw","btx","bty","btz","bua","bub","buc","bud","bue","buf","bug","buh","bui","buj","buk","bum","bun","buo","bup","buq","bus","but","buu","buv","buw","bux","buy","buz","bva","bvb","bvc","bvd","bve","bvf","bvg","bvh","bvi","bvj","bvk","bvl","bvm","bvn","bvo","bvp","bvq","bvr","bvt","bvu","bvv","bvw","bvx","bvy","bvz","bwa","bwb","bwc","bwd","bwe","bwf","bwg","bwh","bwi","bwj","bwk","bwl","bwm","bwn","bwo","bwp","bwq","bwr","bws","bwt","bwu","bww","bwx","bwy","bwz","bxa","bxb","bxc","bxd","bxe","bxf","bxg","bxh","bxi","bxj","bxk","bxl","bxm","bxn","bxo","bxp","bxq","bxr","bxs","bxu","bxv","bxw","bxx","bxz","bya","byb","byc","byd","bye","byf","byg","byh","byi","byj","byk","byl","bym","byn","byo","byp","byq","byr","bys","byt","byv","byw","byx","byy","byz","bza","bzb","bzc","bzd","bze","bzf","bzg","bzh","bzi","bzj","bzk","bzl","bzm","bzn","bzo","bzp","bzq","bzr","bzs","bzt","bzu","bzv","bzw","bzx","bzy","bzz","caa","cab","cac","cad","cae","caf","cag","cah","cai","caj","cak","cal","cam","can","cao","cap","caq","car","cas","cau","cav","caw","cax","cay","caz","cba","cbb","cbc","cbd","cbe","cbg","cbh","cbi","cbj","cbk","cbl","cbn","cbo","cbq","cbr","cbs","cbt","cbu","cbv","cbw","cby","cca","ccc","ccd","cce","ccg","cch","ccj","ccl","ccm","ccn","cco","ccp","ccq","ccr","ccs","cda","cdc","cdd","cde","cdf","cdg","cdh","cdi","cdj","cdm","cdn","cdo","cdr","cds","cdy","cdz","cea","ceb","ceg","cek","cel","cen","cet","cfa","cfd","cfg","cfm","cga","cgc","cgg","cgk","chb","chc","chd","chf","chg","chh","chj","chk","chl","chm","chn","cho","chp","chq","chr","cht","chw","chx","chy","chz","cia","cib","cic","cid","cie","cih","cik","cim","cin","cip","cir","ciw","ciy","cja","cje","cjh","cji","cjk","cjm","cjn","cjo","cjp","cjr","cjs","cjv","cjy","cka","ckb","ckh","ckl","ckn","cko","ckq","ckr","cks","ckt","cku","ckv","ckx","cky","ckz","cla","clc","cld","cle","clh","cli","clj","clk","cll","clm","clo","clt","clu","clw","cly","cma","cmc","cme","cmg","cmi","cmk","cml","cmm","cmn","cmo","cmr","cms","cmt","cna","cnb","cnc","cng","cnh","cni","cnk","cnl","cno","cns","cnt","cnu","cnw","cnx","coa","cob","coc","cod","coe","cof","cog","coh","coj","cok","col","com","con","coo","cop","coq","cot","cou","cov","cow","cox","coy","coz","cpa","cpb","cpc","cpe","cpf","cpg","cpi","cpn","cpo","cpp","cps","cpu","cpx","cpy","cqd","cqu","cra","crb","crc","crd","crf","crg","crh","cri","crj","crk","crl","crm","crn","cro","crp","crq","crr","crs","crt","crv","crw","crx","cry","crz","csa","csb","csc","csd","cse","csf","csg","csh","csi","csj","csk","csl","csm","csn","cso","csq","csr","css","cst","csu","csv","csw","csy","csz","cta","ctc","ctd","cte","ctg","cth","ctl","ctm","ctn","cto","ctp","cts","ctt","ctu","ctz","cua","cub","cuc","cug","cuh","cui","cuj","cuk","cul","cum","cuo","cup","cuq","cur","cus","cut","cuu","cuv","cuw","cux","cvg","cvn","cwa","cwb","cwd","cwe","cwg","cwt","cya","cyb","cyo","czh","czk","czn","czo","czt","daa","dac","dad","dae","daf","dag","dah","dai","daj","dak","dal","dam","dao","dap","daq","dar","das","dau","dav","daw","dax","day","daz","dba","dbb","dbd","dbe","dbf","dbg","dbi","dbj","dbl","dbm","dbn","dbo","dbp","dbq","dbr","dbt","dbu","dbv","dbw","dby","dcc","dcr","dda","ddd","dde","ddg","ddi","ddj","ddn","ddo","ddr","dds","ddw","dec","ded","dee","def","deg","deh","dei","dek","del","dem","den","dep","deq","der","des","dev","dez","dga","dgb","dgc","dgd","dge","dgg","dgh","dgi","dgk","dgl","dgn","dgo","dgr","dgs","dgt","dgu","dgw","dgx","dgz","dha","dhd","dhg","dhi","dhl","dhm","dhn","dho","dhr","dhs","dhu","dhv","dhw","dhx","dia","dib","dic","did","dif","dig","dih","dii","dij","dik","dil","dim","din","dio","dip","diq","dir","dis","dit","diu","diw","dix","diy","diz","dja","djb","djc","djd","dje","djf","dji","djj","djk","djl","djm","djn","djo","djr","dju","djw","dka","dkk","dkl","dkr","dks","dkx","dlg","dlk","dlm","dln","dma","dmb","dmc","dmd","dme","dmg","dmk","dml","dmm","dmn","dmo","dmr","dms","dmu","dmv","dmw","dmx","dmy","dna","dnd","dne","dng","dni","dnj","dnk","dnn","dnr","dnt","dnu","dnv","dnw","dny","doa","dob","doc","doe","dof","doh","doi","dok","dol","don","doo","dop","doq","dor","dos","dot","dov","dow","dox","doy","doz","dpp","dra","drb","drc","drd","dre","drg","drh","dri","drl","drn","dro","drq","drr","drs","drt","dru","drw","dry","dsb","dse","dsh","dsi","dsl","dsn","dso","dsq","dta","dtb","dtd","dth","dti","dtk","dtm","dtn","dto","dtp","dtr","dts","dtt","dtu","dty","dua","dub","duc","dud","due","duf","dug","duh","dui","duj","duk","dul","dum","dun","duo","dup","duq","dur","dus","duu","duv","duw","dux","duy","duz","dva","dwa","dwl","dwr","dws","dwu","dww","dwy","dya","dyb","dyd","dyg","dyi","dym","dyn","dyo","dyu","dyy","dza","dzd","dze","dzg","dzl","dzn","eaa","ebg","ebk","ebo","ebr","ebu","ecr","ecs","ecy","eee","efa","efe","efi","ega","egl","ego","egx","egy","ehu","eip","eit","eiv","eja","eka","ekc","eke","ekg","eki","ekk","ekl","ekm","eko","ekp","ekr","eky","ele","elh","eli","elk","elm","elo","elp","elu","elx","ema","emb","eme","emg","emi","emk","emm","emn","emo","emp","ems","emu","emw","emx","emy","ena","enb","enc","end","enf","enh","enl","enm","enn","eno","enq","enr","enu","env","enw","enx","eot","epi","era","erg","erh","eri","erk","ero","err","ers","ert","erw","ese","esg","esh","esi","esk","esl","esm","esn","eso","esq","ess","esu","esx","esy","etb","etc","eth","etn","eto","etr","ets","ett","etu","etx","etz","euq","eve","evh","evn","ewo","ext","eya","eyo","eza","eze","faa","fab","fad","faf","fag","fah","fai","faj","fak","fal","fam","fan","fap","far","fat","fau","fax","fay","faz","fbl","fcs","fer","ffi","ffm","fgr","fia","fie","fil","fip","fir","fit","fiu","fiw","fkk","fkv","fla","flh","fli","fll","fln","flr","fly","fmp","fmu","fnb","fng","fni","fod","foi","fom","fon","for","fos","fox","fpe","fqs","frc","frd","frk","frm","fro","frp","frq","frr","frs","frt","fse","fsl","fss","fub","fuc","fud","fue","fuf","fuh","fui","fuj","fum","fun","fuq","fur","fut","fuu","fuv","fuy","fvr","fwa","fwe","gaa","gab","gac","gad","gae","gaf","gag","gah","gai","gaj","gak","gal","gam","gan","gao","gap","gaq","gar","gas","gat","gau","gav","gaw","gax","gay","gaz","gba","gbb","gbc","gbd","gbe","gbf","gbg","gbh","gbi","gbj","gbk","gbl","gbm","gbn","gbo","gbp","gbq","gbr","gbs","gbu","gbv","gbw","gbx","gby","gbz","gcc","gcd","gce","gcf","gcl","gcn","gcr","gct","gda","gdb","gdc","gdd","gde","gdf","gdg","gdh","gdi","gdj","gdk","gdl","gdm","gdn","gdo","gdq","gdr","gds","gdt","gdu","gdx","gea","geb","gec","ged","geg","geh","gei","gej","gek","gel","gem","geq","ges","gev","gew","gex","gey","gez","gfk","gft","gfx","gga","ggb","ggd","gge","ggg","ggk","ggl","ggn","ggo","ggr","ggt","ggu","ggw","gha","ghc","ghe","ghh","ghk","ghl","ghn","gho","ghr","ghs","ght","gia","gib","gic","gid","gie","gig","gih","gil","gim","gin","gio","gip","giq","gir","gis","git","giu","giw","gix","giy","giz","gji","gjk","gjm","gjn","gjr","gju","gka","gke","gkn","gko","gkp","gku","glc","gld","glh","gli","glj","glk","gll","glo","glr","glu","glw","gly","gma","gmb","gmd","gme","gmg","gmh","gml","gmm","gmn","gmq","gmu","gmv","gmw","gmx","gmy","gmz","gna","gnb","gnc","gnd","gne","gng","gnh","gni","gnk","gnl","gnm","gnn","gno","gnq","gnr","gnt","gnu","gnw","gnz","goa","gob","goc","god","goe","gof","gog","goh","goi","goj","gok","gol","gom","gon","goo","gop","goq","gor","gos","got","gou","gow","gox","goy","goz","gpa","gpe","gpn","gqa","gqi","gqn","gqr","gqu","gra","grb","grc","grd","grg","grh","gri","grj","grk","grm","gro","grq","grr","grs","grt","gru","grv","grw","grx","gry","grz","gse","gsg","gsl","gsm","gsn","gso","gsp","gss","gsw","gta","gti","gtu","gua","gub","guc","gud","gue","guf","gug","guh","gui","guk","gul","gum","gun","guo","gup","guq","gur","gus","gut","guu","guv","guw","gux","guz","gva","gvc","gve","gvf","gvj","gvl","gvm","gvn","gvo","gvp","gvr","gvs","gvy","gwa","gwb","gwc","gwd","gwe","gwf","gwg","gwi","gwj","gwm","gwn","gwr","gwt","gwu","gww","gwx","gxx","gya","gyb","gyd","gye","gyf","gyg","gyi","gyl","gym","gyn","gyr","gyy","gza","gzi","gzn","haa","hab","hac","had","hae","haf","hag","hah","hai","haj","hak","hal","ham","han","hao","hap","haq","har","has","hav","haw","hax","hay","haz","hba","hbb","hbn","hbo","hbu","hca","hch","hdn","hds","hdy","hea","hed","heg","heh","hei","hem","hgm","hgw","hhi","hhr","hhy","hia","hib","hid","hif","hig","hih","hii","hij","hik","hil","him","hio","hir","hit","hiw","hix","hji","hka","hke","hkk","hks","hla","hlb","hld","hle","hlt","hlu","hma","hmb","hmc","hmd","hme","hmf","hmg","hmh","hmi","hmj","hmk","hml","hmm","hmn","hmp","hmq","hmr","hms","hmt","hmu","hmv","hmw","hmx","hmy","hmz","hna","hnd","hne","hnh","hni","hnj","hnn","hno","hns","hnu","hoa","hob","hoc","hod","hoe","hoh","hoi","hoj","hok","hol","hom","hoo","hop","hor","hos","hot","hov","how","hoy","hoz","hpo","hps","hra","hrc","hre","hrk","hrm","hro","hrp","hrr","hrt","hru","hrw","hrx","hrz","hsb","hsh","hsl","hsn","hss","hti","hto","hts","htu","htx","hub","huc","hud","hue","huf","hug","huh","hui","huj","huk","hul","hum","huo","hup","huq","hur","hus","hut","huu","huv","huw","hux","huy","huz","hvc","hve","hvk","hvn","hvv","hwa","hwc","hwo","hya","hyx","iai","ian","iap","iar","iba","ibb","ibd","ibe","ibg","ibh","ibi","ibl","ibm","ibn","ibr","ibu","iby","ica","ich","icl","icr","ida","idb","idc","idd","ide","idi","idr","ids","idt","idu","ifa","ifb","ife","iff","ifk","ifm","ifu","ify","igb","ige","igg","igl","igm","ign","igo","igs","igw","ihb","ihi","ihp","ihw","iin","iir","ijc","ije","ijj","ijn","ijo","ijs","ike","iki","ikk","ikl","iko","ikp","ikr","iks","ikt","ikv","ikw","ikx","ikz","ila","ilb","ilg","ili","ilk","ill","ilm","ilo","ilp","ils","ilu","ilv","ilw","ima","ime","imi","iml","imn","imo","imr","ims","imy","inb","inc","ine","ing","inh","inj","inl","inm","inn","ino","inp","ins","int","inz","ior","iou","iow","ipi","ipo","iqu","iqw","ira","ire","irh","iri","irk","irn","iro","irr","iru","irx","iry","isa","isc","isd","ise","isg","ish","isi","isk","ism","isn","iso","isr","ist","isu","itb","itc","itd","ite","iti","itk","itl","itm","ito","itr","its","itt","itv","itw","itx","ity","itz","ium","ivb","ivv","iwk","iwm","iwo","iws","ixc","ixl","iya","iyo","iyx","izh","izi","izr","izz","jaa","jab","jac","jad","jae","jaf","jah","jaj","jak","jal","jam","jan","jao","jaq","jar","jas","jat","jau","jax","jay","jaz","jbe","jbi","jbj","jbk","jbn","jbo","jbr","jbt","jbu","jbw","jcs","jct","jda","jdg","jdt","jeb","jee","jeg","jeh","jei","jek","jel","jen","jer","jet","jeu","jgb","jge","jgk","jgo","jhi","jhs","jia","jib","jic","jid","jie","jig","jih","jii","jil","jim","jio","jiq","jit","jiu","jiv","jiy","jje","jjr","jka","jkm","jko","jkp","jkr","jku","jle","jls","jma","jmb","jmc","jmd","jmi","jml","jmn","jmr","jms","jmw","jmx","jna","jnd","jng","jni","jnj","jnl","jns","job","jod","jog","jor","jos","jow","jpa","jpr","jpx","jqr","jra","jrb","jrr","jrt","jru","jsl","jua","jub","juc","jud","juh","jui","juk","jul","jum","jun","juo","jup","jur","jus","jut","juu","juw","juy","jvd","jvn","jwi","jya","jye","jyy","kaa","kab","kac","kad","kae","kaf","kag","kah","kai","kaj","kak","kam","kao","kap","kaq","kar","kav","kaw","kax","kay","kba","kbb","kbc","kbd","kbe","kbf","kbg","kbh","kbi","kbj","kbk","kbl","kbm","kbn","kbo","kbp","kbq","kbr","kbs","kbt","kbu","kbv","kbw","kbx","kby","kbz","kca","kcb","kcc","kcd","kce","kcf","kcg","kch","kci","kcj","kck","kcl","kcm","kcn","kco","kcp","kcq","kcr","kcs","kct","kcu","kcv","kcw","kcx","kcy","kcz","kda","kdc","kdd","kde","kdf","kdg","kdh","kdi","kdj","kdk","kdl","kdm","kdn","kdo","kdp","kdq","kdr","kdt","kdu","kdv","kdw","kdx","kdy","kdz","kea","keb","kec","ked","kee","kef","keg","keh","kei","kej","kek","kel","kem","ken","keo","kep","keq","ker","kes","ket","keu","kev","kew","kex","key","kez","kfa","kfb","kfc","kfd","kfe","kff","kfg","kfh","kfi","kfj","kfk","kfl","kfm","kfn","kfo","kfp","kfq","kfr","kfs","kft","kfu","kfv","kfw","kfx","kfy","kfz","kga","kgb","kgc","kgd","kge","kgf","kgg","kgh","kgi","kgj","kgk","kgl","kgm","kgn","kgo","kgp","kgq","kgr","kgs","kgt","kgu","kgv","kgw","kgx","kgy","kha","khb","khc","khd","khe","khf","khg","khh","khi","khj","khk","khl","khn","kho","khp","khq","khr","khs","kht","khu","khv","khw","khx","khy","khz","kia","kib","kic","kid","kie","kif","kig","kih","kii","kij","kil","kim","kio","kip","kiq","kis","kit","kiu","kiv","kiw","kix","kiy","kiz","kja","kjb","kjc","kjd","kje","kjf","kjg","kjh","kji","kjj","kjk","kjl","kjm","kjn","kjo","kjp","kjq","kjr","kjs","kjt","kju","kjv","kjx","kjy","kjz","kka","kkb","kkc","kkd","kke","kkf","kkg","kkh","kki","kkj","kkk","kkl","kkm","kkn","kko","kkp","kkq","kkr","kks","kkt","kku","kkv","kkw","kkx","kky","kkz","kla","klb","klc","kld","kle","klf","klg","klh","kli","klj","klk","kll","klm","kln","klo","klp","klq","klr","kls","klt","klu","klv","klw","klx","kly","klz","kma","kmb","kmc","kmd","kme","kmf","kmg","kmh","kmi","kmj","kmk","kml","kmm","kmn","kmo","kmp","kmq","kmr","kms","kmt","kmu","kmv","kmw","kmx","kmy","kmz","kna","knb","knc","knd","kne","knf","kng","kni","knj","knk","knl","knm","knn","kno","knp","knq","knr","kns","knt","knu","knv","knw","knx","kny","knz","koa","koc","kod","koe","kof","kog","koh","koi","koj","kok","kol","koo","kop","koq","kos","kot","kou","kov","kow","kox","koy","koz","kpa","kpb","kpc","kpd","kpe","kpf","kpg","kph","kpi","kpj","kpk","kpl","kpm","kpn","kpo","kpp","kpq","kpr","kps","kpt","kpu","kpv","kpw","kpx","kpy","kpz","kqa","kqb","kqc","kqd","kqe","kqf","kqg","kqh","kqi","kqj","kqk","kql","kqm","kqn","kqo","kqp","kqq","kqr","kqs","kqt","kqu","kqv","kqw","kqx","kqy","kqz","kra","krb","krc","krd","kre","krf","krh","kri","krj","krk","krl","krm","krn","kro","krp","krr","krs","krt","kru","krv","krw","krx","kry","krz","ksa","ksb","ksc","ksd","kse","ksf","ksg","ksh","ksi","ksj","ksk","ksl","ksm","ksn","kso","ksp","ksq","ksr","kss","kst","ksu","ksv","ksw","ksx","ksy","ksz","kta","ktb","ktc","ktd","kte","ktf","ktg","kth","kti","ktj","ktk","ktl","ktm","ktn","kto","ktp","ktq","ktr","kts","ktt","ktu","ktv","ktw","ktx","kty","ktz","kub","kuc","kud","kue","kuf","kug","kuh","kui","kuj","kuk","kul","kum","kun","kuo","kup","kuq","kus","kut","kuu","kuv","kuw","kux","kuy","kuz","kva","kvb","kvc","kvd","kve","kvf","kvg","kvh","kvi","kvj","kvk","kvl","kvm","kvn","kvo","kvp","kvq","kvr","kvs","kvt","kvu","kvv","kvw","kvx","kvy","kvz","kwa","kwb","kwc","kwd","kwe","kwf","kwg","kwh","kwi","kwj","kwk","kwl","kwm","kwn","kwo","kwp","kwq","kwr","kws","kwt","kwu","kwv","kww","kwx","kwy","kwz","kxa","kxb","kxc","kxd","kxe","kxf","kxh","kxi","kxj","kxk","kxl","kxm","kxn","kxo","kxp","kxq","kxr","kxs","kxt","kxu","kxv","kxw","kxx","kxy","kxz","kya","kyb","kyc","kyd","kye","kyf","kyg","kyh","kyi","kyj","kyk","kyl","kym","kyn","kyo","kyp","kyq","kyr","kys","kyt","kyu","kyv","kyw","kyx","kyy","kyz","kza","kzb","kzc","kzd","kze","kzf","kzg","kzh","kzi","kzj","kzk","kzl","kzm","kzn","kzo","kzp","kzq","kzr","kzs","kzt","kzu","kzv","kzw","kzx","kzy","kzz","laa","lab","lac","lad","lae","laf","lag","lah","lai","laj","lak","lal","lam","lan","lap","laq","lar","las","lau","law","lax","lay","laz","lba","lbb","lbc","lbe","lbf","lbg","lbi","lbj","lbk","lbl","lbm","lbn","lbo","lbq","lbr","lbs","lbt","lbu","lbv","lbw","lbx","lby","lbz","lcc","lcd","lce","lcf","lch","lcl","lcm","lcp","lcq","lcs","lda","ldb","ldd","ldg","ldh","ldi","ldj","ldk","ldl","ldm","ldn","ldo","ldp","ldq","lea","leb","lec","led","lee","lef","leg","leh","lei","lej","lek","lel","lem","len","leo","lep","leq","ler","les","let","leu","lev","lew","lex","ley","lez","lfa","lfn","lga","lgb","lgg","lgh","lgi","lgk","lgl","lgm","lgn","lgq","lgr","lgt","lgu","lgz","lha","lhh","lhi","lhl","lhm","lhn","lhp","lhs","lht","lhu","lia","lib","lic","lid","lie","lif","lig","lih","lii","lij","lik","lil","lio","lip","liq","lir","lis","liu","liv","liw","lix","liy","liz","lja","lje","lji","ljl","ljp","ljw","ljx","lka","lkb","lkc","lkd","lke","lkh","lki","lkj","lkl","lkm","lkn","lko","lkr","lks","lkt","lku","lky","lla","llb","llc","lld","lle","llf","llg","llh","lli","llj","llk","lll","llm","lln","llo","llp","llq","lls","llu","llx","lma","lmb","lmc","lmd","lme","lmf","lmg","lmh","lmi","lmj","lmk","lml","lmm","lmn","lmo","lmp","lmq","lmr","lmu","lmv","lmw","lmx","lmy","lmz","lna","lnb","lnd","lng","lnh","lni","lnj","lnl","lnm","lnn","lno","lns","lnu","lnw","lnz","loa","lob","loc","loe","lof","log","loh","loi","loj","lok","lol","lom","lon","loo","lop","loq","lor","los","lot","lou","lov","low","lox","loy","loz","lpa","lpe","lpn","lpo","lpx","lra","lrc","lre","lrg","lri","lrk","lrl","lrm","lrn","lro","lrr","lrt","lrv","lrz","lsa","lsd","lse","lsg","lsh","lsi","lsl","lsm","lso","lsp","lsr","lss","lst","lsy","ltc","ltg","lth","lti","ltn","lto","lts","ltu","lua","luc","lud","lue","luf","lui","luj","luk","lul","lum","lun","luo","lup","luq","lur","lus","lut","luu","luv","luw","luy","luz","lva","lvk","lvs","lvu","lwa","lwe","lwg","lwh","lwl","lwm","lwo","lwt","lwu","lww","lya","lyg","lyn","lzh","lzl","lzn","lzz","maa","mab","mad","mae","maf","mag","mai","maj","mak","mam","man","map","maq","mas","mat","mau","mav","maw","max","maz","mba","mbb","mbc","mbd","mbe","mbf","mbh","mbi","mbj","mbk","mbl","mbm","mbn","mbo","mbp","mbq","mbr","mbs","mbt","mbu","mbv","mbw","mbx","mby","mbz","mca","mcb","mcc","mcd","mce","mcf","mcg","mch","mci","mcj","mck","mcl","mcm","mcn","mco","mcp","mcq","mcr","mcs","mct","mcu","mcv","mcw","mcx","mcy","mcz","mda","mdb","mdc","mdd","mde","mdf","mdg","mdh","mdi","mdj","mdk","mdl","mdm","mdn","mdp","mdq","mdr","mds","mdt","mdu","mdv","mdw","mdx","mdy","mdz","mea","meb","mec","med","mee","mef","meg","meh","mei","mej","mek","mel","mem","men","meo","mep","meq","mer","mes","met","meu","mev","mew","mey","mez","mfa","mfb","mfc","mfd","mfe","mff","mfg","mfh","mfi","mfj","mfk","mfl","mfm","mfn","mfo","mfp","mfq","mfr","mfs","mft","mfu","mfv","mfw","mfx","mfy","mfz","mga","mgb","mgc","mgd","mge","mgf","mgg","mgh","mgi","mgj","mgk","mgl","mgm","mgn","mgo","mgp","mgq","mgr","mgs","mgt","mgu","mgv","mgw","mgx","mgy","mgz","mha","mhb","mhc","mhd","mhe","mhf","mhg","mhh","mhi","mhj","mhk","mhl","mhm","mhn","mho","mhp","mhq","mhr","mhs","mht","mhu","mhw","mhx","mhy","mhz","mia","mib","mic","mid","mie","mif","mig","mih","mii","mij","mik","mil","mim","min","mio","mip","miq","mir","mis","mit","miu","miw","mix","miy","miz","mja","mjb","mjc","mjd","mje","mjg","mjh","mji","mjj","mjk","mjl","mjm","mjn","mjo","mjp","mjq","mjr","mjs","mjt","mju","mjv","mjw","mjx","mjy","mjz","mka","mkb","mkc","mke","mkf","mkg","mkh","mki","mkj","mkk","mkl","mkm","mkn","mko","mkp","mkq","mkr","mks","mkt","mku","mkv","mkw","mkx","mky","mkz","mla","mlb","mlc","mld","mle","mlf","mlh","mli","mlj","mlk","mll","mlm","mln","mlo","mlp","mlq","mlr","mls","mlu","mlv","mlw","mlx","mlz","mma","mmb","mmc","mmd","mme","mmf","mmg","mmh","mmi","mmj","mmk","mml","mmm","mmn","mmo","mmp","mmq","mmr","mmt","mmu","mmv","mmw","mmx","mmy","mmz","mna","mnb","mnc","mnd","mne","mnf","mng","mnh","mni","mnj","mnk","mnl","mnm","mnn","mno","mnp","mnq","mnr","mns","mnt","mnu","mnv","mnw","mnx","mny","mnz","moa","moc","mod","moe","mof","mog","moh","moi","moj","mok","mom","moo","mop","moq","mor","mos","mot","mou","mov","mow","mox","moy","moz","mpa","mpb","mpc","mpd","mpe","mpg","mph","mpi","mpj","mpk","mpl","mpm","mpn","mpo","mpp","mpq","mpr","mps","mpt","mpu","mpv","mpw","mpx","mpy","mpz","mqa","mqb","mqc","mqe","mqf","mqg","mqh","mqi","mqj","mqk","mql","mqm","mqn","mqo","mqp","mqq","mqr","mqs","mqt","mqu","mqv","mqw","mqx","mqy","mqz","mra","mrb","mrc","mrd","mre","mrf","mrg","mrh","mrj","mrk","mrl","mrm","mrn","mro","mrp","mrq","mrr","mrs","mrt","mru","mrv","mrw","mrx","mry","mrz","msb","msc","msd","mse","msf","msg","msh","msi","msj","msk","msl","msm","msn","mso","msp","msq","msr","mss","mst","msu","msv","msw","msx","msy","msz","mta","mtb","mtc","mtd","mte","mtf","mtg","mth","mti","mtj","mtk","mtl","mtm","mtn","mto","mtp","mtq","mtr","mts","mtt","mtu","mtv","mtw","mtx","mty","mua","mub","muc","mud","mue","mug","muh","mui","muj","muk","mul","mum","mun","muo","mup","muq","mur","mus","mut","muu","muv","mux","muy","muz","mva","mvb","mvd","mve","mvf","mvg","mvh","mvi","mvk","mvl","mvm","mvn","mvo","mvp","mvq","mvr","mvs","mvt","mvu","mvv","mvw","mvx","mvy","mvz","mwa","mwb","mwc","mwd","mwe","mwf","mwg","mwh","mwi","mwj","mwk","mwl","mwm","mwn","mwo","mwp","mwq","mwr","mws","mwt","mwu","mwv","mww","mwx","mwy","mwz","mxa","mxb","mxc","mxd","mxe","mxf","mxg","mxh","mxi","mxj","mxk","mxl","mxm","mxn","mxo","mxp","mxq","mxr","mxs","mxt","mxu","mxv","mxw","mxx","mxy","mxz","myb","myc","myd","mye","myf","myg","myh","myi","myj","myk","myl","mym","myn","myo","myp","myq","myr","mys","myt","myu","myv","myw","myx","myy","myz","mza","mzb","mzc","mzd","mze","mzg","mzh","mzi","mzj","mzk","mzl","mzm","mzn","mzo","mzp","mzq","mzr","mzs","mzt","mzu","mzv","mzw","mzx","mzy","mzz","naa","nab","nac","nad","nae","naf","nag","nah","nai","naj","nak","nal","nam","nan","nao","nap","naq","nar","nas","nat","naw","nax","nay","naz","nba","nbb","nbc","nbd","nbe","nbf","nbg","nbh","nbi","nbj","nbk","nbm","nbn","nbo","nbp","nbq","nbr","nbs","nbt","nbu","nbv","nbw","nbx","nby","nca","ncb","ncc","ncd","nce","ncf","ncg","nch","nci","ncj","nck","ncl","ncm","ncn","nco","ncp","ncq","ncr","ncs","nct","ncu","ncx","ncz","nda","ndb","ndc","ndd","ndf","ndg","ndh","ndi","ndj","ndk","ndl","ndm","ndn","ndp","ndq","ndr","nds","ndt","ndu","ndv","ndw","ndx","ndy","ndz","nea","neb","nec","ned","nee","nef","neg","neh","nei","nej","nek","nem","nen","neo","neq","ner","nes","net","neu","nev","new","nex","ney","nez","nfa","nfd","nfl","nfr","nfu","nga","ngb","ngc","ngd","nge","ngf","ngg","ngh","ngi","ngj","ngk","ngl","ngm","ngn","ngo","ngp","ngq","ngr","ngs","ngt","ngu","ngv","ngw","ngx","ngy","ngz","nha","nhb","nhc","nhd","nhe","nhf","nhg","nhh","nhi","nhk","nhm","nhn","nho","nhp","nhq","nhr","nht","nhu","nhv","nhw","nhx","nhy","nhz","nia","nib","nic","nid","nie","nif","nig","nih","nii","nij","nik","nil","nim","nin","nio","niq","nir","nis","nit","niu","niv","niw","nix","niy","niz","nja","njb","njd","njh","nji","njj","njl","njm","njn","njo","njr","njs","njt","nju","njx","njy","njz","nka","nkb","nkc","nkd","nke","nkf","nkg","nkh","nki","nkj","nkk","nkm","nkn","nko","nkp","nkq","nkr","nks","nkt","nku","nkv","nkw","nkx","nkz","nla","nlc","nle","nlg","nli","nlj","nlk","nll","nln","nlo","nlq","nlr","nlu","nlv","nlw","nlx","nly","nlz","nma","nmb","nmc","nmd","nme","nmf","nmg","nmh","nmi","nmj","nmk","nml","nmm","nmn","nmo","nmp","nmq","nmr","nms","nmt","nmu","nmv","nmw","nmx","nmy","nmz","nna","nnb","nnc","nnd","nne","nnf","nng","nnh","nni","nnj","nnk","nnl","nnm","nnn","nnp","nnq","nnr","nns","nnt","nnu","nnv","nnw","nnx","nny","nnz","noa","noc","nod","noe","nof","nog","noh","noi","noj","nok","nol","nom","non","noo","nop","noq","nos","not","nou","nov","now","noy","noz","npa","npb","npg","nph","npi","npl","npn","npo","nps","npu","npx","npy","nqg","nqk","nql","nqm","nqn","nqo","nqq","nqy","nra","nrb","nrc","nre","nrf","nrg","nri","nrk","nrl","nrm","nrn","nrp","nrr","nrt","nru","nrx","nrz","nsa","nsc","nsd","nse","nsf","nsg","nsh","nsi","nsk","nsl","nsm","nsn","nso","nsp","nsq","nsr","nss","nst","nsu","nsv","nsw","nsx","nsy","nsz","ntd","nte","ntg","nti","ntj","ntk","ntm","nto","ntp","ntr","nts","ntu","ntw","ntx","nty","ntz","nua","nub","nuc","nud","nue","nuf","nug","nuh","nui","nuj","nuk","nul","num","nun","nuo","nup","nuq","nur","nus","nut","nuu","nuv","nuw","nux","nuy","nuz","nvh","nvm","nvo","nwa","nwb","nwc","nwe","nwg","nwi","nwm","nwo","nwr","nwx","nwy","nxa","nxd","nxe","nxg","nxi","nxk","nxl","nxm","nxn","nxo","nxq","nxr","nxu","nxx","nyb","nyc","nyd","nye","nyf","nyg","nyh","nyi","nyj","nyk","nyl","nym","nyn","nyo","nyp","nyq","nyr","nys","nyt","nyu","nyv","nyw","nyx","nyy","nza","nzb","nzi","nzk","nzm","nzs","nzu","nzy","nzz","oaa","oac","oar","oav","obi","obk","obl","obm","obo","obr","obt","obu","oca","och","oco","ocu","oda","odk","odt","odu","ofo","ofs","ofu","ogb","ogc","oge","ogg","ogo","ogu","oht","ohu","oia","oin","ojb","ojc","ojg","ojp","ojs","ojv","ojw","oka","okb","okd","oke","okg","okh","oki","okj","okk","okl","okm","okn","oko","okr","oks","oku","okv","okx","ola","old","ole","olk","olm","olo","olr","olt","olu","oma","omb","omc","ome","omg","omi","omk","oml","omn","omo","omp","omq","omr","omt","omu","omv","omw","omx","ona","onb","one","ong","oni","onj","onk","onn","ono","onp","onr","ons","ont","onu","onw","onx","ood","oog","oon","oor","oos","opa","opk","opm","opo","opt","opy","ora","orc","ore","org","orh","orn","oro","orr","ors","ort","oru","orv","orw","orx","ory","orz","osa","osc","osi","oso","osp","ost","osu","osx","ota","otb","otd","ote","oti","otk","otl","otm","otn","oto","otq","otr","ots","ott","otu","otw","otx","oty","otz","oua","oub","oue","oui","oum","oun","ovd","owi","owl","oyb","oyd","oym","oyy","ozm","paa","pab","pac","pad","pae","paf","pag","pah","pai","pak","pal","pam","pao","pap","paq","par","pas","pat","pau","pav","paw","pax","pay","paz","pbb","pbc","pbe","pbf","pbg","pbh","pbi","pbl","pbn","pbo","pbp","pbr","pbs","pbt","pbu","pbv","pby","pbz","pca","pcb","pcc","pcd","pce","pcf","pcg","pch","pci","pcj","pck","pcl","pcm","pcn","pcp","pcr","pcw","pda","pdc","pdi","pdn","pdo","pdt","pdu","pea","peb","ped","pee","pef","peg","peh","pei","pej","pek","pel","pem","peo","pep","peq","pes","pev","pex","pey","pez","pfa","pfe","pfl","pga","pgd","pgg","pgi","pgk","pgl","pgn","pgs","pgu","pgy","pgz","pha","phd","phg","phh","phi","phk","phl","phm","phn","pho","phq","phr","pht","phu","phv","phw","pia","pib","pic","pid","pie","pif","pig","pih","pii","pij","pil","pim","pin","pio","pip","pir","pis","pit","piu","piv","piw","pix","piy","piz","pjt","pka","pkb","pkc","pkg","pkh","pkn","pko","pkp","pkr","pks","pkt","pku","pla","plb","plc","pld","ple","plf","plg","plh","plj","plk","pll","pln","plo","plp","plq","plr","pls","plt","plu","plv","plw","ply","plz","pma","pmb","pmc","pmd","pme","pmf","pmh","pmi","pmj","pmk","pml","pmm","pmn","pmo","pmq","pmr","pms","pmt","pmu","pmw","pmx","pmy","pmz","pna","pnb","pnc","pne","png","pnh","pni","pnj","pnk","pnl","pnm","pnn","pno","pnp","pnq","pnr","pns","pnt","pnu","pnv","pnw","pnx","pny","pnz","poc","pod","poe","pof","pog","poh","poi","pok","pom","pon","poo","pop","poq","pos","pot","pov","pow","pox","poy","poz","ppa","ppe","ppi","ppk","ppl","ppm","ppn","ppo","ppp","ppq","ppr","pps","ppt","ppu","pqa","pqe","pqm","pqw","pra","prb","prc","prd","pre","prf","prg","prh","pri","prk","prl","prm","prn","pro","prp","prq","prr","prs","prt","pru","prw","prx","pry","prz","psa","psc","psd","pse","psg","psh","psi","psl","psm","psn","pso","psp","psq","psr","pss","pst","psu","psw","psy","pta","pth","pti","ptn","pto","ptp","ptq","ptr","ptt","ptu","ptv","ptw","pty","pua","pub","puc","pud","pue","puf","pug","pui","puj","puk","pum","puo","pup","puq","pur","put","puu","puw","pux","puy","puz","pwa","pwb","pwg","pwi","pwm","pwn","pwo","pwr","pww","pxm","pye","pym","pyn","pys","pyu","pyx","pyy","pzn","qaa..qtz","qua","qub","quc","qud","quf","qug","quh","qui","quk","qul","qum","qun","qup","quq","qur","qus","quv","quw","qux","quy","quz","qva","qvc","qve","qvh","qvi","qvj","qvl","qvm","qvn","qvo","qvp","qvs","qvw","qvy","qvz","qwa","qwc","qwe","qwh","qwm","qws","qwt","qxa","qxc","qxh","qxl","qxn","qxo","qxp","qxq","qxr","qxs","qxt","qxu","qxw","qya","qyp","raa","rab","rac","rad","raf","rag","rah","rai","raj","rak","ral","ram","ran","rao","rap","raq","rar","ras","rat","rau","rav","raw","rax","ray","raz","rbb","rbk","rbl","rbp","rcf","rdb","rea","reb","ree","reg","rei","rej","rel","rem","ren","rer","res","ret","rey","rga","rge","rgk","rgn","rgr","rgs","rgu","rhg","rhp","ria","rie","rif","ril","rim","rin","rir","rit","riu","rjg","rji","rjs","rka","rkb","rkh","rki","rkm","rkt","rkw","rma","rmb","rmc","rmd","rme","rmf","rmg","rmh","rmi","rmk","rml","rmm","rmn","rmo","rmp","rmq","rmr","rms","rmt","rmu","rmv","rmw","rmx","rmy","rmz","rna","rnd","rng","rnl","rnn","rnp","rnr","rnw","roa","rob","roc","rod","roe","rof","rog","rol","rom","roo","rop","ror","rou","row","rpn","rpt","rri","rro","rrt","rsb","rsi","rsl","rsm","rtc","rth","rtm","rts","rtw","rub","ruc","rue","ruf","rug","ruh","rui","ruk","ruo","rup","ruq","rut","ruu","ruy","ruz","rwa","rwk","rwm","rwo","rwr","rxd","rxw","ryn","rys","ryu","rzh","saa","sab","sac","sad","sae","saf","sah","sai","saj","sak","sal","sam","sao","sap","saq","sar","sas","sat","sau","sav","saw","sax","say","saz","sba","sbb","sbc","sbd","sbe","sbf","sbg","sbh","sbi","sbj","sbk","sbl","sbm","sbn","sbo","sbp","sbq","sbr","sbs","sbt","sbu","sbv","sbw","sbx","sby","sbz","sca","scb","sce","scf","scg","sch","sci","sck","scl","scn","sco","scp","scq","scs","sct","scu","scv","scw","scx","sda","sdb","sdc","sde","sdf","sdg","sdh","sdj","sdk","sdl","sdm","sdn","sdo","sdp","sdr","sds","sdt","sdu","sdv","sdx","sdz","sea","seb","sec","sed","see","sef","seg","seh","sei","sej","sek","sel","sem","sen","seo","sep","seq","ser","ses","set","seu","sev","sew","sey","sez","sfb","sfe","sfm","sfs","sfw","sga","sgb","sgc","sgd","sge","sgg","sgh","sgi","sgj","sgk","sgl","sgm","sgn","sgo","sgp","sgr","sgs","sgt","sgu","sgw","sgx","sgy","sgz","sha","shb","shc","shd","she","shg","shh","shi","shj","shk","shl","shm","shn","sho","shp","shq","shr","shs","sht","shu","shv","shw","shx","shy","shz","sia","sib","sid","sie","sif","sig","sih","sii","sij","sik","sil","sim","sio","sip","siq","sir","sis","sit","siu","siv","siw","six","siy","siz","sja","sjb","sjd","sje","sjg","sjk","sjl","sjm","sjn","sjo","sjp","sjr","sjs","sjt","sju","sjw","ska","skb","skc","skd","ske","skf","skg","skh","ski","skj","skk","skm","skn","sko","skp","skq","skr","sks","skt","sku","skv","skw","skx","sky","skz","sla","slc","sld","sle","slf","slg","slh","sli","slj","sll","slm","sln","slp","slq","slr","sls","slt","slu","slw","slx","sly","slz","sma","smb","smc","smd","smf","smg","smh","smi","smj","smk","sml","smm","smn","smp","smq","smr","sms","smt","smu","smv","smw","smx","smy","smz","snb","snc","sne","snf","sng","snh","sni","snj","snk","snl","snm","snn","sno","snp","snq","snr","sns","snu","snv","snw","snx","sny","snz","soa","sob","soc","sod","soe","sog","soh","soi","soj","sok","sol","son","soo","sop","soq","sor","sos","sou","sov","sow","sox","soy","soz","spb","spc","spd","spe","spg","spi","spk","spl","spm","spn","spo","spp","spq","spr","sps","spt","spu","spv","spx","spy","sqa","sqh","sqj","sqk","sqm","sqn","sqo","sqq","sqr","sqs","sqt","squ","sra","srb","src","sre","srf","srg","srh","sri","srk","srl","srm","srn","sro","srq","srr","srs","srt","sru","srv","srw","srx","sry","srz","ssa","ssb","ssc","ssd","sse","ssf","ssg","ssh","ssi","ssj","ssk","ssl","ssm","ssn","sso","ssp","ssq","ssr","sss","sst","ssu","ssv","ssx","ssy","ssz","sta","stb","std","ste","stf","stg","sth","sti","stj","stk","stl","stm","stn","sto","stp","stq","str","sts","stt","stu","stv","stw","sty","sua","sub","suc","sue","sug","sui","suj","suk","sul","sum","suq","sur","sus","sut","suv","suw","sux","suy","suz","sva","svb","svc","sve","svk","svm","svr","svs","svx","swb","swc","swf","swg","swh","swi","swj","swk","swl","swm","swn","swo","swp","swq","swr","sws","swt","swu","swv","sww","swx","swy","sxb","sxc","sxe","sxg","sxk","sxl","sxm","sxn","sxo","sxr","sxs","sxu","sxw","sya","syb","syc","syd","syi","syk","syl","sym","syn","syo","syr","sys","syw","syx","syy","sza","szb","szc","szd","sze","szg","szl","szn","szp","szs","szv","szw","taa","tab","tac","tad","tae","taf","tag","tai","taj","tak","tal","tan","tao","tap","taq","tar","tas","tau","tav","taw","tax","tay","taz","tba","tbb","tbc","tbd","tbe","tbf","tbg","tbh","tbi","tbj","tbk","tbl","tbm","tbn","tbo","tbp","tbq","tbr","tbs","tbt","tbu","tbv","tbw","tbx","tby","tbz","tca","tcb","tcc","tcd","tce","tcf","tcg","tch","tci","tck","tcl","tcm","tcn","tco","tcp","tcq","tcs","tct","tcu","tcw","tcx","tcy","tcz","tda","tdb","tdc","tdd","tde","tdf","tdg","tdh","tdi","tdj","tdk","tdl","tdm","tdn","tdo","tdq","tdr","tds","tdt","tdu","tdv","tdx","tdy","tea","teb","tec","ted","tee","tef","teg","teh","tei","tek","tem","ten","teo","tep","teq","ter","tes","tet","teu","tev","tew","tex","tey","tfi","tfn","tfo","tfr","tft","tga","tgb","tgc","tgd","tge","tgf","tgg","tgh","tgi","tgj","tgn","tgo","tgp","tgq","tgr","tgs","tgt","tgu","tgv","tgw","tgx","tgy","tgz","thc","thd","the","thf","thh","thi","thk","thl","thm","thn","thp","thq","thr","ths","tht","thu","thv","thw","thx","thy","thz","tia","tic","tid","tie","tif","tig","tih","tii","tij","tik","til","tim","tin","tio","tip","tiq","tis","tit","tiu","tiv","tiw","tix","tiy","tiz","tja","tjg","tji","tjl","tjm","tjn","tjo","tjs","tju","tjw","tka","tkb","tkd","tke","tkf","tkg","tkk","tkl","tkm","tkn","tkp","tkq","tkr","tks","tkt","tku","tkv","tkw","tkx","tkz","tla","tlb","tlc","tld","tlf","tlg","tlh","tli","tlj","tlk","tll","tlm","tln","tlo","tlp","tlq","tlr","tls","tlt","tlu","tlv","tlw","tlx","tly","tma","tmb","tmc","tmd","tme","tmf","tmg","tmh","tmi","tmj","tmk","tml","tmm","tmn","tmo","tmp","tmq","tmr","tms","tmt","tmu","tmv","tmw","tmy","tmz","tna","tnb","tnc","tnd","tne","tnf","tng","tnh","tni","tnk","tnl","tnm","tnn","tno","tnp","tnq","tnr","tns","tnt","tnu","tnv","tnw","tnx","tny","tnz","tob","toc","tod","toe","tof","tog","toh","toi","toj","tol","tom","too","top","toq","tor","tos","tou","tov","tow","tox","toy","toz","tpa","tpc","tpe","tpf","tpg","tpi","tpj","tpk","tpl","tpm","tpn","tpo","tpp","tpq","tpr","tpt","tpu","tpv","tpw","tpx","tpy","tpz","tqb","tql","tqm","tqn","tqo","tqp","tqq","tqr","tqt","tqu","tqw","tra","trb","trc","trd","tre","trf","trg","trh","tri","trj","trk","trl","trm","trn","tro","trp","trq","trr","trs","trt","tru","trv","trw","trx","try","trz","tsa","tsb","tsc","tsd","tse","tsf","tsg","tsh","tsi","tsj","tsk","tsl","tsm","tsp","tsq","tsr","tss","tst","tsu","tsv","tsw","tsx","tsy","tsz","tta","ttb","ttc","ttd","tte","ttf","ttg","tth","tti","ttj","ttk","ttl","ttm","ttn","tto","ttp","ttq","ttr","tts","ttt","ttu","ttv","ttw","tty","ttz","tua","tub","tuc","tud","tue","tuf","tug","tuh","tui","tuj","tul","tum","tun","tuo","tup","tuq","tus","tut","tuu","tuv","tuw","tux","tuy","tuz","tva","tvd","tve","tvk","tvl","tvm","tvn","tvo","tvs","tvt","tvu","tvw","tvy","twa","twb","twc","twd","twe","twf","twg","twh","twl","twm","twn","two","twp","twq","twr","twt","twu","tww","twx","twy","txa","txb","txc","txe","txg","txh","txi","txj","txm","txn","txo","txq","txr","txs","txt","txu","txx","txy","tya","tye","tyh","tyi","tyj","tyl","tyn","typ","tyr","tys","tyt","tyu","tyv","tyx","tyz","tza","tzh","tzj","tzl","tzm","tzn","tzo","tzx","uam","uan","uar","uba","ubi","ubl","ubr","ubu","uby","uda","ude","udg","udi","udj","udl","udm","udu","ues","ufi","uga","ugb","uge","ugn","ugo","ugy","uha","uhn","uis","uiv","uji","uka","ukg","ukh","ukk","ukl","ukp","ukq","uks","uku","ukw","uky","ula","ulb","ulc","ule","ulf","uli","ulk","ull","ulm","uln","ulu","ulw","uma","umb","umc","umd","umg","umi","umm","umn","umo","ump","umr","ums","umu","una","und","une","ung","unk","unm","unn","unp","unr","unu","unx","unz","uok","upi","upv","ura","urb","urc","ure","urf","urg","urh","uri","urj","urk","url","urm","urn","uro","urp","urr","urt","uru","urv","urw","urx","ury","urz","usa","ush","usi","usk","usp","usu","uta","ute","utp","utr","utu","uum","uun","uur","uuu","uve","uvh","uvl","uwa","uya","uzn","uzs","vaa","vae","vaf","vag","vah","vai","vaj","val","vam","van","vao","vap","var","vas","vau","vav","vay","vbb","vbk","vec","ved","vel","vem","veo","vep","ver","vgr","vgt","vic","vid","vif","vig","vil","vin","vis","vit","viv","vka","vki","vkj","vkk","vkl","vkm","vko","vkp","vkt","vku","vlp","vls","vma","vmb","vmc","vmd","vme","vmf","vmg","vmh","vmi","vmj","vmk","vml","vmm","vmp","vmq","vmr","vms","vmu","vmv","vmw","vmx","vmy","vmz","vnk","vnm","vnp","vor","vot","vra","vro","vrs","vrt","vsi","vsl","vsv","vto","vum","vun","vut","vwa","waa","wab","wac","wad","wae","waf","wag","wah","wai","waj","wak","wal","wam","wan","wao","wap","waq","war","was","wat","wau","wav","waw","wax","way","waz","wba","wbb","wbe","wbf","wbh","wbi","wbj","wbk","wbl","wbm","wbp","wbq","wbr","wbs","wbt","wbv","wbw","wca","wci","wdd","wdg","wdj","wdk","wdu","wdy","wea","wec","wed","weg","weh","wei","wem","wen","weo","wep","wer","wes","wet","weu","wew","wfg","wga","wgb","wgg","wgi","wgo","wgu","wgw","wgy","wha","whg","whk","whu","wib","wic","wie","wif","wig","wih","wii","wij","wik","wil","wim","win","wir","wit","wiu","wiv","wiw","wiy","wja","wji","wka","wkb","wkd","wkl","wku","wkw","wky","wla","wlc","wle","wlg","wli","wlk","wll","wlm","wlo","wlr","wls","wlu","wlv","wlw","wlx","wly","wma","wmb","wmc","wmd","wme","wmh","wmi","wmm","wmn","wmo","wms","wmt","wmw","wmx","wnb","wnc","wnd","wne","wng","wni","wnk","wnm","wnn","wno","wnp","wnu","wnw","wny","woa","wob","woc","wod","woe","wof","wog","woi","wok","wom","won","woo","wor","wos","wow","woy","wpc","wra","wrb","wrd","wrg","wrh","wri","wrk","wrl","wrm","wrn","wro","wrp","wrr","wrs","wru","wrv","wrw","wrx","wry","wrz","wsa","wsg","wsi","wsk","wsr","wss","wsu","wsv","wtf","wth","wti","wtk","wtm","wtw","wua","wub","wud","wuh","wul","wum","wun","wur","wut","wuu","wuv","wux","wuy","wwa","wwb","wwo","wwr","www","wxa","wxw","wya","wyb","wyi","wym","wyr","wyy","xaa","xab","xac","xad","xae","xag","xai","xaj","xak","xal","xam","xan","xao","xap","xaq","xar","xas","xat","xau","xav","xaw","xay","xba","xbb","xbc","xbd","xbe","xbg","xbi","xbj","xbm","xbn","xbo","xbp","xbr","xbw","xbx","xby","xcb","xcc","xce","xcg","xch","xcl","xcm","xcn","xco","xcr","xct","xcu","xcv","xcw","xcy","xda","xdc","xdk","xdm","xdo","xdy","xeb","xed","xeg","xel","xem","xep","xer","xes","xet","xeu","xfa","xga","xgb","xgd","xgf","xgg","xgi","xgl","xgm","xgn","xgr","xgu","xgw","xha","xhc","xhd","xhe","xhr","xht","xhu","xhv","xia","xib","xii","xil","xin","xip","xir","xis","xiv","xiy","xjb","xjt","xka","xkb","xkc","xkd","xke","xkf","xkg","xkh","xki","xkj","xkk","xkl","xkn","xko","xkp","xkq","xkr","xks","xkt","xku","xkv","xkw","xkx","xky","xkz","xla","xlb","xlc","xld","xle","xlg","xli","xln","xlo","xlp","xls","xlu","xly","xma","xmb","xmc","xmd","xme","xmf","xmg","xmh","xmj","xmk","xml","xmm","xmn","xmo","xmp","xmq","xmr","xms","xmt","xmu","xmv","xmw","xmx","xmy","xmz","xna","xnb","xnd","xng","xnh","xni","xnk","xnn","xno","xnr","xns","xnt","xnu","xny","xnz","xoc","xod","xog","xoi","xok","xom","xon","xoo","xop","xor","xow","xpa","xpc","xpe","xpg","xpi","xpj","xpk","xpm","xpn","xpo","xpp","xpq","xpr","xps","xpt","xpu","xpy","xqa","xqt","xra","xrb","xrd","xre","xrg","xri","xrm","xrn","xrq","xrr","xrt","xru","xrw","xsa","xsb","xsc","xsd","xse","xsh","xsi","xsj","xsl","xsm","xsn","xso","xsp","xsq","xsr","xss","xsu","xsv","xsy","xta","xtb","xtc","xtd","xte","xtg","xth","xti","xtj","xtl","xtm","xtn","xto","xtp","xtq","xtr","xts","xtt","xtu","xtv","xtw","xty","xtz","xua","xub","xud","xug","xuj","xul","xum","xun","xuo","xup","xur","xut","xuu","xve","xvi","xvn","xvo","xvs","xwa","xwc","xwd","xwe","xwg","xwj","xwk","xwl","xwo","xwr","xwt","xww","xxb","xxk","xxm","xxr","xxt","xya","xyb","xyj","xyk","xyl","xyt","xyy","xzh","xzm","xzp","yaa","yab","yac","yad","yae","yaf","yag","yah","yai","yaj","yak","yal","yam","yan","yao","yap","yaq","yar","yas","yat","yau","yav","yaw","yax","yay","yaz","yba","ybb","ybd","ybe","ybh","ybi","ybj","ybk","ybl","ybm","ybn","ybo","ybx","yby","ych","ycl","ycn","ycp","yda","ydd","yde","ydg","ydk","yds","yea","yec","yee","yei","yej","yel","yen","yer","yes","yet","yeu","yev","yey","yga","ygi","ygl","ygm","ygp","ygr","ygs","ygu","ygw","yha","yhd","yhl","yhs","yia","yif","yig","yih","yii","yij","yik","yil","yim","yin","yip","yiq","yir","yis","yit","yiu","yiv","yix","yiy","yiz","yka","ykg","yki","ykk","ykl","ykm","ykn","yko","ykr","ykt","yku","yky","yla","ylb","yle","ylg","yli","yll","ylm","yln","ylo","ylr","ylu","yly","yma","ymb","ymc","ymd","yme","ymg","ymh","ymi","ymk","yml","ymm","ymn","ymo","ymp","ymq","ymr","yms","ymt","ymx","ymz","yna","ynd","yne","yng","ynh","ynk","ynl","ynn","yno","ynq","yns","ynu","yob","yog","yoi","yok","yol","yom","yon","yos","yot","yox","yoy","ypa","ypb","ypg","yph","ypk","ypm","ypn","ypo","ypp","ypz","yra","yrb","yre","yri","yrk","yrl","yrm","yrn","yro","yrs","yrw","yry","ysc","ysd","ysg","ysl","ysn","yso","ysp","ysr","yss","ysy","yta","ytl","ytp","ytw","yty","yua","yub","yuc","yud","yue","yuf","yug","yui","yuj","yuk","yul","yum","yun","yup","yuq","yur","yut","yuu","yuw","yux","yuy","yuz","yva","yvt","ywa","ywg","ywl","ywn","ywq","ywr","ywt","ywu","yww","yxa","yxg","yxl","yxm","yxu","yxy","yyr","yyu","yyz","yzg","yzk","zaa","zab","zac","zad","zae","zaf","zag","zah","zai","zaj","zak","zal","zam","zao","zap","zaq","zar","zas","zat","zau","zav","zaw","zax","zay","zaz","zbc","zbe","zbl","zbt","zbw","zca","zch","zdj","zea","zeg","zeh","zen","zga","zgb","zgh","zgm","zgn","zgr","zhb","zhd","zhi","zhn","zhw","zhx","zia","zib","zik","zil","zim","zin","zir","ziw","ziz","zka","zkb","zkd","zkg","zkh","zkk","zkn","zko","zkp","zkr","zkt","zku","zkv","zkz","zle","zlj","zlm","zln","zlq","zls","zlw","zma","zmb","zmc","zmd","zme","zmf","zmg","zmh","zmi","zmj","zmk","zml","zmm","zmn","zmo","zmp","zmq","zmr","zms","zmt","zmu","zmv","zmw","zmx","zmy","zmz","zna","znd","zne","zng","znk","zns","zoc","zoh","zom","zoo","zoq","zor","zos","zpa","zpb","zpc","zpd","zpe","zpf","zpg","zph","zpi","zpj","zpk","zpl","zpm","zpn","zpo","zpp","zpq","zpr","zps","zpt","zpu","zpv","zpw","zpx","zpy","zpz","zqe","zra","zrg","zrn","zro","zrp","zrs","zsa","zsk","zsl","zsm","zsr","zsu","zte","ztg","ztl","ztm","ztn","ztp","ztq","zts","ztt","ztu","ztx","zty","zua","zuh","zum","zun","zuy","zwa","zxx","zyb","zyg","zyj","zyn","zyp","zza","zzj"];axe.utils.validLangs=function(){'use strict';return langs;};},{}],99:[function(require,module,exports){window.requestFileSystem=window.requestFileSystem||window.webkitRequestFileSystem;WebInspector.TempFile=function()
{this._fileEntry=null;this._writer=null;};WebInspector.TempFile.create=function(dirPath,name)
{var file=new WebInspector.TempFile();function requestTempFileSystem()
{return new Promise(window.requestFileSystem.bind(window,window.TEMPORARY,10));}
function getDirectoryEntry(fs)
{return new Promise(fs.root.getDirectory.bind(fs.root,dirPath,{create:true}));}
function getFileEntry(dir)
{return new Promise(dir.getFile.bind(dir,name,{create:true}));}
function createFileWriter(fileEntry)
{file._fileEntry=fileEntry;return new Promise(fileEntry.createWriter.bind(fileEntry));}
function truncateFile(writer)
{if(!writer.length){file._writer=writer;return Promise.resolve(file);}
function truncate(fulfill,reject)
{writer.onwriteend=fulfill;writer.onerror=reject;writer.truncate(0);}
function didTruncate()
{file._writer=writer;writer.onwriteend=null;writer.onerror=null;return Promise.resolve(file);}
function onTruncateError(e)
{writer.onwriteend=null;writer.onerror=null;throw e;}
return new Promise(truncate).then(didTruncate,onTruncateError);}
return WebInspector.TempFile.ensureTempStorageCleared().then(requestTempFileSystem).then(getDirectoryEntry).then(getFileEntry).then(createFileWriter).then(truncateFile);};WebInspector.TempFile.prototype={write:function(strings,callback)
{var blob=new Blob(strings,{type:"text/plain"});this._writer.onerror=function(e)
{WebInspector.console.error("Failed to write into a temp file: "+e.target.error.message);callback(-1);};this._writer.onwriteend=function(e)
{callback(e.target.length);};this._writer.write(blob);},finishWriting:function()
{this._writer=null;},read:function(callback)
{this.readRange(undefined,undefined,callback);},readRange:function(startOffset,endOffset,callback)
{function didGetFile(file)
{var reader=new FileReader();if(typeof startOffset==="number"||typeof endOffset==="number")
file=file.slice(startOffset,endOffset);reader.onloadend=function(e)
{callback(this.result);};reader.onerror=function(error)
{WebInspector.console.error("Failed to read from temp file: "+error.message);};reader.readAsText(file);}
function didFailToGetFile(error)
{WebInspector.console.error("Failed to load temp file: "+error.message);callback(null);}
this._fileEntry.file(didGetFile,didFailToGetFile);},copyToOutputStream:function(outputStream,delegate)
{function didGetFile(file)
{var reader=new WebInspector.ChunkedFileReader(file,10*1000*1000,delegate);reader.start(outputStream);}
function didFailToGetFile(error)
{WebInspector.console.error("Failed to load temp file: "+error.message);outputStream.close();}
this._fileEntry.file(didGetFile,didFailToGetFile);},remove:function()
{if(this._fileEntry)
this._fileEntry.remove(function(){});}};WebInspector.DeferredTempFile=function(dirPath,name)
{this._chunks=[];this._tempFile=null;this._isWriting=false;this._finishCallback=null;this._finishedWriting=false;this._callsPendingOpen=[];this._pendingReads=[];WebInspector.TempFile.create(dirPath,name).then(this._didCreateTempFile.bind(this),this._failedToCreateTempFile.bind(this));};WebInspector.DeferredTempFile.prototype={write:function(strings,callback)
{if(this._finishCallback)
throw new Error("No writes are allowed after close.");this._chunks.push({strings:strings,callback:callback||null});if(this._tempFile&&!this._isWriting)
this._writeNextChunk();},finishWriting:function(callback)
{this._finishCallback=callback;if(this._finishedWriting)
callback(this._tempFile);else
if(!this._isWriting&&!this._chunks.length)
this._notifyFinished();},_failedToCreateTempFile:function(e)
{WebInspector.console.error("Failed to create temp file "+e.code+" : "+e.message);this._notifyFinished();},_didCreateTempFile:function(tempFile)
{this._tempFile=tempFile;var callsPendingOpen=this._callsPendingOpen;this._callsPendingOpen=null;for(var i=0;i<callsPendingOpen.length;++i)
callsPendingOpen[i]();if(this._chunks.length)
this._writeNextChunk();},_writeNextChunk:function()
{if(!this._tempFile)
return;var chunk=this._chunks.shift();this._isWriting=true;this._tempFile.write(chunk.strings,this._didWriteChunk.bind(this,chunk.callback));},_didWriteChunk:function(callback,size)
{this._isWriting=false;if(size===-1){this._tempFile=null;this._notifyFinished();return;}
if(callback)
callback(size);if(this._chunks.length)
this._writeNextChunk();else
if(this._finishCallback)
this._notifyFinished();},_notifyFinished:function()
{this._finishedWriting=true;if(this._tempFile)
this._tempFile.finishWriting();var chunks=this._chunks;this._chunks=[];for(var i=0;i<chunks.length;++i){if(chunks[i].callback)
chunks[i].callback(-1);}
if(this._finishCallback)
this._finishCallback(this._tempFile);var pendingReads=this._pendingReads;this._pendingReads=[];for(var i=0;i<pendingReads.length;++i)
pendingReads[i]();},readRange:function(startOffset,endOffset,callback)
{if(!this._finishedWriting){this._pendingReads.push(this.readRange.bind(this,startOffset,endOffset,callback));return;}
if(!this._tempFile){callback(null);return;}
this._tempFile.readRange(startOffset,endOffset,callback);},copyToOutputStream:function(outputStream,delegate)
{if(!this._finishedWriting){this._pendingReads.push(this.copyToOutputStream.bind(this,outputStream,delegate));return;}
if(this._tempFile)
this._tempFile.copyToOutputStream(outputStream,delegate);},remove:function()
{if(this._callsPendingOpen){this._callsPendingOpen.push(this.remove.bind(this));return;}
if(this._tempFile)
this._tempFile.remove();this._tempFile=null;}};WebInspector.TempFile._clearTempStorage=function(fulfill,reject)
{function handleError(event)
{WebInspector.console.error(WebInspector.UIString("Failed to clear temp storage: %s",event.data));reject(event.data);}
function handleMessage(event)
{if(event.data.type==="tempStorageCleared"){if(event.data.error)
WebInspector.console.error(event.data.error);else
fulfill(undefined);return;}
reject(event.data);}
try{var worker=new WebInspector.Worker("temp_storage_shared_worker","TempStorageCleaner");worker.onerror=handleError;worker.onmessage=handleMessage;}catch(e){if(e.name==="URLMismatchError")
console.log("Shared worker wasn't started due to url difference. "+e);else
throw e;}};WebInspector.TempFile.ensureTempStorageCleared=function()
{if(!WebInspector.TempFile._storageCleanerPromise)
WebInspector.TempFile._storageCleanerPromise=new Promise(WebInspector.TempFile._clearTempStorage);return WebInspector.TempFile._storageCleanerPromise;};WebInspector.TempFileBackingStorage=function(dirName)
{this._dirName=dirName;this.reset();};WebInspector.TempFileBackingStorage.Chunk;WebInspector.TempFileBackingStorage.prototype={appendString:function(string)
{this._strings.push(string);this._stringsLength+=string.length;var flushStringLength=10*1024*1024;if(this._stringsLength>flushStringLength)
this._flush(false);},appendAccessibleString:function(string)
{this._flush(false);this._strings.push(string);var chunk=this._flush(true);function readString(chunk,file)
{if(chunk.string)
return Promise.resolve(chunk.string);console.assert(chunk.endOffset);if(!chunk.endOffset)
return Promise.reject("Nor string nor offset to the string in the file were found.");function readRange(fulfill,reject)
{file.readRange(chunk.startOffset,chunk.endOffset,fulfill);}
return new Promise(readRange);}
return readString.bind(null,chunk,this._file);},_flush:function(createChunk)
{if(!this._strings.length)
return null;var chunk=null;if(createChunk){console.assert(this._strings.length===1);chunk={string:this._strings[0],startOffset:0,endOffset:0};}
function didWrite(chunk,fileSize)
{if(fileSize===-1)
return;if(chunk){chunk.startOffset=this._fileSize;chunk.endOffset=fileSize;chunk.string=null;}
this._fileSize=fileSize;}
this._file.write(this._strings,didWrite.bind(this,chunk));this._strings=[];this._stringsLength=0;return chunk;},finishWriting:function()
{this._flush(false);this._file.finishWriting(function(){});},reset:function()
{if(this._file)
this._file.remove();this._file=new WebInspector.DeferredTempFile(this._dirName,String(Date.now()));this._strings=[];this._stringsLength=0;this._fileSize=0;},writeToStream:function(outputStream,delegate)
{this._file.copyToOutputStream(outputStream,delegate);}};},{}],100:[function(require,module,exports){WebInspector.Color=function(rgba,format,originalText)
{this._rgba=rgba;this._originalText=originalText||null;this._originalTextIsValid=!!this._originalText;this._format=format;if(typeof this._rgba[3]==="undefined")
this._rgba[3]=1;for(var i=0;i<4;++i){if(this._rgba[i]<0){this._rgba[i]=0;this._originalTextIsValid=false;}
if(this._rgba[i]>1){this._rgba[i]=1;this._originalTextIsValid=false;}}};WebInspector.Color.Regex=/((?:rgb|hsl)a?\([^)]+\)|#[0-9a-fA-F]{6}|#[0-9a-fA-F]{3}|\b[a-zA-Z]+\b(?!-))/g;WebInspector.Color.Format={Original:"original",Nickname:"nickname",HEX:"hex",ShortHEX:"shorthex",RGB:"rgb",RGBA:"rgba",HSL:"hsl",HSLA:"hsla"};WebInspector.Color.parse=function(text)
{var value=text.toLowerCase().replace(/\s+/g,"");var simple=/^(?:#([0-9a-f]{3}|[0-9a-f]{6})|rgb\(((?:-?\d+%?,){2}-?\d+%?)\)|(\w+)|hsl\((-?\d+\.?\d*(?:,-?\d+\.?\d*%){2})\))$/i;var match=value.match(simple);if(match){if(match[1]){var hex=match[1].toLowerCase();var format;if(hex.length===3){format=WebInspector.Color.Format.ShortHEX;hex=hex.charAt(0)+hex.charAt(0)+hex.charAt(1)+hex.charAt(1)+hex.charAt(2)+hex.charAt(2);}else
format=WebInspector.Color.Format.HEX;var r=parseInt(hex.substring(0,2),16);var g=parseInt(hex.substring(2,4),16);var b=parseInt(hex.substring(4,6),16);return new WebInspector.Color([r/255,g/255,b/255,1],format,text);}
if(match[2]){var rgbString=match[2].split(/\s*,\s*/);var rgba=[WebInspector.Color._parseRgbNumeric(rgbString[0]),WebInspector.Color._parseRgbNumeric(rgbString[1]),WebInspector.Color._parseRgbNumeric(rgbString[2]),1];return new WebInspector.Color(rgba,WebInspector.Color.Format.RGB,text);}
if(match[3]){var nickname=match[3].toLowerCase();if(nickname in WebInspector.Color.Nicknames){var rgba=WebInspector.Color.Nicknames[nickname];var color=WebInspector.Color.fromRGBA(rgba);color._format=WebInspector.Color.Format.Nickname;color._originalText=text;return color;}
return null;}
if(match[4]){var hslString=match[4].replace(/%/g,"").split(/\s*,\s*/);var hsla=[WebInspector.Color._parseHueNumeric(hslString[0]),WebInspector.Color._parseSatLightNumeric(hslString[1]),WebInspector.Color._parseSatLightNumeric(hslString[2]),1];var rgba=[];WebInspector.Color.hsl2rgb(hsla,rgba);return new WebInspector.Color(rgba,WebInspector.Color.Format.HSL,text);}
return null;}
var advanced=/^(?:rgba\(((?:-?\d+%?,){3}-?(?:\d+|\d*\.\d+))\)|hsla\((-?(?:\d+|\d*\.\d+)(?:,-?(?:\d+|\d*\.\d+)*%){2},-?(?:\d+|\d*\.\d+))\))$/;match=value.match(advanced);if(match){if(match[1]){var rgbaString=match[1].split(/\s*,\s*/);var rgba=[WebInspector.Color._parseRgbNumeric(rgbaString[0]),WebInspector.Color._parseRgbNumeric(rgbaString[1]),WebInspector.Color._parseRgbNumeric(rgbaString[2]),WebInspector.Color._parseAlphaNumeric(rgbaString[3])];return new WebInspector.Color(rgba,WebInspector.Color.Format.RGBA,text);}
if(match[2]){var hslaString=match[2].replace(/%/g,"").split(/\s*,\s*/);var hsla=[WebInspector.Color._parseHueNumeric(hslaString[0]),WebInspector.Color._parseSatLightNumeric(hslaString[1]),WebInspector.Color._parseSatLightNumeric(hslaString[2]),WebInspector.Color._parseAlphaNumeric(hslaString[3])];var rgba=[];WebInspector.Color.hsl2rgb(hsla,rgba);return new WebInspector.Color(rgba,WebInspector.Color.Format.HSLA,text);}}
return null;};WebInspector.Color.fromRGBA=function(rgba)
{return new WebInspector.Color([rgba[0]/255,rgba[1]/255,rgba[2]/255,rgba[3]],WebInspector.Color.Format.RGBA);};WebInspector.Color.fromHSVA=function(hsva)
{var rgba=[];WebInspector.Color.hsva2rgba(hsva,rgba);return new WebInspector.Color(rgba,WebInspector.Color.Format.HSLA);};WebInspector.Color.prototype={format:function()
{return this._format;},hsla:function()
{if(this._hsla)
return this._hsla;var r=this._rgba[0];var g=this._rgba[1];var b=this._rgba[2];var max=Math.max(r,g,b);var min=Math.min(r,g,b);var diff=max-min;var add=max+min;if(min===max)
var h=0;else
if(r===max)
var h=(1/6*(g-b)/diff+1)%1;else
if(g===max)
var h=1/6*(b-r)/diff+1/3;else
var h=1/6*(r-g)/diff+2/3;var l=0.5*add;if(l===0)
var s=0;else
if(l===1)
var s=0;else
if(l<=0.5)
var s=diff/add;else
var s=diff/(2-add);this._hsla=[h,s,l,this._rgba[3]];return this._hsla;},canonicalHSLA:function()
{var hsla=this.hsla();return[Math.round(hsla[0]*360),Math.round(hsla[1]*100),Math.round(hsla[2]*100),hsla[3]];},hsva:function()
{var hsla=this.hsla();var h=hsla[0];var s=hsla[1];var l=hsla[2];s*=l<0.5?l:1-l;return[h,s!==0?2*s/(l+s):0,l+s,hsla[3]];},hasAlpha:function()
{return this._rgba[3]!==1;},canBeShortHex:function()
{if(this.hasAlpha())
return false;for(var i=0;i<3;++i){var c=Math.round(this._rgba[i]*255);if(c%17)
return false;}
return true;},asString:function(format)
{if(format===this._format&&this._originalTextIsValid)
return this._originalText;if(!format)
format=this._format;function toRgbValue(value)
{return Math.round(value*255);}
function toHexValue(value)
{var hex=Math.round(value*255).toString(16);return hex.length===1?"0"+hex:hex;}
function toShortHexValue(value)
{return(Math.round(value*255)/17).toString(16);}
switch(format){case WebInspector.Color.Format.Original:return this._originalText;case WebInspector.Color.Format.RGB:if(this.hasAlpha())
return null;return String.sprintf("rgb(%d, %d, %d)",toRgbValue(this._rgba[0]),toRgbValue(this._rgba[1]),toRgbValue(this._rgba[2]));case WebInspector.Color.Format.RGBA:return String.sprintf("rgba(%d, %d, %d, %f)",toRgbValue(this._rgba[0]),toRgbValue(this._rgba[1]),toRgbValue(this._rgba[2]),this._rgba[3]);case WebInspector.Color.Format.HSL:if(this.hasAlpha())
return null;var hsl=this.hsla();return String.sprintf("hsl(%d, %d%, %d%)",Math.round(hsl[0]*360),Math.round(hsl[1]*100),Math.round(hsl[2]*100));case WebInspector.Color.Format.HSLA:var hsla=this.hsla();return String.sprintf("hsla(%d, %d%, %d%, %f)",Math.round(hsla[0]*360),Math.round(hsla[1]*100),Math.round(hsla[2]*100),hsla[3]);case WebInspector.Color.Format.HEX:if(this.hasAlpha())
return null;return String.sprintf("#%s%s%s",toHexValue(this._rgba[0]),toHexValue(this._rgba[1]),toHexValue(this._rgba[2])).toLowerCase();case WebInspector.Color.Format.ShortHEX:if(!this.canBeShortHex())
return null;return String.sprintf("#%s%s%s",toShortHexValue(this._rgba[0]),toShortHexValue(this._rgba[1]),toShortHexValue(this._rgba[2])).toLowerCase();case WebInspector.Color.Format.Nickname:return this.nickname();}
return this._originalText;},rgba:function()
{return this._rgba.slice();},canonicalRGBA:function()
{var rgba=new Array(4);for(var i=0;i<3;++i)
rgba[i]=Math.round(this._rgba[i]*255);rgba[3]=this._rgba[3];return rgba;},nickname:function()
{if(!WebInspector.Color._rgbaToNickname){WebInspector.Color._rgbaToNickname={};for(var nickname in WebInspector.Color.Nicknames){var rgba=WebInspector.Color.Nicknames[nickname];if(rgba.length!==4)
rgba=rgba.concat(1);WebInspector.Color._rgbaToNickname[rgba]=nickname;}}
return WebInspector.Color._rgbaToNickname[this.canonicalRGBA()]||null;},toProtocolRGBA:function()
{var rgba=this.canonicalRGBA();var result={r:rgba[0],g:rgba[1],b:rgba[2]};if(rgba[3]!==1)
result.a=rgba[3];return result;},invert:function()
{var rgba=[];rgba[0]=1-this._rgba[0];rgba[1]=1-this._rgba[1];rgba[2]=1-this._rgba[2];rgba[3]=this._rgba[3];return new WebInspector.Color(rgba,WebInspector.Color.Format.RGBA);},setAlpha:function(alpha)
{var rgba=this._rgba.slice();rgba[3]=alpha;return new WebInspector.Color(rgba,WebInspector.Color.Format.RGBA);}};WebInspector.Color._parseRgbNumeric=function(value)
{var parsed=parseInt(value,10);if(value.indexOf("%")!==-1)
parsed/=100;else
parsed/=255;return parsed;};WebInspector.Color._parseHueNumeric=function(value)
{return isNaN(value)?0:parseFloat(value)/360%1;};WebInspector.Color._parseSatLightNumeric=function(value)
{return Math.min(1,parseFloat(value)/100);};WebInspector.Color._parseAlphaNumeric=function(value)
{return isNaN(value)?0:parseFloat(value);};WebInspector.Color._hsva2hsla=function(hsva,out_hsla)
{var h=hsva[0];var s=hsva[1];var v=hsva[2];var t=(2-s)*v;if(v===0||s===0)
s=0;else
s*=v/(t<1?t:2-t);out_hsla[0]=h;out_hsla[1]=s;out_hsla[2]=t/2;out_hsla[3]=hsva[3];};WebInspector.Color.hsl2rgb=function(hsl,out_rgb)
{var h=hsl[0];var s=hsl[1];var l=hsl[2];function hue2rgb(p,q,h)
{if(h<0)
h+=1;else
if(h>1)
h-=1;if(h*6<1)
return p+(q-p)*h*6;else
if(h*2<1)
return q;else
if(h*3<2)
return p+(q-p)*(2/3-h)*6;else
return p;}
if(s<0)
s=0;if(l<=0.5)
var q=l*(1+s);else
var q=l+s-l*s;var p=2*l-q;var tr=h+1/3;var tg=h;var tb=h-1/3;out_rgb[0]=hue2rgb(p,q,tr);out_rgb[1]=hue2rgb(p,q,tg);out_rgb[2]=hue2rgb(p,q,tb);out_rgb[3]=hsl[3];};WebInspector.Color.hsva2rgba=function(hsva,out_rgba)
{WebInspector.Color._hsva2hsla(hsva,WebInspector.Color.hsva2rgba._tmpHSLA);WebInspector.Color.hsl2rgb(WebInspector.Color.hsva2rgba._tmpHSLA,out_rgba);for(var i=0;i<WebInspector.Color.hsva2rgba._tmpHSLA.length;i++)
WebInspector.Color.hsva2rgba._tmpHSLA[i]=0;};WebInspector.Color.hsva2rgba._tmpHSLA=[0,0,0,0];WebInspector.Color.luminance=function(rgba)
{var rSRGB=rgba[0];var gSRGB=rgba[1];var bSRGB=rgba[2];var r=rSRGB<=0.03928?rSRGB/12.92:Math.pow((rSRGB+0.055)/1.055,2.4);var g=gSRGB<=0.03928?gSRGB/12.92:Math.pow((gSRGB+0.055)/1.055,2.4);var b=bSRGB<=0.03928?bSRGB/12.92:Math.pow((bSRGB+0.055)/1.055,2.4);return 0.2126*r+0.7152*g+0.0722*b;};WebInspector.Color.blendColors=function(fgRGBA,bgRGBA,out_blended)
{var alpha=fgRGBA[3];out_blended[0]=(1-alpha)*bgRGBA[0]+alpha*fgRGBA[0];out_blended[1]=(1-alpha)*bgRGBA[1]+alpha*fgRGBA[1];out_blended[2]=(1-alpha)*bgRGBA[2]+alpha*fgRGBA[2];out_blended[3]=alpha+bgRGBA[3]*(1-alpha);};WebInspector.Color.calculateContrastRatio=function(fgRGBA,bgRGBA)
{WebInspector.Color.blendColors(fgRGBA,bgRGBA,WebInspector.Color.calculateContrastRatio._blendedFg);var fgLuminance=WebInspector.Color.luminance(WebInspector.Color.calculateContrastRatio._blendedFg);var bgLuminance=WebInspector.Color.luminance(bgRGBA);var contrastRatio=(Math.max(fgLuminance,bgLuminance)+0.05)/(Math.min(fgLuminance,bgLuminance)+0.05);for(var i=0;i<WebInspector.Color.calculateContrastRatio._blendedFg.length;i++)
WebInspector.Color.calculateContrastRatio._blendedFg[i]=0;return contrastRatio;};WebInspector.Color.calculateContrastRatio._blendedFg=[0,0,0,0];WebInspector.Color.desiredLuminance=function(luminance,contrast,lighter)
{function computeLuminance()
{if(lighter)
return(luminance+0.05)*contrast-0.05;else
return(luminance+0.05)/contrast-0.05;}
var desiredLuminance=computeLuminance();if(desiredLuminance<0||desiredLuminance>1){lighter=!lighter;desiredLuminance=computeLuminance();}
return desiredLuminance;};WebInspector.Color.Nicknames={"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aqua":[0,255,255],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"black":[0,0,0],"blanchedalmond":[255,235,205],"blue":[0,0,255],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[237,20,61],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgrey":[169,169,169],"darkgreen":[0,100,0],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"fuchsia":[255,0,255],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"gray":[128,128,128],"grey":[128,128,128],"green":[0,128,0],"greenyellow":[173,255,47],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgreen":[144,238,144],"lightgray":[211,211,211],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"lime":[0,255,0],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"maroon":[128,0,0],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"navy":[0,0,128],"oldlace":[253,245,230],"olive":[128,128,0],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"purple":[128,0,128],"rebeccapurple":[102,51,153],"red":[255,0,0],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"silver":[192,192,192],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"teal":[0,128,128],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"white":[255,255,255],"whitesmoke":[245,245,245],"yellow":[255,255,0],"yellowgreen":[154,205,50],"transparent":[0,0,0,0]};WebInspector.Color.PageHighlight={Content:WebInspector.Color.fromRGBA([111,168,220,.66]),ContentLight:WebInspector.Color.fromRGBA([111,168,220,.5]),ContentOutline:WebInspector.Color.fromRGBA([9,83,148]),Padding:WebInspector.Color.fromRGBA([147,196,125,.55]),PaddingLight:WebInspector.Color.fromRGBA([147,196,125,.4]),Border:WebInspector.Color.fromRGBA([255,229,153,.66]),BorderLight:WebInspector.Color.fromRGBA([255,229,153,.5]),Margin:WebInspector.Color.fromRGBA([246,178,107,.66]),MarginLight:WebInspector.Color.fromRGBA([246,178,107,.5]),EventTarget:WebInspector.Color.fromRGBA([255,196,196,.66]),Shape:WebInspector.Color.fromRGBA([96,82,177,0.8]),ShapeMargin:WebInspector.Color.fromRGBA([96,82,127,.6])};WebInspector.Color.detectColorFormat=function(color)
{const cf=WebInspector.Color.Format;var format;var formatSetting=WebInspector.moduleSetting("colorFormat").get();if(formatSetting===cf.Original)
format=cf.Original;else
if(formatSetting===cf.RGB)
format=color.hasAlpha()?cf.RGBA:cf.RGB;else
if(formatSetting===cf.HSL)
format=color.hasAlpha()?cf.HSLA:cf.HSL;else
if(!color.hasAlpha())
format=color.canBeShortHex()?cf.ShortHEX:cf.HEX;else
format=cf.RGBA;return format;};},{}],101:[function(require,module,exports){WebInspector.Object=function(){};WebInspector.Object.prototype={addEventListener:function(eventType,listener,thisObject)
{if(!listener)
console.assert(false);if(!this._listeners)
this._listeners=new Map();if(!this._listeners.has(eventType))
this._listeners.set(eventType,[]);this._listeners.get(eventType).push({thisObject:thisObject,listener:listener});return new WebInspector.EventTarget.EventDescriptor(this,eventType,thisObject,listener);},removeEventListener:function(eventType,listener,thisObject)
{console.assert(listener);if(!this._listeners||!this._listeners.has(eventType))
return;var listeners=this._listeners.get(eventType);for(var i=0;i<listeners.length;++i){if(listeners[i].listener===listener&&listeners[i].thisObject===thisObject)
listeners.splice(i--,1);}
if(!listeners.length)
this._listeners.delete(eventType);},removeAllListeners:function()
{delete this._listeners;},hasEventListeners:function(eventType)
{return this._listeners&&this._listeners.has(eventType);},dispatchEventToListeners:function(eventType,eventData)
{if(!this._listeners||!this._listeners.has(eventType))
return false;var event=new WebInspector.Event(this,eventType,eventData);var listeners=this._listeners.get(eventType).slice(0);for(var i=0;i<listeners.length;++i){listeners[i].listener.call(listeners[i].thisObject,event);if(event._stoppedPropagation)
break;}
return event.defaultPrevented;}};WebInspector.Event=function(target,type,data)
{this.target=target;this.type=type;this.data=data;this.defaultPrevented=false;this._stoppedPropagation=false;};WebInspector.Event.prototype={stopPropagation:function()
{this._stoppedPropagation=true;},preventDefault:function()
{this.defaultPrevented=true;},consume:function(preventDefault)
{this.stopPropagation();if(preventDefault)
this.preventDefault();}};WebInspector.EventTarget=function()
{};WebInspector.EventTarget.removeEventListeners=function(eventList)
{for(var i=0;i<eventList.length;++i){var eventInfo=eventList[i];eventInfo.eventTarget.removeEventListener(eventInfo.eventType,eventInfo.method,eventInfo.receiver);}
eventList.splice(0,eventList.length);};WebInspector.EventTarget.prototype={addEventListener:function(eventType,listener,thisObject){},removeEventListener:function(eventType,listener,thisObject){},removeAllListeners:function(){},hasEventListeners:function(eventType){},dispatchEventToListeners:function(eventType,eventData){}};WebInspector.EventTarget.EventDescriptor=function(eventTarget,eventType,receiver,method)
{this.eventTarget=eventTarget;this.eventType=eventType;this.receiver=receiver;this.method=method;};},{}],102:[function(require,module,exports){WebInspector.ParsedURL=function(url)
{this.isValid=false;this.url=url;this.scheme="";this.host="";this.port="";this.path="";this.queryParams="";this.fragment="";this.folderPathComponents="";this.lastPathComponent="";var match=url.match(/^([A-Za-z][A-Za-z0-9+.-]*):\/\/([^\s\/:]*)(?::([\d]+))?(?:(\/[^#]*)(?:#(.*))?)?$/i);if(match){this.isValid=true;this.scheme=match[1].toLowerCase();this.host=match[2];this.port=match[3];this.path=match[4]||"/";this.fragment=match[5];}else{if(this.url.startsWith("data:")){this.scheme="data";return;}
if(this.url==="about:blank"){this.scheme="about";return;}
this.path=this.url;}
var path=this.path;var indexOfQuery=path.indexOf("?");if(indexOfQuery!==-1){this.queryParams=path.substring(indexOfQuery+1);path=path.substring(0,indexOfQuery);}
var lastSlashIndex=path.lastIndexOf("/");if(lastSlashIndex!==-1){this.folderPathComponents=path.substring(0,lastSlashIndex);this.lastPathComponent=path.substring(lastSlashIndex+1);}else
this.lastPathComponent=path;};WebInspector.ParsedURL.splitURLIntoPathComponents=function(url)
{if(url.startsWith("/"))
url="file://"+url;var parsedURL=new WebInspector.ParsedURL(url);var origin;var folderPath;var name;if(parsedURL.isValid){origin=parsedURL.scheme+"://"+parsedURL.host;if(parsedURL.port)
origin+=":"+parsedURL.port;folderPath=parsedURL.folderPathComponents;name=parsedURL.lastPathComponent;if(parsedURL.queryParams)
name+="?"+parsedURL.queryParams;}else{origin="";folderPath="";name=url;}
var result=[origin];var splittedPath=folderPath.split("/");for(var i=1;i<splittedPath.length;++i){if(!splittedPath[i])
continue;result.push(splittedPath[i]);}
result.push(name);return result;};WebInspector.ParsedURL.extractOrigin=function(url)
{var parsedURL=new WebInspector.ParsedURL(url);if(!parsedURL.isValid)
return"";var origin=parsedURL.scheme+"://"+parsedURL.host;if(parsedURL.port)
origin+=":"+parsedURL.port;return origin;};WebInspector.ParsedURL.extractExtension=function(url)
{var lastIndexOfDot=url.lastIndexOf(".");var extension=lastIndexOfDot!==-1?url.substr(lastIndexOfDot+1):"";var indexOfQuestionMark=extension.indexOf("?");if(indexOfQuestionMark!==-1)
extension=extension.substr(0,indexOfQuestionMark);return extension;};WebInspector.ParsedURL.extractName=function(url)
{var index=url.lastIndexOf("/");return index!==-1?url.substr(index+1):url;};WebInspector.ParsedURL.completeURL=function(baseURL,href)
{if(href){var trimmedHref=href.trim();if(trimmedHref.startsWith("data:")||trimmedHref.startsWith("blob:")||trimmedHref.startsWith("javascript:"))
return href;var parsedHref=trimmedHref.asParsedURL();if(parsedHref&&parsedHref.scheme)
return trimmedHref;}else{return baseURL;}
var parsedURL=baseURL.asParsedURL();if(parsedURL){if(parsedURL.isDataURL())
return href;var path=href;var query=path.indexOf("?");var postfix="";if(query!==-1){postfix=path.substring(query);path=path.substring(0,query);}else{var fragment=path.indexOf("#");if(fragment!==-1){postfix=path.substring(fragment);path=path.substring(0,fragment);}}
if(!path){var basePath=parsedURL.path;if(postfix.charAt(0)==="?"){var baseQuery=parsedURL.path.indexOf("?");if(baseQuery!==-1)
basePath=basePath.substring(0,baseQuery);}
return parsedURL.scheme+"://"+parsedURL.host+(parsedURL.port?":"+parsedURL.port:"")+basePath+postfix;}else if(path.charAt(0)!=="/"){var prefix=parsedURL.path;var prefixQuery=prefix.indexOf("?");if(prefixQuery!==-1)
prefix=prefix.substring(0,prefixQuery);prefix=prefix.substring(0,prefix.lastIndexOf("/"))+"/";path=prefix+path;}else if(path.length>1&&path.charAt(1)==="/"){return parsedURL.scheme+":"+path+postfix;}
return parsedURL.scheme+"://"+parsedURL.host+(parsedURL.port?":"+parsedURL.port:"")+Runtime.normalizePath(path)+postfix;}
return null;};WebInspector.ParsedURL.prototype={get displayName()
{if(this._displayName)
return this._displayName;if(this.isDataURL())
return this.dataURLDisplayName();if(this.isAboutBlank())
return this.url;this._displayName=this.lastPathComponent;if(!this._displayName)
this._displayName=(this.host||"")+"/";if(this._displayName==="/")
this._displayName=this.url;return this._displayName;},dataURLDisplayName:function()
{if(this._dataURLDisplayName)
return this._dataURLDisplayName;if(!this.isDataURL())
return"";this._dataURLDisplayName=this.url.trimEnd(20);return this._dataURLDisplayName;},isAboutBlank:function()
{return this.url==="about:blank";},isDataURL:function()
{return this.scheme==="data";},lastPathComponentWithFragment:function()
{return this.lastPathComponent+(this.fragment?"#"+this.fragment:"");},domain:function()
{if(this.isDataURL())
return"data:";return this.host+(this.port?":"+this.port:"");},securityOrigin:function()
{if(this.isDataURL())
return"data:";return this.scheme+"://"+this.domain();},urlWithoutScheme:function()
{if(this.scheme&&this.url.startsWith(this.scheme+"://"))
return this.url.substring(this.scheme.length+3);return this.url;}};WebInspector.ParsedURL.splitLineAndColumn=function(string)
{var lineColumnRegEx=/(?::(\d+))?(?::(\d+))?$/;var lineColumnMatch=lineColumnRegEx.exec(string);var lineNumber;var columnNumber;console.assert(lineColumnMatch);if(typeof lineColumnMatch[1]==="string"){lineNumber=parseInt(lineColumnMatch[1],10);lineNumber=isNaN(lineNumber)?undefined:lineNumber-1;}
if(typeof lineColumnMatch[2]==="string"){columnNumber=parseInt(lineColumnMatch[2],10);columnNumber=isNaN(columnNumber)?undefined:columnNumber-1;}
return{url:string.substring(0,string.length-lineColumnMatch[0].length),lineNumber:lineNumber,columnNumber:columnNumber};};WebInspector.ParsedURL.isRelativeURL=function(url)
{return!/^[A-Za-z][A-Za-z0-9+.-]*:/.test(url);};String.prototype.asParsedURL=function()
{var parsedURL=new WebInspector.ParsedURL(this.toString());if(parsedURL.isValid)
return parsedURL;return null;};},{}],103:[function(require,module,exports){WebInspector.ResourceType=function(name,title,category,isTextType)
{this._name=name;this._title=title;this._category=category;this._isTextType=isTextType;};WebInspector.ResourceType.prototype={name:function()
{return this._name;},title:function()
{return this._title;},category:function()
{return this._category;},isTextType:function()
{return this._isTextType;},isScript:function()
{return this._name==="script"||this._name==="sm-script";},hasScripts:function()
{return this.isScript()||this.isDocument();},isStyleSheet:function()
{return this._name==="stylesheet"||this._name==="sm-stylesheet";},isDocument:function()
{return this._name==="document";},isDocumentOrScriptOrStyleSheet:function()
{return this.isDocument()||this.isScript()||this.isStyleSheet();},isFromSourceMap:function()
{return this._name.startsWith("sm-");},toString:function()
{return this._name;},canonicalMimeType:function()
{if(this.isDocument())
return"text/html";if(this.isScript())
return"text/javascript";if(this.isStyleSheet())
return"text/css";return"";}};WebInspector.ResourceCategory=function(title,shortTitle)
{this.title=title;this.shortTitle=shortTitle;};WebInspector.resourceCategories={XHR:new WebInspector.ResourceCategory("XHR and Fetch","XHR"),Script:new WebInspector.ResourceCategory("Scripts","JS"),Stylesheet:new WebInspector.ResourceCategory("Stylesheets","CSS"),Image:new WebInspector.ResourceCategory("Images","Img"),Media:new WebInspector.ResourceCategory("Media","Media"),Font:new WebInspector.ResourceCategory("Fonts","Font"),Document:new WebInspector.ResourceCategory("Documents","Doc"),WebSocket:new WebInspector.ResourceCategory("WebSockets","WS"),Manifest:new WebInspector.ResourceCategory("Manifest","Manifest"),Other:new WebInspector.ResourceCategory("Other","Other")};WebInspector.resourceTypes={XHR:new WebInspector.ResourceType("xhr","XHR",WebInspector.resourceCategories.XHR,true),Fetch:new WebInspector.ResourceType("fetch","Fetch",WebInspector.resourceCategories.XHR,true),EventSource:new WebInspector.ResourceType("eventsource","EventSource",WebInspector.resourceCategories.XHR,true),Script:new WebInspector.ResourceType("script","Script",WebInspector.resourceCategories.Script,true),Stylesheet:new WebInspector.ResourceType("stylesheet","Stylesheet",WebInspector.resourceCategories.Stylesheet,true),Image:new WebInspector.ResourceType("image","Image",WebInspector.resourceCategories.Image,false),Media:new WebInspector.ResourceType("media","Media",WebInspector.resourceCategories.Medi