WebInspector.CountersGraph=function(delegate,model,filters)
{WebInspector.VBox.call(this);this.element.id="memory-graphs-container";this._delegate=delegate;this._model=model;this._filters=filters;this._calculator=new WebInspector.CounterGraphCalculator(this._model);this._infoWidget=new WebInspector.HBox();this._infoWidget.element.classList.add("memory-counter-selector-swatches","timeline-toolbar-resizer");this._infoWidget.show(this.element);this._graphsContainer=new WebInspector.VBox();this._graphsContainer.show(this.element);var canvasWidget=new WebInspector.VBoxWithResizeCallback(this._resize.bind(this));canvasWidget.show(this._graphsContainer.element);this._createCurrentValuesBar();this._canvasContainer=canvasWidget.element;this._canvasContainer.id="memory-graphs-canvas-container";this._canvas=this._canvasContainer.createChild("canvas");this._canvas.id="memory-counters-graph";this._canvasContainer.addEventListener("mouseover",this._onMouseMove.bind(this),true);this._canvasContainer.addEventListener("mousemove",this._onMouseMove.bind(this),true);this._canvasContainer.addEventListener("mouseleave",this._onMouseLeave.bind(this),true);this._canvasContainer.addEventListener("click",this._onClick.bind(this),true);this._timelineGrid=new WebInspector.TimelineGrid();this._canvasContainer.appendChild(this._timelineGrid.dividersElement);this._counters=[];this._counterUI=[];}
WebInspector.CountersGraph.prototype={_createCurrentValuesBar:function()
{this._currentValuesBar=this._graphsContainer.element.createChild("div");this._currentValuesBar.id="counter-values-bar";},createCounter:function(uiName,uiValueTemplate,color,formatter)
{var counter=new WebInspector.CountersGraph.Counter();this._counters.push(counter);this._counterUI.push(new WebInspector.CountersGraph.CounterUI(this,uiName,uiValueTemplate,color,counter,formatter));return counter;},view:function()
{return this;},dispose:function()
{},reset:function()
{for(var i=0;i<this._counters.length;++i){this._counters[i].reset();this._counterUI[i].reset();}
this.refresh();},resizerElement:function()
{return this._infoWidget.element;},_resize:function()
{var parentElement=this._canvas.parentElement;this._canvas.width=parentElement.clientWidth*window.devicePixelRatio;this._canvas.height=parentElement.clientHeight*window.devicePixelRatio;var timelinePaddingLeft=15;this._calculator.setDisplayWindow(this._canvas.width,timelinePaddingLeft);this.refresh();},setWindowTimes:function(startTime,endTime)
{this._calculator.setWindow(startTime,endTime);this.scheduleRefresh();},scheduleRefresh:function()
{WebInspector.invokeOnceAfterBatchUpdate(this,this.refresh);},draw:function()
{for(var i=0;i<this._counters.length;++i){this._counters[i]._calculateVisibleIndexes(this._calculator);this._counters[i]._calculateXValues(this._canvas.width);}
this._clear();for(var i=0;i<this._counterUI.length;i++)
this._counterUI[i]._drawGraph(this._canvas);},_onClick:function(event)
{var x=event.x-this._canvasContainer.totalOffsetLeft();var minDistance=Infinity;var bestTime;for(var i=0;i<this._counterUI.length;++i){var counterUI=this._counterUI[i];if(!counterUI.counter.times.length)
continue;var index=counterUI._recordIndexAt(x);var distance=Math.abs(x*window.devicePixelRatio-counterUI.counter.x[index]);if(distance<minDistance){minDistance=distance;bestTime=counterUI.counter.times[index];}}
if(bestTime!==undefined)
this._delegate.selectEntryAtTime(bestTime);},_onMouseLeave:function(event)
{delete this._markerXPosition;this._clearCurrentValueAndMarker();},_clearCurrentValueAndMarker:function()
{for(var i=0;i<this._counterUI.length;i++)
this._counterUI[i]._clearCurrentValueAndMarker();},_onMouseMove:function(event)
{var x=event.x-this._canvasContainer.totalOffsetLeft();this._markerXPosition=x;this._refreshCurrentValues();},_refreshCurrentValues:function()
{if(this._markerXPosition===undefined)
return;for(var i=0;i<this._counterUI.length;++i)
this._counterUI[i].updateCurrentValue(this._markerXPosition);},refresh:function()
{this._timelineGrid.updateDividers(this._calculator);this.draw();this._refreshCurrentValues();},refreshRecords:function(){},_clear:function()
{var ctx=this._canvas.getContext("2d");ctx.clearRect(0,0,ctx.canvas.width,ctx.canvas.height);},highlightSearchResult:function(event,regex,select)
{},highlightEvent:function(event)
{},setSelection:function(selection)
{},__proto__:WebInspector.VBox.prototype}
WebInspector.CountersGraph.Counter=function()
{this.times=[];this.values=[];}
WebInspector.CountersGraph.Counter.prototype={appendSample:function(time,value)
{if(this.values.length&&this.values.peekLast()===value)
return;this.times.push(time);this.values.push(value);},reset:function()
{this.times=[];this.values=[];},setLimit:function(value)
{this._limitValue=value;},_calculateBounds:function()
{var maxValue;var minValue;for(var i=this._minimumIndex;i<=this._maximumIndex;i++){var value=this.values[i];if(minValue===undefined||value<minValue)
minValue=value;if(maxValue===undefined||value>maxValue)
maxValue=value;}
minValue=minValue||0;maxValue=maxValue||1;if(this._limitValue){if(maxValue>this._limitValue*0.5)
maxValue=Math.max(maxValue,this._limitValue);minValue=Math.min(minValue,this._limitValue);}
return{min:minValue,max:maxValue};},_calculateVisibleIndexes:function(calculator)
{var start=calculator.minimumBoundary();var end=calculator.maximumBoundary();this._minimumIndex=Number.constrain(this.times.upperBound(start)-1,0,this.times.length-1);this._maximumIndex=Number.constrain(this.times.lowerBound(end),0,this.times.length-1);this._minTime=start;this._maxTime=end;},_calculateXValues:function(width)
{if(!this.values.length)
return;var xFactor=width/(this._maxTime-this._minTime);this.x=new Array(this.values.length);for(var i=this._minimumIndex+1;i<=this._maximumIndex;i++)
this.x[i]=xFactor*(this.times[i]-this._minTime);}}
WebInspector.CountersGraph.CounterUI=function(memoryCountersPane,title,currentValueLabel,graphColor,counter,formatter)
{this._memoryCountersPane=memoryCountersPane;this.counter=counter;this._formatter=formatter||Number.withThousandsSeparator;var container=memoryCountersPane._infoWidget.element.createChild("div","memory-counter-selector-info");this._setting=WebInspector.settings.createSetting("timelineCountersGraph-"+title,true);this._filter=new WebInspector.ToolbarCheckbox(title,title,this._setting);this._filter.inputElement.classList.add("-theme-preserve");var color=WebInspector.Color.parse(graphColor).setAlpha(0.5).asString(WebInspector.Color.Format.RGBA);if(color){this._filter.element.backgroundColor=color;this._filter.element.borderColor="transparent";}
this._filter.inputElement.addEventListener("click",this._toggleCounterGraph.bind(this));container.appendChild(this._filter.element);this._range=this._filter.element.createChild("span","range");this._value=memoryCountersPane._currentValuesBar.createChild("span","memory-counter-value");this._value.style.color=graphColor;this.graphColor=graphColor;this.limitColor=WebInspector.Color.parse(graphColor).setAlpha(0.3).asString(WebInspector.Color.Format.RGBA);this.graphYValues=[];this._verticalPadding=10;this._currentValueLabel=currentValueLabel;this._marker=memoryCountersPane._canvasContainer.createChild("div","memory-counter-marker");this._marker.style.backgroundColor=graphColor;this._clearCurrentValueAndMarker();}
WebInspector.CountersGraph.CounterUI.prototype={reset:function()
{this._range.textContent="";},setRange:function(minValue,maxValue)
{var min=this._formatter(minValue);var max=this._formatter(maxValue);this._range.textContent=WebInspector.UIString("[%s\u2009\u2013\u2009%s]",min,max);},_toggleCounterGraph:function(event)
{this._value.classList.toggle("hidden",!this._filter.checked());this._memoryCountersPane.refresh();},_recordIndexAt:function(x)
{return this.counter.x.upperBound(x*window.devicePixelRatio,null,this.counter._minimumIndex+1,this.counter._maximumIndex+1)-1;},updateCurrentValue:function(x)
{if(!this.visible()||!this.counter.values.length||!this.counter.x)
return;var index=this._recordIndexAt(x);var value=Number.withThousandsSeparator(this.counter.values[index]);this._value.textContent=WebInspector.UIString(this._currentValueLabel,value);var y=this.graphYValues[index]/window.devicePixelRatio;this._marker.style.left=x+"px";this._marker.style.top=y+"px";this._marker.classList.remove("hidden");},_clearCurrentValueAndMarker:function()
{this._value.textContent="";this._marker.classList.add("hidden");},_drawGraph:function(canvas)
{var ctx=canvas.getContext("2d");var width=canvas.width;var height=canvas.height-2*this._verticalPadding;if(height<=0){this.graphYValues=[];return;}
var originY=this._verticalPadding;var counter=this.counter;var values=counter.values;if(!values.length)
return;var bounds=counter._calculateBounds();var minValue=bounds.min;var maxValue=bounds.max;this.setRange(minValue,maxValue);if(!this.visible())
return;var yValues=this.graphYValues;var maxYRange=maxValue-minValue;var yFactor=maxYRange?height/(maxYRange):1;ctx.save();ctx.lineWidth=window.devicePixelRatio;if(ctx.lineWidth%2)
ctx.translate(0.5,0.5);ctx.beginPath();var value=values[counter._minimumIndex];var currentY=Math.round(originY+height-(value-minValue)*yFactor);ctx.moveTo(0,currentY);for(var i=counter._minimumIndex;i<=counter._maximumIndex;i++){var x=Math.round(counter.x[i]);ctx.lineTo(x,currentY);var currentValue=values[i];if(typeof currentValue!=="undefined")
value=currentValue;currentY=Math.round(originY+height-(value-minValue)*yFactor);ctx.lineTo(x,currentY);yValues[i]=currentY;}
yValues.length=i;ctx.lineTo(width,currentY);ctx.strokeStyle=this.graphColor;ctx.stroke();if(counter._limitValue){var limitLineY=Math.round(originY+height-(counter._limitValue-minValue)*yFactor);ctx.moveTo(0,limitLineY);ctx.lineTo(width,limitLineY);ctx.strokeStyle=this.limitColor;ctx.stroke();}
ctx.closePath();ctx.restore();},visible:function()
{return this._filter.checked();}}
WebInspector.CounterGraphCalculator=function(model)
{this._model=model;}
WebInspector.CounterGraphCalculator._minWidth=5;WebInspector.CounterGraphCalculator.prototype={paddingLeft:function()
{return this._paddingLeft;},computePosition:function(time)
{return(time-this._minimumBoundary)/this.boundarySpan()*this._workingArea+this._paddingLeft;},setWindow:function(minimumBoundary,maximumBoundary)
{this._minimumBoundary=minimumBoundary;this._maximumBoundary=maximumBoundary;},setDisplayWindow:function(clientWidth,paddingLeft)
{this._paddingLeft=paddingLeft||0;this._workingArea=clientWidth-WebInspector.CounterGraphCalculator._minWidth-this._paddingLeft;},formatValue:function(value,precision)
{return Number.preciseMillisToString(value-this.zeroTime(),precision);},maximumBoundary:function()
{return this._maximumBoundary;},minimumBoundary:function()
{return this._minimumBoundary;},zeroTime:function()
{return this._model.minimumRecordTime();},boundarySpan:function()
{return this._maximumBoundary-this._minimumBoundary;}};WebInspector.MemoryCountersGraph=function(delegate,model,filters)
{WebInspector.CountersGraph.call(this,delegate,model,filters);this._countersByName={};this._countersByName["jsHeapSizeUsed"]=this.createCounter(WebInspector.UIString("JS Heap"),WebInspector.UIString("JS Heap: %s"),"hsl(220, 90%, 43%)",Number.bytesToString);this._countersByName["documents"]=this.createCounter(WebInspector.UIString("Documents"),WebInspector.UIString("Documents: %s"),"hsl(0, 90%, 43%)");this._countersByName["nodes"]=this.createCounter(WebInspector.UIString("Nodes"),WebInspector.UIString("Nodes: %s"),"hsl(120, 90%, 43%)");this._countersByName["jsEventListeners"]=this.createCounter(WebInspector.UIString("Listeners"),WebInspector.UIString("Listeners: %s"),"hsl(38, 90%, 43%)");this._gpuMemoryCounter=this.createCounter(WebInspector.UIString("GPU Memory"),WebInspector.UIString("GPU Memory [KB]: %s"),"hsl(300, 90%, 43%)",Number.bytesToString);this._countersByName["gpuMemoryUsedKB"]=this._gpuMemoryCounter;}
WebInspector.MemoryCountersGraph.prototype={refreshRecords:function()
{this.reset();var events=this._model.mainThreadEvents();for(var i=0;i<events.length;++i){var event=events[i];if(event.name!==WebInspector.TimelineModel.RecordType.UpdateCounters)
continue;var counters=event.args.data;if(!counters)
return;for(var name in counters){var counter=this._countersByName[name];if(counter)
counter.appendSample(event.startTime,counters[name]);}
var gpuMemoryLimitCounterName="gpuMemoryLimitKB";if(gpuMemoryLimitCounterName in counters)
this._gpuMemoryCounter.setLimit(counters[gpuMemoryLimitCounterName]);}
this.scheduleRefresh();},__proto__:WebInspector.CountersGraph.prototype};WebInspector.TimelineController=function(target,delegate,tracingModel)
{this._delegate=delegate;this._target=target;this._tracingModel=tracingModel;this._targets=[];WebInspector.targetManager.observeTargets(this);}
WebInspector.TimelineController.prototype={startRecording:function(captureCauses,enableJSSampling,captureMemory,capturePictures,captureFilmStrip)
{this._extensionTraceProviders=WebInspector.extensionServer.traceProviders().slice();function disabledByDefault(category)
{return"disabled-by-default-"+category;}
var categoriesArray=["-*","devtools.timeline","v8.execute",disabledByDefault("devtools.timeline"),disabledByDefault("devtools.timeline.frame"),WebInspector.TracingModel.TopLevelEventCategory,WebInspector.TimelineModel.Category.Console,WebInspector.TimelineModel.Category.UserTiming];categoriesArray.push(WebInspector.TimelineModel.Category.LatencyInfo)
if(Runtime.experiments.isEnabled("timelineFlowEvents")){categoriesArray.push(disabledByDefault("toplevel.flow"),disabledByDefault("ipc.flow"));}
if(Runtime.experiments.isEnabled("timelineTracingJSProfile")&&enableJSSampling){categoriesArray.push(disabledByDefault("v8.cpu_profiler"));if(WebInspector.moduleSetting("highResolutionCpuProfiling").get())
categoriesArray.push(disabledByDefault("v8.cpu_profiler.hires"));}
if(captureCauses||enableJSSampling)
categoriesArray.push(disabledByDefault("devtools.timeline.stack"));if(captureCauses&&Runtime.experiments.isEnabled("timelineInvalidationTracking"))
categoriesArray.push(disabledByDefault("devtools.timeline.invalidationTracking"));if(capturePictures){categoriesArray.push(disabledByDefault("devtools.timeline.layers"),disabledByDefault("devtools.timeline.picture"),disabledByDefault("blink.graphics_context_annotations"));}
if(captureFilmStrip)
categoriesArray.push(disabledByDefault("devtools.screenshot"));for(var traceProvider of this._extensionTraceProviders)
traceProvider.start();var categories=categoriesArray.join(",");this._startRecordingWithCategories(categories,enableJSSampling);},stopRecording:function()
{var tracingStoppedPromises=[];tracingStoppedPromises.push(new Promise(resolve=>this._tracingCompleteCallback=resolve));tracingStoppedPromises.push(this._stopProfilingOnAllTargets());this._target.tracingManager.stop();tracingStoppedPromises.push(WebInspector.targetManager.resumeAllTargets());Promise.all(tracingStoppedPromises).then(()=>this._allSourcesFinished());this._delegate.loadingStarted();for(var traceProvider of this._extensionTraceProviders)
traceProvider.stop();},targetAdded:function(target)
{this._targets.push(target);if(this._profiling)
this._startProfilingOnTarget(target);},targetRemoved:function(target)
{this._targets.remove(target,true);},_startProfilingOnTarget:function(target)
{return target.hasJSCapability()?target.profilerAgent().start():Promise.resolve();},_startProfilingOnAllTargets:function()
{var intervalUs=WebInspector.moduleSetting("highResolutionCpuProfiling").get()?100:1000;this._target.profilerAgent().setSamplingInterval(intervalUs);this._profiling=true;return Promise.all(this._targets.map(this._startProfilingOnTarget));},_stopProfilingOnTarget:function(target)
{return target.hasJSCapability()?target.profilerAgent().stop(this._addCpuProfile.bind(this,target.id())):Promise.resolve();},_addCpuProfile:function(targetId,error,cpuProfile)
{if(!cpuProfile){WebInspector.console.warn(WebInspector.UIString("CPU profile for a target is not available. %s",error||""));return;}
if(!this._cpuProfiles)
this._cpuProfiles=new Map();this._cpuProfiles.set(targetId,cpuProfile);},_stopProfilingOnAllTargets:function()
{var targets=this._profiling?this._targets:[];this._profiling=false;return Promise.all(targets.map(this._stopProfilingOnTarget,this));},_startRecordingWithCategories:function(categories,enableJSSampling,callback)
{WebInspector.targetManager.suspendAllTargets();var profilingStartedPromise=enableJSSampling&&!Runtime.experiments.isEnabled("timelineTracingJSProfile")?this._startProfilingOnAllTargets():Promise.resolve();var samplingFrequencyHz=WebInspector.moduleSetting("highResolutionCpuProfiling").get()?10000:1000;var options="sampling-frequency="+samplingFrequencyHz;var target=this._target;var tracingManager=target.tracingManager;WebInspector.targetManager.suspendReload(target);profilingStartedPromise.then(tracingManager.start.bind(tracingManager,this,categories,options,onTraceStarted));function onTraceStarted(error)
{WebInspector.targetManager.resumeReload(target);if(callback)
callback(error);}},tracingStarted:function()
{this._tracingModel.reset();this._delegate.recordingStarted();},traceEventsCollected:function(events)
{this._tracingModel.addEvents(events);},tracingComplete:function()
{this._tracingCompleteCallback();this._tracingCompleteCallback=null;},_allSourcesFinished:function()
{this._injectCpuProfileEvents();this._tracingModel.tracingComplete();this._delegate.loadingComplete(true);},_injectCpuProfileEvent:function(pid,tid,cpuProfile)
{if(!cpuProfile)
return;var cpuProfileEvent=({cat:WebInspector.TracingModel.DevToolsMetadataEventCategory,ph:WebInspector.TracingModel.Phase.Instant,ts:this._tracingModel.maximumRecordTime()*1000,pid:pid,tid:tid,name:WebInspector.TimelineModel.RecordType.CpuProfile,args:{data:{cpuProfile:cpuProfile}}});this._tracingModel.addEvents([cpuProfileEvent]);},_injectCpuProfileEvents:function()
{if(!this._cpuProfiles)
return;var metadataEventTypes=WebInspector.TimelineModel.DevToolsMetadataEvent;var metadataEvents=this._tracingModel.devToolsMetadataEvents();var mainMetaEvent=metadataEvents.filter(event=>event.name===metadataEventTypes.TracingStartedInPage).peekLast();if(!mainMetaEvent)
return;var pid=mainMetaEvent.thread.process().id();var mainCpuProfile=this._cpuProfiles.get(this._target.id());this._injectCpuProfileEvent(pid,mainMetaEvent.thread.id(),mainCpuProfile);var workerMetaEvents=metadataEvents.filter(event=>event.name===metadataEventTypes.TracingSessionIdForWorker);for(var metaEvent of workerMetaEvents){var workerId=metaEvent.args["data"]["workerId"];var workerTarget=this._target.workerManager?this._target.workerManager.targetByWorkerId(workerId):null;if(!workerTarget)
continue;var cpuProfile=this._cpuProfiles.get(workerTarget.id());this._injectCpuProfileEvent(pid,metaEvent.args["data"]["workerThreadId"],cpuProfile);}
this._cpuProfiles=null;},tracingBufferUsage:function(usage)
{this._delegate.recordingProgress(usage);},eventsRetrievalProgress:function(progress)
{this._delegate.loadingProgress(progress);}};WebInspector.TimelineLoader=function(model,delegate)
{this._model=model;this._delegate=delegate;this._canceledCallback=null;this._state=WebInspector.TimelineLoader.State.Initial;this._buffer="";this._firstChunk=true;this._loadedBytes=0;this._totalSize;this._jsonTokenizer=new WebInspector.TextUtils.BalancedJSONTokenizer(this._writeBalancedJSON.bind(this),true);}
WebInspector.TimelineLoader.loadFromFile=function(model,file,delegate)
{var loader=new WebInspector.TimelineLoader(model,delegate);var fileReader=WebInspector.TimelineLoader._createFileReader(file,loader);loader._canceledCallback=fileReader.cancel.bind(fileReader);loader._totalSize=file.size;fileReader.start(loader);return loader;}
WebInspector.TimelineLoader.loadFromURL=function(model,url,delegate)
{var stream=new WebInspector.TimelineLoader(model,delegate);WebInspector.ResourceLoader.loadAsStream(url,null,stream);return stream;}
WebInspector.TimelineLoader.TransferChunkLengthBytes=5000000;WebInspector.TimelineLoader._createFileReader=function(file,delegate)
{return new WebInspector.ChunkedFileReader(file,WebInspector.TimelineLoader.TransferChunkLengthBytes,delegate);}
WebInspector.TimelineLoader.State={Initial:Symbol("Initial"),LookingForEvents:Symbol("LookingForEvents"),ReadingEvents:Symbol("ReadingEvents"),SkippingTail:Symbol("SkippingTail")}
WebInspector.TimelineLoader.prototype={cancel:function()
{this._model.reset();this._delegate.loadingComplete(false);this._delegate=null;if(this._canceledCallback)
this._canceledCallback();},write:function(chunk)
{if(!this._delegate)
return;this._loadedBytes+=chunk.length;if(!this._firstChunk)
this._delegate.loadingProgress(this._totalSize?this._loadedBytes/this._totalSize:undefined);if(this._state===WebInspector.TimelineLoader.State.Initial){if(chunk[0]==="{")
this._state=WebInspector.TimelineLoader.State.LookingForEvents;else if(chunk[0]==="[")
this._state=WebInspector.TimelineLoader.State.ReadingEvents;else{this._reportErrorAndCancelLoading(WebInspector.UIString("Malformed timeline data: Unknown JSON format"));return;}}
if(this._state===WebInspector.TimelineLoader.State.LookingForEvents){var objectName="\"traceEvents\":";var startPos=this._buffer.length-objectName.length;this._buffer+=chunk;var pos=this._buffer.indexOf(objectName,startPos);if(pos===-1)
return;chunk=this._buffer.slice(pos+objectName.length)
this._state=WebInspector.TimelineLoader.State.ReadingEvents;}
if(this._state!==WebInspector.TimelineLoader.State.ReadingEvents)
return;if(this._jsonTokenizer.write(chunk))
return;this._state=WebInspector.TimelineLoader.State.SkippingTail;if(this._firstChunk){this._reportErrorAndCancelLoading(WebInspector.UIString("Malformed timeline input, wrong JSON brackets balance"));return;}},_writeBalancedJSON:function(data)
{var json=data+"]";if(this._firstChunk){this._delegate.loadingStarted();}else{var commaIndex=json.indexOf(",");if(commaIndex!==-1)
json=json.slice(commaIndex+1);json="["+json;}
var items;try{items=(JSON.parse(json));}catch(e){this._reportErrorAndCancelLoading(WebInspector.UIString("Malformed timeline data: %s",e.toString()));return;}
if(this._firstChunk){this._firstChunk=false;this._model.reset();if(this._looksLikeAppVersion(items[0])){this._reportErrorAndCancelLoading(WebInspector.UIString("Legacy Timeline format is not supported."));return;}}
try{this._model.addEvents(items);}catch(e){this._reportErrorAndCancelLoading(WebInspector.UIString("Malformed timeline data: %s",e.toString()));return;}},_reportErrorAndCancelLoading:function(message)
{if(message)
WebInspector.console.error(message);this.cancel();},_looksLikeAppVersion:function(item)
{return typeof item==="string"&&item.indexOf("Chrome")!==-1;},close:function()
{this._model.tracingComplete();if(this._delegate)
this._delegate.loadingComplete(true);},onTransferStarted:function(){},onChunkTransferred:function(reader){},onTransferFinished:function(){},onError:function(reader,event)
{switch(event.target.error.name){case"NotFoundError":this._reportErrorAndCancelLoading(WebInspector.UIString("File \"%s\" not found.",reader.fileName()));break;case"NotReadableError":this._reportErrorAndCancelLoading(WebInspector.UIString("File \"%s\" is not readable",reader.fileName()));break;case"AbortError":break;default:this._reportErrorAndCancelLoading(WebInspector.UIString("An error occurred while reading the file \"%s\"",reader.fileName()));}}}
WebInspector.TracingTimelineSaver=function()
{}
WebInspector.TracingTimelineSaver.prototype={onTransferStarted:function(){},onTransferFinished:function(){},onChunkTransferred:function(reader){},onError:function(reader,event)
{var error=event.target.error;WebInspector.console.error(WebInspector.UIString("Failed to save timeline: %s (%s, %s)",error.message,error.name,error.code));}};WebInspector.TimelineEventOverview=function(id,title,model)
{WebInspector.TimelineOverviewBase.call(this);this.element.id="timeline-overview-"+id;this.element.classList.add("overview-strip");if(title)
this.element.createChild("div","timeline-overview-strip-title").textContent=title;this._model=model;}
WebInspector.TimelineEventOverview.prototype={_renderBar:function(begin,end,position,height,color)
{var x=begin;var width=end-begin;this._context.fillStyle=color;this._context.fillRect(x,position,width,height);},windowTimes:function(windowLeft,windowRight)
{var absoluteMin=this._model.minimumRecordTime();var timeSpan=this._model.maximumRecordTime()-absoluteMin;return{startTime:absoluteMin+timeSpan*windowLeft,endTime:absoluteMin+timeSpan*windowRight};},windowBoundaries:function(startTime,endTime)
{var absoluteMin=this._model.minimumRecordTime();var timeSpan=this._model.maximumRecordTime()-absoluteMin;var haveRecords=absoluteMin>0;return{left:haveRecords&&startTime?Math.min((startTime-absoluteMin)/timeSpan,1):0,right:haveRecords&&endTime<Infinity?(endTime-absoluteMin)/timeSpan:1};},__proto__:WebInspector.TimelineOverviewBase.prototype}
WebInspector.TimelineEventOverview.Input=function(model)
{WebInspector.TimelineEventOverview.call(this,"input",null,model);}
WebInspector.TimelineEventOverview.Input.prototype={update:function()
{WebInspector.TimelineEventOverview.prototype.update.call(this);var events=this._model.mainThreadEvents();var height=this._canvas.height;var descriptors=WebInspector.TimelineUIUtils.eventDispatchDesciptors();var descriptorsByType=new Map();var maxPriority=-1;for(var descriptor of descriptors){for(var type of descriptor.eventTypes)
descriptorsByType.set(type,descriptor);maxPriority=Math.max(maxPriority,descriptor.priority);}
var minWidth=2*window.devicePixelRatio;var timeOffset=this._model.minimumRecordTime();var timeSpan=this._model.maximumRecordTime()-timeOffset;var canvasWidth=this._canvas.width;var scale=canvasWidth/timeSpan;for(var priority=0;priority<=maxPriority;++priority){for(var i=0;i<events.length;++i){var event=events[i];if(event.name!==WebInspector.TimelineModel.RecordType.EventDispatch)
continue;var descriptor=descriptorsByType.get(event.args["data"]["type"]);if(!descriptor||descriptor.priority!==priority)
continue;var start=Number.constrain(Math.floor((event.startTime-timeOffset)*scale),0,canvasWidth);var end=Number.constrain(Math.ceil((event.endTime-timeOffset)*scale),0,canvasWidth);var width=Math.max(end-start,minWidth);this._renderBar(start,start+width,0,height,descriptor.color);}}},__proto__:WebInspector.TimelineEventOverview.prototype}
WebInspector.TimelineEventOverview.Network=function(model)
{WebInspector.TimelineEventOverview.call(this,"network",WebInspector.UIString("NET"),model);}
WebInspector.TimelineEventOverview.Network.prototype={update:function()
{WebInspector.TimelineEventOverview.prototype.update.call(this);var height=this._canvas.height;var numBands=categoryBand(WebInspector.TimelineUIUtils.NetworkCategory.Other)+1;var bandHeight=Math.floor(height/numBands);var devicePixelRatio=window.devicePixelRatio;var timeOffset=this._model.minimumRecordTime();var timeSpan=this._model.maximumRecordTime()-timeOffset;var canvasWidth=this._canvas.width;var scale=canvasWidth/timeSpan;var ctx=this._context;var requests=this._model.networkRequests();var paths=new Map();requests.forEach(drawRequest);for(var path of paths){ctx.fillStyle=path[0];ctx.globalAlpha=0.3;ctx.fill(path[1]["waiting"]);ctx.globalAlpha=1;ctx.fill(path[1]["transfer"]);}
function categoryBand(category)
{var categories=WebInspector.TimelineUIUtils.NetworkCategory;switch(category){case categories.HTML:return 0;case categories.Script:return 1;case categories.Style:return 2;case categories.Media:return 3;default:return 4;}}
function drawRequest(request)
{var tickWidth=2*devicePixelRatio;var category=WebInspector.TimelineUIUtils.networkRequestCategory(request);var style=WebInspector.TimelineUIUtils.networkCategoryColor(category);var band=categoryBand(category);var y=band*bandHeight;var path=paths.get(style);if(!path){path={waiting:new Path2D(),transfer:new Path2D()};paths.set(style,path);}
var s=Math.max(Math.floor((request.startTime-timeOffset)*scale),0);var e=Math.min(Math.ceil((request.endTime-timeOffset)*scale),canvasWidth);path["waiting"].rect(s,y,e-s,bandHeight-1);path["transfer"].rect(e-tickWidth/2,y,tickWidth,bandHeight-1);if(!request.responseTime)
return;var r=Math.ceil((request.responseTime-timeOffset)*scale);path["transfer"].rect(r-tickWidth/2,y,tickWidth,bandHeight-1);}},__proto__:WebInspector.TimelineEventOverview.prototype}
WebInspector.TimelineEventOverview.CPUActivity=function(model)
{WebInspector.TimelineEventOverview.call(this,"cpu-activity",WebInspector.UIString("CPU"),model);this._backgroundCanvas=this.element.createChild("canvas","fill background");}
WebInspector.TimelineEventOverview.CPUActivity.prototype={resetCanvas:function()
{WebInspector.TimelineEventOverview.prototype.resetCanvas.call(this);this._backgroundCanvas.width=this.element.clientWidth*window.devicePixelRatio;this._backgroundCanvas.height=this.element.clientHeight*window.devicePixelRatio;},update:function()
{WebInspector.TimelineEventOverview.prototype.update.call(this);var quantSizePx=4*window.devicePixelRatio;var width=this._canvas.width;var height=this._canvas.height;var baseLine=height;var timeOffset=this._model.minimumRecordTime();var timeSpan=this._model.maximumRecordTime()-timeOffset;var scale=width/timeSpan;var quantTime=quantSizePx/scale;var categories=WebInspector.TimelineUIUtils.categories();var categoryOrder=["idle","loading","painting","rendering","scripting","other"];var otherIndex=categoryOrder.indexOf("other");var idleIndex=0;console.assert(idleIndex===categoryOrder.indexOf("idle"));for(var i=idleIndex+1;i<categoryOrder.length;++i)
categories[categoryOrder[i]]._overviewIndex=i;var backgroundContext=this._backgroundCanvas.getContext("2d");for(var thread of this._model.virtualThreads())
drawThreadEvents(backgroundContext,thread.events);applyPattern(backgroundContext);drawThreadEvents(this._context,this._model.mainThreadEvents());function drawThreadEvents(ctx,events)
{var quantizer=new WebInspector.Quantizer(timeOffset,quantTime,drawSample);var x=0;var categoryIndexStack=[];var paths=[];var lastY=[];for(var i=0;i<categoryOrder.length;++i){paths[i]=new Path2D();paths[i].moveTo(0,height);lastY[i]=height;}
function drawSample(counters)
{var y=baseLine;for(var i=idleIndex+1;i<categoryOrder.length;++i){var h=(counters[i]||0)/quantTime*height;y-=h;paths[i].bezierCurveTo(x,lastY[i],x,y,x+quantSizePx/2,y);lastY[i]=y;}
x+=quantSizePx;}
function onEventStart(e)
{var index=categoryIndexStack.length?categoryIndexStack.peekLast():idleIndex;quantizer.appendInterval(e.startTime,index);categoryIndexStack.push(WebInspector.TimelineUIUtils.eventStyle(e).category._overviewIndex||otherIndex);}
function onEventEnd(e)
{quantizer.appendInterval(e.endTime,categoryIndexStack.pop());}
WebInspector.TimelineModel.forEachEvent(events,onEventStart,onEventEnd);quantizer.appendInterval(timeOffset+timeSpan+quantTime,idleIndex);for(var i=categoryOrder.length-1;i>0;--i){paths[i].lineTo(width,height);ctx.fillStyle=categories[categoryOrder[i]].color;ctx.fill(paths[i]);}}
function applyPattern(ctx)
{var step=4*window.devicePixelRatio;ctx.save();ctx.lineWidth=step/Math.sqrt(8);for(var x=0.5;x<width+height;x+=step){ctx.moveTo(x,0);ctx.lineTo(x-height,height);}
ctx.globalCompositeOperation="destination-out";ctx.stroke();ctx.restore();}},__proto__:WebInspector.TimelineEventOverview.prototype}
WebInspector.TimelineEventOverview.Responsiveness=function(model,frameModel)
{WebInspector.TimelineEventOverview.call(this,"responsiveness",null,model)
this._frameModel=frameModel;}
WebInspector.TimelineEventOverview.Responsiveness.prototype={update:function()
{WebInspector.TimelineEventOverview.prototype.update.call(this);var height=this._canvas.height;var timeOffset=this._model.minimumRecordTime();var timeSpan=this._model.maximumRecordTime()-timeOffset;var scale=this._canvas.width/timeSpan;var frames=this._frameModel.frames();var ctx=this._context;var fillPath=new Path2D();var markersPath=new Path2D();for(var i=0;i<frames.length;++i){var frame=frames[i];if(!frame.hasWarnings())
continue;paintWarningDecoration(frame.startTime,frame.duration);}
var events=this._model.mainThreadEvents();for(var i=0;i<events.length;++i){if(!events[i].warning)
continue;paintWarningDecoration(events[i].startTime,events[i].duration);}
ctx.fillStyle="hsl(0, 80%, 90%)";ctx.strokeStyle="red";ctx.lineWidth=2*window.devicePixelRatio;ctx.fill(fillPath);ctx.stroke(markersPath);function paintWarningDecoration(time,duration)
{var x=Math.round(scale*(time-timeOffset));var w=Math.round(scale*duration);fillPath.rect(x,0,w,height);markersPath.moveTo(x+w,0);markersPath.lineTo(x+w,height);}},__proto__:WebInspector.TimelineEventOverview.prototype}
WebInspector.TimelineFilmStripOverview=function(model,filmStripModel)
{WebInspector.TimelineEventOverview.call(this,"filmstrip",null,model);this._filmStripModel=filmStripModel;this.reset();}
WebInspector.TimelineFilmStripOverview.Padding=2;WebInspector.TimelineFilmStripOverview.prototype={update:function()
{WebInspector.TimelineEventOverview.prototype.update.call(this);var frames=this._filmStripModel.frames();if(!frames.length)
return;var drawGeneration=Symbol("drawGeneration");this._drawGeneration=drawGeneration;this._imageByFrame(frames[0]).then(image=>{if(this._drawGeneration!==drawGeneration)
return;if(!image.naturalWidth||!image.naturalHeight)
return;var imageHeight=this._canvas.height-2*WebInspector.TimelineFilmStripOverview.Padding;var imageWidth=Math.ceil(imageHeight*image.naturalWidth/image.naturalHeight);var popoverScale=Math.min(200/image.naturalWidth,1);this._emptyImage=new Image(image.naturalWidth*popoverScale,image.naturalHeight*popoverScale);this._drawFrames(imageWidth,imageHeight);});},_imageByFrame:function(frame)
{var imagePromise=this._frameToImagePromise.get(frame);if(!imagePromise){imagePromise=frame.imageDataPromise().then(createImage);this._frameToImagePromise.set(frame,imagePromise);}
return imagePromise;function createImage(data)
{var fulfill;var promise=new Promise(f=>fulfill=f);var image=(createElement("img"));if(data)
image.src="data:image/jpg;base64,"+data;if(image.complete){fulfill(image);}else{image.addEventListener("load",()=>fulfill(image));image.addEventListener("error",()=>fulfill(image));}
return promise;}},_drawFrames:function(imageWidth,imageHeight)
{if(!imageWidth)
return;if(!this._filmStripModel.frames().length)
return;var padding=WebInspector.TimelineFilmStripOverview.Padding;var width=this._canvas.width;var zeroTime=this._filmStripModel.zeroTime();var spanTime=this._filmStripModel.spanTime();var scale=spanTime/width;var context=this._canvas.getContext("2d");var drawGeneration=this._drawGeneration;context.beginPath();for(var x=padding;x<width;x+=imageWidth+2*padding){var time=zeroTime+(x+imageWidth/2)*scale;var frame=this._filmStripModel.frameByTimestamp(time);if(!frame)
continue;context.rect(x-0.5,0.5,imageWidth+1,imageHeight+1);this._imageByFrame(frame).then(drawFrameImage.bind(this,x));}
context.strokeStyle="#ddd";context.stroke();function drawFrameImage(x,image)
{if(this._drawGeneration!==drawGeneration)
return;context.drawImage(image,x,1,imageWidth,imageHeight);}},popoverElementPromise:function(x)
{if(!this._filmStripModel.frames().length)
return Promise.resolve((null));var time=this._calculator.positionToTime(x);var frame=this._filmStripModel.frameByTimestamp(time);if(frame===this._lastFrame)
return Promise.resolve(this._lastElement);var imagePromise=frame?this._imageByFrame(frame):Promise.resolve(this._emptyImage);return imagePromise.then(createFrameElement.bind(this));function createFrameElement(image)
{var element=createElementWithClass("div","frame");element.createChild("div","thumbnail").appendChild(image);WebInspector.appendStyle(element,"timeline/timelinePanel.css");this._lastFrame=frame;this._lastElement=element;return element;}},reset:function()
{this._lastFrame=undefined;this._lastElement=null;this._frameToImagePromise=new Map();this._imageWidth=0;},__proto__:WebInspector.TimelineEventOverview.prototype}
WebInspector.TimelineEventOverview.Frames=function(model,frameModel)
{WebInspector.TimelineEventOverview.call(this,"framerate",WebInspector.UIString("FPS"),model);this._frameModel=frameModel;}
WebInspector.TimelineEventOverview.Frames.prototype={update:function()
{WebInspector.TimelineEventOverview.prototype.update.call(this);var height=this._canvas.height;var padding=1*window.devicePixelRatio;var baseFrameDurationMs=1e3/60;var visualHeight=height-2*padding;var timeOffset=this._model.minimumRecordTime();var timeSpan=this._model.maximumRecordTime()-timeOffset;var scale=this._canvas.width/timeSpan;var frames=this._frameModel.frames();var baseY=height-padding;var ctx=this._context;var bottomY=baseY+10*window.devicePixelRatio;var y=bottomY;if(!frames.length)
return;var lineWidth=window.devicePixelRatio;var offset=lineWidth&1?0.5:0;var tickDepth=1.5*window.devicePixelRatio;ctx.beginPath();ctx.moveTo(0,y);for(var i=0;i<frames.length;++i){var frame=frames[i];var x=Math.round((frame.startTime-timeOffset)*scale)+offset;ctx.lineTo(x,y);ctx.lineTo(x,y+tickDepth);y=frame.idle?bottomY:Math.round(baseY-visualHeight*Math.min(baseFrameDurationMs/frame.duration,1))-offset;ctx.lineTo(x,y+tickDepth);ctx.lineTo(x,y);}
if(frames.length){var lastFrame=frames.peekLast();var x=Math.round((lastFrame.startTime+lastFrame.duration-timeOffset)*scale)+offset;ctx.lineTo(x,y);}
ctx.lineTo(x,bottomY);ctx.fillStyle="hsl(110, 50%, 88%)";ctx.strokeStyle="hsl(110, 50%, 60%)";ctx.lineWidth=lineWidth;ctx.fill();ctx.stroke();},__proto__:WebInspector.TimelineEventOverview.prototype}
WebInspector.TimelineEventOverview.Memory=function(model)
{WebInspector.TimelineEventOverview.call(this,"memory",WebInspector.UIString("HEAP"),model);this._heapSizeLabel=this.element.createChild("div","memory-graph-label");}
WebInspector.TimelineEventOverview.Memory.prototype={resetHeapSizeLabels:function()
{this._heapSizeLabel.textContent="";},update:function()
{WebInspector.TimelineEventOverview.prototype.update.call(this);var ratio=window.devicePixelRatio;var events=this._model.mainThreadEvents();if(!events.length){this.resetHeapSizeLabels();return;}
var lowerOffset=3*ratio;var maxUsedHeapSize=0;var minUsedHeapSize=100000000000;var minTime=this._model.minimumRecordTime();var maxTime=this._model.maximumRecordTime();function isUpdateCountersEvent(event)
{return event.name===WebInspector.TimelineModel.RecordType.UpdateCounters;}
events=events.filter(isUpdateCountersEvent);function calculateMinMaxSizes(event)
{var counters=event.args.data;if(!counters||!counters.jsHeapSizeUsed)
return;maxUsedHeapSize=Math.max(maxUsedHeapSize,counters.jsHeapSizeUsed);minUsedHeapSize=Math.min(minUsedHeapSize,counters.jsHeapSizeUsed);}
events.forEach(calculateMinMaxSizes);minUsedHeapSize=Math.min(minUsedHeapSize,maxUsedHeapSize);var lineWidth=1;var width=this._canvas.width;var height=this._canvas.height-lowerOffset;var xFactor=width/(maxTime-minTime);var yFactor=(height-lineWidth)/Math.max(maxUsedHeapSize-minUsedHeapSize,1);var histogram=new Array(width);function buildHistogram(event)
{var counters=event.args.data;if(!counters||!counters.jsHeapSizeUsed)
return;var x=Math.round((event.startTime-minTime)*xFactor);var y=Math.round((counters.jsHeapSizeUsed-minUsedHeapSize)*yFactor);histogram[x]=Math.max(histogram[x]||0,y);}
events.forEach(buildHistogram);var ctx=this._context;var heightBeyondView=height+lowerOffset+lineWidth;ctx.translate(0.5,0.5);ctx.beginPath();ctx.moveTo(-lineWidth,heightBeyondView);var y=0;var isFirstPoint=true;var lastX=0;for(var x=0;x<histogram.length;x++){if(typeof histogram[x]==="undefined")
continue;if(isFirstPoint){isFirstPoint=false;y=histogram[x];ctx.lineTo(-lineWidth,height-y);}
var nextY=histogram[x];if(Math.abs(nextY-y)>2&&Math.abs(x-lastX)>1)
ctx.lineTo(x,height-y);y=nextY;ctx.lineTo(x,height-y);lastX=x;}
ctx.lineTo(width+lineWidth,height-y);ctx.lineTo(width+lineWidth,heightBeyondView);ctx.closePath();ctx.fillStyle="hsla(220, 90%, 70%, 0.2)";ctx.fill();ctx.lineWidth=lineWidth;ctx.strokeStyle="hsl(220, 90%, 70%)";ctx.stroke();this._heapSizeLabel.textContent=WebInspector.UIString("%s \u2013 %s",Number.bytesToString(minUsedHeapSize),Number.bytesToString(maxUsedHeapSize));},__proto__:WebInspector.TimelineEventOverview.prototype}
WebInspector.Quantizer=function(startTime,quantDuration,callback)
{this._lastTime=startTime;this._quantDuration=quantDuration;this._callback=callback;this._counters=[];this._remainder=quantDuration;}
WebInspector.Quantizer.prototype={appendInterval:function(time,group)
{var interval=time-this._lastTime;if(interval<=this._remainder){this._counters[group]=(this._counters[group]||0)+interval;this._remainder-=interval;this._lastTime=time;return;}
this._counters[group]=(this._counters[group]||0)+this._remainder;this._callback(this._counters);interval-=this._remainder;while(interval>=this._quantDuration){var counters=[];counters[group]=this._quantDuration;this._callback(counters);interval-=this._quantDuration;}
this._counters=[];this._counters[group]=interval;this._lastTime=time;this._remainder=this._quantDuration-interval;}};WebInspector.TimelineFlameChartDataProviderBase=function(model,filters)
{WebInspector.FlameChartDataProvider.call(this);this.reset();this._model=model;this._timelineData;this._font="11px "+WebInspector.fontFamily();this._filters=filters;}
WebInspector.TimelineFlameChartDataProviderBase.prototype={barHeight:function()
{return 17;},textBaseline:function()
{return 5;},textPadding:function()
{return 4;},entryFont:function(entryIndex)
{return this._font;},entryTitle:function(entryIndex)
{return null;},reset:function()
{this._timelineData=null;},minimumBoundary:function()
{return this._minimumBoundary;},totalTime:function()
{return this._timeSpan;},formatValue:function(value,precision)
{return Number.preciseMillisToString(value,precision);},maxStackDepth:function()
{return this._currentLevel;},prepareHighlightedEntryInfo:function(entryIndex)
{return null;},canJumpToEntry:function(entryIndex)
{return false;},entryColor:function(entryIndex)
{return"red";},forceDecoration:function(index)
{return false;},decorateEntry:function(entryIndex,context,text,barX,barY,barWidth,barHeight,unclippedBarX,timeToPixels)
{return false;},dividerOffsets:function(startTime,endTime)
{return null;},paddingLeft:function()
{return 0;},textColor:function(entryIndex)
{return"#333";},highlightTimeRange:function(entryIndex)
{var startTime=this._timelineData.entryStartTimes[entryIndex];return{startTime:startTime,endTime:startTime+this._timelineData.entryTotalTimes[entryIndex]};},createSelection:function(entryIndex)
{return null;},timelineData:function()
{throw new Error("Not implemented");},_isVisible:function(event)
{return this._filters.every(function(filter){return filter.accept(event);});}}
WebInspector.TimelineFlameChartEntryType={Frame:Symbol("Frame"),Event:Symbol("Event"),InteractionRecord:Symbol("InteractionRecord"),};WebInspector.TimelineFlameChartDataProvider=function(model,frameModel,irModel,filters)
{WebInspector.TimelineFlameChartDataProviderBase.call(this,model,filters);this._frameModel=frameModel;this._irModel=irModel;this._consoleColorGenerator=new WebInspector.FlameChart.ColorGenerator({min:30,max:55},{min:70,max:100,count:6},50,0.7);this._headerLevel1={padding:4,height:17,collapsible:true,color:WebInspector.themeSupport.patchColor("#222",WebInspector.ThemeSupport.ColorUsage.Foreground),font:this._font,backgroundColor:WebInspector.themeSupport.patchColor("white",WebInspector.ThemeSupport.ColorUsage.Background),nestingLevel:0};this._headerLevel2={padding:2,height:17,collapsible:false,font:this._font,color:WebInspector.themeSupport.patchColor("#222",WebInspector.ThemeSupport.ColorUsage.Foreground),backgroundColor:WebInspector.themeSupport.patchColor("white",WebInspector.ThemeSupport.ColorUsage.Background),nestingLevel:1,shareHeaderLine:true};this._interactionsHeaderLevel1={padding:4,height:17,collapsible:true,color:WebInspector.themeSupport.patchColor("#222",WebInspector.ThemeSupport.ColorUsage.Foreground),font:this._font,backgroundColor:WebInspector.themeSupport.patchColor("white",WebInspector.ThemeSupport.ColorUsage.Background),nestingLevel:0,useFirstLineForOverview:true,shareHeaderLine:true};this._interactionsHeaderLevel2={padding:2,height:17,collapsible:true,color:WebInspector.themeSupport.patchColor("#222",WebInspector.ThemeSupport.ColorUsage.Foreground),font:this._font,backgroundColor:WebInspector.themeSupport.patchColor("white",WebInspector.ThemeSupport.ColorUsage.Background),nestingLevel:1,shareHeaderLine:true};}
WebInspector.TimelineFlameChartDataProvider.InstantEventVisibleDurationMs=0.001;WebInspector.TimelineFlameChartDataProvider.prototype={entryTitle:function(entryIndex)
{var entryType=this._entryType(entryIndex);if(entryType===WebInspector.TimelineFlameChartEntryType.Event){var event=(this._entryData[entryIndex]);if(event.phase===WebInspector.TracingModel.Phase.AsyncStepInto||event.phase===WebInspector.TracingModel.Phase.AsyncStepPast)
return event.name+":"+event.args["step"];if(event._blackboxRoot)
return WebInspector.UIString("Blackboxed");var name=WebInspector.TimelineUIUtils.eventStyle(event).title;var detailsText=WebInspector.TimelineUIUtils.buildDetailsTextForTraceEvent(event,this._model.targetByEvent(event));if(event.name===WebInspector.TimelineModel.RecordType.JSFrame&&detailsText)
return detailsText;return detailsText?WebInspector.UIString("%s (%s)",name,detailsText):name;}
var title=this._entryIndexToTitle[entryIndex];if(!title){title=WebInspector.UIString("Unexpected entryIndex %d",entryIndex);console.error(title);}
return title;},textColor:function(index)
{var event=this._entryData[index];if(event&&event._blackboxRoot)
return"#888";else
return WebInspector.TimelineFlameChartDataProviderBase.prototype.textColor.call(this,index);},reset:function()
{WebInspector.TimelineFlameChartDataProviderBase.prototype.reset.call(this);this._entryData=[];this._entryTypeByLevel=[];this._entryIndexToTitle=[];this._markers=[];this._asyncColorByCategory=new Map();this._asyncColorByInteractionPhase=new Map();},timelineData:function()
{if(this._timelineData)
return this._timelineData;this._timelineData=new WebInspector.FlameChart.TimelineData([],[],[],[]);this._flowEventIndexById={};this._minimumBoundary=this._model.minimumRecordTime();this._timeSpan=this._model.isEmpty()?1000:this._model.maximumRecordTime()-this._minimumBoundary;this._currentLevel=0;this._appendFrameBars(this._frameModel.frames());this._appendHeader(WebInspector.UIString("Interactions"),this._interactionsHeaderLevel1);this._appendInteractionRecords();var asyncEventGroups=WebInspector.TimelineModel.AsyncEventGroup;var inputLatencies=this._model.mainThreadAsyncEvents().get(asyncEventGroups.input);if(inputLatencies&&inputLatencies.length){var title=WebInspector.TimelineUIUtils.titleForAsyncEventGroup(asyncEventGroups.input);this._appendAsyncEventsGroup(title,inputLatencies,this._interactionsHeaderLevel2);}
var animations=this._model.mainThreadAsyncEvents().get(asyncEventGroups.animation);if(animations&&animations.length){var title=WebInspector.TimelineUIUtils.titleForAsyncEventGroup(asyncEventGroups.animation);this._appendAsyncEventsGroup(title,animations,this._interactionsHeaderLevel2);}
var threads=this._model.virtualThreads();this._appendThreadTimelineData(WebInspector.UIString("Main"),this._model.mainThreadEvents(),this._model.mainThreadAsyncEvents(),true);var compositorThreads=threads.filter(thread=>thread.name.startsWith("CompositorTileWorker"));var otherThreads=threads.filter(thread=>!thread.name.startsWith("CompositorTileWorker"));if(compositorThreads.length){this._appendHeader(WebInspector.UIString("Raster"),this._headerLevel1);for(var i=0;i<compositorThreads.length;++i)
this._appendSyncEvents(compositorThreads[i].events,WebInspector.UIString("Rasterizer Thread %d",i),this._headerLevel2);}
this._appendGPUEvents();otherThreads.forEach(thread=>this._appendThreadTimelineData(thread.name,thread.events,thread.asyncEventsByGroup));function compareStartTime(a,b)
{return a.startTime()-b.startTime();}
this._markers.sort(compareStartTime);this._timelineData.markers=this._markers;this._flowEventIndexById={};return this._timelineData;},_appendThreadTimelineData:function(threadTitle,syncEvents,asyncEvents,forceExpanded)
{this._appendAsyncEvents(asyncEvents);this._appendSyncEvents(syncEvents,threadTitle,this._headerLevel1,forceExpanded);},_appendSyncEvents:function(events,title,style,forceExpanded)
{var openEvents=[];var flowEventsEnabled=Runtime.experiments.isEnabled("timelineFlowEvents");var blackboxingEnabled=Runtime.experiments.isEnabled("blackboxJSFramesOnTimeline");var maxStackDepth=0;for(var i=0;i<events.length;++i){var e=events[i];if(WebInspector.TimelineModel.isMarkerEvent(e))
this._markers.push(new WebInspector.TimelineFlameChartMarker(e.startTime,e.startTime-this._model.minimumRecordTime(),WebInspector.TimelineUIUtils.markerStyleForEvent(e)));if(!WebInspector.TracingModel.isFlowPhase(e.phase)){if(!e.endTime&&e.phase!==WebInspector.TracingModel.Phase.Instant)
continue;if(WebInspector.TracingModel.isAsyncPhase(e.phase))
continue;if(!this._isVisible(e))
continue;}
while(openEvents.length&&openEvents.peekLast().endTime<=e.startTime)
openEvents.pop();e._blackboxRoot=false;if(blackboxingEnabled&&this._isBlackboxedEvent(e)){var parent=openEvents.peekLast();if(parent&&parent._blackboxRoot)
continue;e._blackboxRoot=true;}
if(title){this._appendHeader(title,style,forceExpanded);title="";}
var level=this._currentLevel+openEvents.length;this._appendEvent(e,level);if(flowEventsEnabled)
this._appendFlowEvent(e,level);maxStackDepth=Math.max(maxStackDepth,openEvents.length+1);if(e.endTime)
openEvents.push(e);}
this._entryTypeByLevel.length=this._currentLevel+maxStackDepth;this._entryTypeByLevel.fill(WebInspector.TimelineFlameChartEntryType.Event,this._currentLevel);this._currentLevel+=maxStackDepth;},_isBlackboxedEvent:function(event)
{if(event.name!==WebInspector.TimelineModel.RecordType.JSFrame)
return false;var url=event.args["data"]["url"];return url&&this._isBlackboxedURL(url);},_isBlackboxedURL:function(url)
{return WebInspector.blackboxManager.isBlackboxedURL(url);},_appendAsyncEvents:function(asyncEvents)
{var groups=WebInspector.TimelineModel.AsyncEventGroup;var groupArray=Object.keys(groups).map(key=>groups[key]);groupArray.remove(groups.animation);groupArray.remove(groups.input);for(var groupIndex=0;groupIndex<groupArray.length;++groupIndex){var group=groupArray[groupIndex];var events=asyncEvents.get(group);if(!events)
continue;var title=WebInspector.TimelineUIUtils.titleForAsyncEventGroup(group);this._appendAsyncEventsGroup(title,events,this._headerLevel1);}},_appendAsyncEventsGroup:function(header,events,style)
{var lastUsedTimeByLevel=[];var groupHeaderAppended=false;for(var i=0;i<events.length;++i){var asyncEvent=events[i];if(!this._isVisible(asyncEvent))
continue;if(!groupHeaderAppended){this._appendHeader(header,style);groupHeaderAppended=true;}
var startTime=asyncEvent.startTime;var level;for(level=0;level<lastUsedTimeByLevel.length&&lastUsedTimeByLevel[level]>startTime;++level){}
this._appendAsyncEvent(asyncEvent,this._currentLevel+level);lastUsedTimeByLevel[level]=asyncEvent.endTime;}
this._entryTypeByLevel.length=this._currentLevel+lastUsedTimeByLevel.length;this._entryTypeByLevel.fill(WebInspector.TimelineFlameChartEntryType.Event,this._currentLevel);this._currentLevel+=lastUsedTimeByLevel.length;},_appendGPUEvents:function()
{if(this._appendSyncEvents(this._model.gpuEvents(),WebInspector.UIString("GPU"),this._headerLevel1,false))
++this._currentLevel;},_appendInteractionRecords:function()
{this._irModel.interactionRecords().forEach(this._appendSegment,this);this._entryTypeByLevel[this._currentLevel++]=WebInspector.TimelineFlameChartEntryType.InteractionRecord;},_appendFrameBars:function(frames)
{var style=WebInspector.TimelineUIUtils.markerStyleForFrame();this._entryTypeByLevel[this._currentLevel]=WebInspector.TimelineFlameChartEntryType.Frame;for(var i=0;i<frames.length;++i){this._markers.push(new WebInspector.TimelineFlameChartMarker(frames[i].startTime,frames[i].startTime-this._model.minimumRecordTime(),style));this._appendFrame(frames[i]);}
++this._currentLevel;},_entryType:function(entryIndex)
{return this._entryTypeByLevel[this._timelineData.entryLevels[entryIndex]];},prepareHighlightedEntryInfo:function(entryIndex)
{var time="";var title;var warning;var type=this._entryType(entryIndex);if(type===WebInspector.TimelineFlameChartEntryType.Event){var event=(this._entryData[entryIndex]);var totalTime=event.duration;var selfTime=event.selfTime;var eps=1e-6;if(typeof totalTime==="number"){time=Math.abs(totalTime-selfTime)>eps&&selfTime>eps?WebInspector.UIString("%s (self %s)",Number.millisToString(totalTime,true),Number.millisToString(selfTime,true)):Number.millisToString(totalTime,true);}
title=this.entryTitle(entryIndex);warning=WebInspector.TimelineUIUtils.eventWarning(event);}else if(type===WebInspector.TimelineFlameChartEntryType.Frame){var frame=(this._entryData[entryIndex]);time=WebInspector.UIString("%s ~ %.0f\u2009fps",Number.preciseMillisToString(frame.duration,1),(1000/frame.duration));title=frame.idle?WebInspector.UIString("Idle Frame"):WebInspector.UIString("Frame");if(frame.hasWarnings()){warning=createElement("span");warning.textContent=WebInspector.UIString("Long frame");}}else{return null;}
var element=createElement("div");var root=WebInspector.createShadowRootWithCoreStyles(element,"timeline/timelineFlamechartPopover.css");var contents=root.createChild("div","timeline-flamechart-popover");contents.createChild("span","timeline-info-time").textContent=time;contents.createChild("span","timeline-info-title").textContent=title;if(warning){warning.classList.add("timeline-info-warning");contents.appendChild(warning);}
return element;},entryColor:function(entryIndex)
{function patchColorAndCache(cache,key,lookupColor)
{var color=cache.get(key);if(color)
return color;var parsedColor=WebInspector.Color.parse(lookupColor(key));color=parsedColor.setAlpha(0.7).asString(WebInspector.Color.Format.RGBA)||"";cache.set(key,color);return color;}
var type=this._entryType(entryIndex);if(type===WebInspector.TimelineFlameChartEntryType.Event){var event=(this._entryData[entryIndex]);if(!WebInspector.TracingModel.isAsyncPhase(event.phase))
return WebInspector.TimelineUIUtils.eventColor(event);if(event.hasCategory(WebInspector.TimelineModel.Category.Console)||event.hasCategory(WebInspector.TimelineModel.Category.UserTiming))
return this._consoleColorGenerator.colorForID(event.name);if(event.hasCategory(WebInspector.TimelineModel.Category.LatencyInfo)){var phase=WebInspector.TimelineIRModel.phaseForEvent(event)||WebInspector.TimelineIRModel.Phases.Uncategorized;return patchColorAndCache(this._asyncColorByInteractionPhase,phase,WebInspector.TimelineUIUtils.interactionPhaseColor);}
var category=WebInspector.TimelineUIUtils.eventStyle(event).category;return patchColorAndCache(this._asyncColorByCategory,category,()=>category.color);}
if(type===WebInspector.TimelineFlameChartEntryType.Frame)
return"white";if(type===WebInspector.TimelineFlameChartEntryType.InteractionRecord)
return"transparent";return"";},decorateEntry:function(entryIndex,context,text,barX,barY,barWidth,barHeight,unclippedBarX,timeToPixels)
{var data=this._entryData[entryIndex];var type=this._entryType(entryIndex);if(type===WebInspector.TimelineFlameChartEntryType.Frame){var vPadding=1;var hPadding=1;var frame=(data);barX+=hPadding;barWidth-=2*hPadding;barY+=vPadding;barHeight-=2*vPadding+1;context.fillStyle=frame.idle?"white":(frame.hasWarnings()?"#fad1d1":"#d7f0d1");context.fillRect(barX,barY,barWidth,barHeight);var frameDurationText=Number.preciseMillisToString(frame.duration,1);var textWidth=context.measureText(frameDurationText).width;if(barWidth>=textWidth){context.fillStyle=this.textColor(entryIndex);context.fillText(frameDurationText,barX+(barWidth-textWidth)/2,barY+barHeight-3);}
return true;}
if(type===WebInspector.TimelineFlameChartEntryType.InteractionRecord){var color=WebInspector.TimelineUIUtils.interactionPhaseColor((this._entryData[entryIndex]));context.fillStyle=color;context.fillRect(barX,barY,barWidth-1,2);context.fillRect(barX,barY-3,2,3);context.fillRect(barX+barWidth-3,barY-3,2,3);return false;}
if(type===WebInspector.TimelineFlameChartEntryType.Event){var event=(this._entryData[entryIndex]);if(event.hasCategory(WebInspector.TimelineModel.Category.LatencyInfo)&&event.timeWaitingForMainThread){context.fillStyle="hsla(0, 70%, 60%, 1)";var width=Math.floor(unclippedBarX-barX+event.timeWaitingForMainThread*timeToPixels);context.fillRect(barX,barY+barHeight-3,width,2);}
if(event.warning)
paintWarningDecoration(barX,barWidth-1.5);}
function paintWarningDecoration(x,width)
{var triangleSize=8;context.save();context.beginPath();context.rect(x,barY,width,barHeight);context.clip();context.beginPath();context.fillStyle="red";context.moveTo(x+width-triangleSize,barY);context.lineTo(x+width,barY);context.lineTo(x+width,barY+triangleSize);context.fill();context.restore();}
return false;},forceDecoration:function(entryIndex)
{var type=this._entryType(entryIndex);return type===WebInspector.TimelineFlameChartEntryType.Frame||type===WebInspector.TimelineFlameChartEntryType.Event&&!!((this._entryData[entryIndex]).warning);},_appendHeader:function(title,style,expanded)
{this._timelineData.groups.push({startLevel:this._currentLevel,name:title,expanded:expanded,style:style});},_appendEvent:function(event,level)
{var index=this._entryData.length;this._entryData.push(event);this._timelineData.entryLevels[index]=level;var duration;if(WebInspector.TimelineModel.isMarkerEvent(event))
duration=undefined;else
duration=event.duration||WebInspector.TimelineFlameChartDataProvider.InstantEventVisibleDurationMs;this._timelineData.entryTotalTimes[index]=duration;this._timelineData.entryStartTimes[index]=event.startTime;},_appendFlowEvent:function(event,level)
{var timelineData=this._timelineData;function pushStartFlow(event)
{var flowIndex=timelineData.flowStartTimes.length;timelineData.flowStartTimes.push(event.startTime);timelineData.flowStartLevels.push(level);return flowIndex;}
function pushEndFlow(event,flowIndex)
{timelineData.flowEndTimes[flowIndex]=event.startTime;timelineData.flowEndLevels[flowIndex]=level;}
switch(event.phase){case WebInspector.TracingModel.Phase.FlowBegin:this._flowEventIndexById[event.id]=pushStartFlow(event);break;case WebInspector.TracingModel.Phase.FlowStep:pushEndFlow(event,this._flowEventIndexById[event.id]);this._flowEventIndexById[event.id]=pushStartFlow(event);break;case WebInspector.TracingModel.Phase.FlowEnd:pushEndFlow(event,this._flowEventIndexById[event.id]);delete this._flowEventIndexById[event.id];break;}},_appendAsyncEvent:function(asyncEvent,level)
{if(WebInspector.TracingModel.isNestableAsyncPhase(asyncEvent.phase)){this._appendEvent(asyncEvent,level);return;}
var steps=asyncEvent.steps;var eventOffset=steps.length>1&&steps[1].phase===WebInspector.TracingModel.Phase.AsyncStepPast?1:0;for(var i=0;i<steps.length-1;++i){var index=this._entryData.length;this._entryData.push(steps[i+eventOffset]);var startTime=steps[i].startTime;this._timelineData.entryLevels[index]=level;this._timelineData.entryTotalTimes[index]=steps[i+1].startTime-startTime;this._timelineData.entryStartTimes[index]=startTime;}},_appendFrame:function(frame)
{var index=this._entryData.length;this._entryData.push(frame);this._entryIndexToTitle[index]=Number.millisToString(frame.duration,true);this._timelineData.entryLevels[index]=this._currentLevel;this._timelineData.entryTotalTimes[index]=frame.duration;this._timelineData.entryStartTimes[index]=frame.startTime;},_appendSegment:function(segment)
{var index=this._entryData.length;this._entryData.push((segment.data));this._entryIndexToTitle[index]=(segment.data);this._timelineData.entryLevels[index]=this._currentLevel;this._timelineData.entryTotalTimes[index]=segment.end-segment.begin;this._timelineData.entryStartTimes[index]=segment.begin;},createSelection:function(entryIndex)
{var type=this._entryType(entryIndex);var timelineSelection=null;if(type===WebInspector.TimelineFlameChartEntryType.Event)
timelineSelection=WebInspector.TimelineSelection.fromTraceEvent((this._entryData[entryIndex]))
else if(type===WebInspector.TimelineFlameChartEntryType.Frame)
timelineSelection=WebInspector.TimelineSelection.fromFrame((this._entryData[entryIndex]));if(timelineSelection)
this._lastSelection=new WebInspector.TimelineFlameChartView.Selection(timelineSelection,entryIndex);return timelineSelection;},entryIndexForSelection:function(selection)
{if(!selection||selection.type()===WebInspector.TimelineSelection.Type.Range)
return-1;if(this._lastSelection&&this._lastSelection.timelineSelection.object()===selection.object())
return this._lastSelection.entryIndex;var index=this._entryData.indexOf((selection.object()));if(index!==-1)
this._lastSelection=new WebInspector.TimelineFlameChartView.Selection(selection,index);return index;},__proto__:WebInspector.TimelineFlameChartDataProviderBase.prototype}
WebInspector.TimelineFlameChartNetworkDataProvider=function(model)
{WebInspector.TimelineFlameChartDataProviderBase.call(this,model,[]);var loadingCategory=WebInspector.TimelineUIUtils.categories()["loading"];this._waitingColor=loadingCategory.childColor;this._processingColor=loadingCategory.color;}
WebInspector.TimelineFlameChartNetworkDataProvider.prototype={timelineData:function()
{if(this._timelineData)
return this._timelineData;this._requests=[];this._timelineData=new WebInspector.FlameChart.TimelineData([],[],[],[]);this._appendTimelineData(this._model.mainThreadEvents());return this._timelineData;},reset:function()
{WebInspector.TimelineFlameChartDataProviderBase.prototype.reset.call(this);this._requests=[];},setWindowTimes:function(startTime,endTime)
{this._startTime=startTime;this._endTime=endTime;this._updateTimelineData();},createSelection:function(index)
{if(index===-1)
return null;var request=this._requests[index];this._lastSelection=new WebInspector.TimelineFlameChartView.Selection(WebInspector.TimelineSelection.fromNetworkRequest(request),index);return this._lastSelection.timelineSelection;},entryIndexForSelection:function(selection)
{if(!selection)
return-1;if(this._lastSelection&&this._lastSelection.timelineSelection.object()===selection.object())
return this._lastSelection.entryIndex;if(selection.type()!==WebInspector.TimelineSelection.Type.NetworkRequest)
return-1;var request=(selection.object());var index=this._requests.indexOf(request);if(index!==-1)
this._lastSelection=new WebInspector.TimelineFlameChartView.Selection(WebInspector.TimelineSelection.fromNetworkRequest(request),index);return index;},entryColor:function(index)
{var request=(this._requests[index]);var category=WebInspector.TimelineUIUtils.networkRequestCategory(request);return WebInspector.TimelineUIUtils.networkCategoryColor(category);},entryTitle:function(index)
{var request=(this._requests[index]);return request.url||null;},decorateEntry:function(index,context,text,barX,barY,barWidth,barHeight,unclippedBarX,timeToPixels)
{var minTransferWidthPx=2;var request=(this._requests[index]);var startTime=request.startTime;var endTime=request.endTime;var lastX=unclippedBarX;context.fillStyle="hsla(0, 0%, 100%, 0.6)";for(var i=0;i<request.children.length;++i){var event=request.children[i];var t0=event.startTime;var t1=event.endTime||event.startTime;var x0=Math.floor(unclippedBarX+(t0-startTime)*timeToPixels-1);var x1=Math.floor(unclippedBarX+(t1-startTime)*timeToPixels+1);if(x0>lastX)
context.fillRect(lastX,barY,x0-lastX,barHeight);lastX=x1;}
var endX=unclippedBarX+(endTime-startTime)*timeToPixels;if(endX>lastX)
context.fillRect(lastX,barY,Math.min(endX-lastX,1e5),barHeight);if(typeof request.priority==="string"){var color=this._colorForPriority(request.priority);if(color){context.fillStyle="hsl(0, 0%, 100%)";context.fillRect(barX,barY,4,4);context.fillStyle=color;context.fillRect(barX,barY,3,3);}}
return false;},forceDecoration:function(index)
{return true;},prepareHighlightedEntryInfo:function(index)
{var maxURLChars=80;var request=(this._requests[index]);if(!request.url)
return null;var element=createElement("div");var root=WebInspector.createShadowRootWithCoreStyles(element,"timeline/timelineFlamechartPopover.css");var contents=root.createChild("div","timeline-flamechart-popover");var duration=request.endTime-request.startTime;if(request.startTime&&isFinite(duration))
contents.createChild("span","timeline-info-network-time").textContent=Number.millisToString(duration);if(typeof request.priority==="string"){var div=contents.createChild("span");div.textContent=WebInspector.uiLabelForPriority((request.priority));div.style.color=this._colorForPriority(request.priority)||"black";}
contents.createChild("span").textContent=request.url.trimMiddle(maxURLChars);return element;},_colorForPriority:function(priority)
{switch((priority)){case NetworkAgent.ResourcePriority.VeryLow:return"#080";case NetworkAgent.ResourcePriority.Low:return"#6c0";case NetworkAgent.ResourcePriority.Medium:return"#fa0";case NetworkAgent.ResourcePriority.High:return"#f60";case NetworkAgent.ResourcePriority.VeryHigh:return"#f00";}
return null;},_appendTimelineData:function(events)
{this._minimumBoundary=this._model.minimumRecordTime();this._maximumBoundary=this._model.maximumRecordTime();this._timeSpan=this._model.isEmpty()?1000:this._maximumBoundary-this._minimumBoundary;this._model.networkRequests().forEach(this._appendEntry.bind(this));this._updateTimelineData();},_updateTimelineData:function()
{if(!this._timelineData)
return;var index=-1;var lastTime=Infinity;for(var i=0;i<this._requests.length;++i){var r=this._requests[i];var visible=r.startTime<this._endTime&&r.endTime>this._startTime;if(!visible){this._timelineData.entryLevels[i]=-1;continue;}
if(lastTime>r.startTime)
++index;lastTime=r.endTime;this._timelineData.entryLevels[i]=index;}
++index;for(var i=0;i<this._requests.length;++i){if(this._timelineData.entryLevels[i]===-1)
this._timelineData.entryLevels[i]=index;}
this._timelineData=new WebInspector.FlameChart.TimelineData(this._timelineData.entryLevels,this._timelineData.entryTotalTimes,this._timelineData.entryStartTimes,null);this._currentLevel=index;},_appendEntry:function(request)
{this._requests.push(request);this._timelineData.entryStartTimes.push(request.startTime);this._timelineData.entryTotalTimes.push(request.endTime-request.startTime);this._timelineData.entryLevels.push(this._requests.length-1);},__proto__:WebInspector.TimelineFlameChartDataProviderBase.prototype}
WebInspector.TimelineFlameChartMarker=function(startTime,startOffset,style)
{this._startTime=startTime;this._startOffset=startOffset;this._style=style;}
WebInspector.TimelineFlameChartMarker.prototype={startTime:function()
{return this._startTime;},color:function()
{return this._style.color;},title:function()
{var startTime=Number.millisToString(this._startOffset);return WebInspector.UIString("%s at %s",this._style.title,startTime);},draw:function(context,x,height,pixelsPerMillisecond)
{var lowPriorityVisibilityThresholdInPixelsPerMs=4;if(this._style.lowPriority&&pixelsPerMillisecond<lowPriorityVisibilityThresholdInPixelsPerMs)
return;context.save();if(!this._style.lowPriority){context.strokeStyle=this._style.color;context.lineWidth=2;context.beginPath();context.moveTo(x,0);context.lineTo(x,height);context.stroke();}
if(this._style.tall){context.strokeStyle=this._style.color;context.lineWidth=this._style.lineWidth;context.translate(this._style.lineWidth<1||(this._style.lineWidth&1)?0.5:0,0.5);context.beginPath();context.moveTo(x,height);context.setLineDash(this._style.dashStyle);context.lineTo(x,context.canvas.height);context.stroke();}
context.restore();}}
WebInspector.TimelineFlameChartView=function(delegate,timelineModel,frameModel,irModel,filters)
{WebInspector.VBox.call(this);this.element.classList.add("timeline-flamechart");this._delegate=delegate;this._model=timelineModel;this._splitWidget=new WebInspector.SplitWidget(false,false,"timelineFlamechartMainView",150);this._dataProvider=new WebInspector.TimelineFlameChartDataProvider(this._model,frameModel,irModel,filters);var mainViewGroupExpansionSetting=WebInspector.settings.createSetting("timelineFlamechartMainViewGroupExpansion",{});this._mainView=new WebInspector.FlameChart(this._dataProvider,this,mainViewGroupExpansionSetting);this._networkDataProvider=new WebInspector.TimelineFlameChartNetworkDataProvider(this._model);this._networkView=new WebInspector.FlameChart(this._networkDataProvider,this);this._splitWidget.setMainWidget(this._mainView);this._splitWidget.setSidebarWidget(this._networkView);this._splitWidget.show(this.element);this._onMainEntrySelected=this._onEntrySelected.bind(this,this._dataProvider);this._onNetworkEntrySelected=this._onEntrySelected.bind(this,this._networkDataProvider);this._mainView.addEventListener(WebInspector.FlameChart.Events.EntrySelected,this._onMainEntrySelected,this);this._networkView.addEventListener(WebInspector.FlameChart.Events.EntrySelected,this._onNetworkEntrySelected,this);WebInspector.blackboxManager.addChangeListener(this.refreshRecords,this);}
WebInspector.TimelineFlameChartView.prototype={dispose:function()
{this._mainView.removeEventListener(WebInspector.FlameChart.Events.EntrySelected,this._onMainEntrySelected,this);this._networkView.removeEventListener(WebInspector.FlameChart.Events.EntrySelected,this._onNetworkEntrySelected,this);WebInspector.blackboxManager.removeChangeListener(this.refreshRecords,this);},resizerElement:function()
{return null;},requestWindowTimes:function(windowStartTime,windowEndTime)
{this._delegate.requestWindowTimes(windowStartTime,windowEndTime);},updateRangeSelection:function(startTime,endTime)
{this._delegate.select(WebInspector.TimelineSelection.fromRange(startTime,endTime));},refreshRecords:function()
{this._dataProvider.reset();this._mainView.scheduleUpdate();this._networkDataProvider.reset();this._networkView.scheduleUpdate();},highlightEvent:function(event)
{var entryIndex=event?this._dataProvider.entryIndexForSelection(WebInspector.TimelineSelection.fromTraceEvent(event)):-1;if(entryIndex>=0)
this._mainView.highlightEntry(entryIndex);else
this._mainView.hideHighlight();},wasShown:function()
{this._mainView.scheduleUpdate();this._networkView.scheduleUpdate();},view:function()
{return this;},reset:function()
{this._dataProvider.reset();this._mainView.reset();this._mainView.setWindowTimes(0,Infinity);this._networkDataProvider.reset();this._networkView.reset();this._networkView.setWindowTimes(0,Infinity);},setWindowTimes:function(startTime,endTime)
{this._mainView.setWindowTimes(startTime,endTime);this._networkView.setWindowTimes(startTime,endTime);this._networkDataProvider.setWindowTimes(startTime,endTime);},highlightSearchResult:function(event,regex,select)
{if(!event){this._delegate.select(null);return;}
var entryIndex=this._dataProvider._entryData.indexOf(event);var timelineSelection=this._dataProvider.createSelection(entryIndex);if(timelineSelection)
this._delegate.select(timelineSelection);},setSelection:function(selection)
{var index=this._dataProvider.entryIndexForSelection(selection);this._mainView.setSelectedEntry(index);index=this._networkDataProvider.entryIndexForSelection(selection);this._networkView.setSelectedEntry(index);},_onEntrySelected:function(dataProvider,event)
{var entryIndex=(event.data);this._delegate.select(dataProvider.createSelection(entryIndex));},enableNetworkPane:function(enable,animate)
{if(enable)
this._splitWidget.showBoth(animate);else
this._splitWidget.hideSidebar(animate);},__proto__:WebInspector.VBox.prototype}
WebInspector.TimelineFlameChartView.Selection=function(selection,entryIndex)
{this.timelineSelection=selection;this.entryIndex=entryIndex;};WebInspector.TimelineTreeView=function(model,filters)
{WebInspector.VBox.call(this);this.element.classList.add("timeline-tree-view");this._model=model;this._linkifier=new WebInspector.Linkifier();this._filters=filters.slice();var columns=[];this._populateColumns(columns);var mainView=new WebInspector.VBox();this._populateToolbar(mainView.element);this._dataGrid=new WebInspector.SortableDataGrid(columns);this._dataGrid.addEventListener(WebInspector.DataGrid.Events.SortingChanged,this._sortingChanged,this);this._dataGrid.element.addEventListener("mousemove",this._onMouseMove.bind(this),true)
this._dataGrid.setResizeMethod(WebInspector.DataGrid.ResizeMethod.Last);this._dataGrid.asWidget().show(mainView.element);this._splitWidget=new WebInspector.SplitWidget(true,true,"timelineTreeViewDetailsSplitWidget");this._splitWidget.show(this.element);this._splitWidget.setMainWidget(mainView);this._detailsView=new WebInspector.VBox();this._detailsView.element.classList.add("timeline-details-view","timeline-details-view-body");this._splitWidget.setSidebarWidget(this._detailsView);this._dataGrid.addEventListener(WebInspector.DataGrid.Events.SelectedNode,this._updateDetailsForSelection,this);this._lastSelectedNode;}
WebInspector.TimelineTreeView.prototype={updateContents:function(selection)
{this.setRange(selection.startTime(),selection.endTime());},setRange:function(startTime,endTime)
{this._startTime=startTime;this._endTime=endTime;this._refreshTree();},_exposePercentages:function()
{return false;},_populateToolbar:function(parent){},_onHover:function(node){},_linkifyLocation:function(event)
{var target=this._model.targetByEvent(event);if(!target)
return null;var frame=WebInspector.TimelineProfileTree.eventStackFrame(event);if(!frame)
return null;return this._linkifier.maybeLinkifyConsoleCallFrame(target,frame);},selectProfileNode:function(treeNode,suppressSelectedEvent)
{var pathToRoot=[];for(var node=treeNode;node;node=node.parent)
pathToRoot.push(node);for(var i=pathToRoot.length-1;i>0;--i){var gridNode=this._dataGridNodeForTreeNode(pathToRoot[i]);if(gridNode&&gridNode.dataGrid)
gridNode.expand();}
var gridNode=this._dataGridNodeForTreeNode(treeNode);if(gridNode.dataGrid){gridNode.reveal();gridNode.select(suppressSelectedEvent);}},_refreshTree:function()
{this._linkifier.reset();this._dataGrid.rootNode().removeChildren();var tree=this._buildTree();if(!tree.children)
return;var maxSelfTime=0;var maxTotalTime=0;for(var child of tree.children.values()){maxSelfTime=Math.max(maxSelfTime,child.selfTime);maxTotalTime=Math.max(maxTotalTime,child.totalTime);}
for(var child of tree.children.values()){var gridNode=new WebInspector.TimelineTreeView.TreeGridNode(child,tree.totalTime,maxSelfTime,maxTotalTime,this);this._dataGrid.insertChild(gridNode);}
this._sortingChanged();this._updateDetailsForSelection();},_buildTree:function()
{throw new Error("Not Implemented");},_buildTopDownTree:function(eventIdCallback)
{return WebInspector.TimelineProfileTree.buildTopDown(this._model.mainThreadEvents(),this._filters,this._startTime,this._endTime,eventIdCallback)},_populateColumns:function(columns)
{columns.push({id:"self",title:WebInspector.UIString("Self Time"),width:"110px",fixedWidth:true,sortable:true});columns.push({id:"total",title:WebInspector.UIString("Total Time"),width:"110px",fixedWidth:true,sortable:true});columns.push({id:"activity",title:WebInspector.UIString("Activity"),disclosure:true,sortable:true});},_sortingChanged:function()
{var columnIdentifier=this._dataGrid.sortColumnIdentifier();if(!columnIdentifier)
return;var sortFunction;switch(columnIdentifier){case"startTime":sortFunction=compareStartTime;break;case"self":sortFunction=compareNumericField.bind(null,"selfTime");break;case"total":sortFunction=compareNumericField.bind(null,"totalTime");break;case"activity":sortFunction=compareName;break;default:console.assert(false,"Unknown sort field: "+columnIdentifier);return;}
this._dataGrid.sortNodes(sortFunction,!this._dataGrid.isSortOrderAscending());function compareNumericField(field,a,b)
{var nodeA=(a);var nodeB=(b);return nodeA._profileNode[field]-nodeB._profileNode[field];}
function compareStartTime(a,b)
{var nodeA=(a);var nodeB=(b);return nodeA._profileNode.event.startTime-nodeB._profileNode.event.startTime;}
function compareName(a,b)
{var nodeA=(a);var nodeB=(b);var nameA=WebInspector.TimelineTreeView.eventNameForSorting(nodeA._profileNode.event);var nameB=WebInspector.TimelineTreeView.eventNameForSorting(nodeB._profileNode.event);return nameA.localeCompare(nameB);}},_updateDetailsForSelection:function()
{var selectedNode=this._dataGrid.selectedNode?(this._dataGrid.selectedNode)._profileNode:null;if(selectedNode===this._lastSelectedNode)
return;this._lastSelectedNode=selectedNode;this._detailsView.detachChildWidgets();this._detailsView.element.removeChildren();if(!selectedNode||!this._showDetailsForNode(selectedNode)){var banner=this._detailsView.element.createChild("div","full-widget-dimmed-banner");banner.createTextChild(WebInspector.UIString("Select item for details."));}},_showDetailsForNode:function(node)
{return false;},_onMouseMove:function(event)
{var gridNode=event.target&&(event.target instanceof Node)?(this._dataGrid.dataGridNodeFromNode((event.target))):null;var profileNode=gridNode&&gridNode._profileNode;if(profileNode===this._lastHoveredProfileNode)
return;this._lastHoveredProfileNode=profileNode;this._onHover(profileNode);},_dataGridNodeForTreeNode:function(treeNode)
{return treeNode[WebInspector.TimelineTreeView.TreeGridNode._gridNodeSymbol]||null;},__proto__:WebInspector.VBox.prototype}
WebInspector.TimelineTreeView.eventNameForSorting=function(event)
{if(event.name===WebInspector.TimelineModel.RecordType.JSFrame){var data=event.args["data"];return data["functionName"]+"@"+(data["scriptId"]||data["url"]||"");}
return event.name+":@"+WebInspector.TimelineProfileTree.eventURL(event);}
WebInspector.TimelineTreeView.GridNode=function(profileNode,grandTotalTime,maxSelfTime,maxTotalTime,treeView)
{this._populated=false;this._profileNode=profileNode;this._treeView=treeView;this._grandTotalTime=grandTotalTime;this._maxSelfTime=maxSelfTime;this._maxTotalTime=maxTotalTime;WebInspector.SortableDataGridNode.call(this,null,false);}
WebInspector.TimelineTreeView.GridNode.prototype={createCell:function(columnIdentifier)
{if(columnIdentifier==="activity")
return this._createNameCell(columnIdentifier);return this._createValueCell(columnIdentifier)||WebInspector.DataGridNode.prototype.createCell.call(this,columnIdentifier);},_createNameCell:function(columnIdentifier)
{var cell=this.createTD(columnIdentifier);var container=cell.createChild("div","name-container");var icon=container.createChild("div","activity-icon");var name=container.createChild("div","activity-name");var event=this._profileNode.event;if(this._profileNode.isGroupNode()){var treeView=(this._treeView);var info=treeView._displayInfoForGroupNode(this._profileNode);name.textContent=info.name;icon.style.backgroundColor=info.color;}else if(event){var data=event.args["data"];var deoptReason=data&&data["deoptReason"];if(deoptReason)
container.createChild("div","activity-warning").title=WebInspector.UIString("Not optimized: %s",deoptReason);name.textContent=event.name===WebInspector.TimelineModel.RecordType.JSFrame?WebInspector.beautifyFunctionName(event.args["data"]["functionName"]):WebInspector.TimelineUIUtils.eventTitle(event);var link=this._treeView._linkifyLocation(event);if(link)
container.createChild("div","activity-link").appendChild(link);icon.style.backgroundColor=WebInspector.TimelineUIUtils.eventColor(event);}
return cell;},_createValueCell:function(columnIdentifier)
{if(columnIdentifier!=="self"&&columnIdentifier!=="total"&&columnIdentifier!=="startTime")
return null;var showPercents=false;var value;var maxTime;switch(columnIdentifier){case"startTime":value=this._profileNode.event.startTime-this._treeView._model.minimumRecordTime();break;case"self":value=this._profileNode.selfTime;maxTime=this._maxSelfTime;showPercents=true;break;case"total":value=this._profileNode.totalTime;maxTime=this._maxTotalTime;showPercents=true;break;default:return null;}
var cell=this.createTD(columnIdentifier);cell.className="numeric-column";var textDiv=cell.createChild("div");textDiv.createChild("span").textContent=WebInspector.UIString("%.1f\u2009ms",value);if(showPercents&&this._treeView._exposePercentages())
textDiv.createChild("span","percent-column").textContent=WebInspector.UIString("%.1f\u2009%%",value/this._grandTotalTime*100);if(maxTime){textDiv.classList.add("background-percent-bar");cell.createChild("div","background-bar-container").createChild("div","background-bar").style.width=(value*100/maxTime).toFixed(1)+"%";}
return cell;},__proto__:WebInspector.SortableDataGridNode.prototype}
WebInspector.TimelineTreeView.TreeGridNode=function(profileNode,grandTotalTime,maxSelfTime,maxTotalTime,treeView)
{WebInspector.TimelineTreeView.GridNode.call(this,profileNode,grandTotalTime,maxSelfTime,maxTotalTime,treeView);this.hasChildren=this._profileNode.children?this._profileNode.children.size>0:false;profileNode[WebInspector.TimelineTreeView.TreeGridNode._gridNodeSymbol]=this;}
WebInspector.TimelineTreeView.TreeGridNode._gridNodeSymbol=Symbol("treeGridNode");WebInspector.TimelineTreeView.TreeGridNode.prototype={populate:function()
{if(this._populated)
return;this._populated=true;if(!this._profileNode.children)
return;for(var node of this._profileNode.children.values()){var gridNode=new WebInspector.TimelineTreeView.TreeGridNode(node,this._grandTotalTime,this._maxSelfTime,this._maxTotalTime,this._treeView);this.insertChildOrdered(gridNode);}},__proto__:WebInspector.TimelineTreeView.GridNode.prototype};WebInspector.AggregatedTimelineTreeView=function(model,filters)
{this._groupBySetting=WebInspector.settings.createSetting("timelineTreeGroupBy",WebInspector.TimelineAggregator.GroupBy.Category);WebInspector.TimelineTreeView.call(this,model,filters);var nonessentialEvents=[WebInspector.TimelineModel.RecordType.EventDispatch,WebInspector.TimelineModel.RecordType.FunctionCall,WebInspector.TimelineModel.RecordType.TimerFire];this._filters.push(new WebInspector.ExclusiveNameFilter(nonessentialEvents));this._stackView=new WebInspector.TimelineStackView(this);this._stackView.addEventListener(WebInspector.TimelineStackView.Events.SelectionChanged,this._onStackViewSelectionChanged,this);}
WebInspector.AggregatedTimelineTreeView.prototype={updateContents:function(selection)
{this._updateExtensionResolver();WebInspector.TimelineTreeView.prototype.updateContents.call(this,selection);var rootNode=this._dataGrid.rootNode();if(rootNode.children.length)
rootNode.children[0].revealAndSelect();},_updateExtensionResolver:function()
{this._executionContextNamesByOrigin=new Map();for(var target of WebInspector.targetManager.targets()){for(var context of target.runtimeModel.executionContexts())
this._executionContextNamesByOrigin.set(context.origin,context.name);}},_displayInfoForGroupNode:function(node)
{var categories=WebInspector.TimelineUIUtils.categories();var color=node.id?WebInspector.TimelineUIUtils.eventColor(node.event):categories["other"].color;switch(this._groupBySetting.get()){case WebInspector.TimelineAggregator.GroupBy.Category:var category=categories[node.id]||categories["other"];return{name:category.title,color:category.color};case WebInspector.TimelineAggregator.GroupBy.Domain:case WebInspector.TimelineAggregator.GroupBy.Subdomain:var name=node.id;if(WebInspector.TimelineAggregator.isExtensionInternalURL(name))
name=WebInspector.UIString("[Chrome extensions overhead]");else if(name.startsWith("chrome-extension"))
name=this._executionContextNamesByOrigin.get(name)||name;return{name:name||WebInspector.UIString("unattributed"),color:color};case WebInspector.TimelineAggregator.GroupBy.EventName:var name=node.event.name===WebInspector.TimelineModel.RecordType.JSFrame?WebInspector.UIString("JavaScript"):WebInspector.TimelineUIUtils.eventTitle(node.event);return{name:name,color:node.event.name===WebInspector.TimelineModel.RecordType.JSFrame?WebInspector.TimelineUIUtils.eventStyle(node.event).category.color:color};case WebInspector.TimelineAggregator.GroupBy.URL:break;default:console.assert(false,"Unexpected aggregation type");}
return{name:node.id||WebInspector.UIString("unattributed"),color:color};},_populateToolbar:function(parent)
{var panelToolbar=new WebInspector.Toolbar("",parent);this._groupByCombobox=new WebInspector.ToolbarComboBox(this._onGroupByChanged.bind(this));function addGroupingOption(name,id)
{var option=this._groupByCombobox.createOption(name,"",id);this._groupByCombobox.addOption(option);if(id===this._groupBySetting.get())
this._groupByCombobox.select(option);}
addGroupingOption.call(this,WebInspector.UIString("No Grouping"),WebInspector.TimelineAggregator.GroupBy.None);addGroupingOption.call(this,WebInspector.UIString("Group by Activity"),WebInspector.TimelineAggregator.GroupBy.EventName);addGroupingOption.call(this,WebInspector.UIString("Group by Category"),WebInspector.TimelineAggregator.GroupBy.Category);addGroupingOption.call(this,WebInspector.UIString("Group by Domain"),WebInspector.TimelineAggregator.GroupBy.Domain);addGroupingOption.call(this,WebInspector.UIString("Group by Subdomain"),WebInspector.TimelineAggregator.GroupBy.Subdomain);addGroupingOption.call(this,WebInspector.UIString("Group by URL"),WebInspector.TimelineAggregator.GroupBy.URL);panelToolbar.appendToolbarItem(this._groupByCombobox);},_buildHeaviestStack:function(treeNode)
{console.assert(!!treeNode.parent,"Attempt to build stack for tree root");var result=[];for(var node=treeNode;node&&node.parent;node=node.parent)
result.push(node);result=result.reverse();for(node=treeNode;node&&node.children&&node.children.size;){var children=Array.from(node.children.values());node=children.reduce((a,b)=>a.totalTime>b.totalTime?a:b);result.push(node);}
return result;},_exposePercentages:function()
{return true;},_onGroupByChanged:function()
{this._groupBySetting.set(this._groupByCombobox.selectedOption().value);this._refreshTree();},_onStackViewSelectionChanged:function()
{var treeNode=this._stackView.selectedTreeNode();if(treeNode)
this.selectProfileNode(treeNode,true);},_showDetailsForNode:function(node)
{var stack=this._buildHeaviestStack(node);this._stackView.setStack(stack,node);this._stackView.show(this._detailsView.element);return true;},_createAggregator:function()
{return new WebInspector.TimelineAggregator(event=>WebInspector.TimelineUIUtils.eventStyle(event).title,event=>WebInspector.TimelineUIUtils.eventStyle(event).category.name);},__proto__:WebInspector.TimelineTreeView.prototype,};WebInspector.CallTreeTimelineTreeView=function(model,filters)
{WebInspector.AggregatedTimelineTreeView.call(this,model,filters);this._dataGrid.markColumnAsSortedBy("total",WebInspector.DataGrid.Order.Descending);}
WebInspector.CallTreeTimelineTreeView.prototype={_buildTree:function()
{var topDown=this._buildTopDownTree(WebInspector.TimelineAggregator.eventId);return this._createAggregator().performGrouping(topDown,this._groupBySetting.get());},__proto__:WebInspector.AggregatedTimelineTreeView.prototype,};WebInspector.BottomUpTimelineTreeView=function(model,filters)
{WebInspector.AggregatedTimelineTreeView.call(this,model,filters);this._dataGrid.markColumnAsSortedBy("self",WebInspector.DataGrid.Order.Descending);}
WebInspector.BottomUpTimelineTreeView.prototype={_buildTree:function()
{var topDown=this._buildTopDownTree(WebInspector.TimelineAggregator.eventId);return WebInspector.TimelineProfileTree.buildBottomUp(topDown,this._createAggregator().groupFunction(this._groupBySetting.get()));},__proto__:WebInspector.AggregatedTimelineTreeView.prototype};WebInspector.EventsTimelineTreeView=function(model,filters,delegate)
{this._filtersControl=new WebInspector.TimelineFilters();this._filtersControl.addEventListener(WebInspector.TimelineFilters.Events.FilterChanged,this._onFilterChanged,this);WebInspector.TimelineTreeView.call(this,model,filters);this._delegate=delegate;this._filters.push.apply(this._filters,this._filtersControl.filters());this._dataGrid.markColumnAsSortedBy("startTime",WebInspector.DataGrid.Order.Ascending);}
WebInspector.EventsTimelineTreeView.prototype={updateContents:function(selection)
{WebInspector.TimelineTreeView.prototype.updateContents.call(this,selection);if(selection.type()===WebInspector.TimelineSelection.Type.TraceEvent){var event=(selection.object());this._selectEvent(event,true);}},_buildTree:function()
{this._currentTree=this._buildTopDownTree();return this._currentTree;},_onFilterChanged:function()
{var selectedEvent=this._lastSelectedNode&&this._lastSelectedNode.event;this._refreshTree();if(selectedEvent)
this._selectEvent(selectedEvent,false);},_findNodeWithEvent:function(event)
{var iterators=[this._currentTree.children.values()];while(iterators.length){var iterator=iterators.peekLast().next();if(iterator.done){iterators.pop();continue;}
var child=(iterator.value);if(child.event===event)
return child;if(child.children)
iterators.push(child.children.values());}
return null;},_selectEvent:function(event,expand)
{var node=this._findNodeWithEvent(event);if(!node)
return;this.selectProfileNode(node,false);if(expand)
this._dataGridNodeForTreeNode(node).expand();},_populateColumns:function(columns)
{columns.push({id:"startTime",title:WebInspector.UIString("Start Time"),width:"110px",fixedWidth:true,sortable:true});WebInspector.TimelineTreeView.prototype._populateColumns.call(this,columns);},_populateToolbar:function(parent)
{var filtersWidget=this._filtersControl.filtersWidget();filtersWidget.forceShowFilterBar();filtersWidget.show(parent);},_showDetailsForNode:function(node)
{var traceEvent=node.event;if(!traceEvent)
return false;WebInspector.TimelineUIUtils.buildTraceEventDetails(traceEvent,this._model,this._linkifier,false,showDetails.bind(this));return true;function showDetails(fragment)
{this._detailsView.element.appendChild(fragment);}},_onHover:function(node)
{this._delegate.highlightEvent(node&&node.event);},__proto__:WebInspector.TimelineTreeView.prototype}
WebInspector.TimelineStackView=function(treeView)
{WebInspector.VBox.call(this);var header=this.element.createChild("div","timeline-stack-view-header");header.textContent=WebInspector.UIString("Heaviest stack");this._treeView=treeView;var columns=[{id:"total",title:WebInspector.UIString("Total Time"),fixedWidth:true,width:"110px"},{id:"activity",title:WebInspector.UIString("Activity")}];this._dataGrid=new WebInspector.ViewportDataGrid(columns);this._dataGrid.setResizeMethod(WebInspector.DataGrid.ResizeMethod.Last);this._dataGrid.addEventListener(WebInspector.DataGrid.Events.SelectedNode,this._onSelectionChanged,this);this._dataGrid.asWidget().show(this.element);}
WebInspector.TimelineStackView.Events={SelectionChanged:Symbol("SelectionChanged")}
WebInspector.TimelineStackView.prototype={setStack:function(stack,selectedNode)
{var rootNode=this._dataGrid.rootNode();rootNode.removeChildren();var nodeToReveal=null;var totalTime=Math.max.apply(Math,stack.map(node=>node.totalTime));for(var node of stack){var gridNode=new WebInspector.TimelineTreeView.GridNode(node,totalTime,totalTime,totalTime,this._treeView);rootNode.appendChild(gridNode);if(node===selectedNode)
nodeToReveal=gridNode;}
nodeToReveal.revealAndSelect();},selectedTreeNode:function()
{var selectedNode=this._dataGrid.selectedNode;return selectedNode&&(selectedNode)._profileNode;},_onSelectionChanged:function()
{this.dispatchEventToListeners(WebInspector.TimelineStackView.Events.SelectionChanged);},__proto__:WebInspector.VBox.prototype};WebInspector.TimelineUIUtils=function(){}
WebInspector.TimelineRecordStyle=function(title,category,hidden)
{this.title=title;this.category=category;this.hidden=!!hidden;}
WebInspector.TimelineUIUtils._initEventStyles=function()
{if(WebInspector.TimelineUIUtils._eventStylesMap)
return WebInspector.TimelineUIUtils._eventStylesMap;var recordTypes=WebInspector.TimelineModel.RecordType;var categories=WebInspector.TimelineUIUtils.categories();var eventStyles={};eventStyles[recordTypes.Task]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Task"),categories["other"]);eventStyles[recordTypes.Program]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Other"),categories["other"]);eventStyles[recordTypes.Animation]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Animation"),categories["rendering"]);eventStyles[recordTypes.EventDispatch]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Event"),categories["scripting"]);eventStyles[recordTypes.RequestMainThreadFrame]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Request Main Thread Frame"),categories["rendering"],true);eventStyles[recordTypes.BeginFrame]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Frame Start"),categories["rendering"],true);eventStyles[recordTypes.BeginMainThreadFrame]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Frame Start (main thread)"),categories["rendering"],true);eventStyles[recordTypes.DrawFrame]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Draw Frame"),categories["rendering"],true);eventStyles[recordTypes.HitTest]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Hit Test"),categories["rendering"]);eventStyles[recordTypes.ScheduleStyleRecalculation]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Schedule Style Recalculation"),categories["rendering"],true);eventStyles[recordTypes.RecalculateStyles]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Recalculate Style"),categories["rendering"]);eventStyles[recordTypes.UpdateLayoutTree]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Recalculate Style"),categories["rendering"]);eventStyles[recordTypes.InvalidateLayout]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Invalidate Layout"),categories["rendering"],true);eventStyles[recordTypes.Layout]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Layout"),categories["rendering"]);eventStyles[recordTypes.PaintSetup]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Paint Setup"),categories["painting"]);eventStyles[recordTypes.PaintImage]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Paint Image"),categories["painting"],true);eventStyles[recordTypes.UpdateLayer]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Update Layer"),categories["painting"],true);eventStyles[recordTypes.UpdateLayerTree]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Update Layer Tree"),categories["rendering"]);eventStyles[recordTypes.Paint]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Paint"),categories["painting"]);eventStyles[recordTypes.RasterTask]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Rasterize Paint"),categories["painting"]);eventStyles[recordTypes.ScrollLayer]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Scroll"),categories["rendering"]);eventStyles[recordTypes.CompositeLayers]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Composite Layers"),categories["painting"]);eventStyles[recordTypes.ParseHTML]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Parse HTML"),categories["loading"]);eventStyles[recordTypes.ParseAuthorStyleSheet]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Parse Stylesheet"),categories["loading"]);eventStyles[recordTypes.TimerInstall]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Install Timer"),categories["scripting"]);eventStyles[recordTypes.TimerRemove]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Remove Timer"),categories["scripting"]);eventStyles[recordTypes.TimerFire]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Timer Fired"),categories["scripting"]);eventStyles[recordTypes.XHRReadyStateChange]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("XHR Ready State Change"),categories["scripting"]);eventStyles[recordTypes.XHRLoad]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("XHR Load"),categories["scripting"]);eventStyles[recordTypes.CompileScript]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Compile Script"),categories["scripting"]);eventStyles[recordTypes.EvaluateScript]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Evaluate Script"),categories["scripting"]);eventStyles[recordTypes.ParseScriptOnBackground]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Parse Script"),categories["scripting"]);eventStyles[recordTypes.MarkLoad]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Load event"),categories["scripting"],true);eventStyles[recordTypes.MarkDOMContent]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("DOMContentLoaded event"),categories["scripting"],true);eventStyles[recordTypes.MarkFirstPaint]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("First paint"),categories["painting"],true);eventStyles[recordTypes.TimeStamp]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Timestamp"),categories["scripting"]);eventStyles[recordTypes.ConsoleTime]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Console Time"),categories["scripting"]);eventStyles[recordTypes.UserTiming]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("User Timing"),categories["scripting"]);eventStyles[recordTypes.ResourceSendRequest]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Send Request"),categories["loading"]);eventStyles[recordTypes.ResourceReceiveResponse]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Receive Response"),categories["loading"]);eventStyles[recordTypes.ResourceFinish]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Finish Loading"),categories["loading"]);eventStyles[recordTypes.ResourceReceivedData]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Receive Data"),categories["loading"]);eventStyles[recordTypes.RunMicrotasks]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Run Microtasks"),categories["scripting"]);eventStyles[recordTypes.FunctionCall]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Function Call"),categories["scripting"]);eventStyles[recordTypes.GCEvent]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("GC Event"),categories["scripting"]);eventStyles[recordTypes.MajorGC]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Major GC"),categories["scripting"]);eventStyles[recordTypes.MinorGC]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Minor GC"),categories["scripting"]);eventStyles[recordTypes.JSFrame]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("JS Frame"),categories["scripting"]);eventStyles[recordTypes.RequestAnimationFrame]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Request Animation Frame"),categories["scripting"]);eventStyles[recordTypes.CancelAnimationFrame]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Cancel Animation Frame"),categories["scripting"]);eventStyles[recordTypes.FireAnimationFrame]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Animation Frame Fired"),categories["scripting"]);eventStyles[recordTypes.RequestIdleCallback]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Request Idle Callback"),categories["scripting"]);eventStyles[recordTypes.CancelIdleCallback]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Cancel Idle Callback"),categories["scripting"]);eventStyles[recordTypes.FireIdleCallback]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Fire Idle Callback"),categories["scripting"]);eventStyles[recordTypes.WebSocketCreate]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Create WebSocket"),categories["scripting"]);eventStyles[recordTypes.WebSocketSendHandshakeRequest]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Send WebSocket Handshake"),categories["scripting"]);eventStyles[recordTypes.WebSocketReceiveHandshakeResponse]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Receive WebSocket Handshake"),categories["scripting"]);eventStyles[recordTypes.WebSocketDestroy]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Destroy WebSocket"),categories["scripting"]);eventStyles[recordTypes.EmbedderCallback]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Embedder Callback"),categories["scripting"]);eventStyles[recordTypes.DecodeImage]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Image Decode"),categories["painting"]);eventStyles[recordTypes.ResizeImage]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Image Resize"),categories["painting"]);eventStyles[recordTypes.GPUTask]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("GPU"),categories["gpu"]);eventStyles[recordTypes.LatencyInfo]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("Input Latency"),categories["scripting"]);eventStyles[recordTypes.GCIdleLazySweep]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("DOM GC"),categories["scripting"]);eventStyles[recordTypes.GCCompleteSweep]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("DOM GC"),categories["scripting"]);eventStyles[recordTypes.GCCollectGarbage]=new WebInspector.TimelineRecordStyle(WebInspector.UIString("DOM GC"),categories["scripting"]);WebInspector.TimelineUIUtils._eventStylesMap=eventStyles;return eventStyles;}
WebInspector.TimelineUIUtils.inputEventDisplayName=function(inputEventType)
{if(!WebInspector.TimelineUIUtils._inputEventToDisplayName){var inputEvent=WebInspector.TimelineIRModel.InputEvents;WebInspector.TimelineUIUtils._inputEventToDisplayName=new Map([[inputEvent.Char,WebInspector.UIString("Key Character")],[inputEvent.KeyDown,WebInspector.UIString("Key Down")],[inputEvent.KeyDownRaw,WebInspector.UIString("Key Down")],[inputEvent.KeyUp,WebInspector.UIString("Key Up")],[inputEvent.Click,WebInspector.UIString("Click")],[inputEvent.ContextMenu,WebInspector.UIString("Context Menu")],[inputEvent.MouseDown,WebInspector.UIString("Mouse Down")],[inputEvent.MouseMove,WebInspector.UIString("Mouse Move")],[inputEvent.MouseUp,WebInspector.UIString("Mouse Up")],[inputEvent.MouseWheel,WebInspector.UIString("Mouse Wheel")],[inputEvent.ScrollBegin,WebInspector.UIString("Scroll Begin")],[inputEvent.ScrollEnd,WebInspector.UIString("Scroll End")],[inputEvent.ScrollUpdate,WebInspector.UIString("Scroll Update")],[inputEvent.FlingStart,WebInspector.UIString("Fling Start")],[inputEvent.FlingCancel,WebInspector.UIString("Fling Halt")],[inputEvent.Tap,WebInspector.UIString("Tap")],[inputEvent.TapCancel,WebInspector.UIString("Tap Halt")],[inputEvent.ShowPress,WebInspector.UIString("Tap Begin")],[inputEvent.TapDown,WebInspector.UIString("Tap Down")],[inputEvent.TouchCancel,WebInspector.UIString("Touch Cancel")],[inputEvent.TouchEnd,WebInspector.UIString("Touch End")],[inputEvent.TouchMove,WebInspector.UIString("Touch Move")],[inputEvent.TouchStart,WebInspector.UIString("Touch Start")],[inputEvent.PinchBegin,WebInspector.UIString("Pinch Begin")],[inputEvent.PinchEnd,WebInspector.UIString("Pinch End")],[inputEvent.PinchUpdate,WebInspector.UIString("Pinch Update")]]);}
return WebInspector.TimelineUIUtils._inputEventToDisplayName.get(inputEventType)||null;}
WebInspector.TimelineUIUtils.testContentMatching=function(traceEvent,regExp)
{var title=WebInspector.TimelineUIUtils.eventStyle(traceEvent).title;var tokens=[title];if(traceEvent.url)
tokens.push(traceEvent.url);for(var argName in traceEvent.args){var argValue=traceEvent.args[argName];for(var key in argValue)
tokens.push(argValue[key]);}
return regExp.test(tokens.join("|"));}
WebInspector.TimelineUIUtils.categoryForRecord=function(record)
{return WebInspector.TimelineUIUtils.eventStyle(record.traceEvent()).category;}
WebInspector.TimelineUIUtils.eventStyle=function(event)
{var eventStyles=WebInspector.TimelineUIUtils._initEventStyles();if(event.hasCategory(WebInspector.TimelineModel.Category.Console)||event.hasCategory(WebInspector.TimelineModel.Category.UserTiming))
return{title:event.name,category:WebInspector.TimelineUIUtils.categories()["scripting"]};if(event.hasCategory(WebInspector.TimelineModel.Category.LatencyInfo)){var prefix="InputLatency::";var inputEventType=event.name.startsWith(prefix)?event.name.substr(prefix.length):event.name;var displayName=WebInspector.TimelineUIUtils.inputEventDisplayName((inputEventType));return{title:displayName||inputEventType,category:WebInspector.TimelineUIUtils.categories()["scripting"]};}
var result=eventStyles[event.name];if(!result){result=new WebInspector.TimelineRecordStyle(event.name,WebInspector.TimelineUIUtils.categories()["other"],true);eventStyles[event.name]=result;}
return result;}
WebInspector.TimelineUIUtils.eventColor=function(event)
{if(event.name===WebInspector.TimelineModel.RecordType.JSFrame){var frame=event.args["data"];if(WebInspector.TimelineUIUtils.isUserFrame(frame))
return WebInspector.TimelineUIUtils.colorForURL(frame.url);}
return WebInspector.TimelineUIUtils.eventStyle(event).category.color;}
WebInspector.TimelineUIUtils.eventTitle=function(event)
{var title=WebInspector.TimelineUIUtils.eventStyle(event).title;if(event.hasCategory(WebInspector.TimelineModel.Category.Console))
return title;if(event.name===WebInspector.TimelineModel.RecordType.TimeStamp)
return WebInspector.UIString("%s: %s",title,event.args["data"]["message"]);if(event.name===WebInspector.TimelineModel.RecordType.Animation&&event.args["data"]&&event.args["data"]["name"])
return WebInspector.UIString("%s: %s",title,event.args["data"]["name"]);return title;}
WebInspector.TimelineUIUtils.eventURL=function(event)
{if(event.url)
return event.url;var data=event.args["data"]||event.args["beginData"];return data&&data.url||null;}
WebInspector.TimelineUIUtils._interactionPhaseStyles=function()
{var map=WebInspector.TimelineUIUtils._interactionPhaseStylesMap;if(!map){map=new Map([[WebInspector.TimelineIRModel.Phases.Idle,{color:"white",label:"Idle"}],[WebInspector.TimelineIRModel.Phases.Response,{color:"hsl(43, 83%, 64%)",label:WebInspector.UIString("Response")}],[WebInspector.TimelineIRModel.Phases.Scroll,{color:"hsl(256, 67%, 70%)",label:WebInspector.UIString("Scroll")}],[WebInspector.TimelineIRModel.Phases.Fling,{color:"hsl(256, 67%, 70%)",label:WebInspector.UIString("Fling")}],[WebInspector.TimelineIRModel.Phases.Drag,{color:"hsl(256, 67%, 70%)",label:WebInspector.UIString("Drag")}],[WebInspector.TimelineIRModel.Phases.Animation,{color:"hsl(256, 67%, 70%)",label:WebInspector.UIString("Animation")}],[WebInspector.TimelineIRModel.Phases.Uncategorized,{color:"hsl(0, 0%, 87%)",label:WebInspector.UIString("Uncategorized")}]]);WebInspector.TimelineUIUtils._interactionPhaseStylesMap=map;}
return map;}
WebInspector.TimelineUIUtils.interactionPhaseColor=function(phase)
{return WebInspector.TimelineUIUtils._interactionPhaseStyles().get(phase).color;}
WebInspector.TimelineUIUtils.interactionPhaseLabel=function(phase)
{return WebInspector.TimelineUIUtils._interactionPhaseStyles().get(phase).label;}
WebInspector.TimelineUIUtils.isUserFrame=function(frame)
{return frame.scriptId!=="0"&&!(frame.url&&frame.url.startsWith("native "));}
WebInspector.TimelineUIUtils.topStackFrame=function(event)
{var stackTrace=event.stackTrace||event.initiator&&event.initiator.stackTrace;return stackTrace&&stackTrace.length?stackTrace[0]:null;}
WebInspector.TimelineUIUtils.NetworkCategory={HTML:Symbol("HTML"),Script:Symbol("Script"),Style:Symbol("Style"),Media:Symbol("Media"),Other:Symbol("Other")}
WebInspector.TimelineUIUtils.networkRequestCategory=function(request)
{var categories=WebInspector.TimelineUIUtils.NetworkCategory;switch(request.mimeType){case"text/html":return categories.HTML;case"application/javascript":case"application/x-javascript":case"text/javascript":return categories.Script;case"text/css":return categories.Style;case"audio/ogg":case"image/gif":case"image/jpeg":case"image/png":case"image/svg+xml":case"image/webp":case"image/x-icon":case"font/opentype":case"font/woff2":case"application/font-woff":return categories.Media;default:return categories.Other;}}
WebInspector.TimelineUIUtils.networkCategoryColor=function(category)
{var categories=WebInspector.TimelineUIUtils.NetworkCategory;switch(category){case categories.HTML:return"hsl(214, 67%, 66%)";case categories.Script:return"hsl(43, 83%, 64%)";case categories.Style:return"hsl(256, 67%, 70%)";case categories.Media:return"hsl(109, 33%, 55%)";default:return"hsl(0, 0%, 70%)";}}
WebInspector.TimelineUIUtils.buildDetailsTextForTraceEvent=function(event,target)
{var recordType=WebInspector.TimelineModel.RecordType;var detailsText;var eventData=event.args["data"];switch(event.name){case recordType.GCEvent:case recordType.MajorGC:case recordType.MinorGC:var delta=event.args["usedHeapSizeBefore"]-event.args["usedHeapSizeAfter"];detailsText=WebInspector.UIString("%s collected",Number.bytesToString(delta));break;case recordType.FunctionCall:if(eventData)
detailsText=linkifyLocationAsText(eventData["scriptId"],eventData["lineNumber"],0);break;case recordType.JSFrame:detailsText=WebInspector.beautifyFunctionName(eventData["functionName"]);break;case recordType.EventDispatch:detailsText=eventData?eventData["type"]:null;break;case recordType.Paint:var width=WebInspector.TimelineUIUtils.quadWidth(eventData.clip);var height=WebInspector.TimelineUIUtils.quadHeight(eventData.clip);if(width&&height)
detailsText=WebInspector.UIString("%d\u2009\u00d7\u2009%d",width,height);break;case recordType.ParseHTML:var endLine=event.args["endData"]&&event.args["endData"]["endLine"];var url=WebInspector.displayNameForURL(event.args["beginData"]["url"]);detailsText=WebInspector.UIString("%s [%s\u2026%s]",url,event.args["beginData"]["startLine"]+1,endLine>=0?endLine+1:"");break;case recordType.CompileScript:case recordType.EvaluateScript:var url=eventData["url"];if(url)
detailsText=WebInspector.displayNameForURL(url)+":"+(eventData["lineNumber"]+1);break;case recordType.ParseScriptOnBackground:case recordType.XHRReadyStateChange:case recordType.XHRLoad:var url=eventData["url"];if(url)
detailsText=WebInspector.displayNameForURL(url);break;case recordType.TimeStamp:detailsText=eventData["message"];break;case recordType.WebSocketCreate:case recordType.WebSocketSendHandshakeRequest:case recordType.WebSocketReceiveHandshakeResponse:case recordType.WebSocketDestroy:case recordType.ResourceSendRequest:case recordType.ResourceReceivedData:case recordType.ResourceReceiveResponse:case recordType.ResourceFinish:case recordType.PaintImage:case recordType.DecodeImage:case recordType.ResizeImage:case recordType.DecodeLazyPixelRef:if(event.url)
detailsText=WebInspector.displayNameForURL(event.url);break;case recordType.EmbedderCallback:detailsText=eventData["callbackName"];break;case recordType.Animation:detailsText=eventData&&eventData["name"];break;case recordType.GCIdleLazySweep:detailsText=WebInspector.UIString("idle sweep");break;case recordType.GCCompleteSweep:detailsText=WebInspector.UIString("complete sweep");break;case recordType.GCCollectGarbage:detailsText=WebInspector.UIString("collect");break;default:if(event.hasCategory(WebInspector.TimelineModel.Category.Console))
detailsText=null;else
detailsText=linkifyTopCallFrameAsText();break;}
return detailsText;function linkifyLocationAsText(scriptId,lineNumber,columnNumber)
{var debuggerModel=WebInspector.DebuggerModel.fromTarget(target);if(!target||target.isDetached()||!scriptId||!debuggerModel)
return null;var rawLocation=debuggerModel.createRawLocationByScriptId(scriptId,lineNumber,columnNumber);if(!rawLocation)
return null;var uiLocation=WebInspector.debuggerWorkspaceBinding.rawLocationToUILocation(rawLocation);return uiLocation.linkText();}
function linkifyTopCallFrameAsText()
{var frame=WebInspector.TimelineUIUtils.topStackFrame(event);if(!frame)
return null;var text=linkifyLocationAsText(frame.scriptId,frame.lineNumber,frame.columnNumber);if(!text){text=frame.url;if(typeof frame.lineNumber==="number")
text+=":"+(frame.lineNumber+1);}
return text;}}
WebInspector.TimelineUIUtils.buildDetailsNodeForTraceEvent=function(event,target,linkifier)
{var recordType=WebInspector.TimelineModel.RecordType;var details=null;var detailsText;var eventData=event.args["data"];switch(event.name){case recordType.GCEvent:case recordType.MajorGC:case recordType.MinorGC:case recordType.EventDispatch:case recordType.Paint:case recordType.Animation:case recordType.EmbedderCallback:case recordType.ParseHTML:case recordType.WebSocketCreate:case recordType.WebSocketSendHandshakeRequest:case recordType.WebSocketReceiveHandshakeResponse:case recordType.WebSocketDestroy:case recordType.GCIdleLazySweep:case recordType.GCCompleteSweep:case recordType.GCCollectGarbage:detailsText=WebInspector.TimelineUIUtils.buildDetailsTextForTraceEvent(event,target);break;case recordType.PaintImage:case recordType.DecodeImage:case recordType.ResizeImage:case recordType.DecodeLazyPixelRef:case recordType.XHRReadyStateChange:case recordType.XHRLoad:case recordType.ResourceSendRequest:case recordType.ResourceReceivedData:case recordType.ResourceReceiveResponse:case recordType.ResourceFinish:if(event.url)
details=WebInspector.linkifyResourceAsNode(event.url);break;case recordType.FunctionCall:case recordType.JSFrame:details=createElement("span");details.createTextChild(WebInspector.beautifyFunctionName(eventData["functionName"]));var location=linkifyLocation(eventData["scriptId"],eventData["url"],eventData["lineNumber"],eventData["columnNumber"]);if(location){details.createTextChild(" @ ");details.appendChild(location);}
break;case recordType.CompileScript:case recordType.EvaluateScript:var url=eventData["url"];if(url)
details=linkifyLocation("",url,eventData["lineNumber"],0);break;case recordType.ParseScriptOnBackground:var url=eventData["url"];if(url)
details=linkifyLocation("",url,0,0);break;default:if(event.hasCategory(WebInspector.TimelineModel.Category.Console))
detailsText=null;else
details=linkifyTopCallFrame();break;}
if(!details&&detailsText)
details=createTextNode(detailsText);return details;function linkifyLocation(scriptId,url,lineNumber,columnNumber)
{return linkifier.linkifyScriptLocation(target,scriptId,url,lineNumber,columnNumber,"timeline-details");}
function linkifyTopCallFrame()
{var frame=WebInspector.TimelineUIUtils.topStackFrame(event);return frame?linkifier.maybeLinkifyConsoleCallFrame(target,frame,"timeline-details"):null;}}
WebInspector.TimelineUIUtils.buildTraceEventDetails=function(event,model,linkifier,detailed,callback)
{var target=model.targetByEvent(event);if(!target){callbackWrapper();return;}
var relatedNodes=null;var barrier=new CallbackBarrier();if(!event.previewElement){if(event.url)
WebInspector.DOMPresentationUtils.buildImagePreviewContents(target,event.url,false,barrier.createCallback(saveImage));else if(event.picture)
WebInspector.TimelineUIUtils.buildPicturePreviewContent(event,target,barrier.createCallback(saveImage));}
var nodeIdsToResolve=new Set();if(event.backendNodeId)
nodeIdsToResolve.add(event.backendNodeId);if(event.invalidationTrackingEvents)
WebInspector.TimelineUIUtils._collectInvalidationNodeIds(nodeIdsToResolve,event.invalidationTrackingEvents);if(nodeIdsToResolve.size){var domModel=WebInspector.DOMModel.fromTarget(target);if(domModel)
domModel.pushNodesByBackendIdsToFrontend(nodeIdsToResolve,barrier.createCallback(setRelatedNodeMap));}
barrier.callWhenDone(callbackWrapper);function saveImage(element)
{event.previewElement=element||null;}
function setRelatedNodeMap(nodeMap)
{relatedNodes=nodeMap;}
function callbackWrapper()
{callback(WebInspector.TimelineUIUtils._buildTraceEventDetailsSynchronously(event,model,linkifier,detailed,relatedNodes));}}
WebInspector.TimelineUIUtils._buildTraceEventDetailsSynchronously=function(event,model,linkifier,detailed,relatedNodesMap)
{var stats={};var recordTypes=WebInspector.TimelineModel.RecordType;var relatedNodeLabel;var contentHelper=new WebInspector.TimelineDetailsContentHelper(model.targetByEvent(event),linkifier);contentHelper.addSection(WebInspector.TimelineUIUtils.eventTitle(event),WebInspector.TimelineUIUtils.eventStyle(event).category);var eventData=event.args["data"];var initiator=event.initiator;if(event.warning)
contentHelper.appendWarningRow(event);if(event.name===recordTypes.JSFrame&&eventData["deoptReason"])
contentHelper.appendWarningRow(event,WebInspector.TimelineModel.WarningType.V8Deopt);if(detailed){contentHelper.appendTextRow(WebInspector.UIString("Self Time"),Number.millisToString(event.selfTime,true));contentHelper.appendTextRow(WebInspector.UIString("Total Time"),Number.millisToString(event.duration||0,true));}
switch(event.name){case recordTypes.GCEvent:case recordTypes.MajorGC:case recordTypes.MinorGC:var delta=event.args["usedHeapSizeBefore"]-event.args["usedHeapSizeAfter"];contentHelper.appendTextRow(WebInspector.UIString("Collected"),Number.bytesToString(delta));break;case recordTypes.JSFrame:case recordTypes.FunctionCall:var detailsNode=WebInspector.TimelineUIUtils.buildDetailsNodeForTraceEvent(event,model.targetByEvent(event),linkifier);if(detailsNode)
contentHelper.appendElementRow(WebInspector.UIString("Function"),detailsNode);break;case recordTypes.TimerFire:case recordTypes.TimerInstall:case recordTypes.TimerRemove:contentHelper.appendTextRow(WebInspector.UIString("Timer ID"),eventData["timerId"]);if(event.name===recordTypes.TimerInstall){contentHelper.appendTextRow(WebInspector.UIString("Timeout"),Number.millisToString(eventData["timeout"]));contentHelper.appendTextRow(WebInspector.UIString("Repeats"),!eventData["singleShot"]);}
break;case recordTypes.FireAnimationFrame:contentHelper.appendTextRow(WebInspector.UIString("Callback ID"),eventData["id"]);break;case recordTypes.ResourceSendRequest:case recordTypes.ResourceReceiveResponse:case recordTypes.ResourceReceivedData:case recordTypes.ResourceFinish:var url=(event.name===recordTypes.ResourceSendRequest)?eventData["url"]:initiator&&initiator.args["data"]["url"];if(url)
contentHelper.appendElementRow(WebInspector.UIString("Resource"),WebInspector.linkifyResourceAsNode(url));if(eventData["requestMethod"])
contentHelper.appendTextRow(WebInspector.UIString("Request Method"),eventData["requestMethod"]);if(typeof eventData["statusCode"]==="number")
contentHelper.appendTextRow(WebInspector.UIString("Status Code"),eventData["statusCode"]);if(eventData["mimeType"])
contentHelper.appendTextRow(WebInspector.UIString("MIME Type"),eventData["mimeType"]);if("priority"in eventData){var priority=WebInspector.uiLabelForPriority(eventData["priority"]);contentHelper.appendTextRow(WebInspector.UIString("Priority"),priority);}
if(eventData["encodedDataLength"])
contentHelper.appendTextRow(WebInspector.UIString("Encoded Data Length"),WebInspector.UIString("%d Bytes",eventData["encodedDataLength"]));break;case recordTypes.CompileScript:case recordTypes.EvaluateScript:var url=eventData["url"];if(url)
contentHelper.appendLocationRow(WebInspector.UIString("Script"),url,eventData["lineNumber"],eventData["columnNumber"]);break;case recordTypes.Paint:var clip=eventData["clip"];contentHelper.appendTextRow(WebInspector.UIString("Location"),WebInspector.UIString("(%d, %d)",clip[0],clip[1]));var clipWidth=WebInspector.TimelineUIUtils.quadWidth(clip);var clipHeight=WebInspector.TimelineUIUtils.quadHeight(clip);contentHelper.appendTextRow(WebInspector.UIString("Dimensions"),WebInspector.UIString("%d × %d",clipWidth,clipHeight));case recordTypes.PaintSetup:case recordTypes.Rasterize:case recordTypes.ScrollLayer:relatedNodeLabel=WebInspector.UIString("Layer Root");break;case recordTypes.PaintImage:case recordTypes.DecodeLazyPixelRef:case recordTypes.DecodeImage:case recordTypes.ResizeImage:case recordTypes.DrawLazyPixelRef:relatedNodeLabel=WebInspector.UIString("Owner Element");if(event.url)
contentHelper.appendElementRow(WebInspector.UIString("Image URL"),WebInspector.linkifyResourceAsNode(event.url));break;case recordTypes.ParseAuthorStyleSheet:var url=eventData["styleSheetUrl"];if(url)
contentHelper.appendElementRow(WebInspector.UIString("Stylesheet URL"),WebInspector.linkifyResourceAsNode(url));break;case recordTypes.UpdateLayoutTree:case recordTypes.RecalculateStyles:contentHelper.appendTextRow(WebInspector.UIString("Elements Affected"),event.args["elementCount"]);break;case recordTypes.Layout:var beginData=event.args["beginData"];contentHelper.appendTextRow(WebInspector.UIString("Nodes That Need Layout"),WebInspector.UIString("%s of %s",beginData["dirtyObjects"],beginData["totalObjects"]));relatedNodeLabel=WebInspector.UIString("Layout root");break;case recordTypes.ConsoleTime:contentHelper.appendTextRow(WebInspector.UIString("Message"),event.name);break;case recordTypes.WebSocketCreate:case recordTypes.WebSocketSendHandshakeRequest:case recordTypes.WebSocketReceiveHandshakeResponse:case recordTypes.WebSocketDestroy:var initiatorData=initiator?initiator.args["data"]:eventData;if(typeof initiatorData["webSocketURL"]!=="undefined")
contentHelper.appendTextRow(WebInspector.UIString("URL"),initiatorData["webSocketURL"]);if(typeof initiatorData["webSocketProtocol"]!=="undefined")
contentHelper.appendTextRow(WebInspector.UIString("WebSocket Protocol"),initiatorData["webSocketProtocol"]);if(typeof eventData["message"]!=="undefined")
contentHelper.appendTextRow(WebInspector.UIString("Message"),eventData["message"]);break;case recordTypes.EmbedderCallback:contentHelper.appendTextRow(WebInspector.UIString("Callback Function"),eventData["callbackName"]);break;case recordTypes.Animation:if(event.phase===WebInspector.TracingModel.Phase.NestableAsyncInstant)
contentHelper.appendTextRow(WebInspector.UIString("State"),eventData["state"]);break;case recordTypes.ParseHTML:var beginData=event.args["beginData"];var url=beginData["url"];var startLine=beginData["startLine"]-1;var endLine=event.args["endData"]?event.args["endData"]["endLine"]-1:undefined;if(url)
contentHelper.appendLocationRange(WebInspector.UIString("Range"),url,startLine,endLine);break;case recordTypes.FireIdleCallback:contentHelper.appendTextRow(WebInspector.UIString("Allotted Time"),Number.millisToString(eventData["allottedMilliseconds"]));contentHelper.appendTextRow(WebInspector.UIString("Invoked by Timeout"),eventData["timedOut"]);case recordTypes.RequestIdleCallback:case recordTypes.CancelIdleCallback:contentHelper.appendTextRow(WebInspector.UIString("Callback ID"),eventData["id"]);break;case recordTypes.EventDispatch:contentHelper.appendTextRow(WebInspector.UIString("Type"),eventData["type"]);break;default:var detailsNode=WebInspector.TimelineUIUtils.buildDetailsNodeForTraceEvent(event,model.targetByEvent(event),linkifier);if(detailsNode)
contentHelper.appendElementRow(WebInspector.UIString("Details"),detailsNode);break;}
if(event.timeWaitingForMainThread)
contentHelper.appendTextRow(WebInspector.UIString("Time Waiting for Main Thread"),Number.millisToString(event.timeWaitingForMainThread,true));var relatedNode=relatedNodesMap&&relatedNodesMap.get(event.backendNodeId);if(relatedNode)
contentHelper.appendElementRow(relatedNodeLabel||WebInspector.UIString("Related Node"),WebInspector.DOMPresentationUtils.linkifyNodeReference(relatedNode));if(event.previewElement){contentHelper.addSection(WebInspector.UIString("Preview"));contentHelper.appendElementRow("",event.previewElement);}
if(event.stackTrace||(event.initiator&&event.initiator.stackTrace)||event.invalidationTrackingEvents)
WebInspector.TimelineUIUtils._generateCauses(event,model.targetByEvent(event),relatedNodesMap,contentHelper);var showPieChart=detailed&&WebInspector.TimelineUIUtils._aggregatedStatsForTraceEvent(stats,model,event);if(showPieChart){contentHelper.addSection(WebInspector.UIString("Aggregated Time"));var pieChart=WebInspector.TimelineUIUtils.generatePieChart(stats,WebInspector.TimelineUIUtils.eventStyle(event).category,event.selfTime);contentHelper.appendElementRow("",pieChart);}
return contentHelper.fragment;}
WebInspector.TimelineUIUtils._aggregatedStatsKey=Symbol("aggregatedStats");WebInspector.TimelineUIUtils.buildRangeStats=function(model,startTime,endTime)
{var aggregatedStats={};function compareEndTime(value,task)
{return value<task.endTime()?-1:1;}
var mainThreadTasks=model.mainThreadTasks();var taskIndex=mainThreadTasks.lowerBound(startTime,compareEndTime);for(;taskIndex<mainThreadTasks.length;++taskIndex){var task=mainThreadTasks[taskIndex];if(task.startTime()>endTime)
break;if(task.startTime()>startTime&&task.endTime()<endTime){var taskStats=task[WebInspector.TimelineUIUtils._aggregatedStatsKey];if(!taskStats){taskStats={};WebInspector.TimelineUIUtils._collectAggregatedStatsForRecord(task,startTime,endTime,taskStats);task[WebInspector.TimelineUIUtils._aggregatedStatsKey]=taskStats;}
for(var key in taskStats)
aggregatedStats[key]=(aggregatedStats[key]||0)+taskStats[key];continue;}
WebInspector.TimelineUIUtils._collectAggregatedStatsForRecord(task,startTime,endTime,aggregatedStats);}
var aggregatedTotal=0;for(var categoryName in aggregatedStats)
aggregatedTotal+=aggregatedStats[categoryName];aggregatedStats["idle"]=Math.max(0,endTime-startTime-aggregatedTotal);var startOffset=startTime-model.minimumRecordTime();var endOffset=endTime-model.minimumRecordTime();var contentHelper=new WebInspector.TimelineDetailsContentHelper(null,null);contentHelper.addSection(WebInspector.UIString("Range:  %s \u2013 %s",Number.millisToString(startOffset),Number.millisToString(endOffset)));var pieChart=WebInspector.TimelineUIUtils.generatePieChart(aggregatedStats);contentHelper.appendElementRow("",pieChart);return contentHelper.fragment;}
WebInspector.TimelineUIUtils._collectAggregatedStatsForRecord=function(record,startTime,endTime,aggregatedStats)
{var records=[];if(!record.endTime()||record.endTime()<startTime||record.startTime()>endTime)
return;var childrenTime=0;var children=record.children()||[];for(var i=0;i<children.length;++i){var child=children[i];if(!child.endTime()||child.endTime()<startTime||child.startTime()>endTime)
continue;childrenTime+=Math.min(endTime,child.endTime())-Math.max(startTime,child.startTime());WebInspector.TimelineUIUtils._collectAggregatedStatsForRecord(child,startTime,endTime,aggregatedStats);}
var categoryName=WebInspector.TimelineUIUtils.categoryForRecord(record).name;var ownTime=Math.min(endTime,record.endTime())-Math.max(startTime,record.startTime())-childrenTime;aggregatedStats[categoryName]=(aggregatedStats[categoryName]||0)+ownTime;}
WebInspector.TimelineUIUtils.buildNetworkRequestDetails=function(request,model,linkifier)
{var target=model.targetByEvent(request.children[0]);var contentHelper=new WebInspector.TimelineDetailsContentHelper(target,linkifier);var duration=request.endTime-(request.startTime||-Infinity);var items=[];if(request.url)
contentHelper.appendElementRow(WebInspector.UIString("URL"),WebInspector.linkifyURLAsNode(request.url));if(isFinite(duration))
contentHelper.appendTextRow(WebInspector.UIString("Duration"),Number.millisToString(duration,true));if(request.requestMethod)
contentHelper.appendTextRow(WebInspector.UIString("Request Method"),request.requestMethod);if(typeof request.priority==="string"){var priority=WebInspector.uiLabelForPriority((request.priority));contentHelper.appendTextRow(WebInspector.UIString("Priority"),priority);}
if(request.mimeType)
contentHelper.appendTextRow(WebInspector.UIString("Mime Type"),request.mimeType);var title=WebInspector.UIString("Initiator");var sendRequest=request.children[0];var topFrame=WebInspector.TimelineUIUtils.topStackFrame(sendRequest);if(topFrame){var link=linkifier.maybeLinkifyConsoleCallFrame(target,topFrame);if(link)
contentHelper.appendElementRow(title,link);}else if(sendRequest.initiator){var initiatorURL=WebInspector.TimelineUIUtils.eventURL(sendRequest.initiator);if(initiatorURL){var link=linkifier.maybeLinkifyScriptLocation(target,null,initiatorURL,0);if(link)
contentHelper.appendElementRow(title,link);}}
function action(fulfill)
{WebInspector.DOMPresentationUtils.buildImagePreviewContents((target),request.url,false,saveImage);function saveImage(element)
{request.previewElement=element||null;fulfill(request.previewElement);}}
var previewPromise;if(request.previewElement)
previewPromise=Promise.resolve(request.previewElement);else
previewPromise=request.url&&target?new Promise(action):Promise.resolve(null);function appendPreview(element)
{if(element)
contentHelper.appendElementRow(WebInspector.UIString("Preview"),request.previewElement);return contentHelper.fragment;}
return previewPromise.then(appendPreview);}
WebInspector.TimelineUIUtils._stackTraceFromCallFrames=function(callFrames)
{return({callFrames:callFrames});}
WebInspector.TimelineUIUtils._generateCauses=function(event,target,relatedNodesMap,contentHelper)
{var recordTypes=WebInspector.TimelineModel.RecordType;var callSiteStackLabel;var stackLabel;var initiator=event.initiator;switch(event.name){case recordTypes.TimerFire:callSiteStackLabel=WebInspector.UIString("Timer Installed");break;case recordTypes.FireAnimationFrame:callSiteStackLabel=WebInspector.UIString("Animation Frame Requested");break;case recordTypes.FireIdleCallback:callSiteStackLabel=WebInspector.UIString("Idle Callback Requested");break;case recordTypes.UpdateLayoutTree:case recordTypes.RecalculateStyles:stackLabel=WebInspector.UIString("Recalculation Forced");break;case recordTypes.Layout:callSiteStackLabel=WebInspector.UIString("First Layout Invalidation");stackLabel=WebInspector.UIString("Layout Forced");break;}
if(event.stackTrace&&event.stackTrace.length){contentHelper.addSection(WebInspector.UIString("Call Stacks"));contentHelper.appendStackTrace(stackLabel||WebInspector.UIString("Stack Trace"),WebInspector.TimelineUIUtils._stackTraceFromCallFrames(event.stackTrace));}
if(event.invalidationTrackingEvents&&target){contentHelper.addSection(WebInspector.UIString("Invalidations"));WebInspector.TimelineUIUtils._generateInvalidations(event,target,relatedNodesMap,contentHelper);}else if(initiator&&initiator.stackTrace){contentHelper.appendStackTrace(callSiteStackLabel||WebInspector.UIString("First Invalidated"),WebInspector.TimelineUIUtils._stackTraceFromCallFrames(initiator.stackTrace));}}
WebInspector.TimelineUIUtils._generateInvalidations=function(event,target,relatedNodesMap,contentHelper)
{if(!event.invalidationTrackingEvents)
return;var invalidations={};event.invalidationTrackingEvents.forEach(function(invalidation){if(!invalidations[invalidation.type])
invalidations[invalidation.type]=[invalidation];else
invalidations[invalidation.type].push(invalidation);});Object.keys(invalidations).forEach(function(type){WebInspector.TimelineUIUtils._generateInvalidationsForType(type,target,invalidations[type],relatedNodesMap,contentHelper);});}
WebInspector.TimelineUIUtils._generateInvalidationsForType=function(type,target,invalidations,relatedNodesMap,contentHelper)
{var title;switch(type){case WebInspector.TimelineModel.RecordType.StyleRecalcInvalidationTracking:title=WebInspector.UIString("Style Invalidations");break;case WebInspector.TimelineModel.RecordType.LayoutInvalidationTracking:title=WebInspector.UIString("Layout Invalidations");break;default:title=WebInspector.UIString("Other Invalidations");break;}
var invalidationsTreeOutline=new TreeOutlineInShadow();invalidationsTreeOutline.registerRequiredCSS("timeline/invalidationsTree.css");invalidationsTreeOutline.element.classList.add("invalidations-tree");var invalidationGroups=groupInvalidationsByCause(invalidations);invalidationGroups.forEach(function(group){var groupElement=new WebInspector.TimelineUIUtils.InvalidationsGroupElement(target,relatedNodesMap,contentHelper,group);invalidationsTreeOutline.appendChild(groupElement);});contentHelper.appendElementRow(title,invalidationsTreeOutline.element,false,true);function groupInvalidationsByCause(invalidations)
{var causeToInvalidationMap=new Map();for(var index=0;index<invalidations.length;index++){var invalidation=invalidations[index];var causeKey="";if(invalidation.cause.reason)
causeKey+=invalidation.cause.reason+".";if(invalidation.cause.stackTrace){invalidation.cause.stackTrace.forEach(function(stackFrame){causeKey+=stackFrame["functionName"]+".";causeKey+=stackFrame["scriptId"]+".";causeKey+=stackFrame["url"]+".";causeKey+=stackFrame["lineNumber"]+".";causeKey+=stackFrame["columnNumber"]+".";});}
if(causeToInvalidationMap.has(causeKey))
causeToInvalidationMap.get(causeKey).push(invalidation);else
causeToInvalidationMap.set(causeKey,[invalidation]);}
return causeToInvalidationMap.valuesArray();}}
WebInspector.TimelineUIUtils._collectInvalidationNodeIds=function(nodeIds,invalidations)
{for(var i=0;i<invalidations.length;++i){if(invalidations[i].nodeId)
nodeIds.add(invalidations[i].nodeId);}}
WebInspector.TimelineUIUtils.InvalidationsGroupElement=function(target,relatedNodesMap,contentHelper,invalidations)
{TreeElement.call(this,"",true);this.listItemElement.classList.add("header");this.selectable=false;this.toggleOnClick=true;this._relatedNodesMap=relatedNodesMap;this._contentHelper=contentHelper;this._invalidations=invalidations;this.title=this._createTitle(target);}
WebInspector.TimelineUIUtils.InvalidationsGroupElement.prototype={_createTitle:function(target)
{var first=this._invalidations[0];var reason=first.cause.reason;var topFrame=first.cause.stackTrace&&first.cause.stackTrace[0];var title=createElement("span");if(reason)
title.createTextChild(WebInspector.UIString("%s for ",reason));else
title.createTextChild(WebInspector.UIString("Unknown cause for "));this._appendTruncatedNodeList(title,this._invalidations);if(topFrame&&this._contentHelper.linkifier()){title.createTextChild(WebInspector.UIString(". "));var stack=title.createChild("span","monospace");stack.createChild("span").textContent=WebInspector.beautifyFunctionName(topFrame.functionName);var link=this._contentHelper.linkifier().maybeLinkifyConsoleCallFrame(target,topFrame);if(link){stack.createChild("span").textContent=" @ ";stack.createChild("span").appendChild(link);}}
return title;},onpopulate:function()
{var content=createElementWithClass("div","content");var first=this._invalidations[0];if(first.cause.stackTrace){var stack=content.createChild("div");stack.createTextChild(WebInspector.UIString("Stack trace:"));this._contentHelper.createChildStackTraceElement(stack,WebInspector.TimelineUIUtils._stackTraceFromCallFrames(first.cause.stackTrace));}
content.createTextChild(this._invalidations.length>1?WebInspector.UIString("Nodes:"):WebInspector.UIString("Node:"));var nodeList=content.createChild("div","node-list");var firstNode=true;for(var i=0;i<this._invalidations.length;i++){var invalidation=this._invalidations[i];var invalidationNode=this._createInvalidationNode(invalidation,true);if(invalidationNode){if(!firstNode)
nodeList.createTextChild(WebInspector.UIString(", "));firstNode=false;nodeList.appendChild(invalidationNode);var extraData=invalidation.extraData?", "+invalidation.extraData:"";if(invalidation.changedId)
nodeList.createTextChild(WebInspector.UIString("(changed id to \"%s\"%s)",invalidation.changedId,extraData));else if(invalidation.changedClass)
nodeList.createTextChild(WebInspector.UIString("(changed class to \"%s\"%s)",invalidation.changedClass,extraData));else if(invalidation.changedAttribute)
nodeList.createTextChild(WebInspector.UIString("(changed attribute to \"%s\"%s)",invalidation.changedAttribute,extraData));else if(invalidation.changedPseudo)
nodeList.createTextChild(WebInspector.UIString("(changed pesudo to \"%s\"%s)",invalidation.changedPseudo,extraData));else if(invalidation.selectorPart)
nodeList.createTextChild(WebInspector.UIString("(changed \"%s\"%s)",invalidation.selectorPart,extraData));}}
var contentTreeElement=new TreeElement(content,false);contentTreeElement.selectable=false;this.appendChild(contentTreeElement);},_appendTruncatedNodeList:function(parentElement,invalidations)
{var invalidationNodes=[];var invalidationNodeIdMap={};for(var i=0;i<invalidations.length;i++){var invalidation=invalidations[i];var invalidationNode=this._createInvalidationNode(invalidation,false);invalidationNode.addEventListener("click",(e)=>e.consume(),false);if(invalidationNode&&!invalidationNodeIdMap[invalidation.nodeId]){invalidationNodes.push(invalidationNode);invalidationNodeIdMap[invalidation.nodeId]=true;}}
if(invalidationNodes.length===1){parentElement.appendChild(invalidationNodes[0]);}else if(invalidationNodes.length===2){parentElement.appendChild(invalidationNodes[0]);parentElement.createTextChild(WebInspector.UIString(" and "));parentElement.appendChild(invalidationNodes[1]);}else if(invalidationNodes.length>=3){parentElement.appendChild(invalidationNodes[0]);parentElement.createTextChild(WebInspector.UIString(", "));parentElement.appendChild(invalidationNodes[1]);parentElement.createTextChild(WebInspector.UIString(", and %s others",invalidationNodes.length-2));}},_createInvalidationNode:function(invalidation,showUnknownNodes)
{var node=(invalidation.nodeId&&this._relatedNodesMap)?this._relatedNodesMap.get(invalidation.nodeId):null;if(node)
return WebInspector.DOMPresentationUtils.linkifyNodeReference(node);if(invalidation.nodeName){var nodeSpan=createElement("span");nodeSpan.textContent=WebInspector.UIString("[ %s ]",invalidation.nodeName);return nodeSpan;}
if(showUnknownNodes){var nodeSpan=createElement("span");return nodeSpan.createTextChild(WebInspector.UIString("[ unknown node ]"));}},__proto__:TreeElement.prototype}
WebInspector.TimelineUIUtils._aggregatedStatsForTraceEvent=function(total,model,event)
{var events=model.inspectedTargetEvents();function eventComparator(startTime,e)
{return startTime-e.startTime;}
var index=events.binaryIndexOf(event.startTime,eventComparator);if(index<0)
return false;var hasChildren=false;var endTime=event.endTime;if(endTime){for(var i=index;i<events.length;i++){var nextEvent=events[i];if(nextEvent.startTime>=endTime)
break;if(!nextEvent.selfTime)
continue;if(nextEvent.thread!==event.thread)
continue;if(i>index)
hasChildren=true;var categoryName=WebInspector.TimelineUIUtils.eventStyle(nextEvent).category.name;total[categoryName]=(total[categoryName]||0)+nextEvent.selfTime;}}
if(WebInspector.TracingModel.isAsyncPhase(event.phase)){if(event.endTime){var aggregatedTotal=0;for(var categoryName in total)
aggregatedTotal+=total[categoryName];total["idle"]=Math.max(0,event.endTime-event.startTime-aggregatedTotal);}
return false;}
return hasChildren;}
WebInspector.TimelineUIUtils.buildPicturePreviewContent=function(event,target,callback)
{new WebInspector.LayerPaintEvent(event,target).loadSnapshot(onSnapshotLoaded);function onSnapshotLoaded(rect,snapshot)
{if(!snapshot){callback();return;}
snapshot.requestImage(null,null,1,onGotImage);snapshot.dispose();}
function onGotImage(imageURL)
{if(!imageURL){callback();return;}
var container=createElement("div");container.classList.add("image-preview-container","vbox","link");var img=container.createChild("img");img.src=imageURL;var paintProfilerButton=container.createChild("a");paintProfilerButton.textContent=WebInspector.UIString("Paint Profiler");container.addEventListener("click",showPaintProfiler,false);callback(container);}
function showPaintProfiler()
{WebInspector.TimelinePanel.instance().select(WebInspector.TimelineSelection.fromTraceEvent(event),WebInspector.TimelinePanel.DetailsTab.PaintProfiler);}}
WebInspector.TimelineUIUtils.createEventDivider=function(recordType,title,position)
{var eventDivider=createElement("div");eventDivider.className="resources-event-divider";var recordTypes=WebInspector.TimelineModel.RecordType;if(recordType===recordTypes.MarkDOMContent)
eventDivider.className+=" resources-blue-divider";else if(recordType===recordTypes.MarkLoad)
eventDivider.className+=" resources-red-divider";else if(recordType===recordTypes.MarkFirstPaint)
eventDivider.className+=" resources-green-divider";else if(recordType===recordTypes.TimeStamp||recordType===recordTypes.ConsoleTime||recordType===recordTypes.UserTiming)
eventDivider.className+=" resources-orange-divider";else if(recordType===recordTypes.BeginFrame)
eventDivider.className+=" timeline-frame-divider";if(title)
eventDivider.title=title;eventDivider.style.left=position+"px";return eventDivider;}
WebInspector.TimelineUIUtils.createDividerForRecord=function(record,zeroTime,position)
{var startTime=Number.millisToString(record.startTime()-zeroTime);var title=WebInspector.UIString("%s at %s",WebInspector.TimelineUIUtils.eventTitle(record.traceEvent()),startTime);return WebInspector.TimelineUIUtils.createEventDivider(record.type(),title,position);}
WebInspector.TimelineUIUtils._visibleTypes=function()
{var eventStyles=WebInspector.TimelineUIUtils._initEventStyles();var result=[];for(var name in eventStyles){if(!eventStyles[name].hidden)
result.push(name);}
return result;}
WebInspector.TimelineUIUtils.visibleEventsFilter=function()
{return new WebInspector.TimelineVisibleEventsFilter(WebInspector.TimelineUIUtils._visibleTypes());}
WebInspector.TimelineUIUtils.categories=function()
{if(WebInspector.TimelineUIUtils._categories)
return WebInspector.TimelineUIUtils._categories;WebInspector.TimelineUIUtils._categories={loading:new WebInspector.TimelineCategory("loading",WebInspector.UIString("Loading"),true,"hsl(214, 67%, 74%)","hsl(214, 67%, 66%)"),scripting:new WebInspector.TimelineCategory("scripting",WebInspector.UIString("Scripting"),true,"hsl(43, 83%, 72%)","hsl(43, 83%, 64%) "),rendering:new WebInspector.TimelineCategory("rendering",WebInspector.UIString("Rendering"),true,"hsl(256, 67%, 76%)","hsl(256, 67%, 70%)"),painting:new WebInspector.TimelineCategory("painting",WebInspector.UIString("Painting"),true,"hsl(109, 33%, 64%)","hsl(109, 33%, 55%)"),gpu:new WebInspector.TimelineCategory("gpu",WebInspector.UIString("GPU"),false,"hsl(109, 33%, 64%)","hsl(109, 33%, 55%)"),other:new WebInspector.TimelineCategory("other",WebInspector.UIString("Other"),false,"hsl(0, 0%, 87%)","hsl(0, 0%, 79%)"),idle:new WebInspector.TimelineCategory("idle",WebInspector.UIString("Idle"),false,"hsl(0, 100%, 100%)","hsl(0, 100%, 100%)")};return WebInspector.TimelineUIUtils._categories;};WebInspector.TimelineUIUtils.titleForAsyncEventGroup=function(group)
{if(!WebInspector.TimelineUIUtils._titleForAsyncEventGroupMap){var groups=WebInspector.TimelineModel.AsyncEventGroup;WebInspector.TimelineUIUtils._titleForAsyncEventGroupMap=new Map([[groups.animation,WebInspector.UIString("Animation")],[groups.console,WebInspector.UIString("Console")],[groups.userTiming,WebInspector.UIString("User Timing")],[groups.input,WebInspector.UIString("Input")]]);}
return WebInspector.TimelineUIUtils._titleForAsyncEventGroupMap.get(group)||"";}
WebInspector.TimelineUIUtils.generatePieChart=function(aggregatedStats,selfCategory,selfTime)
{var total=0;for(var categoryName in aggregatedStats)
total+=aggregatedStats[categoryName];var element=createElementWithClass("div","timeline-details-view-pie-chart-wrapper hbox");var pieChart=new WebInspector.PieChart(100);pieChart.element.classList.add("timeline-details-view-pie-chart");pieChart.setTotal(total);var pieChartContainer=element.createChild("div","vbox");pieChartContainer.appendChild(pieChart.element);pieChartContainer.createChild("div","timeline-details-view-pie-chart-total").textContent=WebInspector.UIString("Total: %s",Number.millisToString(total,true));var footerElement=element.createChild("div","timeline-aggregated-info-legend");function appendLegendRow(name,title,value,color)
{if(!value)
return;pieChart.addSlice(value,color);var rowElement=footerElement.createChild("div");rowElement.createChild("span","timeline-aggregated-legend-value").textContent=Number.preciseMillisToString(value,1);rowElement.createChild("span","timeline-aggregated-legend-swatch").style.backgroundColor=color;rowElement.createChild("span","timeline-aggregated-legend-title").textContent=title;}
if(selfCategory){if(selfTime)
appendLegendRow(selfCategory.name,WebInspector.UIString("%s (self)",selfCategory.title),selfTime,selfCategory.color);var categoryTime=aggregatedStats[selfCategory.name];var value=categoryTime-selfTime;if(value>0)
appendLegendRow(selfCategory.name,WebInspector.UIString("%s (children)",selfCategory.title),value,selfCategory.childColor);}
for(var categoryName in WebInspector.TimelineUIUtils.categories()){var category=WebInspector.TimelineUIUtils.categories()[categoryName];if(category===selfCategory)
continue;appendLegendRow(category.name,category.title,aggregatedStats[category.name],category.childColor);}
return element;}
WebInspector.TimelineUIUtils.generateDetailsContentForFrame=function(frameModel,frame,filmStripFrame)
{var pieChart=WebInspector.TimelineUIUtils.generatePieChart(frame.timeByCategory);var contentHelper=new WebInspector.TimelineDetailsContentHelper(null,null);contentHelper.addSection(WebInspector.UIString("Frame"));var duration=WebInspector.TimelineUIUtils.frameDuration(frame);contentHelper.appendElementRow(WebInspector.UIString("Duration"),duration,frame.hasWarnings());if(filmStripFrame){var filmStripPreview=createElementWithClass("img","timeline-filmstrip-preview");filmStripFrame.imageDataPromise().then(onGotImageData.bind(null,filmStripPreview));contentHelper.appendElementRow("",filmStripPreview);filmStripPreview.addEventListener("click",frameClicked.bind(null,filmStripFrame),false);}
var durationInMillis=frame.endTime-frame.startTime;contentHelper.appendTextRow(WebInspector.UIString("FPS"),Math.floor(1000/durationInMillis));contentHelper.appendTextRow(WebInspector.UIString("CPU time"),Number.millisToString(frame.cpuTime,true));if(Runtime.experiments.isEnabled("layersPanel")&&frame.layerTree){contentHelper.appendElementRow(WebInspector.UIString("Layer tree"),WebInspector.Linkifier.linkifyUsingRevealer(frame.layerTree,WebInspector.UIString("show")));}
function onGotImageData(image,data)
{if(data)
image.src="data:image/jpg;base64,"+data;}
function frameClicked(filmStripFrame)
{new WebInspector.FilmStripView.Dialog(filmStripFrame,0);}
return contentHelper.fragment;}
WebInspector.TimelineUIUtils.frameDuration=function(frame)
{var durationText=WebInspector.UIString("%s (at %s)",Number.millisToString(frame.endTime-frame.startTime,true),Number.millisToString(frame.startTimeOffset,true));var element=createElement("span");element.createTextChild(durationText);if(!frame.hasWarnings())
return element;element.createTextChild(WebInspector.UIString(". Long frame times are an indication of "));element.appendChild(WebInspector.linkifyURLAsNode("https://developers.google.com/web/fundamentals/performance/rendering/",WebInspector.UIString("jank"),undefined,true));element.createTextChild(".");return element;}
WebInspector.TimelineUIUtils.createFillStyle=function(context,width,height,color0,color1,color2)
{var gradient=context.createLinearGradient(0,0,width,height);gradient.addColorStop(0,color0);gradient.addColorStop(0.25,color1);gradient.addColorStop(0.75,color1);gradient.addColorStop(1,color2);return gradient;}
WebInspector.TimelineUIUtils.quadWidth=function(quad)
{return Math.round(Math.sqrt(Math.pow(quad[0]-quad[2],2)+Math.pow(quad[1]-quad[3],2)));}
WebInspector.TimelineUIUtils.quadHeight=function(quad)
{return Math.round(Math.sqrt(Math.pow(quad[0]-quad[6],2)+Math.pow(quad[1]-quad[7],2)));}
WebInspector.TimelineUIUtils.EventDispatchTypeDescriptor=function(priority,color,eventTypes)
{this.priority=priority;this.color=color;this.eventTypes=eventTypes;}
WebInspector.TimelineUIUtils.eventDispatchDesciptors=function()
{if(WebInspector.TimelineUIUtils._eventDispatchDesciptors)
return WebInspector.TimelineUIUtils._eventDispatchDesciptors;var lightOrange="hsl(40,100%,80%)";var orange="hsl(40,100%,50%)";var green="hsl(90,100%,40%)";var purple="hsl(256,100%,75%)";WebInspector.TimelineUIUtils._eventDispatchDesciptors=[new WebInspector.TimelineUIUtils.EventDispatchTypeDescriptor(1,lightOrange,["mousemove","mouseenter","mouseleave","mouseout","mouseover"]),new WebInspector.TimelineUIUtils.EventDispatchTypeDescriptor(1,lightOrange,["pointerover","pointerout","pointerenter","pointerleave","pointermove"]),new WebInspector.TimelineUIUtils.EventDispatchTypeDescriptor(2,green,["wheel"]),new WebInspector.TimelineUIUtils.EventDispatchTypeDescriptor(3,orange,["click","mousedown","mouseup"]),new WebInspector.TimelineUIUtils.EventDispatchTypeDescriptor(3,orange,["touchstart","touchend","touchmove","touchcancel"]),new WebInspector.TimelineUIUtils.EventDispatchTypeDescriptor(3,orange,["pointerdown","pointerup","pointercancel","gotpointercapture","lostpointercapture"]),new WebInspector.TimelineUIUtils.EventDispatchTypeDescriptor(3,purple,["keydown","keyup","keypress"])];return WebInspector.TimelineUIUtils._eventDispatchDesciptors;}
WebInspector.TimelineCategory=function(name,title,visible,childColor,color)
{this.name=name;this.title=title;this.visible=visible;this.childColor=childColor;this.color=color;this.hidden=false;}
WebInspector.TimelineCategory.Events={VisibilityChanged:Symbol("VisibilityChanged")};WebInspector.TimelineCategory.prototype={get hidden()
{return this._hidden;},set hidden(hidden)
{this._hidden=hidden;this.dispatchEventToListeners(WebInspector.TimelineCategory.Events.VisibilityChanged,this);},__proto__:WebInspector.Object.prototype}
WebInspector.TimelineMarkerStyle;WebInspector.TimelineUIUtils.markerStyleForEvent=function(event)
{var red="rgb(255, 0, 0)";var blue="rgb(0, 0, 255)";var orange="rgb(255, 178, 23)";var green="rgb(0, 130, 0)";var tallMarkerDashStyle=[10,5];var title=WebInspector.TimelineUIUtils.eventTitle(event)
if(event.hasCategory(WebInspector.TimelineModel.Category.Console)||event.hasCategory(WebInspector.TimelineModel.Category.UserTiming)){return{title:title,dashStyle:tallMarkerDashStyle,lineWidth:0.5,color:orange,tall:false,lowPriority:false,};}
var recordTypes=WebInspector.TimelineModel.RecordType;var tall=false;var color=green;switch(event.name){case recordTypes.MarkDOMContent:color=blue;tall=true;break;case recordTypes.MarkLoad:color=red;tall=true;break;case recordTypes.MarkFirstPaint:color=green;tall=true;break;case recordTypes.TimeStamp:color=orange;break;}
return{title:title,dashStyle:tallMarkerDashStyle,lineWidth:0.5,color:color,tall:tall,lowPriority:false,};}
WebInspector.TimelineUIUtils.markerStyleForFrame=function()
{return{title:WebInspector.UIString("Frame"),color:"rgba(100, 100, 100, 0.4)",lineWidth:3,dashStyle:[3],tall:true,lowPriority:true};}
WebInspector.TimelineUIUtils.colorForURL=function(url)
{if(!WebInspector.TimelineUIUtils.colorForURL._colorGenerator){WebInspector.TimelineUIUtils.colorForURL._colorGenerator=new WebInspector.FlameChart.ColorGenerator({min:30,max:330},{min:50,max:80,count:3},85);}
return WebInspector.TimelineUIUtils.colorForURL._colorGenerator.colorForID(url);}
WebInspector.TimelinePopupContentHelper=function(title)
{this._contentTable=createElement("table");var titleCell=this._createCell(WebInspector.UIString("%s - Details",title),"timeline-details-title");titleCell.colSpan=2;var titleRow=createElement("tr");titleRow.appendChild(titleCell);this._contentTable.appendChild(titleRow);}
WebInspector.TimelinePopupContentHelper.prototype={contentTable:function()
{return this._contentTable;},_createCell:function(content,styleName)
{var text=createElement("label");text.createTextChild(String(content));var cell=createElement("td");cell.className="timeline-details";if(styleName)
cell.className+=" "+styleName;cell.textContent=content;return cell;},appendTextRow:function(title,content)
{var row=createElement("tr");row.appendChild(this._createCell(title,"timeline-details-row-title"));row.appendChild(this._createCell(content,"timeline-details-row-data"));this._contentTable.appendChild(row);},appendElementRow:function(title,content)
{var row=createElement("tr");var titleCell=this._createCell(title,"timeline-details-row-title");row.appendChild(titleCell);var cell=createElement("td");cell.className="details";if(content instanceof Node)
cell.appendChild(content);else
cell.createTextChild(content||"");row.appendChild(cell);this._contentTable.appendChild(row);}}
WebInspector.TimelineDetailsContentHelper=function(target,linkifier)
{this.fragment=createDocumentFragment();this._linkifier=linkifier;this._target=target;this.element=createElementWithClass("div","timeline-details-view-block");this._tableElement=this.element.createChild("div","vbox timeline-details-chip-body");this.fragment.appendChild(this.element);}
WebInspector.TimelineDetailsContentHelper.prototype={addSection:function(title,category)
{if(!this._tableElement.hasChildNodes()){this.element.removeChildren();}else{this.element=createElementWithClass("div","timeline-details-view-block");this.fragment.appendChild(this.element);}
if(title){var titleElement=this.element.createChild("div","timeline-details-chip-title");if(category)
titleElement.createChild("div").style.backgroundColor=category.color;titleElement.createTextChild(title);}
this._tableElement=this.element.createChild("div","vbox timeline-details-chip-body");this.fragment.appendChild(this.element);},linkifier:function()
{return this._linkifier;},appendTextRow:function(title,value)
{var rowElement=this._tableElement.createChild("div","timeline-details-view-row");rowElement.createChild("div","timeline-details-view-row-title").textContent=title;rowElement.createChild("div","timeline-details-view-row-value").textContent=value;},appendElementRow:function(title,content,isWarning,isStacked)
{var rowElement=this._tableElement.createChild("div","timeline-details-view-row");if(isWarning)
rowElement.classList.add("timeline-details-warning");if(isStacked)
rowElement.classList.add("timeline-details-stack-values");var titleElement=rowElement.createChild("div","timeline-details-view-row-title");titleElement.textContent=title;var valueElement=rowElement.createChild("div","timeline-details-view-row-value");if(content instanceof Node)
valueElement.appendChild(content);else
valueElement.createTextChild(content||"");},appendLocationRow:function(title,url,startLine,startColumn)
{if(!this._linkifier||!this._target)
return;var link=this._linkifier.maybeLinkifyScriptLocation(this._target,null,url,startLine,startColumn);if(!link)
return;this.appendElementRow(title,link);},appendLocationRange:function(title,url,startLine,endLine)
{if(!this._linkifier||!this._target)
return;var locationContent=createElement("span");var link=this._linkifier.maybeLinkifyScriptLocation(this._target,null,url,startLine);if(!link)
return;locationContent.appendChild(link);locationContent.createTextChild(String.sprintf(" [%s\u2026%s]",startLine+1,endLine+1||""));this.appendElementRow(title,locationContent);},appendStackTrace:function(title,stackTrace)
{if(!this._linkifier||!this._target)
return;var rowElement=this._tableElement.createChild("div","timeline-details-view-row");rowElement.createChild("div","timeline-details-view-row-title").textContent=title;this.createChildStackTraceElement(rowElement,stackTrace);},createChildStackTraceElement:function(parentElement,stackTrace)
{if(!this._linkifier||!this._target)
return;parentElement.classList.add("timeline-details-stack-values");var stackTraceElement=parentElement.createChild("div","timeline-details-view-row-value timeline-details-view-row-stack-trace");var callFrameElem=WebInspector.DOMPresentationUtils.buildStackTracePreviewContents(this._target,this._linkifier,stackTrace);stackTraceElement.appendChild(callFrameElem);},appendWarningRow:function(event,warningType)
{var warning=WebInspector.TimelineUIUtils.eventWarning(event,warningType);if(warning)
this.appendElementRow(WebInspector.UIString("Warning"),warning,true);}}
WebInspector.TimelineUIUtils.eventWarning=function(event,warningType)
{var warning=warningType||event.warning;if(!warning)
return null;var warnings=WebInspector.TimelineModel.WarningType;var span=createElement("span");var eventData=event.args["data"];switch(warning){case warnings.ForcedStyle:case warnings.ForcedLayout:span.appendChild(WebInspector.linkifyDocumentationURLAsNode("../../fundamentals/performance/rendering/avoid-large-complex-layouts-and-layout-thrashing#avoid-forced-synchronous-layouts",WebInspector.UIString("Forced reflow")));span.createTextChild(WebInspector.UIString(" is a likely performance bottleneck."));break;case warnings.IdleDeadlineExceeded:span.textContent=WebInspector.UIString("Idle callback execution extended beyond deadline by "+
Number.millisToString(event.duration-eventData["allottedMilliseconds"],true));break;case warnings.V8Deopt:span.appendChild(WebInspector.linkifyURLAsNode("https://github.com/GoogleChrome/devtools-docs/issues/53",WebInspector.UIString("Not optimized"),undefined,true));span.createTextChild(WebInspector.UIString(": %s",eventData["deoptReason"]));break;default:console.assert(false,"Unhandled TimelineModel.WarningType");}
return span;};WebInspector.TimelineLayersView=function(model,showEventDetailsCallback)
{WebInspector.SplitWidget.call(this,true,false,"timelineLayersView");this._model=model;this._showEventDetailsCallback=showEventDetailsCallback;this.element.classList.add("timeline-layers-view");this._rightSplitWidget=new WebInspector.SplitWidget(true,true,"timelineLayersViewDetails");this._rightSplitWidget.element.classList.add("timeline-layers-view-properties");this.setMainWidget(this._rightSplitWidget);this._paintTiles=[];var vbox=new WebInspector.VBox();this.setSidebarWidget(vbox);this._layerViewHost=new WebInspector.LayerViewHost();var layerTreeOutline=new WebInspector.LayerTreeOutline(this._layerViewHost);vbox.element.appendChild(layerTreeOutline.element);this._layers3DView=new WebInspector.Layers3DView(this._layerViewHost);this._layers3DView.addEventListener(WebInspector.Layers3DView.Events.PaintProfilerRequested,this._jumpToPaintEvent,this);this._rightSplitWidget.setMainWidget(this._layers3DView);var layerDetailsView=new WebInspector.LayerDetailsView(this._layerViewHost);this._rightSplitWidget.setSidebarWidget(layerDetailsView);layerDetailsView.addEventListener(WebInspector.LayerDetailsView.Events.PaintProfilerRequested,this._jumpToPaintEvent,this);}
WebInspector.TimelineLayersView.prototype={showLayerTree:function(deferredLayerTree,paints)
{this._disposeTiles();this._deferredLayerTree=deferredLayerTree;this._paints=paints;if(this.isShowing())
this._update();else
this._updateWhenVisible=true;},wasShown:function()
{if(this._updateWhenVisible){this._updateWhenVisible=false;this._update();}},_jumpToPaintEvent:function(event)
{var traceEvent=(event.data);this._showEventDetailsCallback(traceEvent);},_update:function()
{var layerTree;this._target=this._deferredLayerTree.target();var originalTiles=this._paintTiles;var tilesReadyBarrier=new CallbackBarrier();this._deferredLayerTree.resolve(tilesReadyBarrier.createCallback(onLayersReady));for(var i=0;this._paints&&i<this._paints.length;++i)
this._paints[i].loadSnapshot(tilesReadyBarrier.createCallback(onSnapshotLoaded.bind(this,this._paints[i])));tilesReadyBarrier.callWhenDone(onLayersAndTilesReady.bind(this));function onLayersReady(resolvedLayerTree)
{layerTree=resolvedLayerTree;}
function onSnapshotLoaded(paintEvent,rect,snapshot)
{if(!rect||!snapshot)
return;if(originalTiles!==this._paintTiles){snapshot.dispose();return;}
this._paintTiles.push({layerId:paintEvent.layerId(),rect:rect,snapshot:snapshot,traceEvent:paintEvent.event()});}
function onLayersAndTilesReady()
{this._layerViewHost.setLayerTree(layerTree);this._layers3DView.setTiles(this._paintTiles);}},_disposeTiles:function()
{for(var i=0;i<this._paintTiles.length;++i)
this._paintTiles[i].snapshot.dispose();this._paintTiles=[];},__proto__:WebInspector.SplitWidget.prototype};WebInspector.TimelinePaintProfilerView=function(frameModel)
{WebInspector.SplitWidget.call(this,false,false);this.element.classList.add("timeline-paint-profiler-view");this.setSidebarSize(60);this.setResizable(false);this._frameModel=frameModel;this._logAndImageSplitWidget=new WebInspector.SplitWidget(true,false);this._logAndImageSplitWidget.element.classList.add("timeline-paint-profiler-log-split");this.setMainWidget(this._logAndImageSplitWidget);this._imageView=new WebInspector.TimelinePaintImageView();this._logAndImageSplitWidget.setMainWidget(this._imageView);this._paintProfilerView=new WebInspector.PaintProfilerView(this._imageView.showImage.bind(this._imageView));this._paintProfilerView.addEventListener(WebInspector.PaintProfilerView.Events.WindowChanged,this._onWindowChanged,this);this.setSidebarWidget(this._paintProfilerView);this._logTreeView=new WebInspector.PaintProfilerCommandLogView();this._logAndImageSplitWidget.setSidebarWidget(this._logTreeView);}
WebInspector.TimelinePaintProfilerView.prototype={wasShown:function()
{if(this._updateWhenVisible){this._updateWhenVisible=false;this._update();}},setEvent:function(target,event)
{this._disposeSnapshot();this._target=target;this._event=event;if(this.isShowing())
this._update();else
this._updateWhenVisible=true;if(this._event.name===WebInspector.TimelineModel.RecordType.Paint)
return!!event.picture;if(this._event.name===WebInspector.TimelineModel.RecordType.RasterTask)
return this._frameModel.hasRasterTile(this._event);return false;},_update:function()
{this._logTreeView.setCommandLog(null,[]);this._paintProfilerView.setSnapshotAndLog(null,[],null);if(this._event.name===WebInspector.TimelineModel.RecordType.Paint)
this._event.picture.requestObject(onDataAvailable.bind(this));else if(this._event.name===WebInspector.TimelineModel.RecordType.RasterTask)
this._frameModel.requestRasterTile(this._event,onSnapshotLoaded.bind(this))
else
console.assert(false,"Unexpected event type: "+this._event.name);function onDataAvailable(data)
{if(data)
WebInspector.PaintProfilerSnapshot.load(this._target,data["skp64"],onSnapshotLoaded.bind(this,null));}
function onSnapshotLoaded(tileRect,snapshot)
{this._disposeSnapshot();this._lastLoadedSnapshot=snapshot;this._imageView.setMask(tileRect);if(!snapshot){this._imageView.showImage();return;}
snapshot.commandLog(onCommandLogDone.bind(this,snapshot,tileRect));}
function onCommandLogDone(snapshot,clipRect,log)
{this._logTreeView.setCommandLog(snapshot.target(),log||[]);this._paintProfilerView.setSnapshotAndLog(snapshot,log||[],clipRect);}},_disposeSnapshot:function()
{if(!this._lastLoadedSnapshot)
return;this._lastLoadedSnapshot.dispose();this._lastLoadedSnapshot=null;},_onWindowChanged:function()
{this._logTreeView.updateWindow(this._paintProfilerView.selectionWindow());},__proto__:WebInspector.SplitWidget.prototype};WebInspector.TimelinePaintImageView=function()
{WebInspector.Widget.call(this,true);this.registerRequiredCSS("timeline/timelinePaintProfiler.css");this.contentElement.classList.add("fill","paint-profiler-image-view");this._imageContainer=this.contentElement.createChild("div","paint-profiler-image-container");this._imageElement=this._imageContainer.createChild("img");this._maskElement=this._imageContainer.createChild("div");this._imageElement.addEventListener("load",this._updateImagePosition.bind(this),false);this._transformController=new WebInspector.TransformController(this.contentElement,true);this._transformController.addEventListener(WebInspector.TransformController.Events.TransformChanged,this._updateImagePosition,this);}
WebInspector.TimelinePaintImageView.prototype={onResize:function()
{if(this._imageElement.src)
this._updateImagePosition();},_updateImagePosition:function()
{var width=this._imageElement.naturalWidth;var height=this._imageElement.naturalHeight;var clientWidth=this.contentElement.clientWidth;var clientHeight=this.contentElement.clientHeight;var paddingFraction=0.1;var paddingX=clientWidth*paddingFraction;var paddingY=clientHeight*paddingFraction;var scaleX=(clientWidth-paddingX)/width;var scaleY=(clientHeight-paddingY)/height;var scale=Math.min(scaleX,scaleY);if(this._maskRectangle){var style=this._maskElement.style;style.width=width+"px";style.height=height+"px";style.borderLeftWidth=this._maskRectangle.x+"px";style.borderTopWidth=this._maskRectangle.y+"px";style.borderRightWidth=(width-this._maskRectangle.x-this._maskRectangle.width)+"px";style.borderBottomWidth=(height-this._maskRectangle.y-this._maskRectangle.height)+"px";}
this._transformController.setScaleConstraints(0.5,10/scale);var matrix=new WebKitCSSMatrix().scale(this._transformController.scale(),this._transformController.scale()).translate(clientWidth/2,clientHeight/2).scale(scale,scale).translate(-width/2,-height/2);var bounds=WebInspector.Geometry.boundsForTransformedPoints(matrix,[0,0,0,width,height,0]);this._transformController.clampOffsets(paddingX-bounds.maxX,clientWidth-paddingX-bounds.minX,paddingY-bounds.maxY,clientHeight-paddingY-bounds.minY);matrix=new WebKitCSSMatrix().translate(this._transformController.offsetX(),this._transformController.offsetY()).multiply(matrix);this._imageContainer.style.webkitTransform=matrix.toString();},showImage:function(imageURL)
{this._imageContainer.classList.toggle("hidden",!imageURL);if(imageURL)
this._imageElement.src=imageURL;},setMask:function(maskRectangle)
{this._maskRectangle=maskRectangle;this._maskElement.classList.toggle("hidden",!maskRectangle);},__proto__:WebInspector.Widget.prototype};;WebInspector.TimelinePanel=function()
{WebInspector.Panel.call(this,"timeline");this.registerRequiredCSS("timeline/timelinePanel.css");this.element.addEventListener("contextmenu",this._contextMenu.bind(this),false);this._dropTarget=new WebInspector.DropTarget(this.element,[WebInspector.DropTarget.Types.Files,WebInspector.DropTarget.Types.URIList],WebInspector.UIString("Drop timeline file or URL here"),this._handleDrop.bind(this));this._state=WebInspector.TimelinePanel.State.Idle;this._detailsLinkifier=new WebInspector.Linkifier();this._windowStartTime=0;this._windowEndTime=Infinity;this._millisecondsToRecordAfterLoadEvent=3000;this._toggleRecordAction=(WebInspector.actionRegistry.action("timeline.toggle-recording"));this._customCPUThrottlingRate=0;this._filters=[];if(!Runtime.experiments.isEnabled("timelineShowAllEvents")){this._filters.push(WebInspector.TimelineUIUtils.visibleEventsFilter());this._filters.push(new WebInspector.ExcludeTopLevelFilter());}
this._tracingModelBackingStorage=new WebInspector.TempFileBackingStorage("tracing");this._tracingModel=new WebInspector.TracingModel(this._tracingModelBackingStorage);this._model=new WebInspector.TimelineModel(WebInspector.TimelineUIUtils.visibleEventsFilter());this._frameModel=new WebInspector.TimelineFrameModel(event=>WebInspector.TimelineUIUtils.eventStyle(event).category.name);this._filmStripModel=new WebInspector.FilmStripModel(this._tracingModel);this._irModel=new WebInspector.TimelineIRModel();this._cpuThrottlingManager=new WebInspector.CPUThrottlingManager();this._currentViews=[];this._captureNetworkSetting=WebInspector.settings.createSetting("timelineCaptureNetwork",false);this._captureJSProfileSetting=WebInspector.settings.createSetting("timelineEnableJSSampling",true);this._captureMemorySetting=WebInspector.settings.createSetting("timelineCaptureMemory",false);this._captureLayersAndPicturesSetting=WebInspector.settings.createSetting("timelineCaptureLayersAndPictures",false);this._captureFilmStripSetting=WebInspector.settings.createSetting("timelineCaptureFilmStrip",false);this._panelToolbar=new WebInspector.Toolbar("",this.element);this._createToolbarItems();var timelinePane=new WebInspector.VBox();timelinePane.show(this.element);var topPaneElement=timelinePane.element.createChild("div","hbox");topPaneElement.id="timeline-overview-panel";this._overviewPane=new WebInspector.TimelineOverviewPane("timeline");this._overviewPane.addEventListener(WebInspector.TimelineOverviewPane.Events.WindowChanged,this._onWindowChanged.bind(this));this._overviewPane.show(topPaneElement);this._statusPaneContainer=timelinePane.element.createChild("div","status-pane-container fill");this._createFileSelector();WebInspector.targetManager.addEventListener(WebInspector.TargetManager.Events.PageReloadRequested,this._pageReloadRequested,this);WebInspector.targetManager.addEventListener(WebInspector.TargetManager.Events.Load,this._loadEventFired,this);this._detailsSplitWidget=new WebInspector.SplitWidget(false,true,"timelinePanelDetailsSplitViewState");this._detailsSplitWidget.element.classList.add("timeline-details-split");this._detailsView=new WebInspector.TimelineDetailsView(this._model,this._filters,this);this._detailsSplitWidget.installResizer(this._detailsView.headerElement());this._detailsSplitWidget.setSidebarWidget(this._detailsView);this._searchableView=new WebInspector.SearchableView(this);this._searchableView.setMinimumSize(0,100);this._searchableView.element.classList.add("searchable-view");this._detailsSplitWidget.setMainWidget(this._searchableView);this._stackView=new WebInspector.StackView(false);this._stackView.element.classList.add("timeline-view-stack");this._stackView.show(this._searchableView.element);this._onModeChanged();this._detailsSplitWidget.show(timelinePane.element);this._detailsSplitWidget.hideSidebar();WebInspector.targetManager.addEventListener(WebInspector.TargetManager.Events.SuspendStateChanged,this._onSuspendStateChanged,this);this._showRecordingHelpMessage();this._selectedSearchResult;this._searchResults;}
WebInspector.TimelinePanel.Perspectives={Load:"Load",Responsiveness:"Responsiveness",Custom:"Custom"}
WebInspector.TimelinePanel.DetailsTab={Details:"Details",Events:"Events",CallTree:"CallTree",BottomUp:"BottomUp",PaintProfiler:"PaintProfiler",LayerViewer:"LayerViewer"}
WebInspector.TimelinePanel.State={Idle:Symbol("Idle"),StartPending:Symbol("StartPending"),Recording:Symbol("Recording"),StopPending:Symbol("StopPending"),Loading:Symbol("Loading")}
WebInspector.TimelinePanel.rowHeight=18;WebInspector.TimelinePanel.headerHeight=20;WebInspector.TimelinePanel.prototype={searchableView:function()
{return this._searchableView;},wasShown:function()
{WebInspector.context.setFlavor(WebInspector.TimelinePanel,this);},willHide:function()
{WebInspector.context.setFlavor(WebInspector.TimelinePanel,null);},windowStartTime:function()
{if(this._windowStartTime)
return this._windowStartTime;return this._model.minimumRecordTime();},windowEndTime:function()
{if(this._windowEndTime<Infinity)
return this._windowEndTime;return this._model.maximumRecordTime()||Infinity;},_onWindowChanged:function(event)
{this._windowStartTime=event.data.startTime;this._windowEndTime=event.data.endTime;for(var i=0;i<this._currentViews.length;++i)
this._currentViews[i].setWindowTimes(this._windowStartTime,this._windowEndTime);if(!this._selection||this._selection.type()===WebInspector.TimelineSelection.Type.Range)
this.select(null);},_onOverviewSelectionChanged:function(event)
{var selection=(event.data);this.select(selection);},requestWindowTimes:function(windowStartTime,windowEndTime)
{this._overviewPane.requestWindowTimes(windowStartTime,windowEndTime);},_layersView:function()
{if(this._lazyLayersView)
return this._lazyLayersView;this._lazyLayersView=new WebInspector.TimelineLayersView(this._model,showPaintEventDetails.bind(this));return this._lazyLayersView;function showPaintEventDetails(event)
{this._showEventInPaintProfiler(event,true);this._detailsView.selectTab(WebInspector.TimelinePanel.DetailsTab.PaintProfiler,true);}},_paintProfilerView:function()
{if(this._lazyPaintProfilerView)
return this._lazyPaintProfilerView;this._lazyPaintProfilerView=new WebInspector.TimelinePaintProfilerView(this._frameModel);return this._lazyPaintProfilerView;},_addModeView:function(modeView)
{modeView.setWindowTimes(this.windowStartTime(),this.windowEndTime());modeView.refreshRecords();var splitWidget=this._stackView.appendView(modeView.view(),"timelinePanelTimelineStackSplitViewState",undefined,112);var resizer=modeView.resizerElement();if(splitWidget&&resizer){splitWidget.hideDefaultResizer();splitWidget.installResizer(resizer);}
this._currentViews.push(modeView);},_removeAllModeViews:function()
{this._currentViews.forEach(view=>view.dispose());this._currentViews=[];this._stackView.detachChildWidgets();},_setState:function(state)
{this._state=state;this._updateTimelineControls();},_createSettingCheckbox:function(name,setting,tooltip)
{if(!this._recordingOptionUIControls)
this._recordingOptionUIControls=[];var checkboxItem=new WebInspector.ToolbarCheckbox(name,tooltip,setting);this._recordingOptionUIControls.push(checkboxItem);return checkboxItem;},_createToolbarItems:function()
{this._panelToolbar.removeToolbarItems();var perspectiveSetting=WebInspector.settings.createSetting("timelinePerspective",WebInspector.TimelinePanel.Perspectives.Load);if(Runtime.experiments.isEnabled("timelineRecordingPerspectives")){function onPerspectiveChanged()
{perspectiveSetting.set(perspectiveCombobox.selectElement().value);this._createToolbarItems();}
function addPerspectiveOption(id,title)
{var option=perspectiveCombobox.createOption(title,"",id);perspectiveCombobox.addOption(option);if(id===perspectiveSetting.get())
perspectiveCombobox.select(option);}
var perspectiveCombobox=new WebInspector.ToolbarComboBox(onPerspectiveChanged.bind(this));addPerspectiveOption(WebInspector.TimelinePanel.Perspectives.Load,WebInspector.UIString("Page Load"));addPerspectiveOption(WebInspector.TimelinePanel.Perspectives.Responsiveness,WebInspector.UIString("Responsiveness"));addPerspectiveOption(WebInspector.TimelinePanel.Perspectives.Custom,WebInspector.UIString("Custom"));this._panelToolbar.appendToolbarItem(perspectiveCombobox);switch(perspectiveSetting.get()){case WebInspector.TimelinePanel.Perspectives.Load:this._captureNetworkSetting.set(true);this._captureJSProfileSetting.set(true);this._captureMemorySetting.set(false);this._captureLayersAndPicturesSetting.set(false);this._captureFilmStripSetting.set(true);break;case WebInspector.TimelinePanel.Perspectives.Responsiveness:this._captureNetworkSetting.set(true);this._captureJSProfileSetting.set(true);this._captureMemorySetting.set(false);this._captureLayersAndPicturesSetting.set(false);this._captureFilmStripSetting.set(false);break;}}
if(Runtime.experiments.isEnabled("timelineRecordingPerspectives")&&perspectiveSetting.get()===WebInspector.TimelinePanel.Perspectives.Load){this._reloadButton=new WebInspector.ToolbarButton(WebInspector.UIString("Record & Reload"),"refresh-toolbar-item");this._reloadButton.addEventListener("click",()=>WebInspector.targetManager.reloadPage());this._panelToolbar.appendToolbarItem(this._reloadButton);}else{this._panelToolbar.appendToolbarItem(WebInspector.Toolbar.createActionButton(this._toggleRecordAction));}
this._updateTimelineControls();var clearButton=new WebInspector.ToolbarButton(WebInspector.UIString("Clear recording"),"clear-toolbar-item");clearButton.addEventListener("click",this._clear,this);this._panelToolbar.appendToolbarItem(clearButton);this._panelToolbar.appendSeparator();this._panelToolbar.appendText(WebInspector.UIString("Capture:"));var screenshotCheckbox=this._createSettingCheckbox(WebInspector.UIString("Screenshots"),this._captureFilmStripSetting,WebInspector.UIString("Capture screenshots while recording. (Has small performance overhead)"));if(!Runtime.experiments.isEnabled("timelineRecordingPerspectives")||perspectiveSetting.get()===WebInspector.TimelinePanel.Perspectives.Custom){this._panelToolbar.appendToolbarItem(this._createSettingCheckbox(WebInspector.UIString("Network"),this._captureNetworkSetting,WebInspector.UIString("Show network requests information")));this._panelToolbar.appendToolbarItem(this._createSettingCheckbox(WebInspector.UIString("JS Profile"),this._captureJSProfileSetting,WebInspector.UIString("Capture JavaScript stacks with sampling profiler. (Has small performance overhead)")));this._panelToolbar.appendToolbarItem(screenshotCheckbox);this._panelToolbar.appendToolbarItem(this._createSettingCheckbox(WebInspector.UIString("Memory"),this._captureMemorySetting,WebInspector.UIString("Capture memory information on every timeline event.")));this._panelToolbar.appendToolbarItem(this._createSettingCheckbox(WebInspector.UIString("Paint"),this._captureLayersAndPicturesSetting,WebInspector.UIString("Capture graphics layer positions and rasterization draw calls. (Has large performance overhead)")));}else{this._panelToolbar.appendToolbarItem(screenshotCheckbox);}
this._captureNetworkSetting.addChangeListener(this._onNetworkChanged,this);this._captureMemorySetting.addChangeListener(this._onModeChanged,this);this._captureFilmStripSetting.addChangeListener(this._onModeChanged,this);this._panelToolbar.appendSeparator();var garbageCollectButton=new WebInspector.ToolbarButton(WebInspector.UIString("Collect garbage"),"garbage-collect-toolbar-item");garbageCollectButton.addEventListener("click",this._garbageCollectButtonClicked,this);this._panelToolbar.appendToolbarItem(garbageCollectButton);this._panelToolbar.appendSeparator();this._cpuThrottlingCombobox=new WebInspector.ToolbarComboBox(this._onCPUThrottlingChanged.bind(this));this._panelToolbar.appendToolbarItem(this._cpuThrottlingCombobox);this._populateCPUThrottingCombobox();},_populateCPUThrottingCombobox:function()
{var cpuThrottlingCombobox=this._cpuThrottlingCombobox;cpuThrottlingCombobox.removeOptions();var currentRate=this._cpuThrottlingManager.rate();var hasSelection=false;function addGroupingOption(name,value)
{var option=cpuThrottlingCombobox.createOption(name,"",String(value));cpuThrottlingCombobox.addOption(option);if(hasSelection||(value&&value!==currentRate))
return;cpuThrottlingCombobox.select(option);hasSelection=true;}
var predefinedRates=new Map([[1,WebInspector.UIString("No CPU throttling")],[2,WebInspector.UIString("High end device (2\xD7 slowdown)")],[5,WebInspector.UIString("Low end device (5\xD7 slowdown)")]]);for(var rate of predefinedRates)
addGroupingOption(rate[1],rate[0]);if(this._customCPUThrottlingRate&&!predefinedRates.has(this._customCPUThrottlingRate))
addGroupingOption(WebInspector.UIString("Custom rate (%d\xD7 slowdown)",this._customCPUThrottlingRate),this._customCPUThrottlingRate);addGroupingOption(WebInspector.UIString("Set custom rate\u2026"),0);},_prepareToLoadTimeline:function()
{console.assert(this._state===WebInspector.TimelinePanel.State.Idle);this._setState(WebInspector.TimelinePanel.State.Loading);},_createFileSelector:function()
{if(this._fileSelectorElement)
this._fileSelectorElement.remove();this._fileSelectorElement=WebInspector.createFileSelectorElement(this._loadFromFile.bind(this));this.element.appendChild(this._fileSelectorElement);},_contextMenu:function(event)
{var contextMenu=new WebInspector.ContextMenu(event);contextMenu.appendItemsAtLocation("timelineMenu");contextMenu.show();},_saveToFile:function()
{if(this._state!==WebInspector.TimelinePanel.State.Idle)
return true;if(this._model.isEmpty())
return true;var now=new Date();var fileName="TimelineRawData-"+now.toISO8601Compact()+".json";var stream=new WebInspector.FileOutputStream();function callback(accepted)
{if(!accepted)
return;var saver=new WebInspector.TracingTimelineSaver();this._tracingModelBackingStorage.writeToStream(stream,saver);}
stream.open(fileName,callback.bind(this));return true;},_selectFileToLoad:function()
{this._fileSelectorElement.click();return true;},_loadFromFile:function(file)
{if(this._state!==WebInspector.TimelinePanel.State.Idle)
return;this._prepareToLoadTimeline();this._loader=WebInspector.TimelineLoader.loadFromFile(this._tracingModel,file,this);this._createFileSelector();},_loadFromURL:function(url)
{if(this._state!==WebInspector.TimelinePanel.State.Idle)
return;this._prepareToLoadTimeline();this._loader=WebInspector.TimelineLoader.loadFromURL(this._tracingModel,url,this);},_refreshViews:function()
{for(var i=0;i<this._currentViews.length;++i){var view=this._currentViews[i];view.refreshRecords();}
this._updateSelectionDetails();},_onModeChanged:function()
{this._overviewControls=[];this._overviewControls.push(new WebInspector.TimelineEventOverview.Responsiveness(this._model,this._frameModel));if(Runtime.experiments.isEnabled("inputEventsOnTimelineOverview"))
this._overviewControls.push(new WebInspector.TimelineEventOverview.Input(this._model));this._overviewControls.push(new WebInspector.TimelineEventOverview.Frames(this._model,this._frameModel));this._overviewControls.push(new WebInspector.TimelineEventOverview.CPUActivity(this._model));this._overviewControls.push(new WebInspector.TimelineEventOverview.Network(this._model));if(this._captureFilmStripSetting.get())
this._overviewControls.push(new WebInspector.TimelineFilmStripOverview(this._model,this._filmStripModel));if(this._captureMemorySetting.get())
this._overviewControls.push(new WebInspector.TimelineEventOverview.Memory(this._model));this._overviewPane.setOverviewControls(this._overviewControls);this._removeAllModeViews();this._flameChart=new WebInspector.TimelineFlameChartView(this,this._model,this._frameModel,this._irModel,this._filters);this._flameChart.enableNetworkPane(this._captureNetworkSetting.get());this._addModeView(this._flameChart);if(this._captureMemorySetting.get())
this._addModeView(new WebInspector.MemoryCountersGraph(this,this._model,[WebInspector.TimelineUIUtils.visibleEventsFilter()]));this.doResize();this.select(null);},_onNetworkChanged:function()
{if(this._flameChart)
this._flameChart.enableNetworkPane(this._captureNetworkSetting.get(),true);},_onCPUThrottlingChanged:function()
{if(!this._cpuThrottlingManager)
return;var value=this._cpuThrottlingCombobox.selectedOption().value;var isLastOption=this._cpuThrottlingCombobox.selectedIndex()===this._cpuThrottlingCombobox.size()-1;this._populateCPUThrottingCombobox();var resultPromise=isLastOption?WebInspector.TimelinePanel.CustomCPUThrottlingRateDialog.show(this._cpuThrottlingCombobox.element):Promise.resolve(value);resultPromise.then(text=>{var value=Number.parseFloat(text);if(value>=1){if(isLastOption)
this._customCPUThrottlingRate=value;this._cpuThrottlingManager.setRate(value);this._populateCPUThrottingCombobox();}});},_setUIControlsEnabled:function(enabled)
{function handler(toolbarButton)
{toolbarButton.setEnabled(enabled);}
this._recordingOptionUIControls.forEach(handler);},_startRecording:function(userInitiated)
{console.assert(!this._statusPane,"Status pane is already opened.");var mainTarget=WebInspector.targetManager.mainTarget();if(!mainTarget)
return;this._setState(WebInspector.TimelinePanel.State.StartPending);this._showRecordingStarted();this._autoRecordGeneration=userInitiated?null:Symbol("Generation");this._controller=new WebInspector.TimelineController(mainTarget,this,this._tracingModel);this._controller.startRecording(true,this._captureJSProfileSetting.get(),this._captureMemorySetting.get(),this._captureLayersAndPicturesSetting.get(),this._captureFilmStripSetting&&this._captureFilmStripSetting.get());for(var i=0;i<this._overviewControls.length;++i)
this._overviewControls[i].timelineStarted();if(userInitiated)
WebInspector.userMetrics.actionTaken(WebInspector.UserMetrics.Action.TimelineStarted);this._setUIControlsEnabled(false);this._hideRecordingHelpMessage();},_stopRecording:function()
{if(this._statusPane){this._statusPane.finish();this._statusPane.updateStatus(WebInspector.UIString("Stopping timeline\u2026"));this._statusPane.updateProgressBar(WebInspector.UIString("Received"),0);}
this._setState(WebInspector.TimelinePanel.State.StopPending);this._autoRecordGeneration=null;this._controller.stopRecording();this._controller=null;this._setUIControlsEnabled(true);},_onSuspendStateChanged:function()
{this._updateTimelineControls();},_updateTimelineControls:function()
{var state=WebInspector.TimelinePanel.State;this._toggleRecordAction.setToggled(this._state===state.Recording);this._toggleRecordAction.setEnabled(this._state===state.Recording||this._state===state.Idle);this._panelToolbar.setEnabled(this._state!==state.Loading);this._dropTarget.setEnabled(this._state===state.Idle);},_toggleRecording:function()
{if(this._state===WebInspector.TimelinePanel.State.Idle)
this._startRecording(true);else if(this._state===WebInspector.TimelinePanel.State.Recording)
this._stopRecording();},_garbageCollectButtonClicked:function()
{var targets=WebInspector.targetManager.targets();for(var i=0;i<targets.length;++i)
targets[i].heapProfilerAgent().collectGarbage();},_clear:function()
{WebInspector.LineLevelProfile.instance().reset();this._tracingModel.reset();this._model.reset();this._showRecordingHelpMessage();this.requestWindowTimes(0,Infinity);delete this._selection;this._frameModel.reset();this._filmStripModel.reset(this._tracingModel);this._overviewPane.reset();for(var i=0;i<this._currentViews.length;++i)
this._currentViews[i].reset();for(var i=0;i<this._overviewControls.length;++i)
this._overviewControls[i].reset();this.select(null);this._detailsSplitWidget.hideSidebar();},recordingStarted:function()
{this._clear();this._setState(WebInspector.TimelinePanel.State.Recording);this._showRecordingStarted();this._statusPane.updateStatus(WebInspector.UIString("Recording\u2026"));this._statusPane.updateProgressBar(WebInspector.UIString("Buffer usage"),0)
this._statusPane.startTimer();this._hideRecordingHelpMessage();},recordingProgress:function(usage)
{this._statusPane.updateProgressBar(WebInspector.UIString("Buffer usage"),usage*100);},_showRecordingHelpMessage:function()
{function encloseWithTag(tagName,contents)
{var e=createElement(tagName);e.textContent=contents;return e;}
var recordNode=encloseWithTag("b",WebInspector.shortcutRegistry.shortcutDescriptorsForAction("timeline.toggle-recording")[0].name);var reloadNode=encloseWithTag("b",WebInspector.shortcutRegistry.shortcutDescriptorsForAction("main.reload")[0].name);var navigateNode=encloseWithTag("b",WebInspector.UIString("WASD"));var hintText=createElementWithClass("div");hintText.appendChild(WebInspector.formatLocalized("To capture a new timeline, click the record toolbar button or hit %s.",[recordNode]));hintText.createChild("br");hintText.appendChild(WebInspector.formatLocalized("To evaluate page load performance, hit %s to record the reload.",[reloadNode]));hintText.createChild("p");hintText.appendChild(WebInspector.formatLocalized("After recording, select an area of interest in the overview by dragging.",[]));hintText.createChild("br");hintText.appendChild(WebInspector.formatLocalized("Then, zoom and pan the timeline with the mousewheel and %s keys.",[navigateNode]));this._hideRecordingHelpMessage();this._helpMessageElement=this._searchableView.element.createChild("div","full-widget-dimmed-banner timeline-status-pane");this._helpMessageElement.appendChild(hintText);},_hideRecordingHelpMessage:function()
{if(this._helpMessageElement)
this._helpMessageElement.remove();delete this._helpMessageElement;},loadingStarted:function()
{this._hideRecordingHelpMessage();if(this._statusPane)
this._statusPane.hide();this._statusPane=new WebInspector.TimelinePanel.StatusPane(false,this._cancelLoading.bind(this));this._statusPane.showPane(this._statusPaneContainer);this._statusPane.updateStatus(WebInspector.UIString("Loading timeline\u2026"));if(!this._loader)
this._statusPane.finish();this.loadingProgress(0);},loadingProgress:function(progress)
{if(typeof progress==="number")
this._statusPane.updateProgressBar(WebInspector.UIString("Received"),progress*100);},loadingComplete:function(success)
{var loadedFromFile=!!this._loader;delete this._loader;this._setState(WebInspector.TimelinePanel.State.Idle);if(!success){this._statusPane.hide();delete this._statusPane;this._clear();return;}
if(this._statusPane)
this._statusPane.updateStatus(WebInspector.UIString("Processing timeline\u2026"));this._model.setEvents(this._tracingModel,loadedFromFile);this._frameModel.reset();this._frameModel.addTraceEvents(WebInspector.targetManager.mainTarget(),this._model.inspectedTargetEvents(),this._model.sessionId()||"");this._filmStripModel.reset(this._tracingModel);var groups=WebInspector.TimelineModel.AsyncEventGroup;var asyncEventsByGroup=this._model.mainThreadAsyncEvents();this._irModel.populate(asyncEventsByGroup.get(groups.input),asyncEventsByGroup.get(groups.animation));this._model.cpuProfiles().forEach(profile=>WebInspector.LineLevelProfile.instance().appendCPUProfile(profile));if(this._statusPane)
this._statusPane.hide();delete this._statusPane;this._overviewPane.reset();this._overviewPane.setBounds(this._model.minimumRecordTime(),this._model.maximumRecordTime());this._setAutoWindowTimes();this._refreshViews();for(var i=0;i<this._overviewControls.length;++i)
this._overviewControls[i].timelineStopped();this._setMarkers();this._overviewPane.scheduleUpdate();this._updateSearchHighlight(false,true);this._detailsSplitWidget.showBoth();},_showRecordingStarted:function()
{if(this._statusPane)
return;this._statusPane=new WebInspector.TimelinePanel.StatusPane(true,this._stopRecording.bind(this));this._statusPane.showPane(this._statusPaneContainer);this._statusPane.updateStatus(WebInspector.UIString("Initializing recording\u2026"));},_cancelLoading:function()
{if(this._loader)
this._loader.cancel();},_setMarkers:function()
{var markers=new Map();var recordTypes=WebInspector.TimelineModel.RecordType;var zeroTime=this._model.minimumRecordTime();for(var record of this._model.eventDividerRecords()){if(record.type()===recordTypes.TimeStamp||record.type()===recordTypes.ConsoleTime)
continue;markers.set(record.startTime(),WebInspector.TimelineUIUtils.createDividerForRecord(record,zeroTime,0));}
this._overviewPane.setMarkers(markers);},_pageReloadRequested:function(event)
{if(this._state!==WebInspector.TimelinePanel.State.Idle||!this.isShowing())
return;this._startRecording(false);},_loadEventFired:function(event)
{if(this._state!==WebInspector.TimelinePanel.State.Recording||!this._autoRecordGeneration)
return;setTimeout(stopRecordingOnReload.bind(this,this._autoRecordGeneration),this._millisecondsToRecordAfterLoadEvent);function stopRecordingOnReload(recordGeneration)
{if(this._state!==WebInspector.TimelinePanel.State.Recording||this._autoRecordGeneration!==recordGeneration)
return;this._stopRecording();}},jumpToNextSearchResult:function()
{if(!this._searchResults||!this._searchResults.length)
return;var index=this._selectedSearchResult?this._searchResults.indexOf(this._selectedSearchResult):-1;this._jumpToSearchResult(index+1);},jumpToPreviousSearchResult:function()
{if(!this._searchResults||!this._searchResults.length)
return;var index=this._selectedSearchResult?this._searchResults.indexOf(this._selectedSearchResult):0;this._jumpToSearchResult(index-1);},supportsCaseSensitiveSearch:function()
{return false;},supportsRegexSearch:function()
{return false;},_jumpToSearchResult:function(index)
{this._selectSearchResult((index+this._searchResults.length)%this._searchResults.length);this._currentViews[0].highlightSearchResult(this._selectedSearchResult,this._searchRegex,true);},_selectSearchResult:function(index)
{this._selectedSearchResult=this._searchResults[index];this._searchableView.updateCurrentMatchIndex(index);},_clearHighlight:function()
{this._currentViews[0].highlightSearchResult(null);},_updateSearchHighlight:function(revealRecord,shouldJump,jumpBackwards)
{if(!this._searchRegex){this._clearHighlight();return;}
if(!this._searchResults)
this._updateSearchResults(shouldJump,jumpBackwards);this._currentViews[0].highlightSearchResult(this._selectedSearchResult,this._searchRegex,revealRecord);},_updateSearchResults:function(shouldJump,jumpBackwards)
{if(!this._searchRegex)
return;var events=this._model.mainThreadEvents();var filters=this._filters.concat([new WebInspector.TimelineTextFilter(this._searchRegex)]);var matches=[];for(var index=events.lowerBound(this._windowStartTime,(time,event)=>time-event.startTime);index<events.length;++index){var event=events[index];if(event.startTime>this._windowEndTime)
break;if(WebInspector.TimelineModel.isVisible(filters,event))
matches.push(event);}
var matchesCount=matches.length;if(matchesCount){this._searchResults=matches;this._searchableView.updateSearchMatchesCount(matchesCount);var selectedIndex=matches.indexOf(this._selectedSearchResult);if(shouldJump&&selectedIndex===-1)
selectedIndex=jumpBackwards?this._searchResults.length-1:0;this._selectSearchResult(selectedIndex);}else{this._searchableView.updateSearchMatchesCount(0);delete this._selectedSearchResult;}},searchCanceled:function()
{this._clearHighlight();delete this._searchResults;delete this._selectedSearchResult;delete this._searchRegex;},performSearch:function(searchConfig,shouldJump,jumpBackwards)
{var query=searchConfig.query;this._searchRegex=createPlainTextSearchRegex(query,"i");delete this._searchResults;this._updateSearchHighlight(true,shouldJump,jumpBackwards);},_updateSelectionDetails:function()
{switch(this._selection.type()){case WebInspector.TimelineSelection.Type.TraceEvent:var event=(this._selection.object());WebInspector.TimelineUIUtils.buildTraceEventDetails(event,this._model,this._detailsLinkifier,true,this._appendDetailsTabsForTraceEventAndShowDetails.bind(this,event));break;case WebInspector.TimelineSelection.Type.Frame:var frame=(this._selection.object());var screenshotTime=frame.idle?frame.startTime:frame.endTime;var filmStripFrame=filmStripFrame=this._filmStripModel.frameByTimestamp(screenshotTime);if(filmStripFrame&&filmStripFrame.timestamp-frame.endTime>10)
filmStripFrame=null;this.showInDetails(WebInspector.TimelineUIUtils.generateDetailsContentForFrame(this._frameModel,frame,filmStripFrame));if(frame.layerTree){var layersView=this._layersView();layersView.showLayerTree(frame.layerTree,frame.paints);if(!this._detailsView.hasTab(WebInspector.TimelinePanel.DetailsTab.LayerViewer))
this._detailsView.appendTab(WebInspector.TimelinePanel.DetailsTab.LayerViewer,WebInspector.UIString("Layers"),layersView);}
break;case WebInspector.TimelineSelection.Type.NetworkRequest:var request=(this._selection.object());WebInspector.TimelineUIUtils.buildNetworkRequestDetails(request,this._model,this._detailsLinkifier).then(this.showInDetails.bind(this));break;case WebInspector.TimelineSelection.Type.Range:this._updateSelectedRangeStats(this._selection._startTime,this._selection._endTime);break;}
this._detailsView.updateContents(this._selection);},_frameForSelection:function(selection)
{switch(selection.type()){case WebInspector.TimelineSelection.Type.Frame:return(selection.object());case WebInspector.TimelineSelection.Type.Range:return null;case WebInspector.TimelineSelection.Type.TraceEvent:return this._frameModel.filteredFrames(selection._endTime,selection._endTime)[0];default:console.assert(false,"Should never be reached");return null;}},_jumpToFrame:function(offset)
{var currentFrame=this._frameForSelection(this._selection);if(!currentFrame)
return;var frames=this._frameModel.frames();var index=frames.indexOf(currentFrame);console.assert(index>=0,"Can't find current frame in the frame list");index=Number.constrain(index+offset,0,frames.length-1);var frame=frames[index];this._revealTimeRange(frame.startTime,frame.endTime);this.select(WebInspector.TimelineSelection.fromFrame(frame));return true;},_appendDetailsTabsForTraceEventAndShowDetails:function(event,content)
{this.showInDetails(content);if(event.name===WebInspector.TimelineModel.RecordType.Paint||event.name===WebInspector.TimelineModel.RecordType.RasterTask)
this._showEventInPaintProfiler(event);},_showEventInPaintProfiler:function(event,isCloseable)
{var target=WebInspector.targetManager.mainTarget();if(!target)
return;var paintProfilerView=this._paintProfilerView();var hasProfileData=paintProfilerView.setEvent(target,event);if(!hasProfileData)
return;if(!this._detailsView.hasTab(WebInspector.TimelinePanel.DetailsTab.PaintProfiler))
this._detailsView.appendTab(WebInspector.TimelinePanel.DetailsTab.PaintProfiler,WebInspector.UIString("Paint Profiler"),paintProfilerView,undefined,undefined,isCloseable);},_updateSelectedRangeStats:function(startTime,endTime)
{this.showInDetails(WebInspector.TimelineUIUtils.buildRangeStats(this._model,startTime,endTime));},select:function(selection,preferredTab)
{if(!selection)
selection=WebInspector.TimelineSelection.fromRange(this._windowStartTime,this._windowEndTime);this._selection=selection;this._detailsLinkifier.reset();if(preferredTab)
this._detailsView.setPreferredTab(preferredTab);for(var view of this._currentViews)
view.setSelection(selection);this._updateSelectionDetails();},selectEntryAtTime:function(time)
{var events=this._model.mainThreadEvents();for(var index=events.upperBound(time,(time,event)=>time-event.startTime)-1;index>=0;--index){var event=events[index];var endTime=event.endTime||event.startTime;if(WebInspector.TracingModel.isTopLevelEvent(event)&&endTime<time)
break;if(WebInspector.TimelineModel.isVisible(this._filters,event)&&endTime>=time){this.select(WebInspector.TimelineSelection.fromTraceEvent(event));return;}}
this.select(null);},highlightEvent:function(event)
{for(var view of this._currentViews)
view.highlightEvent(event);},_revealTimeRange:function(startTime,endTime)
{var timeShift=0;if(this._windowEndTime<endTime)
timeShift=endTime-this._windowEndTime;else if(this._windowStartTime>startTime)
timeShift=startTime-this._windowStartTime;if(timeShift)
this.requestWindowTimes(this._windowStartTime+timeShift,this._windowEndTime+timeShift);},showInDetails:function(node)
{this._detailsView.setContent(node);},_handleDrop:function(dataTransfer)
{var items=dataTransfer.items;if(!items.length)
return;var item=items[0];if(item.kind==="string"){var url=dataTransfer.getData("text/uri-list");if(new WebInspector.ParsedURL(url).isValid)
this._loadFromURL(url);}else if(item.kind==="file"){var entry=items[0].webkitGetAsEntry();if(!entry.isFile)
return;entry.file(this._loadFromFile.bind(this));}},_setAutoWindowTimes:function()
{var tasks=this._model.mainThreadTasks();if(!tasks.length){this.requestWindowTimes(this._tracingModel.minimumRecordTime(),this._tracingModel.maximumRecordTime());return;}
function findLowUtilizationRegion(startIndex,stopIndex)
{var threshold=0.1;var cutIndex=startIndex;var cutTime=(tasks[cutIndex].startTime()+tasks[cutIndex].endTime())/2;var usedTime=0;var step=Math.sign(stopIndex-startIndex);for(var i=startIndex;i!==stopIndex;i+=step){var task=tasks[i];var taskTime=(task.startTime()+task.endTime())/2;var interval=Math.abs(cutTime-taskTime);if(usedTime<threshold*interval){cutIndex=i;cutTime=taskTime;usedTime=0;}
usedTime+=task.endTime()-task.startTime();}
return cutIndex;}
var rightIndex=findLowUtilizationRegion(tasks.length-1,0);var leftIndex=findLowUtilizationRegion(0,rightIndex);var leftTime=tasks[leftIndex].startTime();var rightTime=tasks[rightIndex].endTime();var span=rightTime-leftTime;var totalSpan=this._tracingModel.maximumRecordTime()-this._tracingModel.minimumRecordTime();if(span<totalSpan*0.1){leftTime=this._tracingModel.minimumRecordTime();rightTime=this._tracingModel.maximumRecordTime();}else{leftTime=Math.max(leftTime-0.05*span,this._tracingModel.minimumRecordTime());rightTime=Math.min(rightTime+0.05*span,this._tracingModel.maximumRecordTime());}
this.requestWindowTimes(leftTime,rightTime);},__proto__:WebInspector.Panel.prototype}
WebInspector.TimelineLifecycleDelegate=function()
{}
WebInspector.TimelineLifecycleDelegate.prototype={recordingStarted:function(){},recordingProgress:function(usage){},loadingStarted:function(){},loadingProgress:function(progress){},loadingComplete:function(success){},};WebInspector.TimelineDetailsView=function(timelineModel,filters,delegate)
{WebInspector.TabbedPane.call(this);this.element.classList.add("timeline-details");var tabIds=WebInspector.TimelinePanel.DetailsTab;this._defaultDetailsWidget=new WebInspector.VBox();this._defaultDetailsWidget.element.classList.add("timeline-details-view");this._defaultDetailsContentElement=this._defaultDetailsWidget.element.createChild("div","timeline-details-view-body vbox");this.appendTab(tabIds.Details,WebInspector.UIString("Summary"),this._defaultDetailsWidget);this.setPreferredTab(tabIds.Details);this._rangeDetailViews=new Map();var bottomUpView=new WebInspector.BottomUpTimelineTreeView(timelineModel,filters);this.appendTab(tabIds.BottomUp,WebInspector.UIString("Bottom-Up"),bottomUpView);this._rangeDetailViews.set(tabIds.BottomUp,bottomUpView);var callTreeView=new WebInspector.CallTreeTimelineTreeView(timelineModel,filters);this.appendTab(tabIds.CallTree,WebInspector.UIString("Call Tree"),callTreeView);this._rangeDetailViews.set(tabIds.CallTree,callTreeView);var eventsView=new WebInspector.EventsTimelineTreeView(timelineModel,filters,delegate);this.appendTab(tabIds.Events,WebInspector.UIString("Event Log"),eventsView);this._rangeDetailViews.set(tabIds.Events,eventsView);this.addEventListener(WebInspector.TabbedPane.Events.TabSelected,this._tabSelected,this);}
WebInspector.TimelineDetailsView.prototype={setContent:function(node)
{var allTabs=this.otherTabs(WebInspector.TimelinePanel.DetailsTab.Details);for(var i=0;i<allTabs.length;++i){if(!this._rangeDetailViews.has(allTabs[i]))
this.closeTab(allTabs[i]);}
this._defaultDetailsContentElement.removeChildren();this._defaultDetailsContentElement.appendChild(node);},updateContents:function(selection)
{this._selection=selection;var view=this.selectedTabId?this._rangeDetailViews.get(this.selectedTabId):null;if(view)
view.updateContents(selection);},appendTab:function(id,tabTitle,view,tabTooltip,userGesture,isCloseable)
{WebInspector.TabbedPane.prototype.appendTab.call(this,id,tabTitle,view,tabTooltip,userGesture,isCloseable);if(this._preferredTabId!==this.selectedTabId)
this.selectTab(id);},setPreferredTab:function(tabId)
{this._preferredTabId=tabId;},_tabSelected:function(event)
{if(!event.data.isUserGesture)
return;this.setPreferredTab(event.data.tabId);this.updateContents(this._selection);},__proto__:WebInspector.TabbedPane.prototype}
WebInspector.TimelineSelection=function(type,startTime,endTime,object)
{this._type=type;this._startTime=startTime;this._endTime=endTime;this._object=object||null;}
WebInspector.TimelineSelection.Type={Frame:"Frame",NetworkRequest:"NetworkRequest",TraceEvent:"TraceEvent",Range:"Range"};WebInspector.TimelineSelection.fromFrame=function(frame)
{return new WebInspector.TimelineSelection(WebInspector.TimelineSelection.Type.Frame,frame.startTime,frame.endTime,frame);}
WebInspector.TimelineSelection.fromNetworkRequest=function(request)
{return new WebInspector.TimelineSelection(WebInspector.TimelineSelection.Type.NetworkRequest,request.startTime,request.endTime||request.startTime,request);}
WebInspector.TimelineSelection.fromTraceEvent=function(event)
{return new WebInspector.TimelineSelection(WebInspector.TimelineSelection.Type.TraceEvent,event.startTime,event.endTime||(event.startTime+1),event);}
WebInspector.TimelineSelection.fromRange=function(startTime,endTime)
{return new WebInspector.TimelineSelection(WebInspector.TimelineSelection.Type.Range,startTime,endTime);}
WebInspector.TimelineSelection.prototype={type:function()
{return this._type;},object:function()
{return this._object;},startTime:function()
{return this._startTime;},endTime:function()
{return this._endTime;}};WebInspector.TimelineModeView=function()
{}
WebInspector.TimelineModeView.prototype={view:function(){},dispose:function(){},resizerElement:function(){},reset:function(){},refreshRecords:function(){},highlightSearchResult:function(event,regex,select){},setWindowTimes:function(startTime,endTime){},setSelection:function(selection){},highlightEvent:function(event){}}
WebInspector.TimelineModeViewDelegate=function(){}
WebInspector.TimelineModeViewDelegate.prototype={requestWindowTimes:function(startTime,endTime){},select:function(selection,preferredTab){},selectEntryAtTime:function(time){},showInDetails:function(node){},highlightEvent:function(event){}}
WebInspector.TimelineCategoryFilter=function()
{WebInspector.TimelineModel.Filter.call(this);}
WebInspector.TimelineCategoryFilter.prototype={accept:function(event)
{return!WebInspector.TimelineUIUtils.eventStyle(event).category.hidden;},__proto__:WebInspector.TimelineModel.Filter.prototype}
WebInspector.TimelineIsLongFilter=function()
{WebInspector.TimelineModel.Filter.call(this);this._minimumRecordDuration=0;}
WebInspector.TimelineIsLongFilter.prototype={setMinimumRecordDuration:function(value)
{this._minimumRecordDuration=value;},accept:function(event)
{var duration=event.endTime?event.endTime-event.startTime:0;return duration>=this._minimumRecordDuration;},__proto__:WebInspector.TimelineModel.Filter.prototype}
WebInspector.TimelineTextFilter=function(regExp)
{WebInspector.TimelineModel.Filter.call(this);this._setRegExp(regExp||null);}
WebInspector.TimelineTextFilter.prototype={_setRegExp:function(regExp)
{this._regExp=regExp;},accept:function(event)
{return!this._regExp||WebInspector.TimelineUIUtils.testContentMatching(event,this._regExp);},__proto__:WebInspector.TimelineModel.Filter.prototype}
WebInspector.TimelinePanel.StatusPane=function(showTimer,stopCallback)
{WebInspector.VBox.call(this,true);this.registerRequiredCSS("timeline/timelineStatusDialog.css");this.contentElement.classList.add("timeline-status-dialog");var statusLine=this.contentElement.createChild("div","status-dialog-line status");statusLine.createChild("div","label").textContent=WebInspector.UIString("Status");this._status=statusLine.createChild("div","content");if(showTimer){var timeLine=this.contentElement.createChild("div","status-dialog-line time");timeLine.createChild("div","label").textContent=WebInspector.UIString("Time");this._time=timeLine.createChild("div","content");}
var progressLine=this.contentElement.createChild("div","status-dialog-line progress");this._progressLabel=progressLine.createChild("div","label");this._progressBar=progressLine.createChild("div","indicator-container").createChild("div","indicator");this._stopButton=createTextButton(WebInspector.UIString("Stop"),stopCallback);this.contentElement.createChild("div","stop-button").appendChild(this._stopButton);}
WebInspector.TimelinePanel.StatusPane.prototype={finish:function()
{this._stopTimer();this._stopButton.disabled=true;},hide:function()
{this.element.parentNode.classList.remove("tinted");this.element.remove();},showPane:function(parent)
{this.show(parent);parent.classList.add("tinted");},updateStatus:function(text)
{this._status.textContent=text;},updateProgressBar:function(activity,percent)
{this._progressLabel.textContent=activity;this._progressBar.style.width=percent.toFixed(1)+"%";this._updateTimer();},startTimer:function()
{this._startTime=Date.now();this._timeUpdateTimer=setInterval(this._updateTimer.bind(this,false),1000);this._updateTimer();},_stopTimer:function()
{if(!this._timeUpdateTimer)
return;clearInterval(this._timeUpdateTimer);this._updateTimer(true);delete this._timeUpdateTimer;},_updateTimer:function(precise)
{if(!this._timeUpdateTimer)
return;var elapsed=(Date.now()-this._startTime)/1000;this._time.textContent=WebInspector.UIString("%s\u2009sec",elapsed.toFixed(precise?1:0));},__proto__:WebInspector.VBox.prototype}
WebInspector.TimelinePanel.instance=function()
{return(self.runtime.sharedInstance(WebInspector.TimelinePanel));}
WebInspector.LoadTimelineHandler=function()
{}
WebInspector.LoadTimelineHandler.prototype={handleQueryParam:function(value)
{WebInspector.viewManager.showView("timeline").then(()=>{WebInspector.TimelinePanel.instance()._loadFromURL(window.decodeURIComponent(value));});}}
WebInspector.TimelinePanel.ActionDelegate=function()
{}
WebInspector.TimelinePanel.ActionDelegate.prototype={handleAction:function(context,actionId)
{var panel=WebInspector.context.flavor(WebInspector.TimelinePanel);console.assert(panel&&panel instanceof WebInspector.TimelinePanel);switch(actionId){case"timeline.toggle-recording":panel._toggleRecording();return true;case"timeline.save-to-file":panel._saveToFile();return true;case"timeline.load-from-file":panel._selectFileToLoad();return true;case"timeline.jump-to-previous-frame":panel._jumpToFrame(-1);return true;case"timeline.jump-to-next-frame":panel._jumpToFrame(1);return true;}
return false;}}
WebInspector.TimelineFilters=function()
{WebInspector.Object.call(this);this._categoryFilter=new WebInspector.TimelineCategoryFilter();this._durationFilter=new WebInspector.TimelineIsLongFilter();this._textFilter=new WebInspector.TimelineTextFilter();this._filters=[this._categoryFilter,this._durationFilter,this._textFilter];this._createFilterBar();}
WebInspector.TimelineFilters.Events={FilterChanged:Symbol("FilterChanged")};WebInspector.TimelineFilters._durationFilterPresetsMs=[0,1,15];WebInspector.TimelineFilters.prototype={filters:function()
{return this._filters;},searchRegExp:function()
{return this._textFilter._regExp;},filterButton:function()
{return this._filterBar.filterButton();},filtersWidget:function()
{return this._filterBar;},_createFilterBar:function()
{this._filterBar=new WebInspector.FilterBar("timelinePanel");this._textFilterUI=new WebInspector.TextFilterUI();this._textFilterUI.addEventListener(WebInspector.FilterUI.Events.FilterChanged,textFilterChanged,this);this._filterBar.addFilter(this._textFilterUI);var durationOptions=[];for(var durationMs of WebInspector.TimelineFilters._durationFilterPresetsMs){var durationOption={};if(!durationMs){durationOption.label=WebInspector.UIString("All");durationOption.title=WebInspector.UIString("Show all records");}else{durationOption.label=WebInspector.UIString("\u2265 %dms",durationMs);durationOption.title=WebInspector.UIString("Hide records shorter than %dms",durationMs);}
durationOption.value=durationMs;durationOptions.push(durationOption);}
var durationFilterUI=new WebInspector.ComboBoxFilterUI(durationOptions);durationFilterUI.addEventListener(WebInspector.FilterUI.Events.FilterChanged,durationFilterChanged,this);this._filterBar.addFilter(durationFilterUI);var categoryFiltersUI={};var categories=WebInspector.TimelineUIUtils.categories();for(var categoryName in categories){var category=categories[categoryName];if(!category.visible)
continue;var filter=new WebInspector.CheckboxFilterUI(category.name,category.title);filter.setColor(category.color,"rgba(0, 0, 0, 0.2)");categoryFiltersUI[category.name]=filter;filter.addEventListener(WebInspector.FilterUI.Events.FilterChanged,categoriesFilterChanged.bind(this,categoryName));this._filterBar.addFilter(filter);}
return this._filterBar;function textFilterChanged()
{var searchQuery=this._textFilterUI.value();this._textFilter._setRegExp(searchQuery?createPlainTextSearchRegex(searchQuery,"i"):null);this._notifyFiltersChanged();}
function durationFilterChanged()
{var duration=durationFilterUI.value();var minimumRecordDuration=parseInt(duration,10);this._durationFilter.setMinimumRecordDuration(minimumRecordDuration);this._notifyFiltersChanged();}
function categoriesFilterChanged(name)
{var categories=WebInspector.TimelineUIUtils.categories();categories[name].hidden=!categoryFiltersUI[name].checked();this._notifyFiltersChanged();}},_notifyFiltersChanged:function()
{this.dispatchEventToListeners(WebInspector.TimelineFilters.Events.FilterChanged);},__proto__:WebInspector.Object.prototype};WebInspector.CPUThrottlingManager=function()
{this._targets=[];this._throttlingRate=1.;WebInspector.targetManager.observeTargets(this,WebInspector.Target.Capability.Browser);}
WebInspector.CPUThrottlingManager.prototype={setRate:function(value)
{this._throttlingRate=value;this._targets.forEach(target=>target.emulationAgent().setCPUThrottlingRate(value));if(value!==1)
WebInspector.inspectorView.setPanelIcon("timeline","warning-icon",WebInspector.UIString("CPU throttling is enabled"));else
WebInspector.inspectorView.setPanelIcon("timeline","","");},rate:function()
{return this._throttlingRate;},targetAdded:function(target)
{this._targets.push(target);target.emulationAgent().setCPUThrottlingRate(this._throttlingRate);},targetRemoved:function(target)
{this._targets.remove(target,true);},__proto__:WebInspector.Object.prototype}
WebInspector.TimelinePanel.CustomCPUThrottlingRateDialog=function()
{WebInspector.HBox.call(this,true);this.registerRequiredCSS("ui_lazy/dialog.css");this.contentElement.createChild("label").textContent=WebInspector.UIString("CPU Slowdown Rate: ");this._input=this.contentElement.createChild("input");this._input.setAttribute("type","text");this._input.style.width="64px";this._input.addEventListener("keydown",this._onKeyDown.bind(this),false);var addButton=this.contentElement.createChild("button");addButton.textContent=WebInspector.UIString("Set");addButton.addEventListener("click",this._apply.bind(this),false);this.setDefaultFocusedElement(this._input);this.contentElement.tabIndex=0;this._resultPromise=new Promise(fulfill=>this._callback=fulfill);}
WebInspector.TimelinePanel.CustomCPUThrottlingRateDialog.show=function(anchor)
{var dialog=new WebInspector.Dialog();var dialogContent=new WebInspector.TimelinePanel.CustomCPUThrottlingRateDialog();dialogContent.show(dialog.element);dialog.setWrapsContent(true);if(anchor)
dialog.setPosition(anchor.totalOffsetLeft()-32,anchor.totalOffsetTop()+anchor.offsetHeight);dialog.show();return dialogContent.result().then(value=>(dialog.detach(),value));}
WebInspector.TimelinePanel.CustomCPUThrottlingRateDialog.prototype={result:function()
{return this._resultPromise;},_apply:function()
{this._callback(this._input.value);},_onKeyDown:function(event)
{if(event.keyCode===WebInspector.KeyboardShortcut.Keys.Enter.code){event.preventDefault();this._apply();}},__proto__:WebInspector.HBox.prototype};Runtime.cachedResources["timeline/invalidationsTree.css"]="/*\n * Copyright 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.header, .children, .content {\n    min-height: initial;\n    line-height: initial;\n}\n\n/* This TreeElement is always expanded and has no arrow.   */\n/* FIXME(crbug.com/475618): Implement this in TreeElement. */\n.children li::before {\n    display: none;\n}\n\n.content {\n    margin-bottom: 4px;\n}\n\n.content .stack-preview-container {\n    margin-left: 8px;\n}\n\n.content .node-list {\n    margin-left: 10px;\n}\n\n/*# sourceURL=timeline/invalidationsTree.css */";Runtime.cachedResources["timeline/timelineFlamechartPopover.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.timeline-flamechart-popover span {\n    margin-right: 5px;\n}\n\n.timeline-flamechart-popover span.timeline-info-network-time {\n    color: #009;\n}\n\n.timeline-flamechart-popover span.timeline-info-time {\n    color: #282;\n}\n\n.timeline-flamechart-popover span.timeline-info-warning {\n    color: #e44;\n}\n\n.timeline-flamechart-popover span.timeline-info-warning * {\n    color: inherit;\n}\n\n/*# sourceURL=timeline/timelineFlamechartPopover.css */";Runtime.cachedResources["timeline/timelinePanel.css"]="/*\n * Copyright (C) 2006, 2007, 2008 Apple Inc.  All rights reserved.\n * Copyright (C) 2009 Anthony Ricaud <rik@webkit.org>\n *\n * Redistribution and use in source and binary forms, with or without\n * modification, are permitted provided that the following conditions\n * are met:\n *\n * 1.  Redistributions of source code must retain the above copyright\n *     notice, this list of conditions and the following disclaimer.\n * 2.  Redistributions in binary form must reproduce the above copyright\n *     notice, this list of conditions and the following disclaimer in the\n *     documentation and/or other materials provided with the distribution.\n * 3.  Neither the name of Apple Computer, Inc. (\"Apple\") nor the names of\n *     its contributors may be used to endorse or promote products derived\n *     from this software without specific prior written permission.\n *\n * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS \"AS IS\" AND ANY\n * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\n * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\n * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY\n * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES\n * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;\n * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND\n * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF\n * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n */\n\n.panel.timeline > .toolbar {\n    border-bottom: 1px solid #dadada;\n}\n\n#timeline-overview-panel {\n    flex: none;\n    position: relative;\n    border-bottom: 1px solid rgb(140, 140, 140);\n}\n\n#timeline-overview-panel .timeline-graph-bar {\n    pointer-events: none;\n}\n\n#timeline-overview-grid {\n    background-color: rgb(255, 255, 255);\n}\n\n#timeline-overview-grid .timeline-grid-header {\n    height: 12px;\n}\n\n#timeline-overview-grid .resources-dividers-label-bar {\n    pointer-events: auto;\n    height: 12px;\n}\n\n#timeline-overview-grid .resources-divider-label {\n    top: 1px;\n}\n\n.timeline-details-split {\n    flex: auto;\n}\n\n.timeline-view-stack {\n    flex: auto;\n    display: flex;\n}\n\n#timeline-container .webkit-html-external-link,\n#timeline-container .webkit-html-resource-link {\n    color: inherit;\n}\n\n.timeline-graph-side.hovered {\n    background-color: rgba(0, 0, 0, 0.05) !important;\n}\n\n.timeline.panel .status-pane-container {\n    z-index: 1000;\n    pointer-events: none;\n    display: flex;\n    align-items: center;\n}\n\n.timeline.panel .status-pane-container.tinted {\n    background-color: hsla(0, 0%, 90%, 0.8);\n    pointer-events: auto;\n}\n\n#timeline-overview-panel .overview-strip {\n    margin-top: 2px;\n    justify-content: center;\n}\n\n#timeline-overview-panel .overview-strip .timeline-overview-strip-title {\n    color: #666;\n    font-size: 10px;\n    font-weight: bold;\n    z-index: 100;\n    background-color: rgba(255, 255, 255, 0.7);\n    padding: 0 4px;\n    position: absolute;\n    top: 0;\n    right: 0;\n}\n\n#timeline-overview-cpu-activity {\n    flex-basis: 25px;\n}\n\n#timeline-overview-network,\n#timeline-overview-framerate {\n    flex-basis: 20px;\n}\n\n#timeline-overview-filmstrip {\n    flex-basis: 40px;\n}\n\n#timeline-overview-memory {\n    flex-basis: 22px;\n}\n\n#timeline-overview-framerate::before,\n#timeline-overview-network::before,\n#timeline-overview-cpu-activity::before {\n    content: \"\";\n    position: absolute;\n    left: 0;\n    right: 0;\n    bottom: 0;\n    border-bottom: 1px solid hsla(0, 0%, 0%, 0.06);\n    z-index: -200;\n}\n\n.overview-strip .background {\n    z-index: -10;\n}\n\n#timeline-overview-responsiveness {\n    flex-basis: 6px;\n    margin-top: 1px !important;\n}\n\n#timeline-overview-input {\n    flex-basis: 6px;\n}\n\n#timeline-overview-pane {\n    flex: auto;\n    position: relative;\n    overflow: hidden;\n}\n\n#timeline-overview-container {\n    display: flex;\n    flex-direction: column;\n    flex: none;\n    position: relative;\n    overflow: hidden;\n}\n\n#timeline-overview-container canvas {\n    width: 100%;\n    height: 100%;\n}\n\n#timeline-graphs {\n    position: absolute;\n    left: 0;\n    right: 0;\n    max-height: 100%;\n    top: 20px;\n}\n\n.timeline-aggregated-legend-title {\n    display: inline-block;\n}\n\n.timeline-aggregated-legend-value {\n    display: inline-block;\n    width: 70px;\n    text-align: right;\n}\n\n.timeline-aggregated-legend-swatch {\n    display: inline-block;\n    width: 11px;\n    height: 11px;\n    margin: 0 6px;\n    position: relative;\n    top: 1px;\n    border: 1px solid rgba(0, 0, 0, 0.2);\n}\n\n.popover ul {\n    margin: 0;\n    padding: 0;\n    list-style-type: none;\n}\n\n#resources-container-content {\n    overflow: hidden;\n    min-height: 100%;\n}\n\n.timeline-toolbar-resizer {\n    background-image: url(Images/toolbarResizerVertical.png);\n    background-repeat: no-repeat;\n    background-position: right center, center;\n}\n\n.memory-graph-label {\n    position: absolute;\n    right: 0;\n    bottom: 0;\n    font-size: 9px;\n    color: #888;\n    white-space: nowrap;\n    padding: 0 4px;\n    background-color: hsla(0, 0%, 100%, 0.8);\n}\n\n#memory-graphs-canvas-container {\n    overflow: hidden;\n    flex: auto;\n    position: relative;\n}\n\n#memory-counters-graph {\n    flex: auto;\n}\n\n#memory-graphs-canvas-container .memory-counter-marker {\n    position: absolute;\n    border-radius: 3px;\n    width: 5px;\n    height: 5px;\n    margin-left: -3px;\n    margin-top: -2px;\n}\n\n#memory-graphs-container .memory-counter-selector-swatches {\n    flex: 0 0 24px;\n    padding: 5px 0;\n    background-color: #eee;\n    border-bottom: 1px solid #ddd;\n}\n\n.memory-counter-selector-info {\n    flex: 0 0 auto;\n    margin-left: 5px;\n    white-space: nowrap;\n}\n\n.memory-counter-selector-info .range {\n    margin: 0 4px;\n    align-items: center;\n    display: inline-flex;\n}\n\n.memory-counter-value {\n    margin: 8px;\n}\n\n#counter-values-bar {\n    flex: 0 0 20px;\n    border-top: solid 1px lightgray;\n    width: 100%;\n    overflow: hidden;\n    line-height: 18px;\n}\n\n.image-preview-container {\n    background: transparent;\n    text-align: left;\n    border-spacing: 0;\n}\n\n.image-preview-container img {\n    max-width: 100px;\n    max-height: 100px;\n    background-image: url(Images/checker.png);\n    -webkit-user-select: text;\n    -webkit-user-drag: auto;\n}\n\n.image-container {\n    padding: 0;\n}\n\n.timeline-filters-header {\n    overflow: hidden;\n    flex: none;\n}\n\n.timeline-details {\n    vertical-align: top;\n}\n\n.timeline-details-title {\n    border-bottom: 1px solid #B8B8B8;\n    font-weight: bold;\n    padding-bottom: 5px;\n    padding-top: 0;\n    white-space: nowrap;\n}\n\n.timeline-details-row-title {\n    font-weight: bold;\n    text-align: right;\n    white-space: nowrap;\n}\n\n.timeline-details-row-data {\n    white-space: nowrap;\n}\n\n.timeline-details-view {\n    color: #333;\n    overflow: hidden;\n}\n\n.timeline-details-view-body {\n    flex: auto;\n    overflow: auto;\n    position: relative;\n    background-color: #f3f3f3;\n}\n\n.timeline-details-view-block {\n    flex: none;\n    display: flex;\n    background-color: white;\n    flex-direction: column;\n    padding-bottom: 5px;\n    border-bottom: 1px solid #ccc;\n}\n\n.timeline-details-view-row {\n    padding-left: 10px;\n    flex-direction: row;\n    display: flex;\n    line-height: 20px;\n}\n\n.timeline-details-view-block .timeline-details-stack-values {\n    flex-direction: column !important;\n}\n\n.timeline-details-chip-title {\n    font-size: 13px;\n    padding: 8px;\n    display: flex;\n    align-items: center;\n}\n\n.timeline-details-chip-title > div {\n    width: 12px;\n    height: 12px;\n    border: 1px solid rgba(0, 0, 0, 0.2);\n    display: inline-block;\n    margin-right: 4px;\n    content: \" \";\n}\n\n.timeline-details-view-row-title {\n    color: rgb(152, 152, 152);\n    overflow: hidden;\n}\n\n.timeline-details-warning {\n    background-color: rgba(250, 209, 209, 0.48);\n}\n\n.timeline-details-warning .timeline-details-view-row-title {\n    color: red;\n}\n\n.timeline-details-warning .timeline-details-view-row-value {\n    white-space: nowrap;\n    overflow: hidden;\n    text-overflow: ellipsis;\n}\n\n.timeline-details-view-row-value {\n    -webkit-user-select: text;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    overflow: hidden;\n    padding-left: 10px;\n}\n\n.timeline-details-view-row-value .stack-preview-container {\n    line-height: 11px;\n}\n\n.timeline-details-view-row-value .timeline-details-warning-marker {\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    overflow: hidden;\n}\n\n.timeline-details-view-pie-chart-wrapper {\n    margin: 4px 0;\n}\n\n.timeline-details-view-pie-chart {\n    margin-top: 5px;\n}\n\n.timeline-details-view-pie-chart-total {\n    width: 100px;\n    margin-top: 10px;\n    text-align: center;\n}\n\n.timeline-details-view-row-stack-trace {\n    padding: 4px 0;\n    line-height: inherit;\n}\n\n.timeline-details-view-row-stack-trace div {\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    line-height: 12px;\n}\n\n.timeline-aggregated-info-legend > div {\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n}\n\n.timeline-flamechart {\n    overflow: hidden;\n}\n\n.timeline-status-pane.full-widget-dimmed-banner {\n    text-align: left !important;\n}\n\n.timeline-layers-view > div:last-child,\n.timeline-layers-view-properties > div:last-child {\n    background-color: #eee;\n}\n\n.timeline-layers-view-properties table {\n    width: 100%;\n    border-collapse: collapse;\n}\n\n.timeline-layers-view-properties td {\n    border: 1px solid #e1e1e1;\n    line-height: 22px;\n}\n\n.timeline-paint-profiler-log-split > div:last-child {\n    background-color: #eee;\n    z-index: 0;\n}\n\n.timeline-gap {\n    flex: none;\n}\n\n.timeline-filmstrip-preview {\n    margin-top: 10px;\n    max-width: 200px;\n    max-height: 200px;\n    cursor: pointer;\n    border: 1px solid #ddd;\n}\n\n.timeline-overview-popover .frame .time {\n    display: none;\n}\n\n.timeline-overview-popover .frame .thumbnail img {\n    max-width: 200px;\n}\n\n.timeline-tree-view {\n    display: flex;\n    overflow: hidden;\n}\n\n.timeline-tree-view > .toolbar {\n    border-bottom: 1px solid #dadada;\n}\n\n.timeline-tree-view .data-grid {\n    border: none;\n    flex: auto;\n}\n\n.timeline-tree-view .data-grid .data-container {\n    overflow-y: scroll;\n}\n\n.timeline-tree-view .data-grid.data-grid-fits-viewport .corner {\n    display: table-cell;\n}\n\n.timeline-tree-view .data-grid table.data {\n    background: white;\n}\n\n.timeline-tree-view .data-grid tr:not(.selected) .highlight {\n    background-color: rgb(255, 230, 179);\n}\n\n.timeline-tree-view .data-grid tr:hover td:not(.bottom-filler-td) {\n    background-color: rgba(0, 0, 0, 0.1);\n}\n\n.timeline-tree-view .data-grid td.numeric-column {\n    text-align: right;\n    position: relative;\n}\n\n.timeline-tree-view .data-grid div.background-percent-bar {\n    float: right;\n}\n\n.timeline-tree-view .data-grid span.percent-column {\n    color: #888;\n    width: 44px;\n    display: inline-block;\n}\n\n.timeline-tree-view .data-grid tr.selected span {\n    color: inherit;\n}\n\n.timeline-tree-view .data-grid .name-container {\n    display: flex;\n    align-items: center;\n}\n\n.timeline-tree-view .data-grid .name-container div {\n    flex: none;\n}\n\n.timeline-tree-view .data-grid .name-container .activity-icon {\n    width: 10px;\n    height: 10px;\n    margin: 0 4px 0 2px;\n    border: 1px solid rgba(0, 0, 0, 0.05);\n}\n\n.timeline-tree-view .data-grid .name-container .activity-warning::after {\n    content: \"[deopt]\";\n    margin: 0 4px;\n    line-height: 12px;\n    font-size: 10px;\n    color: #777;\n}\n\n.timeline-tree-view .data-grid tr.selected .name-container .activity-warning::after {\n    color: white;\n}\n\n.timeline-tree-view .data-grid .name-container .activity-link {\n    flex: auto;\n    text-align: right;\n    overflow: hidden;\n    text-overflow: ellipsis;\n    margin-left: 5px;\n}\n\n.timeline-tree-view .data-grid .background-bar-container {\n    position: absolute;\n    left: 3px;\n    right: 0;\n}\n\n.timeline-tree-view .data-grid .background-bar {\n    float: right;\n    height: 15px;\n    background-color: hsla(43, 84%, 64%, 0.2);\n    border-bottom: 1px solid hsl(43, 84%, 64%);\n}\n\n.timeline-tree-view .data-grid .selected .background-bar {\n    background-color: rgba(255, 255, 255, 0.25);\n    border-bottom-color: transparent;\n}\n\n.timeline-tree-view .timeline-details-view-body .full-widget-dimmed-banner {\n    background-color: inherit;\n}\n\n.timeline-details #filter-input-field {\n    width: 120px;\n}\n\n.timeline-tree-view .data-grid .header-container {\n    height: 21px;\n}\n\n.timeline-tree-view .data-grid .data-container {\n    top: 21px;\n}\n\n.timeline-tree-view .data-grid th {\n    border-bottom: 1px solid #ddd;\n    background-color: #f3f3f3\n}\n\n.timeline-stack-view-header {\n    height: 26px;\n    background-color: white;\n    padding: 6px 10px;\n    color: #5a5a5a;\n}\n\n/*# sourceURL=timeline/timelinePanel.css */";Runtime.cachedResources["timeline/timelinePaintProfiler.css"]="/*\n * Copyright 2016 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.paint-profiler-image-view {\n    overflow: hidden;\n}\n\n.paint-profiler-image-view .paint-profiler-image-container {\n    -webkit-transform-origin: 0 0;\n}\n\n.paint-profiler-image-view .paint-profiler-image-container div {\n    border-color: rgba(100, 100, 100, 0.4);\n    border-style: solid;\n    z-index: 100;\n    position: absolute;\n    top: 0;\n    left: 0;\n}\n\n.paint-profiler-image-view img {\n    border: solid 1px black;\n}\n\n/*# sourceURL=timeline/timelinePaintProfiler.css */";Runtime.cachedResources["timeline/timelineStatusDialog.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.timeline-status-dialog {\n    display: flex;\n    flex-direction: column;\n    padding: 12px 16px;\n    align-self: center;\n    background-color: white;\n    box-shadow: 0 0 0 1px rgba(0, 0, 0, 0.2),\n                0 2px 4px rgba(0, 0, 0, 0.2),\n                0 2px 6px rgba(0, 0, 0, 0.1);\n    margin-top: -1px;\n}\n\n.status-dialog-line {\n    margin: 2px;\n    height: 14px;\n    display: flex;\n    align-items: baseline;\n}\n\n.status-dialog-line .label {\n    display: inline-block;\n    width: 80px;\n    text-align: right;\n    color: #aaa;\n    margin-right: 10px;\n}\n\n.timeline-status-dialog .progress .indicator-container {\n    display: inline-block;\n    width: 200px;\n    height: 8px;\n    background-color: #f4f4f4;\n    display: inline-block;\n    margin: 0 10px 0 0;\n}\n\n.timeline-status-dialog .progress .indicator {\n    background-color: rgb(112, 166, 255);\n    height: 100%;\n    width: 0;\n    margin: 0;\n}\n\n.timeline-status-dialog .stop-button {\n    margin-top: 8px;\n    height: 100%;\n    align-self: center;\n}\n\n/*# sourceURL=timeline/timelineStatusDialog.css */";