Polymer({is:"iron-collapse",behaviors:[Polymer.IronResizableBehavior],properties:{horizontal:{type:Boolean,value:false,observer:"_horizontalChanged"},opened:{type:Boolean,value:false,notify:true,observer:"_openedChanged"},noAnimation:{type:Boolean},_desiredSize:{type:String,value:""}},get dimension(){return this.horizontal?"width":"height"},get _dimensionMax(){return this.horizontal?"maxWidth":"maxHeight"},get _dimensionMaxCss(){return this.horizontal?"max-width":"max-height"},hostAttributes:{role:"group","aria-hidden":"true","aria-expanded":"false"},listeners:{transitionend:"_transitionEnd"},attached:function(){this._transitionEnd()},toggle:function(){this.opened=!this.opened},show:function(){this.opened=true},hide:function(){this.opened=false},updateSize:function(size,animated){size=size==="auto"?"":size;if(this._desiredSize===size){return}this._desiredSize=size;this._updateTransition(false);var willAnimate=animated&&!this.noAnimation&&this._isDisplayed;if(willAnimate){var startSize=this._calcSize();if(size===""){this.style[this._dimensionMax]="";size=this._calcSize()}this.style[this._dimensionMax]=startSize;this.scrollTop=this.scrollTop;this._updateTransition(true);willAnimate=size!==startSize}this.style[this._dimensionMax]=size;if(!willAnimate){this._transitionEnd()}},enableTransition:function(enabled){Polymer.Base._warn("`enableTransition()` is deprecated, use `noAnimation` instead.");this.noAnimation=!enabled},_updateTransition:function(enabled){this.style.transitionDuration=enabled&&!this.noAnimation?"":"0s"},_horizontalChanged:function(){this.style.transitionProperty=this._dimensionMaxCss;var otherDimension=this._dimensionMax==="maxWidth"?"maxHeight":"maxWidth";this.style[otherDimension]="";this.updateSize(this.opened?"auto":"0px",false)},_openedChanged:function(){this.setAttribute("aria-expanded",this.opened);this.setAttribute("aria-hidden",!this.opened);this.toggleClass("iron-collapse-closed",false);this.toggleClass("iron-collapse-opened",false);this.updateSize(this.opened?"auto":"0px",true);if(this.opened){this.focus()}},_transitionEnd:function(){this.style[this._dimensionMax]=this._desiredSize;this.toggleClass("iron-collapse-closed",!this.opened);this.toggleClass("iron-collapse-opened",this.opened);this._updateTransition(false);this.notifyResize()},get _isDisplayed(){var rect=this.getBoundingClientRect();for(var prop in rect){if(rect[prop]!==0)return true}return false},_calcSize:function(){return this.getBoundingClientRect()[this.dimension]+"px"}});
// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var HistoryDomain;var HistoryGroup;Polymer({is:"history-grouped-list",behaviors:[HistoryListBehavior],properties:{searchedTerm:{type:String,value:""},groupedHistoryData_:Array,historyData:Array,queryInterval:String,range:Number},observers:["updateGroupedHistoryData_(historyData)"],addNewResults:function(results,incremental,finished){this.historyData=results},createHistoryDomains_:function(visits){var domainIndexes={};var domains=[];for(var i=0,visit;visit=visits[i];i++){var domain=visit.domain;if(domainIndexes[domain]==undefined){domainIndexes[domain]=domains.length;domains.push({domain:domain,visits:[],expanded:false,rendered:false})}domains[domainIndexes[domain]].visits.push(visit)}var sortByVisits=function(a,b){return b.visits.length-a.visits.length};domains.sort(sortByVisits);return domains},updateGroupedHistoryData_:function(){if(this.historyData.length==0){this.groupedHistoryData_=[];return}if(this.range==HistoryRange.WEEK){var days=[];var currentDayVisits=[this.historyData[0]];var pushCurrentDay=function(){days.push({title:this.searchedTerm?currentDayVisits[0].dateShort:currentDayVisits[0].dateRelativeDay,domains:this.createHistoryDomains_(currentDayVisits)})}.bind(this);var visitsSameDay=function(a,b){if(this.searchedTerm)return a.dateShort==b.dateShort;return a.dateRelativeDay==b.dateRelativeDay}.bind(this);for(var i=1;i<this.historyData.length;i++){var visit=this.historyData[i];if(!visitsSameDay(visit,currentDayVisits[0])){pushCurrentDay();currentDayVisits=[]}currentDayVisits.push(visit)}pushCurrentDay();this.groupedHistoryData_=days}else if(this.range==HistoryRange.MONTH){this.groupedHistoryData_=[{title:this.queryInterval,domains:this.createHistoryDomains_(this.historyData)}]}},toggleDomainExpanded_:function(e){var collapse=e.currentTarget.parentNode.querySelector("iron-collapse");e.model.set("domain.rendered",true);setTimeout(function(){collapse.toggle()},0)},needsTimeGap_:function(groupIndex,domainIndex,itemIndex){var visits=this.groupedHistoryData_[groupIndex].domains[domainIndex].visits;return md_history.HistoryItem.needsTimeGap(visits,itemIndex,this.searchedTerm)},pathForItem_:function(groupIndex,domainIndex,itemIndex){return["groupedHistoryData_",groupIndex,"domains",domainIndex,"visits",itemIndex].join(".")},getWebsiteIconStyle_:function(domain){return"background-image: "+cr.icon.getFavicon(domain.visits[0].url)},getDropdownIcon_:function(expanded){return expanded?"cr:expand-less":"cr:expand-more"}});
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
cr.define("cr.ui",function(){function FocusGrid(){this.rows=[]}FocusGrid.prototype={ignoreFocusChange_:false,onFocus:function(row,e){if(this.ignoreFocusChange_)this.ignoreFocusChange_=false;else this.lastFocused_=e.currentTarget;this.rows.forEach(function(r){r.makeActive(r==row)})},onKeydown:function(row,e){var rowIndex=this.rows.indexOf(row);assert(rowIndex>=0);var newRow=-1;if(e.key=="ArrowUp")newRow=rowIndex-1;else if(e.key=="ArrowDown")newRow=rowIndex+1;else if(e.key=="PageUp")newRow=0;else if(e.key=="PageDown")newRow=this.rows.length-1;var rowToFocus=this.rows[newRow];if(rowToFocus){this.ignoreFocusChange_=true;rowToFocus.getEquivalentElement(this.lastFocused_).focus();e.preventDefault();return true}return false},destroy:function(){this.rows.forEach(function(row){row.destroy()});this.rows.length=0},getRowIndexForTarget:function(target){for(var i=0;i<this.rows.length;++i){if(this.rows[i].getElements().indexOf(target)>=0)return i}return-1},getRowForRoot:function(root){for(var i=0;i<this.rows.length;++i){if(this.rows[i].root==root)return this.rows[i]}return null},addRow:function(row){this.addRowBefore(row,null)},addRowBefore:function(row,nextRow){row.delegate=row.delegate||this;var nextRowIndex=nextRow?this.rows.indexOf(nextRow):-1;if(nextRowIndex==-1)this.rows.push(row);else this.rows.splice(nextRowIndex,0,row)},removeRow:function(row){var nextRowIndex=row?this.rows.indexOf(row):-1;if(nextRowIndex>-1)this.rows.splice(nextRowIndex,1)},ensureRowActive:function(preferredRow){if(this.rows.length==0)return;for(var i=0;i<this.rows.length;++i){if(this.rows[i].isActive())return}(this.rows[preferredRow||0]||this.rows[0]).makeActive(true)}};return{FocusGrid:FocusGrid}});Polymer.PaperButtonBehaviorImpl={properties:{elevation:{type:Number,reflectToAttribute:true,readOnly:true}},observers:["_calculateElevation(focused, disabled, active, pressed, receivedFocusFromKeyboard)","_computeKeyboardClass(receivedFocusFromKeyboard)"],hostAttributes:{role:"button",tabindex:"0",animated:true},_calculateElevation:function(){var e=1;if(this.disabled){e=0}else if(this.active||this.pressed){e=4}else if(this.receivedFocusFromKeyboard){e=3}this._setElevation(e)},_computeKeyboardClass:function(receivedFocusFromKeyboard){this.toggleClass("keyboard-focus",receivedFocusFromKeyboard)},_spaceKeyDownHandler:function(event){Polymer.IronButtonStateImpl._spaceKeyDownHandler.call(this,event);if(this.hasRipple()&&this.getRipple().ripples.length<1){this._ripple.uiDownAction()}},_spaceKeyUpHandler:function(event){Polymer.IronButtonStateImpl._spaceKeyUpHandler.call(this,event);if(this.hasRipple()){this._ripple.uiUpAction()}}};Polymer.PaperButtonBehavior=[Polymer.IronButtonState,Polymer.IronControlState,Polymer.PaperRippleBehavior,Polymer.PaperButtonBehaviorImpl];Polymer({is:"paper-button",behaviors:[Polymer.PaperButtonBehavior],properties:{raised:{type:Boolean,reflectToAttribute:true,value:false,observer:"_calculateElevation"}},_calculateElevation:function(){if(!this.raised){this._setElevation(0)}else{Polymer.PaperButtonBehaviorImpl._calculateElevation.apply(this)}}});
// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
Polymer({is:"cr-action-menu","extends":"dialog",options_:null,anchorElement_:null,onWindowResize_:null,hostAttributes:{tabindex:0},listeners:{keydown:"onKeyDown_",tap:"onTap_"},attached:function(){this.options_=this.querySelectorAll(".dropdown-item")},detached:function(){this.removeResizeListener_()},removeResizeListener_:function(){window.removeEventListener("resize",this.onWindowResize_)},onTap_:function(e){if(e.target==this){this.close();e.stopPropagation()}},onKeyDown_:function(e){if(e.key=="Tab"||e.key=="Escape"){this.close();e.preventDefault();return}if(e.key!=="ArrowDown"&&e.key!=="ArrowUp")return;var nextOption=this.getNextOption_(e.key=="ArrowDown"?1:-1);if(nextOption)nextOption.focus();e.preventDefault()},getNextOption_:function(step){var counter=0;var nextOption=null;var numOptions=this.options_.length;var focusedIndex=Array.prototype.indexOf.call(this.options_,this.root.activeElement);do{focusedIndex=(numOptions+focusedIndex+step)%numOptions;nextOption=this.options_[focusedIndex];if(nextOption.disabled||nextOption.hidden)nextOption=null;counter++}while(!nextOption&&counter<numOptions);return nextOption},close:function(){this.removeResizeListener_();HTMLDialogElement.prototype.close.call(this);this.anchorElement_.focus();this.anchorElement_=null},showAt:function(anchorElement){this.anchorElement_=anchorElement;this.onWindowResize_=this.onWindowResize_||function(){if(this.open)this.close()}.bind(this);window.addEventListener("resize",this.onWindowResize_);this.style.left="";this.style.right="";this.style.top="";this.showModal();var rect=this.anchorElement_.getBoundingClientRect();if(getComputedStyle(this.anchorElement_).direction=="rtl"){var right=window.innerWidth-rect.left-this.offsetWidth;this.style.right=right+"px"}else{var left=rect.right-this.offsetWidth;this.style.left=left+"px"}var top=rect.top+this.offsetHeight<=window.innerHeight?rect.top:rect.bottom-this.offsetHeight-Math.max(rect.bottom-window.innerHeight,0);this.style.top=top+"px"}});Polymer({is:"paper-icon-button-light","extends":"button",behaviors:[Polymer.PaperRippleBehavior],listeners:{down:"_rippleDown",up:"_rippleUp",focus:"_rippleDown",blur:"_rippleUp"},_rippleDown:function(){this.getRipple().downAction()},_rippleUp:function(){this.getRipple().upAction()},ensureRipple:function(var_args){var lastRipple=this._ripple;Polymer.PaperRippleBehavior.ensureRipple.apply(this,arguments);if(this._ripple&&this._ripple!==lastRipple){this._ripple.center=true;this._ripple.classList.add("circle")}}});
// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
Polymer({is:"history-synced-device-card",properties:{tabs:{type:Array,value:function(){return[]},observer:"updateIcons_"},device:String,lastUpdateTime:String,opened:Boolean,searchTerm:String,separatorIndexes:Array,sessionTag:String},listeners:{"dom-change":"notifyFocusUpdate_"},createFocusRows:function(){var titleRow=new cr.ui.FocusRow(this.$["card-heading"],null);titleRow.addItem("menu","#menu-button");titleRow.addItem("collapse","#collapse-button");var rows=[titleRow];if(this.opened){Polymer.dom(this.root).querySelectorAll(".item-container").forEach(function(el){var row=new cr.ui.FocusRow(el,null);row.addItem("title",".website-title");rows.push(row)})}return rows},openTab_:function(e){var tab=e.model.tab;var browserService=md_history.BrowserService.getInstance();browserService.recordHistogram(SYNCED_TABS_HISTOGRAM_NAME,SyncedTabsHistogram.LINK_CLICKED,SyncedTabsHistogram.LIMIT);browserService.openForeignSessionTab(this.sessionTag,tab.windowId,tab.sessionId,e);e.preventDefault()},toggleTabCard:function(){var histogramValue=this.$.collapse.opened?SyncedTabsHistogram.COLLAPSE_SESSION:SyncedTabsHistogram.EXPAND_SESSION;md_history.BrowserService.getInstance().recordHistogram(SYNCED_TABS_HISTOGRAM_NAME,histogramValue,SyncedTabsHistogram.LIMIT);this.$.collapse.toggle();this.$["dropdown-indicator"].icon=this.$.collapse.opened?"cr:expand-less":"cr:expand-more";this.fire("update-focus-grid")},notifyFocusUpdate_:function(){this.fire("update-focus-grid")},updateIcons_:function(){this.async(function(){var icons=Polymer.dom(this.root).querySelectorAll(".website-icon");for(var i=0;i<this.tabs.length;i++){icons[i].style.backgroundImage=cr.icon.getFavicon(this.tabs[i].url)}})},isWindowSeparatorIndex_:function(index,separatorIndexes){return this.separatorIndexes.indexOf(index)!=-1},getCollapseIcon_:function(opened){return opened?"cr:expand-less":"cr:expand-more"},getCollapseTitle_:function(opened){return opened?loadTimeData.getString("collapseSessionButton"):loadTimeData.getString("expandSessionButton")},onMenuButtonTap_:function(e){this.fire("open-menu",{target:Polymer.dom(e).localTarget,tag:this.sessionTag});e.stopPropagation()},onLinkRightClick_:function(){md_history.BrowserService.getInstance().recordHistogram(SYNCED_TABS_HISTOGRAM_NAME,SyncedTabsHistogram.LINK_RIGHT_CLICKED,SyncedTabsHistogram.LIMIT)}});
// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var ForeignDeviceInternal;Polymer({is:"history-synced-device-manager",properties:{sessionList:{type:Array,observer:"updateSyncedDevices"},searchTerm:{type:String,observer:"searchTermChanged"},syncedDevices_:{type:Array,value:function(){return[]}},signInState:{type:Boolean,observer:"signInStateChanged_"},guestSession_:{type:Boolean,value:loadTimeData.getBoolean("isGuestSession")},fetchingSyncedTabs_:{type:Boolean,value:false},hasSeenForeignData_:Boolean,actionMenuModel_:String},listeners:{"open-menu":"onOpenMenu_","update-focus-grid":"updateFocusGrid_"},focusGrid_:null,attached:function(){this.focusGrid_=new cr.ui.FocusGrid;chrome.send("otherDevicesInitialized");md_history.BrowserService.getInstance().recordHistogram(SYNCED_TABS_HISTOGRAM_NAME,SyncedTabsHistogram.INITIALIZED,SyncedTabsHistogram.LIMIT)},detached:function(){this.focusGrid_.destroy()},getContentScrollTarget:function(){return this},createInternalDevice_:function(session){var tabs=[];var separatorIndexes=[];for(var i=0;i<session.windows.length;i++){var windowId=session.windows[i].sessionId;var newTabs=session.windows[i].tabs;if(newTabs.length==0)continue;newTabs.forEach(function(tab){tab.windowId=windowId});var windowAdded=false;if(!this.searchTerm){tabs=tabs.concat(newTabs);windowAdded=true}else{var searchText=this.searchTerm.toLowerCase();for(var j=0;j<newTabs.length;j++){var tab=newTabs[j];if(tab.title.toLowerCase().indexOf(searchText)!=-1){tabs.push(tab);windowAdded=true}}}if(windowAdded&&i!=session.windows.length-1)separatorIndexes.push(tabs.length-1)}return{device:session.name,lastUpdateTime:"– "+session.modifiedTime,opened:true,separatorIndexes:separatorIndexes,timestamp:session.timestamp,tabs:tabs,tag:session.tag}},onSignInTap_:function(){chrome.send("startSignInFlow")},onOpenMenu_:function(e){var menu=this.$.menu.get();this.actionMenuModel_=e.detail.tag;menu.showAt(e.detail.target);md_history.BrowserService.getInstance().recordHistogram(SYNCED_TABS_HISTOGRAM_NAME,SyncedTabsHistogram.SHOW_SESSION_MENU,SyncedTabsHistogram.LIMIT)},onOpenAllTap_:function(){var menu=assert(this.$.menu.getIfExists());var browserService=md_history.BrowserService.getInstance();browserService.recordHistogram(SYNCED_TABS_HISTOGRAM_NAME,SyncedTabsHistogram.OPEN_ALL,SyncedTabsHistogram.LIMIT);browserService.openForeignSessionAllTabs(assert(this.actionMenuModel_));this.actionMenuModel_=null;menu.close()},updateFocusGrid_:function(){if(!this.focusGrid_)return;this.focusGrid_.destroy();this.debounce("updateFocusGrid",function(){Polymer.dom(this.root).querySelectorAll("history-synced-device-card").reduce(function(prev,cur){return prev.concat(cur.createFocusRows())},[]).forEach(function(row){this.focusGrid_.addRow(row)}.bind(this));this.focusGrid_.ensureRowActive(1)})},onDeleteSessionTap_:function(){var menu=assert(this.$.menu.getIfExists());var browserService=md_history.BrowserService.getInstance();browserService.recordHistogram(SYNCED_TABS_HISTOGRAM_NAME,SyncedTabsHistogram.HIDE_FOR_NOW,SyncedTabsHistogram.LIMIT);browserService.deleteForeignSession(assert(this.actionMenuModel_));this.actionMenuModel_=null;menu.close()},clearDisplayedSyncedDevices_:function(){this.syncedDevices_=[]},showNoSyncedMessage:function(signInState,syncedDevicesLength,guestSession){if(guestSession)return true;return signInState&&syncedDevicesLength==0},showSignInGuide:function(signInState,guestSession){var show=!signInState&&!guestSession;if(show){md_history.BrowserService.getInstance().recordAction("Signin_Impression_FromRecentTabs")}return show},noSyncedTabsMessage:function(){var stringName=this.fetchingSyncedTabs_?"loading":"noSyncedResults";if(this.searchTerm!=="")stringName="noSearchResults";return loadTimeData.getString(stringName)},updateSyncedDevices:function(sessionList){this.fetchingSyncedTabs_=false;if(!sessionList)return;if(sessionList.length>0&&!this.hasSeenForeignData_){this.hasSeenForeignData_=true;md_history.BrowserService.getInstance().recordHistogram(SYNCED_TABS_HISTOGRAM_NAME,SyncedTabsHistogram.HAS_FOREIGN_DATA,SyncedTabsHistogram.LIMIT)}var devices=[];sessionList.forEach(function(session){var device=this.createInternalDevice_(session);if(device.tabs.length!=0)devices.push(device)}.bind(this));this.syncedDevices_=devices},signInStateChanged_:function(){this.fire("history-view-changed");if(!this.signInState){this.clearDisplayedSyncedDevices_();return}this.fetchingSyncedTabs_=true},searchTermChanged:function(searchTerm){this.clearDisplayedSyncedDevices_();this.updateSyncedDevices(this.sessionList)}});
// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
Polymer({is:"cr-dialog","extends":"dialog",properties:{closeText:String,ignorePopstate:{type:Boolean,value:false}},ready:function(){window.addEventListener("popstate",function(){if(!this.ignorePopstate&&this.open)this.cancel()}.bind(this))},cancel:function(){this.fire("cancel");HTMLDialogElement.prototype.close.call(this,"")},close:function(opt_returnValue){HTMLDialogElement.prototype.close.call(this,"success")},getCloseButton:function(){return this.$.close}});
// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
Polymer({is:"cr-drawer","extends":"dialog",properties:{open:{type:Boolean,notify:true},align:{type:String,value:"left",reflectToAttribute:true}},listeners:{cancel:"onDialogCancel_",tap:"onDialogTap_",transitionend:"onDialogTransitionEnd_"},toggle:function(){if(this.open)this.closeDrawer();else this.openDrawer()},openDrawer:function(){if(!this.open){this.showModal();this.classList.add("opening")}},closeDrawer:function(){if(this.open){this.classList.remove("opening");this.classList.add("closing")}},onContainerTap_:function(event){event.stopPropagation()},onDialogTap_:function(){this.closeDrawer()},onDialogCancel_:function(event){event.preventDefault();this.closeDrawer()},onDialogTransitionEnd_:function(){if(this.classList.contains("closing")){this.classList.remove("closing");this.close()}}});Polymer({is:"paper-tab",behaviors:[Polymer.IronControlState,Polymer.IronButtonState,Polymer.PaperRippleBehavior],properties:{link:{type:Boolean,value:false,reflectToAttribute:true}},hostAttributes:{role:"tab"},listeners:{down:"_updateNoink",tap:"_onTap"},attached:function(){this._updateNoink()},get _parentNoink(){var parent=Polymer.dom(this).parentNode;return!!parent&&!!parent.noink},_updateNoink:function(){this.noink=!!this.noink||!!this._parentNoink},_onTap:function(event){if(this.link){var anchor=this.queryEffectiveChildren("a");if(!anchor){return}if(event.target===anchor){return}anchor.click()}}});Polymer.IronMenuBehaviorImpl={properties:{focusedItem:{observer:"_focusedItemChanged",readOnly:true,type:Object},attrForItemTitle:{type:String}},hostAttributes:{role:"menu",tabindex:"0"},observers:["_updateMultiselectable(multi)"],listeners:{focus:"_onFocus",keydown:"_onKeydown","iron-items-changed":"_onIronItemsChanged"},keyBindings:{up:"_onUpKey",down:"_onDownKey",esc:"_onEscKey","shift+tab:keydown":"_onShiftTabDown"},attached:function(){this._resetTabindices()},select:function(value){if(this._defaultFocusAsync){this.cancelAsync(this._defaultFocusAsync);this._defaultFocusAsync=null}var item=this._valueToItem(value);if(item&&item.hasAttribute("disabled"))return;this._setFocusedItem(item);Polymer.IronMultiSelectableBehaviorImpl.select.apply(this,arguments)},_resetTabindices:function(){var selectedItem=this.multi?this.selectedItems&&this.selectedItems[0]:this.selectedItem;this.items.forEach(function(item){item.setAttribute("tabindex",item===selectedItem?"0":"-1")},this)},_updateMultiselectable:function(multi){if(multi){this.setAttribute("aria-multiselectable","true")}else{this.removeAttribute("aria-multiselectable")}},_focusWithKeyboardEvent:function(event){for(var i=0,item;item=this.items[i];i++){var attr=this.attrForItemTitle||"textContent";var title=item[attr]||item.getAttribute(attr);if(!item.hasAttribute("disabled")&&title&&title.trim().charAt(0).toLowerCase()===String.fromCharCode(event.keyCode).toLowerCase()){this._setFocusedItem(item);break}}},_focusPrevious:function(){var length=this.items.length;var curFocusIndex=Number(this.indexOf(this.focusedItem));for(var i=1;i<length+1;i++){var item=this.items[(curFocusIndex-i+length)%length];if(!item.hasAttribute("disabled")){var owner=Polymer.dom(item).getOwnerRoot()||document;this._setFocusedItem(item);if(Polymer.dom(owner).activeElement==item){return}}}},_focusNext:function(){var length=this.items.length;var curFocusIndex=Number(this.indexOf(this.focusedItem));for(var i=1;i<length+1;i++){var item=this.items[(curFocusIndex+i)%length];if(!item.hasAttribute("disabled")){var owner=Polymer.dom(item).getOwnerRoot()||document;this._setFocusedItem(item);if(Polymer.dom(owner).activeElement==item){return}}}},_applySelection:function(item,isSelected){if(isSelected){item.setAttribute("aria-selected","true")}else{item.removeAttribute("aria-selected")}Polymer.IronSelectableBehavior._applySelection.apply(this,arguments)},_focusedItemChanged:function(focusedItem,old){old&&old.setAttribute("tabindex","-1");if(focusedItem){focusedItem.setAttribute("tabindex","0");focusedItem.focus()}},_onIronItemsChanged:function(event){if(event.detail.addedNodes.length){this._resetTabindices()}},_onShiftTabDown:function(event){var oldTabIndex=this.getAttribute("tabindex");Polymer.IronMenuBehaviorImpl._shiftTabPressed=true;this._setFocusedItem(null);this.setAttribute("tabindex","-1");this.async(function(){this.setAttribute("tabindex",oldTabIndex);Polymer.IronMenuBehaviorImpl._shiftTabPressed=false},1)},_onFocus:function(event){if(Polymer.IronMenuBehaviorImpl._shiftTabPressed){return}var rootTarget=Polymer.dom(event).rootTarget;if(rootTarget!==this&&typeof rootTarget.tabIndex!=="undefined"&&!this.isLightDescendant(rootTarget)){return}this._defaultFocusAsync=this.async(function(){var selectedItem=this.multi?this.selectedItems&&this.selectedItems[0]:this.selectedItem;this._setFocusedItem(null);if(selectedItem){this._setFocusedItem(selectedItem)}else if(this.items[0]){this._focusNext()}})},_onUpKey:function(event){this._focusPrevious();event.detail.keyboardEvent.preventDefault()},_onDownKey:function(event){this._focusNext();event.detail.keyboardEvent.preventDefault()},_onEscKey:function(event){this.focusedItem.blur()},_onKeydown:function(event){if(!this.keyboardEventMatchesKeys(event,"up down esc")){this._focusWithKeyboardEvent(event)}event.stopPropagation()},_activateHandler:function(event){Polymer.IronSelectableBehavior._activateHandler.call(this,event);event.stopPropagation()}};Polymer.IronMenuBehaviorImpl._shiftTabPressed=false;Polymer.IronMenuBehavior=[Polymer.IronMultiSelectableBehavior,Polymer.IronA11yKeysBehavior,Polymer.IronMenuBehaviorImpl];Polymer.IronMenubarBehaviorImpl={hostAttributes:{role:"menubar"},keyBindings:{left:"_onLeftKey",right:"_onRightKey"},_onUpKey:function(event){this.focusedItem.click();event.detail.keyboardEvent.preventDefault()},_onDownKey:function(event){this.focusedItem.click();event.detail.keyboardEvent.preventDefault()},get _isRTL(){return window.getComputedStyle(this)["direction"]==="rtl"},_onLeftKey:function(event){if(this._isRTL){this._focusNext()}else{this._focusPrevious()}event.detail.keyboardEvent.preventDefault()},_onRightKey:function(event){if(this._isRTL){this._focusPrevious()}else{this._focusNext()}event.detail.keyboardEvent.preventDefault()},_onKeydown:function(event){if(this.keyboardEventMatchesKeys(event,"up down left right esc")){return}this._focusWithKeyboardEvent(event)}};Polymer.IronMenubarBehavior=[Polymer.IronMenuBehavior,Polymer.IronMenubarBehaviorImpl];Polymer({is:"paper-tabs",behaviors:[Polymer.IronResizableBehavior,Polymer.IronMenubarBehavior],properties:{noink:{type:Boolean,value:false,observer:"_noinkChanged"},noBar:{type:Boolean,value:false},noSlide:{type:Boolean,value:false},scrollable:{type:Boolean,value:false},fitContainer:{type:Boolean,value:false},disableDrag:{type:Boolean,value:false},hideScrollButtons:{type:Boolean,value:false},alignBottom:{type:Boolean,value:false},selectable:{type:String,value:"paper-tab"},autoselect:{type:Boolean,value:false},autoselectDelay:{type:Number,value:0},_step:{type:Number,value:10},_holdDelay:{type:Number,value:1},_leftHidden:{type:Boolean,value:false},_rightHidden:{type:Boolean,value:false},_previousTab:{type:Object}},hostAttributes:{role:"tablist"},listeners:{"iron-resize":"_onTabSizingChanged","iron-items-changed":"_onTabSizingChanged","iron-select":"_onIronSelect","iron-deselect":"_onIronDeselect"},keyBindings:{"left:keyup right:keyup":"_onArrowKeyup"},created:function(){this._holdJob=null;this._pendingActivationItem=undefined;this._pendingActivationTimeout=undefined;this._bindDelayedActivationHandler=this._delayedActivationHandler.bind(this);this.addEventListener("blur",this._onBlurCapture.bind(this),true)},ready:function(){this.setScrollDirection("y",this.$.tabsContainer)},detached:function(){this._cancelPendingActivation()},_noinkChanged:function(noink){var childTabs=Polymer.dom(this).querySelectorAll("paper-tab");childTabs.forEach(noink?this._setNoinkAttribute:this._removeNoinkAttribute)},_setNoinkAttribute:function(element){element.setAttribute("noink","")},_removeNoinkAttribute:function(element){element.removeAttribute("noink")},_computeScrollButtonClass:function(hideThisButton,scrollable,hideScrollButtons){if(!scrollable||hideScrollButtons){return"hidden"}if(hideThisButton){return"not-visible"}return""},_computeTabsContentClass:function(scrollable,fitContainer){return scrollable?"scrollable"+(fitContainer?" fit-container":""):" fit-container"},_computeSelectionBarClass:function(noBar,alignBottom){if(noBar){return"hidden"}else if(alignBottom){return"align-bottom"}return""},_onTabSizingChanged:function(){this.debounce("_onTabSizingChanged",function(){this._scroll();this._tabChanged(this.selectedItem)},10)},_onIronSelect:function(event){this._tabChanged(event.detail.item,this._previousTab);this._previousTab=event.detail.item;this.cancelDebouncer("tab-changed")},_onIronDeselect:function(event){this.debounce("tab-changed",function(){this._tabChanged(null,this._previousTab);this._previousTab=null},1)},_activateHandler:function(){this._cancelPendingActivation();Polymer.IronMenuBehaviorImpl._activateHandler.apply(this,arguments)},_scheduleActivation:function(item,delay){this._pendingActivationItem=item;this._pendingActivationTimeout=this.async(this._bindDelayedActivationHandler,delay)},_delayedActivationHandler:function(){var item=this._pendingActivationItem;this._pendingActivationItem=undefined;this._pendingActivationTimeout=undefined;item.fire(this.activateEvent,null,{bubbles:true,cancelable:true})},_cancelPendingActivation:function(){if(this._pendingActivationTimeout!==undefined){this.cancelAsync(this._pendingActivationTimeout);this._pendingActivationItem=undefined;this._pendingActivationTimeout=undefined}},_onArrowKeyup:function(event){if(this.autoselect){this._scheduleActivation(this.focusedItem,this.autoselectDelay)}},_onBlurCapture:function(event){if(event.target===this._pendingActivationItem){this._cancelPendingActivation()}},get _tabContainerScrollSize(){return Math.max(0,this.$.tabsContainer.scrollWidth-this.$.tabsContainer.offsetWidth)},_scroll:function(e,detail){if(!this.scrollable){return}var ddx=detail&&-detail.ddx||0;this._affectScroll(ddx)},_down:function(e){this.async(function(){if(this._defaultFocusAsync){this.cancelAsync(this._defaultFocusAsync);this._defaultFocusAsync=null}},1)},_affectScroll:function(dx){this.$.tabsContainer.scrollLeft+=dx;var scrollLeft=this.$.tabsContainer.scrollLeft;this._leftHidden=scrollLeft===0;this._rightHidden=scrollLeft===this._tabContainerScrollSize},_onLeftScrollButtonDown:function(){this._scrollToLeft();this._holdJob=setInterval(this._scrollToLeft.bind(this),this._holdDelay)},_onRightScrollButtonDown:function(){this._scrollToRight();this._holdJob=setInterval(this._scrollToRight.bind(this),this._holdDelay)},_onScrollButtonUp:function(){clearInterval(this._holdJob);this._holdJob=null},_scrollToLeft:function(){this._affectScroll(-this._step)},_scrollToRight:function(){this._affectScroll(this._step)},_tabChanged:function(tab,old){if(!tab){this.$.selectionBar.classList.remove("expand");this.$.selectionBar.classList.remove("contract");this._positionBar(0,0);return}var r=this.$.tabsContent.getBoundingClientRect();var w=r.width;var tabRect=tab.getBoundingClientRect();var tabOffsetLeft=tabRect.left-r.left;this._pos={width:this._calcPercent(tabRect.width,w),left:this._calcPercent(tabOffsetLeft,w)};if(this.noSlide||old==null){this.$.selectionBar.classList.remove("expand");this.$.selectionBar.classList.remove("contract");this._positionBar(this._pos.width,this._pos.left);return}var oldRect=old.getBoundingClientRect();var oldIndex=this.items.indexOf(old);var index=this.items.indexOf(tab);var m=5;this.$.selectionBar.classList.add("expand");var moveRight=oldIndex<index;var isRTL=this._isRTL;if(isRTL){moveRight=!moveRight}if(moveRight){this._positionBar(this._calcPercent(tabRect.left+tabRect.width-oldRect.left,w)-m,this._left)}else{this._positionBar(this._calcPercent(oldRect.left+oldRect.width-tabRect.left,w)-m,this._calcPercent(tabOffsetLeft,w)+m)}if(this.scrollable){this._scrollToSelectedIfNeeded(tabRect.width,tabOffsetLeft)}},_scrollToSelectedIfNeeded:function(tabWidth,tabOffsetLeft){var l=tabOffsetLeft-this.$.tabsContainer.scrollLeft;if(l<0){this.$.tabsContainer.scrollLeft+=l}else{l+=tabWidth-this.$.tabsContainer.offsetWidth;if(l>0){this.$.tabsContainer.scrollLeft+=l}}},_calcPercent:function(w,w0){return 100*w/w0},_positionBar:function(width,left){width=width||0;left=left||0;this._width=width;this._left=left;this.transform("translateX("+left+"%) scaleX("+width/100+")",this.$.selectionBar)},_onBarTransitionEnd:function(e){var cl=this.$.selectionBar.classList;if(cl.contains("expand")){cl.remove("expand");cl.add("contract");this._positionBar(this._pos.width,this._pos.left)}else if(cl.contains("contract")){cl.remove("contract")}}});