# Copyright 2014 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

# This file is shared between the regular GYP build, the NaCl GYP build, and
# the GN build. For GN support, it must have no conditionals or anything like
# that beyond the simple one-level-deep dictionary of values.
{
  'variables': {
    # Subset of net source files that are compiled for NaCl (net_nacl target).
    # These files must not depend on files listed in sources list in the net
    # target.
    'net_nacl_common_sources' : [
      'base/address_family.cc',
      'base/address_family.h',
      'base/address_list.cc',
      'base/address_list.h',
      'base/auth.cc',
      'base/auth.h',
      'base/completion_callback.h',
      'base/escape.cc',
      'base/escape.h',
      'base/hash_value.cc',
      'base/hash_value.h',
      'base/host_port_pair.cc',
      'base/host_port_pair.h',
      'base/io_buffer.cc',
      'base/io_buffer.h',
      'base/ip_address.cc',
      'base/ip_address.h',
      'base/ip_endpoint.cc',
      'base/ip_endpoint.h',
      'base/load_timing_info.cc',
      'base/load_timing_info.h',
      'base/lookup_string_in_fixed_set.cc',
      'base/lookup_string_in_fixed_set.h',
      'base/net_error_details.h',
      'base/net_error_list.h',
      'base/net_errors.cc',
      'base/net_errors.h',
      'base/net_errors_posix.cc',
      'base/net_export.h',
      'base/net_module.cc',
      'base/net_module.h',
      'base/net_string_util.h',
      'base/network_interfaces.cc',
      'base/network_interfaces.h',
      'base/network_interfaces_posix.cc',
      'base/openssl_private_key_store.h',
      'base/openssl_private_key_store_android.cc',
      'base/openssl_private_key_store_memory.cc',
      'base/parse_number.cc',
      'base/parse_number.h',
      'base/port_util.cc',
      'base/port_util.h',
      'base/rand_callback.h',
      'base/registry_controlled_domains/registry_controlled_domain.cc',
      'base/registry_controlled_domains/registry_controlled_domain.h',
      'base/sockaddr_storage.cc',
      'base/sockaddr_storage.h',
      'base/sys_addrinfo.h',
      'base/url_util.cc',
      'base/url_util.h',
      'base/zap.cc',
      'base/zap.h',
      'cert/asn1_util.cc',
      'cert/asn1_util.h',
      'cert/cert_database.cc',
      'cert/cert_database.h',
      'cert/cert_database_openssl.cc',
      'cert/cert_status_flags.cc',
      'cert/cert_status_flags.h',
      'cert/cert_verifier.cc',
      'cert/cert_verifier.h',
      'cert/cert_verify_result.cc',
      'cert/cert_verify_result.h',
      'cert/client_cert_verifier.h',
      'cert/crl_set.cc',
      'cert/crl_set.h',
      'cert/ct_known_logs.cc',
      'cert/ct_known_logs.h',
      'cert/ct_known_logs_static-inc.h',
      'cert/ct_policy_enforcer.cc',
      'cert/ct_policy_enforcer.h',
      'cert/ct_policy_status.h',
      'cert/ct_verifier.h',
      'cert/ct_verify_result.cc',
      'cert/ct_verify_result.h',
      'cert/internal/cert_issuer_source.h',
      'cert/internal/cert_issuer_source_aia.cc',
      'cert/internal/cert_issuer_source_aia.h',
      'cert/internal/cert_issuer_source_static.cc',
      'cert/internal/cert_issuer_source_static.h',
      'cert/internal/certificate_policies.cc',
      'cert/internal/certificate_policies.h',
      'cert/internal/extended_key_usage.cc',
      'cert/internal/extended_key_usage.h',
      'cert/internal/name_constraints.cc',
      'cert/internal/name_constraints.h',
      'cert/internal/parse_certificate.cc',
      'cert/internal/parse_certificate.h',
      'cert/internal/parse_name.cc',
      'cert/internal/parse_name.h',
      'cert/internal/parse_ocsp.cc',
      'cert/internal/parse_ocsp.h',
      'cert/internal/parsed_certificate.cc',
      'cert/internal/parsed_certificate.h',
      'cert/internal/path_builder.cc',
      'cert/internal/path_builder.h',
      'cert/internal/signature_algorithm.cc',
      'cert/internal/signature_algorithm.h',
      'cert/internal/signature_policy.cc',
      'cert/internal/signature_policy.h',
      'cert/internal/trust_store.cc',
      'cert/internal/trust_store.h',
      'cert/internal/trust_store_in_memory.cc',
      'cert/internal/trust_store_in_memory.h',
      'cert/internal/verify_certificate_chain.cc',
      'cert/internal/verify_certificate_chain.h',
      'cert/internal/verify_name_match.cc',
      'cert/internal/verify_name_match.h',
      'cert/internal/verify_signed_data.cc',
      'cert/internal/verify_signed_data.h',
      'cert/ocsp_revocation_status.h',
      'cert/ocsp_verify_result.cc',
      'cert/ocsp_verify_result.h',
      'cert/pem_tokenizer.cc',
      'cert/pem_tokenizer.h',
      'cert/signed_certificate_timestamp.cc',
      'cert/signed_certificate_timestamp.h',
      'cert/signed_certificate_timestamp_and_status.cc',
      'cert/signed_certificate_timestamp_and_status.h',
      'cert/signed_tree_head.cc',
      'cert/signed_tree_head.h',
      'cert/sth_distributor.cc',
      'cert/sth_distributor.h',
      'cert/sth_observer.h',
      'cert/sth_reporter.h',
      'cert/x509_cert_types.cc',
      'cert/x509_cert_types.h',
      'cert/x509_certificate.cc',
      'cert/x509_certificate.h',
      'cert/x509_certificate_net_log_param.cc',
      'cert/x509_certificate_net_log_param.h',
      'cert/x509_certificate_openssl.cc',
      'cert/x509_util.cc',
      'cert/x509_util.h',
      'cert/x509_util_openssl.cc',
      'cert/x509_util_openssl.h',
      'der/input.cc',
      'der/input.h',
      'der/encode_values.cc',
      'der/encode_values.h',
      'der/parse_values.cc',
      'der/parse_values.h',
      'der/parser.cc',
      'der/parser.h',
      'der/tag.cc',
      'der/tag.h',
      'dns/dns_util.cc',
      'dns/dns_util.h',
      'http/http_auth_challenge_tokenizer.cc',
      'http/http_auth_challenge_tokenizer.h',
      'http/http_auth_scheme.cc',
      'http/http_auth_scheme.h',
      'http/http_byte_range.cc',
      'http/http_byte_range.h',
      'http/http_log_util.cc',
      'http/http_log_util.h',
      'http/http_request_headers.cc',
      'http/http_request_headers.h',
      'http/http_response_headers.cc',
      'http/http_response_headers.h',
      'http/http_response_info.cc',
      'http/http_response_info.h',
      'http/http_security_headers.cc',
      'http/http_security_headers.h',
      'http/http_status_line_validator.cc',
      'http/http_status_line_validator.h',
      'http/http_util.cc',
      'http/http_util.h',
      'http/http_vary_data.cc',
      'http/http_vary_data.h',
      'http/transport_security_state.cc',
      'http/transport_security_state.h',
      'log/net_log.cc',
      'log/net_log.h',
      'log/net_log_capture_mode.cc',
      'log/net_log_capture_mode.h',
      'log/net_log_event_type_list.h',
      'log/net_log_source_type_list.h',
      'socket/client_socket_handle.cc',
      'socket/client_socket_handle.h',
      'socket/connection_attempts.h',
      'socket/next_proto.h',
      'socket/socket.h',
      'socket/socket_performance_watcher.h',
      'socket/socket_performance_watcher_factory.h',
      'socket/ssl_client_socket.cc',
      'socket/ssl_client_socket.h',
      'socket/ssl_client_socket_impl.cc',
      'socket/ssl_client_socket_impl.h',
      'socket/ssl_socket.h',
      'ssl/channel_id_service.cc',
      'ssl/channel_id_service.h',
      'ssl/channel_id_store.cc',
      'ssl/channel_id_store.h',
      'ssl/client_key_store.cc',
      'ssl/client_key_store.h',
      'ssl/default_channel_id_store.cc',
      'ssl/default_channel_id_store.h',
      'ssl/openssl_client_key_store.cc',
      'ssl/openssl_client_key_store.h',
      'ssl/openssl_ssl_util.cc',
      'ssl/openssl_ssl_util.h',
      'ssl/ssl_cert_request_info.cc',
      'ssl/ssl_cert_request_info.h',
      'ssl/ssl_cipher_suite_names.cc',
      'ssl/ssl_cipher_suite_names.h',
      'ssl/ssl_client_auth_cache.cc',
      'ssl/ssl_client_auth_cache.h',
      'ssl/ssl_client_cert_type.h',
      'ssl/ssl_client_session_cache.cc',
      'ssl/ssl_client_session_cache.h',
      'ssl/ssl_config.cc',
      'ssl/ssl_config.h',
      'ssl/ssl_config_service.cc',
      'ssl/ssl_config_service.h',
      'ssl/ssl_info.cc',
      'ssl/ssl_info.h',
      'ssl/ssl_private_key.h',
      'ssl/ssl_server_config.cc',
      'ssl/ssl_server_config.h',
      'ssl/token_binding.cc',
      'ssl/token_binding.h',
    ],
    'net_non_nacl_sources': [
      'android/cellular_signal_strength.cc',
      'android/cellular_signal_strength.h',
      'android/cert_verify_result_android.cc',
      'android/cert_verify_result_android.h',
      'android/gurl_utils.cc',
      'android/gurl_utils.h',
      'android/http_auth_negotiate_android.cc',
      'android/http_auth_negotiate_android.h',
      'android/keystore.cc',
      'android/keystore.h',
      'android/keystore_openssl.cc',
      'android/keystore_openssl.h',
      'android/legacy_openssl.h',
      'android/net_jni_registrar.cc',
      'android/net_jni_registrar.h',
      'android/network_change_notifier_android.cc',
      'android/network_change_notifier_android.h',
      'android/network_change_notifier_delegate_android.cc',
      'android/network_change_notifier_delegate_android.h',
      'android/network_change_notifier_factory_android.cc',
      'android/network_change_notifier_factory_android.h',
      'android/network_library.cc',
      'android/network_library.h',
      'android/traffic_stats.cc',
      'android/traffic_stats.h',
      'base/address_tracker_linux.cc',
      'base/address_tracker_linux.h',
      'base/arena.cc',
      'base/arena.h',
      'base/backoff_entry.cc',
      'base/backoff_entry.h',
      'base/backoff_entry_serializer.cc',
      'base/backoff_entry_serializer.h',
      'base/cache_type.h',
      'base/chunked_upload_data_stream.cc',
      'base/chunked_upload_data_stream.h',
      'base/crypto_module.h',
      'base/crypto_module_nss.cc',
      'base/crypto_module_openssl.cc',
      'base/data_url.cc',
      'base/data_url.h',
      'base/elements_upload_data_stream.cc',
      'base/elements_upload_data_stream.h',
      'base/expiring_cache.h',
      'base/file_stream.cc',
      'base/file_stream.h',
      'base/file_stream_context.cc',
      'base/file_stream_context.h',
      'base/file_stream_context_posix.cc',
      'base/file_stream_context_win.cc',
      'base/filename_util.cc',
      'base/filename_util.h',
      'base/filename_util_internal.cc',
      'base/filename_util_internal.h',
      'base/host_mapping_rules.cc',
      'base/host_mapping_rules.h',
      'base/int128.cc',
      'base/int128.h',
      'base/iovec.h',
      'base/ip_pattern.cc',
      'base/ip_pattern.h',
      'base/keygen_handler.cc',
      'base/keygen_handler.h',
      'base/keygen_handler_mac.cc',
      'base/keygen_handler_nss.cc',
      'base/keygen_handler_openssl.cc',
      'base/keygen_handler_win.cc',
      # TODO(tc): gnome-vfs? xdgmime? /etc/mime.types?
      'base/layered_network_delegate.cc',
      'base/layered_network_delegate.h',
      'base/linked_hash_map.h',
      'base/load_flags.h',
      'base/load_flags_list.h',
      'base/load_states.h',
      'base/load_states_list.h',
      'base/logging_network_change_observer.cc',
      'base/logging_network_change_observer.h',
      'base/mime_extension_chromeos.cc',
      'base/mime_extension_chromeos.h',
      'base/mime_sniffer.cc',
      'base/mime_sniffer.h',
      'base/mime_util.cc',
      'base/mime_util.h',
      'base/net_errors_win.cc',
      'base/net_info_source_list.h',
      'base/network_activity_monitor.cc',
      'base/network_activity_monitor.h',
      'base/network_change_notifier.cc',
      'base/network_change_notifier.h',
      'base/network_change_notifier_factory.h',
      'base/network_change_notifier_linux.cc',
      'base/network_change_notifier_linux.h',
      'base/network_change_notifier_mac.cc',
      'base/network_change_notifier_mac.h',
      'base/network_change_notifier_win.cc',
      'base/network_change_notifier_win.h',
      'base/network_config_watcher_mac.cc',
      'base/network_config_watcher_mac.h',
      'base/network_delegate.cc',
      'base/network_delegate.h',
      'base/network_delegate_impl.cc',
      'base/network_delegate_impl.h',
      'base/network_interfaces_linux.cc',
      'base/network_interfaces_mac.cc',
      'base/network_interfaces_win.cc',
      'base/platform_mime_util.h',
      'base/platform_mime_util_linux.cc',
      'base/platform_mime_util_mac.mm',
      'base/platform_mime_util_win.cc',
      'base/prioritized_dispatcher.cc',
      'base/prioritized_dispatcher.h',
      'base/priority_queue.h',
      'base/proxy_delegate.h',
      'base/request_priority.cc',
      'base/request_priority.h',
      'base/sdch_dictionary.cc',
      'base/sdch_dictionary.h',
      'base/sdch_manager.cc',
      'base/sdch_manager.h',
      'base/sdch_net_log_params.cc',
      'base/sdch_net_log_params.h',
      'base/sdch_observer.cc',
      'base/sdch_observer.h',
      'base/sdch_problem_code_list.h',
      'base/sdch_problem_codes.h',
      'base/static_cookie_policy.cc',
      'base/static_cookie_policy.h',
      'base/test_data_stream.cc',
      'base/test_data_stream.h',
      'base/upload_bytes_element_reader.cc',
      'base/upload_bytes_element_reader.h',
      'base/upload_data_stream.cc',
      'base/upload_data_stream.h',
      'base/upload_element_reader.cc',
      'base/upload_element_reader.h',
      'base/upload_file_element_reader.cc',
      'base/upload_file_element_reader.h',
      'base/upload_progress.h',
      'base/winsock_init.cc',
      'base/winsock_init.h',
      'base/winsock_util.cc',
      'base/winsock_util.h',
      'cert/caching_cert_verifier.cc',
      'cert/caching_cert_verifier.h',
      'cert/cert_database_android.cc',
      'cert/cert_database_ios.cc',
      'cert/cert_database_mac.cc',
      'cert/cert_database_nss.cc',
      'cert/cert_database_win.cc',
      'cert/cert_net_fetcher.h',
      'cert/cert_verify_proc.cc',
      'cert/cert_verify_proc.h',
      'cert/cert_verify_proc_android.cc',
      'cert/cert_verify_proc_android.h',
      'cert/cert_verify_proc_ios.cc',
      'cert/cert_verify_proc_ios.h',
      'cert/cert_verify_proc_mac.cc',
      'cert/cert_verify_proc_mac.h',
      'cert/cert_verify_proc_nss.cc',
      'cert/cert_verify_proc_nss.h',
      'cert/cert_verify_proc_openssl.cc',
      'cert/cert_verify_proc_openssl.h',
      'cert/cert_verify_proc_whitelist.cc',
      'cert/cert_verify_proc_whitelist.h',
      'cert/cert_verify_proc_win.cc',
      'cert/cert_verify_proc_win.h',
      'cert/crl_set_storage.cc',
      'cert/crl_set_storage.h',
      'cert/ct_ev_whitelist.h',
      'cert/ct_log_response_parser.cc',
      'cert/ct_log_response_parser.h',
      'cert/ct_log_verifier.cc',
      'cert/ct_log_verifier.h',
      'cert/ct_log_verifier_util.cc',
      'cert/ct_log_verifier_util.h',
      'cert/ct_objects_extractor.cc',
      'cert/ct_objects_extractor.h',
      'cert/ct_sct_to_string.cc',
      'cert/ct_sct_to_string.h',
      'cert/ct_serialization.cc',
      'cert/ct_serialization.h',
      'cert/ct_signed_certificate_timestamp_log_param.cc',
      'cert/ct_signed_certificate_timestamp_log_param.h',
      'cert/ev_root_ca_metadata.cc',
      'cert/ev_root_ca_metadata.h',
      'cert/jwk_serializer.cc',
      'cert/jwk_serializer.h',
      'cert/merkle_audit_proof.cc',
      'cert/merkle_audit_proof.h',
      'cert/merkle_consistency_proof.cc',
      'cert/merkle_consistency_proof.h',
      'cert/merkle_tree_leaf.cc',
      'cert/merkle_tree_leaf.h',
      'cert/multi_log_ct_verifier.cc',
      'cert/multi_log_ct_verifier.h',
      'cert/multi_threaded_cert_verifier.cc',
      'cert/multi_threaded_cert_verifier.h',
      'cert/nss_cert_database.cc',
      'cert/nss_cert_database.h',
      'cert/nss_cert_database_chromeos.cc',
      'cert/nss_cert_database_chromeos.h',
      'cert/nss_profile_filter_chromeos.cc',
      'cert/nss_profile_filter_chromeos.h',
      'cert/sct_status_flags.h',
      'cert/test_root_certs.cc',
      'cert/test_root_certs.h',
      'cert/test_root_certs_android.cc',
      'cert/test_root_certs_mac.cc',
      'cert/test_root_certs_nss.cc',
      'cert/test_root_certs_openssl.cc',
      'cert/test_root_certs_win.cc',
      'cert/x509_cert_types_mac.cc',
      'cert/x509_cert_types_win.cc',
      'cert/x509_certificate_ios.cc',
      'cert/x509_certificate_mac.cc',
      'cert/x509_certificate_nss.cc',
      'cert/x509_certificate_win.cc',
      'cert/x509_util_android.cc',
      'cert/x509_util_android.h',
      'cert/x509_util_mac.cc',
      'cert/x509_util_mac.h',
      'cert/x509_util_nss.h',
      'cert/x509_util_nss.cc',
      'cert_net/cert_net_fetcher_impl.cc',
      'cert_net/cert_net_fetcher_impl.h',
      'cookies/canonical_cookie.cc',
      'cookies/canonical_cookie.h',
      'cookies/cookie_constants.cc',
      'cookies/cookie_constants.h',
      'cookies/cookie_monster.cc',
      'cookies/cookie_monster.h',
      'cookies/cookie_options.cc',
      'cookies/cookie_options.h',
      'cookies/cookie_store.cc',
      'cookies/cookie_store.h',
      'cookies/cookie_util.cc',
      'cookies/cookie_util.h',
      'cookies/parsed_cookie.cc',
      'cookies/parsed_cookie.h',
      'disk_cache/blockfile/addr.cc',
      'disk_cache/blockfile/addr.h',
      'disk_cache/blockfile/backend_impl.cc',
      'disk_cache/blockfile/backend_impl.h',
      'disk_cache/blockfile/bitmap.cc',
      'disk_cache/blockfile/bitmap.h',
      'disk_cache/blockfile/block_files.cc',
      'disk_cache/blockfile/block_files.h',
      'disk_cache/blockfile/disk_format.cc',
      'disk_cache/blockfile/disk_format.h',
      'disk_cache/blockfile/disk_format_base.h',
      'disk_cache/blockfile/entry_impl.cc',
      'disk_cache/blockfile/entry_impl.h',
      'disk_cache/blockfile/errors.h',
      'disk_cache/blockfile/eviction.cc',
      'disk_cache/blockfile/eviction.h',
      'disk_cache/blockfile/experiments.h',
      'disk_cache/blockfile/file.cc',
      'disk_cache/blockfile/file.h',
      'disk_cache/blockfile/file_block.h',
      'disk_cache/blockfile/file_ios.cc',
      'disk_cache/blockfile/file_lock.cc',
      'disk_cache/blockfile/file_lock.h',
      'disk_cache/blockfile/file_posix.cc',
      'disk_cache/blockfile/file_win.cc',
      'disk_cache/blockfile/histogram_macros.h',
      'disk_cache/blockfile/in_flight_backend_io.cc',
      'disk_cache/blockfile/in_flight_backend_io.h',
      'disk_cache/blockfile/in_flight_io.cc',
      'disk_cache/blockfile/in_flight_io.h',
      'disk_cache/blockfile/mapped_file.cc',
      'disk_cache/blockfile/mapped_file.h',
      'disk_cache/blockfile/mapped_file_avoid_mmap_posix.cc',
      'disk_cache/blockfile/mapped_file_posix.cc',
      'disk_cache/blockfile/mapped_file_win.cc',
      'disk_cache/blockfile/rankings.cc',
      'disk_cache/blockfile/rankings.h',
      'disk_cache/blockfile/sparse_control.cc',
      'disk_cache/blockfile/sparse_control.h',
      'disk_cache/blockfile/stats.cc',
      'disk_cache/blockfile/stats.h',
      'disk_cache/blockfile/storage_block-inl.h',
      'disk_cache/blockfile/storage_block.h',
      'disk_cache/blockfile/stress_support.h',
      'disk_cache/blockfile/trace.cc',
      'disk_cache/blockfile/trace.h',
      'disk_cache/blockfile/webfonts_histogram.cc',
      'disk_cache/blockfile/webfonts_histogram.h',
      'disk_cache/cache_creator.cc',
      'disk_cache/cache_util.cc',
      'disk_cache/cache_util.h',
      'disk_cache/cache_util_posix.cc',
      'disk_cache/cache_util_win.cc',
      'disk_cache/disk_cache.h',
      'disk_cache/memory/mem_backend_impl.cc',
      'disk_cache/memory/mem_backend_impl.h',
      'disk_cache/memory/mem_entry_impl.cc',
      'disk_cache/memory/mem_entry_impl.h',
      'disk_cache/net_log_parameters.cc',
      'disk_cache/net_log_parameters.h',
      'disk_cache/simple/simple_backend_impl.cc',
      'disk_cache/simple/simple_backend_impl.h',
      'disk_cache/simple/simple_backend_version.h',
      'disk_cache/simple/simple_entry_format.cc',
      'disk_cache/simple/simple_entry_format.h',
      'disk_cache/simple/simple_entry_format_history.h',
      'disk_cache/simple/simple_entry_impl.cc',
      'disk_cache/simple/simple_entry_impl.h',
      'disk_cache/simple/simple_entry_operation.cc',
      'disk_cache/simple/simple_entry_operation.h',
      'log/net_log_util.cc',
      'log/net_log_util.h',
      'log/trace_net_log_observer.cc',
      'log/trace_net_log_observer.h',
      'log/write_to_file_net_log_observer.cc',
      'log/write_to_file_net_log_observer.h',
      'log/bounded_file_net_log_observer.cc',
      'log/bounded_file_net_log_observer.h',
      'disk_cache/simple/simple_histogram_macros.h' ,
      'cert_net/nss_ocsp.cc',
      'cert_net/nss_ocsp.h',
      'disk_cache/simple/simple_index.cc',
      'disk_cache/simple/simple_index.h',
      'disk_cache/simple/simple_index_delegate.h',
      'disk_cache/simple/simple_index_file.cc',
      'disk_cache/simple/simple_index_file.h',
      'disk_cache/simple/simple_index_file_posix.cc',
      'disk_cache/simple/simple_index_file_win.cc',
      'disk_cache/simple/simple_net_log_parameters.cc',
      'disk_cache/simple/simple_net_log_parameters.h',
      'disk_cache/simple/simple_synchronous_entry.cc',
      'disk_cache/simple/simple_synchronous_entry.h',
      'disk_cache/simple/simple_util.cc',
      'disk_cache/simple/simple_util.h',
      'disk_cache/simple/simple_util_posix.cc',
      'disk_cache/simple/simple_util_win.cc',
      'disk_cache/simple/simple_version_upgrade.cc',
      'disk_cache/simple/simple_version_upgrade.h',
      'dns/address_sorter.h',
      'dns/address_sorter_posix.cc',
      'dns/address_sorter_posix.h',
      'dns/address_sorter_win.cc',
      'dns/dns_client.cc',
      'dns/dns_client.h',
      'dns/dns_config_service.cc',
      'dns/dns_config_service.h',
      'dns/dns_config_service_posix.cc',
      'dns/dns_config_service_posix.h',
      'dns/dns_config_service_win.cc',
      'dns/dns_config_service_win.h',
      'dns/dns_config_watcher_mac.cc',
      'dns/dns_config_watcher_mac.h',
      'dns/dns_hosts.cc',
      'dns/dns_hosts.h',
      'dns/dns_protocol.h',
      'dns/dns_query.cc',
      'dns/dns_query.h',
      'dns/dns_reloader.cc',
      'dns/dns_reloader.h',
      'dns/dns_response.cc',
      'dns/dns_response.h',
      'dns/dns_session.cc',
      'dns/dns_session.h',
      'dns/dns_socket_pool.cc',
      'dns/dns_socket_pool.h',
      'dns/dns_transaction.cc',
      'dns/dns_transaction.h',
      'dns/host_cache.cc',
      'dns/host_cache.h',
      'dns/host_resolver.cc',
      'dns/host_resolver.h',
      'dns/host_resolver_impl.cc',
      'dns/host_resolver_impl.h',
      'dns/host_resolver_proc.cc',
      'dns/host_resolver_proc.h',
      'dns/mapped_host_resolver.cc',
      'dns/mapped_host_resolver.h',
      'dns/mdns_cache.cc',
      'dns/mdns_cache.h',
      'dns/mdns_client.cc',
      'dns/mdns_client.h',
      'dns/mdns_client_impl.cc',
      'dns/mdns_client_impl.h',
      'dns/notify_watcher_mac.cc',
      'dns/notify_watcher_mac.h',
      'dns/record_parsed.cc',
      'dns/record_parsed.h',
      'dns/record_rdata.cc',
      'dns/record_rdata.h',
      'dns/serial_worker.cc',
      'dns/serial_worker.h',
      'filter/filter.cc',
      'filter/filter.h',
      'filter/gzip_filter.cc',
      'filter/gzip_filter.h',
      'filter/gzip_header.cc',
      'filter/gzip_header.h',
      'filter/sdch_filter.cc',
      'filter/sdch_filter.h',
      'http/bidirectional_stream.cc',
      'http/bidirectional_stream.h',
      'http/bidirectional_stream_impl.cc',
      'http/bidirectional_stream_impl.h',
      'http/bidirectional_stream_request_info.cc',
      'http/bidirectional_stream_request_info.h',
      'http/des.cc',
      'http/des.h',
      'http/disk_cache_based_quic_server_info.cc',
      'http/disk_cache_based_quic_server_info.h',
      'http/failing_http_transaction_factory.cc',
      'http/failing_http_transaction_factory.h',
      'http/http_auth.cc',
      'http/http_auth.h',
      'http/http_auth_cache.cc',
      'http/http_auth_cache.h',
      'http/http_auth_controller.cc',
      'http/http_auth_controller.h',
      'http/http_auth_filter.cc',
      'http/http_auth_filter.h',
      'http/http_auth_filter_win.h',
      'http/http_auth_gssapi_posix.cc',
      'http/http_auth_gssapi_posix.h',
      'http/http_auth_handler.cc',
      'http/http_auth_handler.h',
      'http/http_auth_handler_basic.cc',
      'http/http_auth_handler_basic.h',
      'http/http_auth_handler_digest.cc',
      'http/http_auth_handler_digest.h',
      'http/http_auth_handler_factory.cc',
      'http/http_auth_handler_factory.h',
      'http/http_auth_handler_negotiate.cc',
      'http/http_auth_handler_negotiate.h',
      'http/http_auth_handler_ntlm.cc',
      'http/http_auth_handler_ntlm.h',
      'http/http_auth_handler_ntlm_portable.cc',
      'http/http_auth_handler_ntlm_win.cc',
      'http/http_auth_multi_round_parse.cc',
      'http/http_auth_multi_round_parse.h',
      'http/http_auth_preferences.cc',
      'http/http_auth_preferences.h',
      'http/http_auth_sspi_win.cc',
      'http/http_auth_sspi_win.h',
      'http/http_basic_state.cc',
      'http/http_basic_state.h',
      'http/http_basic_stream.cc',
      'http/http_basic_stream.h',
      'http/http_cache.cc',
      'http/http_cache.h',
      'http/http_cache_transaction.cc',
      'http/http_cache_transaction.h',
      'http/http_chunked_decoder.cc',
      'http/http_chunked_decoder.h',
      'http/http_content_disposition.cc',
      'http/http_content_disposition.h',
      'http/http_network_layer.cc',
      'http/http_network_layer.h',
      'http/http_network_session.cc',
      'http/http_network_session.h',
      'http/http_network_session_peer.cc',
      'http/http_network_session_peer.h',
      'http/http_network_transaction.cc',
      'http/http_network_transaction.h',
      'http/http_proxy_client_socket.cc',
      'http/http_proxy_client_socket.h',
      'http/http_proxy_client_socket_pool.cc',
      'http/http_proxy_client_socket_pool.h',
      'http/http_proxy_client_socket_wrapper.cc',
      'http/http_proxy_client_socket_wrapper.h',
      'http/http_request_info.cc',
      'http/http_request_info.h',
      'http/http_response_body_drainer.cc',
      'http/http_response_body_drainer.h',
      'http/http_server_properties.cc',
      'http/http_server_properties.h',
      'http/http_server_properties_impl.cc',
      'http/http_server_properties_impl.h',
      'http/http_server_properties_manager.cc',
      'http/http_server_properties_manager.h',
      'http/http_status_code.cc',
      'http/http_status_code.h',
      'http/http_stream.h',
      'http/http_stream_factory.cc',
      'http/http_stream_factory.h',
      'http/http_stream_factory_impl.cc',
      'http/http_stream_factory_impl.h',
      'http/http_stream_factory_impl_job.cc',
      'http/http_stream_factory_impl_job.h',
      'http/http_stream_factory_impl_job_controller.cc',
      'http/http_stream_factory_impl_job_controller.h',
      'http/http_stream_factory_impl_request.cc',
      'http/http_stream_factory_impl_request.h',
      'http/http_stream_parser.cc',
      'http/http_stream_parser.h',
      'http/http_transaction.h',
      'http/http_transaction_factory.h',
      'http/http_version.h',
      'http/md4.cc',
      'http/md4.h',
      'http/partial_data.cc',
      'http/partial_data.h',
      'http/proxy_client_socket.cc',
      'http/proxy_client_socket.h',
      'http/proxy_connect_redirect_http_stream.cc',
      'http/proxy_connect_redirect_http_stream.h',
      'http/transport_security_persister.cc',
      'http/transport_security_persister.h',
      'http/transport_security_state_static.h',
      'http/url_security_manager.cc',
      'http/url_security_manager.h',
      'http/url_security_manager_posix.cc',
      'http/url_security_manager_win.cc',
      'nqe/cached_network_quality.cc',
      'nqe/cached_network_quality.h',
      'nqe/effective_connection_type.cc',
      'nqe/effective_connection_type.h',
      'nqe/external_estimate_provider.h',
      'nqe/network_id.h',
      'nqe/network_quality.cc',
      'nqe/network_quality.h',
      'nqe/network_quality_estimator.cc',
      'nqe/network_quality_estimator.h',
      'nqe/network_quality_observation.h',
      'nqe/network_quality_observation_source.h',
      'nqe/network_quality_store.cc',
      'nqe/network_quality_store.h',
      'nqe/observation_buffer.h',
      'nqe/socket_watcher.cc',
      'nqe/socket_watcher.h',
      'nqe/socket_watcher_factory.cc',
      'nqe/socket_watcher_factory.h',
      'nqe/throughput_analyzer.cc',
      'nqe/throughput_analyzer.h',
      'nqe/weighted_observation.h',
      'proxy/dhcp_proxy_script_adapter_fetcher_win.cc',
      'proxy/dhcp_proxy_script_adapter_fetcher_win.h',
      'proxy/dhcp_proxy_script_fetcher.cc',
      'proxy/dhcp_proxy_script_fetcher.h',
      'proxy/dhcp_proxy_script_fetcher_factory.cc',
      'proxy/dhcp_proxy_script_fetcher_factory.h',
      'proxy/dhcp_proxy_script_fetcher_win.cc',
      'proxy/dhcp_proxy_script_fetcher_win.h',
      'proxy/dhcpcsvc_init_win.cc',
      'proxy/dhcpcsvc_init_win.h',
      'proxy/multi_threaded_proxy_resolver.cc',
      'proxy/multi_threaded_proxy_resolver.h',
      'proxy/network_delegate_error_observer.cc',
      'proxy/network_delegate_error_observer.h',
      'proxy/polling_proxy_config_service.cc',
      'proxy/polling_proxy_config_service.h',
      'proxy/proxy_bypass_rules.cc',
      'proxy/proxy_bypass_rules.h',
      'proxy/proxy_config.cc',
      'proxy/proxy_config.h',
      'proxy/proxy_config_service.h',
      'proxy/proxy_config_service_android.cc',
      'proxy/proxy_config_service_android.h',
      'proxy/proxy_config_service_fixed.cc',
      'proxy/proxy_config_service_fixed.h',
      'proxy/proxy_config_service_ios.cc',
      'proxy/proxy_config_service_ios.h',
      'proxy/proxy_config_service_linux.cc',
      'proxy/proxy_config_service_linux.h',
      'proxy/proxy_config_service_mac.cc',
      'proxy/proxy_config_service_mac.h',
      'proxy/proxy_config_service_win.cc',
      'proxy/proxy_config_service_win.h',
      'proxy/proxy_config_source.cc',
      'proxy/proxy_config_source.h',
      'proxy/proxy_info.cc',
      'proxy/proxy_info.h',
      'proxy/proxy_list.cc',
      'proxy/proxy_list.h',
      'proxy/proxy_resolver.h',
      'proxy/proxy_resolver_error_observer.h',
      'proxy/proxy_resolver_factory.cc',
      'proxy/proxy_resolver_factory.h',
      'proxy/proxy_resolver_mac.cc',
      'proxy/proxy_resolver_mac.h',
      'proxy/proxy_resolver_script.h',
      'proxy/proxy_resolver_script_data.cc',
      'proxy/proxy_resolver_script_data.h',
      'proxy/proxy_resolver_winhttp.cc',
      'proxy/proxy_resolver_winhttp.h',
      'proxy/proxy_retry_info.h',
      'proxy/proxy_script_decider.cc',
      'proxy/proxy_script_decider.h',
      'proxy/proxy_script_fetcher.h',
      'proxy/proxy_script_fetcher_impl.cc',
      'proxy/proxy_script_fetcher_impl.h',
      'proxy/proxy_server.cc',
      'proxy/proxy_server.h',
      'proxy/proxy_server_mac.cc',
      'proxy/proxy_service.cc',
      'proxy/proxy_service.h',
      'quic/chromium/bidirectional_stream_quic_impl.cc',
      'quic/chromium/bidirectional_stream_quic_impl.h',
      'quic/chromium/crypto/channel_id_chromium.cc',
      'quic/chromium/crypto/channel_id_chromium.h',
      'quic/chromium/crypto/proof_source_chromium.cc',
      'quic/chromium/crypto/proof_source_chromium.h',
      'quic/chromium/crypto/proof_verifier_chromium.cc',
      'quic/chromium/crypto/proof_verifier_chromium.h',
      'quic/chromium/quic_stream_factory.cc',
      'quic/chromium/quic_stream_factory.h',
      'quic/chromium/quic_http_stream.cc',
      'quic/chromium/quic_http_stream.h',
      'quic/chromium/quic_chromium_alarm_factory.cc',
      'quic/chromium/quic_chromium_alarm_factory.h',
      'quic/chromium/quic_chromium_client_session.cc',
      'quic/chromium/quic_chromium_client_session.h',
      'quic/chromium/quic_chromium_client_stream.cc',
      'quic/chromium/quic_chromium_client_stream.h',
      'quic/chromium/quic_chromium_connection_helper.cc',
      'quic/chromium/quic_chromium_connection_helper.h',
      'quic/chromium/quic_chromium_packet_reader.cc',
      'quic/chromium/quic_chromium_packet_reader.h',
      'quic/chromium/quic_chromium_packet_writer.cc',
      'quic/chromium/quic_chromium_packet_writer.h',
      'quic/chromium/quic_connection_logger.cc',
      'quic/chromium/quic_connection_logger.h',
      'quic/chromium/quic_utils_chromium.h',
      'quic/chromium/network_connection.cc',
      'quic/chromium/network_connection.h',
      'quic/chromium/port_suggester.cc',
      'quic/chromium/port_suggester.h',
      'quic/core/congestion_control/cubic.cc',
      'quic/core/congestion_control/cubic.h',
      'quic/core/congestion_control/cubic_bytes.cc',
      'quic/core/congestion_control/cubic_bytes.h',
      'quic/core/congestion_control/general_loss_algorithm.cc',
      'quic/core/congestion_control/general_loss_algorithm.h',
      'quic/core/congestion_control/hybrid_slow_start.cc',
      'quic/core/congestion_control/hybrid_slow_start.h',
      'quic/core/congestion_control/loss_detection_interface.h',
      'quic/core/congestion_control/pacing_sender.cc',
      'quic/core/congestion_control/pacing_sender.h',
      'quic/core/congestion_control/prr_sender.cc',
      'quic/core/congestion_control/prr_sender.h',
      'quic/core/congestion_control/rtt_stats.cc',
      'quic/core/congestion_control/rtt_stats.h',
      'quic/core/congestion_control/send_algorithm_interface.cc',
      'quic/core/congestion_control/send_algorithm_interface.h',
      'quic/core/congestion_control/tcp_cubic_sender_base.cc',
      'quic/core/congestion_control/tcp_cubic_sender_base.h',
      'quic/core/congestion_control/tcp_cubic_sender_base.h',
      'quic/core/congestion_control/tcp_cubic_sender_bytes.cc',
      'quic/core/congestion_control/tcp_cubic_sender_packets.cc',
      'quic/core/congestion_control/tcp_cubic_sender_packets.h',
      'quic/core/congestion_control/windowed_filter.h',
      'quic/core/crypto/aead_base_decrypter.cc',
      'quic/core/crypto/aead_base_decrypter.h',
      'quic/core/crypto/aead_base_encrypter.cc',
      'quic/core/crypto/aead_base_encrypter.h',
      'quic/core/crypto/aes_128_gcm_12_decrypter.cc',
      'quic/core/crypto/aes_128_gcm_12_decrypter.h',
      'quic/core/crypto/aes_128_gcm_12_encrypter.cc',
      'quic/core/crypto/aes_128_gcm_12_encrypter.h',
      'quic/core/crypto/cert_compressor.cc',
      'quic/core/crypto/cert_compressor.h',
      'quic/core/crypto/chacha20_poly1305_decrypter.cc',
      'quic/core/crypto/chacha20_poly1305_decrypter.h',
      'quic/core/crypto/chacha20_poly1305_encrypter.cc',
      'quic/core/crypto/chacha20_poly1305_encrypter.h',
      'quic/core/crypto/channel_id.cc',
      'quic/core/crypto/channel_id.h',
      'quic/core/crypto/common_cert_set.cc',
      'quic/core/crypto/common_cert_set.h',
      'quic/core/crypto/crypto_framer.cc',
      'quic/core/crypto/crypto_framer.h',
      'quic/core/crypto/crypto_handshake.cc',
      'quic/core/crypto/crypto_handshake.h',
      'quic/core/crypto/crypto_handshake_message.cc',
      'quic/core/crypto/crypto_handshake_message.h',
      'quic/core/crypto/crypto_protocol.h',
      'quic/core/crypto/crypto_secret_boxer.cc',
      'quic/core/crypto/crypto_secret_boxer.h',
      'quic/core/crypto/crypto_server_config_protobuf.cc',
      'quic/core/crypto/crypto_server_config_protobuf.h',
      'quic/core/crypto/crypto_utils.cc',
      'quic/core/crypto/crypto_utils.h',
      'quic/core/crypto/curve25519_key_exchange.cc',
      'quic/core/crypto/curve25519_key_exchange.h',
      'quic/core/crypto/ephemeral_key_source.h',
      'quic/core/crypto/key_exchange.h',
      'quic/core/crypto/local_strike_register_client.cc',
      'quic/core/crypto/local_strike_register_client.h',
      'quic/core/crypto/null_decrypter.cc',
      'quic/core/crypto/null_decrypter.h',
      'quic/core/crypto/null_encrypter.cc',
      'quic/core/crypto/null_encrypter.h',
      'quic/core/crypto/p256_key_exchange.cc',
      'quic/core/crypto/p256_key_exchange.h',
      'quic/core/crypto/proof_source.cc',
      'quic/core/crypto/proof_source.h',
      'quic/core/crypto/proof_verifier.h',
      'quic/core/crypto/properties_based_quic_server_info.cc',
      'quic/core/crypto/properties_based_quic_server_info.h',
      'quic/core/crypto/quic_compressed_certs_cache.cc',
      'quic/core/crypto/quic_compressed_certs_cache.h',
      'quic/core/crypto/quic_crypto_client_config.cc',
      'quic/core/crypto/quic_crypto_client_config.h',
      'quic/core/crypto/quic_crypto_server_config.cc',
      'quic/core/crypto/quic_crypto_server_config.h',
      'quic/core/crypto/quic_decrypter.cc',
      'quic/core/crypto/quic_decrypter.h',
      'quic/core/crypto/quic_encrypter.cc',
      'quic/core/crypto/quic_encrypter.h',
      'quic/core/crypto/quic_random.cc',
      'quic/core/crypto/quic_random.h',
      'quic/core/crypto/quic_server_info.cc',
      'quic/core/crypto/quic_server_info.h',
      'quic/core/crypto/scoped_evp_aead_ctx.cc',
      'quic/core/crypto/scoped_evp_aead_ctx.h',
      'quic/core/crypto/strike_register.cc',
      'quic/core/crypto/strike_register.h',
      'quic/core/crypto/strike_register_client.h',
      'quic/core/interval.h',
      'quic/core/interval_set.h',
      'quic/core/iovector.cc',
      'quic/core/iovector.h',
      'quic/core/quic_address_mismatch.cc',
      'quic/core/quic_address_mismatch.h',
      'quic/core/quic_alarm.cc',
      'quic/core/quic_alarm.h',
      'quic/core/quic_arena_scoped_ptr.h',
      'quic/core/quic_bandwidth.cc',
      'quic/core/quic_bandwidth.h',
      'quic/core/quic_blocked_writer_interface.h',
      'quic/core/quic_buffered_packet_store.cc',
      'quic/core/quic_buffered_packet_store.h',
      'quic/core/quic_bug_tracker.h',
      'quic/core/quic_client_promised_info.cc',
      'quic/core/quic_client_promised_info.h',
      'quic/core/quic_client_push_promise_index.cc',
      'quic/core/quic_client_push_promise_index.h',
      'quic/core/quic_client_session_base.cc',
      'quic/core/quic_client_session_base.h',
      'quic/core/quic_clock.cc',
      'quic/core/quic_clock.h',
      'quic/core/quic_config.cc',
      'quic/core/quic_config.h',
      'quic/core/quic_connection.cc',
      'quic/core/quic_connection.h',
      'quic/core/quic_connection_stats.cc',
      'quic/core/quic_connection_stats.h',
      'quic/core/quic_crypto_client_stream.cc',
      'quic/core/quic_crypto_client_stream.h',
      'quic/core/quic_crypto_client_stream_factory.cc',
      'quic/core/quic_crypto_client_stream_factory.h',
      'quic/core/quic_crypto_server_stream.cc',
      'quic/core/quic_crypto_server_stream.h',
      'quic/core/quic_crypto_stream.cc',
      'quic/core/quic_crypto_stream.h',
      'quic/core/quic_data_reader.cc',
      'quic/core/quic_data_reader.h',
      'quic/core/quic_data_writer.cc',
      'quic/core/quic_data_writer.h',
      'quic/core/quic_flags.cc',
      'quic/core/quic_flags.h',
      'quic/core/quic_flow_controller.cc',
      'quic/core/quic_flow_controller.h',
      'quic/core/quic_frame_list.cc',
      'quic/core/quic_frame_list.h',
      'quic/core/quic_framer.cc',
      'quic/core/quic_framer.h',
      'quic/core/quic_header_list.cc',
      'quic/core/quic_header_list.h',
      'quic/core/quic_headers_stream.cc',
      'quic/core/quic_headers_stream.h',
      'quic/core/quic_http_utils.cc',
      'quic/core/quic_http_utils.h',
      'quic/core/quic_multipath_received_packet_manager.cc',
      'quic/core/quic_multipath_received_packet_manager.h',
      'quic/core/quic_multipath_sent_packet_manager.cc',
      'quic/core/quic_multipath_sent_packet_manager.h',
      'quic/core/quic_multipath_transmissions_map.cc',
      'quic/core/quic_multipath_transmissions_map.h',
      'quic/core/quic_one_block_arena.h',
      'quic/core/quic_packet_creator.cc',
      'quic/core/quic_packet_creator.h',
      'quic/core/quic_packet_generator.cc',
      'quic/core/quic_packet_generator.h',
      'quic/core/quic_packet_writer.h',
      'quic/core/quic_protocol.cc',
      'quic/core/quic_protocol.h',
      'quic/core/quic_received_packet_manager.cc',
      'quic/core/quic_received_packet_manager.h',
      'quic/core/quic_sent_entropy_manager.cc',
      'quic/core/quic_sent_entropy_manager.h',
      'quic/core/quic_sent_packet_manager.cc',
      'quic/core/quic_sent_packet_manager.h',
      'quic/core/quic_sent_packet_manager_interface.h',
      'quic/core/quic_server_id.cc',
      'quic/core/quic_server_id.h',
      'quic/core/quic_session.cc',
      'quic/core/quic_session.h',
      'quic/core/quic_simple_buffer_allocator.cc',
      'quic/core/quic_simple_buffer_allocator.h',
      'quic/core/quic_socket_address_coder.cc',
      'quic/core/quic_socket_address_coder.h',
      'quic/core/quic_spdy_session.cc',
      'quic/core/quic_spdy_session.h',
      'quic/core/quic_spdy_stream.cc',
      'quic/core/quic_spdy_stream.h',
      'quic/core/quic_stream_sequencer.cc',
      'quic/core/quic_stream_sequencer.h',
      'quic/core/quic_stream_sequencer_buffer.cc',
      'quic/core/quic_stream_sequencer_buffer.h',
      'quic/core/quic_stream_sequencer_buffer_interface.h',
      'quic/core/quic_sustained_bandwidth_recorder.cc',
      'quic/core/quic_sustained_bandwidth_recorder.h',
      'quic/core/quic_time.cc',
      'quic/core/quic_time.h',
      'quic/core/quic_types.cc',
      'quic/core/quic_types.h',
      'quic/core/quic_unacked_packet_map.cc',
      'quic/core/quic_unacked_packet_map.h',
      'quic/core/quic_utils.cc',
      'quic/core/quic_utils.h',
      'quic/core/quic_write_blocked_list.cc',
      'quic/core/quic_write_blocked_list.h',
      'quic/core/reliable_quic_stream.cc',
      'quic/core/reliable_quic_stream.h',
      'quic/core/quic_server_session_base.cc',
      'quic/core/quic_server_session_base.h',
      'quic/core/spdy_utils.cc',
      'quic/core/spdy_utils.h',
      'sdch/sdch_owner.cc',
      'sdch/sdch_owner.h',
      'socket/client_socket_factory.cc',
      'socket/client_socket_factory.h',
      'socket/client_socket_pool.cc',
      'socket/client_socket_pool.h',
      'socket/client_socket_pool_base.cc',
      'socket/client_socket_pool_base.h',
      'socket/client_socket_pool_manager.cc',
      'socket/client_socket_pool_manager.h',
      'socket/client_socket_pool_manager_impl.cc',
      'socket/client_socket_pool_manager_impl.h',
      'socket/server_socket.cc',
      'socket/server_socket.h',
      'socket/socket_descriptor.cc',
      'socket/socket_descriptor.h',
      'socket/socket_net_log_params.cc',
      'socket/socket_net_log_params.h',
      'socket/socket_posix.cc',
      'socket/socket_posix.h',
      'socket/socks5_client_socket.cc',
      'socket/socks5_client_socket.h',
      'socket/socks_client_socket.cc',
      'socket/socks_client_socket.h',
      'socket/socks_client_socket_pool.cc',
      'socket/socks_client_socket_pool.h',
      'socket/ssl_client_socket_pool.cc',
      'socket/ssl_client_socket_pool.h',
      'socket/ssl_server_socket.h',
      'socket/ssl_server_socket_impl.cc',
      'socket/ssl_server_socket_impl.h',
      'socket/stream_socket.cc',
      'socket/stream_socket.h',
      'socket/tcp_client_socket.cc',
      'socket/tcp_client_socket.h',
      'socket/tcp_server_socket.cc',
      'socket/tcp_server_socket.h',
      'socket/tcp_socket.cc',
      'socket/tcp_socket.h',
      'socket/tcp_socket_posix.cc',
      'socket/tcp_socket_posix.h',
      'socket/tcp_socket_win.cc',
      'socket/tcp_socket_win.h',
      'socket/transport_client_socket_pool.cc',
      'socket/transport_client_socket_pool.h',
      'socket/unix_domain_client_socket_posix.cc',
      'socket/unix_domain_client_socket_posix.h',
      'socket/unix_domain_server_socket_posix.cc',
      'socket/unix_domain_server_socket_posix.h',
      'socket/websocket_endpoint_lock_manager.cc',
      'socket/websocket_endpoint_lock_manager.h',
      'socket/websocket_transport_client_socket_pool.cc',
      'socket/websocket_transport_client_socket_pool.h',
      'socket/websocket_transport_connect_sub_job.cc',
      'socket/websocket_transport_connect_sub_job.h',
      'spdy/bidirectional_stream_spdy_impl.cc',
      'spdy/bidirectional_stream_spdy_impl.h',
      'spdy/buffered_spdy_framer.cc',
      'spdy/buffered_spdy_framer.h',
      'spdy/fuzzing/hpack_fuzz_util.cc',
      'spdy/fuzzing/hpack_fuzz_util.h',
      'spdy/header_coalescer.cc',
      'spdy/header_coalescer.h',
      'spdy/hpack/hpack_constants.cc',
      'spdy/hpack/hpack_constants.h',
      'spdy/hpack/hpack_decoder.cc',
      'spdy/hpack/hpack_decoder.h',
      'spdy/hpack/hpack_decoder_interface.h',
      'spdy/hpack/hpack_encoder.cc',
      'spdy/hpack/hpack_encoder.h',
      'spdy/hpack/hpack_entry.cc',
      'spdy/hpack/hpack_entry.h',
      'spdy/hpack/hpack_header_table.cc',
      'spdy/hpack/hpack_header_table.h',
      'spdy/hpack/hpack_huffman_decoder.cc',
      'spdy/hpack/hpack_huffman_decoder.h',
      'spdy/hpack/hpack_huffman_table.cc',
      'spdy/hpack/hpack_huffman_table.h',
      'spdy/hpack/hpack_input_stream.cc',
      'spdy/hpack/hpack_input_stream.h',
      'spdy/hpack/hpack_output_stream.cc',
      'spdy/hpack/hpack_output_stream.h',
      'spdy/hpack/hpack_static_table.cc',
      'spdy/hpack/hpack_static_table.h',
      'spdy/http2_write_scheduler.h',
      'spdy/http2_priority_dependencies.h',
      'spdy/http2_priority_dependencies.cc',
      'spdy/priority_write_scheduler.h',
      'spdy/spdy_alt_svc_wire_format.cc',
      'spdy/spdy_alt_svc_wire_format.h',
      'spdy/spdy_bitmasks.h',
      'spdy/spdy_buffer.cc',
      'spdy/spdy_buffer.h',
      'spdy/spdy_buffer_producer.cc',
      'spdy/spdy_buffer_producer.h',
      'spdy/spdy_bug_tracker.h',
      'spdy/spdy_flags.cc',
      'spdy/spdy_flags.h',
      'spdy/spdy_frame_builder.cc',
      'spdy/spdy_frame_builder.h',
      'spdy/spdy_frame_reader.cc',
      'spdy/spdy_frame_reader.h',
      'spdy/spdy_framer.cc',
      'spdy/spdy_framer.h',
      'spdy/spdy_framer_decoder_adapter.cc',
      'spdy/spdy_framer_decoder_adapter.h',
      'spdy/spdy_header_block.cc',
      'spdy/spdy_header_block.h',
      'spdy/spdy_headers_block_parser.cc',
      'spdy/spdy_headers_block_parser.h',
      'spdy/spdy_headers_handler_interface.h',
      'spdy/spdy_http_stream.cc',
      'spdy/spdy_http_stream.h',
      'spdy/spdy_http_utils.cc',
      'spdy/spdy_http_utils.h',
      'spdy/spdy_pinnable_buffer_piece.cc',
      'spdy/spdy_pinnable_buffer_piece.h',
      'spdy/spdy_prefixed_buffer_reader.cc',
      'spdy/spdy_prefixed_buffer_reader.h',
      'spdy/spdy_protocol.cc',
      'spdy/spdy_protocol.h',
      'spdy/spdy_proxy_client_socket.cc',
      'spdy/spdy_proxy_client_socket.h',
      'spdy/spdy_read_queue.cc',
      'spdy/spdy_read_queue.h',
      'spdy/spdy_session.cc',
      'spdy/spdy_session.h',
      'spdy/spdy_session_key.cc',
      'spdy/spdy_session_key.h',
      'spdy/spdy_session_pool.cc',
      'spdy/spdy_session_pool.h',
      'spdy/spdy_stream.cc',
      'spdy/spdy_stream.h',
      'spdy/spdy_write_queue.cc',
      'spdy/spdy_write_queue.h',
      'spdy/write_blocked_list.h',
      'spdy/write_scheduler.h',
      'ssl/client_cert_store.h',
      'ssl/client_cert_store_mac.cc',
      'ssl/client_cert_store_mac.h',
      'ssl/client_cert_store_nss.cc',
      'ssl/client_cert_store_nss.h',
      'ssl/client_cert_store_win.cc',
      'ssl/client_cert_store_win.h',
      'ssl/ssl_config_service_defaults.cc',
      'ssl/ssl_config_service_defaults.h',
      'ssl/ssl_key_logger.cc',
      'ssl/ssl_key_logger.h',
      'ssl/ssl_platform_key.h',
      'ssl/ssl_platform_key_android.cc',
      'ssl/ssl_platform_key_mac.cc',
      'ssl/ssl_platform_key_nss.cc',
      'ssl/ssl_platform_key_task_runner.cc',
      'ssl/ssl_platform_key_task_runner.h',
      'ssl/ssl_platform_key_win.cc',
      'ssl/test_ssl_private_key.cc',
      'ssl/test_ssl_private_key.h',
      'ssl/threaded_ssl_private_key.cc',
      'ssl/threaded_ssl_private_key.h',
      'third_party/mozilla_security_manager/nsKeygenHandler.cpp',
      'third_party/mozilla_security_manager/nsKeygenHandler.h',
      'third_party/mozilla_security_manager/nsNSSCertificateDB.cpp',
      'third_party/mozilla_security_manager/nsNSSCertificateDB.h',
      'third_party/mozilla_security_manager/nsPKCS12Blob.cpp',
      'third_party/mozilla_security_manager/nsPKCS12Blob.h',
      'udp/datagram_client_socket.h',
      'udp/datagram_server_socket.h',
      'udp/datagram_socket.h',
      'udp/diff_serv_code_point.h',
      'udp/udp_client_socket.cc',
      'udp/udp_client_socket.h',
      'udp/udp_net_log_parameters.cc',
      'udp/udp_net_log_parameters.h',
      'udp/udp_server_socket.cc',
      'udp/udp_server_socket.h',
      'udp/udp_socket.h',
      'udp/udp_socket_posix.cc',
      'udp/udp_socket_posix.h',
      'udp/udp_socket_win.cc',
      'udp/udp_socket_win.h',
      'url_request/data_protocol_handler.cc',
      'url_request/data_protocol_handler.h',
      'url_request/http_user_agent_settings.h',
      'url_request/redirect_info.cc',
      'url_request/redirect_info.h',
      'url_request/report_sender.cc',
      'url_request/report_sender.h',
      'url_request/sdch_dictionary_fetcher.cc',
      'url_request/sdch_dictionary_fetcher.h',
      'url_request/static_http_user_agent_settings.cc',
      'url_request/static_http_user_agent_settings.h',
      'url_request/url_fetcher.cc',
      'url_request/url_fetcher.h',
      'url_request/url_fetcher_core.cc',
      'url_request/url_fetcher_core.h',
      'url_request/url_fetcher_delegate.cc',
      'url_request/url_fetcher_delegate.h',
      'url_request/url_fetcher_factory.h',
      'url_request/url_fetcher_impl.cc',
      'url_request/url_fetcher_impl.h',
      'url_request/url_fetcher_response_writer.cc',
      'url_request/url_fetcher_response_writer.h',
      'url_request/url_range_request_job.cc',
      'url_request/url_range_request_job.h',
      'url_request/url_request.cc',
      'url_request/url_request.h',
      'url_request/url_request_context.cc',
      'url_request/url_request_context.h',
      'url_request/url_request_context_builder.cc',
      'url_request/url_request_context_builder.h',
      'url_request/url_request_context_getter.cc',
      'url_request/url_request_context_getter.h',
      'url_request/url_request_context_getter_observer.h',
      'url_request/url_request_context_storage.cc',
      'url_request/url_request_context_storage.h',
      'url_request/url_request_data_job.cc',
      'url_request/url_request_data_job.h',
      'url_request/url_request_error_job.cc',
      'url_request/url_request_error_job.h',
      'url_request/url_request_filter.cc',
      'url_request/url_request_filter.h',
      'url_request/url_request_http_job.cc',
      'url_request/url_request_http_job.h',
      'url_request/url_request_intercepting_job_factory.cc',
      'url_request/url_request_intercepting_job_factory.h',
      'url_request/url_request_interceptor.cc',
      'url_request/url_request_interceptor.h',
      'url_request/url_request_job.cc',
      'url_request/url_request_job.h',
      'url_request/url_request_job_factory.cc',
      'url_request/url_request_job_factory.h',
      'url_request/url_request_job_factory_impl.cc',
      'url_request/url_request_job_factory_impl.h',
      'url_request/url_request_job_manager.cc',
      'url_request/url_request_job_manager.h',
      'url_request/url_request_netlog_params.cc',
      'url_request/url_request_netlog_params.h',
      'url_request/url_request_redirect_job.cc',
      'url_request/url_request_redirect_job.h',
      'url_request/url_request_simple_job.cc',
      'url_request/url_request_simple_job.h',
      'url_request/url_request_status.cc',
      'url_request/url_request_status.h',
      'url_request/url_request_test_job.cc',
      'url_request/url_request_test_job.h',
      'url_request/url_request_throttler_entry.cc',
      'url_request/url_request_throttler_entry.h',
      'url_request/url_request_throttler_entry_interface.h',
      'url_request/url_request_throttler_manager.cc',
      'url_request/url_request_throttler_manager.h',
      'url_request/view_cache_helper.cc',
      'url_request/view_cache_helper.h',
      'url_request/websocket_handshake_userdata_key.cc',
      'url_request/websocket_handshake_userdata_key.h',

      # WebSockets headers are included net/http files. Since net/http can be
      # built without linking net/websockets code, the uses of the websockets
      # headers from url_request are carefully written not to introduce link-
      # time dependencies.
      #
      # To make "gn check" validate the header usage properly, these are the
      # websocket headers needed by the shared net code, which are duplicated
      # unconditionally here from the conditional websockets list below.
      'websockets/websocket_handshake_stream_base.h',
      'websockets/websocket_stream.h',
      'websockets/websocket_handshake_request_info.h',
      'websockets/websocket_handshake_response_info.h',
    ],
    'net_extras_sources': [
      'extras/sqlite/cookie_crypto_delegate.h',
      'extras/sqlite/sqlite_channel_id_store.cc',
      'extras/sqlite/sqlite_channel_id_store.h',
      'extras/sqlite/sqlite_persistent_cookie_store.cc',
      'extras/sqlite/sqlite_persistent_cookie_store.h',
    ],
    'net_test_sources': [
      'android/cellular_signal_strength_unittest.cc',
      'android/dummy_spnego_authenticator.cc',
      'android/dummy_spnego_authenticator.h',
      'android/http_auth_negotiate_android_unittest.cc',
      'android/keystore_unittest.cc',
      'android/network_change_notifier_android_unittest.cc',
      'android/traffic_stats_unittest.cc',
      'base/address_family_unittest.cc',
      'base/address_list_unittest.cc',
      'base/address_tracker_linux_unittest.cc',
      'base/arena_unittest.cc',
      'base/backoff_entry_serializer_unittest.cc',
      'base/backoff_entry_unittest.cc',
      'base/chunked_upload_data_stream_unittest.cc',
      'base/data_url_unittest.cc',
      'base/directory_lister_unittest.cc',
      'base/directory_listing_unittest.cc',
      'base/elements_upload_data_stream_unittest.cc',
      'base/escape_unittest.cc',
      'base/expiring_cache_unittest.cc',
      'base/file_stream_unittest.cc',
      'base/filename_util_unittest.cc',
      'base/host_mapping_rules_unittest.cc',
      'base/host_port_pair_unittest.cc',
      'base/int128_unittest.cc',
      'base/ip_address_unittest.cc',
      'base/ip_endpoint_unittest.cc',
      'base/ip_pattern_unittest.cc',
      'base/keygen_handler_unittest.cc',
      'base/layered_network_delegate_unittest.cc',
      'base/lookup_string_in_fixed_set_unittest.cc',
      'base/mime_sniffer_unittest.cc',
      'base/mime_util_unittest.cc',
      'base/network_activity_monitor_unittest.cc',
      'base/network_change_notifier_unittest.cc',
      'base/network_change_notifier_win_unittest.cc',
      'base/network_interfaces_unittest.cc',
      'base/parse_number_unittest.cc',
      'base/port_util_unittest.cc',
      'base/prioritized_dispatcher_unittest.cc',
      'base/priority_queue_unittest.cc',
      'base/registry_controlled_domains/registry_controlled_domain_unittest.cc',
      'base/sdch_dictionary_unittest.cc',
      'base/sdch_manager_unittest.cc',
      'base/stale_while_revalidate_experiment_domains_unittest.cc',
      'base/static_cookie_policy_unittest.cc',
      'base/test_completion_callback_unittest.cc',
      'base/test_proxy_delegate.cc',
      'base/test_proxy_delegate.h',
      'base/upload_bytes_element_reader_unittest.cc',
      'base/upload_file_element_reader_unittest.cc',
      'base/url_util_unittest.cc',
      'cert/caching_cert_verifier_unittest.cc',
      'cert/ct_known_logs_unittest.cc',
      'cert/ct_policy_enforcer_unittest.cc',
      'cert/cert_verifier_unittest.cc',
      'cert/cert_verify_proc_unittest.cc',
      'cert/cert_verify_proc_whitelist_unittest.cc',
      'cert/crl_set_unittest.cc',
      'cert/ct_log_response_parser_unittest.cc',
      'cert/ct_log_verifier_unittest.cc',
      'cert/ct_objects_extractor_unittest.cc',
      'cert/ct_serialization_unittest.cc',
      'cert/ev_root_ca_metadata_unittest.cc',
      'cert/internal/cert_issuer_source_aia_unittest.cc',
      'cert/internal/cert_issuer_source_static_unittest.cc',
      'cert/internal/certificate_policies_unittest.cc',
      'cert/internal/extended_key_usage_unittest.cc',
      'cert/internal/name_constraints_unittest.cc',
      'cert/internal/nist_pkits_unittest.h',
      'cert/internal/parse_certificate_unittest.cc',
      'cert/internal/parse_name_unittest.cc',
      'cert/internal/parse_ocsp_unittest.cc',
      'cert/internal/path_builder_pkits_unittest.cc',
      'cert/internal/path_builder_unittest.cc',
      'cert/internal/path_builder_verify_certificate_chain_unittest.cc',
      'cert/internal/signature_algorithm_unittest.cc',
      'cert/internal/test_helpers.cc',
      'cert/internal/test_helpers.h',
      'cert/internal/verify_certificate_chain_pkits_unittest.cc',
      'cert/internal/verify_certificate_chain_typed_unittest.h',
      'cert/internal/verify_certificate_chain_unittest.cc',
      'cert/internal/verify_name_match_unittest.cc',
      'cert/internal/verify_signed_data_unittest.cc',
      'cert/jwk_serializer_unittest.cc',
      'cert/merkle_audit_proof_unittest.cc',
      'cert/merkle_tree_leaf_unittest.cc',
      'cert/multi_log_ct_verifier_unittest.cc',
      'cert/multi_threaded_cert_verifier_unittest.cc',
      'cert/nss_cert_database_chromeos_unittest.cc',
      'cert/nss_cert_database_unittest.cc',
      'cert/nss_profile_filter_chromeos_unittest.cc',
      'cert/pem_tokenizer_unittest.cc',
      'cert/cert_verify_proc_ios_unittest.cc',
      'cert/signed_certificate_timestamp_unittest.cc',
      'cert/sth_distributor_unittest.cc',
      'cert/test_root_certs_unittest.cc',
      'cert/x509_cert_types_unittest.cc',
      'cert/x509_certificate_unittest.cc',
      'cert/x509_util_unittest.cc',
      'cert_net/cert_net_fetcher_impl_unittest.cc',
      'cert_net/nss_ocsp_unittest.cc',
      'cookies/canonical_cookie_unittest.cc',
      'cookies/cookie_constants_unittest.cc',
      'cookies/cookie_monster_unittest.cc',
      'cookies/cookie_store_unittest.cc',
      'cookies/cookie_util_unittest.cc',
      'cookies/parsed_cookie_unittest.cc',
      'der/input_unittest.cc',
      'der/encode_values_unittest.cc',
      'der/parse_values_unittest.cc',
      'der/parser_unittest.cc',
      'disk_cache/backend_unittest.cc',
      'disk_cache/blockfile/addr_unittest.cc',
      'disk_cache/blockfile/bitmap_unittest.cc',
      'disk_cache/blockfile/block_files_unittest.cc',
      'disk_cache/blockfile/mapped_file_unittest.cc',
      'disk_cache/blockfile/stats_unittest.cc',
      'disk_cache/blockfile/storage_block_unittest.cc',
      'disk_cache/cache_util_unittest.cc',
      'disk_cache/entry_unittest.cc',
      'disk_cache/simple/simple_index_file_unittest.cc',
      'disk_cache/simple/simple_index_unittest.cc',
      'disk_cache/simple/simple_test_util.cc',
      'disk_cache/simple/simple_test_util.h',
      'disk_cache/simple/simple_util_unittest.cc',
      'disk_cache/simple/simple_version_upgrade_unittest.cc',
      'dns/address_sorter_posix_unittest.cc',
      'dns/address_sorter_unittest.cc',
      'dns/dns_config_service_posix_unittest.cc',
      'dns/dns_config_service_unittest.cc',
      'dns/dns_config_service_win_unittest.cc',
      'dns/dns_hosts_unittest.cc',
      'dns/dns_query_unittest.cc',
      'dns/dns_response_unittest.cc',
      'dns/dns_session_unittest.cc',
      'dns/dns_transaction_unittest.cc',
      'dns/dns_util_unittest.cc',
      'dns/host_cache_unittest.cc',
      'dns/host_resolver_impl_unittest.cc',
      'dns/host_resolver_mojo_unittest.cc',
      'dns/mapped_host_resolver_unittest.cc',
      'dns/mdns_cache_unittest.cc',
      'dns/mdns_client_unittest.cc',
      'dns/mojo_host_resolver_impl_unittest.cc',
      'dns/record_parsed_unittest.cc',
      'dns/record_rdata_unittest.cc',
      'dns/serial_worker_unittest.cc',
      'extras/sqlite/sqlite_channel_id_store_unittest.cc',
      'extras/sqlite/sqlite_persistent_cookie_store_unittest.cc',
      'filter/brotli_filter_unittest.cc',
      'filter/filter_unittest.cc',
      'filter/gzip_filter_unittest.cc',
      'filter/mock_filter_context.cc',
      'filter/mock_filter_context.h',
      'filter/sdch_filter_unittest.cc',
      'ftp/ftp_auth_cache_unittest.cc',
      'ftp/ftp_ctrl_response_buffer_unittest.cc',
      'ftp/ftp_directory_listing_parser_ls_unittest.cc',
      'ftp/ftp_directory_listing_parser_unittest.cc',
      'ftp/ftp_directory_listing_parser_unittest.h',
      'ftp/ftp_directory_listing_parser_vms_unittest.cc',
      'ftp/ftp_directory_listing_parser_windows_unittest.cc',
      'ftp/ftp_network_transaction_unittest.cc',
      'ftp/ftp_util_unittest.cc',
      'http/bidirectional_stream_unittest.cc',
      'http/des_unittest.cc',
      'http/disk_cache_based_quic_server_info_unittest.cc',
      'http/http_auth_cache_unittest.cc',
      'http/http_auth_challenge_tokenizer_unittest.cc',
      'http/http_auth_controller_unittest.cc',
      'http/http_auth_filter_unittest.cc',
      'http/http_auth_gssapi_posix_unittest.cc',
      'http/http_auth_handler_basic_unittest.cc',
      'http/http_auth_handler_digest_unittest.cc',
      'http/http_auth_handler_factory_unittest.cc',
      'http/http_auth_handler_mock.cc',
      'http/http_auth_handler_mock.h',
      'http/http_auth_handler_negotiate_unittest.cc',
      'http/http_auth_handler_unittest.cc',
      'http/http_auth_multi_round_parse_unittest.cc',
      'http/http_auth_preferences_unittest.cc',
      'http/http_auth_sspi_win_unittest.cc',
      'http/http_auth_unittest.cc',
      'http/http_basic_state_unittest.cc',
      'http/http_byte_range_unittest.cc',
      'http/http_cache_unittest.cc',
      'http/http_chunked_decoder_unittest.cc',
      'http/http_content_disposition_unittest.cc',
      'http/http_log_util_unittest.cc',
      'http/http_network_layer_unittest.cc',
      'http/http_network_transaction_ssl_unittest.cc',
      'http/http_network_transaction_unittest.cc',
      'http/http_proxy_client_socket_pool_unittest.cc',
      'http/http_request_headers_unittest.cc',
      'http/http_response_body_drainer_unittest.cc',
      'http/http_response_headers_unittest.cc',
      'http/http_response_info_unittest.cc',
      'http/http_security_headers_unittest.cc',
      'http/http_server_properties_impl_unittest.cc',
      'http/http_server_properties_manager_unittest.cc',
      'http/http_status_code_unittest.cc',
      'http/http_status_line_validator_unittest.cc',
      'http/http_stream_factory_impl_job_controller_unittest.cc',
      'http/http_stream_factory_impl_request_unittest.cc',
      'http/http_stream_factory_impl_unittest.cc',
      'http/http_stream_parser_unittest.cc',
      'http/http_util_unittest.cc',
      'http/http_vary_data_unittest.cc',
      'http/mock_allow_http_auth_preferences.cc',
      'http/mock_allow_http_auth_preferences.h',
      'http/mock_gssapi_library_posix.cc',
      'http/mock_gssapi_library_posix.h',
      'http/mock_http_cache.cc',
      'http/mock_http_cache.h',
      'http/mock_sspi_library_win.cc',
      'http/mock_sspi_library_win.h',
      'http/transport_security_persister_unittest.cc',
      'http/transport_security_state_unittest.cc',
      'http/url_security_manager_unittest.cc',
      'log/net_log_capture_mode_unittest.cc',
      'log/net_log_unittest.cc',
      'log/net_log_util_unittest.cc',
      'log/trace_net_log_observer_unittest.cc',
      'log/write_to_file_net_log_observer_unittest.cc',
      'log/bounded_file_net_log_observer_unittest.cc',
      'nqe/effective_connection_type_unittest.cc',
      'nqe/network_quality_estimator_unittest.cc',
      'nqe/network_quality_observation_unittest.cc',
      'nqe/network_quality_store_unittest.cc',
      'nqe/throughput_analyzer_unittest.cc',
      'proxy/dhcp_proxy_script_adapter_fetcher_win_unittest.cc',
      'proxy/dhcp_proxy_script_fetcher_factory_unittest.cc',
      'proxy/dhcp_proxy_script_fetcher_win_unittest.cc',
      'proxy/mojo_proxy_resolver_factory_impl_unittest.cc',
      'proxy/mojo_proxy_resolver_impl_unittest.cc',
      'proxy/mojo_proxy_resolver_v8_tracing_bindings_unittest.cc',
      'proxy/multi_threaded_proxy_resolver_unittest.cc',
      'proxy/network_delegate_error_observer_unittest.cc',
      'proxy/proxy_bypass_rules_unittest.cc',
      'proxy/proxy_config_service_android_unittest.cc',
      'proxy/proxy_config_service_linux_unittest.cc',
      'proxy/proxy_config_service_win_unittest.cc',
      'proxy/proxy_config_unittest.cc',
      'proxy/proxy_info_unittest.cc',
      'proxy/proxy_list_unittest.cc',
      'proxy/proxy_resolver_factory_mojo_unittest.cc',
      'proxy/proxy_resolver_v8_tracing_unittest.cc',
      'proxy/proxy_resolver_v8_tracing_wrapper_unittest.cc',
      'proxy/proxy_resolver_v8_unittest.cc',
      'proxy/proxy_script_decider_unittest.cc',
      'proxy/proxy_script_fetcher_impl_unittest.cc',
      'proxy/proxy_server_unittest.cc',
      'proxy/proxy_service_mojo_unittest.cc',
      'proxy/proxy_service_unittest.cc',
      'quic/chromium/bidirectional_stream_quic_impl_unittest.cc',
      'quic/chromium/crypto/proof_verifier_chromium_test.cc',
      'quic/chromium/crypto_test_utils_chromium.cc',
      'quic/chromium/crypto/proof_test_chromium.cc',
      'quic/chromium/network_connection_unittest.cc',
      'quic/chromium/port_suggester_unittest.cc',
      'quic/chromium/quic_chromium_alarm_factory_test.cc',
      'quic/chromium/quic_chromium_client_session_test.cc',
      'quic/chromium/quic_chromium_client_stream_test.cc',
      'quic/chromium/quic_chromium_connection_helper_test.cc',
      'quic/chromium/quic_http_stream_test.cc',
      'quic/chromium/quic_network_transaction_unittest.cc',
      'quic/chromium/quic_stream_factory_test.cc',
      'quic/chromium/quic_utils_chromium_test.cc',
      'quic/chromium/quic_chromium_client_session_peer.cc',
      'quic/chromium/quic_chromium_client_session_peer.h',
      'quic/core/congestion_control/cubic_bytes_test.cc',
      'quic/core/congestion_control/cubic_test.cc',
      'quic/core/congestion_control/general_loss_algorithm_test.cc',
      'quic/core/congestion_control/hybrid_slow_start_test.cc',
      'quic/core/congestion_control/pacing_sender_test.cc',
      'quic/core/congestion_control/prr_sender_test.cc',
      'quic/core/congestion_control/rtt_stats_test.cc',
      'quic/core/congestion_control/send_algorithm_simulator.cc',
      'quic/core/congestion_control/send_algorithm_simulator.h',
      'quic/core/congestion_control/tcp_cubic_sender_bytes_test.cc',
      'quic/core/congestion_control/tcp_cubic_sender_packets_test.cc',
      'quic/core/congestion_control/windowed_filter_test.cc',
      'quic/core/crypto/aes_128_gcm_12_decrypter_test.cc',
      'quic/core/crypto/aes_128_gcm_12_encrypter_test.cc',
      'quic/core/crypto/cert_compressor_test.cc',
      'quic/core/crypto/chacha20_poly1305_decrypter_test.cc',
      'quic/core/crypto/chacha20_poly1305_encrypter_test.cc',
      'quic/core/crypto/channel_id_test.cc',
      'quic/core/crypto/common_cert_set_test.cc',
      'quic/core/crypto/crypto_framer_test.cc',
      'quic/core/crypto/crypto_handshake_message_test.cc',
      'quic/core/crypto/crypto_secret_boxer_test.cc',
      'quic/core/crypto/crypto_server_test.cc',
      'quic/core/crypto/crypto_utils_test.cc',
      'quic/core/crypto/curve25519_key_exchange_test.cc',
      'quic/core/crypto/local_strike_register_client_test.cc',
      'quic/core/crypto/null_decrypter_test.cc',
      'quic/core/crypto/null_encrypter_test.cc',
      'quic/core/crypto/p256_key_exchange_test.cc',
      'quic/core/crypto/properties_based_quic_server_info_test.cc',
      'quic/core/crypto/quic_compressed_certs_cache_test.cc',
      'quic/core/crypto/quic_crypto_client_config_test.cc',
      'quic/core/crypto/quic_crypto_server_config_test.cc',
      'quic/core/crypto/quic_random_test.cc',
      'quic/core/crypto/strike_register_test.cc',
      'quic/core/interval_set_test.cc',
      'quic/core/interval_test.cc',
      'quic/core/iovector_test.cc',
      'quic/core/quic_address_mismatch_test.cc',
      'quic/core/quic_alarm_test.cc',
      'quic/core/quic_arena_scoped_ptr_test.cc',
      'quic/core/quic_bandwidth_test.cc',
      'quic/core/quic_buffered_packet_store_test.cc',
      'quic/core/quic_client_push_promise_index_test.cc',
      'quic/core/quic_clock_test.cc',
      'quic/core/quic_config_test.cc',
      'quic/core/quic_connection_test.cc',
      'quic/core/quic_crypto_client_stream_test.cc',
      'quic/core/quic_crypto_server_stream_test.cc',
      'quic/core/quic_crypto_stream_test.cc',
      'quic/core/quic_data_writer_test.cc',
      'quic/core/quic_flow_controller_test.cc',
      'quic/core/quic_framer_test.cc',
      'quic/core/quic_header_list_test.cc',
      'quic/core/quic_headers_stream_test.cc',
      'quic/core/quic_http_utils_test.cc',
      'quic/core/quic_multipath_received_packet_manager_test.cc',
      'quic/core/quic_multipath_sent_packet_manager_test.cc',
      'quic/core/quic_multipath_transmissions_map_test.cc',
      'quic/core/quic_one_block_arena_test.cc',
      'quic/core/quic_packet_creator_test.cc',
      'quic/core/quic_packet_generator_test.cc',
      'quic/core/quic_protocol_test.cc',
      'quic/core/quic_received_packet_manager_test.cc',
      'quic/core/quic_sent_entropy_manager_test.cc',
      'quic/core/quic_sent_packet_manager_test.cc',
      'quic/core/quic_server_id_test.cc',
      'quic/core/quic_server_session_base_test.cc',
      'quic/core/quic_session_test.cc',
      'quic/core/quic_simple_buffer_allocator_test.cc',
      'quic/core/quic_socket_address_coder_test.cc',
      'quic/core/quic_spdy_stream_test.cc',
      'quic/core/quic_stream_sequencer_test.cc',
      'quic/core/quic_sustained_bandwidth_recorder_test.cc',
      'quic/core/quic_time_test.cc',
      'quic/core/quic_unacked_packet_map_test.cc',
      'quic/core/quic_utils_test.cc',
      'quic/core/quic_write_blocked_list_test.cc',
      'quic/core/reliable_quic_stream_test.cc',
      'quic/core/spdy_utils_test.cc',
      'quic/core/quic_stream_sequencer_buffer_test.cc',
      'quic/test_tools/crypto_test_utils.cc',
      'quic/test_tools/crypto_test_utils.h',
      'quic/test_tools/crypto_test_utils_test.cc',
      'quic/test_tools/delayed_verify_strike_register_client.cc',
      'quic/test_tools/delayed_verify_strike_register_client.h',
      'quic/test_tools/mock_clock.cc',
      'quic/test_tools/mock_clock.h',
      'quic/test_tools/mock_crypto_client_stream.cc',
      'quic/test_tools/mock_crypto_client_stream.h',
      'quic/test_tools/mock_crypto_client_stream_factory.cc',
      'quic/test_tools/mock_crypto_client_stream_factory.h',
      'quic/test_tools/mock_quic_client_promised_info.cc',
      'quic/test_tools/mock_quic_client_promised_info.h',
      'quic/test_tools/mock_quic_dispatcher.cc',
      'quic/test_tools/mock_quic_dispatcher.h',
      'quic/test_tools/mock_quic_spdy_client_stream.cc',
      'quic/test_tools/mock_quic_spdy_client_stream.h',
      'quic/test_tools/mock_random.cc',
      'quic/test_tools/mock_random.h',
      'quic/test_tools/quic_buffered_packet_store_peer.cc',
      'quic/test_tools/quic_buffered_packet_store_peer.h',
      'quic/test_tools/quic_config_peer.cc',
      'quic/test_tools/quic_config_peer.h',
      'quic/test_tools/quic_connection_peer.cc',
      'quic/test_tools/quic_connection_peer.h',
      'quic/test_tools/quic_crypto_server_config_peer.cc',
      'quic/test_tools/quic_crypto_server_config_peer.h',
      'quic/test_tools/quic_flow_controller_peer.cc',
      'quic/test_tools/quic_flow_controller_peer.h',
      'quic/test_tools/quic_framer_peer.cc',
      'quic/test_tools/quic_framer_peer.h',
      'quic/test_tools/quic_headers_stream_peer.cc',
      'quic/test_tools/quic_headers_stream_peer.h',
      'quic/test_tools/quic_multipath_sent_packet_manager_peer.h',
      'quic/test_tools/quic_multipath_sent_packet_manager_peer.cc',
      'quic/test_tools/quic_packet_creator_peer.cc',
      'quic/test_tools/quic_packet_creator_peer.h',
      'quic/test_tools/quic_packet_generator_peer.cc',
      'quic/test_tools/quic_packet_generator_peer.h',
      'quic/test_tools/quic_received_packet_manager_peer.cc',
      'quic/test_tools/quic_received_packet_manager_peer.h',
      'quic/test_tools/quic_sent_packet_manager_peer.cc',
      'quic/test_tools/quic_sent_packet_manager_peer.h',
      'quic/test_tools/quic_session_peer.cc',
      'quic/test_tools/quic_session_peer.h',
      'quic/test_tools/quic_spdy_session_peer.cc',
      'quic/test_tools/quic_spdy_session_peer.h',
      'quic/test_tools/quic_spdy_stream_peer.cc',
      'quic/test_tools/quic_spdy_stream_peer.h',
      'quic/test_tools/quic_stream_factory_peer.cc',
      'quic/test_tools/quic_stream_factory_peer.h',
      'quic/test_tools/quic_stream_sequencer_peer.cc',
      'quic/test_tools/quic_stream_sequencer_peer.h',
      'quic/test_tools/quic_sustained_bandwidth_recorder_peer.cc',
      'quic/test_tools/quic_sustained_bandwidth_recorder_peer.h',
      'quic/test_tools/quic_test_packet_maker.cc',
      'quic/test_tools/quic_test_packet_maker.h',
      'quic/test_tools/quic_test_utils.cc',
      'quic/test_tools/quic_test_utils.h',
      'quic/test_tools/reliable_quic_stream_peer.cc',
      'quic/test_tools/reliable_quic_stream_peer.h',
      'quic/test_tools/rtt_stats_peer.cc',
      'quic/test_tools/rtt_stats_peer.h',
      'quic/test_tools/simple_quic_framer.cc',
      'quic/test_tools/simple_quic_framer.h',
      'quic/test_tools/test_task_runner.cc',
      'quic/test_tools/test_task_runner.h',
      'sdch/sdch_owner_unittest.cc',
      'socket/client_socket_pool_base_unittest.cc',
      'socket/mock_client_socket_pool_manager.cc',
      'socket/mock_client_socket_pool_manager.h',
      'socket/sequenced_socket_data_unittest.cc',
      'socket/socks5_client_socket_unittest.cc',
      'socket/socks_client_socket_pool_unittest.cc',
      'socket/socks_client_socket_unittest.cc',
      'socket/ssl_client_socket_pool_unittest.cc',
      'socket/ssl_client_socket_unittest.cc',
      'socket/ssl_server_socket_unittest.cc',
      'socket/tcp_client_socket_unittest.cc',
      'socket/tcp_server_socket_unittest.cc',
      'socket/tcp_socket_unittest.cc',
      'socket/transport_client_socket_pool_test_util.cc',
      'socket/transport_client_socket_pool_test_util.h',
      'socket/transport_client_socket_pool_unittest.cc',
      'socket/transport_client_socket_unittest.cc',
      'socket/unix_domain_client_socket_posix_unittest.cc',
      'socket/unix_domain_server_socket_posix_unittest.cc',
      'socket/websocket_endpoint_lock_manager_unittest.cc',
      'socket/websocket_transport_client_socket_pool_unittest.cc',
      'spdy/bidirectional_stream_spdy_impl_unittest.cc',
      'spdy/buffered_spdy_framer_unittest.cc',
      'spdy/fuzzing/hpack_fuzz_util_test.cc',
      'spdy/header_coalescer_test.cc',
      'spdy/hpack/hpack_decoder_test.cc',
      'spdy/hpack/hpack_encoder_test.cc',
      'spdy/hpack/hpack_entry_test.cc',
      'spdy/hpack/hpack_header_table_test.cc',
      'spdy/hpack/hpack_huffman_decoder_test.cc',
      'spdy/hpack/hpack_huffman_table_test.cc',
      'spdy/hpack/hpack_input_stream_test.cc',
      'spdy/hpack/hpack_output_stream_test.cc',
      'spdy/hpack/hpack_round_trip_test.cc',
      'spdy/hpack/hpack_static_table_test.cc',
      'spdy/http2_write_scheduler_test.cc',
      'spdy/http2_priority_dependencies_unittest.cc',
      'spdy/mock_spdy_framer_visitor.cc',
      'spdy/mock_spdy_framer_visitor.h',
      'spdy/priority_write_scheduler_test.cc',
      'spdy/spdy_alt_svc_wire_format_test.cc',
      'spdy/spdy_buffer_unittest.cc',
      'spdy/spdy_deframer_visitor.cc',
      'spdy/spdy_deframer_visitor.h',
      'spdy/spdy_deframer_visitor_test.cc',
      'spdy/spdy_frame_builder_test.cc',
      'spdy/spdy_frame_reader_test.cc',
      'spdy/spdy_framer_test.cc',
      'spdy/spdy_header_block_test.cc',
      'spdy/spdy_headers_block_parser_test.cc',
      'spdy/spdy_http_stream_unittest.cc',
      'spdy/spdy_http_utils_unittest.cc',
      'spdy/spdy_network_transaction_unittest.cc',
      'spdy/spdy_no_op_visitor.h',
      'spdy/spdy_no_op_visitor.cc',
      'spdy/spdy_pinnable_buffer_piece_test.cc',
      'spdy/spdy_prefixed_buffer_reader_test.cc',
      'spdy/spdy_protocol_test.cc',
      'spdy/spdy_protocol_test_utils.cc',
      'spdy/spdy_protocol_test_utils.h',
      'spdy/spdy_proxy_client_socket_unittest.cc',
      'spdy/spdy_read_queue_unittest.cc',
      'spdy/spdy_session_pool_unittest.cc',
      'spdy/spdy_session_test_util.cc',
      'spdy/spdy_session_test_util.h',
      'spdy/spdy_session_unittest.cc',
      'spdy/spdy_stream_test_util.cc',
      'spdy/spdy_stream_test_util.h',
      'spdy/spdy_stream_unittest.cc',
      'spdy/spdy_test_util_common.cc',
      'spdy/spdy_test_util_common.h',
      'spdy/spdy_test_utils.cc',
      'spdy/spdy_test_utils.h',
      'spdy/spdy_write_queue_unittest.cc',
      'spdy/write_blocked_list_test.cc',
      'ssl/channel_id_service_unittest.cc',
      'ssl/client_cert_store_mac_unittest.cc',
      'ssl/client_cert_store_nss_unittest.cc',
      'ssl/client_cert_store_unittest-inl.h',
      'ssl/client_cert_store_win_unittest.cc',
      'ssl/default_channel_id_store_unittest.cc',
      'ssl/openssl_client_key_store_unittest.cc',
      'ssl/ssl_cipher_suite_names_unittest.cc',
      'ssl/ssl_client_auth_cache_unittest.cc',
      'ssl/ssl_client_session_cache_unittest.cc',
      'ssl/ssl_config_service_unittest.cc',
      'ssl/ssl_config_unittest.cc',
      'ssl/ssl_connection_status_flags_unittest.cc',
      'test/embedded_test_server/embedded_test_server_unittest.cc',
      'test/embedded_test_server/http_request_unittest.cc',
      'test/embedded_test_server/http_response_unittest.cc',
      'test/python_utils_unittest.cc',
      'test/run_all_unittests.cc',
      'third_party/nist-pkits/pkits_testcases-inl.h',
      'tools/balsa/balsa_frame_test.cc',
      'tools/balsa/balsa_headers_test.cc',
      'tools/quic/quic_simple_client_test.cc',
      'tools/quic/test_tools/mock_quic_server_session_visitor.cc',
      'tools/quic/test_tools/mock_quic_server_session_visitor.h',
      'tools/tld_cleanup/tld_cleanup_util_unittest.cc',
      'udp/udp_socket_unittest.cc',
      'url_request/report_sender_unittest.cc',
      'url_request/sdch_dictionary_fetcher_unittest.cc',
      'url_request/url_fetcher_impl_unittest.cc',
      'url_request/url_fetcher_response_writer_unittest.cc',
      'url_request/url_request_context_builder_unittest.cc',
      'url_request/url_request_data_job_unittest.cc',
      'url_request/url_request_file_dir_job_unittest.cc',
      'url_request/url_request_file_job_unittest.cc',
      'url_request/url_request_filter_unittest.cc',
      'url_request/url_request_ftp_job_unittest.cc',
      'url_request/url_request_http_job_unittest.cc',
      'url_request/url_request_job_factory_impl_unittest.cc',
      'url_request/url_request_job_unittest.cc',
      'url_request/url_request_simple_job_unittest.cc',
      'url_request/url_request_throttler_simulation_unittest.cc',
      'url_request/url_request_throttler_test_support.cc',
      'url_request/url_request_throttler_test_support.h',
      'url_request/url_request_throttler_unittest.cc',
      'url_request/url_request_unittest.cc',
      'url_request/view_cache_helper_unittest.cc',
    ],
    'net_linux_test_sources': [
      'quic/core/quic_end_to_end_unittest.cc',
      'tools/quic/chlo_extractor_test.cc',
      'tools/quic/end_to_end_test.cc',
      'tools/quic/quic_client_session_test.cc',
      'tools/quic/quic_client_test.cc',
      'tools/quic/quic_dispatcher_test.cc',
      'tools/quic/quic_epoll_alarm_factory_test.cc',
      'tools/quic/quic_epoll_clock_test.cc',
      'tools/quic/quic_epoll_connection_helper_test.cc',
      'tools/quic/quic_in_memory_cache_test.cc',
      'tools/quic/quic_server_test.cc',
      'tools/quic/quic_simple_server_session_helper_test.cc',
      'tools/quic/quic_simple_server_session_test.cc',
      'tools/quic/quic_simple_server_stream_test.cc',
      'tools/quic/quic_simple_server_test.cc',
      'tools/quic/quic_spdy_client_stream_test.cc',
      'tools/quic/quic_time_wait_list_manager_test.cc',
      'tools/quic/spdy_balsa_utils_test.cc',
      'tools/quic/stateless_rejector_test.cc',
      'tools/quic/test_tools/http_message.cc',
      'tools/quic/test_tools/http_message.h',
      'tools/quic/test_tools/limited_mtu_test_writer.cc',
      'tools/quic/test_tools/limited_mtu_test_writer.h',
      'tools/quic/test_tools/mock_epoll_server.cc',
      'tools/quic/test_tools/mock_epoll_server.h',
      'tools/quic/test_tools/mock_quic_time_wait_list_manager.cc',
      'tools/quic/test_tools/mock_quic_time_wait_list_manager.h',
      'tools/quic/test_tools/packet_dropping_test_writer.cc',
      'tools/quic/test_tools/packet_dropping_test_writer.h',
      'tools/quic/test_tools/packet_reordering_writer.cc',
      'tools/quic/test_tools/packet_reordering_writer.h',
      'tools/quic/test_tools/quic_client_peer.cc',
      'tools/quic/test_tools/quic_client_peer.h',
      'tools/quic/test_tools/quic_dispatcher_peer.cc',
      'tools/quic/test_tools/quic_dispatcher_peer.h',
      'tools/quic/test_tools/quic_in_memory_cache_peer.cc',
      'tools/quic/test_tools/quic_in_memory_cache_peer.h',
      'tools/quic/test_tools/quic_server_peer.cc',
      'tools/quic/test_tools/quic_server_peer.h',
      'tools/quic/test_tools/quic_test_client.cc',
      'tools/quic/test_tools/quic_test_client.h',
      'tools/quic/test_tools/quic_test_server.cc',
      'tools/quic/test_tools/quic_test_server.h',
      'tools/quic/test_tools/server_thread.cc',
      'tools/quic/test_tools/server_thread.h',
      'tools/quic/test_tools/simple_client.cc',
      'tools/quic/test_tools/simple_client.h',
    ],
    'net_websockets_test_sources': [
      'server/http_connection_unittest.cc',
      'server/http_server_response_info_unittest.cc',
      'server/http_server_unittest.cc',
      'server/web_socket_encoder_unittest.cc',
      'websockets/websocket_basic_stream_test.cc',
      'websockets/websocket_channel_test.cc',
      'websockets/websocket_deflate_parameters_test.cc',
      'websockets/websocket_deflate_predictor_impl_test.cc',
      'websockets/websocket_deflate_stream_test.cc',
      'websockets/websocket_deflater_test.cc',
      'websockets/websocket_end_to_end_test.cc',
      'websockets/websocket_errors_test.cc',
      'websockets/websocket_extension_parser_test.cc',
      'websockets/websocket_extension_test.cc',
      'websockets/websocket_frame_parser_test.cc',
      'websockets/websocket_frame_test.cc',
      'websockets/websocket_handshake_challenge_test.cc',
      'websockets/websocket_handshake_stream_create_helper_test.cc',
      'websockets/websocket_inflater_test.cc',
      'websockets/websocket_stream_cookie_test.cc',
      'websockets/websocket_stream_create_test_base.cc',
      'websockets/websocket_stream_create_test_base.h',
      'websockets/websocket_stream_test.cc',
      'websockets/websocket_test_util.cc',
      'websockets/websocket_test_util.h',
    ],
    'net_base_mac_ios_sources': [
      'base/mac/url_conversions.h',
      'base/mac/url_conversions.mm',
    ],
    'net_base_test_mac_ios_sources': [
      'base/mac/url_conversions_unittest.mm',
    ],
    'net_file_support_sources': [
      "base/directory_lister.cc",
      "base/directory_lister.h",
      "base/directory_listing.cc",
      "base/directory_listing.h",
      "url_request/file_protocol_handler.cc",
      "url_request/file_protocol_handler.h",
      "url_request/url_request_file_dir_job.cc",
      "url_request/url_request_file_dir_job.h",
      "url_request/url_request_file_job.cc",
      "url_request/url_request_file_job.h",
    ],
    'net_ftp_support_sources': [
      "ftp/ftp_auth_cache.cc",
      "ftp/ftp_auth_cache.h",
      "ftp/ftp_ctrl_response_buffer.cc",
      "ftp/ftp_ctrl_response_buffer.h",
      "ftp/ftp_directory_listing_parser.cc",
      "ftp/ftp_directory_listing_parser.h",
      "ftp/ftp_directory_listing_parser_ls.cc",
      "ftp/ftp_directory_listing_parser_ls.h",
      "ftp/ftp_directory_listing_parser_vms.cc",
      "ftp/ftp_directory_listing_parser_vms.h",
      "ftp/ftp_directory_listing_parser_windows.cc",
      "ftp/ftp_directory_listing_parser_windows.h",
      "ftp/ftp_network_layer.cc",
      "ftp/ftp_network_layer.h",
      "ftp/ftp_network_session.cc",
      "ftp/ftp_network_session.h",
      "ftp/ftp_network_transaction.cc",
      "ftp/ftp_network_transaction.h",
      "ftp/ftp_request_info.h",
      "ftp/ftp_response_info.cc",
      "ftp/ftp_response_info.h",
      "ftp/ftp_server_type_histograms.cc",
      "ftp/ftp_server_type_histograms.h",
      "ftp/ftp_transaction.h",
      "ftp/ftp_transaction_factory.h",
      "ftp/ftp_util.cc",
      "ftp/ftp_util.h",
      "url_request/ftp_protocol_handler.cc",
      "url_request/ftp_protocol_handler.h",
      "url_request/url_request_ftp_job.cc",
      "url_request/url_request_ftp_job.h",
    ],
    'net_websockets_sources': [
      "websockets/websocket_basic_handshake_stream.cc",
      "websockets/websocket_basic_handshake_stream.h",
      "websockets/websocket_basic_stream.cc",
      "websockets/websocket_basic_stream.h",
      "websockets/websocket_channel.cc",
      "websockets/websocket_channel.h",
      "websockets/websocket_deflate_parameters.cc",
      "websockets/websocket_deflate_parameters.h",
      "websockets/websocket_deflate_predictor.h",
      "websockets/websocket_deflate_predictor_impl.cc",
      "websockets/websocket_deflate_predictor_impl.h",
      "websockets/websocket_deflate_stream.cc",
      "websockets/websocket_deflate_stream.h",
      "websockets/websocket_deflater.cc",
      "websockets/websocket_deflater.h",
      "websockets/websocket_errors.cc",
      "websockets/websocket_errors.h",
      "websockets/websocket_extension.cc",
      "websockets/websocket_extension.h",
      "websockets/websocket_extension_parser.cc",
      "websockets/websocket_extension_parser.h",
      "websockets/websocket_frame.cc",
      "websockets/websocket_frame.h",
      "websockets/websocket_frame_parser.cc",
      "websockets/websocket_frame_parser.h",
      "websockets/websocket_handshake_challenge.cc",
      "websockets/websocket_handshake_challenge.h",
      "websockets/websocket_handshake_constants.cc",
      "websockets/websocket_handshake_constants.h",
      "websockets/websocket_handshake_request_info.cc",
      "websockets/websocket_handshake_request_info.h",
      "websockets/websocket_handshake_response_info.cc",
      "websockets/websocket_handshake_response_info.h",
      "websockets/websocket_handshake_stream_base.h",
      "websockets/websocket_handshake_stream_create_helper.cc",
      "websockets/websocket_handshake_stream_create_helper.h",
      "websockets/websocket_inflater.cc",
      "websockets/websocket_inflater.h",
      "websockets/websocket_mux.h",
      "websockets/websocket_stream.cc",
      "websockets/websocket_stream.h",
    ],
    # List of test data files for //net:test_support. Can be regenerated by
    # running net/data/update_net_gypi.py.
    'net_test_support_data_sources': [
      'data/ssl/certificates/1024-rsa-ee-by-1024-rsa-intermediate.pem',
      'data/ssl/certificates/1024-rsa-ee-by-2048-rsa-intermediate.pem',
      'data/ssl/certificates/1024-rsa-ee-by-768-rsa-intermediate.pem',
      'data/ssl/certificates/1024-rsa-ee-by-prime256v1-ecdsa-intermediate.pem',
      'data/ssl/certificates/1024-rsa-intermediate.pem',
      'data/ssl/certificates/10_year_validity.pem',
      'data/ssl/certificates/11_year_validity.pem',
      'data/ssl/certificates/2029_globalsign_com_cert.pem',
      'data/ssl/certificates/2048-rsa-ee-by-1024-rsa-intermediate.pem',
      'data/ssl/certificates/2048-rsa-ee-by-2048-rsa-intermediate.pem',
      'data/ssl/certificates/2048-rsa-ee-by-768-rsa-intermediate.pem',
      'data/ssl/certificates/2048-rsa-ee-by-prime256v1-ecdsa-intermediate.pem',
      'data/ssl/certificates/2048-rsa-intermediate.pem',
      'data/ssl/certificates/2048-rsa-root.pem',
      'data/ssl/certificates/39_months_after_2015_04.pem',
      'data/ssl/certificates/40_months_after_2015_04.pem',
      'data/ssl/certificates/60_months_after_2012_07.pem',
      'data/ssl/certificates/61_months_after_2012_07.pem',
      'data/ssl/certificates/768-rsa-ee-by-1024-rsa-intermediate.pem',
      'data/ssl/certificates/768-rsa-ee-by-2048-rsa-intermediate.pem',
      'data/ssl/certificates/768-rsa-ee-by-768-rsa-intermediate.pem',
      'data/ssl/certificates/768-rsa-ee-by-prime256v1-ecdsa-intermediate.pem',
      'data/ssl/certificates/768-rsa-intermediate.pem',
      'data/ssl/certificates/aia-cert.pem',
      'data/ssl/certificates/aia-intermediate.der',
      'data/ssl/certificates/aia-root.pem',
      'data/ssl/certificates/android-test-key-dsa-public.pem',
      'data/ssl/certificates/android-test-key-dsa.pem',
      'data/ssl/certificates/android-test-key-ecdsa-public.pem',
      'data/ssl/certificates/android-test-key-ecdsa.pem',
      'data/ssl/certificates/android-test-key-rsa.pem',
      'data/ssl/certificates/bad_validity.pem',
      'data/ssl/certificates/client-nokey.p12',
      'data/ssl/certificates/client.p12',
      'data/ssl/certificates/client_1.key',
      'data/ssl/certificates/client_1.pem',
      'data/ssl/certificates/client_1.pk8',
      'data/ssl/certificates/client_1_ca.pem',
      'data/ssl/certificates/client_2.key',
      'data/ssl/certificates/client_2.pem',
      'data/ssl/certificates/client_2.pk8',
      'data/ssl/certificates/client_2_ca.pem',
      'data/ssl/certificates/client_3.key',
      'data/ssl/certificates/client_3.pem',
      'data/ssl/certificates/client_3.pk8',
      'data/ssl/certificates/client_3_ca.pem',
      'data/ssl/certificates/comodo.chain.pem',
      'data/ssl/certificates/crit-codeSigning-chain.pem',
      'data/ssl/certificates/crlset_by_intermediate_serial.raw',
      'data/ssl/certificates/crlset_by_leaf_spki.raw',
      'data/ssl/certificates/crlset_by_root_serial.raw',
      'data/ssl/certificates/cross-signed-leaf.pem',
      'data/ssl/certificates/cross-signed-root-md5.pem',
      'data/ssl/certificates/cross-signed-root-sha256.pem',
      'data/ssl/certificates/ct-test-embedded-cert.pem',
      'data/ssl/certificates/ct-test-embedded-with-intermediate-chain.pem',
      'data/ssl/certificates/ct-test-embedded-with-intermediate-preca-chain.pem',
      'data/ssl/certificates/ct-test-embedded-with-preca-chain.pem',
      'data/ssl/certificates/diginotar_cyber_ca.pem',
      'data/ssl/certificates/diginotar_pkioverheid.pem',
      'data/ssl/certificates/diginotar_pkioverheid_g2.pem',
      'data/ssl/certificates/diginotar_public_ca_2025.pem',
      'data/ssl/certificates/diginotar_root_ca.pem',
      'data/ssl/certificates/diginotar_services_1024_ca.pem',
      'data/ssl/certificates/dod_ca_13_cert.der',
      'data/ssl/certificates/dod_ca_17_cert.der',
      'data/ssl/certificates/dod_root_ca_2_cert.der',
      'data/ssl/certificates/duplicate_cn_1.p12',
      'data/ssl/certificates/duplicate_cn_1.pem',
      'data/ssl/certificates/duplicate_cn_2.p12',
      'data/ssl/certificates/duplicate_cn_2.pem',
      'data/ssl/certificates/eku-test-root.pem',
      'data/ssl/certificates/empty_subject_cert.der',
      'data/ssl/certificates/expired_cert.pem',
      'data/ssl/certificates/explicit-policy-chain.pem',
      'data/ssl/certificates/foaf.me.chromium-test-cert.der',
      'data/ssl/certificates/google.binary.p7b',
      'data/ssl/certificates/google.chain.pem',
      'data/ssl/certificates/google.pem_cert.p7b',
      'data/ssl/certificates/google.pem_pkcs7.p7b',
      'data/ssl/certificates/google.single.der',
      'data/ssl/certificates/google.single.pem',
      'data/ssl/certificates/google_diginotar.pem',
      'data/ssl/certificates/googlenew.chain.pem',
      'data/ssl/certificates/invalid_key_usage_cert.der',
      'data/ssl/certificates/large_key.pem',
      'data/ssl/certificates/localhost_cert.pem',
      'data/ssl/certificates/mit.davidben.der',
      'data/ssl/certificates/multi-root-A-by-B.pem',
      'data/ssl/certificates/multi-root-B-by-C.pem',
      'data/ssl/certificates/multi-root-B-by-F.pem',
      'data/ssl/certificates/multi-root-C-by-D.pem',
      'data/ssl/certificates/multi-root-C-by-E.pem',
      'data/ssl/certificates/multi-root-D-by-D.pem',
      'data/ssl/certificates/multi-root-E-by-E.pem',
      'data/ssl/certificates/multi-root-F-by-E.pem',
      'data/ssl/certificates/multi-root-chain1.pem',
      'data/ssl/certificates/multi-root-chain2.pem',
      'data/ssl/certificates/multi-root-crlset-C.raw',
      'data/ssl/certificates/multi-root-crlset-CD-and-FE.raw',
      'data/ssl/certificates/multi-root-crlset-D-and-E.raw',
      'data/ssl/certificates/multi-root-crlset-E.raw',
      'data/ssl/certificates/multi-root-crlset-unrelated.raw',
      'data/ssl/certificates/multivalue_rdn.pem',
      'data/ssl/certificates/name_constraint_bad.pem',
      'data/ssl/certificates/name_constraint_good.pem',
      'data/ssl/certificates/ndn.ca.crt',
      'data/ssl/certificates/nist.der',
      'data/ssl/certificates/no_subject_common_name_cert.pem',
      'data/ssl/certificates/non-crit-codeSigning-chain.pem',
      'data/ssl/certificates/ocsp-test-root.pem',
      'data/ssl/certificates/ok_cert.pem',
      'data/ssl/certificates/post_june_2016.pem',
      'data/ssl/certificates/pre_br_validity_bad_121.pem',
      'data/ssl/certificates/pre_br_validity_bad_2020.pem',
      'data/ssl/certificates/pre_br_validity_ok.pem',
      'data/ssl/certificates/pre_june_2016.pem',
      'data/ssl/certificates/prime256v1-ecdsa-ee-by-1024-rsa-intermediate.pem',
      'data/ssl/certificates/prime256v1-ecdsa-ee-by-2048-rsa-intermediate.pem',
      'data/ssl/certificates/prime256v1-ecdsa-ee-by-768-rsa-intermediate.pem',
      'data/ssl/certificates/prime256v1-ecdsa-ee-by-prime256v1-ecdsa-intermediate.pem',
      'data/ssl/certificates/prime256v1-ecdsa-intermediate.pem',
      'data/ssl/certificates/punycodetest.pem',
      'data/ssl/certificates/quic_chain.crt',
      'data/ssl/certificates/quic_intermediate.crt',
      'data/ssl/certificates/quic_intermediate.key',
      'data/ssl/certificates/quic_root.crt',
      'data/ssl/certificates/quic_root.key',
      'data/ssl/certificates/quic_test.example.com.crt',
      'data/ssl/certificates/quic_test.example.com.key',
      'data/ssl/certificates/quic_test.example.com.key.pkcs8',
      'data/ssl/certificates/quic_test.example.com.key.sct',
      'data/ssl/certificates/quic_test_ecc.example.com.crt',
      'data/ssl/certificates/quic_test_ecc.example.com.key',
      'data/ssl/certificates/redundant-server-chain.pem',
      'data/ssl/certificates/redundant-validated-chain-root.pem',
      'data/ssl/certificates/redundant-validated-chain.pem',
      'data/ssl/certificates/reject_intranet_hosts.pem',
      'data/ssl/certificates/root_ca_cert.pem',
      'data/ssl/certificates/salesforce_com_test.pem',
      'data/ssl/certificates/self-signed-invalid-name.pem',
      'data/ssl/certificates/self-signed-invalid-sig.pem',
      'data/ssl/certificates/sha1_2016.pem',
      'data/ssl/certificates/sha1_dec_2015.pem',
      'data/ssl/certificates/sha1_jan_2016.pem',
      'data/ssl/certificates/spdy_pooling.pem',
      'data/ssl/certificates/start_after_expiry.pem',
      'data/ssl/certificates/subjectAltName_sanity_check.pem',
      'data/ssl/certificates/test_mail_google_com.pem',
      'data/ssl/certificates/thawte.single.pem',
      'data/ssl/certificates/twitter-chain.pem',
      'data/ssl/certificates/unescaped.pem',
      'data/ssl/certificates/unittest.key.bin',
      'data/ssl/certificates/unittest.originbound.der',
      'data/ssl/certificates/unittest.originbound.key.der',
      'data/ssl/certificates/unittest.selfsigned.der',
      'data/ssl/certificates/verisign_intermediate_ca_2011.pem',
      'data/ssl/certificates/verisign_intermediate_ca_2016.pem',
      'data/ssl/certificates/weak_digest_md2_ee.pem',
      'data/ssl/certificates/weak_digest_md2_intermediate.pem',
      'data/ssl/certificates/weak_digest_md2_root.pem',
      'data/ssl/certificates/weak_digest_md4_ee.pem',
      'data/ssl/certificates/weak_digest_md4_intermediate.pem',
      'data/ssl/certificates/weak_digest_md4_root.pem',
      'data/ssl/certificates/weak_digest_md5_ee.pem',
      'data/ssl/certificates/weak_digest_md5_intermediate.pem',
      'data/ssl/certificates/weak_digest_md5_root.pem',
      'data/ssl/certificates/weak_digest_sha1_ee.pem',
      'data/ssl/certificates/weak_digest_sha1_intermediate.pem',
      'data/ssl/certificates/weak_digest_sha1_root.pem',
      'data/ssl/certificates/websocket_cacert.pem',
      'data/ssl/certificates/websocket_client_cert.p12',
      'data/ssl/certificates/wildcard.pem',
      'data/ssl/certificates/www_us_army_mil_cert.der',
      'data/ssl/certificates/x509_verify_results.chain.pem',
    ],
    # List of test data files for //net:net_unittests. Can be regenerated by
    # running net/data/update_net_gypi.py.
    'net_unittests_data_sources': [
      'data/cert_issuer_source_aia_unittest/i.pem',
      'data/cert_issuer_source_aia_unittest/i2.pem',
      'data/cert_issuer_source_aia_unittest/i3.pem',
      'data/cert_issuer_source_aia_unittest/target_file_aia.pem',
      'data/cert_issuer_source_aia_unittest/target_file_and_http_aia.pem',
      'data/cert_issuer_source_aia_unittest/target_invalid_and_http_aia.pem',
      'data/cert_issuer_source_aia_unittest/target_invalid_url_aia.pem',
      'data/cert_issuer_source_aia_unittest/target_no_aia.pem',
      'data/cert_issuer_source_aia_unittest/target_one_aia.pem',
      'data/cert_issuer_source_aia_unittest/target_six_aia.pem',
      'data/cert_issuer_source_aia_unittest/target_three_aia.pem',
      'data/cert_issuer_source_aia_unittest/target_two_aia.pem',
      'data/cert_issuer_source_static_unittest/c1.pem',
      'data/cert_issuer_source_static_unittest/c2.pem',
      'data/cert_issuer_source_static_unittest/d.pem',
      'data/cert_issuer_source_static_unittest/i1_1.pem',
      'data/cert_issuer_source_static_unittest/i1_2.pem',
      'data/cert_issuer_source_static_unittest/i2.pem',
      'data/cert_issuer_source_static_unittest/root.pem',
      'data/certificate_policies_unittest/anypolicy.pem',
      'data/certificate_policies_unittest/anypolicy_with_qualifier.pem',
      'data/certificate_policies_unittest/invalid-anypolicy_with_custom_qualifier.pem',
      'data/certificate_policies_unittest/invalid-empty.pem',
      'data/certificate_policies_unittest/invalid-policy_1_2_3_dupe.pem',
      'data/certificate_policies_unittest/invalid-policy_1_2_3_policyinformation_unconsumed_data.pem',
      'data/certificate_policies_unittest/invalid-policy_1_2_3_policyqualifierinfo_unconsumed_data.pem',
      'data/certificate_policies_unittest/invalid-policy_1_2_3_with_empty_qualifiers_sequence.pem',
      'data/certificate_policies_unittest/invalid-policy_identifier_not_oid.pem',
      'data/certificate_policies_unittest/policy_1_2_3.pem',
      'data/certificate_policies_unittest/policy_1_2_3_and_1_2_4.pem',
      'data/certificate_policies_unittest/policy_1_2_3_and_1_2_4_with_qualifiers.pem',
      'data/certificate_policies_unittest/policy_1_2_3_with_custom_qualifier.pem',
      'data/certificate_policies_unittest/policy_1_2_3_with_qualifier.pem',
      'data/name_constraints_unittest/directoryname-excludeall.pem',
      'data/name_constraints_unittest/directoryname-excluded.pem',
      'data/name_constraints_unittest/directoryname.pem',
      'data/name_constraints_unittest/directoryname_and_dnsname.pem',
      'data/name_constraints_unittest/directoryname_and_dnsname_and_ipaddress.pem',
      'data/name_constraints_unittest/dnsname-exclude_dot.pem',
      'data/name_constraints_unittest/dnsname-excludeall.pem',
      'data/name_constraints_unittest/dnsname-excluded.pem',
      'data/name_constraints_unittest/dnsname-permitted_with_leading_dot.pem',
      'data/name_constraints_unittest/dnsname-with_max.pem',
      'data/name_constraints_unittest/dnsname-with_min_0.pem',
      'data/name_constraints_unittest/dnsname-with_min_0_and_max.pem',
      'data/name_constraints_unittest/dnsname-with_min_1.pem',
      'data/name_constraints_unittest/dnsname-with_min_1_and_max.pem',
      'data/name_constraints_unittest/dnsname.pem',
      'data/name_constraints_unittest/dnsname2.pem',
      'data/name_constraints_unittest/edipartyname-excluded.pem',
      'data/name_constraints_unittest/edipartyname-permitted.pem',
      'data/name_constraints_unittest/invalid-empty_excluded_subtree.pem',
      'data/name_constraints_unittest/invalid-empty_permitted_subtree.pem',
      'data/name_constraints_unittest/invalid-no_subtrees.pem',
      'data/name_constraints_unittest/ipaddress-excludeall.pem',
      'data/name_constraints_unittest/ipaddress-excluded.pem',
      'data/name_constraints_unittest/ipaddress-invalid_addr.pem',
      'data/name_constraints_unittest/ipaddress-invalid_mask_not_contiguous_1.pem',
      'data/name_constraints_unittest/ipaddress-invalid_mask_not_contiguous_2.pem',
      'data/name_constraints_unittest/ipaddress-invalid_mask_not_contiguous_3.pem',
      'data/name_constraints_unittest/ipaddress-invalid_mask_not_contiguous_4.pem',
      'data/name_constraints_unittest/ipaddress-permit_all.pem',
      'data/name_constraints_unittest/ipaddress-permit_prefix1.pem',
      'data/name_constraints_unittest/ipaddress-permit_prefix31.pem',
      'data/name_constraints_unittest/ipaddress-permit_singlehost.pem',
      'data/name_constraints_unittest/ipaddress.pem',
      'data/name_constraints_unittest/name-ca.pem',
      'data/name_constraints_unittest/name-de.pem',
      'data/name_constraints_unittest/name-empty.pem',
      'data/name_constraints_unittest/name-jp-tokyo.pem',
      'data/name_constraints_unittest/name-jp.pem',
      'data/name_constraints_unittest/name-us-arizona-1.1.1.1.pem',
      'data/name_constraints_unittest/name-us-arizona-192.168.1.1.pem',
      'data/name_constraints_unittest/name-us-arizona-email.pem',
      'data/name_constraints_unittest/name-us-arizona-foo.com.pem',
      'data/name_constraints_unittest/name-us-arizona-ipv6.pem',
      'data/name_constraints_unittest/name-us-arizona-permitted.example.com.pem',
      'data/name_constraints_unittest/name-us-arizona.pem',
      'data/name_constraints_unittest/name-us-california-192.168.1.1.pem',
      'data/name_constraints_unittest/name-us-california-mountain_view.pem',
      'data/name_constraints_unittest/name-us-california-permitted.example.com.pem',
      'data/name_constraints_unittest/name-us-california.pem',
      'data/name_constraints_unittest/name-us.pem',
      'data/name_constraints_unittest/othername-excluded.pem',
      'data/name_constraints_unittest/othername-permitted.pem',
      'data/name_constraints_unittest/registeredid-excluded.pem',
      'data/name_constraints_unittest/registeredid-permitted.pem',
      'data/name_constraints_unittest/rfc822name-excluded.pem',
      'data/name_constraints_unittest/rfc822name-permitted.pem',
      'data/name_constraints_unittest/san-edipartyname.pem',
      'data/name_constraints_unittest/san-excluded-directoryname.pem',
      'data/name_constraints_unittest/san-excluded-dnsname.pem',
      'data/name_constraints_unittest/san-excluded-ipaddress.pem',
      'data/name_constraints_unittest/san-invalid-empty.pem',
      'data/name_constraints_unittest/san-invalid-ipaddress.pem',
      'data/name_constraints_unittest/san-othername.pem',
      'data/name_constraints_unittest/san-permitted.pem',
      'data/name_constraints_unittest/san-registeredid.pem',
      'data/name_constraints_unittest/san-rfc822name.pem',
      'data/name_constraints_unittest/san-uri.pem',
      'data/name_constraints_unittest/san-x400address.pem',
      'data/name_constraints_unittest/uri-excluded.pem',
      'data/name_constraints_unittest/uri-permitted.pem',
      'data/name_constraints_unittest/x400address-excluded.pem',
      'data/name_constraints_unittest/x400address-permitted.pem',
      'data/parse_certificate_unittest/basic_constraints_ca_false.pem',
      'data/parse_certificate_unittest/basic_constraints_ca_no_path.pem',
      'data/parse_certificate_unittest/basic_constraints_ca_path_9.pem',
      'data/parse_certificate_unittest/basic_constraints_negative_path.pem',
      'data/parse_certificate_unittest/basic_constraints_not_ca.pem',
      'data/parse_certificate_unittest/basic_constraints_path_too_large.pem',
      'data/parse_certificate_unittest/basic_constraints_pathlen_255.pem',
      'data/parse_certificate_unittest/basic_constraints_pathlen_256.pem',
      'data/parse_certificate_unittest/basic_constraints_pathlen_not_ca.pem',
      'data/parse_certificate_unittest/basic_constraints_unconsumed_data.pem',
      'data/parse_certificate_unittest/cert_algorithm_not_sequence.pem',
      'data/parse_certificate_unittest/cert_data_after_signature.pem',
      'data/parse_certificate_unittest/cert_empty_sequence.pem',
      'data/parse_certificate_unittest/cert_missing_signature.pem',
      'data/parse_certificate_unittest/cert_not_sequence.pem',
      'data/parse_certificate_unittest/cert_signature_not_bit_string.pem',
      'data/parse_certificate_unittest/cert_skeleton.pem',
      'data/parse_certificate_unittest/cert_version3.pem',
      'data/parse_certificate_unittest/extension_critical.pem',
      'data/parse_certificate_unittest/extension_critical_0.pem',
      'data/parse_certificate_unittest/extension_critical_3.pem',
      'data/parse_certificate_unittest/extension_not_critical.pem',
      'data/parse_certificate_unittest/extensions_basic_constraints.pem',
      'data/parse_certificate_unittest/extensions_data_after_sequence.pem',
      'data/parse_certificate_unittest/extensions_duplicate_key_usage.pem',
      'data/parse_certificate_unittest/extensions_empty_sequence.pem',
      'data/parse_certificate_unittest/extensions_extended_key_usage.pem',
      'data/parse_certificate_unittest/extensions_key_usage.pem',
      'data/parse_certificate_unittest/extensions_not_sequence.pem',
      'data/parse_certificate_unittest/extensions_policies.pem',
      'data/parse_certificate_unittest/extensions_real.pem',
      'data/parse_certificate_unittest/extensions_subject_alt_name.pem',
      'data/parse_certificate_unittest/extensions_unknown_critical.pem',
      'data/parse_certificate_unittest/extensions_unknown_non_critical.pem',
      'data/parse_certificate_unittest/tbs_explicit_v1.pem',
      'data/parse_certificate_unittest/tbs_negative_serial_number.pem',
      'data/parse_certificate_unittest/tbs_serial_number_21_octets_leading_0.pem',
      'data/parse_certificate_unittest/tbs_serial_number_26_octets.pem',
      'data/parse_certificate_unittest/tbs_v1.pem',
      'data/parse_certificate_unittest/tbs_v1_extensions.pem',
      'data/parse_certificate_unittest/tbs_v2_extensions.pem',
      'data/parse_certificate_unittest/tbs_v2_issuer_and_subject_unique_id.pem',
      'data/parse_certificate_unittest/tbs_v2_issuer_unique_id.pem',
      'data/parse_certificate_unittest/tbs_v2_no_optionals.pem',
      'data/parse_certificate_unittest/tbs_v3_all_optionals.pem',
      'data/parse_certificate_unittest/tbs_v3_data_after_extensions.pem',
      'data/parse_certificate_unittest/tbs_v3_extensions.pem',
      'data/parse_certificate_unittest/tbs_v3_extensions_not_sequence.pem',
      'data/parse_certificate_unittest/tbs_v3_no_optionals.pem',
      'data/parse_certificate_unittest/tbs_v3_real.pem',
      'data/parse_certificate_unittest/tbs_v4.pem',
      'data/parse_certificate_unittest/tbs_validity_both_generalized_time.pem',
      'data/parse_certificate_unittest/tbs_validity_both_utc_time.pem',
      'data/parse_certificate_unittest/tbs_validity_generalized_time_and_utc_time.pem',
      'data/parse_certificate_unittest/tbs_validity_relaxed.pem',
      'data/parse_certificate_unittest/tbs_validity_utc_time_and_generalized_time.pem',
      'data/parse_ocsp_unittest/bad_ocsp_type.pem',
      'data/parse_ocsp_unittest/bad_signature.pem',
      'data/parse_ocsp_unittest/bad_status.pem',
      'data/parse_ocsp_unittest/good_response.pem',
      'data/parse_ocsp_unittest/good_response_next_update.pem',
      'data/parse_ocsp_unittest/has_extension.pem',
      'data/parse_ocsp_unittest/has_single_extension.pem',
      'data/parse_ocsp_unittest/has_version.pem',
      'data/parse_ocsp_unittest/malformed_status.pem',
      'data/parse_ocsp_unittest/missing_response.pem',
      'data/parse_ocsp_unittest/multiple_response.pem',
      'data/parse_ocsp_unittest/no_response.pem',
      'data/parse_ocsp_unittest/ocsp_extra_certs.pem',
      'data/parse_ocsp_unittest/ocsp_sign_bad_indirect.pem',
      'data/parse_ocsp_unittest/ocsp_sign_direct.pem',
      'data/parse_ocsp_unittest/ocsp_sign_indirect.pem',
      'data/parse_ocsp_unittest/ocsp_sign_indirect_missing.pem',
      'data/parse_ocsp_unittest/other_response.pem',
      'data/parse_ocsp_unittest/responder_id.pem',
      'data/parse_ocsp_unittest/responder_name.pem',
      'data/parse_ocsp_unittest/revoke_response.pem',
      'data/parse_ocsp_unittest/revoke_response_reason.pem',
      'data/parse_ocsp_unittest/unknown_response.pem',
      'data/test.html',
      'data/url_request_unittest/308-without-location-header',
      'data/url_request_unittest/308-without-location-header.mock-http-headers',
      'data/url_request_unittest/BullRunSpeech.txt',
      'data/url_request_unittest/content-type-normalization.html',
      'data/url_request_unittest/content-type-normalization.html.mock-http-headers',
      'data/url_request_unittest/expect-ct-header.html',
      'data/url_request_unittest/expect-ct-header.html.mock-http-headers',
      'data/url_request_unittest/filedir-sentinel',
      'data/url_request_unittest/gzip-encoded',
      'data/url_request_unittest/gzip-encoded.mock-http-headers',
      'data/url_request_unittest/hpkp-headers-report-only.html',
      'data/url_request_unittest/hpkp-headers-report-only.html.mock-http-headers',
      'data/url_request_unittest/hpkp-headers.html',
      'data/url_request_unittest/hpkp-headers.html.mock-http-headers',
      'data/url_request_unittest/hsts-and-hpkp-headers.html',
      'data/url_request_unittest/hsts-and-hpkp-headers.html.mock-http-headers',
      'data/url_request_unittest/hsts-and-hpkp-headers2.html',
      'data/url_request_unittest/hsts-and-hpkp-headers2.html.mock-http-headers',
      'data/url_request_unittest/hsts-headers.html',
      'data/url_request_unittest/hsts-headers.html.mock-http-headers',
      'data/url_request_unittest/hsts-multiple-headers.html',
      'data/url_request_unittest/hsts-multiple-headers.html.mock-http-headers',
      'data/url_request_unittest/redirect-test.html',
      'data/url_request_unittest/redirect-test.html.mock-http-headers',
      'data/url_request_unittest/redirect-to-data.html',
      'data/url_request_unittest/redirect-to-data.html.mock-http-headers',
      'data/url_request_unittest/redirect-to-echoall',
      'data/url_request_unittest/redirect-to-echoall.mock-http-headers',
      'data/url_request_unittest/redirect-to-file.html',
      'data/url_request_unittest/redirect-to-file.html.mock-http-headers',
      'data/url_request_unittest/redirect-to-invalid-url.html',
      'data/url_request_unittest/redirect-to-invalid-url.html.mock-http-headers',
      'data/url_request_unittest/redirect301-to-echo',
      'data/url_request_unittest/redirect301-to-echo.mock-http-headers',
      'data/url_request_unittest/redirect301-to-https',
      'data/url_request_unittest/redirect301-to-https.mock-http-headers',
      'data/url_request_unittest/redirect302-to-echo',
      'data/url_request_unittest/redirect302-to-echo-cacheable',
      'data/url_request_unittest/redirect302-to-echo-cacheable.mock-http-headers',
      'data/url_request_unittest/redirect302-to-echo.mock-http-headers',
      'data/url_request_unittest/redirect302-to-https',
      'data/url_request_unittest/redirect302-to-https.mock-http-headers',
      'data/url_request_unittest/redirect303-to-echo',
      'data/url_request_unittest/redirect303-to-echo.mock-http-headers',
      'data/url_request_unittest/redirect303-to-https',
      'data/url_request_unittest/redirect303-to-https.mock-http-headers',
      'data/url_request_unittest/redirect307-to-echo',
      'data/url_request_unittest/redirect307-to-echo.mock-http-headers',
      'data/url_request_unittest/redirect307-to-https',
      'data/url_request_unittest/redirect307-to-https.mock-http-headers',
      'data/url_request_unittest/redirect308-to-echo',
      'data/url_request_unittest/redirect308-to-echo.mock-http-headers',
      'data/url_request_unittest/redirect308-to-https',
      'data/url_request_unittest/redirect308-to-https.mock-http-headers',
      'data/url_request_unittest/simple.html',
      'data/url_request_unittest/simple.html.mock-http-headers',
      'data/url_request_unittest/two-content-lengths.html',
      'data/url_request_unittest/two-content-lengths.html.mock-http-headers',
      'data/url_request_unittest/with-headers.html',
      'data/url_request_unittest/with-headers.html.mock-http-headers',
      'data/verify_certificate_chain_unittest/basic-constraints-pathlen-0-self-issued.pem',
      'data/verify_certificate_chain_unittest/constrained-non-self-signed-root.pem',
      'data/verify_certificate_chain_unittest/constrained-root-basic-constraints-ca-false.pem',
      'data/verify_certificate_chain_unittest/constrained-root-lacks-basic-constraints.pem',
      'data/verify_certificate_chain_unittest/expired-constrained-root.pem',
      'data/verify_certificate_chain_unittest/expired-intermediate.pem',
      'data/verify_certificate_chain_unittest/expired-target-notBefore.pem',
      'data/verify_certificate_chain_unittest/expired-target.pem',
      'data/verify_certificate_chain_unittest/expired-unconstrained-root.pem',
      'data/verify_certificate_chain_unittest/intermediate-basic-constraints-ca-false.pem',
      'data/verify_certificate_chain_unittest/intermediate-basic-constraints-not-critical.pem',
      'data/verify_certificate_chain_unittest/intermediate-lacks-basic-constraints.pem',
      'data/verify_certificate_chain_unittest/intermediate-lacks-signing-key-usage.pem',
      'data/verify_certificate_chain_unittest/intermediate-signed-with-md5.pem',
      'data/verify_certificate_chain_unittest/intermediate-unknown-critical-extension.pem',
      'data/verify_certificate_chain_unittest/intermediate-unknown-non-critical-extension.pem',
      'data/verify_certificate_chain_unittest/issuer-and-subject-not-byte-for-byte-equal-anchor.pem',
      'data/verify_certificate_chain_unittest/issuer-and-subject-not-byte-for-byte-equal.pem',
      'data/verify_certificate_chain_unittest/key-rollover-longrolloverchain.pem',
      'data/verify_certificate_chain_unittest/key-rollover-newchain.pem',
      'data/verify_certificate_chain_unittest/key-rollover-oldchain.pem',
      'data/verify_certificate_chain_unittest/key-rollover-rolloverchain.pem',
      'data/verify_certificate_chain_unittest/non-self-signed-root.pem',
      'data/verify_certificate_chain_unittest/target-and-intermediate.pem',
      'data/verify_certificate_chain_unittest/target-has-keycertsign-but-not-ca.pem',
      'data/verify_certificate_chain_unittest/target-has-pathlen-but-not-ca.pem',
      'data/verify_certificate_chain_unittest/target-not-end-entity.pem',
      'data/verify_certificate_chain_unittest/target-signed-by-512bit-rsa.pem',
      'data/verify_certificate_chain_unittest/target-signed-using-ecdsa.pem',
      'data/verify_certificate_chain_unittest/target-signed-with-md5.pem',
      'data/verify_certificate_chain_unittest/target-unknown-critical-extension.pem',
      'data/verify_certificate_chain_unittest/target-wrong-signature.pem',
      'data/verify_certificate_chain_unittest/unconstrained-non-self-signed-root.pem',
      'data/verify_certificate_chain_unittest/unconstrained-root-basic-constraints-ca-false.pem',
      'data/verify_certificate_chain_unittest/unconstrained-root-lacks-basic-constraints.pem',
      'data/verify_certificate_chain_unittest/unknown-root.pem',
      'data/verify_certificate_chain_unittest/violates-basic-constraints-pathlen-0.pem',
      'data/verify_certificate_chain_unittest/violates-pathlen-1-constrained-root.pem',
      'data/verify_certificate_chain_unittest/violates-pathlen-1-unconstrained-root.pem',
      'data/verify_name_match_unittest/names/ascii-BMPSTRING-case_swap-dupe_attr.pem',
      'data/verify_name_match_unittest/names/ascii-BMPSTRING-case_swap-extra_attr.pem',
      'data/verify_name_match_unittest/names/ascii-BMPSTRING-case_swap-extra_rdn.pem',
      'data/verify_name_match_unittest/names/ascii-BMPSTRING-case_swap.pem',
      'data/verify_name_match_unittest/names/ascii-BMPSTRING-extra_whitespace-dupe_attr.pem',
      'data/verify_name_match_unittest/names/ascii-BMPSTRING-extra_whitespace-extra_attr.pem',
      'data/verify_name_match_unittest/names/ascii-BMPSTRING-extra_whitespace-extra_rdn.pem',
      'data/verify_name_match_unittest/names/ascii-BMPSTRING-extra_whitespace.pem',
      'data/verify_name_match_unittest/names/ascii-BMPSTRING-unmangled-dupe_attr.pem',
      'data/verify_name_match_unittest/names/ascii-BMPSTRING-unmangled-extra_attr.pem',
      'data/verify_name_match_unittest/names/ascii-BMPSTRING-unmangled-extra_rdn.pem',
      'data/verify_name_match_unittest/names/ascii-BMPSTRING-unmangled.pem',
      'data/verify_name_match_unittest/names/ascii-PRINTABLESTRING-case_swap-dupe_attr.pem',
      'data/verify_name_match_unittest/names/ascii-PRINTABLESTRING-case_swap-extra_attr.pem',
      'data/verify_name_match_unittest/names/ascii-PRINTABLESTRING-case_swap-extra_rdn.pem',
      'data/verify_name_match_unittest/names/ascii-PRINTABLESTRING-case_swap.pem',
      'data/verify_name_match_unittest/names/ascii-PRINTABLESTRING-extra_whitespace-dupe_attr.pem',
      'data/verify_name_match_unittest/names/ascii-PRINTABLESTRING-extra_whitespace-extra_attr.pem',
      'data/verify_name_match_unittest/names/ascii-PRINTABLESTRING-extra_whitespace-extra_rdn.pem',
      'data/verify_name_match_unittest/names/ascii-PRINTABLESTRING-extra_whitespace.pem',
      'data/verify_name_match_unittest/names/ascii-PRINTABLESTRING-rdn_sorting_1.pem',
      'data/verify_name_match_unittest/names/ascii-PRINTABLESTRING-rdn_sorting_2.pem',
      'data/verify_name_match_unittest/names/ascii-PRINTABLESTRING-unmangled-dupe_attr.pem',
      'data/verify_name_match_unittest/names/ascii-PRINTABLESTRING-unmangled-extra_attr.pem',
      'data/verify_name_match_unittest/names/ascii-PRINTABLESTRING-unmangled-extra_rdn.pem',
      'data/verify_name_match_unittest/names/ascii-PRINTABLESTRING-unmangled.pem',
      'data/verify_name_match_unittest/names/ascii-T61STRING-case_swap-dupe_attr.pem',
      'data/verify_name_match_unittest/names/ascii-T61STRING-case_swap-extra_attr.pem',
      'data/verify_name_match_unittest/names/ascii-T61STRING-case_swap-extra_rdn.pem',
      'data/verify_name_match_unittest/names/ascii-T61STRING-case_swap.pem',
      'data/verify_name_match_unittest/names/ascii-T61STRING-extra_whitespace-dupe_attr.pem',
      'data/verify_name_match_unittest/names/ascii-T61STRING-extra_whitespace-extra_attr.pem',
      'data/verify_name_match_unittest/names/ascii-T61STRING-extra_whitespace-extra_rdn.pem',
      'data/verify_name_match_unittest/names/ascii-T61STRING-extra_whitespace.pem',
      'data/verify_name_match_unittest/names/ascii-T61STRING-unmangled-dupe_attr.pem',
      'data/verify_name_match_unittest/names/ascii-T61STRING-unmangled-extra_attr.pem',
      'data/verify_name_match_unittest/names/ascii-T61STRING-unmangled-extra_rdn.pem',
      'data/verify_name_match_unittest/names/ascii-T61STRING-unmangled.pem',
      'data/verify_name_match_unittest/names/ascii-UNIVERSALSTRING-case_swap-dupe_attr.pem',
      'data/verify_name_match_unittest/names/ascii-UNIVERSALSTRING-case_swap-extra_attr.pem',
      'data/verify_name_match_unittest/names/ascii-UNIVERSALSTRING-case_swap-extra_rdn.pem',
      'data/verify_name_match_unittest/names/ascii-UNIVERSALSTRING-case_swap.pem',
      'data/verify_name_match_unittest/names/ascii-UNIVERSALSTRING-extra_whitespace-dupe_attr.pem',
      'data/verify_name_match_unittest/names/ascii-UNIVERSALSTRING-extra_whitespace-extra_attr.pem',
      'data/verify_name_match_unittest/names/ascii-UNIVERSALSTRING-extra_whitespace-extra_rdn.pem',
      'data/verify_name_match_unittest/names/ascii-UNIVERSALSTRING-extra_whitespace.pem',
      'data/verify_name_match_unittest/names/ascii-UNIVERSALSTRING-unmangled-dupe_attr.pem',
      'data/verify_name_match_unittest/names/ascii-UNIVERSALSTRING-unmangled-extra_attr.pem',
      'data/verify_name_match_unittest/names/ascii-UNIVERSALSTRING-unmangled-extra_rdn.pem',
      'data/verify_name_match_unittest/names/ascii-UNIVERSALSTRING-unmangled.pem',
      'data/verify_name_match_unittest/names/ascii-UTF8-case_swap-dupe_attr.pem',
      'data/verify_name_match_unittest/names/ascii-UTF8-case_swap-extra_attr.pem',
      'data/verify_name_match_unittest/names/ascii-UTF8-case_swap-extra_rdn.pem',
      'data/verify_name_match_unittest/names/ascii-UTF8-case_swap.pem',
      'data/verify_name_match_unittest/names/ascii-UTF8-extra_whitespace-dupe_attr.pem',
      'data/verify_name_match_unittest/names/ascii-UTF8-extra_whitespace-extra_attr.pem',
      'data/verify_name_match_unittest/names/ascii-UTF8-extra_whitespace-extra_rdn.pem',
      'data/verify_name_match_unittest/names/ascii-UTF8-extra_whitespace.pem',
      'data/verify_name_match_unittest/names/ascii-UTF8-unmangled-dupe_attr.pem',
      'data/verify_name_match_unittest/names/ascii-UTF8-unmangled-extra_attr.pem',
      'data/verify_name_match_unittest/names/ascii-UTF8-unmangled-extra_rdn.pem',
      'data/verify_name_match_unittest/names/ascii-UTF8-unmangled.pem',
      'data/verify_name_match_unittest/names/ascii-mixed-rdn_dupetype_sorting_1.pem',
      'data/verify_name_match_unittest/names/ascii-mixed-rdn_dupetype_sorting_2.pem',
      'data/verify_name_match_unittest/names/invalid-AttributeTypeAndValue-badAttributeType.pem',
      'data/verify_name_match_unittest/names/invalid-AttributeTypeAndValue-empty.pem',
      'data/verify_name_match_unittest/names/invalid-AttributeTypeAndValue-extradata.pem',
      'data/verify_name_match_unittest/names/invalid-AttributeTypeAndValue-onlyOneElement.pem',
      'data/verify_name_match_unittest/names/invalid-AttributeTypeAndValue-setNotSequence.pem',
      'data/verify_name_match_unittest/names/invalid-Name-setInsteadOfSequence.pem',
      'data/verify_name_match_unittest/names/invalid-RDN-empty.pem',
      'data/verify_name_match_unittest/names/invalid-RDN-sequenceInsteadOfSet.pem',
      'data/verify_name_match_unittest/names/unicode-mixed-normalized.pem',
      'data/verify_name_match_unittest/names/unicode-mixed-unnormalized.pem',
      'data/verify_name_match_unittest/names/unicode_bmp-BMPSTRING-unmangled.pem',
      'data/verify_name_match_unittest/names/unicode_bmp-UNIVERSALSTRING-unmangled.pem',
      'data/verify_name_match_unittest/names/unicode_bmp-UTF8-unmangled.pem',
      'data/verify_name_match_unittest/names/unicode_supplementary-UNIVERSALSTRING-unmangled.pem',
      'data/verify_name_match_unittest/names/unicode_supplementary-UTF8-unmangled.pem',
      'data/verify_name_match_unittest/names/valid-Name-empty.pem',
      'data/verify_name_match_unittest/names/valid-minimal.pem',
      'data/verify_signed_data_unittest/ecdsa-prime256v1-sha512-spki-params-null.pem',
      'data/verify_signed_data_unittest/ecdsa-prime256v1-sha512-unused-bits-signature.pem',
      'data/verify_signed_data_unittest/ecdsa-prime256v1-sha512-using-ecdh-key.pem',
      'data/verify_signed_data_unittest/ecdsa-prime256v1-sha512-using-ecmqv-key.pem',
      'data/verify_signed_data_unittest/ecdsa-prime256v1-sha512-using-rsa-algorithm.pem',
      'data/verify_signed_data_unittest/ecdsa-prime256v1-sha512-wrong-signature-format.pem',
      'data/verify_signed_data_unittest/ecdsa-prime256v1-sha512.pem',
      'data/verify_signed_data_unittest/ecdsa-secp384r1-sha256-corrupted-data.pem',
      'data/verify_signed_data_unittest/ecdsa-secp384r1-sha256.pem',
      'data/verify_signed_data_unittest/ecdsa-using-rsa-key.pem',
      'data/verify_signed_data_unittest/rsa-pkcs1-sha1-bad-key-der-length.pem',
      'data/verify_signed_data_unittest/rsa-pkcs1-sha1-bad-key-der-null.pem',
      'data/verify_signed_data_unittest/rsa-pkcs1-sha1-key-params-absent.pem',
      'data/verify_signed_data_unittest/rsa-pkcs1-sha1-using-pss-key-no-params.pem',
      'data/verify_signed_data_unittest/rsa-pkcs1-sha1-wrong-algorithm.pem',
      'data/verify_signed_data_unittest/rsa-pkcs1-sha1.pem',
      'data/verify_signed_data_unittest/rsa-pkcs1-sha256-key-encoded-ber.pem',
      'data/verify_signed_data_unittest/rsa-pkcs1-sha256-spki-non-null-params.pem',
      'data/verify_signed_data_unittest/rsa-pkcs1-sha256-using-ecdsa-algorithm.pem',
      'data/verify_signed_data_unittest/rsa-pkcs1-sha256-using-id-ea-rsa.pem',
      'data/verify_signed_data_unittest/rsa-pkcs1-sha256.pem',
      'data/verify_signed_data_unittest/rsa-pss-sha1-salt20-using-pss-key-no-params.pem',
      'data/verify_signed_data_unittest/rsa-pss-sha1-salt20-using-pss-key-with-null-params.pem',
      'data/verify_signed_data_unittest/rsa-pss-sha1-salt20.pem',
      'data/verify_signed_data_unittest/rsa-pss-sha1-wrong-salt.pem',
      'data/verify_signed_data_unittest/rsa-pss-sha256-mgf1-sha512-salt33.pem',
      'data/verify_signed_data_unittest/rsa-pss-sha256-salt10-using-pss-key-with-params.pem',
      'data/verify_signed_data_unittest/rsa-pss-sha256-salt10-using-pss-key-with-wrong-params.pem',
      'data/verify_signed_data_unittest/rsa-pss-sha256-salt10.pem',
      'data/verify_signed_data_unittest/rsa-using-ec-key.pem',
      'data/verify_signed_data_unittest/rsa2048-pkcs1-sha512.pem',
      'third_party/nist-pkits/certs/AllCertificatesNoPoliciesTest2EE.crt',
      'third_party/nist-pkits/certs/AllCertificatesSamePoliciesTest10EE.crt',
      'third_party/nist-pkits/certs/AllCertificatesSamePoliciesTest13EE.crt',
      'third_party/nist-pkits/certs/AllCertificatesanyPolicyTest11EE.crt',
      'third_party/nist-pkits/certs/AnyPolicyTest14EE.crt',
      'third_party/nist-pkits/certs/BadCRLIssuerNameCACert.crt',
      'third_party/nist-pkits/certs/BadCRLSignatureCACert.crt',
      'third_party/nist-pkits/certs/BadSignedCACert.crt',
      'third_party/nist-pkits/certs/BadnotAfterDateCACert.crt',
      'third_party/nist-pkits/certs/BadnotBeforeDateCACert.crt',
      'third_party/nist-pkits/certs/BasicSelfIssuedCRLSigningKeyCACert.crt',
      'third_party/nist-pkits/certs/BasicSelfIssuedCRLSigningKeyCRLCert.crt',
      'third_party/nist-pkits/certs/BasicSelfIssuedNewKeyCACert.crt',
      'third_party/nist-pkits/certs/BasicSelfIssuedNewKeyOldWithNewCACert.crt',
      'third_party/nist-pkits/certs/BasicSelfIssuedOldKeyCACert.crt',
      'third_party/nist-pkits/certs/BasicSelfIssuedOldKeyNewWithOldCACert.crt',
      'third_party/nist-pkits/certs/CPSPointerQualifierTest20EE.crt',
      'third_party/nist-pkits/certs/DSACACert.crt',
      'third_party/nist-pkits/certs/DSAParametersInheritedCACert.crt',
      'third_party/nist-pkits/certs/DifferentPoliciesTest12EE.crt',
      'third_party/nist-pkits/certs/DifferentPoliciesTest3EE.crt',
      'third_party/nist-pkits/certs/DifferentPoliciesTest4EE.crt',
      'third_party/nist-pkits/certs/DifferentPoliciesTest5EE.crt',
      'third_party/nist-pkits/certs/DifferentPoliciesTest7EE.crt',
      'third_party/nist-pkits/certs/DifferentPoliciesTest8EE.crt',
      'third_party/nist-pkits/certs/DifferentPoliciesTest9EE.crt',
      'third_party/nist-pkits/certs/GeneralizedTimeCRLnextUpdateCACert.crt',
      'third_party/nist-pkits/certs/GoodCACert.crt',
      'third_party/nist-pkits/certs/GoodsubCACert.crt',
      'third_party/nist-pkits/certs/GoodsubCAPanyPolicyMapping1to2CACert.crt',
      'third_party/nist-pkits/certs/InvalidBadCRLIssuerNameTest5EE.crt',
      'third_party/nist-pkits/certs/InvalidBadCRLSignatureTest4EE.crt',
      'third_party/nist-pkits/certs/InvalidBasicSelfIssuedCRLSigningKeyTest7EE.crt',
      'third_party/nist-pkits/certs/InvalidBasicSelfIssuedCRLSigningKeyTest8EE.crt',
      'third_party/nist-pkits/certs/InvalidBasicSelfIssuedNewWithOldTest5EE.crt',
      'third_party/nist-pkits/certs/InvalidBasicSelfIssuedOldWithNewTest2EE.crt',
      'third_party/nist-pkits/certs/InvalidCASignatureTest2EE.crt',
      'third_party/nist-pkits/certs/InvalidCAnotAfterDateTest5EE.crt',
      'third_party/nist-pkits/certs/InvalidCAnotBeforeDateTest1EE.crt',
      'third_party/nist-pkits/certs/InvalidDNSnameConstraintsTest31EE.crt',
      'third_party/nist-pkits/certs/InvalidDNSnameConstraintsTest33EE.crt',
      'third_party/nist-pkits/certs/InvalidDNSnameConstraintsTest38EE.crt',
      'third_party/nist-pkits/certs/InvalidDNandRFC822nameConstraintsTest28EE.crt',
      'third_party/nist-pkits/certs/InvalidDNandRFC822nameConstraintsTest29EE.crt',
      'third_party/nist-pkits/certs/InvalidDNnameConstraintsTest10EE.crt',
      'third_party/nist-pkits/certs/InvalidDNnameConstraintsTest12EE.crt',
      'third_party/nist-pkits/certs/InvalidDNnameConstraintsTest13EE.crt',
      'third_party/nist-pkits/certs/InvalidDNnameConstraintsTest15EE.crt',
      'third_party/nist-pkits/certs/InvalidDNnameConstraintsTest16EE.crt',
      'third_party/nist-pkits/certs/InvalidDNnameConstraintsTest17EE.crt',
      'third_party/nist-pkits/certs/InvalidDNnameConstraintsTest20EE.crt',
      'third_party/nist-pkits/certs/InvalidDNnameConstraintsTest2EE.crt',
      'third_party/nist-pkits/certs/InvalidDNnameConstraintsTest3EE.crt',
      'third_party/nist-pkits/certs/InvalidDNnameConstraintsTest7EE.crt',
      'third_party/nist-pkits/certs/InvalidDNnameConstraintsTest8EE.crt',
      'third_party/nist-pkits/certs/InvalidDNnameConstraintsTest9EE.crt',
      'third_party/nist-pkits/certs/InvalidDSASignatureTest6EE.crt',
      'third_party/nist-pkits/certs/InvalidEESignatureTest3EE.crt',
      'third_party/nist-pkits/certs/InvalidEEnotAfterDateTest6EE.crt',
      'third_party/nist-pkits/certs/InvalidEEnotBeforeDateTest2EE.crt',
      'third_party/nist-pkits/certs/InvalidIDPwithindirectCRLTest23EE.crt',
      'third_party/nist-pkits/certs/InvalidIDPwithindirectCRLTest26EE.crt',
      'third_party/nist-pkits/certs/InvalidLongSerialNumberTest18EE.crt',
      'third_party/nist-pkits/certs/InvalidMappingFromanyPolicyTest7EE.crt',
      'third_party/nist-pkits/certs/InvalidMappingToanyPolicyTest8EE.crt',
      'third_party/nist-pkits/certs/InvalidMissingCRLTest1EE.crt',
      'third_party/nist-pkits/certs/InvalidMissingbasicConstraintsTest1EE.crt',
      'third_party/nist-pkits/certs/InvalidNameChainingOrderTest2EE.crt',
      'third_party/nist-pkits/certs/InvalidNameChainingTest1EE.crt',
      'third_party/nist-pkits/certs/InvalidNegativeSerialNumberTest15EE.crt',
      'third_party/nist-pkits/certs/InvalidOldCRLnextUpdateTest11EE.crt',
      'third_party/nist-pkits/certs/InvalidPolicyMappingTest10EE.crt',
      'third_party/nist-pkits/certs/InvalidPolicyMappingTest2EE.crt',
      'third_party/nist-pkits/certs/InvalidPolicyMappingTest4EE.crt',
      'third_party/nist-pkits/certs/InvalidRFC822nameConstraintsTest22EE.crt',
      'third_party/nist-pkits/certs/InvalidRFC822nameConstraintsTest24EE.crt',
      'third_party/nist-pkits/certs/InvalidRFC822nameConstraintsTest26EE.crt',
      'third_party/nist-pkits/certs/InvalidRevokedCATest2EE.crt',
      'third_party/nist-pkits/certs/InvalidRevokedEETest3EE.crt',
      'third_party/nist-pkits/certs/InvalidSelfIssuedinhibitAnyPolicyTest10EE.crt',
      'third_party/nist-pkits/certs/InvalidSelfIssuedinhibitAnyPolicyTest8EE.crt',
      'third_party/nist-pkits/certs/InvalidSelfIssuedinhibitPolicyMappingTest10EE.crt',
      'third_party/nist-pkits/certs/InvalidSelfIssuedinhibitPolicyMappingTest11EE.crt',
      'third_party/nist-pkits/certs/InvalidSelfIssuedinhibitPolicyMappingTest8EE.crt',
      'third_party/nist-pkits/certs/InvalidSelfIssuedinhibitPolicyMappingTest9EE.crt',
      'third_party/nist-pkits/certs/InvalidSelfIssuedpathLenConstraintTest16EE.crt',
      'third_party/nist-pkits/certs/InvalidSelfIssuedrequireExplicitPolicyTest7EE.crt',
      'third_party/nist-pkits/certs/InvalidSelfIssuedrequireExplicitPolicyTest8EE.crt',
      'third_party/nist-pkits/certs/InvalidSeparateCertificateandCRLKeysTest20EE.crt',
      'third_party/nist-pkits/certs/InvalidSeparateCertificateandCRLKeysTest21EE.crt',
      'third_party/nist-pkits/certs/InvalidURInameConstraintsTest35EE.crt',
      'third_party/nist-pkits/certs/InvalidURInameConstraintsTest37EE.crt',
      'third_party/nist-pkits/certs/InvalidUnknownCRLEntryExtensionTest8EE.crt',
      'third_party/nist-pkits/certs/InvalidUnknownCRLExtensionTest10EE.crt',
      'third_party/nist-pkits/certs/InvalidUnknownCRLExtensionTest9EE.crt',
      'third_party/nist-pkits/certs/InvalidUnknownCriticalCertificateExtensionTest2EE.crt',
      'third_party/nist-pkits/certs/InvalidWrongCRLTest6EE.crt',
      'third_party/nist-pkits/certs/InvalidcAFalseTest2EE.crt',
      'third_party/nist-pkits/certs/InvalidcAFalseTest3EE.crt',
      'third_party/nist-pkits/certs/InvalidcRLIssuerTest27EE.crt',
      'third_party/nist-pkits/certs/InvalidcRLIssuerTest31EE.crt',
      'third_party/nist-pkits/certs/InvalidcRLIssuerTest32EE.crt',
      'third_party/nist-pkits/certs/InvalidcRLIssuerTest34EE.crt',
      'third_party/nist-pkits/certs/InvalidcRLIssuerTest35EE.crt',
      'third_party/nist-pkits/certs/InvaliddeltaCRLIndicatorNoBaseTest1EE.crt',
      'third_party/nist-pkits/certs/InvaliddeltaCRLTest10EE.crt',
      'third_party/nist-pkits/certs/InvaliddeltaCRLTest3EE.crt',
      'third_party/nist-pkits/certs/InvaliddeltaCRLTest4EE.crt',
      'third_party/nist-pkits/certs/InvaliddeltaCRLTest6EE.crt',
      'third_party/nist-pkits/certs/InvaliddeltaCRLTest9EE.crt',
      'third_party/nist-pkits/certs/InvaliddistributionPointTest2EE.crt',
      'third_party/nist-pkits/certs/InvaliddistributionPointTest3EE.crt',
      'third_party/nist-pkits/certs/InvaliddistributionPointTest6EE.crt',
      'third_party/nist-pkits/certs/InvaliddistributionPointTest8EE.crt',
      'third_party/nist-pkits/certs/InvaliddistributionPointTest9EE.crt',
      'third_party/nist-pkits/certs/InvalidinhibitAnyPolicyTest1EE.crt',
      'third_party/nist-pkits/certs/InvalidinhibitAnyPolicyTest4EE.crt',
      'third_party/nist-pkits/certs/InvalidinhibitAnyPolicyTest5EE.crt',
      'third_party/nist-pkits/certs/InvalidinhibitAnyPolicyTest6EE.crt',
      'third_party/nist-pkits/certs/InvalidinhibitPolicyMappingTest1EE.crt',
      'third_party/nist-pkits/certs/InvalidinhibitPolicyMappingTest3EE.crt',
      'third_party/nist-pkits/certs/InvalidinhibitPolicyMappingTest5EE.crt',
      'third_party/nist-pkits/certs/InvalidinhibitPolicyMappingTest6EE.crt',
      'third_party/nist-pkits/certs/InvalidkeyUsageCriticalcRLSignFalseTest4EE.crt',
      'third_party/nist-pkits/certs/InvalidkeyUsageCriticalkeyCertSignFalseTest1EE.crt',
      'third_party/nist-pkits/certs/InvalidkeyUsageNotCriticalcRLSignFalseTest5EE.crt',
      'third_party/nist-pkits/certs/InvalidkeyUsageNotCriticalkeyCertSignFalseTest2EE.crt',
      'third_party/nist-pkits/certs/InvalidonlyContainsAttributeCertsTest14EE.crt',
      'third_party/nist-pkits/certs/InvalidonlyContainsCACertsTest12EE.crt',
      'third_party/nist-pkits/certs/InvalidonlyContainsUserCertsTest11EE.crt',
      'third_party/nist-pkits/certs/InvalidonlySomeReasonsTest15EE.crt',
      'third_party/nist-pkits/certs/InvalidonlySomeReasonsTest16EE.crt',
      'third_party/nist-pkits/certs/InvalidonlySomeReasonsTest17EE.crt',
      'third_party/nist-pkits/certs/InvalidonlySomeReasonsTest20EE.crt',
      'third_party/nist-pkits/certs/InvalidonlySomeReasonsTest21EE.crt',
      'third_party/nist-pkits/certs/InvalidpathLenConstraintTest10EE.crt',
      'third_party/nist-pkits/certs/InvalidpathLenConstraintTest11EE.crt',
      'third_party/nist-pkits/certs/InvalidpathLenConstraintTest12EE.crt',
      'third_party/nist-pkits/certs/InvalidpathLenConstraintTest5EE.crt',
      'third_party/nist-pkits/certs/InvalidpathLenConstraintTest6EE.crt',
      'third_party/nist-pkits/certs/InvalidpathLenConstraintTest9EE.crt',
      'third_party/nist-pkits/certs/Invalidpre2000CRLnextUpdateTest12EE.crt',
      'third_party/nist-pkits/certs/Invalidpre2000UTCEEnotAfterDateTest7EE.crt',
      'third_party/nist-pkits/certs/InvalidrequireExplicitPolicyTest3EE.crt',
      'third_party/nist-pkits/certs/InvalidrequireExplicitPolicyTest5EE.crt',
      'third_party/nist-pkits/certs/LongSerialNumberCACert.crt',
      'third_party/nist-pkits/certs/Mapping1to2CACert.crt',
      'third_party/nist-pkits/certs/MappingFromanyPolicyCACert.crt',
      'third_party/nist-pkits/certs/MappingToanyPolicyCACert.crt',
      'third_party/nist-pkits/certs/MissingbasicConstraintsCACert.crt',
      'third_party/nist-pkits/certs/NameOrderingCACert.crt',
      'third_party/nist-pkits/certs/NegativeSerialNumberCACert.crt',
      'third_party/nist-pkits/certs/NoCRLCACert.crt',
      'third_party/nist-pkits/certs/NoPoliciesCACert.crt',
      'third_party/nist-pkits/certs/NoissuingDistributionPointCACert.crt',
      'third_party/nist-pkits/certs/OldCRLnextUpdateCACert.crt',
      'third_party/nist-pkits/certs/OverlappingPoliciesTest6EE.crt',
      'third_party/nist-pkits/certs/P12Mapping1to3CACert.crt',
      'third_party/nist-pkits/certs/P12Mapping1to3subCACert.crt',
      'third_party/nist-pkits/certs/P12Mapping1to3subsubCACert.crt',
      'third_party/nist-pkits/certs/P1Mapping1to234CACert.crt',
      'third_party/nist-pkits/certs/P1Mapping1to234subCACert.crt',
      'third_party/nist-pkits/certs/P1anyPolicyMapping1to2CACert.crt',
      'third_party/nist-pkits/certs/PanyPolicyMapping1to2CACert.crt',
      'third_party/nist-pkits/certs/PoliciesP1234CACert.crt',
      'third_party/nist-pkits/certs/PoliciesP1234subCAP123Cert.crt',
      'third_party/nist-pkits/certs/PoliciesP1234subsubCAP123P12Cert.crt',
      'third_party/nist-pkits/certs/PoliciesP123CACert.crt',
      'third_party/nist-pkits/certs/PoliciesP123subCAP12Cert.crt',
      'third_party/nist-pkits/certs/PoliciesP123subsubCAP12P1Cert.crt',
      'third_party/nist-pkits/certs/PoliciesP123subsubCAP12P2Cert.crt',
      'third_party/nist-pkits/certs/PoliciesP123subsubsubCAP12P2P1Cert.crt',
      'third_party/nist-pkits/certs/PoliciesP12CACert.crt',
      'third_party/nist-pkits/certs/PoliciesP12subCAP1Cert.crt',
      'third_party/nist-pkits/certs/PoliciesP12subsubCAP1P2Cert.crt',
      'third_party/nist-pkits/certs/PoliciesP2subCA2Cert.crt',
      'third_party/nist-pkits/certs/PoliciesP2subCACert.crt',
      'third_party/nist-pkits/certs/PoliciesP3CACert.crt',
      'third_party/nist-pkits/certs/RFC3280MandatoryAttributeTypesCACert.crt',
      'third_party/nist-pkits/certs/RFC3280OptionalAttributeTypesCACert.crt',
      'third_party/nist-pkits/certs/RevokedsubCACert.crt',
      'third_party/nist-pkits/certs/RolloverfromPrintableStringtoUTF8StringCACert.crt',
      'third_party/nist-pkits/certs/SeparateCertificateandCRLKeysCA2CRLSigningCert.crt',
      'third_party/nist-pkits/certs/SeparateCertificateandCRLKeysCA2CertificateSigningCACert.crt',
      'third_party/nist-pkits/certs/SeparateCertificateandCRLKeysCRLSigningCert.crt',
      'third_party/nist-pkits/certs/SeparateCertificateandCRLKeysCertificateSigningCACert.crt',
      'third_party/nist-pkits/certs/TrustAnchorRootCertificate.crt',
      'third_party/nist-pkits/certs/TwoCRLsCACert.crt',
      'third_party/nist-pkits/certs/UIDCACert.crt',
      'third_party/nist-pkits/certs/UTF8StringCaseInsensitiveMatchCACert.crt',
      'third_party/nist-pkits/certs/UTF8StringEncodedNamesCACert.crt',
      'third_party/nist-pkits/certs/UnknownCRLEntryExtensionCACert.crt',
      'third_party/nist-pkits/certs/UnknownCRLExtensionCACert.crt',
      'third_party/nist-pkits/certs/UserNoticeQualifierTest15EE.crt',
      'third_party/nist-pkits/certs/UserNoticeQualifierTest16EE.crt',
      'third_party/nist-pkits/certs/UserNoticeQualifierTest17EE.crt',
      'third_party/nist-pkits/certs/UserNoticeQualifierTest18EE.crt',
      'third_party/nist-pkits/certs/UserNoticeQualifierTest19EE.crt',
      'third_party/nist-pkits/certs/ValidBasicSelfIssuedCRLSigningKeyTest6EE.crt',
      'third_party/nist-pkits/certs/ValidBasicSelfIssuedNewWithOldTest3EE.crt',
      'third_party/nist-pkits/certs/ValidBasicSelfIssuedNewWithOldTest4EE.crt',
      'third_party/nist-pkits/certs/ValidBasicSelfIssuedOldWithNewTest1EE.crt',
      'third_party/nist-pkits/certs/ValidCertificatePathTest1EE.crt',
      'third_party/nist-pkits/certs/ValidDNSnameConstraintsTest30EE.crt',
      'third_party/nist-pkits/certs/ValidDNSnameConstraintsTest32EE.crt',
      'third_party/nist-pkits/certs/ValidDNandRFC822nameConstraintsTest27EE.crt',
      'third_party/nist-pkits/certs/ValidDNnameConstraintsTest11EE.crt',
      'third_party/nist-pkits/certs/ValidDNnameConstraintsTest14EE.crt',
      'third_party/nist-pkits/certs/ValidDNnameConstraintsTest18EE.crt',
      'third_party/nist-pkits/certs/ValidDNnameConstraintsTest19EE.crt',
      'third_party/nist-pkits/certs/ValidDNnameConstraintsTest1EE.crt',
      'third_party/nist-pkits/certs/ValidDNnameConstraintsTest4EE.crt',
      'third_party/nist-pkits/certs/ValidDNnameConstraintsTest5EE.crt',
      'third_party/nist-pkits/certs/ValidDNnameConstraintsTest6EE.crt',
      'third_party/nist-pkits/certs/ValidDSAParameterInheritanceTest5EE.crt',
      'third_party/nist-pkits/certs/ValidDSASignaturesTest4EE.crt',
      'third_party/nist-pkits/certs/ValidGeneralizedTimeCRLnextUpdateTest13EE.crt',
      'third_party/nist-pkits/certs/ValidGeneralizedTimenotAfterDateTest8EE.crt',
      'third_party/nist-pkits/certs/ValidGeneralizedTimenotBeforeDateTest4EE.crt',
      'third_party/nist-pkits/certs/ValidIDPwithindirectCRLTest22EE.crt',
      'third_party/nist-pkits/certs/ValidIDPwithindirectCRLTest24EE.crt',
      'third_party/nist-pkits/certs/ValidIDPwithindirectCRLTest25EE.crt',
      'third_party/nist-pkits/certs/ValidLongSerialNumberTest16EE.crt',
      'third_party/nist-pkits/certs/ValidLongSerialNumberTest17EE.crt',
      'third_party/nist-pkits/certs/ValidNameChainingCapitalizationTest5EE.crt',
      'third_party/nist-pkits/certs/ValidNameChainingWhitespaceTest3EE.crt',
      'third_party/nist-pkits/certs/ValidNameChainingWhitespaceTest4EE.crt',
      'third_party/nist-pkits/certs/ValidNameUIDsTest6EE.crt',
      'third_party/nist-pkits/certs/ValidNegativeSerialNumberTest14EE.crt',
      'third_party/nist-pkits/certs/ValidNoissuingDistributionPointTest10EE.crt',
      'third_party/nist-pkits/certs/ValidPolicyMappingTest11EE.crt',
      'third_party/nist-pkits/certs/ValidPolicyMappingTest12EE.crt',
      'third_party/nist-pkits/certs/ValidPolicyMappingTest13EE.crt',
      'third_party/nist-pkits/certs/ValidPolicyMappingTest14EE.crt',
      'third_party/nist-pkits/certs/ValidPolicyMappingTest1EE.crt',
      'third_party/nist-pkits/certs/ValidPolicyMappingTest3EE.crt',
      'third_party/nist-pkits/certs/ValidPolicyMappingTest5EE.crt',
      'third_party/nist-pkits/certs/ValidPolicyMappingTest6EE.crt',
      'third_party/nist-pkits/certs/ValidPolicyMappingTest9EE.crt',
      'third_party/nist-pkits/certs/ValidRFC3280MandatoryAttributeTypesTest7EE.crt',
      'third_party/nist-pkits/certs/ValidRFC3280OptionalAttributeTypesTest8EE.crt',
      'third_party/nist-pkits/certs/ValidRFC822nameConstraintsTest21EE.crt',
      'third_party/nist-pkits/certs/ValidRFC822nameConstraintsTest23EE.crt',
      'third_party/nist-pkits/certs/ValidRFC822nameConstraintsTest25EE.crt',
      'third_party/nist-pkits/certs/ValidRolloverfromPrintableStringtoUTF8StringTest10EE.crt',
      'third_party/nist-pkits/certs/ValidSelfIssuedinhibitAnyPolicyTest7EE.crt',
      'third_party/nist-pkits/certs/ValidSelfIssuedinhibitAnyPolicyTest9EE.crt',
      'third_party/nist-pkits/certs/ValidSelfIssuedinhibitPolicyMappingTest7EE.crt',
      'third_party/nist-pkits/certs/ValidSelfIssuedpathLenConstraintTest15EE.crt',
      'third_party/nist-pkits/certs/ValidSelfIssuedpathLenConstraintTest17EE.crt',
      'third_party/nist-pkits/certs/ValidSelfIssuedrequireExplicitPolicyTest6EE.crt',
      'third_party/nist-pkits/certs/ValidSeparateCertificateandCRLKeysTest19EE.crt',
      'third_party/nist-pkits/certs/ValidTwoCRLsTest7EE.crt',
      'third_party/nist-pkits/certs/ValidURInameConstraintsTest34EE.crt',
      'third_party/nist-pkits/certs/ValidURInameConstraintsTest36EE.crt',
      'third_party/nist-pkits/certs/ValidUTF8StringCaseInsensitiveMatchTest11EE.crt',
      'third_party/nist-pkits/certs/ValidUTF8StringEncodedNamesTest9EE.crt',
      'third_party/nist-pkits/certs/ValidUnknownNotCriticalCertificateExtensionTest1EE.crt',
      'third_party/nist-pkits/certs/ValidbasicConstraintsNotCriticalTest4EE.crt',
      'third_party/nist-pkits/certs/ValidcRLIssuerTest28EE.crt',
      'third_party/nist-pkits/certs/ValidcRLIssuerTest29EE.crt',
      'third_party/nist-pkits/certs/ValidcRLIssuerTest30EE.crt',
      'third_party/nist-pkits/certs/ValidcRLIssuerTest33EE.crt',
      'third_party/nist-pkits/certs/ValiddeltaCRLTest2EE.crt',
      'third_party/nist-pkits/certs/ValiddeltaCRLTest5EE.crt',
      'third_party/nist-pkits/certs/ValiddeltaCRLTest7EE.crt',
      'third_party/nist-pkits/certs/ValiddeltaCRLTest8EE.crt',
      'third_party/nist-pkits/certs/ValiddistributionPointTest1EE.crt',
      'third_party/nist-pkits/certs/ValiddistributionPointTest4EE.crt',
      'third_party/nist-pkits/certs/ValiddistributionPointTest5EE.crt',
      'third_party/nist-pkits/certs/ValiddistributionPointTest7EE.crt',
      'third_party/nist-pkits/certs/ValidinhibitAnyPolicyTest2EE.crt',
      'third_party/nist-pkits/certs/ValidinhibitPolicyMappingTest2EE.crt',
      'third_party/nist-pkits/certs/ValidinhibitPolicyMappingTest4EE.crt',
      'third_party/nist-pkits/certs/ValidkeyUsageNotCriticalTest3EE.crt',
      'third_party/nist-pkits/certs/ValidonlyContainsCACertsTest13EE.crt',
      'third_party/nist-pkits/certs/ValidonlySomeReasonsTest18EE.crt',
      'third_party/nist-pkits/certs/ValidonlySomeReasonsTest19EE.crt',
      'third_party/nist-pkits/certs/ValidpathLenConstraintTest13EE.crt',
      'third_party/nist-pkits/certs/ValidpathLenConstraintTest14EE.crt',
      'third_party/nist-pkits/certs/ValidpathLenConstraintTest7EE.crt',
      'third_party/nist-pkits/certs/ValidpathLenConstraintTest8EE.crt',
      'third_party/nist-pkits/certs/Validpre2000UTCnotBeforeDateTest3EE.crt',
      'third_party/nist-pkits/certs/ValidrequireExplicitPolicyTest1EE.crt',
      'third_party/nist-pkits/certs/ValidrequireExplicitPolicyTest2EE.crt',
      'third_party/nist-pkits/certs/ValidrequireExplicitPolicyTest4EE.crt',
      'third_party/nist-pkits/certs/WrongCRLCACert.crt',
      'third_party/nist-pkits/certs/anyPolicyCACert.crt',
      'third_party/nist-pkits/certs/basicConstraintsCriticalcAFalseCACert.crt',
      'third_party/nist-pkits/certs/basicConstraintsNotCriticalCACert.crt',
      'third_party/nist-pkits/certs/basicConstraintsNotCriticalcAFalseCACert.crt',
      'third_party/nist-pkits/certs/deltaCRLCA1Cert.crt',
      'third_party/nist-pkits/certs/deltaCRLCA2Cert.crt',
      'third_party/nist-pkits/certs/deltaCRLCA3Cert.crt',
      'third_party/nist-pkits/certs/deltaCRLIndicatorNoBaseCACert.crt',
      'third_party/nist-pkits/certs/distributionPoint1CACert.crt',
      'third_party/nist-pkits/certs/distributionPoint2CACert.crt',
      'third_party/nist-pkits/certs/indirectCRLCA1Cert.crt',
      'third_party/nist-pkits/certs/indirectCRLCA2Cert.crt',
      'third_party/nist-pkits/certs/indirectCRLCA3Cert.crt',
      'third_party/nist-pkits/certs/indirectCRLCA3cRLIssuerCert.crt',
      'third_party/nist-pkits/certs/indirectCRLCA4Cert.crt',
      'third_party/nist-pkits/certs/indirectCRLCA4cRLIssuerCert.crt',
      'third_party/nist-pkits/certs/indirectCRLCA5Cert.crt',
      'third_party/nist-pkits/certs/indirectCRLCA6Cert.crt',
      'third_party/nist-pkits/certs/inhibitAnyPolicy0CACert.crt',
      'third_party/nist-pkits/certs/inhibitAnyPolicy1CACert.crt',
      'third_party/nist-pkits/certs/inhibitAnyPolicy1SelfIssuedCACert.crt',
      'third_party/nist-pkits/certs/inhibitAnyPolicy1SelfIssuedsubCA2Cert.crt',
      'third_party/nist-pkits/certs/inhibitAnyPolicy1subCA1Cert.crt',
      'third_party/nist-pkits/certs/inhibitAnyPolicy1subCA2Cert.crt',
      'third_party/nist-pkits/certs/inhibitAnyPolicy1subCAIAP5Cert.crt',
      'third_party/nist-pkits/certs/inhibitAnyPolicy1subsubCA2Cert.crt',
      'third_party/nist-pkits/certs/inhibitAnyPolicy5CACert.crt',
      'third_party/nist-pkits/certs/inhibitAnyPolicy5subCACert.crt',
      'third_party/nist-pkits/certs/inhibitAnyPolicy5subsubCACert.crt',
      'third_party/nist-pkits/certs/inhibitAnyPolicyTest3EE.crt',
      'third_party/nist-pkits/certs/inhibitPolicyMapping0CACert.crt',
      'third_party/nist-pkits/certs/inhibitPolicyMapping0subCACert.crt',
      'third_party/nist-pkits/certs/inhibitPolicyMapping1P12CACert.crt',
      'third_party/nist-pkits/certs/inhibitPolicyMapping1P12subCACert.crt',
      'third_party/nist-pkits/certs/inhibitPolicyMapping1P12subCAIPM5Cert.crt',
      'third_party/nist-pkits/certs/inhibitPolicyMapping1P12subsubCACert.crt',
      'third_party/nist-pkits/certs/inhibitPolicyMapping1P12subsubCAIPM5Cert.crt',
      'third_party/nist-pkits/certs/inhibitPolicyMapping1P1CACert.crt',
      'third_party/nist-pkits/certs/inhibitPolicyMapping1P1SelfIssuedCACert.crt',
      'third_party/nist-pkits/certs/inhibitPolicyMapping1P1SelfIssuedsubCACert.crt',
      'third_party/nist-pkits/certs/inhibitPolicyMapping1P1subCACert.crt',
      'third_party/nist-pkits/certs/inhibitPolicyMapping1P1subsubCACert.crt',
      'third_party/nist-pkits/certs/inhibitPolicyMapping5CACert.crt',
      'third_party/nist-pkits/certs/inhibitPolicyMapping5subCACert.crt',
      'third_party/nist-pkits/certs/inhibitPolicyMapping5subsubCACert.crt',
      'third_party/nist-pkits/certs/inhibitPolicyMapping5subsubsubCACert.crt',
      'third_party/nist-pkits/certs/keyUsageCriticalcRLSignFalseCACert.crt',
      'third_party/nist-pkits/certs/keyUsageCriticalkeyCertSignFalseCACert.crt',
      'third_party/nist-pkits/certs/keyUsageNotCriticalCACert.crt',
      'third_party/nist-pkits/certs/keyUsageNotCriticalcRLSignFalseCACert.crt',
      'third_party/nist-pkits/certs/keyUsageNotCriticalkeyCertSignFalseCACert.crt',
      'third_party/nist-pkits/certs/nameConstraintsDN1CACert.crt',
      'third_party/nist-pkits/certs/nameConstraintsDN1SelfIssuedCACert.crt',
      'third_party/nist-pkits/certs/nameConstraintsDN1subCA1Cert.crt',
      'third_party/nist-pkits/certs/nameConstraintsDN1subCA2Cert.crt',
      'third_party/nist-pkits/certs/nameConstraintsDN1subCA3Cert.crt',
      'third_party/nist-pkits/certs/nameConstraintsDN2CACert.crt',
      'third_party/nist-pkits/certs/nameConstraintsDN3CACert.crt',
      'third_party/nist-pkits/certs/nameConstraintsDN3subCA1Cert.crt',
      'third_party/nist-pkits/certs/nameConstraintsDN3subCA2Cert.crt',
      'third_party/nist-pkits/certs/nameConstraintsDN4CACert.crt',
      'third_party/nist-pkits/certs/nameConstraintsDN5CACert.crt',
      'third_party/nist-pkits/certs/nameConstraintsDNS1CACert.crt',
      'third_party/nist-pkits/certs/nameConstraintsDNS2CACert.crt',
      'third_party/nist-pkits/certs/nameConstraintsRFC822CA1Cert.crt',
      'third_party/nist-pkits/certs/nameConstraintsRFC822CA2Cert.crt',
      'third_party/nist-pkits/certs/nameConstraintsRFC822CA3Cert.crt',
      'third_party/nist-pkits/certs/nameConstraintsURI1CACert.crt',
      'third_party/nist-pkits/certs/nameConstraintsURI2CACert.crt',
      'third_party/nist-pkits/certs/onlyContainsAttributeCertsCACert.crt',
      'third_party/nist-pkits/certs/onlyContainsCACertsCACert.crt',
      'third_party/nist-pkits/certs/onlyContainsUserCertsCACert.crt',
      'third_party/nist-pkits/certs/onlySomeReasonsCA1Cert.crt',
      'third_party/nist-pkits/certs/onlySomeReasonsCA2Cert.crt',
      'third_party/nist-pkits/certs/onlySomeReasonsCA3Cert.crt',
      'third_party/nist-pkits/certs/onlySomeReasonsCA4Cert.crt',
      'third_party/nist-pkits/certs/pathLenConstraint0CACert.crt',
      'third_party/nist-pkits/certs/pathLenConstraint0SelfIssuedCACert.crt',
      'third_party/nist-pkits/certs/pathLenConstraint0subCA2Cert.crt',
      'third_party/nist-pkits/certs/pathLenConstraint0subCACert.crt',
      'third_party/nist-pkits/certs/pathLenConstraint1CACert.crt',
      'third_party/nist-pkits/certs/pathLenConstraint1SelfIssuedCACert.crt',
      'third_party/nist-pkits/certs/pathLenConstraint1SelfIssuedsubCACert.crt',
      'third_party/nist-pkits/certs/pathLenConstraint1subCACert.crt',
      'third_party/nist-pkits/certs/pathLenConstraint6CACert.crt',
      'third_party/nist-pkits/certs/pathLenConstraint6subCA0Cert.crt',
      'third_party/nist-pkits/certs/pathLenConstraint6subCA1Cert.crt',
      'third_party/nist-pkits/certs/pathLenConstraint6subCA4Cert.crt',
      'third_party/nist-pkits/certs/pathLenConstraint6subsubCA00Cert.crt',
      'third_party/nist-pkits/certs/pathLenConstraint6subsubCA11Cert.crt',
      'third_party/nist-pkits/certs/pathLenConstraint6subsubCA41Cert.crt',
      'third_party/nist-pkits/certs/pathLenConstraint6subsubsubCA11XCert.crt',
      'third_party/nist-pkits/certs/pathLenConstraint6subsubsubCA41XCert.crt',
      'third_party/nist-pkits/certs/pre2000CRLnextUpdateCACert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy0CACert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy0subCACert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy0subsubCACert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy0subsubsubCACert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy10CACert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy10subCACert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy10subsubCACert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy10subsubsubCACert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy2CACert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy2SelfIssuedCACert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy2SelfIssuedsubCACert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy2subCACert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy4CACert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy4subCACert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy4subsubCACert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy4subsubsubCACert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy5CACert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy5subCACert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy5subsubCACert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy5subsubsubCACert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy7CACert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy7subCARE2Cert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy7subsubCARE2RE4Cert.crt',
      'third_party/nist-pkits/certs/requireExplicitPolicy7subsubsubCARE2RE4Cert.crt',
      'third_party/nist-pkits/crls/BadCRLIssuerNameCACRL.crl',
      'third_party/nist-pkits/crls/BadCRLSignatureCACRL.crl',
      'third_party/nist-pkits/crls/BadSignedCACRL.crl',
      'third_party/nist-pkits/crls/BadnotAfterDateCACRL.crl',
      'third_party/nist-pkits/crls/BadnotBeforeDateCACRL.crl',
      'third_party/nist-pkits/crls/BasicSelfIssuedCRLSigningKeyCACRL.crl',
      'third_party/nist-pkits/crls/BasicSelfIssuedCRLSigningKeyCRLCertCRL.crl',
      'third_party/nist-pkits/crls/BasicSelfIssuedNewKeyCACRL.crl',
      'third_party/nist-pkits/crls/BasicSelfIssuedOldKeyCACRL.crl',
      'third_party/nist-pkits/crls/BasicSelfIssuedOldKeySelfIssuedCertCRL.crl',
      'third_party/nist-pkits/crls/DSACACRL.crl',
      'third_party/nist-pkits/crls/DSAParametersInheritedCACRL.crl',
      'third_party/nist-pkits/crls/GeneralizedTimeCRLnextUpdateCACRL.crl',
      'third_party/nist-pkits/crls/GoodCACRL.crl',
      'third_party/nist-pkits/crls/GoodsubCACRL.crl',
      'third_party/nist-pkits/crls/GoodsubCAPanyPolicyMapping1to2CACRL.crl',
      'third_party/nist-pkits/crls/LongSerialNumberCACRL.crl',
      'third_party/nist-pkits/crls/Mapping1to2CACRL.crl',
      'third_party/nist-pkits/crls/MappingFromanyPolicyCACRL.crl',
      'third_party/nist-pkits/crls/MappingToanyPolicyCACRL.crl',
      'third_party/nist-pkits/crls/MissingbasicConstraintsCACRL.crl',
      'third_party/nist-pkits/crls/NameOrderCACRL.crl',
      'third_party/nist-pkits/crls/NegativeSerialNumberCACRL.crl',
      'third_party/nist-pkits/crls/NoPoliciesCACRL.crl',
      'third_party/nist-pkits/crls/NoissuingDistributionPointCACRL.crl',
      'third_party/nist-pkits/crls/OldCRLnextUpdateCACRL.crl',
      'third_party/nist-pkits/crls/P12Mapping1to3CACRL.crl',
      'third_party/nist-pkits/crls/P12Mapping1to3subCACRL.crl',
      'third_party/nist-pkits/crls/P12Mapping1to3subsubCACRL.crl',
      'third_party/nist-pkits/crls/P1Mapping1to234CACRL.crl',
      'third_party/nist-pkits/crls/P1Mapping1to234subCACRL.crl',
      'third_party/nist-pkits/crls/P1anyPolicyMapping1to2CACRL.crl',
      'third_party/nist-pkits/crls/PanyPolicyMapping1to2CACRL.crl',
      'third_party/nist-pkits/crls/PoliciesP1234CACRL.crl',
      'third_party/nist-pkits/crls/PoliciesP1234subCAP123CRL.crl',
      'third_party/nist-pkits/crls/PoliciesP1234subsubCAP123P12CRL.crl',
      'third_party/nist-pkits/crls/PoliciesP123CACRL.crl',
      'third_party/nist-pkits/crls/PoliciesP123subCAP12CRL.crl',
      'third_party/nist-pkits/crls/PoliciesP123subsubCAP12P1CRL.crl',
      'third_party/nist-pkits/crls/PoliciesP123subsubCAP2P2CRL.crl',
      'third_party/nist-pkits/crls/PoliciesP123subsubsubCAP12P2P1CRL.crl',
      'third_party/nist-pkits/crls/PoliciesP12CACRL.crl',
      'third_party/nist-pkits/crls/PoliciesP12subCAP1CRL.crl',
      'third_party/nist-pkits/crls/PoliciesP12subsubCAP1P2CRL.crl',
      'third_party/nist-pkits/crls/PoliciesP2subCA2CRL.crl',
      'third_party/nist-pkits/crls/PoliciesP2subCACRL.crl',
      'third_party/nist-pkits/crls/PoliciesP3CACRL.crl',
      'third_party/nist-pkits/crls/RFC3280MandatoryAttributeTypesCACRL.crl',
      'third_party/nist-pkits/crls/RFC3280OptionalAttributeTypesCACRL.crl',
      'third_party/nist-pkits/crls/RevokedsubCACRL.crl',
      'third_party/nist-pkits/crls/RolloverfromPrintableStringtoUTF8StringCACRL.crl',
      'third_party/nist-pkits/crls/SeparateCertificateandCRLKeysCA2CRL.crl',
      'third_party/nist-pkits/crls/SeparateCertificateandCRLKeysCRL.crl',
      'third_party/nist-pkits/crls/TrustAnchorRootCRL.crl',
      'third_party/nist-pkits/crls/TwoCRLsCABadCRL.crl',
      'third_party/nist-pkits/crls/TwoCRLsCAGoodCRL.crl',
      'third_party/nist-pkits/crls/UIDCACRL.crl',
      'third_party/nist-pkits/crls/UTF8StringCaseInsensitiveMatchCACRL.crl',
      'third_party/nist-pkits/crls/UTF8StringEncodedNamesCACRL.crl',
      'third_party/nist-pkits/crls/UnknownCRLEntryExtensionCACRL.crl',
      'third_party/nist-pkits/crls/UnknownCRLExtensionCACRL.crl',
      'third_party/nist-pkits/crls/WrongCRLCACRL.crl',
      'third_party/nist-pkits/crls/anyPolicyCACRL.crl',
      'third_party/nist-pkits/crls/basicConstraintsCriticalcAFalseCACRL.crl',
      'third_party/nist-pkits/crls/basicConstraintsNotCriticalCACRL.crl',
      'third_party/nist-pkits/crls/basicConstraintsNotCriticalcAFalseCACRL.crl',
      'third_party/nist-pkits/crls/deltaCRLCA1CRL.crl',
      'third_party/nist-pkits/crls/deltaCRLCA1deltaCRL.crl',
      'third_party/nist-pkits/crls/deltaCRLCA2CRL.crl',
      'third_party/nist-pkits/crls/deltaCRLCA2deltaCRL.crl',
      'third_party/nist-pkits/crls/deltaCRLCA3CRL.crl',
      'third_party/nist-pkits/crls/deltaCRLCA3deltaCRL.crl',
      'third_party/nist-pkits/crls/deltaCRLIndicatorNoBaseCACRL.crl',
      'third_party/nist-pkits/crls/distributionPoint1CACRL.crl',
      'third_party/nist-pkits/crls/distributionPoint2CACRL.crl',
      'third_party/nist-pkits/crls/indirectCRLCA1CRL.crl',
      'third_party/nist-pkits/crls/indirectCRLCA3CRL.crl',
      'third_party/nist-pkits/crls/indirectCRLCA3cRLIssuerCRL.crl',
      'third_party/nist-pkits/crls/indirectCRLCA4cRLIssuerCRL.crl',
      'third_party/nist-pkits/crls/indirectCRLCA5CRL.crl',
      'third_party/nist-pkits/crls/inhibitAnyPolicy0CACRL.crl',
      'third_party/nist-pkits/crls/inhibitAnyPolicy1CACRL.crl',
      'third_party/nist-pkits/crls/inhibitAnyPolicy1subCA1CRL.crl',
      'third_party/nist-pkits/crls/inhibitAnyPolicy1subCA2CRL.crl',
      'third_party/nist-pkits/crls/inhibitAnyPolicy1subCAIAP5CRL.crl',
      'third_party/nist-pkits/crls/inhibitAnyPolicy1subsubCA2CRL.crl',
      'third_party/nist-pkits/crls/inhibitAnyPolicy5CACRL.crl',
      'third_party/nist-pkits/crls/inhibitAnyPolicy5subCACRL.crl',
      'third_party/nist-pkits/crls/inhibitAnyPolicy5subsubCACRL.crl',
      'third_party/nist-pkits/crls/inhibitPolicyMapping0CACRL.crl',
      'third_party/nist-pkits/crls/inhibitPolicyMapping0subCACRL.crl',
      'third_party/nist-pkits/crls/inhibitPolicyMapping1P12CACRL.crl',
      'third_party/nist-pkits/crls/inhibitPolicyMapping1P12subCACRL.crl',
      'third_party/nist-pkits/crls/inhibitPolicyMapping1P12subCAIPM5CRL.crl',
      'third_party/nist-pkits/crls/inhibitPolicyMapping1P12subsubCACRL.crl',
      'third_party/nist-pkits/crls/inhibitPolicyMapping1P12subsubCAIPM5CRL.crl',
      'third_party/nist-pkits/crls/inhibitPolicyMapping1P1CACRL.crl',
      'third_party/nist-pkits/crls/inhibitPolicyMapping1P1subCACRL.crl',
      'third_party/nist-pkits/crls/inhibitPolicyMapping1P1subsubCACRL.crl',
      'third_party/nist-pkits/crls/inhibitPolicyMapping5CACRL.crl',
      'third_party/nist-pkits/crls/inhibitPolicyMapping5subCACRL.crl',
      'third_party/nist-pkits/crls/inhibitPolicyMapping5subsubCACRL.crl',
      'third_party/nist-pkits/crls/inhibitPolicyMapping5subsubsubCACRL.crl',
      'third_party/nist-pkits/crls/keyUsageCriticalcRLSignFalseCACRL.crl',
      'third_party/nist-pkits/crls/keyUsageCriticalkeyCertSignFalseCACRL.crl',
      'third_party/nist-pkits/crls/keyUsageNotCriticalCACRL.crl',
      'third_party/nist-pkits/crls/keyUsageNotCriticalcRLSignFalseCACRL.crl',
      'third_party/nist-pkits/crls/keyUsageNotCriticalkeyCertSignFalseCACRL.crl',
      'third_party/nist-pkits/crls/nameConstraintsDN1CACRL.crl',
      'third_party/nist-pkits/crls/nameConstraintsDN1subCA1CRL.crl',
      'third_party/nist-pkits/crls/nameConstraintsDN1subCA2CRL.crl',
      'third_party/nist-pkits/crls/nameConstraintsDN1subCA3CRL.crl',
      'third_party/nist-pkits/crls/nameConstraintsDN2CACRL.crl',
      'third_party/nist-pkits/crls/nameConstraintsDN3CACRL.crl',
      'third_party/nist-pkits/crls/nameConstraintsDN3subCA1CRL.crl',
      'third_party/nist-pkits/crls/nameConstraintsDN3subCA2CRL.crl',
      'third_party/nist-pkits/crls/nameConstraintsDN4CACRL.crl',
      'third_party/nist-pkits/crls/nameConstraintsDN5CACRL.crl',
      'third_party/nist-pkits/crls/nameConstraintsDNS1CACRL.crl',
      'third_party/nist-pkits/crls/nameConstraintsDNS2CACRL.crl',
      'third_party/nist-pkits/crls/nameConstraintsRFC822CA1CRL.crl',
      'third_party/nist-pkits/crls/nameConstraintsRFC822CA2CRL.crl',
      'third_party/nist-pkits/crls/nameConstraintsRFC822CA3CRL.crl',
      'third_party/nist-pkits/crls/nameConstraintsURI1CACRL.crl',
      'third_party/nist-pkits/crls/nameConstraintsURI2CACRL.crl',
      'third_party/nist-pkits/crls/onlyContainsAttributeCertsCACRL.crl',
      'third_party/nist-pkits/crls/onlyContainsCACertsCACRL.crl',
      'third_party/nist-pkits/crls/onlyContainsUserCertsCACRL.crl',
      'third_party/nist-pkits/crls/onlySomeReasonsCA1compromiseCRL.crl',
      'third_party/nist-pkits/crls/onlySomeReasonsCA1otherreasonsCRL.crl',
      'third_party/nist-pkits/crls/onlySomeReasonsCA2CRL1.crl',
      'third_party/nist-pkits/crls/onlySomeReasonsCA2CRL2.crl',
      'third_party/nist-pkits/crls/onlySomeReasonsCA3compromiseCRL.crl',
      'third_party/nist-pkits/crls/onlySomeReasonsCA3otherreasonsCRL.crl',
      'third_party/nist-pkits/crls/onlySomeReasonsCA4compromiseCRL.crl',
      'third_party/nist-pkits/crls/onlySomeReasonsCA4otherreasonsCRL.crl',
      'third_party/nist-pkits/crls/pathLenConstraint0CACRL.crl',
      'third_party/nist-pkits/crls/pathLenConstraint0subCA2CRL.crl',
      'third_party/nist-pkits/crls/pathLenConstraint0subCACRL.crl',
      'third_party/nist-pkits/crls/pathLenConstraint1CACRL.crl',
      'third_party/nist-pkits/crls/pathLenConstraint1subCACRL.crl',
      'third_party/nist-pkits/crls/pathLenConstraint6CACRL.crl',
      'third_party/nist-pkits/crls/pathLenConstraint6subCA0CRL.crl',
      'third_party/nist-pkits/crls/pathLenConstraint6subCA1CRL.crl',
      'third_party/nist-pkits/crls/pathLenConstraint6subCA4CRL.crl',
      'third_party/nist-pkits/crls/pathLenConstraint6subsubCA00CRL.crl',
      'third_party/nist-pkits/crls/pathLenConstraint6subsubCA11CRL.crl',
      'third_party/nist-pkits/crls/pathLenConstraint6subsubCA41CRL.crl',
      'third_party/nist-pkits/crls/pathLenConstraint6subsubsubCA11XCRL.crl',
      'third_party/nist-pkits/crls/pathLenConstraint6subsubsubCA41XCRL.crl',
      'third_party/nist-pkits/crls/pre2000CRLnextUpdateCACRL.crl',
      'third_party/nist-pkits/crls/requireExplicitPolicy0CACRL.crl',
      'third_party/nist-pkits/crls/requireExplicitPolicy0subCACRL.crl',
      'third_party/nist-pkits/crls/requireExplicitPolicy0subsubCACRL.crl',
      'third_party/nist-pkits/crls/requireExplicitPolicy0subsubsubCACRL.crl',
      'third_party/nist-pkits/crls/requireExplicitPolicy10CACRL.crl',
      'third_party/nist-pkits/crls/requireExplicitPolicy10subCACRL.crl',
      'third_party/nist-pkits/crls/requireExplicitPolicy10subsubCACRL.crl',
      'third_party/nist-pkits/crls/requireExplicitPolicy10subsubsubCACRL.crl',
      'third_party/nist-pkits/crls/requireExplicitPolicy2CACRL.crl',
      'third_party/nist-pkits/crls/requireExplicitPolicy2subCACRL.crl',
      'third_party/nist-pkits/crls/requireExplicitPolicy4CACRL.crl',
      'third_party/nist-pkits/crls/requireExplicitPolicy4subCACRL.crl',
      'third_party/nist-pkits/crls/requireExplicitPolicy4subsubCACRL.crl',
      'third_party/nist-pkits/crls/requireExplicitPolicy4subsubsubCACRL.crl',
      'third_party/nist-pkits/crls/requireExplicitPolicy5CACRL.crl',
      'third_party/nist-pkits/crls/requireExplicitPolicy5subCACRL.crl',
      'third_party/nist-pkits/crls/requireExplicitPolicy5subsubCACRL.crl',
      'third_party/nist-pkits/crls/requireExplicitPolicy5subsubsubCACRL.crl',
      'third_party/nist-pkits/crls/requireExplicitPolicy7CACRL.crl',
      'third_party/nist-pkits/crls/requireExplicitPolicy7subCARE2CRL.crl',
      'third_party/nist-pkits/crls/requireExplicitPolicy7subsubCARE2RE4CRL.crl',
      'third_party/nist-pkits/crls/requireExplicitPolicy7subsubsubCARE2RE4CRL.crl',
    ],
  }
}
