// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

cr.define('options', function() {
  var Page = cr.ui.pageManager.Page;
  var PageManager = cr.ui.pageManager.PageManager;

  /**
   * QuickUnlockConfigureOverlay class
   * Dialog that allows users to configure screen lock.
   * @constructor
   * @extends {cr.ui.pageManager.Page}
   */
  function QuickUnlockConfigureOverlay() {
    Page.call(this, 'quickUnlockConfigureOverlay',
              loadTimeData.getString('lockScreenTitle'),
              'quick-unlock-configure-overlay');

  }

  cr.addSingletonGetter(QuickUnlockConfigureOverlay);

  QuickUnlockConfigureOverlay.prototype = {
    __proto__: Page.prototype,

    /** @override */
    initializePage: function() {
      Page.prototype.initializePage.call(this);
    },

    /** @override */
    didClosePage: function() {
      settings.navigateTo(settings.Route.PEOPLE);
    },

    /** @override */
    didShowPage: function() {
      settings.navigateTo(settings.Route.LOCK_SCREEN);
      var lockScreen = document.querySelector('settings-lock-screen');

      var checkbox = lockScreen.root.querySelector('settings-checkbox');
      checkbox.hidden = true;

      var passwordPrompt = lockScreen.root.
          querySelector('settings-password-prompt-dialog');
      passwordPrompt.addEventListener('close', function() {
        if (!lockScreen.setModes_) {
          QuickUnlockConfigureOverlay.dismiss();
        }
      }.bind(this));
    },

  };

  QuickUnlockConfigureOverlay.dismiss = function() {
    PageManager.closeOverlay();
  };

  // Export
  return {
    QuickUnlockConfigureOverlay: QuickUnlockConfigureOverlay
  };
});
