Protocol.Error=Symbol('Protocol.Error');Protocol.InspectorBackend=class{constructor(){this._agentPrototypes={};this._dispatcherPrototypes={};this._initialized=false;}
static reportProtocolError(error,messageObject){console.error(error+': '+JSON.stringify(messageObject));}
isInitialized(){return this._initialized;}
_addAgentGetterMethodToProtocolTargetPrototype(domain){var upperCaseLength=0;while(upperCaseLength<domain.length&&domain[upperCaseLength].toLowerCase()!==domain[upperCaseLength])
++upperCaseLength;var methodName=domain.substr(0,upperCaseLength).toLowerCase()+domain.slice(upperCaseLength)+'Agent';function agentGetter(){return this._agents[domain];}
Protocol.TargetBase.prototype[methodName]=agentGetter;function registerDispatcher(dispatcher){this.registerDispatcher(domain,dispatcher);}
Protocol.TargetBase.prototype['register'+domain+'Dispatcher']=registerDispatcher;}
_agentPrototype(domain){if(!this._agentPrototypes[domain]){this._agentPrototypes[domain]=new Protocol.InspectorBackend._AgentPrototype(domain);this._addAgentGetterMethodToProtocolTargetPrototype(domain);}
return this._agentPrototypes[domain];}
_dispatcherPrototype(domain){if(!this._dispatcherPrototypes[domain])
this._dispatcherPrototypes[domain]=new Protocol.InspectorBackend._DispatcherPrototype();return this._dispatcherPrototypes[domain];}
registerCommand(method,signature,replyArgs,hasErrorData){var domainAndMethod=method.split('.');this._agentPrototype(domainAndMethod[0]).registerCommand(domainAndMethod[1],signature,replyArgs,hasErrorData);this._initialized=true;}
registerEnum(type,values){var domainAndName=type.split('.');var domain=domainAndName[0];if(!Protocol[domain])
Protocol[domain]={};Protocol[domain][domainAndName[1]]=values;this._initialized=true;}
registerEvent(eventName,params){var domain=eventName.split('.')[0];this._dispatcherPrototype(domain).registerEvent(eventName,params);this._initialized=true;}
wrapClientCallback(clientCallback,errorPrefix,constructor,defaultValue){function callbackWrapper(error,value){if(error){console.error(errorPrefix+error);clientCallback(defaultValue);return;}
if(constructor)
clientCallback(new constructor(value));else
clientCallback(value);}
return callbackWrapper;}};Protocol.InspectorBackend._ConnectionClosedErrorCode=-32000;Protocol.InspectorBackend.DevToolsStubErrorCode=-32015;Protocol.inspectorBackend=new Protocol.InspectorBackend();Protocol.InspectorBackend.Connection=function(){};Protocol.InspectorBackend.Connection.prototype={sendMessage(message){},disconnect(){},};Protocol.InspectorBackend.Connection.Params;Protocol.InspectorBackend.Connection.Factory;Protocol.TargetBase=class{constructor(connectionFactory){this._connection=connectionFactory({onMessage:this._onMessage.bind(this),onDisconnect:this._onDisconnect.bind(this)});this._lastMessageId=1;this._pendingResponsesCount=0;this._agents={};this._dispatchers={};this._callbacks={};this._initialize(Protocol.inspectorBackend._agentPrototypes,Protocol.inspectorBackend._dispatcherPrototypes);if(!Protocol.InspectorBackend.deprecatedRunAfterPendingDispatches){Protocol.InspectorBackend.deprecatedRunAfterPendingDispatches=this._deprecatedRunAfterPendingDispatches.bind(this);}
if(!Protocol.InspectorBackend.sendRawMessageForTesting)
Protocol.InspectorBackend.sendRawMessageForTesting=this._sendRawMessageForTesting.bind(this);}
_initialize(agentPrototypes,dispatcherPrototypes){for(var domain in agentPrototypes){this._agents[domain]=Object.create(agentPrototypes[domain]);this._agents[domain].setTarget(this);}
for(var domain in dispatcherPrototypes){this._dispatchers[domain]=Object.create(dispatcherPrototypes[domain]);this._dispatchers[domain].initialize();}}
_nextMessageId(){return this._lastMessageId++;}
_agent(domain){return this._agents[domain];}
_wrapCallbackAndSendMessageObject(domain,method,params,callback){if(!this._connection){if(callback)
this._dispatchConnectionErrorResponse(domain,method,callback);return;}
var messageObject={};var messageId=this._nextMessageId();messageObject.id=messageId;messageObject.method=method;if(params)
messageObject.params=params;var wrappedCallback=this._wrap(callback,domain,method);var message=JSON.stringify(messageObject);if(Protocol.InspectorBackend.Options.dumpInspectorProtocolMessages)
this._dumpProtocolMessage('frontend: '+message);this._connection.sendMessage(message);++this._pendingResponsesCount;this._callbacks[messageId]=wrappedCallback;}
_wrap(callback,domain,method){if(!callback)
callback=function(){};callback.methodName=method;callback.domain=domain;if(Protocol.InspectorBackend.Options.dumpInspectorTimeStats)
callback.sendRequestTime=Date.now();return callback;}
_sendRawMessageForTesting(method,params,callback){var domain=method.split('.')[0];this._wrapCallbackAndSendMessageObject(domain,method,params,callback);}
_onMessage(message){if(Protocol.InspectorBackend.Options.dumpInspectorProtocolMessages)
this._dumpProtocolMessage('backend: '+((typeof message==='string')?message:JSON.stringify(message)));var messageObject=((typeof message==='string')?JSON.parse(message):message);if('id'in messageObject){var callback=this._callbacks[messageObject.id];if(!callback){Protocol.InspectorBackend.reportProtocolError('Protocol Error: the message with wrong id',messageObject);return;}
var timingLabel='time-stats: '+callback.methodName;if(Protocol.InspectorBackend.Options.dumpInspectorTimeStats)
console.time(timingLabel);this._agent(callback.domain).dispatchResponse(messageObject,callback.methodName,callback);--this._pendingResponsesCount;delete this._callbacks[messageObject.id];if(Protocol.InspectorBackend.Options.dumpInspectorTimeStats)
console.timeEnd(timingLabel);if(this._scripts&&!this._pendingResponsesCount)
this._deprecatedRunAfterPendingDispatches();}else{if(!('method'in messageObject)){Protocol.InspectorBackend.reportProtocolError('Protocol Error: the message without method',messageObject);return;}
var method=messageObject.method.split('.');var domainName=method[0];if(!(domainName in this._dispatchers)){Protocol.InspectorBackend.reportProtocolError(`Protocol Error: the message ${messageObject.method} is for non-existing domain '${domainName}'`,messageObject);return;}
this._dispatchers[domainName].dispatch(method[1],messageObject);}}
registerDispatcher(domain,dispatcher){if(!this._dispatchers[domain])
return;this._dispatchers[domain].addDomainDispatcher(dispatcher);}
_deprecatedRunAfterPendingDispatches(script){if(!this._scripts)
this._scripts=[];if(script)
this._scripts.push(script);setTimeout(function(){if(!this._pendingResponsesCount)
this._executeAfterPendingDispatches();else
this._deprecatedRunAfterPendingDispatches();}.bind(this),0);}
_executeAfterPendingDispatches(){if(!this._pendingResponsesCount){var scripts=this._scripts;this._scripts=[];for(var id=0;id<scripts.length;++id)
scripts[id].call(this);}}
_dumpProtocolMessage(message){console.log(message);}
_onDisconnect(reason){this._connection=null;this._runPendingCallbacks();this.dispose();}
dispose(){}
isDisposed(){return!this._connection;}
_runPendingCallbacks(){var keys=Object.keys(this._callbacks).map(function(num){return parseInt(num,10);});for(var i=0;i<keys.length;++i){var callback=this._callbacks[keys[i]];this._dispatchConnectionErrorResponse(callback.domain,callback.methodName,callback);}
this._callbacks={};}
_dispatchConnectionErrorResponse(domain,methodName,callback){var error={message:'Connection is closed, can\'t dispatch pending '+methodName,code:Protocol.InspectorBackend._ConnectionClosedErrorCode,data:null};var messageObject={error:error};setTimeout(Protocol.InspectorBackend._AgentPrototype.prototype.dispatchResponse.bind(this._agent(domain),messageObject,methodName,callback),0);}};Protocol.InspectorBackend._AgentPrototype=class{constructor(domain){this._replyArgs={};this._hasErrorData={};this._domain=domain;}
setTarget(target){this._target=target;}
registerCommand(methodName,signature,replyArgs,hasErrorData){var domainAndMethod=this._domain+'.'+methodName;function sendMessagePromise(vararg){var params=Array.prototype.slice.call(arguments);return Protocol.InspectorBackend._AgentPrototype.prototype._sendMessageToBackendPromise.call(this,domainAndMethod,signature,params);}
this[methodName]=sendMessagePromise;function invoke(request){return this._invoke(domainAndMethod,request);}
this['invoke_'+methodName]=invoke;this._replyArgs[domainAndMethod]=replyArgs;if(hasErrorData)
this._hasErrorData[domainAndMethod]=true;}
_prepareParameters(method,signature,args,errorCallback){var params={};var hasParams=false;for(var param of signature){var paramName=param['name'];var typeName=param['type'];var optionalFlag=param['optional'];if(!args.length&&!optionalFlag){errorCallback(`Protocol Error: Invalid number of arguments for method '${method}' call. `+`It must have the following arguments ${JSON.stringify(signature)}'.`);return null;}
var value=args.shift();if(optionalFlag&&typeof value==='undefined')
continue;if(typeof value!==typeName){errorCallback(`Protocol Error: Invalid type of argument '${paramName}' for method '${method}' call. `+`It must be '${typeName}' but it is '${typeof value}'.`);return null;}
params[paramName]=value;hasParams=true;}
if(args.length){errorCallback(`Protocol Error: Extra ${args.length} arguments in a call to method '${method}'.`);return null;}
return hasParams?params:null;}
_sendMessageToBackendPromise(method,signature,args){var errorMessage;function onError(message){console.error(message);errorMessage=message;}
var params=this._prepareParameters(method,signature,args,onError);if(errorMessage)
return Promise.resolve(null);return new Promise(resolve=>{this._target._wrapCallbackAndSendMessageObject(this._domain,method,params,(error,result)=>{if(error){resolve(null);return;}
var args=this._replyArgs[method];resolve(result&&args.length?result[args[0]]:undefined);});});}
_invoke(method,request){return new Promise(fulfill=>{this._target._wrapCallbackAndSendMessageObject(this._domain,method,request,(error,result)=>{if(!result)
result={};if(error)
result[Protocol.Error]=error.message;fulfill(result);});});}
dispatchResponse(messageObject,methodName,callback){if(messageObject.error&&messageObject.error.code!==Protocol.InspectorBackend._ConnectionClosedErrorCode&&messageObject.error.code!==Protocol.InspectorBackend.DevToolsStubErrorCode&&!Protocol.InspectorBackend.Options.suppressRequestErrors){var id=Protocol.InspectorBackend.Options.dumpInspectorProtocolMessages?' with id = '+messageObject.id:'';console.error('Request '+methodName+id+' failed. '+JSON.stringify(messageObject.error));}
callback(messageObject.error,messageObject.result);}};Protocol.InspectorBackend._DispatcherPrototype=class{constructor(){this._eventArgs={};}
registerEvent(eventName,params){this._eventArgs[eventName]=params;}
initialize(){this._dispatchers=[];}
addDomainDispatcher(dispatcher){this._dispatchers.push(dispatcher);}
dispatch(functionName,messageObject){if(!this._dispatchers.length)
return;if(!this._eventArgs[messageObject.method]){Protocol.InspectorBackend.reportProtocolError(`Protocol Error: Attempted to dispatch an unspecified method '${messageObject.method}'`,messageObject);return;}
var params=[];if(messageObject.params){var paramNames=this._eventArgs[messageObject.method];for(var i=0;i<paramNames.length;++i)
params.push(messageObject.params[paramNames[i]]);}
var timingLabel='time-stats: '+messageObject.method;if(Protocol.InspectorBackend.Options.dumpInspectorTimeStats)
console.time(timingLabel);for(var index=0;index<this._dispatchers.length;++index){var dispatcher=this._dispatchers[index];if(functionName in dispatcher)
dispatcher[functionName].apply(dispatcher,params);}
if(Protocol.InspectorBackend.Options.dumpInspectorTimeStats)
console.timeEnd(timingLabel);}};Protocol.InspectorBackend.Options={dumpInspectorTimeStats:false,dumpInspectorProtocolMessages:false,suppressRequestErrors:false};;Protocol.inspectorBackend.registerEvent("Inspector.detached",["reason"]);Protocol.inspectorBackend.registerEvent("Inspector.targetCrashed",[]);Protocol.inspectorBackend.registerCommand("Inspector.enable",[],[],false);Protocol.inspectorBackend.registerCommand("Inspector.disable",[],[],false);Protocol.inspectorBackend.registerEnum("Memory.PressureLevel",{Moderate:"moderate",Critical:"critical"});Protocol.inspectorBackend.registerCommand("Memory.getDOMCounters",[],["documents","nodes","jsEventListeners"],false);Protocol.inspectorBackend.registerCommand("Memory.setPressureNotificationsSuppressed",[{"name":"suppressed","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Memory.simulatePressureNotification",[{"name":"level","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerEnum("Page.ResourceType",{Document:"Document",Stylesheet:"Stylesheet",Image:"Image",Media:"Media",Font:"Font",Script:"Script",TextTrack:"TextTrack",XHR:"XHR",Fetch:"Fetch",EventSource:"EventSource",WebSocket:"WebSocket",Manifest:"Manifest",Other:"Other"});Protocol.inspectorBackend.registerEnum("Page.TransitionType",{Link:"link",Typed:"typed",Auto_bookmark:"auto_bookmark",Auto_subframe:"auto_subframe",Manual_subframe:"manual_subframe",Generated:"generated",Auto_toplevel:"auto_toplevel",Form_submit:"form_submit",Reload:"reload",Keyword:"keyword",Keyword_generated:"keyword_generated",Other:"other"});Protocol.inspectorBackend.registerEnum("Page.DialogType",{Alert:"alert",Confirm:"confirm",Prompt:"prompt",Beforeunload:"beforeunload"});Protocol.inspectorBackend.registerEnum("Page.NavigationResponse",{Proceed:"Proceed",Cancel:"Cancel",CancelAndIgnore:"CancelAndIgnore"});Protocol.inspectorBackend.registerEvent("Page.domContentEventFired",["timestamp"]);Protocol.inspectorBackend.registerEvent("Page.loadEventFired",["timestamp"]);Protocol.inspectorBackend.registerEvent("Page.frameAttached",["frameId","parentFrameId","stack"]);Protocol.inspectorBackend.registerEvent("Page.frameNavigated",["frame"]);Protocol.inspectorBackend.registerEvent("Page.frameDetached",["frameId"]);Protocol.inspectorBackend.registerEvent("Page.frameStartedLoading",["frameId"]);Protocol.inspectorBackend.registerEvent("Page.frameStoppedLoading",["frameId"]);Protocol.inspectorBackend.registerEvent("Page.frameScheduledNavigation",["frameId","delay"]);Protocol.inspectorBackend.registerEvent("Page.frameClearedScheduledNavigation",["frameId"]);Protocol.inspectorBackend.registerEvent("Page.frameResized",[]);Protocol.inspectorBackend.registerEvent("Page.javascriptDialogOpening",["message","type"]);Protocol.inspectorBackend.registerEvent("Page.javascriptDialogClosed",["result"]);Protocol.inspectorBackend.registerEvent("Page.screencastFrame",["data","metadata","sessionId"]);Protocol.inspectorBackend.registerEvent("Page.screencastVisibilityChanged",["visible"]);Protocol.inspectorBackend.registerEvent("Page.interstitialShown",[]);Protocol.inspectorBackend.registerEvent("Page.interstitialHidden",[]);Protocol.inspectorBackend.registerEvent("Page.navigationRequested",["isInMainFrame","isRedirect","navigationId","url"]);Protocol.inspectorBackend.registerCommand("Page.enable",[],[],false);Protocol.inspectorBackend.registerCommand("Page.disable",[],[],false);Protocol.inspectorBackend.registerCommand("Page.addScriptToEvaluateOnLoad",[{"name":"scriptSource","type":"string","optional":false}],["identifier"],false);Protocol.inspectorBackend.registerCommand("Page.removeScriptToEvaluateOnLoad",[{"name":"identifier","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Page.setAutoAttachToCreatedPages",[{"name":"autoAttach","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Page.reload",[{"name":"ignoreCache","type":"boolean","optional":true},{"name":"scriptToEvaluateOnLoad","type":"string","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Page.navigate",[{"name":"url","type":"string","optional":false},{"name":"referrer","type":"string","optional":true},{"name":"transitionType","type":"string","optional":true}],["frameId"],false);Protocol.inspectorBackend.registerCommand("Page.stopLoading",[],[],false);Protocol.inspectorBackend.registerCommand("Page.getNavigationHistory",[],["currentIndex","entries"],false);Protocol.inspectorBackend.registerCommand("Page.navigateToHistoryEntry",[{"name":"entryId","type":"number","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Page.getCookies",[],["cookies"],false);Protocol.inspectorBackend.registerCommand("Page.deleteCookie",[{"name":"cookieName","type":"string","optional":false},{"name":"url","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Page.getResourceTree",[],["frameTree"],false);Protocol.inspectorBackend.registerCommand("Page.getResourceContent",[{"name":"frameId","type":"string","optional":false},{"name":"url","type":"string","optional":false}],["content","base64Encoded"],false);Protocol.inspectorBackend.registerCommand("Page.searchInResource",[{"name":"frameId","type":"string","optional":false},{"name":"url","type":"string","optional":false},{"name":"query","type":"string","optional":false},{"name":"caseSensitive","type":"boolean","optional":true},{"name":"isRegex","type":"boolean","optional":true}],["result"],false);Protocol.inspectorBackend.registerCommand("Page.setDocumentContent",[{"name":"frameId","type":"string","optional":false},{"name":"html","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Page.setDeviceMetricsOverride",[{"name":"width","type":"number","optional":false},{"name":"height","type":"number","optional":false},{"name":"deviceScaleFactor","type":"number","optional":false},{"name":"mobile","type":"boolean","optional":false},{"name":"fitWindow","type":"boolean","optional":false},{"name":"scale","type":"number","optional":true},{"name":"offsetX","type":"number","optional":true},{"name":"offsetY","type":"number","optional":true},{"name":"screenWidth","type":"number","optional":true},{"name":"screenHeight","type":"number","optional":true},{"name":"positionX","type":"number","optional":true},{"name":"positionY","type":"number","optional":true},{"name":"screenOrientation","type":"object","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Page.clearDeviceMetricsOverride",[],[],false);Protocol.inspectorBackend.registerCommand("Page.setGeolocationOverride",[{"name":"latitude","type":"number","optional":true},{"name":"longitude","type":"number","optional":true},{"name":"accuracy","type":"number","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Page.clearGeolocationOverride",[],[],false);Protocol.inspectorBackend.registerCommand("Page.setDeviceOrientationOverride",[{"name":"alpha","type":"number","optional":false},{"name":"beta","type":"number","optional":false},{"name":"gamma","type":"number","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Page.clearDeviceOrientationOverride",[],[],false);Protocol.inspectorBackend.registerCommand("Page.setTouchEmulationEnabled",[{"name":"enabled","type":"boolean","optional":false},{"name":"configuration","type":"string","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Page.captureScreenshot",[{"name":"format","type":"string","optional":true},{"name":"quality","type":"number","optional":true},{"name":"fromSurface","type":"boolean","optional":true}],["data"],false);Protocol.inspectorBackend.registerCommand("Page.printToPDF",[{"name":"landscape","type":"boolean","optional":true},{"name":"displayHeaderFooter","type":"boolean","optional":true},{"name":"printBackground","type":"boolean","optional":true},{"name":"scale","type":"number","optional":true},{"name":"paperWidth","type":"number","optional":true},{"name":"paperHeight","type":"number","optional":true},{"name":"marginTop","type":"number","optional":true},{"name":"marginBottom","type":"number","optional":true},{"name":"marginLeft","type":"number","optional":true},{"name":"marginRight","type":"number","optional":true},{"name":"pageRanges","type":"string","optional":true}],["data"],false);Protocol.inspectorBackend.registerCommand("Page.startScreencast",[{"name":"format","type":"string","optional":true},{"name":"quality","type":"number","optional":true},{"name":"maxWidth","type":"number","optional":true},{"name":"maxHeight","type":"number","optional":true},{"name":"everyNthFrame","type":"number","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Page.stopScreencast",[],[],false);Protocol.inspectorBackend.registerCommand("Page.screencastFrameAck",[{"name":"sessionId","type":"number","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Page.handleJavaScriptDialog",[{"name":"accept","type":"boolean","optional":false},{"name":"promptText","type":"string","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Page.getAppManifest",[],["url","errors","data"],false);Protocol.inspectorBackend.registerCommand("Page.requestAppBanner",[],[],false);Protocol.inspectorBackend.registerCommand("Page.setControlNavigations",[{"name":"enabled","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Page.processNavigation",[{"name":"response","type":"string","optional":false},{"name":"navigationId","type":"number","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Page.getLayoutMetrics",[],["layoutViewport","visualViewport","contentSize"],false);Protocol.inspectorBackend.registerCommand("Page.createIsolatedWorld",[{"name":"frameId","type":"string","optional":false},{"name":"worldName","type":"string","optional":true},{"name":"grantUniveralAccess","type":"boolean","optional":true}],["executionContextId"],false);Protocol.inspectorBackend.registerEnum("Overlay.InspectMode",{SearchForNode:"searchForNode",SearchForUAShadowDOM:"searchForUAShadowDOM",None:"none"});Protocol.inspectorBackend.registerEvent("Overlay.nodeHighlightRequested",["nodeId"]);Protocol.inspectorBackend.registerEvent("Overlay.inspectNodeRequested",["backendNodeId"]);Protocol.inspectorBackend.registerCommand("Overlay.enable",[],[],false);Protocol.inspectorBackend.registerCommand("Overlay.disable",[],[],false);Protocol.inspectorBackend.registerCommand("Overlay.setShowPaintRects",[{"name":"result","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Overlay.setShowDebugBorders",[{"name":"show","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Overlay.setShowFPSCounter",[{"name":"show","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Overlay.setShowScrollBottleneckRects",[{"name":"show","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Overlay.setShowViewportSizeOnResize",[{"name":"show","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Overlay.setPausedInDebuggerMessage",[{"name":"message","type":"string","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Overlay.setSuspended",[{"name":"suspended","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Overlay.setInspectMode",[{"name":"mode","type":"string","optional":false},{"name":"highlightConfig","type":"object","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Overlay.highlightRect",[{"name":"x","type":"number","optional":false},{"name":"y","type":"number","optional":false},{"name":"width","type":"number","optional":false},{"name":"height","type":"number","optional":false},{"name":"color","type":"object","optional":true},{"name":"outlineColor","type":"object","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Overlay.highlightQuad",[{"name":"quad","type":"object","optional":false},{"name":"color","type":"object","optional":true},{"name":"outlineColor","type":"object","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Overlay.highlightNode",[{"name":"highlightConfig","type":"object","optional":false},{"name":"nodeId","type":"number","optional":true},{"name":"backendNodeId","type":"number","optional":true},{"name":"objectId","type":"string","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Overlay.highlightFrame",[{"name":"frameId","type":"string","optional":false},{"name":"contentColor","type":"object","optional":true},{"name":"contentOutlineColor","type":"object","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Overlay.hideHighlight",[],[],false);Protocol.inspectorBackend.registerCommand("Overlay.getHighlightObjectForTest",[{"name":"nodeId","type":"number","optional":false}],["highlight"],false);Protocol.inspectorBackend.registerEnum("Emulation.ScreenOrientationType",{PortraitPrimary:"portraitPrimary",PortraitSecondary:"portraitSecondary",LandscapePrimary:"landscapePrimary",LandscapeSecondary:"landscapeSecondary"});Protocol.inspectorBackend.registerEnum("Emulation.VirtualTimePolicy",{Advance:"advance",Pause:"pause",PauseIfNetworkFetchesPending:"pauseIfNetworkFetchesPending"});Protocol.inspectorBackend.registerEvent("Emulation.virtualTimeBudgetExpired",[]);Protocol.inspectorBackend.registerCommand("Emulation.setDeviceMetricsOverride",[{"name":"width","type":"number","optional":false},{"name":"height","type":"number","optional":false},{"name":"deviceScaleFactor","type":"number","optional":false},{"name":"mobile","type":"boolean","optional":false},{"name":"fitWindow","type":"boolean","optional":false},{"name":"scale","type":"number","optional":true},{"name":"offsetX","type":"number","optional":true},{"name":"offsetY","type":"number","optional":true},{"name":"screenWidth","type":"number","optional":true},{"name":"screenHeight","type":"number","optional":true},{"name":"positionX","type":"number","optional":true},{"name":"positionY","type":"number","optional":true},{"name":"screenOrientation","type":"object","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Emulation.clearDeviceMetricsOverride",[],[],false);Protocol.inspectorBackend.registerCommand("Emulation.forceViewport",[{"name":"x","type":"number","optional":false},{"name":"y","type":"number","optional":false},{"name":"scale","type":"number","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Emulation.resetViewport",[],[],false);Protocol.inspectorBackend.registerCommand("Emulation.resetPageScaleFactor",[],[],false);Protocol.inspectorBackend.registerCommand("Emulation.setPageScaleFactor",[{"name":"pageScaleFactor","type":"number","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Emulation.setVisibleSize",[{"name":"width","type":"number","optional":false},{"name":"height","type":"number","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Emulation.setScriptExecutionDisabled",[{"name":"value","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Emulation.setGeolocationOverride",[{"name":"latitude","type":"number","optional":true},{"name":"longitude","type":"number","optional":true},{"name":"accuracy","type":"number","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Emulation.clearGeolocationOverride",[],[],false);Protocol.inspectorBackend.registerCommand("Emulation.setTouchEmulationEnabled",[{"name":"enabled","type":"boolean","optional":false},{"name":"configuration","type":"string","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Emulation.setEmulatedMedia",[{"name":"media","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Emulation.setCPUThrottlingRate",[{"name":"rate","type":"number","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Emulation.canEmulate",[],["result"],false);Protocol.inspectorBackend.registerCommand("Emulation.setVirtualTimePolicy",[{"name":"policy","type":"string","optional":false},{"name":"budget","type":"number","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Emulation.setDefaultBackgroundColorOverride",[{"name":"color","type":"object","optional":true}],[],false);Protocol.inspectorBackend.registerEnum("Security.SecurityState",{Unknown:"unknown",Neutral:"neutral",Insecure:"insecure",Warning:"warning",Secure:"secure",Info:"info"});Protocol.inspectorBackend.registerEnum("Security.CertificateErrorAction",{Continue:"continue",Cancel:"cancel"});Protocol.inspectorBackend.registerEvent("Security.securityStateChanged",["securityState","schemeIsCryptographic","explanations","insecureContentStatus","summary"]);Protocol.inspectorBackend.registerEvent("Security.certificateError",["eventId","errorType","requestURL"]);Protocol.inspectorBackend.registerCommand("Security.enable",[],[],false);Protocol.inspectorBackend.registerCommand("Security.disable",[],[],false);Protocol.inspectorBackend.registerCommand("Security.showCertificateViewer",[],[],false);Protocol.inspectorBackend.registerCommand("Security.handleCertificateError",[{"name":"eventId","type":"number","optional":false},{"name":"action","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Security.setOverrideCertificateErrors",[{"name":"override","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerEnum("Network.ErrorReason",{Failed:"Failed",Aborted:"Aborted",TimedOut:"TimedOut",AccessDenied:"AccessDenied",ConnectionClosed:"ConnectionClosed",ConnectionReset:"ConnectionReset",ConnectionRefused:"ConnectionRefused",ConnectionAborted:"ConnectionAborted",ConnectionFailed:"ConnectionFailed",NameNotResolved:"NameNotResolved",InternetDisconnected:"InternetDisconnected",AddressUnreachable:"AddressUnreachable"});Protocol.inspectorBackend.registerEnum("Network.ConnectionType",{None:"none",Cellular2g:"cellular2g",Cellular3g:"cellular3g",Cellular4g:"cellular4g",Bluetooth:"bluetooth",Ethernet:"ethernet",Wifi:"wifi",Wimax:"wimax",Other:"other"});Protocol.inspectorBackend.registerEnum("Network.CookieSameSite",{Strict:"Strict",Lax:"Lax"});Protocol.inspectorBackend.registerEnum("Network.ResourcePriority",{VeryLow:"VeryLow",Low:"Low",Medium:"Medium",High:"High",VeryHigh:"VeryHigh"});Protocol.inspectorBackend.registerEnum("Network.RequestMixedContentType",{Blockable:"blockable",OptionallyBlockable:"optionally-blockable",None:"none"});Protocol.inspectorBackend.registerEnum("Network.RequestReferrerPolicy",{UnsafeUrl:"unsafe-url",NoReferrerWhenDowngrade:"no-referrer-when-downgrade",NoReferrer:"no-referrer",Origin:"origin",OriginWhenCrossOrigin:"origin-when-cross-origin",SameOrigin:"same-origin",StrictOrigin:"strict-origin",StrictOriginWhenCrossOrigin:"strict-origin-when-cross-origin"});Protocol.inspectorBackend.registerEnum("Network.BlockedReason",{Csp:"csp",MixedContent:"mixed-content",Origin:"origin",Inspector:"inspector",SubresourceFilter:"subresource-filter",Other:"other"});Protocol.inspectorBackend.registerEnum("Network.InitiatorType",{Parser:"parser",Script:"script",Preload:"preload",Other:"other"});Protocol.inspectorBackend.registerEnum("Network.AuthChallengeSource",{Server:"Server",Proxy:"Proxy"});Protocol.inspectorBackend.registerEnum("Network.AuthChallengeResponseResponse",{Default:"Default",CancelAuth:"CancelAuth",ProvideCredentials:"ProvideCredentials"});Protocol.inspectorBackend.registerEvent("Network.resourceChangedPriority",["requestId","newPriority","timestamp"]);Protocol.inspectorBackend.registerEvent("Network.requestWillBeSent",["requestId","frameId","loaderId","documentURL","request","timestamp","wallTime","initiator","redirectResponse","type"]);Protocol.inspectorBackend.registerEvent("Network.requestServedFromCache",["requestId"]);Protocol.inspectorBackend.registerEvent("Network.responseReceived",["requestId","frameId","loaderId","timestamp","type","response"]);Protocol.inspectorBackend.registerEvent("Network.dataReceived",["requestId","timestamp","dataLength","encodedDataLength"]);Protocol.inspectorBackend.registerEvent("Network.loadingFinished",["requestId","timestamp","encodedDataLength"]);Protocol.inspectorBackend.registerEvent("Network.loadingFailed",["requestId","timestamp","type","errorText","canceled","blockedReason"]);Protocol.inspectorBackend.registerEvent("Network.webSocketWillSendHandshakeRequest",["requestId","timestamp","wallTime","request"]);Protocol.inspectorBackend.registerEvent("Network.webSocketHandshakeResponseReceived",["requestId","timestamp","response"]);Protocol.inspectorBackend.registerEvent("Network.webSocketCreated",["requestId","url","initiator"]);Protocol.inspectorBackend.registerEvent("Network.webSocketClosed",["requestId","timestamp"]);Protocol.inspectorBackend.registerEvent("Network.webSocketFrameReceived",["requestId","timestamp","response"]);Protocol.inspectorBackend.registerEvent("Network.webSocketFrameError",["requestId","timestamp","errorMessage"]);Protocol.inspectorBackend.registerEvent("Network.webSocketFrameSent",["requestId","timestamp","response"]);Protocol.inspectorBackend.registerEvent("Network.eventSourceMessageReceived",["requestId","timestamp","eventName","eventId","data"]);Protocol.inspectorBackend.registerEvent("Network.requestIntercepted",["interceptionId","request","resourceType","redirectHeaders","redirectStatusCode","redirectUrl","authChallenge"]);Protocol.inspectorBackend.registerCommand("Network.enable",[{"name":"maxTotalBufferSize","type":"number","optional":true},{"name":"maxResourceBufferSize","type":"number","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Network.disable",[],[],false);Protocol.inspectorBackend.registerCommand("Network.setUserAgentOverride",[{"name":"userAgent","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Network.setExtraHTTPHeaders",[{"name":"headers","type":"object","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Network.getResponseBody",[{"name":"requestId","type":"string","optional":false}],["body","base64Encoded"],false);Protocol.inspectorBackend.registerCommand("Network.setBlockedURLs",[{"name":"urls","type":"object","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Network.replayXHR",[{"name":"requestId","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Network.canClearBrowserCache",[],["result"],false);Protocol.inspectorBackend.registerCommand("Network.clearBrowserCache",[],[],false);Protocol.inspectorBackend.registerCommand("Network.canClearBrowserCookies",[],["result"],false);Protocol.inspectorBackend.registerCommand("Network.clearBrowserCookies",[],[],false);Protocol.inspectorBackend.registerCommand("Network.getCookies",[{"name":"urls","type":"object","optional":true}],["cookies"],false);Protocol.inspectorBackend.registerCommand("Network.getAllCookies",[],["cookies"],false);Protocol.inspectorBackend.registerCommand("Network.deleteCookie",[{"name":"cookieName","type":"string","optional":false},{"name":"url","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Network.setCookie",[{"name":"url","type":"string","optional":false},{"name":"name","type":"string","optional":false},{"name":"value","type":"string","optional":false},{"name":"domain","type":"string","optional":true},{"name":"path","type":"string","optional":true},{"name":"secure","type":"boolean","optional":true},{"name":"httpOnly","type":"boolean","optional":true},{"name":"sameSite","type":"string","optional":true},{"name":"expirationDate","type":"number","optional":true}],["success"],false);Protocol.inspectorBackend.registerCommand("Network.canEmulateNetworkConditions",[],["result"],false);Protocol.inspectorBackend.registerCommand("Network.emulateNetworkConditions",[{"name":"offline","type":"boolean","optional":false},{"name":"latency","type":"number","optional":false},{"name":"downloadThroughput","type":"number","optional":false},{"name":"uploadThroughput","type":"number","optional":false},{"name":"connectionType","type":"string","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Network.setCacheDisabled",[{"name":"cacheDisabled","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Network.setBypassServiceWorker",[{"name":"bypass","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Network.setDataSizeLimitsForTest",[{"name":"maxTotalSize","type":"number","optional":false},{"name":"maxResourceSize","type":"number","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Network.getCertificate",[{"name":"origin","type":"string","optional":false}],["tableNames"],false);Protocol.inspectorBackend.registerCommand("Network.enableRequestInterception",[{"name":"enabled","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Network.continueInterceptedRequest",[{"name":"interceptionId","type":"string","optional":false},{"name":"errorReason","type":"string","optional":true},{"name":"rawResponse","type":"string","optional":true},{"name":"url","type":"string","optional":true},{"name":"method","type":"string","optional":true},{"name":"postData","type":"string","optional":true},{"name":"headers","type":"object","optional":true},{"name":"authChallengeResponse","type":"object","optional":true}],[],false);Protocol.inspectorBackend.registerEvent("Database.addDatabase",["database"]);Protocol.inspectorBackend.registerCommand("Database.enable",[],[],false);Protocol.inspectorBackend.registerCommand("Database.disable",[],[],false);Protocol.inspectorBackend.registerCommand("Database.getDatabaseTableNames",[{"name":"databaseId","type":"string","optional":false}],["tableNames"],false);Protocol.inspectorBackend.registerCommand("Database.executeSQL",[{"name":"databaseId","type":"string","optional":false},{"name":"query","type":"string","optional":false}],["columnNames","values","sqlError"],false);Protocol.inspectorBackend.registerEnum("IndexedDB.KeyType",{Number:"number",String:"string",Date:"date",Array:"array"});Protocol.inspectorBackend.registerEnum("IndexedDB.KeyPathType",{Null:"null",String:"string",Array:"array"});Protocol.inspectorBackend.registerCommand("IndexedDB.enable",[],[],false);Protocol.inspectorBackend.registerCommand("IndexedDB.disable",[],[],false);Protocol.inspectorBackend.registerCommand("IndexedDB.requestDatabaseNames",[{"name":"securityOrigin","type":"string","optional":false}],["databaseNames"],false);Protocol.inspectorBackend.registerCommand("IndexedDB.requestDatabase",[{"name":"securityOrigin","type":"string","optional":false},{"name":"databaseName","type":"string","optional":false}],["databaseWithObjectStores"],false);Protocol.inspectorBackend.registerCommand("IndexedDB.requestData",[{"name":"securityOrigin","type":"string","optional":false},{"name":"databaseName","type":"string","optional":false},{"name":"objectStoreName","type":"string","optional":false},{"name":"indexName","type":"string","optional":false},{"name":"skipCount","type":"number","optional":false},{"name":"pageSize","type":"number","optional":false},{"name":"keyRange","type":"object","optional":true}],["objectStoreDataEntries","hasMore"],false);Protocol.inspectorBackend.registerCommand("IndexedDB.clearObjectStore",[{"name":"securityOrigin","type":"string","optional":false},{"name":"databaseName","type":"string","optional":false},{"name":"objectStoreName","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("IndexedDB.deleteDatabase",[{"name":"securityOrigin","type":"string","optional":false},{"name":"databaseName","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("CacheStorage.requestCacheNames",[{"name":"securityOrigin","type":"string","optional":false}],["caches"],false);Protocol.inspectorBackend.registerCommand("CacheStorage.requestEntries",[{"name":"cacheId","type":"string","optional":false},{"name":"skipCount","type":"number","optional":false},{"name":"pageSize","type":"number","optional":false}],["cacheDataEntries","hasMore"],false);Protocol.inspectorBackend.registerCommand("CacheStorage.deleteCache",[{"name":"cacheId","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("CacheStorage.deleteEntry",[{"name":"cacheId","type":"string","optional":false},{"name":"request","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerEvent("DOMStorage.domStorageItemsCleared",["storageId"]);Protocol.inspectorBackend.registerEvent("DOMStorage.domStorageItemRemoved",["storageId","key"]);Protocol.inspectorBackend.registerEvent("DOMStorage.domStorageItemAdded",["storageId","key","newValue"]);Protocol.inspectorBackend.registerEvent("DOMStorage.domStorageItemUpdated",["storageId","key","oldValue","newValue"]);Protocol.inspectorBackend.registerCommand("DOMStorage.enable",[],[],false);Protocol.inspectorBackend.registerCommand("DOMStorage.disable",[],[],false);Protocol.inspectorBackend.registerCommand("DOMStorage.clear",[{"name":"storageId","type":"object","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("DOMStorage.getDOMStorageItems",[{"name":"storageId","type":"object","optional":false}],["entries"],false);Protocol.inspectorBackend.registerCommand("DOMStorage.setDOMStorageItem",[{"name":"storageId","type":"object","optional":false},{"name":"key","type":"string","optional":false},{"name":"value","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("DOMStorage.removeDOMStorageItem",[{"name":"storageId","type":"object","optional":false},{"name":"key","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerEvent("ApplicationCache.applicationCacheStatusUpdated",["frameId","manifestURL","status"]);Protocol.inspectorBackend.registerEvent("ApplicationCache.networkStateUpdated",["isNowOnline"]);Protocol.inspectorBackend.registerCommand("ApplicationCache.getFramesWithManifests",[],["frameIds"],false);Protocol.inspectorBackend.registerCommand("ApplicationCache.enable",[],[],false);Protocol.inspectorBackend.registerCommand("ApplicationCache.getManifestForFrame",[{"name":"frameId","type":"string","optional":false}],["manifestURL"],false);Protocol.inspectorBackend.registerCommand("ApplicationCache.getApplicationCacheForFrame",[{"name":"frameId","type":"string","optional":false}],["applicationCache"],false);Protocol.inspectorBackend.registerEnum("DOM.PseudoType",{FirstLine:"first-line",FirstLetter:"first-letter",Before:"before",After:"after",Backdrop:"backdrop",Selection:"selection",FirstLineInherited:"first-line-inherited",Scrollbar:"scrollbar",ScrollbarThumb:"scrollbar-thumb",ScrollbarButton:"scrollbar-button",ScrollbarTrack:"scrollbar-track",ScrollbarTrackPiece:"scrollbar-track-piece",ScrollbarCorner:"scrollbar-corner",Resizer:"resizer",InputListButton:"input-list-button"});Protocol.inspectorBackend.registerEnum("DOM.ShadowRootType",{UserAgent:"user-agent",Open:"open",Closed:"closed"});Protocol.inspectorBackend.registerEvent("DOM.documentUpdated",[]);Protocol.inspectorBackend.registerEvent("DOM.setChildNodes",["parentId","nodes"]);Protocol.inspectorBackend.registerEvent("DOM.attributeModified",["nodeId","name","value"]);Protocol.inspectorBackend.registerEvent("DOM.attributeRemoved",["nodeId","name"]);Protocol.inspectorBackend.registerEvent("DOM.inlineStyleInvalidated",["nodeIds"]);Protocol.inspectorBackend.registerEvent("DOM.characterDataModified",["nodeId","characterData"]);Protocol.inspectorBackend.registerEvent("DOM.childNodeCountUpdated",["nodeId","childNodeCount"]);Protocol.inspectorBackend.registerEvent("DOM.childNodeInserted",["parentNodeId","previousNodeId","node"]);Protocol.inspectorBackend.registerEvent("DOM.childNodeRemoved",["parentNodeId","nodeId"]);Protocol.inspectorBackend.registerEvent("DOM.shadowRootPushed",["hostId","root"]);Protocol.inspectorBackend.registerEvent("DOM.shadowRootPopped",["hostId","rootId"]);Protocol.inspectorBackend.registerEvent("DOM.pseudoElementAdded",["parentId","pseudoElement"]);Protocol.inspectorBackend.registerEvent("DOM.pseudoElementRemoved",["parentId","pseudoElementId"]);Protocol.inspectorBackend.registerEvent("DOM.distributedNodesUpdated",["insertionPointId","distributedNodes"]);Protocol.inspectorBackend.registerCommand("DOM.enable",[],[],false);Protocol.inspectorBackend.registerCommand("DOM.disable",[],[],false);Protocol.inspectorBackend.registerCommand("DOM.getDocument",[{"name":"depth","type":"number","optional":true},{"name":"pierce","type":"boolean","optional":true}],["root"],false);Protocol.inspectorBackend.registerCommand("DOM.getFlattenedDocument",[{"name":"depth","type":"number","optional":true},{"name":"pierce","type":"boolean","optional":true}],["nodes"],false);Protocol.inspectorBackend.registerCommand("DOM.collectClassNamesFromSubtree",[{"name":"nodeId","type":"number","optional":false}],["classNames"],false);Protocol.inspectorBackend.registerCommand("DOM.requestChildNodes",[{"name":"nodeId","type":"number","optional":false},{"name":"depth","type":"number","optional":true},{"name":"pierce","type":"boolean","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("DOM.querySelector",[{"name":"nodeId","type":"number","optional":false},{"name":"selector","type":"string","optional":false}],["nodeId"],false);Protocol.inspectorBackend.registerCommand("DOM.querySelectorAll",[{"name":"nodeId","type":"number","optional":false},{"name":"selector","type":"string","optional":false}],["nodeIds"],false);Protocol.inspectorBackend.registerCommand("DOM.setNodeName",[{"name":"nodeId","type":"number","optional":false},{"name":"name","type":"string","optional":false}],["nodeId"],false);Protocol.inspectorBackend.registerCommand("DOM.setNodeValue",[{"name":"nodeId","type":"number","optional":false},{"name":"value","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("DOM.removeNode",[{"name":"nodeId","type":"number","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("DOM.setAttributeValue",[{"name":"nodeId","type":"number","optional":false},{"name":"name","type":"string","optional":false},{"name":"value","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("DOM.setAttributesAsText",[{"name":"nodeId","type":"number","optional":false},{"name":"text","type":"string","optional":false},{"name":"name","type":"string","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("DOM.removeAttribute",[{"name":"nodeId","type":"number","optional":false},{"name":"name","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("DOM.getOuterHTML",[{"name":"nodeId","type":"number","optional":false}],["outerHTML"],false);Protocol.inspectorBackend.registerCommand("DOM.setOuterHTML",[{"name":"nodeId","type":"number","optional":false},{"name":"outerHTML","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("DOM.performSearch",[{"name":"query","type":"string","optional":false},{"name":"includeUserAgentShadowDOM","type":"boolean","optional":true}],["searchId","resultCount"],false);Protocol.inspectorBackend.registerCommand("DOM.getSearchResults",[{"name":"searchId","type":"string","optional":false},{"name":"fromIndex","type":"number","optional":false},{"name":"toIndex","type":"number","optional":false}],["nodeIds"],false);Protocol.inspectorBackend.registerCommand("DOM.discardSearchResults",[{"name":"searchId","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("DOM.requestNode",[{"name":"objectId","type":"string","optional":false}],["nodeId"],false);Protocol.inspectorBackend.registerCommand("DOM.highlightRect",[],[],false);Protocol.inspectorBackend.registerCommand("DOM.highlightNode",[],[],false);Protocol.inspectorBackend.registerCommand("DOM.hideHighlight",[],[],false);Protocol.inspectorBackend.registerCommand("DOM.pushNodeByPathToFrontend",[{"name":"path","type":"string","optional":false}],["nodeId"],false);Protocol.inspectorBackend.registerCommand("DOM.pushNodesByBackendIdsToFrontend",[{"name":"backendNodeIds","type":"object","optional":false}],["nodeIds"],false);Protocol.inspectorBackend.registerCommand("DOM.setInspectedNode",[{"name":"nodeId","type":"number","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("DOM.resolveNode",[{"name":"nodeId","type":"number","optional":false},{"name":"objectGroup","type":"string","optional":true}],["object"],false);Protocol.inspectorBackend.registerCommand("DOM.getAttributes",[{"name":"nodeId","type":"number","optional":false}],["attributes"],false);Protocol.inspectorBackend.registerCommand("DOM.copyTo",[{"name":"nodeId","type":"number","optional":false},{"name":"targetNodeId","type":"number","optional":false},{"name":"insertBeforeNodeId","type":"number","optional":true}],["nodeId"],false);Protocol.inspectorBackend.registerCommand("DOM.moveTo",[{"name":"nodeId","type":"number","optional":false},{"name":"targetNodeId","type":"number","optional":false},{"name":"insertBeforeNodeId","type":"number","optional":true}],["nodeId"],false);Protocol.inspectorBackend.registerCommand("DOM.undo",[],[],false);Protocol.inspectorBackend.registerCommand("DOM.redo",[],[],false);Protocol.inspectorBackend.registerCommand("DOM.markUndoableState",[],[],false);Protocol.inspectorBackend.registerCommand("DOM.focus",[{"name":"nodeId","type":"number","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("DOM.setFileInputFiles",[{"name":"nodeId","type":"number","optional":false},{"name":"files","type":"object","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("DOM.getBoxModel",[{"name":"nodeId","type":"number","optional":false}],["model"],false);Protocol.inspectorBackend.registerCommand("DOM.getNodeForLocation",[{"name":"x","type":"number","optional":false},{"name":"y","type":"number","optional":false},{"name":"includeUserAgentShadowDOM","type":"boolean","optional":true}],["nodeId"],false);Protocol.inspectorBackend.registerCommand("DOM.getRelayoutBoundary",[{"name":"nodeId","type":"number","optional":false}],["nodeId"],false);Protocol.inspectorBackend.registerEnum("CSS.StyleSheetOrigin",{Injected:"injected",UserAgent:"user-agent",Inspector:"inspector",Regular:"regular"});Protocol.inspectorBackend.registerEnum("CSS.CSSMediaSource",{MediaRule:"mediaRule",ImportRule:"importRule",LinkedSheet:"linkedSheet",InlineSheet:"inlineSheet"});Protocol.inspectorBackend.registerEvent("CSS.mediaQueryResultChanged",[]);Protocol.inspectorBackend.registerEvent("CSS.fontsUpdated",[]);Protocol.inspectorBackend.registerEvent("CSS.styleSheetChanged",["styleSheetId"]);Protocol.inspectorBackend.registerEvent("CSS.styleSheetAdded",["header"]);Protocol.inspectorBackend.registerEvent("CSS.styleSheetRemoved",["styleSheetId"]);Protocol.inspectorBackend.registerCommand("CSS.enable",[],[],false);Protocol.inspectorBackend.registerCommand("CSS.disable",[],[],false);Protocol.inspectorBackend.registerCommand("CSS.getMatchedStylesForNode",[{"name":"nodeId","type":"number","optional":false}],["inlineStyle","attributesStyle","matchedCSSRules","pseudoElements","inherited","cssKeyframesRules"],false);Protocol.inspectorBackend.registerCommand("CSS.getInlineStylesForNode",[{"name":"nodeId","type":"number","optional":false}],["inlineStyle","attributesStyle"],false);Protocol.inspectorBackend.registerCommand("CSS.getComputedStyleForNode",[{"name":"nodeId","type":"number","optional":false}],["computedStyle"],false);Protocol.inspectorBackend.registerCommand("CSS.getPlatformFontsForNode",[{"name":"nodeId","type":"number","optional":false}],["fonts"],false);Protocol.inspectorBackend.registerCommand("CSS.getStyleSheetText",[{"name":"styleSheetId","type":"string","optional":false}],["text"],false);Protocol.inspectorBackend.registerCommand("CSS.collectClassNames",[{"name":"styleSheetId","type":"string","optional":false}],["classNames"],false);Protocol.inspectorBackend.registerCommand("CSS.setStyleSheetText",[{"name":"styleSheetId","type":"string","optional":false},{"name":"text","type":"string","optional":false}],["sourceMapURL"],false);Protocol.inspectorBackend.registerCommand("CSS.setRuleSelector",[{"name":"styleSheetId","type":"string","optional":false},{"name":"range","type":"object","optional":false},{"name":"selector","type":"string","optional":false}],["selectorList"],false);Protocol.inspectorBackend.registerCommand("CSS.setKeyframeKey",[{"name":"styleSheetId","type":"string","optional":false},{"name":"range","type":"object","optional":false},{"name":"keyText","type":"string","optional":false}],["keyText"],false);Protocol.inspectorBackend.registerCommand("CSS.setStyleTexts",[{"name":"edits","type":"object","optional":false}],["styles"],false);Protocol.inspectorBackend.registerCommand("CSS.setMediaText",[{"name":"styleSheetId","type":"string","optional":false},{"name":"range","type":"object","optional":false},{"name":"text","type":"string","optional":false}],["media"],false);Protocol.inspectorBackend.registerCommand("CSS.createStyleSheet",[{"name":"frameId","type":"string","optional":false}],["styleSheetId"],false);Protocol.inspectorBackend.registerCommand("CSS.addRule",[{"name":"styleSheetId","type":"string","optional":false},{"name":"ruleText","type":"string","optional":false},{"name":"location","type":"object","optional":false}],["rule"],false);Protocol.inspectorBackend.registerCommand("CSS.forcePseudoState",[{"name":"nodeId","type":"number","optional":false},{"name":"forcedPseudoClasses","type":"object","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("CSS.getMediaQueries",[],["medias"],false);Protocol.inspectorBackend.registerCommand("CSS.setEffectivePropertyValueForNode",[{"name":"nodeId","type":"number","optional":false},{"name":"propertyName","type":"string","optional":false},{"name":"value","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("CSS.getBackgroundColors",[{"name":"nodeId","type":"number","optional":false}],["backgroundColors"],false);Protocol.inspectorBackend.registerCommand("CSS.startRuleUsageTracking",[],[],false);Protocol.inspectorBackend.registerCommand("CSS.takeCoverageDelta",[],["coverage"],false);Protocol.inspectorBackend.registerCommand("CSS.stopRuleUsageTracking",[],["ruleUsage"],false);Protocol.inspectorBackend.registerCommand("DOMSnapshot.getSnapshot",[{"name":"computedStyleWhitelist","type":"object","optional":false}],["domNodes","layoutTreeNodes","computedStyles"],false);Protocol.inspectorBackend.registerCommand("IO.read",[{"name":"handle","type":"string","optional":false},{"name":"offset","type":"number","optional":true},{"name":"size","type":"number","optional":true}],["data","eof"],false);Protocol.inspectorBackend.registerCommand("IO.close",[{"name":"handle","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerEnum("DOMDebugger.DOMBreakpointType",{SubtreeModified:"subtree-modified",AttributeModified:"attribute-modified",NodeRemoved:"node-removed"});Protocol.inspectorBackend.registerCommand("DOMDebugger.setDOMBreakpoint",[{"name":"nodeId","type":"number","optional":false},{"name":"type","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("DOMDebugger.removeDOMBreakpoint",[{"name":"nodeId","type":"number","optional":false},{"name":"type","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("DOMDebugger.setEventListenerBreakpoint",[{"name":"eventName","type":"string","optional":false},{"name":"targetName","type":"string","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("DOMDebugger.removeEventListenerBreakpoint",[{"name":"eventName","type":"string","optional":false},{"name":"targetName","type":"string","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("DOMDebugger.setInstrumentationBreakpoint",[{"name":"eventName","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("DOMDebugger.removeInstrumentationBreakpoint",[{"name":"eventName","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("DOMDebugger.setXHRBreakpoint",[{"name":"url","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("DOMDebugger.removeXHRBreakpoint",[{"name":"url","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("DOMDebugger.getEventListeners",[{"name":"objectId","type":"string","optional":false},{"name":"depth","type":"number","optional":true},{"name":"pierce","type":"boolean","optional":true}],["listeners"],false);Protocol.inspectorBackend.registerEvent("Target.targetCreated",["targetInfo"]);Protocol.inspectorBackend.registerEvent("Target.targetDestroyed",["targetId"]);Protocol.inspectorBackend.registerEvent("Target.attachedToTarget",["targetInfo","waitingForDebugger"]);Protocol.inspectorBackend.registerEvent("Target.detachedFromTarget",["targetId"]);Protocol.inspectorBackend.registerEvent("Target.receivedMessageFromTarget",["targetId","message"]);Protocol.inspectorBackend.registerCommand("Target.setDiscoverTargets",[{"name":"discover","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Target.setAutoAttach",[{"name":"autoAttach","type":"boolean","optional":false},{"name":"waitForDebuggerOnStart","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Target.setAttachToFrames",[{"name":"value","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Target.setRemoteLocations",[{"name":"locations","type":"object","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Target.sendMessageToTarget",[{"name":"targetId","type":"string","optional":false},{"name":"message","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Target.getTargetInfo",[{"name":"targetId","type":"string","optional":false}],["targetInfo"],false);Protocol.inspectorBackend.registerCommand("Target.activateTarget",[{"name":"targetId","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Target.closeTarget",[{"name":"targetId","type":"string","optional":false}],["success"],false);Protocol.inspectorBackend.registerCommand("Target.attachToTarget",[{"name":"targetId","type":"string","optional":false}],["success"],false);Protocol.inspectorBackend.registerCommand("Target.detachFromTarget",[{"name":"targetId","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Target.createBrowserContext",[],["browserContextId"],false);Protocol.inspectorBackend.registerCommand("Target.disposeBrowserContext",[{"name":"browserContextId","type":"string","optional":false}],["success"],false);Protocol.inspectorBackend.registerCommand("Target.createTarget",[{"name":"url","type":"string","optional":false},{"name":"width","type":"number","optional":true},{"name":"height","type":"number","optional":true},{"name":"browserContextId","type":"string","optional":true}],["targetId"],false);Protocol.inspectorBackend.registerCommand("Target.getTargets",[],["targetInfos"],false);Protocol.inspectorBackend.registerEnum("ServiceWorker.ServiceWorkerVersionRunningStatus",{Stopped:"stopped",Starting:"starting",Running:"running",Stopping:"stopping"});Protocol.inspectorBackend.registerEnum("ServiceWorker.ServiceWorkerVersionStatus",{New:"new",Installing:"installing",Installed:"installed",Activating:"activating",Activated:"activated",Redundant:"redundant"});Protocol.inspectorBackend.registerEvent("ServiceWorker.workerRegistrationUpdated",["registrations"]);Protocol.inspectorBackend.registerEvent("ServiceWorker.workerVersionUpdated",["versions"]);Protocol.inspectorBackend.registerEvent("ServiceWorker.workerErrorReported",["errorMessage"]);Protocol.inspectorBackend.registerCommand("ServiceWorker.enable",[],[],false);Protocol.inspectorBackend.registerCommand("ServiceWorker.disable",[],[],false);Protocol.inspectorBackend.registerCommand("ServiceWorker.unregister",[{"name":"scopeURL","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("ServiceWorker.updateRegistration",[{"name":"scopeURL","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("ServiceWorker.startWorker",[{"name":"scopeURL","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("ServiceWorker.skipWaiting",[{"name":"scopeURL","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("ServiceWorker.stopWorker",[{"name":"versionId","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("ServiceWorker.inspectWorker",[{"name":"versionId","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("ServiceWorker.setForceUpdateOnPageLoad",[{"name":"forceUpdateOnPageLoad","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("ServiceWorker.deliverPushMessage",[{"name":"origin","type":"string","optional":false},{"name":"registrationId","type":"string","optional":false},{"name":"data","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("ServiceWorker.dispatchSyncEvent",[{"name":"origin","type":"string","optional":false},{"name":"registrationId","type":"string","optional":false},{"name":"tag","type":"string","optional":false},{"name":"lastChance","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerEnum("Input.TouchPointState",{TouchPressed:"touchPressed",TouchReleased:"touchReleased",TouchMoved:"touchMoved",TouchStationary:"touchStationary",TouchCancelled:"touchCancelled"});Protocol.inspectorBackend.registerEnum("Input.GestureSourceType",{Default:"default",Touch:"touch",Mouse:"mouse"});Protocol.inspectorBackend.registerCommand("Input.setIgnoreInputEvents",[{"name":"ignore","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Input.dispatchKeyEvent",[{"name":"type","type":"string","optional":false},{"name":"modifiers","type":"number","optional":true},{"name":"timestamp","type":"number","optional":true},{"name":"text","type":"string","optional":true},{"name":"unmodifiedText","type":"string","optional":true},{"name":"keyIdentifier","type":"string","optional":true},{"name":"code","type":"string","optional":true},{"name":"key","type":"string","optional":true},{"name":"windowsVirtualKeyCode","type":"number","optional":true},{"name":"nativeVirtualKeyCode","type":"number","optional":true},{"name":"autoRepeat","type":"boolean","optional":true},{"name":"isKeypad","type":"boolean","optional":true},{"name":"isSystemKey","type":"boolean","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Input.dispatchMouseEvent",[{"name":"type","type":"string","optional":false},{"name":"x","type":"number","optional":false},{"name":"y","type":"number","optional":false},{"name":"modifiers","type":"number","optional":true},{"name":"timestamp","type":"number","optional":true},{"name":"button","type":"string","optional":true},{"name":"clickCount","type":"number","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Input.dispatchTouchEvent",[{"name":"type","type":"string","optional":false},{"name":"touchPoints","type":"object","optional":false},{"name":"modifiers","type":"number","optional":true},{"name":"timestamp","type":"number","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Input.emulateTouchFromMouseEvent",[{"name":"type","type":"string","optional":false},{"name":"x","type":"number","optional":false},{"name":"y","type":"number","optional":false},{"name":"timestamp","type":"number","optional":false},{"name":"button","type":"string","optional":false},{"name":"deltaX","type":"number","optional":true},{"name":"deltaY","type":"number","optional":true},{"name":"modifiers","type":"number","optional":true},{"name":"clickCount","type":"number","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Input.synthesizePinchGesture",[{"name":"x","type":"number","optional":false},{"name":"y","type":"number","optional":false},{"name":"scaleFactor","type":"number","optional":false},{"name":"relativeSpeed","type":"number","optional":true},{"name":"gestureSourceType","type":"string","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Input.synthesizeScrollGesture",[{"name":"x","type":"number","optional":false},{"name":"y","type":"number","optional":false},{"name":"xDistance","type":"number","optional":true},{"name":"yDistance","type":"number","optional":true},{"name":"xOverscroll","type":"number","optional":true},{"name":"yOverscroll","type":"number","optional":true},{"name":"preventFling","type":"boolean","optional":true},{"name":"speed","type":"number","optional":true},{"name":"gestureSourceType","type":"string","optional":true},{"name":"repeatCount","type":"number","optional":true},{"name":"repeatDelayMs","type":"number","optional":true},{"name":"interactionMarkerName","type":"string","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Input.synthesizeTapGesture",[{"name":"x","type":"number","optional":false},{"name":"y","type":"number","optional":false},{"name":"duration","type":"number","optional":true},{"name":"tapCount","type":"number","optional":true},{"name":"gestureSourceType","type":"string","optional":true}],[],false);Protocol.inspectorBackend.registerEnum("LayerTree.ScrollRectType",{RepaintsOnScroll:"RepaintsOnScroll",TouchEventHandler:"TouchEventHandler",WheelEventHandler:"WheelEventHandler"});Protocol.inspectorBackend.registerEvent("LayerTree.layerTreeDidChange",["layers"]);Protocol.inspectorBackend.registerEvent("LayerTree.layerPainted",["layerId","clip"]);Protocol.inspectorBackend.registerCommand("LayerTree.enable",[],[],false);Protocol.inspectorBackend.registerCommand("LayerTree.disable",[],[],false);Protocol.inspectorBackend.registerCommand("LayerTree.compositingReasons",[{"name":"layerId","type":"string","optional":false}],["compositingReasons"],false);Protocol.inspectorBackend.registerCommand("LayerTree.makeSnapshot",[{"name":"layerId","type":"string","optional":false}],["snapshotId"],false);Protocol.inspectorBackend.registerCommand("LayerTree.loadSnapshot",[{"name":"tiles","type":"object","optional":false}],["snapshotId"],false);Protocol.inspectorBackend.registerCommand("LayerTree.releaseSnapshot",[{"name":"snapshotId","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("LayerTree.profileSnapshot",[{"name":"snapshotId","type":"string","optional":false},{"name":"minRepeatCount","type":"number","optional":true},{"name":"minDuration","type":"number","optional":true},{"name":"clipRect","type":"object","optional":true}],["timings"],false);Protocol.inspectorBackend.registerCommand("LayerTree.replaySnapshot",[{"name":"snapshotId","type":"string","optional":false},{"name":"fromStep","type":"number","optional":true},{"name":"toStep","type":"number","optional":true},{"name":"scale","type":"number","optional":true}],["dataURL"],false);Protocol.inspectorBackend.registerCommand("LayerTree.snapshotCommandLog",[{"name":"snapshotId","type":"string","optional":false}],["commandLog"],false);Protocol.inspectorBackend.registerCommand("DeviceOrientation.setDeviceOrientationOverride",[{"name":"alpha","type":"number","optional":false},{"name":"beta","type":"number","optional":false},{"name":"gamma","type":"number","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("DeviceOrientation.clearDeviceOrientationOverride",[],[],false);Protocol.inspectorBackend.registerEnum("Tracing.TraceConfigRecordMode",{RecordUntilFull:"recordUntilFull",RecordContinuously:"recordContinuously",RecordAsMuchAsPossible:"recordAsMuchAsPossible",EchoToConsole:"echoToConsole"});Protocol.inspectorBackend.registerEvent("Tracing.dataCollected",["value"]);Protocol.inspectorBackend.registerEvent("Tracing.tracingComplete",["stream"]);Protocol.inspectorBackend.registerEvent("Tracing.bufferUsage",["percentFull","eventCount","value"]);Protocol.inspectorBackend.registerCommand("Tracing.start",[{"name":"categories","type":"string","optional":true},{"name":"options","type":"string","optional":true},{"name":"bufferUsageReportingInterval","type":"number","optional":true},{"name":"transferMode","type":"string","optional":true},{"name":"traceConfig","type":"object","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Tracing.end",[],[],false);Protocol.inspectorBackend.registerCommand("Tracing.getCategories",[],["categories"],false);Protocol.inspectorBackend.registerCommand("Tracing.requestMemoryDump",[],["dumpGuid","success"],false);Protocol.inspectorBackend.registerCommand("Tracing.recordClockSyncMarker",[{"name":"syncId","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerEnum("Animation.AnimationType",{CSSTransition:"CSSTransition",CSSAnimation:"CSSAnimation",WebAnimation:"WebAnimation"});Protocol.inspectorBackend.registerEvent("Animation.animationCreated",["id"]);Protocol.inspectorBackend.registerEvent("Animation.animationStarted",["animation"]);Protocol.inspectorBackend.registerEvent("Animation.animationCanceled",["id"]);Protocol.inspectorBackend.registerCommand("Animation.enable",[],[],false);Protocol.inspectorBackend.registerCommand("Animation.disable",[],[],false);Protocol.inspectorBackend.registerCommand("Animation.getPlaybackRate",[],["playbackRate"],false);Protocol.inspectorBackend.registerCommand("Animation.setPlaybackRate",[{"name":"playbackRate","type":"number","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Animation.getCurrentTime",[{"name":"id","type":"string","optional":false}],["currentTime"],false);Protocol.inspectorBackend.registerCommand("Animation.setPaused",[{"name":"animations","type":"object","optional":false},{"name":"paused","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Animation.setTiming",[{"name":"animationId","type":"string","optional":false},{"name":"duration","type":"number","optional":false},{"name":"delay","type":"number","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Animation.seekAnimations",[{"name":"animations","type":"object","optional":false},{"name":"currentTime","type":"number","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Animation.releaseAnimations",[{"name":"animations","type":"object","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Animation.resolveAnimation",[{"name":"animationId","type":"string","optional":false}],["remoteObject"],false);Protocol.inspectorBackend.registerEnum("Accessibility.AXValueType",{Boolean:"boolean",Tristate:"tristate",BooleanOrUndefined:"booleanOrUndefined",Idref:"idref",IdrefList:"idrefList",Integer:"integer",Node:"node",NodeList:"nodeList",Number:"number",String:"string",ComputedString:"computedString",Token:"token",TokenList:"tokenList",DomRelation:"domRelation",Role:"role",InternalRole:"internalRole",ValueUndefined:"valueUndefined"});Protocol.inspectorBackend.registerEnum("Accessibility.AXValueSourceType",{Attribute:"attribute",Implicit:"implicit",Style:"style",Contents:"contents",Placeholder:"placeholder",RelatedElement:"relatedElement"});Protocol.inspectorBackend.registerEnum("Accessibility.AXValueNativeSourceType",{Figcaption:"figcaption",Label:"label",Labelfor:"labelfor",Labelwrapped:"labelwrapped",Legend:"legend",Tablecaption:"tablecaption",Title:"title",Other:"other"});Protocol.inspectorBackend.registerEnum("Accessibility.AXGlobalStates",{Disabled:"disabled",Hidden:"hidden",HiddenRoot:"hiddenRoot",Invalid:"invalid",Keyshortcuts:"keyshortcuts",Roledescription:"roledescription"});Protocol.inspectorBackend.registerEnum("Accessibility.AXLiveRegionAttributes",{Live:"live",Atomic:"atomic",Relevant:"relevant",Busy:"busy",Root:"root"});Protocol.inspectorBackend.registerEnum("Accessibility.AXWidgetAttributes",{Autocomplete:"autocomplete",Haspopup:"haspopup",Level:"level",Multiselectable:"multiselectable",Orientation:"orientation",Multiline:"multiline",Readonly:"readonly",Required:"required",Valuemin:"valuemin",Valuemax:"valuemax",Valuetext:"valuetext"});Protocol.inspectorBackend.registerEnum("Accessibility.AXWidgetStates",{Checked:"checked",Expanded:"expanded",Modal:"modal",Pressed:"pressed",Selected:"selected"});Protocol.inspectorBackend.registerEnum("Accessibility.AXRelationshipAttributes",{Activedescendant:"activedescendant",Controls:"controls",Describedby:"describedby",Details:"details",Errormessage:"errormessage",Flowto:"flowto",Labelledby:"labelledby",Owns:"owns"});Protocol.inspectorBackend.registerCommand("Accessibility.getPartialAXTree",[{"name":"nodeId","type":"number","optional":false},{"name":"fetchRelatives","type":"boolean","optional":true}],["nodes"],false);Protocol.inspectorBackend.registerEnum("Storage.StorageType",{Appcache:"appcache",Cookies:"cookies",File_systems:"file_systems",Indexeddb:"indexeddb",Local_storage:"local_storage",Shader_cache:"shader_cache",Websql:"websql",Service_workers:"service_workers",Cache_storage:"cache_storage",All:"all",Other:"other"});Protocol.inspectorBackend.registerCommand("Storage.clearDataForOrigin",[{"name":"origin","type":"string","optional":false},{"name":"storageTypes","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Storage.getUsageAndQuota",[{"name":"origin","type":"string","optional":false}],["usage","quota","usageBreakdown"],false);Protocol.inspectorBackend.registerEnum("Log.LogEntrySource",{XML:"xml",Javascript:"javascript",Network:"network",Storage:"storage",Appcache:"appcache",Rendering:"rendering",Security:"security",Deprecation:"deprecation",Worker:"worker",Violation:"violation",Intervention:"intervention",Other:"other"});Protocol.inspectorBackend.registerEnum("Log.LogEntryLevel",{Verbose:"verbose",Info:"info",Warning:"warning",Error:"error"});Protocol.inspectorBackend.registerEnum("Log.ViolationSettingName",{LongTask:"longTask",LongLayout:"longLayout",BlockedEvent:"blockedEvent",BlockedParser:"blockedParser",DiscouragedAPIUse:"discouragedAPIUse",Handler:"handler",RecurringHandler:"recurringHandler"});Protocol.inspectorBackend.registerEvent("Log.entryAdded",["entry"]);Protocol.inspectorBackend.registerCommand("Log.enable",[],[],false);Protocol.inspectorBackend.registerCommand("Log.disable",[],[],false);Protocol.inspectorBackend.registerCommand("Log.clear",[],[],false);Protocol.inspectorBackend.registerCommand("Log.startViolationsReport",[{"name":"config","type":"object","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Log.stopViolationsReport",[],[],false);Protocol.inspectorBackend.registerCommand("SystemInfo.getInfo",[],["gpu","modelName","modelVersion","commandLine"],false);Protocol.inspectorBackend.registerEvent("Tethering.accepted",["port","connectionId"]);Protocol.inspectorBackend.registerCommand("Tethering.bind",[{"name":"port","type":"number","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Tethering.unbind",[{"name":"port","type":"number","optional":false}],[],false);Protocol.inspectorBackend.registerEnum("Browser.WindowState",{Normal:"normal",Minimized:"minimized",Maximized:"maximized",Fullscreen:"fullscreen"});Protocol.inspectorBackend.registerCommand("Browser.getWindowForTarget",[{"name":"targetId","type":"string","optional":false}],["windowId","bounds"],false);Protocol.inspectorBackend.registerCommand("Browser.setWindowBounds",[{"name":"windowId","type":"number","optional":false},{"name":"bounds","type":"object","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Browser.getWindowBounds",[{"name":"windowId","type":"number","optional":false}],["bounds"],false);Protocol.inspectorBackend.registerCommand("Schema.getDomains",[],["domains"],false);Protocol.inspectorBackend.registerEnum("Runtime.UnserializableValue",{Infinity:"Infinity",NaN:"NaN",NegativeInfinity:"-Infinity",Negative0:"-0"});Protocol.inspectorBackend.registerEnum("Runtime.RemoteObjectType",{Object:"object",Function:"function",Undefined:"undefined",String:"string",Number:"number",Boolean:"boolean",Symbol:"symbol"});Protocol.inspectorBackend.registerEnum("Runtime.RemoteObjectSubtype",{Array:"array",Null:"null",Node:"node",Regexp:"regexp",Date:"date",Map:"map",Set:"set",Weakmap:"weakmap",Weakset:"weakset",Iterator:"iterator",Generator:"generator",Error:"error",Proxy:"proxy",Promise:"promise",Typedarray:"typedarray"});Protocol.inspectorBackend.registerEnum("Runtime.ObjectPreviewType",{Object:"object",Function:"function",Undefined:"undefined",String:"string",Number:"number",Boolean:"boolean",Symbol:"symbol"});Protocol.inspectorBackend.registerEnum("Runtime.ObjectPreviewSubtype",{Array:"array",Null:"null",Node:"node",Regexp:"regexp",Date:"date",Map:"map",Set:"set",Weakmap:"weakmap",Weakset:"weakset",Iterator:"iterator",Generator:"generator",Error:"error"});Protocol.inspectorBackend.registerEnum("Runtime.PropertyPreviewType",{Object:"object",Function:"function",Undefined:"undefined",String:"string",Number:"number",Boolean:"boolean",Symbol:"symbol",Accessor:"accessor"});Protocol.inspectorBackend.registerEnum("Runtime.PropertyPreviewSubtype",{Array:"array",Null:"null",Node:"node",Regexp:"regexp",Date:"date",Map:"map",Set:"set",Weakmap:"weakmap",Weakset:"weakset",Iterator:"iterator",Generator:"generator",Error:"error"});Protocol.inspectorBackend.registerEvent("Runtime.executionContextCreated",["context"]);Protocol.inspectorBackend.registerEvent("Runtime.executionContextDestroyed",["executionContextId"]);Protocol.inspectorBackend.registerEvent("Runtime.executionContextsCleared",[]);Protocol.inspectorBackend.registerEvent("Runtime.exceptionThrown",["timestamp","exceptionDetails"]);Protocol.inspectorBackend.registerEvent("Runtime.exceptionRevoked",["reason","exceptionId"]);Protocol.inspectorBackend.registerEvent("Runtime.consoleAPICalled",["type","args","executionContextId","timestamp","stackTrace","context"]);Protocol.inspectorBackend.registerEvent("Runtime.inspectRequested",["object","hints"]);Protocol.inspectorBackend.registerCommand("Runtime.evaluate",[{"name":"expression","type":"string","optional":false},{"name":"objectGroup","type":"string","optional":true},{"name":"includeCommandLineAPI","type":"boolean","optional":true},{"name":"silent","type":"boolean","optional":true},{"name":"contextId","type":"number","optional":true},{"name":"returnByValue","type":"boolean","optional":true},{"name":"generatePreview","type":"boolean","optional":true},{"name":"userGesture","type":"boolean","optional":true},{"name":"awaitPromise","type":"boolean","optional":true}],["result","exceptionDetails"],false);Protocol.inspectorBackend.registerCommand("Runtime.awaitPromise",[{"name":"promiseObjectId","type":"string","optional":false},{"name":"returnByValue","type":"boolean","optional":true},{"name":"generatePreview","type":"boolean","optional":true}],["result","exceptionDetails"],false);Protocol.inspectorBackend.registerCommand("Runtime.callFunctionOn",[{"name":"objectId","type":"string","optional":false},{"name":"functionDeclaration","type":"string","optional":false},{"name":"arguments","type":"object","optional":true},{"name":"silent","type":"boolean","optional":true},{"name":"returnByValue","type":"boolean","optional":true},{"name":"generatePreview","type":"boolean","optional":true},{"name":"userGesture","type":"boolean","optional":true},{"name":"awaitPromise","type":"boolean","optional":true}],["result","exceptionDetails"],false);Protocol.inspectorBackend.registerCommand("Runtime.getProperties",[{"name":"objectId","type":"string","optional":false},{"name":"ownProperties","type":"boolean","optional":true},{"name":"accessorPropertiesOnly","type":"boolean","optional":true},{"name":"generatePreview","type":"boolean","optional":true}],["result","internalProperties","exceptionDetails"],false);Protocol.inspectorBackend.registerCommand("Runtime.releaseObject",[{"name":"objectId","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Runtime.releaseObjectGroup",[{"name":"objectGroup","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Runtime.runIfWaitingForDebugger",[],[],false);Protocol.inspectorBackend.registerCommand("Runtime.enable",[],[],false);Protocol.inspectorBackend.registerCommand("Runtime.disable",[],[],false);Protocol.inspectorBackend.registerCommand("Runtime.discardConsoleEntries",[],[],false);Protocol.inspectorBackend.registerCommand("Runtime.setCustomObjectFormatterEnabled",[{"name":"enabled","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Runtime.compileScript",[{"name":"expression","type":"string","optional":false},{"name":"sourceURL","type":"string","optional":false},{"name":"persistScript","type":"boolean","optional":false},{"name":"executionContextId","type":"number","optional":true}],["scriptId","exceptionDetails"],false);Protocol.inspectorBackend.registerCommand("Runtime.runScript",[{"name":"scriptId","type":"string","optional":false},{"name":"executionContextId","type":"number","optional":true},{"name":"objectGroup","type":"string","optional":true},{"name":"silent","type":"boolean","optional":true},{"name":"includeCommandLineAPI","type":"boolean","optional":true},{"name":"returnByValue","type":"boolean","optional":true},{"name":"generatePreview","type":"boolean","optional":true},{"name":"awaitPromise","type":"boolean","optional":true}],["result","exceptionDetails"],false);Protocol.inspectorBackend.registerEnum("Debugger.ScopeType",{Global:"global",Local:"local",With:"with",Closure:"closure",Catch:"catch",Block:"block",Script:"script",Eval:"eval",Module:"module"});Protocol.inspectorBackend.registerEnum("Debugger.BreakLocationType",{DebuggerStatement:"debuggerStatement",Call:"call",Return:"return"});Protocol.inspectorBackend.registerEvent("Debugger.scriptParsed",["scriptId","url","startLine","startColumn","endLine","endColumn","executionContextId","hash","executionContextAuxData","isLiveEdit","sourceMapURL","hasSourceURL","isModule","length","stackTrace"]);Protocol.inspectorBackend.registerEvent("Debugger.scriptFailedToParse",["scriptId","url","startLine","startColumn","endLine","endColumn","executionContextId","hash","executionContextAuxData","sourceMapURL","hasSourceURL","isModule","length","stackTrace"]);Protocol.inspectorBackend.registerEvent("Debugger.breakpointResolved",["breakpointId","location"]);Protocol.inspectorBackend.registerEvent("Debugger.paused",["callFrames","reason","data","hitBreakpoints","asyncStackTrace"]);Protocol.inspectorBackend.registerEvent("Debugger.resumed",[]);Protocol.inspectorBackend.registerCommand("Debugger.enable",[],[],false);Protocol.inspectorBackend.registerCommand("Debugger.disable",[],[],false);Protocol.inspectorBackend.registerCommand("Debugger.setBreakpointsActive",[{"name":"active","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Debugger.setSkipAllPauses",[{"name":"skip","type":"boolean","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Debugger.setBreakpointByUrl",[{"name":"lineNumber","type":"number","optional":false},{"name":"url","type":"string","optional":true},{"name":"urlRegex","type":"string","optional":true},{"name":"columnNumber","type":"number","optional":true},{"name":"condition","type":"string","optional":true}],["breakpointId","locations"],false);Protocol.inspectorBackend.registerCommand("Debugger.setBreakpoint",[{"name":"location","type":"object","optional":false},{"name":"condition","type":"string","optional":true}],["breakpointId","actualLocation"],false);Protocol.inspectorBackend.registerCommand("Debugger.removeBreakpoint",[{"name":"breakpointId","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Debugger.getPossibleBreakpoints",[{"name":"start","type":"object","optional":false},{"name":"end","type":"object","optional":true},{"name":"restrictToFunction","type":"boolean","optional":true}],["locations"],false);Protocol.inspectorBackend.registerCommand("Debugger.continueToLocation",[{"name":"location","type":"object","optional":false},{"name":"targetCallFrames","type":"string","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Debugger.stepOver",[],[],false);Protocol.inspectorBackend.registerCommand("Debugger.stepInto",[],[],false);Protocol.inspectorBackend.registerCommand("Debugger.stepOut",[],[],false);Protocol.inspectorBackend.registerCommand("Debugger.pause",[],[],false);Protocol.inspectorBackend.registerCommand("Debugger.scheduleStepIntoAsync",[],[],false);Protocol.inspectorBackend.registerCommand("Debugger.resume",[],[],false);Protocol.inspectorBackend.registerCommand("Debugger.searchInContent",[{"name":"scriptId","type":"string","optional":false},{"name":"query","type":"string","optional":false},{"name":"caseSensitive","type":"boolean","optional":true},{"name":"isRegex","type":"boolean","optional":true}],["result"],false);Protocol.inspectorBackend.registerCommand("Debugger.setScriptSource",[{"name":"scriptId","type":"string","optional":false},{"name":"scriptSource","type":"string","optional":false},{"name":"dryRun","type":"boolean","optional":true}],["callFrames","stackChanged","asyncStackTrace","exceptionDetails"],false);Protocol.inspectorBackend.registerCommand("Debugger.restartFrame",[{"name":"callFrameId","type":"string","optional":false}],["callFrames","asyncStackTrace"],false);Protocol.inspectorBackend.registerCommand("Debugger.getScriptSource",[{"name":"scriptId","type":"string","optional":false}],["scriptSource"],false);Protocol.inspectorBackend.registerCommand("Debugger.setPauseOnExceptions",[{"name":"state","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Debugger.evaluateOnCallFrame",[{"name":"callFrameId","type":"string","optional":false},{"name":"expression","type":"string","optional":false},{"name":"objectGroup","type":"string","optional":true},{"name":"includeCommandLineAPI","type":"boolean","optional":true},{"name":"silent","type":"boolean","optional":true},{"name":"returnByValue","type":"boolean","optional":true},{"name":"generatePreview","type":"boolean","optional":true},{"name":"throwOnSideEffect","type":"boolean","optional":true}],["result","exceptionDetails"],false);Protocol.inspectorBackend.registerCommand("Debugger.setVariableValue",[{"name":"scopeNumber","type":"number","optional":false},{"name":"variableName","type":"string","optional":false},{"name":"newValue","type":"object","optional":false},{"name":"callFrameId","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Debugger.setAsyncCallStackDepth",[{"name":"maxDepth","type":"number","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Debugger.setBlackboxPatterns",[{"name":"patterns","type":"object","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Debugger.setBlackboxedRanges",[{"name":"scriptId","type":"string","optional":false},{"name":"positions","type":"object","optional":false}],[],false);Protocol.inspectorBackend.registerEvent("Profiler.consoleProfileStarted",["id","location","title"]);Protocol.inspectorBackend.registerEvent("Profiler.consoleProfileFinished",["id","location","profile","title"]);Protocol.inspectorBackend.registerCommand("Profiler.enable",[],[],false);Protocol.inspectorBackend.registerCommand("Profiler.disable",[],[],false);Protocol.inspectorBackend.registerCommand("Profiler.setSamplingInterval",[{"name":"interval","type":"number","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("Profiler.start",[],[],false);Protocol.inspectorBackend.registerCommand("Profiler.stop",[],["profile"],false);Protocol.inspectorBackend.registerCommand("Profiler.startPreciseCoverage",[{"name":"callCount","type":"boolean","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("Profiler.stopPreciseCoverage",[],[],false);Protocol.inspectorBackend.registerCommand("Profiler.takePreciseCoverage",[],["result"],false);Protocol.inspectorBackend.registerCommand("Profiler.getBestEffortCoverage",[],["result"],false);Protocol.inspectorBackend.registerEvent("HeapProfiler.addHeapSnapshotChunk",["chunk"]);Protocol.inspectorBackend.registerEvent("HeapProfiler.resetProfiles",[]);Protocol.inspectorBackend.registerEvent("HeapProfiler.reportHeapSnapshotProgress",["done","total","finished"]);Protocol.inspectorBackend.registerEvent("HeapProfiler.lastSeenObjectId",["lastSeenObjectId","timestamp"]);Protocol.inspectorBackend.registerEvent("HeapProfiler.heapStatsUpdate",["statsUpdate"]);Protocol.inspectorBackend.registerCommand("HeapProfiler.enable",[],[],false);Protocol.inspectorBackend.registerCommand("HeapProfiler.disable",[],[],false);Protocol.inspectorBackend.registerCommand("HeapProfiler.startTrackingHeapObjects",[{"name":"trackAllocations","type":"boolean","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("HeapProfiler.stopTrackingHeapObjects",[{"name":"reportProgress","type":"boolean","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("HeapProfiler.takeHeapSnapshot",[{"name":"reportProgress","type":"boolean","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("HeapProfiler.collectGarbage",[],[],false);Protocol.inspectorBackend.registerCommand("HeapProfiler.getObjectByHeapObjectId",[{"name":"objectId","type":"string","optional":false},{"name":"objectGroup","type":"string","optional":true}],["result"],false);Protocol.inspectorBackend.registerCommand("HeapProfiler.addInspectedHeapObject",[{"name":"heapObjectId","type":"string","optional":false}],[],false);Protocol.inspectorBackend.registerCommand("HeapProfiler.getHeapObjectId",[{"name":"objectId","type":"string","optional":false}],["heapSnapshotObjectId"],false);Protocol.inspectorBackend.registerCommand("HeapProfiler.startSampling",[{"name":"samplingInterval","type":"number","optional":true}],[],false);Protocol.inspectorBackend.registerCommand("HeapProfiler.stopSampling",[],["profile"],false);;