Network.BlockedURLsPane=class extends UI.VBox{constructor(){super(true);this.registerRequiredCSS('network/blockedURLsPane.css');this.contentElement.classList.add('blocked-urls-pane');Network.BlockedURLsPane._instance=this;this._blockedURLsSetting=Common.moduleSetting('networkBlockedURLs');this._blockedURLsSetting.addChangeListener(this._update,this);this._toolbar=new UI.Toolbar('',this.contentElement);this._toolbar.element.addEventListener('click',e=>e.consume());var addButton=new UI.ToolbarButton(Common.UIString('Add pattern'),'largeicon-add');addButton.addEventListener(UI.ToolbarButton.Events.Click,this._addButtonClicked,this);this._toolbar.appendToolbarItem(addButton);var clearButton=new UI.ToolbarButton(Common.UIString('Remove all'),'largeicon-clear');clearButton.addEventListener(UI.ToolbarButton.Events.Click,this._removeAll,this);this._toolbar.appendToolbarItem(clearButton);var enableRequestBlockingCheckbox=new UI.ToolbarSettingCheckbox(Common.moduleSetting('requestBlockingEnabled'));this._toolbar.appendToolbarItem(enableRequestBlockingCheckbox);this._emptyElement=this.contentElement.createChild('div','no-blocked-urls');this._emptyElement.createChild('span').textContent=Common.UIString('Requests are not blocked. ');var addLink=this._emptyElement.createChild('span','link');addLink.textContent=Common.UIString('Add pattern.');addLink.href='';addLink.addEventListener('click',this._addButtonClicked.bind(this),false);this._emptyElement.addEventListener('contextmenu',this._emptyElementContextMenu.bind(this),true);this._listElement=this.contentElement.createChild('div','blocked-urls-list');this._blockedCountForUrl=new Map();SDK.targetManager.addModelListener(SDK.NetworkManager,SDK.NetworkManager.Events.RequestFinished,this._onRequestFinished,this);this._updateThrottler=new Common.Throttler(200);this._update();}
static reset(){if(Network.BlockedURLsPane._instance)
Network.BlockedURLsPane._instance.reset();}
_emptyElementContextMenu(event){var contextMenu=new UI.ContextMenu(event);contextMenu.appendItem(Common.UIString.capitalize('Add ^pattern'),this._addButtonClicked.bind(this));contextMenu.show();}
_addButtonClicked(){this._emptyElement.classList.add('hidden');var element=this._createElement('',this._blockedURLsSetting.get().length);this._listElement.appendChild(element);element.scrollIntoViewIfNeeded();this._edit('',element,this._addBlockedURL.bind(this));}
_edit(content,element,onAccept){this._editing=true;element.classList.add('blocked-url-editing');var input=element.createChild('input');input.setAttribute('type','text');input.value=content;input.placeholder=Common.UIString('Text pattern to block matching requests; use * for wildcard');input.addEventListener('blur',commit.bind(this),false);input.addEventListener('keydown',keydown.bind(this),false);input.focus();function finish(){this._editing=false;element.removeChild(input);element.classList.remove('blocked-url-editing');}
function commit(){if(!this._editing)
return;var text=input.value.trim();finish.call(this);if(text)
onAccept(text);else
this._update();}
function keydown(event){if(isEnterKey(event)){event.consume();commit.call(this);}else if(event.keyCode===UI.KeyboardShortcut.Keys.Esc.code||event.key==='Escape'){event.consume();finish.call(this);this._update();}}}
_addBlockedURL(url){var blocked=this._blockedURLsSetting.get();blocked.push(url);this._blockedURLsSetting.set(blocked);}
_removeBlockedURL(index){var blocked=this._blockedURLsSetting.get();blocked.splice(index,1);this._blockedURLsSetting.set(blocked);}
_changeBlockedURL(index,url){var blocked=this._blockedURLsSetting.get();blocked.splice(index,1,url);this._blockedURLsSetting.set(blocked);}
_removeAll(){this._blockedURLsSetting.set([]);}
_contextMenu(index,event){var contextMenu=new UI.ContextMenu(event);contextMenu.appendItem(Common.UIString.capitalize('Add ^pattern'),this._addButtonClicked.bind(this));contextMenu.appendItem(Common.UIString.capitalize('Remove ^pattern'),this._removeBlockedURL.bind(this,index));contextMenu.appendItem(Common.UIString.capitalize('Remove ^all'),this._removeAll.bind(this));contextMenu.show();}
_update(){if(this._editing)
return Promise.resolve();this._listElement.removeChildren();var blocked=this._blockedURLsSetting.get();for(var index=0;index<blocked.length;index++)
this._listElement.appendChild(this._createElement(blocked[index],index));this._emptyElement.classList.toggle('hidden',!!blocked.length);return Promise.resolve();}
_createElement(url,index){var element=createElementWithClass('div','blocked-url');var label=element.createChild('div','blocked-url-text');label.textContent=url;var count=this._blockedRequestsCount(url);var countElement=element.createChild('div','blocked-count monospace');countElement.textContent=String.sprintf('[%d]',count);countElement.title=Common.UIString(count===1?'%d request blocked by this pattern':'%d requests blocked by this pattern',count);var removeButton=UI.Icon.create('smallicon-cross','remove-icon');element.appendChild(removeButton);removeButton.title=Common.UIString('Remove');removeButton.addEventListener('click',this._removeBlockedURL.bind(this,index),false);element.addEventListener('contextmenu',this._contextMenu.bind(this,index),true);element.addEventListener('dblclick',this._edit.bind(this,url,element,this._changeBlockedURL.bind(this,index)),false);return element;}
_blockedRequestsCount(url){if(!url)
return 0;var result=0;for(var blockedUrl of this._blockedCountForUrl.keys()){if(this._matches(url,blockedUrl))
result+=this._blockedCountForUrl.get(blockedUrl);}
return result;}
_matches(pattern,url){var pos=0;var parts=pattern.split('*');for(var index=0;index<parts.length;index++){var part=parts[index];if(!part.length)
continue;pos=url.indexOf(part,pos);if(pos===-1)
return false;pos+=part.length;}
return true;}
reset(){this._blockedCountForUrl.clear();}
_onRequestFinished(event){var request=(event.data);if(request.wasBlocked()){var count=this._blockedCountForUrl.get(request.url())||0;this._blockedCountForUrl.set(request.url(),count+1);this._updateThrottler.schedule(this._update.bind(this));}}};Network.BlockedURLsPane._instance=null;;Network.EventSourceMessagesView=class extends UI.VBox{constructor(request){super();this.registerRequiredCSS('network/eventSourceMessagesView.css');this.element.classList.add('event-source-messages-view');this._request=request;var columns=([{id:'id',title:Common.UIString('Id'),sortable:true,weight:8},{id:'type',title:Common.UIString('Type'),sortable:true,weight:8},{id:'data',title:Common.UIString('Data'),sortable:false,weight:88},{id:'time',title:Common.UIString('Time'),sortable:true,weight:8}]);this._dataGrid=new DataGrid.SortableDataGrid(columns);this._dataGrid.setStickToBottom(true);this._dataGrid.markColumnAsSortedBy('time',DataGrid.DataGrid.Order.Ascending);this._sortItems();this._dataGrid.addEventListener(DataGrid.DataGrid.Events.SortingChanged,this._sortItems,this);this._dataGrid.setName('EventSourceMessagesView');this._dataGrid.asWidget().show(this.element);}
wasShown(){this._dataGrid.rootNode().removeChildren();var messages=this._request.eventSourceMessages();for(var i=0;i<messages.length;++i)
this._dataGrid.insertChild(new Network.EventSourceMessageNode(messages[i]));this._request.addEventListener(SDK.NetworkRequest.Events.EventSourceMessageAdded,this._messageAdded,this);}
willHide(){this._request.removeEventListener(SDK.NetworkRequest.Events.EventSourceMessageAdded,this._messageAdded,this);}
_messageAdded(event){var message=(event.data);this._dataGrid.insertChild(new Network.EventSourceMessageNode(message));}
_sortItems(){var sortColumnId=this._dataGrid.sortColumnId();if(!sortColumnId)
return;var comparator=Network.EventSourceMessageNode.Comparators[sortColumnId];if(!comparator)
return;this._dataGrid.sortNodes(comparator,!this._dataGrid.isSortOrderAscending());}};Network.EventSourceMessageNode=class extends DataGrid.SortableDataGridNode{constructor(message){var time=new Date(message.time*1000);var timeText=('0'+time.getHours()).substr(-2)+':'+('0'+time.getMinutes()).substr(-2)+':'+
('0'+time.getSeconds()).substr(-2)+'.'+('00'+time.getMilliseconds()).substr(-3);var timeNode=createElement('div');timeNode.createTextChild(timeText);timeNode.title=time.toLocaleString();super({id:message.eventId,type:message.eventName,data:message.data,time:timeNode});this._message=message;}};Network.EventSourceMessageNodeComparator=function(field,a,b){var aValue=a._message[field];var bValue=b._message[field];return aValue<bValue?-1:aValue>bValue?1:0;};Network.EventSourceMessageNode.Comparators={'id':Network.EventSourceMessageNodeComparator.bind(null,'eventId'),'type':Network.EventSourceMessageNodeComparator.bind(null,'eventName'),'time':Network.EventSourceMessageNodeComparator.bind(null,'time')};;Network.FilterSuggestionBuilder=class{constructor(keys){this._keys=keys;this._valueSets={};this._valueLists={};}
completions(expression,prefix,force){if(!prefix&&!force)
return Promise.resolve([]);var negative=prefix.startsWith('-');if(negative)
prefix=prefix.substring(1);var modifier=negative?'-':'';var valueDelimiterIndex=prefix.indexOf(':');var suggestions=[];if(valueDelimiterIndex===-1){var matcher=new RegExp('^'+prefix.escapeForRegExp(),'i');for(var j=0;j<this._keys.length;++j){if(this._keys[j].match(matcher))
suggestions.push({text:modifier+this._keys[j]+':'});}}else{var key=prefix.substring(0,valueDelimiterIndex).toLowerCase();var value=prefix.substring(valueDelimiterIndex+1);var matcher=new RegExp('^'+value.escapeForRegExp(),'i');var items=this._values(key);for(var i=0;i<items.length;++i){if(items[i].match(matcher)&&(items[i]!==value))
suggestions.push({text:modifier+key+':'+items[i]});}}
return Promise.resolve(suggestions);}
_values(key){var result=(this._valueLists[key]);if(!result)
return[];if(key===Network.NetworkLogView.FilterType.Priority){var resultSet=new Set(result);result=[];var numericToPriorityMap=new Map();NetworkConditions.prioritySymbolToNumericMap().forEach((value,key)=>numericToPriorityMap.set(value,key));var sortedNumericPriorities=numericToPriorityMap.keysArray();sortedNumericPriorities.sortNumbers();var sortedPriorities=sortedNumericPriorities.map(value=>numericToPriorityMap.get(value));var sortedPriorityLabels=sortedPriorities.map(value=>NetworkConditions.uiLabelForPriority(value));for(var value of sortedPriorityLabels){if(!resultSet.has(value))
continue;result.push(value);}}else{result.sort();}
return result;}
addItem(key,value){if(!value)
return;var set=this._valueSets[key];var list=this._valueLists[key];if(!set){set={};this._valueSets[key]=set;list=[];this._valueLists[key]=list;}
if(set[value])
return;set[value]=true;list.push(value);}
parseQuery(query){var filters=[];var text=[];var parts=query.split(/\s+/);for(var i=0;i<parts.length;++i){var part=parts[i];if(!part)
continue;var colonIndex=part.indexOf(':');if(colonIndex===-1){text.push(part);continue;}
var key=part.substring(0,colonIndex);var negative=key.startsWith('-');if(negative)
key=key.substring(1);if(this._keys.indexOf(key)===-1){text.push(part);continue;}
var value=part.substring(colonIndex+1);filters.push({type:key,data:value,negative:negative});}
return{text:text,filters:filters};}};Network.FilterSuggestionBuilder.Filter;;Network.HARWriter=class{write(stream,requests,progress){this._stream=stream;this._harLog=(new NetworkLog.HARLog(requests)).build();this._pendingRequests=1;var entries=this._harLog.entries;for(var i=0;i<entries.length;++i){var content=requests[i].content;if(typeof content==='undefined'&&requests[i].finished){++this._pendingRequests;requests[i].requestContent().then(this._onContentAvailable.bind(this,entries[i],requests[i]));}else if(content!==null){this._setEntryContent(entries[i],requests[i]);}}
var compositeProgress=new Common.CompositeProgress(progress);this._writeProgress=compositeProgress.createSubProgress();if(--this._pendingRequests){this._requestsProgress=compositeProgress.createSubProgress();this._requestsProgress.setTitle(Common.UIString('Collecting content…'));this._requestsProgress.setTotalWork(this._pendingRequests);}else{this._beginWrite();}}
_setEntryContent(entry,request){if(request.content!==null)
entry.response.content.text=request.content;if(request.contentEncoded)
entry.response.content.encoding='base64';}
_onContentAvailable(entry,request,content){this._setEntryContent(entry,request);if(this._requestsProgress)
this._requestsProgress.worked();if(!--this._pendingRequests){this._requestsProgress.done();this._beginWrite();}}
_beginWrite(){const jsonIndent=2;this._text=JSON.stringify({log:this._harLog},null,jsonIndent);this._writeProgress.setTitle(Common.UIString('Writing file…'));this._writeProgress.setTotalWork(this._text.length);this._bytesWritten=0;this._writeNextChunk(this._stream);}
_writeNextChunk(stream,error){if(this._bytesWritten>=this._text.length||error){stream.close();this._writeProgress.done();return;}
const chunkSize=100000;var text=this._text.substring(this._bytesWritten,this._bytesWritten+chunkSize);this._bytesWritten+=text.length;stream.write(text,this._writeNextChunk.bind(this));this._writeProgress.setWorked(this._bytesWritten);}};;Network.JSONView=class extends UI.VBox{constructor(parsedJSON){super();this._parsedJSON=parsedJSON;this.element.classList.add('json-view');this._searchableView;this._treeOutline;this._currentSearchFocusIndex=0;this._currentSearchTreeElements=[];this._searchRegex=null;}
static createSearchableView(parsedJSON){var jsonView=new Network.JSONView(parsedJSON);var searchableView=new UI.SearchableView(jsonView);searchableView.setPlaceholder(Common.UIString('Find'));jsonView._searchableView=searchableView;jsonView.show(searchableView.element);jsonView.element.setAttribute('tabIndex',0);return searchableView;}
static parseJSON(text){var returnObj=null;if(text)
returnObj=Network.JSONView._extractJSON((text));if(!returnObj)
return Promise.resolve((null));return Common.formatterWorkerPool.parseJSONRelaxed(returnObj.data).then(handleReturnedJSON);function handleReturnedJSON(data){if(!data)
return null;returnObj.data=data;return returnObj;}}
static _extractJSON(text){if(text.startsWith('<'))
return null;var inner=Network.JSONView._findBrackets(text,'{','}');var inner2=Network.JSONView._findBrackets(text,'[',']');inner=inner2.length>inner.length?inner2:inner;if(inner.length===-1||text.length-inner.length>80)
return null;var prefix=text.substring(0,inner.start);var suffix=text.substring(inner.end+1);text=text.substring(inner.start,inner.end+1);if(suffix.trim().length&&!(suffix.trim().startsWith(')')&&prefix.trim().endsWith('(')))
return null;return new Network.ParsedJSON(text,prefix,suffix);}
static _findBrackets(text,open,close){var start=text.indexOf(open);var end=text.lastIndexOf(close);var length=end-start-1;if(start===-1||end===-1||end<start)
length=-1;return{start:start,end:end,length:length};}
wasShown(){this._initialize();}
_initialize(){if(this._initialized)
return;this._initialized=true;var obj=SDK.RemoteObject.fromLocalObject(this._parsedJSON.data);var title=this._parsedJSON.prefix+obj.description+this._parsedJSON.suffix;this._treeOutline=new ObjectUI.ObjectPropertiesSection(obj,title);this._treeOutline.setEditable(false);this._treeOutline.expand();this.element.appendChild(this._treeOutline.element);}
_jumpToMatch(index){if(!this._searchRegex)
return;var previousFocusElement=this._currentSearchTreeElements[this._currentSearchFocusIndex];if(previousFocusElement)
previousFocusElement.setSearchRegex(this._searchRegex);var newFocusElement=this._currentSearchTreeElements[index];if(newFocusElement){this._updateSearchIndex(index);newFocusElement.setSearchRegex(this._searchRegex,UI.highlightedCurrentSearchResultClassName);newFocusElement.reveal();}else{this._updateSearchIndex(0);}}
_updateSearchCount(count){if(!this._searchableView)
return;this._searchableView.updateSearchMatchesCount(count);}
_updateSearchIndex(index){this._currentSearchFocusIndex=index;if(!this._searchableView)
return;this._searchableView.updateCurrentMatchIndex(index);}
searchCanceled(){this._searchRegex=null;this._currentSearchTreeElements=[];for(var element=this._treeOutline.rootElement();element;element=element.traverseNextTreeElement(false)){if(!(element instanceof ObjectUI.ObjectPropertyTreeElement))
continue;element.revertHighlightChanges();}
this._updateSearchCount(0);this._updateSearchIndex(0);}
performSearch(searchConfig,shouldJump,jumpBackwards){var newIndex=this._currentSearchFocusIndex;var previousSearchFocusElement=this._currentSearchTreeElements[newIndex];this.searchCanceled();this._searchRegex=searchConfig.toSearchRegex(true);for(var element=this._treeOutline.rootElement();element;element=element.traverseNextTreeElement(false)){if(!(element instanceof ObjectUI.ObjectPropertyTreeElement))
continue;var hasMatch=element.setSearchRegex(this._searchRegex);if(hasMatch)
this._currentSearchTreeElements.push(element);if(previousSearchFocusElement===element){var currentIndex=this._currentSearchTreeElements.length-1;if(hasMatch||jumpBackwards)
newIndex=currentIndex;else
newIndex=currentIndex+1;}}
this._updateSearchCount(this._currentSearchTreeElements.length);if(!this._currentSearchTreeElements.length){this._updateSearchIndex(0);return;}
newIndex=mod(newIndex,this._currentSearchTreeElements.length);this._jumpToMatch(newIndex);}
jumpToNextSearchResult(){if(!this._currentSearchTreeElements.length)
return;var newIndex=mod(this._currentSearchFocusIndex+1,this._currentSearchTreeElements.length);this._jumpToMatch(newIndex);}
jumpToPreviousSearchResult(){if(!this._currentSearchTreeElements.length)
return;var newIndex=mod(this._currentSearchFocusIndex-1,this._currentSearchTreeElements.length);this._jumpToMatch(newIndex);}
supportsCaseSensitiveSearch(){return true;}
supportsRegexSearch(){return true;}};Network.ParsedJSON=class{constructor(data,prefix,suffix){this.data=data;this.prefix=prefix;this.suffix=suffix;}};;Network.RequestView=class extends UI.VBox{constructor(request){super();this.element.classList.add('request-view');this.request=request;}
static hasTextContent(request){if(request.resourceType().isTextType())
return true;if(request.resourceType()===Common.resourceTypes.Other||request.hasErrorStatusCode())
return!!request.content&&!request.contentEncoded;return false;}
static nonSourceViewForRequest(request){switch(request.resourceType()){case Common.resourceTypes.Image:return new SourceFrame.ImageView(request.mimeType,request);case Common.resourceTypes.Font:return new SourceFrame.FontView(request.mimeType,request);default:return new Network.RequestView(request);}}};;Network.NetworkConfigView=class extends UI.VBox{constructor(){super(true);this._autoCheckbox;this._customSelectAndInput;this.registerRequiredCSS('network/networkConfigView.css');this.contentElement.classList.add('network-config');this._createCacheSection();this.contentElement.createChild('div').classList.add('panel-section-separator');this._createNetworkThrottlingSection();this.contentElement.createChild('div').classList.add('panel-section-separator');this._createUserAgentSection();}
static createUserAgentSelectAndInput(){var userAgentSetting=Common.settings.createSetting('customUserAgent','');var userAgentSelectElement=createElement('select');const customOverride={title:Common.UIString('Custom...'),value:'custom'};userAgentSelectElement.appendChild(new Option(customOverride.title,customOverride.value));var groups=Network.NetworkConfigView._userAgentGroups;for(var userAgentDescriptor of groups){var groupElement=userAgentSelectElement.createChild('optgroup');groupElement.label=userAgentDescriptor.title;for(var userAgentVersion of userAgentDescriptor.values){var userAgentValue=SDK.MultitargetNetworkManager.patchUserAgentWithChromeVersion(userAgentVersion.value);groupElement.appendChild(new Option(userAgentVersion.title,userAgentValue));}}
userAgentSelectElement.selectedIndex=0;var otherUserAgentElement=createElement('input');otherUserAgentElement.type='text';otherUserAgentElement.value=userAgentSetting.get();otherUserAgentElement.title=userAgentSetting.get();otherUserAgentElement.placeholder=Common.UIString('Enter a custom user agent');otherUserAgentElement.required=true;settingChanged();userAgentSelectElement.addEventListener('change',userAgentSelected,false);otherUserAgentElement.addEventListener('input',applyOtherUserAgent,false);function userAgentSelected(){var value=userAgentSelectElement.options[userAgentSelectElement.selectedIndex].value;if(value!==customOverride.value){userAgentSetting.set(value);otherUserAgentElement.value=value;otherUserAgentElement.title=value;}else{otherUserAgentElement.select();}}
function settingChanged(){var value=userAgentSetting.get();var options=userAgentSelectElement.options;var selectionRestored=false;for(var i=0;i<options.length;++i){if(options[i].value===value){userAgentSelectElement.selectedIndex=i;selectionRestored=true;break;}}
if(!selectionRestored)
userAgentSelectElement.selectedIndex=0;}
function applyOtherUserAgent(){if(userAgentSetting.get()!==otherUserAgentElement.value){userAgentSetting.set(otherUserAgentElement.value);otherUserAgentElement.title=otherUserAgentElement.value;settingChanged();}}
return{select:userAgentSelectElement,input:otherUserAgentElement};}
_createSection(title,className){var section=this.contentElement.createChild('section','network-config-group');if(className)
section.classList.add(className);section.createChild('div','network-config-title').textContent=title;return section.createChild('div','network-config-fields');}
_createCacheSection(){var section=this._createSection(Common.UIString('Caching'),'network-config-disable-cache');section.appendChild(UI.SettingsUI.createSettingCheckbox(Common.UIString('Disable cache'),Common.moduleSetting('cacheDisabled'),true));}
_createNetworkThrottlingSection(){var section=this._createSection(Common.UIString('Network throttling'),'network-config-throttling');NetworkConditions.NetworkConditionsSelector.decorateSelect((section.createChild('select','chrome-select')));}
_createUserAgentSection(){var section=this._createSection(Common.UIString('User agent'),'network-config-ua');var checkboxLabel=UI.createCheckboxLabel(Common.UIString('Select automatically'),true);section.appendChild(checkboxLabel);this._autoCheckbox=checkboxLabel.checkboxElement;this._autoCheckbox.addEventListener('change',this._userAgentTypeChanged.bind(this));this._customUserAgentSetting=Common.settings.createSetting('customUserAgent','');this._customUserAgentSetting.addChangeListener(this._customUserAgentChanged,this);this._customUserAgent=section.createChild('div','network-config-ua-custom');this._customSelectAndInput=Network.NetworkConfigView.createUserAgentSelectAndInput();this._customSelectAndInput.select.classList.add('chrome-select');this._customUserAgent.appendChild(this._customSelectAndInput.select);this._customUserAgent.appendChild(this._customSelectAndInput.input);this._userAgentTypeChanged();}
_customUserAgentChanged(){if(this._autoCheckbox.checked)
return;SDK.multitargetNetworkManager.setCustomUserAgentOverride(this._customUserAgentSetting.get());}
_userAgentTypeChanged(){var useCustomUA=!this._autoCheckbox.checked;this._customUserAgent.classList.toggle('checked',useCustomUA);this._customSelectAndInput.select.disabled=!useCustomUA;this._customSelectAndInput.input.disabled=!useCustomUA;var customUA=useCustomUA?this._customUserAgentSetting.get():'';SDK.multitargetNetworkManager.setCustomUserAgentOverride(customUA);}};Network.NetworkConfigView._userAgentGroups=[{title:'Android',values:[{title:'Android (4.0.2) Browser \u2014 Galaxy Nexus',value:'Mozilla/5.0 (Linux; U; Android 4.0.2; en-us; Galaxy Nexus Build/ICL53F) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30'},{title:'Android (2.3) Browser \u2014 Nexus S',value:'Mozilla/5.0 (Linux; U; Android 2.3.6; en-us; Nexus S Build/GRK39F) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1'}]},{title:'BlackBerry',values:[{title:'BlackBerry \u2014 BB10',value:'Mozilla/5.0 (BB10; Touch) AppleWebKit/537.1+ (KHTML, like Gecko) Version/10.0.0.1337 Mobile Safari/537.1+'},{title:'BlackBerry \u2014 PlayBook 2.1',value:'Mozilla/5.0 (PlayBook; U; RIM Tablet OS 2.1.0; en-US) AppleWebKit/536.2+ (KHTML, like Gecko) Version/7.2.1.0 Safari/536.2+'},{title:'BlackBerry \u2014 9900',value:'Mozilla/5.0 (BlackBerry; U; BlackBerry 9900; en-US) AppleWebKit/534.11+ (KHTML, like Gecko) Version/7.0.0.187 Mobile Safari/534.11+'}]},{title:'Chrome',values:[{title:'Chrome \u2014 Android Mobile',value:'Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36'},{title:'Chrome \u2014 Android Tablet',value:'Mozilla/5.0 (Linux; Android 4.3; Nexus 7 Build/JSS15Q) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Safari/537.36'},{title:'Chrome \u2014 iPhone',value:'Mozilla/5.0 (iPhone; CPU iPhone OS 9_1 like Mac OS X) AppleWebKit/601.1 (KHTML, like Gecko) CriOS/%s Mobile/13B143 Safari/601.1.46'},{title:'Chrome \u2014 iPad',value:'Mozilla/5.0 (iPad; CPU OS 9_1 like Mac OS X) AppleWebKit/601.1 (KHTML, like Gecko) CriOS/%s Mobile/13B143 Safari/601.1.46'},{title:'Chrome \u2014 Mac',value:'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Safari/537.36'},{title:'Chrome \u2014 Windows',value:'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Safari/537.36'}]},{title:'Edge',values:[{title:'Edge \u2014 Windows',value:'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/42.0.2311.135 Safari/537.36 Edge/12.10240'},{title:'Edge \u2014 Mobile',value:'Mozilla/5.0 (Windows Phone 10.0; Android 4.2.1; Microsoft; Lumia 640 XL LTE) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/42.0.2311.135 Mobile Safari/537.36 Edge/12.10166'},{title:'Edge \u2014 XBox',value:'Mozilla/5.0 (Windows NT 10.0; Win64; x64; Xbox; Xbox One) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/42.0.2311.135 Safari/537.36 Edge/13.10586'}]},{title:'Firefox',values:[{title:'Firefox \u2014 Android Mobile',value:'Mozilla/5.0 (Android 4.4; Mobile; rv:46.0) Gecko/46.0 Firefox/46.0'},{title:'Firefox \u2014 Android Tablet',value:'Mozilla/5.0 (Android 4.4; Tablet; rv:46.0) Gecko/46.0 Firefox/46.0'},{title:'Firefox \u2014 iPhone',value:'Mozilla/5.0 (iPhone; CPU iPhone OS 8_3 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) FxiOS/1.0 Mobile/12F69 Safari/600.1.4'},{title:'Firefox \u2014 iPad',value:'Mozilla/5.0 (iPad; CPU iPhone OS 8_3 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) FxiOS/1.0 Mobile/12F69 Safari/600.1.4'},{title:'Firefox \u2014 Mac',value:'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:46.0) Gecko/20100101 Firefox/46.0'},{title:'Firefox \u2014 Windows',value:'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:46.0) Gecko/20100101 Firefox/46.0'}]},{title:'Googlebot',values:[{title:'Googlebot',value:'Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)'},{title:'Googlebot Smartphone',value:'Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.96 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)'}]},{title:'Internet Explorer',values:[{title:'Internet Explorer 11',value:'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko'},{title:'Internet Explorer 10',value:'Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; WOW64; Trident/6.0)'},{title:'Internet Explorer 9',value:'Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0)'},{title:'Internet Explorer 8',value:'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0)'},{title:'Internet Explorer 7',value:'Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)'}]},{title:'Opera',values:[{title:'Opera \u2014 Mac',value:'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.87 Safari/537.36 OPR/37.0.2178.31'},{title:'Opera \u2014 Windows',value:'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.87 Safari/537.36 OPR/37.0.2178.31'},{title:'Opera (Presto) \u2014 Mac',value:'Opera/9.80 (Macintosh; Intel Mac OS X 10.9.1) Presto/2.12.388 Version/12.16'},{title:'Opera (Presto) \u2014 Windows',value:'Opera/9.80 (Windows NT 6.1) Presto/2.12.388 Version/12.16'},{title:'Opera Mobile \u2014 Android Mobile',value:'Opera/12.02 (Android 4.1; Linux; Opera Mobi/ADR-1111101157; U; en-US) Presto/2.9.201 Version/12.02'},{title:'Opera Mini \u2014 iOS',value:'Opera/9.80 (iPhone; Opera Mini/8.0.0/34.2336; U; en) Presto/2.8.119 Version/11.10'}]},{title:'Safari',values:[{title:'Safari \u2014 iPad iOS 9',value:'Mozilla/5.0 (iPad; CPU OS 9_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13B137 Safari/601.1'},{title:'Safari \u2014 iPhone iOS 9',value:'Mozilla/5.0 (iPhone; CPU iPhone OS 9_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13B137 Safari/601.1'},{title:'Safari \u2014 Mac',value:'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_3) AppleWebKit/537.75.14 (KHTML, like Gecko) Version/7.0.3 Safari/7046A194A'}]},{title:'UC Browser',values:[{title:'UC Browser \u2014 Android Mobile',value:'Mozilla/5.0 (Linux; U; Android 4.4.4; en-US; XT1022 Build/KXC21.5-40) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.7.0.636 U3/0.8.0 Mobile Safari/534.30'},{title:'UC Browser \u2014 iOS',value:'UCWEB/2.0 (iPad; U; CPU OS 7_1 like Mac OS X; en; iPad3,6) U2/1.0.0 UCBrowser/9.3.1.344'},{title:'UC Browser \u2014 Windows Phone',value:'NokiaX2-02/2.0 (11.79) Profile/MIDP-2.1 Configuration/CLDC-1.1 Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0; SLCC2;.NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; InfoPath.2) UCBrowser8.4.0.159/70/352'}]}];;Network.NetworkNode=class extends DataGrid.SortableDataGridNode{constructor(parentView){super({});this._parentView=parentView;this._columnExtensions=new Map();this._isHovered=false;this._showingInitiatorChain=false;this._requestOrFirstKnownChildRequest=null;}
parentView(){return this._parentView;}
hovered(){return this._isHovered;}
showingInitiatorChain(){return this._showingInitiatorChain;}
nodeSelfHeight(){return this._parentView.rowHeight();}
setColumnExtensions(columnExtensions){this._columnExtensions=columnExtensions;}
setHovered(hovered,showInitiatorChain){if(this._isHovered===hovered&&this._showingInitiatorChain===showInitiatorChain)
return;if(this._isHovered!==hovered){this._isHovered=hovered;if(this.attached())
this.element().classList.toggle('hover',hovered);}
if(this._showingInitiatorChain!==showInitiatorChain){this._showingInitiatorChain=showInitiatorChain;this.showingInitiatorChainChanged();}
this._parentView.stylesChanged();}
showingInitiatorChainChanged(){}
isOnInitiatorPath(){return false;}
isOnInitiatedPath(){return false;}
request(){return null;}
isNavigationRequest(){return false;}
asRequestNode(){return null;}
asGroupNode(){return null;}
clearFlatNodes(){super.clearFlatNodes();this._requestOrFirstKnownChildRequest=null;}
requestOrFirstKnownChildRequest(){if(this._requestOrFirstKnownChildRequest)
return this._requestOrFirstKnownChildRequest;var request=this.request();if(request||!this.hasChildren()){this._requestOrFirstKnownChildRequest=request;return this._requestOrFirstKnownChildRequest;}
var firstChildRequest=null;var flatChildren=this.flatChildren();for(var i=0;i<flatChildren.length;i++){request=flatChildren[i].request();if(!firstChildRequest||(request&&request.issueTime()<firstChildRequest.issueTime()))
firstChildRequest=request;}
this._requestOrFirstKnownChildRequest=firstChildRequest;return this._requestOrFirstKnownChildRequest;}};Network.NetworkRequestNode=class extends Network.NetworkNode{constructor(parentView,request){super(parentView);this._nameCell=null;this._initiatorCell=null;this._linkifiedInitiatorAnchor=null;this._request=request;this._isNavigationRequest=false;this.selectable=true;this._isOnInitiatorPath=false;this._isOnInitiatedPath=false;}
static NameComparator(a,b){var aGroupNode=a.asGroupNode();var bGroupNode=b.asGroupNode();if((!aGroupNode&&bGroupNode)||(aGroupNode&&!bGroupNode))
return aGroupNode?1:-1;var aName;var bName;if(aGroupNode&&bGroupNode){aName=aGroupNode.displayName();bName=bGroupNode.displayName();if(aName===bName)
return Network.NetworkRequestNode.RequestPropertyComparator('startTime',a,b);}else{var aRequest=a.requestOrFirstKnownChildRequest();var bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return aRequest?1:-1;aName=aRequest.name();bName=bRequest.name();if(aName===bName)
return aRequest.indentityCompare(bRequest);}
return aName<bName?-1:1;}
static RemoteAddressComparator(a,b){var aRequest=a.requestOrFirstKnownChildRequest();var bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return!aRequest?-1:1;var aRemoteAddress=aRequest.remoteAddress();var bRemoteAddress=bRequest.remoteAddress();if(aRemoteAddress>bRemoteAddress)
return 1;if(bRemoteAddress>aRemoteAddress)
return-1;return aRequest.indentityCompare(bRequest);}
static SizeComparator(a,b){var aRequest=a.requestOrFirstKnownChildRequest();var bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return!aRequest?-1:1;if(bRequest.cached()&&!aRequest.cached())
return 1;if(aRequest.cached()&&!bRequest.cached())
return-1;return(aRequest.transferSize-bRequest.transferSize)||aRequest.indentityCompare(bRequest);}
static TypeComparator(a,b){var aRequest=a.requestOrFirstKnownChildRequest();var bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return!aRequest?-1:1;var aSimpleType=a.asRequestNode().displayType();var bSimpleType=b.asRequestNode().displayType();if(aSimpleType>bSimpleType)
return 1;if(bSimpleType>aSimpleType)
return-1;return aRequest.indentityCompare(bRequest);}
static InitiatorComparator(a,b){var aRequest=a.requestOrFirstKnownChildRequest();var bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return!aRequest?-1:1;var aInitiator=NetworkLog.networkLog.initiatorInfoForRequest(aRequest);var bInitiator=NetworkLog.networkLog.initiatorInfoForRequest(bRequest);if(aInitiator.type<bInitiator.type)
return-1;if(aInitiator.type>bInitiator.type)
return 1;if(typeof aInitiator.__source==='undefined')
aInitiator.__source=Bindings.displayNameForURL(aInitiator.url);if(typeof bInitiator.__source==='undefined')
bInitiator.__source=Bindings.displayNameForURL(bInitiator.url);if(aInitiator.__source<bInitiator.__source)
return-1;if(aInitiator.__source>bInitiator.__source)
return 1;if(aInitiator.lineNumber<bInitiator.lineNumber)
return-1;if(aInitiator.lineNumber>bInitiator.lineNumber)
return 1;if(aInitiator.columnNumber<bInitiator.columnNumber)
return-1;if(aInitiator.columnNumber>bInitiator.columnNumber)
return 1;return aRequest.indentityCompare(bRequest);}
static RequestCookiesCountComparator(a,b){var aRequest=a.requestOrFirstKnownChildRequest();var bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return!aRequest?-1:1;var aScore=aRequest.requestCookies?aRequest.requestCookies.length:0;var bScore=bRequest.requestCookies?bRequest.requestCookies.length:0;return(aScore-bScore)||aRequest.indentityCompare(bRequest);}
static ResponseCookiesCountComparator(a,b){var aRequest=a.requestOrFirstKnownChildRequest();var bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return!aRequest?-1:1;var aScore=aRequest.responseCookies?aRequest.responseCookies.length:0;var bScore=bRequest.responseCookies?bRequest.responseCookies.length:0;return(aScore-bScore)||aRequest.indentityCompare(bRequest);}
static InitialPriorityComparator(a,b){var aRequest=a.requestOrFirstKnownChildRequest();var bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return!aRequest?-1:1;var priorityMap=NetworkConditions.prioritySymbolToNumericMap();var aPriority=aRequest.initialPriority();var aScore=aPriority?priorityMap.get(aPriority):0;aScore=aScore||0;var bPriority=aRequest.initialPriority();var bScore=bPriority?priorityMap.get(bPriority):0;bScore=bScore||0;return aScore-bScore||aRequest.indentityCompare(bRequest);}
static RequestPropertyComparator(propertyName,a,b){var aRequest=a.requestOrFirstKnownChildRequest();var bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return!aRequest?-1:1;var aValue=aRequest[propertyName];var bValue=bRequest[propertyName];if(aValue===bValue)
return aRequest.indentityCompare(bRequest);return aValue>bValue?1:-1;}
static ResponseHeaderStringComparator(propertyName,a,b){var aRequest=a.requestOrFirstKnownChildRequest();var bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return!aRequest?-1:1;var aValue=String(aRequest.responseHeaderValue(propertyName)||'');var bValue=String(bRequest.responseHeaderValue(propertyName)||'');return aValue.localeCompare(bValue)||aRequest.indentityCompare(bRequest);}
static ResponseHeaderNumberComparator(propertyName,a,b){var aRequest=a.requestOrFirstKnownChildRequest();var bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return!aRequest?-1:1;var aValue=(aRequest.responseHeaderValue(propertyName)!==undefined)?parseFloat(aRequest.responseHeaderValue(propertyName)):-Infinity;var bValue=(bRequest.responseHeaderValue(propertyName)!==undefined)?parseFloat(bRequest.responseHeaderValue(propertyName)):-Infinity;if(aValue===bValue)
return aRequest.indentityCompare(bRequest);return aValue>bValue?1:-1;}
static ResponseHeaderDateComparator(propertyName,a,b){var aRequest=a.requestOrFirstKnownChildRequest();var bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return!aRequest?-1:1;var aHeader=aRequest.responseHeaderValue(propertyName);var bHeader=bRequest.responseHeaderValue(propertyName);var aValue=aHeader?new Date(aHeader).getTime():-Infinity;var bValue=bHeader?new Date(bHeader).getTime():-Infinity;if(aValue===bValue)
return aRequest.indentityCompare(bRequest);return aValue>bValue?1:-1;}
static ExtensionColumnComparator(extensionsMap,extensionId,a,b){var aRequest=a.requestOrFirstKnownChildRequest();var bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return!aRequest?-1:1;var instance=extensionsMap.get(extensionId);if(!instance)
return aRequest.indentityCompare(bRequest);return instance.requestComparator(aRequest,bRequest);}
showingInitiatorChainChanged(){var showInitiatorChain=this.showingInitiatorChain();var initiatorGraph=NetworkLog.networkLog.initiatorGraphForRequest(this._request);for(var request of initiatorGraph.initiators){if(request===this._request)
continue;var node=this.parentView().nodeForRequest(request);if(!node)
continue;node._setIsOnInitiatorPath(showInitiatorChain);}
for(var request of initiatorGraph.initiated){if(request===this._request)
continue;var node=this.parentView().nodeForRequest(request);if(!node)
continue;node._setIsOnInitiatedPath(showInitiatorChain);}}
_setIsOnInitiatorPath(isOnInitiatorPath){if(this._isOnInitiatorPath===isOnInitiatorPath||!this.attached())
return;this._isOnInitiatorPath=isOnInitiatorPath;this.element().classList.toggle('network-node-on-initiator-path',isOnInitiatorPath);}
isOnInitiatorPath(){return this._isOnInitiatorPath;}
_setIsOnInitiatedPath(isOnInitiatedPath){if(this._isOnInitiatedPath===isOnInitiatedPath||!this.attached())
return;this._isOnInitiatedPath=isOnInitiatedPath;this.element().classList.toggle('network-node-on-initiated-path',isOnInitiatedPath);}
isOnInitiatedPath(){return this._isOnInitiatedPath;}
displayType(){var mimeType=this._request.mimeType||this._request.requestContentType()||'';var resourceType=this._request.resourceType();var simpleType=resourceType.name();if(resourceType===Common.resourceTypes.Other||resourceType===Common.resourceTypes.Image)
simpleType=mimeType.replace(/^(application|image)\//,'');return simpleType;}
request(){return this._request;}
asRequestNode(){return this;}
isNavigationRequest(){return this._isNavigationRequest;}
markAsNavigationRequest(){this._isNavigationRequest=true;this.refresh();}
nodeSelfHeight(){return this.parentView().rowHeight();}
createCells(element){this._nameCell=null;this._initiatorCell=null;element.classList.toggle('network-error-row',this._isFailed());element.classList.toggle('network-navigation-row',this._isNavigationRequest);super.createCells(element);}
_setTextAndTitle(element,text){element.textContent=text;element.title=text;}
createCell(columnIdentifier){var cell=this.createTD(columnIdentifier);if(this._columnExtensions.has(columnIdentifier)){var instance=this._columnExtensions.get(columnIdentifier);if(instance)
this._setTextAndTitle(cell,instance.lookupColumnValue(this._request));return cell;}
switch(columnIdentifier){case'name':this._renderNameCell(cell);break;case'method':this._setTextAndTitle(cell,this._request.requestMethod);break;case'status':this._renderStatusCell(cell);break;case'protocol':this._setTextAndTitle(cell,this._request.protocol);break;case'scheme':this._setTextAndTitle(cell,this._request.scheme);break;case'domain':this._setTextAndTitle(cell,this._request.domain);break;case'remoteaddress':this._setTextAndTitle(cell,this._request.remoteAddress());break;case'cookies':this._setTextAndTitle(cell,this._arrayLength(this._request.requestCookies));break;case'setcookies':this._setTextAndTitle(cell,this._arrayLength(this._request.responseCookies));break;case'priority':var priority=this._request.initialPriority();this._setTextAndTitle(cell,priority?NetworkConditions.uiLabelForPriority(priority):'');break;case'connectionid':this._setTextAndTitle(cell,this._request.connectionId);break;case'type':this._setTextAndTitle(cell,this.displayType());break;case'initiator':this._renderInitiatorCell(cell);break;case'size':this._renderSizeCell(cell);break;case'time':this._renderTimeCell(cell);break;case'timeline':this._setTextAndTitle(cell,'');break;default:this._setTextAndTitle(cell,this._request.responseHeaderValue(columnIdentifier)||'');break;}
return cell;}
_arrayLength(array){return array?''+array.length:'';}
willAttach(){if(this._initiatorCell&&NetworkLog.networkLog.initiatorInfoForRequest(this._request).type===SDK.NetworkRequest.InitiatorType.Script)
this._initiatorCell.insertBefore(this._linkifiedInitiatorAnchor,this._initiatorCell.firstChild);}
wasDetached(){if(this._linkifiedInitiatorAnchor)
this._linkifiedInitiatorAnchor.remove();}
dispose(){if(this._linkifiedInitiatorAnchor)
this.parentView().linkifier.disposeAnchor(this._request.target(),this._linkifiedInitiatorAnchor);}
select(supressSelectedEvent){super.select(supressSelectedEvent);this.parentView().dispatchEventToListeners(Network.NetworkLogView.Events.RequestSelected,this._request);}
highlightMatchedSubstring(regexp){this.element();var domChanges=[];var matchInfo=this._nameCell.textContent.match(regexp);if(matchInfo)
UI.highlightSearchResult(this._nameCell,matchInfo.index,matchInfo[0].length,domChanges);return domChanges;}
_openInNewTab(){InspectorFrontendHost.openInNewTab(this._request.url());}
_isFailed(){return(this._request.failed&&!this._request.statusCode)||(this._request.statusCode>=400);}
_renderNameCell(cell){var leftPadding=this.leftPadding?this.leftPadding+'px':'';cell.style.setProperty('padding-left',leftPadding);this._nameCell=cell;cell.addEventListener('dblclick',this._openInNewTab.bind(this),false);var iconElement;if(this._request.resourceType()===Common.resourceTypes.Image){var previewImage=createElementWithClass('img','image-network-icon-preview');this._request.populateImageSource(previewImage);iconElement=createElementWithClass('div','icon');iconElement.appendChild(previewImage);}else{iconElement=createElementWithClass('img','icon');}
iconElement.classList.add(this._request.resourceType().name());cell.appendChild(iconElement);cell.createTextChild(this._request.target().decorateLabel(this._request.name()));this._appendSubtitle(cell,this._request.path());cell.title=this._request.url();}
_renderStatusCell(cell){cell.classList.toggle('network-dim-cell',!this._isFailed()&&(this._request.cached()||!this._request.statusCode));if(this._request.failed&&!this._request.canceled&&!this._request.wasBlocked()){var failText=Common.UIString('(failed)');if(this._request.localizedFailDescription){cell.createTextChild(failText);this._appendSubtitle(cell,this._request.localizedFailDescription);cell.title=failText+' '+this._request.localizedFailDescription;}else{this._setTextAndTitle(cell,failText);}}else if(this._request.statusCode){cell.createTextChild(''+this._request.statusCode);this._appendSubtitle(cell,this._request.statusText);cell.title=this._request.statusCode+' '+this._request.statusText;}else if(this._request.parsedURL.isDataURL()){this._setTextAndTitle(cell,Common.UIString('(data)'));}else if(this._request.canceled){this._setTextAndTitle(cell,Common.UIString('(canceled)'));}else if(this._request.wasBlocked()){var reason=Common.UIString('other');switch(this._request.blockedReason()){case Protocol.Network.BlockedReason.Csp:reason=Common.UIString('csp');break;case Protocol.Network.BlockedReason.MixedContent:reason=Common.UIString('mixed-content');break;case Protocol.Network.BlockedReason.Origin:reason=Common.UIString('origin');break;case Protocol.Network.BlockedReason.Inspector:reason=Common.UIString('devtools');break;case Protocol.Network.BlockedReason.Other:reason=Common.UIString('other');break;}
this._setTextAndTitle(cell,Common.UIString('(blocked:%s)',reason));}else if(this._request.finished){this._setTextAndTitle(cell,Common.UIString('Finished'));}else{this._setTextAndTitle(cell,Common.UIString('(pending)'));}}
_renderInitiatorCell(cell){this._initiatorCell=cell;var request=this._request;var initiator=NetworkLog.networkLog.initiatorInfoForRequest(request);if(request.timing&&request.timing.pushStart)
cell.appendChild(createTextNode(Common.UIString('Push / ')));switch(initiator.type){case SDK.NetworkRequest.InitiatorType.Parser:cell.title=initiator.url+':'+(initiator.lineNumber+1);var uiSourceCode=Workspace.workspace.uiSourceCodeForURL(initiator.url);cell.appendChild(Components.Linkifier.linkifyURL(initiator.url,uiSourceCode?uiSourceCode.displayName():undefined,'',initiator.lineNumber,initiator.columnNumber));this._appendSubtitle(cell,Common.UIString('Parser'));break;case SDK.NetworkRequest.InitiatorType.Redirect:cell.title=initiator.url;console.assert(request.redirectSource);var redirectSource=(request.redirectSource);if(this.parentView().nodeForRequest(redirectSource)){cell.appendChild(Components.Linkifier.linkifyRevealable(redirectSource,Bindings.displayNameForURL(redirectSource.url())));}else{cell.appendChild(Components.Linkifier.linkifyURL(redirectSource.url()));}
this._appendSubtitle(cell,Common.UIString('Redirect'));break;case SDK.NetworkRequest.InitiatorType.Script:if(!this._linkifiedInitiatorAnchor){this._linkifiedInitiatorAnchor=this.parentView().linkifier.linkifyScriptLocation(request.target(),initiator.scriptId,initiator.url,initiator.lineNumber,initiator.columnNumber);this._linkifiedInitiatorAnchor.title='';}
cell.appendChild(this._linkifiedInitiatorAnchor);this._appendSubtitle(cell,Common.UIString('Script'));cell.classList.add('network-script-initiated');cell.request=request;break;case SDK.NetworkRequest.InitiatorType.Preload:cell.title=Common.UIString('Preload');cell.classList.add('network-dim-cell');cell.appendChild(createTextNode(Common.UIString('Preload')));break;default:cell.title=Common.UIString('Other');cell.classList.add('network-dim-cell');cell.appendChild(createTextNode(Common.UIString('Other')));}}
_renderSizeCell(cell){if(this._request.fetchedViaServiceWorker){this._setTextAndTitle(cell,Common.UIString('(from ServiceWorker)'));cell.classList.add('network-dim-cell');}else if(this._request.cached()){if(this._request.cachedInMemory())
this._setTextAndTitle(cell,Common.UIString('(from memory cache)'));else
this._setTextAndTitle(cell,Common.UIString('(from disk cache)'));cell.classList.add('network-dim-cell');}else{var resourceSize=Number.bytesToString(this._request.resourceSize);var transferSize=Number.bytesToString(this._request.transferSize);this._setTextAndTitle(cell,transferSize);this._appendSubtitle(cell,resourceSize);}}
_renderTimeCell(cell){if(this._request.duration>0){this._setTextAndTitle(cell,Number.secondsToString(this._request.duration));this._appendSubtitle(cell,Number.secondsToString(this._request.latency));}else{cell.classList.add('network-dim-cell');this._setTextAndTitle(cell,Common.UIString('Pending'));}}
_appendSubtitle(cellElement,subtitleText){var subtitleElement=createElement('div');subtitleElement.className='network-cell-subtitle';subtitleElement.textContent=subtitleText;cellElement.appendChild(subtitleElement);}};Network.NetworkGroupNode=class extends Network.NetworkNode{constructor(parentView,displayName,sortKey){super(parentView);this._displayName=displayName;this._name=sortKey;}
asGroupNode(){return this;}
displayName(){return this._displayName;}
_setTextAndTitle(element,text){element.textContent=text;element.title=text;}
createCell(columnIdentifier){var cell=this.createTD(columnIdentifier);if(this._columnExtensions.has(columnIdentifier))
return cell;if(columnIdentifier==='name'){var leftPadding=this.leftPadding?this.leftPadding+'px':'';cell.style.setProperty('padding-left',leftPadding);cell.classList.add('disclosure');this._setTextAndTitle(cell,this._displayName);}
return cell;}
select(supressSelectedEvent){if(this.expanded){this.collapse();return;}
this.expand();}};;Network.NetworkItemView=class extends UI.TabbedPane{constructor(request,calculator){super();this.renderWithNoHeaderBackground();this.element.classList.add('network-item-view');this._resourceViewTabSetting=Common.settings.createSetting('resourceViewTab','preview');var headersView=new Network.RequestHeadersView(request);this.appendTab('headers',Common.UIString('Headers'),headersView);this.addEventListener(UI.TabbedPane.Events.TabSelected,this._tabSelected,this);if(request.resourceType()===Common.resourceTypes.WebSocket){var frameView=new Network.ResourceWebSocketFrameView(request);this.appendTab('webSocketFrames',Common.UIString('Frames'),frameView);}else if(request.mimeType==='text/event-stream'){this.appendTab('eventSource',Common.UIString('EventStream'),new Network.EventSourceMessagesView(request));}else{var responseView=new Network.RequestResponseView(request);var previewView=new Network.RequestPreviewView(request,responseView);this.appendTab('preview',Common.UIString('Preview'),previewView);this.appendTab('response',Common.UIString('Response'),responseView);}
if(request.requestCookies||request.responseCookies){this._cookiesView=new Network.RequestCookiesView(request);this.appendTab('cookies',Common.UIString('Cookies'),this._cookiesView);}
this.appendTab('timing',Common.UIString('Timing'),new Network.RequestTimingView(request,calculator));this._request=request;}
wasShown(){super.wasShown();this._selectTab();}
_selectTab(tabId){if(!tabId)
tabId=this._resourceViewTabSetting.get();if(!this.selectTab(tabId))
this.selectTab('headers');}
_tabSelected(event){if(!event.data.isUserGesture)
return;this._resourceViewTabSetting.set(event.data.tabId);}
request(){return this._request;}};Network.RequestContentView=class extends Network.RequestView{constructor(request){super(request);}
wasShown(){this._ensureInnerViewShown();}
_ensureInnerViewShown(){if(this._innerViewShowRequested)
return;this._innerViewShowRequested=true;function callback(content){this._innerViewShowRequested=false;this.contentLoaded();}
this.request.requestContent().then(callback.bind(this));}
contentLoaded(){}};;Network.NetworkTimeBoundary=class{constructor(minimum,maximum){this.minimum=minimum;this.maximum=maximum;}
equals(other){return(this.minimum===other.minimum)&&(this.maximum===other.maximum);}};Network.NetworkTimeCalculator=class extends Common.Object{constructor(startAtZero){super();this.startAtZero=startAtZero;this._minimumBoundary=-1;this._maximumBoundary=-1;this._boundryChangedEventThrottler=new Common.Throttler(0);this._window=null;}
setWindow(window){this._window=window;this._boundaryChanged();}
setInitialUserFriendlyBoundaries(){this._minimumBoundary=0;this._maximumBoundary=1;}
computePosition(time){return(time-this.minimumBoundary())/this.boundarySpan()*this._workingArea;}
formatValue(value,precision){return Number.secondsToString(value,!!precision);}
minimumBoundary(){return this._window?this._window.minimum:this._minimumBoundary;}
zeroTime(){return this._minimumBoundary;}
maximumBoundary(){return this._window?this._window.maximum:this._maximumBoundary;}
boundary(){return new Network.NetworkTimeBoundary(this.minimumBoundary(),this.maximumBoundary());}
boundarySpan(){return this.maximumBoundary()-this.minimumBoundary();}
reset(){this._minimumBoundary=-1;this._maximumBoundary=-1;this._boundaryChanged();}
_value(item){return 0;}
setDisplayWidth(clientWidth){this._workingArea=clientWidth;}
computeBarGraphPercentages(request){if(request.startTime!==-1)
var start=((request.startTime-this.minimumBoundary())/this.boundarySpan())*100;else
var start=0;if(request.responseReceivedTime!==-1)
var middle=((request.responseReceivedTime-this.minimumBoundary())/this.boundarySpan())*100;else
var middle=(this.startAtZero?start:100);if(request.endTime!==-1)
var end=((request.endTime-this.minimumBoundary())/this.boundarySpan())*100;else
var end=(this.startAtZero?middle:100);if(this.startAtZero){end-=start;middle-=start;start=0;}
return{start:start,middle:middle,end:end};}
computePercentageFromEventTime(eventTime){if(eventTime!==-1&&!this.startAtZero)
return((eventTime-this.minimumBoundary())/this.boundarySpan())*100;return 0;}
percentageToTime(percentage){return percentage*this.boundarySpan()/100+this.minimumBoundary();}
_boundaryChanged(){this._boundryChangedEventThrottler.schedule(dispatchEvent.bind(this));function dispatchEvent(){this.dispatchEventToListeners(Network.NetworkTimeCalculator.Events.BoundariesChanged);return Promise.resolve();}}
updateBoundariesForEventTime(eventTime){if(eventTime===-1||this.startAtZero)
return;if(this._maximumBoundary===undefined||eventTime>this._maximumBoundary){this._maximumBoundary=eventTime;this._boundaryChanged();}}
computeBarGraphLabels(request){var rightLabel='';if(request.responseReceivedTime!==-1&&request.endTime!==-1)
rightLabel=Number.secondsToString(request.endTime-request.responseReceivedTime);var hasLatency=request.latency>0;if(hasLatency)
var leftLabel=Number.secondsToString(request.latency);else
var leftLabel=rightLabel;if(request.timing)
return{left:leftLabel,right:rightLabel};if(hasLatency&&rightLabel){var total=Number.secondsToString(request.duration);var tooltip=Network.NetworkTimeCalculator._latencyDownloadTotalFormat.format(leftLabel,rightLabel,total);}else if(hasLatency){var tooltip=Network.NetworkTimeCalculator._latencyFormat.format(leftLabel);}else if(rightLabel){var tooltip=Network.NetworkTimeCalculator._downloadFormat.format(rightLabel);}
if(request.fetchedViaServiceWorker)
tooltip=Network.NetworkTimeCalculator._fromServiceWorkerFormat.format(tooltip);else if(request.cached())
tooltip=Network.NetworkTimeCalculator._fromCacheFormat.format(tooltip);return{left:leftLabel,right:rightLabel,tooltip:tooltip};}
updateBoundaries(request){var lowerBound=this._lowerBound(request);var upperBound=this._upperBound(request);var changed=false;if(lowerBound!==-1||this.startAtZero)
changed=this._extendBoundariesToIncludeTimestamp(this.startAtZero?0:lowerBound);if(upperBound!==-1)
changed=this._extendBoundariesToIncludeTimestamp(upperBound)||changed;if(changed)
this._boundaryChanged();}
_extendBoundariesToIncludeTimestamp(timestamp){var previousMinimumBoundary=this._minimumBoundary;var previousMaximumBoundary=this._maximumBoundary;const minOffset=Network.NetworkTimeCalculator._minimumSpread;if(this._minimumBoundary===-1||this._maximumBoundary===-1){this._minimumBoundary=timestamp;this._maximumBoundary=timestamp+minOffset;}else{this._minimumBoundary=Math.min(timestamp,this._minimumBoundary);this._maximumBoundary=Math.max(timestamp,this._minimumBoundary+minOffset,this._maximumBoundary);}
return previousMinimumBoundary!==this._minimumBoundary||previousMaximumBoundary!==this._maximumBoundary;}
_lowerBound(request){return 0;}
_upperBound(request){return 0;}};Network.NetworkTimeCalculator._minimumSpread=0.1;Network.NetworkTimeCalculator.Events={BoundariesChanged:Symbol('BoundariesChanged')};Network.NetworkTimeCalculator._latencyDownloadTotalFormat=new Common.UIStringFormat('%s latency, %s download (%s total)');Network.NetworkTimeCalculator._latencyFormat=new Common.UIStringFormat('%s latency');Network.NetworkTimeCalculator._downloadFormat=new Common.UIStringFormat('%s download');Network.NetworkTimeCalculator._fromServiceWorkerFormat=new Common.UIStringFormat('%s (from ServiceWorker)');Network.NetworkTimeCalculator._fromCacheFormat=new Common.UIStringFormat('%s (from cache)');Network.NetworkTransferTimeCalculator=class extends Network.NetworkTimeCalculator{constructor(){super(false);}
formatValue(value,precision){return Number.secondsToString(value-this.zeroTime(),!!precision);}
_lowerBound(request){return request.issueTime();}
_upperBound(request){return request.endTime;}};Network.NetworkTransferDurationCalculator=class extends Network.NetworkTimeCalculator{constructor(){super(true);}
formatValue(value,precision){return Number.secondsToString(value,!!precision);}
_upperBound(request){return request.duration;}};;Network.NetworkLogView=class extends UI.VBox{constructor(filterBar,progressBarContainer,networkLogLargeRowsSetting){super();this.setMinimumSize(50,64);this.registerRequiredCSS('network/networkLogView.css');this._networkHideDataURLSetting=Common.settings.createSetting('networkHideDataURL',false);this._networkResourceTypeFiltersSetting=Common.settings.createSetting('networkResourceTypeFilters',{});this._filterBar=filterBar;this._progressBarContainer=progressBarContainer;this._networkLogLargeRowsSetting=networkLogLargeRowsSetting;this._networkLogLargeRowsSetting.addChangeListener(updateRowHeight.bind(this),this);this._timeCalculator=new Network.NetworkTransferTimeCalculator();this._durationCalculator=new Network.NetworkTransferDurationCalculator();this._calculator=this._timeCalculator;this._activeGroupLookup=null;function updateRowHeight(){this._rowHeight=!!this._networkLogLargeRowsSetting.get()?41:21;}
updateRowHeight.call(this);this._columns=new Network.NetworkLogViewColumns(this,this._timeCalculator,this._durationCalculator,networkLogLargeRowsSetting);this._nodesByRequestId=new Map();this._nodeGroups=new Map();this._staleRequestIds={};this._mainRequestLoadTime=-1;this._mainRequestDOMContentLoadedTime=-1;this._matchedRequestCount=0;this._highlightedSubstringChanges=[];this._filters=[];this._timeFilter=null;this._hoveredNode=null;this._currentMatchedRequestNode=null;this._currentMatchedRequestIndex=-1;this.linkifier=new Components.Linkifier();this._recording=false;this._preserveLog=false;this._headerHeight=0;this._addFilters();this._resetSuggestionBuilder();this._initializeView();Common.moduleSetting('networkColorCodeResourceTypes').addChangeListener(this._invalidateAllItems.bind(this,false),this);SDK.targetManager.observeTargets(this);SDK.targetManager.addModelListener(SDK.NetworkManager,SDK.NetworkManager.Events.RequestStarted,this._onRequestStarted,this);SDK.targetManager.addModelListener(SDK.NetworkManager,SDK.NetworkManager.Events.RequestUpdated,this._onRequestUpdated,this);SDK.targetManager.addModelListener(SDK.NetworkManager,SDK.NetworkManager.Events.RequestFinished,this._onRequestUpdated,this);}
static _negativeFilter(filter,request){return!filter(request);}
static _requestPathFilter(regex,request){if(!regex)
return false;return regex.test(request.path()+'/'+request.name());}
static _subdomains(domain){var result=[domain];var indexOfPeriod=domain.indexOf('.');while(indexOfPeriod!==-1){result.push('*'+domain.substring(indexOfPeriod));indexOfPeriod=domain.indexOf('.',indexOfPeriod+1);}
return result;}
static _createRequestDomainFilter(value){function escapeForRegExp(string){return string.escapeForRegExp();}
var escapedPattern=value.split('*').map(escapeForRegExp).join('.*');return Network.NetworkLogView._requestDomainFilter.bind(null,new RegExp('^'+escapedPattern+'$','i'));}
static _requestDomainFilter(regex,request){return regex.test(request.domain);}
static _runningRequestFilter(request){return!request.finished;}
static _fromCacheRequestFilter(request){return request.cached();}
static _requestResponseHeaderFilter(value,request){return request.responseHeaderValue(value)!==undefined;}
static _requestMethodFilter(value,request){return request.requestMethod===value;}
static _requestPriorityFilter(value,request){return request.initialPriority()===value;}
static _requestMimeTypeFilter(value,request){return request.mimeType===value;}
static _requestMixedContentFilter(value,request){if(value===Network.NetworkLogView.MixedContentFilterValues.Displayed)
return request.mixedContentType==='optionally-blockable';else if(value===Network.NetworkLogView.MixedContentFilterValues.Blocked)
return request.mixedContentType==='blockable'&&request.wasBlocked();else if(value===Network.NetworkLogView.MixedContentFilterValues.BlockOverridden)
return request.mixedContentType==='blockable'&&!request.wasBlocked();else if(value===Network.NetworkLogView.MixedContentFilterValues.All)
return request.mixedContentType!=='none';return false;}
static _requestSchemeFilter(value,request){return request.scheme===value;}
static _requestSetCookieDomainFilter(value,request){var cookies=request.responseCookies;for(var i=0,l=cookies?cookies.length:0;i<l;++i){if(cookies[i].domain()===value)
return true;}
return false;}
static _requestSetCookieNameFilter(value,request){var cookies=request.responseCookies;for(var i=0,l=cookies?cookies.length:0;i<l;++i){if(cookies[i].name()===value)
return true;}
return false;}
static _requestSetCookieValueFilter(value,request){var cookies=request.responseCookies;for(var i=0,l=cookies?cookies.length:0;i<l;++i){if(cookies[i].value()===value)
return true;}
return false;}
static _requestSizeLargerThanFilter(value,request){return request.transferSize>=value;}
static _statusCodeFilter(value,request){return(''+request.statusCode)===value;}
static HTTPRequestsFilter(request){return request.parsedURL.isValid&&(request.scheme in Network.NetworkLogView.HTTPSchemas);}
static FinishedRequestsFilter(request){return request.finished;}
static _requestTimeFilter(windowStart,windowEnd,request){if(request.issueTime()>windowEnd)
return false;if(request.endTime!==-1&&request.endTime<windowStart)
return false;return true;}
setGrouping(grouping){this._activeGroupLookup=grouping;this._invalidateAllItems();}
nodeForRequest(request){return this._nodesByRequestId.get(request.requestId());}
headerHeight(){return this._headerHeight;}
setRecording(recording){this._recording=recording;this._updateSummaryBar();}
setPreserveLog(preserveLog){this._preserveLog=preserveLog;}
targetAdded(target){if(!target.parentTarget()){var resourceTreeModel=SDK.ResourceTreeModel.fromTarget(target);if(resourceTreeModel){resourceTreeModel.addEventListener(SDK.ResourceTreeModel.Events.MainFrameNavigated,this._mainFrameNavigated,this);resourceTreeModel.addEventListener(SDK.ResourceTreeModel.Events.Load,this._loadEventFired,this);resourceTreeModel.addEventListener(SDK.ResourceTreeModel.Events.DOMContentLoaded,this._domContentLoadedEventFired,this);}}
NetworkLog.networkLog.requestsForTarget(target).forEach(this._appendRequest.bind(this));}
targetRemoved(target){if(!target.parentTarget()){var resourceTreeModel=SDK.ResourceTreeModel.fromTarget(target);if(resourceTreeModel){resourceTreeModel.removeEventListener(SDK.ResourceTreeModel.Events.MainFrameNavigated,this._mainFrameNavigated,this);resourceTreeModel.removeEventListener(SDK.ResourceTreeModel.Events.Load,this._loadEventFired,this);resourceTreeModel.removeEventListener(SDK.ResourceTreeModel.Events.DOMContentLoaded,this._domContentLoadedEventFired,this);}}}
setWindow(start,end){if(!start&&!end){this._timeFilter=null;this._timeCalculator.setWindow(null);}else{this._timeFilter=Network.NetworkLogView._requestTimeFilter.bind(null,start,end);this._timeCalculator.setWindow(new Network.NetworkTimeBoundary(start,end));}
this._filterRequests();}
clearSelection(){if(this._dataGrid.selectedNode)
this._dataGrid.selectedNode.deselect();}
_addFilters(){this._textFilterUI=new UI.TextFilterUI(true);this._textFilterUI.addEventListener(UI.FilterUI.Events.FilterChanged,this._filterChanged,this);this._filterBar.addFilter(this._textFilterUI);var dataURLSetting=this._networkHideDataURLSetting;this._dataURLFilterUI=new UI.CheckboxFilterUI('hide-data-url',Common.UIString('Hide data URLs'),true,dataURLSetting);this._dataURLFilterUI.addEventListener(UI.FilterUI.Events.FilterChanged,this._filterChanged.bind(this),this);this._filterBar.addFilter(this._dataURLFilterUI);var filterItems=[];for(var categoryId in Common.resourceCategories){var category=Common.resourceCategories[categoryId];filterItems.push({name:category.title,label:category.shortTitle,title:category.title});}
this._resourceCategoryFilterUI=new UI.NamedBitSetFilterUI(filterItems,this._networkResourceTypeFiltersSetting);this._resourceCategoryFilterUI.addEventListener(UI.FilterUI.Events.FilterChanged,this._filterChanged.bind(this),this);this._filterBar.addFilter(this._resourceCategoryFilterUI);}
_resetSuggestionBuilder(){this._suggestionBuilder=new Network.FilterSuggestionBuilder(Network.NetworkLogView._searchKeys);this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.Is,Network.NetworkLogView.IsFilterType.Running);this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.Is,Network.NetworkLogView.IsFilterType.FromCache);this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.LargerThan,'100');this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.LargerThan,'10k');this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.LargerThan,'1M');this._textFilterUI.setSuggestionProvider(this._suggestionBuilder.completions.bind(this._suggestionBuilder));}
_filterChanged(event){this.removeAllNodeHighlights();this._parseFilterQuery(this._textFilterUI.value());this._filterRequests();}
_initializeView(){this.element.id='network-container';this._setupDataGrid();this._columns.show(this.element);this._summaryBarElement=this.element.createChild('div','network-summary-bar');this._columns.sortByCurrentColumn();}
_showRecordingHint(){this._hideRecordingHint();this._recordingHint=this.element.createChild('div','network-status-pane fill');var hintText=this._recordingHint.createChild('div','recording-hint');var reloadShortcutNode=this._recordingHint.createChild('b');reloadShortcutNode.textContent=UI.shortcutRegistry.shortcutDescriptorsForAction('main.reload')[0].name;if(this._recording){var recordingText=hintText.createChild('span');recordingText.textContent=Common.UIString('Recording network activity\u2026');hintText.createChild('br');hintText.appendChild(UI.formatLocalized('Perform a request or hit %s to record the reload.',[reloadShortcutNode]));}else{var recordNode=hintText.createChild('b');recordNode.textContent=UI.shortcutRegistry.shortcutTitleForAction('network.toggle-recording');hintText.appendChild(UI.formatLocalized('Record (%s) or reload (%s) to display network activity.',[recordNode,reloadShortcutNode]));}}
_hideRecordingHint(){if(this._recordingHint)
this._recordingHint.remove();delete this._recordingHint;}
elementsToRestoreScrollPositionsFor(){if(!this._dataGrid)
return[];return[this._dataGrid.scrollContainer];}
columnExtensionResolved(){this._invalidateAllItems(true);}
_setupDataGrid(){this._dataGrid=this._columns.dataGrid();this._dataGrid.setRowContextMenuCallback((contextMenu,node)=>{var request=node.request();if(request)
this.handleContextMenuForRequest(contextMenu,request);});this._dataGrid.setStickToBottom(true);this._dataGrid.setName('networkLog');this._dataGrid.setResizeMethod(DataGrid.DataGrid.ResizeMethod.Last);this._dataGrid.element.classList.add('network-log-grid');this._dataGrid.element.addEventListener('mousedown',this._dataGridMouseDown.bind(this),true);this._dataGrid.element.addEventListener('mousemove',this._dataGridMouseMove.bind(this),true);this._dataGrid.element.addEventListener('mouseleave',()=>this._setHoveredNode(null),true);}
_dataGridMouseMove(event){var node=(this._dataGrid.dataGridNodeFromNode((event.target)));var highlightInitiatorChain=event.shiftKey;this._setHoveredNode(node,highlightInitiatorChain);}
_setHoveredNode(node,highlightInitiatorChain){if(this._hoveredNode)
this._hoveredNode.setHovered(false,false);this._hoveredNode=node;if(this._hoveredNode)
this._hoveredNode.setHovered(true,!!highlightInitiatorChain);}
_dataGridMouseDown(event){if(!this._dataGrid.selectedNode&&event.button)
event.consume();}
_updateSummaryBar(){var requestsNumber=this._nodesByRequestId.size;if(!requestsNumber){this._showRecordingHint();return;}
this._hideRecordingHint();var transferSize=0;var selectedRequestsNumber=0;var selectedTransferSize=0;var baseTime=-1;var maxTime=-1;var nodes=this._nodesByRequestId.valuesArray();for(var i=0;i<nodes.length;++i){var request=nodes[i].request();var requestTransferSize=request.transferSize;transferSize+=requestTransferSize;if(!nodes[i][Network.NetworkLogView._isFilteredOutSymbol]){selectedRequestsNumber++;selectedTransferSize+=requestTransferSize;}
if(request.url()===request.target().inspectedURL()&&request.resourceType()===Common.resourceTypes.Document)
baseTime=request.startTime;if(request.endTime>maxTime)
maxTime=request.endTime;}
var summaryBar=this._summaryBarElement;summaryBar.removeChildren();var separator='\u2002\u2758\u2002';var text='';function appendChunk(chunk){var span=summaryBar.createChild('span');span.textContent=chunk;text+=chunk;return span;}
if(selectedRequestsNumber!==requestsNumber){appendChunk(Common.UIString('%d / %d requests',selectedRequestsNumber,requestsNumber));appendChunk(separator);appendChunk(Common.UIString('%s / %s transferred',Number.bytesToString(selectedTransferSize),Number.bytesToString(transferSize)));}else{appendChunk(Common.UIString('%d requests',requestsNumber));appendChunk(separator);appendChunk(Common.UIString('%s transferred',Number.bytesToString(transferSize)));}
if(baseTime!==-1&&maxTime!==-1){appendChunk(separator);appendChunk(Common.UIString('Finish: %s',Number.secondsToString(maxTime-baseTime)));if(this._mainRequestDOMContentLoadedTime!==-1&&this._mainRequestDOMContentLoadedTime>baseTime){appendChunk(separator);var domContentLoadedText=Common.UIString('DOMContentLoaded: %s',Number.secondsToString(this._mainRequestDOMContentLoadedTime-baseTime));appendChunk(domContentLoadedText).classList.add('summary-blue');}
if(this._mainRequestLoadTime!==-1){appendChunk(separator);var loadText=Common.UIString('Load: %s',Number.secondsToString(this._mainRequestLoadTime-baseTime));appendChunk(loadText).classList.add('summary-red');}}
summaryBar.title=text;}
scheduleRefresh(){if(this._needsRefresh)
return;this._needsRefresh=true;if(this.isShowing()&&!this._refreshRequestId)
this._refreshRequestId=this.element.window().requestAnimationFrame(this._refresh.bind(this));}
addFilmStripFrames(times){this._columns.addEventDividers(times,'network-frame-divider');}
selectFilmStripFrame(time){this._columns.selectFilmStripFrame(time);}
clearFilmStripFrame(){this._columns.clearFilmStripFrame();}
_refreshIfNeeded(){if(this._needsRefresh)
this._refresh();}
_invalidateAllItems(deferUpdate){var requestIds=this._nodesByRequestId.keysArray();for(var i=0;i<requestIds.length;++i)
this._staleRequestIds[requestIds[i]]=true;if(deferUpdate)
this.scheduleRefresh();else
this._refresh();}
timeCalculator(){return this._timeCalculator;}
calculator(){return this._calculator;}
setCalculator(x){if(!x||this._calculator===x)
return;if(this._calculator!==x){this._calculator=x;this._columns.setCalculator(this._calculator);}
this._calculator.reset();if(this._calculator.startAtZero)
this._columns.hideEventDividers();else
this._columns.showEventDividers();this._invalidateAllItems();}
_loadEventFired(event){if(!this._recording)
return;var time=(event.data.loadTime);if(time){this._mainRequestLoadTime=time;this._columns.addEventDividers([time],'network-red-divider');}}
_domContentLoadedEventFired(event){if(!this._recording)
return;var data=(event.data);if(data){this._mainRequestDOMContentLoadedTime=data;this._columns.addEventDividers([data],'network-blue-divider');}}
wasShown(){this._refreshIfNeeded();this._columns.wasShown();}
willHide(){this._columns.willHide();}
flatNodesList(){return this._dataGrid.rootNode().flatChildren();}
stylesChanged(){this._columns.scheduleRefresh();}
_refresh(){this._needsRefresh=false;if(this._refreshRequestId){this.element.window().cancelAnimationFrame(this._refreshRequestId);delete this._refreshRequestId;}
this.removeAllNodeHighlights();this._timeCalculator.updateBoundariesForEventTime(this._mainRequestLoadTime);this._durationCalculator.updateBoundariesForEventTime(this._mainRequestLoadTime);this._timeCalculator.updateBoundariesForEventTime(this._mainRequestDOMContentLoadedTime);this._durationCalculator.updateBoundariesForEventTime(this._mainRequestDOMContentLoadedTime);var nodesToInsert=new Map();var nodesToRefresh=[];for(var requestId in this._staleRequestIds){var node=this._nodesByRequestId.get(requestId);if(!node)
continue;var isFilteredOut=!this._applyFilter(node);if(isFilteredOut&&node===this._hoveredNode)
this._setHoveredNode(null);if(!isFilteredOut)
nodesToRefresh.push(node);var request=node.request();this._timeCalculator.updateBoundaries(request);this._durationCalculator.updateBoundaries(request);node[Network.NetworkLogView._isFilteredOutSymbol]=isFilteredOut;var newParent=this._parentNodeForInsert(node);var removeFromParent=node.parent&&(isFilteredOut||node.parent!==newParent);if(removeFromParent){var parent=node.parent;parent.removeChild(node);while(parent&&!parent.hasChildren()&&parent.dataGrid&&parent.dataGrid.rootNode()!==parent){var grandparent=parent.parent;grandparent.removeChild(parent);parent=grandparent;}}
if(!newParent||isFilteredOut)
continue;if(!newParent.dataGrid&&!nodesToInsert.has(newParent)){nodesToInsert.set(newParent,this._dataGrid.rootNode());nodesToRefresh.push(newParent);}
nodesToInsert.set(node,newParent);}
for(var node of nodesToInsert.keys()){var parent=nodesToInsert.get(node);var request=node.request();if(request)
node[Network.NetworkLogView._isMatchingSearchQuerySymbol]=this._matchRequest(request);parent.appendChild(node);}
for(var node of nodesToRefresh)
node.refresh();this._highlightNthMatchedRequestForSearch(this._updateMatchCountAndFindMatchIndex(this._currentMatchedRequestNode),false);this._staleRequestIds={};this._updateSummaryBar();if(nodesToInsert.size)
this._columns.sortByCurrentColumn();this._dataGrid.updateInstantly();}
_parentNodeForInsert(node){if(!this._activeGroupLookup)
return this._dataGrid.rootNode();var groupName=this._activeGroupLookup.lookup(node.request());if(!groupName)
return this._dataGrid.rootNode();var group=this._nodeGroups.get(groupName);if(group)
return group;group=new Network.NetworkGroupNode(this,groupName);group.setColumnExtensions(this._columns.columnExtensions());this._nodeGroups.set(groupName,group);return group;}
reset(){this._requestWithHighlightedInitiators=null;this.dispatchEventToListeners(Network.NetworkLogView.Events.RequestSelected,null);this._clearSearchMatchedList();this._setHoveredNode(null);this._columns.reset();this._timeFilter=null;this._calculator.reset();this._timeCalculator.setWindow(null);var nodes=this._nodesByRequestId.valuesArray();for(var i=0;i<nodes.length;++i)
nodes[i].dispose();this._nodeGroups.clear();this._nodesByRequestId.clear();this._staleRequestIds={};this._resetSuggestionBuilder();this._mainRequestLoadTime=-1;this._mainRequestDOMContentLoadedTime=-1;if(this._dataGrid){this._dataGrid.rootNode().removeChildren();this._updateSummaryBar();}}
setTextFilterValue(filterString){this._textFilterUI.setValue(filterString);this._textFilterUI.setRegexChecked(false);this._dataURLFilterUI.setChecked(false);this._resourceCategoryFilterUI.reset();}
_onRequestStarted(event){if(!this._recording)
return;var request=(event.data);this._appendRequest(request);}
_appendRequest(request){var node=new Network.NetworkRequestNode(this,request);node.setColumnExtensions(this._columns.columnExtensions());node[Network.NetworkLogView._isFilteredOutSymbol]=true;node[Network.NetworkLogView._isMatchingSearchQuerySymbol]=false;var originalRequestNode=this._nodesByRequestId.get(request.requestId());if(originalRequestNode)
this._nodesByRequestId.set(originalRequestNode.request().requestId(),originalRequestNode);this._nodesByRequestId.set(request.requestId(),node);if(request.redirects){for(var i=0;i<request.redirects.length;++i)
this._refreshRequest(request.redirects[i]);}
this._refreshRequest(request);}
_onRequestUpdated(event){var request=(event.data);this._refreshRequest(request);}
_refreshRequest(request){if(!this._nodesByRequestId.get(request.requestId()))
return;Network.NetworkLogView._subdomains(request.domain).forEach(this._suggestionBuilder.addItem.bind(this._suggestionBuilder,Network.NetworkLogView.FilterType.Domain));this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.Method,request.requestMethod);this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.MimeType,request.mimeType);this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.Scheme,''+request.scheme);this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.StatusCode,''+request.statusCode);var priority=request.initialPriority();if(priority){this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.Priority,NetworkConditions.uiLabelForPriority(priority));}
if(request.mixedContentType!=='none'){this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.MixedContent,Network.NetworkLogView.MixedContentFilterValues.All);}
if(request.mixedContentType==='optionally-blockable'){this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.MixedContent,Network.NetworkLogView.MixedContentFilterValues.Displayed);}
if(request.mixedContentType==='blockable'){var suggestion=request.wasBlocked()?Network.NetworkLogView.MixedContentFilterValues.Blocked:Network.NetworkLogView.MixedContentFilterValues.BlockOverridden;this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.MixedContent,suggestion);}
var responseHeaders=request.responseHeaders;for(var i=0,l=responseHeaders.length;i<l;++i)
this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.HasResponseHeader,responseHeaders[i].name);var cookies=request.responseCookies;for(var i=0,l=cookies?cookies.length:0;i<l;++i){var cookie=cookies[i];this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.SetCookieDomain,cookie.domain());this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.SetCookieName,cookie.name());this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.SetCookieValue,cookie.value());}
this._staleRequestIds[request.requestId()]=true;this.dispatchEventToListeners(Network.NetworkLogView.Events.UpdateRequest,request);this.scheduleRefresh();}
_mainFrameNavigated(event){if(!this._recording)
return;var frame=(event.data);var loaderId=frame.loaderId;var requestsToPick=[];var requests=NetworkLog.networkLog.requestsForTarget(frame.target());for(var i=0;i<requests.length;++i){var request=requests[i];if(request.loaderId===loaderId)
requestsToPick.push(request);}
if(!this._preserveLog){this.reset();for(var i=0;i<requestsToPick.length;++i)
this._appendRequest(requestsToPick[i]);}
for(var i=0;i<requestsToPick.length;++i){var request=requestsToPick[i];var node=this._nodesByRequestId.get(request.requestId());if(node){node.markAsNavigationRequest();break;}}}
rowHeight(){return this._rowHeight;}
switchViewMode(gridMode){this._columns.switchViewMode(gridMode);}
handleContextMenuForRequest(contextMenu,request){contextMenu.appendApplicableItems(request);var copyMenu=contextMenu.appendSubMenuItem(Common.UIString('Copy'));if(request){copyMenu.appendItem(UI.copyLinkAddressLabel(),InspectorFrontendHost.copyText.bind(InspectorFrontendHost,request.contentURL()));copyMenu.appendSeparator();if(request.requestHeadersText()){copyMenu.appendItem(Common.UIString.capitalize('Copy ^request ^headers'),this._copyRequestHeaders.bind(this,request));}
if(request.responseHeadersText){copyMenu.appendItem(Common.UIString.capitalize('Copy ^response ^headers'),this._copyResponseHeaders.bind(this,request));}
if(request.finished)
copyMenu.appendItem(Common.UIString.capitalize('Copy ^response'),this._copyResponse.bind(this,request));if(Host.isWin()){copyMenu.appendItem(Common.UIString('Copy as cURL (cmd)'),this._copyCurlCommand.bind(this,request,'win'));copyMenu.appendItem(Common.UIString('Copy as cURL (bash)'),this._copyCurlCommand.bind(this,request,'unix'));copyMenu.appendItem(Common.UIString('Copy All as cURL (cmd)'),this._copyAllCurlCommand.bind(this,'win'));copyMenu.appendItem(Common.UIString('Copy All as cURL (bash)'),this._copyAllCurlCommand.bind(this,'unix'));}else{copyMenu.appendItem(Common.UIString('Copy as cURL'),this._copyCurlCommand.bind(this,request,'unix'));copyMenu.appendItem(Common.UIString('Copy All as cURL'),this._copyAllCurlCommand.bind(this,'unix'));}}else{copyMenu=contextMenu.appendSubMenuItem(Common.UIString('Copy'));}
copyMenu.appendItem(Common.UIString.capitalize('Copy ^all as HAR'),this._copyAll.bind(this));contextMenu.appendSeparator();contextMenu.appendItem(Common.UIString.capitalize('Save as HAR with ^content'),this._exportAll.bind(this));contextMenu.appendSeparator();contextMenu.appendItem(Common.UIString.capitalize('Clear ^browser ^cache'),this._clearBrowserCache.bind(this));contextMenu.appendItem(Common.UIString.capitalize('Clear ^browser ^cookies'),this._clearBrowserCookies.bind(this));if(request&&Runtime.experiments.isEnabled('requestBlocking')){contextMenu.appendSeparator();var blockedSetting=Common.moduleSetting('networkBlockedURLs');var blockedSettingData=blockedSetting.get();const maxBlockedURLLength=20;var urlWithoutScheme=request.parsedURL.urlWithoutScheme();var blockedURLIndex=blockedSettingData.indexOf(urlWithoutScheme);if(urlWithoutScheme&&blockedURLIndex===-1){contextMenu.appendItem(Common.UIString.capitalize('Block ^request URL'),addBlockedURL.bind(null,urlWithoutScheme));}else if(urlWithoutScheme){const croppedURL=urlWithoutScheme.trimMiddle(maxBlockedURLLength);contextMenu.appendItem(Common.UIString.capitalize('Unblock '+croppedURL),removeBlockedURLIndex.bind(null,blockedURLIndex));}
var domain=request.parsedURL.domain();var blockedDomainIndex=blockedSettingData.indexOf(domain);if(domain&&blockedDomainIndex===-1){contextMenu.appendItem(Common.UIString.capitalize('Block ^request ^domain'),addBlockedURL.bind(null,domain));}else if(domain){const croppedDomain=domain.trimMiddle(maxBlockedURLLength);contextMenu.appendItem(Common.UIString.capitalize('Unblock '+croppedDomain),removeBlockedURLIndex.bind(null,blockedDomainIndex));}
function addBlockedURL(url){blockedSettingData.push(url);blockedSetting.set(blockedSettingData);UI.viewManager.showView('network.blocked-urls');Common.moduleSetting('requestBlockingEnabled').set(true);}
function removeBlockedURLIndex(index){blockedSettingData.splice(index,1);blockedSetting.set(blockedSettingData);UI.viewManager.showView('network.blocked-urls');}}
if(request&&request.resourceType()===Common.resourceTypes.XHR){contextMenu.appendSeparator();contextMenu.appendItem(Common.UIString('Replay XHR'),request.replayXHR.bind(request));contextMenu.appendSeparator();}}
_harRequests(){var requests=this._nodesByRequestId.valuesArray().map(function(node){return node.request();});var httpRequests=requests.filter(Network.NetworkLogView.HTTPRequestsFilter);return httpRequests.filter(Network.NetworkLogView.FinishedRequestsFilter);}
_copyAll(){var harArchive={log:(new NetworkLog.HARLog(this._harRequests())).build()};InspectorFrontendHost.copyText(JSON.stringify(harArchive,null,2));}
_copyRequestHeaders(request){InspectorFrontendHost.copyText(request.requestHeadersText());}
_copyResponse(request){function callback(content){if(request.contentEncoded)
content=request.asDataURL();InspectorFrontendHost.copyText(content||'');}
request.requestContent().then(callback);}
_copyResponseHeaders(request){InspectorFrontendHost.copyText(request.responseHeadersText);}
_copyCurlCommand(request,platform){InspectorFrontendHost.copyText(this._generateCurlCommand(request,platform));}
_copyAllCurlCommand(platform){var requests=this._nodesByRequestId.valuesArray().map(node=>node.request());var commands=[];for(var request of requests)
commands.push(this._generateCurlCommand(request,platform));if(platform==='win')
InspectorFrontendHost.copyText(commands.join(' &\r\n'));else
InspectorFrontendHost.copyText(commands.join(' ;\n'));}
_exportAll(){var url=SDK.targetManager.mainTarget().inspectedURL();var parsedURL=url.asParsedURL();var filename=parsedURL?parsedURL.host:'network-log';var stream=new Bindings.FileOutputStream();stream.open(filename+'.har',openCallback.bind(this));function openCallback(accepted){if(!accepted)
return;var progressIndicator=new UI.ProgressIndicator();this._progressBarContainer.appendChild(progressIndicator.element);var harWriter=new Network.HARWriter();harWriter.write(stream,this._harRequests(),progressIndicator);}}
_clearBrowserCache(){if(confirm(Common.UIString('Are you sure you want to clear browser cache?')))
SDK.multitargetNetworkManager.clearBrowserCache();}
_clearBrowserCookies(){if(confirm(Common.UIString('Are you sure you want to clear browser cookies?')))
SDK.multitargetNetworkManager.clearBrowserCookies();}
_matchRequest(request){var re=this._searchRegex;if(!re)
return false;var text=this._networkLogLargeRowsSetting.get()?request.path()+'/'+request.name():request.name();return re.test(text);}
_clearSearchMatchedList(){this._matchedRequestCount=-1;this._currentMatchedRequestNode=null;this._removeAllHighlights();}
_removeAllHighlights(){this.removeAllNodeHighlights();for(var i=0;i<this._highlightedSubstringChanges.length;++i)
UI.revertDomChanges(this._highlightedSubstringChanges[i]);this._highlightedSubstringChanges=[];}
dataGridSorted(){this._highlightNthMatchedRequestForSearch(this._updateMatchCountAndFindMatchIndex(this._currentMatchedRequestNode),false);}
_highlightNthMatchedRequestForSearch(n,reveal){this._removeAllHighlights();var nodes=this._dataGrid.rootNode().children;var matchCount=0;var node=null;for(var i=0;i<nodes.length;++i){if(nodes[i][Network.NetworkLogView._isMatchingSearchQuerySymbol]){if(matchCount===n){node=nodes[i];break;}
matchCount++;}}
if(!node){this._currentMatchedRequestNode=null;return;}
var request=node.request();if(reveal)
Common.Revealer.reveal(request);var highlightedSubstringChanges=node.highlightMatchedSubstring(this._searchRegex);this._highlightedSubstringChanges.push(highlightedSubstringChanges);this._currentMatchedRequestNode=node;this._currentMatchedRequestIndex=n;this.dispatchEventToListeners(Network.NetworkLogView.Events.SearchIndexUpdated,n);}
performSearch(searchConfig,shouldJump,jumpBackwards){var query=searchConfig.query;var currentMatchedRequestNode=this._currentMatchedRequestNode;this._clearSearchMatchedList();this._searchRegex=createPlainTextSearchRegex(query,'i');var nodes=this._dataGrid.rootNode().children;for(var i=0;i<nodes.length;++i)
nodes[i][Network.NetworkLogView._isMatchingSearchQuerySymbol]=this._matchRequest(nodes[i].request());var newMatchedRequestIndex=this._updateMatchCountAndFindMatchIndex(currentMatchedRequestNode);if(!newMatchedRequestIndex&&jumpBackwards)
newMatchedRequestIndex=this._matchedRequestCount-1;this._highlightNthMatchedRequestForSearch(newMatchedRequestIndex,shouldJump);}
supportsCaseSensitiveSearch(){return false;}
supportsRegexSearch(){return true;}
_updateMatchCountAndFindMatchIndex(node){var nodes=this._dataGrid.rootNode().children;var matchCount=0;var matchIndex=0;for(var i=0;i<nodes.length;++i){if(!nodes[i][Network.NetworkLogView._isMatchingSearchQuerySymbol])
continue;if(node===nodes[i])
matchIndex=matchCount;matchCount++;}
if(this._matchedRequestCount!==matchCount){this._matchedRequestCount=matchCount;this.dispatchEventToListeners(Network.NetworkLogView.Events.SearchCountUpdated,matchCount);}
return matchIndex;}
_normalizeSearchResultIndex(index){return(index+this._matchedRequestCount)%this._matchedRequestCount;}
_applyFilter(node){var request=node.request();if(this._timeFilter&&!this._timeFilter(request))
return false;var categoryName=request.resourceType().category().title;if(!this._resourceCategoryFilterUI.accept(categoryName))
return false;if(this._dataURLFilterUI.checked()&&request.parsedURL.isDataURL())
return false;if(request.statusText==='Service Worker Fallback Required')
return false;for(var i=0;i<this._filters.length;++i){if(!this._filters[i](request))
return false;}
return true;}
_parseFilterQuery(query){var parsedQuery;if(this._textFilterUI.isRegexChecked()&&query!=='')
parsedQuery={text:[query],filters:[]};else
parsedQuery=this._suggestionBuilder.parseQuery(query);this._filters=parsedQuery.text.map(this._createTextFilter,this);var n=parsedQuery.filters.length;for(var i=0;i<n;++i){var filter=parsedQuery.filters[i];var filterType=(filter.type.toLowerCase());this._filters.push(this._createFilter(filterType,filter.data,filter.negative));}}
_createTextFilter(text){var negative=false;var regex;if(!this._textFilterUI.isRegexChecked()&&text[0]==='-'&&text.length>1){negative=true;text=text.substring(1);regex=new RegExp(text.escapeForRegExp(),'i');}else{regex=this._textFilterUI.regex();}
var filter=Network.NetworkLogView._requestPathFilter.bind(null,regex);if(negative)
filter=Network.NetworkLogView._negativeFilter.bind(null,filter);return filter;}
_createFilter(type,value,negative){var filter=this._createSpecialFilter(type,value);if(!filter)
return this._createTextFilter((negative?'-':'')+type+':'+value);if(negative)
return Network.NetworkLogView._negativeFilter.bind(null,filter);return filter;}
_createSpecialFilter(type,value){switch(type){case Network.NetworkLogView.FilterType.Domain:return Network.NetworkLogView._createRequestDomainFilter(value);case Network.NetworkLogView.FilterType.HasResponseHeader:return Network.NetworkLogView._requestResponseHeaderFilter.bind(null,value);case Network.NetworkLogView.FilterType.Is:if(value.toLowerCase()===Network.NetworkLogView.IsFilterType.Running)
return Network.NetworkLogView._runningRequestFilter;if(value.toLowerCase()===Network.NetworkLogView.IsFilterType.FromCache)
return Network.NetworkLogView._fromCacheRequestFilter;break;case Network.NetworkLogView.FilterType.LargerThan:return this._createSizeFilter(value.toLowerCase());case Network.NetworkLogView.FilterType.Method:return Network.NetworkLogView._requestMethodFilter.bind(null,value);case Network.NetworkLogView.FilterType.MimeType:return Network.NetworkLogView._requestMimeTypeFilter.bind(null,value);case Network.NetworkLogView.FilterType.MixedContent:return Network.NetworkLogView._requestMixedContentFilter.bind(null,(value));case Network.NetworkLogView.FilterType.Scheme:return Network.NetworkLogView._requestSchemeFilter.bind(null,value);case Network.NetworkLogView.FilterType.SetCookieDomain:return Network.NetworkLogView._requestSetCookieDomainFilter.bind(null,value);case Network.NetworkLogView.FilterType.SetCookieName:return Network.NetworkLogView._requestSetCookieNameFilter.bind(null,value);case Network.NetworkLogView.FilterType.SetCookieValue:return Network.NetworkLogView._requestSetCookieValueFilter.bind(null,value);case Network.NetworkLogView.FilterType.Priority:return Network.NetworkLogView._requestPriorityFilter.bind(null,NetworkConditions.uiLabelToPriority(value));case Network.NetworkLogView.FilterType.StatusCode:return Network.NetworkLogView._statusCodeFilter.bind(null,value);}
return null;}
_createSizeFilter(value){var multiplier=1;if(value.endsWith('k')){multiplier=1024;value=value.substring(0,value.length-1);}else if(value.endsWith('m')){multiplier=1024*1024;value=value.substring(0,value.length-1);}
var quantity=Number(value);if(isNaN(quantity))
return null;return Network.NetworkLogView._requestSizeLargerThanFilter.bind(null,quantity*multiplier);}
_filterRequests(){this._removeAllHighlights();this._invalidateAllItems();}
jumpToPreviousSearchResult(){if(!this._matchedRequestCount)
return;var index=this._normalizeSearchResultIndex(this._currentMatchedRequestIndex-1);this._highlightNthMatchedRequestForSearch(index,true);}
jumpToNextSearchResult(){if(!this._matchedRequestCount)
return;var index=this._normalizeSearchResultIndex(this._currentMatchedRequestIndex+1);this._highlightNthMatchedRequestForSearch(index,true);}
searchCanceled(){delete this._searchRegex;this._clearSearchMatchedList();this.dispatchEventToListeners(Network.NetworkLogView.Events.SearchCountUpdated,0);}
revealAndHighlightRequest(request){this.removeAllNodeHighlights();var node=this._nodesByRequestId.get(request.requestId());if(node){node.reveal();this._highlightNode(node);}}
removeAllNodeHighlights(){if(this._highlightedNode){this._highlightedNode.element().classList.remove('highlighted-row');delete this._highlightedNode;}}
_highlightNode(node){UI.runCSSAnimationOnce(node.element(),'highlighted-row');this._highlightedNode=node;}
_generateCurlCommand(request,platform){var command=['curl'];var ignoredHeaders={'host':1,'method':1,'path':1,'scheme':1,'version':1};function escapeStringWin(str){var encapsChars=/[\r\n]/.test(str)?'^"':'"';return encapsChars+
str.replace(/\\/g,'\\\\').replace(/"/g,'\\"').replace(/[^a-zA-Z0-9\s_\-:=+~'\/.',?;()*`]/g,'^$&').replace(/%(?=[a-zA-Z0-9_])/g,'%^').replace(/\r\n|[\n\r]/g,'^\n\n')+
encapsChars;}
function escapeStringPosix(str){function escapeCharacter(x){var code=x.charCodeAt(0);if(code<256){return code<16?'\\x0'+code.toString(16):'\\x'+code.toString(16);}
code=code.toString(16);return'\\u'+('0000'+code).substr(code.length,4);}
if(/[^\x20-\x7E]|\'/.test(str)){return'$\''+
str.replace(/\\/g,'\\\\').replace(/\'/g,'\\\'').replace(/\n/g,'\\n').replace(/\r/g,'\\r').replace(/[^\x20-\x7E]/g,escapeCharacter)+'\'';}else{return'\''+str+'\'';}}
var escapeString=platform==='win'?escapeStringWin:escapeStringPosix;command.push(escapeString(request.url()).replace(/[[{}\]]/g,'\\$&'));var inferredMethod='GET';var data=[];var requestContentType=request.requestContentType();if(requestContentType&&requestContentType.startsWith('application/x-www-form-urlencoded')&&request.requestFormData){data.push('--data');data.push(escapeString(request.requestFormData));ignoredHeaders['content-length']=true;inferredMethod='POST';}else if(request.requestFormData){data.push('--data-binary');data.push(escapeString(request.requestFormData));ignoredHeaders['content-length']=true;inferredMethod='POST';}
if(request.requestMethod!==inferredMethod){command.push('-X');command.push(request.requestMethod);}
var requestHeaders=request.requestHeaders();for(var i=0;i<requestHeaders.length;i++){var header=requestHeaders[i];var name=header.name.replace(/^:/,'');if(name.toLowerCase()in ignoredHeaders)
continue;command.push('-H');command.push(escapeString(name+': '+header.value));}
command=command.concat(data);command.push('--compressed');if(request.securityState()===Protocol.Security.SecurityState.Insecure)
command.push('--insecure');return command.join(' ');}};Network.NetworkLogView._isFilteredOutSymbol=Symbol('isFilteredOut');Network.NetworkLogView._isMatchingSearchQuerySymbol=Symbol('isMatchingSearchQuery');Network.NetworkLogView.HTTPSchemas={'http':true,'https':true,'ws':true,'wss':true};Network.NetworkLogView.Events={RequestSelected:Symbol('RequestSelected'),SearchCountUpdated:Symbol('SearchCountUpdated'),SearchIndexUpdated:Symbol('SearchIndexUpdated'),UpdateRequest:Symbol('UpdateRequest')};Network.NetworkLogView.FilterType={Domain:'domain',HasResponseHeader:'has-response-header',Is:'is',LargerThan:'larger-than',Method:'method',MimeType:'mime-type',MixedContent:'mixed-content',Priority:'priority',Scheme:'scheme',SetCookieDomain:'set-cookie-domain',SetCookieName:'set-cookie-name',SetCookieValue:'set-cookie-value',StatusCode:'status-code'};Network.NetworkLogView.MixedContentFilterValues={All:'all',Displayed:'displayed',Blocked:'blocked',BlockOverridden:'block-overridden'};Network.NetworkLogView.IsFilterType={Running:'running',FromCache:'from-cache'};Network.NetworkLogView._searchKeys=Object.keys(Network.NetworkLogView.FilterType).map(key=>Network.NetworkLogView.FilterType[key]);Network.NetworkLogView.Filter;Network.NetworkGroupLookupInterface=function(){};Network.NetworkGroupLookupInterface.prototype={lookup(request){}};;Network.NetworkLogViewColumns=class{constructor(networkLogView,timeCalculator,durationCalculator,networkLogLargeRowsSetting){this._networkLogView=networkLogView;this._persistantSettings=Common.settings.createSetting('networkLogColumns',{});this._networkLogLargeRowsSetting=networkLogLargeRowsSetting;this._networkLogLargeRowsSetting.addChangeListener(this._updateRowsSize,this);this._eventDividers=new Map();this._eventDividersShown=false;this._gridMode=true;this._columns=[];this._columnExtensions=new Map();this._waterfallRequestsAreStale=false;this._waterfallScrollerWidthIsStale=true;this._popupLinkifier=new Components.Linkifier();this._calculatorsMap=new Map();this._calculatorsMap.set(Network.NetworkLogViewColumns._calculatorTypes.Time,timeCalculator);this._calculatorsMap.set(Network.NetworkLogViewColumns._calculatorTypes.Duration,durationCalculator);this._setupDataGrid();this._setupWaterfall();}
static _convertToDataGridDescriptor(columnConfig){return({id:columnConfig.id,title:columnConfig.title,sortable:columnConfig.sortable,align:columnConfig.align,nonSelectable:columnConfig.nonSelectable,weight:columnConfig.weight});}
wasShown(){this._updateRowsSize();}
willHide(){this._popoverHelper.hidePopover();}
reset(){if(this._popoverHelper)
this._popoverHelper.hidePopover();this._eventDividers.clear();}
_setupDataGrid(){var defaultColumns=Network.NetworkLogViewColumns._defaultColumns;var defaultColumnConfig=Network.NetworkLogViewColumns._defaultColumnConfig;this._columns=([]);for(var currentConfigColumn of defaultColumns){var columnConfig=(Object.assign({},defaultColumnConfig,currentConfigColumn));columnConfig.id=columnConfig.id;if(columnConfig.subtitle)
columnConfig.titleDOMFragment=this._makeHeaderFragment(columnConfig.title,columnConfig.subtitle);this._columns.push(columnConfig);}
this._loadColumnExtensions();this._loadCustomColumnsAndSettings();this._popoverHelper=new UI.PopoverHelper(this._networkLogView.element,this._getPopoverRequest.bind(this));this._popoverHelper.setHasPadding(true);this._dataGrid=new DataGrid.SortableDataGrid(this._columns.map(Network.NetworkLogViewColumns._convertToDataGridDescriptor));this._dataGrid.element.addEventListener('mousedown',event=>{if(!this._dataGrid.selectedNode&&event.button)
event.consume();},true);this._dataGridScroller=this._dataGrid.scrollContainer;this._updateColumns();this._dataGrid.addEventListener(DataGrid.DataGrid.Events.SortingChanged,this._sortHandler,this);this._dataGrid.setHeaderContextMenuCallback(this._innerHeaderContextMenu.bind(this));this._activeWaterfallSortId=Network.NetworkLogViewColumns.WaterfallSortIds.StartTime;this._dataGrid.markColumnAsSortedBy(Network.NetworkLogViewColumns._initialSortColumn,DataGrid.DataGrid.Order.Ascending);this._splitWidget=new UI.SplitWidget(true,true,'networkPanelSplitViewWaterfall',200);var widget=this._dataGrid.asWidget();widget.setMinimumSize(150,0);this._splitWidget.setMainWidget(widget);}
_setupWaterfall(){this._waterfallColumn=new Network.NetworkWaterfallColumn(this._networkLogView.rowHeight(),this._networkLogView.calculator());this._waterfallColumn.element.addEventListener('contextmenu',handleContextMenu.bind(this));this._waterfallColumn.element.addEventListener('mousewheel',this._onMouseWheel.bind(this,false),{passive:true});this._dataGridScroller.addEventListener('mousewheel',this._onMouseWheel.bind(this,true),true);this._waterfallScroller=this._waterfallColumn.contentElement.createChild('div','network-waterfall-v-scroll');this._waterfallScrollerContent=this._waterfallScroller.createChild('div','network-waterfall-v-scroll-content');this._dataGrid.addEventListener(DataGrid.DataGrid.Events.PaddingChanged,()=>{this._waterfallScrollerWidthIsStale=true;this._syncScrollers();});this._dataGrid.addEventListener(DataGrid.ViewportDataGrid.Events.ViewportCalculated,this._redrawWaterfallColumn.bind(this));this._createWaterfallHeader();this._waterfallColumn.contentElement.classList.add('network-waterfall-view');this._waterfallColumn.setMinimumSize(100,0);this._splitWidget.setSidebarWidget(this._waterfallColumn);this.switchViewMode(false);function handleContextMenu(event){var node=this._waterfallColumn.getNodeFromPoint(event.offsetX,event.offsetY);if(!node)
return;var request=node.request();if(!request)
return;var contextMenu=new UI.ContextMenu(event);this._networkLogView.handleContextMenuForRequest(contextMenu,request);contextMenu.show();}}
_onMouseWheel(shouldConsume,event){if(shouldConsume)
event.consume(true);this._activeScroller.scrollTop-=event.wheelDeltaY;this._syncScrollers();}
_syncScrollers(){if(!this._waterfallColumn.isShowing())
return;this._waterfallScrollerContent.style.height=this._dataGridScroller.scrollHeight+'px';this._updateScrollerWidthIfNeeded();this._dataGridScroller.scrollTop=this._waterfallScroller.scrollTop;}
_updateScrollerWidthIfNeeded(){if(this._waterfallScrollerWidthIsStale){this._waterfallScrollerWidthIsStale=false;this._waterfallColumn.setRightPadding(this._waterfallScroller.offsetWidth-this._waterfallScrollerContent.offsetWidth);}}
_redrawWaterfallColumn(){if(!this._waterfallRequestsAreStale){this._updateScrollerWidthIfNeeded();this._waterfallColumn.update(this._activeScroller.scrollTop,this._eventDividersShown?this._eventDividers:undefined);return;}
this._syncScrollers();var nodes=this._networkLogView.flatNodesList();this._waterfallColumn.update(this._activeScroller.scrollTop,this._eventDividers,nodes);}
_createWaterfallHeader(){this._waterfallHeaderElement=this._waterfallColumn.contentElement.createChild('div','network-waterfall-header');this._waterfallHeaderElement.addEventListener('click',waterfallHeaderClicked.bind(this));this._waterfallHeaderElement.addEventListener('contextmenu',event=>this._innerHeaderContextMenu(new UI.ContextMenu(event)));var innerElement=this._waterfallHeaderElement.createChild('div');innerElement.textContent=Common.UIString('Waterfall');this._waterfallColumnSortIcon=UI.Icon.create('','sort-order-icon');this._waterfallHeaderElement.createChild('div','sort-order-icon-container').appendChild(this._waterfallColumnSortIcon);function waterfallHeaderClicked(){var sortOrders=DataGrid.DataGrid.Order;var sortOrder=this._dataGrid.sortOrder()===sortOrders.Ascending?sortOrders.Descending:sortOrders.Ascending;this._dataGrid.markColumnAsSortedBy('waterfall',sortOrder);this._sortHandler();}}
setCalculator(x){this._waterfallColumn.setCalculator(x);}
scheduleRefresh(){this._waterfallColumn.scheduleDraw();}
_updateRowsSize(){var largeRows=!!this._networkLogLargeRowsSetting.get();this._dataGrid.element.classList.toggle('small',!largeRows);this._dataGrid.scheduleUpdate();this._waterfallScrollerWidthIsStale=true;this._waterfallColumn.setRowHeight(this._networkLogView.rowHeight());this._waterfallScroller.classList.toggle('small',!largeRows);this._waterfallHeaderElement.classList.toggle('small',!largeRows);this._waterfallColumn.setHeaderHeight(this._waterfallScroller.offsetTop);}
show(element){this._splitWidget.show(element);}
dataGrid(){return this._dataGrid;}
sortByCurrentColumn(){this._sortHandler();}
_sortHandler(){var columnId=this._dataGrid.sortColumnId();this._networkLogView.removeAllNodeHighlights();this._waterfallRequestsAreStale=true;if(columnId==='waterfall'){if(this._dataGrid.sortOrder()===DataGrid.DataGrid.Order.Ascending)
this._waterfallColumnSortIcon.setIconType('smallicon-triangle-up');else
this._waterfallColumnSortIcon.setIconType('smallicon-triangle-down');var sortFunction=Network.NetworkRequestNode.RequestPropertyComparator.bind(null,this._activeWaterfallSortId);this._dataGrid.sortNodes(sortFunction,!this._dataGrid.isSortOrderAscending());this._networkLogView.dataGridSorted();return;}
this._waterfallColumnSortIcon.setIconType('');var columnConfig=this._columns.find(columnConfig=>columnConfig.id===columnId);if(!columnConfig||!columnConfig.sortingFunction)
return;this._dataGrid.sortNodes(columnConfig.sortingFunction,!this._dataGrid.isSortOrderAscending());this._networkLogView.dataGridSorted();}
_updateColumns(){if(!this._dataGrid)
return;var visibleColumns=({});if(this._gridMode){for(var columnConfig of this._columns)
visibleColumns[columnConfig.id]=columnConfig.visible;}else{visibleColumns.name=true;}
this._dataGrid.setColumnsVisiblity(visibleColumns);}
switchViewMode(gridMode){if(this._gridMode===gridMode)
return;this._gridMode=gridMode;if(gridMode){if(this._dataGrid.selectedNode)
this._dataGrid.selectedNode.selected=false;this._splitWidget.showBoth();this._activeScroller=this._waterfallScroller;this._waterfallScroller.scrollTop=this._dataGridScroller.scrollTop;this._dataGrid.setScrollContainer(this._waterfallScroller);}else{this._networkLogView.removeAllNodeHighlights();this._splitWidget.hideSidebar();this._activeScroller=this._dataGridScroller;this._dataGrid.setScrollContainer(this._dataGridScroller);}
this._networkLogView.element.classList.toggle('brief-mode',!gridMode);this._updateColumns();}
columnExtensions(){return this._columnExtensions;}
_toggleColumnVisibility(columnConfig){this._loadCustomColumnsAndSettings();columnConfig.visible=!columnConfig.visible;this._saveColumnsSettings();this._updateColumns();}
_saveColumnsSettings(){var saveableSettings={};for(var columnConfig of this._columns)
saveableSettings[columnConfig.id]={visible:columnConfig.visible,title:columnConfig.title};this._persistantSettings.set(saveableSettings);}
_loadColumnExtensions(){var extensions=self.runtime.extensions(Network.NetworkColumnExtensionInterface);for(var i=0;i<extensions.length;i++){var extension=extensions[i];var title=extension.title();var columnId=title.toLowerCase()+'-extension';this._columnExtensions.set(columnId,null);extension.instance().then(extensionInstanceResolved.bind(this,columnId));var columnConfig=(Object.assign({},Network.NetworkLogViewColumns._defaultColumnConfig,{id:columnId,title:title,isResponseHeader:false,isCustomHeader:false,visible:true,sortingFunction:Network.NetworkRequestNode.ExtensionColumnComparator.bind(null,this._columnExtensions,columnId)}));const columnIndex=i+1;this._columns.splice(columnIndex,0,columnConfig);if(this._dataGrid)
this._dataGrid.addColumn(Network.NetworkLogViewColumns._convertToDataGridDescriptor(columnConfig),columnIndex);}
function extensionInstanceResolved(columnId,instance){this._columnExtensions.set(columnId,instance);this._networkLogView.columnExtensionResolved();}}
_loadCustomColumnsAndSettings(){var savedSettings=this._persistantSettings.get();var columnIds=Object.keys(savedSettings);for(var columnId of columnIds){var setting=savedSettings[columnId];var columnConfig=this._columns.find(columnConfig=>columnConfig.id===columnId);if(!columnConfig)
columnConfig=this._addCustomHeader(setting.title,columnId);if(columnConfig.hideable&&typeof setting.visible==='boolean')
columnConfig.visible=!!setting.visible;if(typeof setting.title==='string')
columnConfig.title=setting.title;}}
_makeHeaderFragment(title,subtitle){var fragment=createDocumentFragment();fragment.createTextChild(title);var subtitleDiv=fragment.createChild('div','network-header-subtitle');subtitleDiv.createTextChild(subtitle);return fragment;}
_innerHeaderContextMenu(contextMenu){var columnConfigs=this._columns.filter(columnConfig=>columnConfig.hideable);var nonResponseHeaders=columnConfigs.filter(columnConfig=>!columnConfig.isResponseHeader);for(var columnConfig of nonResponseHeaders){contextMenu.appendCheckboxItem(columnConfig.title,this._toggleColumnVisibility.bind(this,columnConfig),columnConfig.visible);}
contextMenu.appendSeparator();var responseSubMenu=contextMenu.appendSubMenuItem(Common.UIString('Response Headers'));var responseHeaders=columnConfigs.filter(columnConfig=>columnConfig.isResponseHeader);for(var columnConfig of responseHeaders){responseSubMenu.appendCheckboxItem(columnConfig.title,this._toggleColumnVisibility.bind(this,columnConfig),columnConfig.visible);}
responseSubMenu.appendSeparator();responseSubMenu.appendItem(Common.UIString('Manage Header Columns\u2026'),this._manageCustomHeaderDialog.bind(this));contextMenu.appendSeparator();var waterfallSortIds=Network.NetworkLogViewColumns.WaterfallSortIds;var waterfallSubMenu=contextMenu.appendSubMenuItem(Common.UIString('Waterfall'));waterfallSubMenu.appendCheckboxItem(Common.UIString('Start Time'),setWaterfallMode.bind(this,waterfallSortIds.StartTime),this._activeWaterfallSortId===waterfallSortIds.StartTime);waterfallSubMenu.appendCheckboxItem(Common.UIString('Response Time'),setWaterfallMode.bind(this,waterfallSortIds.ResponseTime),this._activeWaterfallSortId===waterfallSortIds.ResponseTime);waterfallSubMenu.appendCheckboxItem(Common.UIString('End Time'),setWaterfallMode.bind(this,waterfallSortIds.EndTime),this._activeWaterfallSortId===waterfallSortIds.EndTime);waterfallSubMenu.appendCheckboxItem(Common.UIString('Total Duration'),setWaterfallMode.bind(this,waterfallSortIds.Duration),this._activeWaterfallSortId===waterfallSortIds.Duration);waterfallSubMenu.appendCheckboxItem(Common.UIString('Latency'),setWaterfallMode.bind(this,waterfallSortIds.Latency),this._activeWaterfallSortId===waterfallSortIds.Latency);contextMenu.show();function setWaterfallMode(sortId){var calculator=this._calculatorsMap.get(Network.NetworkLogViewColumns._calculatorTypes.Time);var waterfallSortIds=Network.NetworkLogViewColumns.WaterfallSortIds;if(sortId===waterfallSortIds.Duration||sortId===waterfallSortIds.Latency)
calculator=this._calculatorsMap.get(Network.NetworkLogViewColumns._calculatorTypes.Duration);this._networkLogView.setCalculator(calculator);this._activeWaterfallSortId=sortId;this._dataGrid.markColumnAsSortedBy('waterfall',DataGrid.DataGrid.Order.Ascending);this._sortHandler();}}
_manageCustomHeaderDialog(){var customHeaders=[];for(var columnConfig of this._columns){if(columnConfig.isResponseHeader)
customHeaders.push({title:columnConfig.title,editable:columnConfig.isCustomHeader});}
var manageCustomHeaders=new Network.NetworkManageCustomHeadersView(customHeaders,headerTitle=>!!this._addCustomHeader(headerTitle),this._changeCustomHeader.bind(this),this._removeCustomHeader.bind(this));var dialog=new UI.Dialog();manageCustomHeaders.show(dialog.contentElement);dialog.setSizeBehavior(UI.GlassPane.SizeBehavior.MeasureContent);dialog.show(this._networkLogView.element);}
_removeCustomHeader(headerId){headerId=headerId.toLowerCase();var index=this._columns.findIndex(columnConfig=>columnConfig.id===headerId);if(index===-1)
return false;this._columns.splice(index,1);this._dataGrid.removeColumn(headerId);this._saveColumnsSettings();this._updateColumns();return true;}
_addCustomHeader(headerTitle,headerId,index){if(!headerId)
headerId=headerTitle.toLowerCase();if(index===undefined)
index=this._columns.length-1;var currentColumnConfig=this._columns.find(columnConfig=>columnConfig.id===headerId);if(currentColumnConfig)
return null;var columnConfig=(Object.assign({},Network.NetworkLogViewColumns._defaultColumnConfig,{id:headerId,title:headerTitle,isResponseHeader:true,isCustomHeader:true,visible:true,sortingFunction:Network.NetworkRequestNode.ResponseHeaderStringComparator.bind(null,headerId)}));this._columns.splice(index,0,columnConfig);if(this._dataGrid)
this._dataGrid.addColumn(Network.NetworkLogViewColumns._convertToDataGridDescriptor(columnConfig),index);this._saveColumnsSettings();this._updateColumns();return columnConfig;}
_changeCustomHeader(oldHeaderId,newHeaderTitle,newHeaderId){if(!newHeaderId)
newHeaderId=newHeaderTitle.toLowerCase();oldHeaderId=oldHeaderId.toLowerCase();var oldIndex=this._columns.findIndex(columnConfig=>columnConfig.id===oldHeaderId);var oldColumnConfig=this._columns[oldIndex];var currentColumnConfig=this._columns.find(columnConfig=>columnConfig.id===newHeaderId);if(!oldColumnConfig||(currentColumnConfig&&oldHeaderId!==newHeaderId))
return false;this._removeCustomHeader(oldHeaderId);this._addCustomHeader(newHeaderTitle,newHeaderId,oldIndex);return true;}
_getPopoverRequest(event){if(!this._gridMode)
return null;var anchor=event.target.enclosingNodeOrSelfWithClass('network-script-initiated');var request=(anchor?anchor.request:null);var initiator=request?request.initiator():null;if(!initiator||!initiator.stack)
return null;return{box:anchor.boxInWindow(),show:popover=>{var content=Components.DOMPresentationUtils.buildStackTracePreviewContents(anchor.request.target(),this._popupLinkifier,initiator.stack);popover.contentElement.appendChild(content);return Promise.resolve(true);},hide:()=>{this._popupLinkifier.reset();}};}
addEventDividers(times,className){var color='transparent';switch(className){case'network-blue-divider':color='hsla(240, 100%, 80%, 0.7)';break;case'network-red-divider':color='rgba(255, 0, 0, 0.5)';break;default:return;}
var currentTimes=this._eventDividers.get(color)||[];this._eventDividers.set(color,currentTimes.concat(times));this._networkLogView.scheduleRefresh();}
hideEventDividers(){this._eventDividersShown=true;this._redrawWaterfallColumn();}
showEventDividers(){this._eventDividersShown=false;this._redrawWaterfallColumn();}
selectFilmStripFrame(time){this._eventDividers.set(Network.NetworkLogViewColumns._filmStripDividerColor,[time]);this._redrawWaterfallColumn();}
clearFilmStripFrame(){this._eventDividers.delete(Network.NetworkLogViewColumns._filmStripDividerColor);this._redrawWaterfallColumn();}};Network.NetworkLogViewColumns._initialSortColumn='waterfall';Network.NetworkLogViewColumns.Descriptor;Network.NetworkLogViewColumns._calculatorTypes={Duration:'Duration',Time:'Time'};Network.NetworkLogViewColumns._defaultColumnConfig={subtitle:null,visible:false,weight:6,sortable:true,hideable:true,nonSelectable:true,isResponseHeader:false,alwaysVisible:false,isCustomHeader:false};Network.NetworkLogViewColumns._defaultColumns=[{id:'name',title:Common.UIString('Name'),subtitle:Common.UIString('Path'),visible:true,weight:20,hideable:false,nonSelectable:false,alwaysVisible:true,sortingFunction:Network.NetworkRequestNode.NameComparator},{id:'method',title:Common.UIString('Method'),sortingFunction:Network.NetworkRequestNode.RequestPropertyComparator.bind(null,'requestMethod')},{id:'status',title:Common.UIString('Status'),visible:true,subtitle:Common.UIString('Text'),sortingFunction:Network.NetworkRequestNode.RequestPropertyComparator.bind(null,'statusCode')},{id:'protocol',title:Common.UIString('Protocol'),sortingFunction:Network.NetworkRequestNode.RequestPropertyComparator.bind(null,'protocol')},{id:'scheme',title:Common.UIString('Scheme'),sortingFunction:Network.NetworkRequestNode.RequestPropertyComparator.bind(null,'scheme')},{id:'domain',title:Common.UIString('Domain'),sortingFunction:Network.NetworkRequestNode.RequestPropertyComparator.bind(null,'domain')},{id:'remoteaddress',title:Common.UIString('Remote Address'),weight:10,align:DataGrid.DataGrid.Align.Right,sortingFunction:Network.NetworkRequestNode.RemoteAddressComparator},{id:'type',title:Common.UIString('Type'),visible:true,sortingFunction:Network.NetworkRequestNode.TypeComparator},{id:'initiator',title:Common.UIString('Initiator'),visible:true,weight:10,sortingFunction:Network.NetworkRequestNode.InitiatorComparator},{id:'cookies',title:Common.UIString('Cookies'),align:DataGrid.DataGrid.Align.Right,sortingFunction:Network.NetworkRequestNode.RequestCookiesCountComparator},{id:'setcookies',title:Common.UIString('Set Cookies'),align:DataGrid.DataGrid.Align.Right,sortingFunction:Network.NetworkRequestNode.ResponseCookiesCountComparator},{id:'size',title:Common.UIString('Size'),visible:true,subtitle:Common.UIString('Content'),align:DataGrid.DataGrid.Align.Right,sortingFunction:Network.NetworkRequestNode.SizeComparator},{id:'time',title:Common.UIString('Time'),visible:true,subtitle:Common.UIString('Latency'),align:DataGrid.DataGrid.Align.Right,sortingFunction:Network.NetworkRequestNode.RequestPropertyComparator.bind(null,'duration')},{id:'priority',title:Common.UIString('Priority'),sortingFunction:Network.NetworkRequestNode.InitialPriorityComparator},{id:'connectionid',title:Common.UIString('Connection ID'),sortingFunction:Network.NetworkRequestNode.RequestPropertyComparator.bind(null,'connectionId')},{id:'cache-control',isResponseHeader:true,title:Common.UIString('Cache-Control'),sortingFunction:Network.NetworkRequestNode.ResponseHeaderStringComparator.bind(null,'cache-control')},{id:'connection',isResponseHeader:true,title:Common.UIString('Connection'),sortingFunction:Network.NetworkRequestNode.ResponseHeaderStringComparator.bind(null,'connection')},{id:'content-encoding',isResponseHeader:true,title:Common.UIString('Content-Encoding'),sortingFunction:Network.NetworkRequestNode.ResponseHeaderStringComparator.bind(null,'content-encoding')},{id:'content-length',isResponseHeader:true,title:Common.UIString('Content-Length'),align:DataGrid.DataGrid.Align.Right,sortingFunction:Network.NetworkRequestNode.ResponseHeaderNumberComparator.bind(null,'content-length')},{id:'etag',isResponseHeader:true,title:Common.UIString('ETag'),sortingFunction:Network.NetworkRequestNode.ResponseHeaderStringComparator.bind(null,'etag')},{id:'keep-alive',isResponseHeader:true,title:Common.UIString('Keep-Alive'),sortingFunction:Network.NetworkRequestNode.ResponseHeaderStringComparator.bind(null,'keep-alive')},{id:'last-modified',isResponseHeader:true,title:Common.UIString('Last-Modified'),sortingFunction:Network.NetworkRequestNode.ResponseHeaderDateComparator.bind(null,'last-modified')},{id:'server',isResponseHeader:true,title:Common.UIString('Server'),sortingFunction:Network.NetworkRequestNode.ResponseHeaderStringComparator.bind(null,'server')},{id:'vary',isResponseHeader:true,title:Common.UIString('Vary'),sortingFunction:Network.NetworkRequestNode.ResponseHeaderStringComparator.bind(null,'vary')},{id:'waterfall',title:'',visible:false,hideable:false}];Network.NetworkLogViewColumns._filmStripDividerColor='#fccc49';Network.NetworkLogViewColumns.WaterfallSortIds={StartTime:'startTime',ResponseTime:'responseReceivedTime',EndTime:'endTime',Duration:'duration',Latency:'latency'};Network.NetworkColumnExtensionInterface=function(){};Network.NetworkColumnExtensionInterface.prototype={lookupColumnValue(request){},requestComparator(aRequest,bRequest){}};;Network.NetworkManageCustomHeadersView=class extends UI.VBox{constructor(columnData,addHeaderColumnCallback,changeHeaderColumnCallback,removeHeaderColumnCallback){super(true);this.registerRequiredCSS('network/networkManageCustomHeadersView.css');this.contentElement.classList.add('custom-headers-wrapper');this.contentElement.createChild('div','header').textContent=Common.UIString('Manage Header Columns');this._list=new UI.ListWidget(this);this._list.element.classList.add('custom-headers-list');this._list.registerRequiredCSS('network/networkManageCustomHeadersView.css');var placeholder=createElementWithClass('div','custom-headers-list-list-empty');placeholder.textContent=Common.UIString('No custom headers');this._list.setEmptyPlaceholder(placeholder);this._list.show(this.contentElement);this.contentElement.appendChild(UI.createTextButton(Common.UIString('Add custom header\u2026'),this._addButtonClicked.bind(this),'add-button'));this._columnConfigs=new Map();columnData.forEach(columnData=>this._columnConfigs.set(columnData.title.toLowerCase(),columnData));this._addHeaderColumnCallback=addHeaderColumnCallback;this._changeHeaderColumnCallback=changeHeaderColumnCallback;this._removeHeaderColumnCallback=removeHeaderColumnCallback;this.contentElement.tabIndex=0;}
wasShown(){this._headersUpdated();}
_headersUpdated(){this._list.clear();this._columnConfigs.forEach(headerData=>this._list.appendItem({header:headerData.title},headerData.editable));}
_addButtonClicked(){this._list.addNewItem(this._columnConfigs.size,{header:''});}
renderItem(item,editable){var element=createElementWithClass('div','custom-headers-list-item');var header=element.createChild('div','custom-header-name');header.textContent=item.header;header.title=item.header;return element;}
removeItemRequested(item,index){this._removeHeaderColumnCallback(item.header);this._columnConfigs.delete(item.header.toLowerCase());this._headersUpdated();}
commitEdit(item,editor,isNew){var headerId=editor.control('header').value.trim();var success;if(isNew)
success=this._addHeaderColumnCallback(headerId);else
success=this._changeHeaderColumnCallback(item.header,headerId);if(success&&!isNew)
this._columnConfigs.delete(item.header.toLowerCase());if(success)
this._columnConfigs.set(headerId.toLowerCase(),{title:headerId,editable:true});this._headersUpdated();}
beginEdit(item){var editor=this._createEditor();editor.control('header').value=item.header;return editor;}
_createEditor(){if(this._editor)
return this._editor;var editor=new UI.ListWidget.Editor();this._editor=editor;var content=editor.contentElement();var titles=content.createChild('div','custom-headers-edit-row');titles.createChild('div','custom-headers-header').textContent=Common.UIString('Header Name');var fields=content.createChild('div','custom-headers-edit-row');fields.createChild('div','custom-headers-header').appendChild(editor.createInput('header','text','x-custom-header',validateHeader.bind(this)));return editor;function validateHeader(item,index,input){var headerId=editor.control('header').value.trim().toLowerCase();if(this._columnConfigs.has(headerId)&&item.header!==headerId)
return false;return true;}}};;Network.NetworkOverview=class extends PerfUI.TimelineOverviewBase{constructor(){super();this._selectedFilmStripTime=-1;this.element.classList.add('network-overview');this._numBands=1;this._updateScheduled=false;SDK.targetManager.addModelListener(SDK.ResourceTreeModel,SDK.ResourceTreeModel.Events.Load,this._loadEventFired,this);SDK.targetManager.addModelListener(SDK.ResourceTreeModel,SDK.ResourceTreeModel.Events.DOMContentLoaded,this._domContentLoadedEventFired,this);this.reset();}
setFilmStripModel(filmStripModel){this._filmStripModel=filmStripModel;this.scheduleUpdate();}
selectFilmStripFrame(time){this._selectedFilmStripTime=time;this.scheduleUpdate();}
clearFilmStripFrame(){this._selectedFilmStripTime=-1;this.scheduleUpdate();}
_loadEventFired(event){var time=(event.data.loadTime);if(time)
this._loadEvents.push(time*1000);this.scheduleUpdate();}
_domContentLoadedEventFired(event){var data=(event.data);if(data)
this._domContentLoadedEvents.push(data*1000);this.scheduleUpdate();}
_bandId(connectionId){if(!connectionId||connectionId==='0')
return-1;if(this._bandMap.has(connectionId))
return(this._bandMap.get(connectionId));var result=this._nextBand++;this._bandMap.set(connectionId,result);return result;}
updateRequest(request){if(!this._requestsSet.has(request)){this._requestsSet.add(request);this._requestsList.push(request);}
this.scheduleUpdate();}
wasShown(){this.onResize();}
onResize(){var width=this.element.offsetWidth;var height=this.element.offsetHeight;this.calculator().setDisplayWidth(width);this.resetCanvas();var numBands=(((height-1)/Network.NetworkOverview._bandHeight)-1)|0;this._numBands=(numBands>0)?numBands:1;this.scheduleUpdate();}
reset(){this._filmStripModel=null;this._span=1;this._lastBoundary=null;this._nextBand=0;this._bandMap=new Map();this._requestsList=[];this._requestsSet=new Set();this._loadEvents=[];this._domContentLoadedEvents=[];this.resetCanvas();}
scheduleUpdate(){if(this._updateScheduled||!this.isShowing())
return;this._updateScheduled=true;this.element.window().requestAnimationFrame(this.update.bind(this));}
update(){this._updateScheduled=false;var calculator=this.calculator();var newBoundary=new Network.NetworkTimeBoundary(calculator.minimumBoundary(),calculator.maximumBoundary());if(!this._lastBoundary||!newBoundary.equals(this._lastBoundary)){var span=calculator.boundarySpan();while(this._span<span)
this._span*=1.25;calculator.setBounds(calculator.minimumBoundary(),calculator.minimumBoundary()+this._span);this._lastBoundary=new Network.NetworkTimeBoundary(calculator.minimumBoundary(),calculator.maximumBoundary());}
var context=this.context();var linesByType={};var paddingTop=2;function drawLines(type,strokeStyle){var lines=linesByType[type];if(!lines)
return;var n=lines.length;context.beginPath();context.strokeStyle=strokeStyle;for(var i=0;i<n;){var y=lines[i++]*Network.NetworkOverview._bandHeight+paddingTop;var startTime=lines[i++];var endTime=lines[i++];if(endTime===Number.MAX_VALUE)
endTime=calculator.maximumBoundary();context.moveTo(calculator.computePosition(startTime),y);context.lineTo(calculator.computePosition(endTime)+1,y);}
context.stroke();}
function addLine(type,y,start,end){var lines=linesByType[type];if(!lines){lines=[];linesByType[type]=lines;}
lines.push(y,start,end);}
var requests=this._requestsList;var n=requests.length;for(var i=0;i<n;++i){var request=requests[i];var band=this._bandId(request.connectionId);var y=(band===-1)?0:(band%this._numBands+1);var timeRanges=Network.RequestTimingView.calculateRequestTimeRanges(request,this.calculator().minimumBoundary());for(var j=0;j<timeRanges.length;++j){var type=timeRanges[j].name;if(band!==-1||type===Network.RequestTimeRangeNames.Total)
addLine(type,y,timeRanges[j].start*1000,timeRanges[j].end*1000);}}
context.clearRect(0,0,this.width(),this.height());context.save();context.scale(window.devicePixelRatio,window.devicePixelRatio);context.lineWidth=2;drawLines(Network.RequestTimeRangeNames.Total,'#CCCCCC');drawLines(Network.RequestTimeRangeNames.Blocking,'#AAAAAA');drawLines(Network.RequestTimeRangeNames.Connecting,'#FF9800');drawLines(Network.RequestTimeRangeNames.ServiceWorker,'#FF9800');drawLines(Network.RequestTimeRangeNames.ServiceWorkerPreparation,'#FF9800');drawLines(Network.RequestTimeRangeNames.Push,'#8CDBff');drawLines(Network.RequestTimeRangeNames.Proxy,'#A1887F');drawLines(Network.RequestTimeRangeNames.DNS,'#009688');drawLines(Network.RequestTimeRangeNames.SSL,'#9C27B0');drawLines(Network.RequestTimeRangeNames.Sending,'#B0BEC5');drawLines(Network.RequestTimeRangeNames.Waiting,'#00C853');drawLines(Network.RequestTimeRangeNames.Receiving,'#03A9F4');var height=this.element.offsetHeight;context.lineWidth=1;context.beginPath();context.strokeStyle='#8080FF';for(var i=this._domContentLoadedEvents.length-1;i>=0;--i){var x=Math.round(calculator.computePosition(this._domContentLoadedEvents[i]))+0.5;context.moveTo(x,0);context.lineTo(x,height);}
context.stroke();context.beginPath();context.strokeStyle='#FF8080';for(var i=this._loadEvents.length-1;i>=0;--i){var x=Math.round(calculator.computePosition(this._loadEvents[i]))+0.5;context.moveTo(x,0);context.lineTo(x,height);}
context.stroke();if(this._selectedFilmStripTime!==-1){context.lineWidth=2;context.beginPath();context.strokeStyle='#FCCC49';var x=Math.round(calculator.computePosition(this._selectedFilmStripTime));context.moveTo(x,0);context.lineTo(x,height);context.stroke();}
context.restore();}};Network.NetworkOverview._bandHeight=3;Network.NetworkOverview.Window;;Network.NetworkWaterfallColumn=class extends UI.VBox{constructor(rowHeight,calculator){super(false);this.registerRequiredCSS('network/networkWaterfallColumn.css');this._canvas=this.contentElement.createChild('canvas');this._canvas.tabIndex=1;this.setDefaultFocusedElement(this._canvas);this._canvasPosition=this._canvas.getBoundingClientRect();this._leftPadding=5;this._fontSize=10;this._rightPadding=0;this._scrollTop=0;this._rowHeight=rowHeight;this._headerHeight=0;this._calculator=calculator;this._offsetWidth=0;this._offsetHeight=0;this._startTime=this._calculator.minimumBoundary();this._endTime=this._calculator.maximumBoundary();this._popoverHelper=new UI.PopoverHelper(this.element,this._getPopoverRequest.bind(this));this._popoverHelper.setHasPadding(true);this._popoverHelper.setTimeout(300,300);this._nodes=[];this._hoveredNode=null;this._eventDividers=new Map();this._updateRequestID;var colorUsage=UI.ThemeSupport.ColorUsage;this._rowNavigationRequestColor=UI.themeSupport.patchColor('#def',colorUsage.Background);this._rowStripeColor=UI.themeSupport.patchColor('#f5f5f5',colorUsage.Background);this._rowHoverColor=UI.themeSupport.patchColor('#ebf2fc',(colorUsage.Background|colorUsage.Selection));this._parentInitiatorColor=UI.themeSupport.patchColor('hsla(120, 68%, 54%, 0.2)',colorUsage.Background);this._initiatedColor=UI.themeSupport.patchColor('hsla(0, 68%, 54%, 0.2)',colorUsage.Background);this.element.addEventListener('mousemove',this._onMouseMove.bind(this),true);this.element.addEventListener('mouseleave',event=>this._setHoveredNode(null,false),true);this._styleForTimeRangeName=Network.NetworkWaterfallColumn._buildRequestTimeRangeStyle();var resourceStyleTuple=Network.NetworkWaterfallColumn._buildResourceTypeStyle();this._styleForWaitingResourceType=resourceStyleTuple[0];this._styleForDownloadingResourceType=resourceStyleTuple[1];var baseLineColor=UI.themeSupport.patchColor('#a5a5a5',UI.ThemeSupport.ColorUsage.Foreground);this._wiskerStyle={borderColor:baseLineColor,lineWidth:1};this._hoverDetailsStyle={fillStyle:baseLineColor,lineWidth:1,borderColor:baseLineColor};this._pathForStyle=new Map();this._textLayers=[];}
static _buildRequestTimeRangeStyle(){const types=Network.RequestTimeRangeNames;var styleMap=new Map();styleMap.set(types.Connecting,{fillStyle:'#FF9800'});styleMap.set(types.SSL,{fillStyle:'#9C27B0'});styleMap.set(types.DNS,{fillStyle:'#009688'});styleMap.set(types.Proxy,{fillStyle:'#A1887F'});styleMap.set(types.Blocking,{fillStyle:'#AAAAAA'});styleMap.set(types.Push,{fillStyle:'#8CDBff'});styleMap.set(types.Queueing,{fillStyle:'white',lineWidth:2,borderColor:'lightgrey'});styleMap.set(types.Receiving,{fillStyle:'#03A9F4',lineWidth:2,borderColor:'#03A9F4'});styleMap.set(types.Waiting,{fillStyle:'#00C853'});styleMap.set(types.ReceivingPush,{fillStyle:'#03A9F4'});styleMap.set(types.ServiceWorker,{fillStyle:'orange'});styleMap.set(types.ServiceWorkerPreparation,{fillStyle:'orange'});return styleMap;}
static _buildResourceTypeStyle(){const baseResourceTypeColors=new Map([['document','hsl(215, 100%, 80%)'],['font','hsl(8, 100%, 80%)'],['media','hsl(90, 50%, 80%)'],['image','hsl(90, 50%, 80%)'],['script','hsl(31, 100%, 80%)'],['stylesheet','hsl(272, 64%, 80%)'],['texttrack','hsl(8, 100%, 80%)'],['websocket','hsl(0, 0%, 95%)'],['xhr','hsl(53, 100%, 80%)'],['fetch','hsl(53, 100%, 80%)'],['other','hsl(0, 0%, 95%)'],]);var waitingStyleMap=new Map();var downloadingStyleMap=new Map();for(var resourceType of Object.values(Common.resourceTypes)){var color=baseResourceTypeColors.get(resourceType.name());if(!color)
color=baseResourceTypeColors.get('other');var borderColor=toBorderColor(color);waitingStyleMap.set(resourceType,{fillStyle:toWaitingColor(color),lineWidth:1,borderColor:borderColor});downloadingStyleMap.set(resourceType,{fillStyle:color,lineWidth:1,borderColor:borderColor});}
return[waitingStyleMap,downloadingStyleMap];function toBorderColor(color){var parsedColor=Common.Color.parse(color);var hsla=parsedColor.hsla();hsla[1]/=2;hsla[2]-=Math.min(hsla[2],0.2);return parsedColor.asString(null);}
function toWaitingColor(color){var parsedColor=Common.Color.parse(color);var hsla=parsedColor.hsla();hsla[2]*=1.1;return parsedColor.asString(null);}}
_resetPaths(){this._pathForStyle.clear();this._pathForStyle.set(this._wiskerStyle,new Path2D());this._styleForTimeRangeName.forEach(style=>this._pathForStyle.set(style,new Path2D()));this._styleForWaitingResourceType.forEach(style=>this._pathForStyle.set(style,new Path2D()));this._styleForDownloadingResourceType.forEach(style=>this._pathForStyle.set(style,new Path2D()));this._pathForStyle.set(this._hoverDetailsStyle,new Path2D());}
willHide(){this._popoverHelper.hidePopover();}
wasShown(){this.update();}
_onMouseMove(event){this._setHoveredNode(this.getNodeFromPoint(event.offsetX,event.offsetY),event.shiftKey);}
_getPopoverRequest(event){if(!this._hoveredNode)
return null;var request=this._hoveredNode.request();if(!request)
return null;var useTimingBars=!Common.moduleSetting('networkColorCodeResourceTypes').get()&&!this._calculator.startAtZero;if(useTimingBars){var range=Network.RequestTimingView.calculateRequestTimeRanges(request,0).find(data=>data.name===Network.RequestTimeRangeNames.Total);var start=this._timeToPosition(range.start);var end=this._timeToPosition(range.end);}else{var range=this._getSimplifiedBarRange(request,0);var start=range.start;var end=range.end;}
if(end-start<50){var halfWidth=(end-start)/2;start=start+halfWidth-25;end=end-halfWidth+25;}
if(event.clientX<this._canvasPosition.left+start||event.clientX>this._canvasPosition.left+end)
return null;var rowIndex=this._nodes.findIndex(node=>node.hovered());var barHeight=this._getBarHeight(range.name);var y=this._headerHeight+(this._rowHeight*rowIndex-this._scrollTop)+((this._rowHeight-barHeight)/2);if(event.clientY<this._canvasPosition.top+y||event.clientY>this._canvasPosition.top+y+barHeight)
return null;var anchorBox=this.element.boxInWindow();anchorBox.x+=start;anchorBox.y+=y;anchorBox.width=end-start;anchorBox.height=barHeight;return{box:anchorBox,show:popover=>{var content=Network.RequestTimingView.createTimingTable((request),this._calculator);popover.contentElement.appendChild(content);return Promise.resolve(true);}};}
_setHoveredNode(node,highlightInitiatorChain){if(this._hoveredNode)
this._hoveredNode.setHovered(false,false);this._hoveredNode=node;if(this._hoveredNode)
this._hoveredNode.setHovered(true,highlightInitiatorChain);}
setRowHeight(height){this._rowHeight=height;}
setHeaderHeight(height){this._headerHeight=height;}
setRightPadding(padding){this._rightPadding=padding;this._calculateCanvasSize();}
setCalculator(calculator){this._calculator=calculator;}
getNodeFromPoint(x,y){return this._nodes[Math.floor((this._scrollTop+y-this._headerHeight)/this._rowHeight)];}
scheduleDraw(){if(this._updateRequestID)
return;this._updateRequestID=this.element.window().requestAnimationFrame(()=>this.update());}
update(scrollTop,eventDividers,nodes){if(scrollTop!==undefined&&this._scrollTop!==scrollTop){this._popoverHelper.hidePopover();this._scrollTop=scrollTop;}
if(nodes){this._nodes=nodes;this._calculateCanvasSize();}
if(eventDividers!==undefined)
this._eventDividers=eventDividers;if(this._updateRequestID){this.element.window().cancelAnimationFrame(this._updateRequestID);delete this._updateRequestID;}
this._startTime=this._calculator.minimumBoundary();this._endTime=this._calculator.maximumBoundary();this._resetCanvas();this._resetPaths();this._textLayers=[];this._draw();}
_resetCanvas(){var ratio=window.devicePixelRatio;this._canvas.width=this._offsetWidth*ratio;this._canvas.height=this._offsetHeight*ratio;this._canvas.style.width=this._offsetWidth+'px';this._canvas.style.height=this._offsetHeight+'px';}
onResize(){super.onResize();this._calculateCanvasSize();this.scheduleDraw();}
_calculateCanvasSize(){this._offsetWidth=this.contentElement.offsetWidth-this._rightPadding;this._offsetHeight=this.contentElement.offsetHeight;this._calculator.setDisplayWidth(this._offsetWidth);this._canvasPosition=this._canvas.getBoundingClientRect();}
_timeToPosition(time){var availableWidth=this._offsetWidth-this._leftPadding;var timeToPixel=availableWidth/(this._endTime-this._startTime);return Math.floor(this._leftPadding+(time-this._startTime)*timeToPixel);}
_didDrawForTest(){}
_draw(){var useTimingBars=!Common.moduleSetting('networkColorCodeResourceTypes').get()&&!this._calculator.startAtZero;var nodes=this._nodes;var context=this._canvas.getContext('2d');context.save();context.scale(window.devicePixelRatio,window.devicePixelRatio);context.translate(0,this._headerHeight);context.rect(0,0,this._offsetWidth,this._offsetHeight);context.clip();var firstRequestIndex=Math.floor(this._scrollTop/this._rowHeight);var lastRequestIndex=Math.min(nodes.length,firstRequestIndex+Math.ceil(this._offsetHeight/this._rowHeight));for(var i=firstRequestIndex;i<lastRequestIndex;i++){var rowOffset=this._rowHeight*i;var node=nodes[i];this._decorateRow(context,node,rowOffset-this._scrollTop);var drawNodes=[];if(node.hasChildren()&&!node.expanded)
drawNodes=(node.flatChildren());drawNodes.push(node);for(var drawNode of drawNodes){if(useTimingBars)
this._buildTimingBarLayers(drawNode,rowOffset-this._scrollTop);else
this._buildSimplifiedBarLayers(context,drawNode,rowOffset-this._scrollTop);}}
this._drawLayers(context);context.save();context.fillStyle=UI.themeSupport.patchColor('#888',UI.ThemeSupport.ColorUsage.Foreground);for(var textData of this._textLayers)
context.fillText(textData.text,textData.x,textData.y);context.restore();this._drawEventDividers(context);context.restore();const freeZoneAtLeft=75;const freeZoneAtRight=18;PerfUI.TimelineGrid.drawCanvasGrid(context,this._calculator,this._fontSize,this._headerHeight,freeZoneAtLeft);context.clearRect(this._offsetWidth-freeZoneAtRight,0,freeZoneAtRight,this._headerHeight);this._didDrawForTest();}
_drawLayers(context){for(var entry of this._pathForStyle){var style=(entry[0]);var path=(entry[1]);context.save();context.beginPath();if(style.lineWidth){context.lineWidth=style.lineWidth;context.strokeStyle=style.borderColor;context.stroke(path);}
if(style.fillStyle){context.fillStyle=style.fillStyle;context.fill(path);}
context.restore();}}
_drawEventDividers(context){context.save();context.lineWidth=1;for(var color of this._eventDividers.keys()){context.strokeStyle=color;for(var time of this._eventDividers.get(color)){context.beginPath();var x=this._timeToPosition(time);context.moveTo(x,0);context.lineTo(x,this._offsetHeight);}
context.stroke();}
context.restore();}
_getBarHeight(type){var types=Network.RequestTimeRangeNames;switch(type){case types.Connecting:case types.SSL:case types.DNS:case types.Proxy:case types.Blocking:case types.Push:case types.Queueing:return 7;default:return 13;}}
_getSimplifiedBarRange(request,borderOffset){var drawWidth=this._offsetWidth-this._leftPadding;var percentages=this._calculator.computeBarGraphPercentages(request);return{start:this._leftPadding+Math.floor((percentages.start/100)*drawWidth)+borderOffset,mid:this._leftPadding+Math.floor((percentages.middle/100)*drawWidth)+borderOffset,end:this._leftPadding+Math.floor((percentages.end/100)*drawWidth)+borderOffset};}
_buildSimplifiedBarLayers(context,node,y){var request=node.request();if(!request)
return;const borderWidth=1;var borderOffset=borderWidth%2===0?0:0.5;var ranges=this._getSimplifiedBarRange(request,borderOffset);var height=this._getBarHeight();y+=Math.floor(this._rowHeight/2-height/2+borderWidth)-borderWidth/2;var waitingStyle=this._styleForWaitingResourceType.get(request.resourceType());var waitingPath=this._pathForStyle.get(waitingStyle);waitingPath.rect(ranges.start,y,ranges.mid-ranges.start,height-borderWidth);var barWidth=Math.max(2,ranges.end-ranges.mid);var downloadingStyle=this._styleForDownloadingResourceType.get(request.resourceType());var downloadingPath=this._pathForStyle.get(downloadingStyle);downloadingPath.rect(ranges.mid,y,barWidth,height-borderWidth);var labels=null;if(node.hovered()){labels=this._calculator.computeBarGraphLabels(request);const barDotLineLength=10;var leftLabelWidth=context.measureText(labels.left).width;var rightLabelWidth=context.measureText(labels.right).width;var hoverLinePath=this._pathForStyle.get(this._hoverDetailsStyle);if(leftLabelWidth<ranges.mid-ranges.start){var midBarX=ranges.start+(ranges.mid-ranges.start-leftLabelWidth)/2;this._textLayers.push({text:labels.left,x:midBarX,y:y+this._fontSize});}else if(barDotLineLength+leftLabelWidth+this._leftPadding<ranges.start){this._textLayers.push({text:labels.left,x:ranges.start-leftLabelWidth-barDotLineLength-1,y:y+this._fontSize});hoverLinePath.moveTo(ranges.start-barDotLineLength,y+Math.floor(height/2));hoverLinePath.arc(ranges.start,y+Math.floor(height/2),2,0,2*Math.PI);hoverLinePath.moveTo(ranges.start-barDotLineLength,y+Math.floor(height/2));hoverLinePath.lineTo(ranges.start,y+Math.floor(height/2));}
var endX=ranges.mid+barWidth+borderOffset;if(rightLabelWidth<endX-ranges.mid){var midBarX=ranges.mid+(endX-ranges.mid-rightLabelWidth)/2;this._textLayers.push({text:labels.right,x:midBarX,y:y+this._fontSize});}else if(endX+barDotLineLength+rightLabelWidth<this._offsetWidth-this._leftPadding){this._textLayers.push({text:labels.right,x:endX+barDotLineLength+1,y:y+this._fontSize});hoverLinePath.moveTo(endX,y+Math.floor(height/2));hoverLinePath.arc(endX,y+Math.floor(height/2),2,0,2*Math.PI);hoverLinePath.moveTo(endX,y+Math.floor(height/2));hoverLinePath.lineTo(endX+barDotLineLength,y+Math.floor(height/2));}}
if(!this._calculator.startAtZero){var queueingRange=Network.RequestTimingView.calculateRequestTimeRanges(request,0).find(data=>data.name===Network.RequestTimeRangeNames.Total);var leftLabelWidth=labels?context.measureText(labels.left).width:0;var leftTextPlacedInBar=leftLabelWidth<ranges.mid-ranges.start;const wiskerTextPadding=13;var textOffset=(labels&&!leftTextPlacedInBar)?leftLabelWidth+wiskerTextPadding:0;var queueingStart=this._timeToPosition(queueingRange.start);if(ranges.start-textOffset>queueingStart){var wiskerPath=this._pathForStyle.get(this._wiskerStyle);wiskerPath.moveTo(queueingStart,y+Math.floor(height/2));wiskerPath.lineTo(ranges.start-textOffset,y+Math.floor(height/2));const wiskerHeight=height/2;wiskerPath.moveTo(queueingStart+borderOffset,y+wiskerHeight/2);wiskerPath.lineTo(queueingStart+borderOffset,y+height-wiskerHeight/2-1);}}}
_buildTimingBarLayers(node,y){var request=node.request();if(!request)
return;var ranges=Network.RequestTimingView.calculateRequestTimeRanges(request,0);for(var range of ranges){if(range.name===Network.RequestTimeRangeNames.Total||range.name===Network.RequestTimeRangeNames.Sending||range.end-range.start===0)
continue;var style=this._styleForTimeRangeName.get(range.name);var path=this._pathForStyle.get(style);var lineWidth=style.lineWidth||0;var height=this._getBarHeight(range.name);var middleBarY=y+Math.floor(this._rowHeight/2-height/2)+lineWidth/2;var start=this._timeToPosition(range.start);var end=this._timeToPosition(range.end);path.rect(start,middleBarY,end-start,height-lineWidth);}}
_decorateRow(context,node,y){var isStriped=node.isStriped();if(!isStriped&&!node.hovered()&&!node.isNavigationRequest()&&!node.isOnInitiatorPath()&&!node.isOnInitiatedPath())
return;var color=getRowColor.call(this);if(color==='transparent')
return;context.save();context.beginPath();context.fillStyle=color;context.rect(0,y,this._offsetWidth,this._rowHeight);context.fill();context.restore();function getRowColor(){if(node.hovered())
return this._rowHoverColor;if(node.isOnInitiatorPath())
return this._parentInitiatorColor;if(node.isOnInitiatedPath())
return this._initiatedColor;if(node.isNavigationRequest())
return this._rowNavigationRequestColor;if(!isStriped)
return'transparent';return this._rowStripeColor;}}};Network.NetworkWaterfallColumn._LayerStyle;Network.NetworkWaterfallColumn._TextLayer;;Network.RequestCookiesView=class extends UI.VBox{constructor(request){super();this.registerRequiredCSS('network/requestCookiesView.css');this.element.classList.add('request-cookies-view');this._request=request;}
wasShown(){this._request.addEventListener(SDK.NetworkRequest.Events.RequestHeadersChanged,this._refreshCookies,this);this._request.addEventListener(SDK.NetworkRequest.Events.ResponseHeadersChanged,this._refreshCookies,this);if(!this._gotCookies){if(!this._emptyWidget){this._emptyWidget=new UI.EmptyWidget(Common.UIString('This request has no cookies.'));this._emptyWidget.show(this.element);}
return;}
if(!this._cookiesTable)
this._buildCookiesTable();}
willHide(){this._request.removeEventListener(SDK.NetworkRequest.Events.RequestHeadersChanged,this._refreshCookies,this);this._request.removeEventListener(SDK.NetworkRequest.Events.ResponseHeadersChanged,this._refreshCookies,this);}
get _gotCookies(){return(this._request.requestCookies&&this._request.requestCookies.length)||(this._request.responseCookies&&this._request.responseCookies.length);}
_buildCookiesTable(){this.detachChildWidgets();this._cookiesTable=new CookieTable.CookiesTable();this._cookiesTable.setCookieFolders([{folderName:Common.UIString('Request Cookies'),cookies:this._request.requestCookies},{folderName:Common.UIString('Response Cookies'),cookies:this._request.responseCookies}]);this._cookiesTable.show(this.element);}
_refreshCookies(){delete this._cookiesTable;if(!this._gotCookies||!this.isShowing())
return;this._buildCookiesTable();}};;Network.RequestHeadersView=class extends UI.VBox{constructor(request){super();this.registerRequiredCSS('network/requestHeadersView.css');this.element.classList.add('request-headers-view');this._request=request;this._decodeRequestParameters=true;this._showRequestHeadersText=false;this._showResponseHeadersText=false;var root=new UI.TreeOutlineInShadow();root.registerRequiredCSS('network/requestHeadersTree.css');root.element.classList.add('request-headers-tree');root.setFocusable(false);root.makeDense();root.expandTreeElementsWhenArrowing=true;this.element.appendChild(root.element);var generalCategory=new Network.RequestHeadersView.Category(root,'general',Common.UIString('General'));generalCategory.hidden=false;this._urlItem=generalCategory.createLeaf();this._requestMethodItem=generalCategory.createLeaf();this._statusCodeItem=generalCategory.createLeaf();this._remoteAddressItem=generalCategory.createLeaf();this._remoteAddressItem.hidden=true;this._referrerPolicyItem=generalCategory.createLeaf();this._referrerPolicyItem.hidden=true;this._responseHeadersCategory=new Network.RequestHeadersView.Category(root,'responseHeaders','');this._requestHeadersCategory=new Network.RequestHeadersView.Category(root,'requestHeaders','');this._queryStringCategory=new Network.RequestHeadersView.Category(root,'queryString','');this._formDataCategory=new Network.RequestHeadersView.Category(root,'formData','');this._requestPayloadCategory=new Network.RequestHeadersView.Category(root,'requestPayload',Common.UIString('Request Payload'));}
wasShown(){this._request.addEventListener(SDK.NetworkRequest.Events.RemoteAddressChanged,this._refreshRemoteAddress,this);this._request.addEventListener(SDK.NetworkRequest.Events.RequestHeadersChanged,this._refreshRequestHeaders,this);this._request.addEventListener(SDK.NetworkRequest.Events.ResponseHeadersChanged,this._refreshResponseHeaders,this);this._request.addEventListener(SDK.NetworkRequest.Events.FinishedLoading,this._refreshHTTPInformation,this);this._refreshURL();this._refreshQueryString();this._refreshRequestHeaders();this._refreshResponseHeaders();this._refreshHTTPInformation();this._refreshRemoteAddress();this._refreshReferrerPolicy();}
willHide(){this._request.removeEventListener(SDK.NetworkRequest.Events.RemoteAddressChanged,this._refreshRemoteAddress,this);this._request.removeEventListener(SDK.NetworkRequest.Events.RequestHeadersChanged,this._refreshRequestHeaders,this);this._request.removeEventListener(SDK.NetworkRequest.Events.ResponseHeadersChanged,this._refreshResponseHeaders,this);this._request.removeEventListener(SDK.NetworkRequest.Events.FinishedLoading,this._refreshHTTPInformation,this);}
_formatHeader(name,value){var fragment=createDocumentFragment();fragment.createChild('div','header-name').textContent=name+':';fragment.createChild('div','header-value source-code').textContent=value;return fragment;}
_formatParameter(value,className,decodeParameters){var errorDecoding=false;if(decodeParameters){value=value.replace(/\+/g,' ');if(value.indexOf('%')>=0){try{value=decodeURIComponent(value);}catch(e){errorDecoding=true;}}}
var div=createElementWithClass('div',className);if(value==='')
div.classList.add('empty-value');if(errorDecoding)
div.createChild('span','header-decode-error').textContent=Common.UIString('(unable to decode value)');else
div.textContent=value;return div;}
_refreshURL(){this._urlItem.title=this._formatHeader(Common.UIString('Request URL'),this._request.url());}
_refreshQueryString(){var queryString=this._request.queryString();var queryParameters=this._request.queryParameters;this._queryStringCategory.hidden=!queryParameters;if(queryParameters){this._refreshParams(Common.UIString('Query String Parameters'),queryParameters,queryString,this._queryStringCategory);}}
_refreshFormData(){this._formDataCategory.hidden=true;this._requestPayloadCategory.hidden=true;var formData=this._request.requestFormData;if(!formData)
return;var formParameters=this._request.formParameters;if(formParameters){this._formDataCategory.hidden=false;this._refreshParams(Common.UIString('Form Data'),formParameters,formData,this._formDataCategory);}else{this._requestPayloadCategory.hidden=false;try{var json=JSON.parse(formData);this._refreshRequestJSONPayload(json,formData);}catch(e){this._populateTreeElementWithSourceText(this._requestPayloadCategory,formData);}}}
_populateTreeElementWithSourceText(treeElement,sourceText){var sourceTextElement=createElementWithClass('span','header-value source-code');sourceTextElement.textContent=String(sourceText||'').trim();var sourceTreeElement=new UI.TreeElement(sourceTextElement);sourceTreeElement.selectable=false;treeElement.removeChildren();treeElement.appendChild(sourceTreeElement);}
_refreshParams(title,params,sourceText,paramsTreeElement){paramsTreeElement.removeChildren();paramsTreeElement.listItemElement.removeChildren();paramsTreeElement.listItemElement.createTextChild(title);var headerCount=createElementWithClass('span','header-count');headerCount.textContent=Common.UIString('\u00A0(%d)',params.length);paramsTreeElement.listItemElement.appendChild(headerCount);function toggleViewSource(event){paramsTreeElement[Network.RequestHeadersView._viewSourceSymbol]=!paramsTreeElement[Network.RequestHeadersView._viewSourceSymbol];this._refreshParams(title,params,sourceText,paramsTreeElement);event.consume();}
paramsTreeElement.listItemElement.appendChild(this._createViewSourceToggle(paramsTreeElement[Network.RequestHeadersView._viewSourceSymbol],toggleViewSource.bind(this)));if(paramsTreeElement[Network.RequestHeadersView._viewSourceSymbol]){this._populateTreeElementWithSourceText(paramsTreeElement,sourceText);return;}
var toggleTitle=this._decodeRequestParameters?Common.UIString('view URL encoded'):Common.UIString('view decoded');var toggleButton=this._createToggleButton(toggleTitle);toggleButton.addEventListener('click',this._toggleURLDecoding.bind(this),false);paramsTreeElement.listItemElement.appendChild(toggleButton);for(var i=0;i<params.length;++i){var paramNameValue=createDocumentFragment();if(params[i].name!==''){var name=this._formatParameter(params[i].name+':','header-name',this._decodeRequestParameters);var value=this._formatParameter(params[i].value,'header-value source-code',this._decodeRequestParameters);paramNameValue.appendChild(name);paramNameValue.appendChild(value);}else{paramNameValue.appendChild(this._formatParameter(Common.UIString('(empty)'),'empty-request-header',this._decodeRequestParameters));}
var paramTreeElement=new UI.TreeElement(paramNameValue);paramTreeElement.selectable=false;paramsTreeElement.appendChild(paramTreeElement);}}
_refreshRequestJSONPayload(parsedObject,sourceText){var treeElement=this._requestPayloadCategory;treeElement.removeChildren();var listItem=this._requestPayloadCategory.listItemElement;listItem.removeChildren();listItem.createTextChild(this._requestPayloadCategory.title);function toggleViewSource(event){treeElement[Network.RequestHeadersView._viewSourceSymbol]=!treeElement[Network.RequestHeadersView._viewSourceSymbol];this._refreshRequestJSONPayload(parsedObject,sourceText);event.consume();}
listItem.appendChild(this._createViewSourceToggle(treeElement[Network.RequestHeadersView._viewSourceSymbol],toggleViewSource.bind(this)));if(treeElement[Network.RequestHeadersView._viewSourceSymbol]){this._populateTreeElementWithSourceText(this._requestPayloadCategory,sourceText);}else{var object=SDK.RemoteObject.fromLocalObject(parsedObject);var section=new ObjectUI.ObjectPropertiesSection(object,object.description);section.expand();section.editable=false;treeElement.appendChild(new UI.TreeElement(section.element));}}
_createViewSourceToggle(viewSource,handler){var viewSourceToggleTitle=viewSource?Common.UIString('view parsed'):Common.UIString('view source');var viewSourceToggleButton=this._createToggleButton(viewSourceToggleTitle);viewSourceToggleButton.addEventListener('click',handler,false);return viewSourceToggleButton;}
_toggleURLDecoding(event){this._decodeRequestParameters=!this._decodeRequestParameters;this._refreshQueryString();this._refreshFormData();event.consume();}
_refreshRequestHeaders(){var treeElement=this._requestHeadersCategory;var headers=this._request.requestHeaders().slice();headers.sort(function(a,b){return a.name.toLowerCase().compareTo(b.name.toLowerCase());});var headersText=this._request.requestHeadersText();if(this._showRequestHeadersText&&headersText)
this._refreshHeadersText(Common.UIString('Request Headers'),headers.length,headersText,treeElement);else
this._refreshHeaders(Common.UIString('Request Headers'),headers,treeElement,headersText===undefined);if(headersText){var toggleButton=this._createHeadersToggleButton(this._showRequestHeadersText);toggleButton.addEventListener('click',this._toggleRequestHeadersText.bind(this),false);treeElement.listItemElement.appendChild(toggleButton);}
this._refreshFormData();}
_refreshResponseHeaders(){var treeElement=this._responseHeadersCategory;var headers=this._request.sortedResponseHeaders.slice();var headersText=this._request.responseHeadersText;if(this._showResponseHeadersText)
this._refreshHeadersText(Common.UIString('Response Headers'),headers.length,headersText,treeElement);else
this._refreshHeaders(Common.UIString('Response Headers'),headers,treeElement);if(headersText){var toggleButton=this._createHeadersToggleButton(this._showResponseHeadersText);toggleButton.addEventListener('click',this._toggleResponseHeadersText.bind(this),false);treeElement.listItemElement.appendChild(toggleButton);}}
_refreshHTTPInformation(){var requestMethodElement=this._requestMethodItem;requestMethodElement.hidden=!this._request.statusCode;var statusCodeElement=this._statusCodeItem;statusCodeElement.hidden=!this._request.statusCode;if(this._request.statusCode){var statusCodeFragment=createDocumentFragment();statusCodeFragment.createChild('div','header-name').textContent=Common.UIString('Status Code')+':';var statusCodeImage=statusCodeFragment.createChild('label','resource-status-image','dt-icon-label');statusCodeImage.title=this._request.statusCode+' '+this._request.statusText;if(this._request.statusCode<300||this._request.statusCode===304)
statusCodeImage.type='smallicon-green-ball';else if(this._request.statusCode<400)
statusCodeImage.type='smallicon-orange-ball';else
statusCodeImage.type='smallicon-red-ball';requestMethodElement.title=this._formatHeader(Common.UIString('Request Method'),this._request.requestMethod);var statusTextElement=statusCodeFragment.createChild('div','header-value source-code');var statusText=this._request.statusCode+' '+this._request.statusText;if(this._request.fetchedViaServiceWorker){statusText+=' '+Common.UIString('(from ServiceWorker)');statusTextElement.classList.add('status-from-cache');}else if(this._request.cached()){if(this._request.cachedInMemory())
statusText+=' '+Common.UIString('(from memory cache)');else
statusText+=' '+Common.UIString('(from disk cache)');statusTextElement.classList.add('status-from-cache');}
statusTextElement.textContent=statusText;statusCodeElement.title=statusCodeFragment;}}
_refreshHeadersTitle(title,headersTreeElement,headersLength){headersTreeElement.listItemElement.removeChildren();headersTreeElement.listItemElement.createTextChild(title);var headerCount=Common.UIString('\u00A0(%d)',headersLength);headersTreeElement.listItemElement.createChild('span','header-count').textContent=headerCount;}
_refreshHeaders(title,headers,headersTreeElement,provisionalHeaders){headersTreeElement.removeChildren();var length=headers.length;this._refreshHeadersTitle(title,headersTreeElement,length);if(provisionalHeaders){var cautionText=Common.UIString('Provisional headers are shown');var cautionFragment=createDocumentFragment();cautionFragment.createChild('label','','dt-icon-label').type='smallicon-warning';cautionFragment.createChild('div','caution').textContent=cautionText;var cautionTreeElement=new UI.TreeElement(cautionFragment);cautionTreeElement.selectable=false;headersTreeElement.appendChild(cautionTreeElement);}
headersTreeElement.hidden=!length&&!provisionalHeaders;for(var i=0;i<length;++i){var headerTreeElement=new UI.TreeElement(this._formatHeader(headers[i].name,headers[i].value));headerTreeElement.selectable=false;headersTreeElement.appendChild(headerTreeElement);}}
_refreshHeadersText(title,count,headersText,headersTreeElement){this._populateTreeElementWithSourceText(headersTreeElement,headersText);this._refreshHeadersTitle(title,headersTreeElement,count);}
_refreshRemoteAddress(){var remoteAddress=this._request.remoteAddress();var treeElement=this._remoteAddressItem;treeElement.hidden=!remoteAddress;if(remoteAddress)
treeElement.title=this._formatHeader(Common.UIString('Remote Address'),remoteAddress);}
_refreshReferrerPolicy(){var referrerPolicy=this._request.referrerPolicy();var treeElement=this._referrerPolicyItem;treeElement.hidden=!referrerPolicy;if(referrerPolicy)
treeElement.title=this._formatHeader(Common.UIString('Referrer Policy'),referrerPolicy);}
_toggleRequestHeadersText(event){this._showRequestHeadersText=!this._showRequestHeadersText;this._refreshRequestHeaders();event.consume();}
_toggleResponseHeadersText(event){this._showResponseHeadersText=!this._showResponseHeadersText;this._refreshResponseHeaders();event.consume();}
_createToggleButton(title){var button=createElementWithClass('span','header-toggle');button.textContent=title;return button;}
_createHeadersToggleButton(isHeadersTextShown){var toggleTitle=isHeadersTextShown?Common.UIString('view parsed'):Common.UIString('view source');return this._createToggleButton(toggleTitle);}};Network.RequestHeadersView._viewSourceSymbol=Symbol('ViewSource');Network.RequestHeadersView.Category=class extends UI.TreeElement{constructor(root,name,title){super(title||'',true);this.selectable=false;this.toggleOnClick=true;this.hidden=true;this._expandedSetting=Common.settings.createSetting('request-info-'+name+'-category-expanded',true);this.expanded=this._expandedSetting.get();root.appendChild(this);}
createLeaf(){var leaf=new UI.TreeElement();leaf.selectable=false;this.appendChild(leaf);return leaf;}
onexpand(){this._expandedSetting.set(true);}
oncollapse(){this._expandedSetting.set(false);}};;Network.RequestHTMLView=class extends Network.RequestView{constructor(request,dataURL){super(request);this._dataURL=dataURL;this.element.classList.add('html');}
wasShown(){this._createIFrame();}
willHide(){this.element.removeChildren();}
_createIFrame(){this.element.removeChildren();var iframe=createElement('iframe');iframe.setAttribute('sandbox','');iframe.setAttribute('src',this._dataURL);this.element.appendChild(iframe);}};;Network.RequestPreviewView=class extends Network.RequestContentView{constructor(request,responseView){super(request);this._responseView=responseView;this._previewView=null;}
contentLoaded(){if(!this.request.content&&!this.request.contentError()){if(!this._emptyWidget){this._emptyWidget=this._createEmptyWidget();this._emptyWidget.show(this.element);this._previewView=this._emptyWidget;}
return;}
if(this._emptyWidget){this._emptyWidget.detach();delete this._emptyWidget;this._previewView=null;}
if(!this._previewView)
this._createPreviewView(handlePreviewView.bind(this));else
this._previewView.show(this.element);function handlePreviewView(view){this._previewView=view;view.show(this.element);if(view instanceof UI.SimpleView){var toolbar=new UI.Toolbar('network-item-preview-toolbar',this.element);for(var item of(this._previewView).syncToolbarItems())
toolbar.appendToolbarItem(item);}
this._previewViewHandledForTest(view);}}
_previewViewHandledForTest(view){}
_createEmptyWidget(){return this._createMessageView(Common.UIString('This request has no preview available.'));}
_createMessageView(message){return new UI.EmptyWidget(message);}
_requestContent(){var content=this.request.content;return this.request.contentEncoded?window.atob(content||''):(content||'');}
_jsonView(parsedJSON){if(!parsedJSON||typeof parsedJSON.data!=='object')
return null;return Network.JSONView.createSearchableView((parsedJSON));}
_xmlView(){var parsedXML=Network.XMLView.parseXML(this._requestContent(),this.request.mimeType);return parsedXML?Network.XMLView.createSearchableView(parsedXML):null;}
_htmlErrorPreview(){var whitelist=['text/html','text/plain','application/xhtml+xml'];if(whitelist.indexOf(this.request.mimeType)===-1)
return null;var dataURL=this.request.asDataURL();if(dataURL===null)
return null;return new Network.RequestHTMLView(this.request,dataURL);}
_createPreviewView(callback){if(this.request.contentError()){callback(this._createMessageView(Common.UIString('Failed to load response data')));return;}
var xmlView=this._xmlView();if(xmlView){callback(xmlView);return;}
Network.JSONView.parseJSON(this._requestContent()).then(chooseView.bind(this)).then(callback);function chooseView(jsonData){if(jsonData){var jsonView=this._jsonView(jsonData);if(jsonView)
return jsonView;}
if(this.request.hasErrorStatusCode()||this.request.resourceType()===Common.resourceTypes.XHR){var htmlErrorPreview=this._htmlErrorPreview();if(htmlErrorPreview)
return htmlErrorPreview;}
if(this._responseView.sourceView)
return this._responseView.sourceView;if(this.request.resourceType()===Common.resourceTypes.Other)
return this._createEmptyWidget();return Network.RequestView.nonSourceViewForRequest(this.request);}}};;Network.RequestResponseView=class extends Network.RequestContentView{constructor(request){super(request);}
get sourceView(){if(this._sourceView||!Network.RequestView.hasTextContent(this.request))
return this._sourceView;var contentProvider=new Network.RequestResponseView.ContentProvider(this.request);var highlighterType=this.request.resourceType().canonicalMimeType()||this.request.mimeType;this._sourceView=SourceFrame.ResourceSourceFrame.createSearchableView(contentProvider,highlighterType);return this._sourceView;}
_createMessageView(message){return new UI.EmptyWidget(message);}
contentLoaded(){if((!this.request.content||!this.sourceView)&&!this.request.contentError()){if(!this._emptyWidget){this._emptyWidget=this._createMessageView(Common.UIString('This request has no response data available.'));this._emptyWidget.show(this.element);}}else{if(this._emptyWidget){this._emptyWidget.detach();delete this._emptyWidget;}
if(this.request.content&&this.sourceView){this.sourceView.show(this.element);}else{if(!this._errorView)
this._errorView=this._createMessageView(Common.UIString('Failed to load response data'));this._errorView.show(this.element);}}}};Network.RequestResponseView.ContentProvider=class{constructor(request){this._request=request;}
contentURL(){return this._request.contentURL();}
contentType(){return this._request.resourceType();}
requestContent(){function decodeContent(content){return this._request.contentEncoded?window.atob(content||''):content;}
return this._request.requestContent().then(decodeContent.bind(this));}
searchInContent(query,caseSensitive,isRegex,callback){this._request.searchInContent(query,caseSensitive,isRegex,callback);}};;Network.RequestTimingView=class extends UI.VBox{constructor(request,calculator){super();this.element.classList.add('resource-timing-view');this._request=request;this._calculator=calculator;}
static _timeRangeTitle(name){switch(name){case Network.RequestTimeRangeNames.Push:return Common.UIString('Receiving Push');case Network.RequestTimeRangeNames.Queueing:return Common.UIString('Queueing');case Network.RequestTimeRangeNames.Blocking:return Common.UIString('Stalled');case Network.RequestTimeRangeNames.Connecting:return Common.UIString('Initial connection');case Network.RequestTimeRangeNames.DNS:return Common.UIString('DNS Lookup');case Network.RequestTimeRangeNames.Proxy:return Common.UIString('Proxy negotiation');case Network.RequestTimeRangeNames.ReceivingPush:return Common.UIString('Reading Push');case Network.RequestTimeRangeNames.Receiving:return Common.UIString('Content Download');case Network.RequestTimeRangeNames.Sending:return Common.UIString('Request sent');case Network.RequestTimeRangeNames.ServiceWorker:return Common.UIString('Request to ServiceWorker');case Network.RequestTimeRangeNames.ServiceWorkerPreparation:return Common.UIString('ServiceWorker Preparation');case Network.RequestTimeRangeNames.SSL:return Common.UIString('SSL');case Network.RequestTimeRangeNames.Total:return Common.UIString('Total');case Network.RequestTimeRangeNames.Waiting:return Common.UIString('Waiting (TTFB)');default:return Common.UIString(name);}}
static calculateRequestTimeRanges(request,navigationStart){var result=[];function addRange(name,start,end){if(start<Number.MAX_VALUE&&start<=end)
result.push({name:name,start:start,end:end});}
function firstPositive(numbers){for(var i=0;i<numbers.length;++i){if(numbers[i]>0)
return numbers[i];}
return undefined;}
function addOffsetRange(name,start,end){if(start>=0&&end>=0)
addRange(name,startTime+(start/1000),startTime+(end/1000));}
var timing=request.timing;if(!timing){var start=request.issueTime()!==-1?request.issueTime():request.startTime!==-1?request.startTime:0;var middle=(request.responseReceivedTime===-1)?Number.MAX_VALUE:request.responseReceivedTime;var end=(request.endTime===-1)?Number.MAX_VALUE:request.endTime;addRange(Network.RequestTimeRangeNames.Total,start,end);addRange(Network.RequestTimeRangeNames.Blocking,start,middle);addRange(Network.RequestTimeRangeNames.Receiving,middle,end);return result;}
var issueTime=request.issueTime();var startTime=timing.requestTime;var endTime=firstPositive([request.endTime,request.responseReceivedTime])||startTime;addRange(Network.RequestTimeRangeNames.Total,issueTime<startTime?issueTime:startTime,endTime);if(timing.pushStart){var pushEnd=timing.pushEnd||endTime;if(pushEnd>navigationStart)
addRange(Network.RequestTimeRangeNames.Push,Math.max(timing.pushStart,navigationStart),pushEnd);}
if(issueTime<startTime)
addRange(Network.RequestTimeRangeNames.Queueing,issueTime,startTime);if(request.fetchedViaServiceWorker){addOffsetRange(Network.RequestTimeRangeNames.Blocking,0,timing.workerStart);addOffsetRange(Network.RequestTimeRangeNames.ServiceWorkerPreparation,timing.workerStart,timing.workerReady);addOffsetRange(Network.RequestTimeRangeNames.ServiceWorker,timing.workerReady,timing.sendEnd);addOffsetRange(Network.RequestTimeRangeNames.Waiting,timing.sendEnd,timing.receiveHeadersEnd);}else if(!timing.pushStart){var blocking=firstPositive([timing.dnsStart,timing.connectStart,timing.sendStart])||0;addOffsetRange(Network.RequestTimeRangeNames.Blocking,0,blocking);addOffsetRange(Network.RequestTimeRangeNames.Proxy,timing.proxyStart,timing.proxyEnd);addOffsetRange(Network.RequestTimeRangeNames.DNS,timing.dnsStart,timing.dnsEnd);addOffsetRange(Network.RequestTimeRangeNames.Connecting,timing.connectStart,timing.connectEnd);addOffsetRange(Network.RequestTimeRangeNames.SSL,timing.sslStart,timing.sslEnd);addOffsetRange(Network.RequestTimeRangeNames.Sending,timing.sendStart,timing.sendEnd);addOffsetRange(Network.RequestTimeRangeNames.Waiting,timing.sendEnd,timing.receiveHeadersEnd);}
if(request.endTime!==-1){addRange(timing.pushStart?Network.RequestTimeRangeNames.ReceivingPush:Network.RequestTimeRangeNames.Receiving,request.responseReceivedTime,endTime);}
return result;}
static createTimingTable(request,calculator){var tableElement=createElementWithClass('table','network-timing-table');UI.appendStyle(tableElement,'network/networkTimingTable.css');var colgroup=tableElement.createChild('colgroup');colgroup.createChild('col','labels');colgroup.createChild('col','bars');colgroup.createChild('col','duration');var timeRanges=Network.RequestTimingView.calculateRequestTimeRanges(request,calculator.minimumBoundary());var startTime=timeRanges.map(r=>r.start).reduce((a,b)=>Math.min(a,b));var endTime=timeRanges.map(r=>r.end).reduce((a,b)=>Math.max(a,b));var scale=100/(endTime-startTime);var connectionHeader;var dataHeader;var queueingHeader;var totalDuration=0;var startTimeHeader=tableElement.createChild('thead','network-timing-start');var queuedCell=startTimeHeader.createChild('tr').createChild('td');var startedCell=startTimeHeader.createChild('tr').createChild('td');queuedCell.colSpan=startedCell.colSpan=2;queuedCell.createTextChild(Common.UIString('Queued at %s',calculator.formatValue(request.issueTime(),2)));startedCell.createTextChild(Common.UIString('Started at %s',calculator.formatValue(request.startTime,2)));for(var i=0;i<timeRanges.length;++i){var range=timeRanges[i];var rangeName=range.name;if(rangeName===Network.RequestTimeRangeNames.Total){totalDuration=range.end-range.start;continue;}
if(rangeName===Network.RequestTimeRangeNames.Push){createHeader(Common.UIString('Server Push'));}else if(rangeName===Network.RequestTimeRangeNames.Queueing){queueingHeader=tableElement.createChild('tr','network-timing-table-header');queueingHeader.createChild('td').createTextChild(Common.UIString('Resource Scheduling'));queueingHeader.createChild('td').createTextChild('');queueingHeader.createChild('td').createTextChild(Common.UIString('TIME'));}else if(Network.RequestTimingView.ConnectionSetupRangeNames.has(rangeName)){if(!connectionHeader)
connectionHeader=createHeader(Common.UIString('Connection Start'));}else{if(!dataHeader)
dataHeader=createHeader(Common.UIString('Request/Response'));}
var left=(scale*(range.start-startTime));var right=(scale*(endTime-range.end));var duration=range.end-range.start;var tr=tableElement.createChild('tr');tr.createChild('td').createTextChild(Network.RequestTimingView._timeRangeTitle(rangeName));var row=tr.createChild('td').createChild('div','network-timing-row');var bar=row.createChild('span','network-timing-bar '+rangeName);bar.style.left=left+'%';bar.style.right=right+'%';bar.textContent='\u200B';var label=tr.createChild('td').createChild('div','network-timing-bar-title');label.textContent=Number.secondsToString(duration,true);}
if(!request.finished){var cell=tableElement.createChild('tr').createChild('td','caution');cell.colSpan=3;cell.createTextChild(Common.UIString('CAUTION: request is not finished yet!'));}
var footer=tableElement.createChild('tr','network-timing-footer');var note=footer.createChild('td');note.colSpan=1;note.appendChild(UI.createDocumentationLink('network-performance/reference#timing',Common.UIString('Explanation')));footer.createChild('td');footer.createChild('td').createTextChild(Number.secondsToString(totalDuration,true));var serverTimings=request.serverTimings;if(!serverTimings)
return tableElement;var lastTimingRightEdge=right===undefined?100:right;var breakElement=tableElement.createChild('tr','network-timing-table-header').createChild('td');breakElement.colSpan=3;breakElement.createChild('hr','break');var serverHeader=tableElement.createChild('tr','network-timing-table-header');serverHeader.createChild('td').createTextChild(Common.UIString('Server Timing'));serverHeader.createChild('td');serverHeader.createChild('td').createTextChild(Common.UIString('TIME'));serverTimings.filter(item=>item.metric.toLowerCase()!=='total').forEach(item=>addTiming(item,lastTimingRightEdge));serverTimings.filter(item=>item.metric.toLowerCase()==='total').forEach(item=>addTiming(item,lastTimingRightEdge));return tableElement;function addTiming(serverTiming,right){var colorGenerator=new PerfUI.FlameChart.ColorGenerator({min:0,max:360,count:36},{min:50,max:80},80);var isTotal=serverTiming.metric.toLowerCase()==='total';var tr=tableElement.createChild('tr',isTotal?'network-timing-footer':'');var metric=tr.createChild('td','network-timing-metric');metric.createTextChild(serverTiming.description||serverTiming.metric);var row=tr.createChild('td').createChild('div','network-timing-row');if(serverTiming.value===null)
return;var left=scale*(endTime-startTime-(serverTiming.value/1000));if(left>=0){var bar=row.createChild('span','network-timing-bar server-timing');bar.style.left=left+'%';bar.style.right=right+'%';bar.textContent='\u200B';if(!isTotal)
bar.style.backgroundColor=colorGenerator.colorForID(serverTiming.metric);}
var label=tr.createChild('td').createChild('div','network-timing-bar-title');label.textContent=Number.millisToString(serverTiming.value,true);}
function createHeader(title){var dataHeader=tableElement.createChild('tr','network-timing-table-header');dataHeader.createChild('td').createTextChild(title);dataHeader.createChild('td').createTextChild('');dataHeader.createChild('td').createTextChild(Common.UIString('TIME'));return dataHeader;}}
wasShown(){this._request.addEventListener(SDK.NetworkRequest.Events.TimingChanged,this._refresh,this);this._request.addEventListener(SDK.NetworkRequest.Events.FinishedLoading,this._refresh,this);this._calculator.addEventListener(Network.NetworkTimeCalculator.Events.BoundariesChanged,this._refresh,this);this._refresh();}
willHide(){this._request.removeEventListener(SDK.NetworkRequest.Events.TimingChanged,this._refresh,this);this._request.removeEventListener(SDK.NetworkRequest.Events.FinishedLoading,this._refresh,this);this._calculator.removeEventListener(Network.NetworkTimeCalculator.Events.BoundariesChanged,this._refresh,this);}
_refresh(){if(this._tableElement)
this._tableElement.remove();this._tableElement=Network.RequestTimingView.createTimingTable(this._request,this._calculator);this._tableElement.classList.add('resource-timing-table');this.element.appendChild(this._tableElement);}};Network.RequestTimeRangeNames={Push:'push',Queueing:'queueing',Blocking:'blocking',Connecting:'connecting',DNS:'dns',Proxy:'proxy',Receiving:'receiving',ReceivingPush:'receiving-push',Sending:'sending',ServiceWorker:'serviceworker',ServiceWorkerPreparation:'serviceworker-preparation',SSL:'ssl',Total:'total',Waiting:'waiting'};Network.RequestTimingView.ConnectionSetupRangeNames=new Set([Network.RequestTimeRangeNames.Queueing,Network.RequestTimeRangeNames.Blocking,Network.RequestTimeRangeNames.Connecting,Network.RequestTimeRangeNames.DNS,Network.RequestTimeRangeNames.Proxy,Network.RequestTimeRangeNames.SSL]);Network.RequestTimeRange;;Network.ResourceWebSocketFrameView=class extends UI.VBox{constructor(request){super();this.registerRequiredCSS('network/webSocketFrameView.css');this.element.classList.add('websocket-frame-view');this._request=request;this._splitWidget=new UI.SplitWidget(false,true,'resourceWebSocketFrameSplitViewState');this._splitWidget.show(this.element);var columns=([{id:'data',title:Common.UIString('Data'),sortable:false,weight:88},{id:'length',title:Common.UIString('Length'),sortable:false,align:DataGrid.DataGrid.Align.Right,weight:5},{id:'time',title:Common.UIString('Time'),sortable:true,weight:7}]);this._dataGrid=new DataGrid.SortableDataGrid(columns);this._dataGrid.setRowContextMenuCallback(onRowContextMenu);this._dataGrid.setStickToBottom(true);this._dataGrid.setCellClass('websocket-frame-view-td');this._timeComparator=(Network.ResourceWebSocketFrameNodeTimeComparator);this._dataGrid.sortNodes(this._timeComparator,false);this._dataGrid.markColumnAsSortedBy('time',DataGrid.DataGrid.Order.Ascending);this._dataGrid.addEventListener(DataGrid.DataGrid.Events.SortingChanged,this._sortItems,this);this._dataGrid.setName('ResourceWebSocketFrameView');this._dataGrid.addEventListener(DataGrid.DataGrid.Events.SelectedNode,this._onFrameSelected,this);this._dataGrid.addEventListener(DataGrid.DataGrid.Events.DeselectedNode,this._onFrameDeselected,this);this._splitWidget.setMainWidget(this._dataGrid.asWidget());var view=new UI.EmptyWidget('Select frame to browse its content.');this._splitWidget.setSidebarWidget(view);this._selectedNode=null;function onRowContextMenu(contextMenu,node){contextMenu.appendItem(Common.UIString.capitalize('Copy ^message'),InspectorFrontendHost.copyText.bind(InspectorFrontendHost,node.data.data));}}
static opCodeDescription(opCode,mask){var rawDescription=Network.ResourceWebSocketFrameView.opCodeDescriptions[opCode]||'';var localizedDescription=Common.UIString(rawDescription);return Common.UIString('%s (Opcode %d%s)',localizedDescription,opCode,(mask?', mask':''));}
wasShown(){this.refresh();this._request.addEventListener(SDK.NetworkRequest.Events.WebsocketFrameAdded,this._frameAdded,this);}
willHide(){this._request.removeEventListener(SDK.NetworkRequest.Events.WebsocketFrameAdded,this._frameAdded,this);}
_frameAdded(event){var frame=(event.data);this._dataGrid.insertChild(new Network.ResourceWebSocketFrameNode(this._request.url(),frame));}
_onFrameSelected(event){var selectedNode=(event.data);this._currentSelectedNode=selectedNode;var contentProvider=selectedNode.contentProvider();contentProvider.requestContent().then(contentHandler.bind(this));function contentHandler(content){if(this._currentSelectedNode!==selectedNode)
return;Network.JSONView.parseJSON(content).then(handleJSONData.bind(this));}
function handleJSONData(parsedJSON){if(this._currentSelectedNode!==selectedNode)
return;if(parsedJSON)
this._splitWidget.setSidebarWidget(Network.JSONView.createSearchableView(parsedJSON));else
this._splitWidget.setSidebarWidget(new SourceFrame.ResourceSourceFrame(contentProvider));}}
_onFrameDeselected(event){this._currentSelectedNode=null;}
refresh(){this._dataGrid.rootNode().removeChildren();var frames=this._request.frames();for(var i=0;i<frames.length;++i)
this._dataGrid.insertChild(new Network.ResourceWebSocketFrameNode(this._request.url(),frames[i]));}
_sortItems(){this._dataGrid.sortNodes(this._timeComparator,!this._dataGrid.isSortOrderAscending());}};Network.ResourceWebSocketFrameView.OpCodes={ContinuationFrame:0,TextFrame:1,BinaryFrame:2,ConnectionCloseFrame:8,PingFrame:9,PongFrame:10};Network.ResourceWebSocketFrameView.opCodeDescriptions=(function(){var opCodes=Network.ResourceWebSocketFrameView.OpCodes;var map=[];map[opCodes.ContinuationFrame]='Continuation Frame';map[opCodes.TextFrame]='Text Frame';map[opCodes.BinaryFrame]='Binary Frame';map[opCodes.ContinuationFrame]='Connection Close Frame';map[opCodes.PingFrame]='Ping Frame';map[opCodes.PongFrame]='Pong Frame';return map;})();Network.ResourceWebSocketFrameNode=class extends DataGrid.SortableDataGridNode{constructor(url,frame){var dataText=frame.text;var length=frame.text.length;var time=new Date(frame.time*1000);var timeText=('0'+time.getHours()).substr(-2)+':'+('0'+time.getMinutes()).substr(-2)+':'+
('0'+time.getSeconds()).substr(-2)+'.'+('00'+time.getMilliseconds()).substr(-3);var timeNode=createElement('div');timeNode.createTextChild(timeText);timeNode.title=time.toLocaleString();var isTextFrame=frame.opCode===Network.ResourceWebSocketFrameView.OpCodes.TextFrame;if(!isTextFrame)
dataText=Network.ResourceWebSocketFrameView.opCodeDescription(frame.opCode,frame.mask);super({data:dataText,length:length,time:timeNode});this._url=url;this._frame=frame;this._isTextFrame=isTextFrame;this._dataText=dataText;}
createCells(element){element.classList.toggle('websocket-frame-view-row-error',this._frame.type===SDK.NetworkRequest.WebSocketFrameType.Error);element.classList.toggle('websocket-frame-view-row-outcoming',this._frame.type===SDK.NetworkRequest.WebSocketFrameType.Send);element.classList.toggle('websocket-frame-view-row-opcode',!this._isTextFrame);super.createCells(element);}
nodeSelfHeight(){return 21;}
contentProvider(){return Common.StaticContentProvider.fromString(this._url,Common.resourceTypes.WebSocket,this._dataText);}};Network.ResourceWebSocketFrameNodeTimeComparator=function(a,b){return a._frame.time-b._frame.time;};;Network.NetworkPanel=class extends UI.Panel{constructor(){super('network');this.registerRequiredCSS('network/networkPanel.css');this._networkLogShowOverviewSetting=Common.settings.createSetting('networkLogShowOverview',true);this._networkLogLargeRowsSetting=Common.settings.createSetting('networkLogLargeRows',false);this._networkRecordFilmStripSetting=Common.settings.createSetting('networkRecordFilmStripSetting',false);this._toggleRecordAction=(UI.actionRegistry.action('network.toggle-recording'));this._filmStripView=null;this._filmStripRecorder=null;this._panelToolbar=new UI.Toolbar('',this.element);this._filterBar=new UI.FilterBar('networkPanel',true);this._filterBar.show(this.element);this._overviewPane=new PerfUI.TimelineOverviewPane('network');this._overviewPane.addEventListener(PerfUI.TimelineOverviewPane.Events.WindowChanged,this._onWindowChanged.bind(this));this._overviewPane.element.id='network-overview-panel';this._networkOverview=new Network.NetworkOverview();this._overviewPane.setOverviewControls([this._networkOverview]);this._calculator=new Network.NetworkTransferTimeCalculator();this._splitWidget=new UI.SplitWidget(true,false,'networkPanelSplitViewState');this._splitWidget.hideMain();this._splitWidget.show(this.element);this._progressBarContainer=createElement('div');this._searchableView=new UI.SearchableView(this);this._searchableView.setPlaceholder(Common.UIString('Find by filename or path'));this._networkLogView=new Network.NetworkLogView(this._filterBar,this._progressBarContainer,this._networkLogLargeRowsSetting);this._networkLogView.show(this._searchableView.element);this._splitWidget.setSidebarWidget(this._searchableView);this._detailsWidget=new UI.VBox();this._detailsWidget.element.classList.add('network-details-view');this._splitWidget.setMainWidget(this._detailsWidget);this._closeButtonElement=createElement('div','dt-close-button');this._closeButtonElement.addEventListener('click',this._showRequest.bind(this,null),false);this._networkLogShowOverviewSetting.addChangeListener(this._toggleShowOverview,this);this._networkLogLargeRowsSetting.addChangeListener(this._toggleLargerRequests,this);this._networkRecordFilmStripSetting.addChangeListener(this._toggleRecordFilmStrip,this);this._groupingExtensions=new Map();this._createToolbarButtons();this._toggleRecord(true);this._toggleShowOverview();this._toggleLargerRequests();this._toggleRecordFilmStrip();this._updateUI();SDK.targetManager.addModelListener(SDK.ResourceTreeModel,SDK.ResourceTreeModel.Events.WillReloadPage,this._willReloadPage,this);SDK.targetManager.addModelListener(SDK.ResourceTreeModel,SDK.ResourceTreeModel.Events.Load,this._load,this);this._networkLogView.addEventListener(Network.NetworkLogView.Events.RequestSelected,this._onRequestSelected,this);this._networkLogView.addEventListener(Network.NetworkLogView.Events.SearchCountUpdated,this._onSearchCountUpdated,this);this._networkLogView.addEventListener(Network.NetworkLogView.Events.SearchIndexUpdated,this._onSearchIndexUpdated,this);this._networkLogView.addEventListener(Network.NetworkLogView.Events.UpdateRequest,this._onUpdateRequest,this);Components.DataSaverInfobar.maybeShowInPanel(this);var blockedURLsSetting=Common.moduleSetting('networkBlockedURLs');blockedURLsSetting.addChangeListener(updateIconVisibility.bind(this));var requestBlockingEnabledSetting=Common.moduleSetting('requestBlockingEnabled');requestBlockingEnabledSetting.addChangeListener(updateIconVisibility.bind(this));SDK.multitargetNetworkManager.addEventListener(SDK.MultitargetNetworkManager.Events.ConditionsChanged,updateIconVisibility.bind(this));updateIconVisibility.call(this);function updateIconVisibility(){var icon=null;if(SDK.multitargetNetworkManager.isThrottling()){icon=UI.Icon.create('smallicon-warning');icon.title=Common.UIString('Network throttling is enabled');}else if(requestBlockingEnabledSetting.get()&&blockedURLsSetting.get().length){icon=UI.Icon.create('smallicon-warning');icon.title=Common.UIString('Requests may be blocked');}
UI.inspectorView.setPanelIcon(this.name,icon);}}
static revealAndFilter(filters){var panel=Network.NetworkPanel._instance();var filterString='';for(var filter of filters)
filterString+=`${filter.filterType}:${filter.filterValue} `;panel._networkLogView.setTextFilterValue(filterString);UI.viewManager.showView('network');}
static _instance(){return(self.runtime.sharedInstance(Network.NetworkPanel));}
_onWindowChanged(event){var startTime=Math.max(this._calculator.minimumBoundary(),event.data.startTime/1000);var endTime=Math.min(this._calculator.maximumBoundary(),event.data.endTime/1000);this._networkLogView.setWindow(startTime,endTime);}
_createToolbarButtons(){this._panelToolbar.appendToolbarItem(UI.Toolbar.createActionButton(this._toggleRecordAction));this._clearButton=new UI.ToolbarButton(Common.UIString('Clear'),'largeicon-clear');this._clearButton.addEventListener(UI.ToolbarButton.Events.Click,this._onClearButtonClicked,this);this._panelToolbar.appendToolbarItem(this._clearButton);this._panelToolbar.appendSeparator();var recordFilmStripButton=new UI.ToolbarSettingToggle(this._networkRecordFilmStripSetting,'largeicon-camera',Common.UIString('Capture screenshots'));this._panelToolbar.appendToolbarItem(recordFilmStripButton);this._panelToolbar.appendToolbarItem(this._filterBar.filterButton());this._panelToolbar.appendSeparator();this._panelToolbar.appendText(Common.UIString('View:'));var largerRequestsButton=new UI.ToolbarSettingToggle(this._networkLogLargeRowsSetting,'largeicon-large-list',Common.UIString('Use large request rows'),Common.UIString('Use small request rows'));this._panelToolbar.appendToolbarItem(largerRequestsButton);var showOverviewButton=new UI.ToolbarSettingToggle(this._networkLogShowOverviewSetting,'largeicon-waterfall',Common.UIString('Show overview'),Common.UIString('Hide overview'));this._panelToolbar.appendToolbarItem(showOverviewButton);this._panelToolbar.appendSeparator();this._preserveLogCheckbox=new UI.ToolbarCheckbox(Common.UIString('Preserve log'),Common.UIString('Do not clear log on page reload / navigation'));this._preserveLogCheckbox.inputElement.addEventListener('change',this._onPreserveLogCheckboxChanged.bind(this),false);this._panelToolbar.appendToolbarItem(this._preserveLogCheckbox);this._disableCacheCheckbox=new UI.ToolbarSettingCheckbox(Common.moduleSetting('cacheDisabled'),Common.UIString('Disable cache (while DevTools is open)'),Common.UIString('Disable cache'));this._panelToolbar.appendToolbarItem(this._disableCacheCheckbox);this._panelToolbar.appendSeparator();this._panelToolbar.appendToolbarItem(NetworkConditions.NetworkConditionsSelector.createOfflineToolbarCheckbox());this._panelToolbar.appendToolbarItem(this._createNetworkConditionsSelect());this._setupGroupingCombo();this._panelToolbar.appendToolbarItem(new UI.ToolbarItem(this._progressBarContainer));}
_setupGroupingCombo(){var extensions=self.runtime.extensions(Network.NetworkGroupLookupInterface);if(!extensions.length)
return;var setting=Common.settings.createSetting('networkGrouping','');var options=[{value:'',label:Common.UIString('No grouping'),title:Common.UIString('No grouping')}];extensions.forEach(extension=>{var identifier=extension.descriptor()['id'];this._groupingExtensions.set(identifier,extension);options.push({value:identifier,label:extension.title(),title:extension.title()});});this._panelToolbar.appendToolbarItem(new UI.ToolbarSettingComboBox(options,setting,Common.UIString('Group by')));setting.addChangeListener(event=>this._groupingChanged((event.data)));this._groupingChanged(setting.get());}
_groupingChanged(identifier){var extension=this._groupingExtensions.get(identifier);if(extension){extension.instance().then(grouping=>this._networkLogView.setGrouping((grouping)));}else{this._networkLogView.setGrouping(null);}}
_createNetworkConditionsSelect(){var toolbarItem=new UI.ToolbarComboBox(null);toolbarItem.setMaxWidth(140);NetworkConditions.NetworkConditionsSelector.decorateSelect(toolbarItem.selectElement());return toolbarItem;}
_toggleRecording(){if(!this._preserveLogCheckbox.checked()&&!this._toggleRecordAction.toggled())
this._reset();this._toggleRecord(!this._toggleRecordAction.toggled());}
_toggleRecord(toggled){this._toggleRecordAction.setToggled(toggled);this._networkLogView.setRecording(toggled);if(!toggled&&this._filmStripRecorder)
this._filmStripRecorder.stopRecording(this._filmStripAvailable.bind(this));}
_filmStripAvailable(filmStripModel){if(!filmStripModel)
return;var calculator=this._networkLogView.timeCalculator();this._filmStripView.setModel(filmStripModel,calculator.minimumBoundary()*1000,calculator.boundarySpan()*1000);this._networkOverview.setFilmStripModel(filmStripModel);var timestamps=filmStripModel.frames().map(mapTimestamp);function mapTimestamp(frame){return frame.timestamp/1000;}
this._networkLogView.addFilmStripFrames(timestamps);}
_onPreserveLogCheckboxChanged(event){this._networkLogView.setPreserveLog(this._preserveLogCheckbox.checked());}
_onClearButtonClicked(event){this._reset();}
_reset(){this._calculator.reset();this._overviewPane.reset();this._networkLogView.reset();Network.BlockedURLsPane.reset();if(this._filmStripView)
this._resetFilmStripView();}
_willReloadPage(event){if(!this._preserveLogCheckbox.checked())
this._reset();this._toggleRecord(true);if(this._pendingStopTimer){clearTimeout(this._pendingStopTimer);delete this._pendingStopTimer;}
if(this.isShowing()&&this._filmStripRecorder)
this._filmStripRecorder.startRecording();}
_load(event){if(this._filmStripRecorder&&this._filmStripRecorder.isRecording()){this._pendingStopTimer=setTimeout(this._stopFilmStripRecording.bind(this),Network.NetworkPanel.displayScreenshotDelay);}}
_stopFilmStripRecording(){this._filmStripRecorder.stopRecording(this._filmStripAvailable.bind(this));delete this._pendingStopTimer;}
_toggleLargerRequests(){this._updateUI();}
_toggleShowOverview(){var toggled=this._networkLogShowOverviewSetting.get();if(toggled)
this._overviewPane.show(this.element,this._splitWidget.element);else
this._overviewPane.detach();this.doResize();}
_toggleRecordFilmStrip(){var toggled=this._networkRecordFilmStripSetting.get();if(toggled&&!this._filmStripRecorder){this._filmStripView=new PerfUI.FilmStripView();this._filmStripView.setMode(PerfUI.FilmStripView.Modes.FrameBased);this._filmStripView.element.classList.add('network-film-strip');this._filmStripRecorder=new Network.NetworkPanel.FilmStripRecorder(this._networkLogView.timeCalculator(),this._filmStripView);this._filmStripView.show(this.element,this.element.firstElementChild);this._filmStripView.addEventListener(PerfUI.FilmStripView.Events.FrameSelected,this._onFilmFrameSelected,this);this._filmStripView.addEventListener(PerfUI.FilmStripView.Events.FrameEnter,this._onFilmFrameEnter,this);this._filmStripView.addEventListener(PerfUI.FilmStripView.Events.FrameExit,this._onFilmFrameExit,this);this._resetFilmStripView();}
if(!toggled&&this._filmStripRecorder){this._filmStripView.detach();this._filmStripView=null;this._filmStripRecorder=null;}}
_resetFilmStripView(){this._filmStripView.reset();this._filmStripView.setStatusText(Common.UIString('Hit %s to reload and capture filmstrip.',UI.shortcutRegistry.shortcutDescriptorsForAction('main.reload')[0].name));}
elementsToRestoreScrollPositionsFor(){return this._networkLogView.elementsToRestoreScrollPositionsFor();}
searchableView(){return this._searchableView;}
handleShortcut(event){if(this._networkItemView&&event.keyCode===UI.KeyboardShortcut.Keys.Esc.code){this._showRequest(null);event.handled=true;return;}
super.handleShortcut(event);}
wasShown(){UI.context.setFlavor(Network.NetworkPanel,this);}
willHide(){UI.context.setFlavor(Network.NetworkPanel,null);}
revealAndHighlightRequest(request){this._showRequest(null);if(request)
this._networkLogView.revealAndHighlightRequest(request);}
_onRowSizeChanged(event){this._updateUI();}
_onSearchCountUpdated(event){var count=(event.data);this._searchableView.updateSearchMatchesCount(count);}
_onSearchIndexUpdated(event){var index=(event.data);this._searchableView.updateCurrentMatchIndex(index);}
_onRequestSelected(event){var request=(event.data);this._showRequest(request);}
_showRequest(request){if(this._networkItemView){this._networkItemView.detach();this._networkItemView=null;}
if(request){this._networkItemView=new Network.NetworkItemView(request,this._networkLogView.timeCalculator());this._networkItemView.leftToolbar().appendToolbarItem(new UI.ToolbarItem(this._closeButtonElement));this._networkItemView.show(this._detailsWidget.element);this._splitWidget.showBoth();}else{this._splitWidget.hideMain();this._networkLogView.clearSelection();}
this._updateUI();}
_updateUI(){this._detailsWidget.element.classList.toggle('network-details-view-tall-header',this._networkLogLargeRowsSetting.get());this._networkLogView.switchViewMode(!this._splitWidget.isResizable());}
performSearch(searchConfig,shouldJump,jumpBackwards){this._networkLogView.performSearch(searchConfig,shouldJump,jumpBackwards);}
jumpToPreviousSearchResult(){this._networkLogView.jumpToPreviousSearchResult();}
supportsCaseSensitiveSearch(){return false;}
supportsRegexSearch(){return false;}
jumpToNextSearchResult(){this._networkLogView.jumpToNextSearchResult();}
searchCanceled(){this._networkLogView.searchCanceled();}
appendApplicableItems(event,contextMenu,target){function reveal(request){UI.viewManager.showView('network').then(this.revealAndHighlightRequest.bind(this,request));}
function appendRevealItem(request){contextMenu.appendItem(Common.UIString.capitalize('Reveal in Network ^panel'),reveal.bind(this,request));}
if(event.target.isSelfOrDescendant(this.element))
return;if(target instanceof SDK.Resource){var resource=(target);if(resource.request)
appendRevealItem.call(this,resource.request);return;}
if(target instanceof Workspace.UISourceCode){var uiSourceCode=(target);var resource=Bindings.resourceForURL(uiSourceCode.url());if(resource&&resource.request)
appendRevealItem.call(this,resource.request);return;}
if(!(target instanceof SDK.NetworkRequest))
return;var request=(target);if(this._networkItemView&&this._networkItemView.isShowing()&&this._networkItemView.request()===request)
return;appendRevealItem.call(this,request);}
_onFilmFrameSelected(event){var timestamp=(event.data);this._overviewPane.requestWindowTimes(0,timestamp);}
_onFilmFrameEnter(event){var timestamp=(event.data);this._networkOverview.selectFilmStripFrame(timestamp);this._networkLogView.selectFilmStripFrame(timestamp/1000);}
_onFilmFrameExit(event){this._networkOverview.clearFilmStripFrame();this._networkLogView.clearFilmStripFrame();}
_onUpdateRequest(event){var request=(event.data);this._calculator.updateBoundaries(request);this._overviewPane.setBounds(this._calculator.minimumBoundary()*1000,this._calculator.maximumBoundary()*1000);this._networkOverview.updateRequest(request);this._overviewPane.scheduleUpdate();}};Network.NetworkPanel.displayScreenshotDelay=1000;Network.NetworkPanel.ContextMenuProvider=class{appendApplicableItems(event,contextMenu,target){Network.NetworkPanel._instance().appendApplicableItems(event,contextMenu,target);}};Network.NetworkPanel.RequestRevealer=class{reveal(request){if(!(request instanceof SDK.NetworkRequest))
return Promise.reject(new Error('Internal error: not a network request'));var panel=Network.NetworkPanel._instance();return UI.viewManager.showView('network').then(panel.revealAndHighlightRequest.bind(panel,request));}};Network.NetworkPanel.FilmStripRecorder=class{constructor(timeCalculator,filmStripView){this._tracingManager=null;this._resourceTreeModel=null;this._timeCalculator=timeCalculator;this._filmStripView=filmStripView;}
traceEventsCollected(events){if(this._tracingModel)
this._tracingModel.addEvents(events);}
tracingComplete(){if(!this._tracingModel||!this._tracingManager)
return;this._tracingModel.tracingComplete();this._tracingManager=null;this._callback(new SDK.FilmStripModel(this._tracingModel,this._timeCalculator.minimumBoundary()*1000));delete this._callback;if(this._resourceTreeModel)
this._resourceTreeModel.resumeReload();this._resourceTreeModel=null;}
tracingBufferUsage(){}
eventsRetrievalProgress(progress){}
startRecording(){this._filmStripView.reset();this._filmStripView.setStatusText(Common.UIString('Recording frames...'));var tracingManagers=SDK.targetManager.models(SDK.TracingManager);if(this._tracingManager||!tracingManagers.length)
return;this._tracingManager=tracingManagers[0];this._resourceTreeModel=this._tracingManager.target().model(SDK.ResourceTreeModel);if(this._tracingModel)
this._tracingModel.reset();else
this._tracingModel=new SDK.TracingModel(new Bindings.TempFileBackingStorage('tracing'));this._tracingManager.start(this,'-*,disabled-by-default-devtools.screenshot','');}
isRecording(){return!!this._tracingManager;}
stopRecording(callback){if(!this._tracingManager)
return;this._tracingManager.stop();if(this._resourceTreeModel)
this._resourceTreeModel.suspendReload();this._callback=callback;this._filmStripView.setStatusText(Common.UIString('Fetching frames...'));}};Network.NetworkPanel.RecordActionDelegate=class{handleAction(context,actionId){var panel=UI.context.flavor(Network.NetworkPanel);console.assert(panel&&panel instanceof Network.NetworkPanel);panel._toggleRecording();return true;}};;Network.XMLView=class extends UI.Widget{constructor(parsedXML){super(true);this.registerRequiredCSS('network/xmlView.css');this.contentElement.classList.add('shadow-xml-view','source-code');this._treeOutline=new UI.TreeOutlineInShadow();this._treeOutline.registerRequiredCSS('network/xmlTree.css');this.contentElement.appendChild(this._treeOutline.element);this._searchableView;this._currentSearchFocusIndex=0;this._currentSearchTreeElements=[];this._searchConfig;Network.XMLView.Node.populate(this._treeOutline,parsedXML,this);}
static createSearchableView(parsedXML){var xmlView=new Network.XMLView(parsedXML);var searchableView=new UI.SearchableView(xmlView);searchableView.setPlaceholder(Common.UIString('Find'));xmlView._searchableView=searchableView;xmlView.show(searchableView.element);xmlView.contentElement.setAttribute('tabIndex',0);return searchableView;}
static parseXML(text,mimeType){var parsedXML;try{parsedXML=(new DOMParser()).parseFromString(text,mimeType);}catch(e){return null;}
if(parsedXML.body)
return null;return parsedXML;}
_jumpToMatch(index,shouldJump){if(!this._searchConfig)
return;var regex=this._searchConfig.toSearchRegex(true);var previousFocusElement=this._currentSearchTreeElements[this._currentSearchFocusIndex];if(previousFocusElement)
previousFocusElement.setSearchRegex(regex);var newFocusElement=this._currentSearchTreeElements[index];if(newFocusElement){this._updateSearchIndex(index);if(shouldJump)
newFocusElement.reveal(true);newFocusElement.setSearchRegex(regex,UI.highlightedCurrentSearchResultClassName);}else{this._updateSearchIndex(0);}}
_updateSearchCount(count){if(!this._searchableView)
return;this._searchableView.updateSearchMatchesCount(count);}
_updateSearchIndex(index){this._currentSearchFocusIndex=index;if(!this._searchableView)
return;this._searchableView.updateCurrentMatchIndex(index);}
_innerPerformSearch(shouldJump,jumpBackwards){if(!this._searchConfig)
return;var newIndex=this._currentSearchFocusIndex;var previousSearchFocusElement=this._currentSearchTreeElements[newIndex];this._innerSearchCanceled();this._currentSearchTreeElements=[];var regex=this._searchConfig.toSearchRegex(true);for(var element=this._treeOutline.rootElement();element;element=element.traverseNextTreeElement(false)){if(!(element instanceof Network.XMLView.Node))
continue;var hasMatch=element.setSearchRegex(regex);if(hasMatch)
this._currentSearchTreeElements.push(element);if(previousSearchFocusElement===element){var currentIndex=this._currentSearchTreeElements.length-1;if(hasMatch||jumpBackwards)
newIndex=currentIndex;else
newIndex=currentIndex+1;}}
this._updateSearchCount(this._currentSearchTreeElements.length);if(!this._currentSearchTreeElements.length){this._updateSearchIndex(0);return;}
newIndex=mod(newIndex,this._currentSearchTreeElements.length);this._jumpToMatch(newIndex,shouldJump);}
_innerSearchCanceled(){for(var element=this._treeOutline.rootElement();element;element=element.traverseNextTreeElement(false)){if(!(element instanceof Network.XMLView.Node))
continue;element.revertHighlightChanges();}
this._updateSearchCount(0);this._updateSearchIndex(0);}
searchCanceled(){this._searchConfig=null;this._currentSearchTreeElements=[];this._innerSearchCanceled();}
performSearch(searchConfig,shouldJump,jumpBackwards){this._searchConfig=searchConfig;this._innerPerformSearch(shouldJump,jumpBackwards);}
jumpToNextSearchResult(){if(!this._currentSearchTreeElements.length)
return;var newIndex=mod(this._currentSearchFocusIndex+1,this._currentSearchTreeElements.length);this._jumpToMatch(newIndex,true);}
jumpToPreviousSearchResult(){if(!this._currentSearchTreeElements.length)
return;var newIndex=mod(this._currentSearchFocusIndex-1,this._currentSearchTreeElements.length);this._jumpToMatch(newIndex,true);}
supportsCaseSensitiveSearch(){return true;}
supportsRegexSearch(){return true;}};Network.XMLView.Node=class extends UI.TreeElement{constructor(node,closeTag,xmlView){super('',!closeTag&&!!node.childElementCount);this._node=node;this._closeTag=closeTag;this.selectable=false;this._highlightChanges=[];this._xmlView=xmlView;this._updateTitle();}
static populate(root,xmlNode,xmlView){var node=xmlNode.firstChild;while(node){var currentNode=node;node=node.nextSibling;var nodeType=currentNode.nodeType;if(nodeType===3&&currentNode.nodeValue.match(/\s+/))
continue;if((nodeType!==1)&&(nodeType!==3)&&(nodeType!==4)&&(nodeType!==7)&&(nodeType!==8))
continue;root.appendChild(new Network.XMLView.Node(currentNode,false,xmlView));}}
setSearchRegex(regex,additionalCssClassName){this.revertHighlightChanges();if(!regex)
return false;if(this._closeTag&&this.parent&&!this.parent.expanded)
return false;regex.lastIndex=0;var cssClasses=UI.highlightedSearchResultClassName;if(additionalCssClassName)
cssClasses+=' '+additionalCssClassName;var content=this.listItemElement.textContent.replace(/\xA0/g,' ');var match=regex.exec(content);var ranges=[];while(match){ranges.push(new TextUtils.SourceRange(match.index,match[0].length));match=regex.exec(content);}
if(ranges.length)
UI.highlightRangesWithStyleClass(this.listItemElement,ranges,cssClasses,this._highlightChanges);return!!this._highlightChanges.length;}
revertHighlightChanges(){UI.revertDomChanges(this._highlightChanges);this._highlightChanges=[];}
_updateTitle(){var node=this._node;switch(node.nodeType){case 1:var tag=node.tagName;if(this._closeTag){this._setTitle(['</'+tag+'>','shadow-xml-view-tag']);return;}
var titleItems=['<'+tag,'shadow-xml-view-tag'];var attributes=node.attributes;for(var i=0;i<attributes.length;++i){var attributeNode=attributes.item(i);titleItems.push('\u00a0','shadow-xml-view-tag',attributeNode.name,'shadow-xml-view-attribute-name','="','shadow-xml-view-tag',attributeNode.value,'shadow-xml-view-attribute-value','"','shadow-xml-view-tag');}
if(!this.expanded){if(node.childElementCount){titleItems.push('>','shadow-xml-view-tag','\u2026','shadow-xml-view-comment','</'+tag,'shadow-xml-view-tag');}else if(this._node.textContent){titleItems.push('>','shadow-xml-view-tag',node.textContent,'shadow-xml-view-text','</'+tag,'shadow-xml-view-tag');}else{titleItems.push(' /','shadow-xml-view-tag');}}
titleItems.push('>','shadow-xml-view-tag');this._setTitle(titleItems);return;case 3:this._setTitle([node.nodeValue,'shadow-xml-view-text']);return;case 4:this._setTitle(['<![CDATA[','shadow-xml-view-cdata',node.nodeValue,'shadow-xml-view-text',']]>','shadow-xml-view-cdata']);return;case 7:this._setTitle(['<?'+node.nodeName+' '+node.nodeValue+'?>','shadow-xml-view-processing-instruction']);return;case 8:this._setTitle(['<!--'+node.nodeValue+'-->','shadow-xml-view-comment']);return;}}
_setTitle(items){var titleFragment=createDocumentFragment();for(var i=0;i<items.length;i+=2)
titleFragment.createChild('span',items[i+1]).textContent=items[i];this.title=titleFragment;this._xmlView._innerPerformSearch(false,false);}
onattach(){this.listItemElement.classList.toggle('shadow-xml-view-close-tag',this._closeTag);}
onexpand(){this._updateTitle();}
oncollapse(){this._updateTitle();}
onpopulate(){Network.XMLView.Node.populate(this,this._node,this._xmlView);this.appendChild(new Network.XMLView.Node(this._node,true,this._xmlView));}};;Runtime.cachedResources["network/blockedURLsPane.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.blocked-urls-pane {\n    overflow: hidden;\n}\n\n.toolbar {\n    border-bottom: 1px solid #dadada;\n}\n\n.no-blocked-urls, .blocked-urls-list {\n    overflow-x: hidden;\n    overflow-y: auto;\n}\n\n.no-blocked-urls {\n    display: flex;\n    justify-content: center;\n    padding: 3px;\n}\n\n.no-blocked-urls > span {\n    white-space: pre;\n}\n\n.blocked-url {\n    flex: none;\n    display: flex;\n    align-items: center;\n    padding: 3px 10px 3px 9px;\n    position: relative;\n}\n\n.blocked-url:not(.blocked-url-editing):hover {\n    background-color: #dadada;\n}\n\n.blocked-url .blocked-count {\n    flex: 30px 0 0;\n    font-size: smaller !important;\n    padding-right: 5px;\n}\n\n.blocked-url > input {\n    position: absolute;\n    left: 6px;\n    right: 6px;\n    top: 0;\n    bottom: 0;\n    width: calc(100% - 12px);\n}\n\n.blocked-url-text {\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    overflow: hidden;\n    flex: auto;\n    margin-right: 5px;\n}\n\n.remove-icon {\n    opacity: 0.7;\n    visibility: hidden;\n}\n\n.blocked-url .remove-icon:hover {\n    opacity: 1.0;\n}\n\n.blocked-url:hover .remove-icon {\n    visibility: visible;\n}\n\n/*# sourceURL=network/blockedURLsPane.css */";Runtime.cachedResources["network/eventSourceMessagesView.css"]="/*\n * Copyright (c) 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.event-source-messages-view .data-grid {\n    flex: auto;\n    border: none;\n}\n\n/*# sourceURL=network/eventSourceMessagesView.css */";Runtime.cachedResources["network/networkConfigView.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.network-config {\n    padding: 12px;\n    display: block;\n}\n\n.network-config-group {\n    display: flex;\n    margin-bottom: 10px;\n    flex-wrap: wrap;\n    flex: 0 0 auto;\n    min-height: 30px;\n}\n\n.network-config-title {\n    margin-right: 16px;\n    width: 130px;\n}\n\n.network-config-fields {\n    flex: 2 0 200px;\n}\n\n.panel-section-separator {\n    height: 1px;\n    margin-bottom: 10px;\n    background: #f0f0f0;\n}\n\n/* Disable cache */\n\n.network-config-disable-cache {\n    line-height: 28px;\n    border-top: none;\n    padding-top: 0;\n}\n\n/* Network throttling */\n\n.network-config-throttling .chrome-select {\n    width: 100%;\n    max-width: 250px;\n}\n\n.network-config-throttling > .network-config-title {\n    line-height: 24px;\n}\n\n/* User agent */\n\n.network-config-ua > .network-config-title {\n    line-height: 20px;\n}\n\n.network-config-ua label[is=\"dt-radio\"].checked > * {\n    display: none\n}\n\n.network-config-ua input:not(.dt-radio-button) {\n    display: block;\n    width: calc(100% - 20px);\n    max-width: 250px;\n    border: 1px solid #bfbfbf;\n    border-radius: 2px;\n    box-sizing: border-box;\n    color: #444;\n    font: inherit;\n    border-width: 1px;\n    min-height: 2em;\n    padding: 3px;\n}\n\n.network-config-ua input[readonly] {\n    background-color: rgb(235, 235, 228);\n}\n\n.network-config-ua input[type=text], .network-config-ua .chrome-select {\n    margin-top: 8px;\n}\n\n.network-config-ua input[type=\"text\"]:invalid {\n    outline: auto 2px red;\n    outline-offset: -2px;\n}\n\n.network-config-ua .chrome-select {\n    width: calc(100% - 20px);\n    max-width: 250px;\n}\n\n.network-config-ua label[is=\"dt-radio\"] {\n    display: block;\n}\n\n.network-config-ua-auto, .network-config-ua-custom {\n    opacity: 0.5;\n}\n\n.network-config-ua-auto.checked, .network-config-ua-custom.checked {\n    opacity: 1;\n}\n\n/*# sourceURL=network/networkConfigView.css */";Runtime.cachedResources["network/networkLogView.css"]="/*\n * Copyright (C) 2013 Google Inc. All rights reserved.\n *\n * Redistribution and use in source and binary forms, with or without\n * modification, are permitted provided that the following conditions are\n * met:\n *\n *     * Redistributions of source code must retain the above copyright\n * notice, this list of conditions and the following disclaimer.\n *     * Redistributions in binary form must reproduce the above\n * copyright notice, this list of conditions and the following disclaimer\n * in the documentation and/or other materials provided with the\n * distribution.\n *     * Neither the name of Google Inc. nor the names of its\n * contributors may be used to endorse or promote products derived from\n * this software without specific prior written permission.\n *\n * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n * \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n */\n\n.network-log-grid.data-grid {\n    border: none;\n    flex: auto;\n}\n\n.network-summary-bar {\n    flex: 0 0 27px;\n    line-height: 27px;\n    padding-left: 5px;\n    background-color: #eee;\n    border-top: 1px solid #ccc;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    overflow: hidden;\n}\n\n.network-summary-bar label[is=dt-icon-label] {\n    margin-right: 6px;\n}\n\n.network-summary-bar > * {\n    flex: none;\n}\n\n.network-log-grid.data-grid table.data {\n    background: transparent;\n}\n\n.network-log-grid .odd {\n    background: #f5f5f5;\n}\n\n.network-log-grid .network-navigation-row,\n.network-log-grid .network-navigation-row.odd {\n    background: #def;\n}\n\n.network-log-grid.data-grid td {\n    height: 41px;\n    border-left: 1px solid #e1e1e1;\n    vertical-align: middle;\n}\n\n.network-log-grid.data-grid .corner {\n    display: none;\n}\n\n.network-log-grid.data-grid.small td {\n    height: 21px;\n}\n\n.network-waterfall-header, .network-log-grid.data-grid th {\n    border-bottom: 1px solid rgb(205, 205, 205);\n    border-left: 1px solid rgb(205, 205, 205);\n}\n\n.network-log-grid.data-grid th {\n    background: white;\n}\n\n.network-waterfall-header, .network-log-grid.data-grid .header-container {\n    height: 31px;\n}\n\n.network-log-grid.data-grid .data-container {\n    top: 31px;\n}\n\n.network-waterfall-header.small, .network-log-grid.data-grid.small .header-container {\n    height: 27px;\n}\n\n.network-log-grid.data-grid.small .data-container {\n    top: 27px;\n}\n\n.network-log-grid.data-grid select {\n    -webkit-appearance: none;\n    background-color: transparent;\n    border: none;\n    width: 100%;\n    color: inherit;\n}\n\n.network-log-grid.data-grid .name-column {\n    cursor: pointer;\n}\n\n.network-log-grid.data-grid .waterfall-column {\n    padding: 1px 0;\n}\n\n.network-log-grid.data-grid .waterfall-column .sort-order-icon-container {\n    right: 15px;\n    pointer-events: none;\n}\n\n#network-container:not(.brief-mode) .network-log-grid.data-grid td.name-column:hover {\n    text-decoration: underline;\n}\n\n.network-log-grid.data-grid th.sortable:active {\n    background-image: none !important;\n}\n\n.network-cell-subtitle {\n    font-weight: normal;\n    color: gray;\n}\n\n.network-error-row,\n.network-error-row .network-cell-subtitle {\n    color: rgb(230, 0, 0);\n}\n\n.initiator-column .devtools-link {\n    color: inherit;\n}\n\n.network-log-grid.data-grid tr.selected,\n.network-log-grid.data-grid tr.selected .network-cell-subtitle,\n.network-log-grid.data-grid tr.selected .network-dim-cell {\n    color: inherit !important;\n}\n\n.network-log-grid.data-grid:focus tr.selected,\n.network-log-grid.data-grid:focus tr.selected .network-cell-subtitle,\n.network-log-grid.data-grid:focus tr.selected .network-dim-cell {\n    color: white !important;\n}\n\n.network-log-grid tr.highlighted-row {\n    -webkit-animation: network-row-highlight-fadeout 2s 0s;\n}\n\n@-webkit-keyframes network-row-highlight-fadeout {\n    from {background-color: rgba(255, 255, 120, 1); }\n    to { background-color: rgba(255, 255, 120, 0); }\n}\n\n.network-header-subtitle {\n    color: gray;\n}\n\n.network-log-grid.data-grid.small .network-cell-subtitle,\n.network-log-grid.data-grid.small .network-header-subtitle {\n    display: none;\n}\n\n/* Resource preview icons */\n\n.network-log-grid.data-grid .icon {\n    content: url(Images/resourcePlainIcon.png);\n}\n\n.network-log-grid.data-grid.small .icon {\n    content: url(Images/resourcePlainIconSmall.png);\n}\n\n.network-log-grid.data-grid .icon.script {\n    content: url(Images/resourceJSIcon.png);\n}\n\n.network-log-grid.data-grid.small .icon.script {\n    content: url(Images/resourceDocumentIconSmall.png);\n}\n\n.network-log-grid.data-grid .icon.document {\n    content: url(Images/resourceDocumentIcon.png);\n}\n\n.network-log-grid.data-grid.small .icon.document {\n    content: url(Images/resourceDocumentIconSmall.png);\n}\n\n.network-log-grid.data-grid .icon.stylesheet {\n    content: url(Images/resourceCSSIcon.png);\n}\n\n.network-log-grid.data-grid.small .icon.stylesheet {\n    content: url(Images/resourceDocumentIconSmall.png);\n}\n\n.network-log-grid.data-grid .icon.media {\n    content: url(Images/resourcePlainIcon.png); /* FIXME: media icon */\n}\n\n.network-log-grid.data-grid.small .icon.media {\n    content: url(Images/resourcePlainIconSmall.png); /* FIXME: media icon */\n}\n.network-log-grid.data-grid .icon.texttrack {\n    content: url(Images/resourcePlainIcon.png); /* FIXME: vtt icon */\n}\n\n.network-log-grid.data-grid.small .icon.texttrack {\n    content: url(Images/resourcePlainIconSmall.png); /* FIXME: vtt icon */\n}\n\n.network-log-grid.data-grid .icon.image {\n    position: relative;\n    background-image: url(Images/resourcePlainIcon.png);\n    background-repeat: no-repeat;\n    content: \"\";\n}\n\n.network-log-grid.data-grid.small .icon.image {\n    background-image: url(Images/resourcePlainIconSmall.png);\n    content: \"\";\n}\n\n.network-log-grid.data-grid .icon {\n    float: left;\n    width: 32px;\n    height: 32px;\n    margin-top: 1px;\n    margin-right: 3px;\n}\n\n.network-log-grid.data-grid.small .icon {\n    width: 16px;\n    height: 16px;\n}\n\n.network-log-grid.data-grid .image-network-icon-preview {\n    position: absolute;\n    margin: auto;\n    top: 3px;\n    bottom: 4px;\n    left: 5px;\n    right: 5px;\n    max-width: 18px;\n    max-height: 21px;\n    min-width: 1px;\n    min-height: 1px;\n}\n\n.network-log-grid.data-grid.small .image-network-icon-preview {\n    top: 2px;\n    bottom: 1px;\n    left: 3px;\n    right: 3px;\n    max-width: 8px;\n    max-height: 11px;\n}\n\n.network-dim-cell {\n    color: grey;\n}\n\n.network-summary-bar .summary-red {\n    color: red;\n}\n\n.network-frame-divider {\n    width: 2px;\n    background-color: #FCCC49;\n    z-index: 10;\n    visibility: hidden;\n}\n\n#network-container:not(.brief-mode) .data-container {\n    overflow: hidden;\n}\n\n.network-summary-bar .summary-blue {\n    color: blue;\n}\n\n.-theme-with-dark-background .network-summary-bar .summary-blue {\n    color: #03A9F4;\n}\n\n.network-log-grid.data-grid .resources-dividers {\n    z-index: 0;\n}\n\n.network-log-grid.data-grid .resources-dividers-label-bar {\n    background-color: transparent;\n    border: none;\n    height: 30px;\n    pointer-events: none;\n}\n\n#network-container {\n    overflow: hidden;\n}\n\n.network-log-grid.data-grid .data-container tr:not(.data-grid-filler-row):not(.selected).hover {\n    background-color: #ebf2fc;\n}\n\n.network-log-grid .network-node-on-initiator-path {\n    background-color: hsla(120, 68%, 54%, 0.2) !important;\n}\n\n.network-log-grid .network-node-on-initiated-path {\n    background-color: hsla(0, 68%, 54%, 0.2) !important;\n}\n\n.network-status-pane {\n    color: #777;\n    background-color: white;\n    z-index: 500;\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    text-align: center;\n    padding: 0 20px;\n    overflow: auto;\n}\n\n.network-status-pane > .recording-hint {\n    font-size: 14px;\n    text-align: center;\n    line-height: 28px;\n}\n\n.network-waterfall-header {\n    position: absolute;\n    border-left: 0px;\n    width: 100%;\n    display: table;\n    z-index: 200;\n}\n\n.network-waterfall-header:hover {\n    background-color: hsla(0, 0%, 10%, 0.1);\n}\n\n.network-waterfall-header div {\n    display: table-cell;\n    line-height: 14px;\n    margin: auto 0px;\n    vertical-align: middle;\n    text-align: left;\n    font-weight: normal;\n    padding: 0px 4px;\n}\n\n.network-waterfall-header .sort-order-icon-container {\n    position: absolute;\n    top: 1px;\n    right: 0;\n    bottom: 1px;\n    display: flex;\n    align-items: center;\n}\n\n.network-waterfall-header .sort-order-icon {\n    align-items: center;\n    margin-right: 4px;\n    margin-bottom: -2px;\n}\n\n/*# sourceURL=network/networkLogView.css */";Runtime.cachedResources["network/networkManageCustomHeadersView.css"]="/*\n * Copyright 2016 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n.custom-headers-list {\n    height: 272px;\n    width: 250px;\n}\n\n.custom-headers-wrapper{\n    margin: 10px;\n}\n\n.header {\n    padding: 0 0 6px;\n    font-size: 18px;\n    font-weight: normal;\n    flex: none;\n}\n\n.custom-headers-header {\n    padding:2px;\n}\n\n.custom-headers-list-item {\n    padding-left: 5px;\n}\n\n.editor-container {\n    padding: 5px 0px 0px 5px;\n}\n\n.add-button {\n    width: 150px;\n    margin: auto;\n    margin-top: 5px;\n}\n\n/*# sourceURL=network/networkManageCustomHeadersView.css */";Runtime.cachedResources["network/networkPanel.css"]="/*\n * Copyright (C) 2006, 2007, 2008 Apple Inc.  All rights reserved.\n * Copyright (C) 2009 Anthony Ricaud <rik@webkit.org>\n *\n * Redistribution and use in source and binary forms, with or without\n * modification, are permitted provided that the following conditions\n * are met:\n *\n * 1.  Redistributions of source code must retain the above copyright\n *     notice, this list of conditions and the following disclaimer.\n * 2.  Redistributions in binary form must reproduce the above copyright\n *     notice, this list of conditions and the following disclaimer in the\n *     documentation and/or other materials provided with the distribution.\n * 3.  Neither the name of Apple Computer, Inc. (\"Apple\") nor the names of\n *     its contributors may be used to endorse or promote products derived\n *     from this software without specific prior written permission.\n *\n * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS \"AS IS\" AND ANY\n * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\n * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\n * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY\n * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES\n * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;\n * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND\n * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF\n * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n */\n\n.panel.network > .toolbar {\n    position: relative;\n    border-bottom: 1px solid #dadada;\n}\n\n.network-details-view {\n    background: rgb(203, 203, 203);\n}\n\n.network-details-view-tall-header {\n    margin-top: 4px;\n}\n\n.network-item-view {\n    display: flex;\n    background: white;\n}\n\n.network-item-preview-toolbar {\n    border-top: 1px solid #ccc;\n    background-color: #eee;\n}\n\n.resource-timing-view {\n    display: block;\n    margin: 6px;\n    color: rgb(30%, 30%, 30%);\n}\n\n.resource-timing-table {\n    width: 100% !important;\n}\n\n#network-overview-panel {\n    flex: none;\n    position: relative;\n}\n\n#network-overview-container {\n    overflow: hidden;\n    flex: auto;\n    display: flex;\n    flex-direction: column;\n    position: relative;\n    border-bottom: 1px solid #CDCDCD;\n}\n\n#network-overview-container canvas {\n    width: 100%;\n    height: 100%;\n}\n\n#network-overview-grid .resources-dividers-label-bar {\n    pointer-events: auto;\n}\n\n.network .network-overview {\n    flex: 0 0 60px;\n}\n\n.network-overview .overview-grid-window,\n.network-overview .overview-grid-dividers-background {\n    height: 100%;\n}\n\n.network-overview .resources-dividers-label-bar {\n    background-color: rgba(255, 255, 255, 0.95);\n}\n\n.network-overview .resources-dividers-label-bar .resources-divider {\n    background-color: transparent;\n}\n\n.network-overview .resources-dividers {\n    z-index: 250;\n}\n\n.json-view {\n    padding: 2px 6px;\n    overflow: auto;\n}\n\n.request-view.html iframe {\n    width: 100%;\n    height: 100%;\n    position: absolute;\n}\n\n.network-film-strip {\n    border-bottom: solid 1px #cdcdcd;\n    flex: none !important;\n}\n\n.network-blocked-urls {\n    border-top: 1px solid #dadada;\n    flex: 104px 0 0;\n}\n\n/*# sourceURL=network/networkPanel.css */";Runtime.cachedResources["network/networkTimingTable.css"]="/*\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.network-timing-table {\n    width: 380px;\n    border-spacing: 0;\n    padding-left: 10px;\n    padding-right: 10px;\n    line-height: initial;\n}\n\n.network-timing-start {\n    border-top: 5px solid transparent;\n}\n.network-timing-table-header td, .network-timing-footer td {\n    border-top: 10px solid transparent;\n}\n\n.network-timing-table-header td {\n    color: #bbb;\n}\n\n.network-timing-table-header td:last-child {\n    text-align: right;\n}\n\n.network-timing-table col.labels {\n    width: 156px;\n}\n\n.network-timing-table col.duration {\n    width: 80px;\n}\n\n.network-timing-table td {\n    padding: 2px 0;\n}\n\n.network-timing-table td.caution {\n    font-weight: bold;\n    color: rgb(255, 128, 0);\n    padding: 2px 0;\n}\n\n.network-timing-table hr.break {\n    border: 0;\n    height: 1px;\n    background-image: linear-gradient(to right, #eee, #bbb, #eee);\n}\n\n.network-timing-footer td:last-child {\n    font-weight: bold;\n    text-align: right;\n}\n\n.network-timing-row {\n    position: relative;\n    height: 15px;\n}\n\n.network-timing-bar {\n    position: absolute;\n    min-width: 1px;\n    top: 0;\n    bottom: 0;\n}\n\n.network-timing-bar-title {\n    color: #222;\n    white-space: nowrap;\n    text-align: right;\n}\n\n.network-timing-bar.queueing,\n.network-timing-bar.total {\n    border: 1px solid rgba(0, 0, 0, 0.1);\n}\n\n.network-timing-bar.blocking, -theme-preserve {\n    background-color: #AAAAAA;\n}\n\n.network-timing-bar.proxy, -theme-preserve {\n    background-color: #A1887F;\n}\n\n.network-timing-bar.dns, -theme-preserve {\n    background-color: #009688;\n}\n\n.network-timing-bar.connecting,\n.network-timing-bar.serviceworker,\n.network-timing-bar.serviceworker-preparation, -theme-preserve {\n    background-color: #FF9800;\n}\n\n.network-timing-bar.ssl, -theme-preserve {\n    background-color: #9C27B0;\n}\n\n.network-timing-bar.sending, -theme-preserve {\n    background-color: #B0BEC5;\n}\n\n.network-timing-bar.waiting, -theme-preserve {\n    background-color: #00C853;\n}\n\n.network-timing-bar.receiving, -theme-preserve,\n.network-timing-bar.receiving-push, -theme-preserve {\n    background-color: #03A9F4;\n}\n\n.network-timing-bar.push, -theme-preserve {\n    background-color: #8CDBff;\n}\n\n.network-timing-bar.server-timing, -theme-preserve {\n    background-color: #ddd;\n}\n\n.network-timing-table td.network-timing-metric {\n    white-space: nowrap;\n    max-width: 150px;\n    overflow-x: hidden;\n    text-overflow: ellipsis;\n}\n\n.network-timing-bar.proxy,\n.network-timing-bar.dns,\n.network-timing-bar.ssl,\n.network-timing-bar.connecting,\n.network-timing-bar.blocking {\n    height: 10px;\n    margin: auto;\n}\n\n/*# sourceURL=network/networkTimingTable.css */";Runtime.cachedResources["network/networkWaterfallColumn.css"]="/* Copyright 2016 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n.network-waterfall-v-scroll {\n    position: absolute;\n    top: 0;\n    right: 0;\n    bottom: 0;\n    overflow-x: hidden;\n    margin-top: 31px;\n    z-index: 200;\n}\n\n.network-waterfall-v-scroll.small {\n    margin-top: 27px;\n}\n\n.network-waterfall-v-scroll-content {\n    width: 15px;\n    pointer-events: none;\n}\n\n/*# sourceURL=network/networkWaterfallColumn.css */";Runtime.cachedResources["network/requestCookiesView.css"]="/*\n * Copyright (c) 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.request-cookies-view {\n    display: flex;\n    overflow: auto;\n    margin: 12px;\n    height: 100%;\n}\n\n.request-cookies-view .data-grid {\n    flex: auto;\n    height: 100%;\n}\n\n.request-cookies-view .data-grid .row-group {\n    font-weight: bold;\n}\n\n/*# sourceURL=network/requestCookiesView.css */";Runtime.cachedResources["network/requestHeadersTree.css"]="/*\n * Copyright 2016 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.tree-outline > ol {\n    padding-bottom: 5px;\n}\n\n.tree-outline > .parent {\n    -webkit-user-select: none;\n    font-weight: bold;\n    color: #616161;\n    margin-top: -1px;\n    height: 20px;\n    border-top: solid 1px #e0e0e0;\n    display: flex;\n    align-items: center;\n}\n\n.tree-outline li {\n    display: block;\n}\n\n.tree-outline li:not(.parent) {\n    margin-left: 10px;\n}\n\n.tree-outline li:not(.parent)::before {\n    display: none;\n}\n\n.tree-outline .caution {\n    margin-left: 4px;\n    display: inline-block;\n    font-weight: bold;\n}\n\n.tree-outline li.expanded .header-count {\n    display: none;\n}\n\n.tree-outline li .header-toggle {\n    display: none;\n}\n\n.tree-outline li .status-from-cache {\n    color: gray;\n}\n\n.tree-outline li.expanded .header-toggle {\n    display: inline;\n    margin-left: 30px;\n    font-weight: normal;\n    color: rgb(45%, 45%, 45%);\n}\n\n.tree-outline li .header-toggle:hover {\n    color: rgb(20%, 20%, 45%);\n    cursor: pointer;\n}\n\n.tree-outline .header-name {\n    color: rgb(33%, 33%, 33%);\n    display: inline-block;\n    margin-right: 0.5em;\n    font-weight: bold;\n    vertical-align: top;\n    white-space: pre-wrap;\n}\n\n.tree-outline .header-value {\n    display: inline;\n    margin-right: 1em;\n    white-space: pre-wrap;\n    word-break: break-all;\n    margin-top: 1px;\n}\n\n.tree-outline .empty-request-header {\n    color: rgba(33%, 33%, 33%, 0.5);\n}\n\n/*# sourceURL=network/requestHeadersTree.css */";Runtime.cachedResources["network/requestHeadersView.css"]="/*\n * Copyright (c) 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.request-headers-view {\n    -webkit-user-select: text;\n    overflow: auto;\n}\n\n.resource-status-image {\n    margin-top: -2px;\n    margin-right: 3px;\n}\n\n.request-headers-view .filter-input {\n    outline: none !important;\n    border: none;\n    border-bottom: solid 1px #ccc;\n    flex: 0 0 19px;\n    padding: 0 4px;\n}\n\n.request-headers-tree {\n    padding: 0 0 0 4px;\n    flex-grow: 1;\n    overflow-y: auto;\n    margin: 0;\n}\n\n.header-decode-error {\n    color: red;\n}\n\n.-theme-with-dark-background .header-decode-error {\n    color: hsl(0, 100%, 65%);\n}\n\n/*# sourceURL=network/requestHeadersView.css */";Runtime.cachedResources["network/webSocketFrameView.css"]="/*\n * Copyright (c) 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.websocket-frame-view {\n    -webkit-user-select: text;\n}\n\n.websocket-frame-view .data-grid {\n    flex: auto;\n    border: none;\n}\n\n.websocket-frame-view .data-grid .data {\n    background-image: none;\n}\n\n.websocket-frame-view-td {\n    border-bottom: 1px solid #ccc;\n}\n\n.websocket-frame-view .data-grid tr.selected {\n    background-color: #def;\n}\n\n.websocket-frame-view .data-grid td,\n.websocket-frame-view .data-grid th {\n    border-left-color: #ccc;\n}\n\n.websocket-frame-view-row-outcoming {\n    background-color: rgb(226, 247, 218);\n}\n\n.websocket-frame-view-row-opcode {\n    background-color: rgb(255, 255, 232);\n    color: rgb(170, 111, 71);\n}\n\n.websocket-frame-view-row-error {\n    background-color: rgb(255, 237, 237);\n    color: rgb(182, 0, 0);\n}\n\n/*# sourceURL=network/webSocketFrameView.css */";Runtime.cachedResources["network/xmlTree.css"]="/*\n * Copyright 2016 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.tree-outline ol {\n    list-style: none;\n    padding: 0;\n    margin: 0;\n    -webkit-padding-start: 16px;\n}\n\nol.tree-outline {\n    -webkit-padding-start: 0;\n}\n\n.tree-outline li {\n    min-height: 12px;\n}\n\n.tree-outline li.shadow-xml-view-close-tag {\n    margin-left: -16px;\n}\n\n.shadow-xml-view-tag {\n    color: rgb(136, 18, 128);\n}\n\n.shadow-xml-view-comment {\n    color: rgb(35, 110, 37);\n}\n\n.shadow-xml-view-processing-instruction {\n    color: rgb(35, 110, 37);\n}\n\n.shadow-xml-view-attribute-name {\n    color: rgb(153, 69, 0);\n}\n\n.shadow-xml-view-attribute-value {\n    color: rgb(26, 26, 166);\n}\n\n.shadow-xml-view-text {\n    color: rgb(0, 0, 0);\n    white-space: pre;\n}\n\n.shadow-xml-view-cdata {\n    color: rgb(0, 0, 0);\n}\n\n/*# sourceURL=network/xmlTree.css */";Runtime.cachedResources["network/xmlView.css"]="/*\n * Copyright (c) 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.shadow-xml-view {\n    -webkit-user-select: text;\n    overflow: auto;\n    padding: 2px 4px;\n}\n\n/*# sourceURL=network/xmlView.css */";