Timeline.CountersGraph=class extends UI.VBox{constructor(delegate,model,filters){super();this.element.id='memory-graphs-container';this._delegate=delegate;this._model=model;this._filters=filters;this._calculator=new Timeline.CounterGraphCalculator(this._model);this._infoWidget=new UI.HBox();this._infoWidget.element.classList.add('memory-counter-selector-swatches','timeline-toolbar-resizer');this._infoWidget.show(this.element);this._graphsContainer=new UI.VBox();this._graphsContainer.show(this.element);var canvasWidget=new UI.VBoxWithResizeCallback(this._resize.bind(this));canvasWidget.show(this._graphsContainer.element);this._createCurrentValuesBar();this._canvasContainer=canvasWidget.element;this._canvasContainer.id='memory-graphs-canvas-container';this._canvas=this._canvasContainer.createChild('canvas');this._canvas.id='memory-counters-graph';this._canvasContainer.addEventListener('mouseover',this._onMouseMove.bind(this),true);this._canvasContainer.addEventListener('mousemove',this._onMouseMove.bind(this),true);this._canvasContainer.addEventListener('mouseleave',this._onMouseLeave.bind(this),true);this._canvasContainer.addEventListener('click',this._onClick.bind(this),true);this._timelineGrid=new UI.TimelineGrid();this._canvasContainer.appendChild(this._timelineGrid.dividersElement);this._counters=[];this._counterUI=[];}
_createCurrentValuesBar(){this._currentValuesBar=this._graphsContainer.element.createChild('div');this._currentValuesBar.id='counter-values-bar';}
createCounter(uiName,uiValueTemplate,color,formatter){var counter=new Timeline.CountersGraph.Counter();this._counters.push(counter);this._counterUI.push(new Timeline.CountersGraph.CounterUI(this,uiName,uiValueTemplate,color,counter,formatter));return counter;}
view(){return this;}
dispose(){}
reset(){for(var i=0;i<this._counters.length;++i){this._counters[i].reset();this._counterUI[i].reset();}
this.refresh();}
resizerElement(){return this._infoWidget.element;}
_resize(){var parentElement=this._canvas.parentElement;this._canvas.width=parentElement.clientWidth*window.devicePixelRatio;this._canvas.height=parentElement.clientHeight*window.devicePixelRatio;var timelinePaddingLeft=15;this._calculator.setDisplayWindow(this._canvas.width,timelinePaddingLeft);this.refresh();}
setWindowTimes(startTime,endTime){this._calculator.setWindow(startTime,endTime);this.scheduleRefresh();}
scheduleRefresh(){UI.invokeOnceAfterBatchUpdate(this,this.refresh);}
draw(){for(var i=0;i<this._counters.length;++i){this._counters[i]._calculateVisibleIndexes(this._calculator);this._counters[i]._calculateXValues(this._canvas.width);}
this._clear();for(var i=0;i<this._counterUI.length;i++)
this._counterUI[i]._drawGraph(this._canvas);}
_onClick(event){var x=event.x-this._canvasContainer.totalOffsetLeft();var minDistance=Infinity;var bestTime;for(var i=0;i<this._counterUI.length;++i){var counterUI=this._counterUI[i];if(!counterUI.counter.times.length)
continue;var index=counterUI._recordIndexAt(x);var distance=Math.abs(x*window.devicePixelRatio-counterUI.counter.x[index]);if(distance<minDistance){minDistance=distance;bestTime=counterUI.counter.times[index];}}
if(bestTime!==undefined)
this._delegate.selectEntryAtTime(bestTime);}
_onMouseLeave(event){delete this._markerXPosition;this._clearCurrentValueAndMarker();}
_clearCurrentValueAndMarker(){for(var i=0;i<this._counterUI.length;i++)
this._counterUI[i]._clearCurrentValueAndMarker();}
_onMouseMove(event){var x=event.x-this._canvasContainer.totalOffsetLeft();this._markerXPosition=x;this._refreshCurrentValues();}
_refreshCurrentValues(){if(this._markerXPosition===undefined)
return;for(var i=0;i<this._counterUI.length;++i)
this._counterUI[i].updateCurrentValue(this._markerXPosition);}
refresh(){this._timelineGrid.updateDividers(this._calculator);this.draw();this._refreshCurrentValues();}
refreshRecords(){}
_clear(){var ctx=this._canvas.getContext('2d');ctx.clearRect(0,0,ctx.canvas.width,ctx.canvas.height);}
highlightSearchResult(event,regex,select){}
highlightEvent(event){}
setSelection(selection){}};Timeline.CountersGraph.Counter=class{constructor(){this.times=[];this.values=[];}
appendSample(time,value){if(this.values.length&&this.values.peekLast()===value)
return;this.times.push(time);this.values.push(value);}
reset(){this.times=[];this.values=[];}
setLimit(value){this._limitValue=value;}
_calculateBounds(){var maxValue;var minValue;for(var i=this._minimumIndex;i<=this._maximumIndex;i++){var value=this.values[i];if(minValue===undefined||value<minValue)
minValue=value;if(maxValue===undefined||value>maxValue)
maxValue=value;}
minValue=minValue||0;maxValue=maxValue||1;if(this._limitValue){if(maxValue>this._limitValue*0.5)
maxValue=Math.max(maxValue,this._limitValue);minValue=Math.min(minValue,this._limitValue);}
return{min:minValue,max:maxValue};}
_calculateVisibleIndexes(calculator){var start=calculator.minimumBoundary();var end=calculator.maximumBoundary();this._minimumIndex=Number.constrain(this.times.upperBound(start)-1,0,this.times.length-1);this._maximumIndex=Number.constrain(this.times.lowerBound(end),0,this.times.length-1);this._minTime=start;this._maxTime=end;}
_calculateXValues(width){if(!this.values.length)
return;var xFactor=width/(this._maxTime-this._minTime);this.x=new Array(this.values.length);for(var i=this._minimumIndex+1;i<=this._maximumIndex;i++)
this.x[i]=xFactor*(this.times[i]-this._minTime);}};Timeline.CountersGraph.CounterUI=class{constructor(memoryCountersPane,title,currentValueLabel,graphColor,counter,formatter){this._memoryCountersPane=memoryCountersPane;this.counter=counter;this._formatter=formatter||Number.withThousandsSeparator;var container=memoryCountersPane._infoWidget.element.createChild('div','memory-counter-selector-info');this._setting=Common.settings.createSetting('timelineCountersGraph-'+title,true);this._filter=new UI.ToolbarCheckbox(title,title,this._setting);this._filter.inputElement.classList.add('-theme-preserve');var color=Common.Color.parse(graphColor).setAlpha(0.5).asString(Common.Color.Format.RGBA);if(color){this._filter.element.backgroundColor=color;this._filter.element.borderColor='transparent';}
this._filter.inputElement.addEventListener('click',this._toggleCounterGraph.bind(this));container.appendChild(this._filter.element);this._range=this._filter.element.createChild('span','range');this._value=memoryCountersPane._currentValuesBar.createChild('span','memory-counter-value');this._value.style.color=graphColor;this.graphColor=graphColor;this.limitColor=Common.Color.parse(graphColor).setAlpha(0.3).asString(Common.Color.Format.RGBA);this.graphYValues=[];this._verticalPadding=10;this._currentValueLabel=currentValueLabel;this._marker=memoryCountersPane._canvasContainer.createChild('div','memory-counter-marker');this._marker.style.backgroundColor=graphColor;this._clearCurrentValueAndMarker();}
reset(){this._range.textContent='';}
setRange(minValue,maxValue){var min=this._formatter(minValue);var max=this._formatter(maxValue);this._range.textContent=Common.UIString('[%s\u2009\u2013\u2009%s]',min,max);}
_toggleCounterGraph(event){this._value.classList.toggle('hidden',!this._filter.checked());this._memoryCountersPane.refresh();}
_recordIndexAt(x){return this.counter.x.upperBound(x*window.devicePixelRatio,null,this.counter._minimumIndex+1,this.counter._maximumIndex+1)-
1;}
updateCurrentValue(x){if(!this.visible()||!this.counter.values.length||!this.counter.x)
return;var index=this._recordIndexAt(x);var value=Number.withThousandsSeparator(this.counter.values[index]);this._value.textContent=Common.UIString(this._currentValueLabel,value);var y=this.graphYValues[index]/window.devicePixelRatio;this._marker.style.left=x+'px';this._marker.style.top=y+'px';this._marker.classList.remove('hidden');}
_clearCurrentValueAndMarker(){this._value.textContent='';this._marker.classList.add('hidden');}
_drawGraph(canvas){var ctx=canvas.getContext('2d');var width=canvas.width;var height=canvas.height-2*this._verticalPadding;if(height<=0){this.graphYValues=[];return;}
var originY=this._verticalPadding;var counter=this.counter;var values=counter.values;if(!values.length)
return;var bounds=counter._calculateBounds();var minValue=bounds.min;var maxValue=bounds.max;this.setRange(minValue,maxValue);if(!this.visible())
return;var yValues=this.graphYValues;var maxYRange=maxValue-minValue;var yFactor=maxYRange?height/(maxYRange):1;ctx.save();ctx.lineWidth=window.devicePixelRatio;if(ctx.lineWidth%2)
ctx.translate(0.5,0.5);ctx.beginPath();var value=values[counter._minimumIndex];var currentY=Math.round(originY+height-(value-minValue)*yFactor);ctx.moveTo(0,currentY);for(var i=counter._minimumIndex;i<=counter._maximumIndex;i++){var x=Math.round(counter.x[i]);ctx.lineTo(x,currentY);var currentValue=values[i];if(typeof currentValue!=='undefined')
value=currentValue;currentY=Math.round(originY+height-(value-minValue)*yFactor);ctx.lineTo(x,currentY);yValues[i]=currentY;}
yValues.length=i;ctx.lineTo(width,currentY);ctx.strokeStyle=this.graphColor;ctx.stroke();if(counter._limitValue){var limitLineY=Math.round(originY+height-(counter._limitValue-minValue)*yFactor);ctx.moveTo(0,limitLineY);ctx.lineTo(width,limitLineY);ctx.strokeStyle=this.limitColor;ctx.stroke();}
ctx.closePath();ctx.restore();}
visible(){return this._filter.checked();}};Timeline.CounterGraphCalculator=class{constructor(model){this._model=model;}
paddingLeft(){return this._paddingLeft;}
computePosition(time){return(time-this._minimumBoundary)/this.boundarySpan()*this._workingArea+this._paddingLeft;}
setWindow(minimumBoundary,maximumBoundary){this._minimumBoundary=minimumBoundary;this._maximumBoundary=maximumBoundary;}
setDisplayWindow(clientWidth,paddingLeft){this._paddingLeft=paddingLeft||0;this._workingArea=clientWidth-Timeline.CounterGraphCalculator._minWidth-this._paddingLeft;}
formatValue(value,precision){return Number.preciseMillisToString(value-this.zeroTime(),precision);}
maximumBoundary(){return this._maximumBoundary;}
minimumBoundary(){return this._minimumBoundary;}
zeroTime(){return this._model.minimumRecordTime();}
boundarySpan(){return this._maximumBoundary-this._minimumBoundary;}};Timeline.CounterGraphCalculator._minWidth=5;;Timeline.MemoryCountersGraph=class extends Timeline.CountersGraph{constructor(delegate,model,filters){super(delegate,model,filters);this._countersByName={};this._countersByName['jsHeapSizeUsed']=this.createCounter(Common.UIString('JS Heap'),Common.UIString('JS Heap: %s'),'hsl(220, 90%, 43%)',Number.bytesToString);this._countersByName['documents']=this.createCounter(Common.UIString('Documents'),Common.UIString('Documents: %s'),'hsl(0, 90%, 43%)');this._countersByName['nodes']=this.createCounter(Common.UIString('Nodes'),Common.UIString('Nodes: %s'),'hsl(120, 90%, 43%)');this._countersByName['jsEventListeners']=this.createCounter(Common.UIString('Listeners'),Common.UIString('Listeners: %s'),'hsl(38, 90%, 43%)');this._gpuMemoryCounter=this.createCounter(Common.UIString('GPU Memory'),Common.UIString('GPU Memory [KB]: %s'),'hsl(300, 90%, 43%)',Number.bytesToString);this._countersByName['gpuMemoryUsedKB']=this._gpuMemoryCounter;}
refreshRecords(){this.reset();var events=this._model.mainThreadEvents();for(var i=0;i<events.length;++i){var event=events[i];if(event.name!==TimelineModel.TimelineModel.RecordType.UpdateCounters)
continue;var counters=event.args.data;if(!counters)
return;for(var name in counters){var counter=this._countersByName[name];if(counter)
counter.appendSample(event.startTime,counters[name]);}
var gpuMemoryLimitCounterName='gpuMemoryLimitKB';if(gpuMemoryLimitCounterName in counters)
this._gpuMemoryCounter.setLimit(counters[gpuMemoryLimitCounterName]);}
this.scheduleRefresh();}};;SDK.CSSModel.RuleUsage;Timeline.TimelineController=class{constructor(target,delegate,tracingModel){this._delegate=delegate;this._target=target;this._tracingModel=tracingModel;this._targets=[];SDK.targetManager.observeTargets(this);if(Runtime.experiments.isEnabled('timelineRuleUsageRecording'))
this._markUnusedCSS=Common.settings.createSetting('timelineMarkUnusedCSS',false);}
startRecording(captureCauses,enableJSSampling,captureMemory,capturePictures,captureFilmStrip){this._extensionTraceProviders=Extensions.extensionServer.traceProviders().slice();function disabledByDefault(category){return'disabled-by-default-'+category;}
var categoriesArray=['-*','devtools.timeline','v8.execute',disabledByDefault('devtools.timeline'),disabledByDefault('devtools.timeline.frame'),SDK.TracingModel.TopLevelEventCategory,TimelineModel.TimelineModel.Category.Console,TimelineModel.TimelineModel.Category.UserTiming];categoriesArray.push(TimelineModel.TimelineModel.Category.LatencyInfo);if(Runtime.experiments.isEnabled('timelineV8RuntimeCallStats')&&enableJSSampling)
categoriesArray.push(disabledByDefault('v8.runtime_stats_sampling'));if(Runtime.experiments.isEnabled('timelineTracingJSProfile')&&enableJSSampling){categoriesArray.push(disabledByDefault('v8.cpu_profiler'));if(Common.moduleSetting('highResolutionCpuProfiling').get())
categoriesArray.push(disabledByDefault('v8.cpu_profiler.hires'));}
if(captureCauses||enableJSSampling)
categoriesArray.push(disabledByDefault('devtools.timeline.stack'));if(captureCauses&&Runtime.experiments.isEnabled('timelineInvalidationTracking'))
categoriesArray.push(disabledByDefault('devtools.timeline.invalidationTracking'));if(capturePictures){categoriesArray.push(disabledByDefault('devtools.timeline.layers'),disabledByDefault('devtools.timeline.picture'),disabledByDefault('blink.graphics_context_annotations'));}
if(captureFilmStrip)
categoriesArray.push(disabledByDefault('devtools.screenshot'));for(var traceProvider of this._extensionTraceProviders)
traceProvider.start();var categories=categoriesArray.join(',');this._startRecordingWithCategories(categories,enableJSSampling);}
stopRecording(){var tracingStoppedPromises=[];tracingStoppedPromises.push(new Promise(resolve=>this._tracingCompleteCallback=resolve));tracingStoppedPromises.push(this._stopProfilingOnAllTargets());this._target.tracingManager.stop();if(!Runtime.experiments.isEnabled('timelineRuleUsageRecording')||!this._markUnusedCSS.get())
tracingStoppedPromises.push(SDK.targetManager.resumeAllTargets());else
this._addUnusedRulesToCoverage();Promise.all(tracingStoppedPromises).then(()=>this._allSourcesFinished());this._delegate.loadingStarted();for(var traceProvider of this._extensionTraceProviders)
traceProvider.stop();}
targetAdded(target){this._targets.push(target);if(this._profiling)
this._startProfilingOnTarget(target);}
targetRemoved(target){this._targets.remove(target,true);}
_addUnusedRulesToCoverage(){var mainTarget=SDK.targetManager.mainTarget();if(!mainTarget)
return;var cssModel=SDK.CSSModel.fromTarget(mainTarget);function ruleListReceived(ruleUsageList){for(var rule of ruleUsageList){if(rule.wasUsed)
continue;var styleSheetHeader=cssModel.styleSheetHeaderForId(rule.styleSheetId);var url=styleSheetHeader.sourceURL;Components.CoverageProfile.instance().appendUnusedRule(url,Common.TextRange.fromObject(rule.range));}}
cssModel.ruleListPromise().then(ruleListReceived);}
_startProfilingOnTarget(target){return target.hasJSCapability()?target.profilerAgent().start():Promise.resolve();}
_startProfilingOnAllTargets(){var intervalUs=Common.moduleSetting('highResolutionCpuProfiling').get()?100:1000;this._target.profilerAgent().setSamplingInterval(intervalUs);this._profiling=true;return Promise.all(this._targets.map(this._startProfilingOnTarget));}
_stopProfilingOnTarget(target){return target.hasJSCapability()?target.profilerAgent().stop(this._addCpuProfile.bind(this,target.id())):Promise.resolve();}
_addCpuProfile(targetId,error,cpuProfile){if(!cpuProfile){Common.console.warn(Common.UIString('CPU profile for a target is not available. %s',error||''));return;}
if(!this._cpuProfiles)
this._cpuProfiles=new Map();this._cpuProfiles.set(targetId,cpuProfile);}
_stopProfilingOnAllTargets(){var targets=this._profiling?this._targets:[];this._profiling=false;return Promise.all(targets.map(this._stopProfilingOnTarget,this));}
_startRecordingWithCategories(categories,enableJSSampling,callback){if(!Runtime.experiments.isEnabled('timelineRuleUsageRecording')||!this._markUnusedCSS.get())
SDK.targetManager.suspendAllTargets();var profilingStartedPromise=enableJSSampling&&!Runtime.experiments.isEnabled('timelineTracingJSProfile')?this._startProfilingOnAllTargets():Promise.resolve();var samplingFrequencyHz=Common.moduleSetting('highResolutionCpuProfiling').get()?10000:1000;var options='sampling-frequency='+samplingFrequencyHz;var target=this._target;var tracingManager=target.tracingManager;SDK.targetManager.suspendReload(target);profilingStartedPromise.then(tracingManager.start.bind(tracingManager,this,categories,options,onTraceStarted));function onTraceStarted(error){SDK.targetManager.resumeReload(target);if(callback)
callback(error);}}
tracingStarted(){this._tracingModel.reset();this._delegate.recordingStarted();}
traceEventsCollected(events){this._tracingModel.addEvents(events);}
tracingComplete(){this._tracingCompleteCallback();this._tracingCompleteCallback=null;}
_allSourcesFinished(){this._injectCpuProfileEvents();this._tracingModel.tracingComplete();this._delegate.loadingComplete(true);}
_injectCpuProfileEvent(pid,tid,cpuProfile){if(!cpuProfile)
return;var cpuProfileEvent=({cat:SDK.TracingModel.DevToolsMetadataEventCategory,ph:SDK.TracingModel.Phase.Instant,ts:this._tracingModel.maximumRecordTime()*1000,pid:pid,tid:tid,name:TimelineModel.TimelineModel.RecordType.CpuProfile,args:{data:{cpuProfile:cpuProfile}}});this._tracingModel.addEvents([cpuProfileEvent]);}
_injectCpuProfileEvents(){if(!this._cpuProfiles)
return;var metadataEventTypes=TimelineModel.TimelineModel.DevToolsMetadataEvent;var metadataEvents=this._tracingModel.devToolsMetadataEvents();var mainMetaEvent=metadataEvents.filter(event=>event.name===metadataEventTypes.TracingStartedInPage).peekLast();if(!mainMetaEvent)
return;var pid=mainMetaEvent.thread.process().id();var mainCpuProfile=this._cpuProfiles.get(this._target.id());this._injectCpuProfileEvent(pid,mainMetaEvent.thread.id(),mainCpuProfile);var workerMetaEvents=metadataEvents.filter(event=>event.name===metadataEventTypes.TracingSessionIdForWorker);for(var metaEvent of workerMetaEvents){var workerId=metaEvent.args['data']['workerId'];var workerTarget=this._target.subTargetsManager?this._target.subTargetsManager.targetForId(workerId):null;if(!workerTarget)
continue;var cpuProfile=this._cpuProfiles.get(workerTarget.id());this._injectCpuProfileEvent(pid,metaEvent.args['data']['workerThreadId'],cpuProfile);}
this._cpuProfiles=null;}
tracingBufferUsage(usage){this._delegate.recordingProgress(usage);}
eventsRetrievalProgress(progress){this._delegate.loadingProgress(progress);}};;Timeline.TimelineLoader=class{constructor(model,delegate){this._model=model;this._delegate=delegate;this._canceledCallback=null;this._state=Timeline.TimelineLoader.State.Initial;this._buffer='';this._firstChunk=true;this._loadedBytes=0;this._totalSize;this._jsonTokenizer=new Common.TextUtils.BalancedJSONTokenizer(this._writeBalancedJSON.bind(this),true);}
static loadFromFile(model,file,delegate){var loader=new Timeline.TimelineLoader(model,delegate);var fileReader=Timeline.TimelineLoader._createFileReader(file,loader);loader._canceledCallback=fileReader.cancel.bind(fileReader);loader._totalSize=file.size;fileReader.start(loader);return loader;}
static loadFromURL(model,url,delegate){var stream=new Timeline.TimelineLoader(model,delegate);Host.ResourceLoader.loadAsStream(url,null,stream);return stream;}
static _createFileReader(file,delegate){return new Bindings.ChunkedFileReader(file,Timeline.TimelineLoader.TransferChunkLengthBytes,delegate);}
cancel(){this._model.reset();this._delegate.loadingComplete(false);this._delegate=null;if(this._canceledCallback)
this._canceledCallback();}
write(chunk){if(!this._delegate)
return;this._loadedBytes+=chunk.length;if(!this._firstChunk)
this._delegate.loadingProgress(this._totalSize?this._loadedBytes/this._totalSize:undefined);if(this._state===Timeline.TimelineLoader.State.Initial){if(chunk[0]==='{'){this._state=Timeline.TimelineLoader.State.LookingForEvents;}else if(chunk[0]==='['){this._state=Timeline.TimelineLoader.State.ReadingEvents;}else{this._reportErrorAndCancelLoading(Common.UIString('Malformed timeline data: Unknown JSON format'));return;}}
if(this._state===Timeline.TimelineLoader.State.LookingForEvents){var objectName='"traceEvents":';var startPos=this._buffer.length-objectName.length;this._buffer+=chunk;var pos=this._buffer.indexOf(objectName,startPos);if(pos===-1)
return;chunk=this._buffer.slice(pos+objectName.length);this._state=Timeline.TimelineLoader.State.ReadingEvents;}
if(this._state!==Timeline.TimelineLoader.State.ReadingEvents)
return;if(this._jsonTokenizer.write(chunk))
return;this._state=Timeline.TimelineLoader.State.SkippingTail;if(this._firstChunk){this._reportErrorAndCancelLoading(Common.UIString('Malformed timeline input, wrong JSON brackets balance'));return;}}
_writeBalancedJSON(data){var json=data+']';if(this._firstChunk){this._delegate.loadingStarted();}else{var commaIndex=json.indexOf(',');if(commaIndex!==-1)
json=json.slice(commaIndex+1);json='['+json;}
var items;try{items=(JSON.parse(json));}catch(e){this._reportErrorAndCancelLoading(Common.UIString('Malformed timeline data: %s',e.toString()));return;}
if(this._firstChunk){this._firstChunk=false;this._model.reset();if(this._looksLikeAppVersion(items[0])){this._reportErrorAndCancelLoading(Common.UIString('Legacy Timeline format is not supported.'));return;}}
try{this._model.addEvents(items);}catch(e){this._reportErrorAndCancelLoading(Common.UIString('Malformed timeline data: %s',e.toString()));return;}}
_reportErrorAndCancelLoading(message){if(message)
Common.console.error(message);this.cancel();}
_looksLikeAppVersion(item){return typeof item==='string'&&item.indexOf('Chrome')!==-1;}
close(){this._model.tracingComplete();if(this._delegate)
this._delegate.loadingComplete(true);}
onTransferStarted(){}
onChunkTransferred(reader){}
onTransferFinished(){}
onError(reader,event){switch(event.target.error.name){case'NotFoundError':this._reportErrorAndCancelLoading(Common.UIString('File "%s" not found.',reader.fileName()));break;case'NotReadableError':this._reportErrorAndCancelLoading(Common.UIString('File "%s" is not readable',reader.fileName()));break;case'AbortError':break;default:this._reportErrorAndCancelLoading(Common.UIString('An error occurred while reading the file "%s"',reader.fileName()));}}};Timeline.TimelineLoader.TransferChunkLengthBytes=5000000;Timeline.TimelineLoader.State={Initial:Symbol('Initial'),LookingForEvents:Symbol('LookingForEvents'),ReadingEvents:Symbol('ReadingEvents'),SkippingTail:Symbol('SkippingTail')};Timeline.TracingTimelineSaver=class{onTransferStarted(){}
onTransferFinished(){}
onChunkTransferred(reader){}
onError(reader,event){var error=event.target.error;Common.console.error(Common.UIString('Failed to save timeline: %s (%s, %s)',error.message,error.name,error.code));}};;Timeline.TimelineEventOverview=class extends UI.TimelineOverviewBase{constructor(id,title,model){super();this.element.id='timeline-overview-'+id;this.element.classList.add('overview-strip');if(title)
this.element.createChild('div','timeline-overview-strip-title').textContent=title;this._model=model;}
_renderBar(begin,end,position,height,color){var x=begin;var width=end-begin;var ctx=this.context();ctx.fillStyle=color;ctx.fillRect(x,position,width,height);}
windowTimes(windowLeft,windowRight){var absoluteMin=this._model.minimumRecordTime();var timeSpan=this._model.maximumRecordTime()-absoluteMin;return{startTime:absoluteMin+timeSpan*windowLeft,endTime:absoluteMin+timeSpan*windowRight};}
windowBoundaries(startTime,endTime){var absoluteMin=this._model.minimumRecordTime();var timeSpan=this._model.maximumRecordTime()-absoluteMin;var haveRecords=absoluteMin>0;return{left:haveRecords&&startTime?Math.min((startTime-absoluteMin)/timeSpan,1):0,right:haveRecords&&endTime<Infinity?(endTime-absoluteMin)/timeSpan:1};}};Timeline.TimelineEventOverviewInput=class extends Timeline.TimelineEventOverview{constructor(model){super('input',null,model);}
update(){super.update();var events=this._model.mainThreadEvents();var height=this.height();var descriptors=Timeline.TimelineUIUtils.eventDispatchDesciptors();var descriptorsByType=new Map();var maxPriority=-1;for(var descriptor of descriptors){for(var type of descriptor.eventTypes)
descriptorsByType.set(type,descriptor);maxPriority=Math.max(maxPriority,descriptor.priority);}
var minWidth=2*window.devicePixelRatio;var timeOffset=this._model.minimumRecordTime();var timeSpan=this._model.maximumRecordTime()-timeOffset;var canvasWidth=this.width();var scale=canvasWidth/timeSpan;for(var priority=0;priority<=maxPriority;++priority){for(var i=0;i<events.length;++i){var event=events[i];if(event.name!==TimelineModel.TimelineModel.RecordType.EventDispatch)
continue;var descriptor=descriptorsByType.get(event.args['data']['type']);if(!descriptor||descriptor.priority!==priority)
continue;var start=Number.constrain(Math.floor((event.startTime-timeOffset)*scale),0,canvasWidth);var end=Number.constrain(Math.ceil((event.endTime-timeOffset)*scale),0,canvasWidth);var width=Math.max(end-start,minWidth);this._renderBar(start,start+width,0,height,descriptor.color);}}}};Timeline.TimelineEventOverviewNetwork=class extends Timeline.TimelineEventOverview{constructor(model){super('network',Common.UIString('NET'),model);}
update(){super.update();var height=this.height();var numBands=categoryBand(Timeline.TimelineUIUtils.NetworkCategory.Other)+1;var bandHeight=Math.floor(height/numBands);var devicePixelRatio=window.devicePixelRatio;var timeOffset=this._model.minimumRecordTime();var timeSpan=this._model.maximumRecordTime()-timeOffset;var canvasWidth=this.width();var scale=canvasWidth/timeSpan;var ctx=this.context();var requests=this._model.networkRequests();var paths=new Map();requests.forEach(drawRequest);for(var path of paths){ctx.fillStyle=path[0];ctx.globalAlpha=0.3;ctx.fill(path[1]['waiting']);ctx.globalAlpha=1;ctx.fill(path[1]['transfer']);}
function categoryBand(category){var categories=Timeline.TimelineUIUtils.NetworkCategory;switch(category){case categories.HTML:return 0;case categories.Script:return 1;case categories.Style:return 2;case categories.Media:return 3;default:return 4;}}
function drawRequest(request){var tickWidth=2*devicePixelRatio;var category=Timeline.TimelineUIUtils.networkRequestCategory(request);var style=Timeline.TimelineUIUtils.networkCategoryColor(category);var band=categoryBand(category);var y=band*bandHeight;var path=paths.get(style);if(!path){path={waiting:new Path2D(),transfer:new Path2D()};paths.set(style,path);}
var s=Math.max(Math.floor((request.startTime-timeOffset)*scale),0);var e=Math.min(Math.ceil((request.endTime-timeOffset)*scale),canvasWidth);path['waiting'].rect(s,y,e-s,bandHeight-1);path['transfer'].rect(e-tickWidth/2,y,tickWidth,bandHeight-1);if(!request.responseTime)
return;var r=Math.ceil((request.responseTime-timeOffset)*scale);path['transfer'].rect(r-tickWidth/2,y,tickWidth,bandHeight-1);}}};Timeline.TimelineEventOverviewCPUActivity=class extends Timeline.TimelineEventOverview{constructor(model){super('cpu-activity',Common.UIString('CPU'),model);this._backgroundCanvas=this.element.createChild('canvas','fill background');}
resetCanvas(){super.resetCanvas();this._backgroundCanvas.width=this.element.clientWidth*window.devicePixelRatio;this._backgroundCanvas.height=this.element.clientHeight*window.devicePixelRatio;}
update(){super.update();var quantSizePx=4*window.devicePixelRatio;var width=this.width();var height=this.height();var baseLine=height;var timeOffset=this._model.minimumRecordTime();var timeSpan=this._model.maximumRecordTime()-timeOffset;var scale=width/timeSpan;var quantTime=quantSizePx/scale;var categories=Timeline.TimelineUIUtils.categories();var categoryOrder=['idle','loading','painting','rendering','scripting','other'];var otherIndex=categoryOrder.indexOf('other');var idleIndex=0;console.assert(idleIndex===categoryOrder.indexOf('idle'));for(var i=idleIndex+1;i<categoryOrder.length;++i)
categories[categoryOrder[i]]._overviewIndex=i;var backgroundContext=this._backgroundCanvas.getContext('2d');for(var thread of this._model.virtualThreads())
drawThreadEvents(backgroundContext,thread.events);applyPattern(backgroundContext);drawThreadEvents(this.context(),this._model.mainThreadEvents());function drawThreadEvents(ctx,events){var quantizer=new Timeline.Quantizer(timeOffset,quantTime,drawSample);var x=0;var categoryIndexStack=[];var paths=[];var lastY=[];for(var i=0;i<categoryOrder.length;++i){paths[i]=new Path2D();paths[i].moveTo(0,height);lastY[i]=height;}
function drawSample(counters){var y=baseLine;for(var i=idleIndex+1;i<categoryOrder.length;++i){var h=(counters[i]||0)/quantTime*height;y-=h;paths[i].bezierCurveTo(x,lastY[i],x,y,x+quantSizePx/2,y);lastY[i]=y;}
x+=quantSizePx;}
function onEventStart(e){var index=categoryIndexStack.length?categoryIndexStack.peekLast():idleIndex;quantizer.appendInterval(e.startTime,index);categoryIndexStack.push(Timeline.TimelineUIUtils.eventStyle(e).category._overviewIndex||otherIndex);}
function onEventEnd(e){quantizer.appendInterval(e.endTime,categoryIndexStack.pop());}
TimelineModel.TimelineModel.forEachEvent(events,onEventStart,onEventEnd);quantizer.appendInterval(timeOffset+timeSpan+quantTime,idleIndex);for(var i=categoryOrder.length-1;i>0;--i){paths[i].lineTo(width,height);ctx.fillStyle=categories[categoryOrder[i]].color;ctx.fill(paths[i]);}}
function applyPattern(ctx){var step=4*window.devicePixelRatio;ctx.save();ctx.lineWidth=step/Math.sqrt(8);for(var x=0.5;x<width+height;x+=step){ctx.moveTo(x,0);ctx.lineTo(x-height,height);}
ctx.globalCompositeOperation='destination-out';ctx.stroke();ctx.restore();}}};Timeline.TimelineEventOverviewResponsiveness=class extends Timeline.TimelineEventOverview{constructor(model,frameModel){super('responsiveness',null,model);this._frameModel=frameModel;}
update(){super.update();var height=this.height();var timeOffset=this._model.minimumRecordTime();var timeSpan=this._model.maximumRecordTime()-timeOffset;var scale=this.width()/timeSpan;var frames=this._frameModel.frames();var ctx=(this.context());var fillPath=new Path2D();var markersPath=new Path2D();for(var i=0;i<frames.length;++i){var frame=frames[i];if(!frame.hasWarnings())
continue;paintWarningDecoration(frame.startTime,frame.duration);}
var events=this._model.mainThreadEvents();for(var i=0;i<events.length;++i){if(!TimelineModel.TimelineData.forEvent(events[i]).warning)
continue;paintWarningDecoration(events[i].startTime,events[i].duration);}
ctx.fillStyle='hsl(0, 80%, 90%)';ctx.strokeStyle='red';ctx.lineWidth=2*window.devicePixelRatio;ctx.fill(fillPath);ctx.stroke(markersPath);function paintWarningDecoration(time,duration){var x=Math.round(scale*(time-timeOffset));var w=Math.round(scale*duration);fillPath.rect(x,0,w,height);markersPath.moveTo(x+w,0);markersPath.lineTo(x+w,height);}}};Timeline.TimelineFilmStripOverview=class extends Timeline.TimelineEventOverview{constructor(model,filmStripModel){super('filmstrip',null,model);this._filmStripModel=filmStripModel;this.reset();}
update(){super.update();var frames=this._filmStripModel.frames();if(!frames.length)
return;var drawGeneration=Symbol('drawGeneration');this._drawGeneration=drawGeneration;this._imageByFrame(frames[0]).then(image=>{if(this._drawGeneration!==drawGeneration)
return;if(!image.naturalWidth||!image.naturalHeight)
return;var imageHeight=this.height()-2*Timeline.TimelineFilmStripOverview.Padding;var imageWidth=Math.ceil(imageHeight*image.naturalWidth/image.naturalHeight);var popoverScale=Math.min(200/image.naturalWidth,1);this._emptyImage=new Image(image.naturalWidth*popoverScale,image.naturalHeight*popoverScale);this._drawFrames(imageWidth,imageHeight);});}
_imageByFrame(frame){var imagePromise=this._frameToImagePromise.get(frame);if(!imagePromise){imagePromise=frame.imageDataPromise().then(createImage);this._frameToImagePromise.set(frame,imagePromise);}
return imagePromise;function createImage(data){var fulfill;var promise=new Promise(f=>fulfill=f);var image=(createElement('img'));if(data)
image.src='data:image/jpg;base64,'+data;if(image.complete){fulfill(image);}else{image.addEventListener('load',()=>fulfill(image));image.addEventListener('error',()=>fulfill(image));}
return promise;}}
_drawFrames(imageWidth,imageHeight){if(!imageWidth)
return;if(!this._filmStripModel.frames().length)
return;var padding=Timeline.TimelineFilmStripOverview.Padding;var width=this.width();var zeroTime=this._filmStripModel.zeroTime();var spanTime=this._filmStripModel.spanTime();var scale=spanTime/width;var context=this.context();var drawGeneration=this._drawGeneration;context.beginPath();for(var x=padding;x<width;x+=imageWidth+2*padding){var time=zeroTime+(x+imageWidth/2)*scale;var frame=this._filmStripModel.frameByTimestamp(time);if(!frame)
continue;context.rect(x-0.5,0.5,imageWidth+1,imageHeight+1);this._imageByFrame(frame).then(drawFrameImage.bind(this,x));}
context.strokeStyle='#ddd';context.stroke();function drawFrameImage(x,image){if(this._drawGeneration!==drawGeneration)
return;context.drawImage(image,x,1,imageWidth,imageHeight);}}
popoverElementPromise(x){if(!this._filmStripModel.frames().length)
return Promise.resolve((null));var time=this._calculator.positionToTime(x);var frame=this._filmStripModel.frameByTimestamp(time);if(frame===this._lastFrame)
return Promise.resolve(this._lastElement);var imagePromise=frame?this._imageByFrame(frame):Promise.resolve(this._emptyImage);return imagePromise.then(createFrameElement.bind(this));function createFrameElement(image){var element=createElementWithClass('div','frame');element.createChild('div','thumbnail').appendChild(image);UI.appendStyle(element,'timeline/timelinePanel.css');this._lastFrame=frame;this._lastElement=element;return element;}}
reset(){this._lastFrame=undefined;this._lastElement=null;this._frameToImagePromise=new Map();this._imageWidth=0;}};Timeline.TimelineFilmStripOverview.Padding=2;Timeline.TimelineEventOverviewFrames=class extends Timeline.TimelineEventOverview{constructor(model,frameModel){super('framerate',Common.UIString('FPS'),model);this._frameModel=frameModel;}
update(){super.update();var height=this.height();var padding=1*window.devicePixelRatio;var baseFrameDurationMs=1e3/60;var visualHeight=height-2*padding;var timeOffset=this._model.minimumRecordTime();var timeSpan=this._model.maximumRecordTime()-timeOffset;var scale=this.width()/timeSpan;var frames=this._frameModel.frames();var baseY=height-padding;var ctx=this.context();var bottomY=baseY+10*window.devicePixelRatio;var x=0;var y=bottomY;if(!frames.length)
return;var lineWidth=window.devicePixelRatio;var offset=lineWidth&1?0.5:0;var tickDepth=1.5*window.devicePixelRatio;ctx.beginPath();ctx.moveTo(0,y);for(var i=0;i<frames.length;++i){var frame=frames[i];x=Math.round((frame.startTime-timeOffset)*scale)+offset;ctx.lineTo(x,y);ctx.lineTo(x,y+tickDepth);y=frame.idle?bottomY:Math.round(baseY-visualHeight*Math.min(baseFrameDurationMs/frame.duration,1))-offset;ctx.lineTo(x,y+tickDepth);ctx.lineTo(x,y);}
if(frames.length){var lastFrame=frames.peekLast();x=Math.round((lastFrame.startTime+lastFrame.duration-timeOffset)*scale)+offset;ctx.lineTo(x,y);}
ctx.lineTo(x,bottomY);ctx.fillStyle='hsl(110, 50%, 88%)';ctx.strokeStyle='hsl(110, 50%, 60%)';ctx.lineWidth=lineWidth;ctx.fill();ctx.stroke();}};Timeline.TimelineEventOverviewMemory=class extends Timeline.TimelineEventOverview{constructor(model){super('memory',Common.UIString('HEAP'),model);this._heapSizeLabel=this.element.createChild('div','memory-graph-label');}
resetHeapSizeLabels(){this._heapSizeLabel.textContent='';}
update(){super.update();var ratio=window.devicePixelRatio;var events=this._model.mainThreadEvents();if(!events.length){this.resetHeapSizeLabels();return;}
var lowerOffset=3*ratio;var maxUsedHeapSize=0;var minUsedHeapSize=100000000000;var minTime=this._model.minimumRecordTime();var maxTime=this._model.maximumRecordTime();function isUpdateCountersEvent(event){return event.name===TimelineModel.TimelineModel.RecordType.UpdateCounters;}
events=events.filter(isUpdateCountersEvent);function calculateMinMaxSizes(event){var counters=event.args.data;if(!counters||!counters.jsHeapSizeUsed)
return;maxUsedHeapSize=Math.max(maxUsedHeapSize,counters.jsHeapSizeUsed);minUsedHeapSize=Math.min(minUsedHeapSize,counters.jsHeapSizeUsed);}
events.forEach(calculateMinMaxSizes);minUsedHeapSize=Math.min(minUsedHeapSize,maxUsedHeapSize);var lineWidth=1;var width=this.width();var height=this.height()-lowerOffset;var xFactor=width/(maxTime-minTime);var yFactor=(height-lineWidth)/Math.max(maxUsedHeapSize-minUsedHeapSize,1);var histogram=new Array(width);function buildHistogram(event){var counters=event.args.data;if(!counters||!counters.jsHeapSizeUsed)
return;var x=Math.round((event.startTime-minTime)*xFactor);var y=Math.round((counters.jsHeapSizeUsed-minUsedHeapSize)*yFactor);histogram[x]=Math.max(histogram[x]||0,y);}
events.forEach(buildHistogram);var ctx=this.context();var heightBeyondView=height+lowerOffset+lineWidth;ctx.translate(0.5,0.5);ctx.beginPath();ctx.moveTo(-lineWidth,heightBeyondView);var y=0;var isFirstPoint=true;var lastX=0;for(var x=0;x<histogram.length;x++){if(typeof histogram[x]==='undefined')
continue;if(isFirstPoint){isFirstPoint=false;y=histogram[x];ctx.lineTo(-lineWidth,height-y);}
var nextY=histogram[x];if(Math.abs(nextY-y)>2&&Math.abs(x-lastX)>1)
ctx.lineTo(x,height-y);y=nextY;ctx.lineTo(x,height-y);lastX=x;}
ctx.lineTo(width+lineWidth,height-y);ctx.lineTo(width+lineWidth,heightBeyondView);ctx.closePath();ctx.fillStyle='hsla(220, 90%, 70%, 0.2)';ctx.fill();ctx.lineWidth=lineWidth;ctx.strokeStyle='hsl(220, 90%, 70%)';ctx.stroke();this._heapSizeLabel.textContent=Common.UIString('%s \u2013 %s',Number.bytesToString(minUsedHeapSize),Number.bytesToString(maxUsedHeapSize));}};Timeline.Quantizer=class{constructor(startTime,quantDuration,callback){this._lastTime=startTime;this._quantDuration=quantDuration;this._callback=callback;this._counters=[];this._remainder=quantDuration;}
appendInterval(time,group){var interval=time-this._lastTime;if(interval<=this._remainder){this._counters[group]=(this._counters[group]||0)+interval;this._remainder-=interval;this._lastTime=time;return;}
this._counters[group]=(this._counters[group]||0)+this._remainder;this._callback(this._counters);interval-=this._remainder;while(interval>=this._quantDuration){var counters=[];counters[group]=this._quantDuration;this._callback(counters);interval-=this._quantDuration;}
this._counters=[];this._counters[group]=interval;this._lastTime=time;this._remainder=this._quantDuration-interval;}};;Timeline.TimelineFlameChartDataProviderBase=class{constructor(){UI.FlameChartDataProvider.call(this);this.reset();this._font='11px '+Host.fontFamily();}
font(){return this._font;}
barHeight(){return 17;}
textBaseline(){return 5;}
textPadding(){return 4;}
entryFont(entryIndex){return this._font;}
entryTitle(entryIndex){return null;}
reset(){this._timelineData=null;}
minimumBoundary(){return this._minimumBoundary;}
totalTime(){return this._timeSpan;}
formatValue(value,precision){return Number.preciseMillisToString(value,precision);}
maxStackDepth(){return this._currentLevel;}
prepareHighlightedEntryInfo(entryIndex){return null;}
canJumpToEntry(entryIndex){return false;}
entryColor(entryIndex){return'red';}
forceDecoration(index){return false;}
decorateEntry(entryIndex,context,text,barX,barY,barWidth,barHeight,unclippedBarX,timeToPixels){return false;}
paddingLeft(){return 0;}
textColor(entryIndex){return'#333';}
createSelection(entryIndex){return null;}
timelineData(){throw new Error('Not implemented');}};Timeline.TimelineFlameChartEntryType={Frame:Symbol('Frame'),Event:Symbol('Event'),InteractionRecord:Symbol('InteractionRecord'),};Timeline.TimelineFlameChartMarker=class{constructor(startTime,startOffset,style){this._startTime=startTime;this._startOffset=startOffset;this._style=style;}
startTime(){return this._startTime;}
color(){return this._style.color;}
title(){var startTime=Number.millisToString(this._startOffset);return Common.UIString('%s at %s',this._style.title,startTime);}
draw(context,x,height,pixelsPerMillisecond){var lowPriorityVisibilityThresholdInPixelsPerMs=4;if(this._style.lowPriority&&pixelsPerMillisecond<lowPriorityVisibilityThresholdInPixelsPerMs)
return;context.save();if(!this._style.lowPriority){context.strokeStyle=this._style.color;context.lineWidth=2;context.beginPath();context.moveTo(x,0);context.lineTo(x,height);context.stroke();}
if(this._style.tall){context.strokeStyle=this._style.color;context.lineWidth=this._style.lineWidth;context.translate(this._style.lineWidth<1||(this._style.lineWidth&1)?0.5:0,0.5);context.beginPath();context.moveTo(x,height);context.setLineDash(this._style.dashStyle);context.lineTo(x,context.canvas.height);context.stroke();}
context.restore();}};Timeline.TimelineFlameChartView=class extends UI.VBox{constructor(delegate,timelineModel,frameModel,irModel,filters){super();this.element.classList.add('timeline-flamechart');this._delegate=delegate;this._model=timelineModel;this._splitWidget=new UI.SplitWidget(false,false,'timelineFlamechartMainView',150);this._dataProvider=new Timeline.TimelineFlameChartDataProvider(this._model,frameModel,irModel,filters);var mainViewGroupExpansionSetting=Common.settings.createSetting('timelineFlamechartMainViewGroupExpansion',{});this._mainView=new UI.FlameChart(this._dataProvider,this,mainViewGroupExpansionSetting);var networkViewGroupExpansionSetting=Common.settings.createSetting('timelineFlamechartNetworkViewGroupExpansion',{});this._networkDataProvider=new Timeline.TimelineFlameChartNetworkDataProvider(this._model);this._networkView=new UI.FlameChart(this._networkDataProvider,this,networkViewGroupExpansionSetting);networkViewGroupExpansionSetting.addChangeListener(this.resizeToPreferredHeights.bind(this));this._splitWidget.setMainWidget(this._mainView);this._splitWidget.setSidebarWidget(this._networkView);this._splitWidget.show(this.element);this._onMainEntrySelected=this._onEntrySelected.bind(this,this._dataProvider);this._onNetworkEntrySelected=this._onEntrySelected.bind(this,this._networkDataProvider);this._mainView.addEventListener(UI.FlameChart.Events.EntrySelected,this._onMainEntrySelected,this);this._networkView.addEventListener(UI.FlameChart.Events.EntrySelected,this._onNetworkEntrySelected,this);Bindings.blackboxManager.addChangeListener(this.refreshRecords,this);}
dispose(){this._mainView.removeEventListener(UI.FlameChart.Events.EntrySelected,this._onMainEntrySelected,this);this._networkView.removeEventListener(UI.FlameChart.Events.EntrySelected,this._onNetworkEntrySelected,this);Bindings.blackboxManager.removeChangeListener(this.refreshRecords,this);}
resizerElement(){return null;}
requestWindowTimes(windowStartTime,windowEndTime){this._delegate.requestWindowTimes(windowStartTime,windowEndTime);}
updateRangeSelection(startTime,endTime){this._delegate.select(Timeline.TimelineSelection.fromRange(startTime,endTime));}
refreshRecords(){this._dataProvider.reset();this._mainView.scheduleUpdate();this._networkDataProvider.reset();this._networkView.scheduleUpdate();}
highlightEvent(event){var entryIndex=event?this._dataProvider.entryIndexForSelection(Timeline.TimelineSelection.fromTraceEvent(event)):-1;if(entryIndex>=0)
this._mainView.highlightEntry(entryIndex);else
this._mainView.hideHighlight();}
wasShown(){this._mainView.scheduleUpdate();this._networkView.scheduleUpdate();}
view(){return this;}
reset(){this._dataProvider.reset();this._mainView.reset();this._mainView.setWindowTimes(0,Infinity);this._networkDataProvider.reset();this._networkView.reset();this._networkView.setWindowTimes(0,Infinity);}
setWindowTimes(startTime,endTime){this._mainView.setWindowTimes(startTime,endTime);this._networkView.setWindowTimes(startTime,endTime);this._networkDataProvider.setWindowTimes(startTime,endTime);}
highlightSearchResult(event,regex,select){if(!event){this._delegate.select(null);return;}
var timelineSelection=this._dataProvider.selectionForEvent(event);if(timelineSelection)
this._delegate.select(timelineSelection);}
setSelection(selection){var index=this._dataProvider.entryIndexForSelection(selection);this._mainView.setSelectedEntry(index);index=this._networkDataProvider.entryIndexForSelection(selection);this._networkView.setSelectedEntry(index);}
_onEntrySelected(dataProvider,event){var entryIndex=(event.data);this._delegate.select(dataProvider.createSelection(entryIndex));}
enableNetworkPane(enable,animate){if(enable)
this._splitWidget.showBoth(animate);else
this._splitWidget.hideSidebar(animate);}
resizeToPreferredHeights(){this._splitWidget.setSidebarSize(this._networkDataProvider.preferredHeight());}};Timeline.TimelineFlameChartView.Selection=class{constructor(selection,entryIndex){this.timelineSelection=selection;this.entryIndex=entryIndex;}};;Timeline.TimelineFlameChartDataProvider=class extends Timeline.TimelineFlameChartDataProviderBase{constructor(model,frameModel,irModel,filters){super();this._model=model;this._filters=filters;this._timelineData=null;this._frameModel=frameModel;this._irModel=irModel;this._consoleColorGenerator=new UI.FlameChart.ColorGenerator({min:30,max:55},{min:70,max:100,count:6},50,0.7);const font=this.font();this._headerLevel1={padding:4,height:17,collapsible:true,color:UI.themeSupport.patchColor('#222',UI.ThemeSupport.ColorUsage.Foreground),font:font,backgroundColor:UI.themeSupport.patchColor('white',UI.ThemeSupport.ColorUsage.Background),nestingLevel:0};this._headerLevel2={padding:2,height:17,collapsible:false,font:font,color:UI.themeSupport.patchColor('#222',UI.ThemeSupport.ColorUsage.Foreground),backgroundColor:UI.themeSupport.patchColor('white',UI.ThemeSupport.ColorUsage.Background),nestingLevel:1,shareHeaderLine:true};this._interactionsHeaderLevel1={padding:4,height:17,collapsible:true,color:UI.themeSupport.patchColor('#222',UI.ThemeSupport.ColorUsage.Foreground),font:font,backgroundColor:UI.themeSupport.patchColor('white',UI.ThemeSupport.ColorUsage.Background),nestingLevel:0,useFirstLineForOverview:true,shareHeaderLine:true};this._interactionsHeaderLevel2={padding:2,height:17,collapsible:true,color:UI.themeSupport.patchColor('#222',UI.ThemeSupport.ColorUsage.Foreground),font:font,backgroundColor:UI.themeSupport.patchColor('white',UI.ThemeSupport.ColorUsage.Background),nestingLevel:1,shareHeaderLine:true};}
entryTitle(entryIndex){var entryType=this._entryType(entryIndex);if(entryType===Timeline.TimelineFlameChartEntryType.Event){var event=(this._entryData[entryIndex]);if(event.phase===SDK.TracingModel.Phase.AsyncStepInto||event.phase===SDK.TracingModel.Phase.AsyncStepPast)
return event.name+':'+event.args['step'];if(event._blackboxRoot)
return Common.UIString('Blackboxed');var name=Timeline.TimelineUIUtils.eventStyle(event).title;var detailsText=Timeline.TimelineUIUtils.buildDetailsTextForTraceEvent(event,this._model.targetByEvent(event));if(event.name===TimelineModel.TimelineModel.RecordType.JSFrame&&detailsText)
return detailsText;return detailsText?Common.UIString('%s (%s)',name,detailsText):name;}
var title=this._entryIndexToTitle[entryIndex];if(!title){title=Common.UIString('Unexpected entryIndex %d',entryIndex);console.error(title);}
return title;}
textColor(index){var event=this._entryData[index];if(event&&event._blackboxRoot)
return'#888';else
return super.textColor(index);}
reset(){super.reset();this._timelineData=null;this._entryData=[];this._entryTypeByLevel=[];this._entryIndexToTitle=[];this._markers=[];this._asyncColorByCategory=new Map();this._asyncColorByInteractionPhase=new Map();}
timelineData(){if(this._timelineData)
return this._timelineData;this._timelineData=new UI.FlameChart.TimelineData([],[],[],[]);this._minimumBoundary=this._model.minimumRecordTime();this._timeSpan=this._model.isEmpty()?1000:this._model.maximumRecordTime()-this._minimumBoundary;this._currentLevel=0;this._appendFrameBars(this._frameModel.frames());this._appendHeader(Common.UIString('Interactions'),this._interactionsHeaderLevel1);this._appendInteractionRecords();var asyncEventGroups=TimelineModel.TimelineModel.AsyncEventGroup;var inputLatencies=this._model.mainThreadAsyncEvents().get(asyncEventGroups.input);if(inputLatencies&&inputLatencies.length){var title=Timeline.TimelineUIUtils.titleForAsyncEventGroup(asyncEventGroups.input);this._appendAsyncEventsGroup(title,inputLatencies,this._interactionsHeaderLevel2);}
var animations=this._model.mainThreadAsyncEvents().get(asyncEventGroups.animation);if(animations&&animations.length){var title=Timeline.TimelineUIUtils.titleForAsyncEventGroup(asyncEventGroups.animation);this._appendAsyncEventsGroup(title,animations,this._interactionsHeaderLevel2);}
var threads=this._model.virtualThreads();if(!Runtime.experiments.isEnabled('timelinePerFrameTrack')){this._appendThreadTimelineData(Common.UIString('Main'),this._model.mainThreadEvents(),this._model.mainThreadAsyncEvents(),true);}else{this._appendThreadTimelineData(Common.UIString('Page'),this._model.eventsForFrame(TimelineModel.TimelineModel.PageFrame.mainFrameId),this._model.mainThreadAsyncEvents(),true);for(var frame of this._model.rootFrames()){frame.children.forEach(this._appendFrameEvents.bind(this,0));}}
var compositorThreads=threads.filter(thread=>thread.name.startsWith('CompositorTileWorker'));var otherThreads=threads.filter(thread=>!thread.name.startsWith('CompositorTileWorker'));if(compositorThreads.length){this._appendHeader(Common.UIString('Raster'),this._headerLevel1);for(var i=0;i<compositorThreads.length;++i){this._appendSyncEvents(compositorThreads[i].events,Common.UIString('Rasterizer Thread %d',i),this._headerLevel2);}}
this._appendGPUEvents();otherThreads.forEach(thread=>this._appendThreadTimelineData(thread.name,thread.events,thread.asyncEventsByGroup));function compareStartTime(a,b){return a.startTime()-b.startTime();}
this._markers.sort(compareStartTime);this._timelineData.markers=this._markers;return this._timelineData;}
_appendFrameEvents(level,frame){var events=this._model.eventsForFrame(frame.id);var clonedHeader=Object.assign({},this._headerLevel1);clonedHeader.nestingLevel=level;this._appendSyncEvents(events,Timeline.TimelineUIUtils.displayNameForFrame(frame),(clonedHeader));frame.children.forEach(this._appendFrameEvents.bind(this,level+1));}
_appendThreadTimelineData(threadTitle,syncEvents,asyncEvents,forceExpanded){this._appendAsyncEvents(asyncEvents);this._appendSyncEvents(syncEvents,threadTitle,this._headerLevel1,forceExpanded);}
_appendSyncEvents(events,title,style,forceExpanded){var openEvents=[];var blackboxingEnabled=Runtime.experiments.isEnabled('blackboxJSFramesOnTimeline');var maxStackDepth=0;for(var i=0;i<events.length;++i){var e=events[i];if(TimelineModel.TimelineModel.isMarkerEvent(e)){this._markers.push(new Timeline.TimelineFlameChartMarker(e.startTime,e.startTime-this._model.minimumRecordTime(),Timeline.TimelineUIUtils.markerStyleForEvent(e)));}
if(!SDK.TracingModel.isFlowPhase(e.phase)){if(!e.endTime&&e.phase!==SDK.TracingModel.Phase.Instant)
continue;if(SDK.TracingModel.isAsyncPhase(e.phase))
continue;if(!this._isVisible(e))
continue;}
while(openEvents.length&&openEvents.peekLast().endTime<=e.startTime)
openEvents.pop();e._blackboxRoot=false;if(blackboxingEnabled&&this._isBlackboxedEvent(e)){var parent=openEvents.peekLast();if(parent&&parent._blackboxRoot)
continue;e._blackboxRoot=true;}
if(title){this._appendHeader(title,style,forceExpanded);title='';}
var level=this._currentLevel+openEvents.length;this._appendEvent(e,level);maxStackDepth=Math.max(maxStackDepth,openEvents.length+1);if(e.endTime)
openEvents.push(e);}
this._entryTypeByLevel.length=this._currentLevel+maxStackDepth;this._entryTypeByLevel.fill(Timeline.TimelineFlameChartEntryType.Event,this._currentLevel);this._currentLevel+=maxStackDepth;}
_isBlackboxedEvent(event){if(event.name!==TimelineModel.TimelineModel.RecordType.JSFrame)
return false;var url=event.args['data']['url'];return url&&this._isBlackboxedURL(url);}
_isBlackboxedURL(url){return Bindings.blackboxManager.isBlackboxedURL(url);}
_appendAsyncEvents(asyncEvents){var groups=TimelineModel.TimelineModel.AsyncEventGroup;var groupArray=Object.keys(groups).map(key=>groups[key]);groupArray.remove(groups.animation);groupArray.remove(groups.input);for(var groupIndex=0;groupIndex<groupArray.length;++groupIndex){var group=groupArray[groupIndex];var events=asyncEvents.get(group);if(!events)
continue;var title=Timeline.TimelineUIUtils.titleForAsyncEventGroup(group);this._appendAsyncEventsGroup(title,events,this._headerLevel1);}}
_appendAsyncEventsGroup(header,events,style){var lastUsedTimeByLevel=[];var groupHeaderAppended=false;for(var i=0;i<events.length;++i){var asyncEvent=events[i];if(!this._isVisible(asyncEvent))
continue;if(!groupHeaderAppended){this._appendHeader(header,style);groupHeaderAppended=true;}
var startTime=asyncEvent.startTime;var level;for(level=0;level<lastUsedTimeByLevel.length&&lastUsedTimeByLevel[level]>startTime;++level){}
this._appendAsyncEvent(asyncEvent,this._currentLevel+level);lastUsedTimeByLevel[level]=asyncEvent.endTime;}
this._entryTypeByLevel.length=this._currentLevel+lastUsedTimeByLevel.length;this._entryTypeByLevel.fill(Timeline.TimelineFlameChartEntryType.Event,this._currentLevel);this._currentLevel+=lastUsedTimeByLevel.length;}
_appendGPUEvents(){if(this._appendSyncEvents(this._model.gpuEvents(),Common.UIString('GPU'),this._headerLevel1,false))
++this._currentLevel;}
_appendInteractionRecords(){this._irModel.interactionRecords().forEach(this._appendSegment,this);this._entryTypeByLevel[this._currentLevel++]=Timeline.TimelineFlameChartEntryType.InteractionRecord;}
_appendFrameBars(frames){var style=Timeline.TimelineUIUtils.markerStyleForFrame();this._entryTypeByLevel[this._currentLevel]=Timeline.TimelineFlameChartEntryType.Frame;for(var i=0;i<frames.length;++i){this._markers.push(new Timeline.TimelineFlameChartMarker(frames[i].startTime,frames[i].startTime-this._model.minimumRecordTime(),style));this._appendFrame(frames[i]);}
++this._currentLevel;}
_entryType(entryIndex){return this._entryTypeByLevel[this._timelineData.entryLevels[entryIndex]];}
prepareHighlightedEntryInfo(entryIndex){var time='';var title;var warning;var type=this._entryType(entryIndex);if(type===Timeline.TimelineFlameChartEntryType.Event){var event=(this._entryData[entryIndex]);var totalTime=event.duration;var selfTime=event.selfTime;var eps=1e-6;if(typeof totalTime==='number'){time=Math.abs(totalTime-selfTime)>eps&&selfTime>eps?Common.UIString('%s (self %s)',Number.millisToString(totalTime,true),Number.millisToString(selfTime,true)):Number.millisToString(totalTime,true);}
title=this.entryTitle(entryIndex);warning=Timeline.TimelineUIUtils.eventWarning(event);}else if(type===Timeline.TimelineFlameChartEntryType.Frame){var frame=(this._entryData[entryIndex]);time=Common.UIString('%s ~ %.0f\u2009fps',Number.preciseMillisToString(frame.duration,1),(1000/frame.duration));title=frame.idle?Common.UIString('Idle Frame'):Common.UIString('Frame');if(frame.hasWarnings()){warning=createElement('span');warning.textContent=Common.UIString('Long frame');}}else{return null;}
var element=createElement('div');var root=UI.createShadowRootWithCoreStyles(element,'timeline/timelineFlamechartPopover.css');var contents=root.createChild('div','timeline-flamechart-popover');contents.createChild('span','timeline-info-time').textContent=time;contents.createChild('span','timeline-info-title').textContent=title;if(warning){warning.classList.add('timeline-info-warning');contents.appendChild(warning);}
return element;}
entryColor(entryIndex){function patchColorAndCache(cache,key,lookupColor){var color=cache.get(key);if(color)
return color;var parsedColor=Common.Color.parse(lookupColor(key));color=parsedColor.setAlpha(0.7).asString(Common.Color.Format.RGBA)||'';cache.set(key,color);return color;}
var type=this._entryType(entryIndex);if(type===Timeline.TimelineFlameChartEntryType.Event){var event=(this._entryData[entryIndex]);if(!SDK.TracingModel.isAsyncPhase(event.phase))
return Timeline.TimelineUIUtils.eventColor(event);if(event.hasCategory(TimelineModel.TimelineModel.Category.Console)||event.hasCategory(TimelineModel.TimelineModel.Category.UserTiming))
return this._consoleColorGenerator.colorForID(event.name);if(event.hasCategory(TimelineModel.TimelineModel.Category.LatencyInfo)){var phase=TimelineModel.TimelineIRModel.phaseForEvent(event)||TimelineModel.TimelineIRModel.Phases.Uncategorized;return patchColorAndCache(this._asyncColorByInteractionPhase,phase,Timeline.TimelineUIUtils.interactionPhaseColor);}
var category=Timeline.TimelineUIUtils.eventStyle(event).category;return patchColorAndCache(this._asyncColorByCategory,category,()=>category.color);}
if(type===Timeline.TimelineFlameChartEntryType.Frame)
return'white';if(type===Timeline.TimelineFlameChartEntryType.InteractionRecord)
return'transparent';return'';}
decorateEntry(entryIndex,context,text,barX,barY,barWidth,barHeight,unclippedBarX,timeToPixels){var data=this._entryData[entryIndex];var type=this._entryType(entryIndex);if(type===Timeline.TimelineFlameChartEntryType.Frame){var vPadding=1;var hPadding=1;var frame=(data);barX+=hPadding;barWidth-=2*hPadding;barY+=vPadding;barHeight-=2*vPadding+1;context.fillStyle=frame.idle?'white':(frame.hasWarnings()?'#fad1d1':'#d7f0d1');context.fillRect(barX,barY,barWidth,barHeight);var frameDurationText=Number.preciseMillisToString(frame.duration,1);var textWidth=context.measureText(frameDurationText).width;if(barWidth>=textWidth){context.fillStyle=this.textColor(entryIndex);context.fillText(frameDurationText,barX+(barWidth-textWidth)/2,barY+barHeight-3);}
return true;}
if(type===Timeline.TimelineFlameChartEntryType.InteractionRecord){var color=Timeline.TimelineUIUtils.interactionPhaseColor((this._entryData[entryIndex]));context.fillStyle=color;context.fillRect(barX,barY,barWidth-1,2);context.fillRect(barX,barY-3,2,3);context.fillRect(barX+barWidth-3,barY-3,2,3);return false;}
if(type===Timeline.TimelineFlameChartEntryType.Event){var event=(this._entryData[entryIndex]);if(event.hasCategory(TimelineModel.TimelineModel.Category.LatencyInfo)){var timeWaitingForMainThread=TimelineModel.TimelineData.forEvent(event).timeWaitingForMainThread;if(timeWaitingForMainThread){context.fillStyle='hsla(0, 70%, 60%, 1)';var width=Math.floor(unclippedBarX-barX+timeWaitingForMainThread*timeToPixels);context.fillRect(barX,barY+barHeight-3,width,2);}}
if(TimelineModel.TimelineData.forEvent(event).warning)
paintWarningDecoration(barX,barWidth-1.5);}
function paintWarningDecoration(x,width){var triangleSize=8;context.save();context.beginPath();context.rect(x,barY,width,barHeight);context.clip();context.beginPath();context.fillStyle='red';context.moveTo(x+width-triangleSize,barY);context.lineTo(x+width,barY);context.lineTo(x+width,barY+triangleSize);context.fill();context.restore();}
return false;}
forceDecoration(entryIndex){var type=this._entryType(entryIndex);return type===Timeline.TimelineFlameChartEntryType.Frame||type===Timeline.TimelineFlameChartEntryType.Event&&!!TimelineModel.TimelineData.forEvent((this._entryData[entryIndex])).warning;}
_appendHeader(title,style,expanded){this._timelineData.groups.push({startLevel:this._currentLevel,name:title,expanded:expanded,style:style});}
_appendEvent(event,level){var index=this._entryData.length;this._entryData.push(event);this._timelineData.entryLevels[index]=level;var duration;if(TimelineModel.TimelineModel.isMarkerEvent(event))
duration=undefined;else
duration=event.duration||Timeline.TimelineFlameChartDataProvider.InstantEventVisibleDurationMs;this._timelineData.entryTotalTimes[index]=duration;this._timelineData.entryStartTimes[index]=event.startTime;}
_appendAsyncEvent(asyncEvent,level){if(SDK.TracingModel.isNestableAsyncPhase(asyncEvent.phase)){this._appendEvent(asyncEvent,level);return;}
var steps=asyncEvent.steps;var eventOffset=steps.length>1&&steps[1].phase===SDK.TracingModel.Phase.AsyncStepPast?1:0;for(var i=0;i<steps.length-1;++i){var index=this._entryData.length;this._entryData.push(steps[i+eventOffset]);var startTime=steps[i].startTime;this._timelineData.entryLevels[index]=level;this._timelineData.entryTotalTimes[index]=steps[i+1].startTime-startTime;this._timelineData.entryStartTimes[index]=startTime;}}
_appendFrame(frame){var index=this._entryData.length;this._entryData.push(frame);this._entryIndexToTitle[index]=Number.millisToString(frame.duration,true);this._timelineData.entryLevels[index]=this._currentLevel;this._timelineData.entryTotalTimes[index]=frame.duration;this._timelineData.entryStartTimes[index]=frame.startTime;}
_appendSegment(segment){var index=this._entryData.length;this._entryData.push((segment.data));this._entryIndexToTitle[index]=(segment.data);this._timelineData.entryLevels[index]=this._currentLevel;this._timelineData.entryTotalTimes[index]=segment.end-segment.begin;this._timelineData.entryStartTimes[index]=segment.begin;}
createSelection(entryIndex){var type=this._entryType(entryIndex);var timelineSelection=null;if(type===Timeline.TimelineFlameChartEntryType.Event){timelineSelection=Timeline.TimelineSelection.fromTraceEvent((this._entryData[entryIndex]));}else if(type===Timeline.TimelineFlameChartEntryType.Frame){timelineSelection=Timeline.TimelineSelection.fromFrame((this._entryData[entryIndex]));}
if(timelineSelection)
this._lastSelection=new Timeline.TimelineFlameChartView.Selection(timelineSelection,entryIndex);return timelineSelection;}
entryIndexForSelection(selection){if(!selection||selection.type()===Timeline.TimelineSelection.Type.Range)
return-1;if(this._lastSelection&&this._lastSelection.timelineSelection.object()===selection.object())
return this._lastSelection.entryIndex;var index=this._entryData.indexOf((selection.object()));if(index!==-1)
this._lastSelection=new Timeline.TimelineFlameChartView.Selection(selection,index);return index;}
selectionForEvent(event){var entryIndex=this._entryData.indexOf(event);return this.createSelection(entryIndex);}
_isVisible(event){return this._filters.every(function(filter){return filter.accept(event);});}};Timeline.TimelineFlameChartDataProvider.InstantEventVisibleDurationMs=0.001;;Timeline.TimelineFlameChartNetworkDataProvider=class extends Timeline.TimelineFlameChartDataProviderBase{constructor(model){super();this._model=model;this._timelineData=null;var loadingCategory=Timeline.TimelineUIUtils.categories()['loading'];this._waitingColor=loadingCategory.childColor;this._processingColor=loadingCategory.color;this._style={padding:4,height:17,collapsible:true,color:UI.themeSupport.patchColor('#222',UI.ThemeSupport.ColorUsage.Foreground),font:this._font,backgroundColor:UI.themeSupport.patchColor('white',UI.ThemeSupport.ColorUsage.Background),nestingLevel:0,useFirstLineForOverview:false,shareHeaderLine:false};this._group={startLevel:0,name:Common.UIString('Network'),expanded:true,style:this._style};}
timelineData(){if(this._timelineData)
return this._timelineData;this._requests=[];this._timelineData=new UI.FlameChart.TimelineData([],[],[],[]);this._appendTimelineData(this._model.mainThreadEvents());return this._timelineData;}
reset(){super.reset();this._timelineData=null;this._requests=[];}
setWindowTimes(startTime,endTime){this._startTime=startTime;this._endTime=endTime;this._updateTimelineData();}
createSelection(index){if(index===-1)
return null;var request=this._requests[index];this._lastSelection=new Timeline.TimelineFlameChartView.Selection(Timeline.TimelineSelection.fromNetworkRequest(request),index);return this._lastSelection.timelineSelection;}
entryIndexForSelection(selection){if(!selection)
return-1;if(this._lastSelection&&this._lastSelection.timelineSelection.object()===selection.object())
return this._lastSelection.entryIndex;if(selection.type()!==Timeline.TimelineSelection.Type.NetworkRequest)
return-1;var request=(selection.object());var index=this._requests.indexOf(request);if(index!==-1){this._lastSelection=new Timeline.TimelineFlameChartView.Selection(Timeline.TimelineSelection.fromNetworkRequest(request),index);}
return index;}
entryColor(index){var request=(this._requests[index]);var category=Timeline.TimelineUIUtils.networkRequestCategory(request);return Timeline.TimelineUIUtils.networkCategoryColor(category);}
entryTitle(index){var request=(this._requests[index]);return request.url||null;}
decorateEntry(index,context,text,barX,barY,barWidth,barHeight,unclippedBarX,timeToPixelRatio){const request=(this._requests[index]);if(!request.timing)
return false;function timeToPixel(time){return Math.floor(unclippedBarX+(time-startTime)*timeToPixelRatio);}
const minBarWidthPx=2;const startTime=request.startTime;const endTime=request.endTime;const requestTime=request.timing.requestTime*1000;const sendStart=Math.max(timeToPixel(requestTime+request.timing.sendStart),unclippedBarX);const headersEnd=Math.max(timeToPixel(requestTime+request.timing.receiveHeadersEnd),sendStart);const finish=Math.max(timeToPixel(request.finishTime||endTime),headersEnd+minBarWidthPx);const end=Math.max(timeToPixel(endTime),finish);context.fillStyle='hsla(0, 100%, 100%, 0.8)';context.fillRect(sendStart+0.5,barY+0.5,headersEnd-sendStart-0.5,barHeight-2);context.fillStyle=UI.themeSupport.patchColor('white',UI.ThemeSupport.ColorUsage.Background);context.fillRect(barX,barY-0.5,sendStart-barX,barHeight);context.fillRect(finish,barY-0.5,barX+barWidth-finish,barHeight);function drawTick(begin,end,y){const tickHeightPx=6;context.moveTo(begin,y-tickHeightPx/2);context.lineTo(begin,y+tickHeightPx/2);context.moveTo(begin,y);context.lineTo(end,y);}
context.lineWidth=1;context.strokeStyle='#ccc';const lineY=Math.floor(barY+barHeight/2)+0.5;const leftTick=Math.floor(unclippedBarX)+0.5;const rightTick=end-0.5;drawTick(leftTick,sendStart,lineY);drawTick(rightTick,finish,lineY);context.stroke();if(typeof request.priority==='string'){const color=this._colorForPriority(request.priority);if(color){context.fillStyle=color;context.fillRect(sendStart+0.5,barY+0.5,3.5,3.5);}}
const textStart=Math.max(sendStart,0);const textWidth=finish-textStart;const minTextWidthPx=20;const textPadding=6;if(textWidth>=minTextWidthPx){const text=this.entryTitle(index);if(text&&text.length){context.fillStyle='#333';const trimmedText=UI.trimTextMiddle(context,text,textWidth-2*textPadding);const textBaseHeight=barHeight-this.textBaseline();context.fillText(trimmedText,textStart+textPadding,barY+textBaseHeight);}}
return true;}
forceDecoration(index){return true;}
prepareHighlightedEntryInfo(index){var maxURLChars=80;var request=(this._requests[index]);if(!request.url)
return null;var element=createElement('div');var root=UI.createShadowRootWithCoreStyles(element,'timeline/timelineFlamechartPopover.css');var contents=root.createChild('div','timeline-flamechart-popover');var duration=request.endTime-request.startTime;if(request.startTime&&isFinite(duration))
contents.createChild('span','timeline-info-network-time').textContent=Number.millisToString(duration);if(typeof request.priority==='string'){var div=contents.createChild('span');div.textContent=Components.uiLabelForPriority((request.priority));div.style.color=this._colorForPriority(request.priority)||'black';}
contents.createChild('span').textContent=request.url.trimMiddle(maxURLChars);return element;}
_colorForPriority(priority){switch((priority)){case Protocol.Network.ResourcePriority.VeryLow:return'#080';case Protocol.Network.ResourcePriority.Low:return'#6c0';case Protocol.Network.ResourcePriority.Medium:return'#fa0';case Protocol.Network.ResourcePriority.High:return'#f60';case Protocol.Network.ResourcePriority.VeryHigh:return'#f00';}
return null;}
_appendTimelineData(events){this._minimumBoundary=this._model.minimumRecordTime();this._maximumBoundary=this._model.maximumRecordTime();this._timeSpan=this._model.isEmpty()?1000:this._maximumBoundary-this._minimumBoundary;this._model.networkRequests().forEach(this._appendEntry.bind(this));this._updateTimelineData();}
_updateTimelineData(){if(!this._timelineData)
return;var lastTimeByLevel=[];var maxLevel=0;for(var i=0;i<this._requests.length;++i){const r=this._requests[i];const visible=r.startTime<this._endTime&&r.endTime>this._startTime;if(!visible){this._timelineData.entryLevels[i]=-1;continue;}
while(lastTimeByLevel.length&&lastTimeByLevel.peekLast()<=r.startTime)
lastTimeByLevel.pop();this._timelineData.entryLevels[i]=lastTimeByLevel.length;lastTimeByLevel.push(r.endTime);maxLevel=Math.max(maxLevel,lastTimeByLevel.length);}
for(var i=0;i<this._requests.length;++i){if(this._timelineData.entryLevels[i]===-1)
this._timelineData.entryLevels[i]=maxLevel;}
this._timelineData=new UI.FlameChart.TimelineData(this._timelineData.entryLevels,this._timelineData.entryTotalTimes,this._timelineData.entryStartTimes,[this._group]);this._currentLevel=maxLevel;}
_appendEntry(request){this._requests.push(request);this._timelineData.entryStartTimes.push(request.startTime);this._timelineData.entryTotalTimes.push(request.endTime-request.startTime);this._timelineData.entryLevels.push(this._requests.length-1);}
preferredHeight(){return this._style.height*(this._group.expanded?Number.constrain(this._currentLevel+1,4,8):2)+2;}};;Timeline.TimelineTreeView=class extends UI.VBox{constructor(){super();this.element.classList.add('timeline-tree-view');}
static eventNameForSorting(event){if(event.name===TimelineModel.TimelineModel.RecordType.JSFrame){var data=event.args['data'];return data['functionName']+'@'+(data['scriptId']||data['url']||'');}
return event.name+':@'+TimelineModel.TimelineProfileTree.eventURL(event);}
_init(model,filters){this._model=model;this._linkifier=new Components.Linkifier();this._filters=filters.slice();var columns=([]);this._populateColumns(columns);var mainView=new UI.VBox();this._populateToolbar(mainView.element);this._dataGrid=new UI.SortableDataGrid(columns);this._dataGrid.addEventListener(UI.DataGrid.Events.SortingChanged,this._sortingChanged,this);this._dataGrid.element.addEventListener('mousemove',this._onMouseMove.bind(this),true);this._dataGrid.setResizeMethod(UI.DataGrid.ResizeMethod.Last);this._dataGrid.setRowContextMenuCallback(this._onContextMenu.bind(this));this._dataGrid.asWidget().show(mainView.element);this._splitWidget=new UI.SplitWidget(true,true,'timelineTreeViewDetailsSplitWidget');this._splitWidget.show(this.element);this._splitWidget.setMainWidget(mainView);this._detailsView=new UI.VBox();this._detailsView.element.classList.add('timeline-details-view','timeline-details-view-body');this._splitWidget.setSidebarWidget(this._detailsView);this._dataGrid.addEventListener(UI.DataGrid.Events.SelectedNode,this._updateDetailsForSelection,this);this._lastSelectedNode;}
updateContents(selection){this.setRange(selection.startTime(),selection.endTime());}
setRange(startTime,endTime){this._startTime=startTime;this._endTime=endTime;this._refreshTree();}
_exposePercentages(){return false;}
_populateToolbar(parent){}
_onHover(node){}
_appendContextMenuItems(contextMenu,node){}
_linkifyLocation(event){var target=this._model.targetByEvent(event);if(!target)
return null;var frame=TimelineModel.TimelineProfileTree.eventStackFrame(event);if(!frame)
return null;return this._linkifier.maybeLinkifyConsoleCallFrame(target,frame);}
selectProfileNode(treeNode,suppressSelectedEvent){var pathToRoot=[];for(var node=treeNode;node;node=node.parent)
pathToRoot.push(node);for(var i=pathToRoot.length-1;i>0;--i){var gridNode=this._dataGridNodeForTreeNode(pathToRoot[i]);if(gridNode&&gridNode.dataGrid)
gridNode.expand();}
var gridNode=this._dataGridNodeForTreeNode(treeNode);if(gridNode.dataGrid){gridNode.reveal();gridNode.select(suppressSelectedEvent);}}
_refreshTree(){this._linkifier.reset();this._dataGrid.rootNode().removeChildren();var tree=this._buildTree();if(!tree.children)
return;var maxSelfTime=0;var maxTotalTime=0;for(var child of tree.children.values()){maxSelfTime=Math.max(maxSelfTime,child.selfTime);maxTotalTime=Math.max(maxTotalTime,child.totalTime);}
for(var child of tree.children.values()){var gridNode=new Timeline.TimelineTreeView.TreeGridNode(child,tree.totalTime,maxSelfTime,maxTotalTime,this);this._dataGrid.insertChild(gridNode);}
this._sortingChanged();this._updateDetailsForSelection();}
_buildTree(){throw new Error('Not Implemented');}
_buildTopDownTree(eventIdCallback){return TimelineModel.TimelineProfileTree.buildTopDown(this._model.mainThreadEvents(),this._filters,this._startTime,this._endTime,eventIdCallback);}
_populateColumns(columns){columns.push({id:'self',title:Common.UIString('Self Time'),width:'110px',fixedWidth:true,sortable:true});columns.push({id:'total',title:Common.UIString('Total Time'),width:'110px',fixedWidth:true,sortable:true});columns.push({id:'activity',title:Common.UIString('Activity'),disclosure:true,sortable:true});}
_sortingChanged(){var columnId=this._dataGrid.sortColumnId();if(!columnId)
return;var sortFunction;switch(columnId){case'startTime':sortFunction=compareStartTime;break;case'self':sortFunction=compareNumericField.bind(null,'selfTime');break;case'total':sortFunction=compareNumericField.bind(null,'totalTime');break;case'activity':sortFunction=compareName;break;default:console.assert(false,'Unknown sort field: '+columnId);return;}
this._dataGrid.sortNodes(sortFunction,!this._dataGrid.isSortOrderAscending());function compareNumericField(field,a,b){var nodeA=(a);var nodeB=(b);return nodeA._profileNode[field]-nodeB._profileNode[field];}
function compareStartTime(a,b){var nodeA=(a);var nodeB=(b);return nodeA._profileNode.event.startTime-nodeB._profileNode.event.startTime;}
function compareName(a,b){var nodeA=(a);var nodeB=(b);var nameA=Timeline.TimelineTreeView.eventNameForSorting(nodeA._profileNode.event);var nameB=Timeline.TimelineTreeView.eventNameForSorting(nodeB._profileNode.event);return nameA.localeCompare(nameB);}}
_updateDetailsForSelection(){var selectedNode=this._dataGrid.selectedNode?(this._dataGrid.selectedNode)._profileNode:null;if(selectedNode===this._lastSelectedNode)
return;this._lastSelectedNode=selectedNode;this._detailsView.detachChildWidgets();this._detailsView.element.removeChildren();if(!selectedNode||!this._showDetailsForNode(selectedNode)){var banner=this._detailsView.element.createChild('div','full-widget-dimmed-banner');banner.createTextChild(Common.UIString('Select item for details.'));}}
_showDetailsForNode(node){return false;}
_onMouseMove(event){var gridNode=event.target&&(event.target instanceof Node)?(this._dataGrid.dataGridNodeFromNode((event.target))):null;var profileNode=gridNode&&gridNode._profileNode;if(profileNode===this._lastHoveredProfileNode)
return;this._lastHoveredProfileNode=profileNode;this._onHover(profileNode);}
_onContextMenu(contextMenu,gridNode){var profileNode=gridNode._profileNode;if(!profileNode)
return;this._appendContextMenuItems(contextMenu,profileNode);}
_dataGridNodeForTreeNode(treeNode){return treeNode[Timeline.TimelineTreeView.TreeGridNode._gridNodeSymbol]||null;}};Timeline.TimelineTreeView.GridNode=class extends UI.SortableDataGridNode{constructor(profileNode,grandTotalTime,maxSelfTime,maxTotalTime,treeView){super(null,false);this._populated=false;this._profileNode=profileNode;this._treeView=treeView;this._grandTotalTime=grandTotalTime;this._maxSelfTime=maxSelfTime;this._maxTotalTime=maxTotalTime;}
createCell(columnId){if(columnId==='activity')
return this._createNameCell(columnId);return this._createValueCell(columnId)||super.createCell(columnId);}
_createNameCell(columnId){const cell=this.createTD(columnId);const container=cell.createChild('div','name-container');const icon=container.createChild('div','activity-icon');const name=container.createChild('div','activity-name');const event=this._profileNode.event;if(this._profileNode.isGroupNode()){const treeView=(this._treeView);const info=treeView._displayInfoForGroupNode(this._profileNode);name.textContent=info.name;icon.style.backgroundColor=info.color;}else if(event){const data=event.args['data'];const deoptReason=data&&data['deoptReason'];if(deoptReason)
container.createChild('div','activity-warning').title=Common.UIString('Not optimized: %s',deoptReason);name.textContent=Timeline.TimelineUIUtils.eventTitle(event);const link=this._treeView._linkifyLocation(event);if(link)
container.createChild('div','activity-link').appendChild(link);icon.style.backgroundColor=Timeline.TimelineUIUtils.eventColor(event);}
return cell;}
_createValueCell(columnId){if(columnId!=='self'&&columnId!=='total'&&columnId!=='startTime')
return null;var showPercents=false;var value;var maxTime;switch(columnId){case'startTime':value=this._profileNode.event.startTime-this._treeView._model.minimumRecordTime();break;case'self':value=this._profileNode.selfTime;maxTime=this._maxSelfTime;showPercents=true;break;case'total':value=this._profileNode.totalTime;maxTime=this._maxTotalTime;showPercents=true;break;default:return null;}
var cell=this.createTD(columnId);cell.className='numeric-column';var textDiv=cell.createChild('div');textDiv.createChild('span').textContent=Common.UIString('%.1f\u2009ms',value);if(showPercents&&this._treeView._exposePercentages()){textDiv.createChild('span','percent-column').textContent=Common.UIString('%.1f\u2009%%',value/this._grandTotalTime*100);}
if(maxTime){textDiv.classList.add('background-percent-bar');cell.createChild('div','background-bar-container').createChild('div','background-bar').style.width=(value*100/maxTime).toFixed(1)+'%';}
return cell;}};Timeline.TimelineTreeView.TreeGridNode=class extends Timeline.TimelineTreeView.GridNode{constructor(profileNode,grandTotalTime,maxSelfTime,maxTotalTime,treeView){super(profileNode,grandTotalTime,maxSelfTime,maxTotalTime,treeView);this.setHasChildren(this._profileNode.children?this._profileNode.children.size>0:false);profileNode[Timeline.TimelineTreeView.TreeGridNode._gridNodeSymbol]=this;}
populate(){if(this._populated)
return;this._populated=true;if(!this._profileNode.children)
return;for(var node of this._profileNode.children.values()){var gridNode=new Timeline.TimelineTreeView.TreeGridNode(node,this._grandTotalTime,this._maxSelfTime,this._maxTotalTime,this._treeView);this.insertChildOrdered(gridNode);}}};Timeline.TimelineTreeView.TreeGridNode._gridNodeSymbol=Symbol('treeGridNode');Timeline.AggregatedTimelineTreeView=class extends Timeline.TimelineTreeView{constructor(model,filters){super();this._groupBySetting=Common.settings.createSetting('timelineTreeGroupBy',Timeline.AggregatedTimelineTreeView.GroupBy.None);this._init(model,filters);var nonessentialEvents=[TimelineModel.TimelineModel.RecordType.EventDispatch,TimelineModel.TimelineModel.RecordType.FunctionCall,TimelineModel.TimelineModel.RecordType.TimerFire];this._filters.push(new TimelineModel.ExclusiveNameFilter(nonessentialEvents));this._stackView=new Timeline.TimelineStackView(this);this._stackView.addEventListener(Timeline.TimelineStackView.Events.SelectionChanged,this._onStackViewSelectionChanged,this);}
updateContents(selection){this._updateExtensionResolver();super.updateContents(selection);var rootNode=this._dataGrid.rootNode();if(rootNode.children.length)
rootNode.children[0].revealAndSelect();}
_updateExtensionResolver(){this._executionContextNamesByOrigin=new Map();for(var target of SDK.targetManager.targets()){for(var context of target.runtimeModel.executionContexts())
this._executionContextNamesByOrigin.set(context.origin,context.name);}}
_displayInfoForGroupNode(node){var categories=Timeline.TimelineUIUtils.categories();var color=node.id?Timeline.TimelineUIUtils.eventColor(node.event):categories['other'].color;switch(this._groupBySetting.get()){case Timeline.AggregatedTimelineTreeView.GroupBy.Category:var category=categories[node.id]||categories['other'];return{name:category.title,color:category.color};case Timeline.AggregatedTimelineTreeView.GroupBy.Domain:case Timeline.AggregatedTimelineTreeView.GroupBy.Subdomain:var name=node.id;if(Timeline.AggregatedTimelineTreeView._isExtensionInternalURL(name))
name=Common.UIString('[Chrome extensions overhead]');else if(name.startsWith('chrome-extension'))
name=this._executionContextNamesByOrigin.get(name)||name;return{name:name||Common.UIString('unattributed'),color:color};case Timeline.AggregatedTimelineTreeView.GroupBy.EventName:var name=node.event.name===TimelineModel.TimelineModel.RecordType.JSFrame?Common.UIString('JavaScript'):Timeline.TimelineUIUtils.eventTitle(node.event);return{name:name,color:node.event.name===TimelineModel.TimelineModel.RecordType.JSFrame?Timeline.TimelineUIUtils.eventStyle(node.event).category.color:color};case Timeline.AggregatedTimelineTreeView.GroupBy.URL:break;case Timeline.AggregatedTimelineTreeView.GroupBy.Frame:var frame=this._model.pageFrameById(node.id);var frameName=frame?Timeline.TimelineUIUtils.displayNameForFrame(frame,80):Common.UIString('Page');return{name:frameName,color:color};default:console.assert(false,'Unexpected aggregation type');}
return{name:node.id||Common.UIString('unattributed'),color:color};}
_populateToolbar(parent){var panelToolbar=new UI.Toolbar('',parent);this._groupByCombobox=new UI.ToolbarComboBox(this._onGroupByChanged.bind(this));function addGroupingOption(name,id){var option=this._groupByCombobox.createOption(name,'',id);this._groupByCombobox.addOption(option);if(id===this._groupBySetting.get())
this._groupByCombobox.select(option);}
const groupBy=Timeline.AggregatedTimelineTreeView.GroupBy;addGroupingOption.call(this,Common.UIString('No Grouping'),groupBy.None);addGroupingOption.call(this,Common.UIString('Group by Activity'),groupBy.EventName);addGroupingOption.call(this,Common.UIString('Group by Category'),groupBy.Category);addGroupingOption.call(this,Common.UIString('Group by Domain'),groupBy.Domain);addGroupingOption.call(this,Common.UIString('Group by Subdomain'),groupBy.Subdomain);addGroupingOption.call(this,Common.UIString('Group by URL'),groupBy.URL);addGroupingOption.call(this,Common.UIString('Group by Frame'),groupBy.Frame);panelToolbar.appendToolbarItem(this._groupByCombobox);}
_buildHeaviestStack(treeNode){console.assert(!!treeNode.parent,'Attempt to build stack for tree root');var result=[];for(var node=treeNode;node&&node.parent;node=node.parent)
result.push(node);result=result.reverse();for(node=treeNode;node&&node.children&&node.children.size;){var children=Array.from(node.children.values());node=children.reduce((a,b)=>a.totalTime>b.totalTime?a:b);result.push(node);}
return result;}
_exposePercentages(){return true;}
_onGroupByChanged(){this._groupBySetting.set(this._groupByCombobox.selectedOption().value);this._refreshTree();}
_onStackViewSelectionChanged(){var treeNode=this._stackView.selectedTreeNode();if(treeNode)
this.selectProfileNode(treeNode,true);}
_showDetailsForNode(node){var stack=this._buildHeaviestStack(node);this._stackView.setStack(stack,node);this._stackView.show(this._detailsView.element);return true;}
_groupingFunction(groupBy){function groupByURL(event){return TimelineModel.TimelineProfileTree.eventURL(event)||'';}
function groupByDomain(groupSubdomains,event){var url=TimelineModel.TimelineProfileTree.eventURL(event)||'';if(Timeline.AggregatedTimelineTreeView._isExtensionInternalURL(url))
return Timeline.AggregatedTimelineTreeView._extensionInternalPrefix;var parsedURL=url.asParsedURL();if(!parsedURL)
return'';if(parsedURL.scheme==='chrome-extension')
return parsedURL.scheme+'://'+parsedURL.host;if(!groupSubdomains)
return parsedURL.host;if(/^[.0-9]+$/.test(parsedURL.host))
return parsedURL.host;var domainMatch=/([^.]*\.)?[^.]*$/.exec(parsedURL.host);return domainMatch&&domainMatch[0]||'';}
switch(groupBy){case Timeline.AggregatedTimelineTreeView.GroupBy.None:return()=>Symbol('uniqueGroupId');case Timeline.AggregatedTimelineTreeView.GroupBy.EventName:return event=>Timeline.TimelineUIUtils.eventStyle(event).title;case Timeline.AggregatedTimelineTreeView.GroupBy.Category:return event=>Timeline.TimelineUIUtils.eventStyle(event).category.name;case Timeline.AggregatedTimelineTreeView.GroupBy.Subdomain:return groupByDomain.bind(null,false);case Timeline.AggregatedTimelineTreeView.GroupBy.Domain:return groupByDomain.bind(null,true);case Timeline.AggregatedTimelineTreeView.GroupBy.URL:return groupByURL;case Timeline.AggregatedTimelineTreeView.GroupBy.Frame:return event=>TimelineModel.TimelineData.forEvent(event).frameId;default:console.assert(false,`Unexpected aggregation setting: ${groupBy}`);return()=>Symbol('uniqueGroupId');}}
_appendContextMenuItems(contextMenu,node){if(this._groupBySetting.get()!==Timeline.AggregatedTimelineTreeView.GroupBy.Frame)
return;if(!node.isGroupNode())
return;var frame=this._model.pageFrameById(node.id);if(!frame||!frame.ownerNode)
return;contextMenu.appendApplicableItems(frame.ownerNode);}
static _isExtensionInternalURL(url){return url.startsWith(Timeline.AggregatedTimelineTreeView._extensionInternalPrefix);}};Timeline.AggregatedTimelineTreeView._extensionInternalPrefix='extensions::';Timeline.AggregatedTimelineTreeView.GroupBy={None:'None',EventName:'EventName',Category:'Category',Domain:'Domain',Subdomain:'Subdomain',URL:'URL',Frame:'Frame'};Timeline.CallTreeTimelineTreeView=class extends Timeline.AggregatedTimelineTreeView{constructor(model,filters){super(model,filters);this._dataGrid.markColumnAsSortedBy('total',UI.DataGrid.Order.Descending);}
_buildTree(){var grouping=this._groupBySetting.get();var topDown=this._buildTopDownTree(this._groupingFunction(grouping));if(grouping===Timeline.AggregatedTimelineTreeView.GroupBy.None)
return topDown;return new TimelineModel.TimelineAggregator().performGrouping(topDown);}};Timeline.BottomUpTimelineTreeView=class extends Timeline.AggregatedTimelineTreeView{constructor(model,filters){super(model,filters);this._dataGrid.markColumnAsSortedBy('self',UI.DataGrid.Order.Descending);}
_buildTree(){var topDown=this._buildTopDownTree(this._groupingFunction(this._groupBySetting.get()));return TimelineModel.TimelineProfileTree.buildBottomUp(topDown);}};Timeline.EventsTimelineTreeView=class extends Timeline.TimelineTreeView{constructor(model,filters,delegate){super();this._filtersControl=new Timeline.TimelineFilters();this._filtersControl.addEventListener(Timeline.TimelineFilters.Events.FilterChanged,this._onFilterChanged,this);this._init(model,filters);this._delegate=delegate;this._filters.push.apply(this._filters,this._filtersControl.filters());this._dataGrid.markColumnAsSortedBy('startTime',UI.DataGrid.Order.Ascending);}
updateContents(selection){super.updateContents(selection);if(selection.type()===Timeline.TimelineSelection.Type.TraceEvent){var event=(selection.object());this._selectEvent(event,true);}}
_buildTree(){this._currentTree=this._buildTopDownTree();return this._currentTree;}
_onFilterChanged(){var selectedEvent=this._lastSelectedNode&&this._lastSelectedNode.event;this._refreshTree();if(selectedEvent)
this._selectEvent(selectedEvent,false);}
_findNodeWithEvent(event){var iterators=[this._currentTree.children.values()];while(iterators.length){var iterator=iterators.peekLast().next();if(iterator.done){iterators.pop();continue;}
var child=(iterator.value);if(child.event===event)
return child;if(child.children)
iterators.push(child.children.values());}
return null;}
_selectEvent(event,expand){var node=this._findNodeWithEvent(event);if(!node)
return;this.selectProfileNode(node,false);if(expand)
this._dataGridNodeForTreeNode(node).expand();}
_populateColumns(columns){columns.push({id:'startTime',title:Common.UIString('Start Time'),width:'110px',fixedWidth:true,sortable:true});super._populateColumns(columns);}
_populateToolbar(parent){var filtersWidget=this._filtersControl.filtersWidget();filtersWidget.forceShowFilterBar();filtersWidget.show(parent);}
_showDetailsForNode(node){var traceEvent=node.event;if(!traceEvent)
return false;Timeline.TimelineUIUtils.buildTraceEventDetails(traceEvent,this._model,this._linkifier,false,showDetails.bind(this));return true;function showDetails(fragment){this._detailsView.element.appendChild(fragment);}}
_onHover(node){this._delegate.highlightEvent(node&&node.event);}};Timeline.TimelineStackView=class extends UI.VBox{constructor(treeView){super();var header=this.element.createChild('div','timeline-stack-view-header');header.textContent=Common.UIString('Heaviest stack');this._treeView=treeView;var columns=([{id:'total',title:Common.UIString('Total Time'),fixedWidth:true,width:'110px'},{id:'activity',title:Common.UIString('Activity')}]);this._dataGrid=new UI.ViewportDataGrid(columns);this._dataGrid.setResizeMethod(UI.DataGrid.ResizeMethod.Last);this._dataGrid.addEventListener(UI.DataGrid.Events.SelectedNode,this._onSelectionChanged,this);this._dataGrid.asWidget().show(this.element);}
setStack(stack,selectedNode){var rootNode=this._dataGrid.rootNode();rootNode.removeChildren();var nodeToReveal=null;var totalTime=Math.max.apply(Math,stack.map(node=>node.totalTime));for(var node of stack){var gridNode=new Timeline.TimelineTreeView.GridNode(node,totalTime,totalTime,totalTime,this._treeView);rootNode.appendChild(gridNode);if(node===selectedNode)
nodeToReveal=gridNode;}
nodeToReveal.revealAndSelect();}
selectedTreeNode(){var selectedNode=this._dataGrid.selectedNode;return selectedNode&&(selectedNode)._profileNode;}
_onSelectionChanged(){this.dispatchEventToListeners(Timeline.TimelineStackView.Events.SelectionChanged);}};Timeline.TimelineStackView.Events={SelectionChanged:Symbol('SelectionChanged')};;Timeline.TimelineUIUtils=class{static _initEventStyles(){if(Timeline.TimelineUIUtils._eventStylesMap)
return Timeline.TimelineUIUtils._eventStylesMap;var recordTypes=TimelineModel.TimelineModel.RecordType;var categories=Timeline.TimelineUIUtils.categories();var eventStyles={};eventStyles[recordTypes.Task]=new Timeline.TimelineRecordStyle(Common.UIString('Task'),categories['other']);eventStyles[recordTypes.Program]=new Timeline.TimelineRecordStyle(Common.UIString('Other'),categories['other']);eventStyles[recordTypes.Animation]=new Timeline.TimelineRecordStyle(Common.UIString('Animation'),categories['rendering']);eventStyles[recordTypes.EventDispatch]=new Timeline.TimelineRecordStyle(Common.UIString('Event'),categories['scripting']);eventStyles[recordTypes.RequestMainThreadFrame]=new Timeline.TimelineRecordStyle(Common.UIString('Request Main Thread Frame'),categories['rendering'],true);eventStyles[recordTypes.BeginFrame]=new Timeline.TimelineRecordStyle(Common.UIString('Frame Start'),categories['rendering'],true);eventStyles[recordTypes.BeginMainThreadFrame]=new Timeline.TimelineRecordStyle(Common.UIString('Frame Start (main thread)'),categories['rendering'],true);eventStyles[recordTypes.DrawFrame]=new Timeline.TimelineRecordStyle(Common.UIString('Draw Frame'),categories['rendering'],true);eventStyles[recordTypes.HitTest]=new Timeline.TimelineRecordStyle(Common.UIString('Hit Test'),categories['rendering']);eventStyles[recordTypes.ScheduleStyleRecalculation]=new Timeline.TimelineRecordStyle(Common.UIString('Schedule Style Recalculation'),categories['rendering'],true);eventStyles[recordTypes.RecalculateStyles]=new Timeline.TimelineRecordStyle(Common.UIString('Recalculate Style'),categories['rendering']);eventStyles[recordTypes.UpdateLayoutTree]=new Timeline.TimelineRecordStyle(Common.UIString('Recalculate Style'),categories['rendering']);eventStyles[recordTypes.InvalidateLayout]=new Timeline.TimelineRecordStyle(Common.UIString('Invalidate Layout'),categories['rendering'],true);eventStyles[recordTypes.Layout]=new Timeline.TimelineRecordStyle(Common.UIString('Layout'),categories['rendering']);eventStyles[recordTypes.PaintSetup]=new Timeline.TimelineRecordStyle(Common.UIString('Paint Setup'),categories['painting']);eventStyles[recordTypes.PaintImage]=new Timeline.TimelineRecordStyle(Common.UIString('Paint Image'),categories['painting'],true);eventStyles[recordTypes.UpdateLayer]=new Timeline.TimelineRecordStyle(Common.UIString('Update Layer'),categories['painting'],true);eventStyles[recordTypes.UpdateLayerTree]=new Timeline.TimelineRecordStyle(Common.UIString('Update Layer Tree'),categories['rendering']);eventStyles[recordTypes.Paint]=new Timeline.TimelineRecordStyle(Common.UIString('Paint'),categories['painting']);eventStyles[recordTypes.RasterTask]=new Timeline.TimelineRecordStyle(Common.UIString('Rasterize Paint'),categories['painting']);eventStyles[recordTypes.ScrollLayer]=new Timeline.TimelineRecordStyle(Common.UIString('Scroll'),categories['rendering']);eventStyles[recordTypes.CompositeLayers]=new Timeline.TimelineRecordStyle(Common.UIString('Composite Layers'),categories['painting']);eventStyles[recordTypes.ParseHTML]=new Timeline.TimelineRecordStyle(Common.UIString('Parse HTML'),categories['loading']);eventStyles[recordTypes.ParseAuthorStyleSheet]=new Timeline.TimelineRecordStyle(Common.UIString('Parse Stylesheet'),categories['loading']);eventStyles[recordTypes.TimerInstall]=new Timeline.TimelineRecordStyle(Common.UIString('Install Timer'),categories['scripting']);eventStyles[recordTypes.TimerRemove]=new Timeline.TimelineRecordStyle(Common.UIString('Remove Timer'),categories['scripting']);eventStyles[recordTypes.TimerFire]=new Timeline.TimelineRecordStyle(Common.UIString('Timer Fired'),categories['scripting']);eventStyles[recordTypes.XHRReadyStateChange]=new Timeline.TimelineRecordStyle(Common.UIString('XHR Ready State Change'),categories['scripting']);eventStyles[recordTypes.XHRLoad]=new Timeline.TimelineRecordStyle(Common.UIString('XHR Load'),categories['scripting']);eventStyles[recordTypes.CompileScript]=new Timeline.TimelineRecordStyle(Common.UIString('Compile Script'),categories['scripting']);eventStyles[recordTypes.EvaluateScript]=new Timeline.TimelineRecordStyle(Common.UIString('Evaluate Script'),categories['scripting']);eventStyles[recordTypes.ParseScriptOnBackground]=new Timeline.TimelineRecordStyle(Common.UIString('Parse Script'),categories['scripting']);eventStyles[recordTypes.MarkLoad]=new Timeline.TimelineRecordStyle(Common.UIString('Load event'),categories['scripting'],true);eventStyles[recordTypes.MarkDOMContent]=new Timeline.TimelineRecordStyle(Common.UIString('DOMContentLoaded event'),categories['scripting'],true);eventStyles[recordTypes.MarkFirstPaint]=new Timeline.TimelineRecordStyle(Common.UIString('First paint'),categories['painting'],true);eventStyles[recordTypes.TimeStamp]=new Timeline.TimelineRecordStyle(Common.UIString('Timestamp'),categories['scripting']);eventStyles[recordTypes.ConsoleTime]=new Timeline.TimelineRecordStyle(Common.UIString('Console Time'),categories['scripting']);eventStyles[recordTypes.UserTiming]=new Timeline.TimelineRecordStyle(Common.UIString('User Timing'),categories['scripting']);eventStyles[recordTypes.ResourceSendRequest]=new Timeline.TimelineRecordStyle(Common.UIString('Send Request'),categories['loading']);eventStyles[recordTypes.ResourceReceiveResponse]=new Timeline.TimelineRecordStyle(Common.UIString('Receive Response'),categories['loading']);eventStyles[recordTypes.ResourceFinish]=new Timeline.TimelineRecordStyle(Common.UIString('Finish Loading'),categories['loading']);eventStyles[recordTypes.ResourceReceivedData]=new Timeline.TimelineRecordStyle(Common.UIString('Receive Data'),categories['loading']);eventStyles[recordTypes.RunMicrotasks]=new Timeline.TimelineRecordStyle(Common.UIString('Run Microtasks'),categories['scripting']);eventStyles[recordTypes.FunctionCall]=new Timeline.TimelineRecordStyle(Common.UIString('Function Call'),categories['scripting']);eventStyles[recordTypes.GCEvent]=new Timeline.TimelineRecordStyle(Common.UIString('GC Event'),categories['scripting']);eventStyles[recordTypes.MajorGC]=new Timeline.TimelineRecordStyle(Common.UIString('Major GC'),categories['scripting']);eventStyles[recordTypes.MinorGC]=new Timeline.TimelineRecordStyle(Common.UIString('Minor GC'),categories['scripting']);eventStyles[recordTypes.JSFrame]=new Timeline.TimelineRecordStyle(Common.UIString('JS Frame'),categories['scripting']);eventStyles[recordTypes.RequestAnimationFrame]=new Timeline.TimelineRecordStyle(Common.UIString('Request Animation Frame'),categories['scripting']);eventStyles[recordTypes.CancelAnimationFrame]=new Timeline.TimelineRecordStyle(Common.UIString('Cancel Animation Frame'),categories['scripting']);eventStyles[recordTypes.FireAnimationFrame]=new Timeline.TimelineRecordStyle(Common.UIString('Animation Frame Fired'),categories['scripting']);eventStyles[recordTypes.RequestIdleCallback]=new Timeline.TimelineRecordStyle(Common.UIString('Request Idle Callback'),categories['scripting']);eventStyles[recordTypes.CancelIdleCallback]=new Timeline.TimelineRecordStyle(Common.UIString('Cancel Idle Callback'),categories['scripting']);eventStyles[recordTypes.FireIdleCallback]=new Timeline.TimelineRecordStyle(Common.UIString('Fire Idle Callback'),categories['scripting']);eventStyles[recordTypes.WebSocketCreate]=new Timeline.TimelineRecordStyle(Common.UIString('Create WebSocket'),categories['scripting']);eventStyles[recordTypes.WebSocketSendHandshakeRequest]=new Timeline.TimelineRecordStyle(Common.UIString('Send WebSocket Handshake'),categories['scripting']);eventStyles[recordTypes.WebSocketReceiveHandshakeResponse]=new Timeline.TimelineRecordStyle(Common.UIString('Receive WebSocket Handshake'),categories['scripting']);eventStyles[recordTypes.WebSocketDestroy]=new Timeline.TimelineRecordStyle(Common.UIString('Destroy WebSocket'),categories['scripting']);eventStyles[recordTypes.EmbedderCallback]=new Timeline.TimelineRecordStyle(Common.UIString('Embedder Callback'),categories['scripting']);eventStyles[recordTypes.DecodeImage]=new Timeline.TimelineRecordStyle(Common.UIString('Image Decode'),categories['painting']);eventStyles[recordTypes.ResizeImage]=new Timeline.TimelineRecordStyle(Common.UIString('Image Resize'),categories['painting']);eventStyles[recordTypes.GPUTask]=new Timeline.TimelineRecordStyle(Common.UIString('GPU'),categories['gpu']);eventStyles[recordTypes.LatencyInfo]=new Timeline.TimelineRecordStyle(Common.UIString('Input Latency'),categories['scripting']);eventStyles[recordTypes.GCIdleLazySweep]=new Timeline.TimelineRecordStyle(Common.UIString('DOM GC'),categories['scripting']);eventStyles[recordTypes.GCCompleteSweep]=new Timeline.TimelineRecordStyle(Common.UIString('DOM GC'),categories['scripting']);eventStyles[recordTypes.GCCollectGarbage]=new Timeline.TimelineRecordStyle(Common.UIString('DOM GC'),categories['scripting']);Timeline.TimelineUIUtils._eventStylesMap=eventStyles;return eventStyles;}
static inputEventDisplayName(inputEventType){if(!Timeline.TimelineUIUtils._inputEventToDisplayName){var inputEvent=TimelineModel.TimelineIRModel.InputEvents;Timeline.TimelineUIUtils._inputEventToDisplayName=new Map([[inputEvent.Char,Common.UIString('Key Character')],[inputEvent.KeyDown,Common.UIString('Key Down')],[inputEvent.KeyDownRaw,Common.UIString('Key Down')],[inputEvent.KeyUp,Common.UIString('Key Up')],[inputEvent.Click,Common.UIString('Click')],[inputEvent.ContextMenu,Common.UIString('Context Menu')],[inputEvent.MouseDown,Common.UIString('Mouse Down')],[inputEvent.MouseMove,Common.UIString('Mouse Move')],[inputEvent.MouseUp,Common.UIString('Mouse Up')],[inputEvent.MouseWheel,Common.UIString('Mouse Wheel')],[inputEvent.ScrollBegin,Common.UIString('Scroll Begin')],[inputEvent.ScrollEnd,Common.UIString('Scroll End')],[inputEvent.ScrollUpdate,Common.UIString('Scroll Update')],[inputEvent.FlingStart,Common.UIString('Fling Start')],[inputEvent.FlingCancel,Common.UIString('Fling Halt')],[inputEvent.Tap,Common.UIString('Tap')],[inputEvent.TapCancel,Common.UIString('Tap Halt')],[inputEvent.ShowPress,Common.UIString('Tap Begin')],[inputEvent.TapDown,Common.UIString('Tap Down')],[inputEvent.TouchCancel,Common.UIString('Touch Cancel')],[inputEvent.TouchEnd,Common.UIString('Touch End')],[inputEvent.TouchMove,Common.UIString('Touch Move')],[inputEvent.TouchStart,Common.UIString('Touch Start')],[inputEvent.PinchBegin,Common.UIString('Pinch Begin')],[inputEvent.PinchEnd,Common.UIString('Pinch End')],[inputEvent.PinchUpdate,Common.UIString('Pinch Update')]]);}
return Timeline.TimelineUIUtils._inputEventToDisplayName.get(inputEventType)||null;}
static frameDisplayName(frame){if(!TimelineModel.TimelineJSProfileProcessor.isNativeRuntimeFrame(frame))
return UI.beautifyFunctionName(frame.functionName);const nativeGroup=TimelineModel.TimelineJSProfileProcessor.nativeGroup(frame.functionName);const groups=TimelineModel.TimelineJSProfileProcessor.NativeGroups;switch(nativeGroup){case groups.Compile:return Common.UIString('Compile');case groups.Parse:return Common.UIString('Parse');}
return frame.functionName;}
static testContentMatching(traceEvent,regExp){var title=Timeline.TimelineUIUtils.eventStyle(traceEvent).title;var tokens=[title];var url=TimelineModel.TimelineData.forEvent(traceEvent).url;if(url)
tokens.push(url);for(var argName in traceEvent.args){var argValue=traceEvent.args[argName];for(var key in argValue)
tokens.push(argValue[key]);}
return regExp.test(tokens.join('|'));}
static categoryForRecord(record){return Timeline.TimelineUIUtils.eventStyle(record.traceEvent()).category;}
static eventStyle(event){var eventStyles=Timeline.TimelineUIUtils._initEventStyles();if(event.hasCategory(TimelineModel.TimelineModel.Category.Console)||event.hasCategory(TimelineModel.TimelineModel.Category.UserTiming))
return{title:event.name,category:Timeline.TimelineUIUtils.categories()['scripting']};if(event.hasCategory(TimelineModel.TimelineModel.Category.LatencyInfo)){var prefix='InputLatency::';var inputEventType=event.name.startsWith(prefix)?event.name.substr(prefix.length):event.name;var displayName=Timeline.TimelineUIUtils.inputEventDisplayName((inputEventType));return{title:displayName||inputEventType,category:Timeline.TimelineUIUtils.categories()['scripting']};}
var result=eventStyles[event.name];if(!result){result=new Timeline.TimelineRecordStyle(event.name,Timeline.TimelineUIUtils.categories()['other'],true);eventStyles[event.name]=result;}
return result;}
static eventColor(event){if(event.name===TimelineModel.TimelineModel.RecordType.JSFrame){var frame=event.args['data'];if(Timeline.TimelineUIUtils.isUserFrame(frame))
return Timeline.TimelineUIUtils.colorForURL(frame.url);}
return Timeline.TimelineUIUtils.eventStyle(event).category.color;}
static eventTitle(event){const recordType=TimelineModel.TimelineModel.RecordType;const eventData=event.args['data'];if(event.name===recordType.JSFrame)
return Timeline.TimelineUIUtils.frameDisplayName(eventData);const title=Timeline.TimelineUIUtils.eventStyle(event).title;if(event.hasCategory(TimelineModel.TimelineModel.Category.Console))
return title;if(event.name===recordType.TimeStamp)
return Common.UIString('%s: %s',title,eventData['message']);if(event.name===recordType.Animation&&eventData&&eventData['name'])
return Common.UIString('%s: %s',title,eventData['name']);return title;}
static _interactionPhaseStyles(){var map=Timeline.TimelineUIUtils._interactionPhaseStylesMap;if(!map){map=new Map([[TimelineModel.TimelineIRModel.Phases.Idle,{color:'white',label:'Idle'}],[TimelineModel.TimelineIRModel.Phases.Response,{color:'hsl(43, 83%, 64%)',label:Common.UIString('Response')}],[TimelineModel.TimelineIRModel.Phases.Scroll,{color:'hsl(256, 67%, 70%)',label:Common.UIString('Scroll')}],[TimelineModel.TimelineIRModel.Phases.Fling,{color:'hsl(256, 67%, 70%)',label:Common.UIString('Fling')}],[TimelineModel.TimelineIRModel.Phases.Drag,{color:'hsl(256, 67%, 70%)',label:Common.UIString('Drag')}],[TimelineModel.TimelineIRModel.Phases.Animation,{color:'hsl(256, 67%, 70%)',label:Common.UIString('Animation')}],[TimelineModel.TimelineIRModel.Phases.Uncategorized,{color:'hsl(0, 0%, 87%)',label:Common.UIString('Uncategorized')}]]);Timeline.TimelineUIUtils._interactionPhaseStylesMap=map;}
return map;}
static interactionPhaseColor(phase){return Timeline.TimelineUIUtils._interactionPhaseStyles().get(phase).color;}
static interactionPhaseLabel(phase){return Timeline.TimelineUIUtils._interactionPhaseStyles().get(phase).label;}
static isUserFrame(frame){return frame.scriptId!=='0'&&!(frame.url&&frame.url.startsWith('native '));}
static networkRequestCategory(request){var categories=Timeline.TimelineUIUtils.NetworkCategory;switch(request.mimeType){case'text/html':return categories.HTML;case'application/javascript':case'application/x-javascript':case'text/javascript':return categories.Script;case'text/css':return categories.Style;case'audio/ogg':case'image/gif':case'image/jpeg':case'image/png':case'image/svg+xml':case'image/webp':case'image/x-icon':case'font/opentype':case'font/woff2':case'application/font-woff':return categories.Media;default:return categories.Other;}}
static networkCategoryColor(category){var categories=Timeline.TimelineUIUtils.NetworkCategory;switch(category){case categories.HTML:return'hsl(214, 67%, 66%)';case categories.Script:return'hsl(43, 83%, 64%)';case categories.Style:return'hsl(256, 67%, 70%)';case categories.Media:return'hsl(109, 33%, 55%)';default:return'hsl(0, 0%, 70%)';}}
static buildDetailsTextForTraceEvent(event,target){var recordType=TimelineModel.TimelineModel.RecordType;var detailsText;var eventData=event.args['data'];switch(event.name){case recordType.GCEvent:case recordType.MajorGC:case recordType.MinorGC:var delta=event.args['usedHeapSizeBefore']-event.args['usedHeapSizeAfter'];detailsText=Common.UIString('%s collected',Number.bytesToString(delta));break;case recordType.FunctionCall:if(eventData)
detailsText=linkifyLocationAsText(eventData['scriptId'],eventData['lineNumber'],0);break;case recordType.JSFrame:detailsText=Timeline.TimelineUIUtils.frameDisplayName(eventData);break;case recordType.EventDispatch:detailsText=eventData?eventData['type']:null;break;case recordType.Paint:var width=Timeline.TimelineUIUtils.quadWidth(eventData.clip);var height=Timeline.TimelineUIUtils.quadHeight(eventData.clip);if(width&&height)
detailsText=Common.UIString('%d\u2009\u00d7\u2009%d',width,height);break;case recordType.ParseHTML:var endLine=event.args['endData']&&event.args['endData']['endLine'];var url=Bindings.displayNameForURL(event.args['beginData']['url']);detailsText=Common.UIString('%s [%s\u2026%s]',url,event.args['beginData']['startLine']+1,endLine>=0?endLine+1:'');break;case recordType.CompileScript:case recordType.EvaluateScript:var url=eventData&&eventData['url'];if(url)
detailsText=Bindings.displayNameForURL(url)+':'+(eventData['lineNumber']+1);break;case recordType.ParseScriptOnBackground:case recordType.XHRReadyStateChange:case recordType.XHRLoad:var url=eventData['url'];if(url)
detailsText=Bindings.displayNameForURL(url);break;case recordType.TimeStamp:detailsText=eventData['message'];break;case recordType.WebSocketCreate:case recordType.WebSocketSendHandshakeRequest:case recordType.WebSocketReceiveHandshakeResponse:case recordType.WebSocketDestroy:case recordType.ResourceSendRequest:case recordType.ResourceReceivedData:case recordType.ResourceReceiveResponse:case recordType.ResourceFinish:case recordType.PaintImage:case recordType.DecodeImage:case recordType.ResizeImage:case recordType.DecodeLazyPixelRef:var url=TimelineModel.TimelineData.forEvent(event).url;if(url)
detailsText=Bindings.displayNameForURL(url);break;case recordType.EmbedderCallback:detailsText=eventData['callbackName'];break;case recordType.Animation:detailsText=eventData&&eventData['name'];break;case recordType.GCIdleLazySweep:detailsText=Common.UIString('idle sweep');break;case recordType.GCCompleteSweep:detailsText=Common.UIString('complete sweep');break;case recordType.GCCollectGarbage:detailsText=Common.UIString('collect');break;default:if(event.hasCategory(TimelineModel.TimelineModel.Category.Console))
detailsText=null;else
detailsText=linkifyTopCallFrameAsText();break;}
return detailsText;function linkifyLocationAsText(scriptId,lineNumber,columnNumber){var debuggerModel=SDK.DebuggerModel.fromTarget(target);if(!target||target.isDisposed()||!scriptId||!debuggerModel)
return null;var rawLocation=debuggerModel.createRawLocationByScriptId(scriptId,lineNumber,columnNumber);if(!rawLocation)
return null;var uiLocation=Bindings.debuggerWorkspaceBinding.rawLocationToUILocation(rawLocation);return uiLocation.linkText();}
function linkifyTopCallFrameAsText(){var frame=TimelineModel.TimelineData.forEvent(event).topFrame();if(!frame)
return null;var text=linkifyLocationAsText(frame.scriptId,frame.lineNumber,frame.columnNumber);if(!text){text=frame.url;if(typeof frame.lineNumber==='number')
text+=':'+(frame.lineNumber+1);}
return text;}}
static buildDetailsNodeForTraceEvent(event,target,linkifier){var recordType=TimelineModel.TimelineModel.RecordType;var details=null;var detailsText;var eventData=event.args['data'];switch(event.name){case recordType.GCEvent:case recordType.MajorGC:case recordType.MinorGC:case recordType.EventDispatch:case recordType.Paint:case recordType.Animation:case recordType.EmbedderCallback:case recordType.ParseHTML:case recordType.WebSocketCreate:case recordType.WebSocketSendHandshakeRequest:case recordType.WebSocketReceiveHandshakeResponse:case recordType.WebSocketDestroy:case recordType.GCIdleLazySweep:case recordType.GCCompleteSweep:case recordType.GCCollectGarbage:detailsText=Timeline.TimelineUIUtils.buildDetailsTextForTraceEvent(event,target);break;case recordType.PaintImage:case recordType.DecodeImage:case recordType.ResizeImage:case recordType.DecodeLazyPixelRef:case recordType.XHRReadyStateChange:case recordType.XHRLoad:case recordType.ResourceSendRequest:case recordType.ResourceReceivedData:case recordType.ResourceReceiveResponse:case recordType.ResourceFinish:var url=TimelineModel.TimelineData.forEvent(event).url;if(url)
details=Components.Linkifier.linkifyURL(url);break;case recordType.FunctionCall:case recordType.JSFrame:details=createElement('span');details.createTextChild(Timeline.TimelineUIUtils.frameDisplayName(eventData));const location=linkifyLocation(eventData['scriptId'],eventData['url'],eventData['lineNumber'],eventData['columnNumber']);if(location){details.createTextChild(' @ ');details.appendChild(location);}
break;case recordType.CompileScript:case recordType.EvaluateScript:var url=eventData['url'];if(url)
details=linkifyLocation('',url,eventData['lineNumber'],0);break;case recordType.ParseScriptOnBackground:var url=eventData['url'];if(url)
details=linkifyLocation('',url,0,0);break;default:if(event.hasCategory(TimelineModel.TimelineModel.Category.Console))
detailsText=null;else
details=linkifyTopCallFrame();break;}
if(!details&&detailsText)
details=createTextNode(detailsText);return details;function linkifyLocation(scriptId,url,lineNumber,columnNumber){return linkifier.linkifyScriptLocation(target,scriptId,url,lineNumber,columnNumber,'timeline-details');}
function linkifyTopCallFrame(){var frame=TimelineModel.TimelineData.forEvent(event).topFrame();return frame?linkifier.maybeLinkifyConsoleCallFrame(target,frame,'timeline-details'):null;}}
static buildTraceEventDetails(event,model,linkifier,detailed,callback){var target=model.targetByEvent(event);if(!target){callbackWrapper();return;}
var relatedNodes=null;var barrier=new CallbackBarrier();if(!event[Timeline.TimelineUIUtils._previewElementSymbol]){var url=TimelineModel.TimelineData.forEvent(event).url;if(url){Components.DOMPresentationUtils.buildImagePreviewContents(target,url,false,barrier.createCallback(saveImage));}else if(TimelineModel.TimelineData.forEvent(event).picture){Timeline.TimelineUIUtils.buildPicturePreviewContent(event,target,barrier.createCallback(saveImage));}}
var nodeIdsToResolve=new Set();var timelineData=TimelineModel.TimelineData.forEvent(event);if(timelineData.backendNodeId)
nodeIdsToResolve.add(timelineData.backendNodeId);var invalidationTrackingEvents=TimelineModel.InvalidationTracker.invalidationEventsFor(event);if(invalidationTrackingEvents)
Timeline.TimelineUIUtils._collectInvalidationNodeIds(nodeIdsToResolve,invalidationTrackingEvents);if(nodeIdsToResolve.size){var domModel=SDK.DOMModel.fromTarget(target);if(domModel)
domModel.pushNodesByBackendIdsToFrontend(nodeIdsToResolve,barrier.createCallback(setRelatedNodeMap));}
barrier.callWhenDone(callbackWrapper);function saveImage(element){event[Timeline.TimelineUIUtils._previewElementSymbol]=element||null;}
function setRelatedNodeMap(nodeMap){relatedNodes=nodeMap;}
function callbackWrapper(){callback(Timeline.TimelineUIUtils._buildTraceEventDetailsSynchronously(event,model,linkifier,detailed,relatedNodes));}}
static _buildTraceEventDetailsSynchronously(event,model,linkifier,detailed,relatedNodesMap){var recordTypes=TimelineModel.TimelineModel.RecordType;var relatedNodeLabel;var contentHelper=new Timeline.TimelineDetailsContentHelper(model.targetByEvent(event),linkifier);contentHelper.addSection(Timeline.TimelineUIUtils.eventTitle(event),Timeline.TimelineUIUtils.eventStyle(event).category);var eventData=event.args['data'];var timelineData=TimelineModel.TimelineData.forEvent(event);var initiator=timelineData.initiator();if(timelineData.warning)
contentHelper.appendWarningRow(event);if(event.name===recordTypes.JSFrame&&eventData['deoptReason'])
contentHelper.appendWarningRow(event,TimelineModel.TimelineModel.WarningType.V8Deopt);if(detailed){contentHelper.appendTextRow(Common.UIString('Self Time'),Number.millisToString(event.selfTime,true));contentHelper.appendTextRow(Common.UIString('Total Time'),Number.millisToString(event.duration||0,true));}
switch(event.name){case recordTypes.GCEvent:case recordTypes.MajorGC:case recordTypes.MinorGC:var delta=event.args['usedHeapSizeBefore']-event.args['usedHeapSizeAfter'];contentHelper.appendTextRow(Common.UIString('Collected'),Number.bytesToString(delta));break;case recordTypes.JSFrame:case recordTypes.FunctionCall:var detailsNode=Timeline.TimelineUIUtils.buildDetailsNodeForTraceEvent(event,model.targetByEvent(event),linkifier);if(detailsNode)
contentHelper.appendElementRow(Common.UIString('Function'),detailsNode);break;case recordTypes.TimerFire:case recordTypes.TimerInstall:case recordTypes.TimerRemove:contentHelper.appendTextRow(Common.UIString('Timer ID'),eventData['timerId']);if(event.name===recordTypes.TimerInstall){contentHelper.appendTextRow(Common.UIString('Timeout'),Number.millisToString(eventData['timeout']));contentHelper.appendTextRow(Common.UIString('Repeats'),!eventData['singleShot']);}
break;case recordTypes.FireAnimationFrame:contentHelper.appendTextRow(Common.UIString('Callback ID'),eventData['id']);break;case recordTypes.ResourceSendRequest:case recordTypes.ResourceReceiveResponse:case recordTypes.ResourceReceivedData:case recordTypes.ResourceFinish:var url=timelineData.url;if(url)
contentHelper.appendElementRow(Common.UIString('Resource'),Components.Linkifier.linkifyURL(url));if(eventData['requestMethod'])
contentHelper.appendTextRow(Common.UIString('Request Method'),eventData['requestMethod']);if(typeof eventData['statusCode']==='number')
contentHelper.appendTextRow(Common.UIString('Status Code'),eventData['statusCode']);if(eventData['mimeType'])
contentHelper.appendTextRow(Common.UIString('MIME Type'),eventData['mimeType']);if('priority'in eventData){var priority=Components.uiLabelForPriority(eventData['priority']);contentHelper.appendTextRow(Common.UIString('Priority'),priority);}
if(eventData['encodedDataLength']){contentHelper.appendTextRow(Common.UIString('Encoded Data Length'),Common.UIString('%d Bytes',eventData['encodedDataLength']));}
break;case recordTypes.CompileScript:case recordTypes.EvaluateScript:var url=eventData&&eventData['url'];if(url){contentHelper.appendLocationRow(Common.UIString('Script'),url,eventData['lineNumber'],eventData['columnNumber']);}
break;case recordTypes.Paint:var clip=eventData['clip'];contentHelper.appendTextRow(Common.UIString('Location'),Common.UIString('(%d, %d)',clip[0],clip[1]));var clipWidth=Timeline.TimelineUIUtils.quadWidth(clip);var clipHeight=Timeline.TimelineUIUtils.quadHeight(clip);contentHelper.appendTextRow(Common.UIString('Dimensions'),Common.UIString('%d × %d',clipWidth,clipHeight));case recordTypes.PaintSetup:case recordTypes.Rasterize:case recordTypes.ScrollLayer:relatedNodeLabel=Common.UIString('Layer Root');break;case recordTypes.PaintImage:case recordTypes.DecodeLazyPixelRef:case recordTypes.DecodeImage:case recordTypes.ResizeImage:case recordTypes.DrawLazyPixelRef:relatedNodeLabel=Common.UIString('Owner Element');if(timelineData.url){contentHelper.appendElementRow(Common.UIString('Image URL'),Components.Linkifier.linkifyURL(timelineData.url));}
break;case recordTypes.ParseAuthorStyleSheet:var url=eventData['styleSheetUrl'];if(url)
contentHelper.appendElementRow(Common.UIString('Stylesheet URL'),Components.Linkifier.linkifyURL(url));break;case recordTypes.UpdateLayoutTree:case recordTypes.RecalculateStyles:contentHelper.appendTextRow(Common.UIString('Elements Affected'),event.args['elementCount']);break;case recordTypes.Layout:var beginData=event.args['beginData'];contentHelper.appendTextRow(Common.UIString('Nodes That Need Layout'),Common.UIString('%s of %s',beginData['dirtyObjects'],beginData['totalObjects']));relatedNodeLabel=Common.UIString('Layout root');break;case recordTypes.ConsoleTime:contentHelper.appendTextRow(Common.UIString('Message'),event.name);break;case recordTypes.WebSocketCreate:case recordTypes.WebSocketSendHandshakeRequest:case recordTypes.WebSocketReceiveHandshakeResponse:case recordTypes.WebSocketDestroy:var initiatorData=initiator?initiator.args['data']:eventData;if(typeof initiatorData['webSocketURL']!=='undefined')
contentHelper.appendTextRow(Common.UIString('URL'),initiatorData['webSocketURL']);if(typeof initiatorData['webSocketProtocol']!=='undefined')
contentHelper.appendTextRow(Common.UIString('WebSocket Protocol'),initiatorData['webSocketProtocol']);if(typeof eventData['message']!=='undefined')
contentHelper.appendTextRow(Common.UIString('Message'),eventData['message']);break;case recordTypes.EmbedderCallback:contentHelper.appendTextRow(Common.UIString('Callback Function'),eventData['callbackName']);break;case recordTypes.Animation:if(event.phase===SDK.TracingModel.Phase.NestableAsyncInstant)
contentHelper.appendTextRow(Common.UIString('State'),eventData['state']);break;case recordTypes.ParseHTML:var beginData=event.args['beginData'];var url=beginData['url'];var startLine=beginData['startLine']-1;var endLine=event.args['endData']?event.args['endData']['endLine']-1:undefined;if(url)
contentHelper.appendLocationRange(Common.UIString('Range'),url,startLine,endLine);break;case recordTypes.FireIdleCallback:contentHelper.appendTextRow(Common.UIString('Allotted Time'),Number.millisToString(eventData['allottedMilliseconds']));contentHelper.appendTextRow(Common.UIString('Invoked by Timeout'),eventData['timedOut']);case recordTypes.RequestIdleCallback:case recordTypes.CancelIdleCallback:contentHelper.appendTextRow(Common.UIString('Callback ID'),eventData['id']);break;case recordTypes.EventDispatch:contentHelper.appendTextRow(Common.UIString('Type'),eventData['type']);break;default:var detailsNode=Timeline.TimelineUIUtils.buildDetailsNodeForTraceEvent(event,model.targetByEvent(event),linkifier);if(detailsNode)
contentHelper.appendElementRow(Common.UIString('Details'),detailsNode);break;}
if(timelineData.timeWaitingForMainThread){contentHelper.appendTextRow(Common.UIString('Time Waiting for Main Thread'),Number.millisToString(timelineData.timeWaitingForMainThread,true));}
var relatedNode=relatedNodesMap&&relatedNodesMap.get(timelineData.backendNodeId);if(relatedNode){contentHelper.appendElementRow(relatedNodeLabel||Common.UIString('Related Node'),Components.DOMPresentationUtils.linkifyNodeReference(relatedNode));}
if(event[Timeline.TimelineUIUtils._previewElementSymbol]){contentHelper.addSection(Common.UIString('Preview'));contentHelper.appendElementRow('',event[Timeline.TimelineUIUtils._previewElementSymbol]);}
if(timelineData.stackTraceForSelfOrInitiator()||TimelineModel.InvalidationTracker.invalidationEventsFor(event))
Timeline.TimelineUIUtils._generateCauses(event,model.targetByEvent(event),relatedNodesMap,contentHelper);var stats={};var showPieChart=detailed&&Timeline.TimelineUIUtils._aggregatedStatsForTraceEvent(stats,model,event);if(showPieChart){contentHelper.addSection(Common.UIString('Aggregated Time'));var pieChart=Timeline.TimelineUIUtils.generatePieChart(stats,Timeline.TimelineUIUtils.eventStyle(event).category,event.selfTime);contentHelper.appendElementRow('',pieChart);}
return contentHelper.fragment;}
static buildRangeStats(model,startTime,endTime){var aggregatedStats={};function compareEndTime(value,task){return value<task.endTime()?-1:1;}
var mainThreadTasks=model.mainThreadTasks();var taskIndex=mainThreadTasks.lowerBound(startTime,compareEndTime);for(;taskIndex<mainThreadTasks.length;++taskIndex){var task=mainThreadTasks[taskIndex];if(task.startTime()>endTime)
break;if(task.startTime()>startTime&&task.endTime()<endTime){var taskStats=task[Timeline.TimelineUIUtils._aggregatedStatsKey];if(!taskStats){taskStats={};Timeline.TimelineUIUtils._collectAggregatedStatsForRecord(task,startTime,endTime,taskStats);task[Timeline.TimelineUIUtils._aggregatedStatsKey]=taskStats;}
for(var key in taskStats)
aggregatedStats[key]=(aggregatedStats[key]||0)+taskStats[key];continue;}
Timeline.TimelineUIUtils._collectAggregatedStatsForRecord(task,startTime,endTime,aggregatedStats);}
var aggregatedTotal=0;for(var categoryName in aggregatedStats)
aggregatedTotal+=aggregatedStats[categoryName];aggregatedStats['idle']=Math.max(0,endTime-startTime-aggregatedTotal);var startOffset=startTime-model.minimumRecordTime();var endOffset=endTime-model.minimumRecordTime();var contentHelper=new Timeline.TimelineDetailsContentHelper(null,null);contentHelper.addSection(Common.UIString('Range:  %s \u2013 %s',Number.millisToString(startOffset),Number.millisToString(endOffset)));var pieChart=Timeline.TimelineUIUtils.generatePieChart(aggregatedStats);contentHelper.appendElementRow('',pieChart);return contentHelper.fragment;}
static _collectAggregatedStatsForRecord(record,startTime,endTime,aggregatedStats){var records=[];if(!record.endTime()||record.endTime()<startTime||record.startTime()>endTime)
return;var childrenTime=0;var children=record.children()||[];for(var i=0;i<children.length;++i){var child=children[i];if(!child.endTime()||child.endTime()<startTime||child.startTime()>endTime)
continue;childrenTime+=Math.min(endTime,child.endTime())-Math.max(startTime,child.startTime());Timeline.TimelineUIUtils._collectAggregatedStatsForRecord(child,startTime,endTime,aggregatedStats);}
var categoryName=Timeline.TimelineUIUtils.categoryForRecord(record).name;var ownTime=Math.min(endTime,record.endTime())-Math.max(startTime,record.startTime())-childrenTime;aggregatedStats[categoryName]=(aggregatedStats[categoryName]||0)+ownTime;}
static buildNetworkRequestDetails(request,model,linkifier){var target=model.targetByEvent(request.children[0]);var contentHelper=new Timeline.TimelineDetailsContentHelper(target,linkifier);var duration=request.endTime-(request.startTime||-Infinity);var items=[];if(request.url)
contentHelper.appendElementRow(Common.UIString('URL'),Components.Linkifier.linkifyURL(request.url));if(isFinite(duration))
contentHelper.appendTextRow(Common.UIString('Duration'),Number.millisToString(duration,true));if(request.requestMethod)
contentHelper.appendTextRow(Common.UIString('Request Method'),request.requestMethod);if(typeof request.priority==='string'){var priority=Components.uiLabelForPriority((request.priority));contentHelper.appendTextRow(Common.UIString('Priority'),priority);}
if(request.mimeType)
contentHelper.appendTextRow(Common.UIString('Mime Type'),request.mimeType);var title=Common.UIString('Initiator');var sendRequest=request.children[0];var topFrame=TimelineModel.TimelineData.forEvent(sendRequest).topFrame();if(topFrame){var link=linkifier.maybeLinkifyConsoleCallFrame(target,topFrame);if(link)
contentHelper.appendElementRow(title,link);}else{var initiator=TimelineModel.TimelineData.forEvent(sendRequest).initiator();if(initiator){var initiatorURL=TimelineModel.TimelineData.forEvent(initiator).url;if(initiatorURL){var link=linkifier.maybeLinkifyScriptLocation(target,null,initiatorURL,0);if(link)
contentHelper.appendElementRow(title,link);}}}
function action(fulfill){Components.DOMPresentationUtils.buildImagePreviewContents((target),request.url,false,saveImage);function saveImage(element){request.previewElement=element||null;fulfill(request.previewElement);}}
var previewPromise;if(request.previewElement)
previewPromise=Promise.resolve(request.previewElement);else
previewPromise=request.url&&target?new Promise(action):Promise.resolve(null);function appendPreview(element){if(element)
contentHelper.appendElementRow(Common.UIString('Preview'),request.previewElement);return contentHelper.fragment;}
return previewPromise.then(appendPreview);}
static _stackTraceFromCallFrames(callFrames){return({callFrames:callFrames});}
static _generateCauses(event,target,relatedNodesMap,contentHelper){var recordTypes=TimelineModel.TimelineModel.RecordType;var callSiteStackLabel;var stackLabel;switch(event.name){case recordTypes.TimerFire:callSiteStackLabel=Common.UIString('Timer Installed');break;case recordTypes.FireAnimationFrame:callSiteStackLabel=Common.UIString('Animation Frame Requested');break;case recordTypes.FireIdleCallback:callSiteStackLabel=Common.UIString('Idle Callback Requested');break;case recordTypes.UpdateLayoutTree:case recordTypes.RecalculateStyles:stackLabel=Common.UIString('Recalculation Forced');break;case recordTypes.Layout:callSiteStackLabel=Common.UIString('First Layout Invalidation');stackLabel=Common.UIString('Layout Forced');break;}
var timelineData=TimelineModel.TimelineData.forEvent(event);if(timelineData.stackTrace&&timelineData.stackTrace.length){contentHelper.addSection(Common.UIString('Call Stacks'));contentHelper.appendStackTrace(stackLabel||Common.UIString('Stack Trace'),Timeline.TimelineUIUtils._stackTraceFromCallFrames(timelineData.stackTrace));}
var initiator=TimelineModel.TimelineData.forEvent(event).initiator();if(TimelineModel.InvalidationTracker.invalidationEventsFor(event)&&target){contentHelper.addSection(Common.UIString('Invalidations'));Timeline.TimelineUIUtils._generateInvalidations(event,target,relatedNodesMap,contentHelper);}else if(initiator){var initiatorStackTrace=TimelineModel.TimelineData.forEvent(initiator).stackTrace;if(initiatorStackTrace){contentHelper.appendStackTrace(callSiteStackLabel||Common.UIString('First Invalidated'),Timeline.TimelineUIUtils._stackTraceFromCallFrames(initiatorStackTrace));}}}
static _generateInvalidations(event,target,relatedNodesMap,contentHelper){var invalidationTrackingEvents=TimelineModel.InvalidationTracker.invalidationEventsFor(event);var invalidations={};invalidationTrackingEvents.forEach(function(invalidation){if(!invalidations[invalidation.type])
invalidations[invalidation.type]=[invalidation];else
invalidations[invalidation.type].push(invalidation);});Object.keys(invalidations).forEach(function(type){Timeline.TimelineUIUtils._generateInvalidationsForType(type,target,invalidations[type],relatedNodesMap,contentHelper);});}
static _generateInvalidationsForType(type,target,invalidations,relatedNodesMap,contentHelper){var title;switch(type){case TimelineModel.TimelineModel.RecordType.StyleRecalcInvalidationTracking:title=Common.UIString('Style Invalidations');break;case TimelineModel.TimelineModel.RecordType.LayoutInvalidationTracking:title=Common.UIString('Layout Invalidations');break;default:title=Common.UIString('Other Invalidations');break;}
var invalidationsTreeOutline=new TreeOutlineInShadow();invalidationsTreeOutline.registerRequiredCSS('timeline/invalidationsTree.css');invalidationsTreeOutline.element.classList.add('invalidations-tree');var invalidationGroups=groupInvalidationsByCause(invalidations);invalidationGroups.forEach(function(group){var groupElement=new Timeline.TimelineUIUtils.InvalidationsGroupElement(target,relatedNodesMap,contentHelper,group);invalidationsTreeOutline.appendChild(groupElement);});contentHelper.appendElementRow(title,invalidationsTreeOutline.element,false,true);function groupInvalidationsByCause(invalidations){var causeToInvalidationMap=new Map();for(var index=0;index<invalidations.length;index++){var invalidation=invalidations[index];var causeKey='';if(invalidation.cause.reason)
causeKey+=invalidation.cause.reason+'.';if(invalidation.cause.stackTrace){invalidation.cause.stackTrace.forEach(function(stackFrame){causeKey+=stackFrame['functionName']+'.';causeKey+=stackFrame['scriptId']+'.';causeKey+=stackFrame['url']+'.';causeKey+=stackFrame['lineNumber']+'.';causeKey+=stackFrame['columnNumber']+'.';});}
if(causeToInvalidationMap.has(causeKey))
causeToInvalidationMap.get(causeKey).push(invalidation);else
causeToInvalidationMap.set(causeKey,[invalidation]);}
return causeToInvalidationMap.valuesArray();}}
static _collectInvalidationNodeIds(nodeIds,invalidations){nodeIds.addAll(invalidations.map(invalidation=>invalidation.nodeId).filter(id=>id));}
static _aggregatedStatsForTraceEvent(total,model,event){var events=model.inspectedTargetEvents();function eventComparator(startTime,e){return startTime-e.startTime;}
var index=events.binaryIndexOf(event.startTime,eventComparator);if(index<0)
return false;var hasChildren=false;var endTime=event.endTime;if(endTime){for(var i=index;i<events.length;i++){var nextEvent=events[i];if(nextEvent.startTime>=endTime)
break;if(!nextEvent.selfTime)
continue;if(nextEvent.thread!==event.thread)
continue;if(i>index)
hasChildren=true;var categoryName=Timeline.TimelineUIUtils.eventStyle(nextEvent).category.name;total[categoryName]=(total[categoryName]||0)+nextEvent.selfTime;}}
if(SDK.TracingModel.isAsyncPhase(event.phase)){if(event.endTime){var aggregatedTotal=0;for(var categoryName in total)
aggregatedTotal+=total[categoryName];total['idle']=Math.max(0,event.endTime-event.startTime-aggregatedTotal);}
return false;}
return hasChildren;}
static buildPicturePreviewContent(event,target,callback){new TimelineModel.LayerPaintEvent(event,target).snapshotPromise().then(onSnapshotLoaded);function onSnapshotLoaded(snapshotWithRect){if(!snapshotWithRect){callback();return;}
snapshotWithRect.snapshot.replay(null,null,1).then(imageURL=>onGotImage(imageURL));snapshotWithRect.snapshot.release();}
function onGotImage(imageURL){if(!imageURL){callback();return;}
var container=createElement('div');container.classList.add('image-preview-container','vbox','link');var img=container.createChild('img');img.src=imageURL;var paintProfilerButton=container.createChild('a');paintProfilerButton.textContent=Common.UIString('Paint Profiler');container.addEventListener('click',showPaintProfiler,false);callback(container);}
function showPaintProfiler(){Timeline.TimelinePanel.instance().select(Timeline.TimelineSelection.fromTraceEvent(event),Timeline.TimelinePanel.DetailsTab.PaintProfiler);}}
static createEventDivider(recordType,title,position){var eventDivider=createElement('div');eventDivider.className='resources-event-divider';var recordTypes=TimelineModel.TimelineModel.RecordType;if(recordType===recordTypes.MarkDOMContent)
eventDivider.className+=' resources-blue-divider';else if(recordType===recordTypes.MarkLoad)
eventDivider.className+=' resources-red-divider';else if(recordType===recordTypes.MarkFirstPaint)
eventDivider.className+=' resources-green-divider';else if(recordType===recordTypes.TimeStamp||recordType===recordTypes.ConsoleTime||recordType===recordTypes.UserTiming)
eventDivider.className+=' resources-orange-divider';else if(recordType===recordTypes.BeginFrame)
eventDivider.className+=' timeline-frame-divider';if(title)
eventDivider.title=title;eventDivider.style.left=position+'px';return eventDivider;}
static createDividerForRecord(record,zeroTime,position){var startTime=Number.millisToString(record.startTime()-zeroTime);var title=Common.UIString('%s at %s',Timeline.TimelineUIUtils.eventTitle(record.traceEvent()),startTime);return Timeline.TimelineUIUtils.createEventDivider(record.type(),title,position);}
static _visibleTypes(){var eventStyles=Timeline.TimelineUIUtils._initEventStyles();var result=[];for(var name in eventStyles){if(!eventStyles[name].hidden)
result.push(name);}
return result;}
static visibleEventsFilter(){return new TimelineModel.TimelineVisibleEventsFilter(Timeline.TimelineUIUtils._visibleTypes());}
static categories(){if(Timeline.TimelineUIUtils._categories)
return Timeline.TimelineUIUtils._categories;Timeline.TimelineUIUtils._categories={loading:new Timeline.TimelineCategory('loading',Common.UIString('Loading'),true,'hsl(214, 67%, 74%)','hsl(214, 67%, 66%)'),scripting:new Timeline.TimelineCategory('scripting',Common.UIString('Scripting'),true,'hsl(43, 83%, 72%)','hsl(43, 83%, 64%) '),rendering:new Timeline.TimelineCategory('rendering',Common.UIString('Rendering'),true,'hsl(256, 67%, 76%)','hsl(256, 67%, 70%)'),painting:new Timeline.TimelineCategory('painting',Common.UIString('Painting'),true,'hsl(109, 33%, 64%)','hsl(109, 33%, 55%)'),gpu:new Timeline.TimelineCategory('gpu',Common.UIString('GPU'),false,'hsl(109, 33%, 64%)','hsl(109, 33%, 55%)'),other:new Timeline.TimelineCategory('other',Common.UIString('Other'),false,'hsl(0, 0%, 87%)','hsl(0, 0%, 79%)'),idle:new Timeline.TimelineCategory('idle',Common.UIString('Idle'),false,'hsl(0, 100%, 100%)','hsl(0, 100%, 100%)')};return Timeline.TimelineUIUtils._categories;}
static titleForAsyncEventGroup(group){if(!Timeline.TimelineUIUtils._titleForAsyncEventGroupMap){var groups=TimelineModel.TimelineModel.AsyncEventGroup;Timeline.TimelineUIUtils._titleForAsyncEventGroupMap=new Map([[groups.animation,Common.UIString('Animation')],[groups.console,Common.UIString('Console')],[groups.userTiming,Common.UIString('User Timing')],[groups.input,Common.UIString('Input')]]);}
return Timeline.TimelineUIUtils._titleForAsyncEventGroupMap.get(group)||'';}
static generatePieChart(aggregatedStats,selfCategory,selfTime){var total=0;for(var categoryName in aggregatedStats)
total+=aggregatedStats[categoryName];var element=createElementWithClass('div','timeline-details-view-pie-chart-wrapper hbox');var pieChart=new UI.PieChart(100);pieChart.element.classList.add('timeline-details-view-pie-chart');pieChart.setTotal(total);var pieChartContainer=element.createChild('div','vbox');pieChartContainer.appendChild(pieChart.element);pieChartContainer.createChild('div','timeline-details-view-pie-chart-total').textContent=Common.UIString('Total: %s',Number.millisToString(total,true));var footerElement=element.createChild('div','timeline-aggregated-info-legend');function appendLegendRow(name,title,value,color){if(!value)
return;pieChart.addSlice(value,color);var rowElement=footerElement.createChild('div');rowElement.createChild('span','timeline-aggregated-legend-value').textContent=Number.preciseMillisToString(value,1);rowElement.createChild('span','timeline-aggregated-legend-swatch').style.backgroundColor=color;rowElement.createChild('span','timeline-aggregated-legend-title').textContent=title;}
if(selfCategory){if(selfTime){appendLegendRow(selfCategory.name,Common.UIString('%s (self)',selfCategory.title),selfTime,selfCategory.color);}
var categoryTime=aggregatedStats[selfCategory.name];var value=categoryTime-selfTime;if(value>0){appendLegendRow(selfCategory.name,Common.UIString('%s (children)',selfCategory.title),value,selfCategory.childColor);}}
for(var categoryName in Timeline.TimelineUIUtils.categories()){var category=Timeline.TimelineUIUtils.categories()[categoryName];if(category===selfCategory)
continue;appendLegendRow(category.name,category.title,aggregatedStats[category.name],category.childColor);}
return element;}
static generateDetailsContentForFrame(frameModel,frame,filmStripFrame){var pieChart=Timeline.TimelineUIUtils.generatePieChart(frame.timeByCategory);var contentHelper=new Timeline.TimelineDetailsContentHelper(null,null);contentHelper.addSection(Common.UIString('Frame'));var duration=Timeline.TimelineUIUtils.frameDuration(frame);contentHelper.appendElementRow(Common.UIString('Duration'),duration,frame.hasWarnings());if(filmStripFrame){var filmStripPreview=createElementWithClass('img','timeline-filmstrip-preview');filmStripFrame.imageDataPromise().then(onGotImageData.bind(null,filmStripPreview));contentHelper.appendElementRow('',filmStripPreview);filmStripPreview.addEventListener('click',frameClicked.bind(null,filmStripFrame),false);}
var durationInMillis=frame.endTime-frame.startTime;contentHelper.appendTextRow(Common.UIString('FPS'),Math.floor(1000/durationInMillis));contentHelper.appendTextRow(Common.UIString('CPU time'),Number.millisToString(frame.cpuTime,true));if(frame.layerTree){contentHelper.appendElementRow(Common.UIString('Layer tree'),Components.Linkifier.linkifyRevealable(frame.layerTree,Common.UIString('show')));}
function onGotImageData(image,data){if(data)
image.src='data:image/jpg;base64,'+data;}
function frameClicked(filmStripFrame){new Components.FilmStripView.Dialog(filmStripFrame,0);}
return contentHelper.fragment;}
static frameDuration(frame){var durationText=Common.UIString('%s (at %s)',Number.millisToString(frame.endTime-frame.startTime,true),Number.millisToString(frame.startTimeOffset,true));var element=createElement('span');element.createTextChild(durationText);if(!frame.hasWarnings())
return element;element.createTextChild(Common.UIString('. Long frame times are an indication of '));element.appendChild(UI.createExternalLink('https://developers.google.com/web/fundamentals/performance/rendering/',Common.UIString('jank')));element.createTextChild('.');return element;}
static createFillStyle(context,width,height,color0,color1,color2){var gradient=context.createLinearGradient(0,0,width,height);gradient.addColorStop(0,color0);gradient.addColorStop(0.25,color1);gradient.addColorStop(0.75,color1);gradient.addColorStop(1,color2);return gradient;}
static quadWidth(quad){return Math.round(Math.sqrt(Math.pow(quad[0]-quad[2],2)+Math.pow(quad[1]-quad[3],2)));}
static quadHeight(quad){return Math.round(Math.sqrt(Math.pow(quad[0]-quad[6],2)+Math.pow(quad[1]-quad[7],2)));}
static eventDispatchDesciptors(){if(Timeline.TimelineUIUtils._eventDispatchDesciptors)
return Timeline.TimelineUIUtils._eventDispatchDesciptors;var lightOrange='hsl(40,100%,80%)';var orange='hsl(40,100%,50%)';var green='hsl(90,100%,40%)';var purple='hsl(256,100%,75%)';Timeline.TimelineUIUtils._eventDispatchDesciptors=[new Timeline.TimelineUIUtils.EventDispatchTypeDescriptor(1,lightOrange,['mousemove','mouseenter','mouseleave','mouseout','mouseover']),new Timeline.TimelineUIUtils.EventDispatchTypeDescriptor(1,lightOrange,['pointerover','pointerout','pointerenter','pointerleave','pointermove']),new Timeline.TimelineUIUtils.EventDispatchTypeDescriptor(2,green,['wheel']),new Timeline.TimelineUIUtils.EventDispatchTypeDescriptor(3,orange,['click','mousedown','mouseup']),new Timeline.TimelineUIUtils.EventDispatchTypeDescriptor(3,orange,['touchstart','touchend','touchmove','touchcancel']),new Timeline.TimelineUIUtils.EventDispatchTypeDescriptor(3,orange,['pointerdown','pointerup','pointercancel','gotpointercapture','lostpointercapture']),new Timeline.TimelineUIUtils.EventDispatchTypeDescriptor(3,purple,['keydown','keyup','keypress'])];return Timeline.TimelineUIUtils._eventDispatchDesciptors;}
static markerStyleForEvent(event){var red='rgb(255, 0, 0)';var blue='rgb(0, 0, 255)';var orange='rgb(255, 178, 23)';var green='rgb(0, 130, 0)';var tallMarkerDashStyle=[10,5];var title=Timeline.TimelineUIUtils.eventTitle(event);if(event.hasCategory(TimelineModel.TimelineModel.Category.Console)||event.hasCategory(TimelineModel.TimelineModel.Category.UserTiming)){return{title:title,dashStyle:tallMarkerDashStyle,lineWidth:0.5,color:orange,tall:false,lowPriority:false,};}
var recordTypes=TimelineModel.TimelineModel.RecordType;var tall=false;var color=green;switch(event.name){case recordTypes.MarkDOMContent:color=blue;tall=true;break;case recordTypes.MarkLoad:color=red;tall=true;break;case recordTypes.MarkFirstPaint:color=green;tall=true;break;case recordTypes.TimeStamp:color=orange;break;}
return{title:title,dashStyle:tallMarkerDashStyle,lineWidth:0.5,color:color,tall:tall,lowPriority:false,};}
static markerStyleForFrame(){return{title:Common.UIString('Frame'),color:'rgba(100, 100, 100, 0.4)',lineWidth:3,dashStyle:[3],tall:true,lowPriority:true};}
static colorForURL(url){if(!Timeline.TimelineUIUtils.colorForURL._colorGenerator){Timeline.TimelineUIUtils.colorForURL._colorGenerator=new UI.FlameChart.ColorGenerator({min:30,max:330},{min:50,max:80,count:3},85);}
return Timeline.TimelineUIUtils.colorForURL._colorGenerator.colorForID(url);}
static eventWarning(event,warningType){var timelineData=TimelineModel.TimelineData.forEvent(event);var warning=warningType||timelineData.warning;if(!warning)
return null;var warnings=TimelineModel.TimelineModel.WarningType;var span=createElement('span');var eventData=event.args['data'];switch(warning){case warnings.ForcedStyle:case warnings.ForcedLayout:span.appendChild(UI.createDocumentationLink('../../fundamentals/performance/rendering/avoid-large-complex-layouts-and-layout-thrashing#avoid-forced-synchronous-layouts',Common.UIString('Forced reflow')));span.createTextChild(Common.UIString(' is a likely performance bottleneck.'));break;case warnings.IdleDeadlineExceeded:span.textContent=Common.UIString('Idle callback execution extended beyond deadline by '+
Number.millisToString(event.duration-eventData['allottedMilliseconds'],true));break;case warnings.LongHandler:span.textContent=Common.UIString('Handler took %s',Number.millisToString(event.duration,true));break;case warnings.LongRecurringHandler:span.textContent=Common.UIString('Recurring handler took %s',Number.millisToString(event.duration,true));break;case warnings.V8Deopt:span.appendChild(UI.createExternalLink('https://github.com/GoogleChrome/devtools-docs/issues/53',Common.UIString('Not optimized')));span.createTextChild(Common.UIString(': %s',eventData['deoptReason']));break;default:console.assert(false,'Unhandled TimelineModel.WarningType');}
return span;}
static displayNameForFrame(frame,trimAt){var url=frame.url;if(!trimAt)
trimAt=30;return url.startsWith('about:')?`"${frame.name.trimMiddle(trimAt)}"`:frame.url.trimEnd(trimAt);}};Timeline.TimelineRecordStyle=class{constructor(title,category,hidden){this.title=title;this.category=category;this.hidden=!!hidden;}};Timeline.TimelineUIUtils.NetworkCategory={HTML:Symbol('HTML'),Script:Symbol('Script'),Style:Symbol('Style'),Media:Symbol('Media'),Other:Symbol('Other')};Timeline.TimelineUIUtils._aggregatedStatsKey=Symbol('aggregatedStats');Timeline.TimelineUIUtils.InvalidationsGroupElement=class extends TreeElement{constructor(target,relatedNodesMap,contentHelper,invalidations){super('',true);this.listItemElement.classList.add('header');this.selectable=false;this.toggleOnClick=true;this._relatedNodesMap=relatedNodesMap;this._contentHelper=contentHelper;this._invalidations=invalidations;this.title=this._createTitle(target);}
_createTitle(target){var first=this._invalidations[0];var reason=first.cause.reason;var topFrame=first.cause.stackTrace&&first.cause.stackTrace[0];var title=createElement('span');if(reason)
title.createTextChild(Common.UIString('%s for ',reason));else
title.createTextChild(Common.UIString('Unknown cause for '));this._appendTruncatedNodeList(title,this._invalidations);if(topFrame&&this._contentHelper.linkifier()){title.createTextChild(Common.UIString('. '));var stack=title.createChild('span','monospace');stack.createChild('span').textContent=Timeline.TimelineUIUtils.frameDisplayName(topFrame);var link=this._contentHelper.linkifier().maybeLinkifyConsoleCallFrame(target,topFrame);if(link){stack.createChild('span').textContent=' @ ';stack.createChild('span').appendChild(link);}}
return title;}
onpopulate(){var content=createElementWithClass('div','content');var first=this._invalidations[0];if(first.cause.stackTrace){var stack=content.createChild('div');stack.createTextChild(Common.UIString('Stack trace:'));this._contentHelper.createChildStackTraceElement(stack,Timeline.TimelineUIUtils._stackTraceFromCallFrames(first.cause.stackTrace));}
content.createTextChild(this._invalidations.length>1?Common.UIString('Nodes:'):Common.UIString('Node:'));var nodeList=content.createChild('div','node-list');var firstNode=true;for(var i=0;i<this._invalidations.length;i++){var invalidation=this._invalidations[i];var invalidationNode=this._createInvalidationNode(invalidation,true);if(invalidationNode){if(!firstNode)
nodeList.createTextChild(Common.UIString(', '));firstNode=false;nodeList.appendChild(invalidationNode);var extraData=invalidation.extraData?', '+invalidation.extraData:'';if(invalidation.changedId){nodeList.createTextChild(Common.UIString('(changed id to "%s"%s)',invalidation.changedId,extraData));}else if(invalidation.changedClass){nodeList.createTextChild(Common.UIString('(changed class to "%s"%s)',invalidation.changedClass,extraData));}else if(invalidation.changedAttribute){nodeList.createTextChild(Common.UIString('(changed attribute to "%s"%s)',invalidation.changedAttribute,extraData));}else if(invalidation.changedPseudo){nodeList.createTextChild(Common.UIString('(changed pesudo to "%s"%s)',invalidation.changedPseudo,extraData));}else if(invalidation.selectorPart){nodeList.createTextChild(Common.UIString('(changed "%s"%s)',invalidation.selectorPart,extraData));}}}
var contentTreeElement=new TreeElement(content,false);contentTreeElement.selectable=false;this.appendChild(contentTreeElement);}
_appendTruncatedNodeList(parentElement,invalidations){var invalidationNodes=[];var invalidationNodeIdMap={};for(var i=0;i<invalidations.length;i++){var invalidation=invalidations[i];var invalidationNode=this._createInvalidationNode(invalidation,false);invalidationNode.addEventListener('click',(e)=>e.consume(),false);if(invalidationNode&&!invalidationNodeIdMap[invalidation.nodeId]){invalidationNodes.push(invalidationNode);invalidationNodeIdMap[invalidation.nodeId]=true;}}
if(invalidationNodes.length===1){parentElement.appendChild(invalidationNodes[0]);}else if(invalidationNodes.length===2){parentElement.appendChild(invalidationNodes[0]);parentElement.createTextChild(Common.UIString(' and '));parentElement.appendChild(invalidationNodes[1]);}else if(invalidationNodes.length>=3){parentElement.appendChild(invalidationNodes[0]);parentElement.createTextChild(Common.UIString(', '));parentElement.appendChild(invalidationNodes[1]);parentElement.createTextChild(Common.UIString(', and %s others',invalidationNodes.length-2));}}
_createInvalidationNode(invalidation,showUnknownNodes){var node=(invalidation.nodeId&&this._relatedNodesMap)?this._relatedNodesMap.get(invalidation.nodeId):null;if(node)
return Components.DOMPresentationUtils.linkifyNodeReference(node);if(invalidation.nodeName){var nodeSpan=createElement('span');nodeSpan.textContent=Common.UIString('[ %s ]',invalidation.nodeName);return nodeSpan;}
if(showUnknownNodes){var nodeSpan=createElement('span');return nodeSpan.createTextChild(Common.UIString('[ unknown node ]'));}}};Timeline.TimelineUIUtils._previewElementSymbol=Symbol('previewElement');Timeline.TimelineUIUtils.EventDispatchTypeDescriptor=class{constructor(priority,color,eventTypes){this.priority=priority;this.color=color;this.eventTypes=eventTypes;}};Timeline.TimelineCategory=class extends Common.Object{constructor(name,title,visible,childColor,color){super();this.name=name;this.title=title;this.visible=visible;this.childColor=childColor;this.color=color;this.hidden=false;}
get hidden(){return this._hidden;}
set hidden(hidden){this._hidden=hidden;this.dispatchEventToListeners(Timeline.TimelineCategory.Events.VisibilityChanged,this);}};Timeline.TimelineCategory.Events={VisibilityChanged:Symbol('VisibilityChanged')};Timeline.TimelineMarkerStyle;Timeline.TimelinePopupContentHelper=class{constructor(title){this._contentTable=createElement('table');var titleCell=this._createCell(Common.UIString('%s - Details',title),'timeline-details-title');titleCell.colSpan=2;var titleRow=createElement('tr');titleRow.appendChild(titleCell);this._contentTable.appendChild(titleRow);}
contentTable(){return this._contentTable;}
_createCell(content,styleName){var text=createElement('label');text.createTextChild(String(content));var cell=createElement('td');cell.className='timeline-details';if(styleName)
cell.className+=' '+styleName;cell.textContent=content;return cell;}
appendTextRow(title,content){var row=createElement('tr');row.appendChild(this._createCell(title,'timeline-details-row-title'));row.appendChild(this._createCell(content,'timeline-details-row-data'));this._contentTable.appendChild(row);}
appendElementRow(title,content){var row=createElement('tr');var titleCell=this._createCell(title,'timeline-details-row-title');row.appendChild(titleCell);var cell=createElement('td');cell.className='details';if(content instanceof Node)
cell.appendChild(content);else
cell.createTextChild(content||'');row.appendChild(cell);this._contentTable.appendChild(row);}};Timeline.TimelineDetailsContentHelper=class{constructor(target,linkifier){this.fragment=createDocumentFragment();this._linkifier=linkifier;this._target=target;this.element=createElementWithClass('div','timeline-details-view-block');this._tableElement=this.element.createChild('div','vbox timeline-details-chip-body');this.fragment.appendChild(this.element);}
addSection(title,category){if(!this._tableElement.hasChildNodes()){this.element.removeChildren();}else{this.element=createElementWithClass('div','timeline-details-view-block');this.fragment.appendChild(this.element);}
if(title){var titleElement=this.element.createChild('div','timeline-details-chip-title');if(category)
titleElement.createChild('div').style.backgroundColor=category.color;titleElement.createTextChild(title);}
this._tableElement=this.element.createChild('div','vbox timeline-details-chip-body');this.fragment.appendChild(this.element);}
linkifier(){return this._linkifier;}
appendTextRow(title,value){var rowElement=this._tableElement.createChild('div','timeline-details-view-row');rowElement.createChild('div','timeline-details-view-row-title').textContent=title;rowElement.createChild('div','timeline-details-view-row-value').textContent=value;}
appendElementRow(title,content,isWarning,isStacked){var rowElement=this._tableElement.createChild('div','timeline-details-view-row');if(isWarning)
rowElement.classList.add('timeline-details-warning');if(isStacked)
rowElement.classList.add('timeline-details-stack-values');var titleElement=rowElement.createChild('div','timeline-details-view-row-title');titleElement.textContent=title;var valueElement=rowElement.createChild('div','timeline-details-view-row-value');if(content instanceof Node)
valueElement.appendChild(content);else
valueElement.createTextChild(content||'');}
appendLocationRow(title,url,startLine,startColumn){if(!this._linkifier||!this._target)
return;var link=this._linkifier.maybeLinkifyScriptLocation(this._target,null,url,startLine,startColumn);if(!link)
return;this.appendElementRow(title,link);}
appendLocationRange(title,url,startLine,endLine){if(!this._linkifier||!this._target)
return;var locationContent=createElement('span');var link=this._linkifier.maybeLinkifyScriptLocation(this._target,null,url,startLine);if(!link)
return;locationContent.appendChild(link);locationContent.createTextChild(String.sprintf(' [%s\u2026%s]',startLine+1,endLine+1||''));this.appendElementRow(title,locationContent);}
appendStackTrace(title,stackTrace){if(!this._linkifier||!this._target)
return;var rowElement=this._tableElement.createChild('div','timeline-details-view-row');rowElement.createChild('div','timeline-details-view-row-title').textContent=title;this.createChildStackTraceElement(rowElement,stackTrace);}
createChildStackTraceElement(parentElement,stackTrace){if(!this._linkifier||!this._target)
return;parentElement.classList.add('timeline-details-stack-values');var stackTraceElement=parentElement.createChild('div','timeline-details-view-row-value timeline-details-view-row-stack-trace');var callFrameElem=Components.DOMPresentationUtils.buildStackTracePreviewContents(this._target,this._linkifier,stackTrace);stackTraceElement.appendChild(callFrameElem);}
appendWarningRow(event,warningType){var warning=Timeline.TimelineUIUtils.eventWarning(event,warningType);if(warning)
this.appendElementRow(Common.UIString('Warning'),warning,true);}};;Timeline.TimelineLayersView=class extends UI.SplitWidget{constructor(model,showPaintProfilerCallback){super(true,false,'timelineLayersView');this._model=model;this._showPaintProfilerCallback=showPaintProfilerCallback;this.element.classList.add('timeline-layers-view');this._rightSplitWidget=new UI.SplitWidget(true,true,'timelineLayersViewDetails');this._rightSplitWidget.element.classList.add('timeline-layers-view-properties');this.setMainWidget(this._rightSplitWidget);var vbox=new UI.VBox();this.setSidebarWidget(vbox);this._layerViewHost=new LayerViewer.LayerViewHost();var layerTreeOutline=new LayerViewer.LayerTreeOutline(this._layerViewHost);vbox.element.appendChild(layerTreeOutline.element);this._layers3DView=new LayerViewer.Layers3DView(this._layerViewHost);this._layers3DView.addEventListener(LayerViewer.Layers3DView.Events.PaintProfilerRequested,this._onPaintProfilerRequested,this);this._rightSplitWidget.setMainWidget(this._layers3DView);var layerDetailsView=new LayerViewer.LayerDetailsView(this._layerViewHost);this._rightSplitWidget.setSidebarWidget(layerDetailsView);layerDetailsView.addEventListener(LayerViewer.LayerDetailsView.Events.PaintProfilerRequested,this._onPaintProfilerRequested,this);}
showLayerTree(frameLayerTree){this._frameLayerTree=frameLayerTree;if(this.isShowing())
this._update();else
this._updateWhenVisible=true;}
wasShown(){if(this._updateWhenVisible){this._updateWhenVisible=false;this._update();}}
_onPaintProfilerRequested(event){var selection=(event.data);this._layers3DView.snapshotForSelection(selection).then(snapshotWithRect=>{if(snapshotWithRect)
this._showPaintProfilerCallback(snapshotWithRect.snapshot);});}
_update(){this._frameLayerTree.layerTreePromise().then(layerTree=>this._layerViewHost.setLayerTree(layerTree));}};;Timeline.TimelinePaintProfilerView=class extends UI.SplitWidget{constructor(frameModel){super(false,false);this.element.classList.add('timeline-paint-profiler-view');this.setSidebarSize(60);this.setResizable(false);this._frameModel=frameModel;this._logAndImageSplitWidget=new UI.SplitWidget(true,false);this._logAndImageSplitWidget.element.classList.add('timeline-paint-profiler-log-split');this.setMainWidget(this._logAndImageSplitWidget);this._imageView=new Timeline.TimelinePaintImageView();this._logAndImageSplitWidget.setMainWidget(this._imageView);this._paintProfilerView=new LayerViewer.PaintProfilerView(this._imageView.showImage.bind(this._imageView));this._paintProfilerView.addEventListener(LayerViewer.PaintProfilerView.Events.WindowChanged,this._onWindowChanged,this);this.setSidebarWidget(this._paintProfilerView);this._logTreeView=new LayerViewer.PaintProfilerCommandLogView();this._logAndImageSplitWidget.setSidebarWidget(this._logTreeView);}
wasShown(){if(this._needsUpdateWhenVisible){this._needsUpdateWhenVisible=false;this._update();}}
setSnapshot(snapshot){this._releaseSnapshot();this._pendingSnapshot=snapshot;this._event=null;this._updateWhenVisible();}
setEvent(target,event){this._releaseSnapshot();this._target=target;this._pendingSnapshot=null;this._event=event;this._updateWhenVisible();if(this._event.name===TimelineModel.TimelineModel.RecordType.Paint)
return!!TimelineModel.TimelineData.forEvent(event).picture;if(this._event.name===TimelineModel.TimelineModel.RecordType.RasterTask)
return this._frameModel.hasRasterTile(this._event);return false;}
_updateWhenVisible(){if(this.isShowing())
this._update();else
this._needsUpdateWhenVisible=true;}
_update(){this._logTreeView.setCommandLog(null,[]);this._paintProfilerView.setSnapshotAndLog(null,[],null);var snapshotPromise;if(this._pendingSnapshot){snapshotPromise=Promise.resolve({rect:null,snapshot:this._pendingSnapshot});}else if(this._event.name===TimelineModel.TimelineModel.RecordType.Paint){var picture=TimelineModel.TimelineData.forEvent(this._event).picture;snapshotPromise=picture.objectPromise().then(data=>SDK.PaintProfilerSnapshot.load(this._target,data['skp64'])).then(snapshot=>snapshot&&{rect:null,snapshot:snapshot});}else if(this._event.name===TimelineModel.TimelineModel.RecordType.RasterTask){snapshotPromise=this._frameModel.rasterTilePromise(this._event);}else{console.assert(false,'Unexpected event type or no snapshot');return;}
snapshotPromise.then(snapshotWithRect=>{this._releaseSnapshot();if(!snapshotWithRect){this._imageView.showImage();return;}
var snapshot=snapshotWithRect.snapshot;this._lastLoadedSnapshot=snapshot;this._imageView.setMask(snapshotWithRect.rect);snapshot.commandLog().then(log=>onCommandLogDone.call(this,snapshot,snapshotWithRect.rect,log));});function onCommandLogDone(snapshot,clipRect,log){this._logTreeView.setCommandLog(snapshot.target(),log||[]);this._paintProfilerView.setSnapshotAndLog(snapshot,log||[],clipRect);}}
_releaseSnapshot(){if(!this._lastLoadedSnapshot)
return;this._lastLoadedSnapshot.release();this._lastLoadedSnapshot=null;}
_onWindowChanged(){this._logTreeView.updateWindow(this._paintProfilerView.selectionWindow());}};Timeline.TimelinePaintImageView=class extends UI.Widget{constructor(){super(true);this.registerRequiredCSS('timeline/timelinePaintProfiler.css');this.contentElement.classList.add('fill','paint-profiler-image-view');this._imageContainer=this.contentElement.createChild('div','paint-profiler-image-container');this._imageElement=this._imageContainer.createChild('img');this._maskElement=this._imageContainer.createChild('div');this._imageElement.addEventListener('load',this._updateImagePosition.bind(this),false);this._transformController=new LayerViewer.TransformController(this.contentElement,true);this._transformController.addEventListener(LayerViewer.TransformController.Events.TransformChanged,this._updateImagePosition,this);}
onResize(){if(this._imageElement.src)
this._updateImagePosition();}
_updateImagePosition(){var width=this._imageElement.naturalWidth;var height=this._imageElement.naturalHeight;var clientWidth=this.contentElement.clientWidth;var clientHeight=this.contentElement.clientHeight;var paddingFraction=0.1;var paddingX=clientWidth*paddingFraction;var paddingY=clientHeight*paddingFraction;var scaleX=(clientWidth-paddingX)/width;var scaleY=(clientHeight-paddingY)/height;var scale=Math.min(scaleX,scaleY);if(this._maskRectangle){var style=this._maskElement.style;style.width=width+'px';style.height=height+'px';style.borderLeftWidth=this._maskRectangle.x+'px';style.borderTopWidth=this._maskRectangle.y+'px';style.borderRightWidth=(width-this._maskRectangle.x-this._maskRectangle.width)+'px';style.borderBottomWidth=(height-this._maskRectangle.y-this._maskRectangle.height)+'px';}
this._transformController.setScaleConstraints(0.5,10/scale);var matrix=new WebKitCSSMatrix().scale(this._transformController.scale(),this._transformController.scale()).translate(clientWidth/2,clientHeight/2).scale(scale,scale).translate(-width/2,-height/2);var bounds=Common.Geometry.boundsForTransformedPoints(matrix,[0,0,0,width,height,0]);this._transformController.clampOffsets(paddingX-bounds.maxX,clientWidth-paddingX-bounds.minX,paddingY-bounds.maxY,clientHeight-paddingY-bounds.minY);matrix=new WebKitCSSMatrix().translate(this._transformController.offsetX(),this._transformController.offsetY()).multiply(matrix);this._imageContainer.style.webkitTransform=matrix.toString();}
showImage(imageURL){this._imageContainer.classList.toggle('hidden',!imageURL);if(imageURL)
this._imageElement.src=imageURL;}
setMask(maskRectangle){this._maskRectangle=maskRectangle;this._maskElement.classList.toggle('hidden',!maskRectangle);}};;Timeline.TimelinePanel=class extends UI.Panel{constructor(){super('timeline');this.registerRequiredCSS('timeline/timelinePanel.css');this.element.addEventListener('contextmenu',this._contextMenu.bind(this),false);this._dropTarget=new UI.DropTarget(this.element,[UI.DropTarget.Types.Files,UI.DropTarget.Types.URIList],Common.UIString('Drop timeline file or URL here'),this._handleDrop.bind(this));this._state=Timeline.TimelinePanel.State.Idle;this._detailsLinkifier=new Components.Linkifier();this._windowStartTime=0;this._windowEndTime=Infinity;this._millisecondsToRecordAfterLoadEvent=3000;this._toggleRecordAction=(UI.actionRegistry.action('timeline.toggle-recording'));this._filters=[];if(!Runtime.experiments.isEnabled('timelineShowAllEvents')){this._filters.push(Timeline.TimelineUIUtils.visibleEventsFilter());this._filters.push(new TimelineModel.ExcludeTopLevelFilter());}
this._tracingModelBackingStorage=new Bindings.TempFileBackingStorage('tracing');this._tracingModel=new SDK.TracingModel(this._tracingModelBackingStorage);this._model=new TimelineModel.TimelineModel(Timeline.TimelineUIUtils.visibleEventsFilter());this._frameModel=new TimelineModel.TimelineFrameModel(event=>Timeline.TimelineUIUtils.eventStyle(event).category.name);this._filmStripModel=new Components.FilmStripModel(this._tracingModel);this._irModel=new TimelineModel.TimelineIRModel();this._cpuThrottlingManager=new Timeline.CPUThrottlingManager();this._currentViews=[];this._captureNetworkSetting=Common.settings.createSetting('timelineCaptureNetwork',false);this._captureJSProfileSetting=Common.settings.createSetting('timelineEnableJSSampling',true);this._captureMemorySetting=Common.settings.createSetting('timelineCaptureMemory',false);this._captureLayersAndPicturesSetting=Common.settings.createSetting('timelineCaptureLayersAndPictures',false);this._captureFilmStripSetting=Common.settings.createSetting('timelineCaptureFilmStrip',false);this._markUnusedCSS=Common.settings.createSetting('timelineMarkUnusedCSS',false);this._panelToolbar=new UI.Toolbar('',this.element);var timelinePane=new UI.VBox();timelinePane.show(this.element);var topPaneElement=timelinePane.element.createChild('div','hbox');topPaneElement.id='timeline-overview-panel';this._overviewPane=new UI.TimelineOverviewPane('timeline');this._overviewPane.addEventListener(UI.TimelineOverviewPane.Events.WindowChanged,this._onWindowChanged.bind(this));this._overviewPane.show(topPaneElement);this._statusPaneContainer=timelinePane.element.createChild('div','status-pane-container fill');this._createFileSelector();SDK.targetManager.addEventListener(SDK.TargetManager.Events.PageReloadRequested,this._pageReloadRequested,this);SDK.targetManager.addEventListener(SDK.TargetManager.Events.Load,this._loadEventFired,this);this._detailsSplitWidget=new UI.SplitWidget(false,true,'timelinePanelDetailsSplitViewState');this._detailsSplitWidget.element.classList.add('timeline-details-split');this._detailsView=new Timeline.TimelineDetailsView(this._model,this._filters,this);this._detailsSplitWidget.installResizer(this._detailsView.headerElement());this._detailsSplitWidget.setSidebarWidget(this._detailsView);this._searchableView=new UI.SearchableView(this);this._searchableView.setMinimumSize(0,100);this._searchableView.element.classList.add('searchable-view');this._detailsSplitWidget.setMainWidget(this._searchableView);this._stackView=new UI.StackView(false);this._stackView.element.classList.add('timeline-view-stack');this._stackView.show(this._searchableView.element);this._onModeChanged();this._recreateToolbarItems();this._captureNetworkSetting.addChangeListener(this._onNetworkChanged,this);this._captureMemorySetting.addChangeListener(this._onModeChanged,this);this._captureFilmStripSetting.addChangeListener(this._onModeChanged,this);this._detailsSplitWidget.show(timelinePane.element);this._detailsSplitWidget.hideSidebar();SDK.targetManager.addEventListener(SDK.TargetManager.Events.SuspendStateChanged,this._onSuspendStateChanged,this);this._showRecordingHelpMessage();this._selectedSearchResult;this._searchResults;}
static instance(){return(self.runtime.sharedInstance(Timeline.TimelinePanel));}
searchableView(){return this._searchableView;}
wasShown(){UI.context.setFlavor(Timeline.TimelinePanel,this);}
willHide(){UI.context.setFlavor(Timeline.TimelinePanel,null);}
windowStartTime(){if(this._windowStartTime)
return this._windowStartTime;return this._model.minimumRecordTime();}
windowEndTime(){if(this._windowEndTime<Infinity)
return this._windowEndTime;return this._model.maximumRecordTime()||Infinity;}
_onWindowChanged(event){this._windowStartTime=event.data.startTime;this._windowEndTime=event.data.endTime;for(var i=0;i<this._currentViews.length;++i)
this._currentViews[i].setWindowTimes(this._windowStartTime,this._windowEndTime);if(!this._selection||this._selection.type()===Timeline.TimelineSelection.Type.Range)
this.select(null);}
_onOverviewSelectionChanged(event){var selection=(event.data);this.select(selection);}
requestWindowTimes(windowStartTime,windowEndTime){this._overviewPane.requestWindowTimes(windowStartTime,windowEndTime);}
_layersView(){if(this._lazyLayersView)
return this._lazyLayersView;this._lazyLayersView=new Timeline.TimelineLayersView(this._model,this._showSnapshotInPaintProfiler.bind(this));return this._lazyLayersView;}
_paintProfilerView(){if(this._lazyPaintProfilerView)
return this._lazyPaintProfilerView;this._lazyPaintProfilerView=new Timeline.TimelinePaintProfilerView(this._frameModel);return this._lazyPaintProfilerView;}
_addModeView(modeView){modeView.setWindowTimes(this.windowStartTime(),this.windowEndTime());modeView.refreshRecords();var splitWidget=this._stackView.appendView(modeView.view(),'timelinePanelTimelineStackSplitViewState',undefined,112);var resizer=modeView.resizerElement();if(splitWidget&&resizer){splitWidget.hideDefaultResizer();splitWidget.installResizer(resizer);}
this._currentViews.push(modeView);}
_removeAllModeViews(){this._currentViews.forEach(view=>view.dispose());this._currentViews=[];this._stackView.detachChildWidgets();}
_setState(state){this._state=state;this._updateTimelineControls();}
_createSettingCheckbox(name,setting,tooltip){if(!this._recordingOptionUIControls)
this._recordingOptionUIControls=[];var checkboxItem=new UI.ToolbarCheckbox(name,tooltip,setting);this._recordingOptionUIControls.push(checkboxItem);return checkboxItem;}
_recreateToolbarItems(){this._panelToolbar.removeToolbarItems();var perspectiveSetting=Common.settings.createSetting('timelinePerspective',Timeline.TimelinePanel.Perspectives.Load);if(Runtime.experiments.isEnabled('timelineRecordingPerspectives')&&perspectiveSetting.get()===Timeline.TimelinePanel.Perspectives.Load){this._reloadButton=new UI.ToolbarButton(Common.UIString('Record & Reload'),'largeicon-refresh');this._reloadButton.addEventListener('click',()=>SDK.targetManager.reloadPage());this._panelToolbar.appendToolbarItem(this._reloadButton);}else{this._panelToolbar.appendToolbarItem(UI.Toolbar.createActionButton(this._toggleRecordAction));}
var clearButton=new UI.ToolbarButton(Common.UIString('Clear recording'),'largeicon-clear');clearButton.addEventListener('click',this._clear,this);this._panelToolbar.appendToolbarItem(clearButton);this._panelToolbar.appendSeparator();if(Runtime.experiments.isEnabled('timelineRecordingPerspectives')){function onPerspectiveChanged(){perspectiveSetting.set(perspectiveCombobox.selectElement().value);this._recreateToolbarItems();}
function addPerspectiveOption(id,title){var option=perspectiveCombobox.createOption(title,'',id);perspectiveCombobox.addOption(option);if(id===perspectiveSetting.get())
perspectiveCombobox.select(option);}
var perspectiveCombobox=new UI.ToolbarComboBox(onPerspectiveChanged.bind(this));addPerspectiveOption(Timeline.TimelinePanel.Perspectives.Load,Common.UIString('Page Load'));addPerspectiveOption(Timeline.TimelinePanel.Perspectives.Responsiveness,Common.UIString('Responsiveness'));addPerspectiveOption(Timeline.TimelinePanel.Perspectives.JavaScript,Common.UIString('JavaScript'));addPerspectiveOption(Timeline.TimelinePanel.Perspectives.Custom,Common.UIString('Custom'));this._panelToolbar.appendToolbarItem(perspectiveCombobox);this._bulkUpdate=true;switch(perspectiveSetting.get()){case Timeline.TimelinePanel.Perspectives.Load:this._captureNetworkSetting.set(true);this._captureJSProfileSetting.set(true);this._captureMemorySetting.set(false);this._captureLayersAndPicturesSetting.set(false);this._captureFilmStripSetting.set(true);break;case Timeline.TimelinePanel.Perspectives.Responsiveness:this._captureNetworkSetting.set(true);this._captureJSProfileSetting.set(true);this._captureMemorySetting.set(false);this._captureLayersAndPicturesSetting.set(false);this._captureFilmStripSetting.set(false);break;case Timeline.TimelinePanel.Perspectives.JavaScript:this._captureNetworkSetting.set(false);this._captureJSProfileSetting.set(true);this._captureMemorySetting.set(false);this._captureLayersAndPicturesSetting.set(false);this._captureFilmStripSetting.set(false);this._detailsView.selectTab(Timeline.TimelinePanel.DetailsTab.BottomUp,false);break;}
this._bulkUpdate=false;this._onModeChanged();}
var screenshotCheckbox=this._createSettingCheckbox(Common.UIString('Screenshots'),this._captureFilmStripSetting,Common.UIString('Capture screenshots while recording. (Has small performance overhead)'));if(!Runtime.experiments.isEnabled('timelineRecordingPerspectives')||perspectiveSetting.get()===Timeline.TimelinePanel.Perspectives.Custom){this._panelToolbar.appendToolbarItem(this._createSettingCheckbox(Common.UIString('Network'),this._captureNetworkSetting,Common.UIString('Show network requests information')));this._panelToolbar.appendToolbarItem(this._createSettingCheckbox(Common.UIString('JS Profile'),this._captureJSProfileSetting,Common.UIString('Capture JavaScript stacks with sampling profiler. (Has small performance overhead)')));this._panelToolbar.appendToolbarItem(screenshotCheckbox);this._panelToolbar.appendToolbarItem(this._createSettingCheckbox(Common.UIString('Memory'),this._captureMemorySetting,Common.UIString('Capture memory information on every timeline event.')));this._panelToolbar.appendToolbarItem(this._createSettingCheckbox(Common.UIString('Paint'),this._captureLayersAndPicturesSetting,Common.UIString('Capture graphics layer positions and rasterization draw calls. (Has large performance overhead)')));}else{this._panelToolbar.appendToolbarItem(screenshotCheckbox);}
if(Runtime.experiments.isEnabled('timelineRuleUsageRecording')){this._panelToolbar.appendToolbarItem(this._createSettingCheckbox(Common.UIString('CSS coverage'),this._markUnusedCSS,Common.UIString('Mark unused CSS in souces.')));}
this._panelToolbar.appendSeparator();var garbageCollectButton=new UI.ToolbarButton(Common.UIString('Collect garbage'),'largeicon-trash-bin');garbageCollectButton.addEventListener('click',this._garbageCollectButtonClicked,this);this._panelToolbar.appendToolbarItem(garbageCollectButton);this._panelToolbar.appendSeparator();this._cpuThrottlingCombobox=new UI.ToolbarComboBox(this._onCPUThrottlingChanged.bind(this));this._panelToolbar.appendToolbarItem(this._createNetworkConditionsSelect());this._panelToolbar.appendToolbarItem(this._cpuThrottlingCombobox);this._populateCPUThrottingCombobox();this._updateTimelineControls();}
_createNetworkConditionsSelect(){var toolbarItem=new UI.ToolbarComboBox(null);toolbarItem.setMaxWidth(140);Components.NetworkConditionsSelector.decorateSelect(toolbarItem.selectElement());return toolbarItem;}
_populateCPUThrottingCombobox(){var cpuThrottlingCombobox=this._cpuThrottlingCombobox;cpuThrottlingCombobox.removeOptions();var currentRate=this._cpuThrottlingManager.rate();var hasSelection=false;function addGroupingOption(name,value){var option=cpuThrottlingCombobox.createOption(name,'',String(value));cpuThrottlingCombobox.addOption(option);if(hasSelection||(value&&value!==currentRate))
return;cpuThrottlingCombobox.select(option);hasSelection=true;}
var predefinedRates=new Map([[1,Common.UIString('No CPU throttling')],[2,Common.UIString('2\xD7 slowdown')],[5,Common.UIString('5\xD7 slowdown')],[10,Common.UIString('10\xD7 slowdown')],[20,Common.UIString('20\xD7 slowdown')]]);for(var rate of predefinedRates)
addGroupingOption(rate[1],rate[0]);}
_prepareToLoadTimeline(){console.assert(this._state===Timeline.TimelinePanel.State.Idle);this._setState(Timeline.TimelinePanel.State.Loading);}
_createFileSelector(){if(this._fileSelectorElement)
this._fileSelectorElement.remove();this._fileSelectorElement=Bindings.createFileSelectorElement(this._loadFromFile.bind(this));this.element.appendChild(this._fileSelectorElement);}
_contextMenu(event){var contextMenu=new UI.ContextMenu(event);contextMenu.appendItemsAtLocation('timelineMenu');contextMenu.show();}
_saveToFile(){if(this._state!==Timeline.TimelinePanel.State.Idle)
return true;if(this._model.isEmpty())
return true;var now=new Date();var fileName='TimelineRawData-'+now.toISO8601Compact()+'.json';var stream=new Bindings.FileOutputStream();function callback(accepted){if(!accepted)
return;var saver=new Timeline.TracingTimelineSaver();this._tracingModelBackingStorage.writeToStream(stream,saver);}
stream.open(fileName,callback.bind(this));return true;}
_selectFileToLoad(){this._fileSelectorElement.click();return true;}
_loadFromFile(file){if(this._state!==Timeline.TimelinePanel.State.Idle)
return;this._prepareToLoadTimeline();this._loader=Timeline.TimelineLoader.loadFromFile(this._tracingModel,file,this);this._createFileSelector();}
_loadFromURL(url){if(this._state!==Timeline.TimelinePanel.State.Idle)
return;this._prepareToLoadTimeline();this._loader=Timeline.TimelineLoader.loadFromURL(this._tracingModel,url,this);}
_refreshViews(){for(var i=0;i<this._currentViews.length;++i){var view=this._currentViews[i];view.refreshRecords();}
this._updateSelectionDetails();}
_onModeChanged(){if(this._bulkUpdate)
return;this._overviewControls=[];this._overviewControls.push(new Timeline.TimelineEventOverviewResponsiveness(this._model,this._frameModel));if(Runtime.experiments.isEnabled('inputEventsOnTimelineOverview'))
this._overviewControls.push(new Timeline.TimelineEventOverviewInput(this._model));this._overviewControls.push(new Timeline.TimelineEventOverviewFrames(this._model,this._frameModel));this._overviewControls.push(new Timeline.TimelineEventOverviewCPUActivity(this._model));this._overviewControls.push(new Timeline.TimelineEventOverviewNetwork(this._model));if(this._captureFilmStripSetting.get())
this._overviewControls.push(new Timeline.TimelineFilmStripOverview(this._model,this._filmStripModel));if(this._captureMemorySetting.get())
this._overviewControls.push(new Timeline.TimelineEventOverviewMemory(this._model));this._overviewPane.setOverviewControls(this._overviewControls);this._removeAllModeViews();this._flameChart=new Timeline.TimelineFlameChartView(this,this._model,this._frameModel,this._irModel,this._filters);this._flameChart.enableNetworkPane(this._captureNetworkSetting.get());this._addModeView(this._flameChart);if(this._captureMemorySetting.get()){this._addModeView(new Timeline.MemoryCountersGraph(this,this._model,[Timeline.TimelineUIUtils.visibleEventsFilter()]));}
this.doResize();this.select(null);}
_onNetworkChanged(){if(this._flameChart)
this._flameChart.enableNetworkPane(this._captureNetworkSetting.get(),true);}
_onCPUThrottlingChanged(){if(!this._cpuThrottlingManager)
return;var text=this._cpuThrottlingCombobox.selectedOption().value;this._cpuThrottlingManager.setRate(Number.parseFloat(text));}
_setUIControlsEnabled(enabled){function handler(toolbarButton){toolbarButton.setEnabled(enabled);}
this._recordingOptionUIControls.forEach(handler);}
_startRecording(userInitiated){console.assert(!this._statusPane,'Status pane is already opened.');var mainTarget=SDK.targetManager.mainTarget();if(!mainTarget)
return;this._setState(Timeline.TimelinePanel.State.StartPending);this._showRecordingStarted();if(Runtime.experiments.isEnabled('timelineRuleUsageRecording')&&this._markUnusedCSS.get())
SDK.CSSModel.fromTarget(mainTarget).startRuleUsageTracking();this._autoRecordGeneration=userInitiated?null:Symbol('Generation');this._controller=new Timeline.TimelineController(mainTarget,this,this._tracingModel);this._controller.startRecording(true,this._captureJSProfileSetting.get(),this._captureMemorySetting.get(),this._captureLayersAndPicturesSetting.get(),this._captureFilmStripSetting&&this._captureFilmStripSetting.get());for(var i=0;i<this._overviewControls.length;++i)
this._overviewControls[i].timelineStarted();if(userInitiated)
Host.userMetrics.actionTaken(Host.UserMetrics.Action.TimelineStarted);this._setUIControlsEnabled(false);this._hideRecordingHelpMessage();}
_stopRecording(){if(this._statusPane){this._statusPane.finish();this._statusPane.updateStatus(Common.UIString('Stopping timeline\u2026'));this._statusPane.updateProgressBar(Common.UIString('Received'),0);}
this._setState(Timeline.TimelinePanel.State.StopPending);this._autoRecordGeneration=null;this._controller.stopRecording();this._controller=null;this._setUIControlsEnabled(true);}
_onSuspendStateChanged(){this._updateTimelineControls();}
_updateTimelineControls(){var state=Timeline.TimelinePanel.State;this._toggleRecordAction.setToggled(this._state===state.Recording);this._toggleRecordAction.setEnabled(this._state===state.Recording||this._state===state.Idle);this._panelToolbar.setEnabled(this._state!==state.Loading);this._dropTarget.setEnabled(this._state===state.Idle);}
_toggleRecording(){if(this._state===Timeline.TimelinePanel.State.Idle)
this._startRecording(true);else if(this._state===Timeline.TimelinePanel.State.Recording)
this._stopRecording();}
_garbageCollectButtonClicked(){var targets=SDK.targetManager.targets();for(var i=0;i<targets.length;++i)
targets[i].heapProfilerAgent().collectGarbage();}
_clear(){if(Runtime.experiments.isEnabled('timelineRuleUsageRecording')&&this._markUnusedCSS.get())
Components.CoverageProfile.instance().reset();Components.LineLevelProfile.instance().reset();this._tracingModel.reset();this._model.reset();this._showRecordingHelpMessage();this.requestWindowTimes(0,Infinity);delete this._selection;this._frameModel.reset();this._filmStripModel.reset(this._tracingModel);this._overviewPane.reset();for(var i=0;i<this._currentViews.length;++i)
this._currentViews[i].reset();for(var i=0;i<this._overviewControls.length;++i)
this._overviewControls[i].reset();this.select(null);this._detailsSplitWidget.hideSidebar();}
recordingStarted(){this._clear();this._setState(Timeline.TimelinePanel.State.Recording);this._showRecordingStarted();this._statusPane.updateStatus(Common.UIString('Recording\u2026'));this._statusPane.updateProgressBar(Common.UIString('Buffer usage'),0);this._statusPane.startTimer();this._hideRecordingHelpMessage();}
recordingProgress(usage){this._statusPane.updateProgressBar(Common.UIString('Buffer usage'),usage*100);}
_showRecordingHelpMessage(){function encloseWithTag(tagName,contents){var e=createElement(tagName);e.textContent=contents;return e;}
var recordNode=encloseWithTag('b',UI.shortcutRegistry.shortcutDescriptorsForAction('timeline.toggle-recording')[0].name);var reloadNode=encloseWithTag('b',UI.shortcutRegistry.shortcutDescriptorsForAction('main.reload')[0].name);var navigateNode=encloseWithTag('b',Common.UIString('WASD (ZQSD)'));var hintText=createElementWithClass('div');hintText.appendChild(UI.formatLocalized('To capture a new timeline, click the record toolbar button or hit %s.',[recordNode]));hintText.createChild('br');hintText.appendChild(UI.formatLocalized('To evaluate page load performance, hit %s to record the reload.',[reloadNode]));hintText.createChild('p');hintText.appendChild(UI.formatLocalized('After recording, select an area of interest in the overview by dragging.',[]));hintText.createChild('br');hintText.appendChild(UI.formatLocalized('Then, zoom and pan the timeline with the mousewheel and %s keys.',[navigateNode]));this._hideRecordingHelpMessage();this._helpMessageElement=this._searchableView.element.createChild('div','full-widget-dimmed-banner timeline-status-pane');this._helpMessageElement.appendChild(hintText);}
_hideRecordingHelpMessage(){if(this._helpMessageElement)
this._helpMessageElement.remove();delete this._helpMessageElement;}
loadingStarted(){this._hideRecordingHelpMessage();if(this._statusPane)
this._statusPane.hide();this._statusPane=new Timeline.TimelinePanel.StatusPane(false,this._cancelLoading.bind(this));this._statusPane.showPane(this._statusPaneContainer);this._statusPane.updateStatus(Common.UIString('Loading timeline\u2026'));if(!this._loader)
this._statusPane.finish();this.loadingProgress(0);}
loadingProgress(progress){if(typeof progress==='number')
this._statusPane.updateProgressBar(Common.UIString('Received'),progress*100);}
loadingComplete(success){var loadedFromFile=!!this._loader;delete this._loader;this._setState(Timeline.TimelinePanel.State.Idle);if(!success){this._statusPane.hide();delete this._statusPane;this._clear();return;}
if(this._statusPane)
this._statusPane.updateStatus(Common.UIString('Processing timeline\u2026'));this._model.setEvents(this._tracingModel,loadedFromFile);this._frameModel.reset();this._frameModel.addTraceEvents(SDK.targetManager.mainTarget(),this._model.inspectedTargetEvents(),this._model.sessionId()||'');this._filmStripModel.reset(this._tracingModel);var groups=TimelineModel.TimelineModel.AsyncEventGroup;var asyncEventsByGroup=this._model.mainThreadAsyncEvents();this._irModel.populate(asyncEventsByGroup.get(groups.input),asyncEventsByGroup.get(groups.animation));this._model.cpuProfiles().forEach(profile=>Components.LineLevelProfile.instance().appendCPUProfile(profile));if(this._statusPane)
this._statusPane.hide();delete this._statusPane;this._flameChart.resizeToPreferredHeights();this._overviewPane.reset();this._overviewPane.setBounds(this._model.minimumRecordTime(),this._model.maximumRecordTime());this._setAutoWindowTimes();this._refreshViews();for(var i=0;i<this._overviewControls.length;++i)
this._overviewControls[i].timelineStopped();this._setMarkers();this._overviewPane.scheduleUpdate();this._updateSearchHighlight(false,true);this._detailsSplitWidget.showBoth();}
_showRecordingStarted(){if(this._statusPane)
return;this._statusPane=new Timeline.TimelinePanel.StatusPane(true,this._stopRecording.bind(this));this._statusPane.showPane(this._statusPaneContainer);this._statusPane.updateStatus(Common.UIString('Initializing recording\u2026'));}
_cancelLoading(){if(this._loader)
this._loader.cancel();}
_setMarkers(){var markers=new Map();var recordTypes=TimelineModel.TimelineModel.RecordType;var zeroTime=this._model.minimumRecordTime();for(var record of this._model.eventDividerRecords()){if(record.type()===recordTypes.TimeStamp||record.type()===recordTypes.ConsoleTime)
continue;markers.set(record.startTime(),Timeline.TimelineUIUtils.createDividerForRecord(record,zeroTime,0));}
this._overviewPane.setMarkers(markers);}
_pageReloadRequested(event){if(this._state!==Timeline.TimelinePanel.State.Idle||!this.isShowing())
return;this._startRecording(false);}
_loadEventFired(event){if(this._state!==Timeline.TimelinePanel.State.Recording||!this._autoRecordGeneration)
return;setTimeout(stopRecordingOnReload.bind(this,this._autoRecordGeneration),this._millisecondsToRecordAfterLoadEvent);function stopRecordingOnReload(recordGeneration){if(this._state!==Timeline.TimelinePanel.State.Recording||this._autoRecordGeneration!==recordGeneration)
return;this._stopRecording();}}
jumpToNextSearchResult(){if(!this._searchResults||!this._searchResults.length)
return;var index=this._selectedSearchResult?this._searchResults.indexOf(this._selectedSearchResult):-1;this._jumpToSearchResult(index+1);}
jumpToPreviousSearchResult(){if(!this._searchResults||!this._searchResults.length)
return;var index=this._selectedSearchResult?this._searchResults.indexOf(this._selectedSearchResult):0;this._jumpToSearchResult(index-1);}
supportsCaseSensitiveSearch(){return false;}
supportsRegexSearch(){return false;}
_jumpToSearchResult(index){this._selectSearchResult((index+this._searchResults.length)%this._searchResults.length);this._currentViews[0].highlightSearchResult(this._selectedSearchResult,this._searchRegex,true);}
_selectSearchResult(index){this._selectedSearchResult=this._searchResults[index];this._searchableView.updateCurrentMatchIndex(index);}
_clearHighlight(){this._currentViews[0].highlightSearchResult(null);}
_updateSearchHighlight(revealRecord,shouldJump,jumpBackwards){if(!this._searchRegex){this._clearHighlight();return;}
if(!this._searchResults)
this._updateSearchResults(shouldJump,jumpBackwards);this._currentViews[0].highlightSearchResult(this._selectedSearchResult,this._searchRegex,revealRecord);}
_updateSearchResults(shouldJump,jumpBackwards){if(!this._searchRegex)
return;var events=this._model.mainThreadEvents();var filters=this._filters.concat([new Timeline.TimelineTextFilter(this._searchRegex)]);var matches=[];for(var index=events.lowerBound(this._windowStartTime,(time,event)=>time-event.startTime);index<events.length;++index){var event=events[index];if(event.startTime>this._windowEndTime)
break;if(TimelineModel.TimelineModel.isVisible(filters,event))
matches.push(event);}
var matchesCount=matches.length;if(matchesCount){this._searchResults=matches;this._searchableView.updateSearchMatchesCount(matchesCount);var selectedIndex=matches.indexOf(this._selectedSearchResult);if(shouldJump&&selectedIndex===-1)
selectedIndex=jumpBackwards?this._searchResults.length-1:0;this._selectSearchResult(selectedIndex);}else{this._searchableView.updateSearchMatchesCount(0);delete this._selectedSearchResult;}}
searchCanceled(){this._clearHighlight();delete this._searchResults;delete this._selectedSearchResult;delete this._searchRegex;}
performSearch(searchConfig,shouldJump,jumpBackwards){var query=searchConfig.query;this._searchRegex=createPlainTextSearchRegex(query,'i');delete this._searchResults;this._updateSearchHighlight(true,shouldJump,jumpBackwards);}
_updateSelectionDetails(){switch(this._selection.type()){case Timeline.TimelineSelection.Type.TraceEvent:var event=(this._selection.object());Timeline.TimelineUIUtils.buildTraceEventDetails(event,this._model,this._detailsLinkifier,true,this._appendDetailsTabsForTraceEventAndShowDetails.bind(this,event));break;case Timeline.TimelineSelection.Type.Frame:var frame=(this._selection.object());var screenshotTime=frame.idle?frame.startTime:frame.endTime;var filmStripFrame=filmStripFrame=this._filmStripModel.frameByTimestamp(screenshotTime);if(filmStripFrame&&filmStripFrame.timestamp-frame.endTime>10)
filmStripFrame=null;this.showInDetails(Timeline.TimelineUIUtils.generateDetailsContentForFrame(this._frameModel,frame,filmStripFrame));if(frame.layerTree){var layersView=this._layersView();layersView.showLayerTree(frame.layerTree);if(!this._detailsView.hasTab(Timeline.TimelinePanel.DetailsTab.LayerViewer)){this._detailsView.appendTab(Timeline.TimelinePanel.DetailsTab.LayerViewer,Common.UIString('Layers'),layersView);}}
break;case Timeline.TimelineSelection.Type.NetworkRequest:var request=(this._selection.object());Timeline.TimelineUIUtils.buildNetworkRequestDetails(request,this._model,this._detailsLinkifier).then(this.showInDetails.bind(this));break;case Timeline.TimelineSelection.Type.Range:this._updateSelectedRangeStats(this._selection._startTime,this._selection._endTime);break;}
this._detailsView.updateContents(this._selection);}
_frameForSelection(selection){switch(selection.type()){case Timeline.TimelineSelection.Type.Frame:return(selection.object());case Timeline.TimelineSelection.Type.Range:return null;case Timeline.TimelineSelection.Type.TraceEvent:return this._frameModel.filteredFrames(selection._endTime,selection._endTime)[0];default:console.assert(false,'Should never be reached');return null;}}
_jumpToFrame(offset){var currentFrame=this._frameForSelection(this._selection);if(!currentFrame)
return;var frames=this._frameModel.frames();var index=frames.indexOf(currentFrame);console.assert(index>=0,'Can\'t find current frame in the frame list');index=Number.constrain(index+offset,0,frames.length-1);var frame=frames[index];this._revealTimeRange(frame.startTime,frame.endTime);this.select(Timeline.TimelineSelection.fromFrame(frame));return true;}
_showSnapshotInPaintProfiler(snapshot){var paintProfilerView=this._paintProfilerView();var hasProfileData=paintProfilerView.setSnapshot(snapshot);if(!this._detailsView.hasTab(Timeline.TimelinePanel.DetailsTab.PaintProfiler)){this._detailsView.appendTab(Timeline.TimelinePanel.DetailsTab.PaintProfiler,Common.UIString('Paint Profiler'),paintProfilerView,undefined,undefined,true);}
this._detailsView.selectTab(Timeline.TimelinePanel.DetailsTab.PaintProfiler,true);}
_appendDetailsTabsForTraceEventAndShowDetails(event,content){this.showInDetails(content);if(event.name===TimelineModel.TimelineModel.RecordType.Paint||event.name===TimelineModel.TimelineModel.RecordType.RasterTask)
this._showEventInPaintProfiler(event);}
_showEventInPaintProfiler(event){var target=SDK.targetManager.mainTarget();if(!target)
return;var paintProfilerView=this._paintProfilerView();var hasProfileData=paintProfilerView.setEvent(target,event);if(!hasProfileData)
return;if(!this._detailsView.hasTab(Timeline.TimelinePanel.DetailsTab.PaintProfiler)){this._detailsView.appendTab(Timeline.TimelinePanel.DetailsTab.PaintProfiler,Common.UIString('Paint Profiler'),paintProfilerView,undefined,undefined,false);}}
_updateSelectedRangeStats(startTime,endTime){this.showInDetails(Timeline.TimelineUIUtils.buildRangeStats(this._model,startTime,endTime));}
select(selection,preferredTab){if(!selection)
selection=Timeline.TimelineSelection.fromRange(this._windowStartTime,this._windowEndTime);this._selection=selection;this._detailsLinkifier.reset();if(preferredTab)
this._detailsView.setPreferredTab(preferredTab);for(var view of this._currentViews)
view.setSelection(selection);this._updateSelectionDetails();}
selectEntryAtTime(time){var events=this._model.mainThreadEvents();for(var index=events.upperBound(time,(time,event)=>time-event.startTime)-1;index>=0;--index){var event=events[index];var endTime=event.endTime||event.startTime;if(SDK.TracingModel.isTopLevelEvent(event)&&endTime<time)
break;if(TimelineModel.TimelineModel.isVisible(this._filters,event)&&endTime>=time){this.select(Timeline.TimelineSelection.fromTraceEvent(event));return;}}
this.select(null);}
highlightEvent(event){for(var view of this._currentViews)
view.highlightEvent(event);}
_revealTimeRange(startTime,endTime){var timeShift=0;if(this._windowEndTime<endTime)
timeShift=endTime-this._windowEndTime;else if(this._windowStartTime>startTime)
timeShift=startTime-this._windowStartTime;if(timeShift)
this.requestWindowTimes(this._windowStartTime+timeShift,this._windowEndTime+timeShift);}
showInDetails(node){this._detailsView.setContent(node);}
_handleDrop(dataTransfer){var items=dataTransfer.items;if(!items.length)
return;var item=items[0];if(item.kind==='string'){var url=dataTransfer.getData('text/uri-list');if(new Common.ParsedURL(url).isValid)
this._loadFromURL(url);}else if(item.kind==='file'){var entry=items[0].webkitGetAsEntry();if(!entry.isFile)
return;entry.file(this._loadFromFile.bind(this));}}
_setAutoWindowTimes(){var tasks=this._model.mainThreadTasks();if(!tasks.length){this.requestWindowTimes(this._tracingModel.minimumRecordTime(),this._tracingModel.maximumRecordTime());return;}
function findLowUtilizationRegion(startIndex,stopIndex){var threshold=0.1;var cutIndex=startIndex;var cutTime=(tasks[cutIndex].startTime()+tasks[cutIndex].endTime())/2;var usedTime=0;var step=Math.sign(stopIndex-startIndex);for(var i=startIndex;i!==stopIndex;i+=step){var task=tasks[i];var taskTime=(task.startTime()+task.endTime())/2;var interval=Math.abs(cutTime-taskTime);if(usedTime<threshold*interval){cutIndex=i;cutTime=taskTime;usedTime=0;}
usedTime+=task.endTime()-task.startTime();}
return cutIndex;}
var rightIndex=findLowUtilizationRegion(tasks.length-1,0);var leftIndex=findLowUtilizationRegion(0,rightIndex);var leftTime=tasks[leftIndex].startTime();var rightTime=tasks[rightIndex].endTime();var span=rightTime-leftTime;var totalSpan=this._tracingModel.maximumRecordTime()-this._tracingModel.minimumRecordTime();if(span<totalSpan*0.1){leftTime=this._tracingModel.minimumRecordTime();rightTime=this._tracingModel.maximumRecordTime();}else{leftTime=Math.max(leftTime-0.05*span,this._tracingModel.minimumRecordTime());rightTime=Math.min(rightTime+0.05*span,this._tracingModel.maximumRecordTime());}
this.requestWindowTimes(leftTime,rightTime);}};Timeline.TimelinePanel.Perspectives={Load:'Load',Responsiveness:'Responsiveness',JavaScript:'JavaScript',Custom:'Custom'};Timeline.TimelinePanel.DetailsTab={Details:'Details',Events:'Events',CallTree:'CallTree',BottomUp:'BottomUp',PaintProfiler:'PaintProfiler',LayerViewer:'LayerViewer'};Timeline.TimelinePanel.State={Idle:Symbol('Idle'),StartPending:Symbol('StartPending'),Recording:Symbol('Recording'),StopPending:Symbol('StopPending'),Loading:Symbol('Loading')};Timeline.TimelinePanel.rowHeight=18;Timeline.TimelinePanel.headerHeight=20;Timeline.TimelineLifecycleDelegate=function(){};Timeline.TimelineLifecycleDelegate.prototype={recordingStarted(){},recordingProgress(usage){},loadingStarted(){},loadingProgress(progress){},loadingComplete(success){},};Timeline.TimelineDetailsView=class extends UI.TabbedPane{constructor(timelineModel,filters,delegate){super();this.element.classList.add('timeline-details');var tabIds=Timeline.TimelinePanel.DetailsTab;this._defaultDetailsWidget=new UI.VBox();this._defaultDetailsWidget.element.classList.add('timeline-details-view');this._defaultDetailsContentElement=this._defaultDetailsWidget.element.createChild('div','timeline-details-view-body vbox');this.appendTab(tabIds.Details,Common.UIString('Summary'),this._defaultDetailsWidget);this.setPreferredTab(tabIds.Details);this._rangeDetailViews=new Map();var bottomUpView=new Timeline.BottomUpTimelineTreeView(timelineModel,filters);this.appendTab(tabIds.BottomUp,Common.UIString('Bottom-Up'),bottomUpView);this._rangeDetailViews.set(tabIds.BottomUp,bottomUpView);var callTreeView=new Timeline.CallTreeTimelineTreeView(timelineModel,filters);this.appendTab(tabIds.CallTree,Common.UIString('Call Tree'),callTreeView);this._rangeDetailViews.set(tabIds.CallTree,callTreeView);var eventsView=new Timeline.EventsTimelineTreeView(timelineModel,filters,delegate);this.appendTab(tabIds.Events,Common.UIString('Event Log'),eventsView);this._rangeDetailViews.set(tabIds.Events,eventsView);this.addEventListener(UI.TabbedPane.Events.TabSelected,this._tabSelected,this);}
setContent(node){var allTabs=this.otherTabs(Timeline.TimelinePanel.DetailsTab.Details);for(var i=0;i<allTabs.length;++i){if(!this._rangeDetailViews.has(allTabs[i]))
this.closeTab(allTabs[i]);}
this._defaultDetailsContentElement.removeChildren();this._defaultDetailsContentElement.appendChild(node);}
updateContents(selection){this._selection=selection;var view=this.selectedTabId?this._rangeDetailViews.get(this.selectedTabId):null;if(view)
view.updateContents(selection);}
appendTab(id,tabTitle,view,tabTooltip,userGesture,isCloseable){super.appendTab(id,tabTitle,view,tabTooltip,userGesture,isCloseable);if(this._preferredTabId!==this.selectedTabId)
this.selectTab(id);}
setPreferredTab(tabId){this._preferredTabId=tabId;}
_tabSelected(event){if(!event.data.isUserGesture)
return;this.setPreferredTab(event.data.tabId);this.updateContents(this._selection);}};Timeline.TimelineSelection=class{constructor(type,startTime,endTime,object){this._type=type;this._startTime=startTime;this._endTime=endTime;this._object=object||null;}
static fromFrame(frame){return new Timeline.TimelineSelection(Timeline.TimelineSelection.Type.Frame,frame.startTime,frame.endTime,frame);}
static fromNetworkRequest(request){return new Timeline.TimelineSelection(Timeline.TimelineSelection.Type.NetworkRequest,request.startTime,request.endTime||request.startTime,request);}
static fromTraceEvent(event){return new Timeline.TimelineSelection(Timeline.TimelineSelection.Type.TraceEvent,event.startTime,event.endTime||(event.startTime+1),event);}
static fromRange(startTime,endTime){return new Timeline.TimelineSelection(Timeline.TimelineSelection.Type.Range,startTime,endTime);}
type(){return this._type;}
object(){return this._object;}
startTime(){return this._startTime;}
endTime(){return this._endTime;}};Timeline.TimelineSelection.Type={Frame:'Frame',NetworkRequest:'NetworkRequest',TraceEvent:'TraceEvent',Range:'Range'};Timeline.TimelineModeView=function(){};Timeline.TimelineModeView.prototype={view(){},dispose(){},resizerElement(){},reset(){},refreshRecords(){},highlightSearchResult(event,regex,select){},setWindowTimes(startTime,endTime){},setSelection(selection){},highlightEvent(event){}};Timeline.TimelineModeViewDelegate=function(){};Timeline.TimelineModeViewDelegate.prototype={requestWindowTimes(startTime,endTime){},select(selection,preferredTab){},selectEntryAtTime(time){},showInDetails(node){},highlightEvent(event){}};Timeline.TimelineCategoryFilter=class extends TimelineModel.TimelineModel.Filter{constructor(){super();}
accept(event){return!Timeline.TimelineUIUtils.eventStyle(event).category.hidden;}};Timeline.TimelineIsLongFilter=class extends TimelineModel.TimelineModel.Filter{constructor(){super();this._minimumRecordDuration=0;}
setMinimumRecordDuration(value){this._minimumRecordDuration=value;}
accept(event){var duration=event.endTime?event.endTime-event.startTime:0;return duration>=this._minimumRecordDuration;}};Timeline.TimelineTextFilter=class extends TimelineModel.TimelineModel.Filter{constructor(regExp){super();this._regExp;this._setRegExp(regExp||null);}
_setRegExp(regExp){this._regExp=regExp;}
accept(event){return!this._regExp||Timeline.TimelineUIUtils.testContentMatching(event,this._regExp);}};Timeline.TimelinePanel.StatusPane=class extends UI.VBox{constructor(showTimer,stopCallback){super(true);this.registerRequiredCSS('timeline/timelineStatusDialog.css');this.contentElement.classList.add('timeline-status-dialog');var statusLine=this.contentElement.createChild('div','status-dialog-line status');statusLine.createChild('div','label').textContent=Common.UIString('Status');this._status=statusLine.createChild('div','content');if(showTimer){var timeLine=this.contentElement.createChild('div','status-dialog-line time');timeLine.createChild('div','label').textContent=Common.UIString('Time');this._time=timeLine.createChild('div','content');}
var progressLine=this.contentElement.createChild('div','status-dialog-line progress');this._progressLabel=progressLine.createChild('div','label');this._progressBar=progressLine.createChild('div','indicator-container').createChild('div','indicator');this._stopButton=createTextButton(Common.UIString('Stop'),stopCallback);this.contentElement.createChild('div','stop-button').appendChild(this._stopButton);}
finish(){this._stopTimer();this._stopButton.disabled=true;}
hide(){this.element.parentNode.classList.remove('tinted');this.element.remove();}
showPane(parent){this.show(parent);parent.classList.add('tinted');}
updateStatus(text){this._status.textContent=text;}
updateProgressBar(activity,percent){this._progressLabel.textContent=activity;this._progressBar.style.width=percent.toFixed(1)+'%';this._updateTimer();}
startTimer(){this._startTime=Date.now();this._timeUpdateTimer=setInterval(this._updateTimer.bind(this,false),1000);this._updateTimer();}
_stopTimer(){if(!this._timeUpdateTimer)
return;clearInterval(this._timeUpdateTimer);this._updateTimer(true);delete this._timeUpdateTimer;}
_updateTimer(precise){if(!this._timeUpdateTimer)
return;var elapsed=(Date.now()-this._startTime)/1000;this._time.textContent=Common.UIString('%s\u2009sec',elapsed.toFixed(precise?1:0));}};Timeline.LoadTimelineHandler=class{handleQueryParam(value){UI.viewManager.showView('timeline').then(()=>{Timeline.TimelinePanel.instance()._loadFromURL(window.decodeURIComponent(value));});}};Timeline.TimelinePanel.ActionDelegate=class{handleAction(context,actionId){var panel=UI.context.flavor(Timeline.TimelinePanel);console.assert(panel&&panel instanceof Timeline.TimelinePanel);switch(actionId){case'timeline.toggle-recording':panel._toggleRecording();return true;case'timeline.save-to-file':panel._saveToFile();return true;case'timeline.load-from-file':panel._selectFileToLoad();return true;case'timeline.jump-to-previous-frame':panel._jumpToFrame(-1);return true;case'timeline.jump-to-next-frame':panel._jumpToFrame(1);return true;}
return false;}};Timeline.TimelineFilters=class extends Common.Object{constructor(){super();this._categoryFilter=new Timeline.TimelineCategoryFilter();this._durationFilter=new Timeline.TimelineIsLongFilter();this._textFilter=new Timeline.TimelineTextFilter();this._filters=[this._categoryFilter,this._durationFilter,this._textFilter];this._createFilterBar();}
filters(){return this._filters;}
searchRegExp(){return this._textFilter._regExp;}
filterButton(){return this._filterBar.filterButton();}
filtersWidget(){return this._filterBar;}
_createFilterBar(){this._filterBar=new UI.FilterBar('timelinePanel');this._textFilterUI=new UI.TextFilterUI();this._textFilterUI.addEventListener(UI.FilterUI.Events.FilterChanged,textFilterChanged,this);this._filterBar.addFilter(this._textFilterUI);var durationOptions=[];for(var durationMs of Timeline.TimelineFilters._durationFilterPresetsMs){var durationOption={};if(!durationMs){durationOption.label=Common.UIString('All');durationOption.title=Common.UIString('Show all records');}else{durationOption.label=Common.UIString('\u2265 %dms',durationMs);durationOption.title=Common.UIString('Hide records shorter than %dms',durationMs);}
durationOption.value=durationMs;durationOptions.push(durationOption);}
var durationFilterUI=new UI.ComboBoxFilterUI(durationOptions);durationFilterUI.addEventListener(UI.FilterUI.Events.FilterChanged,durationFilterChanged,this);this._filterBar.addFilter(durationFilterUI);var categoryFiltersUI={};var categories=Timeline.TimelineUIUtils.categories();for(var categoryName in categories){var category=categories[categoryName];if(!category.visible)
continue;var filter=new UI.CheckboxFilterUI(category.name,category.title);filter.setColor(category.color,'rgba(0, 0, 0, 0.2)');categoryFiltersUI[category.name]=filter;filter.addEventListener(UI.FilterUI.Events.FilterChanged,categoriesFilterChanged.bind(this,categoryName));this._filterBar.addFilter(filter);}
return this._filterBar;function textFilterChanged(){var searchQuery=this._textFilterUI.value();this._textFilter._setRegExp(searchQuery?createPlainTextSearchRegex(searchQuery,'i'):null);this._notifyFiltersChanged();}
function durationFilterChanged(){var duration=durationFilterUI.value();var minimumRecordDuration=parseInt(duration,10);this._durationFilter.setMinimumRecordDuration(minimumRecordDuration);this._notifyFiltersChanged();}
function categoriesFilterChanged(name){var categories=Timeline.TimelineUIUtils.categories();categories[name].hidden=!categoryFiltersUI[name].checked();this._notifyFiltersChanged();}}
_notifyFiltersChanged(){this.dispatchEventToListeners(Timeline.TimelineFilters.Events.FilterChanged);}};Timeline.TimelineFilters.Events={FilterChanged:Symbol('FilterChanged')};Timeline.TimelineFilters._durationFilterPresetsMs=[0,1,15];Timeline.CPUThrottlingManager=class extends Common.Object{constructor(){super();this._targets=[];this._throttlingRate=1.;SDK.targetManager.observeTargets(this,SDK.Target.Capability.Browser);}
setRate(value){this._throttlingRate=value;this._targets.forEach(target=>target.emulationAgent().setCPUThrottlingRate(value));if(value!==1)
UI.inspectorView.setPanelIcon('timeline','smallicon-warning',Common.UIString('CPU throttling is enabled'));else
UI.inspectorView.setPanelIcon('timeline','','');}
rate(){return this._throttlingRate;}
targetAdded(target){this._targets.push(target);target.emulationAgent().setCPUThrottlingRate(this._throttlingRate);}
targetRemoved(target){this._targets.remove(target,true);}};;Runtime.cachedResources["timeline/invalidationsTree.css"]="/*\n * Copyright 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.header, .children, .content {\n    min-height: initial;\n    line-height: initial;\n}\n\n/* This TreeElement is always expanded and has no arrow.   */\n/* FIXME(crbug.com/475618): Implement this in TreeElement. */\n.children li::before {\n    display: none;\n}\n\n.content {\n    margin-bottom: 4px;\n}\n\n.content .stack-preview-container {\n    margin-left: 8px;\n}\n\n.content .node-list {\n    margin-left: 10px;\n}\n\n/*# sourceURL=timeline/invalidationsTree.css */";Runtime.cachedResources["timeline/timelineFlamechartPopover.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.timeline-flamechart-popover {\n    overflow: hidden;\n}\n\n.timeline-flamechart-popover span {\n    margin-right: 5px;\n}\n\n.timeline-flamechart-popover span.timeline-info-network-time {\n    color: #009;\n}\n\n.timeline-flamechart-popover span.timeline-info-time {\n    color: #282;\n}\n\n.timeline-flamechart-popover span.timeline-info-warning {\n    color: #e44;\n}\n\n.timeline-flamechart-popover span.timeline-info-warning * {\n    color: inherit;\n}\n\n/*# sourceURL=timeline/timelineFlamechartPopover.css */";Runtime.cachedResources["timeline/timelinePanel.css"]="/*\n * Copyright (C) 2006, 2007, 2008 Apple Inc.  All rights reserved.\n * Copyright (C) 2009 Anthony Ricaud <rik@webkit.org>\n *\n * Redistribution and use in source and binary forms, with or without\n * modification, are permitted provided that the following conditions\n * are met:\n *\n * 1.  Redistributions of source code must retain the above copyright\n *     notice, this list of conditions and the following disclaimer.\n * 2.  Redistributions in binary form must reproduce the above copyright\n *     notice, this list of conditions and the following disclaimer in the\n *     documentation and/or other materials provided with the distribution.\n * 3.  Neither the name of Apple Computer, Inc. (\"Apple\") nor the names of\n *     its contributors may be used to endorse or promote products derived\n *     from this software without specific prior written permission.\n *\n * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS \"AS IS\" AND ANY\n * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\n * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\n * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY\n * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES\n * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;\n * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND\n * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF\n * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n */\n\n.panel.timeline > .toolbar {\n    border-bottom: 1px solid #dadada;\n}\n\n#timeline-overview-panel {\n    flex: none;\n    position: relative;\n    border-bottom: 1px solid rgb(140, 140, 140);\n}\n\n#timeline-overview-panel .timeline-graph-bar {\n    pointer-events: none;\n}\n\n#timeline-overview-grid {\n    background-color: rgb(255, 255, 255);\n}\n\n#timeline-overview-grid .timeline-grid-header {\n    height: 12px;\n}\n\n#timeline-overview-grid .resources-dividers-label-bar {\n    pointer-events: auto;\n    height: 12px;\n}\n\n#timeline-overview-grid .resources-divider-label {\n    top: 1px;\n}\n\n.timeline-details-split {\n    flex: auto;\n}\n\n.timeline-view-stack {\n    flex: auto;\n    display: flex;\n}\n\n#timeline-container .devtools-link {\n    color: inherit;\n}\n\n.timeline-graph-side.hovered {\n    background-color: rgba(0, 0, 0, 0.05) !important;\n}\n\n.timeline.panel .status-pane-container {\n    z-index: 1000;\n    pointer-events: none;\n    display: flex;\n    align-items: center;\n}\n\n.timeline.panel .status-pane-container.tinted {\n    background-color: hsla(0, 0%, 90%, 0.8);\n    pointer-events: auto;\n}\n\n#timeline-overview-panel .overview-strip {\n    margin-top: 2px;\n    justify-content: center;\n}\n\n#timeline-overview-panel .overview-strip .timeline-overview-strip-title {\n    color: #666;\n    font-size: 10px;\n    font-weight: bold;\n    z-index: 100;\n    background-color: rgba(255, 255, 255, 0.7);\n    padding: 0 4px;\n    position: absolute;\n    top: 0;\n    right: 0;\n}\n\n#timeline-overview-cpu-activity {\n    flex-basis: 25px;\n}\n\n#timeline-overview-network,\n#timeline-overview-framerate {\n    flex-basis: 20px;\n}\n\n#timeline-overview-filmstrip {\n    flex-basis: 40px;\n}\n\n#timeline-overview-memory {\n    flex-basis: 22px;\n}\n\n#timeline-overview-framerate::before,\n#timeline-overview-network::before,\n#timeline-overview-cpu-activity::before {\n    content: \"\";\n    position: absolute;\n    left: 0;\n    right: 0;\n    bottom: 0;\n    border-bottom: 1px solid hsla(0, 0%, 0%, 0.06);\n    z-index: -200;\n}\n\n.overview-strip .background {\n    z-index: -10;\n}\n\n#timeline-overview-responsiveness {\n    flex-basis: 6px;\n    margin-top: 1px !important;\n}\n\n#timeline-overview-input {\n    flex-basis: 6px;\n}\n\n#timeline-overview-pane {\n    flex: auto;\n    position: relative;\n    overflow: hidden;\n}\n\n#timeline-overview-container {\n    display: flex;\n    flex-direction: column;\n    flex: none;\n    position: relative;\n    overflow: hidden;\n}\n\n#timeline-overview-container canvas {\n    width: 100%;\n    height: 100%;\n}\n\n#timeline-graphs {\n    position: absolute;\n    left: 0;\n    right: 0;\n    max-height: 100%;\n    top: 20px;\n}\n\n.timeline-aggregated-legend-title {\n    display: inline-block;\n}\n\n.timeline-aggregated-legend-value {\n    display: inline-block;\n    width: 70px;\n    text-align: right;\n}\n\n.timeline-aggregated-legend-swatch {\n    display: inline-block;\n    width: 11px;\n    height: 11px;\n    margin: 0 6px;\n    position: relative;\n    top: 1px;\n    border: 1px solid rgba(0, 0, 0, 0.2);\n}\n\n.popover ul {\n    margin: 0;\n    padding: 0;\n    list-style-type: none;\n}\n\n#resources-container-content {\n    overflow: hidden;\n    min-height: 100%;\n}\n\n.timeline-toolbar-resizer {\n    background-image: url(Images/toolbarResizerVertical.png);\n    background-repeat: no-repeat;\n    background-position: right center, center;\n}\n\n.memory-graph-label {\n    position: absolute;\n    right: 0;\n    bottom: 0;\n    font-size: 9px;\n    color: #888;\n    white-space: nowrap;\n    padding: 0 4px;\n    background-color: hsla(0, 0%, 100%, 0.8);\n}\n\n#memory-graphs-canvas-container {\n    overflow: hidden;\n    flex: auto;\n    position: relative;\n}\n\n#memory-counters-graph {\n    flex: auto;\n}\n\n#memory-graphs-canvas-container .memory-counter-marker {\n    position: absolute;\n    border-radius: 3px;\n    width: 5px;\n    height: 5px;\n    margin-left: -3px;\n    margin-top: -2px;\n}\n\n#memory-graphs-container .memory-counter-selector-swatches {\n    flex: 0 0 24px;\n    padding: 5px 0;\n    background-color: #eee;\n    border-bottom: 1px solid #ddd;\n}\n\n.memory-counter-selector-info {\n    flex: 0 0 auto;\n    margin-left: 5px;\n    white-space: nowrap;\n}\n\n.memory-counter-selector-info .range {\n    margin: 0 4px;\n    align-items: center;\n    display: inline-flex;\n}\n\n.memory-counter-value {\n    margin: 8px;\n}\n\n#counter-values-bar {\n    flex: 0 0 20px;\n    border-top: solid 1px lightgray;\n    width: 100%;\n    overflow: hidden;\n    line-height: 18px;\n}\n\n.image-preview-container {\n    background: transparent;\n    text-align: left;\n    border-spacing: 0;\n}\n\n.image-preview-container img {\n    max-width: 100px;\n    max-height: 100px;\n    background-image: url(Images/checker.png);\n    -webkit-user-select: text;\n    -webkit-user-drag: auto;\n}\n\n.image-container {\n    padding: 0;\n}\n\n.timeline-filters-header {\n    overflow: hidden;\n    flex: none;\n}\n\n.timeline-details {\n    vertical-align: top;\n}\n\n.timeline-details-title {\n    border-bottom: 1px solid #B8B8B8;\n    font-weight: bold;\n    padding-bottom: 5px;\n    padding-top: 0;\n    white-space: nowrap;\n}\n\n.timeline-details-row-title {\n    font-weight: bold;\n    text-align: right;\n    white-space: nowrap;\n}\n\n.timeline-details-row-data {\n    white-space: nowrap;\n}\n\n.timeline-details-view {\n    color: #333;\n    overflow: hidden;\n}\n\n.timeline-details-view-body {\n    flex: auto;\n    overflow: auto;\n    position: relative;\n    background-color: #f3f3f3;\n}\n\n.timeline-details-view-body > div {\n    overflow: hidden;\n}\n\n.timeline-details-view-block {\n    flex: none;\n    display: flex;\n    background-color: white;\n    flex-direction: column;\n    padding-bottom: 5px;\n    border-bottom: 1px solid #ccc;\n}\n\n.timeline-details-view-row {\n    padding-left: 10px;\n    flex-direction: row;\n    display: flex;\n    line-height: 20px;\n}\n\n.timeline-details-view-block .timeline-details-stack-values {\n    flex-direction: column !important;\n}\n\n.timeline-details-chip-title {\n    font-size: 13px;\n    padding: 8px;\n    display: flex;\n    align-items: center;\n}\n\n.timeline-details-chip-title > div {\n    width: 12px;\n    height: 12px;\n    border: 1px solid rgba(0, 0, 0, 0.2);\n    display: inline-block;\n    margin-right: 4px;\n    content: \" \";\n}\n\n.timeline-details-view-row-title {\n    color: rgb(152, 152, 152);\n    overflow: hidden;\n}\n\n.timeline-details-warning {\n    background-color: rgba(250, 209, 209, 0.48);\n}\n\n.timeline-details-warning .timeline-details-view-row-title {\n    color: red;\n}\n\n.timeline-details-warning .timeline-details-view-row-value {\n    white-space: nowrap;\n    overflow: hidden;\n    text-overflow: ellipsis;\n}\n\n.timeline-details-view-row-value {\n    -webkit-user-select: text;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    overflow: hidden;\n    padding-left: 10px;\n}\n\n.timeline-details-view-row-value .stack-preview-container {\n    line-height: 11px;\n}\n\n.timeline-details-view-row-value .timeline-details-warning-marker {\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    overflow: hidden;\n}\n\n.timeline-details-view-pie-chart-wrapper {\n    margin: 4px 0;\n}\n\n.timeline-details-view-pie-chart {\n    margin-top: 5px;\n}\n\n.timeline-details-view-pie-chart-total {\n    width: 100px;\n    margin-top: 10px;\n    text-align: center;\n}\n\n.timeline-details-view-row-stack-trace {\n    padding: 4px 0;\n    line-height: inherit;\n}\n\n.timeline-details-view-row-stack-trace div {\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    line-height: 12px;\n}\n\n.timeline-aggregated-info-legend > div {\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n}\n\n.timeline-flamechart {\n    overflow: hidden;\n}\n\n.timeline-status-pane.full-widget-dimmed-banner {\n    text-align: left !important;\n}\n\n.timeline-layers-view > div:last-child,\n.timeline-layers-view-properties > div:last-child {\n    background-color: #eee;\n}\n\n.timeline-layers-view-properties table {\n    width: 100%;\n    border-collapse: collapse;\n}\n\n.timeline-layers-view-properties td {\n    border: 1px solid #e1e1e1;\n    line-height: 22px;\n}\n\n.timeline-paint-profiler-log-split > div:last-child {\n    background-color: #eee;\n    z-index: 0;\n}\n\n.timeline-gap {\n    flex: none;\n}\n\n.timeline-filmstrip-preview {\n    margin-top: 10px;\n    max-width: 200px;\n    max-height: 200px;\n    cursor: pointer;\n    border: 1px solid #ddd;\n}\n\n.timeline-overview-popover .frame .time {\n    display: none;\n}\n\n.timeline-overview-popover .frame .thumbnail img {\n    max-width: 200px;\n}\n\n.timeline-tree-view {\n    display: flex;\n    overflow: hidden;\n}\n\n.timeline-tree-view > .toolbar {\n    border-bottom: 1px solid #dadada;\n}\n\n.timeline-tree-view .data-grid {\n    border: none;\n    flex: auto;\n}\n\n.timeline-tree-view .data-grid .data-container {\n    overflow-y: scroll;\n}\n\n.timeline-tree-view .data-grid.data-grid-fits-viewport .corner {\n    display: table-cell;\n}\n\n.timeline-tree-view .data-grid table.data {\n    background: white;\n}\n\n.timeline-tree-view .data-grid tr:not(.selected) .highlight {\n    background-color: rgb(255, 230, 179);\n}\n\n.timeline-tree-view .data-grid tr:hover td:not(.bottom-filler-td) {\n    background-color: rgba(0, 0, 0, 0.1);\n}\n\n.timeline-tree-view .data-grid td.numeric-column {\n    text-align: right;\n    position: relative;\n}\n\n.timeline-tree-view .data-grid div.background-percent-bar {\n    float: right;\n}\n\n.timeline-tree-view .data-grid span.percent-column {\n    color: #888;\n    width: 44px;\n    display: inline-block;\n}\n\n.timeline-tree-view .data-grid tr.selected span {\n    color: inherit;\n}\n\n.timeline-tree-view .data-grid .name-container {\n    display: flex;\n    align-items: center;\n}\n\n.timeline-tree-view .data-grid .name-container div {\n    flex: none;\n}\n\n.timeline-tree-view .data-grid .name-container .activity-icon {\n    width: 10px;\n    height: 10px;\n    margin: 0 4px 0 2px;\n    border: 1px solid rgba(0, 0, 0, 0.05);\n}\n\n.timeline-tree-view .data-grid .name-container .activity-warning::after {\n    content: \"[deopt]\";\n    margin: 0 4px;\n    line-height: 12px;\n    font-size: 10px;\n    color: #777;\n}\n\n.timeline-tree-view .data-grid tr.selected .name-container .activity-warning::after {\n    color: white;\n}\n\n.timeline-tree-view .data-grid .name-container .activity-link {\n    flex: auto;\n    text-align: right;\n    overflow: hidden;\n    text-overflow: ellipsis;\n    margin-left: 5px;\n}\n\n.timeline-tree-view .data-grid .background-bar-container {\n    position: absolute;\n    left: 3px;\n    right: 0;\n}\n\n.timeline-tree-view .data-grid .background-bar {\n    float: right;\n    height: 15px;\n    background-color: hsla(43, 84%, 64%, 0.2);\n    border-bottom: 1px solid hsl(43, 84%, 64%);\n}\n\n.timeline-tree-view .data-grid .selected .background-bar {\n    background-color: rgba(255, 255, 255, 0.25);\n    border-bottom-color: transparent;\n}\n\n.timeline-tree-view .timeline-details-view-body .full-widget-dimmed-banner {\n    background-color: inherit;\n}\n\n.timeline-details .filter-input-field {\n    width: 120px;\n}\n\n.timeline-tree-view .data-grid .header-container {\n    height: 21px;\n}\n\n.timeline-tree-view .data-grid .data-container {\n    top: 21px;\n}\n\n.timeline-tree-view .data-grid th {\n    border-bottom: 1px solid #ddd;\n    background-color: #f3f3f3\n}\n\n.timeline-stack-view-header {\n    height: 26px;\n    background-color: white;\n    padding: 6px 10px;\n    color: #5a5a5a;\n    white-space: nowrap;\n}\n\n/*# sourceURL=timeline/timelinePanel.css */";Runtime.cachedResources["timeline/timelinePaintProfiler.css"]="/*\n * Copyright 2016 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.paint-profiler-image-view {\n    overflow: hidden;\n}\n\n.paint-profiler-image-view .paint-profiler-image-container {\n    -webkit-transform-origin: 0 0;\n}\n\n.paint-profiler-image-view .paint-profiler-image-container div {\n    border-color: rgba(100, 100, 100, 0.4);\n    border-style: solid;\n    z-index: 100;\n    position: absolute;\n    top: 0;\n    left: 0;\n}\n\n.paint-profiler-image-view img {\n    border: solid 1px black;\n}\n\n/*# sourceURL=timeline/timelinePaintProfiler.css */";Runtime.cachedResources["timeline/timelineStatusDialog.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.timeline-status-dialog {\n    display: flex;\n    flex-direction: column;\n    padding: 12px 16px;\n    align-self: center;\n    background-color: white;\n    box-shadow: 0 0 0 1px rgba(0, 0, 0, 0.2),\n                0 2px 4px rgba(0, 0, 0, 0.2),\n                0 2px 6px rgba(0, 0, 0, 0.1);\n    margin-top: -1px;\n}\n\n.status-dialog-line {\n    margin: 2px;\n    height: 14px;\n    display: flex;\n    align-items: baseline;\n}\n\n.status-dialog-line .label {\n    display: inline-block;\n    width: 80px;\n    text-align: right;\n    color: #aaa;\n    margin-right: 10px;\n}\n\n.timeline-status-dialog .progress .indicator-container {\n    display: inline-block;\n    width: 200px;\n    height: 8px;\n    background-color: #f4f4f4;\n    display: inline-block;\n    margin: 0 10px 0 0;\n}\n\n.timeline-status-dialog .progress .indicator {\n    background-color: rgb(112, 166, 255);\n    height: 100%;\n    width: 0;\n    margin: 0;\n}\n\n.timeline-status-dialog .stop-button {\n    margin-top: 8px;\n    height: 100%;\n    align-self: center;\n}\n\n/*# sourceURL=timeline/timelineStatusDialog.css */";