WebInspector.EditFileSystemView=function(fileSystemPath)
{WebInspector.VBox.call(this,true);this.registerRequiredCSS("settings/editFileSystemView.css");this._fileSystemPath=fileSystemPath;this._eventListeners=[WebInspector.fileSystemMapping.addEventListener(WebInspector.FileSystemMapping.Events.FileMappingAdded,this._update,this),WebInspector.fileSystemMapping.addEventListener(WebInspector.FileSystemMapping.Events.FileMappingRemoved,this._update,this),WebInspector.isolatedFileSystemManager.addEventListener(WebInspector.IsolatedFileSystemManager.Events.ExcludedFolderAdded,this._update,this),WebInspector.isolatedFileSystemManager.addEventListener(WebInspector.IsolatedFileSystemManager.Events.ExcludedFolderRemoved,this._update,this)];var mappingsHeader=this.contentElement.createChild("div","file-system-header");mappingsHeader.createChild("div","file-system-header-text").textContent=WebInspector.UIString("Mappings");mappingsHeader.appendChild(createTextButton(WebInspector.UIString("Add"),this._addMappingButtonClicked.bind(this),"add-button"));this._mappingsList=new WebInspector.ListWidget(this);this._mappingsList.element.classList.add("file-system-list");this._mappingsList.registerRequiredCSS("settings/editFileSystemView.css");var mappingsPlaceholder=createElementWithClass("div","file-system-list-empty");mappingsPlaceholder.textContent=WebInspector.UIString("No mappings");this._mappingsList.setEmptyPlaceholder(mappingsPlaceholder);this._mappingsList.show(this.contentElement);var excludedFoldersHeader=this.contentElement.createChild("div","file-system-header");excludedFoldersHeader.createChild("div","file-system-header-text").textContent=WebInspector.UIString("Excluded folders");excludedFoldersHeader.appendChild(createTextButton(WebInspector.UIString("Add"),this._addExcludedFolderButtonClicked.bind(this),"add-button"));this._excludedFoldersList=new WebInspector.ListWidget(this);this._excludedFoldersList.element.classList.add("file-system-list");this._excludedFoldersList.registerRequiredCSS("settings/editFileSystemView.css");var excludedFoldersPlaceholder=createElementWithClass("div","file-system-list-empty");excludedFoldersPlaceholder.textContent=WebInspector.UIString("No excluded folders");this._excludedFoldersList.setEmptyPlaceholder(excludedFoldersPlaceholder);this._excludedFoldersList.show(this.contentElement);this.contentElement.tabIndex=0;this._update();}
WebInspector.EditFileSystemView.prototype={dispose:function()
{WebInspector.EventTarget.removeEventListeners(this._eventListeners);},_update:function()
{if(this._muteUpdate)
return;this._mappingsList.clear();this._mappings=[];var mappings=WebInspector.fileSystemMapping.mappingEntries(this._fileSystemPath);for(var entry of mappings){if(entry.configurable){this._mappingsList.appendItem(entry,true);this._mappings.push(entry);}}
for(var entry of mappings){if(!entry.configurable){this._mappingsList.appendItem(entry,false);this._mappings.push(entry);}}
this._excludedFoldersList.clear();this._excludedFolders=[];for(var folder of WebInspector.isolatedFileSystemManager.fileSystem(this._fileSystemPath).excludedFolders().values()){this._excludedFolders.push(folder);this._excludedFoldersList.appendItem(folder,true);}
for(var folder of WebInspector.isolatedFileSystemManager.fileSystem(this._fileSystemPath).nonConfigurableExcludedFolders().values()){this._excludedFolders.push(folder);this._excludedFoldersList.appendItem(folder,false);}},_addMappingButtonClicked:function()
{var entry=new WebInspector.FileSystemMapping.Entry(this._fileSystemPath,"","",true);this._mappingsList.addNewItem(0,entry);},_addExcludedFolderButtonClicked:function()
{this._excludedFoldersList.addNewItem(0,"");},renderItem:function(item,editable)
{var element=createElementWithClass("div","file-system-list-item");if(!editable)
element.classList.add("locked");if(item instanceof WebInspector.FileSystemMapping.Entry){var entry=(item);var urlPrefix=entry.configurable?entry.urlPrefix:WebInspector.UIString("%s (via .devtools)",entry.urlPrefix);var urlPrefixElement=element.createChild("div","file-system-value");urlPrefixElement.textContent=urlPrefix;urlPrefixElement.title=urlPrefix;element.createChild("div","file-system-separator");var pathPrefixElement=element.createChild("div","file-system-value");pathPrefixElement.textContent=entry.pathPrefix;pathPrefixElement.title=entry.pathPrefix;}else{var pathPrefix=(editable?item:WebInspector.UIString("%s (via .devtools)",item));var pathPrefixElement=element.createChild("div","file-system-value");pathPrefixElement.textContent=pathPrefix;pathPrefixElement.title=pathPrefix;}
element.createChild("div","file-system-locked").title=WebInspector.UIString("From .devtools file");return element;},removeItemRequested:function(item,index)
{if(item instanceof WebInspector.FileSystemMapping.Entry){var entry=this._mappings[index];WebInspector.fileSystemMapping.removeFileMapping(entry.fileSystemPath,entry.urlPrefix,entry.pathPrefix);}else{WebInspector.isolatedFileSystemManager.fileSystem(this._fileSystemPath).removeExcludedFolder(this._excludedFolders[index]);}},commitEdit:function(item,editor,isNew)
{this._muteUpdate=true;if(item instanceof WebInspector.FileSystemMapping.Entry){var entry=(item);if(!isNew)
WebInspector.fileSystemMapping.removeFileMapping(this._fileSystemPath,entry.urlPrefix,entry.pathPrefix);WebInspector.fileSystemMapping.addFileMapping(this._fileSystemPath,this._normalizePrefix(editor.control("urlPrefix").value),this._normalizePrefix(editor.control("pathPrefix").value));}else{if(!isNew)
WebInspector.isolatedFileSystemManager.fileSystem(this._fileSystemPath).removeExcludedFolder((item));WebInspector.isolatedFileSystemManager.fileSystem(this._fileSystemPath).addExcludedFolder(this._normalizePrefix(editor.control("pathPrefix").value));}
this._muteUpdate=false;this._update();},beginEdit:function(item)
{if(item instanceof WebInspector.FileSystemMapping.Entry){var entry=(item);var editor=this._createMappingEditor();editor.control("urlPrefix").value=entry.urlPrefix;editor.control("pathPrefix").value=entry.pathPrefix;return editor;}else{var editor=this._createExcludedFolderEditor();editor.control("pathPrefix").value=item;return editor;}},_createMappingEditor:function()
{if(this._mappingEditor)
return this._mappingEditor;var editor=new WebInspector.ListWidget.Editor();this._mappingEditor=editor;var content=editor.contentElement();var titles=content.createChild("div","file-system-edit-row");titles.createChild("div","file-system-value").textContent=WebInspector.UIString("URL prefix");titles.createChild("div","file-system-separator file-system-separator-invisible");titles.createChild("div","file-system-value").textContent=WebInspector.UIString("Folder path");var fields=content.createChild("div","file-system-edit-row");fields.createChild("div","file-system-value").appendChild(editor.createInput("urlPrefix","text","http://localhost:8000/url",urlPrefixValidator.bind(this)));fields.createChild("div","file-system-separator file-system-separator-invisible");fields.createChild("div","file-system-value").appendChild(editor.createInput("pathPrefix","text","/path/to/folder/",pathPrefixValidator.bind(this)));return editor;function urlPrefixValidator(item,index,input)
{var prefix=this._normalizePrefix(input.value);for(var i=0;i<this._mappings.length;++i){if(i!==index&&this._mappings[i].configurable&&this._mappings[i].urlPrefix===prefix)
return false;}
return!!prefix;}
function pathPrefixValidator(item,index,input)
{var prefix=this._normalizePrefix(input.value);for(var i=0;i<this._mappings.length;++i){if(i!==index&&this._mappings[i].configurable&&this._mappings[i].pathPrefix===prefix)
return false;}
return!!prefix;}},_createExcludedFolderEditor:function()
{if(this._excludedFolderEditor)
return this._excludedFolderEditor;var editor=new WebInspector.ListWidget.Editor();this._excludedFolderEditor=editor;var content=editor.contentElement();var titles=content.createChild("div","file-system-edit-row");titles.createChild("div","file-system-value").textContent=WebInspector.UIString("Folder path");var fields=content.createChild("div","file-system-edit-row");fields.createChild("div","file-system-value").appendChild(editor.createInput("pathPrefix","text","/path/to/folder/",pathPrefixValidator.bind(this)));return editor;function pathPrefixValidator(item,index,input)
{var prefix=this._normalizePrefix(input.value);var configurableCount=WebInspector.isolatedFileSystemManager.fileSystem(this._fileSystemPath).excludedFolders().size;for(var i=0;i<configurableCount;++i){if(i!==index&&this._excludedFolders[i]===prefix)
return false;}
return!!prefix;}},_normalizePrefix:function(prefix)
{if(!prefix)
return"";return prefix+(prefix[prefix.length-1]==="/"?"":"/");},__proto__:WebInspector.VBox.prototype};WebInspector.SettingsScreen=function()
{WebInspector.VBox.call(this,true);this.registerRequiredCSS("settings/settingsScreen.css");this.contentElement.tabIndex=0;this.contentElement.classList.add("help-window-main");this.contentElement.classList.add("vbox");var settingsLabelElement=createElement("div");WebInspector.createShadowRootWithCoreStyles(settingsLabelElement,"settings/settingsScreen.css").createChild("div","settings-window-title").textContent=WebInspector.UIString("Settings");this._tabbedLocation=WebInspector.viewManager.createTabbedLocation(()=>WebInspector.SettingsScreen._showSettingsScreen(),"settings-view");var tabbedPane=this._tabbedLocation.tabbedPane();tabbedPane.leftToolbar().appendToolbarItem(new WebInspector.ToolbarItem(settingsLabelElement));tabbedPane.setShrinkableTabs(false);tabbedPane.setVerticalTabLayout(true);var shortcutsView=new WebInspector.SimpleView(WebInspector.UIString("Shortcuts"));WebInspector.shortcutsScreen.createShortcutsTabView().show(shortcutsView.element);this._tabbedLocation.appendView(shortcutsView);tabbedPane.show(this.contentElement);this.element.addEventListener("keydown",this._keyDown.bind(this),false);this._developerModeCounter=0;this.setDefaultFocusedElement(this.contentElement);}
WebInspector.SettingsScreen._showSettingsScreen=function(name)
{var settingsScreen=(self.runtime.sharedInstance(WebInspector.SettingsScreen));if(settingsScreen.isShowing())
return;var dialog=new WebInspector.Dialog();dialog.addCloseButton();settingsScreen.show(dialog.element);dialog.show();settingsScreen._selectTab(name||"preferences");}
WebInspector.SettingsScreen.prototype={resolveLocation:function(locationName)
{return this._tabbedLocation;},_selectTab:function(name)
{WebInspector.viewManager.showView(name);},_keyDown:function(event)
{var shiftKeyCode=16;if(event.keyCode===shiftKeyCode&&++this._developerModeCounter>5)
this.contentElement.classList.add("settings-developer-mode");},__proto__:WebInspector.VBox.prototype}
WebInspector.SettingsTab=function(name,id)
{WebInspector.VBox.call(this);this.element.classList.add("settings-tab-container");if(id)
this.element.id=id;var header=this.element.createChild("header");header.createChild("h3").createTextChild(name);this.containerElement=this.element.createChild("div","help-container-wrapper").createChild("div","settings-tab help-content help-container");}
WebInspector.SettingsTab.prototype={_appendSection:function(name)
{var block=this.containerElement.createChild("div","help-block");if(name)
block.createChild("div","help-section-title").textContent=name;return block;},_createSelectSetting:function(name,options,setting)
{var p=createElement("p");p.createChild("label").textContent=name;var select=p.createChild("select","chrome-select");var settingValue=setting.get();for(var i=0;i<options.length;++i){var option=options[i];select.add(new Option(option[0],option[1]));if(settingValue===option[1])
select.selectedIndex=i;}
function changeListener(e)
{setting.set(options[select.selectedIndex][1]);}
select.addEventListener("change",changeListener,false);return p;},__proto__:WebInspector.VBox.prototype}
WebInspector.GenericSettingsTab=function()
{WebInspector.SettingsTab.call(this,WebInspector.UIString("Preferences"),"preferences-tab-content");var explicitSectionOrder=["","Appearance","Elements","Sources","Network","Profiler","Console","Extensions"];this._nameToSection=new Map();this._nameToSettingElement=new Map();for(var sectionName of explicitSectionOrder)
this._sectionElement(sectionName);self.runtime.extensions("setting").forEach(this._addSetting.bind(this));self.runtime.extensions(WebInspector.SettingUI).forEach(this._addSettingUI.bind(this));this._appendSection().appendChild(createTextButton(WebInspector.UIString("Restore defaults and reload"),restoreAndReload));function restoreAndReload()
{WebInspector.settings.clearAll();WebInspector.reload();}}
WebInspector.GenericSettingsTab.isSettingVisible=function(extension)
{var descriptor=extension.descriptor();if(!("title"in descriptor))
return false;if(!("category"in descriptor))
return false;return true;}
WebInspector.GenericSettingsTab.prototype={_addSetting:function(extension)
{if(!WebInspector.GenericSettingsTab.isSettingVisible(extension))
return;var descriptor=extension.descriptor();var sectionName=descriptor["category"];var settingName=descriptor["settingName"];var setting=WebInspector.moduleSetting(settingName);var uiTitle=WebInspector.UIString(extension.title());var sectionElement=this._sectionElement(sectionName);var settingControl;switch(descriptor["settingType"]){case"boolean":settingControl=WebInspector.SettingsUI.createSettingCheckbox(uiTitle,setting);break;case"enum":var descriptorOptions=descriptor["options"];var options=new Array(descriptorOptions.length);for(var i=0;i<options.length;++i){var optionName=descriptorOptions[i]["raw"]?descriptorOptions[i]["text"]:WebInspector.UIString(descriptorOptions[i]["text"]);options[i]=[optionName,descriptorOptions[i]["value"]];}
settingControl=this._createSelectSetting(uiTitle,options,setting);break;default:console.error("Invalid setting type: "+descriptor["settingType"]);return;}
this._nameToSettingElement.set(settingName,settingControl);sectionElement.appendChild((settingControl));},_addSettingUI:function(extension)
{var descriptor=extension.descriptor();var sectionName=descriptor["category"]||"";extension.instance().then(appendCustomSetting.bind(this));function appendCustomSetting(object)
{var settingUI=(object);var element=settingUI.settingElement();if(element)
this._sectionElement(sectionName).appendChild(element);}},_sectionElement:function(sectionName)
{var sectionElement=this._nameToSection.get(sectionName);if(!sectionElement){var uiSectionName=sectionName&&WebInspector.UIString(sectionName);sectionElement=this._appendSection(uiSectionName);this._nameToSection.set(sectionName,sectionElement);}
return sectionElement;},__proto__:WebInspector.SettingsTab.prototype}
WebInspector.WorkspaceSettingsTab=function()
{WebInspector.SettingsTab.call(this,WebInspector.UIString("Workspace"),"workspace-tab-content");WebInspector.isolatedFileSystemManager.addEventListener(WebInspector.IsolatedFileSystemManager.Events.FileSystemAdded,this._fileSystemAdded,this);WebInspector.isolatedFileSystemManager.addEventListener(WebInspector.IsolatedFileSystemManager.Events.FileSystemRemoved,this._fileSystemRemoved,this);var folderExcludePatternInput=this._createFolderExcludePatternInput();folderExcludePatternInput.classList.add("folder-exclude-pattern");this.containerElement.appendChild(folderExcludePatternInput);this._fileSystemsListContainer=this.containerElement.createChild("div","");this.containerElement.appendChild(createTextButton(WebInspector.UIString("Add folder\u2026"),this._addFileSystemClicked.bind(this)));this._elementByPath=new Map();this._mappingViewByPath=new Map();var fileSystems=WebInspector.isolatedFileSystemManager.fileSystems();for(var i=0;i<fileSystems.length;++i)
this._addItem(fileSystems[i]);}
WebInspector.WorkspaceSettingsTab.prototype={_createFolderExcludePatternInput:function()
{var p=createElement("p");var labelElement=p.createChild("label");labelElement.textContent=WebInspector.UIString("Folder exclude pattern");var inputElement=p.createChild("input");inputElement.type="text";inputElement.style.width="270px";var folderExcludeSetting=WebInspector.isolatedFileSystemManager.workspaceFolderExcludePatternSetting();var setValue=WebInspector.bindInput(inputElement,folderExcludeSetting.set.bind(folderExcludeSetting),regexValidator,false);folderExcludeSetting.addChangeListener(()=>setValue.call(null,folderExcludeSetting.get()));setValue(folderExcludeSetting.get());return p;function regexValidator(value)
{var regex;try{regex=new RegExp(value);}catch(e){}
return!!regex;}},_addItem:function(fileSystem)
{var element=this._renderFileSystem(fileSystem);this._elementByPath.set(fileSystem.path(),element);this._fileSystemsListContainer.appendChild(element);var mappingView=new WebInspector.EditFileSystemView(fileSystem.path());this._mappingViewByPath.set(fileSystem.path(),mappingView);mappingView.element.classList.add("file-system-mapping-view");mappingView.show(element);},_renderFileSystem:function(fileSystem)
{var fileSystemPath=fileSystem.path();var lastIndexOfSlash=fileSystemPath.lastIndexOf(WebInspector.isWin()?"\\":"/");var folderName=fileSystemPath.substr(lastIndexOfSlash+1);var element=createElementWithClass("div","file-system-container");var header=element.createChild("div","file-system-header");header.createChild("div","file-system-name").textContent=folderName;var path=header.createChild("div","file-system-path");path.textContent=fileSystemPath;path.title=fileSystemPath;var toolbar=new WebInspector.Toolbar("");var button=new WebInspector.ToolbarButton(WebInspector.UIString("Remove"),"delete-toolbar-item");button.addEventListener("click",this._removeFileSystemClicked.bind(this,fileSystem));toolbar.appendToolbarItem(button);header.appendChild(toolbar.element);return element;},_removeFileSystemClicked:function(fileSystem)
{WebInspector.isolatedFileSystemManager.removeFileSystem(fileSystem);},_addFileSystemClicked:function()
{WebInspector.isolatedFileSystemManager.addFileSystem();},_fileSystemAdded:function(event)
{var fileSystem=(event.data);this._addItem(fileSystem);},_fileSystemRemoved:function(event)
{var fileSystem=(event.data);var mappingView=this._mappingViewByPath.get(fileSystem.path());if(mappingView){mappingView.dispose();this._mappingViewByPath.delete(fileSystem.path());}
var element=this._elementByPath.get(fileSystem.path());if(element){this._elementByPath.delete(fileSystem.path());element.remove();}},__proto__:WebInspector.SettingsTab.prototype}
WebInspector.ExperimentsSettingsTab=function()
{WebInspector.SettingsTab.call(this,WebInspector.UIString("Experiments"),"experiments-tab-content");var experiments=Runtime.experiments.allConfigurableExperiments();if(experiments.length){var experimentsSection=this._appendSection();experimentsSection.appendChild(this._createExperimentsWarningSubsection());for(var i=0;i<experiments.length;++i)
experimentsSection.appendChild(this._createExperimentCheckbox(experiments[i]));}}
WebInspector.ExperimentsSettingsTab.prototype={_createExperimentsWarningSubsection:function()
{var subsection=createElement("div");var warning=subsection.createChild("span","settings-experiments-warning-subsection-warning");warning.textContent=WebInspector.UIString("WARNING:");subsection.createTextChild(" ");var message=subsection.createChild("span","settings-experiments-warning-subsection-message");message.textContent=WebInspector.UIString("These experiments could be dangerous and may require restart.");return subsection;},_createExperimentCheckbox:function(experiment)
{var label=createCheckboxLabel(WebInspector.UIString(experiment.title),experiment.isEnabled());var input=label.checkboxElement;input.name=experiment.name;function listener()
{experiment.setEnabled(input.checked);}
input.addEventListener("click",listener,false);var p=createElement("p");p.className=experiment.hidden&&!experiment.isEnabled()?"settings-experiment-hidden":"";p.appendChild(label);return p;},__proto__:WebInspector.SettingsTab.prototype}
WebInspector.SettingsScreen.ActionDelegate=function(){}
WebInspector.SettingsScreen.ActionDelegate.prototype={handleAction:function(context,actionId)
{switch(actionId){case"settings.show":WebInspector.SettingsScreen._showSettingsScreen();return true;case"settings.help":InspectorFrontendHost.openInNewTab("https://developers.google.com/web/tools/chrome-devtools/");return true;case"settings.shortcuts":WebInspector.SettingsScreen._showSettingsScreen(WebInspector.UIString("Shortcuts"));return true;}
return false;}}
WebInspector.SettingsScreen.Revealer=function(){}
WebInspector.SettingsScreen.Revealer.prototype={reveal:function(object)
{console.assert(object instanceof WebInspector.Setting);var setting=(object);var success=false;self.runtime.extensions("setting").forEach(revealModuleSetting);self.runtime.extensions(WebInspector.SettingUI).forEach(revealSettingUI);self.runtime.extensions("view").forEach(revealSettingsView);return success?Promise.resolve():Promise.reject();function revealModuleSetting(extension)
{if(!WebInspector.GenericSettingsTab.isSettingVisible(extension))
return;if(extension.descriptor()["settingName"]===setting.name){InspectorFrontendHost.bringToFront();WebInspector.SettingsScreen._showSettingsScreen();success=true;}}
function revealSettingUI(extension)
{var settings=extension.descriptor()["settings"];if(settings&&settings.indexOf(setting.name)!==-1){InspectorFrontendHost.bringToFront();WebInspector.SettingsScreen._showSettingsScreen();success=true;}}
function revealSettingsView(extension)
{var location=extension.descriptor()["location"];if(location!=="settings-view")
return;var settings=extension.descriptor()["settings"];if(settings&&settings.indexOf(setting.name)!==-1){InspectorFrontendHost.bringToFront();WebInspector.SettingsScreen._showSettingsScreen(extension.descriptor()["id"]);success=true;}}}};WebInspector.FrameworkBlackboxSettingsTab=function()
{WebInspector.VBox.call(this,true);this.registerRequiredCSS("settings/frameworkBlackboxSettingsTab.css");this.contentElement.createChild("div","header").textContent=WebInspector.UIString("Framework Blackbox Patterns");this.contentElement.createChild("div","blackbox-content-scripts").appendChild(WebInspector.SettingsUI.createSettingCheckbox(WebInspector.UIString("Blackbox content scripts"),WebInspector.moduleSetting("skipContentScripts"),true));this._blackboxLabel=WebInspector.UIString("Blackbox");this._disabledLabel=WebInspector.UIString("Disabled");this._list=new WebInspector.ListWidget(this);this._list.element.classList.add("blackbox-list");this._list.registerRequiredCSS("settings/frameworkBlackboxSettingsTab.css");var placeholder=createElementWithClass("div","blackbox-list-empty");placeholder.textContent=WebInspector.UIString("No blackboxed patterns");this._list.setEmptyPlaceholder(placeholder);this._list.show(this.contentElement);var addPatternButton=createTextButton(WebInspector.UIString("Add pattern..."),this._addButtonClicked.bind(this),"add-button");this.contentElement.appendChild(addPatternButton);this._setting=WebInspector.moduleSetting("skipStackFramesPattern");this._setting.addChangeListener(this._settingUpdated,this);this.setDefaultFocusedElement(addPatternButton);this.contentElement.tabIndex=0;}
WebInspector.FrameworkBlackboxSettingsTab.prototype={wasShown:function()
{WebInspector.SettingsTab.prototype.wasShown.call(this);this._settingUpdated();},_settingUpdated:function()
{this._list.clear();var patterns=this._setting.getAsArray();for(var i=0;i<patterns.length;++i)
this._list.appendItem(patterns[i],true);},_addButtonClicked:function()
{this._list.addNewItem(this._setting.getAsArray().length,{pattern:"",disabled:false});},renderItem:function(item,editable)
{var element=createElementWithClass("div","blackbox-list-item");var pattern=element.createChild("div","blackbox-pattern");pattern.textContent=item.pattern;pattern.title=item.pattern;element.createChild("div","blackbox-separator");element.createChild("div","blackbox-behavior").textContent=item.disabled?this._disabledLabel:this._blackboxLabel;if(item.disabled)
element.classList.add("blackbox-disabled");return element;},removeItemRequested:function(item,index)
{var patterns=this._setting.getAsArray();patterns.splice(index,1);this._setting.setAsArray(patterns);},commitEdit:function(item,editor,isNew)
{item.pattern=editor.control("pattern").value.trim();item.disabled=editor.control("behavior").value===this._disabledLabel;var list=this._setting.getAsArray();if(isNew)
list.push(item);this._setting.setAsArray(list);},beginEdit:function(item)
{var editor=this._createEditor();editor.control("pattern").value=item.pattern;editor.control("behavior").value=item.disabled?this._disabledLabel:this._blackboxLabel;return editor;},_createEditor:function()
{if(this._editor)
return this._editor;var editor=new WebInspector.ListWidget.Editor();this._editor=editor;var content=editor.contentElement();var titles=content.createChild("div","blackbox-edit-row");titles.createChild("div","blackbox-pattern").textContent=WebInspector.UIString("Pattern");titles.createChild("div","blackbox-separator blackbox-separator-invisible");titles.createChild("div","blackbox-behavior").textContent=WebInspector.UIString("Behavior");var fields=content.createChild("div","blackbox-edit-row");fields.createChild("div","blackbox-pattern").appendChild(editor.createInput("pattern","text","/framework\\.js$",patternValidator.bind(this)));fields.createChild("div","blackbox-separator blackbox-separator-invisible");fields.createChild("div","blackbox-behavior").appendChild(editor.createSelect("behavior",[this._blackboxLabel,this._disabledLabel],behaviorValidator));return editor;function patternValidator(item,index,input)
{var pattern=input.value.trim();var patterns=this._setting.getAsArray();for(var i=0;i<patterns.length;++i){if(i!==index&&patterns[i].pattern===pattern)
return false;}
var regex;try{regex=new RegExp(pattern);}catch(e){}
return!!(pattern&&regex);}
function behaviorValidator(item,index,input)
{return true;}},__proto__:WebInspector.VBox.prototype};Runtime.cachedResources["settings/editFileSystemView.css"]="/*\n * Copyright 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.file-system-header {\n    display: flex;\n    flex-direction: row;\n    align-items: center;\n    flex: auto;\n    margin: 10px 0;\n}\n\n.file-system-header-text {\n    font-size: 14px;\n    flex: auto;\n}\n\n.add-button {\n    margin-left: 10px;\n    align-self: flex-start;\n}\n\n.file-system-list {\n    flex: auto;\n}\n\n.file-system-list-empty {\n    flex: auto;\n    height: 30px;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n}\n\n.file-system-list-item {\n    padding: 3px 5px 3px 5px;\n    height: 30px;\n    display: flex;\n    align-items: center;\n    flex: auto 1 1;\n}\n\n.file-system-value {\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    -webkit-user-select: none;\n    color: #222;\n    flex: 1 1 0px;\n    overflow: hidden;\n}\n\n.file-system-separator {\n    flex: 0 0 1px;\n    background-color: rgb(231, 231, 231);\n    height: 30px;\n    margin: 0 4px;\n}\n\n.file-system-separator-invisible {\n    visibility: hidden;\n    height: 100% !important;\n}\n\n.file-system-edit-row {\n    flex: none;\n    display: flex;\n    flex-direction: row;\n    margin: 6px 5px;\n    align-items: center;\n}\n\n.file-system-edit-row input {\n    width: 100%;\n    text-align: inherit;\n}\n\n.file-system-locked {\n    flex: none;\n    visibility: hidden;\n}\n\n.file-system-locked:after {\n    content: \"\\1F512\";\n}\n\n.file-system-list-item.locked .file-system-locked {\n    visibility: visible;\n}\n\n/*# sourceURL=settings/editFileSystemView.css */";Runtime.cachedResources["settings/frameworkBlackboxSettingsTab.css"]="/*\n * Copyright 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:host {\n    overflow:hidden;\n}\n\n.header {\n    padding: 0 0 6px;\n    border-bottom: 1px solid #EEEEEE;\n    font-size: 18px;\n    font-weight: normal;\n    flex: none;\n}\n\n.blackbox-content-scripts {\n    margin-top: 10px;\n    flex: none;\n}\n\n.add-button {\n    margin: 10px 0;\n    align-self: flex-start;\n    flex: none;\n}\n\n.blackbox-list {\n    margin-top: 10px;\n    max-width: 500px;\n    flex: 0 1 auto;\n    min-height: 30px;\n}\n\n.blackbox-list-empty {\n    flex: auto;\n    height: 30px;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n}\n\n.blackbox-list-item {\n    padding: 3px 5px 3px 5px;\n    height: 30px;\n    display: flex;\n    align-items: center;\n    position: relative;\n    flex: auto 1 1;\n}\n\n.blackbox-pattern {\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    -webkit-user-select: none;\n    color: #222;\n    flex: auto;\n    overflow: hidden;\n}\n\n.blackbox-list-item.blackbox-disabled .blackbox-pattern {\n    text-decoration: line-through;\n}\n\n.blackbox-behavior {\n    flex: 0 0 100px;\n    padding-left: 10px;\n}\n\n.blackbox-behavior > select {\n    margin-left: -10px;\n}\n\n.blackbox-separator {\n    flex: 0 0 1px;\n    background-color: rgb(231, 231, 231);\n    height: 30px;\n    margin: 0 4px;\n}\n\n.blackbox-separator-invisible {\n    visibility: hidden;\n    height: 100% !important;\n}\n\n.blackbox-edit-row {\n    flex: none;\n    display: flex;\n    flex-direction: row;\n    margin: 6px 5px;\n    align-items: center;\n}\n\n.blackbox-edit-row input,\n.blackbox-edit-row select {\n    width: 100%;\n    text-align: inherit;\n}\n\n/*# sourceURL=settings/frameworkBlackboxSettingsTab.css */";Runtime.cachedResources["settings/settingsScreen.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.help-window-main {\n    color: rgb(48, 57, 66);\n    background-color: white;\n    padding: 11px 0 0 0;\n}\n\n.help-window-caption {\n    border-bottom: solid 1px rgb(153, 153, 153);\n    margin: 0 8px;\n    padding: 0 2px;\n    line-height: 28px;\n}\n\n.help-content {\n    overflow-y: auto;\n    overflow-x: hidden;\n    margin: 8px 8px 8px 0;\n    padding: 0 4px;\n    flex: auto;\n}\n\n.help-footnote {\n    border-top: 1px solid #EEEEEE;\n    margin: 0;\n    padding: 12px;\n}\n\n.help-window-main .help-container-wrapper::-webkit-scrollbar {\n    width: 11px;\n}\n\n.help-window-main .help-container-wrapper::-webkit-scrollbar-corner,\n.help-window-main .help-container-wrapper::-webkit-resizer {\n    display: none;\n}\n\n.help-window-main .help-container-wrapper::-webkit-scrollbar-thumb:vertical {\n    background: linear-gradient(to right, rgb(128, 128, 128), rgb(96, 96, 96) 40%, rgb(128, 128, 128));\n    border-radius: 5px;\n    min-height: 20px;\n}\n\n.help-window-main .help-container-wrapper::-webkit-scrollbar-thumb:vertical:hover,\n.help-window-main .help-container-wrapper::-webkit-scrollbar-thumb:vertical:active {\n    background: linear-gradient(to right, rgb(176, 176, 176), rgb(144, 144, 144) 40%, rgb(176, 176, 176));\n}\n\n.help-window-main .help-container-wrapper::-webkit-scrollbar-track:vertical {\n    background: linear-gradient(to right, rgb(10, 10, 10), rgb(32, 32, 32) 25%, rgb(32, 32, 32));\n    border-radius: 5px;\n}\n\n.help-container {\n    width: 100%;\n    -webkit-user-select: auto;\n    -webkit-column-width: 288px;\n}\n\n.help-no-columns {\n    -webkit-column-width: initial !important;\n}\n\n.help-block {\n    display: block;\n    padding-bottom: 9px;\n    width: 288px;\n    -webkit-column-break-inside: avoid;\n}\n\n.settings-tab.help-container {\n    -webkit-column-width: 308px;\n}\n\n.settings-tab .help-block {\n    margin-left: 20px;\n}\n\n.settings-tab .field-error-message {\n    color: DarkRed;\n    height: 0; /* Avoid changing element height when content is set. */\n}\n\n.help-line {\n    padding-bottom: 5px;\n    margin-bottom: 5px;\n}\n\n.help-key-cell {\n    display: inline-block;\n    width: 153px;\n    white-space: nowrap;\n    text-align: right;\n    vertical-align: middle;\n    padding-right: 6px;\n}\n\n.help-cell {\n    display: inline-block;\n    width: 135px;\n    vertical-align: middle;\n}\n\n.help-section-title {\n    font-size: 120%;\n    text-align: left;\n}\n\n.help-key {\n    padding: 0.1em 0.6em;\n    border: 1px solid #ccc;\n    font-size: 11px;\n    background-color: #f7f7f7;\n    color: #333;\n    box-shadow: 0 1px 0 rgba(0, 0, 0, 0.2), 0 0 0 2px #ffffff inset;\n    border-radius: 3px;\n    display: inline-block;\n    margin: 0 0.1em;\n    text-shadow: 0 1px 0 #fff;\n    line-height: 1.5;\n    white-space: nowrap;\n}\n\n.help-combine-keys,\n.help-key-delimiter {\n    font-size: 9px;\n}\n\n.help-combine-keys {\n    margin: 0 0.3em;\n}\n\n.help-key-delimiter {\n    margin: 0 0.5em;\n    display: none;\n}\n\nfieldset {\n    margin: 0;\n    padding: 0;\n    border: none;\n}\n\n.settings-tab label {\n    padding-right: 4px;\n    display: inline-flex;\n}\n\n#general-tab-content .help-block fieldset legend {\n    font-size: 14px;\n}\n\n.help-block p p {\n    padding-left: 30px;\n}\n\n.help-content p.help-section {\n    margin: 0 0 15px 0;\n}\n\n.settings-experiments-warning-subsection-warning {\n    color: rgb(200, 0, 0);\n}\n\n.settings-experiments-warning-subsection-message {\n    color: inherit;\n}\n\n.help-content input[type=checkbox] {\n    margin: 1px 7px 1px 2px;\n}\n\n.settings-window-title {\n    font-size: 18px;\n    color: rgb(48, 57, 66);\n    padding: 0 0 5px 13px;\n}\n\n.help-container-wrapper {\n    position: absolute;\n    top: 31px;\n    left: 0px;\n    right: 0;\n    bottom: 0;\n    overflow: auto;\n    padding-top: 9px;\n}\n\n.settings-tab.help-content {\n    margin: 0;\n    padding: 0;\n}\n\n.settings-tab input:not([type]),\n.settings-tab input[type=\"text\"] {\n    border: 1px solid rgb(213, 213, 213);\n    border-radius: 2px;\n    color: #444444;\n    padding: 3px;\n}\n\n.settings-tab input.numeric {\n    text-align: right;\n}\n\n.settings-tab-container {\n    flex: auto;\n    overflow: hidden;\n}\n\n.settings-tab-container header {\n    padding: 0 0 6px;\n    border-bottom: 1px solid #EEEEEE;\n}\n\n#experiments-tab-content .help-container {\n    -webkit-column-width: 470px;\n}\n\n#experiments-tab-content .help-block {\n    width: 470px;\n    margin-left: 0;\n}\n\n.settings-tab-container header > h3 {\n    font-size: 18px;\n    font-weight: normal;\n    margin: 0;\n    padding-bottom: 3px;\n}\n\n.settings-tab .help-section-title {\n    margin-left: -20px;\n    color: #222;\n}\n\n.settings-tab .help-block fieldset:disabled label:hover {\n    color: inherit;\n}\n\n.settings-tab .help-block label:hover {\n    color: #222;\n}\n\n.settings-tab p {\n    margin: 12px 0;\n}\n\n.settings-tab select {\n    margin-left: 10px;\n}\n\n#workspace-tab-content .settings-tab.help-content.help-container {\n    -webkit-column-width: initial;\n    overflow: hidden;\n}\n\n\n#workspace-tab-content .button:hover {\n    opacity: 1.0 !important;\n}\n\n#workspace-tab-content .help-block {\n    width: auto;\n    margin-right: 20px;\n}\n\np.folder-exclude-pattern {\n    margin-top: 0 !important;\n}\n\n.folder-exclude-pattern input {\n    margin-top: 10px;\n}\n\n.file-system-mapping-view {\n    margin-left: 30px;\n    margin-right: 10px;\n}\n\n.settings-tab .file-system-container {\n    margin-bottom: 18px;\n    padding: 0 8px;\n    border-left: 1px solid hsl(0, 0%, 90%);\n    max-width: 800px;\n}\n\n.settings-tab .file-system-header {\n    display: flex;\n    flex-direction: row;\n    align-items: center;\n}\n\n.settings-tab .file-system-name {\n    font-weight: bold;\n    flex: none;\n    margin-right: 10px;\n    font-size: 15px;\n    overflow: hidden;\n    text-overflow: ellipsis;\n    max-width: 70%;\n}\n\n.settings-tab .file-system-path {\n    white-space: nowrap;\n    overflow: hidden;\n    text-overflow: ellipsis;\n    flex: auto;\n}\n\n.settings-tab .file-system-remove {\n    flex: none;\n    margin-left: 10px;\n}\n\n.help-indent-labels label {\n    padding-left: 10px;\n}\n\n.settings-experiment-hidden {\n    display: none;\n}\n\n.settings-experiment-hidden label {\n    background-color: #ddd;\n}\n\n.settings-developer-mode .settings-experiment-hidden {\n    display: block;\n}\n\n/*# sourceURL=settings/settingsScreen.css */";