WebInspector.LayerPaintProfilerView=function(showImageForLayerCallback)
{WebInspector.SplitWidget.call(this,true,false);this._showImageForLayerCallback=showImageForLayerCallback;this._logTreeView=new WebInspector.PaintProfilerCommandLogView();this.setSidebarWidget(this._logTreeView);this._paintProfilerView=new WebInspector.PaintProfilerView(this._showImage.bind(this));this.setMainWidget(this._paintProfilerView);this._paintProfilerView.addEventListener(WebInspector.PaintProfilerView.Events.WindowChanged,this._onWindowChanged,this);}
WebInspector.LayerPaintProfilerView.prototype={profileLayer:function(layer)
{this._logTreeView.setCommandLog(null,[]);this._paintProfilerView.setSnapshotAndLog(null,[],null);(layer).requestSnapshot(onSnapshotDone.bind(this));function onSnapshotDone(snapshot)
{this._layer=layer;snapshot.commandLog(onCommandLogDone.bind(this,snapshot));}
function onCommandLogDone(snapshot,log)
{this._logTreeView.setCommandLog(snapshot.target(),log||[]);this._paintProfilerView.setSnapshotAndLog(snapshot||null,log||[],null);}},setScale:function(scale)
{this._paintProfilerView.setScale(scale);},_onWindowChanged:function()
{this._logTreeView.updateWindow(this._paintProfilerView.selectionWindow());},_showImage:function(imageURL)
{this._showImageForLayerCallback(this._layer,imageURL);},__proto__:WebInspector.SplitWidget.prototype};;WebInspector.LayerTreeModel=function(target)
{WebInspector.SDKModel.call(this,WebInspector.LayerTreeModel,target);target.registerLayerTreeDispatcher(new WebInspector.LayerTreeDispatcher(this));WebInspector.targetManager.addEventListener(WebInspector.TargetManager.Events.MainFrameNavigated,this._onMainFrameNavigated,this);this._layerTree=null;}
WebInspector.LayerTreeModel.Events={LayerTreeChanged:Symbol("LayerTreeChanged"),LayerPainted:Symbol("LayerPainted"),}
WebInspector.LayerTreeModel.prototype={disable:function()
{if(!this._enabled)
return;this._enabled=false;this.target().layerTreeAgent().disable();},enable:function()
{if(this._enabled)
return;this._enabled=true;this._forceEnable();},_forceEnable:function()
{this._lastPaintRectByLayerId={};if(!this._layerTree)
this._layerTree=new WebInspector.AgentLayerTree(this.target());this.target().layerTreeAgent().enable();},layerTree:function()
{return this._layerTree;},_layerTreeChanged:function(layers)
{if(!this._enabled)
return;var layerTree=(this._layerTree);layerTree.setLayers(layers,onLayersSet.bind(this));function onLayersSet()
{for(var layerId in this._lastPaintRectByLayerId){var lastPaintRect=this._lastPaintRectByLayerId[layerId];var layer=layerTree.layerById(layerId);if(layer)
layer._lastPaintRect=lastPaintRect;}
this._lastPaintRectByLayerId={};this.dispatchEventToListeners(WebInspector.LayerTreeModel.Events.LayerTreeChanged);}},_layerPainted:function(layerId,clipRect)
{if(!this._enabled)
return;var layerTree=(this._layerTree);var layer=layerTree.layerById(layerId);if(!layer){this._lastPaintRectByLayerId[layerId]=clipRect;return;}
layer._didPaint(clipRect);this.dispatchEventToListeners(WebInspector.LayerTreeModel.Events.LayerPainted,layer);},_onMainFrameNavigated:function()
{this._layerTree=null;if(this._enabled)
this._forceEnable();},__proto__:WebInspector.SDKModel.prototype}
WebInspector.AgentLayerTree=function(target)
{WebInspector.LayerTreeBase.call(this,target);}
WebInspector.AgentLayerTree.prototype={setLayers:function(payload,callback)
{if(!payload){onBackendNodeIdsResolved.call(this);return;}
var idsToResolve=new Set();for(var i=0;i<payload.length;++i){var backendNodeId=payload[i].backendNodeId;if(!backendNodeId||this._backendNodeIdToNode.has(backendNodeId))
continue;idsToResolve.add(backendNodeId);}
this._resolveBackendNodeIds(idsToResolve,onBackendNodeIdsResolved.bind(this));function onBackendNodeIdsResolved()
{this._innerSetLayers(payload);callback();}},_innerSetLayers:function(layers)
{this.setRoot(null);this.setContentRoot(null);if(!layers)
return;var root;var oldLayersById=this._layersById;this._layersById={};for(var i=0;i<layers.length;++i){var layerId=layers[i].layerId;var layer=oldLayersById[layerId];if(layer)
layer._reset(layers[i]);else
layer=new WebInspector.AgentLayer(this._target,layers[i]);this._layersById[layerId]=layer;var backendNodeId=layers[i].backendNodeId;if(backendNodeId)
layer._setNode(this._backendNodeIdToNode.get(backendNodeId));if(!this.contentRoot()&&layer.drawsContent())
this.setContentRoot(layer);var parentId=layer.parentId();if(parentId){var parent=this._layersById[parentId];if(!parent)
console.assert(parent,"missing parent "+parentId+" for layer "+layerId);parent.addChild(layer);}else{if(root)
console.assert(false,"Multiple root layers");root=layer;}}
if(root){this.setRoot(root);root._calculateQuad(new WebKitCSSMatrix());}},__proto__:WebInspector.LayerTreeBase.prototype}
WebInspector.AgentLayer=function(target,layerPayload)
{this._target=target;this._reset(layerPayload);}
WebInspector.AgentLayer.prototype={id:function()
{return this._layerPayload.layerId;},parentId:function()
{return this._layerPayload.parentLayerId;},parent:function()
{return this._parent;},isRoot:function()
{return!this.parentId();},children:function()
{return this._children;},addChild:function(child)
{if(child._parent)
console.assert(false,"Child already has a parent");this._children.push(child);child._parent=this;},_setNode:function(node)
{this._node=node;},node:function()
{return this._node;},nodeForSelfOrAncestor:function()
{for(var layer=this;layer;layer=layer._parent){if(layer._node)
return layer._node;}
return null;},offsetX:function()
{return this._layerPayload.offsetX;},offsetY:function()
{return this._layerPayload.offsetY;},width:function()
{return this._layerPayload.width;},height:function()
{return this._layerPayload.height;},transform:function()
{return this._layerPayload.transform;},quad:function()
{return this._quad;},anchorPoint:function()
{return[this._layerPayload.anchorX||0,this._layerPayload.anchorY||0,this._layerPayload.anchorZ||0,];},invisible:function()
{return this._layerPayload.invisible;},paintCount:function()
{return this._paintCount||this._layerPayload.paintCount;},lastPaintRect:function()
{return this._lastPaintRect;},scrollRects:function()
{return this._scrollRects;},requestCompositingReasons:function(callback)
{if(!this._target){callback([]);return;}
var wrappedCallback=InspectorBackend.wrapClientCallback(callback,"LayerTreeAgent.reasonsForCompositingLayer(): ",undefined,[]);this._target.layerTreeAgent().compositingReasons(this.id(),wrappedCallback);},drawsContent:function()
{return this._layerPayload.drawsContent;},gpuMemoryUsage:function()
{var bytesPerPixel=4;return this.drawsContent()?this.width()*this.height()*bytesPerPixel:0;},requestSnapshot:function(callback)
{if(!this._target){callback();return;}
var wrappedCallback=InspectorBackend.wrapClientCallback(callback,"LayerTreeAgent.makeSnapshot(): ",WebInspector.PaintProfilerSnapshot.bind(null,this._target));this._target.layerTreeAgent().makeSnapshot(this.id(),wrappedCallback);},_didPaint:function(rect)
{this._lastPaintRect=rect;this._paintCount=this.paintCount()+1;this._image=null;},_reset:function(layerPayload)
{this._node=null;this._children=[];this._parent=null;this._paintCount=0;this._layerPayload=layerPayload;this._image=null;this._scrollRects=this._layerPayload.scrollRects||[];},_matrixFromArray:function(a)
{function toFixed9(x){return x.toFixed(9);}
return new WebKitCSSMatrix("matrix3d("+a.map(toFixed9).join(",")+")");},_calculateTransformToViewport:function(parentTransform)
{var offsetMatrix=new WebKitCSSMatrix().translate(this._layerPayload.offsetX,this._layerPayload.offsetY);var matrix=offsetMatrix;if(this._layerPayload.transform){var transformMatrix=this._matrixFromArray(this._layerPayload.transform);var anchorVector=new WebInspector.Geometry.Vector(this._layerPayload.width*this.anchorPoint()[0],this._layerPayload.height*this.anchorPoint()[1],this.anchorPoint()[2]);var anchorPoint=WebInspector.Geometry.multiplyVectorByMatrixAndNormalize(anchorVector,matrix);var anchorMatrix=new WebKitCSSMatrix().translate(-anchorPoint.x,-anchorPoint.y,-anchorPoint.z);matrix=anchorMatrix.inverse().multiply(transformMatrix.multiply(anchorMatrix.multiply(matrix)));}
matrix=parentTransform.multiply(matrix);return matrix;},_createVertexArrayForRect:function(width,height)
{return[0,0,0,width,0,0,width,height,0,0,height,0];},_calculateQuad:function(parentTransform)
{var matrix=this._calculateTransformToViewport(parentTransform);this._quad=[];var vertices=this._createVertexArrayForRect(this._layerPayload.width,this._layerPayload.height);for(var i=0;i<4;++i){var point=WebInspector.Geometry.multiplyVectorByMatrixAndNormalize(new WebInspector.Geometry.Vector(vertices[i*3],vertices[i*3+1],vertices[i*3+2]),matrix);this._quad.push(point.x,point.y);}
function calculateQuadForLayer(layer)
{layer._calculateQuad(matrix);}
this._children.forEach(calculateQuadForLayer);}}
WebInspector.LayerTreeDispatcher=function(layerTreeModel)
{this._layerTreeModel=layerTreeModel;}
WebInspector.LayerTreeDispatcher.prototype={layerTreeDidChange:function(layers)
{this._layerTreeModel._layerTreeChanged(layers||null);},layerPainted:function(layerId,clipRect)
{this._layerTreeModel._layerPainted(layerId,clipRect);}}
WebInspector.LayerTreeModel.fromTarget=function(target)
{if(!target.hasDOMCapability())
return null;var model=(target.model(WebInspector.LayerTreeModel));if(!model)
model=new WebInspector.LayerTreeModel(target);return model;};WebInspector.LayersPanel=function()
{WebInspector.PanelWithSidebar.call(this,"layers",225);this._model=null;WebInspector.targetManager.observeTargets(this);this._layerViewHost=new WebInspector.LayerViewHost();this._layerTreeOutline=new WebInspector.LayerTreeOutline(this._layerViewHost);this.panelSidebarElement().appendChild(this._layerTreeOutline.element);this.setDefaultFocusedElement(this._layerTreeOutline.element);this._rightSplitWidget=new WebInspector.SplitWidget(false,true,"layerDetailsSplitViewState");this.splitWidget().setMainWidget(this._rightSplitWidget);this._layers3DView=new WebInspector.Layers3DView(this._layerViewHost);this._rightSplitWidget.setMainWidget(this._layers3DView);this._layers3DView.addEventListener(WebInspector.Layers3DView.Events.LayerSnapshotRequested,this._onSnapshotRequested,this);this._layers3DView.addEventListener(WebInspector.Layers3DView.Events.ScaleChanged,this._onScaleChanged,this);this._tabbedPane=new WebInspector.TabbedPane();this._rightSplitWidget.setSidebarWidget(this._tabbedPane);this._layerDetailsView=new WebInspector.LayerDetailsView(this._layerViewHost);this._tabbedPane.appendTab(WebInspector.LayersPanel.DetailsViewTabs.Details,WebInspector.UIString("Details"),this._layerDetailsView);this._paintProfilerView=new WebInspector.LayerPaintProfilerView(this._layers3DView.showImageForLayer.bind(this._layers3DView));this._tabbedPane.appendTab(WebInspector.LayersPanel.DetailsViewTabs.Profiler,WebInspector.UIString("Profiler"),this._paintProfilerView);this._updateThrottler=new WebInspector.Throttler(100);}
WebInspector.LayersPanel.DetailsViewTabs={Details:"details",Profiler:"profiler"};WebInspector.LayersPanel.prototype={focus:function()
{this._layerTreeOutline.focus();},wasShown:function()
{WebInspector.Panel.prototype.wasShown.call(this);if(this._model)
this._model.enable();this._layerTreeOutline.focus();},willHide:function()
{if(this._model)
this._model.disable();WebInspector.Panel.prototype.willHide.call(this);},targetAdded:function(target)
{if(this._model)
return;this._model=WebInspector.LayerTreeModel.fromTarget(target);if(!this._model)
return;this._model.addEventListener(WebInspector.LayerTreeModel.Events.LayerTreeChanged,this._onLayerTreeUpdated,this);this._model.addEventListener(WebInspector.LayerTreeModel.Events.LayerPainted,this._onLayerPainted,this);if(this.isShowing())
this._model.enable();},targetRemoved:function(target)
{if(!this._model||this._model.target()!==target)
return;this._model.removeEventListener(WebInspector.LayerTreeModel.Events.LayerTreeChanged,this._onLayerTreeUpdated,this);this._model.removeEventListener(WebInspector.LayerTreeModel.Events.LayerPainted,this._onLayerPainted,this);this._model.disable();this._model=null;},_onLayerTreeUpdated:function()
{this._updateThrottler.schedule(this._update.bind(this));},_update:function()
{if(this._model)
this._layerViewHost.setLayerTree(this._model.layerTree());return Promise.resolve();},_onLayerPainted:function(event)
{if(!this._model)
return;if(this._layerViewHost.selection()&&this._layerViewHost.selection().layer()===event.data)
this._layerDetailsView.update();},_onSnapshotRequested:function(event)
{var layer=(event.data);this._tabbedPane.selectTab(WebInspector.LayersPanel.DetailsViewTabs.Profiler);this._paintProfilerView.profileLayer(layer);},_onScaleChanged:function(event)
{this._paintProfilerView.setScale((event.data));},__proto__:WebInspector.PanelWithSidebar.prototype};